/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGDATVModReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGDATVModReport::SWGDATVModReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGDATVModReport::SWGDATVModReport() {
    channel_power_db = 0.0f;
    m_channel_power_db_isSet = false;
    channel_sample_rate = 0;
    m_channel_sample_rate_isSet = false;
    data_rate = 0;
    m_data_rate_isSet = false;
    ts_file_bitrate = 0;
    m_ts_file_bitrate_isSet = false;
    ts_file_length = 0;
    m_ts_file_length_isSet = false;
    udp_byte_count = 0L;
    m_udp_byte_count_isSet = false;
}

SWGDATVModReport::~SWGDATVModReport() {
    this->cleanup();
}

void
SWGDATVModReport::init() {
    channel_power_db = 0.0f;
    m_channel_power_db_isSet = false;
    channel_sample_rate = 0;
    m_channel_sample_rate_isSet = false;
    data_rate = 0;
    m_data_rate_isSet = false;
    ts_file_bitrate = 0;
    m_ts_file_bitrate_isSet = false;
    ts_file_length = 0;
    m_ts_file_length_isSet = false;
    udp_byte_count = 0L;
    m_udp_byte_count_isSet = false;
}

void
SWGDATVModReport::cleanup() {






}

SWGDATVModReport*
SWGDATVModReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGDATVModReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&channel_power_db, pJson["channelPowerDB"], "float", "");
    
    ::SWGSDRangel::setValue(&channel_sample_rate, pJson["channelSampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&data_rate, pJson["dataRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ts_file_bitrate, pJson["tsFileBitrate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ts_file_length, pJson["tsFileLength"], "qint32", "");
    
    ::SWGSDRangel::setValue(&udp_byte_count, pJson["udpByteCount"], "qint64", "");
    
}

QString
SWGDATVModReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGDATVModReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_channel_power_db_isSet){
        obj->insert("channelPowerDB", QJsonValue(channel_power_db));
    }
    if(m_channel_sample_rate_isSet){
        obj->insert("channelSampleRate", QJsonValue(channel_sample_rate));
    }
    if(m_data_rate_isSet){
        obj->insert("dataRate", QJsonValue(data_rate));
    }
    if(m_ts_file_bitrate_isSet){
        obj->insert("tsFileBitrate", QJsonValue(ts_file_bitrate));
    }
    if(m_ts_file_length_isSet){
        obj->insert("tsFileLength", QJsonValue(ts_file_length));
    }
    if(m_udp_byte_count_isSet){
        obj->insert("udpByteCount", QJsonValue(udp_byte_count));
    }

    return obj;
}

float
SWGDATVModReport::getChannelPowerDb() {
    return channel_power_db;
}
void
SWGDATVModReport::setChannelPowerDb(float channel_power_db) {
    this->channel_power_db = channel_power_db;
    this->m_channel_power_db_isSet = true;
}

qint32
SWGDATVModReport::getChannelSampleRate() {
    return channel_sample_rate;
}
void
SWGDATVModReport::setChannelSampleRate(qint32 channel_sample_rate) {
    this->channel_sample_rate = channel_sample_rate;
    this->m_channel_sample_rate_isSet = true;
}

qint32
SWGDATVModReport::getDataRate() {
    return data_rate;
}
void
SWGDATVModReport::setDataRate(qint32 data_rate) {
    this->data_rate = data_rate;
    this->m_data_rate_isSet = true;
}

qint32
SWGDATVModReport::getTsFileBitrate() {
    return ts_file_bitrate;
}
void
SWGDATVModReport::setTsFileBitrate(qint32 ts_file_bitrate) {
    this->ts_file_bitrate = ts_file_bitrate;
    this->m_ts_file_bitrate_isSet = true;
}

qint32
SWGDATVModReport::getTsFileLength() {
    return ts_file_length;
}
void
SWGDATVModReport::setTsFileLength(qint32 ts_file_length) {
    this->ts_file_length = ts_file_length;
    this->m_ts_file_length_isSet = true;
}

qint64
SWGDATVModReport::getUdpByteCount() {
    return udp_byte_count;
}
void
SWGDATVModReport::setUdpByteCount(qint64 udp_byte_count) {
    this->udp_byte_count = udp_byte_count;
    this->m_udp_byte_count_isSet = true;
}


bool
SWGDATVModReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_channel_power_db_isSet){
            isObjectUpdated = true; break;
        }
        if(m_channel_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_data_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ts_file_bitrate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ts_file_length_isSet){
            isObjectUpdated = true; break;
        }
        if(m_udp_byte_count_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

