/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGDenoiserSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGDenoiserSettings::SWGDenoiserSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGDenoiserSettings::SWGDenoiserSettings() {
    denoiser_type = 0;
    m_denoiser_type_isSet = false;
    enable_denoiser = 0;
    m_enable_denoiser_isSet = false;
    volume_tenths = 0;
    m_volume_tenths_isSet = false;
    audio_device_name = nullptr;
    m_audio_device_name_isSet = false;
    audio_mute = 0;
    m_audio_mute_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    file_record_name = nullptr;
    m_file_record_name_isSet = false;
    record_to_file = 0;
    m_record_to_file_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGDenoiserSettings::~SWGDenoiserSettings() {
    this->cleanup();
}

void
SWGDenoiserSettings::init() {
    denoiser_type = 0;
    m_denoiser_type_isSet = false;
    enable_denoiser = 0;
    m_enable_denoiser_isSet = false;
    volume_tenths = 0;
    m_volume_tenths_isSet = false;
    audio_device_name = new QString("");
    m_audio_device_name_isSet = false;
    audio_mute = 0;
    m_audio_mute_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    file_record_name = new QString("");
    m_file_record_name_isSet = false;
    record_to_file = 0;
    m_record_to_file_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGDenoiserSettings::cleanup() {



    if(audio_device_name != nullptr) { 
        delete audio_device_name;
    }

    if(title != nullptr) { 
        delete title;
    }

    if(file_record_name != nullptr) { 
        delete file_record_name;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGDenoiserSettings*
SWGDenoiserSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGDenoiserSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&denoiser_type, pJson["denoiserType"], "qint32", "");
    
    ::SWGSDRangel::setValue(&enable_denoiser, pJson["enableDenoiser"], "qint32", "");
    
    ::SWGSDRangel::setValue(&volume_tenths, pJson["volumeTenths"], "qint32", "");
    
    ::SWGSDRangel::setValue(&audio_device_name, pJson["audioDeviceName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&audio_mute, pJson["audioMute"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&file_record_name, pJson["fileRecordName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&record_to_file, pJson["recordToFile"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_set_index, pJson["reverseAPIFeatureSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_index, pJson["reverseAPIFeatureIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGDenoiserSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGDenoiserSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_denoiser_type_isSet){
        obj->insert("denoiserType", QJsonValue(denoiser_type));
    }
    if(m_enable_denoiser_isSet){
        obj->insert("enableDenoiser", QJsonValue(enable_denoiser));
    }
    if(m_volume_tenths_isSet){
        obj->insert("volumeTenths", QJsonValue(volume_tenths));
    }
    if(audio_device_name != nullptr && *audio_device_name != QString("")){
        toJsonValue(QString("audioDeviceName"), audio_device_name, obj, QString("QString"));
    }
    if(m_audio_mute_isSet){
        obj->insert("audioMute", QJsonValue(audio_mute));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(file_record_name != nullptr && *file_record_name != QString("")){
        toJsonValue(QString("fileRecordName"), file_record_name, obj, QString("QString"));
    }
    if(m_record_to_file_isSet){
        obj->insert("recordToFile", QJsonValue(record_to_file));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_feature_set_index_isSet){
        obj->insert("reverseAPIFeatureSetIndex", QJsonValue(reverse_api_feature_set_index));
    }
    if(m_reverse_api_feature_index_isSet){
        obj->insert("reverseAPIFeatureIndex", QJsonValue(reverse_api_feature_index));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint32
SWGDenoiserSettings::getDenoiserType() {
    return denoiser_type;
}
void
SWGDenoiserSettings::setDenoiserType(qint32 denoiser_type) {
    this->denoiser_type = denoiser_type;
    this->m_denoiser_type_isSet = true;
}

qint32
SWGDenoiserSettings::getEnableDenoiser() {
    return enable_denoiser;
}
void
SWGDenoiserSettings::setEnableDenoiser(qint32 enable_denoiser) {
    this->enable_denoiser = enable_denoiser;
    this->m_enable_denoiser_isSet = true;
}

qint32
SWGDenoiserSettings::getVolumeTenths() {
    return volume_tenths;
}
void
SWGDenoiserSettings::setVolumeTenths(qint32 volume_tenths) {
    this->volume_tenths = volume_tenths;
    this->m_volume_tenths_isSet = true;
}

QString*
SWGDenoiserSettings::getAudioDeviceName() {
    return audio_device_name;
}
void
SWGDenoiserSettings::setAudioDeviceName(QString* audio_device_name) {
    this->audio_device_name = audio_device_name;
    this->m_audio_device_name_isSet = true;
}

qint32
SWGDenoiserSettings::getAudioMute() {
    return audio_mute;
}
void
SWGDenoiserSettings::setAudioMute(qint32 audio_mute) {
    this->audio_mute = audio_mute;
    this->m_audio_mute_isSet = true;
}

QString*
SWGDenoiserSettings::getTitle() {
    return title;
}
void
SWGDenoiserSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGDenoiserSettings::getRgbColor() {
    return rgb_color;
}
void
SWGDenoiserSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

QString*
SWGDenoiserSettings::getFileRecordName() {
    return file_record_name;
}
void
SWGDenoiserSettings::setFileRecordName(QString* file_record_name) {
    this->file_record_name = file_record_name;
    this->m_file_record_name_isSet = true;
}

qint32
SWGDenoiserSettings::getRecordToFile() {
    return record_to_file;
}
void
SWGDenoiserSettings::setRecordToFile(qint32 record_to_file) {
    this->record_to_file = record_to_file;
    this->m_record_to_file_isSet = true;
}

qint32
SWGDenoiserSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGDenoiserSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGDenoiserSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGDenoiserSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGDenoiserSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGDenoiserSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGDenoiserSettings::getReverseApiFeatureSetIndex() {
    return reverse_api_feature_set_index;
}
void
SWGDenoiserSettings::setReverseApiFeatureSetIndex(qint32 reverse_api_feature_set_index) {
    this->reverse_api_feature_set_index = reverse_api_feature_set_index;
    this->m_reverse_api_feature_set_index_isSet = true;
}

qint32
SWGDenoiserSettings::getReverseApiFeatureIndex() {
    return reverse_api_feature_index;
}
void
SWGDenoiserSettings::setReverseApiFeatureIndex(qint32 reverse_api_feature_index) {
    this->reverse_api_feature_index = reverse_api_feature_index;
    this->m_reverse_api_feature_index_isSet = true;
}

SWGRollupState*
SWGDenoiserSettings::getRollupState() {
    return rollup_state;
}
void
SWGDenoiserSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGDenoiserSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_denoiser_type_isSet){
            isObjectUpdated = true; break;
        }
        if(m_enable_denoiser_isSet){
            isObjectUpdated = true; break;
        }
        if(m_volume_tenths_isSet){
            isObjectUpdated = true; break;
        }
        if(audio_device_name && *audio_device_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_audio_mute_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(file_record_name && *file_record_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_record_to_file_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_index_isSet){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

