/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGFT8DemodSettings.h
 *
 * FT8Demod
 */

#ifndef SWGFT8DemodSettings_H_
#define SWGFT8DemodSettings_H_

#include <QJsonObject>


#include "SWGChannelMarker.h"
#include "SWGGLSpectrum.h"
#include "SWGRollupState.h"
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGFT8DemodSettings: public SWGObject {
public:
    SWGFT8DemodSettings();
    SWGFT8DemodSettings(QString* json);
    virtual ~SWGFT8DemodSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGFT8DemodSettings* fromJson(QString &jsonString) override;

    qint64 getInputFrequencyOffset();
    void setInputFrequencyOffset(qint64 input_frequency_offset);

    qint32 getFilterIndex();
    void setFilterIndex(qint32 filter_index);

    qint32 getSpanLog2();
    void setSpanLog2(qint32 span_log2);

    float getRfBandwidth();
    void setRfBandwidth(float rf_bandwidth);

    float getLowCutoff();
    void setLowCutoff(float low_cutoff);

    qint32 getFftWindow();
    void setFftWindow(qint32 fft_window);

    float getVolume();
    void setVolume(float volume);

    qint32 getAgc();
    void setAgc(qint32 agc);

    qint32 getRecordWav();
    void setRecordWav(qint32 record_wav);

    qint32 getLogMessages();
    void setLogMessages(qint32 log_messages);

    qint32 getNbDecoderThreads();
    void setNbDecoderThreads(qint32 nb_decoder_threads);

    float getDecoderTimeBudget();
    void setDecoderTimeBudget(float decoder_time_budget);

    qint32 getUseOsd();
    void setUseOsd(qint32 use_osd);

    qint32 getOsdDepth();
    void setOsdDepth(qint32 osd_depth);

    qint32 getOsdLdpcThreshold();
    void setOsdLdpcThreshold(qint32 osd_ldpc_threshold);

    qint32 getVerifyOsd();
    void setVerifyOsd(qint32 verify_osd);

    qint32 getEnablePskReporter();
    void setEnablePskReporter(qint32 enable_psk_reporter);

    QString* getPskReporterCallsign();
    void setPskReporterCallsign(QString* psk_reporter_callsign);

    QString* getPskReporterLocator();
    void setPskReporterLocator(QString* psk_reporter_locator);

    QString* getPskReporterSoftware();
    void setPskReporterSoftware(QString* psk_reporter_software);

    qint32 getRgbColor();
    void setRgbColor(qint32 rgb_color);

    QString* getTitle();
    void setTitle(QString* title);

    qint32 getStreamIndex();
    void setStreamIndex(qint32 stream_index);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiDeviceIndex();
    void setReverseApiDeviceIndex(qint32 reverse_api_device_index);

    qint32 getReverseApiChannelIndex();
    void setReverseApiChannelIndex(qint32 reverse_api_channel_index);

    SWGGLSpectrum* getSpectrumConfig();
    void setSpectrumConfig(SWGGLSpectrum* spectrum_config);

    SWGChannelMarker* getChannelMarker();
    void setChannelMarker(SWGChannelMarker* channel_marker);

    SWGRollupState* getRollupState();
    void setRollupState(SWGRollupState* rollup_state);


    virtual bool isSet() override;

private:
    qint64 input_frequency_offset;
    bool m_input_frequency_offset_isSet;

    qint32 filter_index;
    bool m_filter_index_isSet;

    qint32 span_log2;
    bool m_span_log2_isSet;

    float rf_bandwidth;
    bool m_rf_bandwidth_isSet;

    float low_cutoff;
    bool m_low_cutoff_isSet;

    qint32 fft_window;
    bool m_fft_window_isSet;

    float volume;
    bool m_volume_isSet;

    qint32 agc;
    bool m_agc_isSet;

    qint32 record_wav;
    bool m_record_wav_isSet;

    qint32 log_messages;
    bool m_log_messages_isSet;

    qint32 nb_decoder_threads;
    bool m_nb_decoder_threads_isSet;

    float decoder_time_budget;
    bool m_decoder_time_budget_isSet;

    qint32 use_osd;
    bool m_use_osd_isSet;

    qint32 osd_depth;
    bool m_osd_depth_isSet;

    qint32 osd_ldpc_threshold;
    bool m_osd_ldpc_threshold_isSet;

    qint32 verify_osd;
    bool m_verify_osd_isSet;

    qint32 enable_psk_reporter;
    bool m_enable_psk_reporter_isSet;

    QString* psk_reporter_callsign;
    bool m_psk_reporter_callsign_isSet;

    QString* psk_reporter_locator;
    bool m_psk_reporter_locator_isSet;

    QString* psk_reporter_software;
    bool m_psk_reporter_software_isSet;

    qint32 rgb_color;
    bool m_rgb_color_isSet;

    QString* title;
    bool m_title_isSet;

    qint32 stream_index;
    bool m_stream_index_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_device_index;
    bool m_reverse_api_device_index_isSet;

    qint32 reverse_api_channel_index;
    bool m_reverse_api_channel_index_isSet;

    SWGGLSpectrum* spectrum_config;
    bool m_spectrum_config_isSet;

    SWGChannelMarker* channel_marker;
    bool m_channel_marker_isSet;

    SWGRollupState* rollup_state;
    bool m_rollup_state_isSet;

};

}

#endif /* SWGFT8DemodSettings_H_ */
