/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGMapAircraftState.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGMapAircraftState::SWGMapAircraftState(QString* json) {
    init();
    this->fromJson(*json);
}

SWGMapAircraftState::SWGMapAircraftState() {
    callsign = nullptr;
    m_callsign_isSet = false;
    aircraft_type = nullptr;
    m_aircraft_type_isSet = false;
    on_surface = 0;
    m_on_surface_isSet = false;
    airspeed = 0.0f;
    m_airspeed_isSet = false;
    airspeed_date_time = nullptr;
    m_airspeed_date_time_isSet = false;
    true_airspeed = 0.0f;
    m_true_airspeed_isSet = false;
    groundspeed = 0.0f;
    m_groundspeed_isSet = false;
    mach = 0.0f;
    m_mach_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
    altitude_date_time = nullptr;
    m_altitude_date_time_isSet = false;
    qnh = 0.0f;
    m_qnh_isSet = false;
    vertical_speed = 0.0f;
    m_vertical_speed_isSet = false;
    vertical_speed_date_time = nullptr;
    m_vertical_speed_date_time_isSet = false;
    heading = 0.0f;
    m_heading_isSet = false;
    track = 0.0f;
    m_track_isSet = false;
    selected_airspeed = 0.0f;
    m_selected_airspeed_isSet = false;
    selected_altitude = 0.0f;
    m_selected_altitude_isSet = false;
    selected_heading = 0.0f;
    m_selected_heading_isSet = false;
    autopilot = 0;
    m_autopilot_isSet = false;
    vertical_mode = 0;
    m_vertical_mode_isSet = false;
    lateral_mode = 0;
    m_lateral_mode_isSet = false;
    tcas_mode = 0;
    m_tcas_mode_isSet = false;
    wind_speed = 0.0f;
    m_wind_speed_isSet = false;
    wind_direction = 0.0f;
    m_wind_direction_isSet = false;
    static_air_temperature = 0.0f;
    m_static_air_temperature_isSet = false;
}

SWGMapAircraftState::~SWGMapAircraftState() {
    this->cleanup();
}

void
SWGMapAircraftState::init() {
    callsign = new QString("");
    m_callsign_isSet = false;
    aircraft_type = new QString("");
    m_aircraft_type_isSet = false;
    on_surface = 0;
    m_on_surface_isSet = false;
    airspeed = 0.0f;
    m_airspeed_isSet = false;
    airspeed_date_time = new QString("");
    m_airspeed_date_time_isSet = false;
    true_airspeed = 0.0f;
    m_true_airspeed_isSet = false;
    groundspeed = 0.0f;
    m_groundspeed_isSet = false;
    mach = 0.0f;
    m_mach_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
    altitude_date_time = new QString("");
    m_altitude_date_time_isSet = false;
    qnh = 0.0f;
    m_qnh_isSet = false;
    vertical_speed = 0.0f;
    m_vertical_speed_isSet = false;
    vertical_speed_date_time = new QString("");
    m_vertical_speed_date_time_isSet = false;
    heading = 0.0f;
    m_heading_isSet = false;
    track = 0.0f;
    m_track_isSet = false;
    selected_airspeed = 0.0f;
    m_selected_airspeed_isSet = false;
    selected_altitude = 0.0f;
    m_selected_altitude_isSet = false;
    selected_heading = 0.0f;
    m_selected_heading_isSet = false;
    autopilot = 0;
    m_autopilot_isSet = false;
    vertical_mode = 0;
    m_vertical_mode_isSet = false;
    lateral_mode = 0;
    m_lateral_mode_isSet = false;
    tcas_mode = 0;
    m_tcas_mode_isSet = false;
    wind_speed = 0.0f;
    m_wind_speed_isSet = false;
    wind_direction = 0.0f;
    m_wind_direction_isSet = false;
    static_air_temperature = 0.0f;
    m_static_air_temperature_isSet = false;
}

void
SWGMapAircraftState::cleanup() {
    if(callsign != nullptr) { 
        delete callsign;
    }
    if(aircraft_type != nullptr) { 
        delete aircraft_type;
    }


    if(airspeed_date_time != nullptr) { 
        delete airspeed_date_time;
    }




    if(altitude_date_time != nullptr) { 
        delete altitude_date_time;
    }


    if(vertical_speed_date_time != nullptr) { 
        delete vertical_speed_date_time;
    }












}

SWGMapAircraftState*
SWGMapAircraftState::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGMapAircraftState::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&callsign, pJson["callsign"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&aircraft_type, pJson["aircraftType"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&on_surface, pJson["onSurface"], "qint32", "");
    
    ::SWGSDRangel::setValue(&airspeed, pJson["airspeed"], "float", "");
    
    ::SWGSDRangel::setValue(&airspeed_date_time, pJson["airspeedDateTime"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&true_airspeed, pJson["trueAirspeed"], "float", "");
    
    ::SWGSDRangel::setValue(&groundspeed, pJson["groundspeed"], "float", "");
    
    ::SWGSDRangel::setValue(&mach, pJson["mach"], "float", "");
    
    ::SWGSDRangel::setValue(&altitude, pJson["altitude"], "float", "");
    
    ::SWGSDRangel::setValue(&altitude_date_time, pJson["altitudeDateTime"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&qnh, pJson["qnh"], "float", "");
    
    ::SWGSDRangel::setValue(&vertical_speed, pJson["verticalSpeed"], "float", "");
    
    ::SWGSDRangel::setValue(&vertical_speed_date_time, pJson["verticalSpeedDateTime"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&heading, pJson["heading"], "float", "");
    
    ::SWGSDRangel::setValue(&track, pJson["track"], "float", "");
    
    ::SWGSDRangel::setValue(&selected_airspeed, pJson["selectedAirspeed"], "float", "");
    
    ::SWGSDRangel::setValue(&selected_altitude, pJson["selectedAltitude"], "float", "");
    
    ::SWGSDRangel::setValue(&selected_heading, pJson["selectedHeading"], "float", "");
    
    ::SWGSDRangel::setValue(&autopilot, pJson["autopilot"], "qint32", "");
    
    ::SWGSDRangel::setValue(&vertical_mode, pJson["verticalMode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&lateral_mode, pJson["lateralMode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tcas_mode, pJson["tcasMode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&wind_speed, pJson["windSpeed"], "float", "");
    
    ::SWGSDRangel::setValue(&wind_direction, pJson["windDirection"], "float", "");
    
    ::SWGSDRangel::setValue(&static_air_temperature, pJson["staticAirTemperature"], "float", "");
    
}

QString
SWGMapAircraftState::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGMapAircraftState::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(callsign != nullptr && *callsign != QString("")){
        toJsonValue(QString("callsign"), callsign, obj, QString("QString"));
    }
    if(aircraft_type != nullptr && *aircraft_type != QString("")){
        toJsonValue(QString("aircraftType"), aircraft_type, obj, QString("QString"));
    }
    if(m_on_surface_isSet){
        obj->insert("onSurface", QJsonValue(on_surface));
    }
    if(m_airspeed_isSet){
        obj->insert("airspeed", QJsonValue(airspeed));
    }
    if(airspeed_date_time != nullptr && *airspeed_date_time != QString("")){
        toJsonValue(QString("airspeedDateTime"), airspeed_date_time, obj, QString("QString"));
    }
    if(m_true_airspeed_isSet){
        obj->insert("trueAirspeed", QJsonValue(true_airspeed));
    }
    if(m_groundspeed_isSet){
        obj->insert("groundspeed", QJsonValue(groundspeed));
    }
    if(m_mach_isSet){
        obj->insert("mach", QJsonValue(mach));
    }
    if(m_altitude_isSet){
        obj->insert("altitude", QJsonValue(altitude));
    }
    if(altitude_date_time != nullptr && *altitude_date_time != QString("")){
        toJsonValue(QString("altitudeDateTime"), altitude_date_time, obj, QString("QString"));
    }
    if(m_qnh_isSet){
        obj->insert("qnh", QJsonValue(qnh));
    }
    if(m_vertical_speed_isSet){
        obj->insert("verticalSpeed", QJsonValue(vertical_speed));
    }
    if(vertical_speed_date_time != nullptr && *vertical_speed_date_time != QString("")){
        toJsonValue(QString("verticalSpeedDateTime"), vertical_speed_date_time, obj, QString("QString"));
    }
    if(m_heading_isSet){
        obj->insert("heading", QJsonValue(heading));
    }
    if(m_track_isSet){
        obj->insert("track", QJsonValue(track));
    }
    if(m_selected_airspeed_isSet){
        obj->insert("selectedAirspeed", QJsonValue(selected_airspeed));
    }
    if(m_selected_altitude_isSet){
        obj->insert("selectedAltitude", QJsonValue(selected_altitude));
    }
    if(m_selected_heading_isSet){
        obj->insert("selectedHeading", QJsonValue(selected_heading));
    }
    if(m_autopilot_isSet){
        obj->insert("autopilot", QJsonValue(autopilot));
    }
    if(m_vertical_mode_isSet){
        obj->insert("verticalMode", QJsonValue(vertical_mode));
    }
    if(m_lateral_mode_isSet){
        obj->insert("lateralMode", QJsonValue(lateral_mode));
    }
    if(m_tcas_mode_isSet){
        obj->insert("tcasMode", QJsonValue(tcas_mode));
    }
    if(m_wind_speed_isSet){
        obj->insert("windSpeed", QJsonValue(wind_speed));
    }
    if(m_wind_direction_isSet){
        obj->insert("windDirection", QJsonValue(wind_direction));
    }
    if(m_static_air_temperature_isSet){
        obj->insert("staticAirTemperature", QJsonValue(static_air_temperature));
    }

    return obj;
}

QString*
SWGMapAircraftState::getCallsign() {
    return callsign;
}
void
SWGMapAircraftState::setCallsign(QString* callsign) {
    this->callsign = callsign;
    this->m_callsign_isSet = true;
}

QString*
SWGMapAircraftState::getAircraftType() {
    return aircraft_type;
}
void
SWGMapAircraftState::setAircraftType(QString* aircraft_type) {
    this->aircraft_type = aircraft_type;
    this->m_aircraft_type_isSet = true;
}

qint32
SWGMapAircraftState::getOnSurface() {
    return on_surface;
}
void
SWGMapAircraftState::setOnSurface(qint32 on_surface) {
    this->on_surface = on_surface;
    this->m_on_surface_isSet = true;
}

float
SWGMapAircraftState::getAirspeed() {
    return airspeed;
}
void
SWGMapAircraftState::setAirspeed(float airspeed) {
    this->airspeed = airspeed;
    this->m_airspeed_isSet = true;
}

QString*
SWGMapAircraftState::getAirspeedDateTime() {
    return airspeed_date_time;
}
void
SWGMapAircraftState::setAirspeedDateTime(QString* airspeed_date_time) {
    this->airspeed_date_time = airspeed_date_time;
    this->m_airspeed_date_time_isSet = true;
}

float
SWGMapAircraftState::getTrueAirspeed() {
    return true_airspeed;
}
void
SWGMapAircraftState::setTrueAirspeed(float true_airspeed) {
    this->true_airspeed = true_airspeed;
    this->m_true_airspeed_isSet = true;
}

float
SWGMapAircraftState::getGroundspeed() {
    return groundspeed;
}
void
SWGMapAircraftState::setGroundspeed(float groundspeed) {
    this->groundspeed = groundspeed;
    this->m_groundspeed_isSet = true;
}

float
SWGMapAircraftState::getMach() {
    return mach;
}
void
SWGMapAircraftState::setMach(float mach) {
    this->mach = mach;
    this->m_mach_isSet = true;
}

float
SWGMapAircraftState::getAltitude() {
    return altitude;
}
void
SWGMapAircraftState::setAltitude(float altitude) {
    this->altitude = altitude;
    this->m_altitude_isSet = true;
}

QString*
SWGMapAircraftState::getAltitudeDateTime() {
    return altitude_date_time;
}
void
SWGMapAircraftState::setAltitudeDateTime(QString* altitude_date_time) {
    this->altitude_date_time = altitude_date_time;
    this->m_altitude_date_time_isSet = true;
}

float
SWGMapAircraftState::getQnh() {
    return qnh;
}
void
SWGMapAircraftState::setQnh(float qnh) {
    this->qnh = qnh;
    this->m_qnh_isSet = true;
}

float
SWGMapAircraftState::getVerticalSpeed() {
    return vertical_speed;
}
void
SWGMapAircraftState::setVerticalSpeed(float vertical_speed) {
    this->vertical_speed = vertical_speed;
    this->m_vertical_speed_isSet = true;
}

QString*
SWGMapAircraftState::getVerticalSpeedDateTime() {
    return vertical_speed_date_time;
}
void
SWGMapAircraftState::setVerticalSpeedDateTime(QString* vertical_speed_date_time) {
    this->vertical_speed_date_time = vertical_speed_date_time;
    this->m_vertical_speed_date_time_isSet = true;
}

float
SWGMapAircraftState::getHeading() {
    return heading;
}
void
SWGMapAircraftState::setHeading(float heading) {
    this->heading = heading;
    this->m_heading_isSet = true;
}

float
SWGMapAircraftState::getTrack() {
    return track;
}
void
SWGMapAircraftState::setTrack(float track) {
    this->track = track;
    this->m_track_isSet = true;
}

float
SWGMapAircraftState::getSelectedAirspeed() {
    return selected_airspeed;
}
void
SWGMapAircraftState::setSelectedAirspeed(float selected_airspeed) {
    this->selected_airspeed = selected_airspeed;
    this->m_selected_airspeed_isSet = true;
}

float
SWGMapAircraftState::getSelectedAltitude() {
    return selected_altitude;
}
void
SWGMapAircraftState::setSelectedAltitude(float selected_altitude) {
    this->selected_altitude = selected_altitude;
    this->m_selected_altitude_isSet = true;
}

float
SWGMapAircraftState::getSelectedHeading() {
    return selected_heading;
}
void
SWGMapAircraftState::setSelectedHeading(float selected_heading) {
    this->selected_heading = selected_heading;
    this->m_selected_heading_isSet = true;
}

qint32
SWGMapAircraftState::getAutopilot() {
    return autopilot;
}
void
SWGMapAircraftState::setAutopilot(qint32 autopilot) {
    this->autopilot = autopilot;
    this->m_autopilot_isSet = true;
}

qint32
SWGMapAircraftState::getVerticalMode() {
    return vertical_mode;
}
void
SWGMapAircraftState::setVerticalMode(qint32 vertical_mode) {
    this->vertical_mode = vertical_mode;
    this->m_vertical_mode_isSet = true;
}

qint32
SWGMapAircraftState::getLateralMode() {
    return lateral_mode;
}
void
SWGMapAircraftState::setLateralMode(qint32 lateral_mode) {
    this->lateral_mode = lateral_mode;
    this->m_lateral_mode_isSet = true;
}

qint32
SWGMapAircraftState::getTcasMode() {
    return tcas_mode;
}
void
SWGMapAircraftState::setTcasMode(qint32 tcas_mode) {
    this->tcas_mode = tcas_mode;
    this->m_tcas_mode_isSet = true;
}

float
SWGMapAircraftState::getWindSpeed() {
    return wind_speed;
}
void
SWGMapAircraftState::setWindSpeed(float wind_speed) {
    this->wind_speed = wind_speed;
    this->m_wind_speed_isSet = true;
}

float
SWGMapAircraftState::getWindDirection() {
    return wind_direction;
}
void
SWGMapAircraftState::setWindDirection(float wind_direction) {
    this->wind_direction = wind_direction;
    this->m_wind_direction_isSet = true;
}

float
SWGMapAircraftState::getStaticAirTemperature() {
    return static_air_temperature;
}
void
SWGMapAircraftState::setStaticAirTemperature(float static_air_temperature) {
    this->static_air_temperature = static_air_temperature;
    this->m_static_air_temperature_isSet = true;
}


bool
SWGMapAircraftState::isSet(){
    bool isObjectUpdated = false;
    do{
        if(callsign && *callsign != QString("")){
            isObjectUpdated = true; break;
        }
        if(aircraft_type && *aircraft_type != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_on_surface_isSet){
            isObjectUpdated = true; break;
        }
        if(m_airspeed_isSet){
            isObjectUpdated = true; break;
        }
        if(airspeed_date_time && *airspeed_date_time != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_true_airspeed_isSet){
            isObjectUpdated = true; break;
        }
        if(m_groundspeed_isSet){
            isObjectUpdated = true; break;
        }
        if(m_mach_isSet){
            isObjectUpdated = true; break;
        }
        if(m_altitude_isSet){
            isObjectUpdated = true; break;
        }
        if(altitude_date_time && *altitude_date_time != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_qnh_isSet){
            isObjectUpdated = true; break;
        }
        if(m_vertical_speed_isSet){
            isObjectUpdated = true; break;
        }
        if(vertical_speed_date_time && *vertical_speed_date_time != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_heading_isSet){
            isObjectUpdated = true; break;
        }
        if(m_track_isSet){
            isObjectUpdated = true; break;
        }
        if(m_selected_airspeed_isSet){
            isObjectUpdated = true; break;
        }
        if(m_selected_altitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_selected_heading_isSet){
            isObjectUpdated = true; break;
        }
        if(m_autopilot_isSet){
            isObjectUpdated = true; break;
        }
        if(m_vertical_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_lateral_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tcas_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_wind_speed_isSet){
            isObjectUpdated = true; break;
        }
        if(m_wind_direction_isSet){
            isObjectUpdated = true; break;
        }
        if(m_static_air_temperature_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

