/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGRollupChildState.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGRollupChildState::SWGRollupChildState(QString* json) {
    init();
    this->fromJson(*json);
}

SWGRollupChildState::SWGRollupChildState() {
    object_name = nullptr;
    m_object_name_isSet = false;
    is_hidden = 0;
    m_is_hidden_isSet = false;
}

SWGRollupChildState::~SWGRollupChildState() {
    this->cleanup();
}

void
SWGRollupChildState::init() {
    object_name = new QString("");
    m_object_name_isSet = false;
    is_hidden = 0;
    m_is_hidden_isSet = false;
}

void
SWGRollupChildState::cleanup() {
    if(object_name != nullptr) { 
        delete object_name;
    }

}

SWGRollupChildState*
SWGRollupChildState::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGRollupChildState::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&object_name, pJson["objectName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&is_hidden, pJson["isHidden"], "qint32", "");
    
}

QString
SWGRollupChildState::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGRollupChildState::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(object_name != nullptr && *object_name != QString("")){
        toJsonValue(QString("objectName"), object_name, obj, QString("QString"));
    }
    if(m_is_hidden_isSet){
        obj->insert("isHidden", QJsonValue(is_hidden));
    }

    return obj;
}

QString*
SWGRollupChildState::getObjectName() {
    return object_name;
}
void
SWGRollupChildState::setObjectName(QString* object_name) {
    this->object_name = object_name;
    this->m_object_name_isSet = true;
}

qint32
SWGRollupChildState::getIsHidden() {
    return is_hidden;
}
void
SWGRollupChildState::setIsHidden(qint32 is_hidden) {
    this->is_hidden = is_hidden;
    this->m_is_hidden_isSet = true;
}


bool
SWGRollupChildState::isSet(){
    bool isObjectUpdated = false;
    do{
        if(object_name && *object_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_is_hidden_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

