/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSkyMapReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSkyMapReport::SWGSkyMapReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSkyMapReport::SWGSkyMapReport() {
    date_time = nullptr;
    m_date_time_isSet = false;
    ra = 0.0f;
    m_ra_isSet = false;
    dec = 0.0f;
    m_dec_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
    azimuth = 0.0f;
    m_azimuth_isSet = false;
    elevation = 0.0f;
    m_elevation_isSet = false;
    fov = 0.0f;
    m_fov_isSet = false;
}

SWGSkyMapReport::~SWGSkyMapReport() {
    this->cleanup();
}

void
SWGSkyMapReport::init() {
    date_time = new QString("");
    m_date_time_isSet = false;
    ra = 0.0f;
    m_ra_isSet = false;
    dec = 0.0f;
    m_dec_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
    azimuth = 0.0f;
    m_azimuth_isSet = false;
    elevation = 0.0f;
    m_elevation_isSet = false;
    fov = 0.0f;
    m_fov_isSet = false;
}

void
SWGSkyMapReport::cleanup() {
    if(date_time != nullptr) { 
        delete date_time;
    }








}

SWGSkyMapReport*
SWGSkyMapReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSkyMapReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&date_time, pJson["dateTime"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&ra, pJson["ra"], "float", "");
    
    ::SWGSDRangel::setValue(&dec, pJson["dec"], "float", "");
    
    ::SWGSDRangel::setValue(&latitude, pJson["latitude"], "float", "");
    
    ::SWGSDRangel::setValue(&longitude, pJson["longitude"], "float", "");
    
    ::SWGSDRangel::setValue(&altitude, pJson["altitude"], "float", "");
    
    ::SWGSDRangel::setValue(&azimuth, pJson["azimuth"], "float", "");
    
    ::SWGSDRangel::setValue(&elevation, pJson["elevation"], "float", "");
    
    ::SWGSDRangel::setValue(&fov, pJson["fov"], "float", "");
    
}

QString
SWGSkyMapReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSkyMapReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(date_time != nullptr && *date_time != QString("")){
        toJsonValue(QString("dateTime"), date_time, obj, QString("QString"));
    }
    if(m_ra_isSet){
        obj->insert("ra", QJsonValue(ra));
    }
    if(m_dec_isSet){
        obj->insert("dec", QJsonValue(dec));
    }
    if(m_latitude_isSet){
        obj->insert("latitude", QJsonValue(latitude));
    }
    if(m_longitude_isSet){
        obj->insert("longitude", QJsonValue(longitude));
    }
    if(m_altitude_isSet){
        obj->insert("altitude", QJsonValue(altitude));
    }
    if(m_azimuth_isSet){
        obj->insert("azimuth", QJsonValue(azimuth));
    }
    if(m_elevation_isSet){
        obj->insert("elevation", QJsonValue(elevation));
    }
    if(m_fov_isSet){
        obj->insert("fov", QJsonValue(fov));
    }

    return obj;
}

QString*
SWGSkyMapReport::getDateTime() {
    return date_time;
}
void
SWGSkyMapReport::setDateTime(QString* date_time) {
    this->date_time = date_time;
    this->m_date_time_isSet = true;
}

float
SWGSkyMapReport::getRa() {
    return ra;
}
void
SWGSkyMapReport::setRa(float ra) {
    this->ra = ra;
    this->m_ra_isSet = true;
}

float
SWGSkyMapReport::getDec() {
    return dec;
}
void
SWGSkyMapReport::setDec(float dec) {
    this->dec = dec;
    this->m_dec_isSet = true;
}

float
SWGSkyMapReport::getLatitude() {
    return latitude;
}
void
SWGSkyMapReport::setLatitude(float latitude) {
    this->latitude = latitude;
    this->m_latitude_isSet = true;
}

float
SWGSkyMapReport::getLongitude() {
    return longitude;
}
void
SWGSkyMapReport::setLongitude(float longitude) {
    this->longitude = longitude;
    this->m_longitude_isSet = true;
}

float
SWGSkyMapReport::getAltitude() {
    return altitude;
}
void
SWGSkyMapReport::setAltitude(float altitude) {
    this->altitude = altitude;
    this->m_altitude_isSet = true;
}

float
SWGSkyMapReport::getAzimuth() {
    return azimuth;
}
void
SWGSkyMapReport::setAzimuth(float azimuth) {
    this->azimuth = azimuth;
    this->m_azimuth_isSet = true;
}

float
SWGSkyMapReport::getElevation() {
    return elevation;
}
void
SWGSkyMapReport::setElevation(float elevation) {
    this->elevation = elevation;
    this->m_elevation_isSet = true;
}

float
SWGSkyMapReport::getFov() {
    return fov;
}
void
SWGSkyMapReport::setFov(float fov) {
    this->fov = fov;
    this->m_fov_isSet = true;
}


bool
SWGSkyMapReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(date_time && *date_time != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_ra_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dec_isSet){
            isObjectUpdated = true; break;
        }
        if(m_latitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_longitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_altitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_azimuth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_elevation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fov_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

