/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSkyMapTarget_2.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSkyMapTarget_2::SWGSkyMapTarget_2(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSkyMapTarget_2::SWGSkyMapTarget_2() {
    ra = 0.0f;
    m_ra_isSet = false;
    dec = 0.0f;
    m_dec_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
    hpbw = 0.0f;
    m_hpbw_isSet = false;
    date_time = nullptr;
    m_date_time_isSet = false;
}

SWGSkyMapTarget_2::~SWGSkyMapTarget_2() {
    this->cleanup();
}

void
SWGSkyMapTarget_2::init() {
    ra = 0.0f;
    m_ra_isSet = false;
    dec = 0.0f;
    m_dec_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
    hpbw = 0.0f;
    m_hpbw_isSet = false;
    date_time = new QString("");
    m_date_time_isSet = false;
}

void
SWGSkyMapTarget_2::cleanup() {






    if(date_time != nullptr) { 
        delete date_time;
    }
}

SWGSkyMapTarget_2*
SWGSkyMapTarget_2::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSkyMapTarget_2::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&ra, pJson["ra"], "float", "");
    
    ::SWGSDRangel::setValue(&dec, pJson["dec"], "float", "");
    
    ::SWGSDRangel::setValue(&latitude, pJson["latitude"], "float", "");
    
    ::SWGSDRangel::setValue(&longitude, pJson["longitude"], "float", "");
    
    ::SWGSDRangel::setValue(&altitude, pJson["altitude"], "float", "");
    
    ::SWGSDRangel::setValue(&hpbw, pJson["hpbw"], "float", "");
    
    ::SWGSDRangel::setValue(&date_time, pJson["dateTime"], "QString", "QString");
    
}

QString
SWGSkyMapTarget_2::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSkyMapTarget_2::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_ra_isSet){
        obj->insert("ra", QJsonValue(ra));
    }
    if(m_dec_isSet){
        obj->insert("dec", QJsonValue(dec));
    }
    if(m_latitude_isSet){
        obj->insert("latitude", QJsonValue(latitude));
    }
    if(m_longitude_isSet){
        obj->insert("longitude", QJsonValue(longitude));
    }
    if(m_altitude_isSet){
        obj->insert("altitude", QJsonValue(altitude));
    }
    if(m_hpbw_isSet){
        obj->insert("hpbw", QJsonValue(hpbw));
    }
    if(date_time != nullptr && *date_time != QString("")){
        toJsonValue(QString("dateTime"), date_time, obj, QString("QString"));
    }

    return obj;
}

float
SWGSkyMapTarget_2::getRa() {
    return ra;
}
void
SWGSkyMapTarget_2::setRa(float ra) {
    this->ra = ra;
    this->m_ra_isSet = true;
}

float
SWGSkyMapTarget_2::getDec() {
    return dec;
}
void
SWGSkyMapTarget_2::setDec(float dec) {
    this->dec = dec;
    this->m_dec_isSet = true;
}

float
SWGSkyMapTarget_2::getLatitude() {
    return latitude;
}
void
SWGSkyMapTarget_2::setLatitude(float latitude) {
    this->latitude = latitude;
    this->m_latitude_isSet = true;
}

float
SWGSkyMapTarget_2::getLongitude() {
    return longitude;
}
void
SWGSkyMapTarget_2::setLongitude(float longitude) {
    this->longitude = longitude;
    this->m_longitude_isSet = true;
}

float
SWGSkyMapTarget_2::getAltitude() {
    return altitude;
}
void
SWGSkyMapTarget_2::setAltitude(float altitude) {
    this->altitude = altitude;
    this->m_altitude_isSet = true;
}

float
SWGSkyMapTarget_2::getHpbw() {
    return hpbw;
}
void
SWGSkyMapTarget_2::setHpbw(float hpbw) {
    this->hpbw = hpbw;
    this->m_hpbw_isSet = true;
}

QString*
SWGSkyMapTarget_2::getDateTime() {
    return date_time;
}
void
SWGSkyMapTarget_2::setDateTime(QString* date_time) {
    this->date_time = date_time;
    this->m_date_time_isSet = true;
}


bool
SWGSkyMapTarget_2::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_ra_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dec_isSet){
            isObjectUpdated = true; break;
        }
        if(m_latitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_longitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_altitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_hpbw_isSet){
            isObjectUpdated = true; break;
        }
        if(date_time && *date_time != QString("")){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

