/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGWDSPRxSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGWDSPRxSettings::SWGWDSPRxSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGWDSPRxSettings::SWGWDSPRxSettings() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    profile_index = 0;
    m_profile_index_isSet = false;
    demod = 0;
    m_demod_isSet = false;
    volume = 0.0f;
    m_volume_isSet = false;
    audio_binaural = 0;
    m_audio_binaural_isSet = false;
    audio_flip_channels = 0;
    m_audio_flip_channels_isSet = false;
    dsb = 0;
    m_dsb_isSet = false;
    audio_mute = 0;
    m_audio_mute_isSet = false;
    agc = 0;
    m_agc_isSet = false;
    agc_mode = 0;
    m_agc_mode_isSet = false;
    agc_gain = 0;
    m_agc_gain_isSet = false;
    agc_slope = 0;
    m_agc_slope_isSet = false;
    agc_hang_threshold = 0;
    m_agc_hang_threshold_isSet = false;
    dnb = 0;
    m_dnb_isSet = false;
    nb_scheme = 0;
    m_nb_scheme_isSet = false;
    nb2_mode = 0;
    m_nb2_mode_isSet = false;
    nb_slew_time = 0.0f;
    m_nb_slew_time_isSet = false;
    nb_lead_time = 0.0f;
    m_nb_lead_time_isSet = false;
    nb_lag_time = 0.0f;
    m_nb_lag_time_isSet = false;
    nb_threshold = 0;
    m_nb_threshold_isSet = false;
    nb_avg_time = 0.0f;
    m_nb_avg_time_isSet = false;
    dnr = 0;
    m_dnr_isSet = false;
    anf = 0;
    m_anf_isSet = false;
    nr_scheme = 0;
    m_nr_scheme_isSet = false;
    nr2_gain = 0;
    m_nr2_gain_isSet = false;
    nr2_npe = 0;
    m_nr2_npe_isSet = false;
    nr_position = 0;
    m_nr_position_isSet = false;
    nr2_artifact_reduction = 0;
    m_nr2_artifact_reduction_isSet = false;
    am_fade_level = 0;
    m_am_fade_level_isSet = false;
    cw_peaking = 0;
    m_cw_peaking_isSet = false;
    cw_peak_frequency = 0.0f;
    m_cw_peak_frequency_isSet = false;
    cw_bandwidth = 0.0f;
    m_cw_bandwidth_isSet = false;
    cw_gain = 0.0f;
    m_cw_gain_isSet = false;
    fm_deviation = 0.0f;
    m_fm_deviation_isSet = false;
    fm_af_low = 0.0f;
    m_fm_af_low_isSet = false;
    fm_af_high = 0.0f;
    m_fm_af_high_isSet = false;
    fm_af_limiter = 0;
    m_fm_af_limiter_isSet = false;
    fm_af_limiter_gain = 0.0f;
    m_fm_af_limiter_gain_isSet = false;
    fm_ctcss_notch = 0;
    m_fm_ctcss_notch_isSet = false;
    fm_ctcss_notch_frequency = 0.0f;
    m_fm_ctcss_notch_frequency_isSet = false;
    squelch = 0;
    m_squelch_isSet = false;
    squelch_threshold = 0;
    m_squelch_threshold_isSet = false;
    squelch_mode = 0;
    m_squelch_mode_isSet = false;
    ssql_tau_mute = 0.0f;
    m_ssql_tau_mute_isSet = false;
    ssql_tau_unmute = 0.0f;
    m_ssql_tau_unmute_isSet = false;
    amsq_max_tail = 0.0f;
    m_amsq_max_tail_isSet = false;
    equalizer = 0;
    m_equalizer_isSet = false;
    eq_f = new QList<float>();
    m_eq_f_isSet = false;
    eq_g = new QList<float>();
    m_eq_g_isSet = false;
    rit = 0;
    m_rit_isSet = false;
    rit_frequency = 0.0f;
    m_rit_frequency_isSet = false;
    span_log2 = 0;
    m_span_log2_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    low_cutoff = 0.0f;
    m_low_cutoff_isSet = false;
    fft_window = 0;
    m_fft_window_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    audio_device_name = nullptr;
    m_audio_device_name_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    spectrum_config = nullptr;
    m_spectrum_config_isSet = false;
    channel_marker = nullptr;
    m_channel_marker_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGWDSPRxSettings::~SWGWDSPRxSettings() {
    this->cleanup();
}

void
SWGWDSPRxSettings::init() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    profile_index = 0;
    m_profile_index_isSet = false;
    demod = 0;
    m_demod_isSet = false;
    volume = 0.0f;
    m_volume_isSet = false;
    audio_binaural = 0;
    m_audio_binaural_isSet = false;
    audio_flip_channels = 0;
    m_audio_flip_channels_isSet = false;
    dsb = 0;
    m_dsb_isSet = false;
    audio_mute = 0;
    m_audio_mute_isSet = false;
    agc = 0;
    m_agc_isSet = false;
    agc_mode = 0;
    m_agc_mode_isSet = false;
    agc_gain = 0;
    m_agc_gain_isSet = false;
    agc_slope = 0;
    m_agc_slope_isSet = false;
    agc_hang_threshold = 0;
    m_agc_hang_threshold_isSet = false;
    dnb = 0;
    m_dnb_isSet = false;
    nb_scheme = 0;
    m_nb_scheme_isSet = false;
    nb2_mode = 0;
    m_nb2_mode_isSet = false;
    nb_slew_time = 0.0f;
    m_nb_slew_time_isSet = false;
    nb_lead_time = 0.0f;
    m_nb_lead_time_isSet = false;
    nb_lag_time = 0.0f;
    m_nb_lag_time_isSet = false;
    nb_threshold = 0;
    m_nb_threshold_isSet = false;
    nb_avg_time = 0.0f;
    m_nb_avg_time_isSet = false;
    dnr = 0;
    m_dnr_isSet = false;
    anf = 0;
    m_anf_isSet = false;
    nr_scheme = 0;
    m_nr_scheme_isSet = false;
    nr2_gain = 0;
    m_nr2_gain_isSet = false;
    nr2_npe = 0;
    m_nr2_npe_isSet = false;
    nr_position = 0;
    m_nr_position_isSet = false;
    nr2_artifact_reduction = 0;
    m_nr2_artifact_reduction_isSet = false;
    am_fade_level = 0;
    m_am_fade_level_isSet = false;
    cw_peaking = 0;
    m_cw_peaking_isSet = false;
    cw_peak_frequency = 0.0f;
    m_cw_peak_frequency_isSet = false;
    cw_bandwidth = 0.0f;
    m_cw_bandwidth_isSet = false;
    cw_gain = 0.0f;
    m_cw_gain_isSet = false;
    fm_deviation = 0.0f;
    m_fm_deviation_isSet = false;
    fm_af_low = 0.0f;
    m_fm_af_low_isSet = false;
    fm_af_high = 0.0f;
    m_fm_af_high_isSet = false;
    fm_af_limiter = 0;
    m_fm_af_limiter_isSet = false;
    fm_af_limiter_gain = 0.0f;
    m_fm_af_limiter_gain_isSet = false;
    fm_ctcss_notch = 0;
    m_fm_ctcss_notch_isSet = false;
    fm_ctcss_notch_frequency = 0.0f;
    m_fm_ctcss_notch_frequency_isSet = false;
    squelch = 0;
    m_squelch_isSet = false;
    squelch_threshold = 0;
    m_squelch_threshold_isSet = false;
    squelch_mode = 0;
    m_squelch_mode_isSet = false;
    ssql_tau_mute = 0.0f;
    m_ssql_tau_mute_isSet = false;
    ssql_tau_unmute = 0.0f;
    m_ssql_tau_unmute_isSet = false;
    amsq_max_tail = 0.0f;
    m_amsq_max_tail_isSet = false;
    equalizer = 0;
    m_equalizer_isSet = false;
    eq_f = new QList<float>();
    m_eq_f_isSet = false;
    eq_g = new QList<float>();
    m_eq_g_isSet = false;
    rit = 0;
    m_rit_isSet = false;
    rit_frequency = 0.0f;
    m_rit_frequency_isSet = false;
    span_log2 = 0;
    m_span_log2_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    low_cutoff = 0.0f;
    m_low_cutoff_isSet = false;
    fft_window = 0;
    m_fft_window_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    audio_device_name = new QString("");
    m_audio_device_name_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    spectrum_config = new SWGGLSpectrum();
    m_spectrum_config_isSet = false;
    channel_marker = new SWGChannelMarker();
    m_channel_marker_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGWDSPRxSettings::cleanup() {
























































    if(title != nullptr) { 
        delete title;
    }
    if(audio_device_name != nullptr) { 
        delete audio_device_name;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(spectrum_config != nullptr) { 
        delete spectrum_config;
    }
    if(channel_marker != nullptr) { 
        delete channel_marker;
    }
    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGWDSPRxSettings*
SWGWDSPRxSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGWDSPRxSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&input_frequency_offset, pJson["inputFrequencyOffset"], "qint64", "");
    
    ::SWGSDRangel::setValue(&profile_index, pJson["profileIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&demod, pJson["demod"], "qint32", "");
    
    ::SWGSDRangel::setValue(&volume, pJson["volume"], "float", "");
    
    ::SWGSDRangel::setValue(&audio_binaural, pJson["audioBinaural"], "qint32", "");
    
    ::SWGSDRangel::setValue(&audio_flip_channels, pJson["audioFlipChannels"], "qint32", "");
    
    ::SWGSDRangel::setValue(&dsb, pJson["dsb"], "qint32", "");
    
    ::SWGSDRangel::setValue(&audio_mute, pJson["audioMute"], "qint32", "");
    
    ::SWGSDRangel::setValue(&agc, pJson["agc"], "qint32", "");
    
    ::SWGSDRangel::setValue(&agc_mode, pJson["agcMode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&agc_gain, pJson["agcGain"], "qint32", "");
    
    ::SWGSDRangel::setValue(&agc_slope, pJson["agcSlope"], "qint32", "");
    
    ::SWGSDRangel::setValue(&agc_hang_threshold, pJson["agcHangThreshold"], "qint32", "");
    
    ::SWGSDRangel::setValue(&dnb, pJson["dnb"], "qint32", "");
    
    ::SWGSDRangel::setValue(&nb_scheme, pJson["nbScheme"], "qint32", "");
    
    ::SWGSDRangel::setValue(&nb2_mode, pJson["nb2Mode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&nb_slew_time, pJson["nbSlewTime"], "float", "");
    
    ::SWGSDRangel::setValue(&nb_lead_time, pJson["nbLeadTime"], "float", "");
    
    ::SWGSDRangel::setValue(&nb_lag_time, pJson["nbLagTime"], "float", "");
    
    ::SWGSDRangel::setValue(&nb_threshold, pJson["nbThreshold"], "qint32", "");
    
    ::SWGSDRangel::setValue(&nb_avg_time, pJson["nbAvgTime"], "float", "");
    
    ::SWGSDRangel::setValue(&dnr, pJson["dnr"], "qint32", "");
    
    ::SWGSDRangel::setValue(&anf, pJson["anf"], "qint32", "");
    
    ::SWGSDRangel::setValue(&nr_scheme, pJson["nrScheme"], "qint32", "");
    
    ::SWGSDRangel::setValue(&nr2_gain, pJson["nr2Gain"], "qint32", "");
    
    ::SWGSDRangel::setValue(&nr2_npe, pJson["nr2NPE"], "qint32", "");
    
    ::SWGSDRangel::setValue(&nr_position, pJson["nrPosition"], "qint32", "");
    
    ::SWGSDRangel::setValue(&nr2_artifact_reduction, pJson["nr2ArtifactReduction"], "qint32", "");
    
    ::SWGSDRangel::setValue(&am_fade_level, pJson["amFadeLevel"], "qint32", "");
    
    ::SWGSDRangel::setValue(&cw_peaking, pJson["cwPeaking"], "qint32", "");
    
    ::SWGSDRangel::setValue(&cw_peak_frequency, pJson["cwPeakFrequency"], "float", "");
    
    ::SWGSDRangel::setValue(&cw_bandwidth, pJson["cwBandwidth"], "float", "");
    
    ::SWGSDRangel::setValue(&cw_gain, pJson["cwGain"], "float", "");
    
    ::SWGSDRangel::setValue(&fm_deviation, pJson["fmDeviation"], "float", "");
    
    ::SWGSDRangel::setValue(&fm_af_low, pJson["fmAFLow"], "float", "");
    
    ::SWGSDRangel::setValue(&fm_af_high, pJson["fmAFHigh"], "float", "");
    
    ::SWGSDRangel::setValue(&fm_af_limiter, pJson["fmAFLimiter"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fm_af_limiter_gain, pJson["fmAFLimiterGain"], "float", "");
    
    ::SWGSDRangel::setValue(&fm_ctcss_notch, pJson["fmCTCSSNotch"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fm_ctcss_notch_frequency, pJson["fmCTCSSNotchFrequency"], "float", "");
    
    ::SWGSDRangel::setValue(&squelch, pJson["squelch"], "qint32", "");
    
    ::SWGSDRangel::setValue(&squelch_threshold, pJson["squelchThreshold"], "qint32", "");
    
    ::SWGSDRangel::setValue(&squelch_mode, pJson["squelchMode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ssql_tau_mute, pJson["ssqlTauMute"], "float", "");
    
    ::SWGSDRangel::setValue(&ssql_tau_unmute, pJson["ssqlTauUnmute"], "float", "");
    
    ::SWGSDRangel::setValue(&amsq_max_tail, pJson["amsqMaxTail"], "float", "");
    
    ::SWGSDRangel::setValue(&equalizer, pJson["equalizer"], "qint32", "");
    
    
    ::SWGSDRangel::setValue(&eq_f, pJson["eqF"], "QList", "float");
    
    ::SWGSDRangel::setValue(&eq_g, pJson["eqG"], "QList", "float");
    ::SWGSDRangel::setValue(&rit, pJson["rit"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rit_frequency, pJson["ritFrequency"], "float", "");
    
    ::SWGSDRangel::setValue(&span_log2, pJson["spanLog2"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rf_bandwidth, pJson["rfBandwidth"], "float", "");
    
    ::SWGSDRangel::setValue(&low_cutoff, pJson["lowCutoff"], "float", "");
    
    ::SWGSDRangel::setValue(&fft_window, pJson["fftWindow"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&audio_device_name, pJson["audioDeviceName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&stream_index, pJson["streamIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_channel_index, pJson["reverseAPIChannelIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&spectrum_config, pJson["spectrumConfig"], "SWGGLSpectrum", "SWGGLSpectrum");
    
    ::SWGSDRangel::setValue(&channel_marker, pJson["channelMarker"], "SWGChannelMarker", "SWGChannelMarker");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGWDSPRxSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGWDSPRxSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_input_frequency_offset_isSet){
        obj->insert("inputFrequencyOffset", QJsonValue(input_frequency_offset));
    }
    if(m_profile_index_isSet){
        obj->insert("profileIndex", QJsonValue(profile_index));
    }
    if(m_demod_isSet){
        obj->insert("demod", QJsonValue(demod));
    }
    if(m_volume_isSet){
        obj->insert("volume", QJsonValue(volume));
    }
    if(m_audio_binaural_isSet){
        obj->insert("audioBinaural", QJsonValue(audio_binaural));
    }
    if(m_audio_flip_channels_isSet){
        obj->insert("audioFlipChannels", QJsonValue(audio_flip_channels));
    }
    if(m_dsb_isSet){
        obj->insert("dsb", QJsonValue(dsb));
    }
    if(m_audio_mute_isSet){
        obj->insert("audioMute", QJsonValue(audio_mute));
    }
    if(m_agc_isSet){
        obj->insert("agc", QJsonValue(agc));
    }
    if(m_agc_mode_isSet){
        obj->insert("agcMode", QJsonValue(agc_mode));
    }
    if(m_agc_gain_isSet){
        obj->insert("agcGain", QJsonValue(agc_gain));
    }
    if(m_agc_slope_isSet){
        obj->insert("agcSlope", QJsonValue(agc_slope));
    }
    if(m_agc_hang_threshold_isSet){
        obj->insert("agcHangThreshold", QJsonValue(agc_hang_threshold));
    }
    if(m_dnb_isSet){
        obj->insert("dnb", QJsonValue(dnb));
    }
    if(m_nb_scheme_isSet){
        obj->insert("nbScheme", QJsonValue(nb_scheme));
    }
    if(m_nb2_mode_isSet){
        obj->insert("nb2Mode", QJsonValue(nb2_mode));
    }
    if(m_nb_slew_time_isSet){
        obj->insert("nbSlewTime", QJsonValue(nb_slew_time));
    }
    if(m_nb_lead_time_isSet){
        obj->insert("nbLeadTime", QJsonValue(nb_lead_time));
    }
    if(m_nb_lag_time_isSet){
        obj->insert("nbLagTime", QJsonValue(nb_lag_time));
    }
    if(m_nb_threshold_isSet){
        obj->insert("nbThreshold", QJsonValue(nb_threshold));
    }
    if(m_nb_avg_time_isSet){
        obj->insert("nbAvgTime", QJsonValue(nb_avg_time));
    }
    if(m_dnr_isSet){
        obj->insert("dnr", QJsonValue(dnr));
    }
    if(m_anf_isSet){
        obj->insert("anf", QJsonValue(anf));
    }
    if(m_nr_scheme_isSet){
        obj->insert("nrScheme", QJsonValue(nr_scheme));
    }
    if(m_nr2_gain_isSet){
        obj->insert("nr2Gain", QJsonValue(nr2_gain));
    }
    if(m_nr2_npe_isSet){
        obj->insert("nr2NPE", QJsonValue(nr2_npe));
    }
    if(m_nr_position_isSet){
        obj->insert("nrPosition", QJsonValue(nr_position));
    }
    if(m_nr2_artifact_reduction_isSet){
        obj->insert("nr2ArtifactReduction", QJsonValue(nr2_artifact_reduction));
    }
    if(m_am_fade_level_isSet){
        obj->insert("amFadeLevel", QJsonValue(am_fade_level));
    }
    if(m_cw_peaking_isSet){
        obj->insert("cwPeaking", QJsonValue(cw_peaking));
    }
    if(m_cw_peak_frequency_isSet){
        obj->insert("cwPeakFrequency", QJsonValue(cw_peak_frequency));
    }
    if(m_cw_bandwidth_isSet){
        obj->insert("cwBandwidth", QJsonValue(cw_bandwidth));
    }
    if(m_cw_gain_isSet){
        obj->insert("cwGain", QJsonValue(cw_gain));
    }
    if(m_fm_deviation_isSet){
        obj->insert("fmDeviation", QJsonValue(fm_deviation));
    }
    if(m_fm_af_low_isSet){
        obj->insert("fmAFLow", QJsonValue(fm_af_low));
    }
    if(m_fm_af_high_isSet){
        obj->insert("fmAFHigh", QJsonValue(fm_af_high));
    }
    if(m_fm_af_limiter_isSet){
        obj->insert("fmAFLimiter", QJsonValue(fm_af_limiter));
    }
    if(m_fm_af_limiter_gain_isSet){
        obj->insert("fmAFLimiterGain", QJsonValue(fm_af_limiter_gain));
    }
    if(m_fm_ctcss_notch_isSet){
        obj->insert("fmCTCSSNotch", QJsonValue(fm_ctcss_notch));
    }
    if(m_fm_ctcss_notch_frequency_isSet){
        obj->insert("fmCTCSSNotchFrequency", QJsonValue(fm_ctcss_notch_frequency));
    }
    if(m_squelch_isSet){
        obj->insert("squelch", QJsonValue(squelch));
    }
    if(m_squelch_threshold_isSet){
        obj->insert("squelchThreshold", QJsonValue(squelch_threshold));
    }
    if(m_squelch_mode_isSet){
        obj->insert("squelchMode", QJsonValue(squelch_mode));
    }
    if(m_ssql_tau_mute_isSet){
        obj->insert("ssqlTauMute", QJsonValue(ssql_tau_mute));
    }
    if(m_ssql_tau_unmute_isSet){
        obj->insert("ssqlTauUnmute", QJsonValue(ssql_tau_unmute));
    }
    if(m_amsq_max_tail_isSet){
        obj->insert("amsqMaxTail", QJsonValue(amsq_max_tail));
    }
    if(m_equalizer_isSet){
        obj->insert("equalizer", QJsonValue(equalizer));
    }
    if(eq_f && eq_f->size() > 0){
        toJsonArray((QList<void*>*)eq_f, obj, "eqF", "float");
    }
    if(eq_g && eq_g->size() > 0){
        toJsonArray((QList<void*>*)eq_g, obj, "eqG", "float");
    }
    if(m_rit_isSet){
        obj->insert("rit", QJsonValue(rit));
    }
    if(m_rit_frequency_isSet){
        obj->insert("ritFrequency", QJsonValue(rit_frequency));
    }
    if(m_span_log2_isSet){
        obj->insert("spanLog2", QJsonValue(span_log2));
    }
    if(m_rf_bandwidth_isSet){
        obj->insert("rfBandwidth", QJsonValue(rf_bandwidth));
    }
    if(m_low_cutoff_isSet){
        obj->insert("lowCutoff", QJsonValue(low_cutoff));
    }
    if(m_fft_window_isSet){
        obj->insert("fftWindow", QJsonValue(fft_window));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(audio_device_name != nullptr && *audio_device_name != QString("")){
        toJsonValue(QString("audioDeviceName"), audio_device_name, obj, QString("QString"));
    }
    if(m_stream_index_isSet){
        obj->insert("streamIndex", QJsonValue(stream_index));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }
    if(m_reverse_api_channel_index_isSet){
        obj->insert("reverseAPIChannelIndex", QJsonValue(reverse_api_channel_index));
    }
    if((spectrum_config != nullptr) && (spectrum_config->isSet())){
        toJsonValue(QString("spectrumConfig"), spectrum_config, obj, QString("SWGGLSpectrum"));
    }
    if((channel_marker != nullptr) && (channel_marker->isSet())){
        toJsonValue(QString("channelMarker"), channel_marker, obj, QString("SWGChannelMarker"));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint64
SWGWDSPRxSettings::getInputFrequencyOffset() {
    return input_frequency_offset;
}
void
SWGWDSPRxSettings::setInputFrequencyOffset(qint64 input_frequency_offset) {
    this->input_frequency_offset = input_frequency_offset;
    this->m_input_frequency_offset_isSet = true;
}

qint32
SWGWDSPRxSettings::getProfileIndex() {
    return profile_index;
}
void
SWGWDSPRxSettings::setProfileIndex(qint32 profile_index) {
    this->profile_index = profile_index;
    this->m_profile_index_isSet = true;
}

qint32
SWGWDSPRxSettings::getDemod() {
    return demod;
}
void
SWGWDSPRxSettings::setDemod(qint32 demod) {
    this->demod = demod;
    this->m_demod_isSet = true;
}

float
SWGWDSPRxSettings::getVolume() {
    return volume;
}
void
SWGWDSPRxSettings::setVolume(float volume) {
    this->volume = volume;
    this->m_volume_isSet = true;
}

qint32
SWGWDSPRxSettings::getAudioBinaural() {
    return audio_binaural;
}
void
SWGWDSPRxSettings::setAudioBinaural(qint32 audio_binaural) {
    this->audio_binaural = audio_binaural;
    this->m_audio_binaural_isSet = true;
}

qint32
SWGWDSPRxSettings::getAudioFlipChannels() {
    return audio_flip_channels;
}
void
SWGWDSPRxSettings::setAudioFlipChannels(qint32 audio_flip_channels) {
    this->audio_flip_channels = audio_flip_channels;
    this->m_audio_flip_channels_isSet = true;
}

qint32
SWGWDSPRxSettings::getDsb() {
    return dsb;
}
void
SWGWDSPRxSettings::setDsb(qint32 dsb) {
    this->dsb = dsb;
    this->m_dsb_isSet = true;
}

qint32
SWGWDSPRxSettings::getAudioMute() {
    return audio_mute;
}
void
SWGWDSPRxSettings::setAudioMute(qint32 audio_mute) {
    this->audio_mute = audio_mute;
    this->m_audio_mute_isSet = true;
}

qint32
SWGWDSPRxSettings::getAgc() {
    return agc;
}
void
SWGWDSPRxSettings::setAgc(qint32 agc) {
    this->agc = agc;
    this->m_agc_isSet = true;
}

qint32
SWGWDSPRxSettings::getAgcMode() {
    return agc_mode;
}
void
SWGWDSPRxSettings::setAgcMode(qint32 agc_mode) {
    this->agc_mode = agc_mode;
    this->m_agc_mode_isSet = true;
}

qint32
SWGWDSPRxSettings::getAgcGain() {
    return agc_gain;
}
void
SWGWDSPRxSettings::setAgcGain(qint32 agc_gain) {
    this->agc_gain = agc_gain;
    this->m_agc_gain_isSet = true;
}

qint32
SWGWDSPRxSettings::getAgcSlope() {
    return agc_slope;
}
void
SWGWDSPRxSettings::setAgcSlope(qint32 agc_slope) {
    this->agc_slope = agc_slope;
    this->m_agc_slope_isSet = true;
}

qint32
SWGWDSPRxSettings::getAgcHangThreshold() {
    return agc_hang_threshold;
}
void
SWGWDSPRxSettings::setAgcHangThreshold(qint32 agc_hang_threshold) {
    this->agc_hang_threshold = agc_hang_threshold;
    this->m_agc_hang_threshold_isSet = true;
}

qint32
SWGWDSPRxSettings::getDnb() {
    return dnb;
}
void
SWGWDSPRxSettings::setDnb(qint32 dnb) {
    this->dnb = dnb;
    this->m_dnb_isSet = true;
}

qint32
SWGWDSPRxSettings::getNbScheme() {
    return nb_scheme;
}
void
SWGWDSPRxSettings::setNbScheme(qint32 nb_scheme) {
    this->nb_scheme = nb_scheme;
    this->m_nb_scheme_isSet = true;
}

qint32
SWGWDSPRxSettings::getNb2Mode() {
    return nb2_mode;
}
void
SWGWDSPRxSettings::setNb2Mode(qint32 nb2_mode) {
    this->nb2_mode = nb2_mode;
    this->m_nb2_mode_isSet = true;
}

float
SWGWDSPRxSettings::getNbSlewTime() {
    return nb_slew_time;
}
void
SWGWDSPRxSettings::setNbSlewTime(float nb_slew_time) {
    this->nb_slew_time = nb_slew_time;
    this->m_nb_slew_time_isSet = true;
}

float
SWGWDSPRxSettings::getNbLeadTime() {
    return nb_lead_time;
}
void
SWGWDSPRxSettings::setNbLeadTime(float nb_lead_time) {
    this->nb_lead_time = nb_lead_time;
    this->m_nb_lead_time_isSet = true;
}

float
SWGWDSPRxSettings::getNbLagTime() {
    return nb_lag_time;
}
void
SWGWDSPRxSettings::setNbLagTime(float nb_lag_time) {
    this->nb_lag_time = nb_lag_time;
    this->m_nb_lag_time_isSet = true;
}

qint32
SWGWDSPRxSettings::getNbThreshold() {
    return nb_threshold;
}
void
SWGWDSPRxSettings::setNbThreshold(qint32 nb_threshold) {
    this->nb_threshold = nb_threshold;
    this->m_nb_threshold_isSet = true;
}

float
SWGWDSPRxSettings::getNbAvgTime() {
    return nb_avg_time;
}
void
SWGWDSPRxSettings::setNbAvgTime(float nb_avg_time) {
    this->nb_avg_time = nb_avg_time;
    this->m_nb_avg_time_isSet = true;
}

qint32
SWGWDSPRxSettings::getDnr() {
    return dnr;
}
void
SWGWDSPRxSettings::setDnr(qint32 dnr) {
    this->dnr = dnr;
    this->m_dnr_isSet = true;
}

qint32
SWGWDSPRxSettings::getAnf() {
    return anf;
}
void
SWGWDSPRxSettings::setAnf(qint32 anf) {
    this->anf = anf;
    this->m_anf_isSet = true;
}

qint32
SWGWDSPRxSettings::getNrScheme() {
    return nr_scheme;
}
void
SWGWDSPRxSettings::setNrScheme(qint32 nr_scheme) {
    this->nr_scheme = nr_scheme;
    this->m_nr_scheme_isSet = true;
}

qint32
SWGWDSPRxSettings::getNr2Gain() {
    return nr2_gain;
}
void
SWGWDSPRxSettings::setNr2Gain(qint32 nr2_gain) {
    this->nr2_gain = nr2_gain;
    this->m_nr2_gain_isSet = true;
}

qint32
SWGWDSPRxSettings::getNr2Npe() {
    return nr2_npe;
}
void
SWGWDSPRxSettings::setNr2Npe(qint32 nr2_npe) {
    this->nr2_npe = nr2_npe;
    this->m_nr2_npe_isSet = true;
}

qint32
SWGWDSPRxSettings::getNrPosition() {
    return nr_position;
}
void
SWGWDSPRxSettings::setNrPosition(qint32 nr_position) {
    this->nr_position = nr_position;
    this->m_nr_position_isSet = true;
}

qint32
SWGWDSPRxSettings::getNr2ArtifactReduction() {
    return nr2_artifact_reduction;
}
void
SWGWDSPRxSettings::setNr2ArtifactReduction(qint32 nr2_artifact_reduction) {
    this->nr2_artifact_reduction = nr2_artifact_reduction;
    this->m_nr2_artifact_reduction_isSet = true;
}

qint32
SWGWDSPRxSettings::getAmFadeLevel() {
    return am_fade_level;
}
void
SWGWDSPRxSettings::setAmFadeLevel(qint32 am_fade_level) {
    this->am_fade_level = am_fade_level;
    this->m_am_fade_level_isSet = true;
}

qint32
SWGWDSPRxSettings::getCwPeaking() {
    return cw_peaking;
}
void
SWGWDSPRxSettings::setCwPeaking(qint32 cw_peaking) {
    this->cw_peaking = cw_peaking;
    this->m_cw_peaking_isSet = true;
}

float
SWGWDSPRxSettings::getCwPeakFrequency() {
    return cw_peak_frequency;
}
void
SWGWDSPRxSettings::setCwPeakFrequency(float cw_peak_frequency) {
    this->cw_peak_frequency = cw_peak_frequency;
    this->m_cw_peak_frequency_isSet = true;
}

float
SWGWDSPRxSettings::getCwBandwidth() {
    return cw_bandwidth;
}
void
SWGWDSPRxSettings::setCwBandwidth(float cw_bandwidth) {
    this->cw_bandwidth = cw_bandwidth;
    this->m_cw_bandwidth_isSet = true;
}

float
SWGWDSPRxSettings::getCwGain() {
    return cw_gain;
}
void
SWGWDSPRxSettings::setCwGain(float cw_gain) {
    this->cw_gain = cw_gain;
    this->m_cw_gain_isSet = true;
}

float
SWGWDSPRxSettings::getFmDeviation() {
    return fm_deviation;
}
void
SWGWDSPRxSettings::setFmDeviation(float fm_deviation) {
    this->fm_deviation = fm_deviation;
    this->m_fm_deviation_isSet = true;
}

float
SWGWDSPRxSettings::getFmAfLow() {
    return fm_af_low;
}
void
SWGWDSPRxSettings::setFmAfLow(float fm_af_low) {
    this->fm_af_low = fm_af_low;
    this->m_fm_af_low_isSet = true;
}

float
SWGWDSPRxSettings::getFmAfHigh() {
    return fm_af_high;
}
void
SWGWDSPRxSettings::setFmAfHigh(float fm_af_high) {
    this->fm_af_high = fm_af_high;
    this->m_fm_af_high_isSet = true;
}

qint32
SWGWDSPRxSettings::getFmAfLimiter() {
    return fm_af_limiter;
}
void
SWGWDSPRxSettings::setFmAfLimiter(qint32 fm_af_limiter) {
    this->fm_af_limiter = fm_af_limiter;
    this->m_fm_af_limiter_isSet = true;
}

float
SWGWDSPRxSettings::getFmAfLimiterGain() {
    return fm_af_limiter_gain;
}
void
SWGWDSPRxSettings::setFmAfLimiterGain(float fm_af_limiter_gain) {
    this->fm_af_limiter_gain = fm_af_limiter_gain;
    this->m_fm_af_limiter_gain_isSet = true;
}

qint32
SWGWDSPRxSettings::getFmCtcssNotch() {
    return fm_ctcss_notch;
}
void
SWGWDSPRxSettings::setFmCtcssNotch(qint32 fm_ctcss_notch) {
    this->fm_ctcss_notch = fm_ctcss_notch;
    this->m_fm_ctcss_notch_isSet = true;
}

float
SWGWDSPRxSettings::getFmCtcssNotchFrequency() {
    return fm_ctcss_notch_frequency;
}
void
SWGWDSPRxSettings::setFmCtcssNotchFrequency(float fm_ctcss_notch_frequency) {
    this->fm_ctcss_notch_frequency = fm_ctcss_notch_frequency;
    this->m_fm_ctcss_notch_frequency_isSet = true;
}

qint32
SWGWDSPRxSettings::getSquelch() {
    return squelch;
}
void
SWGWDSPRxSettings::setSquelch(qint32 squelch) {
    this->squelch = squelch;
    this->m_squelch_isSet = true;
}

qint32
SWGWDSPRxSettings::getSquelchThreshold() {
    return squelch_threshold;
}
void
SWGWDSPRxSettings::setSquelchThreshold(qint32 squelch_threshold) {
    this->squelch_threshold = squelch_threshold;
    this->m_squelch_threshold_isSet = true;
}

qint32
SWGWDSPRxSettings::getSquelchMode() {
    return squelch_mode;
}
void
SWGWDSPRxSettings::setSquelchMode(qint32 squelch_mode) {
    this->squelch_mode = squelch_mode;
    this->m_squelch_mode_isSet = true;
}

float
SWGWDSPRxSettings::getSsqlTauMute() {
    return ssql_tau_mute;
}
void
SWGWDSPRxSettings::setSsqlTauMute(float ssql_tau_mute) {
    this->ssql_tau_mute = ssql_tau_mute;
    this->m_ssql_tau_mute_isSet = true;
}

float
SWGWDSPRxSettings::getSsqlTauUnmute() {
    return ssql_tau_unmute;
}
void
SWGWDSPRxSettings::setSsqlTauUnmute(float ssql_tau_unmute) {
    this->ssql_tau_unmute = ssql_tau_unmute;
    this->m_ssql_tau_unmute_isSet = true;
}

float
SWGWDSPRxSettings::getAmsqMaxTail() {
    return amsq_max_tail;
}
void
SWGWDSPRxSettings::setAmsqMaxTail(float amsq_max_tail) {
    this->amsq_max_tail = amsq_max_tail;
    this->m_amsq_max_tail_isSet = true;
}

qint32
SWGWDSPRxSettings::getEqualizer() {
    return equalizer;
}
void
SWGWDSPRxSettings::setEqualizer(qint32 equalizer) {
    this->equalizer = equalizer;
    this->m_equalizer_isSet = true;
}

QList<float>*
SWGWDSPRxSettings::getEqF() {
    return eq_f;
}
void
SWGWDSPRxSettings::setEqF(QList<float>* eq_f) {
    this->eq_f = eq_f;
    this->m_eq_f_isSet = true;
}

QList<float>*
SWGWDSPRxSettings::getEqG() {
    return eq_g;
}
void
SWGWDSPRxSettings::setEqG(QList<float>* eq_g) {
    this->eq_g = eq_g;
    this->m_eq_g_isSet = true;
}

qint32
SWGWDSPRxSettings::getRit() {
    return rit;
}
void
SWGWDSPRxSettings::setRit(qint32 rit) {
    this->rit = rit;
    this->m_rit_isSet = true;
}

float
SWGWDSPRxSettings::getRitFrequency() {
    return rit_frequency;
}
void
SWGWDSPRxSettings::setRitFrequency(float rit_frequency) {
    this->rit_frequency = rit_frequency;
    this->m_rit_frequency_isSet = true;
}

qint32
SWGWDSPRxSettings::getSpanLog2() {
    return span_log2;
}
void
SWGWDSPRxSettings::setSpanLog2(qint32 span_log2) {
    this->span_log2 = span_log2;
    this->m_span_log2_isSet = true;
}

float
SWGWDSPRxSettings::getRfBandwidth() {
    return rf_bandwidth;
}
void
SWGWDSPRxSettings::setRfBandwidth(float rf_bandwidth) {
    this->rf_bandwidth = rf_bandwidth;
    this->m_rf_bandwidth_isSet = true;
}

float
SWGWDSPRxSettings::getLowCutoff() {
    return low_cutoff;
}
void
SWGWDSPRxSettings::setLowCutoff(float low_cutoff) {
    this->low_cutoff = low_cutoff;
    this->m_low_cutoff_isSet = true;
}

qint32
SWGWDSPRxSettings::getFftWindow() {
    return fft_window;
}
void
SWGWDSPRxSettings::setFftWindow(qint32 fft_window) {
    this->fft_window = fft_window;
    this->m_fft_window_isSet = true;
}

qint32
SWGWDSPRxSettings::getRgbColor() {
    return rgb_color;
}
void
SWGWDSPRxSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

QString*
SWGWDSPRxSettings::getTitle() {
    return title;
}
void
SWGWDSPRxSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

QString*
SWGWDSPRxSettings::getAudioDeviceName() {
    return audio_device_name;
}
void
SWGWDSPRxSettings::setAudioDeviceName(QString* audio_device_name) {
    this->audio_device_name = audio_device_name;
    this->m_audio_device_name_isSet = true;
}

qint32
SWGWDSPRxSettings::getStreamIndex() {
    return stream_index;
}
void
SWGWDSPRxSettings::setStreamIndex(qint32 stream_index) {
    this->stream_index = stream_index;
    this->m_stream_index_isSet = true;
}

qint32
SWGWDSPRxSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGWDSPRxSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGWDSPRxSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGWDSPRxSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGWDSPRxSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGWDSPRxSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGWDSPRxSettings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGWDSPRxSettings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}

qint32
SWGWDSPRxSettings::getReverseApiChannelIndex() {
    return reverse_api_channel_index;
}
void
SWGWDSPRxSettings::setReverseApiChannelIndex(qint32 reverse_api_channel_index) {
    this->reverse_api_channel_index = reverse_api_channel_index;
    this->m_reverse_api_channel_index_isSet = true;
}

SWGGLSpectrum*
SWGWDSPRxSettings::getSpectrumConfig() {
    return spectrum_config;
}
void
SWGWDSPRxSettings::setSpectrumConfig(SWGGLSpectrum* spectrum_config) {
    this->spectrum_config = spectrum_config;
    this->m_spectrum_config_isSet = true;
}

SWGChannelMarker*
SWGWDSPRxSettings::getChannelMarker() {
    return channel_marker;
}
void
SWGWDSPRxSettings::setChannelMarker(SWGChannelMarker* channel_marker) {
    this->channel_marker = channel_marker;
    this->m_channel_marker_isSet = true;
}

SWGRollupState*
SWGWDSPRxSettings::getRollupState() {
    return rollup_state;
}
void
SWGWDSPRxSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGWDSPRxSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_input_frequency_offset_isSet){
            isObjectUpdated = true; break;
        }
        if(m_profile_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_demod_isSet){
            isObjectUpdated = true; break;
        }
        if(m_volume_isSet){
            isObjectUpdated = true; break;
        }
        if(m_audio_binaural_isSet){
            isObjectUpdated = true; break;
        }
        if(m_audio_flip_channels_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dsb_isSet){
            isObjectUpdated = true; break;
        }
        if(m_audio_mute_isSet){
            isObjectUpdated = true; break;
        }
        if(m_agc_isSet){
            isObjectUpdated = true; break;
        }
        if(m_agc_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_agc_gain_isSet){
            isObjectUpdated = true; break;
        }
        if(m_agc_slope_isSet){
            isObjectUpdated = true; break;
        }
        if(m_agc_hang_threshold_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dnb_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nb_scheme_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nb2_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nb_slew_time_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nb_lead_time_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nb_lag_time_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nb_threshold_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nb_avg_time_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dnr_isSet){
            isObjectUpdated = true; break;
        }
        if(m_anf_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nr_scheme_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nr2_gain_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nr2_npe_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nr_position_isSet){
            isObjectUpdated = true; break;
        }
        if(m_nr2_artifact_reduction_isSet){
            isObjectUpdated = true; break;
        }
        if(m_am_fade_level_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cw_peaking_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cw_peak_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cw_bandwidth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cw_gain_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fm_deviation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fm_af_low_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fm_af_high_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fm_af_limiter_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fm_af_limiter_gain_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fm_ctcss_notch_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fm_ctcss_notch_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_squelch_isSet){
            isObjectUpdated = true; break;
        }
        if(m_squelch_threshold_isSet){
            isObjectUpdated = true; break;
        }
        if(m_squelch_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ssql_tau_mute_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ssql_tau_unmute_isSet){
            isObjectUpdated = true; break;
        }
        if(m_amsq_max_tail_isSet){
            isObjectUpdated = true; break;
        }
        if(m_equalizer_isSet){
            isObjectUpdated = true; break;
        }
        if(m_eq_f_isSet){
            isObjectUpdated = true; break;
        }
        if(eq_f && (eq_f->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_eq_g_isSet){
            isObjectUpdated = true; break;
        }
        if(eq_g && (eq_g->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(m_rit_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rit_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_span_log2_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rf_bandwidth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_low_cutoff_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fft_window_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(audio_device_name && *audio_device_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_stream_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_channel_index_isSet){
            isObjectUpdated = true; break;
        }
        if(spectrum_config && spectrum_config->isSet()){
            isObjectUpdated = true; break;
        }
        if(channel_marker && channel_marker->isSet()){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

