from typing import Any, Callable, List, Optional, Tuple, Union

from OCC.Core.AIS import AIS_Shape
from OCC.Core.Graphic3d import Graphic3d_Structure
from OCC.Core.gp import gp_Pnt, gp_Pnt2d, gp_Vec
from OCC.Core.Quantity import Quantity_Color
from OCC.Core.Visualization import Display3d

def rgb_color(r: float, g: float, b: float) -> Quantity_Color: ...
def get_color_from_name(color_name: str) -> Quantity_Color: ...

class Viewer3d(Display3d):
    def __init__(self) -> None: ...
    def get_parent(self) -> Any: ...
    def register_overlay_item(self, overlay_item: Any) -> None: ...
    def register_select_callback(self, callback: Callable) -> None: ...
    def unregister_callback(self, callback: Callable) -> None: ...
    def MoveTo(self, X: int, Y: int) -> None: ...
    def FitAll(self) -> None: ...
    def Create(
        self,
        window_handle: Optional[Any] = None,
        parent: Optional[Any] = None,
        create_default_lights: bool = True,
        draw_face_boundaries: bool = True,
        phong_shading: bool = True,
        display_glinfo: bool = True,
    ) -> None: ...
    def OnResize(self) -> None: ...
    def ResetView(self) -> None: ...
    def Repaint(self) -> None: ...
    def SetModeWireFrame(self) -> None: ...
    def SetModeShaded(self) -> None: ...
    def SetModeHLR(self) -> None: ...
    def SetOrthographicProjection(self) -> None: ...
    def SetPerspectiveProjection(self) -> None: ...
    def View_Top(self) -> None: ...
    def View_Bottom(self) -> None: ...
    def View_Left(self) -> None: ...
    def View_Right(self) -> None: ...
    def View_Front(self) -> None: ...
    def View_Rear(self) -> None: ...
    def View_Iso(self) -> None: ...
    def EnableTextureEnv(self, name_of_texture: int = ...) -> None: ...
    def DisableTextureEnv(self) -> None: ...
    def SetRenderingParams(
        self,
        Method: int = ...,
        RaytracingDepth: int = 3,
        IsShadowEnabled: bool = True,
        IsReflectionEnabled: bool = False,
        IsAntialiasingEnabled: bool = False,
        IsTransparentShadowEnabled: bool = False,
        StereoMode: int = ...,
        AnaglyphFilter: int = ...,
        ToReverseStereo: bool = False,
    ) -> None: ...
    def SetRasterizationMode(self) -> None: ...
    def SetRaytracingMode(self, depth: int = 3) -> None: ...
    def ExportToImage(self, image_filename: str) -> None: ...
    def display_graduated_trihedron(self) -> None: ...
    def display_triedron(self) -> None: ...
    def hide_triedron(self) -> None: ...
    def set_bg_gradient_color(
        self,
        color1: Union[List[float], Quantity_Color],
        color2: Union[List[float], Quantity_Color],
        fill_method: int = ...,
    ) -> None: ...
    def SetBackgroundImage(self, image_filename: str, stretch: bool = True) -> None: ...
    def DisplayVector(
        self, vec: gp_Vec, pnt: gp_Pnt, update: bool = False
    ) -> Optional[Graphic3d_Structure]: ...
    def DisplayMessage(
        self,
        point: Union[gp_Pnt, gp_Pnt2d],
        text_to_write: str,
        height: float = 14.0,
        message_color: Tuple[float, float, float] = ...,
        update: bool = False,
    ) -> Graphic3d_Structure: ...
    def DisplayShape(
        self,
        shapes: Any,
        material: Optional[Any] = None,
        texture: Optional[Any] = None,
        color: Optional[Union[str, int, Quantity_Color]] = None,
        transparency: Optional[float] = None,
        update: bool = False,
    ) -> List[AIS_Shape]: ...
    def DisplayColoredShape(
        self,
        shapes: Any,
        color: Union[str, Quantity_Color] = "YELLOW",
        update: bool = False,
    ) -> List[AIS_Shape]: ...
    def EnableAntiAliasing(self) -> None: ...
    def DisableAntiAliasing(self) -> None: ...
    def EraseAll(self) -> None: ...
    def Tumble(self, num_images: int, animation: bool = True) -> None: ...
    def Pan(self, dx: int, dy: int) -> None: ...
    def SetSelectionMode(self, mode: Optional[int] = None) -> None: ...
    def SetSelectionModeVertex(self) -> None: ...
    def SetSelectionModeEdge(self) -> None: ...
    def SetSelectionModeWire(self) -> None: ...
    def SetSelectionModeFace(self) -> None: ...
    def SetSelectionModeShell(self) -> None: ...
    def SetSelectionModeSolid(self) -> None: ...
    def SetSelectionModeShape(self) -> None: ...
    def SetSelectionModeNeutral(self) -> None: ...
    def GetSelectedShapes(self) -> List[AIS_Shape]: ...
    def GetSelectedShape(self) -> AIS_Shape: ...
    def SelectArea(self, Xmin: int, Ymin: int, Xmax: int, Ymax: int) -> None: ...
    def Select(self, X: int, Y: int) -> None: ...
    def ShiftSelect(self, X: int, Y: int) -> None: ...
    def Rotation(self, X: int, Y: int) -> None: ...
    def DynamicZoom(self, X1: int, Y1: int, X2: int, Y2: int) -> None: ...
    def ZoomFactor(self, zoom_factor: float) -> None: ...
    def ZoomArea(self, X1: int, Y1: int, X2: int, Y2: int) -> None: ...
    def Zoom(self, X: int, Y: int) -> None: ...
    def StartRotation(self, X: int, Y: int) -> None: ...

class OffscreenRenderer(Viewer3d):
    def __init__(self, screen_size: Tuple[int, int] = ...) -> None: ...
    def DisplayShape(
        self,
        shapes: Any,
        material: Optional[Any] = None,
        texture: Optional[Any] = None,
        color: Optional[Union[str, int, Quantity_Color]] = None,
        transparency: Optional[float] = None,
        update: bool = True,
        dump_image: bool = True,
        dump_image_path: Optional[str] = None,
        dump_image_filename: Optional[str] = None,
    ) -> List[AIS_Shape]: ...
