from typing import Any, Optional

from OCC.Core.AIS import AIS_Manipulator
from OCC.Core.gp import gp_Trsf
from OCC.Display.backend import get_qt_modules

QtCore, QtGui, QtWidgets, QtOpenGL = get_qt_modules()

class qtBaseViewer(QtWidgets.QWidget):
    def __init__(self, parent: Optional[Any] = None) -> None: ...
    def resizeEvent(self, event: Any) -> None: ...
    def paintEngine(self) -> None: ...

class qtViewer3d(qtBaseViewer):
    sig_topods_selected: Any

    def __init__(self, *kargs: Any) -> None: ...
    @property
    def qApp(self) -> Any: ...
    @qApp.setter
    def qApp(self, value: Any) -> None: ...
    def InitDriver(self) -> None: ...
    def createCursors(self) -> None: ...
    def keyPressEvent(self, event: Any) -> None: ...
    def focusInEvent(self, event: Any) -> None: ...
    def focusOutEvent(self, event: Any) -> None: ...
    def paintEvent(self, event: Any) -> None: ...
    def wheelEvent(self, event: Any) -> None: ...
    @property
    def cursor(self) -> str: ...
    @cursor.setter
    def cursor(self, value: str) -> None: ...
    def mousePressEvent(self, event: Any) -> None: ...
    def mouseReleaseEvent(self, event: Any) -> None: ...
    def DrawBox(self, event: Any) -> None: ...
    def mouseMoveEvent(self, evt: Any) -> None: ...

class qtViewer3dWithManipulator(qtViewer3d):
    sig_topods_selected: Any

    def __init__(self, *kargs: Any) -> None: ...
    def set_manipulator(self, manipulator: AIS_Manipulator) -> None: ...
    def mousePressEvent(self, event: Any) -> None: ...
    def mouseMoveEvent(self, evt: Any) -> None: ...
    def get_trsf_from_manip(self) -> gp_Trsf: ...
    def mouseReleaseEvent(self, event: Any) -> None: ...
