from typing import Any, List, Tuple, Union

from OCC.Core.Geom import Geom_BSplineCurve, Geom_BezierCurve, Geom_Surface
from OCC.Core.GeomAbs import GeomAbs_Shape
from OCC.Core.gp import gp_Ax1, gp_Dir, gp_Pnt, gp_Vec
from OCC.Core.TColgp import TColgp_Array1OfPnt
from OCC.Core.TopoDS import (
    TopoDS_Edge,
    TopoDS_Face,
    TopoDS_Shape,
    TopoDS_Vertex,
    TopoDS_Wire,
)

def assert_shape_not_null(shp: TopoDS_Shape) -> None: ...
def assert_isdone(inst: Any, message: str) -> None: ...
def point_list_to_TColgp_Array1OfPnt(li: List[gp_Pnt]) -> TColgp_Array1OfPnt: ...
def make_vertex(*args: Union[gp_Pnt, float]) -> TopoDS_Vertex: ...
def make_edge(*args: Any) -> TopoDS_Edge: ...
def make_edge2d(*args: Any) -> TopoDS_Edge: ...
def make_wire(*args: Union[List[TopoDS_Edge], TopoDS_Edge]) -> TopoDS_Wire: ...
def points_to_bspline(pnts: List[gp_Pnt]) -> Geom_BSplineCurve: ...
def edge_to_bezier(
    topods_edge: TopoDS_Edge,
) -> Tuple[bool, Geom_BezierCurve, int]: ...
def make_n_sided(
    edges: List[TopoDS_Edge], continuity: GeomAbs_Shape = ...
) -> TopoDS_Face: ...
def make_face(*args: Union[TopoDS_Wire, Geom_Surface]) -> TopoDS_Face: ...
def get_aligned_boundingbox(
    shape: TopoDS_Shape, tol: float = 1e-06, optimal_BB: bool = True
) -> Tuple[gp_Pnt, List[float], TopoDS_Shape]: ...
def get_oriented_boundingbox(
    shape: TopoDS_Shape, optimal_OBB: bool = True
) -> Tuple[gp_Pnt, List[float], TopoDS_Shape]: ...
def midpoint(point_A: gp_Pnt, point_B: gp_Pnt) -> gp_Pnt: ...
def center_boundingbox(shape: TopoDS_Shape) -> gp_Pnt: ...
def get_boundingbox(
    shape: TopoDS_Shape, tol: float = 1e-06, use_mesh: bool = True
) -> Tuple[float, float, float, float, float, float]: ...
def translate_shp(
    shp: TopoDS_Shape, vec: gp_Vec, copy: bool = False
) -> TopoDS_Shape: ...
def rotate_shape(
    shape: TopoDS_Shape, axis: gp_Ax1, angle: float, unite: str = "deg"
) -> TopoDS_Shape: ...
def rotate_shp_3_axis(
    shape: TopoDS_Shape, rx: float, ry: float, rz: float, unity: str = "deg"
) -> TopoDS_Shape: ...
def scale_shape(
    shape: TopoDS_Shape, fx: float, fy: float, fz: float
) -> TopoDS_Shape: ...
def make_extrusion(
    face: TopoDS_Face, length: float, vector: gp_Vec = None
) -> TopoDS_Shape: ...
def recognize_face(topods_face: TopoDS_Face) -> Tuple[str, gp_Pnt, gp_Dir]: ...
def measure_shape_volume(shape: TopoDS_Shape) -> float: ...
def measure_shape_mass_center_of_gravity(
    shape: TopoDS_Shape,
) -> Tuple[gp_Pnt, float, str]: ...
