from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.gp import *
from OCC.Core.Geom import *
from OCC.Core.gce import *

class GC_MakeMirror:
    @overload
    def __init__(self, Point: gp_Pnt) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax1) -> None: ...
    @overload
    def __init__(self, Line: gp_Lin) -> None: ...
    @overload
    def __init__(self, Point: gp_Pnt, Direc: gp_Dir) -> None: ...
    @overload
    def __init__(self, Plane: gp_Pln) -> None: ...
    @overload
    def __init__(self, Plane: gp_Ax2) -> None: ...
    def Value(self) -> Geom_Transformation: ...

class GC_MakeRotation:
    @overload
    def __init__(self, Line: gp_Lin, Angle: float) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax1, Angle: float) -> None: ...
    @overload
    def __init__(self, Point: gp_Pnt, Direc: gp_Dir, Angle: float) -> None: ...
    def Value(self) -> Geom_Transformation: ...

class GC_MakeScale:
    def __init__(self, Point: gp_Pnt, Scale: float) -> None: ...
    def Value(self) -> Geom_Transformation: ...

class GC_MakeTranslation:
    @overload
    def __init__(self, Vect: gp_Vec) -> None: ...
    @overload
    def __init__(self, Point1: gp_Pnt, Point2: gp_Pnt) -> None: ...
    def Value(self) -> Geom_Transformation: ...

class GC_Root:
    def IsDone(self) -> bool: ...
    def Status(self) -> gce_ErrorType: ...

class GC_MakeArcOfCircle(GC_Root):
    @overload
    def __init__(
        self, Circ: gp_Circ, Alpha1: float, Alpha2: float, Sense: bool
    ) -> None: ...
    @overload
    def __init__(self, Circ: gp_Circ, P: gp_Pnt, Alpha: float, Sense: bool) -> None: ...
    @overload
    def __init__(self, Circ: gp_Circ, P1: gp_Pnt, P2: gp_Pnt, Sense: bool) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt, P3: gp_Pnt) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt, V: gp_Vec, P2: gp_Pnt) -> None: ...
    def Value(self) -> Geom_TrimmedCurve: ...

class GC_MakeArcOfEllipse(GC_Root):
    @overload
    def __init__(
        self, Elips: gp_Elips, Alpha1: float, Alpha2: float, Sense: bool
    ) -> None: ...
    @overload
    def __init__(
        self, Elips: gp_Elips, P: gp_Pnt, Alpha: float, Sense: bool
    ) -> None: ...
    @overload
    def __init__(
        self, Elips: gp_Elips, P1: gp_Pnt, P2: gp_Pnt, Sense: bool
    ) -> None: ...
    def Value(self) -> Geom_TrimmedCurve: ...

class GC_MakeArcOfHyperbola(GC_Root):
    @overload
    def __init__(
        self, Hypr: gp_Hypr, Alpha1: float, Alpha2: float, Sense: bool
    ) -> None: ...
    @overload
    def __init__(self, Hypr: gp_Hypr, P: gp_Pnt, Alpha: float, Sense: bool) -> None: ...
    @overload
    def __init__(self, Hypr: gp_Hypr, P1: gp_Pnt, P2: gp_Pnt, Sense: bool) -> None: ...
    def Value(self) -> Geom_TrimmedCurve: ...

class GC_MakeArcOfParabola(GC_Root):
    @overload
    def __init__(
        self, Parab: gp_Parab, Alpha1: float, Alpha2: float, Sense: bool
    ) -> None: ...
    @overload
    def __init__(
        self, Parab: gp_Parab, P: gp_Pnt, Alpha: float, Sense: bool
    ) -> None: ...
    @overload
    def __init__(
        self, Parab: gp_Parab, P1: gp_Pnt, P2: gp_Pnt, Sense: bool
    ) -> None: ...
    def Value(self) -> Geom_TrimmedCurve: ...

class GC_MakeCircle(GC_Root):
    @overload
    def __init__(self, C: gp_Circ) -> None: ...
    @overload
    def __init__(self, A2: gp_Ax2, Radius: float) -> None: ...
    @overload
    def __init__(self, Circ: gp_Circ, Dist: float) -> None: ...
    @overload
    def __init__(self, Circ: gp_Circ, Point: gp_Pnt) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt, P3: gp_Pnt) -> None: ...
    @overload
    def __init__(self, Center: gp_Pnt, Norm: gp_Dir, Radius: float) -> None: ...
    @overload
    def __init__(self, Center: gp_Pnt, PtAxis: gp_Pnt, Radius: float) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax1, Radius: float) -> None: ...
    def Value(self) -> Geom_Circle: ...

class GC_MakeConicalSurface(GC_Root):
    @overload
    def __init__(self, A2: gp_Ax2, Ang: float, Radius: float) -> None: ...
    @overload
    def __init__(self, C: gp_Cone) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt, P3: gp_Pnt, P4: gp_Pnt) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt, R1: float, R2: float) -> None: ...
    def Value(self) -> Geom_ConicalSurface: ...

class GC_MakeCylindricalSurface(GC_Root):
    @overload
    def __init__(self, A2: gp_Ax2, Radius: float) -> None: ...
    @overload
    def __init__(self, C: gp_Cylinder) -> None: ...
    @overload
    def __init__(self, Cyl: gp_Cylinder, Point: gp_Pnt) -> None: ...
    @overload
    def __init__(self, Cyl: gp_Cylinder, Dist: float) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt, P3: gp_Pnt) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax1, Radius: float) -> None: ...
    @overload
    def __init__(self, Circ: gp_Circ) -> None: ...
    def Value(self) -> Geom_CylindricalSurface: ...

class GC_MakeEllipse(GC_Root):
    @overload
    def __init__(self, E: gp_Elips) -> None: ...
    @overload
    def __init__(self, A2: gp_Ax2, MajorRadius: float, MinorRadius: float) -> None: ...
    @overload
    def __init__(self, S1: gp_Pnt, S2: gp_Pnt, Center: gp_Pnt) -> None: ...
    def Value(self) -> Geom_Ellipse: ...

class GC_MakeHyperbola(GC_Root):
    @overload
    def __init__(self, H: gp_Hypr) -> None: ...
    @overload
    def __init__(self, A2: gp_Ax2, MajorRadius: float, MinorRadius: float) -> None: ...
    @overload
    def __init__(self, S1: gp_Pnt, S2: gp_Pnt, Center: gp_Pnt) -> None: ...
    def Value(self) -> Geom_Hyperbola: ...

class GC_MakeLine(GC_Root):
    @overload
    def __init__(self, A1: gp_Ax1) -> None: ...
    @overload
    def __init__(self, L: gp_Lin) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, V: gp_Dir) -> None: ...
    @overload
    def __init__(self, Lin: gp_Lin, Point: gp_Pnt) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt) -> None: ...
    def Value(self) -> Geom_Line: ...

class GC_MakePlane(GC_Root):
    @overload
    def __init__(self, Pl: gp_Pln) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, V: gp_Dir) -> None: ...
    @overload
    def __init__(self, A: float, B: float, C: float, D: float) -> None: ...
    @overload
    def __init__(self, Pln: gp_Pln, Point: gp_Pnt) -> None: ...
    @overload
    def __init__(self, Pln: gp_Pln, Dist: float) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt, P3: gp_Pnt) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax1) -> None: ...
    def Value(self) -> Geom_Plane: ...

class GC_MakeSegment(GC_Root):
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt) -> None: ...
    @overload
    def __init__(self, Line: gp_Lin, U1: float, U2: float) -> None: ...
    @overload
    def __init__(self, Line: gp_Lin, Point: gp_Pnt, Ulast: float) -> None: ...
    @overload
    def __init__(self, Line: gp_Lin, P1: gp_Pnt, P2: gp_Pnt) -> None: ...
    def Value(self) -> Geom_TrimmedCurve: ...

class GC_MakeTrimmedCone(GC_Root):
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt, P3: gp_Pnt, P4: gp_Pnt) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt, R1: float, R2: float) -> None: ...
    def Value(self) -> Geom_RectangularTrimmedSurface: ...

class GC_MakeTrimmedCylinder(GC_Root):
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt, P3: gp_Pnt) -> None: ...
    @overload
    def __init__(self, Circ: gp_Circ, Height: float) -> None: ...
    @overload
    def __init__(self, A1: gp_Ax1, Radius: float, Height: float) -> None: ...
    def Value(self) -> Geom_RectangularTrimmedSurface: ...

# harray1 classes
# harray2 classes
# hsequence classes
