from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.gp import *

class GccEnt_Position(IntEnum):
    GccEnt_unqualified: int = ...
    GccEnt_enclosing: int = ...
    GccEnt_enclosed: int = ...
    GccEnt_outside: int = ...
    GccEnt_noqualifier: int = ...

GccEnt_unqualified = GccEnt_Position.GccEnt_unqualified
GccEnt_enclosing = GccEnt_Position.GccEnt_enclosing
GccEnt_enclosed = GccEnt_Position.GccEnt_enclosed
GccEnt_outside = GccEnt_Position.GccEnt_outside
GccEnt_noqualifier = GccEnt_Position.GccEnt_noqualifier

class gccent:
    @overload
    @staticmethod
    def Enclosed(Obj: gp_Lin2d) -> GccEnt_QualifiedLin: ...
    @overload
    @staticmethod
    def Enclosed(Obj: gp_Circ2d) -> GccEnt_QualifiedCirc: ...
    @staticmethod
    def Enclosing(Obj: gp_Circ2d) -> GccEnt_QualifiedCirc: ...
    @overload
    @staticmethod
    def Outside(Obj: gp_Lin2d) -> GccEnt_QualifiedLin: ...
    @overload
    @staticmethod
    def Outside(Obj: gp_Circ2d) -> GccEnt_QualifiedCirc: ...
    @overload
    @staticmethod
    def PositionFromString(thePositionString: str) -> GccEnt_Position: ...
    @overload
    @staticmethod
    def PositionFromString(thePositionString: str) -> Tuple[bool, GccEnt_Position]: ...
    @staticmethod
    def PositionToString(thePosition: GccEnt_Position) -> str: ...
    @staticmethod
    def Print(thePosition: GccEnt_Position) -> Tuple[Standard_OStream, str]: ...
    @overload
    @staticmethod
    def Unqualified(Obj: gp_Lin2d) -> GccEnt_QualifiedLin: ...
    @overload
    @staticmethod
    def Unqualified(Obj: gp_Circ2d) -> GccEnt_QualifiedCirc: ...

class GccEnt_QualifiedCirc:
    def __init__(self, Qualified: gp_Circ2d, Qualifier: GccEnt_Position) -> None: ...
    def IsEnclosed(self) -> bool: ...
    def IsEnclosing(self) -> bool: ...
    def IsOutside(self) -> bool: ...
    def IsUnqualified(self) -> bool: ...
    def Qualified(self) -> gp_Circ2d: ...
    def Qualifier(self) -> GccEnt_Position: ...

class GccEnt_QualifiedLin:
    def __init__(self, Qualified: gp_Lin2d, Qualifier: GccEnt_Position) -> None: ...
    def IsEnclosed(self) -> bool: ...
    def IsOutside(self) -> bool: ...
    def IsUnqualified(self) -> bool: ...
    def Qualified(self) -> gp_Lin2d: ...
    def Qualifier(self) -> GccEnt_Position: ...

# harray1 classes
# harray2 classes
# hsequence classes
