from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *

class GeomAbs_BSplKnotDistribution(IntEnum):
    GeomAbs_NonUniform: int = ...
    GeomAbs_Uniform: int = ...
    GeomAbs_QuasiUniform: int = ...
    GeomAbs_PiecewiseBezier: int = ...

GeomAbs_NonUniform = GeomAbs_BSplKnotDistribution.GeomAbs_NonUniform
GeomAbs_Uniform = GeomAbs_BSplKnotDistribution.GeomAbs_Uniform
GeomAbs_QuasiUniform = GeomAbs_BSplKnotDistribution.GeomAbs_QuasiUniform
GeomAbs_PiecewiseBezier = GeomAbs_BSplKnotDistribution.GeomAbs_PiecewiseBezier

class GeomAbs_CurveType(IntEnum):
    GeomAbs_Line: int = ...
    GeomAbs_Circle: int = ...
    GeomAbs_Ellipse: int = ...
    GeomAbs_Hyperbola: int = ...
    GeomAbs_Parabola: int = ...
    GeomAbs_BezierCurve: int = ...
    GeomAbs_BSplineCurve: int = ...
    GeomAbs_OffsetCurve: int = ...
    GeomAbs_OtherCurve: int = ...

GeomAbs_Line = GeomAbs_CurveType.GeomAbs_Line
GeomAbs_Circle = GeomAbs_CurveType.GeomAbs_Circle
GeomAbs_Ellipse = GeomAbs_CurveType.GeomAbs_Ellipse
GeomAbs_Hyperbola = GeomAbs_CurveType.GeomAbs_Hyperbola
GeomAbs_Parabola = GeomAbs_CurveType.GeomAbs_Parabola
GeomAbs_BezierCurve = GeomAbs_CurveType.GeomAbs_BezierCurve
GeomAbs_BSplineCurve = GeomAbs_CurveType.GeomAbs_BSplineCurve
GeomAbs_OffsetCurve = GeomAbs_CurveType.GeomAbs_OffsetCurve
GeomAbs_OtherCurve = GeomAbs_CurveType.GeomAbs_OtherCurve

class GeomAbs_IsoType(IntEnum):
    GeomAbs_IsoU: int = ...
    GeomAbs_IsoV: int = ...
    GeomAbs_NoneIso: int = ...

GeomAbs_IsoU = GeomAbs_IsoType.GeomAbs_IsoU
GeomAbs_IsoV = GeomAbs_IsoType.GeomAbs_IsoV
GeomAbs_NoneIso = GeomAbs_IsoType.GeomAbs_NoneIso

class GeomAbs_JoinType(IntEnum):
    GeomAbs_Arc: int = ...
    GeomAbs_Tangent: int = ...
    GeomAbs_Intersection: int = ...

GeomAbs_Arc = GeomAbs_JoinType.GeomAbs_Arc
GeomAbs_Tangent = GeomAbs_JoinType.GeomAbs_Tangent
GeomAbs_Intersection = GeomAbs_JoinType.GeomAbs_Intersection

class GeomAbs_Shape(IntEnum):
    GeomAbs_C0: int = ...
    GeomAbs_G1: int = ...
    GeomAbs_C1: int = ...
    GeomAbs_G2: int = ...
    GeomAbs_C2: int = ...
    GeomAbs_C3: int = ...
    GeomAbs_CN: int = ...

GeomAbs_C0 = GeomAbs_Shape.GeomAbs_C0
GeomAbs_G1 = GeomAbs_Shape.GeomAbs_G1
GeomAbs_C1 = GeomAbs_Shape.GeomAbs_C1
GeomAbs_G2 = GeomAbs_Shape.GeomAbs_G2
GeomAbs_C2 = GeomAbs_Shape.GeomAbs_C2
GeomAbs_C3 = GeomAbs_Shape.GeomAbs_C3
GeomAbs_CN = GeomAbs_Shape.GeomAbs_CN

class GeomAbs_SurfaceType(IntEnum):
    GeomAbs_Plane: int = ...
    GeomAbs_Cylinder: int = ...
    GeomAbs_Cone: int = ...
    GeomAbs_Sphere: int = ...
    GeomAbs_Torus: int = ...
    GeomAbs_BezierSurface: int = ...
    GeomAbs_BSplineSurface: int = ...
    GeomAbs_SurfaceOfRevolution: int = ...
    GeomAbs_SurfaceOfExtrusion: int = ...
    GeomAbs_OffsetSurface: int = ...
    GeomAbs_OtherSurface: int = ...

GeomAbs_Plane = GeomAbs_SurfaceType.GeomAbs_Plane
GeomAbs_Cylinder = GeomAbs_SurfaceType.GeomAbs_Cylinder
GeomAbs_Cone = GeomAbs_SurfaceType.GeomAbs_Cone
GeomAbs_Sphere = GeomAbs_SurfaceType.GeomAbs_Sphere
GeomAbs_Torus = GeomAbs_SurfaceType.GeomAbs_Torus
GeomAbs_BezierSurface = GeomAbs_SurfaceType.GeomAbs_BezierSurface
GeomAbs_BSplineSurface = GeomAbs_SurfaceType.GeomAbs_BSplineSurface
GeomAbs_SurfaceOfRevolution = GeomAbs_SurfaceType.GeomAbs_SurfaceOfRevolution
GeomAbs_SurfaceOfExtrusion = GeomAbs_SurfaceType.GeomAbs_SurfaceOfExtrusion
GeomAbs_OffsetSurface = GeomAbs_SurfaceType.GeomAbs_OffsetSurface
GeomAbs_OtherSurface = GeomAbs_SurfaceType.GeomAbs_OtherSurface

# harray1 classes
# harray2 classes
# hsequence classes
