from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.StepShape import *
from OCC.Core.StepRepr import *
from OCC.Core.TCollection import *
from OCC.Core.StepGeom import *
from OCC.Core.StepData import *
from OCC.Core.TColStd import *

class StepKinematics_ActuatedDirection(IntEnum):
    StepKinematics_adBidirectional: int = ...
    StepKinematics_adPositiveOnly: int = ...
    StepKinematics_adNegativeOnly: int = ...
    StepKinematics_adNotActuated: int = ...

StepKinematics_adBidirectional = (
    StepKinematics_ActuatedDirection.StepKinematics_adBidirectional
)
StepKinematics_adPositiveOnly = (
    StepKinematics_ActuatedDirection.StepKinematics_adPositiveOnly
)
StepKinematics_adNegativeOnly = (
    StepKinematics_ActuatedDirection.StepKinematics_adNegativeOnly
)
StepKinematics_adNotActuated = (
    StepKinematics_ActuatedDirection.StepKinematics_adNotActuated
)

class StepKinematics_ContextDependentKinematicLinkRepresentation(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationRelation: StepKinematics_KinematicLinkRepresentationAssociation,
        theRepresentedProductRelation: StepKinematics_ProductDefinitionRelationshipKinematics,
    ) -> None: ...
    def RepresentationRelation(
        self,
    ) -> StepKinematics_KinematicLinkRepresentationAssociation: ...
    def RepresentedProductRelation(
        self,
    ) -> StepKinematics_ProductDefinitionRelationshipKinematics: ...
    def SetRepresentationRelation(
        self,
        theRepresentationRelation: StepKinematics_KinematicLinkRepresentationAssociation,
    ) -> None: ...
    def SetRepresentedProductRelation(
        self,
        theRepresentedProductRelation: StepKinematics_ProductDefinitionRelationshipKinematics,
    ) -> None: ...

class StepKinematics_KinematicJoint(StepShape_Edge):
    def __init__(self) -> None: ...

class StepKinematics_KinematicLink(StepShape_Vertex):
    def __init__(self) -> None: ...

class StepKinematics_KinematicLinkRepresentation(StepRepr_Representation):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentation_Name: TCollection_HAsciiString,
        theRepresentation_Items: StepRepr_HArray1OfRepresentationItem,
        theRepresentation_ContextOfItems: StepRepr_RepresentationContext,
        theRepresentedLink: StepKinematics_KinematicLink,
    ) -> None: ...
    def RepresentedLink(self) -> StepKinematics_KinematicLink: ...
    def SetRepresentedLink(
        self, theRepresentedLink: StepKinematics_KinematicLink
    ) -> None: ...

class StepKinematics_KinematicLinkRepresentationAssociation(
    StepRepr_RepresentationRelationship
):
    def __init__(self) -> None: ...

class StepKinematics_KinematicPair(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theJoint: StepKinematics_KinematicJoint,
    ) -> None: ...
    def ItemDefinedTransformation(self) -> StepRepr_ItemDefinedTransformation: ...
    def Joint(self) -> StepKinematics_KinematicJoint: ...
    def SetItemDefinedTransformation(
        self, theItemDefinedTransformation: StepRepr_ItemDefinedTransformation
    ) -> None: ...
    def SetJoint(self, theJoint: StepKinematics_KinematicJoint) -> None: ...

class StepKinematics_KinematicPropertyDefinitionRepresentation(
    StepRepr_PropertyDefinitionRepresentation
):
    def __init__(self) -> None: ...

class StepKinematics_KinematicTopologyDirectedStructure(StepRepr_Representation):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentation_Name: TCollection_HAsciiString,
        theRepresentation_Items: StepRepr_HArray1OfRepresentationItem,
        theRepresentation_ContextOfItems: StepRepr_RepresentationContext,
        theParent: StepKinematics_KinematicTopologyStructure,
    ) -> None: ...
    def Parent(self) -> StepKinematics_KinematicTopologyStructure: ...
    def SetParent(
        self, theParent: StepKinematics_KinematicTopologyStructure
    ) -> None: ...

class StepKinematics_KinematicTopologyNetworkStructure(StepRepr_Representation):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentation_Name: TCollection_HAsciiString,
        theRepresentation_Items: StepRepr_HArray1OfRepresentationItem,
        theRepresentation_ContextOfItems: StepRepr_RepresentationContext,
        theParent: StepKinematics_KinematicTopologyStructure,
    ) -> None: ...
    def Parent(self) -> StepKinematics_KinematicTopologyStructure: ...
    def SetParent(
        self, theParent: StepKinematics_KinematicTopologyStructure
    ) -> None: ...

class StepKinematics_KinematicTopologyRepresentationSelect(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def KinematicTopologyDirectedStructure(
        self,
    ) -> StepKinematics_KinematicTopologyDirectedStructure: ...
    def KinematicTopologyNetworkStructure(
        self,
    ) -> StepKinematics_KinematicTopologyNetworkStructure: ...
    def KinematicTopologyStructure(
        self,
    ) -> StepKinematics_KinematicTopologyStructure: ...

class StepKinematics_KinematicTopologyStructure(StepRepr_Representation):
    def __init__(self) -> None: ...

class StepKinematics_MechanismRepresentation(StepRepr_Representation):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentation_Name: TCollection_HAsciiString,
        theRepresentation_Items: StepRepr_HArray1OfRepresentationItem,
        theRepresentation_ContextOfItems: StepRepr_RepresentationContext,
        theRepresentedTopology: StepKinematics_KinematicTopologyRepresentationSelect,
    ) -> None: ...
    def RepresentedTopology(
        self,
    ) -> StepKinematics_KinematicTopologyRepresentationSelect: ...
    def SetRepresentedTopology(
        self,
        theRepresentedTopology: StepKinematics_KinematicTopologyRepresentationSelect,
    ) -> None: ...

class StepKinematics_MechanismStateRepresentation(StepRepr_Representation):
    def __init__(self) -> None: ...
    def Init(
        self,
        theName: TCollection_HAsciiString,
        theItems: StepRepr_HArray1OfRepresentationItem,
        theContextOfItems: StepRepr_RepresentationContext,
        theMechanism: StepKinematics_MechanismRepresentation,
    ) -> None: ...
    def Mechanism(self) -> StepKinematics_MechanismRepresentation: ...
    def SetMechanism(
        self, theMechanism: StepKinematics_MechanismRepresentation
    ) -> None: ...

class StepKinematics_OrientedJoint(StepShape_OrientedEdge):
    def __init__(self) -> None: ...

class StepKinematics_PairRepresentationRelationship(
    StepGeom_GeometricRepresentationItem
):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theRepresentationRelationship_Name: TCollection_HAsciiString,
        hasRepresentationRelationship_Description: bool,
        theRepresentationRelationship_Description: TCollection_HAsciiString,
        theRepresentationRelationship_Rep1: StepRepr_RepresentationOrRepresentationReference,
        theRepresentationRelationship_Rep2: StepRepr_RepresentationOrRepresentationReference,
        theRepresentationRelationshipWithTransformation_TransformationOperator: StepRepr_Transformation,
    ) -> None: ...
    def RepresentationRelationshipWithTransformation(
        self,
    ) -> StepRepr_RepresentationRelationshipWithTransformation: ...
    def SetRepresentationRelationshipWithTransformation(
        self,
        theRepresentationRelationshipWithTransformation: StepRepr_RepresentationRelationshipWithTransformation,
    ) -> None: ...

class StepKinematics_PairValue(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def AppliesToPair(self) -> StepKinematics_KinematicPair: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theAppliesToPair: StepKinematics_KinematicPair,
    ) -> None: ...
    def SetAppliesToPair(
        self, theAppliesToPair: StepKinematics_KinematicPair
    ) -> None: ...

class StepKinematics_ProductDefinitionKinematics(StepRepr_PropertyDefinition):
    def __init__(self) -> None: ...

class StepKinematics_ProductDefinitionRelationshipKinematics(
    StepRepr_PropertyDefinition
):
    def __init__(self) -> None: ...

class StepKinematics_RigidPlacement(StepData_SelectType):
    def __init__(self) -> None: ...
    def Axis2Placement3d(self) -> StepGeom_Axis2Placement3d: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def SuParameters(self) -> StepGeom_SuParameters: ...

class StepKinematics_RotationAboutDirection(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def DirectionOfAxis(self) -> StepGeom_Direction: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theDirectionOfAxis: StepGeom_Direction,
        theRotationAngle: float,
    ) -> None: ...
    def RotationAngle(self) -> float: ...
    def SetDirectionOfAxis(self, theDirectionOfAxis: StepGeom_Direction) -> None: ...
    def SetRotationAngle(self, theRotationAngle: float) -> None: ...

class StepKinematics_SpatialRotation(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def RotationAboutDirection(self) -> StepKinematics_RotationAboutDirection: ...
    def YprRotation(self) -> TColStd_HArray1OfReal: ...

class StepKinematics_SphericalPairSelect(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def SphericalPair(self) -> StepKinematics_SphericalPair: ...
    def SphericalPairWithPin(self) -> StepKinematics_SphericalPairWithPin: ...

class StepKinematics_ActuatedKinPairAndOrderKinPair(StepKinematics_KinematicPair):
    def __init__(self) -> None: ...
    def GetActuatedKinematicPair(self) -> StepKinematics_ActuatedKinematicPair: ...
    def GetOrderKinematicPair(self) -> StepKinematics_KinematicPair: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theJoint: StepKinematics_KinematicJoint,
        theActuatedKinematicPair: StepKinematics_ActuatedKinematicPair,
        theOrderKinematicPair: StepKinematics_KinematicPair,
    ) -> None: ...
    def SetActuatedKinematicPair(
        self, aKP: StepKinematics_ActuatedKinematicPair
    ) -> None: ...
    def SetOrderKinematicPair(self, aKP: StepKinematics_KinematicPair) -> None: ...

class StepKinematics_ActuatedKinematicPair(StepKinematics_KinematicPair):
    def __init__(self) -> None: ...
    def HasRX(self) -> bool: ...
    def HasRY(self) -> bool: ...
    def HasRZ(self) -> bool: ...
    def HasTX(self) -> bool: ...
    def HasTY(self) -> bool: ...
    def HasTZ(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        hasTX: bool,
        theTX: StepKinematics_ActuatedDirection,
        hasTY: bool,
        theTY: StepKinematics_ActuatedDirection,
        hasTZ: bool,
        theTZ: StepKinematics_ActuatedDirection,
        hasRX: bool,
        theRX: StepKinematics_ActuatedDirection,
        hasRY: bool,
        theRY: StepKinematics_ActuatedDirection,
        hasRZ: bool,
        theRZ: StepKinematics_ActuatedDirection,
    ) -> None: ...
    def RX(self) -> StepKinematics_ActuatedDirection: ...
    def RY(self) -> StepKinematics_ActuatedDirection: ...
    def RZ(self) -> StepKinematics_ActuatedDirection: ...
    def SetRX(self, theRX: StepKinematics_ActuatedDirection) -> None: ...
    def SetRY(self, theRY: StepKinematics_ActuatedDirection) -> None: ...
    def SetRZ(self, theRZ: StepKinematics_ActuatedDirection) -> None: ...
    def SetTX(self, theTX: StepKinematics_ActuatedDirection) -> None: ...
    def SetTY(self, theTY: StepKinematics_ActuatedDirection) -> None: ...
    def SetTZ(self, theTZ: StepKinematics_ActuatedDirection) -> None: ...
    def TX(self) -> StepKinematics_ActuatedDirection: ...
    def TY(self) -> StepKinematics_ActuatedDirection: ...
    def TZ(self) -> StepKinematics_ActuatedDirection: ...

class StepKinematics_CylindricalPairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualRotation(self) -> float: ...
    def ActualTranslation(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualTranslation: float,
        theActualRotation: float,
    ) -> None: ...
    def SetActualRotation(self, theActualRotation: float) -> None: ...
    def SetActualTranslation(self, theActualTranslation: float) -> None: ...

class StepKinematics_GearPairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualRotation1(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualRotation1: float,
    ) -> None: ...
    def SetActualRotation1(self, theActualRotation1: float) -> None: ...

class StepKinematics_HighOrderKinematicPair(StepKinematics_KinematicPair):
    def __init__(self) -> None: ...

class StepKinematics_KinematicPropertyMechanismRepresentation(
    StepKinematics_KinematicPropertyDefinitionRepresentation
):
    def __init__(self) -> None: ...
    def Base(self) -> StepKinematics_KinematicLinkRepresentation: ...
    def Init(
        self,
        thePropertyDefinitionRepresentation_Definition: StepRepr_RepresentedDefinition,
        thePropertyDefinitionRepresentation_UsedRepresentation: StepRepr_Representation,
        theBase: StepKinematics_KinematicLinkRepresentation,
    ) -> None: ...
    def SetBase(self, theBase: StepKinematics_KinematicLinkRepresentation) -> None: ...

class StepKinematics_LinearFlexibleLinkRepresentation(
    StepKinematics_KinematicLinkRepresentation
):
    def __init__(self) -> None: ...

class StepKinematics_LowOrderKinematicPair(StepKinematics_KinematicPair):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theTX: bool,
        theTY: bool,
        theTZ: bool,
        theRX: bool,
        theRY: bool,
        theRZ: bool,
    ) -> None: ...
    def RX(self) -> bool: ...
    def RY(self) -> bool: ...
    def RZ(self) -> bool: ...
    def SetRX(self, theRX: bool) -> None: ...
    def SetRY(self, theRY: bool) -> None: ...
    def SetRZ(self, theRZ: bool) -> None: ...
    def SetTX(self, theTX: bool) -> None: ...
    def SetTY(self, theTY: bool) -> None: ...
    def SetTZ(self, theTZ: bool) -> None: ...
    def TX(self) -> bool: ...
    def TY(self) -> bool: ...
    def TZ(self) -> bool: ...

class StepKinematics_LowOrderKinematicPairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualRotationX(self) -> float: ...
    def ActualRotationY(self) -> float: ...
    def ActualRotationZ(self) -> float: ...
    def ActualTranslationX(self) -> float: ...
    def ActualTranslationY(self) -> float: ...
    def ActualTranslationZ(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualTranslationX: float,
        theActualTranslationY: float,
        theActualTranslationZ: float,
        theActualRotationX: float,
        theActualRotationY: float,
        theActualRotationZ: float,
    ) -> None: ...
    def SetActualRotationX(self, theActualRotationX: float) -> None: ...
    def SetActualRotationY(self, theActualRotationY: float) -> None: ...
    def SetActualRotationZ(self, theActualRotationZ: float) -> None: ...
    def SetActualTranslationX(self, theActualTranslationX: float) -> None: ...
    def SetActualTranslationY(self, theActualTranslationY: float) -> None: ...
    def SetActualTranslationZ(self, theActualTranslationZ: float) -> None: ...

class StepKinematics_LowOrderKinematicPairWithMotionCoupling(
    StepKinematics_KinematicPair
):
    def __init__(self) -> None: ...

class StepKinematics_PlanarPairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualRotation(self) -> float: ...
    def ActualTranslationX(self) -> float: ...
    def ActualTranslationY(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualRotation: float,
        theActualTranslationX: float,
        theActualTranslationY: float,
    ) -> None: ...
    def SetActualRotation(self, theActualRotation: float) -> None: ...
    def SetActualTranslationX(self, theActualTranslationX: float) -> None: ...
    def SetActualTranslationY(self, theActualTranslationY: float) -> None: ...

class StepKinematics_PointOnPlanarCurvePairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualPointOnCurve(self) -> StepGeom_PointOnCurve: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualPointOnCurve: StepGeom_PointOnCurve,
        theInputOrientation: StepKinematics_SpatialRotation,
    ) -> None: ...
    def InputOrientation(self) -> StepKinematics_SpatialRotation: ...
    def SetActualPointOnCurve(
        self, theActualPointOnCurve: StepGeom_PointOnCurve
    ) -> None: ...
    def SetInputOrientation(
        self, theInputOrientation: StepKinematics_SpatialRotation
    ) -> None: ...

class StepKinematics_PointOnSurfacePairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualPointOnSurface(self) -> StepGeom_PointOnSurface: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualPointOnSurface: StepGeom_PointOnSurface,
        theInputOrientation: StepKinematics_SpatialRotation,
    ) -> None: ...
    def InputOrientation(self) -> StepKinematics_SpatialRotation: ...
    def SetActualPointOnSurface(
        self, theActualPointOnSurface: StepGeom_PointOnSurface
    ) -> None: ...
    def SetInputOrientation(
        self, theInputOrientation: StepKinematics_SpatialRotation
    ) -> None: ...

class StepKinematics_PrismaticPairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualTranslation(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualTranslation: float,
    ) -> None: ...
    def SetActualTranslation(self, theActualTranslation: float) -> None: ...

class StepKinematics_RackAndPinionPairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualDisplacement(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualDisplacement: float,
    ) -> None: ...
    def SetActualDisplacement(self, theActualDisplacement: float) -> None: ...

class StepKinematics_RevolutePairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualRotation(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualRotation: float,
    ) -> None: ...
    def SetActualRotation(self, theActualRotation: float) -> None: ...

class StepKinematics_RigidLinkRepresentation(
    StepKinematics_KinematicLinkRepresentation
):
    def __init__(self) -> None: ...

class StepKinematics_RollingCurvePairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualPointOnCurve1(self) -> StepGeom_PointOnCurve: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualPointOnCurve1: StepGeom_PointOnCurve,
    ) -> None: ...
    def SetActualPointOnCurve1(
        self, theActualPointOnCurve1: StepGeom_PointOnCurve
    ) -> None: ...

class StepKinematics_RollingSurfacePairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualPointOnSurface(self) -> StepGeom_PointOnSurface: ...
    def ActualRotation(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualPointOnSurface: StepGeom_PointOnSurface,
        theActualRotation: float,
    ) -> None: ...
    def SetActualPointOnSurface(
        self, theActualPointOnSurface: StepGeom_PointOnSurface
    ) -> None: ...
    def SetActualRotation(self, theActualRotation: float) -> None: ...

class StepKinematics_ScrewPairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualRotation(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualRotation: float,
    ) -> None: ...
    def SetActualRotation(self, theActualRotation: float) -> None: ...

class StepKinematics_SlidingCurvePairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualPointOnCurve1(self) -> StepGeom_PointOnCurve: ...
    def ActualPointOnCurve2(self) -> StepGeom_PointOnCurve: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualPointOnCurve1: StepGeom_PointOnCurve,
        theActualPointOnCurve2: StepGeom_PointOnCurve,
    ) -> None: ...
    def SetActualPointOnCurve1(
        self, theActualPointOnCurve1: StepGeom_PointOnCurve
    ) -> None: ...
    def SetActualPointOnCurve2(
        self, theActualPointOnCurve2: StepGeom_PointOnCurve
    ) -> None: ...

class StepKinematics_SlidingSurfacePairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualPointOnSurface1(self) -> StepGeom_PointOnSurface: ...
    def ActualPointOnSurface2(self) -> StepGeom_PointOnSurface: ...
    def ActualRotation(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualPointOnSurface1: StepGeom_PointOnSurface,
        theActualPointOnSurface2: StepGeom_PointOnSurface,
        theActualRotation: float,
    ) -> None: ...
    def SetActualPointOnSurface1(
        self, theActualPointOnSurface1: StepGeom_PointOnSurface
    ) -> None: ...
    def SetActualPointOnSurface2(
        self, theActualPointOnSurface2: StepGeom_PointOnSurface
    ) -> None: ...
    def SetActualRotation(self, theActualRotation: float) -> None: ...

class StepKinematics_SphericalPairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theInputOrientation: StepKinematics_SpatialRotation,
    ) -> None: ...
    def InputOrientation(self) -> StepKinematics_SpatialRotation: ...
    def SetInputOrientation(
        self, theInputOrientation: StepKinematics_SpatialRotation
    ) -> None: ...

class StepKinematics_UnconstrainedPairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def ActualPlacement(self) -> StepGeom_Axis2Placement3d: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theActualPlacement: StepGeom_Axis2Placement3d,
    ) -> None: ...
    def SetActualPlacement(
        self, theActualPlacement: StepGeom_Axis2Placement3d
    ) -> None: ...

class StepKinematics_UniversalPairValue(StepKinematics_PairValue):
    def __init__(self) -> None: ...
    def FirstRotationAngle(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        thePairValue_AppliesToPair: StepKinematics_KinematicPair,
        theFirstRotationAngle: float,
        theSecondRotationAngle: float,
    ) -> None: ...
    def SecondRotationAngle(self) -> float: ...
    def SetFirstRotationAngle(self, theFirstRotationAngle: float) -> None: ...
    def SetSecondRotationAngle(self, theSecondRotationAngle: float) -> None: ...

class StepKinematics_CylindricalPair(StepKinematics_LowOrderKinematicPair):
    def __init__(self) -> None: ...

class StepKinematics_FullyConstrainedPair(StepKinematics_LowOrderKinematicPair):
    def __init__(self) -> None: ...

class StepKinematics_GearPair(StepKinematics_LowOrderKinematicPairWithMotionCoupling):
    def __init__(self) -> None: ...
    def Bevel(self) -> float: ...
    def GearRatio(self) -> float: ...
    def HelicalAngle(self) -> float: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theRadiusFirstLink: float,
        theRadiusSecondLink: float,
        theBevel: float,
        theHelicalAngle: float,
        theGearRatio: float,
    ) -> None: ...
    def RadiusFirstLink(self) -> float: ...
    def RadiusSecondLink(self) -> float: ...
    def SetBevel(self, theBevel: float) -> None: ...
    def SetGearRatio(self, theGearRatio: float) -> None: ...
    def SetHelicalAngle(self, theHelicalAngle: float) -> None: ...
    def SetRadiusFirstLink(self, theRadiusFirstLink: float) -> None: ...
    def SetRadiusSecondLink(self, theRadiusSecondLink: float) -> None: ...

class StepKinematics_LinearFlexibleAndPinionPair(
    StepKinematics_LowOrderKinematicPairWithMotionCoupling
):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        thePinionRadius: float,
    ) -> None: ...
    def PinionRadius(self) -> float: ...
    def SetPinionRadius(self, thePinionRadius: float) -> None: ...

class StepKinematics_LinearFlexibleAndPlanarCurvePair(
    StepKinematics_HighOrderKinematicPair
):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        thePairCurve: StepGeom_Curve,
        theOrientation: bool,
    ) -> None: ...
    def Orientation(self) -> bool: ...
    def PairCurve(self) -> StepGeom_Curve: ...
    def SetOrientation(self, theOrientation: bool) -> None: ...
    def SetPairCurve(self, thePairCurve: StepGeom_Curve) -> None: ...

class StepKinematics_LowOrderKinematicPairWithRange(
    StepKinematics_LowOrderKinematicPair
):
    def __init__(self) -> None: ...
    def HasLowerLimitActualRotationX(self) -> bool: ...
    def HasLowerLimitActualRotationY(self) -> bool: ...
    def HasLowerLimitActualRotationZ(self) -> bool: ...
    def HasLowerLimitActualTranslationX(self) -> bool: ...
    def HasLowerLimitActualTranslationY(self) -> bool: ...
    def HasLowerLimitActualTranslationZ(self) -> bool: ...
    def HasUpperLimitActualRotationX(self) -> bool: ...
    def HasUpperLimitActualRotationY(self) -> bool: ...
    def HasUpperLimitActualRotationZ(self) -> bool: ...
    def HasUpperLimitActualTranslationX(self) -> bool: ...
    def HasUpperLimitActualTranslationY(self) -> bool: ...
    def HasUpperLimitActualTranslationZ(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theLowOrderKinematicPair_TX: bool,
        theLowOrderKinematicPair_TY: bool,
        theLowOrderKinematicPair_TZ: bool,
        theLowOrderKinematicPair_RX: bool,
        theLowOrderKinematicPair_RY: bool,
        theLowOrderKinematicPair_RZ: bool,
        hasLowerLimitActualRotationX: bool,
        theLowerLimitActualRotationX: float,
        hasUpperLimitActualRotationX: bool,
        theUpperLimitActualRotationX: float,
        hasLowerLimitActualRotationY: bool,
        theLowerLimitActualRotationY: float,
        hasUpperLimitActualRotationY: bool,
        theUpperLimitActualRotationY: float,
        hasLowerLimitActualRotationZ: bool,
        theLowerLimitActualRotationZ: float,
        hasUpperLimitActualRotationZ: bool,
        theUpperLimitActualRotationZ: float,
        hasLowerLimitActualTranslationX: bool,
        theLowerLimitActualTranslationX: float,
        hasUpperLimitActualTranslationX: bool,
        theUpperLimitActualTranslationX: float,
        hasLowerLimitActualTranslationY: bool,
        theLowerLimitActualTranslationY: float,
        hasUpperLimitActualTranslationY: bool,
        theUpperLimitActualTranslationY: float,
        hasLowerLimitActualTranslationZ: bool,
        theLowerLimitActualTranslationZ: float,
        hasUpperLimitActualTranslationZ: bool,
        theUpperLimitActualTranslationZ: float,
    ) -> None: ...
    def LowerLimitActualRotationX(self) -> float: ...
    def LowerLimitActualRotationY(self) -> float: ...
    def LowerLimitActualRotationZ(self) -> float: ...
    def LowerLimitActualTranslationX(self) -> float: ...
    def LowerLimitActualTranslationY(self) -> float: ...
    def LowerLimitActualTranslationZ(self) -> float: ...
    def SetLowerLimitActualRotationX(
        self, theLowerLimitActualRotationX: float
    ) -> None: ...
    def SetLowerLimitActualRotationY(
        self, theLowerLimitActualRotationY: float
    ) -> None: ...
    def SetLowerLimitActualRotationZ(
        self, theLowerLimitActualRotationZ: float
    ) -> None: ...
    def SetLowerLimitActualTranslationX(
        self, theLowerLimitActualTranslationX: float
    ) -> None: ...
    def SetLowerLimitActualTranslationY(
        self, theLowerLimitActualTranslationY: float
    ) -> None: ...
    def SetLowerLimitActualTranslationZ(
        self, theLowerLimitActualTranslationZ: float
    ) -> None: ...
    def SetUpperLimitActualRotationX(
        self, theUpperLimitActualRotationX: float
    ) -> None: ...
    def SetUpperLimitActualRotationY(
        self, theUpperLimitActualRotationY: float
    ) -> None: ...
    def SetUpperLimitActualRotationZ(
        self, theUpperLimitActualRotationZ: float
    ) -> None: ...
    def SetUpperLimitActualTranslationX(
        self, theUpperLimitActualTranslationX: float
    ) -> None: ...
    def SetUpperLimitActualTranslationY(
        self, theUpperLimitActualTranslationY: float
    ) -> None: ...
    def SetUpperLimitActualTranslationZ(
        self, theUpperLimitActualTranslationZ: float
    ) -> None: ...
    def UpperLimitActualRotationX(self) -> float: ...
    def UpperLimitActualRotationY(self) -> float: ...
    def UpperLimitActualRotationZ(self) -> float: ...
    def UpperLimitActualTranslationX(self) -> float: ...
    def UpperLimitActualTranslationY(self) -> float: ...
    def UpperLimitActualTranslationZ(self) -> float: ...

class StepKinematics_PlanarCurvePair(StepKinematics_HighOrderKinematicPair):
    def __init__(self) -> None: ...
    def Curve1(self) -> StepGeom_Curve: ...
    def Curve2(self) -> StepGeom_Curve: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theCurve1: StepGeom_Curve,
        theCurve2: StepGeom_Curve,
        theOrientation: bool,
    ) -> None: ...
    def Orientation(self) -> bool: ...
    def SetCurve1(self, theCurve1: StepGeom_Curve) -> None: ...
    def SetCurve2(self, theCurve2: StepGeom_Curve) -> None: ...
    def SetOrientation(self, theOrientation: bool) -> None: ...

class StepKinematics_PlanarPair(StepKinematics_LowOrderKinematicPair):
    def __init__(self) -> None: ...

class StepKinematics_PointOnPlanarCurvePair(StepKinematics_HighOrderKinematicPair):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        thePairCurve: StepGeom_Curve,
        theOrientation: bool,
    ) -> None: ...
    def Orientation(self) -> bool: ...
    def PairCurve(self) -> StepGeom_Curve: ...
    def SetOrientation(self, theOrientation: bool) -> None: ...
    def SetPairCurve(self, thePairCurve: StepGeom_Curve) -> None: ...

class StepKinematics_PointOnSurfacePair(StepKinematics_HighOrderKinematicPair):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        thePairSurface: StepGeom_Surface,
    ) -> None: ...
    def PairSurface(self) -> StepGeom_Surface: ...
    def SetPairSurface(self, thePairSurface: StepGeom_Surface) -> None: ...

class StepKinematics_PrismaticPair(StepKinematics_LowOrderKinematicPair):
    def __init__(self) -> None: ...

class StepKinematics_RackAndPinionPair(
    StepKinematics_LowOrderKinematicPairWithMotionCoupling
):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        thePinionRadius: float,
    ) -> None: ...
    def PinionRadius(self) -> float: ...
    def SetPinionRadius(self, thePinionRadius: float) -> None: ...

class StepKinematics_RevolutePair(StepKinematics_LowOrderKinematicPair):
    def __init__(self) -> None: ...

class StepKinematics_ScrewPair(StepKinematics_LowOrderKinematicPairWithMotionCoupling):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        thePitch: float,
    ) -> None: ...
    def Pitch(self) -> float: ...
    def SetPitch(self, thePitch: float) -> None: ...

class StepKinematics_SphericalPair(StepKinematics_LowOrderKinematicPair):
    def __init__(self) -> None: ...

class StepKinematics_SphericalPairWithPin(StepKinematics_LowOrderKinematicPair):
    def __init__(self) -> None: ...

class StepKinematics_SurfacePair(StepKinematics_HighOrderKinematicPair):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theSurface1: StepGeom_Surface,
        theSurface2: StepGeom_Surface,
        theOrientation: bool,
    ) -> None: ...
    def Orientation(self) -> bool: ...
    def SetOrientation(self, theOrientation: bool) -> None: ...
    def SetSurface1(self, theSurface1: StepGeom_Surface) -> None: ...
    def SetSurface2(self, theSurface2: StepGeom_Surface) -> None: ...
    def Surface1(self) -> StepGeom_Surface: ...
    def Surface2(self) -> StepGeom_Surface: ...

class StepKinematics_UnconstrainedPair(StepKinematics_LowOrderKinematicPair):
    def __init__(self) -> None: ...

class StepKinematics_UniversalPair(StepKinematics_LowOrderKinematicPair):
    def __init__(self) -> None: ...
    def HasInputSkewAngle(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theLowOrderKinematicPair_TX: bool,
        theLowOrderKinematicPair_TY: bool,
        theLowOrderKinematicPair_TZ: bool,
        theLowOrderKinematicPair_RX: bool,
        theLowOrderKinematicPair_RY: bool,
        theLowOrderKinematicPair_RZ: bool,
        hasInputSkewAngle: bool,
        theInputSkewAngle: float,
    ) -> None: ...
    def InputSkewAngle(self) -> float: ...
    def SetInputSkewAngle(self, theInputSkewAngle: float) -> None: ...

class StepKinematics_CylindricalPairWithRange(StepKinematics_CylindricalPair):
    def __init__(self) -> None: ...
    def HasLowerLimitActualRotation(self) -> bool: ...
    def HasLowerLimitActualTranslation(self) -> bool: ...
    def HasUpperLimitActualRotation(self) -> bool: ...
    def HasUpperLimitActualTranslation(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theLowOrderKinematicPair_TX: bool,
        theLowOrderKinematicPair_TY: bool,
        theLowOrderKinematicPair_TZ: bool,
        theLowOrderKinematicPair_RX: bool,
        theLowOrderKinematicPair_RY: bool,
        theLowOrderKinematicPair_RZ: bool,
        hasLowerLimitActualTranslation: bool,
        theLowerLimitActualTranslation: float,
        hasUpperLimitActualTranslation: bool,
        theUpperLimitActualTranslation: float,
        hasLowerLimitActualRotation: bool,
        theLowerLimitActualRotation: float,
        hasUpperLimitActualRotation: bool,
        theUpperLimitActualRotation: float,
    ) -> None: ...
    def LowerLimitActualRotation(self) -> float: ...
    def LowerLimitActualTranslation(self) -> float: ...
    def SetLowerLimitActualRotation(
        self, theLowerLimitActualRotation: float
    ) -> None: ...
    def SetLowerLimitActualTranslation(
        self, theLowerLimitActualTranslation: float
    ) -> None: ...
    def SetUpperLimitActualRotation(
        self, theUpperLimitActualRotation: float
    ) -> None: ...
    def SetUpperLimitActualTranslation(
        self, theUpperLimitActualTranslation: float
    ) -> None: ...
    def UpperLimitActualRotation(self) -> float: ...
    def UpperLimitActualTranslation(self) -> float: ...

class StepKinematics_GearPairWithRange(StepKinematics_GearPair):
    def __init__(self) -> None: ...
    def HasLowerLimitActualRotation1(self) -> bool: ...
    def HasUpperLimitActualRotation1(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theGearPair_RadiusFirstLink: float,
        theGearPair_RadiusSecondLink: float,
        theGearPair_Bevel: float,
        theGearPair_HelicalAngle: float,
        theGearPair_GearRatio: float,
        hasLowerLimitActualRotation1: bool,
        theLowerLimitActualRotation1: float,
        hasUpperLimitActualRotation1: bool,
        theUpperLimitActualRotation1: float,
    ) -> None: ...
    def LowerLimitActualRotation1(self) -> float: ...
    def SetLowerLimitActualRotation1(
        self, theLowerLimitActualRotation1: float
    ) -> None: ...
    def SetUpperLimitActualRotation1(
        self, theUpperLimitActualRotation1: float
    ) -> None: ...
    def UpperLimitActualRotation1(self) -> float: ...

class StepKinematics_HomokineticPair(StepKinematics_UniversalPair):
    def __init__(self) -> None: ...

class StepKinematics_PlanarCurvePairRange(StepKinematics_PlanarCurvePair):
    def __init__(self) -> None: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        thePlanarCurvePair_Curve1: StepGeom_Curve,
        thePlanarCurvePair_Curve2: StepGeom_Curve,
        thePlanarCurvePair_Orientation: bool,
        theRangeOnCurve1: StepGeom_TrimmedCurve,
        theRangeOnCurve2: StepGeom_TrimmedCurve,
    ) -> None: ...
    def RangeOnCurve1(self) -> StepGeom_TrimmedCurve: ...
    def RangeOnCurve2(self) -> StepGeom_TrimmedCurve: ...
    def SetRangeOnCurve1(self, theRangeOnCurve1: StepGeom_TrimmedCurve) -> None: ...
    def SetRangeOnCurve2(self, theRangeOnCurve2: StepGeom_TrimmedCurve) -> None: ...

class StepKinematics_PlanarPairWithRange(StepKinematics_PlanarPair):
    def __init__(self) -> None: ...
    def HasLowerLimitActualRotation(self) -> bool: ...
    def HasLowerLimitActualTranslationX(self) -> bool: ...
    def HasLowerLimitActualTranslationY(self) -> bool: ...
    def HasUpperLimitActualRotation(self) -> bool: ...
    def HasUpperLimitActualTranslationX(self) -> bool: ...
    def HasUpperLimitActualTranslationY(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theLowOrderKinematicPair_TX: bool,
        theLowOrderKinematicPair_TY: bool,
        theLowOrderKinematicPair_TZ: bool,
        theLowOrderKinematicPair_RX: bool,
        theLowOrderKinematicPair_RY: bool,
        theLowOrderKinematicPair_RZ: bool,
        hasLowerLimitActualRotation: bool,
        theLowerLimitActualRotation: float,
        hasUpperLimitActualRotation: bool,
        theUpperLimitActualRotation: float,
        hasLowerLimitActualTranslationX: bool,
        theLowerLimitActualTranslationX: float,
        hasUpperLimitActualTranslationX: bool,
        theUpperLimitActualTranslationX: float,
        hasLowerLimitActualTranslationY: bool,
        theLowerLimitActualTranslationY: float,
        hasUpperLimitActualTranslationY: bool,
        theUpperLimitActualTranslationY: float,
    ) -> None: ...
    def LowerLimitActualRotation(self) -> float: ...
    def LowerLimitActualTranslationX(self) -> float: ...
    def LowerLimitActualTranslationY(self) -> float: ...
    def SetLowerLimitActualRotation(
        self, theLowerLimitActualRotation: float
    ) -> None: ...
    def SetLowerLimitActualTranslationX(
        self, theLowerLimitActualTranslationX: float
    ) -> None: ...
    def SetLowerLimitActualTranslationY(
        self, theLowerLimitActualTranslationY: float
    ) -> None: ...
    def SetUpperLimitActualRotation(
        self, theUpperLimitActualRotation: float
    ) -> None: ...
    def SetUpperLimitActualTranslationX(
        self, theUpperLimitActualTranslationX: float
    ) -> None: ...
    def SetUpperLimitActualTranslationY(
        self, theUpperLimitActualTranslationY: float
    ) -> None: ...
    def UpperLimitActualRotation(self) -> float: ...
    def UpperLimitActualTranslationX(self) -> float: ...
    def UpperLimitActualTranslationY(self) -> float: ...

class StepKinematics_PointOnPlanarCurvePairWithRange(
    StepKinematics_PointOnPlanarCurvePair
):
    def __init__(self) -> None: ...
    def HasLowerLimitPitch(self) -> bool: ...
    def HasLowerLimitRoll(self) -> bool: ...
    def HasLowerLimitYaw(self) -> bool: ...
    def HasUpperLimitPitch(self) -> bool: ...
    def HasUpperLimitRoll(self) -> bool: ...
    def HasUpperLimitYaw(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        thePointOnPlanarCurvePair_PairCurve: StepGeom_Curve,
        thePointOnPlanarCurvePair_Orientation: bool,
        theRangeOnPairCurve: StepGeom_TrimmedCurve,
        hasLowerLimitYaw: bool,
        theLowerLimitYaw: float,
        hasUpperLimitYaw: bool,
        theUpperLimitYaw: float,
        hasLowerLimitPitch: bool,
        theLowerLimitPitch: float,
        hasUpperLimitPitch: bool,
        theUpperLimitPitch: float,
        hasLowerLimitRoll: bool,
        theLowerLimitRoll: float,
        hasUpperLimitRoll: bool,
        theUpperLimitRoll: float,
    ) -> None: ...
    def LowerLimitPitch(self) -> float: ...
    def LowerLimitRoll(self) -> float: ...
    def LowerLimitYaw(self) -> float: ...
    def RangeOnPairCurve(self) -> StepGeom_TrimmedCurve: ...
    def SetLowerLimitPitch(self, theLowerLimitPitch: float) -> None: ...
    def SetLowerLimitRoll(self, theLowerLimitRoll: float) -> None: ...
    def SetLowerLimitYaw(self, theLowerLimitYaw: float) -> None: ...
    def SetRangeOnPairCurve(
        self, theRangeOnPairCurve: StepGeom_TrimmedCurve
    ) -> None: ...
    def SetUpperLimitPitch(self, theUpperLimitPitch: float) -> None: ...
    def SetUpperLimitRoll(self, theUpperLimitRoll: float) -> None: ...
    def SetUpperLimitYaw(self, theUpperLimitYaw: float) -> None: ...
    def UpperLimitPitch(self) -> float: ...
    def UpperLimitRoll(self) -> float: ...
    def UpperLimitYaw(self) -> float: ...

class StepKinematics_PointOnSurfacePairWithRange(StepKinematics_PointOnSurfacePair):
    def __init__(self) -> None: ...
    def HasLowerLimitPitch(self) -> bool: ...
    def HasLowerLimitRoll(self) -> bool: ...
    def HasLowerLimitYaw(self) -> bool: ...
    def HasUpperLimitPitch(self) -> bool: ...
    def HasUpperLimitRoll(self) -> bool: ...
    def HasUpperLimitYaw(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        thePointOnSurfacePair_PairSurface: StepGeom_Surface,
        theRangeOnPairSurface: StepGeom_RectangularTrimmedSurface,
        hasLowerLimitYaw: bool,
        theLowerLimitYaw: float,
        hasUpperLimitYaw: bool,
        theUpperLimitYaw: float,
        hasLowerLimitPitch: bool,
        theLowerLimitPitch: float,
        hasUpperLimitPitch: bool,
        theUpperLimitPitch: float,
        hasLowerLimitRoll: bool,
        theLowerLimitRoll: float,
        hasUpperLimitRoll: bool,
        theUpperLimitRoll: float,
    ) -> None: ...
    def LowerLimitPitch(self) -> float: ...
    def LowerLimitRoll(self) -> float: ...
    def LowerLimitYaw(self) -> float: ...
    def RangeOnPairSurface(self) -> StepGeom_RectangularTrimmedSurface: ...
    def SetLowerLimitPitch(self, theLowerLimitPitch: float) -> None: ...
    def SetLowerLimitRoll(self, theLowerLimitRoll: float) -> None: ...
    def SetLowerLimitYaw(self, theLowerLimitYaw: float) -> None: ...
    def SetRangeOnPairSurface(
        self, theRangeOnPairSurface: StepGeom_RectangularTrimmedSurface
    ) -> None: ...
    def SetUpperLimitPitch(self, theUpperLimitPitch: float) -> None: ...
    def SetUpperLimitRoll(self, theUpperLimitRoll: float) -> None: ...
    def SetUpperLimitYaw(self, theUpperLimitYaw: float) -> None: ...
    def UpperLimitPitch(self) -> float: ...
    def UpperLimitRoll(self) -> float: ...
    def UpperLimitYaw(self) -> float: ...

class StepKinematics_PrismaticPairWithRange(StepKinematics_PrismaticPair):
    def __init__(self) -> None: ...
    def HasLowerLimitActualTranslation(self) -> bool: ...
    def HasUpperLimitActualTranslation(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theLowOrderKinematicPair_TX: bool,
        theLowOrderKinematicPair_TY: bool,
        theLowOrderKinematicPair_TZ: bool,
        theLowOrderKinematicPair_RX: bool,
        theLowOrderKinematicPair_RY: bool,
        theLowOrderKinematicPair_RZ: bool,
        hasLowerLimitActualTranslation: bool,
        theLowerLimitActualTranslation: float,
        hasUpperLimitActualTranslation: bool,
        theUpperLimitActualTranslation: float,
    ) -> None: ...
    def LowerLimitActualTranslation(self) -> float: ...
    def SetLowerLimitActualTranslation(
        self, theLowerLimitActualTranslation: float
    ) -> None: ...
    def SetUpperLimitActualTranslation(
        self, theUpperLimitActualTranslation: float
    ) -> None: ...
    def UpperLimitActualTranslation(self) -> float: ...

class StepKinematics_RackAndPinionPairWithRange(StepKinematics_RackAndPinionPair):
    def __init__(self) -> None: ...
    def HasLowerLimitRackDisplacement(self) -> bool: ...
    def HasUpperLimitRackDisplacement(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theRackAndPinionPair_PinionRadius: float,
        hasLowerLimitRackDisplacement: bool,
        theLowerLimitRackDisplacement: float,
        hasUpperLimitRackDisplacement: bool,
        theUpperLimitRackDisplacement: float,
    ) -> None: ...
    def LowerLimitRackDisplacement(self) -> float: ...
    def SetLowerLimitRackDisplacement(
        self, theLowerLimitRackDisplacement: float
    ) -> None: ...
    def SetUpperLimitRackDisplacement(
        self, theUpperLimitRackDisplacement: float
    ) -> None: ...
    def UpperLimitRackDisplacement(self) -> float: ...

class StepKinematics_RevolutePairWithRange(StepKinematics_RevolutePair):
    def __init__(self) -> None: ...
    def HasLowerLimitActualRotation(self) -> bool: ...
    def HasUpperLimitActualRotation(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theLowOrderKinematicPair_TX: bool,
        theLowOrderKinematicPair_TY: bool,
        theLowOrderKinematicPair_TZ: bool,
        theLowOrderKinematicPair_RX: bool,
        theLowOrderKinematicPair_RY: bool,
        theLowOrderKinematicPair_RZ: bool,
        hasLowerLimitActualRotation: bool,
        theLowerLimitActualRotation: float,
        hasUpperLimitActualRotation: bool,
        theUpperLimitActualRotation: float,
    ) -> None: ...
    def LowerLimitActualRotation(self) -> float: ...
    def SetLowerLimitActualRotation(
        self, theLowerLimitActualRotation: float
    ) -> None: ...
    def SetUpperLimitActualRotation(
        self, theUpperLimitActualRotation: float
    ) -> None: ...
    def UpperLimitActualRotation(self) -> float: ...

class StepKinematics_RollingCurvePair(StepKinematics_PlanarCurvePair):
    def __init__(self) -> None: ...

class StepKinematics_RollingSurfacePair(StepKinematics_SurfacePair):
    def __init__(self) -> None: ...

class StepKinematics_ScrewPairWithRange(StepKinematics_ScrewPair):
    def __init__(self) -> None: ...
    def HasLowerLimitActualRotation(self) -> bool: ...
    def HasUpperLimitActualRotation(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theScrewPair_Pitch: float,
        hasLowerLimitActualRotation: bool,
        theLowerLimitActualRotation: float,
        hasUpperLimitActualRotation: bool,
        theUpperLimitActualRotation: float,
    ) -> None: ...
    def LowerLimitActualRotation(self) -> float: ...
    def SetLowerLimitActualRotation(
        self, theLowerLimitActualRotation: float
    ) -> None: ...
    def SetUpperLimitActualRotation(
        self, theUpperLimitActualRotation: float
    ) -> None: ...
    def UpperLimitActualRotation(self) -> float: ...

class StepKinematics_SlidingCurvePair(StepKinematics_PlanarCurvePair):
    def __init__(self) -> None: ...

class StepKinematics_SlidingSurfacePair(StepKinematics_SurfacePair):
    def __init__(self) -> None: ...

class StepKinematics_SphericalPairWithPinAndRange(StepKinematics_SphericalPairWithPin):
    def __init__(self) -> None: ...
    def HasLowerLimitRoll(self) -> bool: ...
    def HasLowerLimitYaw(self) -> bool: ...
    def HasUpperLimitRoll(self) -> bool: ...
    def HasUpperLimitYaw(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theLowOrderKinematicPair_TX: bool,
        theLowOrderKinematicPair_TY: bool,
        theLowOrderKinematicPair_TZ: bool,
        theLowOrderKinematicPair_RX: bool,
        theLowOrderKinematicPair_RY: bool,
        theLowOrderKinematicPair_RZ: bool,
        hasLowerLimitYaw: bool,
        theLowerLimitYaw: float,
        hasUpperLimitYaw: bool,
        theUpperLimitYaw: float,
        hasLowerLimitRoll: bool,
        theLowerLimitRoll: float,
        hasUpperLimitRoll: bool,
        theUpperLimitRoll: float,
    ) -> None: ...
    def LowerLimitRoll(self) -> float: ...
    def LowerLimitYaw(self) -> float: ...
    def SetLowerLimitRoll(self, theLowerLimitRoll: float) -> None: ...
    def SetLowerLimitYaw(self, theLowerLimitYaw: float) -> None: ...
    def SetUpperLimitRoll(self, theUpperLimitRoll: float) -> None: ...
    def SetUpperLimitYaw(self, theUpperLimitYaw: float) -> None: ...
    def UpperLimitRoll(self) -> float: ...
    def UpperLimitYaw(self) -> float: ...

class StepKinematics_SphericalPairWithRange(StepKinematics_SphericalPair):
    def __init__(self) -> None: ...
    def HasLowerLimitPitch(self) -> bool: ...
    def HasLowerLimitRoll(self) -> bool: ...
    def HasLowerLimitYaw(self) -> bool: ...
    def HasUpperLimitPitch(self) -> bool: ...
    def HasUpperLimitRoll(self) -> bool: ...
    def HasUpperLimitYaw(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theLowOrderKinematicPair_TX: bool,
        theLowOrderKinematicPair_TY: bool,
        theLowOrderKinematicPair_TZ: bool,
        theLowOrderKinematicPair_RX: bool,
        theLowOrderKinematicPair_RY: bool,
        theLowOrderKinematicPair_RZ: bool,
        hasLowerLimitYaw: bool,
        theLowerLimitYaw: float,
        hasUpperLimitYaw: bool,
        theUpperLimitYaw: float,
        hasLowerLimitPitch: bool,
        theLowerLimitPitch: float,
        hasUpperLimitPitch: bool,
        theUpperLimitPitch: float,
        hasLowerLimitRoll: bool,
        theLowerLimitRoll: float,
        hasUpperLimitRoll: bool,
        theUpperLimitRoll: float,
    ) -> None: ...
    def LowerLimitPitch(self) -> float: ...
    def LowerLimitRoll(self) -> float: ...
    def LowerLimitYaw(self) -> float: ...
    def SetLowerLimitPitch(self, theLowerLimitPitch: float) -> None: ...
    def SetLowerLimitRoll(self, theLowerLimitRoll: float) -> None: ...
    def SetLowerLimitYaw(self, theLowerLimitYaw: float) -> None: ...
    def SetUpperLimitPitch(self, theUpperLimitPitch: float) -> None: ...
    def SetUpperLimitRoll(self, theUpperLimitRoll: float) -> None: ...
    def SetUpperLimitYaw(self, theUpperLimitYaw: float) -> None: ...
    def UpperLimitPitch(self) -> float: ...
    def UpperLimitRoll(self) -> float: ...
    def UpperLimitYaw(self) -> float: ...

class StepKinematics_SurfacePairWithRange(StepKinematics_SurfacePair):
    def __init__(self) -> None: ...
    def HasLowerLimitActualRotation(self) -> bool: ...
    def HasUpperLimitActualRotation(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theSurfacePair_Surface1: StepGeom_Surface,
        theSurfacePair_Surface2: StepGeom_Surface,
        theSurfacePair_Orientation: bool,
        theRangeOnSurface1: StepGeom_RectangularTrimmedSurface,
        theRangeOnSurface2: StepGeom_RectangularTrimmedSurface,
        hasLowerLimitActualRotation: bool,
        theLowerLimitActualRotation: float,
        hasUpperLimitActualRotation: bool,
        theUpperLimitActualRotation: float,
    ) -> None: ...
    def LowerLimitActualRotation(self) -> float: ...
    def RangeOnSurface1(self) -> StepGeom_RectangularTrimmedSurface: ...
    def RangeOnSurface2(self) -> StepGeom_RectangularTrimmedSurface: ...
    def SetLowerLimitActualRotation(
        self, theLowerLimitActualRotation: float
    ) -> None: ...
    def SetRangeOnSurface1(
        self, theRangeOnSurface1: StepGeom_RectangularTrimmedSurface
    ) -> None: ...
    def SetRangeOnSurface2(
        self, theRangeOnSurface2: StepGeom_RectangularTrimmedSurface
    ) -> None: ...
    def SetUpperLimitActualRotation(
        self, theUpperLimitActualRotation: float
    ) -> None: ...
    def UpperLimitActualRotation(self) -> float: ...

class StepKinematics_UniversalPairWithRange(StepKinematics_UniversalPair):
    def __init__(self) -> None: ...
    def HasLowerLimitFirstRotation(self) -> bool: ...
    def HasLowerLimitSecondRotation(self) -> bool: ...
    def HasUpperLimitFirstRotation(self) -> bool: ...
    def HasUpperLimitSecondRotation(self) -> bool: ...
    def Init(
        self,
        theRepresentationItem_Name: TCollection_HAsciiString,
        theItemDefinedTransformation_Name: TCollection_HAsciiString,
        hasItemDefinedTransformation_Description: bool,
        theItemDefinedTransformation_Description: TCollection_HAsciiString,
        theItemDefinedTransformation_TransformItem1: StepRepr_RepresentationItem,
        theItemDefinedTransformation_TransformItem2: StepRepr_RepresentationItem,
        theKinematicPair_Joint: StepKinematics_KinematicJoint,
        theLowOrderKinematicPair_TX: bool,
        theLowOrderKinematicPair_TY: bool,
        theLowOrderKinematicPair_TZ: bool,
        theLowOrderKinematicPair_RX: bool,
        theLowOrderKinematicPair_RY: bool,
        theLowOrderKinematicPair_RZ: bool,
        hasUniversalPair_InputSkewAngle: bool,
        theUniversalPair_InputSkewAngle: float,
        hasLowerLimitFirstRotation: bool,
        theLowerLimitFirstRotation: float,
        hasUpperLimitFirstRotation: bool,
        theUpperLimitFirstRotation: float,
        hasLowerLimitSecondRotation: bool,
        theLowerLimitSecondRotation: float,
        hasUpperLimitSecondRotation: bool,
        theUpperLimitSecondRotation: float,
    ) -> None: ...
    def LowerLimitFirstRotation(self) -> float: ...
    def LowerLimitSecondRotation(self) -> float: ...
    def SetLowerLimitFirstRotation(self, theLowerLimitFirstRotation: float) -> None: ...
    def SetLowerLimitSecondRotation(
        self, theLowerLimitSecondRotation: float
    ) -> None: ...
    def SetUpperLimitFirstRotation(self, theUpperLimitFirstRotation: float) -> None: ...
    def SetUpperLimitSecondRotation(
        self, theUpperLimitSecondRotation: float
    ) -> None: ...
    def UpperLimitFirstRotation(self) -> float: ...
    def UpperLimitSecondRotation(self) -> float: ...

# harray1 classes
# harray2 classes
# hsequence classes
