from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Geom2d import *

class TColGeom2d_Array1OfBSplineCurve:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class TColGeom2d_Array1OfBezierCurve:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class TColGeom2d_Array1OfCurve:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class TColGeom2d_SequenceOfBoundedCurve:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColGeom2d_SequenceOfCurve:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColGeom2d_SequenceOfGeometry:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

# harray1 classes

class TColGeom2d_HArray1OfBSplineCurve(
    TColGeom2d_Array1OfBSplineCurve, Standard_Transient
):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColGeom2d_Array1OfBSplineCurve: ...

class TColGeom2d_HArray1OfBezierCurve(
    TColGeom2d_Array1OfBezierCurve, Standard_Transient
):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColGeom2d_Array1OfBezierCurve: ...

class TColGeom2d_HArray1OfCurve(TColGeom2d_Array1OfCurve, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColGeom2d_Array1OfCurve: ...

# harray2 classes
# hsequence classes

class TColGeom2d_HSequenceOfBoundedCurve(
    TColGeom2d_SequenceOfBoundedCurve, Standard_Transient
):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TColGeom2d_SequenceOfBoundedCurve) -> None: ...
    def Sequence(self) -> TColGeom2d_SequenceOfBoundedCurve: ...
    def Append(self, theSequence: TColGeom2d_SequenceOfBoundedCurve) -> None: ...

class TColGeom2d_HSequenceOfCurve(TColGeom2d_SequenceOfCurve, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TColGeom2d_SequenceOfCurve) -> None: ...
    def Sequence(self) -> TColGeom2d_SequenceOfCurve: ...
    def Append(self, theSequence: TColGeom2d_SequenceOfCurve) -> None: ...
