from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *

# the following typedef cannot be wrapped as is
TColgp_Array2OfCirc2d = NewType("TColgp_Array2OfCirc2d", Any)
# the following typedef cannot be wrapped as is
TColgp_Array2OfDir = NewType("TColgp_Array2OfDir", Any)
# the following typedef cannot be wrapped as is
TColgp_Array2OfDir2d = NewType("TColgp_Array2OfDir2d", Any)
# the following typedef cannot be wrapped as is
TColgp_Array2OfLin2d = NewType("TColgp_Array2OfLin2d", Any)
# the following typedef cannot be wrapped as is
TColgp_Array2OfPnt = NewType("TColgp_Array2OfPnt", Any)
# the following typedef cannot be wrapped as is
TColgp_Array2OfPnt2d = NewType("TColgp_Array2OfPnt2d", Any)
# the following typedef cannot be wrapped as is
TColgp_Array2OfVec = NewType("TColgp_Array2OfVec", Any)
# the following typedef cannot be wrapped as is
TColgp_Array2OfVec2d = NewType("TColgp_Array2OfVec2d", Any)
# the following typedef cannot be wrapped as is
TColgp_Array2OfXY = NewType("TColgp_Array2OfXY", Any)
# the following typedef cannot be wrapped as is
TColgp_Array2OfXYZ = NewType("TColgp_Array2OfXYZ", Any)

class TColgp_Array1OfCirc2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> gp_Circ2d: ...
    def __setitem__(self, index: int, value: gp_Circ2d) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[gp_Circ2d]: ...
    def next(self) -> gp_Circ2d: ...
    __next__ = next
    def Init(self, theValue: gp_Circ2d) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> gp_Circ2d: ...
    def Last(self) -> gp_Circ2d: ...
    def Value(self, theIndex: int) -> gp_Circ2d: ...
    def SetValue(self, theIndex: int, theValue: gp_Circ2d) -> None: ...

class TColgp_Array1OfDir:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> gp_Dir: ...
    def __setitem__(self, index: int, value: gp_Dir) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[gp_Dir]: ...
    def next(self) -> gp_Dir: ...
    __next__ = next
    def Init(self, theValue: gp_Dir) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> gp_Dir: ...
    def Last(self) -> gp_Dir: ...
    def Value(self, theIndex: int) -> gp_Dir: ...
    def SetValue(self, theIndex: int, theValue: gp_Dir) -> None: ...

class TColgp_Array1OfDir2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> gp_Dir2d: ...
    def __setitem__(self, index: int, value: gp_Dir2d) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[gp_Dir2d]: ...
    def next(self) -> gp_Dir2d: ...
    __next__ = next
    def Init(self, theValue: gp_Dir2d) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> gp_Dir2d: ...
    def Last(self) -> gp_Dir2d: ...
    def Value(self, theIndex: int) -> gp_Dir2d: ...
    def SetValue(self, theIndex: int, theValue: gp_Dir2d) -> None: ...

class TColgp_Array1OfLin2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> gp_Lin2d: ...
    def __setitem__(self, index: int, value: gp_Lin2d) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[gp_Lin2d]: ...
    def next(self) -> gp_Lin2d: ...
    __next__ = next
    def Init(self, theValue: gp_Lin2d) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> gp_Lin2d: ...
    def Last(self) -> gp_Lin2d: ...
    def Value(self, theIndex: int) -> gp_Lin2d: ...
    def SetValue(self, theIndex: int, theValue: gp_Lin2d) -> None: ...

class TColgp_Array1OfPnt:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> gp_Pnt: ...
    def __setitem__(self, index: int, value: gp_Pnt) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[gp_Pnt]: ...
    def next(self) -> gp_Pnt: ...
    __next__ = next
    def Init(self, theValue: gp_Pnt) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> gp_Pnt: ...
    def Last(self) -> gp_Pnt: ...
    def Value(self, theIndex: int) -> gp_Pnt: ...
    def SetValue(self, theIndex: int, theValue: gp_Pnt) -> None: ...

class TColgp_Array1OfPnt2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> gp_Pnt2d: ...
    def __setitem__(self, index: int, value: gp_Pnt2d) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[gp_Pnt2d]: ...
    def next(self) -> gp_Pnt2d: ...
    __next__ = next
    def Init(self, theValue: gp_Pnt2d) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> gp_Pnt2d: ...
    def Last(self) -> gp_Pnt2d: ...
    def Value(self, theIndex: int) -> gp_Pnt2d: ...
    def SetValue(self, theIndex: int, theValue: gp_Pnt2d) -> None: ...

class TColgp_Array1OfVec:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> gp_Vec: ...
    def __setitem__(self, index: int, value: gp_Vec) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[gp_Vec]: ...
    def next(self) -> gp_Vec: ...
    __next__ = next
    def Init(self, theValue: gp_Vec) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> gp_Vec: ...
    def Last(self) -> gp_Vec: ...
    def Value(self, theIndex: int) -> gp_Vec: ...
    def SetValue(self, theIndex: int, theValue: gp_Vec) -> None: ...

class TColgp_Array1OfVec2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> gp_Vec2d: ...
    def __setitem__(self, index: int, value: gp_Vec2d) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[gp_Vec2d]: ...
    def next(self) -> gp_Vec2d: ...
    __next__ = next
    def Init(self, theValue: gp_Vec2d) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> gp_Vec2d: ...
    def Last(self) -> gp_Vec2d: ...
    def Value(self, theIndex: int) -> gp_Vec2d: ...
    def SetValue(self, theIndex: int, theValue: gp_Vec2d) -> None: ...

class TColgp_Array1OfXY:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> gp_XY: ...
    def __setitem__(self, index: int, value: gp_XY) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[gp_XY]: ...
    def next(self) -> gp_XY: ...
    __next__ = next
    def Init(self, theValue: gp_XY) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> gp_XY: ...
    def Last(self) -> gp_XY: ...
    def Value(self, theIndex: int) -> gp_XY: ...
    def SetValue(self, theIndex: int, theValue: gp_XY) -> None: ...

class TColgp_Array1OfXYZ:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> gp_XYZ: ...
    def __setitem__(self, index: int, value: gp_XYZ) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[gp_XYZ]: ...
    def next(self) -> gp_XYZ: ...
    __next__ = next
    def Init(self, theValue: gp_XYZ) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> gp_XYZ: ...
    def Last(self) -> gp_XYZ: ...
    def Value(self, theIndex: int) -> gp_XYZ: ...
    def SetValue(self, theIndex: int, theValue: gp_XYZ) -> None: ...

class TColgp_SequenceOfArray1OfPnt2d:
    def Assign(self, theItem: False) -> False: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> False: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColgp_SequenceOfAx1:
    def Assign(self, theItem: gp_Ax1) -> gp_Ax1: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_Ax1: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> gp_Ax1: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: gp_Ax1) -> gp_Ax1: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_Ax1) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> gp_Ax1: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColgp_SequenceOfDir:
    def Assign(self, theItem: gp_Dir) -> gp_Dir: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_Dir: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> gp_Dir: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: gp_Dir) -> gp_Dir: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_Dir) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> gp_Dir: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColgp_SequenceOfDir2d:
    def Assign(self, theItem: gp_Dir2d) -> gp_Dir2d: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_Dir2d: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> gp_Dir2d: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: gp_Dir2d) -> gp_Dir2d: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_Dir2d) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> gp_Dir2d: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColgp_SequenceOfPnt:
    def Assign(self, theItem: gp_Pnt) -> gp_Pnt: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_Pnt: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> gp_Pnt: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: gp_Pnt) -> gp_Pnt: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_Pnt) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> gp_Pnt: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColgp_SequenceOfPnt2d:
    def Assign(self, theItem: gp_Pnt2d) -> gp_Pnt2d: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_Pnt2d: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> gp_Pnt2d: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: gp_Pnt2d) -> gp_Pnt2d: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_Pnt2d) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> gp_Pnt2d: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColgp_SequenceOfVec:
    def Assign(self, theItem: gp_Vec) -> gp_Vec: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_Vec: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> gp_Vec: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: gp_Vec) -> gp_Vec: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_Vec) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> gp_Vec: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColgp_SequenceOfVec2d:
    def Assign(self, theItem: gp_Vec2d) -> gp_Vec2d: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_Vec2d: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> gp_Vec2d: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: gp_Vec2d) -> gp_Vec2d: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_Vec2d) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> gp_Vec2d: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColgp_SequenceOfXY:
    def Assign(self, theItem: gp_XY) -> gp_XY: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_XY: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> gp_XY: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: gp_XY) -> gp_XY: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_XY) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> gp_XY: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class TColgp_SequenceOfXYZ:
    def Assign(self, theItem: gp_XYZ) -> gp_XYZ: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_XYZ: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> gp_XYZ: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: gp_XYZ) -> gp_XYZ: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: gp_XYZ) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> gp_XYZ: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

# harray1 classes

class TColgp_HArray1OfCirc2d(TColgp_Array1OfCirc2d, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColgp_Array1OfCirc2d: ...

class TColgp_HArray1OfDir(TColgp_Array1OfDir, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColgp_Array1OfDir: ...

class TColgp_HArray1OfDir2d(TColgp_Array1OfDir2d, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColgp_Array1OfDir2d: ...

class TColgp_HArray1OfLin2d(TColgp_Array1OfLin2d, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColgp_Array1OfLin2d: ...

class TColgp_HArray1OfPnt(TColgp_Array1OfPnt, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColgp_Array1OfPnt: ...

class TColgp_HArray1OfPnt2d(TColgp_Array1OfPnt2d, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColgp_Array1OfPnt2d: ...

class TColgp_HArray1OfVec(TColgp_Array1OfVec, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColgp_Array1OfVec: ...

class TColgp_HArray1OfVec2d(TColgp_Array1OfVec2d, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColgp_Array1OfVec2d: ...

class TColgp_HArray1OfXY(TColgp_Array1OfXY, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColgp_Array1OfXY: ...

class TColgp_HArray1OfXYZ(TColgp_Array1OfXYZ, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColgp_Array1OfXYZ: ...

# harray2 classes

class TColgp_HArray2OfCirc2d(TColgp_Array2OfCirc2d, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TColgp_Array2OfCirc2d) -> None: ...
    def Array2(self) -> TColgp_Array2OfCirc2d: ...

class TColgp_HArray2OfDir(TColgp_Array2OfDir, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TColgp_Array2OfDir) -> None: ...
    def Array2(self) -> TColgp_Array2OfDir: ...

class TColgp_HArray2OfDir2d(TColgp_Array2OfDir2d, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TColgp_Array2OfDir2d) -> None: ...
    def Array2(self) -> TColgp_Array2OfDir2d: ...

class TColgp_HArray2OfLin2d(TColgp_Array2OfLin2d, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TColgp_Array2OfLin2d) -> None: ...
    def Array2(self) -> TColgp_Array2OfLin2d: ...

class TColgp_HArray2OfPnt(TColgp_Array2OfPnt, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TColgp_Array2OfPnt) -> None: ...
    def Array2(self) -> TColgp_Array2OfPnt: ...

class TColgp_HArray2OfPnt2d(TColgp_Array2OfPnt2d, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TColgp_Array2OfPnt2d) -> None: ...
    def Array2(self) -> TColgp_Array2OfPnt2d: ...

class TColgp_HArray2OfVec(TColgp_Array2OfVec, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TColgp_Array2OfVec) -> None: ...
    def Array2(self) -> TColgp_Array2OfVec: ...

class TColgp_HArray2OfVec2d(TColgp_Array2OfVec2d, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TColgp_Array2OfVec2d) -> None: ...
    def Array2(self) -> TColgp_Array2OfVec2d: ...

class TColgp_HArray2OfXY(TColgp_Array2OfXY, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TColgp_Array2OfXY) -> None: ...
    def Array2(self) -> TColgp_Array2OfXY: ...

class TColgp_HArray2OfXYZ(TColgp_Array2OfXYZ, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TColgp_Array2OfXYZ) -> None: ...
    def Array2(self) -> TColgp_Array2OfXYZ: ...

# hsequence classes

class TColgp_HSequenceOfDir(TColgp_SequenceOfDir, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TColgp_SequenceOfDir) -> None: ...
    def Sequence(self) -> TColgp_SequenceOfDir: ...
    def Append(self, theSequence: TColgp_SequenceOfDir) -> None: ...

class TColgp_HSequenceOfDir2d(TColgp_SequenceOfDir2d, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TColgp_SequenceOfDir2d) -> None: ...
    def Sequence(self) -> TColgp_SequenceOfDir2d: ...
    def Append(self, theSequence: TColgp_SequenceOfDir2d) -> None: ...

class TColgp_HSequenceOfPnt(TColgp_SequenceOfPnt, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TColgp_SequenceOfPnt) -> None: ...
    def Sequence(self) -> TColgp_SequenceOfPnt: ...
    def Append(self, theSequence: TColgp_SequenceOfPnt) -> None: ...

class TColgp_HSequenceOfPnt2d(TColgp_SequenceOfPnt2d, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TColgp_SequenceOfPnt2d) -> None: ...
    def Sequence(self) -> TColgp_SequenceOfPnt2d: ...
    def Append(self, theSequence: TColgp_SequenceOfPnt2d) -> None: ...

class TColgp_HSequenceOfVec(TColgp_SequenceOfVec, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TColgp_SequenceOfVec) -> None: ...
    def Sequence(self) -> TColgp_SequenceOfVec: ...
    def Append(self, theSequence: TColgp_SequenceOfVec) -> None: ...

class TColgp_HSequenceOfVec2d(TColgp_SequenceOfVec2d, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TColgp_SequenceOfVec2d) -> None: ...
    def Sequence(self) -> TColgp_SequenceOfVec2d: ...
    def Append(self, theSequence: TColgp_SequenceOfVec2d) -> None: ...

class TColgp_HSequenceOfXY(TColgp_SequenceOfXY, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TColgp_SequenceOfXY) -> None: ...
    def Sequence(self) -> TColgp_SequenceOfXY: ...
    def Append(self, theSequence: TColgp_SequenceOfXY) -> None: ...

class TColgp_HSequenceOfXYZ(TColgp_SequenceOfXYZ, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TColgp_SequenceOfXYZ) -> None: ...
    def Sequence(self) -> TColgp_SequenceOfXYZ: ...
    def Append(self, theSequence: TColgp_SequenceOfXYZ) -> None: ...
