from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *

# the following typedef cannot be wrapped as is
TShort_Array2OfShortReal = NewType("TShort_Array2OfShortReal", Any)

class TShort_Array1OfShortReal:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> float: ...
    def __setitem__(self, index: int, value: float) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[float]: ...
    def next(self) -> float: ...
    __next__ = next
    def Init(self, theValue: float) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> float: ...
    def Last(self) -> float: ...
    def Value(self, theIndex: int) -> float: ...
    def SetValue(self, theIndex: int, theValue: float) -> None: ...

class TShort_SequenceOfShortReal:
    def Assign(self, theItem: float) -> float: ...
    def Clear(self) -> None: ...
    def First(self) -> float: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> float: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(self, theItem: float) -> float: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: float) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> float: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

# harray1 classes

class TShort_HArray1OfShortReal(TShort_Array1OfShortReal, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TShort_Array1OfShortReal: ...

# harray2 classes

class TShort_HArray2OfShortReal(TShort_Array2OfShortReal, Standard_Transient):
    @overload
    def __init__(
        self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int
    ) -> None: ...
    @overload
    def __init__(self, theOther: TShort_Array2OfShortReal) -> None: ...
    def Array2(self) -> TShort_Array2OfShortReal: ...

# hsequence classes

class TShort_HSequenceOfShortReal(TShort_SequenceOfShortReal, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: TShort_SequenceOfShortReal) -> None: ...
    def Sequence(self) -> TShort_SequenceOfShortReal: ...
    def Append(self, theSequence: TShort_SequenceOfShortReal) -> None: ...
