from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.RWMesh import *
from OCC.Core.VrmlConverter import *
from OCC.Core.Vrml import *
from OCC.Core.Quantity import *
from OCC.Core.TDocStd import *

class VrmlAPI_RepresentationOfShape(IntEnum):
    VrmlAPI_ShadedRepresentation: int = ...
    VrmlAPI_WireFrameRepresentation: int = ...
    VrmlAPI_BothRepresentation: int = ...

VrmlAPI_ShadedRepresentation = (
    VrmlAPI_RepresentationOfShape.VrmlAPI_ShadedRepresentation
)
VrmlAPI_WireFrameRepresentation = (
    VrmlAPI_RepresentationOfShape.VrmlAPI_WireFrameRepresentation
)
VrmlAPI_BothRepresentation = VrmlAPI_RepresentationOfShape.VrmlAPI_BothRepresentation

class vrmlapi:
    @staticmethod
    def Write(
        aShape: TopoDS_Shape, aFileName: str, aVersion: Optional[int] = 2
    ) -> bool: ...

class VrmlAPI_CafReader(RWMesh_CafReader):
    pass

class VrmlAPI_Writer:
    def __init__(self) -> None: ...
    def Drawer(self) -> VrmlConverter_Drawer: ...
    def GetFreeBoundsMaterial(self) -> Vrml_Material: ...
    def GetFrontMaterial(self) -> Vrml_Material: ...
    def GetLineMaterial(self) -> Vrml_Material: ...
    def GetPointsMaterial(self) -> Vrml_Material: ...
    def GetRepresentation(self) -> VrmlAPI_RepresentationOfShape: ...
    def GetUisoMaterial(self) -> Vrml_Material: ...
    def GetUnfreeBoundsMaterial(self) -> Vrml_Material: ...
    def GetVisoMaterial(self) -> Vrml_Material: ...
    def GetWireMaterial(self) -> Vrml_Material: ...
    def ResetToDefaults(self) -> None: ...
    def SetAmbientColorToMaterial(
        self, aMaterial: Vrml_Material, Color: Quantity_HArray1OfColor
    ) -> None: ...
    def SetDeflection(self, aDef: float) -> None: ...
    def SetDiffuseColorToMaterial(
        self, aMaterial: Vrml_Material, Color: Quantity_HArray1OfColor
    ) -> None: ...
    def SetEmissiveColorToMaterial(
        self, aMaterial: Vrml_Material, Color: Quantity_HArray1OfColor
    ) -> None: ...
    def SetRepresentation(self, aRep: VrmlAPI_RepresentationOfShape) -> None: ...
    def SetShininessToMaterial(
        self, aMaterial: Vrml_Material, aShininess: float
    ) -> None: ...
    def SetSpecularColorToMaterial(
        self, aMaterial: Vrml_Material, Color: Quantity_HArray1OfColor
    ) -> None: ...
    def SetTransparencyToMaterial(
        self, aMaterial: Vrml_Material, aTransparency: float
    ) -> None: ...
    def Write(
        self, aShape: TopoDS_Shape, aFile: str, aVersion: Optional[int] = 2
    ) -> bool: ...
    def WriteDoc(
        self, theDoc: TDocStd_Document, theFile: str, theScale: float
    ) -> bool: ...

# harray1 classes
# harray2 classes
# hsequence classes
