/*
Copyright 2008-2025 Thomas Paviot (tpaviot@gmail.com)

This file is part of pythonOCC.
pythonOCC is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

pythonOCC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with pythonOCC.  If not, see <http://www.gnu.org/licenses/>.
*/
%define XCAFDIMTOLOBJECTSDOCSTRING
"XCAFDimTolObjects module, see official documentation at
https://dev.opencascade.org/doc/occt-7.9.0/refman/html/package_xcafdimtolobjects.html"
%enddef
%module (package="OCC.Core", docstring=XCAFDIMTOLOBJECTSDOCSTRING) XCAFDimTolObjects


%{
#ifdef WNT
#pragma warning(disable : 4716)
#endif
%}

%include ../common/CommonIncludes.i
%include ../common/ExceptionCatcher.i
%include ../common/FunctionTransformers.i
%include ../common/EnumTemplates.i
%include ../common/Operators.i
%include ../common/OccHandle.i
%include ../common/IOStream.i
%include ../common/ArrayMacros.i


%{
#include<XCAFDimTolObjects_module.hxx>

//Dependencies
#include<Standard_module.hxx>
#include<NCollection_module.hxx>
#include<TopoDS_module.hxx>
#include<gp_module.hxx>
#include<TCollection_module.hxx>
#include<TColStd_module.hxx>
#include<TDocStd_module.hxx>
#include<Message_module.hxx>
#include<CDF_module.hxx>
#include<CDM_module.hxx>
#include<PCDM_module.hxx>
#include<LDOM_module.hxx>
#include<TDF_module.hxx>
#include<Resource_module.hxx>
#include<TopLoc_module.hxx>
#include<TColgp_module.hxx>
#include<TColStd_module.hxx>
#include<TCollection_module.hxx>
#include<Storage_module.hxx>
%};
%import Standard.i
%import NCollection.i
%import TopoDS.i
%import gp.i
%import TCollection.i
%import TColStd.i
%import TDocStd.i

%pythoncode {
from enum import IntEnum
from OCC.Core.Exception import *
};

/* public enums */
enum XCAFDimTolObjects_AngularQualifier {
	XCAFDimTolObjects_AngularQualifier_None = 0,
	XCAFDimTolObjects_AngularQualifier_Small = 1,
	XCAFDimTolObjects_AngularQualifier_Large = 2,
	XCAFDimTolObjects_AngularQualifier_Equal = 3,
};

enum XCAFDimTolObjects_DatumModifWithValue {
	XCAFDimTolObjects_DatumModifWithValue_None = 0,
	XCAFDimTolObjects_DatumModifWithValue_CircularOrCylindrical = 1,
	XCAFDimTolObjects_DatumModifWithValue_Distance = 2,
	XCAFDimTolObjects_DatumModifWithValue_Projected = 3,
	XCAFDimTolObjects_DatumModifWithValue_Spherical = 4,
};

enum XCAFDimTolObjects_DatumSingleModif {
	XCAFDimTolObjects_DatumSingleModif_AnyCrossSection = 0,
	XCAFDimTolObjects_DatumSingleModif_Any_LongitudinalSection = 1,
	XCAFDimTolObjects_DatumSingleModif_Basic = 2,
	XCAFDimTolObjects_DatumSingleModif_ContactingFeature = 3,
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintU = 4,
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintV = 5,
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintW = 6,
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintX = 7,
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintY = 8,
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintZ = 9,
	XCAFDimTolObjects_DatumSingleModif_DistanceVariable = 10,
	XCAFDimTolObjects_DatumSingleModif_FreeState = 11,
	XCAFDimTolObjects_DatumSingleModif_LeastMaterialRequirement = 12,
	XCAFDimTolObjects_DatumSingleModif_Line = 13,
	XCAFDimTolObjects_DatumSingleModif_MajorDiameter = 14,
	XCAFDimTolObjects_DatumSingleModif_MaximumMaterialRequirement = 15,
	XCAFDimTolObjects_DatumSingleModif_MinorDiameter = 16,
	XCAFDimTolObjects_DatumSingleModif_Orientation = 17,
	XCAFDimTolObjects_DatumSingleModif_PitchDiameter = 18,
	XCAFDimTolObjects_DatumSingleModif_Plane = 19,
	XCAFDimTolObjects_DatumSingleModif_Point = 20,
	XCAFDimTolObjects_DatumSingleModif_Translation = 21,
};

enum XCAFDimTolObjects_DatumTargetType {
	XCAFDimTolObjects_DatumTargetType_Point = 0,
	XCAFDimTolObjects_DatumTargetType_Line = 1,
	XCAFDimTolObjects_DatumTargetType_Rectangle = 2,
	XCAFDimTolObjects_DatumTargetType_Circle = 3,
	XCAFDimTolObjects_DatumTargetType_Area = 4,
};

enum XCAFDimTolObjects_DimensionFormVariance {
	XCAFDimTolObjects_DimensionFormVariance_None = 0,
	XCAFDimTolObjects_DimensionFormVariance_A = 1,
	XCAFDimTolObjects_DimensionFormVariance_B = 2,
	XCAFDimTolObjects_DimensionFormVariance_C = 3,
	XCAFDimTolObjects_DimensionFormVariance_CD = 4,
	XCAFDimTolObjects_DimensionFormVariance_D = 5,
	XCAFDimTolObjects_DimensionFormVariance_E = 6,
	XCAFDimTolObjects_DimensionFormVariance_EF = 7,
	XCAFDimTolObjects_DimensionFormVariance_F = 8,
	XCAFDimTolObjects_DimensionFormVariance_FG = 9,
	XCAFDimTolObjects_DimensionFormVariance_G = 10,
	XCAFDimTolObjects_DimensionFormVariance_H = 11,
	XCAFDimTolObjects_DimensionFormVariance_JS = 12,
	XCAFDimTolObjects_DimensionFormVariance_J = 13,
	XCAFDimTolObjects_DimensionFormVariance_K = 14,
	XCAFDimTolObjects_DimensionFormVariance_M = 15,
	XCAFDimTolObjects_DimensionFormVariance_N = 16,
	XCAFDimTolObjects_DimensionFormVariance_P = 17,
	XCAFDimTolObjects_DimensionFormVariance_R = 18,
	XCAFDimTolObjects_DimensionFormVariance_S = 19,
	XCAFDimTolObjects_DimensionFormVariance_T = 20,
	XCAFDimTolObjects_DimensionFormVariance_U = 21,
	XCAFDimTolObjects_DimensionFormVariance_V = 22,
	XCAFDimTolObjects_DimensionFormVariance_X = 23,
	XCAFDimTolObjects_DimensionFormVariance_Y = 24,
	XCAFDimTolObjects_DimensionFormVariance_Z = 25,
	XCAFDimTolObjects_DimensionFormVariance_ZA = 26,
	XCAFDimTolObjects_DimensionFormVariance_ZB = 27,
	XCAFDimTolObjects_DimensionFormVariance_ZC = 28,
};

enum XCAFDimTolObjects_DimensionGrade {
	XCAFDimTolObjects_DimensionGrade_IT01 = 0,
	XCAFDimTolObjects_DimensionGrade_IT0 = 1,
	XCAFDimTolObjects_DimensionGrade_IT1 = 2,
	XCAFDimTolObjects_DimensionGrade_IT2 = 3,
	XCAFDimTolObjects_DimensionGrade_IT3 = 4,
	XCAFDimTolObjects_DimensionGrade_IT4 = 5,
	XCAFDimTolObjects_DimensionGrade_IT5 = 6,
	XCAFDimTolObjects_DimensionGrade_IT6 = 7,
	XCAFDimTolObjects_DimensionGrade_IT7 = 8,
	XCAFDimTolObjects_DimensionGrade_IT8 = 9,
	XCAFDimTolObjects_DimensionGrade_IT9 = 10,
	XCAFDimTolObjects_DimensionGrade_IT10 = 11,
	XCAFDimTolObjects_DimensionGrade_IT11 = 12,
	XCAFDimTolObjects_DimensionGrade_IT12 = 13,
	XCAFDimTolObjects_DimensionGrade_IT13 = 14,
	XCAFDimTolObjects_DimensionGrade_IT14 = 15,
	XCAFDimTolObjects_DimensionGrade_IT15 = 16,
	XCAFDimTolObjects_DimensionGrade_IT16 = 17,
	XCAFDimTolObjects_DimensionGrade_IT17 = 18,
	XCAFDimTolObjects_DimensionGrade_IT18 = 19,
};

enum XCAFDimTolObjects_DimensionModif {
	XCAFDimTolObjects_DimensionModif_ControlledRadius = 0,
	XCAFDimTolObjects_DimensionModif_Square = 1,
	XCAFDimTolObjects_DimensionModif_StatisticalTolerance = 2,
	XCAFDimTolObjects_DimensionModif_ContinuousFeature = 3,
	XCAFDimTolObjects_DimensionModif_TwoPointSize = 4,
	XCAFDimTolObjects_DimensionModif_LocalSizeDefinedBySphere = 5,
	XCAFDimTolObjects_DimensionModif_LeastSquaresAssociationCriterion = 6,
	XCAFDimTolObjects_DimensionModif_MaximumInscribedAssociation = 7,
	XCAFDimTolObjects_DimensionModif_MinimumCircumscribedAssociation = 8,
	XCAFDimTolObjects_DimensionModif_CircumferenceDiameter = 9,
	XCAFDimTolObjects_DimensionModif_AreaDiameter = 10,
	XCAFDimTolObjects_DimensionModif_VolumeDiameter = 11,
	XCAFDimTolObjects_DimensionModif_MaximumSize = 12,
	XCAFDimTolObjects_DimensionModif_MinimumSize = 13,
	XCAFDimTolObjects_DimensionModif_AverageSize = 14,
	XCAFDimTolObjects_DimensionModif_MedianSize = 15,
	XCAFDimTolObjects_DimensionModif_MidRangeSize = 16,
	XCAFDimTolObjects_DimensionModif_RangeOfSizes = 17,
	XCAFDimTolObjects_DimensionModif_AnyRestrictedPortionOfFeature = 18,
	XCAFDimTolObjects_DimensionModif_AnyCrossSection = 19,
	XCAFDimTolObjects_DimensionModif_SpecificFixedCrossSection = 20,
	XCAFDimTolObjects_DimensionModif_CommonTolerance = 21,
	XCAFDimTolObjects_DimensionModif_FreeStateCondition = 22,
	XCAFDimTolObjects_DimensionModif_Between = 23,
};

enum XCAFDimTolObjects_DimensionQualifier {
	XCAFDimTolObjects_DimensionQualifier_None = 0,
	XCAFDimTolObjects_DimensionQualifier_Min = 1,
	XCAFDimTolObjects_DimensionQualifier_Max = 2,
	XCAFDimTolObjects_DimensionQualifier_Avg = 3,
};

enum XCAFDimTolObjects_DimensionType {
	XCAFDimTolObjects_DimensionType_Location_None = 0,
	XCAFDimTolObjects_DimensionType_Location_CurvedDistance = 1,
	XCAFDimTolObjects_DimensionType_Location_LinearDistance = 2,
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToOuter = 3,
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToInner = 4,
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToCenter = 5,
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToOuter = 6,
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToInner = 7,
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToCenter = 8,
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToOuter = 9,
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToInner = 10,
	XCAFDimTolObjects_DimensionType_Location_Angular = 11,
	XCAFDimTolObjects_DimensionType_Location_Oriented = 12,
	XCAFDimTolObjects_DimensionType_Location_WithPath = 13,
	XCAFDimTolObjects_DimensionType_Size_CurveLength = 14,
	XCAFDimTolObjects_DimensionType_Size_Diameter = 15,
	XCAFDimTolObjects_DimensionType_Size_SphericalDiameter = 16,
	XCAFDimTolObjects_DimensionType_Size_Radius = 17,
	XCAFDimTolObjects_DimensionType_Size_SphericalRadius = 18,
	XCAFDimTolObjects_DimensionType_Size_ToroidalMinorDiameter = 19,
	XCAFDimTolObjects_DimensionType_Size_ToroidalMajorDiameter = 20,
	XCAFDimTolObjects_DimensionType_Size_ToroidalMinorRadius = 21,
	XCAFDimTolObjects_DimensionType_Size_ToroidalMajorRadius = 22,
	XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorDiameter = 23,
	XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorDiameter = 24,
	XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorRadius = 25,
	XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorRadius = 26,
	XCAFDimTolObjects_DimensionType_Size_Thickness = 27,
	XCAFDimTolObjects_DimensionType_Size_Angular = 28,
	XCAFDimTolObjects_DimensionType_Size_WithPath = 29,
	XCAFDimTolObjects_DimensionType_CommonLabel = 30,
	XCAFDimTolObjects_DimensionType_DimensionPresentation = 31,
};

enum XCAFDimTolObjects_GeomToleranceMatReqModif {
	XCAFDimTolObjects_GeomToleranceMatReqModif_None = 0,
	XCAFDimTolObjects_GeomToleranceMatReqModif_M = 1,
	XCAFDimTolObjects_GeomToleranceMatReqModif_L = 2,
};

enum XCAFDimTolObjects_GeomToleranceModif {
	XCAFDimTolObjects_GeomToleranceModif_Any_Cross_Section = 0,
	XCAFDimTolObjects_GeomToleranceModif_Common_Zone = 1,
	XCAFDimTolObjects_GeomToleranceModif_Each_Radial_Element = 2,
	XCAFDimTolObjects_GeomToleranceModif_Free_State = 3,
	XCAFDimTolObjects_GeomToleranceModif_Least_Material_Requirement = 4,
	XCAFDimTolObjects_GeomToleranceModif_Line_Element = 5,
	XCAFDimTolObjects_GeomToleranceModif_Major_Diameter = 6,
	XCAFDimTolObjects_GeomToleranceModif_Maximum_Material_Requirement = 7,
	XCAFDimTolObjects_GeomToleranceModif_Minor_Diameter = 8,
	XCAFDimTolObjects_GeomToleranceModif_Not_Convex = 9,
	XCAFDimTolObjects_GeomToleranceModif_Pitch_Diameter = 10,
	XCAFDimTolObjects_GeomToleranceModif_Reciprocity_Requirement = 11,
	XCAFDimTolObjects_GeomToleranceModif_Separate_Requirement = 12,
	XCAFDimTolObjects_GeomToleranceModif_Statistical_Tolerance = 13,
	XCAFDimTolObjects_GeomToleranceModif_Tangent_Plane = 14,
	XCAFDimTolObjects_GeomToleranceModif_All_Around = 15,
	XCAFDimTolObjects_GeomToleranceModif_All_Over = 16,
};

enum XCAFDimTolObjects_GeomToleranceType {
	XCAFDimTolObjects_GeomToleranceType_None = 0,
	XCAFDimTolObjects_GeomToleranceType_Angularity = 1,
	XCAFDimTolObjects_GeomToleranceType_CircularRunout = 2,
	XCAFDimTolObjects_GeomToleranceType_CircularityOrRoundness = 3,
	XCAFDimTolObjects_GeomToleranceType_Coaxiality = 4,
	XCAFDimTolObjects_GeomToleranceType_Concentricity = 5,
	XCAFDimTolObjects_GeomToleranceType_Cylindricity = 6,
	XCAFDimTolObjects_GeomToleranceType_Flatness = 7,
	XCAFDimTolObjects_GeomToleranceType_Parallelism = 8,
	XCAFDimTolObjects_GeomToleranceType_Perpendicularity = 9,
	XCAFDimTolObjects_GeomToleranceType_Position = 10,
	XCAFDimTolObjects_GeomToleranceType_ProfileOfLine = 11,
	XCAFDimTolObjects_GeomToleranceType_ProfileOfSurface = 12,
	XCAFDimTolObjects_GeomToleranceType_Straightness = 13,
	XCAFDimTolObjects_GeomToleranceType_Symmetry = 14,
	XCAFDimTolObjects_GeomToleranceType_TotalRunout = 15,
};

enum XCAFDimTolObjects_GeomToleranceTypeValue {
	XCAFDimTolObjects_GeomToleranceTypeValue_None = 0,
	XCAFDimTolObjects_GeomToleranceTypeValue_Diameter = 1,
	XCAFDimTolObjects_GeomToleranceTypeValue_SphericalDiameter = 2,
};

enum XCAFDimTolObjects_GeomToleranceZoneModif {
	XCAFDimTolObjects_GeomToleranceZoneModif_None = 0,
	XCAFDimTolObjects_GeomToleranceZoneModif_Projected = 1,
	XCAFDimTolObjects_GeomToleranceZoneModif_Runout = 2,
	XCAFDimTolObjects_GeomToleranceZoneModif_NonUniform = 3,
};

enum XCAFDimTolObjects_ToleranceZoneAffectedPlane {
	XCAFDimTolObjects_ToleranceZoneAffectedPlane_None = 0,
	XCAFDimTolObjects_ToleranceZoneAffectedPlane_Intersection = 1,
	XCAFDimTolObjects_ToleranceZoneAffectedPlane_Orientation = 2,
};

/* end public enums declaration */

/* python proxy classes for enums */
%pythoncode {

class XCAFDimTolObjects_AngularQualifier(IntEnum):
	XCAFDimTolObjects_AngularQualifier_None = 0
	XCAFDimTolObjects_AngularQualifier_Small = 1
	XCAFDimTolObjects_AngularQualifier_Large = 2
	XCAFDimTolObjects_AngularQualifier_Equal = 3
XCAFDimTolObjects_AngularQualifier_None = XCAFDimTolObjects_AngularQualifier.XCAFDimTolObjects_AngularQualifier_None
XCAFDimTolObjects_AngularQualifier_Small = XCAFDimTolObjects_AngularQualifier.XCAFDimTolObjects_AngularQualifier_Small
XCAFDimTolObjects_AngularQualifier_Large = XCAFDimTolObjects_AngularQualifier.XCAFDimTolObjects_AngularQualifier_Large
XCAFDimTolObjects_AngularQualifier_Equal = XCAFDimTolObjects_AngularQualifier.XCAFDimTolObjects_AngularQualifier_Equal

class XCAFDimTolObjects_DatumModifWithValue(IntEnum):
	XCAFDimTolObjects_DatumModifWithValue_None = 0
	XCAFDimTolObjects_DatumModifWithValue_CircularOrCylindrical = 1
	XCAFDimTolObjects_DatumModifWithValue_Distance = 2
	XCAFDimTolObjects_DatumModifWithValue_Projected = 3
	XCAFDimTolObjects_DatumModifWithValue_Spherical = 4
XCAFDimTolObjects_DatumModifWithValue_None = XCAFDimTolObjects_DatumModifWithValue.XCAFDimTolObjects_DatumModifWithValue_None
XCAFDimTolObjects_DatumModifWithValue_CircularOrCylindrical = XCAFDimTolObjects_DatumModifWithValue.XCAFDimTolObjects_DatumModifWithValue_CircularOrCylindrical
XCAFDimTolObjects_DatumModifWithValue_Distance = XCAFDimTolObjects_DatumModifWithValue.XCAFDimTolObjects_DatumModifWithValue_Distance
XCAFDimTolObjects_DatumModifWithValue_Projected = XCAFDimTolObjects_DatumModifWithValue.XCAFDimTolObjects_DatumModifWithValue_Projected
XCAFDimTolObjects_DatumModifWithValue_Spherical = XCAFDimTolObjects_DatumModifWithValue.XCAFDimTolObjects_DatumModifWithValue_Spherical

class XCAFDimTolObjects_DatumSingleModif(IntEnum):
	XCAFDimTolObjects_DatumSingleModif_AnyCrossSection = 0
	XCAFDimTolObjects_DatumSingleModif_Any_LongitudinalSection = 1
	XCAFDimTolObjects_DatumSingleModif_Basic = 2
	XCAFDimTolObjects_DatumSingleModif_ContactingFeature = 3
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintU = 4
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintV = 5
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintW = 6
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintX = 7
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintY = 8
	XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintZ = 9
	XCAFDimTolObjects_DatumSingleModif_DistanceVariable = 10
	XCAFDimTolObjects_DatumSingleModif_FreeState = 11
	XCAFDimTolObjects_DatumSingleModif_LeastMaterialRequirement = 12
	XCAFDimTolObjects_DatumSingleModif_Line = 13
	XCAFDimTolObjects_DatumSingleModif_MajorDiameter = 14
	XCAFDimTolObjects_DatumSingleModif_MaximumMaterialRequirement = 15
	XCAFDimTolObjects_DatumSingleModif_MinorDiameter = 16
	XCAFDimTolObjects_DatumSingleModif_Orientation = 17
	XCAFDimTolObjects_DatumSingleModif_PitchDiameter = 18
	XCAFDimTolObjects_DatumSingleModif_Plane = 19
	XCAFDimTolObjects_DatumSingleModif_Point = 20
	XCAFDimTolObjects_DatumSingleModif_Translation = 21
XCAFDimTolObjects_DatumSingleModif_AnyCrossSection = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_AnyCrossSection
XCAFDimTolObjects_DatumSingleModif_Any_LongitudinalSection = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Any_LongitudinalSection
XCAFDimTolObjects_DatumSingleModif_Basic = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Basic
XCAFDimTolObjects_DatumSingleModif_ContactingFeature = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_ContactingFeature
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintU = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintU
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintV = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintV
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintW = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintW
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintX = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintX
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintY = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintY
XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintZ = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DegreeOfFreedomConstraintZ
XCAFDimTolObjects_DatumSingleModif_DistanceVariable = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_DistanceVariable
XCAFDimTolObjects_DatumSingleModif_FreeState = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_FreeState
XCAFDimTolObjects_DatumSingleModif_LeastMaterialRequirement = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_LeastMaterialRequirement
XCAFDimTolObjects_DatumSingleModif_Line = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Line
XCAFDimTolObjects_DatumSingleModif_MajorDiameter = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_MajorDiameter
XCAFDimTolObjects_DatumSingleModif_MaximumMaterialRequirement = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_MaximumMaterialRequirement
XCAFDimTolObjects_DatumSingleModif_MinorDiameter = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_MinorDiameter
XCAFDimTolObjects_DatumSingleModif_Orientation = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Orientation
XCAFDimTolObjects_DatumSingleModif_PitchDiameter = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_PitchDiameter
XCAFDimTolObjects_DatumSingleModif_Plane = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Plane
XCAFDimTolObjects_DatumSingleModif_Point = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Point
XCAFDimTolObjects_DatumSingleModif_Translation = XCAFDimTolObjects_DatumSingleModif.XCAFDimTolObjects_DatumSingleModif_Translation

class XCAFDimTolObjects_DatumTargetType(IntEnum):
	XCAFDimTolObjects_DatumTargetType_Point = 0
	XCAFDimTolObjects_DatumTargetType_Line = 1
	XCAFDimTolObjects_DatumTargetType_Rectangle = 2
	XCAFDimTolObjects_DatumTargetType_Circle = 3
	XCAFDimTolObjects_DatumTargetType_Area = 4
XCAFDimTolObjects_DatumTargetType_Point = XCAFDimTolObjects_DatumTargetType.XCAFDimTolObjects_DatumTargetType_Point
XCAFDimTolObjects_DatumTargetType_Line = XCAFDimTolObjects_DatumTargetType.XCAFDimTolObjects_DatumTargetType_Line
XCAFDimTolObjects_DatumTargetType_Rectangle = XCAFDimTolObjects_DatumTargetType.XCAFDimTolObjects_DatumTargetType_Rectangle
XCAFDimTolObjects_DatumTargetType_Circle = XCAFDimTolObjects_DatumTargetType.XCAFDimTolObjects_DatumTargetType_Circle
XCAFDimTolObjects_DatumTargetType_Area = XCAFDimTolObjects_DatumTargetType.XCAFDimTolObjects_DatumTargetType_Area

class XCAFDimTolObjects_DimensionFormVariance(IntEnum):
	XCAFDimTolObjects_DimensionFormVariance_None = 0
	XCAFDimTolObjects_DimensionFormVariance_A = 1
	XCAFDimTolObjects_DimensionFormVariance_B = 2
	XCAFDimTolObjects_DimensionFormVariance_C = 3
	XCAFDimTolObjects_DimensionFormVariance_CD = 4
	XCAFDimTolObjects_DimensionFormVariance_D = 5
	XCAFDimTolObjects_DimensionFormVariance_E = 6
	XCAFDimTolObjects_DimensionFormVariance_EF = 7
	XCAFDimTolObjects_DimensionFormVariance_F = 8
	XCAFDimTolObjects_DimensionFormVariance_FG = 9
	XCAFDimTolObjects_DimensionFormVariance_G = 10
	XCAFDimTolObjects_DimensionFormVariance_H = 11
	XCAFDimTolObjects_DimensionFormVariance_JS = 12
	XCAFDimTolObjects_DimensionFormVariance_J = 13
	XCAFDimTolObjects_DimensionFormVariance_K = 14
	XCAFDimTolObjects_DimensionFormVariance_M = 15
	XCAFDimTolObjects_DimensionFormVariance_N = 16
	XCAFDimTolObjects_DimensionFormVariance_P = 17
	XCAFDimTolObjects_DimensionFormVariance_R = 18
	XCAFDimTolObjects_DimensionFormVariance_S = 19
	XCAFDimTolObjects_DimensionFormVariance_T = 20
	XCAFDimTolObjects_DimensionFormVariance_U = 21
	XCAFDimTolObjects_DimensionFormVariance_V = 22
	XCAFDimTolObjects_DimensionFormVariance_X = 23
	XCAFDimTolObjects_DimensionFormVariance_Y = 24
	XCAFDimTolObjects_DimensionFormVariance_Z = 25
	XCAFDimTolObjects_DimensionFormVariance_ZA = 26
	XCAFDimTolObjects_DimensionFormVariance_ZB = 27
	XCAFDimTolObjects_DimensionFormVariance_ZC = 28
XCAFDimTolObjects_DimensionFormVariance_None = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_None
XCAFDimTolObjects_DimensionFormVariance_A = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_A
XCAFDimTolObjects_DimensionFormVariance_B = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_B
XCAFDimTolObjects_DimensionFormVariance_C = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_C
XCAFDimTolObjects_DimensionFormVariance_CD = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_CD
XCAFDimTolObjects_DimensionFormVariance_D = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_D
XCAFDimTolObjects_DimensionFormVariance_E = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_E
XCAFDimTolObjects_DimensionFormVariance_EF = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_EF
XCAFDimTolObjects_DimensionFormVariance_F = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_F
XCAFDimTolObjects_DimensionFormVariance_FG = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_FG
XCAFDimTolObjects_DimensionFormVariance_G = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_G
XCAFDimTolObjects_DimensionFormVariance_H = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_H
XCAFDimTolObjects_DimensionFormVariance_JS = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_JS
XCAFDimTolObjects_DimensionFormVariance_J = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_J
XCAFDimTolObjects_DimensionFormVariance_K = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_K
XCAFDimTolObjects_DimensionFormVariance_M = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_M
XCAFDimTolObjects_DimensionFormVariance_N = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_N
XCAFDimTolObjects_DimensionFormVariance_P = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_P
XCAFDimTolObjects_DimensionFormVariance_R = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_R
XCAFDimTolObjects_DimensionFormVariance_S = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_S
XCAFDimTolObjects_DimensionFormVariance_T = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_T
XCAFDimTolObjects_DimensionFormVariance_U = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_U
XCAFDimTolObjects_DimensionFormVariance_V = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_V
XCAFDimTolObjects_DimensionFormVariance_X = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_X
XCAFDimTolObjects_DimensionFormVariance_Y = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_Y
XCAFDimTolObjects_DimensionFormVariance_Z = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_Z
XCAFDimTolObjects_DimensionFormVariance_ZA = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_ZA
XCAFDimTolObjects_DimensionFormVariance_ZB = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_ZB
XCAFDimTolObjects_DimensionFormVariance_ZC = XCAFDimTolObjects_DimensionFormVariance.XCAFDimTolObjects_DimensionFormVariance_ZC

class XCAFDimTolObjects_DimensionGrade(IntEnum):
	XCAFDimTolObjects_DimensionGrade_IT01 = 0
	XCAFDimTolObjects_DimensionGrade_IT0 = 1
	XCAFDimTolObjects_DimensionGrade_IT1 = 2
	XCAFDimTolObjects_DimensionGrade_IT2 = 3
	XCAFDimTolObjects_DimensionGrade_IT3 = 4
	XCAFDimTolObjects_DimensionGrade_IT4 = 5
	XCAFDimTolObjects_DimensionGrade_IT5 = 6
	XCAFDimTolObjects_DimensionGrade_IT6 = 7
	XCAFDimTolObjects_DimensionGrade_IT7 = 8
	XCAFDimTolObjects_DimensionGrade_IT8 = 9
	XCAFDimTolObjects_DimensionGrade_IT9 = 10
	XCAFDimTolObjects_DimensionGrade_IT10 = 11
	XCAFDimTolObjects_DimensionGrade_IT11 = 12
	XCAFDimTolObjects_DimensionGrade_IT12 = 13
	XCAFDimTolObjects_DimensionGrade_IT13 = 14
	XCAFDimTolObjects_DimensionGrade_IT14 = 15
	XCAFDimTolObjects_DimensionGrade_IT15 = 16
	XCAFDimTolObjects_DimensionGrade_IT16 = 17
	XCAFDimTolObjects_DimensionGrade_IT17 = 18
	XCAFDimTolObjects_DimensionGrade_IT18 = 19
XCAFDimTolObjects_DimensionGrade_IT01 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT01
XCAFDimTolObjects_DimensionGrade_IT0 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT0
XCAFDimTolObjects_DimensionGrade_IT1 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT1
XCAFDimTolObjects_DimensionGrade_IT2 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT2
XCAFDimTolObjects_DimensionGrade_IT3 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT3
XCAFDimTolObjects_DimensionGrade_IT4 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT4
XCAFDimTolObjects_DimensionGrade_IT5 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT5
XCAFDimTolObjects_DimensionGrade_IT6 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT6
XCAFDimTolObjects_DimensionGrade_IT7 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT7
XCAFDimTolObjects_DimensionGrade_IT8 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT8
XCAFDimTolObjects_DimensionGrade_IT9 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT9
XCAFDimTolObjects_DimensionGrade_IT10 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT10
XCAFDimTolObjects_DimensionGrade_IT11 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT11
XCAFDimTolObjects_DimensionGrade_IT12 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT12
XCAFDimTolObjects_DimensionGrade_IT13 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT13
XCAFDimTolObjects_DimensionGrade_IT14 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT14
XCAFDimTolObjects_DimensionGrade_IT15 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT15
XCAFDimTolObjects_DimensionGrade_IT16 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT16
XCAFDimTolObjects_DimensionGrade_IT17 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT17
XCAFDimTolObjects_DimensionGrade_IT18 = XCAFDimTolObjects_DimensionGrade.XCAFDimTolObjects_DimensionGrade_IT18

class XCAFDimTolObjects_DimensionModif(IntEnum):
	XCAFDimTolObjects_DimensionModif_ControlledRadius = 0
	XCAFDimTolObjects_DimensionModif_Square = 1
	XCAFDimTolObjects_DimensionModif_StatisticalTolerance = 2
	XCAFDimTolObjects_DimensionModif_ContinuousFeature = 3
	XCAFDimTolObjects_DimensionModif_TwoPointSize = 4
	XCAFDimTolObjects_DimensionModif_LocalSizeDefinedBySphere = 5
	XCAFDimTolObjects_DimensionModif_LeastSquaresAssociationCriterion = 6
	XCAFDimTolObjects_DimensionModif_MaximumInscribedAssociation = 7
	XCAFDimTolObjects_DimensionModif_MinimumCircumscribedAssociation = 8
	XCAFDimTolObjects_DimensionModif_CircumferenceDiameter = 9
	XCAFDimTolObjects_DimensionModif_AreaDiameter = 10
	XCAFDimTolObjects_DimensionModif_VolumeDiameter = 11
	XCAFDimTolObjects_DimensionModif_MaximumSize = 12
	XCAFDimTolObjects_DimensionModif_MinimumSize = 13
	XCAFDimTolObjects_DimensionModif_AverageSize = 14
	XCAFDimTolObjects_DimensionModif_MedianSize = 15
	XCAFDimTolObjects_DimensionModif_MidRangeSize = 16
	XCAFDimTolObjects_DimensionModif_RangeOfSizes = 17
	XCAFDimTolObjects_DimensionModif_AnyRestrictedPortionOfFeature = 18
	XCAFDimTolObjects_DimensionModif_AnyCrossSection = 19
	XCAFDimTolObjects_DimensionModif_SpecificFixedCrossSection = 20
	XCAFDimTolObjects_DimensionModif_CommonTolerance = 21
	XCAFDimTolObjects_DimensionModif_FreeStateCondition = 22
	XCAFDimTolObjects_DimensionModif_Between = 23
XCAFDimTolObjects_DimensionModif_ControlledRadius = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_ControlledRadius
XCAFDimTolObjects_DimensionModif_Square = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_Square
XCAFDimTolObjects_DimensionModif_StatisticalTolerance = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_StatisticalTolerance
XCAFDimTolObjects_DimensionModif_ContinuousFeature = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_ContinuousFeature
XCAFDimTolObjects_DimensionModif_TwoPointSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_TwoPointSize
XCAFDimTolObjects_DimensionModif_LocalSizeDefinedBySphere = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_LocalSizeDefinedBySphere
XCAFDimTolObjects_DimensionModif_LeastSquaresAssociationCriterion = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_LeastSquaresAssociationCriterion
XCAFDimTolObjects_DimensionModif_MaximumInscribedAssociation = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MaximumInscribedAssociation
XCAFDimTolObjects_DimensionModif_MinimumCircumscribedAssociation = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MinimumCircumscribedAssociation
XCAFDimTolObjects_DimensionModif_CircumferenceDiameter = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_CircumferenceDiameter
XCAFDimTolObjects_DimensionModif_AreaDiameter = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_AreaDiameter
XCAFDimTolObjects_DimensionModif_VolumeDiameter = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_VolumeDiameter
XCAFDimTolObjects_DimensionModif_MaximumSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MaximumSize
XCAFDimTolObjects_DimensionModif_MinimumSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MinimumSize
XCAFDimTolObjects_DimensionModif_AverageSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_AverageSize
XCAFDimTolObjects_DimensionModif_MedianSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MedianSize
XCAFDimTolObjects_DimensionModif_MidRangeSize = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_MidRangeSize
XCAFDimTolObjects_DimensionModif_RangeOfSizes = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_RangeOfSizes
XCAFDimTolObjects_DimensionModif_AnyRestrictedPortionOfFeature = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_AnyRestrictedPortionOfFeature
XCAFDimTolObjects_DimensionModif_AnyCrossSection = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_AnyCrossSection
XCAFDimTolObjects_DimensionModif_SpecificFixedCrossSection = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_SpecificFixedCrossSection
XCAFDimTolObjects_DimensionModif_CommonTolerance = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_CommonTolerance
XCAFDimTolObjects_DimensionModif_FreeStateCondition = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_FreeStateCondition
XCAFDimTolObjects_DimensionModif_Between = XCAFDimTolObjects_DimensionModif.XCAFDimTolObjects_DimensionModif_Between

class XCAFDimTolObjects_DimensionQualifier(IntEnum):
	XCAFDimTolObjects_DimensionQualifier_None = 0
	XCAFDimTolObjects_DimensionQualifier_Min = 1
	XCAFDimTolObjects_DimensionQualifier_Max = 2
	XCAFDimTolObjects_DimensionQualifier_Avg = 3
XCAFDimTolObjects_DimensionQualifier_None = XCAFDimTolObjects_DimensionQualifier.XCAFDimTolObjects_DimensionQualifier_None
XCAFDimTolObjects_DimensionQualifier_Min = XCAFDimTolObjects_DimensionQualifier.XCAFDimTolObjects_DimensionQualifier_Min
XCAFDimTolObjects_DimensionQualifier_Max = XCAFDimTolObjects_DimensionQualifier.XCAFDimTolObjects_DimensionQualifier_Max
XCAFDimTolObjects_DimensionQualifier_Avg = XCAFDimTolObjects_DimensionQualifier.XCAFDimTolObjects_DimensionQualifier_Avg

class XCAFDimTolObjects_DimensionType(IntEnum):
	XCAFDimTolObjects_DimensionType_Location_None = 0
	XCAFDimTolObjects_DimensionType_Location_CurvedDistance = 1
	XCAFDimTolObjects_DimensionType_Location_LinearDistance = 2
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToOuter = 3
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToInner = 4
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToCenter = 5
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToOuter = 6
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToInner = 7
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToCenter = 8
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToOuter = 9
	XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToInner = 10
	XCAFDimTolObjects_DimensionType_Location_Angular = 11
	XCAFDimTolObjects_DimensionType_Location_Oriented = 12
	XCAFDimTolObjects_DimensionType_Location_WithPath = 13
	XCAFDimTolObjects_DimensionType_Size_CurveLength = 14
	XCAFDimTolObjects_DimensionType_Size_Diameter = 15
	XCAFDimTolObjects_DimensionType_Size_SphericalDiameter = 16
	XCAFDimTolObjects_DimensionType_Size_Radius = 17
	XCAFDimTolObjects_DimensionType_Size_SphericalRadius = 18
	XCAFDimTolObjects_DimensionType_Size_ToroidalMinorDiameter = 19
	XCAFDimTolObjects_DimensionType_Size_ToroidalMajorDiameter = 20
	XCAFDimTolObjects_DimensionType_Size_ToroidalMinorRadius = 21
	XCAFDimTolObjects_DimensionType_Size_ToroidalMajorRadius = 22
	XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorDiameter = 23
	XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorDiameter = 24
	XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorRadius = 25
	XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorRadius = 26
	XCAFDimTolObjects_DimensionType_Size_Thickness = 27
	XCAFDimTolObjects_DimensionType_Size_Angular = 28
	XCAFDimTolObjects_DimensionType_Size_WithPath = 29
	XCAFDimTolObjects_DimensionType_CommonLabel = 30
	XCAFDimTolObjects_DimensionType_DimensionPresentation = 31
XCAFDimTolObjects_DimensionType_Location_None = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_None
XCAFDimTolObjects_DimensionType_Location_CurvedDistance = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_CurvedDistance
XCAFDimTolObjects_DimensionType_Location_LinearDistance = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToOuter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToOuter
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToInner = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromCenterToInner
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToCenter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToCenter
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToOuter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToOuter
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToInner = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromOuterToInner
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToCenter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToCenter
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToOuter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToOuter
XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToInner = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_LinearDistance_FromInnerToInner
XCAFDimTolObjects_DimensionType_Location_Angular = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_Angular
XCAFDimTolObjects_DimensionType_Location_Oriented = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_Oriented
XCAFDimTolObjects_DimensionType_Location_WithPath = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Location_WithPath
XCAFDimTolObjects_DimensionType_Size_CurveLength = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_CurveLength
XCAFDimTolObjects_DimensionType_Size_Diameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_Diameter
XCAFDimTolObjects_DimensionType_Size_SphericalDiameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_SphericalDiameter
XCAFDimTolObjects_DimensionType_Size_Radius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_Radius
XCAFDimTolObjects_DimensionType_Size_SphericalRadius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_SphericalRadius
XCAFDimTolObjects_DimensionType_Size_ToroidalMinorDiameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalMinorDiameter
XCAFDimTolObjects_DimensionType_Size_ToroidalMajorDiameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalMajorDiameter
XCAFDimTolObjects_DimensionType_Size_ToroidalMinorRadius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalMinorRadius
XCAFDimTolObjects_DimensionType_Size_ToroidalMajorRadius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalMajorRadius
XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorDiameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorDiameter
XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorDiameter = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorDiameter
XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorRadius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalHighMajorRadius
XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorRadius = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_ToroidalLowMajorRadius
XCAFDimTolObjects_DimensionType_Size_Thickness = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_Thickness
XCAFDimTolObjects_DimensionType_Size_Angular = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_Angular
XCAFDimTolObjects_DimensionType_Size_WithPath = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_Size_WithPath
XCAFDimTolObjects_DimensionType_CommonLabel = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_CommonLabel
XCAFDimTolObjects_DimensionType_DimensionPresentation = XCAFDimTolObjects_DimensionType.XCAFDimTolObjects_DimensionType_DimensionPresentation

class XCAFDimTolObjects_GeomToleranceMatReqModif(IntEnum):
	XCAFDimTolObjects_GeomToleranceMatReqModif_None = 0
	XCAFDimTolObjects_GeomToleranceMatReqModif_M = 1
	XCAFDimTolObjects_GeomToleranceMatReqModif_L = 2
XCAFDimTolObjects_GeomToleranceMatReqModif_None = XCAFDimTolObjects_GeomToleranceMatReqModif.XCAFDimTolObjects_GeomToleranceMatReqModif_None
XCAFDimTolObjects_GeomToleranceMatReqModif_M = XCAFDimTolObjects_GeomToleranceMatReqModif.XCAFDimTolObjects_GeomToleranceMatReqModif_M
XCAFDimTolObjects_GeomToleranceMatReqModif_L = XCAFDimTolObjects_GeomToleranceMatReqModif.XCAFDimTolObjects_GeomToleranceMatReqModif_L

class XCAFDimTolObjects_GeomToleranceModif(IntEnum):
	XCAFDimTolObjects_GeomToleranceModif_Any_Cross_Section = 0
	XCAFDimTolObjects_GeomToleranceModif_Common_Zone = 1
	XCAFDimTolObjects_GeomToleranceModif_Each_Radial_Element = 2
	XCAFDimTolObjects_GeomToleranceModif_Free_State = 3
	XCAFDimTolObjects_GeomToleranceModif_Least_Material_Requirement = 4
	XCAFDimTolObjects_GeomToleranceModif_Line_Element = 5
	XCAFDimTolObjects_GeomToleranceModif_Major_Diameter = 6
	XCAFDimTolObjects_GeomToleranceModif_Maximum_Material_Requirement = 7
	XCAFDimTolObjects_GeomToleranceModif_Minor_Diameter = 8
	XCAFDimTolObjects_GeomToleranceModif_Not_Convex = 9
	XCAFDimTolObjects_GeomToleranceModif_Pitch_Diameter = 10
	XCAFDimTolObjects_GeomToleranceModif_Reciprocity_Requirement = 11
	XCAFDimTolObjects_GeomToleranceModif_Separate_Requirement = 12
	XCAFDimTolObjects_GeomToleranceModif_Statistical_Tolerance = 13
	XCAFDimTolObjects_GeomToleranceModif_Tangent_Plane = 14
	XCAFDimTolObjects_GeomToleranceModif_All_Around = 15
	XCAFDimTolObjects_GeomToleranceModif_All_Over = 16
XCAFDimTolObjects_GeomToleranceModif_Any_Cross_Section = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Any_Cross_Section
XCAFDimTolObjects_GeomToleranceModif_Common_Zone = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Common_Zone
XCAFDimTolObjects_GeomToleranceModif_Each_Radial_Element = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Each_Radial_Element
XCAFDimTolObjects_GeomToleranceModif_Free_State = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Free_State
XCAFDimTolObjects_GeomToleranceModif_Least_Material_Requirement = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Least_Material_Requirement
XCAFDimTolObjects_GeomToleranceModif_Line_Element = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Line_Element
XCAFDimTolObjects_GeomToleranceModif_Major_Diameter = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Major_Diameter
XCAFDimTolObjects_GeomToleranceModif_Maximum_Material_Requirement = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Maximum_Material_Requirement
XCAFDimTolObjects_GeomToleranceModif_Minor_Diameter = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Minor_Diameter
XCAFDimTolObjects_GeomToleranceModif_Not_Convex = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Not_Convex
XCAFDimTolObjects_GeomToleranceModif_Pitch_Diameter = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Pitch_Diameter
XCAFDimTolObjects_GeomToleranceModif_Reciprocity_Requirement = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Reciprocity_Requirement
XCAFDimTolObjects_GeomToleranceModif_Separate_Requirement = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Separate_Requirement
XCAFDimTolObjects_GeomToleranceModif_Statistical_Tolerance = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Statistical_Tolerance
XCAFDimTolObjects_GeomToleranceModif_Tangent_Plane = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_Tangent_Plane
XCAFDimTolObjects_GeomToleranceModif_All_Around = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_All_Around
XCAFDimTolObjects_GeomToleranceModif_All_Over = XCAFDimTolObjects_GeomToleranceModif.XCAFDimTolObjects_GeomToleranceModif_All_Over

class XCAFDimTolObjects_GeomToleranceType(IntEnum):
	XCAFDimTolObjects_GeomToleranceType_None = 0
	XCAFDimTolObjects_GeomToleranceType_Angularity = 1
	XCAFDimTolObjects_GeomToleranceType_CircularRunout = 2
	XCAFDimTolObjects_GeomToleranceType_CircularityOrRoundness = 3
	XCAFDimTolObjects_GeomToleranceType_Coaxiality = 4
	XCAFDimTolObjects_GeomToleranceType_Concentricity = 5
	XCAFDimTolObjects_GeomToleranceType_Cylindricity = 6
	XCAFDimTolObjects_GeomToleranceType_Flatness = 7
	XCAFDimTolObjects_GeomToleranceType_Parallelism = 8
	XCAFDimTolObjects_GeomToleranceType_Perpendicularity = 9
	XCAFDimTolObjects_GeomToleranceType_Position = 10
	XCAFDimTolObjects_GeomToleranceType_ProfileOfLine = 11
	XCAFDimTolObjects_GeomToleranceType_ProfileOfSurface = 12
	XCAFDimTolObjects_GeomToleranceType_Straightness = 13
	XCAFDimTolObjects_GeomToleranceType_Symmetry = 14
	XCAFDimTolObjects_GeomToleranceType_TotalRunout = 15
XCAFDimTolObjects_GeomToleranceType_None = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_None
XCAFDimTolObjects_GeomToleranceType_Angularity = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Angularity
XCAFDimTolObjects_GeomToleranceType_CircularRunout = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_CircularRunout
XCAFDimTolObjects_GeomToleranceType_CircularityOrRoundness = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_CircularityOrRoundness
XCAFDimTolObjects_GeomToleranceType_Coaxiality = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Coaxiality
XCAFDimTolObjects_GeomToleranceType_Concentricity = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Concentricity
XCAFDimTolObjects_GeomToleranceType_Cylindricity = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Cylindricity
XCAFDimTolObjects_GeomToleranceType_Flatness = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Flatness
XCAFDimTolObjects_GeomToleranceType_Parallelism = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Parallelism
XCAFDimTolObjects_GeomToleranceType_Perpendicularity = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Perpendicularity
XCAFDimTolObjects_GeomToleranceType_Position = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Position
XCAFDimTolObjects_GeomToleranceType_ProfileOfLine = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_ProfileOfLine
XCAFDimTolObjects_GeomToleranceType_ProfileOfSurface = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_ProfileOfSurface
XCAFDimTolObjects_GeomToleranceType_Straightness = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Straightness
XCAFDimTolObjects_GeomToleranceType_Symmetry = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_Symmetry
XCAFDimTolObjects_GeomToleranceType_TotalRunout = XCAFDimTolObjects_GeomToleranceType.XCAFDimTolObjects_GeomToleranceType_TotalRunout

class XCAFDimTolObjects_GeomToleranceTypeValue(IntEnum):
	XCAFDimTolObjects_GeomToleranceTypeValue_None = 0
	XCAFDimTolObjects_GeomToleranceTypeValue_Diameter = 1
	XCAFDimTolObjects_GeomToleranceTypeValue_SphericalDiameter = 2
XCAFDimTolObjects_GeomToleranceTypeValue_None = XCAFDimTolObjects_GeomToleranceTypeValue.XCAFDimTolObjects_GeomToleranceTypeValue_None
XCAFDimTolObjects_GeomToleranceTypeValue_Diameter = XCAFDimTolObjects_GeomToleranceTypeValue.XCAFDimTolObjects_GeomToleranceTypeValue_Diameter
XCAFDimTolObjects_GeomToleranceTypeValue_SphericalDiameter = XCAFDimTolObjects_GeomToleranceTypeValue.XCAFDimTolObjects_GeomToleranceTypeValue_SphericalDiameter

class XCAFDimTolObjects_GeomToleranceZoneModif(IntEnum):
	XCAFDimTolObjects_GeomToleranceZoneModif_None = 0
	XCAFDimTolObjects_GeomToleranceZoneModif_Projected = 1
	XCAFDimTolObjects_GeomToleranceZoneModif_Runout = 2
	XCAFDimTolObjects_GeomToleranceZoneModif_NonUniform = 3
XCAFDimTolObjects_GeomToleranceZoneModif_None = XCAFDimTolObjects_GeomToleranceZoneModif.XCAFDimTolObjects_GeomToleranceZoneModif_None
XCAFDimTolObjects_GeomToleranceZoneModif_Projected = XCAFDimTolObjects_GeomToleranceZoneModif.XCAFDimTolObjects_GeomToleranceZoneModif_Projected
XCAFDimTolObjects_GeomToleranceZoneModif_Runout = XCAFDimTolObjects_GeomToleranceZoneModif.XCAFDimTolObjects_GeomToleranceZoneModif_Runout
XCAFDimTolObjects_GeomToleranceZoneModif_NonUniform = XCAFDimTolObjects_GeomToleranceZoneModif.XCAFDimTolObjects_GeomToleranceZoneModif_NonUniform

class XCAFDimTolObjects_ToleranceZoneAffectedPlane(IntEnum):
	XCAFDimTolObjects_ToleranceZoneAffectedPlane_None = 0
	XCAFDimTolObjects_ToleranceZoneAffectedPlane_Intersection = 1
	XCAFDimTolObjects_ToleranceZoneAffectedPlane_Orientation = 2
XCAFDimTolObjects_ToleranceZoneAffectedPlane_None = XCAFDimTolObjects_ToleranceZoneAffectedPlane.XCAFDimTolObjects_ToleranceZoneAffectedPlane_None
XCAFDimTolObjects_ToleranceZoneAffectedPlane_Intersection = XCAFDimTolObjects_ToleranceZoneAffectedPlane.XCAFDimTolObjects_ToleranceZoneAffectedPlane_Intersection
XCAFDimTolObjects_ToleranceZoneAffectedPlane_Orientation = XCAFDimTolObjects_ToleranceZoneAffectedPlane.XCAFDimTolObjects_ToleranceZoneAffectedPlane_Orientation
};
/* end python proxy for enums */

/* handles */
%wrap_handle(XCAFDimTolObjects_DatumObject)
%wrap_handle(XCAFDimTolObjects_DimensionObject)
%wrap_handle(XCAFDimTolObjects_GeomToleranceObject)
/* end handles declaration */

/* templates */
%template(XCAFDimTolObjects_DataMapOfToleranceDatum) NCollection_DataMap<opencascade::handle<XCAFDimTolObjects_GeomToleranceObject>,opencascade::handle<XCAFDimTolObjects_DatumObject>>;
%template(XCAFDimTolObjects_DatumModifiersSequence) NCollection_Sequence<XCAFDimTolObjects_DatumSingleModif>;

%extend NCollection_Sequence<XCAFDimTolObjects_DatumSingleModif> {
    %pythoncode {
    def __len__(self):
        return self.Size()
    }
};
%template(XCAFDimTolObjects_DatumObjectSequence) NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_DatumObject>>;

%extend NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_DatumObject>> {
    %pythoncode {
    def __len__(self):
        return self.Size()
    }
};
%template(XCAFDimTolObjects_DimensionModifiersSequence) NCollection_Sequence<XCAFDimTolObjects_DimensionModif>;

%extend NCollection_Sequence<XCAFDimTolObjects_DimensionModif> {
    %pythoncode {
    def __len__(self):
        return self.Size()
    }
};
%template(XCAFDimTolObjects_DimensionObjectSequence) NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_DimensionObject>>;

%extend NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_DimensionObject>> {
    %pythoncode {
    def __len__(self):
        return self.Size()
    }
};
%template(XCAFDimTolObjects_GeomToleranceModifiersSequence) NCollection_Sequence<XCAFDimTolObjects_GeomToleranceModif>;

%extend NCollection_Sequence<XCAFDimTolObjects_GeomToleranceModif> {
    %pythoncode {
    def __len__(self):
        return self.Size()
    }
};
%template(XCAFDimTolObjects_GeomToleranceObjectSequence) NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_GeomToleranceObject>>;

%extend NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_GeomToleranceObject>> {
    %pythoncode {
    def __len__(self):
        return self.Size()
    }
};
/* end templates declaration */

/* typedefs */
typedef NCollection_DataMap<opencascade::handle<XCAFDimTolObjects_GeomToleranceObject>, opencascade::handle<XCAFDimTolObjects_DatumObject>> XCAFDimTolObjects_DataMapOfToleranceDatum;
typedef NCollection_Sequence<XCAFDimTolObjects_DatumSingleModif> XCAFDimTolObjects_DatumModifiersSequence;
typedef NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_DatumObject>> XCAFDimTolObjects_DatumObjectSequence;
typedef NCollection_Sequence<XCAFDimTolObjects_DimensionModif> XCAFDimTolObjects_DimensionModifiersSequence;
typedef NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_DimensionObject>> XCAFDimTolObjects_DimensionObjectSequence;
typedef NCollection_Sequence<XCAFDimTolObjects_GeomToleranceModif> XCAFDimTolObjects_GeomToleranceModifiersSequence;
typedef NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_GeomToleranceObject>> XCAFDimTolObjects_GeomToleranceObjectSequence;
/* end typedefs declaration */

/**************************************
* class XCAFDimTolObjects_DatumObject *
**************************************/
class XCAFDimTolObjects_DatumObject : public Standard_Transient {
	public:
		/****** XCAFDimTolObjects_DatumObject::XCAFDimTolObjects_DatumObject ******/
		/****** md5 signature: 740a9a9edb4d4b9d88bb15a7abe65522 ******/
		%feature("compactdefaultargs") XCAFDimTolObjects_DatumObject;
		%feature("autodoc", "Return
-------
None

Description
-----------
No available documentation.
") XCAFDimTolObjects_DatumObject;
		 XCAFDimTolObjects_DatumObject();

		/****** XCAFDimTolObjects_DatumObject::XCAFDimTolObjects_DatumObject ******/
		/****** md5 signature: d941c35c90441a5733d6cb73b4cdaedd ******/
		%feature("compactdefaultargs") XCAFDimTolObjects_DatumObject;
		%feature("autodoc", "
Parameters
----------
theObj: XCAFDimTolObjects_DatumObject

Return
-------
None

Description
-----------
No available documentation.
") XCAFDimTolObjects_DatumObject;
		 XCAFDimTolObjects_DatumObject(const opencascade::handle<XCAFDimTolObjects_DatumObject> & theObj);

		/****** XCAFDimTolObjects_DatumObject::AddModifier ******/
		/****** md5 signature: b052f252dc91e84d97c2ac7d3138dbd0 ******/
		%feature("compactdefaultargs") AddModifier;
		%feature("autodoc", "
Parameters
----------
theModifier: XCAFDimTolObjects_DatumSingleModif

Return
-------
None

Description
-----------
Adds a modifier to the datum sequence of modifiers.
") AddModifier;
		void AddModifier(const XCAFDimTolObjects_DatumSingleModif theModifier);


        /****************** DumpJson ******************/
        %feature("autodoc", "
Parameters
----------
depth: int, default=-1

Return
-------
str

Description
-----------
Dump the object to JSON string.
") DumpJson;
        %extend{
            std::string DumpJson(int depth=-1) {
            std::stringstream s;
            self->DumpJson(s, depth);
            return "{" + s.str() + "}" ;}
        };
		/****** XCAFDimTolObjects_DatumObject::GetDatumTarget ******/
		/****** md5 signature: 907a10d068832d0dfb763a345de9f7e3 ******/
		%feature("compactdefaultargs") GetDatumTarget;
		%feature("autodoc", "Return
-------
TopoDS_Shape

Description
-----------
Returns datum target shape.
") GetDatumTarget;
		TopoDS_Shape GetDatumTarget();

		/****** XCAFDimTolObjects_DatumObject::GetDatumTargetAxis ******/
		/****** md5 signature: d7c4bc3b61bf4e4f7a2e5f136bb1bc79 ******/
		%feature("compactdefaultargs") GetDatumTargetAxis;
		%feature("autodoc", "Return
-------
gp_Ax2

Description
-----------
Returns datum target axis. The Z axis of the datum placement denotes the normal of the surface pointing away from the material.
") GetDatumTargetAxis;
		gp_Ax2 GetDatumTargetAxis();

		/****** XCAFDimTolObjects_DatumObject::GetDatumTargetLength ******/
		/****** md5 signature: dceb1778ee1bc3292f37ed1c219551a6 ******/
		%feature("compactdefaultargs") GetDatumTargetLength;
		%feature("autodoc", "Return
-------
float

Description
-----------
Returns datum target length for line and rectangle types. The length along the X axis of the datum placement.
") GetDatumTargetLength;
		Standard_Real GetDatumTargetLength();

		/****** XCAFDimTolObjects_DatumObject::GetDatumTargetNumber ******/
		/****** md5 signature: 4f4dc912a0ec5187fb922fd2c768c962 ******/
		%feature("compactdefaultargs") GetDatumTargetNumber;
		%feature("autodoc", "Return
-------
int

Description
-----------
Returns datum target number.
") GetDatumTargetNumber;
		Standard_Integer GetDatumTargetNumber();

		/****** XCAFDimTolObjects_DatumObject::GetDatumTargetType ******/
		/****** md5 signature: 29baed0eef88b4da45673256dac43a90 ******/
		%feature("compactdefaultargs") GetDatumTargetType;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_DatumTargetType

Description
-----------
Returns datum target type.
") GetDatumTargetType;
		XCAFDimTolObjects_DatumTargetType GetDatumTargetType();

		/****** XCAFDimTolObjects_DatumObject::GetDatumTargetWidth ******/
		/****** md5 signature: 9a52e7661b91680368d6329aea5d46cf ******/
		%feature("compactdefaultargs") GetDatumTargetWidth;
		%feature("autodoc", "Return
-------
float

Description
-----------
Returns datum target width for rectangle type. The width along the derived Y axis, with the placement itself positioned at the centre of the rectangle.
") GetDatumTargetWidth;
		Standard_Real GetDatumTargetWidth();

		/****** XCAFDimTolObjects_DatumObject::GetModifierWithValue ******/
		/****** md5 signature: d0420dfa8bea7c0492f9343a8d1bcd95 ******/
		%feature("compactdefaultargs") GetModifierWithValue;
		%feature("autodoc", "
Parameters
----------

Return
-------
theModifier: XCAFDimTolObjects_DatumModifWithValue
theValue: float

Description
-----------
Retrieves datum modifier with value.
") GetModifierWithValue;
		void GetModifierWithValue(XCAFDimTolObjects_DatumModifWithValue &OutValue, Standard_Real &OutValue);

		/****** XCAFDimTolObjects_DatumObject::GetModifiers ******/
		/****** md5 signature: b5adaae02ed3bb65adc417ee83177849 ******/
		%feature("compactdefaultargs") GetModifiers;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_DatumModifiersSequence

Description
-----------
Returns a sequence of modifiers of the datum.
") GetModifiers;
		XCAFDimTolObjects_DatumModifiersSequence GetModifiers();

		/****** XCAFDimTolObjects_DatumObject::GetName ******/
		/****** md5 signature: 23aadc9cd2e3411b58fb02d3fd2db5c9 ******/
		%feature("compactdefaultargs") GetName;
		%feature("autodoc", "Return
-------
opencascade::handle<TCollection_HAsciiString>

Description
-----------
Returns datum name.
") GetName;
		opencascade::handle<TCollection_HAsciiString> GetName();

		/****** XCAFDimTolObjects_DatumObject::GetPlane ******/
		/****** md5 signature: 236cce5d8f8ab5feac0e3f6311bd05f0 ******/
		%feature("compactdefaultargs") GetPlane;
		%feature("autodoc", "Return
-------
gp_Ax2

Description
-----------
Returns annotation plane.
") GetPlane;
		const gp_Ax2 GetPlane();

		/****** XCAFDimTolObjects_DatumObject::GetPoint ******/
		/****** md5 signature: 75bde715a8ee43e7500d44b575591a80 ******/
		%feature("compactdefaultargs") GetPoint;
		%feature("autodoc", "Return
-------
gp_Pnt

Description
-----------
Gets point on the datum shape.
") GetPoint;
		const gp_Pnt GetPoint();

		/****** XCAFDimTolObjects_DatumObject::GetPointTextAttach ******/
		/****** md5 signature: e81e077f484c7c68ce183e571e4969e7 ******/
		%feature("compactdefaultargs") GetPointTextAttach;
		%feature("autodoc", "Return
-------
gp_Pnt

Description
-----------
Gets datum text position.
") GetPointTextAttach;
		const gp_Pnt GetPointTextAttach();

		/****** XCAFDimTolObjects_DatumObject::GetPosition ******/
		/****** md5 signature: 3a7096bf5e08d1f1157194f392c5b3ec ******/
		%feature("compactdefaultargs") GetPosition;
		%feature("autodoc", "Return
-------
int

Description
-----------
Returns datum position in the related geometric tolerance object.
") GetPosition;
		Standard_Integer GetPosition();

		/****** XCAFDimTolObjects_DatumObject::GetPresentation ******/
		/****** md5 signature: 3a1ba105c920c672ad36e26c32c03ea0 ******/
		%feature("compactdefaultargs") GetPresentation;
		%feature("autodoc", "Return
-------
TopoDS_Shape

Description
-----------
Returns graphical presentation of the object.
") GetPresentation;
		TopoDS_Shape GetPresentation();

		/****** XCAFDimTolObjects_DatumObject::GetPresentationName ******/
		/****** md5 signature: ae4fdc476bfb8d85148da7be6e48c228 ******/
		%feature("compactdefaultargs") GetPresentationName;
		%feature("autodoc", "Return
-------
opencascade::handle<TCollection_HAsciiString>

Description
-----------
Returns graphical presentation of the object.
") GetPresentationName;
		opencascade::handle<TCollection_HAsciiString> GetPresentationName();

		/****** XCAFDimTolObjects_DatumObject::GetSemanticName ******/
		/****** md5 signature: 914ea6563027cdf692e218da5b1136d4 ******/
		%feature("compactdefaultargs") GetSemanticName;
		%feature("autodoc", "Return
-------
opencascade::handle<TCollection_HAsciiString>

Description
-----------
Returns semantic name.
") GetSemanticName;
		opencascade::handle<TCollection_HAsciiString> GetSemanticName();

		/****** XCAFDimTolObjects_DatumObject::HasDatumTargetParams ******/
		/****** md5 signature: ff688881a529fc9676d7f111adc68465 ******/
		%feature("compactdefaultargs") HasDatumTargetParams;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the datum has valid parameters for datum target (width, length, circle radius etc).
") HasDatumTargetParams;
		Standard_Boolean HasDatumTargetParams();

		/****** XCAFDimTolObjects_DatumObject::HasPlane ******/
		/****** md5 signature: 7cf03566771455c19f444d8a2236d65d ******/
		%feature("compactdefaultargs") HasPlane;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the datum has annotation plane.
") HasPlane;
		Standard_Boolean HasPlane();

		/****** XCAFDimTolObjects_DatumObject::HasPoint ******/
		/****** md5 signature: 8de3c013a7c1611c02e38dffb22d1c6b ******/
		%feature("compactdefaultargs") HasPoint;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if point on the datum target is specified.
") HasPoint;
		Standard_Boolean HasPoint();

		/****** XCAFDimTolObjects_DatumObject::HasPointText ******/
		/****** md5 signature: 0bf2ec86538f2cbb875c1c0a8313563e ******/
		%feature("compactdefaultargs") HasPointText;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the datum text position is specified.
") HasPointText;
		Standard_Boolean HasPointText();

		/****** XCAFDimTolObjects_DatumObject::IsDatumTarget ******/
		/****** md5 signature: affa7fb23f28b674a35275ad9431dcfe ******/
		%feature("compactdefaultargs") IsDatumTarget;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the datum target is specified.
") IsDatumTarget;
		Standard_Boolean IsDatumTarget();

		/****** XCAFDimTolObjects_DatumObject::IsDatumTarget ******/
		/****** md5 signature: 80e38375174ca2c338ba7e04ba982f58 ******/
		%feature("compactdefaultargs") IsDatumTarget;
		%feature("autodoc", "
Parameters
----------
theIsDT: bool

Return
-------
None

Description
-----------
Sets or drops the datum target indicator.
") IsDatumTarget;
		void IsDatumTarget(const Standard_Boolean theIsDT);

		/****** XCAFDimTolObjects_DatumObject::SetDatumTarget ******/
		/****** md5 signature: c5e58e62e91021f5eb99ac01a1f98445 ******/
		%feature("compactdefaultargs") SetDatumTarget;
		%feature("autodoc", "
Parameters
----------
theShape: TopoDS_Shape

Return
-------
None

Description
-----------
Sets datum target shape.
") SetDatumTarget;
		void SetDatumTarget(const TopoDS_Shape & theShape);

		/****** XCAFDimTolObjects_DatumObject::SetDatumTargetAxis ******/
		/****** md5 signature: 8d9f74c22cc7df8fca3c99e6de53c1dd ******/
		%feature("compactdefaultargs") SetDatumTargetAxis;
		%feature("autodoc", "
Parameters
----------
theAxis: gp_Ax2

Return
-------
None

Description
-----------
Sets datum target axis.
") SetDatumTargetAxis;
		void SetDatumTargetAxis(const gp_Ax2 & theAxis);

		/****** XCAFDimTolObjects_DatumObject::SetDatumTargetLength ******/
		/****** md5 signature: f026bdbbc3bf20f77bce308dfba0a65e ******/
		%feature("compactdefaultargs") SetDatumTargetLength;
		%feature("autodoc", "
Parameters
----------
theLength: float

Return
-------
None

Description
-----------
Sets datum target length.
") SetDatumTargetLength;
		void SetDatumTargetLength(const Standard_Real theLength);

		/****** XCAFDimTolObjects_DatumObject::SetDatumTargetNumber ******/
		/****** md5 signature: 0aafb47f190b266f0f3e58d9c1b8de30 ******/
		%feature("compactdefaultargs") SetDatumTargetNumber;
		%feature("autodoc", "
Parameters
----------
theNumber: int

Return
-------
None

Description
-----------
Sets datum target number.
") SetDatumTargetNumber;
		void SetDatumTargetNumber(const Standard_Integer theNumber);

		/****** XCAFDimTolObjects_DatumObject::SetDatumTargetType ******/
		/****** md5 signature: 6968ab43c60b1bf94d193c1f77d9fc73 ******/
		%feature("compactdefaultargs") SetDatumTargetType;
		%feature("autodoc", "
Parameters
----------
theType: XCAFDimTolObjects_DatumTargetType

Return
-------
None

Description
-----------
Sets datum target to point, line, rectangle, circle or area type.
") SetDatumTargetType;
		void SetDatumTargetType(const XCAFDimTolObjects_DatumTargetType theType);

		/****** XCAFDimTolObjects_DatumObject::SetDatumTargetWidth ******/
		/****** md5 signature: d1150520927f93eb207ebc5738b270b2 ******/
		%feature("compactdefaultargs") SetDatumTargetWidth;
		%feature("autodoc", "
Parameters
----------
theWidth: float

Return
-------
None

Description
-----------
Sets datum target width.
") SetDatumTargetWidth;
		void SetDatumTargetWidth(const Standard_Real theWidth);

		/****** XCAFDimTolObjects_DatumObject::SetModifierWithValue ******/
		/****** md5 signature: 06d6a36c24483e33f9dc42b57e32fdea ******/
		%feature("compactdefaultargs") SetModifierWithValue;
		%feature("autodoc", "
Parameters
----------
theModifier: XCAFDimTolObjects_DatumModifWithValue
theValue: float

Return
-------
None

Description
-----------
Sets datum modifier with value.
") SetModifierWithValue;
		void SetModifierWithValue(const XCAFDimTolObjects_DatumModifWithValue theModifier, const Standard_Real theValue);

		/****** XCAFDimTolObjects_DatumObject::SetModifiers ******/
		/****** md5 signature: f17a408bcc855b6527c7c915793c7280 ******/
		%feature("compactdefaultargs") SetModifiers;
		%feature("autodoc", "
Parameters
----------
theModifiers: XCAFDimTolObjects_DatumModifiersSequence

Return
-------
None

Description
-----------
Sets new sequence of datum modifiers.
") SetModifiers;
		void SetModifiers(const XCAFDimTolObjects_DatumModifiersSequence & theModifiers);

		/****** XCAFDimTolObjects_DatumObject::SetName ******/
		/****** md5 signature: f33a2db64e10616326f3c237e59d5df6 ******/
		%feature("compactdefaultargs") SetName;
		%feature("autodoc", "
Parameters
----------
theTag: TCollection_HAsciiString

Return
-------
None

Description
-----------
Sets datum name.
") SetName;
		void SetName(const opencascade::handle<TCollection_HAsciiString> & theTag);

		/****** XCAFDimTolObjects_DatumObject::SetPlane ******/
		/****** md5 signature: 77a07ccd642257136673432fbd51e9ba ******/
		%feature("compactdefaultargs") SetPlane;
		%feature("autodoc", "
Parameters
----------
thePlane: gp_Ax2

Return
-------
None

Description
-----------
Sets annotation plane.
") SetPlane;
		void SetPlane(const gp_Ax2 & thePlane);

		/****** XCAFDimTolObjects_DatumObject::SetPoint ******/
		/****** md5 signature: 366a57481a7ee35be93bd56983beb928 ******/
		%feature("compactdefaultargs") SetPoint;
		%feature("autodoc", "
Parameters
----------
thePnt: gp_Pnt

Return
-------
None

Description
-----------
Sets a point on the datum target shape.
") SetPoint;
		void SetPoint(const gp_Pnt & thePnt);

		/****** XCAFDimTolObjects_DatumObject::SetPointTextAttach ******/
		/****** md5 signature: 341561a939b1838061b22f9114c6f676 ******/
		%feature("compactdefaultargs") SetPointTextAttach;
		%feature("autodoc", "
Parameters
----------
thePntText: gp_Pnt

Return
-------
None

Description
-----------
Sets a position of the datum text.
") SetPointTextAttach;
		void SetPointTextAttach(const gp_Pnt & thePntText);

		/****** XCAFDimTolObjects_DatumObject::SetPosition ******/
		/****** md5 signature: 681c50c8b7fc2c907bcb44c47d32b185 ******/
		%feature("compactdefaultargs") SetPosition;
		%feature("autodoc", "
Parameters
----------
thePosition: int

Return
-------
None

Description
-----------
Sets datum position in the related geometric tolerance object.
") SetPosition;
		void SetPosition(const Standard_Integer thePosition);

		/****** XCAFDimTolObjects_DatumObject::SetPresentation ******/
		/****** md5 signature: d9f84931766936490b58688f84fa9fa9 ******/
		%feature("compactdefaultargs") SetPresentation;
		%feature("autodoc", "
Parameters
----------
thePresentation: TopoDS_Shape
thePresentationName: TCollection_HAsciiString

Return
-------
None

Description
-----------
Set graphical presentation for object.
") SetPresentation;
		void SetPresentation(const TopoDS_Shape & thePresentation, const opencascade::handle<TCollection_HAsciiString> & thePresentationName);

		/****** XCAFDimTolObjects_DatumObject::SetSemanticName ******/
		/****** md5 signature: 1ae0d4c111cc04ac024e398eb0d74f97 ******/
		%feature("compactdefaultargs") SetSemanticName;
		%feature("autodoc", "
Parameters
----------
theName: TCollection_HAsciiString

Return
-------
None

Description
-----------
Sets semantic name.
") SetSemanticName;
		void SetSemanticName(const opencascade::handle<TCollection_HAsciiString> & theName);

};


%make_alias(XCAFDimTolObjects_DatumObject)

%extend XCAFDimTolObjects_DatumObject {
	%pythoncode {
	__repr__ = _dumps_object
	}
};

/******************************************
* class XCAFDimTolObjects_DimensionObject *
******************************************/
class XCAFDimTolObjects_DimensionObject : public Standard_Transient {
	public:
		/****** XCAFDimTolObjects_DimensionObject::XCAFDimTolObjects_DimensionObject ******/
		/****** md5 signature: 3a6b058d71b9fa0645e6bfafe165e026 ******/
		%feature("compactdefaultargs") XCAFDimTolObjects_DimensionObject;
		%feature("autodoc", "Return
-------
None

Description
-----------
No available documentation.
") XCAFDimTolObjects_DimensionObject;
		 XCAFDimTolObjects_DimensionObject();

		/****** XCAFDimTolObjects_DimensionObject::XCAFDimTolObjects_DimensionObject ******/
		/****** md5 signature: 187f8e8b37a0a8209bbf130658d7ce37 ******/
		%feature("compactdefaultargs") XCAFDimTolObjects_DimensionObject;
		%feature("autodoc", "
Parameters
----------
theObj: XCAFDimTolObjects_DimensionObject

Return
-------
None

Description
-----------
No available documentation.
") XCAFDimTolObjects_DimensionObject;
		 XCAFDimTolObjects_DimensionObject(const opencascade::handle<XCAFDimTolObjects_DimensionObject> & theObj);

		/****** XCAFDimTolObjects_DimensionObject::AddDescription ******/
		/****** md5 signature: 54e9721f6e54f76f6035ef85160d7a83 ******/
		%feature("compactdefaultargs") AddDescription;
		%feature("autodoc", "
Parameters
----------
theDescription: TCollection_HAsciiString
theName: TCollection_HAsciiString

Return
-------
None

Description
-----------
Add new description.
") AddDescription;
		void AddDescription(const opencascade::handle<TCollection_HAsciiString > theDescription, const opencascade::handle<TCollection_HAsciiString > theName);

		/****** XCAFDimTolObjects_DimensionObject::AddModifier ******/
		/****** md5 signature: d341b63dcff18a6843e5befc8d4284ae ******/
		%feature("compactdefaultargs") AddModifier;
		%feature("autodoc", "
Parameters
----------
theModifier: XCAFDimTolObjects_DimensionModif

Return
-------
None

Description
-----------
Adds a modifier to the dimension sequence of modifiers.
") AddModifier;
		void AddModifier(const XCAFDimTolObjects_DimensionModif theModifier);


        /****************** DumpJson ******************/
        %feature("autodoc", "
Parameters
----------
depth: int, default=-1

Return
-------
str

Description
-----------
Dump the object to JSON string.
") DumpJson;
        %extend{
            std::string DumpJson(int depth=-1) {
            std::stringstream s;
            self->DumpJson(s, depth);
            return "{" + s.str() + "}" ;}
        };
		/****** XCAFDimTolObjects_DimensionObject::GetAngularQualifier ******/
		/****** md5 signature: 879aaa6d41f62cc9a57ed8bb32b54d97 ******/
		%feature("compactdefaultargs") GetAngularQualifier;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_AngularQualifier

Description
-----------
Returns angular qualifier.
") GetAngularQualifier;
		XCAFDimTolObjects_AngularQualifier GetAngularQualifier();

		/****** XCAFDimTolObjects_DimensionObject::GetClassOfTolerance ******/
		/****** md5 signature: 5c7792eec51fc027e2d5d6043f6964ff ******/
		%feature("compactdefaultargs") GetClassOfTolerance;
		%feature("autodoc", "
Parameters
----------

Return
-------
theHole: bool
theFormVariance: XCAFDimTolObjects_DimensionFormVariance
theGrade: XCAFDimTolObjects_DimensionGrade

Description
-----------
Retrieves tolerance class parameters of the dimension. Returns True if the dimension is toleranced.
") GetClassOfTolerance;
		Standard_Boolean GetClassOfTolerance(Standard_Boolean &OutValue, XCAFDimTolObjects_DimensionFormVariance &OutValue, XCAFDimTolObjects_DimensionGrade &OutValue);

		/****** XCAFDimTolObjects_DimensionObject::GetDescription ******/
		/****** md5 signature: b0dd6b983c7652817465a50088ed69a2 ******/
		%feature("compactdefaultargs") GetDescription;
		%feature("autodoc", "
Parameters
----------
theNumber: int

Return
-------
opencascade::handle<TCollection_HAsciiString>

Description
-----------
Returns description with the given number.
") GetDescription;
		opencascade::handle<TCollection_HAsciiString> GetDescription(const Standard_Integer theNumber);

		/****** XCAFDimTolObjects_DimensionObject::GetDescriptionName ******/
		/****** md5 signature: 7bbc8fcb96b9a95797f62e7b925ca0e5 ******/
		%feature("compactdefaultargs") GetDescriptionName;
		%feature("autodoc", "
Parameters
----------
theNumber: int

Return
-------
opencascade::handle<TCollection_HAsciiString>

Description
-----------
Returns name of description with the given number.
") GetDescriptionName;
		opencascade::handle<TCollection_HAsciiString> GetDescriptionName(const Standard_Integer theNumber);

		/****** XCAFDimTolObjects_DimensionObject::GetDirection ******/
		/****** md5 signature: a767b02b7fd241b74750b61a72de86ac ******/
		%feature("compactdefaultargs") GetDirection;
		%feature("autodoc", "
Parameters
----------
theDir: gp_Dir

Return
-------
bool

Description
-----------
Returns the orientation of the dimension in annotation plane.
") GetDirection;
		Standard_Boolean GetDirection(gp_Dir & theDir);

		/****** XCAFDimTolObjects_DimensionObject::GetLowerBound ******/
		/****** md5 signature: 8d41b4601584b9424eb10ef8caf2e4a4 ******/
		%feature("compactdefaultargs") GetLowerBound;
		%feature("autodoc", "Return
-------
float

Description
-----------
Returns the lower bound of the range dimension, otherwise - zero.
") GetLowerBound;
		Standard_Real GetLowerBound();

		/****** XCAFDimTolObjects_DimensionObject::GetLowerTolValue ******/
		/****** md5 signature: e72090ed2d5e86760b6ae277b44353b9 ******/
		%feature("compactdefaultargs") GetLowerTolValue;
		%feature("autodoc", "Return
-------
float

Description
-----------
Returns the upper value of the toleranced dimension, otherwise - zero.
") GetLowerTolValue;
		Standard_Real GetLowerTolValue();

		/****** XCAFDimTolObjects_DimensionObject::GetModifiers ******/
		/****** md5 signature: 587262242802230210b3d9aefde982fd ******/
		%feature("compactdefaultargs") GetModifiers;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_DimensionModifiersSequence

Description
-----------
Returns a sequence of modifiers of the dimension.
") GetModifiers;
		XCAFDimTolObjects_DimensionModifiersSequence GetModifiers();

		/****** XCAFDimTolObjects_DimensionObject::GetNbOfDecimalPlaces ******/
		/****** md5 signature: 72ecb82ef2e8a3ca68fc130b97a81441 ******/
		%feature("compactdefaultargs") GetNbOfDecimalPlaces;
		%feature("autodoc", "
Parameters
----------

Return
-------
theL: int
theR: int

Description
-----------
Returns the number of places to the left and right of the decimal point respectively.
") GetNbOfDecimalPlaces;
		void GetNbOfDecimalPlaces(Standard_Integer &OutValue, Standard_Integer &OutValue);

		/****** XCAFDimTolObjects_DimensionObject::GetPath ******/
		/****** md5 signature: d141ed819ccde872312162fa0cc04936 ******/
		%feature("compactdefaultargs") GetPath;
		%feature("autodoc", "Return
-------
TopoDS_Edge

Description
-----------
Returns a 'curve' along which the dimension is measured.
") GetPath;
		TopoDS_Edge GetPath();

		/****** XCAFDimTolObjects_DimensionObject::GetPlane ******/
		/****** md5 signature: 236cce5d8f8ab5feac0e3f6311bd05f0 ******/
		%feature("compactdefaultargs") GetPlane;
		%feature("autodoc", "Return
-------
gp_Ax2

Description
-----------
Returns annotation plane.
") GetPlane;
		const gp_Ax2 GetPlane();

		/****** XCAFDimTolObjects_DimensionObject::GetPoint ******/
		/****** md5 signature: baf1854e20bb314d04b36313e7ea5abb ******/
		%feature("compactdefaultargs") GetPoint;
		%feature("autodoc", "Return
-------
gp_Pnt

Description
-----------
Get connection point (for dimensional_size), Get connection point for the first shape (for dimensional_location).
") GetPoint;
		gp_Pnt GetPoint();

		/****** XCAFDimTolObjects_DimensionObject::GetPoint2 ******/
		/****** md5 signature: dda8fa40cffd61265b7b5ba471e18189 ******/
		%feature("compactdefaultargs") GetPoint2;
		%feature("autodoc", "Return
-------
gp_Pnt

Description
-----------
No available documentation.
") GetPoint2;
		gp_Pnt GetPoint2();

		/****** XCAFDimTolObjects_DimensionObject::GetPointTextAttach ******/
		/****** md5 signature: e81e077f484c7c68ce183e571e4969e7 ******/
		%feature("compactdefaultargs") GetPointTextAttach;
		%feature("autodoc", "Return
-------
gp_Pnt

Description
-----------
Returns position of the dimension text.
") GetPointTextAttach;
		const gp_Pnt GetPointTextAttach();

		/****** XCAFDimTolObjects_DimensionObject::GetPresentation ******/
		/****** md5 signature: 3a1ba105c920c672ad36e26c32c03ea0 ******/
		%feature("compactdefaultargs") GetPresentation;
		%feature("autodoc", "Return
-------
TopoDS_Shape

Description
-----------
Returns graphical presentation of the object.
") GetPresentation;
		TopoDS_Shape GetPresentation();

		/****** XCAFDimTolObjects_DimensionObject::GetPresentationName ******/
		/****** md5 signature: ae4fdc476bfb8d85148da7be6e48c228 ******/
		%feature("compactdefaultargs") GetPresentationName;
		%feature("autodoc", "Return
-------
opencascade::handle<TCollection_HAsciiString>

Description
-----------
Returns graphical presentation of the object.
") GetPresentationName;
		opencascade::handle<TCollection_HAsciiString> GetPresentationName();

		/****** XCAFDimTolObjects_DimensionObject::GetQualifier ******/
		/****** md5 signature: e56b8b87f082bfb35d48c4ee1824ba5a ******/
		%feature("compactdefaultargs") GetQualifier;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_DimensionQualifier

Description
-----------
Returns dimension qualifier.
") GetQualifier;
		XCAFDimTolObjects_DimensionQualifier GetQualifier();

		/****** XCAFDimTolObjects_DimensionObject::GetSemanticName ******/
		/****** md5 signature: 914ea6563027cdf692e218da5b1136d4 ******/
		%feature("compactdefaultargs") GetSemanticName;
		%feature("autodoc", "Return
-------
opencascade::handle<TCollection_HAsciiString>

Description
-----------
Returns semantic name.
") GetSemanticName;
		opencascade::handle<TCollection_HAsciiString> GetSemanticName();

		/****** XCAFDimTolObjects_DimensionObject::GetType ******/
		/****** md5 signature: bd5e4ead327a740fbdd88a31eb6c5670 ******/
		%feature("compactdefaultargs") GetType;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_DimensionType

Description
-----------
Returns dimension type.
") GetType;
		XCAFDimTolObjects_DimensionType GetType();

		/****** XCAFDimTolObjects_DimensionObject::GetUpperBound ******/
		/****** md5 signature: f7f657272409b790d778fe5c3a6c0683 ******/
		%feature("compactdefaultargs") GetUpperBound;
		%feature("autodoc", "Return
-------
float

Description
-----------
Returns the upper bound of the range dimension, otherwise - zero.
") GetUpperBound;
		Standard_Real GetUpperBound();

		/****** XCAFDimTolObjects_DimensionObject::GetUpperTolValue ******/
		/****** md5 signature: 7f84a90537f1e0d269263854062fb547 ******/
		%feature("compactdefaultargs") GetUpperTolValue;
		%feature("autodoc", "Return
-------
float

Description
-----------
Returns the lower value of the toleranced dimension, otherwise - zero.
") GetUpperTolValue;
		Standard_Real GetUpperTolValue();

		/****** XCAFDimTolObjects_DimensionObject::GetValue ******/
		/****** md5 signature: 2863c7a566efd7be6530d131f7f2cf29 ******/
		%feature("compactdefaultargs") GetValue;
		%feature("autodoc", "Return
-------
float

Description
-----------
Returns the main dimension value. It will be the middle value in case of range dimension.
") GetValue;
		Standard_Real GetValue();

		/****** XCAFDimTolObjects_DimensionObject::GetValues ******/
		/****** md5 signature: c65722835b4c563a820889b9b9297d8a ******/
		%feature("compactdefaultargs") GetValues;
		%feature("autodoc", "Return
-------
opencascade::handle<TColStd_HArray1OfReal>

Description
-----------
Returns raw array of dimension values.
") GetValues;
		opencascade::handle<TColStd_HArray1OfReal> GetValues();

		/****** XCAFDimTolObjects_DimensionObject::HasAngularQualifier ******/
		/****** md5 signature: c0ae146472fe74681d928f8e33adc449 ******/
		%feature("compactdefaultargs") HasAngularQualifier;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the object has angular qualifier.
") HasAngularQualifier;
		Standard_Boolean HasAngularQualifier();

		/****** XCAFDimTolObjects_DimensionObject::HasDescriptions ******/
		/****** md5 signature: a29882da325e9c2ee8b0fd068b89d92c ******/
		%feature("compactdefaultargs") HasDescriptions;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns true, if the object has descriptions.
") HasDescriptions;
		Standard_Boolean HasDescriptions();

		/****** XCAFDimTolObjects_DimensionObject::HasPlane ******/
		/****** md5 signature: 7cf03566771455c19f444d8a2236d65d ******/
		%feature("compactdefaultargs") HasPlane;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the object has annotation plane.
") HasPlane;
		Standard_Boolean HasPlane();

		/****** XCAFDimTolObjects_DimensionObject::HasPoint ******/
		/****** md5 signature: 8de3c013a7c1611c02e38dffb22d1c6b ******/
		%feature("compactdefaultargs") HasPoint;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns true, if connection point exists (for dimensional_size), if connection point for the first shape exists (for dimensional_location).
") HasPoint;
		Standard_Boolean HasPoint();

		/****** XCAFDimTolObjects_DimensionObject::HasPoint2 ******/
		/****** md5 signature: d0e648b8b854584c60c14c4e48233f5f ******/
		%feature("compactdefaultargs") HasPoint2;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") HasPoint2;
		Standard_Boolean HasPoint2();

		/****** XCAFDimTolObjects_DimensionObject::HasQualifier ******/
		/****** md5 signature: 9764a979a208be8307172054072f77c6 ******/
		%feature("compactdefaultargs") HasQualifier;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the object has dimension qualifier.
") HasQualifier;
		Standard_Boolean HasQualifier();

		/****** XCAFDimTolObjects_DimensionObject::HasTextPoint ******/
		/****** md5 signature: 28189ad30d8d9631ec7e30fd59536f6e ******/
		%feature("compactdefaultargs") HasTextPoint;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the position of dimension text is specified.
") HasTextPoint;
		Standard_Boolean HasTextPoint();

		/****** XCAFDimTolObjects_DimensionObject::IsDimWithClassOfTolerance ******/
		/****** md5 signature: 343c29ecd69891568c9a9fe7e33553f2 ******/
		%feature("compactdefaultargs") IsDimWithClassOfTolerance;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the form variance was set to not XCAFDimTolObjects_DimensionFormVariance_None value.
") IsDimWithClassOfTolerance;
		Standard_Boolean IsDimWithClassOfTolerance();

		/****** XCAFDimTolObjects_DimensionObject::IsDimWithPlusMinusTolerance ******/
		/****** md5 signature: fd1a809368094942606845789648b18d ******/
		%feature("compactdefaultargs") IsDimWithPlusMinusTolerance;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the dimension is of +/- tolerance kind. Dimension is of +/- tolerance kind if its values array contains three elements defining the main value and the lower/upper tolerances.
") IsDimWithPlusMinusTolerance;
		Standard_Boolean IsDimWithPlusMinusTolerance();

		/****** XCAFDimTolObjects_DimensionObject::IsDimWithRange ******/
		/****** md5 signature: 5e415bcacbf6b8754f400f99b06dd87d ******/
		%feature("compactdefaultargs") IsDimWithRange;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the dimension is of range kind. Dimension is of range kind if its values array contains two elements defining lower and upper bounds.
") IsDimWithRange;
		Standard_Boolean IsDimWithRange();

		/****** XCAFDimTolObjects_DimensionObject::NbDescriptions ******/
		/****** md5 signature: 4c4971728539b7092ceee3c61e16666d ******/
		%feature("compactdefaultargs") NbDescriptions;
		%feature("autodoc", "Return
-------
int

Description
-----------
Returns number of descriptions.
") NbDescriptions;
		Standard_Integer NbDescriptions();

		/****** XCAFDimTolObjects_DimensionObject::RemoveDescription ******/
		/****** md5 signature: ee32f9f2826c5dc1d626573c9aa3fd3c ******/
		%feature("compactdefaultargs") RemoveDescription;
		%feature("autodoc", "
Parameters
----------
theNumber: int

Return
-------
None

Description
-----------
Remove description with the given number.
") RemoveDescription;
		void RemoveDescription(const Standard_Integer theNumber);

		/****** XCAFDimTolObjects_DimensionObject::SetAngularQualifier ******/
		/****** md5 signature: cf4d95e9599ca795141ca10e5321fe6e ******/
		%feature("compactdefaultargs") SetAngularQualifier;
		%feature("autodoc", "
Parameters
----------
theAngularQualifier: XCAFDimTolObjects_AngularQualifier

Return
-------
None

Description
-----------
Sets angular qualifier as small, large or equal.
") SetAngularQualifier;
		void SetAngularQualifier(const XCAFDimTolObjects_AngularQualifier theAngularQualifier);

		/****** XCAFDimTolObjects_DimensionObject::SetClassOfTolerance ******/
		/****** md5 signature: 73c5d12561a820f6615237d0257d08e9 ******/
		%feature("compactdefaultargs") SetClassOfTolerance;
		%feature("autodoc", "
Parameters
----------
theHole: bool
theFormVariance: XCAFDimTolObjects_DimensionFormVariance
theGrade: XCAFDimTolObjects_DimensionGrade

Return
-------
None

Description
-----------
Sets tolerance class of the dimension. \param theHole - True if the tolerance applies to an internal feature \param theFormVariance - represents the fundamental deviation or 'position letter'  of the ISO 286 limits-and-fits tolerance classification. \param theGrade - represents the quality or the accuracy grade of a tolerance.
") SetClassOfTolerance;
		void SetClassOfTolerance(const Standard_Boolean theHole, const XCAFDimTolObjects_DimensionFormVariance theFormVariance, const XCAFDimTolObjects_DimensionGrade theGrade);

		/****** XCAFDimTolObjects_DimensionObject::SetDirection ******/
		/****** md5 signature: dd70d2e5545039397501429c9f6d0316 ******/
		%feature("compactdefaultargs") SetDirection;
		%feature("autodoc", "
Parameters
----------
theDir: gp_Dir

Return
-------
bool

Description
-----------
Sets an orientation of the dimension in annotation plane.
") SetDirection;
		Standard_Boolean SetDirection(const gp_Dir & theDir);

		/****** XCAFDimTolObjects_DimensionObject::SetLowerBound ******/
		/****** md5 signature: 8573b334b990276727957af5ab003a79 ******/
		%feature("compactdefaultargs") SetLowerBound;
		%feature("autodoc", "
Parameters
----------
theLowerBound: float

Return
-------
None

Description
-----------
Sets the lower bound of the range dimension, otherwise resets it to an empty range with the specified lower bound.
") SetLowerBound;
		void SetLowerBound(const Standard_Real theLowerBound);

		/****** XCAFDimTolObjects_DimensionObject::SetLowerTolValue ******/
		/****** md5 signature: 6c70862e28548ec0c7e8b7433a2be50c ******/
		%feature("compactdefaultargs") SetLowerTolValue;
		%feature("autodoc", "
Parameters
----------
theLowerTolValue: float

Return
-------
bool

Description
-----------
Sets the lower value of the toleranced dimension, otherwise resets a simple dimension to toleranced one with the specified lower/upper tolerances. Returns False in case of range dimension.
") SetLowerTolValue;
		Standard_Boolean SetLowerTolValue(const Standard_Real theLowerTolValue);

		/****** XCAFDimTolObjects_DimensionObject::SetModifiers ******/
		/****** md5 signature: 19fb3ee31fa40691139898e74f82abec ******/
		%feature("compactdefaultargs") SetModifiers;
		%feature("autodoc", "
Parameters
----------
theModifiers: XCAFDimTolObjects_DimensionModifiersSequence

Return
-------
None

Description
-----------
Sets new sequence of dimension modifiers.
") SetModifiers;
		void SetModifiers(const XCAFDimTolObjects_DimensionModifiersSequence & theModifiers);

		/****** XCAFDimTolObjects_DimensionObject::SetNbOfDecimalPlaces ******/
		/****** md5 signature: 763c2a69c8382715c9dde8b6cbe70d29 ******/
		%feature("compactdefaultargs") SetNbOfDecimalPlaces;
		%feature("autodoc", "
Parameters
----------
theL: int
theR: int

Return
-------
None

Description
-----------
Sets the number of places to the left and right of the decimal point respectively.
") SetNbOfDecimalPlaces;
		void SetNbOfDecimalPlaces(const Standard_Integer theL, const Standard_Integer theR);

		/****** XCAFDimTolObjects_DimensionObject::SetPath ******/
		/****** md5 signature: 9dd5ad4e5143a918fce26f604e7c095a ******/
		%feature("compactdefaultargs") SetPath;
		%feature("autodoc", "
Parameters
----------
thePath: TopoDS_Edge

Return
-------
None

Description
-----------
Sets a 'curve' along which the dimension is measured.
") SetPath;
		void SetPath(const TopoDS_Edge & thePath);

		/****** XCAFDimTolObjects_DimensionObject::SetPlane ******/
		/****** md5 signature: 77a07ccd642257136673432fbd51e9ba ******/
		%feature("compactdefaultargs") SetPlane;
		%feature("autodoc", "
Parameters
----------
thePlane: gp_Ax2

Return
-------
None

Description
-----------
Sets annotation plane.
") SetPlane;
		void SetPlane(const gp_Ax2 & thePlane);

		/****** XCAFDimTolObjects_DimensionObject::SetPoint ******/
		/****** md5 signature: 366a57481a7ee35be93bd56983beb928 ******/
		%feature("compactdefaultargs") SetPoint;
		%feature("autodoc", "
Parameters
----------
thePnt: gp_Pnt

Return
-------
None

Description
-----------
Set connection point (for dimensional_size), Set connection point for the first shape (for dimensional_location).
") SetPoint;
		void SetPoint(const gp_Pnt & thePnt);

		/****** XCAFDimTolObjects_DimensionObject::SetPoint2 ******/
		/****** md5 signature: c4f1f34fb99406cc2260874f1d932235 ******/
		%feature("compactdefaultargs") SetPoint2;
		%feature("autodoc", "
Parameters
----------
thePnt: gp_Pnt

Return
-------
None

Description
-----------
No available documentation.
") SetPoint2;
		void SetPoint2(const gp_Pnt & thePnt);

		/****** XCAFDimTolObjects_DimensionObject::SetPointTextAttach ******/
		/****** md5 signature: 341561a939b1838061b22f9114c6f676 ******/
		%feature("compactdefaultargs") SetPointTextAttach;
		%feature("autodoc", "
Parameters
----------
thePntText: gp_Pnt

Return
-------
None

Description
-----------
Sets position of the dimension text.
") SetPointTextAttach;
		void SetPointTextAttach(const gp_Pnt & thePntText);

		/****** XCAFDimTolObjects_DimensionObject::SetPresentation ******/
		/****** md5 signature: d9f84931766936490b58688f84fa9fa9 ******/
		%feature("compactdefaultargs") SetPresentation;
		%feature("autodoc", "
Parameters
----------
thePresentation: TopoDS_Shape
thePresentationName: TCollection_HAsciiString

Return
-------
None

Description
-----------
Set graphical presentation for the object.
") SetPresentation;
		void SetPresentation(const TopoDS_Shape & thePresentation, const opencascade::handle<TCollection_HAsciiString> & thePresentationName);

		/****** XCAFDimTolObjects_DimensionObject::SetQualifier ******/
		/****** md5 signature: bbd0001df2bb9d2dbbe1969914014061 ******/
		%feature("compactdefaultargs") SetQualifier;
		%feature("autodoc", "
Parameters
----------
theQualifier: XCAFDimTolObjects_DimensionQualifier

Return
-------
None

Description
-----------
Sets dimension qualifier as min., max. or average.
") SetQualifier;
		void SetQualifier(const XCAFDimTolObjects_DimensionQualifier theQualifier);

		/****** XCAFDimTolObjects_DimensionObject::SetSemanticName ******/
		/****** md5 signature: 1ae0d4c111cc04ac024e398eb0d74f97 ******/
		%feature("compactdefaultargs") SetSemanticName;
		%feature("autodoc", "
Parameters
----------
theName: TCollection_HAsciiString

Return
-------
None

Description
-----------
Sets semantic name.
") SetSemanticName;
		void SetSemanticName(const opencascade::handle<TCollection_HAsciiString> & theName);

		/****** XCAFDimTolObjects_DimensionObject::SetType ******/
		/****** md5 signature: f42664d4cf787c360f3e8c514b558de6 ******/
		%feature("compactdefaultargs") SetType;
		%feature("autodoc", "
Parameters
----------
theTyupe: XCAFDimTolObjects_DimensionType

Return
-------
None

Description
-----------
Sets a specific type of dimension.
") SetType;
		void SetType(const XCAFDimTolObjects_DimensionType theTyupe);

		/****** XCAFDimTolObjects_DimensionObject::SetUpperBound ******/
		/****** md5 signature: 9459ed50736fb30efb39b05405ad7e8f ******/
		%feature("compactdefaultargs") SetUpperBound;
		%feature("autodoc", "
Parameters
----------
theUpperBound: float

Return
-------
None

Description
-----------
Sets the upper bound of the range dimension, otherwise resets it to an empty range with the specified upper bound.
") SetUpperBound;
		void SetUpperBound(const Standard_Real theUpperBound);

		/****** XCAFDimTolObjects_DimensionObject::SetUpperTolValue ******/
		/****** md5 signature: 1cb611d02a9917e651fdb4507035669d ******/
		%feature("compactdefaultargs") SetUpperTolValue;
		%feature("autodoc", "
Parameters
----------
theUperTolValue: float

Return
-------
bool

Description
-----------
Sets the upper value of the toleranced dimension, otherwise resets a simple dimension to toleranced one with the specified lower/upper tolerances. Returns False in case of range dimension.
") SetUpperTolValue;
		Standard_Boolean SetUpperTolValue(const Standard_Real theUperTolValue);

		/****** XCAFDimTolObjects_DimensionObject::SetValue ******/
		/****** md5 signature: 5bcfa037669ff7f132a0f41bd6780f3d ******/
		%feature("compactdefaultargs") SetValue;
		%feature("autodoc", "
Parameters
----------
theValue: float

Return
-------
None

Description
-----------
Sets the main dimension value. Overwrites previous values.
") SetValue;
		void SetValue(const Standard_Real theValue);

		/****** XCAFDimTolObjects_DimensionObject::SetValues ******/
		/****** md5 signature: 8b6e8145c45d231ecd41d0bbb1d99770 ******/
		%feature("compactdefaultargs") SetValues;
		%feature("autodoc", "
Parameters
----------
theValue: TColStd_HArray1OfReal

Return
-------
None

Description
-----------
Replaces current raw array of dimension values with theValues array.
") SetValues;
		void SetValues(const opencascade::handle<TColStd_HArray1OfReal> & theValue);

};


%make_alias(XCAFDimTolObjects_DimensionObject)

%extend XCAFDimTolObjects_DimensionObject {
	%pythoncode {
	__repr__ = _dumps_object
	}
};

/**********************************************
* class XCAFDimTolObjects_GeomToleranceObject *
**********************************************/
class XCAFDimTolObjects_GeomToleranceObject : public Standard_Transient {
	public:
		/****** XCAFDimTolObjects_GeomToleranceObject::XCAFDimTolObjects_GeomToleranceObject ******/
		/****** md5 signature: 8cd9dc8b0cebda31706f05d9938befd7 ******/
		%feature("compactdefaultargs") XCAFDimTolObjects_GeomToleranceObject;
		%feature("autodoc", "Return
-------
None

Description
-----------
No available documentation.
") XCAFDimTolObjects_GeomToleranceObject;
		 XCAFDimTolObjects_GeomToleranceObject();

		/****** XCAFDimTolObjects_GeomToleranceObject::XCAFDimTolObjects_GeomToleranceObject ******/
		/****** md5 signature: 9874913cc7fa144dfeb0ace60377f629 ******/
		%feature("compactdefaultargs") XCAFDimTolObjects_GeomToleranceObject;
		%feature("autodoc", "
Parameters
----------
theObj: XCAFDimTolObjects_GeomToleranceObject

Return
-------
None

Description
-----------
No available documentation.
") XCAFDimTolObjects_GeomToleranceObject;
		 XCAFDimTolObjects_GeomToleranceObject(const opencascade::handle<XCAFDimTolObjects_GeomToleranceObject> & theObj);

		/****** XCAFDimTolObjects_GeomToleranceObject::AddModifier ******/
		/****** md5 signature: e51adce582bb77089a780be8e9654ea2 ******/
		%feature("compactdefaultargs") AddModifier;
		%feature("autodoc", "
Parameters
----------
theModifier: XCAFDimTolObjects_GeomToleranceModif

Return
-------
None

Description
-----------
Adds a tolerance modifier to the sequence of modifiers.
") AddModifier;
		void AddModifier(const XCAFDimTolObjects_GeomToleranceModif theModifier);


        /****************** DumpJson ******************/
        %feature("autodoc", "
Parameters
----------
depth: int, default=-1

Return
-------
str

Description
-----------
Dump the object to JSON string.
") DumpJson;
        %extend{
            std::string DumpJson(int depth=-1) {
            std::stringstream s;
            self->DumpJson(s, depth);
            return "{" + s.str() + "}" ;}
        };
		/****** XCAFDimTolObjects_GeomToleranceObject::GetAffectedPlane ******/
		/****** md5 signature: a2b83a410ab5eca7c1125298d914df55 ******/
		%feature("compactdefaultargs") GetAffectedPlane;
		%feature("autodoc", "Return
-------
gp_Pln

Description
-----------
Returns affected plane.
") GetAffectedPlane;
		const gp_Pln GetAffectedPlane();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetAffectedPlaneType ******/
		/****** md5 signature: 6060836a6ae29fcfba33448e802cf055 ******/
		%feature("compactdefaultargs") GetAffectedPlaneType;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_ToleranceZoneAffectedPlane

Description
-----------
No available documentation.
") GetAffectedPlaneType;
		XCAFDimTolObjects_ToleranceZoneAffectedPlane GetAffectedPlaneType();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetAxis ******/
		/****** md5 signature: 876918b464eea6100446926192b36b4a ******/
		%feature("compactdefaultargs") GetAxis;
		%feature("autodoc", "Return
-------
gp_Ax2

Description
-----------
No available documentation.
") GetAxis;
		gp_Ax2 GetAxis();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetMaterialRequirementModifier ******/
		/****** md5 signature: c386afc06e956e0910c6dfbfdc4cbad7 ******/
		%feature("compactdefaultargs") GetMaterialRequirementModifier;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_GeomToleranceMatReqModif

Description
-----------
Returns material requirement of the tolerance.
") GetMaterialRequirementModifier;
		XCAFDimTolObjects_GeomToleranceMatReqModif GetMaterialRequirementModifier();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetMaxValueModifier ******/
		/****** md5 signature: 8486b8ab1d9384fda0f47270555163c9 ******/
		%feature("compactdefaultargs") GetMaxValueModifier;
		%feature("autodoc", "Return
-------
float

Description
-----------
Returns the maximal upper tolerance.
") GetMaxValueModifier;
		Standard_Real GetMaxValueModifier();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetModifiers ******/
		/****** md5 signature: 4b597c6c86736610c0b2458d359046ef ******/
		%feature("compactdefaultargs") GetModifiers;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_GeomToleranceModifiersSequence

Description
-----------
Returns a sequence of modifiers of the tolerance.
") GetModifiers;
		XCAFDimTolObjects_GeomToleranceModifiersSequence GetModifiers();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetPlane ******/
		/****** md5 signature: 236cce5d8f8ab5feac0e3f6311bd05f0 ******/
		%feature("compactdefaultargs") GetPlane;
		%feature("autodoc", "Return
-------
gp_Ax2

Description
-----------
Returns annotation plane.
") GetPlane;
		const gp_Ax2 GetPlane();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetPoint ******/
		/****** md5 signature: 75bde715a8ee43e7500d44b575591a80 ******/
		%feature("compactdefaultargs") GetPoint;
		%feature("autodoc", "Return
-------
gp_Pnt

Description
-----------
Returns reference point.
") GetPoint;
		const gp_Pnt GetPoint();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetPointTextAttach ******/
		/****** md5 signature: e81e077f484c7c68ce183e571e4969e7 ******/
		%feature("compactdefaultargs") GetPointTextAttach;
		%feature("autodoc", "Return
-------
gp_Pnt

Description
-----------
Returns the text position.
") GetPointTextAttach;
		const gp_Pnt GetPointTextAttach();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetPresentation ******/
		/****** md5 signature: 3a1ba105c920c672ad36e26c32c03ea0 ******/
		%feature("compactdefaultargs") GetPresentation;
		%feature("autodoc", "Return
-------
TopoDS_Shape

Description
-----------
Returns graphical presentation of the object.
") GetPresentation;
		TopoDS_Shape GetPresentation();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetPresentationName ******/
		/****** md5 signature: ae4fdc476bfb8d85148da7be6e48c228 ******/
		%feature("compactdefaultargs") GetPresentationName;
		%feature("autodoc", "Return
-------
opencascade::handle<TCollection_HAsciiString>

Description
-----------
Returns graphical presentation of the object.
") GetPresentationName;
		opencascade::handle<TCollection_HAsciiString> GetPresentationName();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetSemanticName ******/
		/****** md5 signature: 914ea6563027cdf692e218da5b1136d4 ******/
		%feature("compactdefaultargs") GetSemanticName;
		%feature("autodoc", "Return
-------
opencascade::handle<TCollection_HAsciiString>

Description
-----------
Returns semantic name.
") GetSemanticName;
		opencascade::handle<TCollection_HAsciiString> GetSemanticName();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetType ******/
		/****** md5 signature: da7c24562a67c93b80b97fb882ba1b25 ******/
		%feature("compactdefaultargs") GetType;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_GeomToleranceType

Description
-----------
Returns type of the object.
") GetType;
		XCAFDimTolObjects_GeomToleranceType GetType();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetTypeOfValue ******/
		/****** md5 signature: dc62c2d3fdbefbb517926b5f2fcca341 ******/
		%feature("compactdefaultargs") GetTypeOfValue;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_GeomToleranceTypeValue

Description
-----------
Returns type of tolerance value.
") GetTypeOfValue;
		XCAFDimTolObjects_GeomToleranceTypeValue GetTypeOfValue();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetValue ******/
		/****** md5 signature: 2863c7a566efd7be6530d131f7f2cf29 ******/
		%feature("compactdefaultargs") GetValue;
		%feature("autodoc", "Return
-------
float

Description
-----------
Returns tolerance value.
") GetValue;
		Standard_Real GetValue();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetValueOfZoneModifier ******/
		/****** md5 signature: e0cd44399ccf3b5576e8bf1a5aca899b ******/
		%feature("compactdefaultargs") GetValueOfZoneModifier;
		%feature("autodoc", "Return
-------
float

Description
-----------
Returns value associated with tolerance zone.
") GetValueOfZoneModifier;
		Standard_Real GetValueOfZoneModifier();

		/****** XCAFDimTolObjects_GeomToleranceObject::GetZoneModifier ******/
		/****** md5 signature: 454b9ee7f2e4e18a2de3523c5eb315c7 ******/
		%feature("compactdefaultargs") GetZoneModifier;
		%feature("autodoc", "Return
-------
XCAFDimTolObjects_GeomToleranceZoneModif

Description
-----------
Returns tolerance zone.
") GetZoneModifier;
		XCAFDimTolObjects_GeomToleranceZoneModif GetZoneModifier();

		/****** XCAFDimTolObjects_GeomToleranceObject::HasAffectedPlane ******/
		/****** md5 signature: 665f798d616b084cef9e434b59f799d1 ******/
		%feature("compactdefaultargs") HasAffectedPlane;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") HasAffectedPlane;
		bool HasAffectedPlane();

		/****** XCAFDimTolObjects_GeomToleranceObject::HasAxis ******/
		/****** md5 signature: 4b18911068f4a18ff4ad5450250ccfda ******/
		%feature("compactdefaultargs") HasAxis;
		%feature("autodoc", "Return
-------
bool

Description
-----------
No available documentation.
") HasAxis;
		Standard_Boolean HasAxis();

		/****** XCAFDimTolObjects_GeomToleranceObject::HasPlane ******/
		/****** md5 signature: 7cf03566771455c19f444d8a2236d65d ******/
		%feature("compactdefaultargs") HasPlane;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if the object has annotation plane.
") HasPlane;
		Standard_Boolean HasPlane();

		/****** XCAFDimTolObjects_GeomToleranceObject::HasPoint ******/
		/****** md5 signature: 8de3c013a7c1611c02e38dffb22d1c6b ******/
		%feature("compactdefaultargs") HasPoint;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if reference point is specified.
") HasPoint;
		Standard_Boolean HasPoint();

		/****** XCAFDimTolObjects_GeomToleranceObject::HasPointText ******/
		/****** md5 signature: 0bf2ec86538f2cbb875c1c0a8313563e ******/
		%feature("compactdefaultargs") HasPointText;
		%feature("autodoc", "Return
-------
bool

Description
-----------
Returns True if text position is specified.
") HasPointText;
		Standard_Boolean HasPointText();

		/****** XCAFDimTolObjects_GeomToleranceObject::SetAffectedPlane ******/
		/****** md5 signature: 591f4b5261bb41f55d66281190c2c214 ******/
		%feature("compactdefaultargs") SetAffectedPlane;
		%feature("autodoc", "
Parameters
----------
thePlane: gp_Pln

Return
-------
None

Description
-----------
Sets affected plane.
") SetAffectedPlane;
		void SetAffectedPlane(const gp_Pln & thePlane);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetAffectedPlane ******/
		/****** md5 signature: 135e42e8e355e11d67511b9f230a798c ******/
		%feature("compactdefaultargs") SetAffectedPlane;
		%feature("autodoc", "
Parameters
----------
thePlane: gp_Pln
theType: XCAFDimTolObjects_ToleranceZoneAffectedPlane

Return
-------
None

Description
-----------
Sets affected plane.
") SetAffectedPlane;
		void SetAffectedPlane(const gp_Pln & thePlane, const XCAFDimTolObjects_ToleranceZoneAffectedPlane theType);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetAffectedPlaneType ******/
		/****** md5 signature: 89c0a2fd72bf9863e86c4f315cb5bbd4 ******/
		%feature("compactdefaultargs") SetAffectedPlaneType;
		%feature("autodoc", "
Parameters
----------
theType: XCAFDimTolObjects_ToleranceZoneAffectedPlane

Return
-------
None

Description
-----------
No available documentation.
") SetAffectedPlaneType;
		void SetAffectedPlaneType(const XCAFDimTolObjects_ToleranceZoneAffectedPlane theType);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetAxis ******/
		/****** md5 signature: 54e51f1310b6be8e02c312df4bfb237e ******/
		%feature("compactdefaultargs") SetAxis;
		%feature("autodoc", "
Parameters
----------
theAxis: gp_Ax2

Return
-------
None

Description
-----------
No available documentation.
") SetAxis;
		void SetAxis(const gp_Ax2 & theAxis);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetMaterialRequirementModifier ******/
		/****** md5 signature: de1309ae344830665d02742b0e761a4c ******/
		%feature("compactdefaultargs") SetMaterialRequirementModifier;
		%feature("autodoc", "
Parameters
----------
theMatReqModif: XCAFDimTolObjects_GeomToleranceMatReqModif

Return
-------
None

Description
-----------
Sets material requirement of the tolerance.
") SetMaterialRequirementModifier;
		void SetMaterialRequirementModifier(const XCAFDimTolObjects_GeomToleranceMatReqModif theMatReqModif);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetMaxValueModifier ******/
		/****** md5 signature: 3cd7df21a5f0df40d2c7ef955188b31a ******/
		%feature("compactdefaultargs") SetMaxValueModifier;
		%feature("autodoc", "
Parameters
----------
theModifier: float

Return
-------
None

Description
-----------
Sets the maximal upper tolerance value for tolerance with modifiers.
") SetMaxValueModifier;
		void SetMaxValueModifier(const Standard_Real theModifier);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetModifiers ******/
		/****** md5 signature: aec6e8a9f31cb3230ca80908216c9673 ******/
		%feature("compactdefaultargs") SetModifiers;
		%feature("autodoc", "
Parameters
----------
theModifiers: XCAFDimTolObjects_GeomToleranceModifiersSequence

Return
-------
None

Description
-----------
Sets new sequence of tolerance modifiers.
") SetModifiers;
		void SetModifiers(const XCAFDimTolObjects_GeomToleranceModifiersSequence & theModifiers);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetPlane ******/
		/****** md5 signature: 77a07ccd642257136673432fbd51e9ba ******/
		%feature("compactdefaultargs") SetPlane;
		%feature("autodoc", "
Parameters
----------
thePlane: gp_Ax2

Return
-------
None

Description
-----------
Sets annotation plane.
") SetPlane;
		void SetPlane(const gp_Ax2 & thePlane);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetPoint ******/
		/****** md5 signature: 366a57481a7ee35be93bd56983beb928 ******/
		%feature("compactdefaultargs") SetPoint;
		%feature("autodoc", "
Parameters
----------
thePnt: gp_Pnt

Return
-------
None

Description
-----------
Sets reference point.
") SetPoint;
		void SetPoint(const gp_Pnt & thePnt);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetPointTextAttach ******/
		/****** md5 signature: 341561a939b1838061b22f9114c6f676 ******/
		%feature("compactdefaultargs") SetPointTextAttach;
		%feature("autodoc", "
Parameters
----------
thePntText: gp_Pnt

Return
-------
None

Description
-----------
Sets text position.
") SetPointTextAttach;
		void SetPointTextAttach(const gp_Pnt & thePntText);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetPresentation ******/
		/****** md5 signature: d9f84931766936490b58688f84fa9fa9 ******/
		%feature("compactdefaultargs") SetPresentation;
		%feature("autodoc", "
Parameters
----------
thePresentation: TopoDS_Shape
thePresentationName: TCollection_HAsciiString

Return
-------
None

Description
-----------
Set graphical presentation for object.
") SetPresentation;
		void SetPresentation(const TopoDS_Shape & thePresentation, const opencascade::handle<TCollection_HAsciiString> & thePresentationName);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetSemanticName ******/
		/****** md5 signature: 1ae0d4c111cc04ac024e398eb0d74f97 ******/
		%feature("compactdefaultargs") SetSemanticName;
		%feature("autodoc", "
Parameters
----------
theName: TCollection_HAsciiString

Return
-------
None

Description
-----------
Sets semantic name.
") SetSemanticName;
		void SetSemanticName(const opencascade::handle<TCollection_HAsciiString> & theName);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetType ******/
		/****** md5 signature: 4b15d55f2f69f9c27afb8c650c8e94fb ******/
		%feature("compactdefaultargs") SetType;
		%feature("autodoc", "
Parameters
----------
theType: XCAFDimTolObjects_GeomToleranceType

Return
-------
None

Description
-----------
Sets type of the object.
") SetType;
		void SetType(const XCAFDimTolObjects_GeomToleranceType theType);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetTypeOfValue ******/
		/****** md5 signature: 38f3d7f69ea62d58d4906f1c9b9c54ea ******/
		%feature("compactdefaultargs") SetTypeOfValue;
		%feature("autodoc", "
Parameters
----------
theTypeOfValue: XCAFDimTolObjects_GeomToleranceTypeValue

Return
-------
None

Description
-----------
Sets type of tolerance value.
") SetTypeOfValue;
		void SetTypeOfValue(const XCAFDimTolObjects_GeomToleranceTypeValue theTypeOfValue);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetValue ******/
		/****** md5 signature: 5bcfa037669ff7f132a0f41bd6780f3d ******/
		%feature("compactdefaultargs") SetValue;
		%feature("autodoc", "
Parameters
----------
theValue: float

Return
-------
None

Description
-----------
Sets tolerance value.
") SetValue;
		void SetValue(const Standard_Real theValue);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetValueOfZoneModifier ******/
		/****** md5 signature: c69f1d85198f0ee12579cac980cafac9 ******/
		%feature("compactdefaultargs") SetValueOfZoneModifier;
		%feature("autodoc", "
Parameters
----------
theValue: float

Return
-------
None

Description
-----------
Sets value associated with tolerance zone.
") SetValueOfZoneModifier;
		void SetValueOfZoneModifier(const Standard_Real theValue);

		/****** XCAFDimTolObjects_GeomToleranceObject::SetZoneModifier ******/
		/****** md5 signature: cf062d025851c9ffd52ff08a1ac15fb6 ******/
		%feature("compactdefaultargs") SetZoneModifier;
		%feature("autodoc", "
Parameters
----------
theZoneModif: XCAFDimTolObjects_GeomToleranceZoneModif

Return
-------
None

Description
-----------
Sets tolerance zone.
") SetZoneModifier;
		void SetZoneModifier(const XCAFDimTolObjects_GeomToleranceZoneModif theZoneModif);

};


%make_alias(XCAFDimTolObjects_GeomToleranceObject)

%extend XCAFDimTolObjects_GeomToleranceObject {
	%pythoncode {
	__repr__ = _dumps_object
	}
};

/*******************************
* class XCAFDimTolObjects_Tool *
*******************************/
class XCAFDimTolObjects_Tool {
	public:
		/****** XCAFDimTolObjects_Tool::XCAFDimTolObjects_Tool ******/
		/****** md5 signature: ffa7452f099cd24d19249cb9debd4fda ******/
		%feature("compactdefaultargs") XCAFDimTolObjects_Tool;
		%feature("autodoc", "
Parameters
----------
theDoc: TDocStd_Document

Return
-------
None

Description
-----------
No available documentation.
") XCAFDimTolObjects_Tool;
		 XCAFDimTolObjects_Tool(const opencascade::handle<TDocStd_Document> & theDoc);

		/****** XCAFDimTolObjects_Tool::GetDimensions ******/
		/****** md5 signature: 3ec09e7fdddcf9e8b8057fddd723189e ******/
		%feature("compactdefaultargs") GetDimensions;
		%feature("autodoc", "
Parameters
----------
theDimensionObjectSequence: XCAFDimTolObjects_DimensionObjectSequence

Return
-------
None

Description
-----------
Returns a sequence of Dimensions currently stored in the GD&T table.
") GetDimensions;
		void GetDimensions(XCAFDimTolObjects_DimensionObjectSequence & theDimensionObjectSequence);

		/****** XCAFDimTolObjects_Tool::GetGeomTolerances ******/
		/****** md5 signature: efd81f037226e8c3624a047d83c013f0 ******/
		%feature("compactdefaultargs") GetGeomTolerances;
		%feature("autodoc", "
Parameters
----------
theGeomToleranceObjectSequence: XCAFDimTolObjects_GeomToleranceObjectSequence
theDatumObjectSequence: XCAFDimTolObjects_DatumObjectSequence
theMap: XCAFDimTolObjects_DataMapOfToleranceDatum

Return
-------
None

Description
-----------
Returns a sequence of Tolerances currently stored in the GD&T table.
") GetGeomTolerances;
		void GetGeomTolerances(XCAFDimTolObjects_GeomToleranceObjectSequence & theGeomToleranceObjectSequence, XCAFDimTolObjects_DatumObjectSequence & theDatumObjectSequence, XCAFDimTolObjects_DataMapOfToleranceDatum & theMap);

		/****** XCAFDimTolObjects_Tool::GetRefDatum ******/
		/****** md5 signature: e78d285dd71f7aad602496c5286ecc2e ******/
		%feature("compactdefaultargs") GetRefDatum;
		%feature("autodoc", "
Parameters
----------
theShape: TopoDS_Shape
theDatum: XCAFDimTolObjects_DatumObject

Return
-------
bool

Description
-----------
Returns DatumObject defined for Shape.
") GetRefDatum;
		Standard_Boolean GetRefDatum(const TopoDS_Shape & theShape, opencascade::handle<XCAFDimTolObjects_DatumObject> & theDatum);

		/****** XCAFDimTolObjects_Tool::GetRefDimensions ******/
		/****** md5 signature: da2a27056f052bead73df4e92b1dcc7e ******/
		%feature("compactdefaultargs") GetRefDimensions;
		%feature("autodoc", "
Parameters
----------
theShape: TopoDS_Shape
theDimensions: XCAFDimTolObjects_DimensionObjectSequence

Return
-------
bool

Description
-----------
Returns all Dimensions defined for Shape.
") GetRefDimensions;
		Standard_Boolean GetRefDimensions(const TopoDS_Shape & theShape, XCAFDimTolObjects_DimensionObjectSequence & theDimensions);

		/****** XCAFDimTolObjects_Tool::GetRefGeomTolerances ******/
		/****** md5 signature: 9362d8bc0e5541f0393b435b328720ba ******/
		%feature("compactdefaultargs") GetRefGeomTolerances;
		%feature("autodoc", "
Parameters
----------
theShape: TopoDS_Shape
theGeomToleranceObjectSequence: XCAFDimTolObjects_GeomToleranceObjectSequence
theDatumObjectSequence: XCAFDimTolObjects_DatumObjectSequence
theMap: XCAFDimTolObjects_DataMapOfToleranceDatum

Return
-------
bool

Description
-----------
Returns all GeomTolerances defined for Shape.
") GetRefGeomTolerances;
		Standard_Boolean GetRefGeomTolerances(const TopoDS_Shape & theShape, XCAFDimTolObjects_GeomToleranceObjectSequence & theGeomToleranceObjectSequence, XCAFDimTolObjects_DatumObjectSequence & theDatumObjectSequence, XCAFDimTolObjects_DataMapOfToleranceDatum & theMap);

};


%extend XCAFDimTolObjects_Tool {
	%pythoncode {
	__repr__ = _dumps_object
	}
};

/* harray1 classes */
/* harray2 classes */
/* hsequence classes */
/* class aliases */
%pythoncode {
}
