from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Message import *
from OCC.Core.XmlMDF import *
from OCC.Core.TCollection import *
from OCC.Core.TDocStd import *
from OCC.Core.PCDM import *
from OCC.Core.CDM import *
from OCC.Core.Storage import *

class XmlLDrivers_SequenceOfNamespaceDef:
    def Assign(self, theItem: XmlLDrivers_NamespaceDef) -> XmlLDrivers_NamespaceDef: ...
    def Clear(self) -> None: ...
    def First(self) -> XmlLDrivers_NamespaceDef: ...
    def IsDeletables(self) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def Last(self) -> XmlLDrivers_NamespaceDef: ...
    def Length(self) -> int: ...
    def Lower(self) -> int: ...
    def Prepend(
        self, theItem: XmlLDrivers_NamespaceDef
    ) -> XmlLDrivers_NamespaceDef: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def SetValue(self, theIndex: int, theValue: XmlLDrivers_NamespaceDef) -> None: ...
    def Size(self) -> int: ...
    def UpdateUpperBound(self, int) -> None: ...
    def UpdateLowerBound(self, int) -> None: ...
    def Upper(self) -> int: ...
    def Value(self, theIndex: int) -> XmlLDrivers_NamespaceDef: ...
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...

class xmlldrivers:
    @staticmethod
    def AttributeDrivers(theMsgDriver: Message_Messenger) -> XmlMDF_ADriverTable: ...
    @staticmethod
    def CreationDate() -> str: ...
    @staticmethod
    def DefineFormat(theApp: TDocStd_Application) -> None: ...
    @staticmethod
    def Factory(theGUID: Standard_GUID) -> Standard_Transient: ...

class XmlLDrivers_DocumentRetrievalDriver(PCDM_RetrievalDriver):
    def __init__(self) -> None: ...
    def AttributeDrivers(
        self, theMsgDriver: Message_Messenger
    ) -> XmlMDF_ADriverTable: ...
    @overload
    def Read(
        self,
        theFileName: str,
        theNewDocument: CDM_Document,
        theApplication: CDM_Application,
        theFilter: Optional[PCDM_ReaderFilter] = PCDM_ReaderFilter(),
        theRange: Optional[Message_ProgressRange] = Message_ProgressRange(),
    ) -> None: ...
    @overload
    def Read(
        self,
        theIStream: str,
        theStorageData: Storage_Data,
        theDoc: CDM_Document,
        theApplication: CDM_Application,
        theFilter: Optional[PCDM_ReaderFilter] = PCDM_ReaderFilter(),
        theRange: Optional[Message_ProgressRange] = Message_ProgressRange(),
    ) -> None: ...

class XmlLDrivers_DocumentStorageDriver(PCDM_StorageDriver):
    def __init__(self, theCopyright: str) -> None: ...
    def AttributeDrivers(
        self, theMsgDriver: Message_Messenger
    ) -> XmlMDF_ADriverTable: ...
    @overload
    def Write(
        self,
        theDocument: CDM_Document,
        theFileName: str,
        theRange: Optional[Message_ProgressRange] = Message_ProgressRange(),
    ) -> None: ...
    @overload
    def Write(
        self,
        theDocument: CDM_Document,
        theRange: Optional[Message_ProgressRange] = Message_ProgressRange(),
    ) -> str: ...

class XmlLDrivers_NamespaceDef:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, thePrefix: str, theURI: str) -> None: ...
    def Prefix(self) -> str: ...
    def URI(self) -> str: ...

# harray1 classes
# harray2 classes
# hsequence classes
