/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.resources.TextResource;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.tasks.wrapper.Wrapper;
import org.gradle.api.tasks.wrapper.internal.DefaultWrapperVersionsResources;

public abstract class WrapperPlugin
implements Plugin<Project> {
    private static final String SERVICES_GRADLE_ORG_VERSIONS_OVERRIDE_URL_PROPERTY = "org.gradle.internal.services.version.url.override";

    public void apply(Project project) {
        if (project.getParent() == null) {
            String versionUrl = WrapperPlugin.getVersionUrl();
            TextResourceFactory textFactory = project.getResources().getText();
            TextResource latest = textFactory.fromUri((Object)(versionUrl + "/current"));
            TextResource releaseCandidate = textFactory.fromUri((Object)(versionUrl + "/" + "release-candidate"));
            TextResource nightly = textFactory.fromUri((Object)(versionUrl + "/" + "nightly"));
            TextResource releaseNightly = textFactory.fromUri((Object)(versionUrl + "/" + "release-nightly"));
            project.getTasks().register("wrapper", Wrapper.class, wrapper -> {
                wrapper.setGroup("Build Setup");
                wrapper.setDescription("Generates Gradle wrapper files.");
                wrapper.getNetworkTimeout().convention((Object)10000);
                wrapper.setWrapperVersionsResources(new DefaultWrapperVersionsResources(latest, releaseCandidate, nightly, releaseNightly));
            });
        }
    }

    private static String getVersionUrl() {
        String baseUrl = System.getProperty(SERVICES_GRADLE_ORG_VERSIONS_OVERRIDE_URL_PROPERTY, "https://services.gradle.org");
        return baseUrl + "/versions";
    }
}

