/**
 * English translations
 * Professional terms (Skills, Plugins, Commands, Sessions, OpenCode, OpenPackage, OpenWork) are NOT translated
 */

export default {
  // ==================== Dashboard ====================
  "dashboard.title": "Dashboard",
  "dashboard.sessions": "Sessions",
  "dashboard.commands": "Commands",
  "dashboard.skills": "Skills",
  "dashboard.plugins": "Plugins",
  "dashboard.mcps": "MCPs",
  "dashboard.settings": "Settings",
  "dashboard.home": "Home",
  "dashboard.runs": "Runs",
  "dashboard.find_workspace": "Find workspace...",
  "dashboard.workspaces": "Workspaces",
  "dashboard.no_workspaces": "No matching workspaces.",
  "dashboard.new_workspace": "New Workspace...",
  "dashboard.new_remote_workspace": "Add Remote Workspace...",
  "dashboard.forget_workspace": "Forget workspace",
  "dashboard.remote": "Remote",
  "dashboard.connection": "Connection",
  "dashboard.local_engine": "Local Engine",
  "dashboard.client_mode": "Client Mode",
  "dashboard.connected": "Connected",
  "dashboard.not_connected": "Not connected",
  "dashboard.stop_disconnect": "Stop & Disconnect",
  "dashboard.disconnect": "Disconnect",
  "dashboard.new_task": "New Task",
  "dashboard.new": "New",
  "dashboard.busy": "Busy",
  "dashboard.hero_title": "What should we do today?",
  "dashboard.hero_description": "Describe an outcome. OpenWork will run it and keep an audit trail.",
  "dashboard.quick_start_commands": "Quick Start Commands",
  "dashboard.view_all": "View all",
  "dashboard.no_commands": "No commands yet. Starter commands will appear here.",
  "dashboard.run_command": "Run a saved command",
  "dashboard.recent_sessions": "Recent Sessions",
  "dashboard.this_workspace": "this workspace",
  "dashboard.no_sessions": "No sessions yet.",
  "dashboard.idle": "Idle",
  "dashboard.running": "Running",
  "dashboard.completed": "Completed",
  "dashboard.failed": "Failed",
  "dashboard.repairing_cache": "Repairing cache",
  "dashboard.repair_cache": "Repair cache",
  "dashboard.retry": "Retry",
  "dashboard.alpha": "Alpha",
  "dashboard.create_workspace_title": "Create Workspace",
  "dashboard.create_workspace_subtitle": "Initialize a new folder-based workspace.",
  "dashboard.create_workspace_confirm": "Create Workspace",
  "dashboard.create_remote_workspace_title": "Add Remote Workspace",
  "dashboard.create_remote_workspace_subtitle": "Save an OpenWork server as a workspace.",
  "dashboard.create_remote_workspace_confirm": "Add Workspace",
  "dashboard.edit_remote_workspace_title": "Edit Remote Connection",
  "dashboard.edit_remote_workspace_subtitle": "Update the OpenWork server details for this workspace.",
  "dashboard.edit_remote_workspace_confirm": "Save connection",
  "dashboard.remote_workspace_title": "Remote workspace",
  "dashboard.remote_workspace_hint": "Track an OpenWork server and reconnect anytime.",
  "dashboard.remote_base_url_label": "OpenWork server URL",
  "dashboard.remote_base_url_placeholder": "http://127.0.0.1:8787",
  "dashboard.remote_base_url_required": "Add a server URL to continue.",
  "dashboard.openwork_host_label": "OpenWork server URL",
  "dashboard.openwork_host_placeholder": "https://your-server.openwork.app",
  "dashboard.openwork_host_hint": "Use the URL shared by your OpenWork server.",
  "dashboard.openwork_host_token_label": "Access token",
  "dashboard.openwork_host_token_placeholder": "Paste your token",
  "dashboard.openwork_host_token_hint": "Optional. Paste the access token from the server to authenticate.",
  "dashboard.remote_mode_openwork_alpha": "OpenWork server",
  "dashboard.remote_mode_direct": "Direct (legacy)",
  "dashboard.remote_connection_openwork": "OpenWork",
  "dashboard.remote_connection_direct": "Direct",
  "dashboard.remote_directory_label": "Workspace directory (optional)",
  "dashboard.remote_directory_placeholder": "/home/team/project",
  "dashboard.remote_directory_hint": "Leave blank to use the server default.",
  "dashboard.remote_display_name_label": "Display name (optional)",
  "dashboard.remote_display_name_placeholder": "Design team workspace",
  "dashboard.select_folder": "Select Folder",
  "dashboard.choose_folder": "Choose a folder",
  "dashboard.choose_folder_next": "You will choose a directory next.",
  "dashboard.change": "Change",
  "dashboard.opening": "Opening...",
  "dashboard.choose_preset": "Choose Preset",
  "dashboard.choose_folder_continue": "Choose a folder to continue.",
  "dashboard.starter_workspace": "Starter workspace",
  "dashboard.starter_workspace_desc": "Preconfigured to show you how to use plugins, commands, and skills.",
  "dashboard.empty_workspace": "Empty workspace",
  "dashboard.empty_workspace_desc": "Start with a blank folder and add what you need.",

  // ==================== Workspace ====================
  "workspace.rename_title": "Edit workspace name",
  "workspace.rename_description": "Update the name shown in the sidebar.",
  "workspace.rename_label": "Workspace name",
  "workspace.rename_placeholder": "Design team workspace",

  // ==================== Session ====================
  "session.no_selected": "No session selected",
  "session.back_to_dashboard": "Back to dashboard",
  "session.new_task": "New task",
  "session.recents": "Recents",
  "session.recents_notice": "These tasks run locally and aren't synced across devices.",
  "session.ready_to_work_title": "Ready to work",
  "session.ready_to_work_description": "Describe a task. I'll show progress and ask for permissions when needed.",
  "session.document_label": "Document",
  "session.standard_label": "Standard",
  "session.no_artifacts_fallback": "No artifacts yet.",
  "session.active_plugins_label": "Active plugins",
  "session.active_plugins_count": "{count}",
  "session.no_plugins_loaded": "No plugins loaded.",
  "session.selected_folders_label": "Selected folders",
  "session.selected_folders_count": "{count}",
  "session.working_files_label": "Working files",
  "session.none_yet_label": "None yet.",
  "session.permission_required_title": "Permission Required",
  "session.permission_required_description": "OpenCode is requesting permission to continue.",
  "session.permission_label_uppercase": "Permission",
  "session.scope_label_uppercase": "Scope",
  "session.details_label": "Details",
  "session.steps_notice_text": "Steps will show as the task unfolds.",
  "session.ready_to_work": "Ready to work",
  "session.ready_description": "Describe a task. I'll show progress and ask for permissions when needed.",
  "session.hide_steps": "Hide steps",
  "session.view_steps": "View steps",
  "session.open": "Open",
  "session.reveal": "Reveal",
  "session.opened_toast": "Opened in default app.",
  "session.revealed_toast": "Revealed in file manager.",
  "session.artifact_path_missing": "Artifact path missing.",
  "session.desktop_only": "Open is only available in the desktop app.",
  "session.open_failed": "Could not open artifact.",
  "session.model": "Model",
  "session.ready": "Ready",
  "session.connect_provider": "Connect a provider to customize this.",
  "session.running": "Running",
  "session.progress": "Progress",
  "session.steps_notice": "Steps will show as the task unfolds.",
  "session.artifacts": "Artifacts",
  "session.no_artifacts": "No artifacts yet.",
  "session.context": "Context",
  "session.active_plugins": "Active plugins",
  "session.no_plugins": "No plugins loaded.",
  "session.selected_folders": "Selected folders",
  "session.working_files": "Working files",
  "session.none_yet": "None yet.",
  "session.document": "Document",
  "session.standard": "Standard",
  "session.try_notion_prompt": "Try it now: set up my CRM in Notion",
  "session.insert_prompt": "Insert prompt",
  "session.placeholder": "Ask OpenWork...",
  "session.run": "Run",
  "session.permission_required": "Permission Required",
  "session.permission_description": "OpenCode is requesting permission to continue.",
  "session.permission_label": "Permission",
  "session.scope_label": "Scope",
  "session.details": "Details",
  "session.deny": "Deny",
  "session.once": "Once",
  "session.allow_for_session": "Allow for session",

  "session.tasks_local_hint": "These tasks run locally and aren't synced across devices.",
  "session.recents_label": "Recents",
  "session.model_standard": "Standard",
  "session.run_button_title": "Run",
  "session.rename_title": "Rename session",
  "session.rename_description": "Update the name for this session.",
  "session.rename_label": "Session name",
  "session.rename_placeholder": "Enter a new name",
  // ==================== Commands ====================
  "commands.new": "New",
  "commands.empty_state": "Save a prompt or command so you can run it again in one tap.",
  "commands.workspace": "This workspace",
  "commands.global": "Every workspace",
  "commands.other": "Other commands",
  "commands.run": "Run",
  "commands.modal_title": "Save a reusable flow",
  "commands.modal_description": "Store a prompt or command for quick reuse.",
  "commands.name_label": "Command name",
  "commands.name_placeholder": "e.g. daily-standup",
  "commands.name_hint": "This becomes /daily-standup in OpenCode.",
  "commands.description_label": "Description (optional)",
  "commands.description_placeholder": "What does this command do?",
  "commands.template_label": "Instructions",
  "commands.template_placeholder": "Write the instructions you want to reuse…",
  "commands.template_hint": "Use $ARGUMENTS to accept details.",
  "commands.details_required": "Details",
  "commands.default_description": "Run a saved command",
  "commands.command_label": "Command",
  "commands.details_label": "Details",
  "commands.details_placeholder": "Add optional details",
  "commands.details_hint": "These details are passed to the command.",
  "commands.run_modal_title": "Run command",
  "commands.run_modal_description": "Add optional details before running.",
  "commands.run_modal_run": "Run command",
  "commands.name_will_be": "Will be created as",
  "commands.override_title": "Replace existing command?",
  "commands.override_description": "A command with this name already exists.",
  "commands.override_warning": "This will replace the existing \"{name}\" command. This action cannot be undone.",
  "commands.override_confirm": "Replace",
  "commands.override_cancel": "Keep existing",

  // ==================== Skills ====================
  "skills.title": "Skills",
  "skills.subtitle": "Manage skills for this workspace.",
  "skills.refresh": "Refresh",
  "skills.add_title": "Add skills",
  "skills.add_description": "Install a starter command, import a skill, or open the folder.",
  "skills.install_from_openpackage": "Install from OpenPackage",
  "skills.host_mode_only": "Local workspace only",
  "skills.install": "Install",
  "skills.installed_label": "Installed",
  "skills.install_hint": "Installs OpenPackage packages into the current workspace. Skills should land in `.opencode/skills`.",
  "skills.import_local": "Import local skill",
  "skills.import_local_hint": "Copy an existing skill folder into this workspace.",
  "skills.import": "Import",
  "skills.curated_packages": "Curated packages",
  "skills.view": "View",
  "skills.search_placeholder": "Search packages or lists (e.g. claude, registry, community)",
  "skills.no_matches": "No curated matches. Try a different search.",
  "skills.install_package": "Install",
  "skills.registry_notice": "Publishing to the OpenPackage registry (`opkg push`) requires authentication today. A registry search + curated list sync is planned.",
  "skills.installed": "Installed skills",
  "skills.no_skills": "No skills detected in `.opencode/skills` or `.claude/skills`.",
  "skills.desktop_required": "Skill management requires the desktop app.",
  "skills.host_only_error": "Skill management requires a local workspace or connected OpenWork server.",
  "skills.install_skill_creator": "Install skill creator",
  "skills.install_skill_creator_hint": "This skill allows you to create other skills from within the chat.",
  "skills.installing_skill_creator": "Installing skill creator...",
  "skills.skill_creator_installed": "Skill creator installed.",
  "skills.skill_creator_already_installed": "Skill creator is already installed.",
  "skills.install_failed": "Skill install failed.",
  "skills.reveal_folder": "Open skills folder",
  "skills.reveal_folder_hint": "Open the skill directory in Finder.",
  "skills.reveal_button": "Reveal in Finder",
  "skills.reveal_failed": "Failed to open skills folder.",
  "skills.uninstall": "Uninstall",
  "skills.uninstall_title": "Uninstall skill?",
  "skills.uninstall_warning": "This will permanently delete the `{name}` skill from your workspace.",
  "skills.uninstall_failed": "Failed to uninstall skill.",
  "skills.uninstalled": "Skill removed.",
  "skills.source_placeholder": "github:anthropics/claude-code",
  "skills.notion_crm_title": "Notion CRM Enrichment Skills",
  "skills.notion_crm_description": "Add enrichment workflows for contacts, pipelines, and follow-ups.",
  "skills.notion_crm_card_description": "Enrich Notion CRM data with ready-made skills.",
  "skills.connect_host_to_load": "Connect an OpenWork server to load skills.",
  "skills.pick_workspace_first": "Pick a workspace folder first.",
  "skills.no_skills_found": "No skills found yet.",
  "skills.installed_description": "Skills available in this workspace.",
  "skills.failed_to_load": "Failed to load skills",
  "skills.plugin_management_host_only": "Plugin management requires the desktop app.",
  "skills.plugins_host_only": "Plugins are only available in the desktop app.",
  "skills.pick_project_for_plugins": "Pick a project folder to manage project plugins.",
  "skills.pick_project_for_active": "Pick a project folder to load active plugins.",
  "skills.no_opencode_found": "No opencode.json found yet. Add a plugin to create one.",
  "skills.no_opencode_workspace": "No opencode.json in this workspace yet.",
  "skills.failed_parse_opencode": "Failed to parse opencode.json",
  "skills.failed_load_opencode": "Failed to load opencode.json",
  "skills.failed_load_active": "Failed to load active plugins.",
  "skills.enter_plugin_name": "Enter a plugin package name.",
  "skills.plugin_already_listed": "Plugin already listed in opencode.json.",
  "skills.failed_update_opencode": "Failed to update opencode.json",
  "skills.opackage_install_host_only": "OpenPackage installs require the desktop app.",
  "skills.pick_project_first": "Pick a project folder first.",
  "skills.enter_opackage_source": "Enter an OpenPackage source (e.g. github:anthropics/claude-code).",
  "skills.installing_opackage": "Installing OpenPackage...",
  "skills.install_complete": "Installed.",
  "skills.curated_list_notice": "This is a curated list, not an OpenPackage yet. Copy the link or watch the PRD for planned registry search integration.",
  "skills.import_host_only": "Skill import requires the desktop app.",
  "skills.select_skill_folder": "Select skill folder",
  "skills.import_failed": "Import failed ({status})",
  "skills.imported": "Imported.",
  "skills.unknown_error": "Unknown error",

  // ==================== Plugins ====================
  "plugins.title": "OpenCode plugins",
  "plugins.description": "Manage `opencode.json` for your project or global OpenCode plugins.",
  "plugins.config_label": "Config",
  "plugins.config_not_loaded": "Not loaded yet",
  "plugins.suggested_label": "Suggested plugins",
  "plugins.no_plugins_yet": "No plugins configured yet.",
  "plugins.enabled_label": "Enabled",
  "plugins.open_label": "Open",
  "plugins.path_label": "Path",
  "plugins.scope_project": "Project",
  "plugins.scope_global": "Global",
  "plugins.refresh": "Refresh",
  "plugins.config": "Config",
  "plugins.not_loaded": "Not loaded yet",
  "plugins.suggested": "Suggested plugins",
  "plugins.hide_setup": "Hide setup",
  "plugins.setup": "Setup",
  "plugins.added": "Added",
  "plugins.add": "Add",
  "plugins.enabled": "Enabled",
  "plugins.no_plugins": "No plugins configured yet.",
  "plugins.add_label": "Add plugin",
  "plugins.placeholder": "opencode-wakatime",
  "plugins.add_hint": "Add npm package names, e.g. opencode-wakatime",

  // ==================== MCP (Model Context Protocol) ====================
  "mcp.title": "MCP (Alpha)",
  "mcp.description": "MCP servers let you connect services with your own credentials.",
  "mcp.alpha_banner_title": "MCP is in alpha while we harden OAuth with OpenCode.",
  "mcp.alpha_banner_help": "If you want to help, open a PR and include a short video showing the OAuth flow works end to end.",
  "mcp.mcps_title": "MCPs",
  "mcp.connect_mcp_hint": "Connect MCP servers to expand what OpenWork can do.",
  "mcp.reload_banner_title": "Finish setup",
  "mcp.reload_banner_description": "Reload to activate the new MCP connection. This is required setup, not an error.",
  "mcp.reload_banner_description_blocked": "A task is running in this workspace. Stop it, then reload to finish setup.",
  "mcp.reload_banner_blocked_hint": "Stop active runs to reload.",
  "mcp.quick_connect_title": "Quick connect",
  "mcp.oauth_only_label": "OAuth + local",
  "mcp.connected_status": "Connected",
  "mcp.no_env_vars": "No environment variables required.",
  "mcp.connected_title": "Connected",
  "mcp.from_opencode_json": "From opencode.json",
  "mcp.no_servers_yet": "No MCP servers configured yet.",
  "mcp.edit_config_title": "Edit MCP config",
  "mcp.edit_config_description": "MCP servers live in OpenCode's opencode.json.",
  "mcp.docs_link": "Docs",
  "mcp.scope_project": "Project",
  "mcp.scope_global": "Global",
  "mcp.config_label": "Config",
  "mcp.config_not_loaded": "Not loaded yet",
  "mcp.open_file_label": "Open file",
  "mcp.reveal_in_finder": "Reveal in Finder",
  "mcp.opening_label": "Opening",
  "mcp.file_not_found": "File not found",
  "mcp.config_load_failed": "Failed to load config path",
  "mcp.open_file": "Open file",
  "mcp.pick_workspace_error": "Pick a workspace folder to reveal the project opencode.json.",
  "mcp.reveal_config_failed": "Failed to reveal config",
  "mcp.alpha_warning": "MCP is in alpha while we harden OAuth with OpenCode.",
  "mcp.github_issue": "View issue #9510 on GitHub",
  "mcp.contribution_guide": "If you want to help, open a PR and include a short video showing the OAuth flow works end to end.",
  "mcp.hide_advanced": "Hide advanced settings",
  "mcp.show_advanced": "Show advanced settings",
  "mcp.mcps_label": "MCPs",
  "mcp.mcps_description": "Connect MCP servers to expand what OpenWork can do.",
  "mcp.configured": "configured",
  "mcp.updated": "Updated",
  "mcp.reload_required": "Reload required",
  "mcp.reload_description": "Changes need a quick reload to activate MCP tools.",
  "mcp.reload_engine": "Reload Engine",
  "mcp.quick_connect": "Quick connect",
  "mcp.oauth_only": "OAuth-only",
  "mcp.connecting": "Connecting",
  "mcp.connect": "Connect",
  "mcp.connected": "Connected",
  "mcp.connected_label": "Connected",
  "mcp.no_env_required": "No environment variables required.",
  "mcp.config_source": "From opencode.json",
  "mcp.no_servers": "No MCP servers configured yet.",
  "mcp.advanced": "Advanced",
  "mcp.advanced_description": "Manual setup for custom servers.",
  "mcp.hide": "Hide",
  "mcp.show": "Show",
  "mcp.server_name": "Server name",
  "mcp.server_name_placeholder": "sentry",
  "mcp.server_url": "Server URL",
  "mcp.server_url_placeholder": "https://mcp.sentry.dev/mcp",
  "mcp.oauth": "OAuth",
  "mcp.api_key": "API key",
  "mcp.enabled": "Enabled",
  "mcp.disabled": "Disabled",
  "mcp.add_mcp": "Add MCP",
  "mcp.verify_connection": "Verify connection",
  "mcp.cli_guidance": "CLI guidance (run from your workspace)",
  "mcp.config_locations": "Config can live in opencode.json, opencode.jsonc, or .opencode/opencode.json.",
  "mcp.details_title": "Details",
  "mcp.select_server_hint": "Select a server to review status and config.",
  "mcp.capabilities_label": "Capabilities",
  "mcp.tools_enabled_label": "Tools enabled",
  "mcp.oauth_ready_label": "OAuth ready",
  "mcp.usage_hint_text": "Use the MCP server name in prompts to target its tools.",
  "mcp.next_steps_label": "Next steps",
  "mcp.reload_step": "Reload the engine after adding a server.",
  "mcp.auth_step": "Run opencode mcp auth for OAuth servers if prompted.",
  "mcp.connection_failed": "Connection failed",
  "mcp.needs_auth": "Needs auth",
  "mcp.register_client": "Register client",
  "mcp.status_disabled": "Disabled",
  "mcp.disconnected": "Disconnected",
  "mcp.failed": "Failed",
  "mcp.host_mode_only": "MCP connections require the desktop app.",
  "mcp.pick_workspace_first": "Pick a workspace folder first.",
  "mcp.desktop_required": "MCP connections require the desktop app.",
  "mcp.connect_server_first": "Connect to the OpenCode server first.",
  "mcp.reload_required_after_add": "Reload required to activate the new MCP.",
  "mcp.connect_failed": "Failed to connect MCP.",
  "mcp.enter_name_and_url": "Enter a server name and URL.",
  "mcp.enter_url_first": "Enter a server URL first.",
  "mcp.use_debug_command": "Use opencode mcp debug <name> to validate connection.",
  "mcp.add_failed": "Failed to add MCP.",

  // MCP Auth Modal
  "mcp.auth.open_browser_signin": "We'll open your browser to finish sign-in.",
  "mcp.auth.connect_server": "Connect {server}",
  "mcp.auth.already_connected": "Already Connected",
  "mcp.auth.already_connected_description": "{server} is already authenticated and ready to use.",
  "mcp.auth.configured_previously": "The MCP may have been configured globally or in a previous session. You can close this modal and start using the MCP tools right away.",
  "mcp.auth.reload_engine_retry": "Reload engine and retry",
  "mcp.auth.retry_now": "Retry Now",
  "mcp.auth.retry": "Retry",
  "mcp.auth.reload_before_oauth": "Reload the engine to finish setting up this MCP before starting OAuth.",
  "mcp.auth.reload_notice": "Finish setup by reloading the engine to activate this MCP. This is a required step, not an error.",
  "mcp.auth.reload_blocked": "Reload is paused while a session is running. Stop the run to finish setup.",
  "mcp.auth.reload_needed": "Finish setup by reloading the engine, then try connecting again.",
  "mcp.auth.manual_finish_title": "Remote server?",
  "mcp.auth.manual_finish_hint": "Paste the callback URL (localhost:19876) or just the code to finish connecting.",
  "mcp.auth.callback_label": "Callback URL or code",
  "mcp.auth.callback_placeholder": "http://127.0.0.1:19876/mcp/oauth/callback?code=...",
  "mcp.auth.complete_connection": "Complete connection",
  "mcp.auth.callback_invalid": "Paste the callback URL or the code parameter to finish OAuth.",
  "mcp.auth.port_forward_hint": "Tip: forward the callback port if needed: ssh -L 19876:127.0.0.1:19876 user@host",
  "mcp.auth.step1_title": "Opening your browser",
  "mcp.auth.step1_description": "We'll launch {server}'s sign-in flow automatically.",
  "mcp.auth.step2_title": "Authorize OpenWork",
  "mcp.auth.step2_description": "Sign in and approve access when prompted.",
  "mcp.auth.step3_title": "Return here when you're done",
  "mcp.auth.step3_description": "We'll finish connecting as soon as authorization completes.",
  "mcp.auth.waiting_authorization": "Waiting for authorization to complete in your browser...",
  "mcp.auth.done": "Done",
  "mcp.auth.cancel": "Cancel",
  "mcp.auth.im_done": "I'm done",
  "mcp.auth.client_registration_required": "Client registration is required before OAuth can continue.",
  "mcp.auth.server_disabled": "This MCP server is disabled. Enable it and try again.",
  "mcp.auth.oauth_failed": "OAuth authentication failed.",
  "mcp.auth.invalid_refresh_token": "The OAuth refresh token is invalid or expired. Reauthorize to continue.",
  "mcp.auth.reauth_action": "Reauthorize OAuth",
  "mcp.auth.reauth_running": "Reauthorizing...",
  "mcp.auth.reauth_failed": "Reauthorization failed.",
  "mcp.auth.reauth_cli_hint": "Run: opencode mcp auth {server}",
  "mcp.auth.reauth_remote_hint": "Reauthorize from the machine running this workspace.",
  "mcp.auth.authorization_still_required": "Authorization is still required. Try again to restart the flow.",
  "mcp.auth.oauth_not_supported_hint": "This could mean:\n• The MCP server doesn't advertise OAuth capabilities\n• The engine needs to reload to discover server capabilities\n• Try: opencode mcp auth {server} from the CLI",
  "mcp.auth.try_reload_engine": "{message}. Try reloading the engine first.",
  "mcp.auth.failed_to_start_oauth": "Failed to start OAuth flow",
  "mcp.auth.oauth_completed_reload": "OAuth completed. Reload the engine to activate the MCP.",

  // ==================== Settings ====================
  "settings.title": "Settings",
  "settings.connection": "Connection",
  "settings.engine_source": "Engine source",
  "settings.from_path": "From PATH",
  "settings.from_sidecar": "Bundled sidecar",
  "settings.engine_source_description": "PATH uses your installed OpenCode (default). Sidecar will use a bundled binary when available.",
  "settings.sidecar_unsupported": "Sidecar is available on Windows",
  "settings.sidecar_unavailable_detail": "Sidecar is bundled when available.",
  "settings.model": "Model",
  "settings.model_description": "Defaults + thinking controls for runs.",
  "settings.change": "Change",
  "settings.engine_path": "PATH",
  "settings.engine_sidecar": "Sidecar",
  "settings.thinking": "Thinking",
  "settings.thinking_description": "Show thinking parts (Developer mode only).",
  "settings.on": "On",
  "settings.off": "Off",
  "settings.model_variant": "Model variant",
  "settings.edit": "Edit",
  "settings.default_model": "Default model",
  "settings.session_model": "Model",
  "settings.model_description_default": "Choose from your configured providers. This selection will be used for new sessions.",
  "settings.model_description_session": "Choose from your configured providers. This selection applies to your next message.",
  "settings.search_models": "Search models…",
  "settings.showing_models": "Showing {count} of {total}",
  "settings.model_variant_prompt": "Model variant (provider-specific, e.g. high/max/minimal). Leave blank to clear.",
  "settings.model_fallback": "Fallback",
  "settings.model_default": "Default",
  "settings.model_free": "Free",
  "settings.model_reasoning": "Reasoning",
  "settings.done": "Done",
  "settings.updates": "Updates",
  "settings.updates_description": "Keep OpenWork up to date.",
  "settings.automatic_checks": "Automatic checks",
  "settings.automatic_checks_description": "Once per day (quiet)",
  "settings.update_checking": "Checking...",
  "settings.update_available": "Update available: v",
  "settings.update_downloading": "Downloading...",
  "settings.update_ready": "Ready to install: v",
  "settings.update_error": "Update check failed",
  "settings.update_uptodate": "Up to date",
  "settings.last_checked": "Last checked",
  "settings.published": "Published",
  "settings.check_update": "Check",
  "settings.install_restart": "Install & Restart",
  "settings.update_not_supported": "Updates are not supported in this environment.",
  "settings.update_desktop_only": "Updates are only available in the desktop app.",
  "settings.startup": "Startup",
  "settings.mode_label": "mode",
  "settings.switch_mode": "Switch",
  "settings.reset_startup": "Reset default startup mode",
  "settings.reset_startup_description": "This clears your saved preference and shows mode selection on next launch.",
  "settings.advanced": "Advanced",
  "settings.advanced_description": "Reset OpenWork local state to retest onboarding.",
  "settings.reset_onboarding": "Reset onboarding",
  "settings.reset_onboarding_description": "Clears OpenWork preferences and restarts the app.",
  "settings.reset_app_data": "Reset app data",
  "settings.reset_app_data_description": "More aggressive. Clears OpenWork cache + app data.",
  "settings.reset": "Reset",
  "settings.requires_typing": "Requires typing",
  "settings.will_restart": "and will restart the app.",
  "settings.reset_onboarding_title": "Reset onboarding",
  "settings.reset_app_data_title": "Reset app data",
  "settings.reset_confirmation_hint": "Type <span class=\"font-mono\">RESET</span> to confirm. OpenWork will restart.",
  "settings.reset_onboarding_warning": "Clears OpenWork local preferences and workspace onboarding markers.",
  "settings.reset_app_data_warning": "Clears OpenWork cache and app data on this device.",
  "settings.reset_stop_active_runs": "Stop active runs before resetting.",
  "settings.reset_confirmation_label": "Confirmation",
  "settings.reset_confirmation_placeholder": "Type RESET",
  "settings.reset_cancel": "Cancel",
  "settings.reset_confirm_button": "Reset & Restart",
  "settings.developer": "Developer",
  "settings.opencode_cache": "OpenCode cache",
  "settings.opencode_cache_description": "Repairs cached data used to start the engine. Safe to run.",
  "settings.repair_cache": "Repair cache",
  "settings.repairing_cache": "Repairing cache",
  "settings.cache_repair_requires_desktop": "Cache repair requires the desktop app",
  "settings.pending_permissions": "Pending permissions",
  "settings.recent_events": "Recent events",
  "settings.notion_connected": "Connected",
  "settings.reload_required": "Reload required",
  "settings.connection_failed": "Connection failed",
  "settings.notion_not_connected": "Not connected",
  "settings.show_thinking": "Show thinking",
  "settings.update": "Update",
  "settings.about": "About",
  "settings.version": "Version",
  "settings.check_for_updates": "Check for updates",
  "settings.download_update": "Download update",
  "settings.install_update": "Install update and restart",
  "settings.enable_developer_mode": "Enable Developer Mode",
  "settings.disable_developer_mode": "Disable Developer Mode",
  "settings.stop_engine": "Stop engine",
  "settings.disconnect": "Disconnect",
  "settings.language": "Language",
  "settings.language.description": "Choose your preferred language",
  "settings.connection_title": "Connection",
  "settings.engine_source_label": "Engine source",
  "settings.engine_source_hint": "PATH uses your installed OpenCode (default). Sidecar will use a bundled binary when available.",
  "settings.sidecar_unavailable": "Sidecar is bundled when available.",
  "settings.model_title": "Model",
  "settings.model_hint": "Defaults + thinking controls for runs.",
  "settings.thinking_label": "Thinking",
  "settings.thinking_hint": "Show thinking parts (Developer mode only).",
  "settings.model_variant_label": "Model variant",
  "settings.appearance_title": "Appearance",
  "settings.appearance_hint": "Match the system or force light/dark mode.",
  "settings.theme_system": "System",
  "settings.theme_light": "Light",
  "settings.theme_dark": "Dark",
  "settings.theme_system_hint": "System mode follows your OS preference automatically.",
  "settings.updates_title": "Updates",
  "settings.updates_hint": "Keep OpenWork up to date.",
  "settings.automatic_checks_label": "Automatic checks",
  "settings.automatic_checks_hint": "Once per day (quiet)",
  "settings.last_checked_time": "Last checked {time}",
  "settings.published_date": "Published {date}",
  "settings.update_not_supported_hint": "Updates are not supported in this environment.",
  "settings.update_desktop_only_hint": "Updates are only available in the desktop app.",
  "settings.startup_title": "Startup",
  "settings.mode_suffix": "mode",
  "settings.reset_startup_label": "Reset default startup mode",
  "settings.reset_startup_hint": "This clears your saved preference and shows mode selection on next launch.",
  "settings.advanced_title": "Advanced",
  "settings.advanced_hint": "Reset OpenWork local state to retest onboarding.",
  "settings.reset_onboarding_label": "Reset onboarding",
  "settings.reset_onboarding_hint": "Clears OpenWork preferences and restarts the app.",
  "settings.reset_app_data_label": "Reset app data",
  "settings.reset_app_data_hint": "More aggressive. Clears OpenWork cache + app data.",
  "settings.reset_requires_hint": "Requires typing RESET and will restart the app.",
  "settings.developer_title": "Developer",
  "settings.opencode_cache_label": "OpenCode cache",
  "settings.opencode_cache_hint": "Repairs cached data used to start the engine. Safe to run.",
  "settings.pending_permissions_label": "Pending permissions",
  "settings.recent_events_label": "Recent events",
  "settings.stop_active_runs_hint": "Stop active runs to update",
  "settings.stop_active_runs_reset_hint": "Stop active runs to reset",
  "settings.stop_runs_to_update": "Stop active runs to update",
  "settings.stop_runs_to_reset": "Stop active runs to reset",
  "settings.updates_not_supported": "Updates are not supported in this environment.",
  "settings.updates_desktop_only": "Updates are only available in the desktop app.",

  // ==================== Reload ====================
  "reload.toast_title": "Updates available",
  "reload.toast_description": "Reload workspace to apply config changes.",
  "reload.toast_warning": "Stops all active tasks.",
  "reload.toast_warning_active": "Reloading stops {count} active tasks.",
  "reload.toast_reload": "Reload",
  "reload.toast_reload_stopped": "Reload & Stop Tasks",
  "reload.toast_reloading": "Reloading...",
  "reload.toast_dismiss": "Later",
  "reload.toast_blocked_host": "Reloading is only available for local workspaces.",
  "reload.toast_blocked_connect": "Connect to this workspace to reload.",
  "reload.toast_blocked_runs": "Waiting for active tasks to complete before reloading.",

  // ==================== Onboarding ====================
  "onboarding.starting_host": "Starting OpenWork server...",
  "onboarding.searching_host": "Connecting to OpenWork server...",
  "onboarding.getting_ready": "Getting everything ready",
  "onboarding.verifying": "Verifying secure handshake",
  "onboarding.create_first_workspace": "Create your first workspace",
  "onboarding.create_workspace": "Create a workspace",
  "onboarding.workspace_description": "Choose a folder and preset to set up your workspace.",
  "onboarding.start": "Start OpenWork",
  "onboarding.back": "Back",
  "onboarding.advanced_settings": "Advanced settings",
  "onboarding.opencode_engine": "OpenCode engine",
  "onboarding.refresh": "Refresh",
  "onboarding.checking_cli": "Checking OpenCode CLI...",
  "onboarding.cli_not_found": "OpenCode CLI not found.",
  "onboarding.cli_needs_update": "OpenCode CLI needs an update for serve.",
  "onboarding.opencode": "OpenCode",
  "onboarding.cli_ready": "OpenCode CLI ready.",
  "onboarding.cli_version": "OpenCode {version}",
  "onboarding.windows_install_instruction": "Install OpenCode for Windows, then restart OpenWork. Ensure opencode.exe is on PATH.",
  "onboarding.install_instruction": "Install OpenCode to enable the local server (no terminal required).",
  "onboarding.install": "Install OpenCode",
  "onboarding.recheck": "Re-check",
  "onboarding.ready_message": "OpenCode is ready to start the local server.",
  "onboarding.resolved_path": "Resolved path",
  "onboarding.version": "Version",
  "onboarding.search_notes": "Search notes",
  "onboarding.serve_help": "serve --help output",
  "onboarding.workspace_folder_label": "A workspace is a folder with its own skills, plugins, and commands.",
  "onboarding.theme_label": "Theme",
  "onboarding.theme_current": "Current: {mode}",
  "onboarding.theme_system": "System",
  "onboarding.theme_light": "Light",
  "onboarding.theme_dark": "Dark",
  "onboarding.access_label": "Access",
  "onboarding.folders_allowed": "{count} folder{plural} allowed",
  "onboarding.manage_access_hint": "You can manage access in advanced settings.",
  "onboarding.open_settings_hint": "Need engine or access options? Open Settings.",
  "onboarding.open_settings": "Open Settings",
  "onboarding.add_folder_path": "Add folder path",
  "onboarding.pick": "Pick",
  "onboarding.add": "Add",
  "onboarding.remove": "Remove",
  "onboarding.cli_label": "OpenCode CLI",
  "onboarding.cli_checking": "Checking install...",
  "onboarding.cli_not_found_hint": "Not found. Install to run the local server.",
  "onboarding.cli_version_installed": "Installed",
  "onboarding.cli_recheck": "Re-check",
  "onboarding.cli_install_commands": "Install OpenCode with one of the commands below, then restart OpenWork.",
  "onboarding.show_search_notes": "Show search notes",
  "onboarding.last_checked": "Last checked {time}",
  "onboarding.server_url_placeholder": "http://localhost:8088",
  "onboarding.directory_placeholder": "my-project",
  "onboarding.connect_host": "Connect to server",
  "onboarding.connect_description": "Pair with an existing OpenCode server (LAN or tunnel).",
  "onboarding.server_url": "Server URL",
  "onboarding.directory": "Directory (optional)",
  "onboarding.directory_hint": "Use if your server runs multiple workspaces.",
  "onboarding.connect": "Connect",
  "onboarding.remote_workspace_title": "Connect to OpenWork server",
  "onboarding.remote_workspace_description": "Connect to an OpenWork server to access a workspace from anywhere.",
  "onboarding.remote_workspace_action": "Connect",
  "onboarding.remote_workspace_card_title": "Connect a remote workspace",
  "onboarding.remote_workspace_card_description": "Connect to an OpenWork server to access a shared workspace.",
  "onboarding.advanced_openwork_host": "OpenWork server",
  "onboarding.advanced_openwork_hint": "Use a server URL and access token for shared access.",
  "onboarding.advanced_opencode_direct": "Advanced: OpenCode direct",
  "onboarding.advanced_opencode_hint": "Connect straight to an OpenCode engine when no server is available.",
  "onboarding.welcome_title": "How would you like to run OpenWork today?",
  "onboarding.run_local": "Run locally",
  "onboarding.run_local_description": "OpenWork runs OpenCode locally and keeps your work private.",
  "onboarding.engine_running": "Engine already running",
  "onboarding.attach_description": "Attach to the existing session on this device.",
  "onboarding.attach": "Attach",
  "onboarding.remember_choice": "Remember my choice for next time",
  "onboarding.client_mode": "Connect as a Client (Remote Pairing)",
  "onboarding.default_workspace_path": "~/OpenWork/Workspace",
  "onboarding.authorize_folder": "Authorize folder",
  "onboarding.choose_workspace_folder": "Choose workspace folder",

  // ==================== Common ====================
  "common.alpha": "Alpha",
  "common.change": "Change",
  "common.refresh": "Refresh",
  "common.new": "New",
  "common.install": "Install",
  "common.delete": "Delete",
  "common.edit": "Edit",
  "common.save": "Save",
  "common.cancel": "Cancel",
  "common.close": "Close",
  "common.open": "Open",
  "common.show": "Show",
  "common.hide": "Hide",
  "common.path": "Path",
  "common.choose": "Choose",
  "common.retry": "Retry",
  "common.untitled": "Untitled",
  "common.default_parens": "(default)",
  "common.on": "On",
  "common.off": "Off",

  // ==================== Status ====================
  "status.connected": "Connected",
  "status.disconnected": "Disconnected",
  "status.idle": "Idle",
  "status.busy": "Busy",
  "status.running": "Running",
  "status.live": "Live",
  "status.connecting": "Connecting",
  "status.creating_workspace": "Creating workspace",
  "status.deleting_command": "Deleting command",
  "status.saving_workspace_command": "Saving workspace command",
  "status.saving_command": "Saving command",
  "status.loading_session": "Loading session",
  "status.creating_task": "Creating new task",
  "status.starting_engine": "Starting engine",
  "status.reloading_engine": "Reloading engine",
  "status.restarting_engine": "Restarting engine",
  "status.installing_opencode": "Installing OpenCode",
  "status.disconnecting": "Disconnecting",

  // ==================== Workspace Switching ====================
  "workspace.switching_title": "Opening {name}",
  "workspace.switching_title_unknown": "Opening workspace",
  "workspace.switching_subtitle": "We’ll bring your recent work back.",
  "workspace.switching_status_preparing": "Getting things ready",
  "workspace.switching_status_connecting": "Checking your connection",
  "workspace.switching_status_loading": "Loading recent tasks",
  "workspace.switching_status_almost": "Almost there",

  "app.connection_lost": "Server connection lost. Please reload.",
  "app.unknown_error": "Unknown error",
  "app.error.tauri_required": "This action requires the Tauri app runtime.",
  "app.error.choose_folder": "Choose a folder to continue.",
  "app.error.pick_workspace_folder": "Pick a workspace folder first.",
  "app.error.remote_base_url_required": "Add a server URL to continue.",
  "app.error.host_requires_local": "Select a local workspace to start the engine.",
  "app.error.sidecar_unsupported_windows": "Sidecar OpenCode is bundled on Windows when available. Falling back to PATH.",
  "app.error.install_failed": "OpenCode install failed. See logs above.",
  "app.error.command_name_template_required": "Command name and instructions are required.",
  "app.error.workspace_commands_desktop": "Commands require the desktop app.",
  "app.error.command_scope_unknown": "This command can't be managed in this mode.",
} as const;
