/**
 * 中文（简体）翻译
 * 专业术语不翻译：Skills、Plugins、Commands、Sessions、OpenCode、OpenPackage、OpenWork、MCPs
 */

export default {
  // ==================== Dashboard ====================
  "dashboard.title": "主页",
  "dashboard.sessions": "会话",
  "dashboard.commands": "Commands",
  "dashboard.skills": "Skills",
  "dashboard.plugins": "插件",
  "dashboard.mcps": "MCPs",
  "dashboard.settings": "设置",
  "dashboard.home": "主页",
  "dashboard.runs": "运行",
  "dashboard.find_workspace": "查找工作区...",
  "dashboard.workspaces": "工作区",
  "dashboard.no_workspaces": "没有匹配的工作区。",
  "dashboard.new_workspace": "新建工作区...",
  "dashboard.new_remote_workspace": "添加远程工作区...",
  "dashboard.forget_workspace": "忘记工作区",
  "dashboard.remote": "远程",
  "dashboard.connection": "连接",
  "dashboard.local_engine": "本地引擎",
  "dashboard.client_mode": "客户端模式",
  "dashboard.connected": "已连接",
  "dashboard.not_connected": "未连接",
  "dashboard.stop_disconnect": "停止并断开",
  "dashboard.disconnect": "断开连接",
  "dashboard.new_task": "新建任务",
  "dashboard.new": "新建",
  "dashboard.busy": "忙碌",
  "dashboard.hero_title": "今天想做些什么？",
  "dashboard.hero_description": "描述一个目标。OpenWork 将运行它并保留审计记录。",
  "dashboard.quick_start_commands": "快速开始命令",
  "dashboard.view_all": "查看全部",
  "dashboard.no_commands": "还没有命令。初始命令将显示在这里。",
  "dashboard.run_command": "运行保存的命令",
  "dashboard.recent_sessions": "最近的会话",
  "dashboard.this_workspace": "此工作区",
  "dashboard.no_sessions": "还没有会话。",
  "dashboard.idle": "空闲",
  "dashboard.running": "运行中",
  "dashboard.completed": "已完成",
  "dashboard.failed": "失败",
  "dashboard.repairing_cache": "正在修复缓存",
  "dashboard.repair_cache": "修复缓存",
  "dashboard.retry": "重试",
  "dashboard.alpha": "测试版",
  "dashboard.create_workspace_title": "创建工作区",
  "dashboard.create_workspace_subtitle": "初始化新的基于文件夹的工作区。",
  "dashboard.create_workspace_confirm": "创建工作区",
  "dashboard.create_remote_workspace_title": "添加远程工作区",
  "dashboard.create_remote_workspace_subtitle": "保存 OpenWork 服务器为工作区。",
  "dashboard.create_remote_workspace_confirm": "添加工作区",
  "dashboard.edit_remote_workspace_title": "编辑远程连接",
  "dashboard.edit_remote_workspace_subtitle": "更新此工作区的 OpenWork 服务器信息。",
  "dashboard.edit_remote_workspace_confirm": "保存连接",
  "dashboard.remote_workspace_title": "远程工作区",
  "dashboard.remote_workspace_hint": "记录 OpenWork 服务器，随时重新连接。",
  "dashboard.remote_base_url_label": "OpenWork 服务器地址",
  "dashboard.remote_base_url_placeholder": "http://127.0.0.1:8787",
  "dashboard.remote_base_url_required": "请先填写服务器地址。",
  "dashboard.openwork_host_label": "OpenWork 服务器地址",
  "dashboard.openwork_host_placeholder": "https://your-server.openwork.app",
  "dashboard.openwork_host_hint": "使用 OpenWork 服务器提供的地址。",
  "dashboard.openwork_host_token_label": "访问令牌",
  "dashboard.openwork_host_token_placeholder": "粘贴你的令牌",
  "dashboard.openwork_host_token_hint": "可选。粘贴服务器提供的访问令牌以验证。",
  "dashboard.remote_mode_openwork_alpha": "OpenWork 服务器",
  "dashboard.remote_mode_direct": "直连（旧版）",
  "dashboard.remote_connection_openwork": "OpenWork",
  "dashboard.remote_connection_direct": "直连",
  "dashboard.remote_directory_label": "工作区目录（可选）",
  "dashboard.remote_directory_placeholder": "/home/team/project",
  "dashboard.remote_directory_hint": "留空则使用服务器默认目录。",
  "dashboard.remote_display_name_label": "显示名称（可选）",
  "dashboard.remote_display_name_placeholder": "设计团队工作区",
  "dashboard.select_folder": "选择文件夹",
  "dashboard.choose_folder": "选择文件夹",
  "dashboard.choose_folder_next": "接下来您将选择一个目录。",
  "dashboard.change": "更改",
  "dashboard.opening": "正在打开...",
  "dashboard.choose_preset": "选择预设",
  "dashboard.choose_folder_continue": "选择文件夹以继续。",
  "dashboard.starter_workspace": "启动工作区",
  "dashboard.starter_workspace_desc": "预配置以展示如何使用插件、命令和技能。",
  "dashboard.empty_workspace": "空白工作区",
  "dashboard.empty_workspace_desc": "从空白文件夹开始，添加您需要的内容。",

  // ==================== Workspace ====================
  "workspace.rename_title": "编辑工作区名称",
  "workspace.rename_description": "更新侧边栏中显示的名称。",
  "workspace.rename_label": "工作区名称",
  "workspace.rename_placeholder": "设计团队工作区",

  // ==================== Session ====================
  "session.no_selected": "未选择会话",
  "session.back_to_dashboard": "返回仪表盘",
  "session.new_task": "新建任务",
  "session.recents": "最近",
  "session.recents_notice": "这些任务在本地运行，不会跨设备同步。",
  "session.ready_to_work_title": "准备就绪",
  "session.ready_to_work_description": "描述一个任务。我会显示进度并在需要时请求权限。",
  "session.document_label": "文档",
  "session.standard_label": "标准",
  "session.no_artifacts_fallback": "还没有工件。",
  "session.active_plugins_label": "活动插件",
  "session.active_plugins_count": "{count}",
  "session.no_plugins_loaded": "未加载插件。",
  "session.selected_folders_label": "选中的文件夹",
  "session.selected_folders_count": "{count}",
  "session.working_files_label": "工作文件",
  "session.none_yet_label": "还没有。",
  "session.permission_required_title": "需要权限",
  "session.permission_required_description": "OpenCode 正在请求权限以继续。",
  "session.permission_label_uppercase": "权限",
  "session.scope_label_uppercase": "范围",
  "session.details_label": "详情",
  "session.steps_notice_text": "步骤将随着任务的展开而显示。",
  "session.ready_to_work": "准备就绪",
  "session.ready_description": "描述一个任务。我会显示进度并在需要时请求权限。",
  "session.hide_steps": "隐藏步骤",
  "session.view_steps": "查看步骤",
  "session.open": "打开",
  "session.reveal": "在文件管理器中显示",
  "session.opened_toast": "已在默认应用中打开。",
  "session.revealed_toast": "已在文件管理器中显示。",
  "session.artifact_path_missing": "工件路径缺失。",
  "session.desktop_only": "打开功能仅在桌面应用中可用。",
  "session.open_failed": "无法打开工件。",
  "session.model": "模型",
  "session.ready": "就绪",
  "session.connect_provider": "连接提供商以进行自定义。",
  "session.running": "运行中",
  "session.progress": "进度",
  "session.steps_notice": "步骤将随着任务的展开而显示。",
  "session.artifacts": "工件",
  "session.no_artifacts": "还没有工件。",
  "session.context": "上下文",
  "session.active_plugins": "活动插件",
  "session.no_plugins": "未加载插件。",
  "session.selected_folders": "选中的文件夹",
  "session.working_files": "工作文件",
  "session.none_yet": "还没有。",
  "session.document": "文档",
  "session.standard": "标准",
  "session.try_notion_prompt": "立即尝试：在 Notion 中设置我的 CRM",
  "session.insert_prompt": "插入提示",
  "session.placeholder": "向 OpenWork 提问...",
  "session.run": "运行",
  "session.permission_required": "需要权限",
  "session.permission_description": "OpenCode 正在请求权限以继续。",
  "session.permission_label": "权限",
  "session.scope_label": "范围",
  "session.details": "详情",
  "session.deny": "拒绝",
  "session.once": "一次",
  "session.allow_for_session": "在会话期间允许",

  "session.tasks_local_hint": "这些任务在本地运行，不会跨设备同步。",
  "session.recents_label": "最近",
  "session.model_standard": "标准",
  "session.run_button_title": "运行",
  "session.rename_title": "重命名会话",
  "session.rename_description": "更新此会话名称。",
  "session.rename_label": "会话名称",
  "session.rename_placeholder": "输入新的名称",

  // ==================== Commands ====================
  "commands.new": "新建",
  "commands.empty_state": "保存提示词或命令，一键重复运行。",
  "commands.workspace": "此工作区",
  "commands.global": "所有工作区",
  "commands.other": "其他命令",
  "commands.run": "运行",
  "commands.modal_title": "保存可复用流程",
  "commands.modal_description": "保存提示词或命令，便于快速复用。",
  "commands.name_label": "命令名称",
  "commands.name_placeholder": "例如：daily-standup",
  "commands.name_hint": "将在 OpenCode 中显示为 /daily-standup。",
  "commands.description_label": "描述（可选）",
  "commands.description_placeholder": "这个命令做什么？",
  "commands.template_label": "指令",
  "commands.template_placeholder": "编写你想复用的指令…",
  "commands.template_hint": "使用 $ARGUMENTS 来接收详情参数。",
  "commands.details_required": "详情",
  "commands.default_description": "运行保存的命令",
  "commands.command_label": "命令",
  "commands.details_label": "详情",
  "commands.details_placeholder": "添加可选详情",
  "commands.details_hint": "这些详情将传给命令。",
  "commands.run_modal_title": "运行命令",
  "commands.run_modal_description": "运行前可添加详情。",
  "commands.run_modal_run": "运行命令",
  "commands.name_will_be": "将创建为",
  "commands.override_title": "替换现有命令？",
  "commands.override_description": "已存在同名命令。",
  "commands.override_warning": "这将替换现有的 \"{name}\" 命令。此操作无法撤销。",
  "commands.override_confirm": "替换",
  "commands.override_cancel": "保留现有",

  // ==================== Skills ====================
  "skills.title": "Skills",
  "skills.subtitle": "管理此工作区的 skills。",
  "skills.refresh": "刷新",
  "skills.add_title": "添加 skills",
  "skills.add_description": "安装起始命令、导入 skill，或打开文件夹。",
  "skills.install_from_openpackage": "从 OpenPackage 安装",
  "skills.host_mode_only": "仅本地工作区",
  "skills.install": "安装",
  "skills.installed_label": "已安装",
  "skills.install_hint": "将 OpenPackage 包安装到当前工作区。Skills 应放在 `.opencode/skills` 中。",
  "skills.import_local": "导入本地 skill",
  "skills.import_local_hint": "将现有 skill 文件夹复制到此工作区。",
  "skills.import": "导入",
  "skills.curated_packages": "精选包",
  "skills.view": "查看",
  "skills.search_placeholder": "搜索包或列表（例如：claude、registry、community）",
  "skills.no_matches": "没有匹配的精选包。尝试不同的搜索。",
  "skills.install_package": "安装",
  "skills.registry_notice": "发布到 OpenPackage 注册表（`opkg push`）目前需要身份验证。计划添加注册表搜索和精选列表同步。",
  "skills.installed": "已安装的 skills",
  "skills.no_skills": "在 `.opencode/skills` 或 `.claude/skills` 中未检测到 skills。",
  "skills.desktop_required": "技能管理需要桌面应用。",
  "skills.host_only_error": "技能管理需要本地工作区或已连接的 OpenWork 服务器。",
  "skills.install_skill_creator": "安装 skill creator",
  "skills.install_skill_creator_hint": "此 skill 可让你在聊天中创建其他 skills。",
  "skills.installing_skill_creator": "正在安装 skill creator...",
  "skills.skill_creator_installed": "Skill creator 已安装。",
  "skills.skill_creator_already_installed": "Skill creator 已经安装过了。",
  "skills.install_failed": "技能安装失败。",
  "skills.reveal_folder": "打开 skills 文件夹",
  "skills.reveal_folder_hint": "在 Finder 中打开 skills 目录。",
  "skills.reveal_button": "在 Finder 中显示",
  "skills.reveal_failed": "打开 skills 文件夹失败。",
  "skills.uninstall": "卸载",
  "skills.uninstall_title": "卸载 skill？",
  "skills.uninstall_warning": "这将永久从工作区删除 `{name}` skill。",
  "skills.uninstall_failed": "卸载 skill 失败。",
  "skills.uninstalled": "Skill 已删除。",
  "skills.source_placeholder": "github:anthropics/claude-code",
  "skills.notion_crm_title": "Notion CRM 增强技能",
  "skills.notion_crm_description": "为联系人、管道和跟进添加增强工作流。",
  "skills.notion_crm_card_description": "使用现成的技能丰富 Notion CRM 数据。",
  "skills.connect_host_to_load": "连接 OpenWork 服务器以加载技能。",
  "skills.pick_workspace_first": "先选择一个工作区文件夹。",
  "skills.no_skills_found": "还没有找到 skills。",
  "skills.installed_description": "此工作区可用的 skills。",
  "skills.failed_to_load": "加载 skills 失败",
  "skills.plugin_management_host_only": "插件管理需要桌面应用。",
  "skills.plugins_host_only": "插件仅在桌面应用中可用。",
  "skills.pick_project_for_plugins": "选择项目文件夹以管理项目插件。",
  "skills.pick_project_for_active": "选择项目文件夹以加载活动插件。",
  "skills.no_opencode_found": "尚未找到 opencode.json。添加插件以创建一个。",
  "skills.no_opencode_workspace": "此工作区中还没有 opencode.json。",
  "skills.failed_parse_opencode": "解析 opencode.json 失败",
  "skills.failed_load_opencode": "加载 opencode.json 失败",
  "skills.failed_load_active": "加载活动插件失败。",
  "skills.enter_plugin_name": "输入插件包名称。",
  "skills.plugin_already_listed": "插件已在 opencode.json 中列出。",
  "skills.failed_update_opencode": "更新 opencode.json 失败",
  "skills.opackage_install_host_only": "OpenPackage 安装需要桌面应用。",
  "skills.pick_project_first": "先选择一个项目文件夹。",
  "skills.enter_opackage_source": "输入 OpenPackage 源（例如：github:anthropics/claude-code）。",
  "skills.installing_opackage": "正在安装 OpenPackage...",
  "skills.install_complete": "已安装。",
  "skills.curated_list_notice": "这是一个精选列表，还不是 OpenPackage。复制链接或关注 PRD 以了解计划的注册表搜索集成。",
  "skills.import_host_only": "Skill 导入需要桌面应用。",
  "skills.select_skill_folder": "选择 skill 文件夹",
  "skills.import_failed": "导入失败（{status}）",
  "skills.imported": "已导入。",
  "skills.unknown_error": "未知错误",

  // ==================== Plugins ====================
  "plugins.title": "OpenCode 插件",
  "plugins.description": "为您的项目或全局 OpenCode 插件管理 `opencode.json`。",
  "plugins.config_label": "配置",
  "plugins.config_not_loaded": "尚未加载",
  "plugins.suggested_label": "建议的插件",
  "plugins.no_plugins_yet": "尚未配置插件。",
  "plugins.enabled_label": "已启用",
  "plugins.open_label": "打开",
  "plugins.path_label": "路径",
  "plugins.scope_project": "项目",
  "plugins.scope_global": "全局",
  "plugins.refresh": "刷新",
  "plugins.config": "配置",
  "plugins.not_loaded": "尚未加载",
  "plugins.suggested": "建议的插件",
  "plugins.hide_setup": "隐藏设置",
  "plugins.setup": "设置",
  "plugins.added": "已添加",
  "plugins.add": "添加",
  "plugins.enabled": "已启用",
  "plugins.no_plugins": "尚未配置插件。",
  "plugins.add_label": "添加插件",
  "plugins.placeholder": "opencode-wakatime",
  "plugins.add_hint": "添加 npm 包名称，例如 opencode-wakatime",

  // ==================== MCP (Model Context Protocol) ====================
  "mcp.title": "MCP（测试版）",
  "mcp.description": "MCP 服务器让您使用自己的凭据连接服务。",
  "mcp.alpha_banner_title": "MCP 处于测试阶段，我们正在加强与 OpenCode 的 OAuth 集成。",
  "mcp.alpha_banner_help": "如果您想帮忙，请提交 PR 并附上一个短视频，展示 OAuth 流程从端到端的工作。",
  "mcp.mcps_title": "MCPs",
  "mcp.connect_mcp_hint": "连接 MCP 服务器以扩展 OpenWork 的功能。",
  "mcp.reload_banner_title": "需要重新加载",
  "mcp.reload_banner_description": "更改需要快速重新加载以激活 MCP 工具。",
  "mcp.quick_connect_title": "快速连接",
  "mcp.oauth_only_label": "OAuth + 本地",
  "mcp.connected_status": "已连接",
  "mcp.no_env_vars": "不需要环境变量。",
  "mcp.connected_title": "已连接",
  "mcp.from_opencode_json": "来自 opencode.json",
  "mcp.no_servers_yet": "尚未配置 MCP 服务器。",
  "mcp.edit_config_title": "编辑 MCP 配置",
  "mcp.edit_config_description": "MCP 服务器位于 OpenCode 的 opencode.json 中。",
  "mcp.docs_link": "文档",
  "mcp.scope_project": "项目",
  "mcp.scope_global": "全局",
  "mcp.config_label": "配置",
  "mcp.config_not_loaded": "尚未加载",
  "mcp.open_file_label": "打开文件",
  "mcp.reveal_in_finder": "在文件管理器中显示",
  "mcp.opening_label": "正在打开",
  "mcp.file_not_found": "文件未找到",
  "mcp.config_load_failed": "加载配置路径失败",
  "mcp.open_file": "打开文件",
  "mcp.pick_workspace_error": "选择工作区文件夹以显示项目 opencode.json。",
  "mcp.reveal_config_failed": "显示配置失败",
  "mcp.alpha_warning": "MCP 处于测试阶段，我们正在加强与 OpenCode 的 OAuth 集成。",
  "mcp.github_issue": "在 GitHub 上查看 issue #9510",
  "mcp.contribution_guide": "如果您想帮忙，请提交 PR 并附上一个短视频，展示 OAuth 流程从端到端的工作。",
  "mcp.hide_advanced": "隐藏高级设置",
  "mcp.show_advanced": "显示高级设置",
  "mcp.mcps_label": "MCPs",
  "mcp.mcps_description": "连接 MCP 服务器以扩展 OpenWork 的功能。",
  "mcp.configured": "已配置",
  "mcp.updated": "更新时间",
  "mcp.reload_required": "需要重新加载",
  "mcp.reload_description": "更改需要快速重新加载以激活 MCP 工具。",
  "mcp.reload_engine": "重新加载引擎",
  "mcp.quick_connect": "快速连接",
  "mcp.oauth_only": "仅 OAuth",
  "mcp.connecting": "连接中",
  "mcp.connect": "连接",
  "mcp.connected": "已连接",
  "mcp.connected_label": "已连接",
  "mcp.no_env_required": "不需要环境变量。",
  "mcp.config_source": "来自 opencode.json",
  "mcp.no_servers": "尚未配置 MCP 服务器。",
  "mcp.advanced": "高级",
  "mcp.advanced_description": "手动设置自定义服务器。",
  "mcp.hide": "隐藏",
  "mcp.show": "显示",
  "mcp.server_name": "服务器名称",
  "mcp.server_name_placeholder": "sentry",
  "mcp.server_url": "服务器 URL",
  "mcp.server_url_placeholder": "https://mcp.sentry.dev/mcp",
  "mcp.oauth": "OAuth",
  "mcp.api_key": "API 密钥",
  "mcp.enabled": "已启用",
  "mcp.disabled": "已禁用",
  "mcp.add_mcp": "添加 MCP",
  "mcp.verify_connection": "验证连接",
  "mcp.cli_guidance": "CLI 指南（从您的工作区运行）",
  "mcp.config_locations": "配置可以位于 opencode.json、opencode.jsonc 或 .opencode/opencode.json。",
  "mcp.details_title": "详情",
  "mcp.select_server": "选择服务器",
  "mcp.select_server_hint": "选择服务器以查看状态和配置。",
  "mcp.capabilities": "功能",
  "mcp.capabilities_label": "功能",
  "mcp.tools_enabled": "已启用工具",
  "mcp.tools_enabled_label": "已启用工具",
  "mcp.oauth_ready": "OAuth 就绪",
  "mcp.oauth_ready_label": "OAuth 就绪",
  "mcp.usage_hint": "在提示中使用 MCP 服务器名称来定位其工具。",
  "mcp.usage_hint_text": "在提示中使用 MCP 服务器名称来定位其工具。",
  "mcp.next_steps": "后续步骤",
  "mcp.next_steps_label": "后续步骤",
  "mcp.reload_step": "添加服务器后重新加载引擎。",
  "mcp.auth_step": "如果提示，为 OAuth 服务器运行 opencode mcp auth。",
  "mcp.connection_failed": "连接失败",
  "mcp.needs_auth": "需要认证",
  "mcp.register_client": "注册客户端",
  "mcp.status_disabled": "已禁用",
  "mcp.disconnected": "已断开",
  "mcp.failed": "失败",
  "mcp.host_mode_only": "MCP 连接需要桌面应用。",
  "mcp.pick_workspace_first": "先选择一个工作区文件夹。",
  "mcp.desktop_required": "MCP 连接需要桌面应用。",
  "mcp.connect_server_first": "先连接到 OpenCode 服务器。",
  "mcp.reload_required_after_add": "添加 MCP 后需要重新加载。",
  "mcp.connect_failed": "MCP 连接失败。",
  "mcp.enter_name_and_url": "输入服务器名称和 URL。",
  "mcp.enter_url_first": "先输入服务器 URL。",
  "mcp.use_debug_command": "使用 opencode mcp debug <name> 验证连接。",
  "mcp.add_failed": "添加 MCP 失败。",

  // MCP Auth Modal
  "mcp.auth.open_browser_signin": "我们将打开您的浏览器完成登录。",
  "mcp.auth.connect_server": "连接 {server}",
  "mcp.auth.already_connected": "已连接",
  "mcp.auth.already_connected_description": "{server} 已通过身份验证，可以正常使用。",
  "mcp.auth.configured_previously": "该 MCP 可能在全局或之前的会话中已配置。您可以关闭此弹窗，立即开始使用 MCP 工具。",
  "mcp.auth.reload_engine_retry": "重新加载引擎并重试",
  "mcp.auth.retry_now": "立即重试",
  "mcp.auth.retry": "重试",
  "mcp.auth.step1_title": "正在打开您的浏览器",
  "mcp.auth.step1_description": "我们将自动启动 {server} 的登录流程。",
  "mcp.auth.step2_title": "授权 OpenWork",
  "mcp.auth.step2_description": "登录并在提示时批准访问权限。",
  "mcp.auth.step3_title": "完成后返回此处",
  "mcp.auth.step3_description": "授权完成后我们将立即完成连接。",
  "mcp.auth.waiting_authorization": "正在等待您在浏览器中完成授权...",
  "mcp.auth.done": "完成",
  "mcp.auth.cancel": "取消",
  "mcp.auth.im_done": "我已完成",
  "mcp.auth.client_registration_required": "在继续 OAuth 之前需要先注册客户端。",
  "mcp.auth.server_disabled": "此 MCP 服务器已禁用。请启用它后重试。",
  "mcp.auth.oauth_failed": "OAuth 身份验证失败。",
  "mcp.auth.invalid_refresh_token": "OAuth 刷新令牌无效或已过期。请重新授权。",
  "mcp.auth.reauth_action": "重新授权 OAuth",
  "mcp.auth.reauth_running": "正在重新授权...",
  "mcp.auth.reauth_failed": "重新授权失败。",
  "mcp.auth.reauth_cli_hint": "运行：opencode mcp auth {server}",
  "mcp.auth.reauth_remote_hint": "请在运行该工作区的设备上重新授权。",
  "mcp.auth.authorization_still_required": "仍需要授权。请重试以重新启动流程。",
  "mcp.auth.oauth_not_supported_hint": "这可能意味着：\n• MCP 服务器未声明 OAuth 功能\n• 引擎需要重新加载以发现服务器功能\n• 尝试：从 CLI 运行 opencode mcp auth {server}",
  "mcp.auth.try_reload_engine": "{message}。请尝试先重新加载引擎。",
  "mcp.auth.failed_to_start_oauth": "启动 OAuth 流程失败",
  "mcp.auth.oauth_completed_reload": "OAuth 已完成。重新加载引擎以激活 MCP。",

  // ==================== Settings ====================
  "settings.title": "设置",
  "settings.connection": "连接",
  "settings.engine_source": "引擎来源",
  "settings.from_path": "从 PATH",
  "settings.from_sidecar": "内置 sidecar",
  "settings.engine_source_description": "PATH 使用您安装的 OpenCode（默认）。Sidecar 将在可用时使用内置的二进制文件。",
  "settings.sidecar_unsupported": "Sidecar 已支持 Windows",
  "settings.sidecar_unavailable_detail": "Sidecar 可用时会随应用内置。",
  "settings.model": "模型",
  "settings.model_description": "默认值 + 运行的思考控制。",
  "settings.change": "更改",
  "settings.engine_path": "PATH",
  "settings.engine_sidecar": "Sidecar",
  "settings.thinking": "思考",
  "settings.thinking_description": "显示思考部分（仅开发者模式）。",
  "settings.on": "开启",
  "settings.off": "关闭",
  "settings.model_variant": "模型变体",
  "settings.edit": "编辑",
  "settings.default_model": "默认模型",
  "settings.session_model": "模型",
  "settings.model_description_default": "从您配置的提供商中选择。此选择将用于新会话。",
  "settings.model_description_session": "从您配置的提供商中选择。此选择适用于您的下一条消息。",
  "settings.search_models": "搜索模型…",
  "settings.showing_models": "显示 {count} / {total}",
  "settings.model_variant_prompt": "模型变体（提供商特定，例如 high/max/minimal）。留空则清除。",
  "settings.model_fallback": "备用",
  "settings.model_default": "默认",
  "settings.model_free": "免费",
  "settings.model_reasoning": "推理",
  "settings.done": "完成",
  "settings.updates": "更新",
  "settings.updates_description": "保持 OpenWork 为最新版本。",
  "settings.automatic_checks": "自动检查",
  "settings.automatic_checks_description": "每天一次（安静）",
  "settings.update_checking": "检查中...",
  "settings.update_available": "可用更新：v",
  "settings.update_downloading": "下载中...",
  "settings.update_ready": "准备安装：v",
  "settings.update_error": "更新检查失败",
  "settings.update_uptodate": "已是最新",
  "settings.last_checked": "上次检查",
  "settings.published": "发布时间",
  "settings.check_update": "检查",
  "settings.install_restart": "安装并重启",
  "settings.update_not_supported": "此环境不支持更新。",
  "settings.update_desktop_only": "更新仅在桌面应用中可用。",
  "settings.startup": "启动",
  "settings.mode_label": "模式",
  "settings.switch_mode": "切换",
  "settings.reset_startup": "重置默认启动模式",
  "settings.reset_startup_description": "这将清除您保存的偏好设置，并在下次启动时显示模式选择。",
  "settings.advanced": "高级",
  "settings.advanced_description": "重置 OpenWork 本地状态以重新测试入门流程。",
  "settings.reset_onboarding": "重置入门",
  "settings.reset_onboarding_description": "清除 OpenCode 偏好设置并重启应用。",
  "settings.reset_app_data": "重置应用数据",
  "settings.reset_app_data_description": "更激进的方式。清除 OpenCode 缓存 + 应用数据。",
  "settings.reset": "重置",
  "settings.requires_typing": "需要输入",
  "settings.will_restart": "并将重启应用。",
  "settings.reset_onboarding_title": "重置入门",
  "settings.reset_app_data_title": "重置应用数据",
  "settings.reset_confirmation_hint": "输入 <span class=\"font-mono\">RESET</span> 以确认。OpenWork 将重启。",
  "settings.reset_onboarding_warning": "清除 OpenWork 本地偏好设置和工作区入门标记。",
  "settings.reset_app_data_warning": "清除此设备上的 OpenWork 缓存和应用数据。",
  "settings.reset_stop_active_runs": "重置前停止活动运行。",
  "settings.reset_confirmation_label": "确认",
  "settings.reset_confirmation_placeholder": "输入 RESET",
  "settings.reset_cancel": "取消",
  "settings.reset_confirm_button": "重置并重启",
  "settings.developer": "开发者",
  "settings.opencode_cache": "OpenCode 缓存",
  "settings.opencode_cache_description": "修复用于启动引擎的缓存数据。安全运行。",
  "settings.repair_cache": "修复缓存",
  "settings.repairing_cache": "正在修复缓存",
  "settings.cache_repair_requires_desktop": "缓存修复需要桌面应用",
  "settings.pending_permissions": "待处理的权限",
  "settings.recent_events": "最近的事件",
  "settings.notion_connected": "已连接",
  "settings.reload_required": "需要重新加载",
  "settings.connection_failed": "连接失败",
  "settings.notion_not_connected": "未连接",
  "settings.show_thinking": "显示思考过程",
  "settings.update": "更新",
  "settings.about": "关于",
  "settings.version": "版本",
  "settings.check_for_updates": "检查更新",
  "settings.download_update": "下载更新",
  "settings.install_update": "安装更新并重启",
  "settings.enable_developer_mode": "启用开发者模式",
  "settings.disable_developer_mode": "禁用开发者模式",
  "settings.stop_engine": "停止引擎",
  "settings.disconnect": "断开连接",
  "settings.language": "语言",
  "settings.language.description": "选择您的首选语言",
  "settings.connection_title": "连接",
  "settings.engine_source_label": "引擎来源",
  "settings.engine_source_hint": "PATH 使用您安装的 OpenCode（默认）。Sidecar 将在可用时使用内置的二进制文件。",
  "settings.sidecar_unavailable": "Sidecar 可用时会随应用内置。",
  "settings.model_title": "模型",
  "settings.model_hint": "默认值 + 运行的思考控制。",
  "settings.thinking_label": "思考",
  "settings.thinking_hint": "显示思考部分（仅开发者模式）。",
  "settings.model_variant_label": "模型变体",
  "settings.appearance_title": "外观",
  "settings.appearance_hint": "匹配系统或强制浅色/深色模式。",
  "settings.theme_system": "系统",
  "settings.theme_light": "浅色",
  "settings.theme_dark": "深色",
  "settings.theme_system_hint": "系统模式自动跟随您的操作系统偏好。",
  "settings.updates_title": "更新",
  "settings.updates_hint": "保持 OpenWork 为最新版本。",
  "settings.automatic_checks_label": "自动检查",
  "settings.automatic_checks_hint": "每天一次（安静）",
  "settings.last_checked_time": "上次检查 {time}",
  "settings.published_date": "发布时间 {date}",
  "settings.update_not_supported_hint": "此环境不支持更新。",
  "settings.update_desktop_only_hint": "更新仅在桌面应用中可用。",
  "settings.startup_title": "启动",
  "settings.mode_suffix": "模式",
  "settings.reset_startup_label": "重置默认启动模式",
  "settings.reset_startup_hint": "这将清除您保存的偏好设置，并在下次启动时显示模式选择。",
  "settings.advanced_title": "高级",
  "settings.advanced_hint": "重置 OpenWork 本地状态以重新测试入门流程。",
  "settings.reset_onboarding_label": "重置入门",
  "settings.reset_onboarding_hint": "清除 OpenCode 偏好设置并重启应用。",
  "settings.reset_app_data_label": "重置应用数据",
  "settings.reset_app_data_hint": "更激进的方式。清除 OpenCode 缓存 + 应用数据。",
  "settings.reset_requires_hint": "需要输入 RESET 并将重启应用。",
  "settings.developer_title": "开发者",
  "settings.opencode_cache_label": "OpenCode 缓存",
  "settings.opencode_cache_hint": "修复用于启动引擎的缓存数据。安全运行。",
  "settings.pending_permissions_label": "待处理的权限",
  "settings.recent_events_label": "最近的事件",
  "settings.stop_active_runs_hint": "停止活动运行以更新",
  "settings.stop_active_runs_reset_hint": "停止活动运行以重置",
  "settings.stop_runs_to_update": "停止活动运行以更新",
  "settings.stop_runs_to_reset": "停止活动运行以重置",
  "settings.updates_not_supported": "此环境不支持更新。",
  "settings.updates_desktop_only": "更新仅在桌面应用中可用。",

  // ==================== Reload ====================
  "reload.toast_title": "需要重新加载",
  "reload.toast_description": "你需要重新加载工作区才能使这些更改生效。",
  "reload.toast_warning": "重新加载可能会中断正在进行的会话或流程。",
  "reload.toast_warning_active": "检测到活动运行，立即重新加载将会中断它们。",
  "reload.toast_reload": "重新加载",
  "reload.toast_reloading": "正在重新加载...",
  "reload.toast_dismiss": "忽略",
  "reload.toast_blocked_host": "仅本地工作区可重新加载。",
  "reload.toast_blocked_connect": "连接到此工作区后才能重新加载。",
  "reload.toast_blocked_runs": "请先停止活动运行再重新加载。",

  // ==================== Onboarding ====================
  "onboarding.starting_host": "正在启动 OpenWork 服务器...",
  "onboarding.searching_host": "正在连接 OpenWork 服务器...",
  "onboarding.getting_ready": "准备就绪",
  "onboarding.verifying": "验证安全握手",
  "onboarding.create_first_workspace": "创建您的第一个工作区",
  "onboarding.create_workspace": "创建工作区",
  "onboarding.workspace_description": "选择文件夹和预设以设置您的工作区。",
  "onboarding.start": "启动 OpenWork",
  "onboarding.back": "返回",
  "onboarding.advanced_settings": "高级设置",
  "onboarding.opencode_engine": "OpenCode 引擎",
  "onboarding.refresh": "刷新",
  "onboarding.checking_cli": "正在检查 OpenCode CLI...",
  "onboarding.cli_not_found": "未找到 OpenCode CLI。",
  "onboarding.cli_needs_update": "OpenCode CLI 需要更新以支持 serve。",
  "onboarding.opencode": "OpenCode",
  "onboarding.cli_ready": "OpenCode CLI 就绪。",
  "onboarding.cli_version": "OpenCode {version}",
  "onboarding.windows_install_instruction": "安装 Windows 版 OpenCode，然后重启 OpenWork。确保 opencode.exe 在 PATH 中。",
  "onboarding.install_instruction": "安装 OpenCode 以启用本地服务器（无需终端）。",
  "onboarding.install": "安装 OpenCode",
  "onboarding.recheck": "重新检查",
  "onboarding.ready_message": "OpenCode 已准备好启动本地服务器。",
  "onboarding.resolved_path": "解析路径",
  "onboarding.version": "版本",
  "onboarding.search_notes": "搜索说明",
  "onboarding.serve_help": "serve --help 输出",
  "onboarding.workspace_folder_label": "工作区是一个包含自己的 skills、插件和命令的文件夹。",
  "onboarding.theme_label": "主题",
  "onboarding.theme_current": "当前：{mode}",
  "onboarding.theme_system": "系统",
  "onboarding.theme_light": "浅色",
  "onboarding.theme_dark": "深色",
  "onboarding.access_label": "访问权限",
  "onboarding.folders_allowed": "{count} 个文件夹{plural}已授权",
  "onboarding.manage_access_hint": "您可以在高级设置中管理访问权限。",
  "onboarding.open_settings_hint": "需要引擎或访问选项？打开设置。",
  "onboarding.open_settings": "打开设置",
  "onboarding.add_folder_path": "添加文件夹路径",
  "onboarding.pick": "选择",
  "onboarding.add": "添加",
  "onboarding.remove": "移除",
  "onboarding.cli_label": "OpenCode CLI",
  "onboarding.cli_checking": "正在检查安装...",
  "onboarding.cli_not_found_hint": "未找到。请安装以运行本地服务器。",
  "onboarding.cli_version_installed": "已安装",
  "onboarding.cli_recheck": "重新检查",
  "onboarding.cli_install_commands": "使用以下命令之一安装 OpenCode，然后重启 OpenWork。",
  "onboarding.show_search_notes": "显示搜索说明",
  "onboarding.last_checked": "上次检查时间 {time}",
  "onboarding.server_url_placeholder": "http://localhost:8088",
  "onboarding.directory_placeholder": "my-project",
  "onboarding.connect_host": "连接服务器",
  "onboarding.connect_description": "与现有的 OpenCode 服务器配对（局域网或隧道）。",
  "onboarding.server_url": "服务器 URL",
  "onboarding.directory": "目录（可选）",
  "onboarding.directory_hint": "如果服务器运行多个工作区，请使用此选项。",
  "onboarding.connect": "连接",
  "onboarding.remote_workspace_title": "连接 OpenWork 服务器",
  "onboarding.remote_workspace_description": "连接 OpenWork 服务器以随时访问工作区。",
  "onboarding.remote_workspace_action": "连接",
  "onboarding.remote_workspace_card_title": "连接远程工作区",
  "onboarding.remote_workspace_card_description": "连接 OpenWork 服务器以访问共享工作区。",
  "onboarding.advanced_openwork_host": "OpenWork 服务器",
  "onboarding.advanced_openwork_hint": "使用服务器地址和访问令牌进行共享访问。",
  "onboarding.advanced_opencode_direct": "高级：OpenCode 直连",
  "onboarding.advanced_opencode_hint": "当没有服务器时，直接连接 OpenCode 引擎。",
  "onboarding.welcome_title": "今天想如何运行 OpenWork？",
  "onboarding.run_local": "本地运行",
  "onboarding.run_local_description": "OpenWork 在本地运行 OpenCode 并保持您的工作私密。",
  "onboarding.engine_running": "引擎已在运行",
  "onboarding.attach_description": "附加到此设备上的现有会话。",
  "onboarding.attach": "附加",
  "onboarding.remember_choice": "记住我的选择",
  "onboarding.client_mode": "作为客户端连接（远程配对）",
  "onboarding.default_workspace_path": "~/OpenWork/Workspace",
  "onboarding.authorize_folder": "授权文件夹",
  "onboarding.choose_workspace_folder": "选择工作区文件夹",

  // ==================== Common ====================
  "common.alpha": "测试版",
  "common.change": "更改",
  "common.refresh": "刷新",
  "common.new": "新建",
  "common.install": "安装",
  "common.delete": "删除",
  "common.edit": "编辑",
  "common.save": "保存",
  "common.cancel": "取消",
  "common.close": "关闭",
  "common.open": "打开",
  "common.show": "显示",
  "common.hide": "隐藏",
  "common.path": "路径",
  "common.choose": "选择",
  "common.retry": "重试",
  "common.untitled": "未命名",
  "common.default_parens": "(默认)",
  "common.on": "开启",
  "common.off": "关闭",

  // ==================== Status ====================
  "status.connected": "已连接",
  "status.disconnected": "已断开",
  "status.idle": "空闲",
  "status.busy": "忙碌",
  "status.running": "运行中",
  "status.live": "实时",
  "status.connecting": "正在连接",
  "status.creating_workspace": "正在创建工作区",
  "status.deleting_command": "正在删除命令",
  "status.saving_workspace_command": "正在保存工作区命令",
  "status.saving_command": "正在保存命令",
  "status.loading_session": "正在加载会话",
  "status.creating_task": "正在创建新任务",
  "status.starting_engine": "正在启动引擎",
  "status.reloading_engine": "正在重新加载引擎",
  "status.restarting_engine": "正在重启引擎",
  "status.installing_opencode": "正在安装 OpenCode",
  "status.disconnecting": "正在断开连接",

  // ==================== Workspace Switching ====================
  "workspace.switching_title": "正在打开 {name}",
  "workspace.switching_title_unknown": "正在打开工作区",
  "workspace.switching_subtitle": "马上带你回到最近的工作。",
  "workspace.switching_status_preparing": "正在准备",
  "workspace.switching_status_connecting": "正在检查连接",
  "workspace.switching_status_loading": "正在加载最近任务",
  "workspace.switching_status_almost": "快好了",

  "app.connection_lost": "服务器连接已断开。请重新加载。",
  "app.unknown_error": "未知错误",
  "app.error.tauri_required": "此操作需要 Tauri 应用运行时。",
  "app.error.choose_folder": "选择一个文件夹以继续。",
  "app.error.pick_workspace_folder": "请先选择一个工作区文件夹。",
  "app.error.remote_base_url_required": "请先填写服务器地址。",
  "app.error.host_requires_local": "请先选择本地工作区以启动引擎。",
  "app.error.sidecar_unsupported_windows": "Windows 上的 Sidecar OpenCode 可用时会内置。将回退到 PATH。",
  "app.error.install_failed": "OpenCode 安装失败。请查看上方日志。",
  "app.error.command_name_template_required": "命令名称和指令为必填项。",
  "app.error.workspace_commands_desktop": "命令需要桌面应用。",
  "app.error.command_scope_unknown": "此命令无法在当前模式下管理。",
} as const;
