/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.util.pcodeInject.ConstantPoolJava;
import ghidra.app.util.pcodeInject.InjectGetField;
import ghidra.app.util.pcodeInject.InjectGetStatic;
import ghidra.app.util.pcodeInject.InjectInvokeDynamic;
import ghidra.app.util.pcodeInject.InjectInvokeInterface;
import ghidra.app.util.pcodeInject.InjectInvokeSpecial;
import ghidra.app.util.pcodeInject.InjectInvokeStatic;
import ghidra.app.util.pcodeInject.InjectInvokeVirtual;
import ghidra.app.util.pcodeInject.InjectLdc;
import ghidra.app.util.pcodeInject.InjectMultiANewArray;
import ghidra.app.util.pcodeInject.InjectPayloadJava;
import ghidra.app.util.pcodeInject.InjectPayloadJavaParameters;
import ghidra.app.util.pcodeInject.InjectPutField;
import ghidra.app.util.pcodeInject.InjectPutStatic;
import ghidra.program.model.lang.ConstantPool;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.listing.Program;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PcodeInjectLibraryJava
extends PcodeInjectLibrary {
    public static final int CONSTANT_POOL_START_ADDRESS = 10;
    public static final String GETFIELD = "getFieldCallOther";
    public static final String GETSTATIC = "getStaticCallOther";
    public static final String INVOKE_DYNAMIC = "invokedynamicCallOther";
    public static final String INVOKE_INTERFACE = "invokeinterfaceCallOther";
    public static final String INVOKE_SPECIAL = "invokespecialCallOther";
    public static final String INVOKE_STATIC = "invokestaticCallOther";
    public static final String INVOKE_VIRTUAL = "invokevirtualCallOther";
    public static final String LDC = "ldcCallOther";
    public static final String LDC2_W = "ldc2_wCallOther";
    public static final String LDC_W = "ldc_wCallOther";
    public static final String MULTIANEWARRAY = "multianewarrayCallOther";
    public static final String PUTFIELD = "putFieldCallOther";
    public static final String PUTSTATIC = "putStaticCallOther";
    public static final String SOURCENAME = "javainternal";
    public static final int REFERENCE_SIZE = 4;
    private Map<String, InjectPayloadJava> implementedOps;

    public PcodeInjectLibraryJava(SleighLanguage l) {
        super(l);
        this.implementedOps = new HashMap<String, InjectPayloadJava>();
        this.implementedOps.put(GETFIELD, new InjectGetField(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(GETSTATIC, new InjectGetStatic(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(INVOKE_DYNAMIC, new InjectInvokeDynamic(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(INVOKE_INTERFACE, new InjectInvokeInterface(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(INVOKE_SPECIAL, new InjectInvokeSpecial(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(INVOKE_STATIC, new InjectInvokeStatic(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(INVOKE_VIRTUAL, new InjectInvokeVirtual(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(LDC, new InjectLdc(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(LDC2_W, new InjectLdc(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(LDC_W, new InjectLdc(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(MULTIANEWARRAY, new InjectMultiANewArray(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(PUTFIELD, new InjectPutField(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
        this.implementedOps.put(PUTSTATIC, new InjectPutStatic(SOURCENAME, l, this.uniqueBase));
        this.uniqueBase += 256L;
    }

    public PcodeInjectLibraryJava(PcodeInjectLibraryJava op2) {
        super((PcodeInjectLibrary)op2);
        this.implementedOps = op2.implementedOps;
    }

    public PcodeInjectLibrary clone() {
        return new PcodeInjectLibraryJava(this);
    }

    public InjectPayload allocateInject(String sourceName, String name, int tp) {
        InjectPayloadJava payload;
        if (tp == 3) {
            return new InjectPayloadJavaParameters(name, sourceName, this.language, tp);
        }
        if (tp == 2 && (payload = this.implementedOps.get(name)) != null) {
            return payload;
        }
        return super.allocateInject(sourceName, name, tp);
    }

    public ConstantPool getConstantPool(Program program) throws IOException {
        return new ConstantPoolJava(program);
    }
}

