/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.PackedBytes;
import ghidra.program.model.pcode.PackedEncode;
import ghidra.program.model.pcode.PatchEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class PatchPackedEncode
extends PackedEncode
implements PatchEncoder {
    private PackedBytes editStream = null;

    @Override
    public int size() {
        return this.editStream.size();
    }

    @Override
    public void writeSpaceId(AttributeId attribId, long spaceId) throws IOException {
        this.writeHeader(192, attribId.id());
        int uniqueId = (int)spaceId >> 7;
        this.writeInteger(80, uniqueId);
    }

    private int skipOpen(int pos) {
        int val = this.editStream.getByte(pos) & 0xE0;
        if (val == 64) {
            return pos + 1;
        }
        if (val == 96) {
            return pos + 2;
        }
        return -1;
    }

    private long readInteger(int pos, int len) {
        long res = 0L;
        while (len > 0) {
            res <<= 7;
            res |= (long)(this.editStream.getByte(pos) & 0x7F);
            ++pos;
            --len;
        }
        return res;
    }

    @Override
    public boolean patchIntegerAttribute(int pos, AttributeId attribId, long val) {
        int length;
        if ((pos = this.skipOpen(pos)) < 0) {
            return false;
        }
        while (true) {
            int header1;
            if (((header1 = this.editStream.getByte(pos)) & 0xC0) != 192) {
                return false;
            }
            ++pos;
            int curid = header1 & 0x1F;
            if ((header1 & 0x20) != 0) {
                curid <<= 7;
                curid |= this.editStream.getByte(pos) & 0x7F;
                ++pos;
            }
            int typeByte = this.editStream.getByte(pos) & 0xFF;
            ++pos;
            int attribType = typeByte >> 4;
            if (attribType == 1 || attribType == 6) continue;
            length = typeByte & 0xF;
            if (attribType == 7) {
                length = (int)this.readInteger(pos, length);
            }
            if (attribId.id() == curid) break;
            pos += length;
        }
        if (length != 10) {
            return false;
        }
        for (int sa = 63; sa >= 0; sa -= 7) {
            long piece = val >>> sa & 0x7FL;
            this.editStream.insertByte(pos, (int)(piece |= 0x80L));
            ++pos;
        }
        return true;
    }

    @Override
    public void clear() {
        this.editStream = new PackedBytes(512);
        this.outStream = this.editStream;
    }

    @Override
    public boolean isEmpty() {
        return this.editStream.size() == 0;
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        this.editStream.writeTo(stream);
    }
}

