/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import ghidra.util.Msg;
import java.io.IOException;

public class SourceFileIndexer {
    private BiMap<String, Integer> filenameToIndex = HashBiMap.create();
    private int leastUnusedIndex = 0;

    public Integer index(Location loc) {
        if (loc == null) {
            Msg.info((Object)this, (Object)"null Location");
            return null;
        }
        String filename = loc.filename;
        if (filename == null) {
            Msg.info((Object)this, (Object)"null filename");
            return null;
        }
        Integer res = (Integer)this.filenameToIndex.putIfAbsent((Object)filename, (Object)this.leastUnusedIndex);
        if (res == null) {
            return this.leastUnusedIndex++;
        }
        return res;
    }

    public Integer getIndex(String filename) {
        return (Integer)this.filenameToIndex.get((Object)filename);
    }

    public String getFileName(Integer index) {
        return (String)this.filenameToIndex.inverse().get((Object)index);
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_SOURCEFILES);
        for (int i = 0; i < this.leastUnusedIndex; ++i) {
            encoder.openElement(SlaFormat.ELEM_SOURCEFILE);
            encoder.writeString(SlaFormat.ATTRIB_NAME, (String)this.filenameToIndex.inverse().get((Object)i));
            encoder.writeSignedInteger(SlaFormat.ATTRIB_INDEX, i);
            encoder.closeElement(SlaFormat.ELEM_SOURCEFILE);
        }
        encoder.closeElement(SlaFormat.ELEM_SOURCEFILES);
    }

    public void decode(Decoder decoder) throws DecoderException {
        int elem = decoder.openElement(SlaFormat.ELEM_SOURCEFILES);
        while (decoder.peekElement() == SlaFormat.ELEM_SOURCEFILE.id()) {
            decoder.openElement();
            String filename = decoder.readString(SlaFormat.ATTRIB_NAME);
            int index = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_INDEX);
            this.filenameToIndex.put((Object)filename, (Object)index);
            decoder.closeElement(SlaFormat.ELEM_SOURCEFILE.id());
        }
        decoder.closeElement(elem);
    }
}

