/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.DialogComponentProvider;
import docking.ReusableDialogComponentProvider;
import docking.widgets.button.GRadioButton;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.datatype.CategoryPathSelectionEditor;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.MessageType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.layout.PairLayout;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.lang3.StringUtils;

public class CreateStructureDialog
extends ReusableDialogComponentProvider {
    private static final String NEW_STRUCTURE_STATUS_PREFIX = "Creating new structure: ";
    private static final String EXISITING_STRUCTURE_STATUS_PREFIX = "Using existing structure: ";
    private static final String STRUCTURE_COLUMN_NAME = "Structure";
    private static final String CATEGORY_COLUMN_NAME = "Category";
    private JTextField nameTextField;
    private CategoryPathSelectionEditor categoryPathEditor;
    private GhidraTable matchingStructuresTable;
    private StructureTableModel structureTableModel;
    private Structure currentStructure;
    private Program currentProgram;
    private PluginTool pluginTool;
    private JRadioButton createNewStructButton;
    private JRadioButton useExistingStructButton;
    private JRadioButton exactMatchButton;
    private JRadioButton sizeMatchButton;
    private GhidraTableFilterPanel<StructureWrapper> filterPanel;

    public CreateStructureDialog(PluginTool tool, Program program) {
        super("Create Structure", true, true, true, false);
        this.pluginTool = tool;
        this.currentProgram = program;
        this.setHelpLocation(new HelpLocation("DataPlugin", "Create_Structure_Dialog"));
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.rootPanel.setPreferredSize(new Dimension(600, 600));
        this.setDefaultButton(this.okButton);
    }

    public void dispose() {
        this.currentProgram = null;
        this.filterPanel.dispose();
        super.dispose();
    }

    private JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.createChoicePanel());
        this.setStatusJustification(2);
        return mainPanel;
    }

    private JPanel createChoicePanel() {
        JPanel radioChoicePanel = new JPanel(new BorderLayout());
        this.createNewStructButton = new GRadioButton("Create New");
        this.createNewStructButton.getAccessibleContext().setAccessibleName("Create New");
        this.useExistingStructButton = new GRadioButton("Use Existing");
        this.useExistingStructButton.getAccessibleContext().setAccessibleName("Use Existing");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.createNewStructButton);
        buttonGroup.add(this.useExistingStructButton);
        this.createNewStructButton.setSelected(true);
        ItemListener choiceListener = event -> this.updateEnablement();
        this.createNewStructButton.addItemListener(choiceListener);
        this.useExistingStructButton.addItemListener(choiceListener);
        JPanel createNewStructPanel = new JPanel();
        createNewStructPanel.setLayout(new BoxLayout(createNewStructPanel, 1));
        createNewStructPanel.setAlignmentX(0.0f);
        createNewStructPanel.setBorder(BorderFactory.createEmptyBorder(5, 30, 15, 5));
        JPanel useExistingStructPanel = new JPanel();
        useExistingStructPanel.setLayout(new BoxLayout(useExistingStructPanel, 1));
        useExistingStructPanel.setAlignmentX(0.0f);
        useExistingStructPanel.setBorder(BorderFactory.createEmptyBorder(0, 30, 10, 5));
        createNewStructPanel.add(this.buildCreateNewStructPanel());
        useExistingStructPanel.add(this.buildMatchingStructPanel());
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 3));
        top.add(this.createNewStructButton);
        top.add(createNewStructPanel);
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 3));
        center.add(this.useExistingStructButton);
        center.add(useExistingStructPanel);
        radioChoicePanel.add((Component)top, "North");
        radioChoicePanel.add((Component)center, "Center");
        return radioChoicePanel;
    }

    private JPanel buildCreateNewStructPanel() {
        JPanel newStructPanel = new JPanel();
        newStructPanel.setLayout((LayoutManager)new PairLayout());
        newStructPanel.setToolTipText("Enter a name and category (optional)");
        JLabel nameLabel = new JLabel("Name: ");
        this.nameTextField = new JTextField();
        this.nameTextField.setName("StructureName");
        this.nameTextField.getAccessibleContext().setAccessibleName("Name");
        this.nameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CreateStructureDialog.this.createNewStructButton.setSelected(true);
                CreateStructureDialog.this.updateEnablement();
            }
        });
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                this.checkText(event.getDocument());
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                this.checkText(event.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                this.checkText(event.getDocument());
            }

            private void checkText(Document document) {
                try {
                    String text = document.getText(0, document.getLength());
                    if (StringUtils.isBlank((CharSequence)text)) {
                        CreateStructureDialog.this.okButton.setEnabled(false);
                        CreateStructureDialog.this.updateStatusText(true, null);
                    } else {
                        CreateStructureDialog.this.okButton.setEnabled(true);
                        CreateStructureDialog.this.updateStatusText(true, text);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        JLabel categoryLabel = new JLabel("Category: ");
        this.buildCategoryPathEditor();
        newStructPanel.add(nameLabel);
        newStructPanel.add(this.nameTextField);
        newStructPanel.add(categoryLabel);
        newStructPanel.add(this.categoryPathEditor.getEditorComponent());
        return newStructPanel;
    }

    private void buildCategoryPathEditor() {
        this.categoryPathEditor = new CategoryPathSelectionEditor((ServiceProvider)this.pluginTool);
        JComponent editorComponent = this.categoryPathEditor.getEditorComponent();
        editorComponent.getAccessibleContext().setAccessibleName(CATEGORY_COLUMN_NAME);
        this.categoryPathEditor.setCellEditorValue(CategoryPath.ROOT);
        this.categoryPathEditor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CreateStructureDialog.this.createNewStructButton.setSelected(true);
                CreateStructureDialog.this.updateEnablement();
            }
        });
    }

    private JPanel buildMatchingStructPanel() {
        JPanel structurePanel = new JPanel();
        structurePanel.setLayout(new BoxLayout(structurePanel, 1));
        GTable table = this.buildMatchingStructuresTable();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CreateStructureDialog.this.useExistingStructButton.setSelected(true);
                CreateStructureDialog.this.updateEnablement();
            }
        });
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (this.useExistingStructButton.isSelected()) {
                this.setOkEnabled(table.getSelectedRowCount() > 0);
            }
        });
        this.filterPanel = new GhidraTableFilterPanel<StructureWrapper>((JTable)table, (RowObjectTableModel)this.structureTableModel){

            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.height = this.getPreferredSize().height;
                return d;
            }
        };
        JScrollPane scrollPane = new JScrollPane((Component)table);
        scrollPane.getAccessibleContext().setAccessibleName("Scroll");
        structurePanel.add(scrollPane);
        structurePanel.add(Box.createVerticalStrut(10));
        structurePanel.add((Component)((Object)this.filterPanel));
        structurePanel.add(Box.createVerticalStrut(10));
        structurePanel.add(this.buildMatchingStyelPanel());
        structurePanel.add(Box.createVerticalStrut(10));
        return structurePanel;
    }

    private GTable buildMatchingStructuresTable() {
        this.structureTableModel = new StructureTableModel();
        this.matchingStructuresTable = new GhidraTable((TableModel)((Object)this.structureTableModel));
        this.matchingStructuresTable.setAutoLookupColumn(0);
        this.matchingStructuresTable.setSelectionMode(0);
        this.matchingStructuresTable.setAutoCreateColumnsFromModel(false);
        this.matchingStructuresTable.setPreferredScrollableViewportSize(new Dimension(200, 100));
        StructureCellRenderer cellRenderer = new StructureCellRenderer();
        TableColumnModel columnModel = this.matchingStructuresTable.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            column.setCellRenderer((TableCellRenderer)((Object)cellRenderer));
        }
        ListSelectionModel lsm = this.matchingStructuresTable.getSelectionModel();
        lsm.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
            if (selectionModel != null && !selectionModel.isSelectionEmpty()) {
                this.useExistingStructButton.setSelected(true);
            }
            this.updateEnablement();
        });
        this.matchingStructuresTable.getAccessibleContext().setAccessibleName("Matching Structures");
        return this.matchingStructuresTable;
    }

    private void updateStatus() {
        this.clearStatusText();
        if (this.useExistingStructButton.isSelected()) {
            Structure structure = this.getSelectedStructure();
            if (structure != null) {
                this.updateStatusText(false, structure.getName());
            }
        } else {
            this.updateStatusText(true, this.nameTextField.getText());
        }
    }

    private JPanel buildMatchingStyelPanel() {
        JPanel matchingStylePanel = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
            }
        };
        matchingStylePanel.setLayout(new BoxLayout(matchingStylePanel, 0));
        matchingStylePanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), "Matching: "));
        this.exactMatchButton = new GRadioButton("Exact");
        this.exactMatchButton.getAccessibleContext().setAccessibleName("Exact Match");
        this.sizeMatchButton = new GRadioButton("Size");
        this.sizeMatchButton.getAccessibleContext().setAccessibleName("Size Match");
        this.exactMatchButton.setToolTipText("Match structures with the same number and type of data elements");
        this.sizeMatchButton.setToolTipText("Match structures of the same size");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.exactMatchButton);
        buttonGroup.add(this.sizeMatchButton);
        this.sizeMatchButton.setSelected(true);
        ItemListener searchListener = event -> this.searchForMatchingStructures(this.currentProgram, this.currentStructure);
        this.exactMatchButton.addItemListener(searchListener);
        this.sizeMatchButton.addItemListener(searchListener);
        matchingStylePanel.add(this.exactMatchButton);
        matchingStylePanel.add(this.sizeMatchButton);
        return matchingStylePanel;
    }

    private void updateEnablement() {
        if (this.createNewStructButton.isSelected()) {
            this.nameTextField.setEnabled(true);
            this.categoryPathEditor.setEnabled(true);
            this.matchingStructuresTable.setEnabled(false);
            this.exactMatchButton.setEnabled(false);
            this.sizeMatchButton.setEnabled(false);
            this.matchingStructuresTable.clearSelection();
        } else {
            this.nameTextField.setEnabled(false);
            this.categoryPathEditor.setEnabled(false);
            this.matchingStructuresTable.setEnabled(true);
            this.exactMatchButton.setEnabled(true);
            this.sizeMatchButton.setEnabled(true);
        }
        this.rootPanel.repaint();
        this.updateStatus();
    }

    private void searchForMatchingStructures(Program program, Structure structure) {
        DataTypeManagerService service = (DataTypeManagerService)this.pluginTool.getService(DataTypeManagerService.class);
        DataTypeManager[] dataTypeManagers = null;
        dataTypeManagers = service != null ? service.getDataTypeManagers() : new DataTypeManager[]{program.getDataTypeManager()};
        this.getMatchingStructuresFromDataTypeManagers(structure, dataTypeManagers);
    }

    private void getMatchingStructuresFromDataTypeManagers(Structure structure, DataTypeManager[] dataTypeManagers) {
        ArrayList<StructureWrapper> dataList = new ArrayList<StructureWrapper>();
        for (DataTypeManager dataTypeManager : dataTypeManagers) {
            Iterator structureIterator = dataTypeManager.getAllStructures();
            while (structureIterator.hasNext()) {
                Structure nextStructure = (Structure)structureIterator.next();
                if (!this.compareStructures(nextStructure, structure)) continue;
                dataList.add(new StructureWrapper(this, nextStructure));
            }
        }
        this.structureTableModel.setData(dataList);
    }

    private boolean compareStructures(Structure structureA, Structure structureB) {
        if (this.sizeMatchButton.isSelected()) {
            return this.compareStructuresBySize(structureA, structureB);
        }
        return this.compareStructuresByData(structureA, structureB);
    }

    private boolean compareStructuresBySize(Structure structureA, Structure structureB) {
        return structureA.getLength() == structureB.getLength();
    }

    private boolean compareStructuresByData(Structure structureA, Structure structureB) {
        DataTypeComponent[] definedComponentsB;
        if (structureA.getLength() != structureB.getLength()) {
            return false;
        }
        DataTypeComponent[] definedComponentsA = structureA.getDefinedComponents();
        if (definedComponentsA.length == (definedComponentsB = structureB.getDefinedComponents()).length) {
            for (int i = 0; i < definedComponentsA.length; ++i) {
                if (this.compareDataTypeComponents(definedComponentsA[i], definedComponentsB[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean compareDataTypeComponents(DataTypeComponent dtcA, DataTypeComponent dtcB) {
        return dtcA.getLength() == dtcB.getLength() && dtcA.getOffset() == dtcB.getOffset() && dtcA.getOrdinal() == dtcB.getOrdinal() && this.compareDataTypes(dtcA.getDataType(), dtcB.getDataType());
    }

    private boolean compareDataTypes(DataType typeA, DataType typeB) {
        if (typeA instanceof Structure) {
            if (typeB instanceof Structure) {
                return this.compareStructuresByData((Structure)typeA, (Structure)typeB);
            }
            return false;
        }
        return typeA.getName().equals(typeB.getName()) && typeA.getLength() == typeB.getLength();
    }

    JTextField getNameField() {
        return this.nameTextField;
    }

    JTable getTable() {
        return this.matchingStructuresTable;
    }

    CategoryPathSelectionEditor getCategoryEditor() {
        return this.categoryPathEditor;
    }

    public Structure showCreateStructureDialog(Program program, Structure structure) throws NullPointerException {
        if (program == null) {
            throw new NullPointerException("Cannot show Create Structure dialog without a non-null Program.");
        }
        if (structure == null) {
            throw new NullPointerException("Non-null structure is required when showing the Create Structure dialog.");
        }
        this.currentStructure = structure;
        this.nameTextField.setText(this.currentStructure.getName());
        this.updateStatusText(true, this.currentStructure.getName());
        this.searchForMatchingStructures(program, structure);
        this.pluginTool.showDialog((DialogComponentProvider)this);
        return this.currentStructure;
    }

    protected void cancelCallback() {
        this.currentStructure = null;
        super.cancelCallback();
    }

    protected void okCallback() {
        if (this.useExistingStructButton.isSelected()) {
            this.currentStructure = this.getSelectedStructure();
            this.close();
            return;
        }
        String nameText = this.nameTextField.getText();
        try {
            this.currentStructure.setName(nameText);
        }
        catch (InvalidNameException ine) {
            this.setStatusText(ine.getMessage());
            return;
        }
        catch (DuplicateNameException dne) {
            this.setStatusText(dne.getMessage());
            return;
        }
        if (!this.setCategoryPath()) {
            return;
        }
        if (!this.validateName()) {
            return;
        }
        this.close();
    }

    private boolean validateName() {
        CategoryPath path;
        ProgramBasedDataTypeManager dtm = this.currentProgram.getDataTypeManager();
        Category category = dtm.getCategory(path = this.currentStructure.getCategoryPath());
        if (category == null) {
            return true;
        }
        String nameText = this.currentStructure.getName();
        DataType existingDt = category.getDataType(nameText);
        if (existingDt != null) {
            this.setStatusText("Name already exists: " + nameText, MessageType.ERROR);
            return false;
        }
        return true;
    }

    private Structure getSelectedStructure() {
        int row = this.matchingStructuresTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        Object cellValue = this.matchingStructuresTable.getValueAt(row, 0);
        return ((StructureWrapper)cellValue).getStructure();
    }

    private boolean setCategoryPath() {
        try {
            this.doSetCategoryPath();
        }
        catch (DuplicateNameException e) {
            this.setStatusText(e.getMessage(), MessageType.ERROR);
            return false;
        }
        return true;
    }

    private void doSetCategoryPath() throws DuplicateNameException {
        CategoryPath path = this.categoryPathEditor.getCellEditorValue();
        String editorValue = this.categoryPathEditor.getCellEditorValueAsText();
        if (path != null && path.getPath().equals(editorValue)) {
            this.currentStructure.setCategoryPath(path);
            return;
        }
        if (!editorValue.isBlank()) {
            CategoryPath parsedPath = this.parseEnteredCategoryPath(editorValue);
            this.currentStructure.setCategoryPath(parsedPath);
            return;
        }
        this.currentStructure.setCategoryPath(CategoryPath.ROOT);
    }

    private CategoryPath parseEnteredCategoryPath(String categoryText) {
        if (categoryText.startsWith("/")) {
            return new CategoryPath(categoryText);
        }
        return new CategoryPath("/" + categoryText);
    }

    private void updateStatusText(boolean creatingNew, String name) {
        if (name == null) {
            this.setStatusText("");
            return;
        }
        String prefix = EXISITING_STRUCTURE_STATUS_PREFIX;
        if (creatingNew) {
            prefix = NEW_STRUCTURE_STATUS_PREFIX;
        }
        String escapeName = HTMLUtilities.escapeHTML((String)name);
        String message = "<html>%s'%s'".formatted(prefix, escapeName);
        this.setStatusText(message);
    }

    class StructureTableModel
    extends AbstractSortedTableModel<StructureWrapper> {
        private List<StructureWrapper> data = Collections.emptyList();

        StructureTableModel() {
        }

        public String getName() {
            return CreateStructureDialog.STRUCTURE_COLUMN_NAME;
        }

        void setData(List<StructureWrapper> data) {
            this.data = data;
            this.fireTableDataChanged();
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return CreateStructureDialog.STRUCTURE_COLUMN_NAME;
                }
                case 1: {
                    return CreateStructureDialog.CATEGORY_COLUMN_NAME;
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean isSortable(int columnIndex) {
            return true;
        }

        public List<StructureWrapper> getModelData() {
            return this.data;
        }

        public Object getColumnValueForRow(StructureWrapper t, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return t;
                }
                case 1: {
                    Structure structure = t.getStructure();
                    CategoryPath path = structure.getCategoryPath();
                    return path.toString();
                }
            }
            return null;
        }
    }

    private class StructureCellRenderer
    extends GTableCellRenderer {
        private StructureCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JComponent renderer = (JComponent)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            JTable table = data.getTable();
            int row = data.getRowViewIndex();
            int column = data.getColumnViewIndex();
            String columnName = table.getColumnName(column);
            if (CreateStructureDialog.STRUCTURE_COLUMN_NAME.equals(columnName)) {
                StructureWrapper wrapper = (StructureWrapper)table.getValueAt(row, 0);
                if (wrapper != null) {
                    Structure structure = wrapper.getStructure();
                    renderer.setToolTipText(ToolTipUtils.getToolTipText((DataType)structure));
                }
            } else if (CreateStructureDialog.CATEGORY_COLUMN_NAME.equals(columnName) && value != null) {
                renderer.setToolTipText(value.toString());
            }
            return renderer;
        }
    }

    class StructureWrapper {
        private Structure structure;

        private StructureWrapper(CreateStructureDialog this$0, Structure newStructure) {
            this.structure = newStructure;
        }

        Structure getStructure() {
            return this.structure;
        }

        public String toString() {
            return this.structure.getName();
        }
    }
}

