/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.hover;

import docking.DockingUtils;
import docking.widgets.PopupWindow;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.HoverProvider;
import docking.widgets.shapes.PopupWindowPlacer;
import ghidra.app.services.HoverService;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolTip;

public abstract class AbstractHoverProvider
implements HoverProvider {
    protected List<HoverService> hoverServices = new ArrayList<HoverService>();
    protected boolean enabled = true;
    protected Program program;
    protected Field lastField;
    private static final Comparator<HoverService> HOVER_PRIORITY_COMPARATOR = (service1, service2) -> service2.getPriority() - service1.getPriority();
    protected HoverService activeHoverService;
    protected PopupWindow popupWindow;
    protected PopupWindowPlacer popupWindowPlacer;
    protected final String windowName;

    public AbstractHoverProvider(String windowName) {
        this.windowName = windowName;
    }

    protected void addHoverService(HoverService hoverService) {
        this.hoverServices.add(hoverService);
        Collections.sort(this.hoverServices, HOVER_PRIORITY_COMPARATOR);
    }

    protected void removeHoverService(HoverService hoverService) {
        this.hoverServices.remove(hoverService);
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setHoverEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled && !this.hasEnabledHoverServices()) {
            Msg.showInfo(this.getClass(), null, (String)"No Popups Enabled", (Object)"You have chosen to enable tooltip style popups, but none are currently enabled.\nTo enable these popups you must use the options menu: \"Options->Listing Popups\"");
        }
    }

    public void setPopupPlacer(PopupWindowPlacer popupWindowPlacer) {
        this.popupWindowPlacer = popupWindowPlacer;
    }

    public boolean isForcePopups() {
        return false;
    }

    private boolean hasEnabledHoverServices() {
        for (HoverService hoverService : this.hoverServices) {
            if (!hoverService.hoverModeSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean isShowing() {
        return this.popupWindow != null && this.popupWindow.isShowing();
    }

    public void closeHover() {
        this.activeHoverService = null;
        this.lastField = null;
        DockingUtils.hideTipWindow();
        if (this.popupWindow != null) {
            this.popupWindow.dispose();
            this.popupWindow = null;
        }
    }

    public void scroll(int amount) {
        if (this.activeHoverService != null) {
            this.activeHoverService.scroll(amount);
        }
    }

    public void dispose() {
        Swing.runLater(() -> {
            this.closeHover();
            this.hoverServices.clear();
        });
        this.program = null;
    }

    protected abstract ProgramLocation getHoverLocation(FieldLocation var1, Field var2, Rectangle var3, MouseEvent var4);

    public void mouseHovered(FieldLocation fieldLocation, Field field, Rectangle fieldBounds, MouseEvent event) {
        if (this.isShowing() && field == this.lastField) {
            return;
        }
        if (this.program == null) {
            return;
        }
        Component component = event.getComponent();
        if (!component.isShowing()) {
            return;
        }
        ProgramLocation loc = this.getHoverLocation(fieldLocation, field, fieldBounds, event);
        for (HoverService hoverService : this.hoverServices) {
            JComponent comp = hoverService.getHoverComponent(this.program, loc, fieldLocation, field);
            if (comp == null) continue;
            this.closeHover();
            this.activeHoverService = hoverService;
            this.showPopup(comp, field, event, fieldBounds);
            return;
        }
    }

    protected void showPopup(JComponent comp, Field field, MouseEvent event, Rectangle fieldBounds) {
        this.lastField = field;
        if (!this.enabled) {
            return;
        }
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = kfm.getActiveWindow();
        if (activeWindow == null) {
            activeWindow = JOptionPane.getRootFrame();
        }
        if (this.popupWindow != null) {
            this.popupWindow.dispose();
        }
        this.popupWindow = new PopupWindow(activeWindow, comp);
        this.popupWindow.setWindowName(this.windowName);
        this.popupWindow.setPopupPlacer(this.popupWindowPlacer);
        this.popupWindow.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (AbstractHoverProvider.this.activeHoverService != null) {
                    AbstractHoverProvider.this.activeHoverService.componentShown();
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (AbstractHoverProvider.this.activeHoverService != null) {
                    AbstractHoverProvider.this.activeHoverService.componentHidden();
                }
            }
        });
        boolean force = this.isForcePopups();
        boolean isToolTip = comp instanceof JToolTip;
        if (isToolTip) {
            this.popupWindow.showPopup(event, force);
        } else {
            int horizontalPad = 100;
            int verticalPad = 50;
            Rectangle keepVisibleArea = new Rectangle(event.getPoint());
            keepVisibleArea.grow(horizontalPad, verticalPad);
            this.popupWindow.showOffsetPopup(event, keepVisibleArea, force);
        }
    }

    public void initializeListingHoverHandler(AbstractHoverProvider otherHandler) {
        otherHandler.program = this.program;
        otherHandler.enabled = this.enabled;
        otherHandler.hoverServices = new ArrayList<HoverService>(this.hoverServices);
    }
}

