/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

public class ByteSequenceLengthFilter {
    private int internalIndex;
    private int minLength;

    public ByteSequenceLengthFilter(int internalIndex, int minLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength must be non-negative!");
        }
        if (minLength < Math.abs(internalIndex)) {
            throw new IllegalArgumentException("minLength too small for this internalIndex!");
        }
        this.internalIndex = 2 * internalIndex;
        this.minLength = 2 * minLength;
    }

    public String filter(String base) {
        if (base == null || base.length() < this.minLength) {
            return null;
        }
        if (this.internalIndex >= 0) {
            return base.substring(0, this.internalIndex);
        }
        int len = base.length();
        return base.substring(len + this.internalIndex, len);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("internalIndex: ");
        sb.append(this.internalIndex);
        sb.append("\nminLength: ");
        sb.append(this.minLength);
        sb.append("\n");
        return sb.toString();
    }
}

