/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.multidex;

import ghidra.app.util.opinion.Loaded;
import ghidra.file.formats.android.dex.DexHeaderFactory;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.MethodIDItem;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MultiDexLinker
implements AutoCloseable {
    private List<Program> programs;
    private Map<Program, DexHeader> dexMap = new HashMap<Program, DexHeader>();
    private Map<DexHeader, Map<ClassMethodPrototype, Integer>> cmpMap = new HashMap<DexHeader, Map<ClassMethodPrototype, Integer>>();
    private Map<Program, List<Address>> changeMap = new HashMap<Program, List<Address>>();

    public MultiDexLinker(List<Loaded<Program>> loadedPrograms) {
        this.programs = new ArrayList<Program>();
        for (Loaded<Program> loaded : loadedPrograms) {
            this.programs.add((Program)loaded.getDomainObject((Object)this));
        }
    }

    public void link(TaskMonitor monitor) throws CancelledException, IOException, MemoryAccessException, InvalidInputException, DuplicateNameException {
        Objects.requireNonNull(monitor);
        this.cacheHeaderInfo(monitor);
        this.linkPrograms(monitor);
    }

    @Override
    public void close() {
        this.programs.forEach(p -> p.release((Object)this));
        this.programs.clear();
        this.dexMap.clear();
        for (DexHeader header : this.cmpMap.keySet()) {
            this.cmpMap.get(header).clear();
        }
        this.cmpMap.clear();
        this.changeMap.clear();
    }

    public List<Address> getChangeList(Program program) {
        return Objects.requireNonNull(this.changeMap.get(program));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void linkPrograms(TaskMonitor monitor) throws CancelledException, MemoryAccessException, InvalidInputException, DuplicateNameException, IOException {
        monitor.setMaximum((long)this.programs.size());
        monitor.setProgress(1L);
        for (Program program : this.programs) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            monitor.setMessage(program.getName());
            DexHeader dexHeader = this.dexMap.get(program);
            ArrayList<Address> changeList = new ArrayList<Address>();
            this.changeMap.put(program, changeList);
            int transaction = program.startTransaction("multi-dex");
            try {
                ReferenceManager referenceManager = program.getReferenceManager();
                ExternalManager externalManager = program.getExternalManager();
                MemoryBlock methodLookupBlock = program.getMemory().getBlock("method_lookup");
                AddressSet methodLookupRange = new AddressSet(methodLookupBlock.getStart(), methodLookupBlock.getEnd());
                DataIterator dataIterator = program.getListing().getDefinedData((AddressSetView)methodLookupRange, true);
                while (dataIterator.hasNext()) {
                    String methodName;
                    String prototype;
                    Data data = dataIterator.next();
                    monitor.checkCancelled();
                    monitor.setMessage(program.getName() + " " + String.valueOf(data.getMinAddress()));
                    if (program.getMemory().getInt(data.getMinAddress()) != -1 || this.isExternalReferenceResolved(program, data, monitor)) continue;
                    int methodIndex = (int)data.getMinAddress().subtract(methodLookupBlock.getStart()) / 4;
                    MethodIDItem methodIDItem = dexHeader.getMethods().get(methodIndex);
                    String className = DexUtil.convertTypeIndexToString(dexHeader, methodIDItem.getClassIndex());
                    ProgramAddress pa = this.findInOtherProgram(program, className, prototype = DexUtil.convertPrototypeIndexToString(dexHeader, methodIDItem.getProtoIndex()), methodName = DexUtil.convertToString(dexHeader, methodIDItem.getNameIndex()), monitor);
                    if (pa == null) continue;
                    if (externalManager.getExternalLibraryPath(pa.program.getName()) == null) {
                        externalManager.setExternalPath(pa.program.getName(), pa.program.getDomainFile().getPathname(), true);
                    }
                    referenceManager.addExternalReference(data.getMinAddress(), pa.program.getName(), null, pa.address, SourceType.ANALYSIS, 0, RefType.EXTERNAL_REF);
                    changeList.add(data.getMinAddress());
                }
            }
            finally {
                program.endTransaction(transaction, true);
            }
        }
    }

    private ProgramAddress findInOtherProgram(Program program, String className, String prototype, String methodName, TaskMonitor monitor) throws CancelledException, IOException, MemoryAccessException {
        ClassMethodPrototype cmp = new ClassMethodPrototype(this, className, methodName, prototype);
        for (Program otherProgram : this.programs) {
            DexHeader otherDexHeader;
            Map<ClassMethodPrototype, Integer> map;
            Integer otherMethodIndex;
            monitor.checkCancelled();
            if (otherProgram.equals((Object)program) || (otherMethodIndex = (map = this.cmpMap.get(otherDexHeader = this.dexMap.get(otherProgram))).get(cmp)) == null) continue;
            Address otherAddress = DexUtil.toLookupAddress(program, otherMethodIndex);
            if (otherProgram.getMemory().getInt(otherAddress) == -1) continue;
            return new ProgramAddress(this, otherProgram, otherAddress);
        }
        return null;
    }

    private void cacheHeaderInfo(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.setMaximum((long)this.programs.size());
        monitor.setProgress(1L);
        for (Program program : this.programs) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            monitor.setMessage("Caching DEX header for " + program.getName() + "...");
            DexHeader dexHeader = DexHeaderFactory.getDexHeader(program);
            this.dexMap.put(program, dexHeader);
            HashMap<ClassMethodPrototype, Integer> map = new HashMap<ClassMethodPrototype, Integer>();
            this.cmpMap.put(dexHeader, map);
            int index = 0;
            for (MethodIDItem item : dexHeader.getMethods()) {
                monitor.checkCancelled();
                String className = DexUtil.convertTypeIndexToString(dexHeader, item.getClassIndex());
                String methodName = DexUtil.convertToString(dexHeader, item.getNameIndex());
                String prototype = DexUtil.convertPrototypeIndexToString(dexHeader, item.getProtoIndex());
                ClassMethodPrototype cmp = new ClassMethodPrototype(this, className, methodName, prototype);
                map.put(cmp, index);
                ++index;
            }
        }
    }

    private boolean isExternalReferenceResolved(Program program, Data data, TaskMonitor monitor) throws CancelledException {
        Reference[] referencesFrom;
        ExternalManager externalManager = program.getExternalManager();
        for (Reference reference : referencesFrom = data.getReferencesFrom()) {
            ExternalReference extref;
            ExternalLocation externalLocation;
            monitor.checkCancelled();
            if (!(reference instanceof ExternalReference) || externalManager.getExternalLibraryPath((externalLocation = (extref = (ExternalReference)reference).getExternalLocation()).getLibraryName()) == null) continue;
            return true;
        }
        return false;
    }

    private class ProgramAddress {
        private final Program program;
        private final Address address;

        ProgramAddress(MultiDexLinker multiDexLinker, Program program, Address address) {
            this.program = program;
            this.address = address;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProgramAddress) {
                ProgramAddress pa = (ProgramAddress)obj;
                return this.program.equals((Object)pa.program) && this.address.equals((Object)pa.address);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.program.hashCode() + this.address.hashCode();
        }
    }

    private class ClassMethodPrototype {
        private final String className;
        private final String methodName;
        private final String prototype;

        ClassMethodPrototype(MultiDexLinker multiDexLinker, String className, String methodName, String prototype) {
            this.className = className;
            this.methodName = methodName;
            this.prototype = prototype;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassMethodPrototype) {
                ClassMethodPrototype cmp = (ClassMethodPrototype)obj;
                return cmp.className.equals(this.className) && cmp.methodName.equals(this.methodName) && cmp.prototype.equals(this.prototype);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.className.hashCode() + this.methodName.hashCode() + this.prototype.hashCode();
        }
    }
}

