/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.feature.vt.api.db.VTMatchSetTableDBAdapterV0;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.AddressSet;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.LinkedList;

public abstract class VTMatchSetTableDBAdapter {
    static String TABLE_NAME = "MatchSetTable";
    static Schema TABLE_SCHEMA = new Schema(0, "Key", ColumnDescription.getColumnFields(), ColumnDescription.getColumnNames());

    static VTMatchSetTableDBAdapter createAdapter(DBHandle dbHandle) throws IOException {
        return new VTMatchSetTableDBAdapterV0(dbHandle);
    }

    static VTMatchSetTableDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        return new VTMatchSetTableDBAdapterV0(dbHandle, openMode);
    }

    public abstract DBRecord createMatchSetRecord(long var1, VTProgramCorrelator var3) throws IOException;

    public abstract RecordIterator getRecords() throws IOException;

    public abstract AddressSet getSourceAddressSet(DBRecord var1, AddressMap var2) throws IOException;

    public abstract AddressSet getDestinationAddressSet(DBRecord var1, AddressMap var2) throws IOException;

    public abstract long getNextMatchSetID();

    public abstract DBRecord getRecord(long var1) throws IOException;

    public static enum ColumnDescription {
        CORRELATOR_CLASS_COL((Field)StringField.INSTANCE),
        CORRELATOR_NAME_COL((Field)StringField.INSTANCE),
        OPTIONS_COL((Field)StringField.INSTANCE);

        private final Field columnField;

        private ColumnDescription(Field columnField) {
            this.columnField = columnField;
        }

        public Field getColumnField() {
            return this.columnField;
        }

        public int column() {
            return this.ordinal();
        }

        private static String[] getColumnNames() {
            ColumnDescription[] columns = ColumnDescription.values();
            LinkedList<String> list = new LinkedList<String>();
            for (ColumnDescription column : columns) {
                list.add(column.name());
            }
            return list.toArray(new String[columns.length]);
        }

        private static Field[] getColumnFields() {
            ColumnDescription[] columns = ColumnDescription.values();
            Field[] fields = new Field[columns.length];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = columns[i].getColumnField();
            }
            return fields;
        }
    }
}

