/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.elastic;

import java.util.Arrays;

public class Base64Lite {
    public static final char[] encode = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    public static final int[] decode = new int[128];

    public static void encodeLongBase64(StringBuilder buf, long val) {
        boolean seenNonZero = false;
        if (val == 0L) {
            buf.append(encode[0]);
            return;
        }
        for (int i = 60; i >= 0; i -= 6) {
            int chunk = (int)(val >> i) & 0x3F;
            if (chunk == 0 && seenNonZero) {
                buf.append(encode[chunk]);
                continue;
            }
            buf.append(encode[chunk]);
            seenNonZero = true;
        }
    }

    public static void encodeLongBase64Padded(StringBuilder buf, long val) {
        for (int i = 60; i >= 0; i -= 6) {
            int chunk = (int)(val >> i) & 0x3F;
            buf.append(encode[chunk]);
        }
    }

    public static String encodeLongBase64(long val) {
        char[] buffer = new char[11];
        if (val == 0L) {
            buffer[0] = encode[0];
            return new String(buffer, 0, 1);
        }
        int pos = 0;
        boolean seenNonZero = false;
        for (int i = 60; i >= 0; i -= 6) {
            int chunk = (int)(val >> i) & 0x3F;
            if (chunk == 0 && seenNonZero) {
                buffer[pos++] = encode[chunk];
                continue;
            }
            buffer[pos++] = encode[chunk];
            seenNonZero = true;
        }
        return new String(buffer, 0, pos);
    }

    public static long decodeLongBase64(String val) {
        long res = 0L;
        for (int i = 0; i < val.length(); ++i) {
            int chunk = decode[val.charAt(i)];
            if (chunk < 0) {
                throw new NumberFormatException("Bad base64 encoding");
            }
            res <<= 6;
            res |= (long)chunk;
        }
        return res;
    }

    static {
        Arrays.fill(decode, -1);
        for (int i = 0; i < encode.length; ++i) {
            Base64Lite.decode[Base64Lite.encode[i]] = i;
        }
    }
}

