import yarl

from ...const import APP_BASE_HOST, MAIN_VERSION
from ...core import HttpCore
from ...exception import TiebaServerError
from ...helper import parse_json
from ._classdef import FollowForums


def parse_body(body: bytes) -> FollowForums:
    res_json = parse_json(body)
    if code := int(res_json["error_code"]):
        raise TiebaServerError(code, res_json["error_msg"])

    follow_forums = FollowForums.from_tbdata(res_json)

    return follow_forums


async def request(http_core: HttpCore, user_id: int, pn: int, rn: int) -> FollowForums:
    data = [
        ("BDUSS", http_core.account.BDUSS),
        ("_client_version", MAIN_VERSION),
        ("friend_uid", user_id),
        ("page_no", pn),
        ("page_size", rn),
    ]

    request = http_core.pack_form_request(
        yarl.URL.build(scheme="http", host=APP_BASE_HOST, path="/c/f/forum/like"), data
    )

    body = await http_core.net_core.send_request(request, read_bufsize=16 * 1024)
    return parse_body(body)
