local _ = require "mason-core.functional"

describe("functional: number", function()
    it("should negate numbers", function()
        assert.equals(-42, _.negate(42))
        assert.equals(42, _.negate(-42))
    end)

    it("should check numbers greater than value", function()
        local greater_than_life = _.gt(42)
        assert.is_false(greater_than_life(0))
        assert.is_false(greater_than_life(42))
        assert.is_true(greater_than_life(43))
    end)

    it("should check numbers greater or equal than value", function()
        local greater_or_equal_to_life = _.gte(42)
        assert.is_false(greater_or_equal_to_life(0))
        assert.is_true(greater_or_equal_to_life(42))
        assert.is_true(greater_or_equal_to_life(43))
    end)

    it("should check numbers lower than value", function()
        local lesser_than_life = _.lt(42)
        assert.is_true(lesser_than_life(0))
        assert.is_false(lesser_than_life(42))
        assert.is_false(lesser_than_life(43))
    end)

    it("should check numbers lower or equal than value", function()
        local lesser_or_equal_to_life = _.lte(42)
        assert.is_true(lesser_or_equal_to_life(0))
        assert.is_true(lesser_or_equal_to_life(42))
        assert.is_false(lesser_or_equal_to_life(43))
    end)

    it("should increment numbers", function()
        local add_5 = _.inc(5)
        assert.equals(0, add_5(-5))
        assert.equals(5, add_5(0))
        assert.equals(7, add_5(2))
    end)

    it("should decrement numbers", function()
        local subtract_5 = _.dec(5)
        assert.equals(5, subtract_5(10))
        assert.equals(-5, subtract_5(0))
        assert.equals(-3, subtract_5(2))
    end)
end)
