/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.project;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObjectSettingsProvider;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.security.SMObjectType;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettingsUtils;

public abstract class BaseProjectSettings
implements DBPObjectSettingsProvider {
    private static final Log log = Log.getLog(BaseProjectSettings.class);
    private final DBPProject project;
    private Map<SMObjectType, Map<String, Map<String, String>>> projectSettings;

    protected BaseProjectSettings(@NotNull DBPProject project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, String> getObjectSettings(@NotNull SMObjectType objectType, @NotNull String objectId) {
        BaseProjectSettings baseProjectSettings = this;
        synchronized (baseProjectSettings) {
            if (this.projectSettings == null) {
                try {
                    this.projectSettings = this.loadAllProjectSettings();
                }
                catch (DBException e) {
                    log.error((Object)"Error loading project settings. Setting to empty.", (Throwable)e);
                    this.projectSettings = new LinkedHashMap<SMObjectType, Map<String, Map<String, String>>>();
                }
            }
        }
        Map<String, Map<String, String>> cache = this.projectSettings.get(objectType);
        return cache == null ? null : cache.get(objectId);
    }

    public void setObjectSettings(@NotNull SMObjectType objectType, @NotNull String objectId, @NotNull Map<String, String> settings) throws DBException {
        this.saveProjectSettings(objectType, objectId, settings);
        this.updateObjectSettingsCache(objectType, objectId, settings);
    }

    public void clearObjectSettings(@NotNull SMObjectType objectType, @NotNull String objectId, @NotNull Set<String> settings) throws DBException {
        LinkedHashMap<String, String> settingMap = new LinkedHashMap<String, String>(settings.size());
        for (String id : settings) {
            settingMap.put(id, null);
        }
        this.saveProjectSettings(objectType, objectId, settingMap);
        this.deleteObjectSettingsCache(objectType, objectId, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjectSettingsCache(@NotNull SMObjectType objectType, @NotNull String objectId, Map<String, String> settingsToSet) {
        if (this.projectSettings != null) {
            BaseProjectSettings baseProjectSettings = this;
            synchronized (baseProjectSettings) {
                Map settings = this.projectSettings.computeIfAbsent(objectType, ot -> new LinkedHashMap()).computeIfAbsent(objectId, k -> new LinkedHashMap());
                settings.putAll(settingsToSet);
            }
        }
        DataSourceNavigatorSettingsUtils.objectSettingUpdated(this.project, objectId, settingsToSet.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjectSettingsCache(@NotNull SMObjectType objectType, @NotNull String objectId, @Nullable Collection<String> settingIds) {
        if (this.projectSettings == null) {
            return;
        }
        BaseProjectSettings baseProjectSettings = this;
        synchronized (baseProjectSettings) {
            Map<String, Map<String, String>> cache = this.projectSettings.get(objectType);
            if (cache != null) {
                Map<Object, Object> settingRemoved;
                if (settingIds == null) {
                    settingRemoved = cache.remove(objectId);
                } else {
                    settingRemoved = new LinkedHashMap();
                    for (String settingId : settingIds) {
                        Map<String, String> settings = cache.get(objectId);
                        if (settings == null) continue;
                        settingRemoved.put(settingId, settings.remove(settingId));
                    }
                }
                DataSourceNavigatorSettingsUtils.objectSettingUpdated(this.project, objectId, settingRemoved.keySet());
            }
        }
    }

    @NotNull
    protected abstract Map<SMObjectType, Map<String, Map<String, String>>> loadAllProjectSettings() throws DBException;

    protected abstract void saveProjectSettings(@NotNull SMObjectType var1, @NotNull String var2, @NotNull Map<String, String> var3) throws DBException;
}

