/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreVersionValidator12;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreVersionValidator9and6;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreToolBaseVacuumSettings
extends SQLToolExecuteSettings<DBSObject> {
    private boolean isFull;
    private boolean isFreeze;
    private boolean isAnalyzed;
    private boolean isDisableSkipping;
    private boolean isSkipLocked;
    private boolean isIndexCleaning;
    private boolean isTruncated;

    @Property(viewable=true, editable=true, updatable=true)
    public boolean isFull() {
        return this.isFull;
    }

    public void setFull(boolean full) {
        this.isFull = full;
    }

    @Property(viewable=true, editable=true, updatable=true)
    public boolean isFreeze() {
        return this.isFreeze;
    }

    public void setFreeze(boolean freeze) {
        this.isFreeze = freeze;
    }

    @Property(viewable=true, editable=true, updatable=true)
    public boolean isAnalyzed() {
        return this.isAnalyzed;
    }

    public void setAnalyzed(boolean analyzed) {
        this.isAnalyzed = analyzed;
    }

    @Property(viewable=true, editable=true, updatable=true, visibleIf=PostgreVersionValidator9and6.class)
    public boolean isDisableSkipping() {
        return this.isDisableSkipping;
    }

    public void setDisableSkipping(boolean disableSkipping) {
        this.isDisableSkipping = disableSkipping;
    }

    @Property(viewable=true, editable=true, updatable=true, visibleIf=PostgreVersionValidator12.class)
    public boolean isSkipLocked() {
        return this.isSkipLocked;
    }

    public void setSkipLocked(boolean skipLocked) {
        this.isSkipLocked = skipLocked;
    }

    @Property(viewable=true, editable=true, updatable=true, visibleIf=PostgreVersionValidator12.class)
    public boolean isIndexCleaning() {
        return this.isIndexCleaning;
    }

    public void setIndexCleaning(boolean indexCleaning) {
        this.isIndexCleaning = indexCleaning;
    }

    @Property(viewable=true, editable=true, updatable=true, visibleIf=PostgreVersionValidator12.class)
    public boolean isTruncated() {
        return this.isTruncated;
    }

    public void setTruncated(boolean truncated) {
        this.isTruncated = truncated;
    }

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> config, @NotNull DBPProject project) {
        super.loadConfiguration(runnableContext, config, project);
        this.isFull = JSONUtils.getBoolean(config, (String)"full");
        this.isFreeze = JSONUtils.getBoolean(config, (String)"freeze");
        this.isAnalyzed = JSONUtils.getBoolean(config, (String)"analyze");
        this.isDisableSkipping = JSONUtils.getBoolean(config, (String)"disable_page_skipping");
        this.isSkipLocked = JSONUtils.getBoolean(config, (String)"skip_locked");
        this.isIndexCleaning = JSONUtils.getBoolean(config, (String)"index_cleanup");
        this.isTruncated = JSONUtils.getBoolean(config, (String)"truncate");
    }

    public void saveConfiguration(Map<String, Object> config) {
        super.saveConfiguration(config);
        config.put("full", this.isFull);
        config.put("freeze", this.isFreeze);
        config.put("analyze", this.isAnalyzed);
        config.put("disable_page_skipping", this.isDisableSkipping);
        config.put("skip_locked", this.isSkipLocked);
        config.put("index_cleanup", this.isIndexCleaning);
        config.put("truncate", this.isTruncated);
    }
}

