# Rathena脚本语言教程-变量

------

## 定义

变量是计算机语言中能储存计算结果或能表示值的抽象概念。在rathena脚本语言中，变量名不区分大小写，可通过变量名来访问变量中保存的数值或字符串。


## 需要特别注意的是

- 变量前缀影响变量的作用域和生命周期。
- 变量名只能由数字、字母和下划线构成。
- 变量后缀决定变量为整数型或字符串。


## 按照作用范围分类

- 全局变量
- 账号变量
- 角色变量
- NPC 变量
- 范围变量

## 按照保存介质分类

- 服务器重启或宕机后依然存在的变量
- 服务器重启或宕机后变量重置的变量


## 变量的前缀

- 前缀 `@` 表示变量为【角色临时变量】，重启服务器失效，不保存在数据库中。
- 前缀 `.@` 表示变量为【范围临时变量】，相当于其他语言的函数内局部变量，离开方法的作用域范围失效。
- 不带任何前缀的变量为【角色变量】，重启服务器不会失效，是默认的变量类型。其中：
    - 以 `$` 结尾的变量为 str 类型，保存在数据表 `ragnarok/char_reg_str`
    - 不以 `$` 结尾的变量为 int 类型，保存在数据表 `ragnarok/char_reg_num`
- 前缀 `#` 表示变量为【账号变量】，玩家同一账号下所有角色都可以使用，重启服务器不会失效。其中：
    - 以 `$` 结尾的变量为 str 类型，保存在数据表 `ragnarok/acc_reg_str`
    - 不以 `$` 结尾的变量为 int 类型，保存在数据表 `ragnarok/acc_reg_num`
- 前缀 `##` 表示变量为【账号全局变量】，服务器重启后不会失效，用于在服务器集群间共享数据。其中：
    - 以 `$` 结尾的变量为 str 类型，保存在数据表 `ragnarok/global_acc_reg_str`
    - 不以 `$` 结尾的变量为 int 类型，保存在数据表 `ragnarok/global_acc_reg_num`
- 前缀 `$` 表示变量为【服务器变量】，重启服务器不会失效，保存在数据表 `ragnarok/mapreg`。
- 前缀 `.` 表示变量为【NPC 变量】，当服务器重启或重置 NPC 时失效。可以从当前 NPC 脚本中直接访问该 NPC 变量，相当于其他语言的全局变量。亦可通过 `getvariableofnpc` 访问其他 NPC 脚本下的 NPC 变量。（注意若在函数中使用此类型变量，则其不能通过 `getvariableofnpc` 获取）
- 前缀 `'` 表示变量为【副本变量】，在每一个副本中副本变量都是独立存在的，互不影响。


## 变量后缀

- 没有后缀为整数型变量，可以存正负整数，不可以存小数和分数。
- 后缀 `$` 为字符串变量，用来保存字符串。


## 变量例子

```
name     永久角色整数变量
name$    永久角色字符串变量
@name    临时角色整数变量
@name$   临时角色字符串变量
$name    永久全局整数变量
$name$   永久全局字符串变量
$@name   临时全局整数变量
$@name$  临时全局字符串变量
.name    NPC 整数变量
.name$   NPC 字符串变量
'name    副本整数变量
'name$   副本字符串变量
#name    账号整数变量
#name$   账号字符串变量
##name   全局账号整数变量
##name$  全局账号字符串变量
```

    
> 如果变量未被赋值，整数变量为 `0`，字符串变量为空字符串 `""`。一旦将变量设置为 `0` 或 `""`，变量则被释放（重置），即使它是永久变量，也将会被释放（重置），在数据表中移除。



## 特殊变量

这些变量是已经在脚本引擎中定义好的，可以在 `src/map/script_constants.h` 中查看。这些变量的值永远给予角色的基本数据。

```
Zeny           金币数量 
Hp             HP 值 
MaxHp          HP 上限 
Sp             SP 值 
MaxSp          SP 上限 
StatusPoint    剩余素质点数 
SkillPoint     剩余技能点数 
BaseLevel      基础等级 
JobLevel       职业等级 
BaseExp        基础等级经验值 
JobExp         职业等级经验值 
NextBaseExp    距离下一基础等级经验值 
NextJobExp     距离下一职业等级经验值 
Weight         角色负重量 
MaxWeight      最大负重量 
Sex            性别
Class          职业编号 
Upper          是否转生（转生值为1） 
BaseClass      基础职业种类 
BaseJob        基础职业编号 
Karma          不健全功能，具体不明 
Manner         发言敏感度，为负数则禁止玩家说话。
```
