#
# Table structure for table `item_db_re`
#

DROP TABLE IF EXISTS `item_db_re`;
CREATE TABLE `item_db_re` (
  `id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name_english` varchar(50) NOT NULL DEFAULT '',
  `name_japanese` varchar(50) NOT NULL DEFAULT '',
  `type` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `price_buy` mediumint(8) unsigned DEFAULT NULL,
  `price_sell` mediumint(8) unsigned DEFAULT NULL,
  `weight` smallint(5) unsigned NOT NULL DEFAULT '0',
  `atk:matk` varchar(11) DEFAULT NULL,
  `defence` smallint(5) unsigned DEFAULT NULL,
  `range` tinyint(2) unsigned DEFAULT NULL,
  `slots` tinyint(2) unsigned DEFAULT NULL,
  `equip_jobs` bigint(20) unsigned DEFAULT NULL,
  `equip_upper` tinyint(2) unsigned DEFAULT NULL,
  `equip_genders` tinyint(1) unsigned DEFAULT NULL,
  `equip_locations` mediumint(7) unsigned DEFAULT NULL,
  `weapon_level` tinyint(1) unsigned DEFAULT NULL,
  `equip_level` varchar(10) DEFAULT NULL,
  `refineable` tinyint(1) unsigned DEFAULT NULL,
  `view` smallint(5) unsigned DEFAULT NULL,
  `script` text,
  `equip_script` text,
  `unequip_script` text,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `UniqueAegisName` (`name_english`)
) ENGINE=MyISAM;

# Items Database
#
# Structure of Database:
#REPLACE INTO `item_db_re` VALUES ( ID,'AegisName','Name',Type,Buy,Sell,Weight,'ATK[:MATK]',DEF,Range,Slots,Job,Class,Gender,Loc,wLV,'eLV[:maxLevel]',Refineable,View,'Script','OnEquip_Script','OnUnequip_Script');
#
# Healing Items
#=============================================================
REPLACE INTO `item_db_re` VALUES (501,'Red_Potion','Red Potion',0,10,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(45,65),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (502,'Orange_Potion','Orange Potion',0,50,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (503,'Yellow_Potion','Yellow Potion',0,180,NULL,130,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(175,235),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (504,'White_Potion','White Potion',0,1200,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (505,'Blue_Potion','Blue Potion',0,5000,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(40,60);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (506,'Green_Potion','Green Potion',0,40,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_HALLUCINATION;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (507,'Red_Herb','Red Herb',0,18,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(18,28),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (508,'Yellow_Herb','Yellow Herb',0,40,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(38,58),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (509,'White_Herb','White Herb',0,120,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(75,115),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (510,'Blue_Herb','Blue Herb',0,60,NULL,70,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(15,30);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (511,'Green_Herb','Green Herb',0,10,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_end SC_POISON;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (512,'Apple','Apple',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(16,22),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (513,'Banana','Banana',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(17,21),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (514,'Grape','Grape',0,200,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(10,15);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (515,'Carrot','Carrot',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(18,20),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (516,'Sweet_Potato','Potato',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(15,23),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (517,'Meat','Meat',0,50,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,100),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (518,'Honey','Honey',0,500,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,100),rand(20,40);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (519,'Milk','Milk',0,25,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(27,37),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (520,'Leaflet_Of_Hinal','Hinalle Leaflet',0,150,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(175,235),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (521,'Leaflet_Of_Aloe','Aloe Leaflet',0,360,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (522,'Fruit_Of_Mastela','Mastela Fruit',0,8500,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(400,600),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (523,'Holy_Water','Holy Water',0,20,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_end SC_CURSE;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (525,'Panacea','Panacea',0,500,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_CURSE; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (526,'Royal_Jelly','Royal Jelly',0,7000,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_CURSE; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (528,'Monster\'s_Feed','Monster\'s Feed',0,60,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(72,108),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (529,'Candy','Candy',0,10,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(45,65),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (530,'Candy_Striper','Candy Cane',0,20,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (531,'Apple_Juice','Apple Juice',0,20,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(25,35),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (532,'Banana_Juice','Banana Juice',0,20,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(26,34),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (533,'Grape_Juice','Grape Juice',0,250,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(15,25);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (534,'Carrot_Juice','Carrot Juice',0,20,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(27,33),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (535,'Pumpkin','Pumpkin',0,15,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 19,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (536,'Ice_Cream','Ice Cream',0,150,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0; sc_start SC_FREEZE,10000,0,2500,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (537,'Pet_Food','Pet Food',0,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,90),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (538,'Well_Baked_Cookie','Well-baked Cookie',0,1000,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(160,200),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (539,'Piece_Of_Cake','Piece of Cake',0,3000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(270,330),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (540,'Falcon\'s_Feed','Falcon Food',0,2000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(185,225),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (541,'Pecopeco\'s_Feed','PecoPeco Food',0,3000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (542,'Festive_Cookie','Festival Cookie',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (543,'Festive_Rainbow_Cake','Festival Rainbow Cake',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (544,'Fish_Slice','Raw Fish',0,20,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(25,60),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (545,'Red_Slim_Potion','Condensed Red Potion',0,150,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(45,65),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (546,'Yellow_Slim_Potion','Condensed Yellow Potion',0,600,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(175,235),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (547,'White_Slim_Potion','Condensed White Potion',0,1650,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (548,'Cheese','Cheese',0,2800,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(10,15);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (549,'Nice_Sweet_Potato','Yam',0,180,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,100),0; sc_start SC_STUN,3000,0,1500,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (550,'Popped_Rice','Rice Cake',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(10,15),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (551,'Shusi','Sushi',0,1,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,60),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (552,'KETUPAT','Ketupat',0,1,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,90),rand(20,30);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (553,'Bun','Bao',0,1,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(35,70),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (554,'Mojji','Mochi',0,100,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0; sc_start SC_STUN,3000,0; sc_start SC_BLIND,2000,0,1500,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (555,'Rice_Cake','Traditional Rice Cake',0,100,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (556,'Long_Rice_Cake','Rice Cake Stick',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(20,25),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (557,'Hash_Rice_Cake','Neatly Sliced Rice Cake',0,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(25,30),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (558,'Chocolate','Chocolate',0,1,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 1,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (559,'HandMade_Chocolate','Hand-made Chocolate',0,1,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 50,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (560,'HandMade_Chocolate_','Handmade White Chocolate',0,5000,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 50,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (561,'White_Chocolate','White Chocolate',0,5000,NULL,80,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 50,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (562,'Pizza','Doublecrust Swiss Fondue',0,100,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(70,100),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (563,'Pizza_01','Doublecrust Swiss Fondue',0,1200,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(375,445),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (564,'Rice_Ball','Rice Ball',0,1,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 200,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (565,'Vita500_Bottle','Vita500',0,580,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(142,274),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (566,'Tomyumkung','Tom Yum Goong',0,10000,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(244,350),rand(10,30); sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_CURSE; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (567,'Prawn','Shrimp',0,500,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(117,192),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (568,'Lemon','Lemon',0,60,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(10,20);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (569,'Novice_Potion','Novice Potion',0,0,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(44,66),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (570,'Lucky_Candy','Lucky Candy',0,10,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(45,65),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (571,'Lucky_Candy_Cane','Lucky Candy Cane',0,20,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (572,'Lucky_Cookie','Lucky Cookie',0,1000,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(160,200),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (573,'Chocolate_Drink','Chocolate Drink',0,7000,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(330,410),rand(45,65); sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_CURSE; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (574,'Egg','Egg',0,20,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(33,42),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (575,'Piece_Of_Cake_','2nd Anniversary Cake',0,10,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(270,330),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (576,'Prickly_Fruit','Prickly Fruit',0,540,NULL,60,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(150,300),rand(20,30);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (577,'Grain','Bag of Grain',0,200,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(60,70),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (578,'Strawberry','Strawberry',0,200,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(16,28);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (579,'Delicious_Fish','Fresh Fish',0,700,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(100,150),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (580,'Bread','Bread',0,150,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,90),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (581,'Mushroom','Edible Mushroom',0,40,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(20,30),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (582,'Orange','Orange',0,300,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(10,20),rand(10,20);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (583,'KETUPAT_','Ketupat Sayur',0,7000,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_CURSE; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (584,'Fish_Ball_Soup','Fish Cake Soup',0,100,NULL,60,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(40,70),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (585,'Wurst','Brusti',11,2,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(15,20),0; itemskill "PR_MAGNIFICAT",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (586,'Mother\'s_Cake','Mother\'s Cake',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (587,'Prickly_Fruit_','Red Prickly Fruit',0,880,NULL,60,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(270,330),rand(20,30);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (588,'Spaghetti','Spaghetti',0,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(40,70),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (589,'Pizza_02','Pizza',0,1200,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(375,445),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (590,'Brezel_','Pretzel',0,2,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(50,90),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (591,'Caviar_Pancake','Caviar Pancake',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_CURSE; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (592,'Jam_Pancake','Jam Pancake',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_CURSE; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (593,'Honey_Pancake','Honey Pancake',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_CURSE; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (594,'Sour_Cream_Pancake','Sour-Cream Pancake',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_CURSE; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (595,'Mushroom_Pancake','Mushroom Pancake',0,0,NULL,150,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(325,405),rand(40,60); sc_end SC_POISON; sc_end SC_SILENCE; sc_end SC_BLIND; sc_end SC_CONFUSION; sc_end SC_CURSE; sc_end SC_Hallucination;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (596,'Cute_Strawberry_Choco','Cute Strawberry-Choco',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal 0,rand(1,100);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (597,'Lovely_Choco_Tart','Lovely Choco-Tart',0,20,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(10,400),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (598,'Light_Red_Pot','Light Red Potion',0,50,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(45,65),0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (599,'Light_Orange_Pot','Light Orange Potion',0,200,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemheal rand(105,145),0;',NULL,NULL);
#===================================================================
# Usable Items
#===================================================================
REPLACE INTO `item_db_re` VALUES (601,'Wing_Of_Fly','Fly Wing',11,60,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "AL_TELEPORT",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (602,'Wing_Of_Butterfly','Butterfly Wing',11,300,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "AL_TELEPORT",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (603,'Old_Blue_Box','Old Blue Box',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_BlueBox,1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (604,'Branch_Of_Dead_Tree','Dead Branch',2,50,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'monster "this",-1,-1,"--ja--",-1-MOBG_Branch_Of_Dead_Tree,1,"";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (605,'Anodyne','Anodyne',11,2000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "SM_ENDURE",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (606,'Aloebera','Aloevera',11,1500,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "SM_SELFPROVOKE",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (607,'Yggdrasilberry','Yggdrasil Berry',0,5000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'percentheal 100,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (608,'Seed_Of_Yggdrasil','Yggdrasil Seed',0,5000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'percentheal 50,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (609,'Amulet','Amulet',2,100,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (610,'Leaf_Of_Yggdrasil','Yggdrasil Leaf',11,4000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "ALL_RESURRECTION",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (611,'Spectacles','Magnifier',11,40,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MC_IDENTIFY",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (612,'Portable_Furnace','Mini Furnace',2,150,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'produce 21;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (613,'Iron_Hammer','Iron Hammer',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'produce 1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (614,'Golden_Hammer','Golden Hammer',2,3000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'produce 2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (615,'Oridecon_Hammer','Oridecon Hammer',2,5000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'produce 3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (616,'Old_Card_Album','Old Card Album',2,10000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_CardAlbum,1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (617,'Old_Violet_Box','Old Purple Box',2,10000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_VioletBox,1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (618,'Worn_Out_Scroll','Worn Out Scroll',2,50,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (619,'Unripe_Apple','Unripe Apple',2,1000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1002;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (620,'Orange_Juice','Orange Juice',2,1500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1113;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (621,'Bitter_Herb','Bitter Herb',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1031;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (622,'Rainbow_Carrot','Rainbow Carrot',2,2500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1063;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (623,'Earthworm_The_Dude','Earthworm the Dude',2,4000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1049;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (624,'Rotten_Fish','Rotten Fish',2,2500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1011;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (625,'Lusty_Iron','Rusty Iron',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1042;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (626,'Monster_Juice','Monster Juice',2,1500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1035;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (627,'Sweet_Milk','Sweet Milk',2,7000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1167;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (628,'Well_Dried_Bone','Well-Dried Bone',2,10000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1107;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (629,'Singing_Flower','Singing Flower',2,300,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1052;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (630,'Dew_Laden_Moss','Dew Laden Moss',2,10,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1014;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (631,'Deadly_Noxious_Herb','Deadly Noxious Herb',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1077;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (632,'Fatty_Chubby_Earthworm','Fatty Chubby Earthworm',2,5000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1019;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (633,'Baked_Yam','Sweet Potato',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1056;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (634,'Tropical_Banana','Tropical Banana',2,20,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1057;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (635,'Horror_Of_Tribe','Orc Trophy',2,300,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1023;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (636,'No_Recipient','No Recipient',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1026;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (637,'Old_Broom','Old Broom',2,350,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1110;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (638,'Silver_Knife_Of_Chaste','Silver Knife of Chastity',2,12000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1170;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (639,'Armlet_Of_Obedience','Armlet of Obedience',2,18000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1029;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (640,'Shining_Stone','Shining Stone',2,3000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1155;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (641,'Contracts_In_Shadow','Contract in Shadow',2,100,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1109;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (642,'Book_Of_Devil','Book of the Devil',2,1800,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1101;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (643,'Pet_Incubator','Pet Incubator',2,10000,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'bpet;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (644,'Gift_Box','Gift Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBox,1);',NULL,NULL);
#ASPD in RE they give a fixed +4/+6/+9 ASPD
REPLACE INTO `item_db_re` VALUES (645,'Center_Potion','Concentration Potion',2,1200,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ASPDPOTION0,1800000,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (656,'Awakening_Potion','Awakening Potion',2,2200,NULL,150,NULL,NULL,NULL,NULL,0xFFF7FEEF,63,2,NULL,NULL,'40',NULL,NULL,'sc_start SC_ASPDPOTION1,1800000,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (657,'Berserk_Potion','Berserk Potion',2,4500,NULL,200,NULL,NULL,NULL,NULL,0x41E646A6,63,2,NULL,NULL,'85',NULL,NULL,'sc_start SC_ASPDPOTION2,1800000,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (658,'Union_Of_Tribe','Union of Tribe',2,2,NULL,500,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'guildgetexp rand(600000,1200000);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (659,'Heart_Of_Her','Her Heart',2,500,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1188;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (660,'Prohibition_Red_Candle','Forbidden Red Candle',2,20000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (661,'Sway_Apron','Soft Apron',2,20000,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'pet 1275;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (662,'Inspector_Certificate','Authoritative Badge',2,1450,NULL,30,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_SPEEDUP0,180000,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (663,'Korea_Rice_Cake','Korean Rice Cake',0,1,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'percentheal 10,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (664,'Gift_Box_1','Gift Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBox_1,1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (665,'Gift_Box_2','Gift Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBox_2,1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (666,'Gift_Box_3','Gift Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBox_3,1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (667,'Gift_Box_4','Gift Box',2,1000,NULL,200,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'getrandgroupitem(IG_GiftBox_4,1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (668,'Handsei','Red Envelope',2,0,NULL,20,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'Zeny += rand(1000,10000);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (669,'Rice_Cake_Soup','Tempting Rice-Cake Soup',0,500,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'percentheal 10,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (670,'Gold_Coin_Moneybag','Bag of Gold Coins',3,100000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (671,'Gold_Coin','Gold Coin',2,10000,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'RouletteGold++;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (672,'Copper_Coin_Moneybag','Bag of Bronze Coins',3,1000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (673,'Copper_Coin','Bronze Coin',2,100,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'RouletteBronze++;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (674,'Mithril_Coin','Mithril Coin',3,5000,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (675,'Silver_Coin','Silver Coin',2,5000,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'RouletteSilver++;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (676,'Silver_Coin_Moneybag','Bag of Silver Coins',3,50000,NULL,400,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (677,'White_Gold_Coin','Platinum Coin',3,2000,NULL,40,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (678,'Poison_Bottle','Poison Bottle',2,5000,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'if(Class == Job_Assassin_Cross || Class == Job_Guillotine_Cross || Class == Job_Guillotine_Cross_T) { sc_start SC_DPOISON,60000,0; sc_start SC_ASPDPOTION3,60000,9; } else percentheal -100,-100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (679,'Gold_Pill','Pilule',2,5000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_DPOISON,10000,0,1000,0; sc_start SC_POISON,50000,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (680,'Magical_Carnation','Magic Carnation',0,0,NULL,1000,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'percentheal 0,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (681,'Memory_Of_Wedding','Sweet Memory of Marriage',2,50000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'if (getpartnerid()) sc_start SC_WEDDING,600000,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (682,'Realgar_Wine','Distilled Fighting Spirit',2,0,NULL,100,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ATKPOTION,60000,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (683,'Exorcize_Herb','Herb of Incantation',2,0,NULL,50,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_MATKPOTION,60000,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (684,'Durian','Durian',2,15000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'sc_start SC_ATKPOTION,60000,10; sc_start SC_MATKPOTION,60000,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (685,'RAMADAN','Ramadan',0,5000,NULL,300,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'percentheal 100,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (686,'Earth_Scroll_1_3','Level 3 Earth Spike',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "WZ_EARTHSPIKE",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (687,'Earth_Scroll_1_5','Level 5 Earth Spike',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "WZ_EARTHSPIKE",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (688,'Cold_Scroll_1_3','Level 3 Cold Bolt',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_COLDBOLT",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (689,'Cold_Scroll_1_5','Level 5 Cold Bolt',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_COLDBOLT",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (690,'Fire_Scroll_1_3','Level 3 Fire Bolt',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREBOLT",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (691,'Fire_Scroll_1_5','Level 5 Fire Bolt',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREBOLT",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (692,'Wind_Scroll_1_3','Level 3 Lightening Bolt',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_LIGHTNINGBOLT",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (693,'Wind_Scroll_1_5','Level 5 Lightening Bolt',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_LIGHTNINGBOLT",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (694,'Ghost_Scroll_1_3','Level 3 Soul Strike',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_SOULSTRIKE",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (695,'Ghost_Scroll_1_5','Level 5 Soul Strike',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_SOULSTRIKE",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (696,'Fire_Scroll_2_1','Level 1 Fire Ball',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREBALL",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (697,'Fire_Scroll_2_5','Level 5 Fire Ball',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREBALL",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (698,'Fire_Scroll_3_1','Level 1 Fire Wall',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREWALL",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (699,'Fire_Scroll_3_5','Level 5 Fire Wall',11,2000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FIREWALL",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (700,'Cold_Scroll_2_1','Level 1 Frost Diver',11,1000,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,'itemskill "MG_FROSTDIVER",1;',NULL,NULL);
#===================================================================
# Etc Items
#===================================================================
REPLACE INTO `item_db_re` VALUES (701,'Ora_Ora','Ora Ora',3,55000,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (702,'Animal_Blood','Animal Gore',3,450,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (703,'Hinalle','Hinalle',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (704,'Aloe','Aloe',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (705,'Clover','Clover',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (706,'Four_Leaf_Clover','Four Leaf Clover',3,80000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (707,'Singing_Plant','Singing Plant',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (708,'Ment','Ment',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (709,'Izidor','Izidor',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (710,'Illusion_Flower','Illusion Flower',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (711,'Shoot','Shoot',3,16,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (712,'Flower','Flower',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (713,'Empty_Bottle','Empty Bottle',3,6,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (714,'Emperium','Emperium',3,2,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (715,'Yellow_Gemstone','Yellow Gemstone',3,600,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (716,'Red_Gemstone','Red Gemstone',3,600,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (717,'Blue_Gemstone','Blue Gemstone',3,600,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (718,'Dark_Red_Jewel','Garnet',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (719,'Violet_Jewel','Amethyst',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (720,'Skyblue_Jewel','Aquamarine',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (721,'Azure_Jewel','Emerald',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (722,'Scarlet_Jewel','Pearl',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (723,'Cardinal_Jewel','Ruby',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (724,'Cardinal_Jewel_','Cursed Ruby',3,600,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (725,'Red_Jewel','Sardonyx',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (726,'Blue_Jewel','Sapphire',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (727,'White_Jewel','Opal',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (728,'Golden_Jewel','Topaz',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (729,'Bluish_Green_Jewel','Zircon',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (730,'Crystal_Jewel','1carat Diamond',3,10000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (731,'Crystal_Jewel_','2carat Diamond',3,25000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (732,'Crystal_Jewel__','3carat Diamond',3,55000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (733,'Crystal_Jewel___','Cracked Diamond',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (734,'Red_Frame','Red Frame',3,3000,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (735,'Blue_Porcelain','Chung Jah',3,5000,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (736,'White_Platter','China',3,1000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (737,'Black_Ladle','Black Ladle',3,400,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (738,'Pencil_Case','Pencil Case',3,400,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (739,'Rouge','Rouge',3,10000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (740,'Stuffed_Doll','Puppet',3,1000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (741,'Poring_Doll','Poring Doll',3,1800,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (742,'Chonchon_Doll','Chonchon Doll',3,3000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (743,'Spore_Doll','Spore Doll',3,5500,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (744,'Bunch_Of_Flowers','Bouquet',3,2000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (745,'Wedding_Bouquet','Wedding Bouquet',3,12000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (746,'Glass_Bead','Glass Bead',3,1400,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (747,'Crystal_Mirror','Crystal Mirror',3,15000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (748,'Witherless_Rose','Witherless Rose',3,55000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (749,'Frozen_Rose','Frozen Rose',3,35000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (750,'Baphomet_Doll','Baphomet Doll',3,18000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (751,'Osiris_Doll','Osiris Doll',3,14000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (752,'Grasshopper_Doll','Rocker Doll',3,4000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (753,'Monkey_Doll','Yoyo Doll',3,6000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (754,'Raccoondog_Doll','Raccoon Doll',3,5000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (756,'Oridecon_Stone','Rough Oridecon',3,550,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (757,'Elunium_Stone','Rough Elunium',3,650,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (901,'Danggie','Daenggie',3,260,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (902,'Tree_Root','Tree Root',3,12,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (903,'Reptile_Tongue','Reptile Tongue',3,140,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (904,'Scorpion\'s_Tail','Scorpion Tail',3,124,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (905,'Stem','Stem',3,46,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (906,'Pointed_Scale','Pointed Scale',3,68,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (907,'Resin','Resin',3,120,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (908,'Spawn','Spawn',3,140,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (909,'Jellopy','Jellopy',3,6,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (910,'Garlet','Garlet',3,40,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (911,'Scell','Scell',3,160,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (912,'Zargon','Zargon',3,480,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (913,'Tooth_Of_Bat','Tooth of Bat',3,34,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (914,'Fluff','Fluff',3,8,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (915,'Chrysalis','Chrysalis',3,8,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (916,'Feather_Of_Birds','Feather of Birds',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (917,'Talon','Talon',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (918,'Sticky_Webfoot','Sticky Webfoot',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (919,'Animal\'s_Skin','Animal Skin',3,36,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (920,'Claw_Of_Wolves','Wolf Claw',3,58,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (921,'Mushroom_Spore','Mushroom Spore',3,36,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (922,'Orcish_Cuspid','Orc\'s Fang',3,220,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (923,'Evil_Horn','Evil Horn',3,1200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (924,'Powder_Of_Butterfly','Powder of Butterfly',3,90,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (925,'Bill_Of_Birds','Bill of Birds',3,64,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (926,'Scale_Of_Snakes','Snake Scale',3,82,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (928,'Insect_Feeler','Insect Feeler',3,114,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (929,'Immortal_Heart','Immortal Heart',3,374,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (930,'Rotten_Bandage','Rotten Bandage',3,350,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (931,'Orcish_Voucher','Orcish Voucher',3,142,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (932,'Skel_Bone','Skel-Bone',3,232,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (934,'Mementos','Memento',3,600,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (935,'Shell','Shell',3,14,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (936,'Scales_Shell','Scale Shell',3,466,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (937,'Posionous_Canine','Venom Canine',3,148,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (938,'Sticky_Mucus','Sticky Mucus',3,70,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (939,'Bee_Sting','Bee Sting',3,32,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (940,'Grasshopper\'s_Leg','Grasshopper\'s Leg',3,36,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (941,'Nose_Ring','Nose Ring',3,568,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (942,'Yoyo_Tail','Yoyo Tail',3,114,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (943,'Solid_Shell','Solid Shell',3,448,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (944,'Horseshoe','Horseshoe',3,588,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (945,'Raccoon_Leaf','Raccoon Leaf',3,106,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (946,'Snail\'s_Shell','Snail\'s Shell',3,64,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (947,'Horn','Horn',3,116,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (948,'Bear\'s_Foot','Bear\'s Footskin',3,174,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (949,'Feather','Feather',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (950,'Heart_Of_Mermaid','Heart of Mermaid',3,264,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (951,'Fin','Fin',3,412,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (952,'Cactus_Needle','Cactus Needle',3,82,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (953,'Stone_Heart','Stone Heart',3,184,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (954,'Shining_Scales','Shining Scale',3,466,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (955,'Worm_Peelings','Worm Peeling',3,52,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (956,'Gill','Gill',3,342,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (957,'Decayed_Nail','Decayed Nail',3,82,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (958,'Horrendous_Mouth','Horrendous Mouth',3,390,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (959,'Rotten_Scale','Stinky Scale',3,168,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (960,'Nipper','Nipper',3,114,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (961,'Conch','Conch',3,158,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (962,'Tentacle','Tentacle',3,70,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (963,'Sharp_Scale','Sharp Scale',3,250,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (964,'Crap_Shell','Crab Shell',3,90,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (965,'Clam_Shell','Clam Shell',3,56,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (966,'Flesh_Of_Clam','Clam Flesh',3,158,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (967,'Turtle_Shell','Turtle Shell',3,680,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (968,'Voucher_Of_Orcish_Hero','Heroic Emblem',3,3000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (969,'Gold','Gold',3,150000,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (970,'Alchol','Alcohol',3,400,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (971,'Detrimindexta','Detrimindexta',3,400,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (972,'Karvodailnirol','Karvodailnirol',3,400,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (973,'Counteragent','Counteragent',3,800,NULL,70,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (974,'Mixture','Mixture',3,800,NULL,70,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (975,'Scarlet_Dyestuffs','Scarlet Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (976,'Lemon_Dyestuffs','Lemon Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (978,'Cobaltblue_Dyestuffs','Cobaltblue Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (979,'Darkgreen_Dyestuffs','Darkgreen Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (980,'Orange_Dyestuffs','Orange Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (981,'Violet_Dyestuffs','Violet Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (982,'White_Dyestuffs','White Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (983,'Black_Dyestuffs','Black Dyestuffs',3,8000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (984,'Oridecon','Oridecon',3,1100,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (985,'Elunium','Elunium',3,1100,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (986,'Anvil','Anvil',3,30000,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (987,'Oridecon_Anvil','Oridecon Anvil',3,120000,NULL,700,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (988,'Golden_Anvil','Golden Anvil',3,300000,NULL,900,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (989,'Emperium_Anvil','Emperium Anvil',3,600000,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (990,'Boody_Red','Red Blood',3,1000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (991,'Crystal_Blue','Crystal Blue',3,1000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (992,'Wind_Of_Verdure','Wind of Verdure',3,1000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (993,'Yellow_Live','Green Live',3,1000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (994,'Flame_Heart','Flame Heart',3,3000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (995,'Mistic_Frozen','Mystic Frozen',3,3000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (996,'Rough_Wind','Rough Wind',3,3000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (997,'Great_Nature','Great Nature',3,3000,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (998,'Iron','Iron',3,100,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (999,'Steel','Steel',3,1000,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1000,'Star_Crumb','Star Crumb',3,4500,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1001,'Sparkling_Dust','Star Dust',3,1500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1002,'Iron_Ore','Iron Ore',3,50,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1003,'Coal','Coal',3,500,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1004,'Patriotism_Marks','Chivalry Emblem',3,2,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1005,'Hammer_Of_Blacksmith','Hammer of Blacksmith',3,2,NULL,800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1006,'Old_Magic_Book','Old Magicbook',3,2,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1007,'Penetration','Necklace of Wisdom',3,2,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1008,'Frozen_Heart','Necklace of Oblivion',3,2,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1009,'Sacred_Marks','Hand of God',3,2,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1010,'Phracon','Phracon',3,200,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1011,'Emveretarcon','Emveretarcon',3,1000,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1012,'Lizard_Scruff','Frill',3,250,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1013,'Colorful_Shell','Rainbow Shell',3,90,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1014,'Jaws_Of_Ant','Ant Jaw',3,232,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1015,'Thin_N\'_Long_Tongue','Tongue',3,528,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1016,'Rat_Tail','Rat Tail',3,52,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1017,'Moustache_Of_Mole','Mole Whiskers',3,106,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1018,'Nail_Of_Mole','Mole Claw',3,210,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1019,'Wooden_Block','Trunk',3,60,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1020,'Long_Hair','Black Hair',3,292,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1021,'Dokkaebi_Horn','Dokebi Horn',3,292,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1022,'Fox_Tail','Nine Tails',3,650,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1023,'Fish_Tail','Fish Tail',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1024,'Chinese_Ink','Squid Ink',3,264,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1025,'Spiderweb','Cobweb',3,184,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1026,'Acorn','Acorn',3,98,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1027,'Porcupine_Spike','Porcupine Quill',3,158,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1028,'Wild_Boar\'s_Mane','Mane',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1029,'Tiger\'s_Skin','Tiger Skin',3,548,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1030,'Tiger_Footskin','Tiger\'s Footskin',3,1500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1031,'Limb_Of_Mantis','Mantis Scythe',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1032,'Blossom_Of_Maneater','Maneater Blossom',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1033,'Root_Of_Maneater','Maneater Root',3,208,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1034,'Cobold_Hair','Blue Hair',3,342,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1035,'Dragon_Canine','Dragon Canine',3,484,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1036,'Dragon_Scale','Dragon Scale',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1037,'Dragon_Train','Dragon Tail',3,1200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1038,'Petite_DiablOfs_Horn','Little Evil Horn',3,528,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1039,'Petite_DiablOfs_Wing','Little Evil Wing',3,2000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1040,'Elder_Pixie\'s_Beard','Elder Pixie\'s Moustache',3,232,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1041,'Lantern','Lantern',3,250,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1042,'Short_Leg','Bug Leg',3,430,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1043,'Nail_Of_Orc','Orc Claw',3,168,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1044,'Tooth_Of_','Zenorc\'s Fang',3,264,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1045,'Sacred_Masque','Cultish Masque',3,412,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1046,'Tweezer','Scorpion Nipper',3,614,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1047,'Head_Of_Medusa','Dead Medusa',3,548,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1048,'Slender_Snake','Horrendous Hair',3,800,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1049,'Skirt_Of_Virgin','Skirt of Virgin',3,1700,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1050,'Tendon','Tendon',3,220,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1051,'Detonator','Detonator',3,450,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1052,'Single_Cell','Single Cell',3,46,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1053,'Tooth_Of_Ancient_Fish','Ancient Tooth',3,548,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1054,'Lip_Of_Ancient_Fish','Ancient Lips',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1055,'Earthworm_Peeling','Earthworm Peeling',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1056,'Grit','Grit',3,306,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1057,'Moth_Dust','Moth Dust',3,138,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1058,'Wing_Of_Moth','Moth Wings',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1059,'Transparent_Cloth','Fabric',3,306,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1060,'Golden_Hair','Golden Hair',3,430,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1061,'Starsand_Of_Witch','Witched Starsand',3,484,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1062,'Pumpkin_Head','Jack o\' Pumpkin',3,374,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1063,'Sharpened_Cuspid','Fang',3,680,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1064,'Reins','Reins',3,802,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1065,'Booby_Trap','Trap',3,75,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1066,'Tree_Of_Archer_1','Fine-grained Trunk',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1067,'Tree_Of_Archer_2','Solid Trunk',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1068,'Tree_Of_Archer_3','Barren Trunk',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1069,'Mushroom_Of_Thief_1','Orange Net Mushroom',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1070,'Mushroom_Of_Thief_2','Orange Gooey Mushroom',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1071,'Mage_Test_1','Unknown Test Tube',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1072,'Delivery_Message','Delivery Message',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1073,'Merchant_Voucher_1','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1074,'Merchant_Voucher_2','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1075,'Merchant_Voucher_3','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1076,'Merchant_Voucher_4','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1077,'Merchant_Voucher_5','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1078,'Merchant_Voucher_6','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1079,'Merchant_Voucher_7','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1080,'Merchant_Voucher_8','Voucher',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1081,'Merchant_Box_1','Delivery Box',3,0,NULL,1200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1082,'Merchant_Box_2','Delivery Box',3,0,NULL,1200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1083,'Merchant_Box_3','Delivery Box',3,0,NULL,1200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1084,'Kapra\'s_Pass','Kafra Pass',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1085,'Mage_Test_2','Unknown Test Tube',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1086,'Mage_Test_3','Unknown Test Tube',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1087,'Mage_Test_4','Unknown Test Tube',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1088,'Morocc_Potion','Morroc Solution',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1089,'Payon_Potion','Payon Solution',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1090,'Mage_Test_Etc','Unknown Test Tube',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1091,'Merchant_Box_Etc','Delivery Box',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1092,'Empty_Cylinder','Empty Test Tube',3,3,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1093,'Empty_Potion','Empty Potion Bottle',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1094,'Short_Daenggie','Short Daenggie',3,278,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1095,'Needle_Of_Alarm','Needle of Alarm',3,546,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1096,'Round_Shell','Round Shell',3,780,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1097,'Worn_Out_Page','Worn Out Page',3,948,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1098,'Manacles','Manacles',3,658,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1099,'Worn_Out_Prison_Uniform','Worn-out Prison Uniform',3,680,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#===================================================================
# 1-Handed Swords
#===================================================================
REPLACE INTO `item_db_re` VALUES (1101,'Sword','Sword',5,100,NULL,500,'25',NULL,1,3,0x000654E3,63,2,2,1,'2',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1102,'Sword_','Sword',5,100,NULL,500,'25',NULL,1,4,0x000654E3,63,2,2,1,'2',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1103,'Sword__','Sword',5,100,NULL,500,'25',NULL,1,0,0x000654E3,63,2,2,1,'2',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1104,'Falchion','Falchion',5,1500,NULL,600,'39',NULL,1,3,0x000654E3,63,2,2,1,'2',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1105,'Falchion_','Falchion',5,1500,NULL,600,'39',NULL,1,4,0x000654E3,63,2,2,1,'2',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1106,'Falchion__','Falchion',5,1500,NULL,600,'39',NULL,1,0,0x000654E3,63,2,2,1,'2',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1107,'Blade','Blade',5,2900,NULL,700,'53',NULL,1,3,0x000654E3,63,2,2,1,'2',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1108,'Blade_','Blade',5,2900,NULL,700,'53',NULL,1,4,0x000654E3,63,2,2,1,'2',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1109,'Blade__','Blade',5,2900,NULL,700,'53',NULL,1,0,0x000654E3,63,2,2,1,'2',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1110,'Lapier','Rapier',5,10000,NULL,500,'70',NULL,1,2,0x000654E3,63,2,2,2,'14',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1111,'Lapier_','Rapier',5,10000,NULL,500,'70',NULL,1,3,0x000654E3,63,2,2,2,'14',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1112,'Lapier__','Rapier',5,10000,NULL,500,'70',NULL,1,0,0x000654E3,63,2,2,2,'14',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1113,'Scimiter','Scimitar',5,17000,NULL,700,'85',NULL,1,2,0x000654E3,63,2,2,2,'14',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1114,'Scimiter_','Scimitar',5,17000,NULL,700,'85',NULL,1,3,0x000654E3,63,2,2,2,'14',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1115,'Scimiter__','Scimitar',5,17000,NULL,700,'85',NULL,1,3,0x000654E3,63,2,2,2,'14',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1116,'Katana','Katana',5,2000,NULL,1000,'60',NULL,1,3,0x00004082,63,2,34,1,'4',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1117,'Katana_','Katana',5,2000,NULL,1000,'60',NULL,1,4,0x00004082,63,2,34,1,'4',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1118,'Katana__','Katana',5,2000,NULL,1000,'60',NULL,1,0,0x00004082,63,2,34,1,'4',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1119,'Tsurugi','Tsurugi',5,51000,NULL,1200,'130',NULL,1,1,0x000654E2,63,2,2,3,'27',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1120,'Tsurugi_','Tsurugi',5,51000,NULL,1200,'130',NULL,1,2,0x000654E2,63,2,2,3,'27',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1121,'Tsurugi__','Tsurugi',5,51000,NULL,1200,'130',NULL,1,0,0x000654E2,63,2,2,3,'27',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1122,'Ring_Pommel_Saber','Ring Pommel Saber',5,24000,NULL,900,'100',NULL,1,2,0x000654E2,63,2,2,2,'14',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1123,'Haedonggum','Haedonggum',5,50000,NULL,900,'120',NULL,1,1,0x000654E2,63,2,2,3,'27',1,2,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1124,'Orcish_Sword','Orcish Sword',5,20,NULL,800,'90',NULL,1,0,0x000654E3,63,2,2,3,'5',1,2,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1125,'Ring_Pommel_Saber_','Ring Pommel Saber',5,24000,NULL,900,'100',NULL,1,3,0x000654E2,63,2,2,2,'14',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1126,'Saber','Saber',5,49000,NULL,1000,'115',NULL,1,2,0x000654E2,63,2,2,3,'27',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1127,'Saber_','Saber',5,49000,NULL,1000,'115',NULL,1,3,0x000654E2,63,2,2,3,'27',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1128,'Hae_Dong_Gum_','Haedonggum',5,50000,NULL,900,'120',NULL,1,2,0x000654E2,63,2,2,3,'27',1,2,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1129,'Flamberge','Flamberge',5,60000,NULL,1500,'150',NULL,1,0,0x00004080,63,2,2,3,'27',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1130,'Nagan','Nagan',5,20,NULL,500,'120',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'skill "TF_DOUBLE",5; bonus bDoubleRate,25; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1131,'Ice_Falchon','Ice Falchion',5,20,NULL,600,'100',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'bonus bAtkEle,Ele_Water; bonus2 bAddEff,Eff_Freeze,500; bonus2 bAddEff2,Eff_Freeze,10; skill "MG_COLDBOLT",3; bonus3 bAutoSpell,"MG_COLDBOLT",3,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1132,'Edge','Edge',5,20,NULL,700,'115',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'bonus2 bAddEff,Eff_Curse,30; bonus2 bComaClass,Class_Normal,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1133,'Fire_Brand','Fireblend',5,20,NULL,500,'100',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'bonus bAtkEle,Ele_Fire; skill "MG_FIREBOLT",3; bonus3 bAutoSpell,"MG_FIREBOLT",3,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1134,'Scissores_Sword','Caesar\'s Sword',5,20,NULL,700,'140',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'bonus2 bAddRace,RC_Plant,25; bonus bIgnoreDefRace,RC_Plant;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1135,'Cutlas','Cutlus',5,20,NULL,900,'150',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'skill "SM_BASH",5; bonus bStr,2; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1136,'Solar_Sword','Solar Sword',5,20,NULL,1200,'85',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'bonus bAtkEle,Ele_Fire; bonus2 bHPDrainRate,1000,1; bonus2 bSPLossRate,15,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1137,'Excalibur','Excalibur',5,20,NULL,1200,'150',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'bonus bInt,5; bonus bLuk,10; bonus bDex,-1; bonus bAtkEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1138,'Mysteltainn_','Mysteltainn',5,20,NULL,1000,'170',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'bonus bAtkEle,Ele_Dark; bonus2 bAddEle,Ele_Ghost,15; bonus3 bAutoSpell,"MG_STONECURSE",3,100; bonus2 bAddEff,Eff_Stone,10; bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1139,'Tale_Fing_','Tirfing',5,20,NULL,1000,'200',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'bonus bAtkEle,Ele_Dark; bonus2 bHPLossRate,35,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1140,'Byeorrun_Gum','Byeollungum',5,20,NULL,900,'150',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'bonus2 bSubClass,Class_Normal,-10; bonus2 bAddClass,Class_Boss,50; bonus bAllStats,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1141,'Immaterial_Sword','Immaterial Sword',5,20,NULL,900,'140',NULL,1,0,0x000654E2,63,2,2,4,'40',1,2,'bonus bAtkEle,Ele_Ghost; bonus3 bSPVanishRate,30,30,BF_WEAPON|BF_MAGIC|BF_MISC; bonus bSPDrainValue,-1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1142,'Jewel_Sword','Jeweled Sword',5,20,NULL,2200,'104',NULL,1,0,0x000654E2,63,2,2,3,'68',1,2,'bonus2 bAddMonsterDropItemGroup,IG_Jewel,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1143,'Gaia_Sword','Gaia Sword',5,20,NULL,2500,'140',NULL,1,0,0x000654E2,63,2,2,3,'74',1,2,'bonus2 bAddMonsterDropItemGroup,IG_Ore,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1144,'Sasimi','Sashimi',5,20,NULL,1400,'75',NULL,1,0,0x000654E2,63,2,2,3,'48',1,2,'bonus bAtkEle,Ele_Wind; bonus3 bAddMonsterDropItem,544,RC_Fish,4000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1145,'Holy_Avenger','Holy Avenger',5,450000,NULL,1350,'125',NULL,1,0,0x00004000,63,2,2,3,'75',1,2,'bonus bAtkEle,Ele_Holy; bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1146,'Town_Sword','Town Sword',5,42000,NULL,800,'100',NULL,1,1,0x00000001,63,2,2,3,'30',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1147,'Town_Sword_','Town Sword',5,42000,NULL,800,'100',NULL,1,2,0x00000001,63,2,2,3,'30',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1148,'Star_Dust_Blade','Star Dust Blade',5,20,NULL,1000,'140',NULL,1,1,0x00000001,63,2,2,4,'45',1,2,'bonus2 bAddEff,Eff_Stun,500; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1149,'Flamberge_','Flamberge',5,60000,NULL,1500,'150',NULL,1,2,0x00004080,63,2,2,3,'27',1,2,NULL,NULL,NULL);
#===================================================================
# 2-Handed Swords
#===================================================================
REPLACE INTO `item_db_re` VALUES (1151,'Slayer','Slayer',5,15000,NULL,1300,'90',NULL,1,2,0x00004082,63,2,34,2,'18',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1152,'Slayer_','Slayer',5,15000,NULL,1300,'90',NULL,1,3,0x00004082,63,2,34,2,'18',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1153,'Slayer__','Slayer',5,15000,NULL,1300,'90',NULL,1,0,0x00004082,63,2,34,2,'18',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1154,'Bastard_Sword','Bastard Sword',5,22500,NULL,1600,'115',NULL,1,2,0x00004082,63,2,34,2,'18',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1155,'Bastard_Sword_','Bastard Sword',5,22500,NULL,1600,'115',NULL,1,3,0x00004082,63,2,34,2,'18',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1156,'Bastard_Sword__','Bastard Sword',5,22500,NULL,1600,'115',NULL,1,0,0x00004082,63,2,34,2,'18',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1157,'Two_Hand_Sword','Two-Handed Sword',5,60000,NULL,2200,'160',NULL,1,1,0x00004082,63,2,34,3,'33',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1158,'Two_Hand_Sword_','Two-Handed Sword',5,60000,NULL,2200,'160',NULL,1,2,0x00004082,63,2,34,3,'33',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1159,'Two_Hand_Sword__','Two-Handed Sword',5,60000,NULL,2200,'160',NULL,1,0,0x00004082,63,2,34,3,'33',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1160,'Broad_Sword','Broad Sword',5,65000,NULL,2000,'140',NULL,1,1,0x00004082,63,2,34,3,'33',1,3,'bonus bDef,5; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1161,'Balmung','Balmung',5,20,NULL,1000,'250',NULL,1,0,0xFFFFFFFF,63,2,34,4,'48',1,3,'bonus bUnbreakableWeapon; bonus bAtkEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1162,'Broad_Sword_','Broad Sword',5,65000,NULL,2000,'140',NULL,1,2,0x00004082,63,2,34,3,'33',1,3,'bonus bDef,5; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1163,'Claymore','Claymore',5,74000,NULL,2500,'180',NULL,1,0,0x00004080,63,2,34,3,'33',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1164,'Muramasa','Muramasa',5,20,NULL,1000,'155',NULL,1,0,0x00004082,63,2,34,4,'48',1,3,'bonus bCritical,30; bonus bAspdRate,8; bonus2 bAddEff2,Eff_Curse,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1165,'Masamune','Masamune',5,20,NULL,1000,'200',NULL,1,0,0x00004082,63,2,34,4,'48',1,3,'bonus bFlee,30; bonus bStr,-5; bonus bAspd,2; bonus bDefRate,-67; bonus bDef2Rate,-67;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1166,'Dragon_Slayer','Dragon Slayer',5,20,NULL,1300,'150',NULL,1,0,0x00004082,63,2,34,4,'48',1,3,'bonus bIgnoreDefRace,RC_Dragon; bonus2 bAddRace,RC_Dragon,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1167,'Schweizersabel','Schweizersabel',5,20,NULL,1600,'160',NULL,1,0,0x00004082,63,2,34,4,'48',1,3,'bonus bAtkEle,Ele_Wind; bonus bDef,1; bonus3 bAutoSpell,"MG_LIGHTNINGBOLT",3,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1168,'Zweihander','Zweihander',5,20,NULL,2200,'200',NULL,1,0,0x00004082,63,2,34,4,'48',1,3,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1169,'Executioner_','Executioner',5,20,NULL,2200,'155',NULL,1,0,0x00004082,63,2,34,4,'48',1,3,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20; bonus2 bSubRace,RC_DemiHuman,-10; bonus2 bSubRace,RC_Player,-10; bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1170,'Katzbalger','Katzbalger',5,20,NULL,2000,'175',NULL,1,0,0x00004082,63,2,34,4,'48',1,3,'bonus bVit,5; bonus bDef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1171,'Zweihander_','Zweihander',5,20,NULL,2200,'200',NULL,1,2,0x00004082,63,2,34,4,'48',1,3,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1172,'Claymore_','Claymore',5,74000,NULL,2500,'180',NULL,1,2,0x00004080,63,2,34,3,'33',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1173,'Muramasa_C','Muramasa',5,1,NULL,0,'204',NULL,1,0,0x00004082,63,2,34,4,'1',0,3,'bonus bCritical,30; bonus bAspdRate,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1174,'Executioner_C','Executioner',5,2,NULL,0,'190',NULL,1,0,0x00004082,63,2,34,4,'0',0,3,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20; bonus2 bSubRace,RC_DemiHuman,-10; bonus2 bSubRace,RC_Player,-10; bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1175,'Altas_Weapon','Atlas Weapon',5,20,NULL,3500,'200',NULL,1,1,0x00004082,18,2,34,4,'55',1,3,'bonus bCritical,10; if(readparam(bStr)>=80) bonus bBreakArmorRate,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1176,'Muscle_Cutter','Muscle Cutter',5,20,NULL,2200,'160',NULL,1,2,0x00004082,18,2,34,4,'55',1,3,'bonus2 bAddEff,Eff_Bleeding,800; bonus3 bAutoSpell,"AL_DECAGI",1,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1177,'Muramash','Muramash',5,20,NULL,0,'120',NULL,1,0,0x00004082,63,2,34,1,'0',0,3,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1178,'Schweizersabel_','Schweizersabel',5,20,NULL,1600,'160',NULL,1,2,0x00004082,63,2,34,4,'48',1,3,'bonus bAtkEle,Ele_Wind; bonus bDef,1; bonus3 bAutoSpell,"MG_LIGHTNINGBOLT",3,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1179,'Executioner__','Executioner',5,20,NULL,2200,'155',NULL,1,1,0x00004082,63,2,34,4,'48',1,3,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20; bonus2 bSubRace,RC_DemiHuman,-10; bonus2 bSubRace,RC_Player,-10; bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1180,'Dragon_Slayer_','Dragon Slayer',5,20,NULL,1300,'150',NULL,1,2,0x00004082,63,2,34,4,'48',1,3,'bonus bIgnoreDefRace,RC_Dragon; bonus2 bAddRace,RC_Dragon,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1181,'Tae_Goo_Lyeon','Tae Goo Lyeon',5,20,NULL,2000,'250',NULL,1,2,0x00004082,18,2,34,4,'90',1,3,'bonus bFlee2,10; if(JobLevel>=70) autobonus "{ bonus bBaseAtk,50; }",10,10000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }"; if(getrefine()>8) { bonus bVariableCastrate,-20; bonus bDelayRate,-20; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1182,'Bloody_Eater','Bloody Eater',5,20,NULL,1200,'200',NULL,1,2,0x00004082,18,2,34,4,'50',1,3,'bonus bAtkEle,Ele_Ghost; autobonus "{ bonus bCritical,100; bonus bBaseAtk,50; }",1,5000,0,"{ specialeffect2 EF_FIRESPLASHHIT; }"; bonus bHPGainValue,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1183,'BF_Two_Handed_Sword1','Brave Assaulter\'s Katzbalger',5,20,NULL,0,'200',NULL,1,0,0x00004082,63,2,34,3,'80',1,3,'bonus bStr,2; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1184,'BF_Two_Handed_Sword2','Valorous Assaulter\'s Katzbalger',5,20,NULL,0,'200',NULL,1,0,0x00004082,63,2,34,3,'80',1,3,'bonus bCritical,20; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus bCritAtkRate,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1185,'Violet_Fear','Violet Fear',5,20,NULL,2200,'275',NULL,1,2,0x00004082,18,2,34,4,'80',1,3,'bonus3 bAutoSpell,"WZ_METEOR",3,30; bonus3 bAutoSpell,"WZ_FROSTNOVA",5,50; autobonus "{ bonus bIgnoreDefClass,Class_Normal; specialeffect2 EF_ENHANCE; }",50,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1186,'Death_Guidance','Death Guidance',5,20,NULL,2000,'200',NULL,1,2,0x00004082,18,2,34,4,'70',1,3,'bonus bStr,5; bonus bAgi,2; bonus bFlee2,20; bonus3 bAutoSpell,"NPC_HELLPOWER",1,10; bonus4 bAutoSpell,"NPC_HELLPOWER",1,10,0; bonus3 bAutoSpell,"NPC_VAMPIRE_GIFT",(getrefine()>8?2:1),20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1187,'Krieger_Twohand_Sword1','Glorious Claymore',5,20,NULL,0,'220',NULL,1,0,0x00004082,63,2,34,4,'80',1,3,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreDefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-3,1); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-3,1); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(.@r>8) { bonus3 bAutoSpell,"LK_CONCENTRATION",max(getskilllv("LK_CONCENTRATION"),1),30; bonus3 bAutoSpell,"LK_AURABLADE",max(getskilllv("LK_AURABLADE"),1),30; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1188,'Veteran_Sword','Veteran Sword',5,10000,NULL,2000,'180',NULL,1,1,0x00004082,63,2,34,4,'80',1,3,'if(getskilllv("SM_BASH")==10) { bonus2 bSkillAtk,"SM_BASH",50; } if(getskilllv("KN_BOWLINGBASH")==10) { bonus2 bSkillAtk,"KN_BOWLINGBASH",50; } bonus bStr,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1189,'Krasnaya','Krasnaya',5,20,NULL,3800,'200',NULL,2,3,0x00004082,18,2,34,2,'50',1,3,'if(readparam(bStr)>=95) { bonus bBaseAtk,20; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1190,'Claymore_C','Claymore',5,0,NULL,0,'220',NULL,1,0,0x00004080,63,2,34,3,'1',0,3,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1191,'Alca_Bringer','Alca Bringer',5,20,NULL,3400,'280',NULL,2,0,0x00004082,63,2,34,3,'100',1,3,'bonus bAspd,(getrefine()/2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1192,'P_Slayer1','Eden Slayer I',5,0,NULL,0,'162',NULL,1,0,0x00004082,63,2,34,2,'26',0,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1193,'P_Slayer2','Eden Slayer II',5,0,NULL,0,'185',NULL,1,0,0x00004082,63,2,34,2,'40',0,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1194,'F_Executioner_C','Executioner',5,2,NULL,0,'190',NULL,1,0,0x00004082,63,2,34,4,'0',0,3,'bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1195,'E_Executioner_C','Executioner',5,2,NULL,0,'190',NULL,1,0,0x00004082,63,2,34,4,'0',0,3,'bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1196,'Chrome_Twohand_Sword','Chrome Two-Handed Sword',5,20,NULL,400,'280',NULL,1,0,0x00004082,63,2,34,3,'110',1,3,'bonus bUnbreakableWeapon; bonus bAgi,3; bonus bMaxHPrate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1197,'P_Slayer3','Eden Slayer III',5,0,NULL,0,'200',NULL,1,0,0x00004082,63,2,34,3,'60',0,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1198,'Hairtail','Cutlass',5,0,NULL,0,'220',NULL,3,0,0x00004082,63,2,34,1,'50',0,3,'bonus bUnbreakableWeapon; bonus bCritical,20; bonus bCritAtkRate,50; if(BaseLevel>99) { bonus bBaseAtk,50; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1199,'Ebony_Toe_Nail','Ebony Toe Nail',5,56000,NULL,1000,'250:150',NULL,1,0,0x00004082,63,2,34,4,'120',1,3,NULL,NULL,NULL);
#===================================================================
# Daggers
#===================================================================
REPLACE INTO `item_db_re` VALUES (1201,'Knife','Knife',5,50,NULL,400,'17',NULL,1,3,0x3E9F7EEF,63,2,2,1,'1',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1202,'Knife_','Knife',5,50,NULL,400,'17',NULL,1,4,0x3E9F7EEF,63,2,2,1,'1',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1203,'Knife__','Knife',5,50,NULL,400,'17',NULL,1,0,0x3E9F7EEF,63,2,2,1,'1',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1204,'Cutter','Cutter',5,1250,NULL,500,'30',NULL,1,3,0x3E9F7EEF,63,2,2,1,'1',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1205,'Cutter_','Cutter',5,1250,NULL,500,'30',NULL,1,4,0x3E9F7EEF,63,2,2,1,'1',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1206,'Cutter__','Cutter',5,1250,NULL,500,'30',NULL,1,0,0x3E9F7EEF,63,2,2,1,'1',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1207,'Main_Gauche','Main Gauche',5,2400,NULL,600,'43',NULL,1,3,0x3E9F7EEF,63,2,2,1,'1',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1208,'Main_Gauche_','Main Gauche',5,2400,NULL,600,'43',NULL,1,4,0x3E9F7EEF,63,2,2,1,'1',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1209,'Main_Gauche__','Main Gauche',5,2400,NULL,600,'43',NULL,1,0,0x3E9F7EEF,63,2,2,1,'1',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1210,'Dirk','Dirk',5,8500,NULL,500,'59',NULL,1,2,0x3E9F7EEF,63,2,2,2,'12',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1211,'Dirk_','Dirk',5,8500,NULL,500,'59',NULL,1,3,0x3E9F7EEF,63,2,2,2,'12',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1212,'Dirk__','Dirk',5,8500,NULL,500,'59',NULL,1,0,0x3E9F7EEF,63,2,2,2,'12',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1213,'Dagger','Dagger',5,14000,NULL,600,'73',NULL,1,2,0x3E9F7EEF,63,2,2,2,'12',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1214,'Dagger_','Dagger',5,14000,NULL,600,'73',NULL,1,3,0x3E9F7EEF,63,2,2,2,'12',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1215,'Dagger__','Dagger',5,14000,NULL,600,'73',NULL,1,0,0x3E9F7EEF,63,2,2,2,'12',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1216,'Stiletto','Stiletto',5,19500,NULL,700,'87',NULL,1,2,0x3E9F7EEF,63,2,2,2,'12',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1217,'Stiletto_','Stiletto',5,19500,NULL,700,'87',NULL,1,3,0x3E9F7EEF,63,2,2,2,'12',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1218,'Stiletto__','Stiletto',5,19500,NULL,700,'87',NULL,1,0,0x3E9F7EEF,63,2,2,2,'12',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1219,'Gladius','Gladius',5,43000,NULL,700,'105',NULL,1,2,0x028F5EEE,63,2,2,3,'24',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1220,'Gladius_','Gladius',5,43000,NULL,700,'105',NULL,1,3,0x028F5EEE,63,2,2,3,'24',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1221,'Gladius__','Gladius',5,43000,NULL,700,'105',NULL,1,0,0x028F5EEE,63,2,2,3,'24',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1222,'Damascus','Damascus',5,49000,NULL,800,'118',NULL,1,1,0x028F5EEE,63,2,2,3,'24',1,1,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1223,'Forturn_Sword','Fortune Sword',5,20,NULL,500,'90',NULL,1,0,0x028F5EEE,63,2,2,4,'24',1,1,'bonus bLuk,5; bonus bFlee2,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1224,'Sword_Breaker','Swordbreaker',5,20,NULL,1000,'70',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus bBreakWeaponRate,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1225,'Mail_Breaker','Mailbreaker',5,20,NULL,1000,'70',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus bBreakArmorRate,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1226,'Damascus_','Damascus',5,49000,NULL,800,'118',NULL,1,2,0x028F5EEE,63,2,2,3,'24',1,1,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1227,'Weeder_Knife','Weeder Knife',5,20,NULL,400,'80',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus bIgnoreDefRace,RC_Plant; bonus2 bAddRace,RC_Plant,15; bonus2 bSubRace,RC_Plant,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1228,'Combat_Knife','Combat Knife',5,20,NULL,400,'80',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10; bonus2 bSubRace,RC_Demon,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1229,'Mama\'s_Knife','Kitchen Knife',5,20,NULL,500,'75',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus bCritical,30; bonus3 bAddMonsterDropItem,517,RC_Brute,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1230,'House_Auger','Ice Pick',5,20,NULL,600,'80',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus bDefRatioAtkClass,Class_All;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1231,'Bazerald','Bazerald',5,20,NULL,500,'70:105',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus bAtkEle,Ele_Fire; bonus bInt,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1232,'Assasin_Dagger','Assassin Dagger',5,20,NULL,600,'140',NULL,1,0,0x00001000,63,2,2,4,'36',1,1,'bonus bMaxHPrate,20; bonus bMaxSPrate,15; bonus bAspdRate,2; bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1233,'Exercise','Exorciser',5,20,NULL,700,'90',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus bIgnoreDefRace,RC_Demon; bonus2 bSubRace,RC_Demon,5; bonus2 bSubRace,RC_DemiHuman,-10; bonus2 bSubRace,RC_Player,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1234,'Moonlight_Sword','Moonlight Dagger',5,20,NULL,700,'50',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus bMaxSPrate,10; bonus bSPDrainValue,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1235,'Azoth','Azoth',5,20,NULL,700,'110',NULL,1,0,0x00040000,63,2,2,4,'36',1,1,'bonus bClassChange,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1236,'Sucsamad','Sucsamad',5,20,NULL,800,'140',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus2 bAddEle,Ele_Earth,10; bonus2 bAddEle,Ele_Wind,10; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1237,'Grimtooth_','Grimtooth',5,20,NULL,800,'180',NULL,1,0,0x028F5EEE,63,2,2,4,'36',1,1,'bonus bFlee,10; bonus bFlee2,5; bonus bDefRate,-50; bonus bDef2Rate,-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1238,'Zeny_Knife','Zeny Knife',5,20,NULL,1200,'64',NULL,1,0,0x028F5EEE,63,2,2,3,'70',1,1,'bonus2 bGetZenyNum,100,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1239,'Poison_Knife','Poison Knife',5,20,NULL,800,'64',NULL,1,0,0x028F5EEE,63,2,2,3,'65',1,1,'bonus bAtkEle,Ele_Poison; bonus2 bAddEff,Eff_Poison,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1240,'Princess_Knife','Princess Knife',5,20,NULL,400,'84',NULL,1,0,0x028F5EEE,63,2,2,4,'1',1,1,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1241,'Cursed_Dagger','Cursed Dagger',5,80000,NULL,400,'55',NULL,1,0,0x00810204,63,2,2,4,'85',1,1,'bonus2 bAddEff,Eff_Curse,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1242,'Counter_Dagger','Dagger of Counter',5,120000,NULL,550,'140',NULL,1,0,0x00810204,63,2,2,4,'55',1,1,'bonus bCritical,90;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1243,'Novice_Knife','Novice Main-Gauche',5,0,NULL,1,'45',NULL,1,0,0x00000001,63,2,2,1,'1',0,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1244,'Holy_Dagger','Holy Dagger',5,20,NULL,800,'100',NULL,1,0,0x02021040,63,2,2,4,'55',1,1,'bonus bAtkEle,Ele_Holy; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1245,'Cinquedea','Cinquedea',5,40000,NULL,700,'110',NULL,1,1,0x00000001,63,2,2,3,'30',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1246,'Cinquedea_','Cinquedea',5,40000,NULL,700,'110',NULL,1,2,0x00000001,63,2,2,3,'30',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1247,'Kindling_Dagger','Kindle Dagger',5,10000,NULL,600,'39',NULL,1,0,0x3E9F7EEF,63,2,2,1,'1',1,1,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1248,'Obsidian_Dagger','Obsidian Dagger',5,10000,NULL,600,'39',NULL,1,0,0x3E9F7EEF,63,2,2,1,'1',1,1,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1249,'Fisherman\'s_Dagger','Fisherman\'s Dagger',5,10000,NULL,600,'39',NULL,1,0,0x3E9F7EEF,63,2,2,1,'1',1,1,'bonus bAtkEle,Ele_Water;',NULL,NULL);
#===================================================================
# Katars
#===================================================================
REPLACE INTO `item_db_re` VALUES (1250,'Jur','Jur',5,19500,NULL,800,'125',NULL,1,2,0x00001000,63,2,34,2,'18',1,16,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1251,'Jur_','Jur',5,19500,NULL,800,'125',NULL,1,3,0x00001000,63,2,34,2,'18',1,16,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1252,'Katar','Katar',5,41000,NULL,1200,'148',NULL,1,1,0x00001000,63,2,34,3,'33',1,16,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1253,'Katar_','Katar',5,41000,NULL,1200,'148',NULL,1,2,0x00001000,63,2,34,3,'33',1,16,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1254,'Jamadhar','Jamadhar',5,37200,NULL,1500,'165',NULL,1,0,0x00001000,63,2,34,3,'33',1,16,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1255,'Jamadhar_','Jamadhar',5,37200,NULL,1500,'165',NULL,1,1,0x00001000,63,2,34,3,'33',1,16,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1256,'Katar_Of_Cold_Icicle','Katar of Frozen Icicle',5,45000,NULL,1200,'105',NULL,1,0,0x00001000,63,2,34,3,'55',1,16,'bonus bAtkEle,Ele_Water; bonus2 bAddEff,Eff_Freeze,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1257,'Katar_Of_Thornbush','Katar of Quaking',5,45000,NULL,1200,'105',NULL,1,0,0x00001000,63,2,34,3,'55',1,16,'bonus bAtkEle,Ele_Earth; bonus2 bAddEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1258,'Katar_Of_Raging_Blaze','Katar of Raging Blaze',5,45000,NULL,1200,'105',NULL,1,0,0x00001000,63,2,34,3,'55',1,16,'bonus bAtkEle,Ele_Fire; bonus2 bAddEff,Eff_Silence,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1259,'Katar_Of_Piercing_Wind','Katar of Piercing Wind',5,45000,NULL,1200,'105',NULL,1,0,0x00001000,63,2,34,3,'55',1,16,'bonus bAtkEle,Ele_Wind; bonus2 bAddEff,Eff_Sleep,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1260,'Ghoul_Leg','Sharpened Legbone of Ghoul',5,52500,NULL,1700,'150',NULL,1,0,0x00001000,63,2,34,3,'65',1,16,'bonus bAtkEle,Ele_Undead;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1261,'Infiltrator','Infiltrator',5,57000,NULL,1500,'140',NULL,1,0,0x00001000,63,2,34,4,'75',1,16,'bonus2 bAddRace,RC_DemiHuman,50; bonus2 bAddRace,RC_Player,50; bonus bDef,3; bonus bFlee,5; bonus bFlee2,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1262,'Nail_Of_Loki','Loki\'s Nail',5,20,NULL,1200,'115',NULL,1,0,0x00001000,63,2,34,3,'55',1,16,'bonus2 bAddEff,Eff_Bleeding,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1263,'Unholy_Touch','Unholy Touch',5,20,NULL,1250,'151',NULL,1,0,0x00001000,63,2,34,4,'70',1,16,'bonus bAtkEle,Ele_Dark; bonus2 bAddEff,Eff_Curse,200; bonus bCritical,-1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1264,'Various_Jur','Specialty Jur',5,20,NULL,800,'90',NULL,1,4,0x00001000,63,2,34,1,'1',1,16,'bonus2 bAddEff2,Eff_Bleeding,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1265,'Bloody_Roar','Bloody Roar',5,20,NULL,1000,'120',NULL,1,0,0x00001000,63,2,34,4,'75',1,16,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus bFlee,-(readparam(bAgi)+BaseLevel); bonus bHPrecovRate,-100; bonus bSPrecovRate,-100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1266,'Infiltrator_','Infiltrator',5,57000,NULL,1500,'140',NULL,1,1,0x00001000,63,2,34,4,'75',1,16,'bonus2 bAddRace,RC_DemiHuman,50; bonus2 bAddRace,RC_Player,50; bonus bDef,3; bonus bFlee,5; bonus bFlee2,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1267,'Infiltrator_C','Infiltrator',5,1,NULL,0,'189',NULL,1,0,0x00001000,63,2,34,4,'1',0,16,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus bDef,3; bonus bFlee,5; bonus bFlee2,2; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1268,'Wild_Beast_Claw','Wild Beast Claw',5,20,NULL,1450,'160',NULL,1,1,0x00001000,18,2,34,4,'55',1,16,'bonus3 bAutoSpell,"NPC_CRITICALWOUND",(getrefine()>=9?2:1),100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1269,'Inverse_Scale','Inverse Scale',5,20,NULL,1500,'140',NULL,1,0,0x00001000,18,2,34,4,'55',1,16,'bonus bAtkEle,Ele_Holy; bonus3 bAutoSpell,"NPC_DRAGONFEAR",1,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1270,'Drill_Katar','Drill Katar',5,20,NULL,1400,'110',NULL,1,1,0x00001000,18,2,34,4,'55',1,16,'bonus bHit,30; bonus3 bAutoSpell,"ST_FULLSTRIP",1,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1271,'Blood_Tears','Blood Tears',5,20,NULL,1700,'120',NULL,1,2,0x00001000,18,2,34,4,'55',1,16,'bonus3 bAutoSpell,"NPC_WIDEBLEEDING",(getrefine()>=9?2:1),30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1272,'Scratcher','Scratcher',5,20,NULL,0,'120',NULL,1,0,0x00001000,63,2,34,1,'0',0,16,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1273,'Bloody_Roar_C','Refined Bloody Roar',5,1,NULL,0,'148',NULL,1,0,0x00001000,63,2,34,4,'0',0,16,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bHPRegenRate,3,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1274,'Unholy_Touch_C','Refined Unholy Touch',5,1,NULL,0,'179',NULL,1,0,0x00001000,63,2,34,4,'0',0,16,'bonus bAtkEle,Ele_Dark; bonus2 bAddEff,Eff_Curse,5000; bonus bCritical,-1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1275,'Katar_Of_Cold_Icicle_','Katar of Frozen Icicle',5,45000,NULL,1200,'105',NULL,1,3,0x00001000,63,2,34,3,'55',1,16,'bonus bAtkEle,Ele_Water; bonus2 bAddEff,Eff_Freeze,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1276,'Katar_Of_Thornbush_','Katar of Quaking',5,45000,NULL,1200,'105',NULL,1,3,0x00001000,63,2,34,3,'55',1,16,'bonus bAtkEle,Ele_Earth; bonus2 bAddEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1277,'Katar_Of_Raging_Blaze_','Katar of Raging Blaze',5,45000,NULL,1200,'105',NULL,1,3,0x00001000,63,2,34,3,'55',1,16,'bonus bAtkEle,Ele_Fire; bonus2 bAddEff,Eff_Silence,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1278,'Katar_Of_Piercing_Wind_','Katar of Piercing Wind',5,45000,NULL,1200,'105',NULL,1,3,0x00001000,63,2,34,3,'55',1,16,'bonus bAtkEle,Ele_Wind; bonus2 bAddEff,Eff_Sleep,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1279,'BF_Katar1','Brave Carnage Katar',5,20,NULL,0,'130',NULL,1,0,0x00001000,63,2,34,3,'80',1,16,'bonus bStr,1; bonus bDex,1; bonus bLuk,1; bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1280,'BF_Katar2','Valorous Carnage Katar',5,20,NULL,0,'130',NULL,1,0,0x00001000,63,2,34,3,'80',1,16,'bonus bStr,1; bonus bDex,1; bonus bLuk,1; bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus bCritAtkRate,20; bonus bAspdRate,5; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1281,'Krieger_Katar1','Glorious Bloody Roar',5,20,NULL,0,'140',NULL,1,0,0x00001000,63,2,34,4,'80',1,16,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(.@r>8) autobonus "{ bonus bAspdRate,100; }",70,3000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1282,'Krieger_Katar2','Glorious Jamadhar',5,20,NULL,0,'140',NULL,1,0,0x00001000,63,2,34,4,'80',1,16,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bCriticalAddRace,RC_DemiHuman,5; bonus2 bCriticalAddRace,RC_Player,5; } if(.@r>8) autobonus "{ bonus bAspdRate,100; }",70,3000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1283,'Katar_Of_Speed','Katar Of Speed',5,20,NULL,0,'175',NULL,1,0,0x00001000,63,2,34,4,'0',0,16,'bonus2 bSkillAtk,"AS_SONICBLOW",25; bonus bAspdRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1284,'Krishna','Krishna',5,20,NULL,1200,'120',NULL,1,2,0x00001000,18,2,34,3,'50',1,16,'bonus2 bSkillAtk,"AS_GRIMTOOTH",10; bonus3 bAutoSpell,"AS_SONICBLOW",max(getskilllv("AS_SONICBLOW"),1),5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1285,'Cakram','Chakram',5,20,NULL,1000,'130',NULL,1,2,0x00001000,18,2,34,3,'50',1,16,'if(getskilllv("AS_KATAR")==10) { bonus bHit,10; } bonus2 bSkillAtk,"ASC_METEORASSAULT",20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1286,'Jamadhar_C','Jamadhar',5,0,NULL,0,'200',NULL,1,0,0x00001000,63,2,34,3,'1',0,16,'bonus bUnbreakableWeapon; bonus2 bAddSize,Size_All,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1287,'Durga','Durga',5,20,NULL,1200,'190',NULL,1,1,0x00001000,63,2,34,3,'100',1,16,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1288,'Bloody_Fear_C','Bloody Fear',5,1,NULL,0,'145',NULL,1,0,0x00001000,63,2,34,4,'1',0,16,'bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus2 bAddEff,Eff_Bleeding,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1289,'P_Katar1','Eden Katar I',5,0,NULL,0,'155',NULL,1,0,0x00001000,63,2,34,3,'60',0,16,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1290,'Agent_Katar','Agent Katar',5,41000,NULL,1200,'170',NULL,1,1,0x00001000,63,2,34,3,'100',1,16,'bonus bHit,readparam(bLuk)/2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1291,'Guillotine_Katar','Guillotine Katar',5,56000,NULL,1500,'200',NULL,1,1,0x00001000,63,2,34,4,'140',1,16,'bonus bDex,2; bonus bFlee,-30; bonus2 bAddRace,RC_DemiHuman,50; bonus2 bAddRace,RC_Player,50; bonus2 bSkillAtk,"GC_CROSSIMPACT",30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1292,'Upg_Katar','Upg Katar',5,20,NULL,1000,'80',NULL,1,1,0x00001000,63,2,34,3,'1',1,16,'.@r = getrefine(); bonus bBaseAtk,(.@r*10); bonus bCritAtkRate,(.@r*2); if(BaseLevel>70) bonus bBaseAtk,(((BaseLevel-70)/10)*10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1293,'Velum_Jamadhar','Vellum Jamadhar',5,20,NULL,1200,'170',NULL,1,0,0x00001000,63,2,34,4,'95',1,16,'bonus4 bSetDefRace,RC_Player,10000,5000,1; bonus4 bSetMDefRace,RC_Player,10000,5000,1; bonus bAspdRate,getrefine();',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1294,'Velum_Scare','Vellum Scale',5,20,NULL,1200,'50',NULL,1,0,0x00001000,63,2,34,4,'95',1,16,'bonus3 bSPVanishRaceRate,RC_Player,1000,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1295,'Blood_Tears_','Blood Tears',5,20,NULL,1700,'120',NULL,1,3,0x00001000,18,2,34,4,'55',1,16,'bonus3 bAutoSpell,"NPC_WIDEBLEEDING",(getrefine()>=9?2:1),30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1296,'Metal_Katar','Metal Katar',5,20,NULL,0,'75',NULL,1,1,0x00001000,63,2,34,3,'1',1,16,'.@r = getrefine(); bonus bBaseAtk,(.@r*5); bonus bCritAtkRate,.@r; .@i = min(BaseLevel/10,12); if(.@i>2) bonus bBaseAtk,((.@i-2)*5);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1297,'Inverse_Scale_','Inverse Scale',5,20,NULL,1500,'140',NULL,1,2,0x00001000,18,2,34,4,'55',1,16,'bonus bAtkEle,Ele_Holy; bonus3 bAutoSpell,"NPC_DRAGONFEAR",1,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1298,'Shiver_Katar','Katar Of Horror',5,60000,NULL,2700,'110',NULL,1,2,0x00001000,63,2,34,4,'105',1,16,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1299,'TE_Woe_Katar','TE Woe Katar',5,0,NULL,0,'120',NULL,1,0,0x00001000,63,2,34,3,'40',1,16,'bonus2 bAddRace,RC_Player,40; bonus2 bAddEff,Eff_Bleeding,3000;',NULL,NULL);
#===================================================================
# 1-Handed Axes
#===================================================================
REPLACE INTO `item_db_re` VALUES (1301,'Axe','Axe',5,500,NULL,800,'38',NULL,1,3,0x000654E3,63,2,2,1,'3',1,6,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1302,'Axe_','Axe',5,500,NULL,800,'38',NULL,1,4,0x000654E3,63,2,2,1,'3',1,6,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1303,'Axe__','Axe',5,500,NULL,800,'38',NULL,1,0,0x000654E3,63,2,2,1,'3',1,6,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1304,'Orcish_Axe','Orcish Axe',5,20,NULL,1500,'75',NULL,1,0,0x000654E3,63,2,2,3,'3',1,6,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1305,'Cleaver','Cleaver',5,20,NULL,1200,'140',NULL,1,0,0x000444A2,63,2,2,4,'44',1,6,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus3 bAddMonsterDropItem,517,RC_Brute,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1306,'War_Axe','War Axe',5,20,NULL,4200,'140',NULL,1,1,0x00040400,63,2,2,3,'76',1,6,'bonus bDex,2; bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1307,'Windhawk','Windhawk',5,18000,NULL,1500,'115',NULL,1,0,0x000654E2,63,2,2,2,'14',1,6,'bonus bAtkEle,Ele_Wind; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1308,'Golden_Axe','Golden Axe',5,20,NULL,3000,'170',NULL,1,0,0x00000001,63,2,2,4,'45',1,6,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1309,'Orcish_Axe_','Orcish Axe',5,20,NULL,1500,'75',NULL,1,4,0x000654E3,63,2,2,3,'3',1,6,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1310,'Krieger_Onehand_Axe1','Glorious Cleaver',5,20,NULL,0,'130',NULL,1,0,0x000444A2,63,2,2,4,'80',1,6,'bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; bonus bAspdRate,5; } if(.@r>8) { bonus bAspdRate,5; bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,50; bonus4 bAutoSpellOnSkill,"MC_MAMMONITE","NPC_CRITICALWOUND",2,200; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1311,'Vecer_Axe','Vecer Axe',5,20,NULL,1500,'140',NULL,1,2,0x000444A2,18,2,2,3,'50',1,6,'if(readparam(bLuk)>=90) { bonus bBaseAtk,20; } if(readparam(bDex)>=90) { bonus bCritical,5; } if(readparam(bDex)>=90&&readparam(bLuk)>=90) { bonus2 bSkillAtk,"MC_MAMMONITE",15; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1312,'Orcish_Axe_C','Orcish Axe',5,0,NULL,0,'110',NULL,1,0,0x000654E3,63,2,2,3,'1',0,6,'bonus2 bAddSize,Size_All,70;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1313,'Tourist_Axe','Tourist Axe',5,0,NULL,500,'77',NULL,1,0,0x000654E3,63,2,2,1,'1',0,6,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1314,'F_Tomahawk_C','Tomahawk',5,2,NULL,0,'200',NULL,1,0,0x000444A2,63,2,34,4,'0',0,7,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1315,'F_Right_Epsilon_C','Light Epsilon',5,1,NULL,0,'229',NULL,1,0,0x000444A2,63,2,34,4,'1',0,7,'bonus bAtkEle,Ele_Holy; bonus bStr,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1316,'Adventure_Axe','Adventure Axe',5,0,NULL,0,'100',NULL,1,0,0x00040420,63,2,2,1,'1',0,6,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1317,'Academy_Axe','Academy Axe',5,0,NULL,1600,'130',NULL,1,1,0x00040420,63,2,2,1,'30',1,6,'bonus bUnbreakableWeapon; bonus bAspdRate,5-(BaseLevel/10); bonus bMaxHP,200-(40*(BaseLevel/10));',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1318,'Dofle_Axe','Deflation Axe',5,50000,NULL,1800,'180',NULL,1,2,0x000654E2,63,2,2,4,'105',1,6,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1319,'TE_Woe_Axe','TE Woe Axe',5,0,NULL,0,'100',NULL,1,0,0x000654E3,63,2,2,3,'40',1,6,'bonus bUnbreakableWeapon; bonus2 bAddRace,RC_Player,40; bonus2 bAddEff,Eff_Freeze,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1321,'Dofle_Axe_','Deflation Axe',5,50000,NULL,1800,'180',NULL,1,3,0x000654E2,63,2,2,4,'105',1,6,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1322,'Ru_Blue_Axe','Blue Axe',5,10,NULL,1800,'180',NULL,1,1,0xFFFFFFFF,63,2,2,1,'1',1,6,'bonus bStr,5; bonus bVit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1323,'Ru_Gold_Axe','Ru Gold Axe',5,0,NULL,1800,'180',NULL,1,2,0x00040000,56,2,2,3,'120',1,6,'bonus bStr,8; bonus bInt,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1324,'War_Axe_','War Axe',5,20,NULL,4200,'140',NULL,1,3,0x00040400,63,2,2,3,'76',1,6,'bonus bDex,2; bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1326,'Illusion_War_Axe','Illusion War Axe',5,0,NULL,4200,'180',NULL,1,2,0x00040420,63,2,2,4,'120',1,6,'bonus bStr,2; bonus bDex,2; bonus bLuk,2; .@r = getrefine(); if (.@r >= 9) { .@val = 40; } else if (.@r >= 7) { .@val = 20; } bonus2 bSkillAtk,"NC_AXETORNADO",(100+.@val); bonus2 bSkillAtk,"NC_AXEBOOMERANG",(100+.@val); bonus2 bSkillAtk,"GN_CART_TORNADO",(75+.@val);',NULL,NULL);
#===================================================================
# 2-Handed Axes
#===================================================================
REPLACE INTO `item_db_re` VALUES (1351,'Battle_Axe','Battle Axe',5,5400,NULL,1500,'80',NULL,1,3,0x000444A2,63,2,34,1,'3',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1352,'Battle_Axe_','Battle Axe',5,5400,NULL,1500,'80',NULL,1,4,0x000444A2,63,2,34,1,'3',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1353,'Battle_Axe__','Battle Axe',5,5400,NULL,1500,'80',NULL,1,0,0x000444A2,63,2,34,1,'3',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1354,'Hammer','Hammer',5,15500,NULL,2000,'120',NULL,1,2,0x000444A2,63,2,34,2,'16',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1355,'Hammer_','Hammer',5,15500,NULL,2000,'120',NULL,1,3,0x000444A2,63,2,34,2,'16',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1356,'Hammer__','Hammer',5,15500,NULL,2000,'120',NULL,1,0,0x000444A2,63,2,34,2,'16',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1357,'Buster','Buster',5,34000,NULL,2200,'155',NULL,1,1,0x000444A2,63,2,34,3,'30',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1358,'Buster_','Buster',5,34000,NULL,2200,'155',NULL,1,2,0x000444A2,63,2,34,3,'30',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1359,'Buster__','Buster',5,34000,NULL,2200,'155',NULL,1,0,0x000444A2,63,2,34,3,'30',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1360,'Two_Handed_Axe','Two-Handed Axe',5,55000,NULL,2500,'185',NULL,1,1,0x000444A2,63,2,34,3,'30',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1361,'Two_Handed_Axe_','Two-Handed Axe',5,55000,NULL,2500,'185',NULL,1,2,0x000444A2,63,2,34,3,'30',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1362,'Two_Handed_Axe__','Two-Handed Axe',5,55000,NULL,2500,'185',NULL,1,0,0x000444A2,63,2,34,3,'30',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1363,'Brood_Axe','Bloody Axe',5,20,NULL,4000,'170',NULL,1,0,0x000444A2,63,2,34,4,'44',1,7,'bonus bStr,10; bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1364,'Great_Axe','Great Axe',5,20,NULL,1800,'187',NULL,1,0,0x000444A2,63,2,34,4,'44',1,7,'bonus2 bAddSkillBlow,"MC_MAMMONITE",5; bonus2 bAddEff,Eff_Stun,1500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1365,'Sabbath','Sabbath',5,20,NULL,2300,'120',NULL,1,0,0x000444A2,63,2,34,4,'44',1,7,'bonus bAtkEle,Ele_Dark; bonus2 bComaRace,RC_Demon,50; bonus2 bCriticalAddRace,RC_Undead,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1366,'Right_Epsilon','Light Epsilon',5,20,NULL,2300,'180',NULL,1,0,0x000444A2,63,2,34,4,'44',1,7,'bonus bAtkEle,Ele_Holy; skill "AL_HEAL",3; bonus2 bAddRace,RC_Demon,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1367,'Slaughter','Slaughter',5,20,NULL,2500,'120',NULL,1,0,0x000444A2,63,2,34,4,'44',1,7,'bonus bAtkEle,Ele_Earth; bonus bIgnoreDefRace,RC_Brute; bonus2 bComaRace,RC_Brute,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1368,'Tomahawk','Tomahawk',5,20,NULL,2500,'165',NULL,1,0,0x000444A2,63,2,34,4,'44',1,7,'bonus bAtkEle,Ele_Wind; skill "ITM_TOMAHAWK",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1369,'Guillotine','Guillotine',5,20,NULL,3000,'215',NULL,1,0,0x000444A2,63,2,34,4,'44',1,7,'bonus2 bComaRace,RC_DemiHuman,30; bonus2 bComaRace,RC_Player,30; bonus2 bSPDrainValueRace,RC_DemiHuman,2; bonus2 bSPDrainValueRace,RC_Player,2; bonus2 bSPGainRace,RC_DemiHuman,20; bonus2 bSPGainRace,RC_Player,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1370,'Doom_Slayer','Doom Slayer',5,20,NULL,6000,'10',NULL,1,0,0x000444A2,63,2,34,4,'80',1,7,'bonus bAspdRate,-40; bonus bUseSPrate,100; if(readparam(bStr)>=95){ bonus bBaseAtk,340; bonus2 bAddEff,Eff_Stun,3000; bonus bBreakArmorRate,500; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1371,'Doom_Slayer_','Doom Slayer',5,20,NULL,6000,'10',NULL,1,1,0x000444A2,63,2,34,4,'80',1,7,'bonus bAspdRate,-40; bonus bUseSPrate,100; if(readparam(bStr)>=95){ bonus bBaseAtk,340; bonus2 bAddEff,Eff_Stun,3000; bonus bBreakArmorRate,500; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1372,'Right_Epsilon_C','Light Epsilon',5,1,NULL,0,'229',NULL,1,0,0x000444A2,63,2,34,4,'1',0,7,'bonus bAtkEle,Ele_Holy; skill "AL_HEAL",3; bonus2 bAddRace,RC_Demon,3; bonus bStr,10; bonus bSpeedRate,25; /*Gold PC Room: bonus bBaseAtk,10; bonus bMatk,10; */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1373,'Brood_Axe_C','Refined Bloody Axe',5,2,NULL,0,'205',NULL,1,0,0x000444A2,63,2,34,4,'0',0,7,'bonus bStr,20; bonus bMatkRate,20; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1374,'Tomahawk_C','Tomahawk',5,2,NULL,0,'200',NULL,1,0,0x000444A2,63,2,34,4,'0',0,7,'bonus bAtkEle,Ele_Wind; skill "ITM_TOMAHAWK",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1375,'Berdysz','Berdysz',5,20,NULL,2500,'200',NULL,1,2,0x000444A2,18,2,34,3,'70',1,7,'bonus2 bSubSize,Size_Medium,13; bonus2 bSubSize,Size_Large,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1376,'Heart_Breaker','Heart Breaker',5,20,NULL,2000,'175',NULL,1,1,0x000444A2,18,2,34,4,'70',1,7,'bonus bCritical,20+getrefine(); bonus bAspdRate,5; if((Class==Job_Whitesmith)||(Class==Job_Creator)||(Class==Job_Mechanic)||(Class==Job_Mechanic_T)||(Class==Job_Genetic)||(Class==Job_Genetic_T)) bonus3 bAutoSpell,"BS_HAMMERFALL",3,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1377,'Hurricane_Fury','Hurricane\'s Fury',5,20,NULL,3500,'332',NULL,1,1,0x000444A2,18,2,34,4,'80',1,7,'.@r = getrefine(); bonus2 bSubSize,Size_Medium,10+.@r; bonus bAspdRate,.@r; bonus3 bAutoSpell,"NPC_PULSESTRIKE",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1378,'Great_Axe_C','Refined Great Axe',5,1,NULL,0,'215',NULL,1,0,0x000444A2,63,2,34,4,'0',0,7,'bonus bStr,5; bonus bHit,20; bonus2 bAddSkillBlow,"MC_MAMMONITE",5; bonus2 bAddEff,Eff_Stun,2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1379,'BF_Two_Handed_Axe1','Valorous Insane Battle Axe',5,20,NULL,0,'200',NULL,1,0,0x000444A2,63,2,34,3,'80',1,7,'bonus bStr,3; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1380,'BF_Two_Handed_Axe2','Brave Insane Battle Axe',5,20,NULL,0,'200',NULL,1,0,0x000444A2,63,2,34,3,'80',1,7,'bonus bStr,3; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; autobonus "{ bonus bBreakArmorRate,10000; }",20,3000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }"; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1381,'N_Battle_Axe','Novice Battle Axe',5,0,NULL,0,'100',NULL,1,3,0x000444A2,63,2,34,1,'3',0,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1382,'Krieger_Twohand_Axe1','Glorious Two-Handed Axe',5,20,NULL,0,'220',NULL,1,0,0x000444A2,63,2,34,4,'80',1,7,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreDefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-3,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-3,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,50; } if(.@r>8) { bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,100; bonus4 bAutoSpellOnSkill,"MC_MAMMONITE","NPC_CRITICALWOUND",2,200; bonus4 bAutoSpellOnSkill,"WS_CARTTERMINATION","NPC_CRITICALWOUND",2,200; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1383,'Holy_Celestial_Axe','Celestial Axe',5,20,NULL,1500,'200',NULL,1,0,0x000444A2,63,2,34,4,'60',1,7,'bonus bAtkEle,Ele_Holy; bonus bVit,10; bonus2 bAddRace,RC_Undead,10; bonus3 bAutoSpell,"AL_BLESSING",5,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1384,'Veteran_Axe','Veteran Axe',5,10000,NULL,3000,'250',NULL,1,2,0x000444A2,63,2,34,3,'80',1,7,'if(getskilllv("BS_DAGGER")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_SWORD")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_TWOHANDSWORD")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_KNUCKLE")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_SPEAR")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_AXE")==3) { bonus bBaseAtk,10; } if(getskilllv("BS_MACE")==3) { bonus bBaseAtk,10; } bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1385,'Bradium_Stonehammer','Bradium Stone Hammer',5,20,NULL,2700,'210',NULL,1,0,0x000444A2,18,2,34,4,'75',1,7,'bonus3 bAddEffOnSkill,"BS_HAMMERFALL",Eff_Stun,500+(200*getrefine());',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1386,'Doom_Slayer_I','Doom Slayer',5,0,NULL,0,'20',NULL,1,0,0x000444A2,63,2,34,4,'0',0,7,'if(readparam(bStr)>=95){ bonus bBaseAtk,400; bonus2 bAddEff,Eff_Stun,3000; bonus bAspdRate,-25; bonus bUseSPrate,100; bonus bBreakArmorRate,500; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1387,'Giant_Axe','Giant Axe',5,20,NULL,4000,'330',NULL,1,1,0x000444A2,18,2,34,3,'50',1,7,'bonus2 bSkillAtk,"WS_CARTTERMINATION",15; if(readparam(bStr)>=95) { bonus bHit,10; bonus bAspdRate,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1388,'Two_Handed_Axe_C','Two-Handed Axe',5,0,NULL,0,'220',NULL,1,0,0x000444A2,63,2,34,3,'1',0,7,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1389,'E_Tomahawk_C','Tomahawk',5,2,NULL,0,'200',NULL,1,0,0x000444A2,63,2,34,4,'0',0,7,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1390,'E_Right_Epsilon_C','Light Epsilon',5,1,NULL,0,'229',NULL,1,0,0x000444A2,63,2,34,4,'1',0,7,'bonus bAtkEle,Ele_Holy; bonus bStr,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1391,'P_Two_Handed_Axe1','Eden Two-Handed Axe I',5,0,NULL,0,'195',NULL,1,0,0x000444A2,63,2,34,3,'60',0,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1392,'Ygnus_Stale','Ignus Steel',5,56000,NULL,1900,'250',NULL,1,1,0x000444A2,63,2,34,4,'95',1,7,'bonus bAtkEle,Ele_Fire; bonus bUnbreakableWeapon; bonus2 bAddEff,Eff_Burning,300; bonus2 bAddEff2,Eff_Burning,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1393,'End_Sektura','End Sectora',5,56000,NULL,1900,'250',NULL,1,1,0x000444A2,63,2,34,4,'95',1,7,'bonus bAtkEle,Ele_Water; bonus bUnbreakableWeapon; bonus2 bAddEff,Eff_Crystalize,300; bonus2 bAddEff2,Eff_Crystalize,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1394,'Upg_Two_Handed_Axe','Upg Two Handed Axe',5,20,NULL,2000,'110',NULL,1,1,0x000444A2,63,2,34,3,'1',1,7,'bonus bBaseAtk,(getrefine()*14); if(BaseLevel>70) bonus bBaseAtk,(((BaseLevel-70)/10)*10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1395,'Velum_Buster','Vellum Buster',5,20,NULL,2500,'50',NULL,1,0,0x000444A2,63,2,34,4,'95',1,7,'bonus bUnbreakableWeapon; bonus3 bSPVanishRaceRate,RC_Player,1000,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1396,'Velum_Guillotine','Vellum Guillotine',5,20,NULL,5500,'300',NULL,1,0,0x000444A2,63,2,34,4,'95',1,7,'bonus bUnbreakableWeapon; bonus2 bAddRace,RC_Player,40; bonus2 bIgnoreDefRaceRate,RC_Player,30; .@r = getrefine(); if(.@r>=6) { bonus2 bSkillAtk,"NC_AXEBOOMERANG",80; bonus2 bSkillAtk,"NC_POWERSWING",80; } if(.@r>=9) { bonus2 bAddRace,RC_Player,60; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1397,'Bradium_Stonehammer_','Bradium Stonehammer',5,20,NULL,2700,'210',NULL,1,2,0x000444A2,63,2,34,4,'75',1,7,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1398,'Metal_Two_Handed_Axe','Metal Two Handed Axe',5,20,NULL,0,'105',NULL,1,1,0x000444A2,63,2,34,3,'1',1,7,'bonus bUnbreakableWeapon; bonus bBaseAtk,(getrefine()*7); .@i = min(BaseLevel/10,12); if(.@i>2) bonus bBaseAtk,((.@i-2)*5);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1399,'TE_Woe_Two_Handed_Axe','TE Woe Two Handed Axe',5,0,NULL,0,'150',NULL,1,0,0x000444A2,63,2,34,3,'40',1,7,'bonus bUnbreakableWeapon; bonus2 bAddRace,RC_Player,40; bonus2 bAddEff,Eff_Stun,3000;',NULL,NULL);
#===================================================================
# 1-Handed Spears
#===================================================================
REPLACE INTO `item_db_re` VALUES (1400,'Spear_of_Vicious_Mind','Spear of Vicious Mind',5,20,NULL,1400,'140',NULL,3,1,0x00004082,63,2,2,4,'160',1,4,'bonus bAtk,pow(min(getrefine(),15),2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1401,'Javelin','Javelin',5,150,NULL,700,'28',NULL,3,3,0x00004082,63,2,2,1,'4',1,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1402,'Javelin_','Javelin',5,150,NULL,700,'28',NULL,3,4,0x00004082,63,2,2,1,'4',1,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1403,'Javelin__','Javelin',5,150,NULL,700,'28',NULL,3,0,0x00004082,63,2,2,1,'4',1,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1404,'Spear','Spear',5,1700,NULL,850,'44',NULL,3,3,0x00004082,63,2,2,1,'4',1,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1405,'Spear_','Spear',5,1700,NULL,850,'44',NULL,3,4,0x00004082,63,2,2,1,'4',1,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1406,'Spear__','Spear',5,1700,NULL,850,'44',NULL,3,0,0x00004082,63,2,2,1,'4',1,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1407,'Pike','Pike',5,3450,NULL,1000,'60',NULL,3,3,0x00004082,63,2,2,1,'4',1,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1408,'Pike_','Pike',5,3450,NULL,1000,'60',NULL,3,4,0x00004082,63,2,2,1,'4',1,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1409,'Pike__','Pike',5,3450,NULL,1000,'60',NULL,3,0,0x00004082,63,2,2,1,'4',1,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1410,'Lance','Lance',5,60000,NULL,2500,'185',NULL,3,0,0x00004082,63,2,34,3,'33',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1411,'Lance_','Lance',5,60000,NULL,2500,'185',NULL,3,0,0x00004082,63,2,34,3,'33',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1412,'Lance__','Lance',5,60000,NULL,2500,'185',NULL,3,0,0x00004082,63,2,34,3,'33',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1413,'Gungnir','Gungnir',5,20,NULL,500,'120',NULL,3,0,0x00004082,63,2,2,4,'4',1,4,'bonus bAtkEle,Ele_Wind; bonus bPerfectHitRate,25; bonus bHit,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1414,'Gelerdria','Gelerdria',5,20,NULL,700,'145',NULL,3,0,0x00004082,63,2,2,4,'48',1,4,'bonus bAtkEle,Ele_Earth; bonus bMaxHP,800; bonus bMaxSP,-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1415,'Skewer','Brocca',5,20,NULL,850,'100',NULL,3,0,0x00004082,63,2,2,4,'48',1,4,'bonus bIgnoreDefClass,Class_Normal; bonus2 bAddEle,Ele_Neutral,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1416,'Tjungkuletti','Tjungkuletti',5,20,NULL,1000,'100',NULL,3,0,0x00004082,63,2,2,4,'48',1,4,'bonus bSPDrainValue,1; bonus bSPGainValue,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1417,'Pole_Axe','Pole Axe',5,20,NULL,3800,'160',NULL,3,1,0x00004082,63,2,2,3,'71',1,4,'bonus bStr,1; bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1418,'Gungnir_','Gungnir',5,20,NULL,500,'120',NULL,3,2,0x00004082,63,2,2,4,'4',1,4,'bonus bAtkEle,Ele_Wind; bonus bPerfectHitRate,25; bonus bHit,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1419,'Pole_Axe_C','Pole Axe',5,1,NULL,4800,'195',NULL,3,0,0x00004082,63,2,2,3,'1',0,4,'bonus bStr,1; bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1420,'Long_Horn','Long Horn',5,20,NULL,1000,'150',NULL,3,1,0x00004082,18,2,2,4,'65',1,4,'bonus bAtkEle,Ele_Holy; bonus2 bAddEff,Eff_Bleeding,500; skill "TF_DETOXIFY",1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1421,'Battle_Hook','Battle Hook',5,20,NULL,900,'140',NULL,3,1,0x00004082,18,2,2,4,'65',1,4,'bonus2 bAddEff,Eff_Stun,500; bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20; skill "KN_PIERCE",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1422,'Hunting_Spear','Hunting Spear',5,20,NULL,4200,'180',NULL,3,1,0x00004082,18,2,2,4,'60',1,4,'bonus bIgnoreDefRace,RC_Brute; bonus3 bAddMonsterDropItem,517,RC_Brute,1000; bonus3 bAutoSpell,"LK_JOINTBEAT",3,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1423,'Pole_XO','Pole XO',5,20,NULL,0,'120',NULL,3,0,0x00004082,63,2,2,1,'0',0,4,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1424,'Skewer_C','Refined Brocca',5,1,NULL,0,'149',NULL,3,0,0x00004082,63,2,2,4,'0',0,4,'bonus bIgnoreDefClass,Class_Normal; bonus2 bAddSize,Size_Medium,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1425,'BF_Spear1','Assaulter Spear',5,20,NULL,0,'60',NULL,3,0,0x00004082,63,2,2,3,'80',1,4,'bonus bStr,2; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; if(BaseJob==Job_Crusader) bonus bAspdRate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1426,'Krieger_Onehand_Spear1','Glorious Spear',5,20,NULL,0,'130',NULL,3,0,0x00004082,63,2,2,4,'80',1,4,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; bonus bAspdRate,10; } if(.@r>8) { if(BaseJob==Job_Knight) bonus4 bAutoSpellOnSkill,"KN_PIERCE","NPC_CRITICALWOUND",2,200; else if(BaseJob==Job_Crusader) bonus3 bAutoSpell,"PA_PRESSURE",5,100; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1427,'Spear_Of_Excellent','Spear Of Excellent',5,20,NULL,0,'160',NULL,3,0,0x00004082,63,2,2,3,'0',0,4,'bonus2 bSkillAtk,"SM_MAGNUM",25; bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1428,'Long_Horn_M','Long Horn',5,20,NULL,1000,'150',NULL,3,1,0x00004082,18,2,2,4,'65',1,4,'bonus bAtkEle,Ele_Holy; bonus2 bAddEff,Eff_Bleeding,500; skill "TF_DETOXIFY",1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1429,'Hunting_Spear_M','Hunting Spear',5,20,NULL,4200,'180',NULL,3,1,0x00004082,18,2,2,4,'60',1,4,'bonus bIgnoreDefRace,RC_Brute; bonus3 bAddMonsterDropItem,517,RC_Brute,1000; bonus3 bAutoSpell,"LK_JOINTBEAT",3,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1430,'Pike_C','Pike',5,0,NULL,0,'74',NULL,3,0,0x00004082,63,2,2,1,'1',0,4,'bonus2 bAddSize,Size_All,70;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1431,'F_Pole_Axe_C','Pole Axe',5,1,NULL,4800,'195',NULL,3,0,0x00004082,63,2,2,3,'1',0,4,'bonus bStr,1; bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1432,'E_Pole_Axe_C','Pole Axe',5,1,NULL,4800,'195',NULL,3,0,0x00004082,63,2,2,3,'1',0,4,'bonus bStr,1; bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1433,'Imperial_Spear','Imperial Spear',5,20,NULL,1800,'180:40',NULL,3,1,0x00004082,63,2,2,3,'102',1,4,'.@r = getrefine(); bonus2 bSkillAtk,"LG_CANNONSPEAR",20+(.@r/2*3); bonus2 bSkillAtk,"LG_BANISHINGPOINT",20+(.@r/2*3);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1434,'P_Sphere1','Eden Spear I',5,0,NULL,0,'165',NULL,3,0,0x00004082,63,2,2,3,'60',0,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1435,'Cannon_Spear','Cannon Spear',5,56000,NULL,1600,'180',NULL,3,1,0x00004000,63,2,2,4,'100',1,4,'bonus bMaxSP,-100; bonus2 bSkillAtk,"LG_CANNONSPEAR",10; bonus bBaseAtk,(getrefine()/3);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1436,'Velum_Spear','Vellum Spear',5,20,NULL,850,'150',NULL,3,0,0x00004082,63,2,2,4,'95',1,4,'bonus2 bAddRace,RC_Player,60; .@r = getrefine(); if(.@r>=6) { bonus2 bSkillAtk,"RK_HUNDREDSPEAR",80; bonus2 bSkillAtk,"LG_PINPOINTATTACK",80; } if(.@r>=9) { bonus2 bAddRace,RC_Player,30; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1437,'TE_Woe_Pike','TE Woe Pike',5,0,NULL,0,'100',NULL,3,0,0x00004082,63,2,2,3,'40',1,4,'bonus2 bAddRace,RC_Player,40; bonus2 bAddEff,Eff_Curse,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1438,'Thanos_Spear','Thanos Spear',5,10,NULL,3000,'150:100',NULL,3,1,0x00004082,56,2,2,4,'120',1,4,'bonus bInt,6; bonus bVit,6; bonus bLuk,-6; bonus2 bHPDrainRate,50,5; bonus2 bSPDrainRate,10,5; bonus2 bHPLossRate,100,10000;',NULL,'heal -1000,0;');
REPLACE INTO `item_db_re` VALUES (1439,'Half_BF_Spear1','Half BF Spear1',5,20,NULL,0,'60',NULL,3,0,0x00004082,63,2,2,3,'80',1,4,'bonus bStr,2; bonus2 bAddRace,RC_DemiHuman,45; bonus2 bAddRace,RC_Player,45; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,10; bonus2 bIgnoreDefRaceRate,RC_Player,10; bonus bUnbreakableWeapon; if(BaseJob==Job_Crusader) bonus bAspdRate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1440,'Battle_Hook_','Battle Hook',5,20,NULL,900,'140',NULL,3,3,0x00004082,18,2,2,4,'65',1,4,'bonus2 bAddEff,Eff_Stun,500; bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20; skill "KN_PIERCE",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1441,'Ru_Blue_Spear','Blue Spear',5,10,NULL,1200,'180:170',NULL,3,1,0x00004000,56,2,2,3,'100',1,4,'bonus bDex,5; bonus bInt,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1442,'Ru_Gold_Spear','Ru Gold Spear',5,0,NULL,1200,'180',NULL,3,2,0x00004000,56,2,2,3,'120',1,4,'bonus bStr,8; bonus bAgi,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1443,'Crimson_Spear','Crimson Spear',5,20,NULL,900,'90',NULL,3,2,0x00004082,63,2,2,3,'70',1,4,'.@r = getrefine(); bonus bBaseAtk,((BaseLevel/10)*5)+(.@r<=15?pow(.@r,2):225);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1446,'Requiem_Spear','Requiem Spear',5,20,NULL,1000,'130',NULL,3,NULL,0x00004080,63,2,2,4,'100',1,4,'.@r = getrefine(); .@b = 40; bonus bUnbreakableWeapon; if(.@r>=5){ .@b += (.@r-5)*15+20; } bonus2 bAddRace2,RC2_BioLab,.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1447,'Poison_Forged_Spear','Poison Forged Spear',5,0,NULL,500,'150',NULL,3,3,0x00004080,58,2,2,4,'100',1,4,'bonus bAtkEle,Ele_Poison; bonus bCritical,10; skill "TF_DOUBLE",5; bonus bDoubleRate,25; bonus2 bAddEff,Eff_Poison,1000; bonus2 bAddEff2,Eff_Poison,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1449,'Gelerdria_','Gelerdria',5,20,NULL,700,'145',NULL,3,3,0x00004082,63,2,2,4,'48',1,4,'bonus bAtkEle,Ele_Earth; bonus bMaxHP,800; bonus bMaxSP,-50;',NULL,NULL);
#===================================================================
# 2-Handed Spears
#===================================================================
REPLACE INTO `item_db_re` VALUES (1450,'Lance_of_Vicious_Mind','Lance of Vicious Mind',5,20,NULL,2250,'225',NULL,3,1,0x00004082,63,2,34,4,'160',1,5,'bonus bAtk,pow(min(getrefine(),15),2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1451,'Guisarme','Guisarme',5,13000,NULL,1000,'84',NULL,3,2,0x00004082,63,2,34,2,'18',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1452,'Guisarme_','Guisarme',5,13000,NULL,1000,'84',NULL,3,3,0x00004082,63,2,34,2,'18',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1453,'Guisarme__','Guisarme',5,13000,NULL,1000,'84',NULL,3,0,0x00004082,63,2,34,2,'18',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1454,'Glaive','Glaive',5,20000,NULL,1200,'104',NULL,3,2,0x00004082,63,2,34,2,'18',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1455,'Glaive_','Glaive',5,20000,NULL,1200,'104',NULL,3,3,0x00004082,63,2,34,2,'18',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1456,'Glaive__','Glaive',5,20000,NULL,1200,'104',NULL,3,0,0x00004082,63,2,34,2,'18',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1457,'Partizan','Partizan',5,27000,NULL,2000,'124',NULL,3,1,0x00004082,63,2,34,2,'18',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1458,'Partizan_','Partizan',5,27000,NULL,2000,'124',NULL,3,2,0x00004082,63,2,34,2,'18',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1459,'Partizan__','Partizan',5,27000,NULL,2000,'124',NULL,3,0,0x00004082,63,2,34,2,'18',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1460,'Trident','Trident',5,51000,NULL,1200,'150',NULL,3,2,0x00004082,63,2,34,3,'33',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1461,'Trident_','Trident',5,51000,NULL,1200,'150',NULL,3,3,0x00004082,63,2,34,3,'33',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1462,'Trident__','Trident',5,51000,NULL,1200,'150',NULL,3,0,0x00004082,63,2,34,3,'33',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1463,'Halberd','Halberd',5,54000,NULL,2500,'165',NULL,3,1,0x00004082,63,2,34,3,'33',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1464,'Halberd_','Halberd',5,54000,NULL,2500,'165',NULL,3,2,0x00004082,63,2,34,3,'33',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1465,'Halberd__','Halberd',5,54000,NULL,2500,'165',NULL,3,0,0x00004082,63,2,34,3,'33',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1466,'Crescent_Scythe','Crescent Scythe',5,20,NULL,2500,'180',NULL,3,0,0x00004082,63,2,34,4,'48',1,5,'bonus bCritical,30; bonus bHit,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1467,'Bill_Guisarme','Bill Guisarme',5,20,NULL,1000,'183',NULL,3,0,0x00004082,63,2,34,4,'48',1,5,'bonus2 bAddRace,RC_Brute,10; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1468,'Zephyrus','Zephyrus',5,20,NULL,2000,'170',NULL,3,0,0x00004082,63,2,34,4,'48',1,5,'bonus bAtkEle,Ele_Wind; bonus2 bAddEff,Eff_Silence,200; bonus3 bAutoSpell,"MG_THUNDERSTORM",3,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1469,'Longinus\'s_Spear','Longinus\'s Spear',5,20,NULL,2500,'180',NULL,3,0,0x00004082,63,2,34,4,'48',1,5,'bonus bAtkEle,Ele_Dark; bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus2 bAddRace,RC_Angel,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1470,'Brionac','Brionac',5,20,NULL,3000,'190',NULL,3,0,0x00004082,63,2,34,4,'48',1,5,'bonus bAtkEle,Ele_Holy; skill "AL_HEAL",5; bonus3 bAutoSpell,"MG_SOULSTRIKE",3,100; bonus2 bAddClass,Class_Boss,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1471,'Hell_Fire','Hellfire',5,20,NULL,3500,'200',NULL,3,0,0x00004082,63,2,34,4,'48',1,5,'bonus bAtkEle,Ele_Fire; bonus3 bAutoSpell,"MG_FIREBALL",5,100; bonus bStr,3;',NULL,NULL);
#===================================================================
# 2-Handed Staffs
#===================================================================
REPLACE INTO `item_db_re` VALUES (1472,'Staff_Of_Soul','Soul Staff',5,20,NULL,1400,'25:200',NULL,1,0,0x00810204,63,2,34,3,'73',1,23,'bonus bInt,5; bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1473,'Wizardy_Staff','Wizardry Staff',5,20,NULL,2400,'120:200',NULL,1,0,0x00810204,63,2,34,4,'90',1,23,'bonus bInt,6; bonus bDex,2;',NULL,NULL);
#===================================================================
# 2-Handed Spears
#===================================================================
REPLACE INTO `item_db_re` VALUES (1474,'Gae_Bolg','Gae Bolg',5,20,NULL,2000,'160',NULL,3,0,0x00004082,63,2,34,4,'60',1,5,'bonus bIgnoreDefRace,RC_Dragon; bonus2 bAddClass,Class_Boss,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1475,'Horseback_Lance','Equestrian\'s Spear',5,20,NULL,3700,'200',NULL,4,0,0x00004082,63,2,34,4,'75',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1476,'Crescent_Scythe_','Crescent Scythe',5,20,NULL,2500,'180',NULL,3,1,0x00004082,63,2,34,4,'48',1,5,'bonus bCritical,30; bonus bHit,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1477,'Spectral_Spear','Spectral Spear',5,20,NULL,2000,'170',NULL,3,0,0x00004082,63,2,34,4,'75',1,5,'bonus2 bAddEle,Ele_Dark,20; bonus2 bAddRace,RC_Demon,20; bonus2 bAddRace,RC_Undead,20; bonus2 bSubEle,Ele_Dark,10; bonus2 bSubEle,Ele_Undead,10; bonus2 bSubRace,RC_Demon,10; bonus2 bAddEff2,Eff_Confusion,1000; bonus bHPGainValue,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1478,'Ahlspiess','Ahlspiess',5,20,NULL,1000,'120',NULL,3,0,0x00004080,63,2,34,4,'65',1,5,'bonus bIgnoreDefClass,Class_Normal; bonus bIgnoreDefClass,Class_Boss; bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus3 bAutoSpell,"KN_PIERCE",5,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1479,'Spectral_Spear_','Spectral Spear',5,20,NULL,2000,'170',NULL,3,1,0x00004082,63,2,34,4,'75',1,5,'bonus2 bAddEle,Ele_Dark,20; bonus2 bAddRace,RC_Demon,20; bonus2 bAddRace,RC_Undead,20; bonus2 bSubEle,Ele_Dark,10; bonus2 bSubEle,Ele_Undead,10; bonus2 bSubRace,RC_Demon,10; bonus2 bAddEff2,Eff_Confusion,1000; bonus bHPGainValue,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1480,'Gae_Bolg_','Gae Bolg',5,20,NULL,2000,'160',NULL,3,2,0x00004082,63,2,34,4,'60',1,5,'bonus bIgnoreDefRace,RC_Dragon; bonus2 bAddClass,Class_Boss,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1481,'Zephyrus_','Zephyrus',5,20,NULL,2000,'170',NULL,3,3,0x00004082,63,2,34,4,'48',1,5,'bonus bAtkEle,Ele_Wind; bonus2 bAddEff,Eff_Silence,200; bonus3 bAutoSpell,"MG_THUNDERSTORM",3,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1482,'BF_Lance1','Assaulter Lance',5,20,NULL,0,'160',NULL,3,0,0x00004082,63,2,34,3,'80',1,5,'bonus bStr,2; bonus2 bAddRace,RC_DemiHuman,25; bonus2 bAddRace,RC_Player,25; bonus bIgnoreDefRace,RC_DemiHuman; bonus bIgnoreDefRace,RC_Player; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1483,'Ivory_Lance','Ivory Lance',5,20,NULL,1000,'160',NULL,3,1,0x00004082,18,2,34,3,'50',1,5,'bonus bAgi,2; bonus bAspdRate,3; bonus2 bAddEff,Eff_Bleeding,300; bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,30; skill "KN_SPEARSTAB",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1484,'Cardo','Cardo',5,20,NULL,5600,'150',NULL,3,1,0x00000080,18,2,34,4,'70',1,5,'bonus bAspdRate,-10; bonus bDef,getrefine()/2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1485,'Battle_Fork','Battle Fork',5,20,NULL,700,'112',NULL,3,4,0x00004082,18,2,34,2,'50',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1486,'Krieger_Twohand_Spear1','Glorious Lance',5,20,NULL,0,'220',NULL,3,0,0x00004082,63,2,34,4,'80',1,5,'bonus2 bAddRace,RC_DemiHuman,70; bonus2 bAddRace,RC_Player,70; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreDefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(.@r>8) { if(BaseJob==Job_Knight) bonus4 bAutoSpellOnSkill,"KN_PIERCE","NPC_CRITICALWOUND",2,200; else if(BaseJob==Job_Crusader) bonus3 bAutoSpell,"PA_PRESSURE",5,200; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1487,'Lance_C','Lance',5,0,NULL,0,'220',NULL,3,0,0x00004082,63,2,34,3,'1',0,5,'bonus2 bAddSize,Size_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1488,'Ahlspiess_C','Ahlspiess',5,20,NULL,0,'135',NULL,3,0,0x00004080,63,2,34,4,'1',1,5,'bonus bIgnoreDefClass,Class_Normal; bonus bIgnoreDefClass,Class_Boss; bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus3 bAutoSpell,"KN_PIERCE",5,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1489,'Spearfish_','Marlin',5,0,NULL,0,'220',NULL,3,0,0x00004082,18,2,34,1,'50',0,5,'bonus bUnbreakableWeapon; bonus3 bAddEffOnSkill,"KN_PIERCE",Eff_Bleeding,1000; bonus3 bAddEffOnSkill,"LK_SPIRALPIERCE",Eff_Bleeding,1000; bonus2 bSkillAtk,"LK_SPIRALPIERCE",100; bonus2 bSkillAtk,"LG_INSPIRATION",50; if(BaseLevel>99) { bonus bBaseAtk,30; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1490,'Giant_Lance','Gigantic Lance',5,20,NULL,20000,'20',NULL,3,0,0x00000080,63,2,34,4,'140',1,5,'bonus bAspd,-10; bonus2 bSkillCooldown,"LK_SPIRALPIERCE",20000; if(readparam(bStr)>=120){ bonus bBaseAtk,300; }',NULL,'heal 0,-600;');
REPLACE INTO `item_db_re` VALUES (1491,'Upg_Lance','Upg Lance',5,20,NULL,1500,'105',NULL,3,1,0x00004082,63,2,34,3,'1',1,5,'bonus bBaseAtk,(getrefine()*12); if(BaseLevel>70) bonus bBaseAtk,(((BaseLevel-70)/10)*10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1492,'Velum_Glaive','Vellum Glaive',5,20,NULL,4500,'250',NULL,3,0,0x00004082,63,2,34,4,'95',1,5,'bonus2 bAddRace,RC_Player,80; .@r = getrefine(); if(.@r>=6) { bonus2 bSkillAtk,"LK_SPIRALPIERCE",100; bonus2 bSkillAtk,"LG_OVERBRAND",50; } if(.@r>=9) { autobonus2 "{ bonus bShortWeaponDamageReturn,20; bonus bMagicDamageReturn,20; }",100,2000,BF_WEAPON|BF_MAGIC,"{ specialeffect2 EF_REFLECTSHIELD; }"; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1493,'Metal_Lance','Metal Lance',5,20,NULL,0,'100',NULL,3,1,0x00004082,63,2,34,3,'1',1,5,'bonus bBaseAtk,(getrefine()*6); .@i = min(BaseLevel/10,12); if(.@i>2) bonus bBaseAtk,((.@i-2)*5);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1494,'Undine_Spear','Spear Of Odin',5,50000,NULL,3800,'190',NULL,3,3,0x00004082,63,2,34,4,'105',1,5,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1495,'TE_Woe_Lance','TE Woe Lance',5,0,NULL,0,'150',NULL,3,0,0x00004082,63,2,34,3,'40',1,5,'bonus2 bAddRace,RC_Player,40; bonus2 bAddEff,Eff_Blind,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1496,'Thanos_Long_Spear','Thanos Long Spear',5,10,NULL,3750,'250:50',NULL,3,1,0x00004082,56,2,34,4,'120',1,5,'bonus bInt,6; bonus bVit,6; bonus bLuk,-6; bonus2 bHPDrainRate,50,5; bonus2 bSPDrainRate,10,5; bonus2 bHPLossRate,100,10000;',NULL,'heal -1000,0;');
REPLACE INTO `item_db_re` VALUES (1497,'Hell_Fire_','Hellfire',5,20,NULL,3500,'200',NULL,3,3,0x00004082,63,2,34,4,'48',1,5,'bonus bAtkEle,Ele_Fire; bonus3 bAutoSpell,"MG_FIREBALL",5,100; bonus bStr,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1498,'Crimson_Lance','Crimson Lance',5,20,NULL,1750,'175',NULL,1,2,0x00004082,63,2,34,3,'70',1,5,'.@r = getrefine(); bonus bBaseAtk,((BaseLevel/10)*5)+(.@r<=15?pow(.@r,2):225);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1499,'Requiem_Lance','Requiem Lance',5,20,NULL,1500,'220',NULL,3,NULL,0x00004080,63,2,34,4,'100',1,5,'.@r = getrefine(); .@b = 40; .@c = 5; bonus bUnbreakableWeapon; if(.@r>=5){ .@b += (.@r-5)*15+30; .@c += (.@r-5); } bonus2 bAddRace2,RC2_BioLab,.@b; bonus2 bSubRace2,RC2_BioLab,.@c;',NULL,NULL);
#===================================================================
# Maces
#===================================================================
REPLACE INTO `item_db_re` VALUES (1501,'Club','Club',5,120,NULL,700,'23',NULL,1,3,0x0004C5B3,63,2,2,1,'2',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1502,'Club_','Club',5,120,NULL,700,'23',NULL,1,4,0x0004C5B3,63,2,2,1,'2',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1503,'Club__','Club',5,120,NULL,700,'23',NULL,1,0,0x0004C5B3,63,2,2,1,'2',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1504,'Mace','Mace',5,1600,NULL,800,'37',NULL,1,3,0x0004C5B3,63,2,2,1,'2',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1505,'Mace_','Mace',5,1600,NULL,800,'37',NULL,1,4,0x0004C5B3,63,2,2,1,'2',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1506,'Mace__','Mace',5,1600,NULL,800,'37',NULL,1,0,0x0004C5B3,63,2,2,1,'2',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1507,'Smasher','Smasher',5,9000,NULL,1000,'54',NULL,1,2,0x0004C5B3,63,2,2,2,'14',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1508,'Smasher_','Smasher',5,9000,NULL,1000,'54',NULL,1,3,0x0004C5B3,63,2,2,2,'14',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1509,'Smasher__','Smasher',5,9000,NULL,1000,'54',NULL,1,3,0x0004C5B3,63,2,2,2,'14',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1510,'Flail','Flail',5,16000,NULL,900,'69',NULL,1,2,0x0004C5B2,63,2,2,2,'14',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1511,'Flail_','Flail',5,16000,NULL,900,'69',NULL,1,3,0x0004C5B2,63,2,2,2,'14',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1512,'Flail__','Flail',5,16000,NULL,900,'69',NULL,1,3,0x0004C5B2,63,2,2,2,'14',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1513,'Morning_Star','Morning Star',5,41000,NULL,1500,'110',NULL,1,1,0x0004C5B2,63,2,2,3,'27',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1514,'Morning_Star_','Morning Star',5,41000,NULL,1500,'110',NULL,1,2,0x0004C5B2,63,2,2,3,'27',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1515,'Morning_Star__','Morning Star',5,41000,NULL,1500,'110',NULL,1,2,0x0004C5B2,63,2,2,3,'27',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1516,'Sword_Mace','Sword Mace',5,50000,NULL,1200,'130',NULL,1,0,0x0004C5B2,63,2,2,3,'27',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1517,'Sword_Mace_','Sword Mace',5,50000,NULL,1200,'130',NULL,1,1,0x0004C5B2,63,2,2,3,'27',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1518,'Sword_Mace__','Sword Mace',5,50000,NULL,1200,'130',NULL,1,1,0x0004C5B2,63,2,2,3,'27',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1519,'Chain','Chain',5,23000,NULL,800,'84',NULL,1,2,0x0004C5B2,63,2,2,2,'14',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1520,'Chain_','Chain',5,23000,NULL,800,'84',NULL,1,3,0x0004C5B2,63,2,2,2,'14',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1521,'Chain__','Chain',5,23000,NULL,800,'84',NULL,1,3,0x0004C5B2,63,2,2,2,'14',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1522,'Stunner','Stunner',5,60000,NULL,2000,'140',NULL,1,0,0x00008110,63,2,2,3,'27',1,8,'bonus2 bAddEff,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1523,'Spike','Spike',5,20,NULL,700,'85',NULL,1,0,0x00008110,63,2,2,4,'40',1,8,'bonus bCritical,40; bonus bDefRate,-67; bonus bDef2Rate,-67;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1524,'Golden_Mace','Golden Mace',5,20,NULL,800,'110',NULL,1,1,0x00008110,63,2,2,4,'40',1,8,'bonus2 bAddRace,RC_Undead,10; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1525,'Long_Mace','Long Mace',5,20,NULL,800,'135',NULL,3,0,0x00008110,63,2,2,4,'40',1,8,'bonus bLongAtkDef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1526,'Slash','Slash',5,20,NULL,1000,'145',NULL,1,0,0x00008110,63,2,2,4,'40',1,8,'bonus2 bAddRace,RC_Undead,15; bonus2 bComaRace,RC_Undead,10; bonus2 bExpAddRace,RC_Undead,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1527,'Quadrille','Quadrille',5,20,NULL,900,'165',NULL,1,0,0x00008110,63,2,2,4,'40',1,8,'bonus2 bAddRace,RC_Undead,10; bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus2 bAddEle,Ele_Earth,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1528,'Grand_Cross','Grand Cross',5,20,NULL,1500,'140',NULL,1,0,0x00008110,63,2,2,4,'40',1,8,'bonus bAtkEle,Ele_Holy; bonus3 bAutoSpell,"PR_TURNUNDEAD",3,100; bonus2 bSPDrainValueRace,RC_Undead,1; bonus2 bSPGainRace,RC_Undead,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1529,'Iron_Driver','Iron Driver',5,20,NULL,3000,'155',NULL,2,0,0x00008100,63,2,2,3,'78',1,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1530,'Mjolnir','Mjolnir',5,20,NULL,6000,'350',NULL,1,0,0x000444A2,63,2,2,4,'95',0,8,'bonus bAtkEle,Ele_Wind; bonus bDex,50; bonus bStr,20; bonus bAspdRate,10; bonus3 bAutoSpell,"MG_THUNDERSTORM",10,100; autobonus "{ bonus bSplashRange,1; }",50,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1531,'Spanner','Wrench',5,20,NULL,2500,'115',NULL,1,0,0x00008110,63,2,2,3,'55',1,8,'bonus2 bAddEff,Eff_Blind,100; bonus2 bAddEff,Eff_Stun,100; bonus2 bAddEff,Eff_Poison,100; bonus2 bAddEff,Eff_Freeze,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1532,'Stunner_','Stunner',5,60000,NULL,2000,'140',NULL,1,2,0x00008110,63,2,2,3,'27',1,8,'bonus2 bAddEff,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1533,'Warrior_Balmung','Warrior\'s Balmung',5,20,NULL,1000,'170',NULL,1,0,0xFFFFFFFF,63,2,2,4,'48',1,8,'bonus bAllStats,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1534,'Spanner_C','Wrench',5,2,NULL,0,'150',NULL,1,0,0x00008110,63,2,2,3,'0',0,8,'bonus2 bAddEff,Eff_Blind,100; bonus2 bAddEff,Eff_Stun,100; bonus2 bAddEff,Eff_Poison,100; bonus2 bAddEff,Eff_Freeze,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1535,'Hollgrehenn_Hammer','Hollgrehenn\'s Hammer',5,4444,NULL,44,'4',NULL,1,1,0x0004C5B2,63,2,2,4,'44',1,8,'bonus bBreakArmorRate,100; bonus bBreakWeaponRate,100; if(readparam(bStr)>=44) { bonus bBaseAtk,44; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1536,'Good_Morning_Star','Good Morning Star',5,20,NULL,0,'120',NULL,1,0,0x0004C5B2,63,2,2,1,'0',0,8,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1537,'Quadrille_C','Refined Quadrille',5,1,NULL,0,'193',NULL,1,0,0x00008110,63,2,2,4,'0',0,8,'bonus2 bAddRace,RC_DemiHuman,30; bonus2 bAddRace,RC_Player,30; bonus2 bAddRace,RC_Demon,40; bonus2 bAddRace,RC_Undead,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1538,'Spike_','Spike',5,20,NULL,700,'85',NULL,1,2,0x00008110,63,2,2,4,'40',1,8,'bonus bCritical,40; bonus bDefRate,-67; bonus bDef2Rate,-67;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1539,'Golden_Mace_','Golden Mace',5,20,NULL,800,'110',NULL,1,2,0x00008110,63,2,2,4,'40',1,8,'bonus2 bAddRace,RC_Undead,10; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1540,'Grand_Cross_','Grand Cross',5,20,NULL,1500,'140',NULL,1,1,0x00008110,63,2,2,4,'40',1,8,'bonus bAtkEle,Ele_Holy; bonus3 bAutoSpell,"PR_TURNUNDEAD",3,100; bonus2 bSPDrainValueRace,RC_Undead,1; bonus2 bSPGainRace,RC_Undead,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1541,'Nemesis','Nemesis',5,20,NULL,900,'120',NULL,1,0,0x00008110,63,2,2,4,'60',1,8,'bonus bAtkEle,Ele_Holy; bonus2 bAddRace,RC_Undead,10; bonus2 bAddRace,RC_Demon,10; bonus3 bAutoSpell,"AL_CRUCIS",1+getrefine(),100; autobonus "{ bonus bBaseAtk,50; }",10,20000,BF_WEAPON,"{ specialeffect2 EF_BLOODDRAIN; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1542,'BF_Morning_Star1','Valorous Battlefield Morning Star',5,20,NULL,0,'105',NULL,1,0,0x0004C5B3,63,2,2,3,'80',1,8,'bonus bStr,1; bonus bDex,1; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1543,'BF_Morning_Star2','Brave Battlefield Morning Star',5,20,NULL,0,'105',NULL,1,0,0x0004C5B3,63,2,2,3,'80',1,8,'bonus bStr,1; bonus bDex,1; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus bUnbreakableWeapon; autobonus "{ bonus2 bAddEff,Eff_Stun,5000; }",10,6000,BF_WEAPON,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1544,'Lunakaligo','Lunakaligo',5,20,NULL,700,'110',NULL,1,3,0x00008110,18,2,2,3,'50',1,8,'if(readparam(bStr)>=77) { bonus bAspdRate,4; bonus2 bAddEff,Eff_Stun,1500; bonus3 bAddMonsterDropItem,12065,RC_Plant,500; bonus3 bAddMonsterDropItem,12043,RC_Brute,500; bonus3 bAddMonsterDropItem,12069,RC_Fish,500; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1545,'N_Mace','Novice Mace',5,0,NULL,0,'57',NULL,1,3,0x0004C5B3,63,2,2,1,'2',0,8,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1546,'Krieger_Onehand_Mace1','Glorious Morning Star',5,20,NULL,0,'130',NULL,1,0,0x0004C5B3,63,2,2,4,'80',1,8,'bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; bonus bAspdRate,5; } if(.@r>8) { bonus2 bAddEff,Eff_Stun,2000; bonus bAspdRate,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1547,'Mace_Of_Madness','Mace Of Madness',5,20,NULL,0,'150',NULL,1,0,0x0004C5B2,63,2,2,3,'0',0,8,'bonus2 bSkillAtk,"MC_CARTREVOLUTION",25; bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1548,'Veteran_Hammer','Veteran Hammer',5,10000,NULL,1800,'160',NULL,1,2,0x00008110,63,2,2,3,'80',1,8,'bonus bHealPower,getskilllv("AL_DP"); bonus bCritical,getskilllv("PR_MACEMASTERY")*2; bonus bInt,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1549,'Pilebuncker','Pile Bunker',5,10000,NULL,3500,'450',NULL,1,0,0x00000400,56,2,2,3,'99',1,8,NULL,NULL,NULL);
#===================================================================
# Books
#===================================================================
REPLACE INTO `item_db_re` VALUES (1550,'Book','Book',5,30000,NULL,600,'85',NULL,1,3,0x00410100,63,2,2,2,'14',1,15,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1551,'Bible','Bible',5,60000,NULL,1000,'115',NULL,1,2,0x00410100,63,2,2,3,'27',1,15,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1552,'Tablet','Tablet',5,51000,NULL,800,'125',NULL,1,1,0x00410100,63,2,2,3,'27',1,15,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1553,'Book_Of_Billows','Book of Billows',5,35000,NULL,750,'90',NULL,1,0,0x00410100,63,2,2,3,'27',1,15,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1554,'Book_Of_Mother_Earth','Book of Mother Earth',5,35000,NULL,750,'90',NULL,1,0,0x00410100,63,2,2,3,'27',1,15,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1555,'Book_Of_Blazing_Sun','Book of the Blazing Sun',5,35000,NULL,750,'90',NULL,1,0,0x00410100,63,2,2,3,'27',1,15,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1556,'Book_Of_Gust_Of_Wind','Book of Gust of Wind',5,35000,NULL,750,'90',NULL,1,0,0x00410100,63,2,2,3,'27',1,15,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1557,'Book_Of_The_Apocalypse','Book of the Apocalypse',5,60000,NULL,800,'120',NULL,1,0,0x00410100,63,2,2,4,'40',1,15,'bonus bAtkEle,Ele_Dark; bonus2 bAddEle,Ele_Holy,5; bonus2 bAddEle,Ele_Water,7; bonus2 bAddEle,Ele_Earth,7; bonus2 bAddEle,Ele_Fire,7; bonus2 bAddEle,Ele_Wind,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1558,'Girl\'s_Diary','Girl\'s Diary',5,1500,NULL,300,'60',NULL,1,1,0x00410100,63,2,2,4,'40',1,15,'bonus2 bAddDamageClass,1188,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1559,'Legacy_Of_Dragon','Legacy of Dragon',5,20,NULL,700,'130',NULL,1,0,0x00410100,63,2,2,4,'70',1,15,'bonus bInt,3; bonus bIgnoreDefRace,RC_Dragon; bonus2 bSPGainRace,RC_Dragon,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1560,'Diary_Of_Great_Sage','Sage\'s Diary',5,20,NULL,1100,'100:120',NULL,1,2,0x00410100,63,2,2,3,'60',1,15,'if(readparam(bStr)>=50) bonus bAspdRate,5; if(readparam(bInt)>=70) bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1561,'Hardback','Hardcover Book',5,20,NULL,1500,'140',NULL,1,1,0x00410100,63,2,2,4,'55',1,15,'bonus bStr,3; bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1562,'Bible_Of_Battlefield','Battlefield Textbook',5,20,NULL,700,'110',NULL,1,1,0x00410100,63,2,2,4,'80',0,15,'bonus bInt,3; bonus3 bAutoSpell,"AL_BLESSING",3+(getskilllv("AL_BLESSING")>3)*(getskilllv("AL_BLESSING")-3),20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1563,'Diary_Of_Great_Sage_C','Sage\'s Diary',5,1,NULL,0,'135:140',NULL,1,0,0x00410100,63,2,2,3,'1',0,15,'bonus bAspdRate,5; /*Gold PC Room: bonus bBaseAtk,10; bonus bMatk,10;*/',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1564,'Encyclopedia','Encyclopedia',5,20,NULL,2000,'110:100',NULL,1,2,0x00410100,63,2,2,3,'70',1,15,'bonus bInt,3; bonus bDex,2; bonus bCritical,20+((readparam(bLuk)*2)/10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1565,'Death_Note','Ledger of Death',5,20,NULL,1000,'137:100',NULL,1,2,0x00410100,63,2,2,4,'85',1,15,'bonus bStr,3; bonus bInt,3; bonus bLuk,-20; bonus2 bComaRace,RC_DemiHuman,10; bonus2 bComaRace,RC_Player,10; bonus bAspdRate,getrefine(); if(BaseJob==Job_Sage) bonus3 bAutoSpell,"NPC_HELLJUDGEMENT",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1566,'Diary_Of_Great_Basil','Diary Of Great Basil',5,20,NULL,0,'120:125',NULL,1,0,0x00410100,63,2,2,1,'0',0,15,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1567,'Hardback_C','Refined Hardcover Book',5,1,NULL,0,'168:100',NULL,1,0,0x00410100,63,2,2,4,'0',0,15,'bonus bStr,5; bonus bDex,2; bonus bMatkRate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1568,'Book_Of_Billows_','Book of Billows',5,35000,NULL,750,'90',NULL,1,3,0x00410100,63,2,2,3,'27',1,15,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1569,'Book_Of_Mother_Earth_','Book of Mother Earth',5,35000,NULL,750,'90',NULL,1,3,0x00410100,63,2,2,3,'27',1,15,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1570,'Book_Of_Blazing_Sun_','Book of Blazing Sun',5,35000,NULL,750,'90',NULL,1,3,0x00410100,63,2,2,3,'27',1,15,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1571,'Book_Of_Gust_Of_Wind_','Book of Gust of Wind',5,35000,NULL,750,'90',NULL,1,3,0x00410100,63,2,2,3,'27',1,15,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1572,'Principles_Of_Magic','Principles of Magic',5,20,NULL,300,'60:160',NULL,1,2,0x00410100,63,2,2,3,'60',1,15,'bonus bInt,3; bonus bSPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1573,'Ancient_Magic','Ancient Magic',5,20,NULL,700,'30:140',NULL,1,2,0x00410100,63,2,2,3,'70',1,15,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1574,'BF_Book1','Brave Battle Strategy Book',5,20,NULL,0,'90:125',NULL,1,0,0x00410100,63,2,2,3,'80',1,15,'bonus bStr,2; bonus bInt,1; bonus bMatkRate,15; bonus2 bAddRace,RC_DemiHuman,75; bonus2 bAddRace,RC_Player,75; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1575,'BF_Book2','Valorous Battle Strategy Book',5,20,NULL,0,'90:125',NULL,1,0,0x00410100,63,2,2,3,'80',1,15,'bonus bStr,2; bonus bInt,1; bonus bMatkRate,15; bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreMdefRaceRate,RC_Player,25; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1576,'Krieger_Book1','Glorious Tablet',5,20,NULL,0,'90:115',NULL,1,0,0x00410100,63,2,2,4,'80',1,15,'bonus bMatkRate,15; bonus2 bAddRace,RC_DemiHuman,80; bonus2 bAddRace,RC_Player,80; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreDefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(.@r>8) autobonus "{ bonus bBaseAtk,200; }",30,3000,BF_WEAPON,"{ specialeffect2 EF_BASH3D; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1577,'Krieger_Book2','Glorious Apocalypse',5,20,NULL,0,'90:115',NULL,1,0,0x00410100,63,2,2,4,'80',1,15,'bonus2 bAddRace,RC_DemiHuman,80; bonus2 bAddRace,RC_Player,80; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreDefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; if(.@r>8) { bonus bMatkRate,5; bonus bVariableCastrate,-5; bonus bDelayRate,-5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1578,'Book_Of_Prayer','Book Of Prayer',5,20,NULL,0,'140',NULL,1,0,0x00410100,63,2,2,3,'0',0,15,'bonus bVit,2; bonus bMdef,2; bonus bMaxSPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1579,'Death_Note_M','Book of the Dead',5,20,NULL,1000,'137',NULL,1,2,0x00410100,63,2,2,4,'85',1,15,'bonus bMatkRate,15; bonus bStr,3; bonus bInt,3; bonus bLuk,-20; bonus2 bComaRace,RC_DemiHuman,10; bonus2 bComaRace,RC_Player,10; bonus bAspdRate,getrefine(); if(BaseJob==Job_Sage) bonus3 bAutoSpell,"NPC_HELLJUDGEMENT",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1580,'Encyclopedia_C','Giant Encyclopedia',5,0,NULL,0,'145:100',NULL,1,0,0x00410100,63,2,2,3,'0',0,15,'bonus bMatkRate,15; bonus bInt,3; bonus bDex,2; bonus bCritical,20+((readparam(bLuk)*2)/10); bonus2 bAddSize,Size_All,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1581,'F_Diary_Of_Great_Sage_C','Diary Of Great Sage',5,1,NULL,0,'135',NULL,1,2,0x00410100,63,2,2,3,'1',0,15,'bonus bMatkRate,20; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1582,'E_Diary_Of_Great_Sage_C','Diary Of Great Sage',5,1,NULL,0,'135',NULL,1,2,0x00410100,63,2,2,3,'1',0,15,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1583,'P_Dic1','Eden Book I',5,0,NULL,0,'135:110',NULL,1,0,0x00410100,63,2,2,3,'60',0,15,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1584,'Chilly_Spell_Book','Cold Magic Book',5,56000,NULL,1000,'100:160',NULL,1,2,0x00010000,63,2,2,4,'100',1,15,'bonus bAtkEle,Ele_Water; bonus bUnbreakableWeapon; bonus bDex,1; .@r = getrefine(); bonus2 bSkillAtk,"MG_COLDBOLT",(.@r*3); bonus2 bSkillAtk,"SO_DIAMONDDUST",(.@r*3); bonus2 bSkillUseSP,"MG_COLDBOLT",-(.@r*5); bonus2 bSkillUseSP,"SO_DIAMONDDUST",-(.@r*5);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1585,'Upg_Book','Upg Book',5,20,NULL,600,'45:20',NULL,1,1,0x00410100,63,2,2,3,'1',1,15,'.@r = getrefine(); bonus bBaseAtk,(.@r*10); bonus bMatk,(.@r*5); if(BaseLevel>70) bonus bMatk,(((BaseLevel-70)/10)*5);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1586,'Velum_Bible','Vellum Bible',5,20,NULL,600,'110:125',NULL,1,0,0x00410100,63,2,2,4,'95',1,15,'if(BaseLevel>104) { bonus bHealPower,(BaseLevel/5)-20; if(getrefine()>=6) { bonus2 bSkillCooldown,"AB_LAUDAAGNUS",-3000; bonus2 bSkillCooldown,"AB_LAUDARAMUS",-3000; bonus2 bSkillCooldown,"AB_CLEARANCE",-10000; bonus2 bSkillUseSP,"AB_LAUDAAGNUS",-60; bonus2 bSkillUseSP,"AB_LAUDARAMUS",-60; bonus2 bSkillUseSP,"AB_CLEARANCE",-60; } }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1587,'Velum_Encyclopedia','Vellum Great Encyclopedia',5,20,NULL,1000,'130',NULL,1,0,0x00410100,63,2,2,4,'95',1,15,'.@r = getrefine(); bonus2 bAddRace,RC_Player,80+.@r; bonus2 bIgnoreDefRaceRate,RC_Player,30; if(.@r>8) { autobonus "{ bonus bBaseAtk,200; }",10,3000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }"; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1588,'Metal_Book','Metal Book',5,20,NULL,0,'45:10',NULL,1,1,0x00410100,63,2,2,3,'1',1,15,'.@r = getrefine(); bonus bUnbreakableWeapon; bonus bBaseAtk,(.@r*5); bonus bMatk,(.@r*2); .@i = min(BaseLevel/10,12); if(.@i>2) bonus bBaseAtk,((.@i-2)*5);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1589,'Legacy_Of_Dragon_','Legacy of Dragon',5,20,NULL,700,'130',NULL,1,2,0x00410100,63,2,2,4,'70',1,15,'bonus bInt,3; bonus bIgnoreDefRace,RC_Dragon; bonus2 bSPGainRace,RC_Dragon,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1590,'Snake_Encyclopedia','Daizenshu Dakatsu',5,60000,NULL,1500,'10:110',NULL,1,2,0x00410100,63,2,2,4,'105',1,15,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1591,'TE_Woe_Book','TE Woe Book',5,0,NULL,0,'120',NULL,1,0,0x00410100,63,2,2,3,'40',1,15,'bonus2 bAddRace,RC_Player,40; bonus2 bMagicAddRace,RC_Player,5; bonus3 bAddEff,Eff_Blind,1000,ATF_MAGIC; bonus bHPRecovRate,5; bonus bSPRecovRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1596,'Earth_Pedigree_Book','Earth Pedigree Book',5,10,NULL,400,'90:130',NULL,NULL,2,0x050100,63,2,2,NULL,'27',1,15,'.@r = getrefine(); bonus2 bSkillAtk,"WZ_HEAVENDRIVE",5+.@r; bonus2 bSkillAtk,"WZ_EARTHSPIKE",5+.@r; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1597,'Half_BF_Book2','Half BF Book2',5,20,NULL,0,'90:125',NULL,1,0,0x00410100,63,2,2,3,'80',1,15,'bonus bStr,2; bonus bInt,1; bonus2 bAddRace,RC_DemiHuman,35; bonus2 bAddRace,RC_Player,35; bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,10; bonus2 bIgnoreMdefRaceRate,RC_Player,10; bonus bUnbreakableWeapon;',NULL,NULL);
# GM Weapon
REPLACE INTO `item_db_re` VALUES (1599,'Angra_Manyu','Angra Manyu',5,1,NULL,10,'10000:10000',NULL,2,0,0xFFFFFFFF,63,2,2,1,'1',1,8,'bonus bAllStats,50; bonus bBaseAtk,3300; bonus bMatkRate,200; bonus2 bHPDrainRate,1000,100; bonus2 bSPDrainRate,1000,20; bonus bHealPower,200; bonus2 bAddClass,Class_All,100; skill "WZ_STORMGUST",10; Skill "WZ_METEOR",10; Skill "WZ_VERMILION",10; skill "GM_SANDMAN",1; bonus bVariableCastrate,-100; bonus bFixedCastrate,-100;',NULL,NULL);
#===================================================================
# 1-Handed Staffs
#===================================================================
REPLACE INTO `item_db_re` VALUES (1600,'Rod_of_Vicious_Mind','Rod of Vicious Mind',5,20,NULL,600,'60:120',NULL,1,1,0x00818315,63,2,2,4,'160',1,10,'bonus bMatk,pow(min(getrefine(),15),2); bonus bInt,5; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1601,'Rod','Rod',5,50,NULL,400,'15:30',NULL,1,3,0x00818315,63,2,2,1,'1',1,10,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1602,'Rod_','Rod',5,50,NULL,400,'15:30',NULL,1,4,0x00818315,63,2,2,1,'1',1,10,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1603,'Rod__','Rod',5,50,NULL,400,'15:30',NULL,1,0,0x00818315,63,2,2,1,'1',1,10,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1604,'Wand','Wand',5,2500,NULL,400,'25:45',NULL,1,2,0x00818315,63,2,2,2,'12',1,10,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1605,'Wand_','Wand',5,2500,NULL,400,'25:45',NULL,1,3,0x00818315,63,2,2,2,'12',1,10,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1606,'Wand__','Wand',5,2500,NULL,400,'25:45',NULL,1,0,0x00818315,63,2,2,2,'12',1,10,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1607,'Staff','Staff',5,9500,NULL,400,'40:70',NULL,1,2,0x00818314,63,2,2,2,'12',1,10,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1608,'Staff_','Staff',5,9500,NULL,400,'40:70',NULL,1,3,0x00818314,63,2,2,2,'12',1,10,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1609,'Staff__','Staff',5,9500,NULL,400,'40:70',NULL,1,0,0x00818314,63,2,2,2,'12',1,10,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1610,'Arc_Wand','Arc Wand',5,45000,NULL,400,'60:95',NULL,1,1,0x00818314,63,2,2,3,'24',1,10,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1611,'Arc_Wand_','Arc Wand',5,45000,NULL,400,'60:95',NULL,1,2,0x00818314,63,2,2,3,'24',1,10,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1612,'Arc_Wand__','Arc Wand',5,45000,NULL,400,'60:95',NULL,1,0,0x00818314,63,2,2,3,'24',1,10,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1613,'Mighty_Staff','Mighty Staff',5,20,NULL,700,'130:100',NULL,1,0,0x00818314,63,2,2,3,'24',1,10,'bonus bStr,10; bonus bSPDrainValue,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1614,'Blessed_Wand','Wand of Occult',5,20,NULL,700,'75:105',NULL,1,0,0x00818314,63,2,2,3,'24',1,10,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1615,'Bone_Wand','Evil Bone Wand',5,20,NULL,700,'40:110',NULL,1,0,0x00818314,63,2,2,3,'24',1,10,'bonus bInt,4; bonus bAtkEle,Ele_Undead;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1616,'Staff_Of_Wing','Wing Staff',5,20,NULL,500,'60:115',NULL,1,0,0x00810204,63,2,2,4,'40',1,10,'bonus bVariableCastrate,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1617,'Survival_Rod','Survivor\'s Rod',5,85000,NULL,1000,'50:120',NULL,1,0,0x00818314,63,2,2,3,'24',1,10,'bonus bDex,2; bonus bMaxHP,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1618,'Survival_Rod_','Survivor\'s Rod',5,85000,NULL,1000,'50:120',NULL,1,1,0x00818314,63,2,2,3,'24',1,10,'bonus bDex,3; bonus bMaxHP,400;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1619,'Survival_Rod2','Survivor\'s Rod',5,85000,NULL,1000,'50:120',NULL,1,0,0x00818314,63,2,2,3,'24',1,10,'bonus bInt,2; bonus bMaxHP,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1620,'Survival_Rod2_','Survivor\'s Rod',5,85000,NULL,1000,'50:120',NULL,1,1,0x00818314,63,2,2,3,'24',1,10,'bonus bInt,3; bonus bMaxHP,400;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1621,'Hypnotist\'s_Staff','Hypnotist\'s Staff',5,43000,NULL,500,'70:120',NULL,1,1,0x00000001,63,2,2,3,'30',1,10,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1622,'Hypnotist\'s_Staff_','Hypnotist\'s Staff',5,20,NULL,500,'70:120',NULL,1,2,0x00000001,63,2,2,3,'30',1,10,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1623,'Mighty_Staff_C','Mighty Staff',5,1,NULL,0,'165:120',NULL,1,0,0x00818314,63,2,2,3,'1',0,10,'bonus bStr,10; bonus bInt,4; bonus bMatkRate,20; bonus bSPDrainValue,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1624,'Lich_Bone_Wand','Lich\'s Bone Wand',5,20,NULL,800,'60:170',NULL,1,2,0x00018314,18,2,2,3,'70',1,10,'bonus bInt,1; bonus bDex,1; bonus bAtkEle,Ele_Undead; .@r = getrefine(); bonus3 bAutoSpellWhenHit,"NPC_WIDECURSE",5,10+.@r; if(.@r>=9){ bonus bMatkRate,3; bonus bMaxSP,300; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1625,'Healing_Staff','Healing Staff',5,20,NULL,400,'10:105',NULL,1,0,0x00008110,63,2,2,3,'55',1,10,'bonus bAtkEle,Ele_Holy; bonus bHealPower,(getrefine()*3/2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1626,'Piercing_Staff','Piercing Staff',5,20,NULL,500,'80:145',NULL,1,0,0x00018314,18,2,2,3,'70',1,10,'.@r = getrefine(); bonus bInt,4; bonus2 bIgnoreMdefClassRate,Class_Normal,10+.@r; bonus2 bIgnoreMdefClassRate,Class_Boss,10+.@r;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1627,'Staffy','Staffy',5,20,NULL,0,'40:120',NULL,1,0,0x00818314,63,2,2,1,'0',0,10,'bonus bInt,4; bonus bMatkRate,15; bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1628,'Survival_Rod_C','Refined Survivor\'s Rod',5,1,NULL,0,'71:145',NULL,1,0,0x00818314,63,2,2,3,'0',0,10,'bonus bDex,4; bonus bMatkRate,20; bonus bMaxHP,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1629,'Walking_Stick','Gentleman\'s Staff',5,20,NULL,500,'40:125',NULL,1,1,0x00818314,63,2,2,4,'50',1,10,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1630,'Release_Of_Wish','Release of Wish',5,20,NULL,500,'30:125',NULL,1,0,0x00810204,63,2,2,3,'50',1,10,'bonus bInt,3; bonus bHealPower,5; autobonus "{ bonus2 bSPRegenRate,100,2000; bonus2 bHPRegenRate,50,2000; }",10,10000,BF_MAGIC,"{ specialeffect2 EF_HEAL; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1631,'Holy_Stick','Holy Stick',5,20,NULL,500,'50:140',NULL,1,1,0x00008100,63,2,2,4,'70',1,10,'bonus bAtkEle,Ele_Holy; bonus bMatkRate,15; bonus2 bVariableCastrate,"AL_HOLYLIGHT",-25; bonus2 bVariableCastrate,"PR_TURNUNDEAD",-25; bonus2 bVariableCastrate,"PR_MAGNUS",-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1632,'BF_Staff1','Warlock\'s Magic Wand',5,20,NULL,0,'70:125',NULL,1,0,0x00818314,63,2,2,3,'80',1,10,'bonus bInt,4; bonus bDex,3; bonus bMatkRate,15; bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreMdefRaceRate,RC_Player,25; bonus3 bAddEff,Eff_Stun,500,ATF_MAGIC; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1633,'BF_Staff2','Warlock\'s Battle Wand',5,20,NULL,0,'70:125',NULL,1,0,0x00818314,63,2,2,3,'80',1,10,'bonus bInt,3; bonus bDex,3; bonus bMatkRate,15; bonus2 bMagicAddRace,RC_DemiHuman,15; bonus2 bMagicAddRace,RC_Player,15; bonus3 bAddEff,Eff_Stun,500,ATF_MAGIC; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1634,'BF_Staff3','Strong Recovery Wand',5,20,NULL,0,'70:125',NULL,1,0,0x00818314,63,2,2,3,'80',1,10,'bonus bMatkRate,15; bonus bHealPower,14; bonus2 bSPRegenRate,5,10000; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1635,'BF_Staff4','Speedy Recovery Wand',5,20,NULL,0,'70:125',NULL,1,0,0x00818314,63,2,2,3,'80',1,10,'bonus bInt,3; bonus bDex,2; bonus bMatkRate,15; bonus bDelayRate,-15; bonus2 bSPRegenRate,5,10000; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1636,'Thorn_Staff','Thorn Staff of Darkness',5,20,NULL,700,'60:160',NULL,1,0,0x00018314,18,2,2,4,'75',1,10,'bonus bAtkEle,Ele_Dark; bonus bInt,3; bonus bDex,3; .@r = getrefine(); bonus2 bIgnoreMdefClassRate,Class_Normal,.@r; bonus2 bIgnoreMdefClassRate,Class_Boss,.@r; bonus bDelayRate,-(.@r*3/2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1637,'Eraser','Eraser',5,20,NULL,500,'80:170',NULL,1,0,0x00018314,18,2,2,4,'70',1,10,'bonus bInt,3; bonus bDex,2; bonus bSPrecovRate,8; bonus5 bAutoSpell,"NPC_WIDESOULDRAIN",(getrefine()>9?3:1),5,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1638,'Healing_Staff_C','Staff Of Healing',5,20,NULL,0,'10:125',NULL,1,0,0x00008110,63,2,2,3,'1',1,10,'bonus bAtkEle,Ele_Holy; bonus bMatkRate,15; bonus bHealPower,(getrefine()*3/2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1639,'N_Rod','Novice Rod',5,0,NULL,0,'15:32',NULL,1,3,0x00818315,63,2,2,1,'1',0,10,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1640,'Krieger_Onehand_Staff1','Glorious Arc Wand',5,20,NULL,0,'70:135',NULL,1,0,0x00818314,63,2,2,4,'80',1,10,'bonus2 bMagicAddRace,RC_DemiHuman,15; bonus2 bMagicAddRace,RC_Player,15; .@r = getrefine(); bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,25 + ((.@r > 5) ? 5 : 0); bonus2 bIgnoreMdefRaceRate,RC_Player,25 + ((.@r > 5) ? 5 : 0); bonus bUnbreakableWeapon; if(.@r > 8) { bonus bMatkRate,5; bonus bVariableCastrate,-5; bonus bDelayRate,-5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1641,'Krieger_Onehand_Staff2','Glorious Cure Wand',5,20,NULL,0,'70:135',NULL,1,0,0x00818314,63,2,2,4,'80',1,10,'bonus bHealPower,14; bonus bDelayRate,-10; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r > 5) { bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreMdefRaceRate,RC_Player,5; bonus bHealPower,5+(min(14,.@r)-5)*2; } if(.@r > 8) bonus5 bAutoSpellOnSkill,"AL_HEAL","AL_HEAL",10,100,1; if(.@r > 9) { bonus bHealPower,10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1642,'Staff_Of_Darkness','Staff Of Darkness',5,20,NULL,0,'100:120',NULL,1,0,0x00818314,63,2,2,2,'0',0,10,'bonus bVariableCastrate,-5; bonus bMatkRate,15; bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1643,'Dead_Tree_Cane','Dead Tree Cane',5,20,NULL,100,'100:155',NULL,1,0,0x00818314,63,2,2,4,'70',1,10,'bonus bInt,4; .@r = getrefine(); if (.@r>5) { bonus bInt,.@r-5; bonus bMaxHP,-200; bonus bMaxSP,-100; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1644,'Piercing_Staff_M','Staff of Piercing',5,20,NULL,500,'80:145',NULL,1,0,0x00018314,18,2,2,3,'70',1,10,'bonus bInt,4; bonus bMatkRate,15; .@r = getrefine(); bonus2 bIgnoreMdefClassRate,Class_Normal,10+.@r; bonus2 bIgnoreMdefClassRate,Class_Boss,10+.@r;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1645,'Lich_Bone_Wand_M','Lich\'s Bone Wand',5,20,NULL,800,'60:170',NULL,1,2,0x00018314,18,2,2,3,'70',1,10,'bonus bInt,1; bonus bDex,1; bonus bAtkEle,Ele_Undead; bonus bMatkRate,20; .@r = getrefine(); bonus3 bAutoSpellWhenHit,"NPC_WIDECURSE",5,10+.@r; if(.@r>=9){ bonus bMatkRate,3; bonus bMaxSP,300; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1646,'La\'cryma_Stick','La\'cryma Stick',5,20,NULL,500,'30:180',NULL,1,2,0x00010204,18,2,2,3,'50',1,10,'.@r = getrefine(); bonus bInt,4; bonus bMdef,.@r; bonus2 bSkillAtk,"WZ_STORMGUST",.@r; if (.@r > 9) bonus2 bVariableCastrate,"WZ_STORMGUST",-8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1647,'Croce_Staff','Croce Staff',5,20,NULL,500,'30:175',NULL,1,1,0x00008110,18,2,2,3,'50',1,10,'bonus bAtkEle,Ele_Holy; bonus bInt,4; bonus4 bAutoSpellOnSkill,"AL_HEAL","AL_BLESSING",max(getskilllv("AL_BLESSING"),1),20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1648,'Staff_Of_Bordeaux','Staff Of Bordeaux',5,20,NULL,500,'30:170',NULL,1,0,0x00010200,18,2,2,4,'50',1,10,'bonus bInt,2; bonus bDex,1; if(getskilllv("SA_DRAGONOLOGY") == 5) { bonus bUseSPrate,-15; bonus bInt,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1649,'Rafini_Staff','Laphine Staff',5,20,NULL,500,'30:180',NULL,1,0,0x00818315,63,2,2,3,'100',1,10,'bonus bFixedCastRate,-getrefine();',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1650,'P_Staff1','Eden Staff I',5,0,NULL,0,'60:125',NULL,1,0,0x00818314,63,2,2,2,'26',0,10,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1651,'P_Staff2','Eden Staff II',5,0,NULL,0,'60:150',NULL,1,0,0x00818314,63,2,2,2,'40',0,10,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1652,'Tourist_Staff','Tourist Staff',5,0,NULL,500,'35:0',NULL,1,0,0x00818315,63,2,2,1,'1',0,10,'bonus bMatkRate,15; bonus bInt,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1653,'Staff_Of_Healing_C','Staff of Healing',5,20,NULL,0,'10:100',NULL,1,0,0x00008110,63,2,2,3,'1',0,10,'bonus bAtkEle,Ele_Holy; bonus bHealPower,18;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1654,'Mental_Stick','Mental Stick',5,20,NULL,500,'40:170',NULL,1,1,0x00818315,63,2,2,3,'102',1,10,'.@r = getrefine(); if(.@r>5) { bonus2 bSkillAtk,"SO_PSYCHIC_WAVE",(.@r-5)*2; bonus bMaxHPrate,-(.@r-5)*2; } bonus2 bSkillVariableCast,"SO_PSYCHIC_WAVE",-3000; bonus2 bSkillUseSP,"SO_PSYCHIC_WAVE",-60;',NULL,'itemheal 0,-100;');
REPLACE INTO `item_db_re` VALUES (1655,'Adventure_Staff','Adventure Staff',5,0,NULL,0,'60',NULL,1,0,0x00810204,63,2,2,1,'1',0,10,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1656,'Academy_Wand','Academy Wand',5,0,NULL,600,'60',NULL,1,1,0x00810204,63,2,2,1,'1',1,10,'bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1657,'Wand_Of_Affection','Wand Of Affection',5,20,NULL,500,'30:160',NULL,1,2,0x00000100,63,2,2,3,'100',1,10,'bonus bInt,2; bonus bAtkEle,Ele_Holy; bonus bHealPower,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1658,'P_Staff3','Eden Staff III',5,0,NULL,0,'60:170',NULL,1,0,0x00818314,63,2,2,3,'60',0,10,'bonus bInt,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1659,'Recovery_Light','Light of Recovery',5,56000,NULL,400,'30:160',NULL,1,1,0x00000100,63,2,2,4,'110',1,10,'bonus bAtkEle,Ele_Holy; bonus bUnbreakableWeapon; .@r = getrefine(); bonus bHealPower,(.@r*6); bonus2 bSkillUseSP,"AL_HEAL",-(.@r*10); bonus2 bSkillUseSP,"AB_CHEAL",-(.@r*12); bonus2 bSkillUseSP,"AB_HIGHNESSHEAL",-(.@r*14);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1660,'Wand_Of_Affection2','Empowered Wand Of Affection',5,20,NULL,500,'30:180',NULL,1,1,0x00000100,63,2,2,3,'130',1,10,'bonus bAtkEle,Ele_Holy; bonus bInt,4; bonus bHealPower,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1661,'Mental_Destroyer','Mental Destroyer',5,20,NULL,1400,'100:50',NULL,1,0,0x00000200,63,2,2,4,'95',1,10,'.@r = getrefine(); bonus bInt,10; bonus bUnbreakableWeapon; bonus bUseSPrate,100; bonus bMdef,20; bonus3 bSPVanishRate,1000,5+(.@r>5?3:0),BF_WEAPON|BF_MAGIC|BF_MISC;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1662,'Bone_Wand_','Evil Bone Wand',5,20,NULL,700,'40:110',NULL,1,2,0x00818314,63,2,2,3,'24',1,10,'bonus bInt,4; bonus bAtkEle,Ele_Undead;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1663,'Staff_Of_Bordeaux_','Staff Of Bordeaux',5,20,NULL,500,'30:180',NULL,1,2,0x00010200,18,2,2,4,'50',1,10,'bonus bInt,2; bonus bDex,1; if(getskilllv("SA_DRAGONOLOGY") == 5) { bonus bUseSPrate,-15; bonus bInt,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1664,'Thorn_Staff_','Thorn Staff of Darkness',5,10,NULL,700,'60:160',NULL,NULL,1,0x14,50,2,2,4,'75',1,8,'bonus bInt,3; bonus bDex,3; bonus bVariableCastrate,-getrefine(); bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1665,'Piercing_Staff_','Piercing Staff',5,20,NULL,500,'80:145',NULL,1,2,0x00018314,18,2,2,3,'70',1,10,'.@r = getrefine(); bonus bInt,4; bonus2 bIgnoreMdefClassRate,Class_Normal,10+.@r; bonus2 bIgnoreMdefClassRate,Class_Boss,10+.@r;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1666,'Healing_Staff_','Healing Staff',5,20,NULL,400,'10:105',NULL,1,2,0x00008110,63,2,2,3,'55',1,10,'bonus bAtkEle,Ele_Holy; bonus bHealPower,(getrefine()*3/2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1667,'TE_Woe_Staff','TE Woe Staff',5,0,NULL,0,'50:100',NULL,1,0,0x00818315,63,2,2,3,'40',1,10,'bonus2 bMagicAddRace,RC_Player,10; bonus3 bAddEff,Eff_Blind,1000,ATF_MAGIC; bonus bHPRecovRate,5; bonus bSPRecovRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1668,'Sword_Stick','Sword Stick',5,10,NULL,500,'120:150',NULL,NULL,2,0x810204,63,2,2,4,'80',1,10,'bonus bAspdRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1669,'Thanos_Staff','Thanos Staff',5,10,NULL,1000,'100:200',NULL,1,1,0x00018314,56,2,2,4,'120',1,10,'bonus bInt,6; bonus bVit,6; bonus bLuk,-6; bonus bHealPower,15; bonus bMagicHPGainValue,500; bonus bMagicSPGainValue,50; bonus2 bHPLossRate,100,10000;',NULL,'heal -1000,0;');
REPLACE INTO `item_db_re` VALUES (1670,'RWC_Memory_Staff','RWC Memory Staff',5,20,NULL,500,'25:30',NULL,1,1,0x00818315,63,2,2,3,'1',1,10,'.@r = getrefine(); bonus bMatk,30*(.@r/3); if(.@r>=6) bonus2 bMagicAddClass,Class_All,(.@r>=9?10:5); if(.@r>=9) bonus4 bAutoSpell,"HW_MAGICPOWER",1,10,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1671,'Devil_Won_Staff','Evil Slayer Vanquisher Staff',5,0,NULL,800,'30:155',NULL,NULL,1,0x00818315,63,2,2,3,'100',1,10,'bonus2 bAddRace,RC_Undead,10; bonus2 bAddRace,RC_Demon,10; bonus2 bMagicAddRace,RC_Undead,10; bonus2 bMagicAddRace,RC_Demon,10; .@r = getrefine(); if(.@r>=9) { .@dmg = 5; if(.@r>=12) { .@dmg += 7; } bonus bMatkRate,.@dmg; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1673,'Half_BF_Staff4','Half BF Staff4',5,20,NULL,0,'70:125',NULL,1,0,0x00818314,63,2,2,3,'80',1,10,'bonus bInt,3; bonus bDex,2; bonus bDelayRate,-10; bonus2 bSPLossRate,5,12000; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1674,'Half_BF_Staff2','Half BF Staff2',5,20,NULL,0,'70:125',NULL,1,0,0x00818314,63,2,2,3,'80',1,10,'bonus bInt,3; bonus bDex,3; bonus2 bMagicAddRace,RC_DemiHuman,10; bonus2 bMagicAddRace,RC_Player,10; bonus3 bAddEff,Eff_Stun,200,ATF_SKILL; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1675,'Walking_Stick_','Gentleman\'s Staff',5,20,NULL,500,'40:125',NULL,1,3,0x00818314,63,2,2,4,'50',1,10,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1676,'Baculum_Daemonicum','Baculum Daemonicum',5,20,NULL,1200,'60:150',NULL,1,2,0x00818315,63,2,2,4,'80',1,10,'bonus bAtkEle,Ele_Dark; bonus bUnbreakableWeapon; bonus bVariableCastrate,-10; if (BaseLevel > 99){ bonus bMatk,30; } if(getrefine() > 8){ bonus2 bResEff,Eff_Blind,3000; bonus bUseSPrate,-10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1677,'Ru_Blue_Wand','Blue Wand',5,10,NULL,0,'50:200',NULL,1,1,0x00000200,56,2,2,3,'100',1,10,'bonus bDex,5; bonus bInt,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1678,'Ru_Gold_Wand','Ru Gold Wand',5,0,NULL,0,'50',NULL,1,2,0x00000200,56,2,2,3,'120',1,10,'bonus bDex,8; bonus bInt,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1679,'Rafini_Staff_S','Laphine Staff',5,20,NULL,500,'30:180',NULL,1,2,0x00818315,63,2,2,3,'100',1,10,'bonus bFixedCastRate,-getrefine();',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1680,'Crimson_One-Handed_Staff','Crimson One-Handed Staff',5,10,NULL,600,'60:70',NULL,1,2,0x00818315,63,2,2,3,'70',1,10,'.@r = getrefine(); bonus bInt,4; bonus bMatk,((BaseLevel/10)*5)+(.@r<=15?pow(.@r,2):225); bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1681,'Short_Foxtail_Staff','Short Foxtail Staff',5,20,NULL,0,'30',NULL,1,0,0x80000000,7,2,2,1,'1',1,10,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1682,'Shadow_Staff','Shadow Staff',5,0,NULL,600,'70:130',NULL,1,2,0x00000200,56,2,2,4,'90',1,10,'.@r = getrefine(); bonus2 bSkillAtk,"WL_HELLINFERNO",(getskilllv("WL_HELLINFERNO") >= 5 ? 100 : 0) + (.@r*10); bonus2 bIgnoreMdefRaceRate,RC_All,5; autobonus "{ bonus2 bVariableCastrate,\\\"WL_HELLINFERNO\\\",-30; }",.@r*20,5000,BF_MAGIC,"{ specialeffect2 EF_SPELLBREAKER; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1683,'Enriched_Foxtail_Staff','Enriched Foxtail Staff',5,20,NULL,200,'50:70',NULL,1,1,0x80000000,7,2,2,2,'12',1,10,'bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1684,'Long_Foxtail_Staff','Long Foxtail Staff',5,20,NULL,200,'50',NULL,2,1,0x80000000,7,2,2,2,'12',1,10,'bonus bLongAtkRate,5; bonus bMaxHP,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1685,'Dragonfly_Sitting_Foxtail_Staff','Dragonfly Sitting Foxtail Staff',5,20,NULL,300,'70:100',NULL,1,1,0x80000000,7,2,2,2,'20',1,10,'bonus bInt,1; bonus bMaxHP,100; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1686,'Large_Foxtail_Staff','Large Foxtail Staff',5,20,NULL,300,'70',NULL,1,1,0x80000000,7,2,2,2,'20',1,10,'bonus bLongAtkRate,8; bonus bDex,1; bonus bMaxHP,200; bonus bMaxSP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1687,'Beginner_Foxtail_Staff','Beginner Foxtail Staff',5,20,NULL,100,'40:15',NULL,1,1,0x80000000,7,2,2,1,'3',1,10,'bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1690,'Mysterious_Foxtail_Staff','Mysterious Foxtail Staff',5,20,NULL,400,'80:180',NULL,1,3,0x80000000,7,2,2,2,'60',1,10,'.@r = getrefine(); bonus bMaxSP,10*(.@r/3)+50; bonus bMatk,10*(.@r/3);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1691,'Strange_God_Foxtail_Staff','Strange God Foxtail Staff',5,20,NULL,500,'100:240',NULL,1,2,0x80000000,7,2,2,3,'100',1,10,'bonus bMaxSP,100; .@r = getrefine(); bonus bMatkRate,2*(.@r/3); bonus bMaxSPrate,.@r/3; if(.@r>=7){ .@r = min(.@r,10)-7; bonus bWeaponAtkRate,(20*.@r)+40; bonus bWeaponMatkRate,(20*.@r)+40; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1692,'Magical_Foxtail_Staff','Magical Foxtail Staff',5,20,NULL,600,'120:260',NULL,1,2,0x80000000,7,2,2,3,'140',1,10,'bonus bMaxSP,100; .@r = getrefine(); bonus bMatkRate,2*(.@r/3); bonus bMaxSPrate,.@r/3; if(.@r>=7){ .@r = min(.@r,10)-7; bonus bWeaponAtkRate,(20*.@r)+40; bonus bWeaponMatkRate,(20*.@r)+40; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1693,'Magical_Yellow_Foxtail_Staff','Magical Yellow Foxtail Staff',5,20,NULL,700,'140:280',NULL,1,1,0x80000000,7,2,2,4,'175',1,10,'.@r = getrefine(); bonus bMatkRate,3*(.@r/2); bonus4 bAutoSpellOnSkill,"SU_FRESHSHRIMP","SU_ARCLOUSEDASH",max(1,getskilllv("SU_ARCLOUSEDASH")),200; bonus4 bAutoSpellOnSkill,"SU_SV_STEMSPEAR","SU_FRESHSHRIMP",max(1,getskilllv("SU_FRESHSHRIMP")),200; if(.@r>=7){ .@r = min(.@r,10)-7; bonus bWeaponAtkRate,(20*.@r)+40; bonus bWeaponMatkRate,(20*.@r)+40; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1694,'Foxtail_Model','Foxtail Model',5,20,NULL,300,'150',NULL,1,3,0x80000000,7,2,2,2,'60',1,10,'bonus bLongAtkRate,8; bonus bMaxHP,100; .@r = getrefine(); bonus bDex,(.@r/3)*2; bonus bMaxSP,(.@r/3)*10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1695,'Delicate_Foxtail_Model','Delicate Foxtail Model',5,20,NULL,300,'195',NULL,1,2,0x80000000,7,2,2,3,'100',1,10,'bonus bLongAtkRate,8; bonus bMaxHP,200; .@r = getrefine(); bonus bDex,(.@r/3)*3; bonus bMaxSP,(.@r/3)*15; if(.@r>=7){ .@r = min(.@r,10)-7; bonus bWeaponAtkRate,(20*.@r)+40; bonus bWeaponMatkRate,(20*.@r)+40; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1696,'Exquisite_Foxtail_Model','Exquisite Foxtail Model',5,20,NULL,300,'240',NULL,1,2,0x80000000,7,2,2,3,'140',1,10,'bonus bLongAtkRate,8; bonus bMaxHPrate,5; .@r = getrefine(); bonus bDex,(.@r/2)*3; bonus bMaxSP,(.@r/2)*15; if(.@r>=7){ .@r = min(.@r,10)-7; bonus bWeaponAtkRate,(20*.@r)+40; bonus bWeaponMatkRate,(20*.@r)+40; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1697,'Exquisite_Yellow_Foxtail_Model','Exquisite Yellow Foxtail Model',5,20,NULL,300,'270',NULL,1,1,0x80000000,7,2,2,4,'175',1,10,'bonus bLongAtkRate,9; bonus bMaxHPrate,7; .@r = getrefine(); bonus bLongAtkRate,.@r/2; bonus bMaxSP,(.@r/2)*20; bonus4 bAutoSpellOnSkill,"SU_PICKYPECK","SU_FRESHSHRIMP",max(1,getskilllv("SU_FRESHSHRIMP")),200; if(.@r>=7){ .@r = min(.@r,10)-7; bonus bWeaponAtkRate,(20*.@r)+40; bonus bWeaponMatkRate,(20*.@r)+40; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1698,'Requiem_Arc_Wand','Requiem Arc Wand',5,20,NULL,500,'80:145',NULL,1,NULL,0xFFFFFFFF,63,2,2,4,'100',1,10,'.@r = getrefine(); .@b = 40; if(.@r>=5){ .@b += (.@r-5)*15+20; } bonus2 bMagicAddRace2,RC2_BioLab,.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1699,'Paradise_Foxtail_Staff_I','Eden Group Foxtail I',5,20,NULL,0,'120:135',NULL,1,0,0x80000000,7,2,2,2,'26',0,10,'bonus bDex,3; bonus bInt,3; bonus bLongAtkRate,5;',NULL,NULL);
#===================================================================
# Bows
#===================================================================
REPLACE INTO `item_db_re` VALUES (1701,'Bow','Bow',5,1000,NULL,500,'15',NULL,5,3,0x000A0848,63,2,34,1,'4',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1702,'Bow_','Bow',5,1000,NULL,500,'15',NULL,5,4,0x000A0848,63,2,34,1,'4',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1703,'Bow__','Bow',5,1000,NULL,0,'15',NULL,5,0,0x000A0848,63,2,34,1,'4',1,11,'bonus2 bAddDamageClass,1002,500; bonus2 bAddDamageClass,1113,500; bonus2 bAddDamageClass,1031,500; bonus2 bAddDamageClass,1242,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1704,'Composite_Bow','Composite Bow',5,2500,NULL,600,'29',NULL,5,3,0x000A0848,63,2,34,1,'4',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1705,'Composite_Bow_','Composite Bow',5,2500,NULL,600,'29',NULL,5,4,0x000A0848,63,2,34,1,'4',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1706,'Composite_Bow__','Composite Bow',5,2500,NULL,600,'29',NULL,5,0,0x000A0848,63,2,34,1,'4',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1707,'Great_Bow','Great Bow',5,10000,NULL,1000,'50',NULL,5,2,0x000A0848,63,2,34,2,'18',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1708,'Great_Bow_','Great Bow',5,10000,NULL,1000,'50',NULL,5,3,0x000A0848,63,2,34,2,'18',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1709,'Great_Bow__','Great Bow',5,10000,NULL,1000,'50',NULL,5,0,0x000A0848,63,2,34,2,'18',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1710,'CrossBow','Crossbow',5,17000,NULL,900,'65',NULL,5,2,0x000A0848,63,2,34,2,'18',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1711,'CrossBow_','Crossbow',5,17000,NULL,900,'65',NULL,5,3,0x000A0848,63,2,34,2,'18',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1712,'CrossBow__','Crossbow',5,17000,NULL,900,'65',NULL,5,0,0x000A0848,63,2,34,2,'18',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1713,'Arbalest','Arbalest',5,48000,NULL,1000,'90',NULL,5,1,0x000A0848,63,2,34,3,'33',1,11,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1714,'Kakkung','Gakkung Bow',5,42000,NULL,1100,'100',NULL,5,1,0x000A0848,63,2,34,3,'33',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1715,'Arbalest_','Arbalest',5,48000,NULL,1000,'90',NULL,5,2,0x000A0848,63,2,34,3,'33',1,11,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1716,'Kakkung_','Gakkung Bow',5,42000,NULL,1100,'100',NULL,5,2,0x000A0848,63,2,34,3,'33',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1718,'Hunter_Bow','Hunter Bow',5,64000,NULL,1500,'125',NULL,5,0,0x00000800,63,2,34,3,'33',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1719,'Bow_Of_Roguemaster','Roguemaster\'s Bow',5,20,NULL,500,'75',NULL,11,0,0x00000040,63,2,34,4,'48',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1720,'Bow_Of_Rudra','Rudra Bow',5,20,NULL,1200,'150',NULL,5,0,0x000A0808,63,2,34,4,'48',1,11,'bonus bAtkEle,Ele_Holy; bonus bInt,5; skill "AL_CURE",1; skill "AL_HEAL",1; bonus2 bResEff,Eff_Poison,5000; bonus2 bResEff,Eff_Curse,5000; bonus2 bResEff,Eff_Silence,5000; bonus2 bResEff,Eff_Confusion,5000; bonus2 bResEff,Eff_Blind,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1721,'Repeting_CrossBow','Repeating Crossbow',5,89000,NULL,2000,'95',NULL,9,1,0x00020840,63,2,34,3,'65',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1722,'Balistar','Ballista',5,124000,NULL,3500,'145',NULL,5,0,0x00080800,63,2,34,4,'77',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1723,'Luna_Bow','Luna Bow',5,20,NULL,2000,'100',NULL,5,2,0x00000800,63,2,34,3,'30',1,11,'.@r = getrefine(); bonus bDef,2+3*(.@r>5)+2*(.@r>8);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1724,'Dragon_Wing','Dragon Wing',5,20,NULL,1200,'100',NULL,5,0,0x000A0848,63,2,34,4,'60',1,11,'bonus3 bAddMonsterDropItem,1765,RC_Dragon,300; bonus bIgnoreDefRace,RC_Dragon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1725,'Bow_Of_Minstrel','Minstrel Bow',5,20,NULL,1700,'120',NULL,5,1,0x00080800,63,2,34,4,'70',1,11,'bonus bInt,2; bonus bSPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1726,'Hunter_Bow_','Hunter Bow',5,64000,NULL,1500,'125',NULL,5,1,0x00000800,63,2,34,3,'33',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1727,'Balistar_','Ballista',5,124000,NULL,3500,'145',NULL,5,1,0x00080800,63,2,34,4,'77',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1728,'Balistar_C','Ballista',5,1,NULL,0,'194',NULL,5,0,0x00080800,63,2,34,4,'1',0,11,'bonus bLongAtkRate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1729,'Bow_Of_Rudra_C','Rudra Bow',5,2,NULL,0,'185',NULL,5,0,0x000A0808,63,2,34,4,'1',0,11,'bonus bAtkEle,Ele_Holy; bonus bInt,5; bonus2 bResEff,Eff_Poison,5000; bonus2 bResEff,Eff_Curse,5000; bonus2 bResEff,Eff_Silence,5000; bonus2 bResEff,Eff_Confusion,5000; bonus2 bResEff,Eff_Blind,5000; skill "AL_CURE",1; skill "AL_HEAL",1; bonus2 bAddRace,RC_Undead,20; bonus2 bAddRace,RC_Demon,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1730,'Burning_Bow','Burning Bow',5,20,NULL,1400,'95',NULL,5,1,0x000A0808,63,2,34,3,'55',1,11,'bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1731,'Frozen_Bow','Frozen Bow',5,20,NULL,1400,'100',NULL,5,1,0x000A0808,63,2,34,3,'55',1,11,'bonus2 bAddEff,Eff_Freeze,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1732,'Earth_Bow','Earth Bow',5,20,NULL,1400,'105',NULL,5,1,0x000A0808,63,2,34,3,'55',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1733,'Gust_Bow','Gust Bow',5,20,NULL,1400,'95',NULL,5,1,0x000A0808,63,2,34,3,'55',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1734,'Orc_Archer_Bow','Orc Archer Bow',5,20,NULL,1600,'120',NULL,5,0,0x000A0808,63,2,34,3,'65',1,11,'bonus2 bAddMonsterDropItem,1753,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1735,'Kkakkung','Kkakkung',5,20,NULL,0,'120',NULL,5,0,0x000A0848,63,2,34,1,'1',0,11,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1736,'Double_Bound','Double Bound',5,20,NULL,900,'70',NULL,5,3,0x00000800,18,2,34,3,'70',1,11,'bonus3 bAutoSpell,"AC_DOUBLE",GetSkillLv("AC_DOUBLE"),10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1737,'Ixion_Wing','Ixion Wings',5,20,NULL,300,'135',NULL,5,1,0x00000800,18,2,34,4,'70',1,11,'autobonus "{ bonus bAspdRate,7; }",10+(getrefine()*2),7000,BF_WEAPON,"{ specialeffect2 EF_HASTEUP; }"; bonus2 bAddSkillBlow,"AC_CHARGEARROW",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1738,'BF_Bow1','Valorous Battle CrossBow',5,20,NULL,0,'100',NULL,5,0,0x000A0848,63,2,34,3,'80',1,11,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1739,'BF_Bow2','Brave Battle CrossBow',5,20,NULL,0,'100',NULL,5,0,0x000A0848,63,2,34,3,'80',1,11,'bonus bDex,2; bonus bInt,10; bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1740,'Nepenthes_Bow','Nepenthes Bow',5,20,NULL,1000,'105',NULL,5,2,0x00000800,18,2,34,4,'60',1,11,'bonus4 bAutoSpellOnSkill,"AC_DOUBLE","AC_CHARGEARROW",1,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1741,'Cursed_Lyre','Cursed Lyre',5,20,NULL,1250,'125',NULL,5,1,0x00080800,18,2,34,4,'80',1,11,'bonus bLuk,-2; bonus2 bAddEff,Eff_Curse,400;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1742,'N_Composite_Bow','Novice Composite Bow',5,1,NULL,0,'49',NULL,5,3,0x000A0848,63,2,34,1,'4',0,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1743,'Krieger_Bow1','Glorious Hunter Bow',5,0,NULL,0,'100',NULL,5,0,0x001A0848,63,2,34,4,'80',1,11,'bonus2 bAddRace,RC_DemiHuman,55; bonus2 bAddRace,RC_Player,55; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; .@r = getrefine(); bonus bCritAtkRate,.@r * 2; bonus bUnbreakableWeapon; if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(.@r>8) bonus2 bSkillAtk,"AC_DOUBLE",20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1744,'Bow_Of_Evil','Bow Of Evil',5,20,NULL,0,'170',NULL,5,0,0x000A0848,63,2,34,4,'1',0,11,'bonus2 bSkillAtk,"AC_DOUBLE",25; bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1745,'Falken_Blitz','Falken Blitz',5,20,NULL,1000,'100',NULL,5,2,0x00000800,18,2,34,3,'50',1,11,'bonus2 bSkillAtk,"SN_SHARPSHOOTING",10; bonus2 bSkillAtk,"AC_DOUBLE",10; bonus2 bSkillAtk,"AC_CHARGEARROW",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1746,'Elven_Bow','Elven Bow',5,20,NULL,1500,'160',NULL,5,1,0x00080800,63,2,34,3,'100',1,11,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1747,'P_Bow1','Eden Bow I',5,0,NULL,0,'82',NULL,5,0,0x000A0848,63,2,34,2,'26',0,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1748,'P_Bow2','Eden Bow II',5,0,NULL,0,'120',NULL,5,0,0x000A0848,63,2,34,2,'40',0,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1749,'Tourist_Bow','Tourist Bow',5,0,NULL,500,'40',NULL,5,0,0x000A0848,63,2,34,1,'1',0,11,'bonus bDex,2;',NULL,NULL);
#===================================================================
# Arrows
#===================================================================
REPLACE INTO `item_db_re` VALUES (1750,'Arrow','Arrow',10,1,NULL,1,'25',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1751,'Silver_Arrow','Silver Arrow',10,3,NULL,2,'30',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1752,'Fire_Arrow','Fire Arrow',10,3,NULL,2,'30',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1753,'Steel_Arrow','Steel Arrow',10,4,NULL,2,'40',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1754,'Crystal_Arrow','Crystal Arrow',10,3,NULL,2,'30',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1755,'Arrow_Of_Wind','Arrow of Wind',10,3,NULL,2,'30',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1756,'Stone_Arrow','Stone Arrow',10,3,NULL,2,'30',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1757,'Immatrial_Arrow','Immaterial Arrow',10,3,NULL,1,'30',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Ghost;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1758,'Stun_Arrow','Stun Arrow',10,10,NULL,3,'1',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus2 bAddEff,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1759,'Freezing_Arrow','Frozen Arrow',10,10,NULL,3,'1',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Water; bonus2 bAddEff,Eff_Freeze,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1760,'Flash_Arrow','Flash Arrow',10,10,NULL,3,'1',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus2 bAddEff,Eff_Blind,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1761,'Curse_Arrow','Cursed Arrow',10,10,NULL,3,'1',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus2 bAddEff,Eff_Curse,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1762,'Rusty_Arrow','Rusty Arrow',10,3,NULL,2,'30',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Poison;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1763,'Poison_Arrow','Poison Arrow',10,10,NULL,3,'1',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Poison; bonus2 bAddEff,Eff_Poison,2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1764,'Incisive_Arrow','Sharp Arrow',10,20,NULL,3,'10',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bCriticalLong,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1765,'Oridecon_Arrow','Oridecon Arrow',10,30,NULL,3,'50',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1766,'Arrow_Of_Counter_Evil','Arrow of Counter Evil',10,40,NULL,3,'50',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1767,'Arrow_Of_Shadow','Arrow of Shadow',10,3,NULL,2,'30',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1768,'Sleep_Arrow','Sleep Arrow',10,10,NULL,3,'1',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus2 bAddEff,Eff_Sleep,2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1769,'Silence_Arrow','Mute Arrow',10,10,NULL,3,'1',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus2 bAddEff,Eff_Silence,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1770,'Iron_Arrow','Iron Arrow',10,2,NULL,1,'30',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1771,'Venom_Knife','Venom Knife',10,50,NULL,5,'30',NULL,NULL,NULL,0x00001000,63,2,32768,NULL,'1',NULL,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1772,'Holy_Arrow','Holy Arrow',10,3,NULL,2,'50',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,'bonus bAtkEle,Ele_Holy; bonus2 bAddRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1773,'Arrow_Of_Elf','Elven Arrow',10,5,NULL,1,'45',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'100',NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1774,'Hunting_Arrow','Hunting Arrow',10,5,NULL,1,'35',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'1',NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1775,'Siege_Arrow_S','Siege Arrow S',10,10,NULL,1,'45',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'130',NULL,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1776,'Siege_Arrow_A','Siege Arrow A',10,10,NULL,1,'30',NULL,NULL,NULL,0x000A1848,63,2,32768,NULL,'95',NULL,1,NULL,NULL,NULL);
#===================================================================
# Knuckles
#===================================================================
REPLACE INTO `item_db_re` VALUES (1800,'Fist_of_Vicious_Mind','Fist of Vicious Mind',5,20,NULL,1500,'150',NULL,1,1,0x00008100,63,2,2,4,'160',1,12,'bonus bAtk,pow(min(getrefine(),15),2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1801,'Waghnakh','Waghnak',5,8000,NULL,400,'30',NULL,1,3,0x00008100,63,2,2,1,'1',1,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1802,'Waghnakh_','Waghnak',5,8000,NULL,400,'30',NULL,1,4,0x00008100,63,2,2,1,'1',1,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1803,'Knuckle_Duster','Knuckle Dusters',5,25000,NULL,450,'50',NULL,1,2,0x00008100,63,2,2,2,'12',1,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1804,'Knuckle_Duster_','Knuckle Dusters',5,25000,NULL,450,'50',NULL,1,3,0x00008100,63,2,2,2,'12',1,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1805,'Hora','Studded Knuckles',5,32000,NULL,450,'65',NULL,1,2,0x00008100,63,2,2,2,'12',1,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1806,'Hora_','Studded Knuckles',5,32000,NULL,450,'65',NULL,1,3,0x00008100,63,2,2,2,'12',1,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1807,'Fist','Fist',5,53000,NULL,650,'115',NULL,1,0,0x00008100,63,2,2,3,'24',1,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1808,'Fist_','Fist',5,53000,NULL,650,'115',NULL,1,1,0x00008100,63,2,2,3,'24',1,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1809,'Claw','Claw',5,67000,NULL,500,'86',NULL,1,1,0x00008100,63,2,2,3,'24',1,12,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1810,'Claw_','Claw',5,67000,NULL,500,'86',NULL,1,2,0x00008100,63,2,2,3,'24',1,12,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1811,'Finger','Finger',5,58000,NULL,500,'97',NULL,1,1,0x00008100,63,2,2,3,'24',1,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1812,'Finger_','Finger',5,58000,NULL,500,'97',NULL,1,2,0x00008100,63,2,2,3,'24',1,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1813,'Kaiser_Knuckle','Kaiser Knuckle',5,20,NULL,450,'110',NULL,1,0,0x00008100,63,2,2,4,'36',1,12,'bonus bAtkEle,Ele_Wind; bonus2 bAddRace,RC_Undead,5; bonus2 bAddEle,Ele_Water,10; bonus2 bAddEle,Ele_Earth,10; bonus2 bAddEle,Ele_Fire,10; bonus2 bAddEle,Ele_Wind,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1814,'Berserk','Berserk',5,20,NULL,500,'120',NULL,1,0,0x00008100,63,2,2,4,'36',1,12,'bonus bAspdRate,12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1815,'Claw_Of_Garm','Hatii Claw',5,20,NULL,550,'152',NULL,1,1,0x00008100,63,2,2,4,'70',1,12,'bonus bAtkEle,Ele_Dark; bonus bMaxHPrate,-2; bonus2 bAddEff,Eff_Bleeding,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1816,'Berserk_','Berserk',5,20,NULL,500,'120',NULL,1,1,0x00008100,63,2,2,4,'36',1,12,'bonus bAspdRate,12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1817,'Kaiser_Knuckle_C','Kaiser Knuckle',5,1,NULL,0,'159',NULL,1,0,0x00008100,63,2,2,4,'1',0,12,'bonus bAtkEle,Ele_Wind; bonus2 bAddRace,RC_Undead,5; bonus2 bAddEle,Ele_Water,10; bonus2 bAddEle,Ele_Earth,10; bonus2 bAddEle,Ele_Fire,10; bonus2 bAddEle,Ele_Wind,10; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1818,'Magma_Fist','Magma Fist',5,20,NULL,650,'80',NULL,1,3,0x00008100,63,2,2,3,'75',1,12,'bonus3 bAutoSpell,"SA_FLAMELAUNCHER",5,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1819,'Icicle_Fist','Icicle Fist',5,20,NULL,650,'80',NULL,1,3,0x00008100,63,2,2,3,'75',1,12,'bonus3 bAutoSpell,"SA_FROSTWEAPON",5,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1820,'Electric_Fist','Electric Fist',5,20,NULL,650,'80',NULL,1,3,0x00008100,63,2,2,3,'75',1,12,'bonus3 bAutoSpell,"SA_LIGHTNINGLOADER",5,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1821,'Seismic_Fist','Seismic Fist',5,20,NULL,650,'80',NULL,1,3,0x00008100,63,2,2,3,'75',1,12,'bonus3 bAutoSpell,"SA_SEISMICWEAPON",5,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1822,'Combo_Battle_Glove','Combo Battle Glove',5,20,NULL,500,'30',NULL,1,4,0x00008100,63,2,2,3,'60',1,12,'bonus2 bSkillAtk,"MO_TRIPLEATTACK",15; bonus2 bSkillAtk,"MO_CHAINCOMBO",15; bonus2 bSkillAtk,"MO_COMBOFINISH",20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1823,'BF_Knuckle1','Valorous Battle Fist',5,20,NULL,0,'30',NULL,1,0,0x00008100,63,2,2,3,'80',1,12,'bonus bStr,2; bonus bAgi,1; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus4 bAutoSpell,"CH_SOULCOLLECT",1,5,0; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1824,'BF_Knuckle2','Brave Battle Fist',5,20,NULL,0,'30',NULL,1,0,0x00008100,63,2,2,3,'80',1,12,'bonus bStr,2; bonus bInt,1; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bVariableCastrate,"MO_EXTREMITYFIST",-25; autobonus "{ bonus2 bVariableCastrate,\\\"MO_EXTREMITYFIST\\\",-100; }",50,6000,BF_WEAPON,"{ specialeffect2 EF_SUFFRAGIUM; }"; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1825,'Horn_Of_Hilthrion','Horn of Hillslion',5,20,NULL,600,'95',NULL,1,3,0x00008000,18,2,2,3,'60',1,12,'bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,100; bonus4 bAutoSpellOnSkill,"CH_PALMSTRIKE","MO_INVESTIGATE",1,100; bonus3 bAutoSpell,"MO_CALLSPIRITS",5,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1826,'Krieger_Knuckle1','Glorious Claw',5,20,NULL,0,'30',NULL,1,0,0x00008100,63,2,2,4,'80',1,12,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(.@r>8) { bonus3 bAutoSpell,"MO_INVESTIGATE",5,(.@r*10-50); bonus3 bAutoSpell,"AL_DECAGI",1,(.@r*10-50); }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1827,'Krieger_Knuckle2','Glorious Fist',5,20,NULL,0,'30',NULL,1,0,0x00008100,63,2,2,4,'80',1,12,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(.@r>8) { bonus2 bVariableCastrate,"MO_EXTREMITYFIST",-100; bonus2 bFixedCastrate,"MO_EXTREMITYFIST",-100; bonus4 bautospellonskill,"MO_EXPLOSIONSPIRITS","CH_SOULCOLLECT",1,1000; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1828,'Monk_Knuckle','Monk Knuckle',5,20,NULL,0,'150',NULL,1,0,0x00008100,63,2,2,4,'0',0,12,'bonus bInt,2; bonus2 bSkillAtk,"MO_FINGEROFFENSIVE",25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1829,'Fist_C','Fist',5,0,NULL,0,'150',NULL,1,0,0x00008100,63,2,2,3,'1',0,12,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1830,'Sura_Rampage','Sura Rampage',5,20,NULL,500,'142',NULL,1,1,0x00008100,63,2,2,3,'102',1,12,'bonus2 bSkillAtk,"SR_EARTHSHAKER",20; bonus2 bSkillAtk,"SR_SKYNETBLOW",20; bonus bUseSPrate,5; .@r = getrefine(); if(.@r>6) { bonus bUseSPrate,-1*(.@r-6); }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1831,'P_Knuckle1','Eden Knuckle I',5,0,NULL,0,'120',NULL,1,0,0x00008100,63,2,2,3,'60',0,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1832,'Velum_Claw','Vellum Claw',5,20,NULL,650,'160',NULL,1,0,0x00008100,63,2,2,4,'95',1,12,'bonus2 bAddRace,RC_Player,100; .@r = getrefine(); if(.@r>7) { bonus2 bAddRace,RC_Player,20; } if(.@r>9) { bonus2 bVariableCastrate,"MO_EXTREMITYFIST",-100; bonus2 bFixedCastrate,"MO_EXTREMITYFIST",-100; bonus4 bAutoSpellOnSkill,"MO_EXPLOSIONSPIRITS","CH_SOULCOLLECT",1,10000; bonus2 bHPLossRate,500,3000; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1833,'Claw_Of_Flash','Claw of Flash',5,60000,NULL,400,'140',NULL,1,2,0x00008100,63,2,2,4,'105',1,12,'bonus bAspd,1; bonus bAspdRate,getrefine(); bonus2 bAddSize,Size_Medium,getrefine();',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1834,'TE_Woe_Fist','TE Woe Fist',5,0,NULL,0,'150',NULL,1,0,0x00008100,63,2,2,3,'40',1,12,'bonus2 bAddRace,RC_Player,40; bonus2 bAddEff,Eff_Freeze,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1835,'Spartacus','Spartacus',5,0,NULL,600,'100',NULL,1,2,0x00008100,63,2,2,4,'50',1,12,'bonus bUnbreakableWeapon; .@r = getrefine(); bonus2 bAddClass,Class_All,.@r; if(.@r>9) { bonus bNoSizeFix; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1836,'Thanos_Knuckle','Thanos Knuckle',5,10,NULL,600,'160:100',NULL,1,1,0x00008000,56,2,2,4,'120',1,12,'bonus bInt,6; bonus bVit,6; bonus bLuk,-6; bonus2 bHPDrainRate,50,5; bonus2 bSPDrainRate,10,5; bonus2 bHPLossRate,100,10000;',NULL,'heal -1000,0;');
REPLACE INTO `item_db_re` VALUES (1837,'Iron_nail','Iron Nail',5,10,NULL,1500,'100',NULL,NULL,1,0x00008100,63,2,2,3,'50',1,12,'bonus bAspdRate,-5; bonus bAspdRate,((getrefine()+1)/2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1838,'Half_BF_Knuckle1','Half BF Knuckle1',5,20,NULL,0,'30',NULL,1,0,0x00008100,63,2,2,3,'80',1,12,'bonus bStr,2; bonus bAgi,1; bonus2 bAddRace,RC_DemiHuman,30; bonus2 bAddRace,RC_Player,30; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,10; bonus2 bIgnoreDefRaceRate,RC_Player,10; bonus4 bAutoSpell,"CH_SOULCOLLECT",1,5,0; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1839,'Crimson_Knuckles','Crimson Knuckles',5,20,NULL,1000,'100',NULL,1,2,0x00008100,63,2,2,3,'70',1,12,'.@r = getrefine(); bonus bBaseAtk,((BaseLevel/10)*5)+(.@r<=15?pow(.@r,2):225); bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1840,'Requiem_Knuckle','Requiem Knuckle',5,20,NULL,500,'150:100',NULL,1,0,0x00008100,63,2,2,4,'100',1,12,'.@r = getrefine(); .@b = 40; if(.@r>=5){ .@b += (.@r-5)*15+20; } bonus2 bAddRace2,RC2_BioLab,.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1841,'Claw_Of_Flash_','Claw of Flash',5,60000,NULL,400,'140',NULL,1,3,0x00008100,63,2,2,4,'105',1,12,'bonus bAspd,1; bonus bAspdRate,getrefine(); bonus2 bAddSize,Size_Medium,getrefine();',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1846,'Illusion_Combo_Battle_Glove','Illusion Combo Battle Glove',5,0,NULL,500,'250',NULL,1,2,0x00008000,56,2,2,4,'120',1,12,'.@r = getrefine(); bonus2 bSkillAtk,"SR_SKYNETBLOW",(10+5*(.@r/2)); bonus2 bSkillAtk,"SR_DRAGONCOMBO",(10+5*(.@r/2)); bonus2 bSkillAtk,"SR_TIGERCANNON",(5*(.@r/3));',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1862,'Burning_Knuckle-OS','Burning Knuckle-OS',5,20,NULL,900,'175',NULL,1,2,0x00008000,63,2,2,4,'130',1,12,'.@r = getrefine(); bonus2 bAddClass,Class_All,3; if (.@r >= 7) { bonus bAspdRate,7; if (.@r >= 9) { bonus2 bSkillAtk,"SR_RAMPAGEBLASTER",15; if (.@r >= 11) { bonus2 bAddSize,Size_Medium,20; bonus2 bAddSize,Size_Large,20; } } }',NULL,NULL);
#===================================================================
# Instruments
#===================================================================
REPLACE INTO `item_db_re` VALUES (1900,'Violin_of_Vicious_Mind','Violin of Vicious Mind',5,20,NULL,1300,'130:50',NULL,1,1,0x00080000,63,1,2,4,'160',1,13,'bonus bAtk,pow(min(getrefine(),15),2); bonus bMatk,pow(min(getrefine(),15),2)/2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1901,'Violin','Violin',5,4000,NULL,700,'50',NULL,1,3,0x00080000,63,1,2,1,'2',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1902,'Violin_','Violin',5,4000,NULL,700,'50',NULL,1,4,0x00080000,63,1,2,1,'2',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1903,'Mandolin','Mandolin',5,18000,NULL,400,'90',NULL,1,2,0x00080000,63,1,2,2,'14',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1904,'Mandolin_','Mandolin',5,18000,NULL,400,'90',NULL,1,3,0x00080000,63,1,2,2,'14',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1905,'Lute','Lute',5,24500,NULL,500,'105',NULL,1,2,0x00080000,63,1,2,2,'14',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1906,'Lute_','Lute',5,24500,NULL,500,'105',NULL,1,3,0x00080000,63,1,2,2,'14',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1907,'Guitar','Guitar',5,47000,NULL,900,'142',NULL,1,0,0x00080000,63,1,2,3,'27',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1908,'Guitar_','Guitar',5,47000,NULL,900,'142',NULL,1,1,0x00080000,63,1,2,3,'27',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1909,'Harp','Harp',5,62000,NULL,900,'114',NULL,1,1,0x00080000,63,1,2,3,'27',1,13,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1910,'Harp_','Harp',5,62000,NULL,900,'114',NULL,1,2,0x00080000,63,1,2,3,'27',1,13,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1911,'Guh_Moon_Goh','Gumoongoh',5,54000,NULL,1300,'126',NULL,1,1,0x00080000,63,1,2,3,'27',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1912,'Guh_Moon_Goh_','Gumoongoh',5,54000,NULL,1300,'126',NULL,1,2,0x00080000,63,1,2,3,'27',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1913,'Electronic_Guitar','Electric Guitar',5,20,NULL,1800,'110',NULL,1,0,0x00080000,63,1,2,4,'70',1,13,'skill "WZ_JUPITEL",1; bonus3 bAutoSpell,"WZ_JUPITEL",1,100; bonus bAtkEle,Ele_Wind; bonus bInt,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1914,'Guitar_Of_Passion','Burning Passion Guitar',5,20,NULL,900,'110',NULL,1,0,0x00080000,63,1,2,3,'27',1,13,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1915,'Guitar_Of_Blue_Solo','Loner\'s Guitar',5,20,NULL,900,'110',NULL,1,0,0x00080000,63,1,2,3,'27',1,13,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1916,'Guitar_Of_Vast_Land','Green Acre Guitar',5,20,NULL,900,'110',NULL,1,0,0x00080000,63,1,2,3,'27',1,13,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1917,'Guitar_Of_Gentle_Breeze','Gentle Breeze Guitar',5,20,NULL,900,'110',NULL,1,0,0x00080000,63,1,2,3,'27',1,13,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1918,'Oriental_Lute','Oriental Lute',5,20,NULL,1200,'150',NULL,1,0,0x00080000,63,1,2,4,'65',1,13,'bonus2 bSkillAtk,"CG_ARROWVULCAN",10; bonus2 bSkillAtk,"BA_MUSICALSTRIKE",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1919,'Base_Guitar','Bass Guitar',5,20,NULL,1500,'130',NULL,1,1,0x00080000,18,1,2,3,'70',1,13,'bonus bSPGainValue,3; bonus4 bAutoSpellWhenHit,"WZ_HEAVENDRIVE",3,30,1; bonus3 bAutoSpell,"NPC_WIDECONFUSE",2,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1920,'Berserk_Guitar','Berserk Guitar',5,20,NULL,1800,'10',NULL,1,0,0x00080000,18,1,2,4,'70',1,13,'bonus bAspdRate,100; bonus bHPrecovRate,-100; bonus2 bHPLossRate,50,5000; bonus bDex,-readparam(bDex);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1921,'Guh_Moon_Gom','Gun Moon Gom',5,20,NULL,0,'120',NULL,1,0,0x00080000,63,1,2,1,'0',0,13,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1922,'Oriental_Lute_','Oriental Lute',5,20,NULL,1200,'150',NULL,1,2,0x00080000,63,1,2,4,'65',1,13,'bonus2 bSkillAtk,"CG_ARROWVULCAN",10; bonus2 bSkillAtk,"BA_MUSICALSTRIKE",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1923,'BF_Instrument1','Valorous Battlefield Guitar',5,20,NULL,0,'50',NULL,1,0,0x00080000,63,1,2,3,'80',1,13,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1924,'BF_Instrument2','Brave Battlefield Guitar',5,20,NULL,0,'50',NULL,1,0,0x00080000,63,1,2,3,'80',1,13,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bSkillAtk,"CG_ARROWVULCAN",20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1925,'Cello','Cello',5,20,NULL,700,'110',NULL,1,3,0x00080000,18,1,2,3,'70',1,13,'bonus bAgi,2; bonus bDex,3; bonus2 bAddSkillBlow,"BA_MUSICALSTRIKE",2; bonus2 bAddSkillBlow,"CG_ARROWVULCAN",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1926,'Harp_Of_Nepenthes','Harp of Nepenthes',5,20,NULL,1000,'120',NULL,1,2,0x00080000,18,1,2,4,'60',1,13,'bonus bInt,2; bonus3 bAddEffOnSkill,"BA_MUSICALSTRIKE",Eff_Stun,(getrefine()>=9?2000:1000);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1927,'Krieger_Instrument1','Glorious Guitar',5,20,NULL,0,'50',NULL,1,0,0x00080000,63,1,2,4,'80',1,13,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(.@r>8) bonus4 bAutoSpellOnSkill,"CG_ARROWVULCAN","CG_TAROTCARD",5,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1928,'Berserk_Guitar_I','Spirited Guitar',5,0,NULL,0,'40',NULL,1,0,0x00080000,18,1,2,4,'0',0,13,'bonus bAspdRate,100; bonus bHPrecovRate,-100; bonus2 bHPLossRate,50,5000; bonus bDex,-readparam(bDex);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1929,'Guitar_C','Guitar',5,0,NULL,0,'177',NULL,1,0,0x00080000,63,1,2,3,'1',0,13,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1930,'Green_Whistle','Green Whistle',5,20,NULL,800,'170:50',NULL,1,1,0x00080000,63,1,2,3,'102',1,13,'.@r = getrefine(); if(.@r>5) { bonus2 bSkillUseSP,"MI_RUSH_WINDMILL",(.@r-5)*4; bonus2 bSkillUseSP,"WM_LULLABY_DEEPSLEEP",(.@r-5)*4; } bonus2 bSkillVariableCast,"MI_RUSH_WINDMILL",-2000; bonus2 bSkillVariableCast,"WM_LULLABY_DEEPSLEEP",-2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1931,'P_String_Inst1','Eden Guitar I',5,0,NULL,0,'125',NULL,1,0,0x00080000,63,1,2,3,'60',0,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1932,'TE_Woe_Guitar','TE Woe Guitar',5,0,NULL,0,'100',NULL,1,0,0x00080000,63,1,2,3,'40',1,13,'bonus2 bAddRace,RC_Player,40; bonus2 bAddEff,Eff_Poison,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1933,'Thanos_Violin','Thanos Violin',5,10,NULL,2000,'200:130',NULL,1,1,0x00080000,56,1,2,4,'120',1,13,'bonus bInt,6; bonus bVit,6; bonus bLuk,-6; bonus2 bHPDrainRate,50,5; bonus2 bSPDrainRate,10,5; bonus bLongAtkRate,20; bonus2 bHPLossRate,100,10000;',NULL,'heal -1000,0;');
REPLACE INTO `item_db_re` VALUES (1934,'Contabass','Contrabass',5,20,NULL,250,'180:120',NULL,1,2,0x00080000,63,1,2,3,'130',1,13,'bonus2 bSkillCooldown,"WM_RANDOMIZESPELL",-20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1935,'Ukulele_Of_Newoz','Oz\'s New Ukulele',5,20,NULL,2000,'160',NULL,1,2,0x00080000,63,1,2,4,'130',1,13,'bonus2 bSkillUseSP,"MI_RUSH_WINDMILL",20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1936,'Ru_Blue_Violin','Blue Violin',5,10,NULL,1500,'180',NULL,2,1,0x00080000,63,1,2,3,'100',1,13,'bonus bDex,5; bonus bVit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1937,'Ru_Gold_Violin','Ru Gold Violin',5,0,NULL,1500,'180',NULL,1,2,0x00080000,56,2,2,3,'120',1,13,'bonus bDex,8; bonus bVit,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1938,'Infinity_Violin','Infinity Violin',5,10,NULL,500,'150',NULL,2,1,0x00080000,56,1,2,4,'100',1,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1939,'Crimson_Violin','Crimson Violin',5,20,NULL,800,'80',NULL,2,2,0x00080000,63,1,2,3,'70',1,13,'.@r = getrefine(); bonus bBaseAtk,((BaseLevel/10)*5)+(.@r<=15?pow(.@r,2):225);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1940,'Trumpet_Shell','Trumpet Shell',5,0,NULL,600,'125',NULL,1,1,0x00080000,56,1,2,4,'130',1,13,'.@r = getrefine(); bonus bDex,.@r; bonus bInt,.@r; .@per = ((.@r > 9) ? 40 : ((.@r > 7) ? 20 : ((.@r > 5) ? 10 : 0))); bonus2 bSkillAtk,"WM_REVERBERATION",.@per; bonus2 bVariableCastrate,"WM_REVERBERATION",-.@per;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1941,'Unity_Violin','Unity Violin',5,20,NULL,400,'76',NULL,2,1,0x00080000,63,1,2,3,'1',1,13,'bonus bBaseAtk,pow(getrefine(),2)*125/100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1942,'Requiem_Violin','Requiem Violin',5,20,NULL,500,'160:120',NULL,1,NULL,0x00080000,63,1,2,4,'100',1,13,'.@r = getrefine(); .@b = 40; bonus bUnbreakableWeapon; if(.@r>=5){ .@b += (.@r-5)*15+20; } if(.@r>=7) bonus2 bSkillAtk,"CG_ARROWVULCAN",200; bonus2 bAddRace2,RC2_BioLab,.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1944,'Hippie_Guitar','Hippie Guitar',5,0,NULL,1000,'140',NULL,2,2,0x00080000,56,1,2,3,'100',1,13,'.@r = getrefine(); .@lvl = getskilllv("BA_MUSICALLESSON"); bonus bAspdRate,.@lvl; if (.@r>=7) bonus bBaseAtk,(5*.@lvl); if (.@r>=9) bonus bAspd,1;',NULL,NULL);
#===================================================================
# Whips
#===================================================================
REPLACE INTO `item_db_re` VALUES (1950,'Rope','Rope',5,2500,NULL,400,'45',NULL,2,3,0x00080000,63,0,2,1,'3',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1951,'Rope_','Rope',5,2500,NULL,400,'45',NULL,2,4,0x00080000,63,0,2,1,'3',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1952,'Line','Whip',5,12000,NULL,300,'80',NULL,2,2,0x00080000,63,0,2,2,'16',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1953,'Line_','Whip',5,12000,NULL,300,'80',NULL,2,3,0x00080000,63,0,2,2,'16',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1954,'Wire','Wire Whip',5,17500,NULL,1000,'95',NULL,2,2,0x00080000,63,0,2,2,'16',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1955,'Wire_','Wire Whip',5,17500,NULL,1000,'95',NULL,2,3,0x00080000,63,0,2,2,'16',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1956,'Rante','Rante Whip',5,32000,NULL,900,'135',NULL,2,0,0x00080000,63,0,2,3,'30',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1957,'Rante_','Rante Whip',5,32000,NULL,900,'135',NULL,2,1,0x00080000,63,0,2,3,'30',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1958,'Tail','Tail Whip',5,41000,NULL,700,'105',NULL,2,1,0x00080000,63,0,2,3,'30',1,14,'bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1959,'Tail_','Tail Whip',5,41000,NULL,700,'105',NULL,2,2,0x00080000,63,0,2,3,'30',1,14,'bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1960,'Whip','Whip',5,38000,NULL,700,'120',NULL,2,1,0x00080000,63,0,2,3,'30',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1961,'Whip_','Whip',5,38000,NULL,700,'120',NULL,2,2,0x00080000,63,0,2,3,'30',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1962,'Lariat','Lariat Whip',5,20,NULL,400,'100',NULL,2,0,0x00080000,63,0,2,4,'44',1,14,'bonus bDex,5; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1963,'Rapture_Rose','Rapture Rose',5,20,NULL,300,'115',NULL,2,0,0x00080000,63,0,2,4,'44',1,14,'bonus bAtkEle,Ele_Poison; bonus2 bAddEff,Eff_Poison,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1964,'Chemeti','Chemeti Whip',5,20,NULL,700,'135',NULL,2,0,0x00080000,63,0,2,4,'44',1,14,'bonus bCritical,5; bonus bFlee,10; bonus bFlee2,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1965,'Whip_Of_Red_Flame','Red Flame Whip',5,20,NULL,700,'110',NULL,2,0,0x00080000,63,0,2,3,'30',1,14,'bonus bAtkEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1966,'Whip_Of_Ice_Piece','Icicle Whip',5,20,NULL,700,'110',NULL,2,0,0x00080000,63,0,2,3,'30',1,14,'bonus bAtkEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1967,'Whip_Of_Earth','Gaia Whip',5,20,NULL,700,'110',NULL,2,0,0x00080000,63,0,2,3,'30',1,14,'bonus bAtkEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1968,'Jump_Rope','Skipping Rope',5,20,NULL,400,'120',NULL,2,0,0x00080000,63,0,2,3,'30',1,14,'bonus bCritical,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1969,'Bladed_Whip','Blade Whip',5,20,NULL,1200,'140',NULL,2,0,0x00080000,63,0,2,4,'30',1,14,'bonus2 bAddEff,Eff_Bleeding,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1970,'Queen\'s_Whip','Queen\'s Whip',5,20,NULL,1100,'150',NULL,2,0,0x00080000,63,0,2,4,'65',1,14,'bonus2 bSkillAtk,"CG_ARROWVULCAN",10; bonus2 bSkillAtk,"DC_THROWARROW",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1971,'Electric_Wire','Electric Wire',5,20,NULL,700,'110',NULL,2,0,0x00080000,63,0,2,3,'30',1,14,'bonus bAtkEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1972,'Electric_Eel','Electric Eel',5,20,NULL,2000,'100',NULL,2,2,0x00080000,18,0,2,4,'70',1,14,'bonus bAtkEle,Ele_Wind; bonus bInt,2; bonus bAgi,2; bonus3 bAutoSpell,"WZ_JUPITEL",3,20; .@r = getrefine(); if(.@r>0) bonus3 bAutoSpell,"CG_ARROWVULCAN",.@r,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1973,'Sea_Witch_Foot','Sea Witch\'s Foot',5,20,NULL,1500,'110',NULL,2,1,0x00080000,18,0,2,4,'70',1,14,'bonus bSPGainValue,5; bonus4 bAutoSpellWhenHit,"WZ_FROSTNOVA",3,50,1; bonus3 bAutoSpell,"NPC_WIDESILENCE",2,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1974,'Carrot_Whip','Carrot Whip',5,20,NULL,1300,'185',NULL,2,0,0x00080000,18,0,2,4,'70',1,14,'.@r = getrefine(); if(.@r>0) bonus3 bAutoSpell,"AL_INCAGI",min(.@r,10),10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1975,'Queen_Is_Whip','Queen Is Whip',5,20,NULL,0,'120',NULL,2,0,0x00080000,63,0,2,1,'0',0,14,'bonus2 bAddClass,Class_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1976,'Queen\'s_Whip_','Queen\'s Whip',5,20,NULL,1100,'150',NULL,2,2,0x00080000,63,0,2,4,'65',1,14,'bonus2 bSkillAtk,"CG_ARROWVULCAN",10; bonus2 bSkillAtk,"DC_THROWARROW",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1977,'BF_Whip1','Valorous Battle Lariat',5,20,NULL,0,'50',NULL,2,0,0x00080000,63,0,2,3,'80',1,14,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1978,'BF_Whip2','Brave Battle Lariat',5,20,NULL,0,'50',NULL,2,0,0x00080000,63,0,2,3,'80',1,14,'bonus bDex,2; bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bSkillAtk,"CG_ARROWVULCAN",20; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1979,'Stem_Of_Nepenthes','Stem of Nepenthes',5,20,NULL,1000,'120',NULL,2,2,0x00080000,18,0,2,4,'60',1,14,'bonus bInt,2; bonus3 bAddEffOnSkill,"DC_THROWARROW",Eff_Freeze,(getrefine()>=9?2000:1000);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1980,'Whip_Of_Balance','Whip of Balance',5,20,NULL,700,'110',NULL,2,3,0x00080000,18,0,2,3,'70',1,14,'bonus bAgi,2; bonus bDex,3; bonus2 bAddSkillBlow,"DC_THROWARROW",2; bonus2 bAddSkillBlow,"CG_ARROWVULCAN",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1981,'Krieger_Whip1','Glorious Lariat',5,20,NULL,0,'50',NULL,2,0,0x00080000,63,0,2,4,'80',1,14,'bonus2 bAddRace,RC_DemiHuman,95; bonus2 bAddRace,RC_Player,95; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,20; bonus2 bIgnoreDefRaceRate,RC_Player,20; bonus bUnbreakableWeapon; .@r = getrefine(); if(.@r>5) { bonus2 bAddRace,RC_DemiHuman,pow(min(14,.@r)-4,2); bonus2 bAddRace,RC_Player,pow(min(14,.@r)-4,2); bonus2 bIgnoreDefRaceRate,RC_DemiHuman,5; bonus2 bIgnoreDefRaceRate,RC_Player,5; } if(.@r>8) bonus4 bAutoSpellOnSkill,"CG_ARROWVULCAN","CG_TAROTCARD",5,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1982,'Phenomena_Whip','Phenomena Whip',5,20,NULL,0,'160',NULL,2,0,0x00080000,63,0,2,4,'0',0,14,'bonus bDex,2; bonus2 bSkillAtk,"DC_THROWARROW",25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1983,'Rante_C','Rante Whip',5,0,NULL,0,'170',NULL,2,0,0x00080000,63,0,2,3,'1',0,14,'bonus2 bAddSize,Size_All,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1984,'Stem_Whip','Stem Whip',5,20,NULL,800,'170:50',NULL,1,1,0x00080000,63,0,2,3,'102',1,14,'.@r = getrefine(); if(.@r>5) { bonus2 bSkillUseSP,"WA_SWING_DANCE",(.@r-5)*4; bonus2 bSkillUseSP,"WM_LULLABY_DEEPSLEEP",(.@r-5)*4; } bonus2 bSkillVariableCast,"WA_SWING_DANCE",-2000; bonus2 bSkillVariableCast,"WM_LULLABY_DEEPSLEEP",-2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1985,'Rosebine','Rosebine',5,20,NULL,1000,'100:130',NULL,1,0,0x00080000,63,0,2,4,'110',1,14,'bonus bInt,2; bonus bAgi,-2; bonus3 bAutoSpell,"WM_VOICEOFSIREN",1,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1986,'P_Tail1','Eden Tail I',5,0,NULL,0,'125',NULL,2,0,0x00080000,63,0,2,3,'60',0,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1987,'TE_Woe_Rope','TE Woe Rope',5,0,NULL,0,'100',NULL,2,0,0x00080000,63,0,2,3,'40',1,14,'bonus2 bAddRace,RC_Player,40; bonus2 bAddEff,Eff_Blind,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1988,'Thanos_Whip','Thanos Whip',5,10,NULL,2200,'200:130',NULL,2,1,0x00080000,56,0,2,4,'120',1,14,'bonus bInt,6; bonus bVit,6; bonus bLuk,-6; bonus2 bHPDrainRate,50,5; bonus2 bSPDrainRate,10,5; bonus bLongAtkRate,20; bonus2 bHPLossRate,100,10000;',NULL,'heal -1000,0;');
REPLACE INTO `item_db_re` VALUES (1989,'Gymnastics_Ribbon','Rhythmic Gymnastics Ribbon',5,20,NULL,300,'150:120',NULL,2,2,0x00080000,63,0,2,3,'130',1,14,'bonus bAspdRate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1990,'Floral_Mic_Of_Igu','Bloody Floral Decoration Microphone',5,20,NULL,1000,'160',NULL,2,2,0x00080000,63,0,2,4,'130',1,14,'bonus2 bSkillUseSP,"CG_MOONLIT",20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1991,'Ru_Blue_Whip','Blue Whip',5,10,NULL,1500,'180',NULL,2,1,0x00080000,63,0,2,3,'100',1,14,'bonus bDex,5; bonus bVit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1992,'Ru_Gold_Whip','Ru Gold Whip',5,0,NULL,1500,'180',NULL,2,2,0x00080000,56,2,2,3,'120',1,14,'bonus bDex,8; bonus bVit,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1994,'Infinity_Whip','Infinity Whip',5,10,NULL,500,'150',NULL,2,1,0x00080000,56,0,2,4,'100',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1995,'Crimson_Whip','Crimson Whip',5,20,NULL,800,'80',NULL,2,2,0x00080000,63,0,2,3,'70',1,14,'.@r = getrefine(); bonus bBaseAtk,((BaseLevel/10)*5)+(.@r<=15?pow(.@r,2):225);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1996,'Wire_of_Vicious_Mind','Wire of Vicious Mind',5,20,NULL,1300,'130:50',NULL,2,1,0x00080000,63,NULL,2,4,'160',1,14,'bonus bAtk,pow(min(getrefine(),15),2); bonus bMatk,pow(min(getrefine(),15),2)/2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (1997,'Unity_Whip','Unity Whip',5,20,NULL,76,'40',NULL,2,1,0x00080000,63,0,2,3,'1',1,14,'bonus bBaseAtk,pow(getrefine(),2)*125/100;',NULL,NULL);
#===================================================================
# Additional 2-Handed Staffs
#===================================================================
REPLACE INTO `item_db_re` VALUES (2000,'Destruction_Rod','Staff of Destruction',5,20,NULL,2500,'130:280',NULL,1,1,0x00000200,18,2,34,4,'80',1,23,'.@r = getrefine; bonus bMatkRate,.@r/2; bonus bInt,3; bonus bAgi,10; bonus bUseSPrate,(.@r*2); bonus3 bAutoSpellWhenHit,"WZ_JUPITEL",5,(.@r*20); bonus2 bFixedCastrate,"HW_MAGICPOWER",-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2001,'Divine_Cross','Divine Cross',5,20,NULL,1500,'120:210',NULL,1,0,0x00008100,63,2,34,4,'70',1,23,'bonus bAtkEle,Ele_Holy; bonus bDex,4; bonus2 bSubRace,RC_Demon,15; bonus2 bSubRace,RC_Undead,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2002,'Krieger_Twohand_Staff1','Glorious Destruction Staff',5,20,NULL,0,'70:210',NULL,1,0,0x00018314,63,2,34,4,'80',1,23,'.@r = getrefine(); bonus bMatkRate,.@r; bonus2 bMagicAddRace,RC_DemiHuman,15; bonus2 bMagicAddRace,RC_Player,15; bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,25; bonus2 bIgnoreMdefRaceRate,RC_Player,25; bonus bUnbreakableWeapon; if(.@r>5) { bonus2 bMagicAddRace,RC_DemiHuman,(min(14,.@r)-5)*2; bonus2 bMagicAddRace,RC_Player,(min(14,.@r)-5)*2; bonus2 bIgnoreMdefRaceRate,RC_DemiHuman,5+(min(14,.@r)-5)*2; bonus2 bIgnoreMdefRaceRate,RC_Player,5+(min(14,.@r)-5)*2; } if(.@r>8) { bonus5 bAutoSpellOnSkill,"WZ_STORMGUST","MG_SAFETYWALL",10,200,1; bonus5 bAutoSpellOnSkill,"WZ_METEOR","MG_SAFETYWALL",10,200,1; bonus5 bAutoSpellOnSkill,"WZ_VERMILION","MG_SAFETYWALL",10,200,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2003,'Destruction_Rod_M','Staff of Destruction',5,20,NULL,2500,'130:280',NULL,1,1,0x00000200,18,2,34,4,'80',1,23,'.@r = getrefine(); bonus bMatkRate,.@r/2; bonus bInt,3; bonus bAgi,10; bonus bUseSPrate,(.@r*2); bonus3 bAutoSpellWhenHit,"WZ_JUPITEL",5,(.@r*20); bonus2 bVariableCastrate,"HW_MAGICPOWER",-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2004,'Kronos','Kronos',5,20,NULL,1000,'30:240',NULL,1,0,0x00010204,18,2,34,4,'50',1,23,'.@r = getrefine(); bonus bInt,3+(.@r/2); bonus bMaxHP,300+(50*.@r/2); autobonus "{ bonus bMatkRate,12; bonus buseSPRate,20; }",1,5000,BF_MAGIC,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2005,'Dea_Staff','Dea Staff',5,20,NULL,1000,'30:220',NULL,1,1,0x00008110,18,2,34,3,'50',1,23,'bonus bAtkEle,Ele_Holy; bonus bMatkRate,getrefine()/2; bonus bInt,6; bonus bVit,2; autobonus3 "{ }",20,1000,"AL_HEAL","{ specialeffect2 EF_MAGICALATTHIT; heal 0,200; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2006,'G_Staff_Of_Light','Staff Of Light',5,20,NULL,1900,'80:150',NULL,1,0,0x00810204,63,2,34,4,'60',1,23,'bonus bAtkEle,Ele_Holy; bonus bInt,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2007,'Golden_Rod_Staff','Golden Rod Staff',5,20,NULL,900,'30:230',NULL,1,2,0x00000200,63,2,34,4,'100',1,23,'bonus bAtkEle,Ele_Wind; bonus bInt,3; bonus2 bSkillAtk,"WZ_JUPITEL",12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2008,'Aqua_Staff','Aqua Staff',5,20,NULL,900,'30:230',NULL,1,2,0x00000200,63,2,34,4,'100',1,23,'bonus bAtkEle,Ele_Water; bonus bInt,3; bonus2 bSkillAtk,"MG_COLDBOLT",12; bonus2 bSkillAtk,"MG_FROSTDIVER",12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2009,'Crimson_Staff','Crimson Staff',5,20,NULL,900,'30:230',NULL,1,2,0x00000200,63,2,34,4,'100',1,23,'bonus bAtkEle,Ele_Fire; bonus bInt,3; bonus2 bSkillAtk,"MG_FIREBOLT",10; bonus2 bSkillAtk,"MG_FIREBALL",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2010,'Forest_Staff','Forest Staff',5,20,NULL,900,'30:230',NULL,1,2,0x00000200,63,2,34,4,'100',1,23,'bonus bAtkEle,Ele_Earth; bonus bInt,3; bonus2 bSkillAtk,"WZ_EARTHSPIKE",10; bonus2 bSkillAtk,"WZ_HEAVENDRIVE",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2011,'Golden_Rod_Staff2','Empowered Golden Rod Staff',5,20,NULL,900,'30:270',NULL,1,1,0x00000200,63,2,34,4,'130',1,23,'bonus bAtkEle,Ele_Wind; bonus bInt,5; bonus2 bSkillAtk,"WZ_JUPITEL",30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2012,'Aqua_Staff2','Empowered Aqua Staff',5,20,NULL,900,'30:270',NULL,1,1,0x00000200,63,2,34,4,'130',1,23,'bonus bAtkEle,Ele_Water; bonus bInt,5; bonus2 bSkillAtk,"MG_COLDBOLT",30; bonus2 bSkillAtk,"MG_FROSTDIVER",30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2013,'Crimson_Staff2','Empowered Crimson Staff',5,20,NULL,900,'30:270',NULL,1,1,0x00000200,63,2,34,4,'130',1,23,'bonus bAtkEle,Ele_Fire; bonus bInt,5; bonus2 bSkillAtk,"MG_FIREBOLT",30; bonus2 bSkillAtk,"MG_FIREBALL",30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2014,'Forest_Staff2','Empowered Forest Staff',5,20,NULL,900,'30:270',NULL,1,1,0x00000200,63,2,34,4,'130',1,23,'bonus bAtkEle,Ele_Earth; bonus bInt,5; bonus2 bSkillAtk,"WZ_EARTHSPIKE",30; bonus2 bSkillAtk,"WZ_HEAVENDRIVE",30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2015,'Upg_Staff','Upg Staff',5,20,NULL,1000,'50:70',NULL,1,1,0x00818314,63,2,34,3,'1',1,23,'.@r = getrefine(); bonus bMatk,(.@r*10); bonus bHealPower,.@r; if(BaseJob==Job_Wizard) bonus bMatk,30; else if(BaseJob==Job_Sage) bonus bMatk,20; if(BaseLevel>70) bonus bMatk,(((BaseLevel-70)/10)*10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2016,'Velum_Arc_Wand','Vellum Arc Wand',5,20,NULL,800,'110:220',NULL,1,0,0x00818314,63,2,34,4,'95',1,23,'bonus bUnbreakableWeapon; bonus2 bMagicAddRace,RC_Player,25; bonus2 bIgnoreMdefRaceRate,RC_Player,25; .@r = getrefine(); if(.@r>5) { bonus2 bMagicAddRace,RC_Player,15; } if(.@r>8) { bonus bVariableCastrate,-50; bonus bFixedCast,-200; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2017,'Divine_Cross_','Divine Cross',5,20,NULL,1500,'120:210',NULL,1,1,0x00008100,63,2,34,4,'70',1,23,'bonus bUnbreakableWeapon; bonus bAtkEle,Ele_Holy; bonus bDex,4; bonus2 bSubRace,RC_Demon,15; bonus2 bSubRace,RC_Undead,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2018,'Metal_Staff','Metal Staff',5,20,NULL,0,'50:70',NULL,1,1,0x00818315,63,2,34,3,'1',1,23,'if(BaseJob==Job_Wizard) bonus bMatk,15; else if(BaseJob==Job_Sage) bonus bMatk,10; bonus bMatk,(getrefine()*5); .@i = min(BaseLevel/10,12); if(.@i>2) bonus bMatk,((.@i-2)*5);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2019,'TE_Woe_Two_Hand_Staff','TE Woe Two Hand Staff',5,0,NULL,0,'50:130',NULL,1,0,0x00818315,63,2,34,3,'40',1,23,'bonus2 bMagicAddRace,RC_Player,20; bonus3 bAddEff,Eff_Stun,1000,ATF_MAGIC; bonus bHPRecovRate,5; bonus bSPRecovRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2020,'Jormungand','Jormungand',5,10,NULL,3000,'200:280',NULL,NULL,0,0x810200,63,2,34,4,'1',0,23,'bonus bInt,20; bonus3 bAddEff,Eff_Poison,3000,ATF_MAGIC; bonus2 bAddEffWhenHit,Eff_DPoison,100; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2021,'Ganbantein','Ganbantein',5,0,NULL,2000,'100:320',NULL,1,0,0x00000200,56,2,2,4,'100',1,10,'bonus bInt,25; bonus bDex,25; bonus3 bAddEff,Eff_Poison,1000,ATF_MAGIC; bonus3 bAutoSpell,"AB_SILENTIUM",1,100; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2022,'Staff_Of_Geffen','Staff of Geffen',5,20,NULL,1000,'100:300',NULL,1,1,0x00000200,18,2,34,1,'150',1,23,'bonus bInt,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2023,'Thanos_Rod','Thanos Two-Handed Staff',5,10,NULL,1400,'120:250',NULL,1,1,0x00018314,56,2,34,4,'120',1,23,'bonus bInt,6; bonus bVit,6; bonus bLuk,-6; bonus bHealPower,18; bonus bMagicHPGainValue,500; bonus bMagicSPGainValue,50; bonus2 bHPLossRate,100,10000;',NULL,'heal -1000,0;');
REPLACE INTO `item_db_re` VALUES (2024,'Infinity_Two-handed_Stick','Infinity Two-handed Stick',5,10,NULL,500,'30:170',NULL,NULL,1,0x810200,56,2,34,4,'100',1,23,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2025,'Crimson_Two-Handed_Staff','Crimson Two-Handed Staff',5,20,NULL,1000,'100',NULL,1,2,0x800200,63,2,34,3,'70',1,23,'.@r = getrefine(); bonus bInt,5; bonus bMatk,150+((BaseLevel/10)*5)+(.@r<=15?pow(.@r,2):225);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2026,'Staff_of_Vicious_Mind','Staff of Vicious Mind',5,20,NULL,1000,'100:200',NULL,1,1,0x00810204,63,2,34,4,'160',1,23,'bonus bMatk,pow(min(getrefine(),15),2); bonus bInt,6; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2027,'Sunflower_Kid','Sunflower Kid',5,10,NULL,1500,'150:320',NULL,NULL,2,0x00000200,56,2,34,4,'170',1,23,'bonus bInt,5; .@r = getrefine(); bonus bMatkRate,(.@r/2); bonus bDelayrate,(.@r*-1); bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2030,'Unity_Two-Handed_Staff','Unity Two-Handed Staff',5,20,NULL,500,'95:135',NULL,1,1,0x800200,63,2,34,3,'1',1,23,'bonus bMatk,pow(getrefine(),2)*125/100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2032,'Requiem_Wizardry_Staff','Requiem Wizardry Staff',5,20,NULL,500,'100:230',NULL,1,NULL,0xFFFFFFFF,63,2,2,4,'100',1,10,'.@r = getrefine(); .@b = 40; .@c = 5; if(.@r>=5){ .@b += (.@r-5)*15+20; .@c += .@r-5; } bonus2 bMagicAddRace2,RC2_BioLab,.@b; bonus2 bSubRace2,RC2_BioLab,.@c; bonus2 bIgnoreMdefRace2Rate,RC2_BioLab,(.@r-5)*10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2039,'Illusion_Wizardry_Staff','Illusion Wizardry Staff',5,0,NULL,2400,'150:250',NULL,1,2,0x00810204,58,2,34,4,'100',1,23,'.@val = min(getrefine(),10)/2; bonus bInt,(6+.@val); bonus bDex,(2+.@val);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2049,'Blue_Flame_Cane','Blue Flame Cane',5,20,NULL,800,'110:300',NULL,1,2,0x00818314,63,2,34,4,'175',1,23,'.@r = getrefine; bonus bInt,7; bonus bMatkRate,.@r/2; bonus bUnbreakableWeapon; if (.@r>=9) .@val = 15; else if (.@r>=7) .@val = 5; if (.@r>=11) bonus2 bSubSize,Size_All,20; if (.@r>=13) bonus bDelayrate,-15; bonus2 bMagicAtkEle,Ele_Fire,.@val; bonus2 bMagicAtkEle,Ele_Earth,.@val; bonus2 bMagicAtkEle,Ele_Water,.@val; bonus2 bMagicAtkEle,Ele_Holy,.@val;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2051,'Illusion_Survivor\'s_Staff','Illusion Survivor\'s Staff',5,0,NULL,1200,'100:240',NULL,1,2,0x00818314,63,2,34,4,'120',1,23,'.@r = getrefine(); bonus bDex,2; bonus bInt,2; bonus bMaxHP,600; bonus bUnbreakableWeapon; bonus bMatkRate,(.@r/2); if (.@r >= 7) { bonus2 bMagicAddSize,Size_Small,15; bonus2 bMagicAddSize,Size_Medium,15; if (.@r >= 9) { bonus2 bSubSize,Size_Small,15; bonus2 bSubSize,Size_Medium,15; if (.@r >= 11) { bonus2 bSubDefEle,Ele_Water,15; bonus2 bSubDefEle,Ele_Wind,15; bonus2 bSubDefEle,Ele_Earth,15; bonus2 bSubDefEle,Ele_Fire,15; } } }',NULL,NULL);
#===================================================================
# Shields
#===================================================================
REPLACE INTO `item_db_re` VALUES (2101,'Guard','Guard',4,500,NULL,300,NULL,20,NULL,0,0xFFFFFFFF,63,2,32,NULL,'0',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2102,'Guard_','Guard',4,500,NULL,300,NULL,20,NULL,1,0xFFFFFFFF,63,2,32,NULL,'0',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2103,'Buckler','Buckler',4,14000,NULL,600,NULL,40,NULL,0,0x000ED5F2,63,2,32,NULL,'0',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2104,'Buckler_','Buckler',4,14000,NULL,600,NULL,40,NULL,1,0x000ED5F2,63,2,32,NULL,'0',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2105,'Shield','Shield',4,56000,NULL,1300,NULL,60,NULL,0,0x00004082,63,2,32,NULL,'0',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2106,'Shield_','Shield',4,56000,NULL,1300,NULL,60,NULL,1,0x00004082,63,2,32,NULL,'0',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2107,'Mirror_Shield','Mirror Shield',4,60000,NULL,1000,NULL,45,NULL,0,0x00404082,63,2,32,NULL,'0',1,4,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2108,'Mirror_Shield_','Mirror Shield',4,60000,NULL,1000,NULL,45,NULL,1,0x00404082,63,2,32,NULL,'0',1,4,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2109,'Memorize_Book','Memory Book',4,20,NULL,1000,NULL,25,NULL,0,0x00810204,63,2,32,NULL,'0',1,5,'bonus bInt,1; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2110,'Holy_Guard','Holy Guard',4,85000,NULL,1400,NULL,110,NULL,0,0x00004000,63,2,32,NULL,'68',0,4,'bonus bVit,2; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2111,'Herald_Of_GOD','Sacred Mission',4,128000,NULL,1600,NULL,120,NULL,0,0x00004000,63,2,32,NULL,'83',1,4,'bonus bVit,3; bonus bInt,2; bonus bMdef,3; bonus bUnbreakableShield;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2112,'Novice_Guard','Novice Guard',4,1,NULL,1,NULL,20,NULL,0,0x00000001,63,2,32,NULL,'0',0,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2113,'Novice_Shield','Novice Shield',4,5000,NULL,1000,NULL,20,NULL,1,0x00000001,63,2,32,NULL,'40',1,3,'bonus2 bSubEle,Ele_All,20; bonus2 bSubEle,Ele_Neutral,-20; bonus2 bSubEle,Ele_Holy,-20; bonus2 bSubEle,Ele_Dark,-20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2114,'Stone_Buckler','Stone Buckler',4,30000,NULL,1500,NULL,45,NULL,1,0xFFFFFFFE,63,2,32,NULL,'65',1,2,'bonus2 bSubSize,Size_Large,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2115,'Valkyrja\'s_Shield','Valkyrja\'s Shield',4,30000,NULL,500,NULL,80,NULL,1,0xFFFFFFFE,63,2,32,NULL,'65',1,4,'bonus2 bSubEle,Ele_Water,20; bonus2 bSubEle,Ele_Fire,20; bonus2 bSubEle,Ele_Dark,20; bonus2 bSubEle,Ele_Undead,20; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2116,'Angel\'s_Safeguard','Angelic Guard',4,10000,NULL,400,NULL,30,NULL,1,0x00000001,63,2,32,NULL,'20',1,1,'bonus2 bSubRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2117,'Arm_Guard','Arm Guard',4,10000,NULL,150,NULL,50,NULL,0,0x02000000,63,2,32,NULL,'20',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2118,'Arm_Guard_','Arm Guard',4,10000,NULL,150,NULL,50,NULL,1,0x02000000,63,2,32,NULL,'20',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2119,'Improved_Arm_Guard','Advanced Arm Guard',4,40000,NULL,150,NULL,45,NULL,0,0x02000000,63,2,32,NULL,'50',1,1,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2120,'Improved_Arm_Guard_','Advanced Arm Guard',4,40000,NULL,150,NULL,45,NULL,1,0x02000000,63,2,32,NULL,'50',1,1,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2121,'Memorize_Book_','Memory Book',4,20,NULL,1000,NULL,25,NULL,1,0x00810204,63,2,32,NULL,'0',1,5,'bonus bInt,1; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2122,'Platinum_Shield','Platinum Shield',4,20,NULL,1200,NULL,95,NULL,0,0xFFFFFFFE,18,2,32,NULL,'68',1,4,'bonus bMdef,5; bonus2 bSubSize,Size_Medium,15; bonus2 bSubSize,Size_Large,15; bonus2 bSubRace,RC_Undead,10; bonus5 bAutoSpellWhenHit,"NPC_MAGICMIRROR",7,150,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2123,'Orleans_Server','Orleans\'s Server',4,20,NULL,1000,NULL,75,NULL,1,0xFFFFFFFE,18,2,32,NULL,'55',1,4,'bonus bMdef,2; bonus bMagicDamageReturn,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2124,'Thorny_Buckler','Thorny Buckler',4,20,NULL,1000,NULL,85,NULL,1,0xFFFFFFFE,18,2,32,NULL,'55',1,2,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2125,'Strong_Shield','Strong Shield',4,20,NULL,2500,NULL,90,NULL,1,0xFFFFFFFE,18,2,32,NULL,'75',1,4,'bonus bNoKnockback; bonus2 bSubEle,Ele_Neutral,-20; bonus2 bSubEle,Ele_Fire,-20; bonus2 bSubEle,Ele_Water,-20; bonus2 bSubEle,Ele_Wind,-20; bonus2 bSubEle,Ele_Earth,-20; bonus2 bSubEle,Ele_Dark,-20; bonus2 bSubEle,Ele_Holy,-20; bonus2 bSubEle,Ele_Ghost,-20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2126,'Guyak_Shield','Guyak Shield',4,20,NULL,700,NULL,3,NULL,0,0xFFFFFFFE,63,2,32,NULL,'1',1,2,'bonus bMdef,2; bonus bMagicDamageReturn,2; autobonus2 "{ bonus bShortWeaponDamageReturn,5; }",20,1000,BF_WEAPON,"{ specialeffect2 EF_REFLECTSHIELD; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2127,'Secular_Mission','Secular Mission',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,63,2,32,NULL,'0',0,4,'bonus2 bSubClass,Class_All,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2128,'Herald_Of_GOD_','Sacred Mission',4,128000,NULL,1600,NULL,120,NULL,1,0x00004000,63,2,32,NULL,'83',1,4,'bonus bVit,3; bonus bInt,2; bonus bMdef,3; bonus bUnbreakableShield;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2129,'Exorcism_Bible','Exorcism Bible',4,20,NULL,600,NULL,80,NULL,0,0x00008100,63,2,32,NULL,'50',1,5,'bonus bHPrecovRate,3; bonus bSPrecovRate,3; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2130,'Cross_Shield','Cross Shield',4,20,NULL,2000,NULL,130,NULL,1,0x00004000,63,2,32,NULL,'80',1,4,'bonus bStr,1; bonus2 bSkillAtk,"PA_SHIELDCHAIN",30; bonus2 bSkillAtk,"CR_SHIELDBOOMERANG",30; bonus bUseSPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2131,'Magic_Study_Vol1','Magic Bible Vol1',4,20,NULL,1000,NULL,18,NULL,1,0x00810204,18,2,32,NULL,'70',1,5,'bonus bMdef,3; bonus bInt,2; bonus2 bAddEffWhenHit,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2132,'Shelter_Resistance','Shell Of Resistance',4,20,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,63,2,32,NULL,'0',0,2,'bonus2 bSubEle,Ele_All,20; bonus bShortWeaponDamageReturn,1; if (vip_status(VIP_STATUS_ACTIVE)) { bonus bAllStats,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2133,'Tournament_Shield','Tournament Shield',4,20,NULL,1000,NULL,105,NULL,1,0x00004082,18,2,32,NULL,'50',1,4,'bonus2 bAddClass,Class_All,1; if( Class == Job_Lord_Knight ) bonus bAspdRate,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2134,'Shield_Of_Naga','Shield of Naga',4,20,NULL,500,NULL,35,NULL,1,0x00CFFF80,18,2,32,NULL,'70',1,2,'.@r = getrefine(); bonus bMdef,3; if(.@r<11) { autobonus2 "{ bonus bShortWeaponDamageReturn,("+.@r+"*3); }",10,5000,BF_WEAPON,"{ specialeffect2 EF_GUARD; }"; } else { autobonus2 "{ bonus bShortWeaponDamageReturn,("+.@r+"*3); }",10,5000+(.@r/2*1000),BF_WEAPON,"{ specialeffect2 EF_GUARD; }"; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2135,'Shadow_Guard','Shadow Guard',4,20,NULL,800,NULL,52,NULL,1,0x00020000,18,2,32,NULL,'70',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2136,'Cracked_Buckler','Cracked Buckler',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFF,63,2,32,NULL,'0',0,2,'bonus bAgi,2; bonus2 bSubEle,Ele_Neutral,10; bonus3 bAutoSpellWhenHit,"PR_KYRIE",10,10; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2137,'Valkyrja\'s_Shield_C','Neo Valkyrja\'s Shield',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,18,2,32,NULL,'95',0,4,'bonus2 bSubEle,Ele_Water,20; bonus2 bSubEle,Ele_Fire,20; bonus2 bSubEle,Ele_Dark,20; bonus2 bSubEle,Ele_Undead,20; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2138,'Bradium_Shield','Bradium Shield',4,20,NULL,1800,NULL,98,NULL,1,0x00CFFF80,18,2,32,NULL,'65',1,3,'bonus2 bSkillAtk,"CR_SHIELDBOOMERANG",60; bonus bAgi,-1; bonus bMaxHP,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2139,'Flame_Thrower','Flame Thrower',4,20000,NULL,2000,NULL,60,NULL,0,0x00000400,63,2,32,NULL,'99',0,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2140,'Energy_Rune_Guard','Energy Rune Guard',4,20,NULL,0,NULL,70,NULL,1,0x00000080,63,2,32,NULL,'99',1,4,'bonus bMaxSPrate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2141,'Freyja_SShield7','Freyja Spirit Shield',4,0,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,63,2,32,NULL,'20',0,1,'bonus2 bSubSize,Size_Medium,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2142,'Freyja_SShield30','Freyja Spirit Shield',4,0,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,63,2,32,NULL,'20',0,1,'bonus2 bSubSize,Size_Medium,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2143,'Freyja_SShield60','Freyja Spirit Shield',4,0,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,63,2,32,NULL,'20',0,1,'bonus2 bSubSize,Size_Medium,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2144,'Freyja_SShield90','Freyja Spirit Shield',4,0,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,63,2,32,NULL,'20',0,1,'bonus2 bSubSize,Size_Medium,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2145,'Time_Keepr_Shield','Time Keeper Shield',4,30000,NULL,0,NULL,20,NULL,0,0xFFFFFFFF,63,2,32,NULL,'0',1,3,'bonus bMdef,1; bonus2 bSubEle,Ele_Neutral,10; bonus2 bSubSize,Size_Medium,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2146,'Siver_Guard','Silver Guard',4,12500,NULL,300,NULL,60,NULL,1,0xFFFFFFFF,63,2,32,NULL,'22',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2147,'Round_Buckler','Round Buckleer',4,24000,NULL,600,NULL,90,NULL,1,0xFFFFFFFE,18,2,32,NULL,'22',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2148,'Rotha_Shield','Rosa Shield',4,56000,NULL,1300,NULL,130,NULL,1,0x00004082,63,2,32,NULL,'100',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2149,'Upg_Guard','Upg Guard',4,20,NULL,150,NULL,25,NULL,1,0xFFFFFFFF,63,2,32,NULL,'1',1,1,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2150,'Upg_Buckler','Upg Buckler',4,20,NULL,300,NULL,45,NULL,1,0x000ED5F2,63,2,32,NULL,'1',1,2,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2151,'Upg_Shield','Upg Shield',4,20,NULL,650,NULL,65,NULL,1,0x00004082,63,2,32,NULL,'1',1,3,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2152,'Anti_Demon_Shield_C','Anti-Demon Shield',4,0,NULL,0,NULL,120,NULL,0,0xFFFFFFFF,63,2,32,NULL,'1',0,3,'bonus2 bSubRace,RC_DemiHuman,25; bonus2 bSubRace,RC_Player,25; bonus2 bSubRace,RC_Demon,25; bonus bMaxHP,400;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2153,'Imperial_Guard','Imperial Guard',4,20,NULL,2500,NULL,120,NULL,1,0x00004000,63,2,32,NULL,'102',1,4,'.@r = getrefine(); bonus bMdef,5; bonus2 bSkillAtk,"LG_SHIELDPRESS",(.@r>=6?20+((.@r-5)*2):20);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2154,'Toy_Shield','Toy Shield',4,0,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,63,2,32,NULL,'10',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2155,'Academy_Shield','Academy Shield',4,0,NULL,1500,NULL,3,NULL,1,0xFFFFFFFE,63,2,32,NULL,'0',1,4,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2156,'Bible_Of_Promise1','Bible of Promise(1st Vol.)',4,20,NULL,500,NULL,10,NULL,1,0x00000100,63,2,32,NULL,'110',1,5,'bonus bMdef,2; skill "ALL_ODINS_POWER",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2157,'Insecticide','Pesticide',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,32,NULL,'0',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2158,'Ramor_Shield_Undead','Ramorushirudo',4,20,NULL,1300,NULL,50,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,3,'bonus2 bSubRace,Ele_Undead,5; bonus2 bSubRace,RC_DemiHuman,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2159,'Sharel_Shield','Sharerushirudo',4,20,NULL,1300,NULL,50,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2160,'Giant_Shield','Giant Shield',4,56000,NULL,2800,NULL,130,NULL,1,0x00004082,63,2,32,NULL,'100',1,3,'bonus2 bSubSize,Size_Large,5; if(getrefine()>=9){ bonus2 bSubSize,Size_Large,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2161,'Geffenia_Book_Water','Geffenia Tomb of Water',4,56000,NULL,1000,NULL,30,NULL,1,0x00000200,63,2,32,NULL,'100',1,5,'bonus bMdef,2; bonus bInt,1; if(readparam(bInt)>=120){ bonus bMatk,10; bonus bMaxHP,800; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2162,'Bible_Of_Promise2','Bible of Promise(2nd Vol.)',4,20,NULL,500,NULL,20,NULL,1,0x00000100,63,2,32,NULL,'140',1,5,'bonus bMdef,5; skill "ALL_ODINS_POWER",2; bonus bHealPower,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2163,'Flow_Shield','Floor Shield',4,20,NULL,1300,NULL,50,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2164,'Sombre_Shield','Bull Son Shield',4,20,NULL,1300,NULL,50,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,3,'bonus2 bSubDefEle,Ele_Dark,5; bonus2 bSubDefEle,Ele_Fire,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2165,'Sol_Shield','Sol Shield',4,20,NULL,1300,NULL,50,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2166,'Exorcism_Bible_','Devil\'s Bible Drive',4,20,NULL,600,NULL,80,NULL,1,0x00008100,63,2,32,NULL,'50',1,5,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2167,'Poison_Shield','Poison Shield',4,20,NULL,1300,NULL,50,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2168,'Immuned_Shield','Immune Shield',4,20,NULL,700,NULL,55,NULL,1,0xFFFFFFFF,63,2,32,NULL,'1',1,4,'.@r = getrefine(); if (.@r>=5) bonus2 bSubEle,Ele_Neutral,min(.@r,12)-4; if(.@r>6) bonus2 bSubEle,Ele_Neutral,5; if(.@r>8) { bonus2 bSubEle,Ele_Fire,5; bonus2 bSubEle,Ele_Water,5; bonus2 bSubEle,Ele_Wind,5; bonus2 bSubEle,Ele_Earth,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2169,'Kalasak','Kalasag',4,20,NULL,400,NULL,40,NULL,0,0xFFFFFFFF,63,2,32,NULL,'1',1,1,'bonus2 bSubClass,Class_Boss,getrefine()/3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2170,'Bayani_Kalasak','Bayani Kalasag',4,20,NULL,400,NULL,40,NULL,1,0xFFFFFFFF,63,2,32,NULL,'1',1,1,'bonus2 bSubClass,Class_Boss,getrefine()/3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2171,'Fox_Armguard','Fox Wrist Guard',4,40000,NULL,200,NULL,45,NULL,1,0x02000000,63,2,32,NULL,'100',1,1,'bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2172,'Wolf_Armguard','Wolf Wrist Guard',4,45000,NULL,250,NULL,70,NULL,1,0x02000000,63,2,32,NULL,'100',1,1,'autobonus "{ bonus bBaseAtk,100; bonus bFlee,-50; }",20,5000,BF_WEAPON,"{ specialeffect2 EF_TEIHIT1; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2173,'Crescent_Armguard','Crescent Wrist Guard',4,45000,NULL,250,NULL,45,NULL,1,0x02000000,63,2,32,NULL,'100',1,1,'bonus bDelayRate,-(getrefine()*2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2174,'Lumiere_Shield','Lumiere Shield',4,20,NULL,1300,NULL,50,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2175,'Esprit_Shield','Spirit Shield',4,20,NULL,1300,NULL,50,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2176,'Dark_Book','Black Book',4,20,NULL,500,NULL,80,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,5,'bonus bMdef,5; .@r = getrefine(); bonus3 bAutoSpellWhenHit,"NPC_DRAGONFEAR",1,(.@r<=6)?(10):((.@r<=8)?(20):(30));',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2177,'Shield_Of_Death','Shield Of Death',4,20,NULL,2000,NULL,150,NULL,1,0xFFFFFFFF,63,2,32,NULL,'90',1,3,'bonus2 bAddClass,Class_Boss,2; bonus2 bMagicAddClass,Class_Boss,2; bonus2 bSubClass,Class_Normal,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2178,'TE_Woe_Buckler','TE Woe Buckler',4,0,NULL,0,NULL,15,NULL,0,0xFFFFFFFF,63,2,32,NULL,'40',1,2,'bonus bMdef,15; bonus bMaxHP,100; bonus bMaxSP,100; bonus2 bSubRace,RC_Player,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2179,'TE_Woe_Shield','TE Woe Shield',4,0,NULL,0,NULL,25,NULL,0,0x000444A2,63,2,32,NULL,'40',1,3,'bonus bMdef,5; bonus bMaxHP,200; bonus2 bSubRace,RC_Player,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2180,'TE_Woe_Magic_Guard','TE Woe Magic Guard',4,0,NULL,0,NULL,5,NULL,0,0x00818315,63,2,32,NULL,'40',1,1,'bonus bMdef,25; bonus bMaxSP,200; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2181,'Hervor','Hervor',4,10,NULL,1500,NULL,100,NULL,0,0xFFFFFFFF,63,2,32,NULL,'1',NULL,2,'bonus bMdef,5; bonus2 bSubRace,RC_All,30; bonus bUnbreakableShield;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2182,'Hervor_Alvitr','Hervor Alvitr',4,0,NULL,3000,NULL,150,NULL,0,0x000FDF80,56,2,32,NULL,'100',0,2,'bonus bMdef,10; bonus bVit,20; bonus2 bSubRace,RC_All,30; bonus bUnbreakableShield; autobonus2 "{ sc_end SC_STUN; sc_end SC_SLEEP; sc_end SC_CURSE; sc_end SC_STONE; sc_end SC_POISON; sc_end SC_BLIND; sc_end SC_SILENCE; sc_end SC_BLEEDING; sc_end SC_CONFUSION; sc_end SC_FREEZE; bonus2 bResEff,Eff_Stun,10000; bonus2 bResEff,Eff_Sleep,10000; bonus2 bResEff,Eff_Curse,10000; bonus2 bResEff,Eff_Stone,10000; bonus2 bResEff,Eff_Poison,10000; bonus2 bResEff,Eff_Blind,10000; bonus2 bResEff,Eff_Silence,10000; bonus2 bResEff,Eff_Bleeding,10000; bonus2 bResEff,Eff_Confusion,10000; bonus2 bResEff,Eff_Freeze,10000; }",10,60000,BF_SHORT;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2183,'Impr_Angel\'s_Safeguard','Advanced Angelic Guard',4,10000,NULL,400,NULL,30,NULL,1,0x00000001,63,2,32,NULL,'99',1,1,'bonus2 bSubRace,RC_Demon,5; bonus2 bSubEle,Ele_All,5; bonus2 bSubEle,Ele_Neutral,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2185,'Magic_Reflector','Magic Reflect',4,10,NULL,1000,NULL,50,NULL,1,0xFFFFFFFF,63,2,32,NULL,'99',1,3,'bonus bMdef,10; bonus bMagicDamageReturn,3+((getrefine()>=9) ? 3 : 0);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2186,'Encyclopedia_Revision','Great Encyclopedia Revision',4,10,NULL,200,'0:5',50,NULL,1,0x00810100,63,2,32,NULL,'99',1,4,'bonus bInt,3; bonus bDex,2; .@r = getrefine(); bonus bCritical,3+((.@r >= 7) ? 2 : 0); if(.@r >= 9) bonus bMatk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2187,'Shield_Of_Gray','Shield of Gray',4,10,NULL,2000,NULL,75,NULL,1,0xFFFFFFFF,56,2,32,NULL,'120',1,3,'.@r = getrefine(); bonus2 bSubEle,Ele_Holy,30+.@r; bonus bMdef,9+.@r/3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2188,'Svalinn_J','Svalinn',4,10,NULL,500,NULL,80,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,3,'.@r = getrefine(); bonus bMaxHP,9+.@r/3; bonus2 bAddEle,Ele_Water,4+.@r/3*5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2189,'Mad_Bunny','Mad Bunny Shield',4,10,NULL,100,NULL,40,NULL,1,0xFFFFFFFF,63,2,32,NULL,'30',1,6,'bonus2 bSubEle,Ele_All,5; bonus bMdef,6; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2190,'Ancient_Shield_Of_Aeon','Ancient Shield Of Aeon',4,0,NULL,200,NULL,5,NULL,0,0x000FDF80,63,2,32,NULL,'130',1,2,'bonus2 bSubEle,Ele_Neutral,10; bonus2 bSubEle,Ele_Fire,10; bonus2 bSubEle,Ele_Water,10; bonus2 bSubEle,Ele_Wind,10; bonus2 bSubEle,Ele_Earth,10; bonus2 bSubEle,Ele_Dark,10; bonus2 bSubEle,Ele_Holy,10; bonus2 bSubEle,Ele_Ghost,10; bonus bMaxHP,500; bonus bMaxSP,50; if(getrefine()>=14) skill "MG_STONECURSE",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2195,'Lian_Shield','Lian Shield',4,0,NULL,1300,NULL,50,NULL,1,0xFFFFFFFF,63,2,32,NULL,'65',1,3,'bonus2 bSubEle,Ele_Neutral,5; bonus2 bSubRace,RC_Formless,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2196,'White_Gold_Shield','White Gold Shield',4,0,NULL,1800,NULL,140,NULL,1,0xFFFFFFFF,63,2,32,NULL,NULL,1,4,'autobonus2 "{ bonus bMagicDamageReturn,20; }",100,2000,BF_MAGIC; /* Confirm: Success rate? */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2198,'Lapine_Shield','Lapine Shield',4,0,NULL,1000,NULL,25,NULL,1,0xFFFFFFFF,63,2,32,NULL,'100',1,3,'bonus bMdef,10; if (getrefine() > 7) { bonus bMatk,20; }',NULL,NULL);
# GM Shield
REPLACE INTO `item_db_re` VALUES (2199,'Ahura_Mazda','Ahura Mazdah',4,1,NULL,10,NULL,10000,NULL,0,0xFFFFFFFF,63,2,32,NULL,'1',1,1,'bonus bAllStats,50; bonus bMdef,99; bonus bShortWeaponDamageReturn,100; bonus2 bSubRace,RC_DemiHuman,95; bonus2 bSubRace,RC_Player,95; skill "CR_FULLPROTECTION",5; skill "WZ_ESTIMATION",1; skill "ST_FULLSTRIP",5; skill "HW_MAGICPOWER",10; skill "ECL_SNOWFLIP",1; skill "ECL_PEONYMAMY",1; skill "ECL_SADAGUI",1; skill "ECL_SEQUOIADUST",1; bonus bMaxHPrate,200; bonus bNoKnockback; bonus bDelayRate,-20; bonus bSpeedRate,25; bonus bIntravision; bonus bNoWalkDelay;',NULL,NULL);
#===================================================================
# Headgears
#===================================================================
REPLACE INTO `item_db_re` VALUES (2201,'Sunglasses','Sunglasses',4,5000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,12,'bonus2 bResEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2202,'Sunglasses_','Sunglasses',4,5000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,512,NULL,'0',0,12,'bonus2 bResEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2203,'Glasses','Glasses',4,4000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2204,'Glasses_','Glasses',4,4000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,512,NULL,'0',0,3,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2205,'Diver\'s_Goggles','Diver Goggles',4,3500,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,10,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2206,'Wedding_Veil','Wedding Veil',4,23000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,0,256,NULL,'0',1,44,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2207,'Fancy_Flower','Fancy Flower',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,4,'bonus2 bSubRace,RC_Plant,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2208,'Ribbon','Ribbon',4,800,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,0,256,NULL,'0',1,17,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2209,'Ribbon_','Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,0,256,NULL,'0',1,17,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2210,'Hair_Band','Hair Band',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,9,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2211,'Bandana','Bandana',4,400,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,6,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2212,'Eye_Bandage','Eye Patch',4,1000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2213,'Cat_Hairband','Kitty Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,2,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2214,'Bunny_Band','Bunny Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,15,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2215,'Flower_Hairband','Flower Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,5,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2216,'Biretta','Biretta',4,9000,NULL,100,NULL,8,NULL,0,0x00008110,63,2,256,NULL,'0',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2217,'Biretta_','Biretta',4,9000,NULL,100,NULL,8,NULL,1,0x00008110,63,2,256,NULL,'0',1,11,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2218,'Flu_Mask','Flu Mask',4,300,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,8,'bonus2 bResEff,Eff_Silence,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2219,'Flu_Mask_','Flu Mask',4,300,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,8,'bonus2 bResEff,Eff_Silence,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2220,'Hat','Hat',4,1000,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,16,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2221,'Hat_','Hat',4,1000,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,16,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2222,'Turban','Turban',4,4500,NULL,300,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2223,'Turban_','Turban',4,4500,NULL,300,NULL,3,NULL,1,0xFFFFFFFE,63,2,256,NULL,'0',1,7,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2224,'Goggle','Goggles',4,20,NULL,300,NULL,5,NULL,0,0x000E5CEA,63,2,768,NULL,'0',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2225,'Goggle_','Goggles',4,20,NULL,300,NULL,5,NULL,1,0x000E5CEA,63,2,768,NULL,'0',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2226,'Cap','Cap',4,12000,NULL,400,NULL,7,NULL,0,0x000E5CEA,63,2,256,NULL,'0',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2227,'Cap_','Cap',4,12000,NULL,400,NULL,7,NULL,1,0x000E5CEA,63,2,256,NULL,'0',1,14,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2228,'Helm','Helm',4,44000,NULL,600,NULL,13,NULL,0,0x00004082,63,2,256,NULL,'0',1,40,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2229,'Helm_','Helm',4,44000,NULL,600,NULL,13,NULL,1,0x00004082,63,2,256,NULL,'0',1,40,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2230,'Gemmed_Sallet','Gemmed Sallet',4,50000,NULL,500,NULL,8,NULL,0,0x000654E2,63,2,256,NULL,'0',1,0,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2231,'Gemmed_Sallet_','Gemmed Sallet',4,50000,NULL,500,NULL,8,NULL,1,0x000654E2,63,2,256,NULL,'0',1,0,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2232,'Circlet','Circlet',4,7500,NULL,300,NULL,6,NULL,0,0x00818314,63,2,256,NULL,'0',1,18,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2233,'Circlet_','Circlet',4,7500,NULL,300,NULL,6,NULL,1,0x00818314,63,2,256,NULL,'0',1,18,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2234,'Tiara','Tiara',4,20,NULL,400,NULL,7,NULL,0,0xFFFFFFFE,63,0,256,NULL,'45',1,19,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2235,'Crown','Crown',4,20,NULL,400,NULL,7,NULL,0,0xFFFFFFFE,63,1,256,NULL,'45',1,45,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2236,'Santa\'s_Hat','Santa Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,20,'bonus bMdef,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2237,'Weird_Goatee','Bandit Beard',4,2,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,21,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2238,'Weird_Moustache','Moustache',4,2,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,22,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2239,'One_Eyed_Glass','Monocle',4,10000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,23,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2240,'Beard','Beard',4,2,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,24,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2241,'Granpa_Beard','Grampa Beard',4,5000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,25,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2242,'Luxury_Sunglasses','Purple Glasses',4,24000,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,26,'bonus2 bResEff,Eff_Blind,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2243,'Spinning_Eyes','Geek Glasses',4,20000,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,27,'bonus2 bResEff,Eff_Blind,1500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2244,'Big_Sis\'_Ribbon','Big Ribbon',4,15000,NULL,200,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,28,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2245,'Sweet_Gents','Sweet Gent',4,15000,NULL,400,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,29,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2246,'Golden_Gear','Golden Gear',4,20,NULL,900,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'40',1,30,'bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2247,'Oldman\'s_Romance','Romantic Gent',4,15000,NULL,400,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,31,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2248,'Western_Grace','Western Grace',4,15000,NULL,400,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,32,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2249,'Coronet','Coronet',4,20,NULL,300,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,33,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2250,'Fillet','Cute Ribbon',4,500,NULL,100,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,34,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2251,'Holy_Bonnet','Monk Hat',4,30000,NULL,100,NULL,10,NULL,0,0x00008110,63,2,256,NULL,'0',1,35,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2252,'Star_Sparkling','Wizard Hat',4,20,NULL,300,NULL,7,NULL,0,0x00810204,63,2,256,NULL,'0',1,36,'bonus bMaxSP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2253,'Sunflower','Sunflower',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,37,'bonus2 bSubRace,RC_Insect,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2254,'Angelic_Chain','Angel Wing',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,38,'bonus bMdef,3; bonus bAgi,1; bonus bLuk,1; bonus2 bSubRace,RC_Demon,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2255,'Satanic_Chain','Evil Wing',4,20,NULL,100,NULL,6,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,39,'bonus bMdef,2; bonus bStr,1; bonus2 bSubRace,RC_Angel,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2256,'Magestic_Goat','Majestic Goat',4,20,NULL,800,NULL,9,NULL,0,0x006444A2,63,2,256,NULL,'0',1,41,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2257,'Snowy_Horn','Unicorn Horn',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,42,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2258,'Sharp_Gear','Spiky Band',4,20,NULL,1000,NULL,12,NULL,0,0x0066D5F2,63,2,256,NULL,'50',1,43,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2259,'Mini_Propeller','Mini Propeller',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,46,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2260,'Mini_Glasses','Mini Glasses',4,28000,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,512,NULL,'0',0,47,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2261,'Prontera_Army_Cap','Army Cap',4,20,NULL,400,NULL,8,NULL,0,0x000654E2,63,2,256,NULL,'0',1,48,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2262,'Pierrot_Nose','Clown Nose',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,49,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2263,'Gangster_Patch','Zorro Masque',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,512,NULL,'0',0,50,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2264,'Munak_Turban','Munak Hat',4,20,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,63,2,769,NULL,'0',0,51,'bonus2 bSubRace,RC_Undead,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2265,'Ganster_Mask','Gangster Mask',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,52,'bonus2 bResEff,Eff_Silence,1500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2266,'Iron_Cane','Iron Cain',4,20,NULL,300,NULL,4,NULL,0,0x00004082,63,2,1,NULL,'50',0,53,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2267,'Cigar','Cigarette',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,1,NULL,'0',0,54,'bonus2 bSubRace,RC_Insect,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2268,'Smoking_Pipe','Pipe',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,1,NULL,'0',0,55,'bonus2 bSubRace,RC_Insect,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2269,'Centimental_Flower','Romantic Flower',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,1,NULL,'0',0,56,'bonus2 bSubRace,RC_Plant,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2270,'Centimental_Leaf','Romantic Leaf',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,1,NULL,'0',0,57,'bonus2 bSubRace,RC_Plant,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2271,'Jack_A_Dandy','Jack be Dandy',4,45000,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,58,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2272,'Stop_Post','Stop Post',4,20,NULL,400,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,59,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2273,'Doctor_Cap','Doctor Band',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,60,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2274,'Ghost_Bandana','Ghost Bandana',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,61,'bonus bAgi,2; bonus2 bSubEle,Ele_Ghost,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2275,'Red_Bandana','Red Bandana',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,62,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2276,'Eagle_Eyes','Angled Glasses',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,63,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2277,'Nurse_Cap','Nurse Cap',4,20,NULL,100,NULL,4,NULL,0,0x00008110,63,2,256,NULL,'0',1,64,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2278,'Mr_Smile','Mr. Smile',4,60,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,513,NULL,'0',0,65,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2279,'Bomb_Wick','Bomb Wick',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,66,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2280,'Sahkkat','Sakkat',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,67,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2281,'Phantom_Of_Opera','Opera Masque',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,63,2,513,NULL,'0',0,68,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2282,'Spirit_Chain','Halo',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,69,'bonus2 bSubEle,Ele_Holy,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2283,'Ear_Mufs','Ear Muffs',4,20,NULL,200,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,70,'bonus2 bResEff,Eff_Curse,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2284,'Antler','Antlers',4,20,NULL,500,NULL,8,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,71,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2285,'Apple_Of_Archer','Apple of Archer',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'30',1,72,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2286,'Elven_Ears','Elven Ears',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,512,NULL,'70',0,73,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2287,'Pirate_Bandana','Pirate Bandana',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,74,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2288,'Mr_Scream','Mr. Scream',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,513,NULL,'0',0,75,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2289,'Poo_Poo_Hat','Poo Poo Hat',4,20,NULL,700,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,76,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2290,'Funeral_Costume','Funeral Hat',4,3000,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,77,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2291,'Masquerade','Masquerade',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,512,NULL,'0',0,78,'bonus2 bAddRace,RC_DemiHuman,3; bonus2 bAddRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2292,'Welding_Mask','Welding Mask',4,20,NULL,300,NULL,2,NULL,0,0x00040420,63,2,513,NULL,'50',0,79,'bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2293,'Pretend_Murdered','Pretend Murdered',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,80,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2294,'Star_Dust','Stellar',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,81,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2295,'Blinker','Blinker',4,1500,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,512,NULL,'0',0,82,'bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2296,'Binoculars','Binoculars',4,20,NULL,100,NULL,2,NULL,0,0x00080808,63,2,512,NULL,'50',0,83,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2297,'Goblini_Mask','Goblin Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,513,NULL,'0',0,84,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2298,'Green_Feeler','Green Feeler',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,85,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2299,'Viking_Helm','Orc Helm',4,20,NULL,500,NULL,9,NULL,0,0x000654E2,63,2,256,NULL,'0',1,86,NULL,NULL,NULL);
#===================================================================
# Armors
#===================================================================
REPLACE INTO `item_db_re` VALUES (2301,'Cotton_Shirt','Cotton Shirt',4,10,NULL,100,NULL,10,NULL,0,0xFFFFFFFF,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2302,'Cotton_Shirt_','Cotton Shirt',4,10,NULL,100,NULL,10,NULL,1,0xFFFFFFFF,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2303,'Leather_Jacket','Jacket',4,200,NULL,200,NULL,15,NULL,0,0xFFFFFFFF,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2304,'Leather_Jacket_','Jacket',4,200,NULL,200,NULL,15,NULL,1,0xFFFFFFFF,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2305,'Adventure_Suit','Adventurer\'s Suit',4,1000,NULL,300,NULL,20,NULL,0,0xFFFFFFFF,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2306,'Adventurere\'s_Suit_','Adventurer\'s Suit',4,1000,NULL,300,NULL,20,NULL,1,0xFFFFFFFF,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2307,'Mantle','Mantle',4,10000,NULL,600,NULL,37,NULL,0,0xFFFFFFFE,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2308,'Mantle_','Mantle',4,10000,NULL,600,NULL,37,NULL,1,0xFFFFFFFE,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2309,'Coat','Coat',4,22000,NULL,1200,NULL,42,NULL,0,0xFFFFFFFE,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2310,'Coat_','Coat',4,22000,NULL,1200,NULL,42,NULL,1,0xFFFFFFFE,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2311,'Mink_Coat','Mink Coat',4,20,NULL,2300,NULL,30,NULL,1,0xFFFFFFFE,63,2,16,NULL,'30',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2312,'Padded_Armor','Padded Armor',4,48000,NULL,2800,NULL,35,NULL,0,0x000654E2,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2313,'Padded_Armor_','Padded Armor',4,48000,NULL,2800,NULL,35,NULL,1,0x000654E2,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2314,'Chain_Mail','Chain Mail',4,65000,NULL,3300,NULL,55,NULL,0,0x000654E2,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2315,'Chain_Mail_','Chain Mail',4,65000,NULL,3300,NULL,55,NULL,1,0x000654E2,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2316,'Plate_Armor','Full Plate',4,80000,NULL,4500,NULL,70,NULL,0,0x00004082,63,2,16,NULL,'40',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2317,'Plate_Armor_','Full Plate',4,80000,NULL,4500,NULL,70,NULL,1,0x00004082,63,2,16,NULL,'40',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2318,'Clothes_Of_The_Lord','Lord\'s Clothes',4,20,NULL,2500,NULL,59,NULL,1,0x00040420,63,2,16,NULL,'70',1,0,'bonus bMdef,5; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2319,'Glittering_Clothes','Glittering Jacket',4,20,NULL,2500,NULL,58,NULL,1,0xFFFFFFFE,63,2,16,NULL,'60',1,0,'bonus bMdef,5; bonus2 bAddEff,Eff_Blind,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2320,'Formal_Suit','Formal Suit',4,20,NULL,300,NULL,40,NULL,1,0xFFFFFFFE,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2321,'Silk_Robe','Silk Robe',4,8000,NULL,400,NULL,20,NULL,0,0x0085C7B6,63,2,16,NULL,'0',1,0,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2322,'Silk_Robe_','Silk Robe',4,8000,NULL,400,NULL,20,NULL,1,0x0085C7B6,63,2,16,NULL,'0',1,0,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2323,'Scapulare','Scapulare',4,6500,NULL,400,NULL,24,NULL,0,0x00008110,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2324,'Scapulare_','Scapulare',4,6500,NULL,400,NULL,24,NULL,1,0x00008110,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2325,'Saint_Robe','Saint\'s Robe',4,54000,NULL,600,NULL,50,NULL,0,0x00048530,63,2,16,NULL,'0',1,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2326,'Saint_Robe_','Saint\'s Robe',4,54000,NULL,600,NULL,50,NULL,1,0x00048530,63,2,16,NULL,'0',1,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2327,'Holy_Robe','Holy Robe',4,20,NULL,1700,NULL,57,NULL,0,0x00008110,63,2,16,NULL,'60',1,0,'bonus bMdef,5; bonus2 bSubRace,RC_Demon,15; bonus2 bSubEle,Ele_Dark,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2328,'Wooden_Mail','Wooden Mail',4,5500,NULL,1000,NULL,25,NULL,0,0x000444A2,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2329,'Wooden_Mail_','Wooden Mail',4,5500,NULL,1000,NULL,25,NULL,1,0x000444A2,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2330,'Tights','Tights',4,71000,NULL,500,NULL,27,NULL,0,0x00080808,63,2,16,NULL,'45',1,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2331,'Tights_','Tights',4,71000,NULL,500,NULL,27,NULL,1,0x00080808,63,2,16,NULL,'45',1,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2332,'Silver_Robe','Silver Robe',4,7000,NULL,700,NULL,23,NULL,0,0x00810204,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2333,'Silver_Robe_','Silver Robe',4,7000,NULL,700,NULL,23,NULL,1,0x00810204,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2334,'Mage_Coat','Mage Coat',4,20,NULL,600,NULL,40,NULL,0,0x00810204,63,2,16,NULL,'50',1,0,'bonus bMdef,5; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2335,'Thief_Clothes','Thief Clothes',4,74000,NULL,100,NULL,40,NULL,0,0x02021040,63,2,16,NULL,'0',1,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2336,'Thief_Clothes_','Thief Clothes',4,74000,NULL,100,NULL,40,NULL,1,0x02021040,63,2,16,NULL,'0',1,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2337,'Ninja_Suit','Ninja Suit',4,20,NULL,1500,NULL,58,NULL,0,0x02021040,63,2,16,NULL,'50',1,0,'bonus bAgi,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2338,'Wedding_Dress','Wedding Dress',4,43000,NULL,500,NULL,10,NULL,0,0xFFFFFFFE,63,2,16,NULL,'0',1,0,'bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2339,'G_Strings','Pantie',4,1000,NULL,100,NULL,22,NULL,0,0xFFFFFFFF,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2340,'Novice_Breast','Novice Breastplate',4,89000,NULL,500,NULL,4,NULL,1,0x00000001,63,2,16,NULL,'10',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2341,'Full_Plate_Armor','Legion Plate Armor',4,94000,NULL,5500,NULL,79,NULL,0,0x00004000,63,2,16,NULL,'70',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2342,'Full_Plate_Armor_','Legion Plate Armor',4,102500,NULL,5500,NULL,79,NULL,1,0x00004000,63,2,16,NULL,'70',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2343,'Robe_Of_Casting','Robe of Cast',4,124800,NULL,1100,NULL,40,NULL,0,0x00810200,63,2,16,NULL,'75',1,0,'bonus bVariableCastrate,-3; bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2344,'Flame_Sprits_Armor','Lucius\'s Fierce Armor of Volcano',4,136000,NULL,2200,NULL,25,NULL,0,0x000444A2,63,2,16,NULL,'45',1,0,'bonus bDefEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2345,'Flame_Sprits_Armor_','Lucius\'s Fierce Armor of Volcano',4,136000,NULL,2200,NULL,25,NULL,1,0xFFFFFFFE,63,2,16,NULL,'45',1,0,'bonus bDefEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2346,'Water_Sprits_Armor','Saphien\'s Armor of Ocean',4,136000,NULL,2200,NULL,25,NULL,0,0x000444A2,63,2,16,NULL,'45',1,0,'bonus bDefEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2347,'Water_Sprits_Armor_','Saphien\'s Armor of Ocean',4,136000,NULL,2200,NULL,25,NULL,1,0xFFFFFFFE,63,2,16,NULL,'45',1,0,'bonus bDefEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2348,'Wind_Sprits_Armor','Aebecee\'s Raging Typhoon Armor',4,136000,NULL,2200,NULL,25,NULL,0,0x000444A2,63,2,16,NULL,'45',1,0,'bonus bDefEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2349,'Wind_Sprits_Armor_','Aebecee\'s Raging Typhoon Armor',4,136000,NULL,2200,NULL,25,NULL,1,0xFFFFFFFE,63,2,16,NULL,'45',1,0,'bonus bDefEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2350,'Earth_Sprits_Armor','Claytos Cracking Earth Armor',4,136000,NULL,2200,NULL,25,NULL,0,0x000444A2,63,2,16,NULL,'45',1,0,'bonus bDefEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2351,'Earth_Sprits_Armor_','Claytos Cracking Earth Armor',4,136000,NULL,2200,NULL,25,NULL,1,0xFFFFFFFE,63,2,16,NULL,'45',1,0,'bonus bDefEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2352,'Novice_Plate','Tattered Novice Ninja Suit',4,1,NULL,1,NULL,25,NULL,0,0x00000001,63,2,16,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2353,'Odin\'s_Blessing','Odin\'s Blessing',4,30000,NULL,2500,NULL,53,NULL,1,0xFFFFFFFE,63,2,16,NULL,'65',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2354,'Goibne\'s_Armor','Goibne\'s Armor',4,50000,NULL,3500,NULL,58,NULL,0,0xFFFFFFFE,63,2,16,NULL,'54',1,0,'bonus bVit,2; bonus bMaxHPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2355,'Angel\'s_Protection','Angelic Protection',4,10000,NULL,600,NULL,25,NULL,1,0x00000001,63,2,16,NULL,'40',1,0,'bonus bMdef,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2356,'Vestment_Of_Grace','Blessed Holy Robe',4,20,NULL,2500,NULL,45,NULL,1,0x00008100,63,2,16,NULL,'70',1,0,'bonus bMdef,5; bonus2 bResEff,Eff_Blind,8000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2357,'Valkyrie_Armor','Valkyrian Armor',4,0,NULL,2800,NULL,55,NULL,1,0xFFFFFFFE,18,2,16,NULL,'1',1,0,'bonus bAllStats,1; bonus bUnbreakableArmor; if(BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte) bonus2 bResEff,Eff_Silence,5000; else if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief) bonus2 bResEff,Eff_Stun,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2358,'Dress_Of_Angel','Angel\'s Dress',4,20,NULL,1000,NULL,5,NULL,0,0xFFFFFFFF,63,2,16,NULL,'0',0,0,'bonus bLuk,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2359,'Ninja_Suit_','Ninja Suit',4,20,NULL,1500,NULL,58,NULL,1,0x02021040,63,2,16,NULL,'50',1,0,'bonus bAgi,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2360,'Robe_Of_Casting_','Robe of Cast',4,124800,NULL,1100,NULL,40,NULL,1,0x00810200,63,2,16,NULL,'75',1,0,'bonus bVariableCastrate,-3; bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2361,'Blue_Aodai','Blue Robe',4,20,NULL,500,NULL,0,NULL,0,0xFFFFFFFE,63,2,16,NULL,'1',1,0,'bonus bAllStats,3; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2362,'Red_Aodai','Red Robe',4,20,NULL,500,NULL,0,NULL,0,0xFFFFFFFE,63,2,16,NULL,'1',1,0,'bonus bAllStats,3; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2363,'White_Aodai','White Robe',4,20,NULL,500,NULL,0,NULL,0,0x00000001,63,2,16,NULL,'1',1,0,'bonus bAllStats,3; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2364,'Meteo_Plate_Armor','Meteo Plate Armor',4,20,NULL,3000,NULL,85,NULL,1,0x000444A2,18,2,16,NULL,'55',1,0,'bonus2 bResEff,Eff_Stun,3000; bonus2 bResEff,Eff_Freeze,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2365,'Orleans_Gown','Orleans\'s Gown',4,20,NULL,300,NULL,15,NULL,1,0xFFFFFFFE,18,2,16,NULL,'55',1,0,'bonus bVariableCastrate,15; bonus bNoCastCancel;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2366,'Divine_Cloth','Divine Cloth',4,20,NULL,1500,NULL,50,NULL,1,0xFFFFFFFE,18,2,16,NULL,'55',1,0,'bonus2 bResEff,Eff_Curse,500; bonus2 bResEff,Eff_Silence,500; bonus2 bResEff,Eff_Stun,500; bonus2 bResEff,Eff_Stone,500; bonus2 bResEff,Eff_Sleep,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2367,'Sniping_Suit','Sniping Suit',4,20,NULL,750,NULL,42,NULL,1,0x00000800,18,2,16,NULL,'50',1,0,'bonus bMdef,5; bonus bCritical,6+(readparam(bLuk)/10); bonus bDelayRate,-23;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2368,'Golden_Armor','Golden Armor',4,20,NULL,2000,NULL,4,NULL,0,0xFFFFFFFF,63,2,16,NULL,'0',0,0,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2369,'Freyja_Overcoat','Freyja Overcoat',4,0,NULL,500,NULL,12,NULL,0,0xFFFFFFFE,63,2,16,NULL,'0',0,0,'bonus bUnbreakableArmor; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2370,'Used_Mage_Coat','Used Mage Coat',4,0,NULL,0,NULL,15,NULL,0,0xFFFFFFFF,63,2,16,NULL,'0',0,0,'bonus bMaxHP,300; bonus bMaxSP,30; bonus bBaseAtk,10; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2371,'G_Strings_','Pantie',4,1000,NULL,100,NULL,22,NULL,1,0xFFFFFFFF,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2372,'Mage_Coat_','Mage Coat',4,20,NULL,600,NULL,40,NULL,1,0x00810204,63,2,16,NULL,'50',1,0,'bonus bMdef,5; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2373,'Holy_Robe_','Holy Robe',4,20,NULL,1700,NULL,57,NULL,1,0x00008110,63,2,16,NULL,'60',1,0,'bonus bMdef,5; bonus2 bSubRace,RC_Demon,15; bonus2 bSubEle,Ele_Dark,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2374,'Diabolus_Robe','Diabolus Robe',4,20,NULL,300,NULL,57,NULL,1,0x00098B1C,18,2,16,NULL,'55',1,0,'bonus bMaxSP,150; bonus bMdef,5; bonus bHealPower,6; bonus bDelayRate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2375,'Diabolus_Armor','Diabolus Armor',4,20,NULL,600,NULL,79,NULL,1,0x000654E2,18,2,16,NULL,'55',1,0,'bonus bStr,2; bonus bDex,1; bonus bMdef,5; bonus bMaxHP,150; bonus2 bResEff,Eff_Stun,500; bonus2 bResEff,Eff_Stone,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2376,'Assaulter_Plate','Assaulter Plate',4,10,NULL,0,NULL,57,NULL,1,0x006444A2,63,2,16,NULL,'80',1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2377,'Elite_Engineer_Armor','Elite Engineer Armor',4,10,NULL,0,NULL,50,NULL,1,0x00040420,63,2,16,NULL,'80',1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2378,'Assassin_Robe','Assassin Robe',4,10,NULL,0,NULL,41,NULL,1,0x02021040,63,2,16,NULL,'80',1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2379,'Warlock_Battle_Robe','Warlock\'s Battle Robe',4,10,NULL,0,NULL,36,NULL,1,0x00810204,63,2,16,NULL,'80',1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2380,'Medic_Robe','Medic\'s Robe',4,10,NULL,0,NULL,25,NULL,1,0x00008110,63,2,16,NULL,'80',1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2381,'Elite_Archer_Suit','Elite Archer Suit',4,10,NULL,0,NULL,35,NULL,1,0x00080808,63,2,16,NULL,'80',1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2382,'Elite_Shooter_Suit','Elite Shooter Suit',4,10,NULL,0,NULL,25,NULL,1,0x41000000,63,2,16,NULL,'80',1,0,'bonus bMaxHP,150; bonus bMdef,2; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2383,'Brynhild','Brynhild',4,20,NULL,400,NULL,120,NULL,0,0xFFFFFFFF,63,2,16,NULL,'94',0,0,'bonus bMdef,10; bonus bMaxHP,20*BaseLevel; bonus bMaxSP,5*BaseLevel; bonus2 bAddClass,Class_All,10; bonus bMatkRate,10; bonus bUnbreakableArmor; bonus bNoKnockback;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2384,'Spritual_Tunic','Spiritual Tunic',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,63,2,16,NULL,'0',0,0,'bonus bMdef,5; bonus bMaxHP,800; bonus2 bResEff,Eff_Freeze,10000; bonus2 bSubEle,Ele_Earth,20; bonus2 bSubEle,Ele_Fire,20; bonus2 bSubEle,Ele_Wind,20; bonus2 bSubEle,Ele_Poison,20; bonus2 bSubEle,Ele_Holy,20; bonus2 bSubEle,Ele_Dark,20; bonus2 bSubEle,Ele_Ghost,20; bonus2 bSubEle,Ele_Undead,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2385,'Recuperative_Armor','Recuperative Armor',4,20,NULL,0,NULL,12,NULL,0,0xFFFFFFFF,63,2,16,NULL,'0',0,0,'bonus bNoRegen,1; bonus bNoRegen,2; bonus bHPGainValue,60; bonus bSPGainValue,6; bonus bMagicHPGainValue,60; bonus bMagicSPGainValue,6;',NULL,'heal 0,-100;');
REPLACE INTO `item_db_re` VALUES (2386,'Chameleon_Armor','Chameleon Armor',4,20,NULL,1700,NULL,55,NULL,0,0x00CFFF80,18,2,16,NULL,'70',1,0,'bonus bMaxHP,(BaseLevel*7); bonus bMaxSP,(BaseLevel/2); autobonus2 "{ bonus bNoMagicDamage,100; }",10,2000,BF_MAGIC,"{ specialeffect2 EF_ENERGYCOAT; }"; if( BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte ) bonus bMdef,5; else if( BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief ) bonus bDef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2387,'Sprint_Mail','Sprint Mail',4,20,NULL,1000,NULL,20,NULL,1,0x00CFFF80,18,2,16,NULL,'70',1,0,'bonus bVit,1; bonus bHPrecovRate,5; bonus bAddItemHealRate,3; bonus2 bSkillHeal,"AL_HEAL",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2388,'Kandura','Kandura',4,20,NULL,300,NULL,36,NULL,1,0x00001000,18,2,16,NULL,'70',1,0,'bonus bAgi,1; bonus bFlee,5; bonus bAspdRate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2389,'Armor_Of_Naga','Armor of Naga',4,20,NULL,1000,NULL,45,NULL,1,0x00CFFF80,18,2,16,NULL,'70',1,0,'bonus bMdef,2; autobonus "{ bonus bBaseAtk,20; }",10,10000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2390,'Improved_Tights','Improved Tights',4,20,NULL,400,NULL,38,NULL,1,0x00080808,18,2,16,NULL,'75',1,0,'bonus bMdef,2; bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2391,'Life_Link','Life Link',4,20,NULL,3500,NULL,75,NULL,1,0x00004082,18,2,16,NULL,'82',1,0,'bonus bVit,2; bonus bMdef,5; bonus bHPrecovRate,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2392,'Old_Pant','Old Green Pantie',4,0,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,63,2,16,NULL,'0',0,0,'bonus bStr,2; bonus bVit,2; bonus bMaxHP,200; bonus3 bAutoSpellWhenHit,"MO_CALLSPIRITS",5,20; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2393,'N_Adventurer\'s_Suit','Novice Adventurer\'s Suit',4,0,NULL,0,NULL,45,NULL,1,0xFFFFFFFF,63,2,16,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2394,'Krieger_Suit1','Glorious Suit',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFE,63,2,16,NULL,'81',1,0,'bonus bMaxHPrate,20; bonus2 bSubRace,RC_DemiHuman,7; bonus2 bSubRace,RC_Player,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2395,'Krieger_Suit2','Glorious Popularized Suit',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFE,63,2,16,NULL,'61',1,0,'bonus bMaxHP,600; bonus bSPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2396,'Krieger_Suit3','Glorious Mass-Production Suit',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,16,NULL,'0',1,0,'bonus bMaxHP,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2397,'Incredible_Coat','Incredible Event Resignation Coat',4,10,NULL,900,NULL,2,NULL,0,0xFFFFFFFE,63,2,16,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2398,'Sniping_Suit_M','Sniping Suit',4,20,NULL,750,NULL,42,NULL,1,0x00000800,18,2,16,NULL,'50',1,0,'bonus bMdef,5; bonus bCritical,6+(readparam(bLuk)/10); bonus bDelayRate,-23;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2399,'Dragon_Vest','Dragon Vest',4,20,NULL,500,NULL,20,NULL,1,0xFFFFFFFE,18,2,16,NULL,'0',1,0,'bonus bMdef,3;',NULL,NULL);
#===================================================================
# Footgears
#===================================================================
REPLACE INTO `item_db_re` VALUES (2401,'Sandals','Sandals',4,400,NULL,200,NULL,5,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2402,'Sandals_','Sandals',4,400,NULL,200,NULL,5,NULL,1,0xFFFFFFFF,63,2,64,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2403,'Shoes','Shoes',4,3500,NULL,400,NULL,10,NULL,0,0xFFFFFFFE,63,2,64,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2404,'Shoes_','Shoes',4,3500,NULL,400,NULL,10,NULL,1,0xFFFFFFFE,63,2,64,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2405,'Boots','Boots',4,18000,NULL,600,NULL,16,NULL,0,0x416E5CEA,63,2,64,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2406,'Boots_','Boots',4,18000,NULL,600,NULL,16,NULL,1,0x416E5CEA,63,2,64,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2407,'Chrystal_Pumps','Crystal Pumps',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFE,63,0,64,NULL,'0',1,0,'bonus bMdef,10; bonus bLuk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2408,'Cuffs','Shackles',4,5000,NULL,3000,NULL,18,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2409,'Spiky_Heel','High Heels',4,8500,NULL,600,NULL,4,NULL,0,0xFFFFFFFE,63,2,64,NULL,'0',1,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2410,'Sleipnir','Sleipnir',4,20,NULL,3500,NULL,40,NULL,0,0xFFFFFFFF,63,2,64,NULL,'94',0,0,'bonus bMdef,10; bonus bMaxHPrate,20; bonus bMaxSPrate,20; bonus bSPrecovRate,25; bonus bSpeedRate,25; bonus bInt,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2411,'Grave','Greaves',4,48000,NULL,750,NULL,27,NULL,0,0x00004080,63,2,64,NULL,'65',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2412,'Grave_','Greaves',4,54000,NULL,750,NULL,15,NULL,1,0x00004080,63,2,64,NULL,'65',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2413,'Safty_Boots','Safety Boots',4,34000,NULL,350,NULL,6,NULL,0,0x00004082,63,2,64,NULL,'30',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2414,'Novice_Boots','Novice Slippers',4,1,NULL,1,NULL,5,NULL,0,0x00000001,63,2,64,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2415,'Slipper','Bunny Slipper',4,34000,NULL,300,NULL,3,NULL,1,0xFFFFFFFE,63,0,64,NULL,'30',1,0,'bonus bLuk,3; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2416,'Novice_Shoes','Novice Shoes',4,35000,NULL,500,NULL,8,NULL,1,0x00000001,63,2,64,NULL,'40',1,0,'bonus bMaxHPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2417,'Fricco_Shoes','Fricco\'s Shoes',4,30000,NULL,500,NULL,12,NULL,0,0xFFFFFFFE,63,2,64,NULL,'65',1,0,'bonus bAgi,2; bonus2 bAddItemGroupHealRate,IG_Potion,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2418,'Vidar\'s_Boots','Vidar\'s Boots',4,30000,NULL,650,NULL,13,NULL,0,0xFFFFFFFE,63,2,64,NULL,'65',1,0,'bonus bMaxHPrate,9; bonus bMaxSPrate,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2419,'Goibne\'s_Combat_Boots','Goibne\'s Greaves',4,30000,NULL,700,NULL,13,NULL,0,0xFFFFFFFE,63,2,64,NULL,'54',1,0,'bonus bMdef,3; bonus bMaxHPrate,5; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2420,'Angel\'s_Arrival','Angel\'s Reincarnation',4,10000,NULL,300,NULL,8,NULL,1,0x00000001,63,2,64,NULL,'25',1,0,'bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2421,'Valkyrie_Shoes','Valkyrian Shoes',4,0,NULL,500,NULL,13,NULL,1,0xFFFFFFFE,18,2,64,NULL,'1',1,0,'bonus bUnbreakableShoes; if(BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte) bonus bMaxHP,(BaseLevel*5); else if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief) bonus bMaxSP,(JobLevel*2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2422,'High_Fashion_Sandals','High Fashion Sandals',4,24000,NULL,200,NULL,7,NULL,1,0x00818314,63,2,64,NULL,'40',1,0,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2423,'Variant_Shoes','Variant Shoes',4,20,NULL,500,NULL,13,NULL,0,0xFFFFFFFE,18,2,64,NULL,'85',1,0,'.@r = getrefine(); bonus bMaxHPrate,20-.@r; bonus bMaxSPrate,20-.@r; bonus bDef,.@r/2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2424,'Tidal_Shoes','Tidal Shoes',4,20,NULL,300,NULL,13,NULL,1,0xFFFFFFFE,18,2,64,NULL,'55',1,0,'bonus2 bSubEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2425,'Black_Leather_Boots','Black Leather Boots',4,20,NULL,500,NULL,16,NULL,0,0xFFFFFFFE,18,2,64,NULL,'55',1,0,'bonus bAgi,(getrefine()>=9?3:1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2426,'Shadow_Walk','Shadow Walk',4,20,NULL,2000,NULL,0,NULL,0,0xFFFFFFFE,18,2,64,NULL,'75',1,0,'bonus bMdef,10; bonus5 bAutoSpellWhenHit,"AS_CLOAKING",max(2,getskilllv("AS_CLOAKING")),100,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2427,'Golden_Shoes','Golden Shoes',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',0,0,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2428,'Freyja_Boots','Freyja Boots',4,0,NULL,300,NULL,10,NULL,0,0xFFFFFFFE,63,2,64,NULL,'0',0,0,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2429,'Iron_Boots01','Iron Boots',4,0,NULL,1500,NULL,5,NULL,0,0x000E5CEA,63,2,64,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2430,'Iron_Boots02','Iron Boots',4,0,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2431,'Valley_Shoes','Valley Shoes',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',0,0,'bonus bMaxHPrate,7; bonus bMaxSPrate,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2432,'Spiky_Heel_','High Heels',4,8500,NULL,600,NULL,10,NULL,1,0xFFFFFFFE,63,2,64,NULL,'0',1,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2433,'Diabolus_Boots','Diabolus Boots',4,20,NULL,250,NULL,15,NULL,1,0x00CFFF80,18,2,64,NULL,'0',1,0,'bonus bMaxHP,(BaseLevel*10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2434,'Black_Leather_Boots_','Black Leather Boots',4,20,NULL,500,NULL,16,NULL,1,0xFFFFFFFE,18,2,64,NULL,'55',1,0,'bonus bAgi,(getrefine()>=9?3:1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2435,'Battle_Greave','Battle Greaves',4,10,NULL,0,NULL,15,NULL,1,0x026654E2,63,2,64,NULL,'80',1,0,'bonus bMaxHP,100; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2436,'Combat_Boots','Combat Boots',4,10,NULL,0,NULL,9,NULL,1,0x00898B1C,63,2,64,NULL,'80',1,0,'bonus bMaxHP,100; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2437,'Battle_Boots','Battle Boots',4,10,NULL,0,NULL,9,NULL,1,0x41000000,63,2,64,NULL,'80',1,0,'bonus bMaxHP,100; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2438,'Paw_Of_Cat','Paw Of Cat',4,10,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,63,2,64,NULL,'80',1,0,'bonus bFlee,5; bonus bAgi,1; /* skill "ALL_CATCRY",1; */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2439,'Refresh_Shoes','Refresh Shoes',4,20,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',0,0,'bonus bMaxHPrate,17; bonus bMaxSPrate,8; bonus2 bHPRegenRate,20,10000; bonus2 bSPRegenRate,3,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2440,'Sprint_Shoes','Sprint Shoes',4,20,NULL,300,NULL,10,NULL,1,0x00CFFF80,18,2,64,NULL,'70',1,0,'bonus bAgi,1; bonus bSPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2441,'Beach_Sandal','Beach Sandals',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',1,0,'bonus bStr,1; bonus bInt,1; bonus bAgi,1; bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2442,'Boots_Perforated','Red Stocking Boots',4,0,NULL,0,NULL,7,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',0,0,'bonus bLuk,2; bonus bHPrecovRate,10; bonus bSPrecovRate,10; bonus3 bAutoSpellWhenHit,"WZ_QUAGMIRE",3,30; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2443,'Fish_Shoes','Fisher\'s Boots',4,10,NULL,250,NULL,0,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2444,'Krieger_Shoes1','Glorious Shoes',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,64,NULL,'81',1,0,'bonus bMaxHPrate,10; bonus2 bSubRace,RC_DemiHuman,4; bonus2 bSubRace,RC_Player,4; bonus3 bAutoSpellWhenHit,"AL_INCAGI",1,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2445,'Krieger_Shoes2','Glorious Popularized Shoes',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,64,NULL,'61',1,0,'bonus bMaxHPrate,5; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2446,'Krieger_Shoes3','Glorious Mass-Production Shoes',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFE,63,2,64,NULL,'0',1,0,'bonus bMaxHPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2447,'Military_Boots','Army Boots',4,0,NULL,1000,NULL,5,NULL,0,0xFFFFFFFE,63,2,64,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2448,'Air_Boss','Air Boss',4,0,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',1,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2449,'Variant_Shoes_M','Variant Shoes',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,18,2,64,NULL,'85',1,0,'.@r = getrefine(); bonus bMaxHPrate,20-.@r; bonus bMaxSPrate,20-.@r; bonus bDef,.@r/2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2450,'Vital_Tree_Shoes','Vital Tree Shoes',4,20,NULL,500,NULL,16,NULL,0,0xFFFFFFFE,18,2,64,NULL,'60',1,0,'bonus bMaxHPrate,10; bonus2 bHPRegenRate,30,10000; bonus bHealpower2,5; bonus bAddItemHealRate,5; bonus bMdef,3; bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2451,'Freyja_SSandal7','Freyja Sprit Sandals',4,20,NULL,400,NULL,5,NULL,0,0xFFFFFFFF,63,2,64,NULL,'20',0,0,'bonus bMaxHPrate,8; bonus bMaxSPrate,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2452,'Freyja_SSandal30','Freyja Sprit Sandals',4,20,NULL,400,NULL,5,NULL,0,0xFFFFFFFF,63,2,64,NULL,'20',0,0,'bonus bMaxHPrate,8; bonus bMaxSPrate,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2453,'Freyja_SSandal60','Freyja Sprit Sandals',4,20,NULL,400,NULL,5,NULL,0,0xFFFFFFFF,63,2,64,NULL,'20',0,0,'bonus bMaxHPrate,8; bonus bMaxSPrate,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2454,'Freyja_SSandal90','Freyja Sprit Sandals',4,20,NULL,400,NULL,5,NULL,0,0xFFFFFFFF,63,2,64,NULL,'20',0,0,'bonus bMaxHPrate,8; bonus bMaxSPrate,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2455,'Time_Keepr_Boots','Time Keeper\'s Boots',4,30000,NULL,0,NULL,17,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',1,0,'bonus bMdef,1; bonus bMaxHP,100; bonus bHPrecovRate,10; bonus bSPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2456,'Para_Team_Boots1','Eden Team Boots I',4,0,NULL,0,NULL,14,NULL,0,0xFFFFFFFF,63,2,64,NULL,'12',0,0,'bonus bHPrecovRate,10; bonus bSPrecovRate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2457,'Para_Team_Boots2','Eden Team Boots II',4,0,NULL,0,NULL,16,NULL,0,0xFFFFFFFF,63,2,64,NULL,'26',0,0,'bonus bHPrecovRate,12; bonus bSPrecovRate,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2458,'Para_Team_Boots3','Eden Team Boots III',4,0,NULL,0,NULL,18,NULL,0,0xFFFFFFFF,63,2,64,NULL,'40',0,0,'bonus bHPrecovRate,14; bonus bSPrecovRate,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2459,'Upg_Shoes','Upg Shoes',4,20,NULL,200,NULL,15,NULL,1,0xFFFFFFFE,63,2,64,NULL,'0',1,0,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2460,'Upg_Boots','Upg Boots',4,20,NULL,300,NULL,21,NULL,1,0x416E5CEA,63,2,64,NULL,'0',1,0,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2461,'Upg_Greave','Upg Greaves',4,20,NULL,400,NULL,32,NULL,1,0x00004080,63,2,64,NULL,'0',1,0,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2462,'Sleipnir_C','Sleipnir',4,20,NULL,0,NULL,40,NULL,0,0xFFFFFFFF,63,2,64,NULL,'94',0,0,'bonus bMdef,10; bonus bMaxHPrate,20; bonus bMaxSPrate,20; bonus bSPrecovRate,15; bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2463,'Feral_Boots','Feral Boots',4,20,NULL,0,NULL,12,NULL,0,0xFFFFFFFF,63,2,64,NULL,'75',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2464,'No_Fear_Shoes','No Fear Shoes',4,0,NULL,0,NULL,6,NULL,0,0xFFFFFFFF,63,2,64,NULL,'20',0,0,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2465,'Dance_Shoes','Dance Shoes',4,20,NULL,300,NULL,15,NULL,1,0x00080000,63,2,64,NULL,'105',1,0,'bonus bAgi,1; bonus bAspdRate,2; bonus2 bSkillUseSP,"WA_SWING_DANCE",32;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2466,'Training_Shoes','Training Shoes',4,20,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,63,2,64,NULL,'1',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2467,'Golden_Rod_Shoes','Golden Rod Shoes',4,20,NULL,500,NULL,12,NULL,0,0x00000200,63,2,64,NULL,'100',1,0,'bonus bMdef,2; bonus bMaxHP,500; bonus2 bSubEle,Ele_Wind,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2468,'Aqua_Shoes','Aqua Shoes',4,20,NULL,500,NULL,12,NULL,0,0x00000200,63,2,64,NULL,'100',1,0,'bonus bMdef,2; bonus bMaxHP,500; bonus2 bSubEle,Ele_Water,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2469,'Crimson_Shoes','Crismons Shoes',4,20,NULL,500,NULL,12,NULL,0,0x00000200,63,2,64,NULL,'100',1,0,'bonus bMdef,2; bonus bMaxHP,500; bonus2 bSubEle,Ele_Fire,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2470,'Forest_Shoes','Forest Shoes',4,20,NULL,500,NULL,12,NULL,0,0x00000200,63,2,64,NULL,'100',1,0,'bonus bMdef,2; bonus bMaxHP,500; bonus2 bSubEle,Ele_Earth,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2471,'Shoes_Of_Affection','Shoes Of Affection',4,20,NULL,300,NULL,12,NULL,0,0x00000100,63,2,64,NULL,'100',1,0,'bonus bMaxHP,500; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10; bonus2 bSubRace,RC_Formless,-10; bonus2 bSubRace,RC_Undead,-10; bonus2 bSubRace,RC_Brute,-10; bonus2 bSubRace,RC_Plant,-10; bonus2 bSubRace,RC_Insect,-10; bonus2 bSubRace,RC_Fish,-10; bonus2 bSubRace,RC_Demon,-10; bonus2 bSubRace,RC_Angel,-10; bonus2 bSubRace,RC_Dragon,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2472,'Shoes_Of_Judgement','Shoes Of Judgement',4,20,NULL,300,NULL,12,NULL,0,0x00000100,63,2,64,NULL,'100',1,0,'bonus2 bSkillAtk,"AB_JUDEX",30; bonus2 bSkillUseSP,"AB_JUDEX",-40; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2473,'Para_Team_Boots4','Eden Team Boots IV',4,0,NULL,0,NULL,20,NULL,0,0xFFFFFFFF,63,2,64,NULL,'60',0,0,'bonus bAgi,1; bonus bVit,1; bonus bHPrecovRate,28; bonus bSPrecovRate,12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2474,'Lehmannza_Shoes','Lehmannza Shoes',4,20,NULL,500,NULL,3,NULL,1,0xFFFFFFFF,63,2,64,NULL,'60',1,0,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2475,'Ur_Greave','Ur\'s Greaves',4,20,NULL,900,NULL,32,NULL,1,0x00000080,56,2,64,NULL,'100',1,0,'bonus bMaxSP,40; .@r = getrefine(); bonus bMaxHPrate,(.@r<=7?.@r-7:1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2476,'Peuz_Greave','Peuz\'s Greaves',4,20,NULL,900,NULL,32,NULL,1,0x00000080,56,2,64,NULL,'100',1,0,'bonus bMaxSP,40; .@r = getrefine(); bonus bAgi,(.@r<=7?.@r-7:1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2477,'Sabah_Shoes','Sapha Shoes',4,20,NULL,400,NULL,18,NULL,1,0x00001000,63,2,64,NULL,'100',1,0,'bonus bMaxSP,30; bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2478,'Nab_Shoes','Nab Shoes',4,20,NULL,400,NULL,18,NULL,1,0x00001000,63,2,64,NULL,'100',1,0,'bonus bFlee,3; bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2479,'White_Wing_Boots','White Wing Boots',4,20,NULL,400,NULL,18,NULL,1,0x00000800,63,2,64,NULL,'100',1,0,'bonus bAgi,2; bonus2 bSkillUseSP,"RA_AIMEDBOLT",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2480,'Black_Wing_Boots','Black Wing Boots',4,20,NULL,400,NULL,18,NULL,1,0x00000800,56,2,64,NULL,'100',1,0,'bonus bInt,2; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2481,'Rune_Boots','Rune Boots',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',1,0,'.@a = readparam(bStr); .@b = readparam(bInt); bonus bBaseAtk,(.@a>=120)?(20):((.@a>=90)?(10):(0)); bonus bMatkRate,(.@b>=120)?(5):((.@b>=90)?(3):(0));',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2482,'Shoes_Of_Valor','Shoes Of Valor',4,0,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,64,NULL,'0',0,0,'skill "AL_INCAGI",1; bonus bUseSPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2483,'Siege_Greave','Siege Greaves',4,10,NULL,750,NULL,30,NULL,1,0x006444A2,63,2,64,NULL,'95',1,0,'bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2484,'Siege_Boots','Siege Boots',4,10,NULL,500,NULL,20,NULL,1,0x636E5CEA,63,2,64,NULL,'95',1,0,'bonus bMdef,5; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2485,'Siege_Shoes','Siege Shoes',4,10,NULL,350,NULL,15,NULL,1,0x00818315,63,2,64,NULL,'95',1,0,'bonus bMdef,10; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2486,'Shadow_Walk_','Shadow Walk',4,20,NULL,2000,NULL,0,NULL,1,0xFFFFFFFE,63,2,64,NULL,'75',1,0,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2487,'Vital_Tree_Shoes_','Vital Tree Shoes',4,20,NULL,500,NULL,16,NULL,1,0xFFFFFFFE,63,2,64,NULL,'60',1,0,'bonus bVit,2; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2488,'Fricco_Shoes_','Fricco Shoes',4,30000,NULL,500,NULL,12,NULL,1,0xFFFFFFFE,63,2,64,NULL,'65',1,0,'bonus bAgi,2; bonus2 bAddItemGroupHealRate,IG_Potion,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2489,'Vidar\'s_Boots_','Vidar\'s Boots',4,30000,NULL,650,NULL,13,NULL,1,0xFFFFFFFE,63,2,64,NULL,'65',1,0,'bonus bMaxHPrate,9; bonus bMaxSPrate,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2491,'Bangungot_Boots','Bangungot Boots of Nightmare',4,20,NULL,600,NULL,10,NULL,0,0xFFFFFFFF,63,2,64,NULL,'1',1,0,'.@r = getrefine(); bonus bMdef,.@r; if(.@r>=14){ bonus bSpeedRate,25; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2492,'Bayani_Bangungot_Boots','Bayani Bangungot Boots of Nightmare',4,20,NULL,600,NULL,10,NULL,1,0xFFFFFFFF,63,2,64,NULL,'1',1,0,'.@r = getrefine(); bonus bMdef,.@r; if(.@r>=12){ bonus bSpeedRate,25; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2493,'Goibne\'s_Combat_Boots_','Goibne\'s Greaves',4,30000,NULL,700,NULL,13,NULL,1,0xFFFFFFFE,63,2,64,NULL,'54',1,0,'bonus bMdef,3; bonus bMaxHPrate,5; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2494,'Chrystal_Pumps_','Crystal Pumps',4,20,NULL,100,NULL,5,NULL,1,0xFFFFFFFE,63,0,64,NULL,'0',1,0,'bonus bMdef,10; bonus bLuk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2495,'Egir_Shoes','Egir Shoes',4,200000,NULL,300,NULL,13,NULL,1,0xFFFFFFFF,63,2,64,NULL,'110',1,0,'if(BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte) bonus bMaxHP,BaseLevel*5; else if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief) bonus bMaxSP,JobLevel*2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2496,'TE_Woe_Shoes','TE Woe Shoes',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFF,63,2,64,NULL,'40',1,NULL,'bonus bMdef,5; bonus bMaxHP,150; bonus bMaxSP,150; bonus2 bAddRace,RC_Player,5; bonus2 bMagicAddRace,RC_Player,5; bonus2 bResEff,Eff_Freeze,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2497,'TE_Woe_Boots','TE Woe Boots',4,0,NULL,0,NULL,10,NULL,0,0x000444A2,63,2,64,NULL,'40',1,NULL,'bonus bMaxHP,200; bonus bMaxSP,100; bonus2 bAddRace,RC_Player,10; bonus2 bResEff,Eff_Freeze,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2498,'TE_Woe_Magic_Sandal','TE Woe Magic Sandal',4,0,NULL,0,NULL,5,NULL,0,0x00818315,63,2,64,NULL,'40',1,NULL,'bonus bMdef,5; bonus bMaxHP,100; bonus bMaxSP,200; bonus2 bMagicAddRace,RC_Player,5; bonus2 bResEff,Eff_Freeze,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2499,'Temporal_Boots','Temporal Boots',4,400,NULL,600,NULL,20,NULL,0,0xFFFFFFFF,63,2,64,NULL,'10',1,NULL,'.@r = getrefine(); bonus bMaxHP,300; bonus bMaxSP,30; bonus bMaxHP,100*(.@r/3); bonus bMaxSP,10*(.@r/3);',NULL,NULL);
#===================================================================
# Garments
#===================================================================
REPLACE INTO `item_db_re` VALUES (2501,'Hood','Hood',4,1000,NULL,200,NULL,4,NULL,0,0xFFFFFFFF,63,2,4,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2502,'Hood_','Hood',4,1000,NULL,200,NULL,4,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2503,'Muffler','Muffler',4,5000,NULL,400,NULL,8,NULL,0,0xFFFFFFFE,63,2,4,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2504,'Muffler_','Muffler',4,5000,NULL,400,NULL,8,NULL,1,0xFFFFFFFE,63,2,4,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2505,'Manteau','Manteau',4,32000,NULL,600,NULL,13,NULL,0,0x006654E2,63,2,4,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2506,'Manteau_','Manteau',4,32000,NULL,600,NULL,13,NULL,1,0x006654E2,63,2,4,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2507,'Cape_Of_Ancient_Lord','Ancient Cape',4,82000,NULL,600,NULL,9,NULL,0,0xFFFFFFFE,63,2,4,NULL,'40',1,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2508,'Ragamuffin_Cape','Ragamuffin Manteau',4,56000,NULL,500,NULL,4,NULL,0,0xFFFFFFFE,63,2,4,NULL,'0',1,0,'bonus bUnbreakableGarment; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2509,'Clack_Of_Servival','Survivor\'s Manteau',4,20000,NULL,550,NULL,10,NULL,0,0x00810204,63,2,4,NULL,'75',1,0,'bonus bMdef,5; bonus bVit,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2510,'Novice_Hood','Somber Novice Hood',4,1,NULL,1,NULL,4,NULL,0,0x00000001,63,2,4,NULL,'0',0,0,'bonus2 bSubEle,Ele_Neutral,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2511,'Skeleton\'s_Cape','Skeleton Manteau',4,5000,NULL,700,NULL,1,NULL,0,0xFFFFFFFE,63,2,4,NULL,'75',1,0,'bonus bStr,2; bonus bInt,-3; bonus bDex,2; bonus bVit,-3; bonus bLuk,2; bonus bAgi,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2512,'Novice_Manteau','Novice Manteau',4,50000,NULL,500,NULL,7,NULL,1,0x00000001,63,2,4,NULL,'40',1,0,'bonus2 bSubEle,Ele_Neutral,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2513,'Celestial_Robe','Heavenly Maiden Robe',4,20,NULL,500,NULL,18,NULL,1,0xFFFFFFFE,63,2,4,NULL,'80',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2514,'Pauldron','Pauldron',4,20,NULL,800,NULL,25,NULL,1,0x000654E2,63,2,4,NULL,'80',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2515,'Wing_Of_Eagle','Eagle Wing',4,20000,NULL,300,NULL,12,NULL,1,0x00810204,63,2,4,NULL,'85',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2516,'Falcon_Robe','Falcon Muffler',4,30000,NULL,400,NULL,8,NULL,0,0xFFFFFFFE,63,2,4,NULL,'65',1,0,'bonus bFlee,15; bonus bFlee2,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2517,'Vali\'s_Manteau','Vali\'s Manteau',4,30000,NULL,600,NULL,13,NULL,0,0xFFFFFFFE,63,2,4,NULL,'65',1,0,'bonus2 bSubEle,Ele_Neutral,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2518,'Morpheus\'s_Shawl','Morpheus\'s Shawl',4,30000,NULL,600,NULL,8,NULL,0,0xFFFFFFFE,63,2,4,NULL,'33',1,0,'bonus bMaxSPrate,10; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2519,'Morrigane\'s_Manteau','Morrigane\'s Manteau',4,30000,NULL,600,NULL,9,NULL,0,0xFFFFFFFE,63,2,4,NULL,'61',1,0,'bonus bLuk,2; bonus bFlee2,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2520,'Goibne\'s_Shoulder_Arms','Goibne\'s Spaulders',4,30000,NULL,700,NULL,11,NULL,0,0xFFFFFFFE,63,2,4,NULL,'54',1,0,'bonus bLongAtkDef,10; bonus bMdef,2; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2521,'Angel\'s_Warmth','Angelic Cardigan',4,10000,NULL,400,NULL,5,NULL,1,0x00000001,63,2,4,NULL,'20',1,0,'bonus bHPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2522,'Undershirt','Undershirt',4,20000,NULL,150,NULL,5,NULL,0,0xFFFFFFFF,63,2,4,NULL,'0',1,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2523,'Undershirt_','Undershirt',4,20000,NULL,150,NULL,5,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2524,'Valkyrie_Manteau','Valkyrian Manteau',4,0,NULL,500,NULL,10,NULL,1,0xFFFFFFFE,18,2,4,NULL,'0',1,0,'bonus bUnbreakableGarment; if(BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte) bonus bFlee2,5+(getequiprefinerycnt(EQI_GARMENT)*2); else if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief) bonus bShortWeaponDamageReturn,5+(getequiprefinerycnt(EQI_GARMENT)*2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2525,'Cape_Of_Ancient_Lord_','Ancient Cape',4,82000,NULL,600,NULL,9,NULL,1,0xFFFFFFFE,63,2,4,NULL,'40',1,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2526,'Dragon_Scale_Coat','Coat of Dragon Scale',4,20,NULL,10,NULL,14,NULL,0,0xFFFFFFFF,63,2,4,NULL,'50',1,0,'bonus bMaxHP,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2527,'Dragon_Breath','Dragon Breath',4,20,NULL,600,NULL,16,NULL,1,0xFFFFFFFE,18,2,4,NULL,'48',1,0,'bonus2 bSubRace,RC_Dragon,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2528,'Wool_Scarf','Wool Scarf',4,20,NULL,500,NULL,11,NULL,1,0xFFFFFFFE,18,2,4,NULL,'55',1,0,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2529,'Rider_Insignia','Rider Insignia',4,20,NULL,500,NULL,13,NULL,0,0xFFFFFFFE,18,2,4,NULL,'55',1,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2530,'Rider_Insignia_','Rider Insignia',4,20,NULL,500,NULL,13,NULL,1,0xFFFFFFFE,18,2,4,NULL,'55',1,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2531,'Ulfhedinn','Ulfhedinn',4,20,NULL,700,NULL,13,NULL,1,0x000654E2,18,2,4,NULL,'70',1,0,'bonus3 bAutoSpellWhenHit,"NPC_STONESKIN",6,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2532,'Mithril_Magic_Cape','Mithril Magic Cape',4,20,NULL,400,NULL,8,NULL,1,0x00098B1C,18,2,4,NULL,'70',1,0,'bonus bMdef,3; bonus5 bAutoSpellWhenHit,"NPC_ANTIMAGIC",6,200,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2533,'Freyja_Cape','Freyja Cape',4,0,NULL,200,NULL,10,NULL,0,0xFFFFFFFE,63,2,4,NULL,'0',0,0,'bonus2 bSubRace,RC_DemiHuman,15; bonus2 bSubRace,RC_Player,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2534,'Ruffler','Ruffler',4,20,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,63,2,4,NULL,'0',0,0,'bonus2 bSubEle,Ele_Neutral,17; bonus bFlee,17;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2535,'Cloak_Of_Survival_C','Cloak Of Survival',4,1,NULL,0,NULL,5,NULL,0,0x00810204,63,2,4,NULL,'0',0,0,'bonus bVit,10; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2536,'Skin_Of_Ventus','Skin of Ventus',4,20,NULL,250,NULL,7,NULL,1,0xFFFFFFFE,63,2,4,NULL,'60',1,0,'bonus bMdef,2; bonus bMaxHP,200; bonus bFlee,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2537,'Diabolus_Manteau','Diabolus Manteau',4,20,NULL,250,NULL,15,NULL,1,0x00CFFF80,18,2,4,NULL,'0',1,0,'bonus2 bSubEle,Ele_Neutral,5; bonus bMaxHP,100; bonus2 bAddDamageClass,1916,10; bonus2 bAddDamageClass,1917,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2538,'Commander_Manteau','Captain\'s Manteau',4,10,NULL,0,NULL,28,NULL,1,0x026654E2,63,2,4,NULL,'80',1,0,'bonus bMaxHP,50; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2539,'Commander_Manteau_','Commander\'s Manteau',4,10,NULL,0,NULL,20,NULL,1,0x00898B1C,63,2,4,NULL,'80',1,0,'bonus bMaxHP,50; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2540,'Sheriff_Manteau','Sheriff\'s Manteau',4,10,NULL,0,NULL,20,NULL,1,0x41000000,63,2,4,NULL,'80',1,0,'bonus bMaxHP,50; bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,1; bonus2 bSubRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2541,'Asprika','Asprika',4,20,NULL,400,NULL,40,NULL,0,0xFFFFFFFF,63,2,4,NULL,'94',0,0,'bonus bMdef,5; bonus3 bSubEle,Ele_Neutral,30,BF_SHORT; bonus3 bSubEle,Ele_Water,30,BF_SHORT; bonus3 bSubEle,Ele_Earth,30,BF_SHORT; bonus3 bSubEle,Ele_Fire,30,BF_SHORT; bonus3 bSubEle,Ele_Wind,30,BF_SHORT; bonus3 bSubEle,Ele_Poison,30,BF_SHORT; bonus3 bSubEle,Ele_Holy,30,BF_SHORT; bonus3 bSubEle,Ele_Dark,30,BF_SHORT; bonus3 bSubEle,Ele_Ghost,30,BF_SHORT; bonus3 bSubEle,Ele_Undead,30,BF_SHORT; bonus bFlee,30; skill "AL_TELEPORT",1; bonus bUnbreakableGarment;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2542,'Flame_Manteau','Flame Manteau of Naght Sieger',4,20,NULL,700,NULL,16,NULL,1,0xFFFFFFFE,18,2,4,NULL,'70',1,0,'bonus bMaxHPrate,5; bonus bMdef,2; bonus bMatkRate,1; bonus2 bAddEle,Ele_Fire,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2543,'Sylphid_Manteau','Sylphid Manteau',4,20,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,63,2,4,NULL,'0',0,0,'bonus bFlee,13; bonus2 bSubEle,Ele_Neutral,13; bonus bFlee2,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2544,'Leather_Of_Tendrilion','Leather of Tendrilion',4,20,NULL,300,NULL,14,NULL,1,0x00CFDF80,18,2,4,NULL,'0',1,0,'bonus2 bSubEle,Ele_Water,5; bonus2 bSubEle,Ele_Earth,5; bonus2 bSubRace,RC_Plant,5; bonus2 bSubRace,RC_Brute,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2545,'Musika','Musika',4,20,NULL,500,NULL,10,NULL,1,0x00008100,18,2,4,NULL,'70',1,0,'bonus bMdef,3; bonus3 bAutoSpellwhenhit,"AL_HEAL",max(1,getskilllv("AL_HEAL")),20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2546,'Beach_Manteau','Beach Manteau',4,20,NULL,600,NULL,0,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,0,'bonus bStr,1; bonus bInt,1; bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2547,'Cheap_Running_Shirts','Cheap Undershirt',4,0,NULL,0,NULL,8,NULL,0,0xFFFFFFFF,63,2,4,NULL,'0',1,0,'bonus bDex,2; bonus bFlee,10; bonus2 bSubEle,Ele_Neutral,10; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2548,'Muffler_C','Neo Muffler',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,18,2,4,NULL,'95',0,0,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10; bonus bMaxHPrate,10; bonus2 bSubEle,Ele_Water,5; bonus2 bSubEle,Ele_Fire,5; bonus2 bSubEle,Ele_Holy,5; bonus2 bSubEle,Ele_Dark,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2549,'Krieger_Muffler1','Glorious Muffler',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFE,63,2,4,NULL,'81',1,0,'bonus bMaxHPrate,5; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2550,'Fisher\'s_Muffler','Fisher\'s Muffler',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,4,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2551,'Rider_Insignia_M','Crest of the Rider',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFE,18,2,4,NULL,'55',1,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2552,'Mithril_Magic_Cape_M','Mithril Magic Manteau',4,20,NULL,400,NULL,3,NULL,1,0x00098B1C,18,2,4,NULL,'70',1,0,'bonus bMdef,3; bonus5 bAutoSpellWhenHit,"NPC_ANTIMAGIC",6,200,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2553,'Dragon_Manteau','Dragon Manteau',4,20,NULL,1000,NULL,14,NULL,1,0xFFFFFFFE,18,2,4,NULL,'0',1,0,'bonus bAgi,1; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2554,'Piece_Of_Angent_Skin','Nydhorgg\'s Shadow Garb',4,20,NULL,400,NULL,25,NULL,1,0xFFFFFFFE,18,2,4,NULL,'90',1,0,'bonus2 bSubEle,Ele_All,7; bonus bMaxSP,(BaseLevel/3)+(getrefine()*10); bonus2 bSPDrainRate,10,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2555,'Freyja_SScarf7','Freyja Soul Scarf',4,20,NULL,400,NULL,4,NULL,0,0xFFFFFFFF,63,2,4,NULL,'20',0,0,'bonus bFlee,15; bonus2 bSubEle,Ele_Neutral,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2556,'Freyja_SScarf30','Freyja Soul Scarf',4,20,NULL,400,NULL,4,NULL,0,0xFFFFFFFF,63,2,4,NULL,'20',0,0,'bonus bFlee,15; bonus2 bSubEle,Ele_Neutral,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2557,'Freyja_SScarf60','Freyja Soul Scarf',4,20,NULL,400,NULL,4,NULL,0,0xFFFFFFFF,63,2,4,NULL,'20',0,0,'bonus bFlee,15; bonus2 bSubEle,Ele_Neutral,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2558,'Freyja_SScarf90','Freyja Soul Scarf',4,20,NULL,400,NULL,4,NULL,0,0xFFFFFFFF,63,2,4,NULL,'20',0,0,'bonus bFlee,15; bonus2 bSubEle,Ele_Neutral,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2559,'Time_Keepr_Manteau','Time Keeper\'s Manteau',4,30000,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,63,2,4,NULL,'1',1,0,'bonus bMdef,1; bonus bFlee,10; bonus2 bSubEle,Ele_Neutral,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2560,'Para_Team_Manteau','Eden Team Manteau I',4,0,NULL,0,NULL,14,NULL,0,0xFFFFFFFF,63,2,4,NULL,'12',0,0,'bonus2 bSubEle,Ele_Neutral,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2561,'Upg_Hood','Upg Hood',4,0,NULL,100,NULL,9,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,0,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2562,'Upg_Muffler','Upg Muffler',4,20,NULL,200,NULL,13,NULL,1,0xFFFFFFFE,63,2,4,NULL,'0',1,0,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2563,'Upg_Manteau','Upg Manteau',4,20,NULL,300,NULL,18,NULL,1,0x006654E2,63,2,4,NULL,'0',1,0,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2564,'Feral_Tail','Feral Tail',4,20,NULL,0,NULL,16,NULL,0,0xFFFFFFFF,63,2,4,NULL,'75',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2565,'Beach_Towel','Beach Towel',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,0,'bonus bMdef,3; bonus bFlee,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2566,'Half_Asprika','Half Asprika',4,20,NULL,0,NULL,20,NULL,0,0xFFFFFFFF,63,2,4,NULL,'47',0,0,'bonus bMdef,2; bonus3 bSubEle,Ele_Neutral,15,BF_SHORT; bonus3 bSubEle,Ele_Water,15,BF_SHORT; bonus3 bSubEle,Ele_Earth,15,BF_SHORT; bonus3 bSubEle,Ele_Fire,15,BF_SHORT; bonus3 bSubEle,Ele_Wind,15,BF_SHORT; bonus3 bSubEle,Ele_Poison,15,BF_SHORT; bonus3 bSubEle,Ele_Holy,15,BF_SHORT; bonus3 bSubEle,Ele_Dark,15,BF_SHORT; bonus3 bSubEle,Ele_Ghost,15,BF_SHORT; bonus3 bSubEle,Ele_Undead,15,BF_SHORT; bonus bFlee,15; skill "AL_TELEPORT",1; bonus bUnbreakableGarment;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2567,'Academy_Manteau','Academy Manteau',4,0,NULL,600,NULL,3,NULL,1,73,7,2,4,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2568,'Muffler_Of_Roki','Loki\'s Muffler',4,20,NULL,400,NULL,10,NULL,0,0xFFFFFFFF,63,2,4,NULL,'100',0,0,'bonus bAgi,1; bonus2 bSkillAtk,"ASC_BREAKER",5; bonus2 bSkillAtk,"GC_CROSSIMPACT",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2569,'Shawl_Of_Affection','Shawl Of Affection',4,20,NULL,400,NULL,12,NULL,0,0x00000100,63,2,4,NULL,'100',1,0,'bonus bFlee2,5; autobonus2 "{ bonus2 bHPRegenRate,1000,5000; }",300,90000,BF_WEAPON; autobonus2 "{ bonus2 bHPRegenRate,1000,5000; }",400,90000,BF_MAGIC;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2570,'Shawl_Of_Judgement','Shawl Of Judgement',4,20,NULL,400,NULL,12,NULL,0,0x00000100,63,2,4,NULL,'100',1,0,'bonus bFlee,5; .@i = max(2,getskilllv("AB_ORATIO")); bonus5 bAutoSpellWhenHit,"AB_ORATIO",.@i,30,BF_WEAPON,0; bonus5 bAutoSpellWhenHit,"AB_ORATIO",.@i,40,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2571,'Para_Team_Manteau2','Eden Team Manteau II',4,0,NULL,0,NULL,18,NULL,0,0xFFFFFFFF,63,2,4,NULL,'60',0,0,'bonus bFlee,12; bonus2 bSubEle,Ele_Neutral,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2572,'Katabart_Sholder','Katabart Sholder',4,20,NULL,3000,NULL,4,NULL,1,0xFFFFFFFF,63,2,4,NULL,'70',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2573,'Archangel_Wing','Archangel Wings',4,0,NULL,200,NULL,18,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,1,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2574,'Ur_Manteau','Ur\'s Manteau',4,20,NULL,600,NULL,20,NULL,0,0x00000080,56,2,4,NULL,'100',1,0,'bonus bMaxHPrate,2; bonus2 bSubEle,Ele_Neutral,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2575,'Peuz_Manteau','Peuz\'s Manteau',4,20,NULL,600,NULL,16,NULL,0,0x00000080,56,2,4,NULL,'100',1,0,'bonus bFlee,10; bonus bCritical,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2576,'Bravery_Bag','Adventurer\'s Backpack',4,0,NULL,200,NULL,20,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,2,'skill "BS_GREED",1; .@r = getrefine(); if(.@r>=7) { if(readparam(bStr)>=90) { bonus bBaseAtk,(.@r>=9)?30:20; } if(readparam(bInt)>=90) { bonus bMatk,(.@r>=9)?50:30; } if(readparam(bVit)>=90) { bonus2 bSubEle,Ele_Neutral,(.@r>=9)?10:5; } if(readparam(bAgi)>=90) { bonus bAspdRate,8; if(.@r>=9) { bonus bAspd,1; } } if(readparam(bDex)>=90) { bonus bLongAtkRate,(.@r>=9)?10:5; } if(readparam(bLuk)>=90) { bonus bCritAtkRate,(.@r>=9)?15:10; } }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2577,'Sabah_Hood','Sapha Hood',4,20,NULL,100,NULL,13,NULL,0,0x00001000,63,2,4,NULL,'100',1,0,'bonus bFlee,12; bonus bCritical,getrefine();',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2578,'Nab_Hood','Nab Hood',4,20,NULL,100,NULL,13,NULL,0,0x00001000,63,2,4,NULL,'100',1,0,'.@r = getrefine(); bonus bFlee,.@r*2; bonus bBaseAtk,.@r*2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2579,'Magic_Stole','Magic Stole',4,20,NULL,700,NULL,8,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,0,'bonus bMdef,3; bonus bUseSPrate,-5; bonus bMaxSPrate,((getrefine()>=4)?6:3);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2580,'White_Wing_Manteau','White Wing Manteau',4,20,NULL,200,NULL,15,NULL,0,0x00000800,63,2,4,NULL,'100',1,0,'bonus bAgi,2; bonus bFlee,10; autobonus2 "{ bonus bFlee,20; }",20,7000,BF_LONG,"{ specialeffect2 EF_CHAINCOMBO; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2581,'Black_Wing_Manteau','Black Wing Manteau',4,20,NULL,200,NULL,15,NULL,0,0x00000800,56,2,4,NULL,'100',1,0,'.@r = getrefine(); bonus bInt,2; if(.@r>6) bonus bFlee2,.@r-6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2582,'Salvage_Cape','Salvage Cape',4,56000,NULL,400,NULL,1,NULL,0,0x00000300,63,2,4,NULL,'130',1,0,'skill "NJ_UTSUSEMI",1; bonus2 bSkillCooldown,"NJ_UTSUSEMI",30000; bonus bUseSPrate,100;',NULL,'heal 0,-1200;');
REPLACE INTO `item_db_re` VALUES (2583,'Holy_Cape','Holy Cape',4,20,NULL,100,NULL,5,NULL,1,0xFFFFFFFF,63,2,4,NULL,'50',1,0,'bonus bDex,-5; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2584,'Wanderer_Outer','Wanderer Outer',4,20,NULL,500,NULL,8,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2585,'Muffler_Of_Valor','Muffler Of Valor',4,0,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,4,NULL,'0',0,0,'bonus bSPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2586,'Siege_Manteau','Siege Manteau',4,10,NULL,600,NULL,32,NULL,1,0xFFFFFFFE,63,2,4,NULL,'95',1,0,'bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2587,'Siege_Muffler','Siege Muffler',4,10,NULL,400,NULL,15,NULL,1,0xFFFFFFFF,63,2,4,NULL,'95',1,0,'bonus bMdef,10; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2588,'Ragamuffin_Cape_','Ragamuffin Cape',4,56000,NULL,500,NULL,4,NULL,1,0xFFFFFFFE,63,2,4,NULL,'40',1,0,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2589,'Fallen_Angel_Wing','Fallen Angel Wing',4,0,NULL,200,NULL,18,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,3,'bonus bAllStats,1; bonus bAtk,readparam(bStr)/20; bonus bMatk,readparam(bInt)/20; bonus2 bSubEle,Ele_Neutral,readparam(bVit)/20; bonus bLongAtkRate,readparam(bDex)/20; bonus bCritAtkRate,readparam(bLuk)/20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2590,'Buwaya_Cloth','Buwaya Sack Cloth',4,20,NULL,200,NULL,8,NULL,0,0xFFFFFFFF,63,2,4,NULL,'1',1,0,'.@r = getrefine(); bonus bHealPower2,.@r/3; bonus bAddItemHealRate,.@r/3; bonus2 bSubEle,Ele_Water,10; bonus2 bSubEle,Ele_Wind,10; bonus2 bSubEle,Ele_Earth,10; bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2591,'Bayani_Buwaya_Cloth','Bayani Buwaya Sack Cloth',4,20,NULL,200,NULL,8,NULL,1,0xFFFFFFFF,63,2,4,NULL,'1',1,0,'.@r = getrefine(); bonus bHealPower2,.@r; bonus bAddItemHealRate,.@r; bonus2 bSubEle,Ele_Water,10; bonus2 bSubEle,Ele_Wind,10; bonus2 bSubEle,Ele_Earth,10; bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2592,'Boss_Brownie_Manteau','Boss Brownie Manteau',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,4,NULL,'50',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2593,'Flow_Manteau','Flow Manteau',4,20,NULL,700,NULL,20,NULL,1,0xFFFFFFFF,63,2,4,NULL,'65',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2594,'Wrapping_Manteau','Wrapping Manteau',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,4,NULL,'0',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2597,'Scarlet_Poncho','Scarlet Poncho',4,0,NULL,500,NULL,10,NULL,1,0xFFFFFFFF,63,2,4,NULL,NULL,1,0,'bonus bCritAtkRate,3; /* Confirm: The location. If the location is changed, also change the combo script! */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2598,'Ramor_Manteau','Ramor Manteau',4,20,NULL,700,NULL,20,NULL,1,0xFFFFFFFF,63,2,4,NULL,'65',1,0,'bonus2 bSubRace,RC_Undead,5; bonus2 bSubRace,RC_DemiHuman,-5; /*Gold PC Room: bonus bFlee,20;*/',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2599,'Goibne\'s_Shoulder_Arms_','Goibne\'s Spaulders',4,30000,NULL,700,NULL,11,NULL,1,0xFFFFFFFE,63,2,4,NULL,'54',1,0,'bonus bLongAtkDef,10; bonus bMdef,2; bonus bVit,1;',NULL,NULL);
#===================================================================
# Accessories
#===================================================================
REPLACE INTO `item_db_re` VALUES (2601,'Ring','Ring',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'20',0,0,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2602,'Earring','Earring',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'20',0,0,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2603,'Necklace','Necklace',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'20',0,0,'bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2604,'Glove','Glove',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'20',0,0,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2605,'Brooch','Brooch',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'20',0,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2607,'Clip','Clip',4,30000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMaxSP,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2608,'Rosary','Rosary',4,15000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'20',0,0,'bonus bMdef,5; bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2609,'Skul_Ring','Skull Ring',4,10000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2610,'Gold_Ring','Gold Ring',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2611,'Silver_Ring','Silver Ring',4,20000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2612,'Flower_Ring','Flower Ring',4,1500,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2613,'Diamond_Ring','Diamond Ring',4,45000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2614,'An_Eye_Of_Dullahan','Eye of Dullahan',4,90000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'50',0,0,'bonus2 bResEff,Eff_Poison,10000; bonus2 bSubRace,RC_Undead,4; bonus2 bSubRace,RC_Demon,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2615,'Safety_Ring','Safety Ring',4,75000,NULL,100,NULL,5,NULL,0,0xFFFFFFFE,63,2,136,NULL,'40',0,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2616,'Critical_Ring','Critical Ring',4,75000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'40',0,0,'bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2617,'Mitten_Of_Presbyter','Celebrant\'s Mitten',4,2,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'35',0,0,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2618,'Matyr\'s_Flea_Guard','Matyr\'s Leash',4,2,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'35',0,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2619,'Thimble_Of_Archer','Bow Thimble',4,10000,NULL,100,NULL,0,NULL,0,0x00080808,63,2,136,NULL,'65',0,0,'bonus bLongAtkRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2620,'Ring_Of_Rogue','Rogue\'s Treasure',4,10000,NULL,100,NULL,0,NULL,0,0x02021040,63,2,136,NULL,'70',0,0,'if(readparam(bStr)>=90){ bonus bHit,10; bonus bFlee,10; } if(readparam(bAgi)>=90){ bonus bBaseAtk,10; bonus bCritical,10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2621,'Ring_','Ring',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'90',0,0,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2622,'Earring_','Earring',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'90',0,0,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2623,'Necklace_','Necklace',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'90',0,0,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2624,'Glove_','Glove',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'90',0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2625,'Brooch_','Brooch',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'90',0,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2626,'Rosary_','Rosary',4,15000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'90',0,0,'bonus bMdef,3; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2627,'Belt','Belt',4,20000,NULL,1200,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'25',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2628,'Novice_Armlet','Novice Armlet',4,400,NULL,200,NULL,0,NULL,1,0x00000001,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2629,'Magingiorde','Megingjard',4,20,NULL,8000,NULL,2,NULL,0,0xFFFFFFFF,63,2,136,NULL,'94',0,0,'bonus bStr,40+BaseLevel/5; bonus bMdef,7; if(readparam(bStr)>=120) bonus2 bAddClass,Class_Boss,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2630,'Brysinggamen','Brisingamen',4,20,NULL,1500,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'94',0,0,'bonus bStr,6; bonus bAgi,6; bonus bVit,6; bonus bInt,10; bonus bLuk,10; bonus bMdef,5; bonus bHealPower,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2631,'First_Age_Ring','Celebration Ring',4,1,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2632,'Korean_Trinket','Korean Trinket',4,125000,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'65',0,0,'bonus bVit,1; bonus bDex,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2633,'Jade_Ring','Jade Ring',4,204000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'80',0,0,'bonus bStr,2; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2634,'Bridegroom_Ring','Wedding Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,1,136,NULL,'0',0,0,'skill "WE_MALE",1; skill "WE_FEMALE",1; skill "WE_CALLPARTNER",1; skill "WE_CALLALLFAMILY",1; skill "WE_ONEFOREVER",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2635,'Bride_Ring','Wedding Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,0,136,NULL,'0',0,0,'skill "WE_MALE",1; skill "WE_FEMALE",1; skill "WE_CALLPARTNER",1; skill "WE_CALLALLFAMILY",1; skill "WE_ONEFOREVER",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2636,'Gold_Ring_','Gold Christmas Ring',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2637,'Silver_Ring_','Silver Christmas Ring',4,20000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2638,'Exorcize_Sachet','Sacred Incense',4,20000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bStr,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2639,'Purification_Sachet','Occult Incense',4,20000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bInt,1; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2640,'Kafra_Ring','Kafra Ring',4,40000,NULL,200,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'0',0,0,'bonus bStr,1; bonus bInt,1; bonus bAgi,1; bonus bLuk,1; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2641,'Fashionable_Sack','Fashion Hip Sack',4,20,NULL,700,NULL,0,NULL,0,0x00040420,63,2,136,NULL,'50',0,0,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2642,'Serin\'s_Gold_Ring','Serin\'s Gold Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2643,'Serin\'s_Gold_Ring_','Serin\'s Gold Ring',4,45000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2644,'The_Sign_','The Sign',4,2,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bAddClass,Class_All,5; bonus2 bMagicAddClass,Class_All,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2645,'Moonlight_Ring','Moonlight Ring',4,40000,NULL,200,NULL,0,NULL,0,0x02021040,63,2,136,NULL,'60',0,0,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2646,'Bunch_Of_Carnation','Bunch of Carnations',4,2,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2647,'Nile_Rose','Nile Rose',4,2,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2648,'Morpheus\'s_Ring','Morpheus\'s Ring',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'33',0,0,'bonus bInt,1; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2649,'Morpheus\'s_Armlet','Morpheus\'s Bracelet',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'33',0,0,'bonus bInt,1; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2650,'Morrigane\'s_Belt','Morrigane\'s Belt',4,30000,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'61',0,0,'bonus bBaseAtk,5; bonus bCritical,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2651,'Morrigane\'s_Pendant','Morrigane\'s Pendant',4,30000,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'61',0,0,'bonus bStr,2; bonus bCritical,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2652,'Cursed_Lucky_Brooch','Goddess of Fortune\'s Cursed Brooch',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'40',0,0,'bonus bCritical,6; bonus2 bAddEff2,Eff_Curse,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2653,'Sacrifice_Ring','Sacrifice Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'90',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2654,'Shinobi\'s_Sash','Shinobi Sash',4,20000,NULL,300,NULL,1,NULL,0,0x02021040,63,2,136,NULL,'30',0,0,'bonus bStr,1; bonus bAgi,1; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2655,'Bloody_Iron_Ball','Bloodied Shackle Ball',4,50000,NULL,4000,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2656,'Hyper_Changer','Armor Charm',4,20000,NULL,1000,NULL,1,NULL,0,0x000654E2,63,2,136,NULL,'1',0,0,'bonus bMaxHP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2657,'Lab_Passport','Laboratory Permit',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2658,'Nile_Rose_','Nile Rose',4,2,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMaxHP,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2659,'Vesper_Core01','Vesper Core 01',4,20,NULL,500,NULL,1,NULL,0,0x00CFFF80,18,2,136,NULL,'1',0,0,'bonus bMdef,3; bonus bInt,2; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2660,'Vesper_Core02','Vesper Core 02',4,20,NULL,500,NULL,1,NULL,0,0x00CFFF80,18,2,136,NULL,'1',0,0,'bonus bMdef,3; bonus bStr,3; bonus bBaseAtk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2661,'Vesper_Core03','Vesper Core 03',4,20,NULL,500,NULL,1,NULL,0,0x00CFFF80,18,2,136,NULL,'1',0,0,'bonus bMdef,3; bonus bAgi,3; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2662,'Vesper_Core04','Vesper Core 04',4,20,NULL,500,NULL,1,NULL,0,0x00CFFF80,18,2,136,NULL,'1',0,0,'bonus bMdef,3; bonus bDex,3; bonus bHit,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2663,'Gauntlet_Of_Accuracy','Gauntlet of Hit',4,20,NULL,900,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'75',0,0,'bonus bHit,15; bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2664,'Scarf_Belt','Belcarf',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'75',0,0,'bonus bDex,2; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2665,'Ring_Of_Exorcism','Exorcising Ring',4,20,NULL,500,NULL,0,NULL,0,0x00008110,63,2,136,NULL,'60',0,0,'bonus bMdef,1; bonus2 bExpAddRace,RC_Undead,5; bonus2 bExpAddRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2666,'Lamp_Of_Hope','Lantern of Hope',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bStr,2; bonus2 bResEff,Eff_Blind,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2667,'Glove_Of_Archer','Renown Archer\'s Gloves',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'60',0,0,'bonus bHit,5; bonus bCritical,5; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2668,'Women\'s_Glory','Woman Glory',4,0,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bStr,3; bonus bAgi,3; bonus bVit,3; bonus bInt,3; bonus bDex,3; bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2669,'Golden_Necklace_','RJC Necklace',4,30000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMaxSP,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2670,'Ring_Of_Longing','Ring of Longing',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'30',0,0,'bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2671,'Thimble_Of_Archer_','Bow Thimble',4,10000,NULL,100,NULL,0,NULL,1,0x00080808,63,2,136,NULL,'65',0,0,'bonus bLongAtkRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2672,'Anniversary_Ring','3rd Anniversary Celebration Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'0',0,0,'bonus bStr,5; bonus bAgi,5; bonus bVit,5; bonus bInt,5; bonus bDex,5; bonus bLuk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2673,'Shining_Ring','Warrior\'s Shining Ring',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'48',0,0,'bonus bBaseAtk,10; bonus bSPrecovRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2674,'Honor_Ring','Ring of Honor',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2675,'Lord_Ring','Lord Ring',4,0,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2676,'Hunter_Earring','Hunter\'s Earring',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus2 bAddMonsterDropItem,7618,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2677,'Spiritual_Ring','Spiritual Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2678,'Ring_Of_Flame_Lord','Ring Of Flame Lord',4,20,NULL,100,NULL,0,NULL,0,0x00CFFF80,18,2,136,NULL,'0',0,0,'bonus bStr,2; bonus bVit,1; bonus bBaseAtk,15; bonus2 bSubEle,Ele_Fire,10; bonus3 bAutoSpell,"CH_SOULCOLLECT",1,30; bonus3 bAutoSpell,"MO_EXPLOSIONSPIRITS",1,10; bonus3 bAutoSpell,"PA_PRESSURE",2,30; bonus3 bAutoSpell,"MG_FIREBALL",1,150; bonus3 bAutoSpell,"KN_BOWLINGBASH",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2679,'Ring_Of_Resonance','Ring Of Resonance',4,20,NULL,100,NULL,2,NULL,0,0x00CFFF80,18,2,136,NULL,'0',0,0,'bonus bAgi,2; bonus bVit,1; bonus bMdef,2; bonus4 bAutoSpellWhenHit,"WZ_QUAGMIRE",1,50,0; bonus3 bAutoSpellWhenHit,"AS_SPLASHER",10,20; bonus3 bAutoSpellWhenHit,"AL_HEAL",10,30; bonus3 bAutoSpellWhenHit,"HP_ASSUMPTIO",3,20; bonus3 bAutoSpellWhenHit,"CG_TAROTCARD",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2680,'Lesser_Elemental_Ring','Lesser Elemental Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,1; bonus3 bAutoSpell,"WZ_ESTIMATION",1,80; bonus3 bAutoSpell,"MC_IDENTIFY",1,50; bonus3 bAutoSpell,"TF_PICKSTONE",1,100; bonus3 bAutoSpell,"BS_GREED",1,10; bonus3 bAutoSpellWhenHit,"TK_RUN",5,20; bonus3 bAutoSpellWhenHit,"TK_HIGHJUMP",3,30; bonus3 bAutoSpellWhenHit,"NV_FIRSTAID",1,100; bonus3 bAutoSpellWhenHit,"TF_BACKSLIDING",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2681,'Republic_Ring','Republic Anniversary Ring',4,20,NULL,1000,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2682,'Ring_Of_Water','Ring of Water',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'20',0,0,'bonus2 bSubDefEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2683,'Ring_Of_Fire','Ring of Fire',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'20',0,0,'bonus2 bSubDefEle,Ele_Fire,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2684,'Ring_Of_Wind','Ring of Wind',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'20',0,0,'bonus2 bSubDefEle,Ele_Wind,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2685,'Ring_Of_Earth','Ring of Earth',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'20',0,0,'bonus2 bSubDefEle,Ele_Earth,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2686,'Elven_Ears_C','Elven Ears',4,1,NULL,0,NULL,2,NULL,0,0xFFFFFFFE,63,2,512,NULL,'1',0,73,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2687,'Steel_Flower_C','Steel Flower',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,63,2,1,NULL,'1',0,56,'bonus2 bSubRace,RC_Plant,3; bonus3 bAutoSpellWhenHit,"PR_STRECOVERY",1,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2688,'Critical_Ring_C','Critical Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bCriticalRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2689,'Earring_C','Earring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2690,'Ring_C','Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bStr,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2691,'Necklace_C','Necklace',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bVit,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2692,'Glove_C','Glove',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2693,'Brooch_C','Brooch',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bAgi,4; /*Gold PC Room bonus bAllStats,1;*/',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2694,'Rosary_C','Rosary',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bMdef,5; bonus bLuk,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2695,'Safety_Ring_C','Safety Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bMdef,5; bonus bDef,5; /*Gold PC Room bonus bAllStats,1;*/',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2696,'Vesper_Core01_C','Vesper Core 01',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bMdef,3; bonus bInt,2; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2697,'Vesper_Core02_C','Vesper Core 02',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bMdef,3; bonus bStr,3; bonus bBaseAtk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2698,'Vesper_Core03_C','Vesper Core 03',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bMdef,3; bonus bAgi,3; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2699,'Vesper_Core04_C','Vesper Core 04',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bMdef,3; bonus bDex,3; bonus bHit,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2700,'Red_Silk_Seal','Red Silk Seal',4,20,NULL,100,NULL,0,NULL,0,0x00004082,18,2,136,NULL,'60',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2701,'Orleans_Glove','Orleans\'s Glove',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFE,18,2,136,NULL,'90',0,0,'bonus bDex,2; bonus bMatkRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2702,'Bison_Horn','Bison Horn',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFE,18,2,136,NULL,'90',0,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2703,'Expert_Ring','Expert Ring',4,20,NULL,150,NULL,0,NULL,1,0xFFFFFFFE,18,2,136,NULL,'50',0,0,'bonus bDelayRate,-5; bonus bUseSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2704,'Golden_Accessory','Golden Accessories',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2705,'Golden_Accessory2','Golden Accessories',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bAddMonsterDropItem,12018,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2706,'Handcuff','Arrest Handcuffs',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2707,'Gusli','GUSLI',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2708,'Chinese_Handicraft','Chinese Handicraft',4,0,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus3 bAutoSpell,"MG_FIREBOLT",5,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2709,'5_Anniversary_Coin','5th Anniversary Coin',4,2,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2710,'Bloody_Iron_Ball_C','Bloody Iron Ball',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'0',0,0,'bonus bBaseAtk,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2711,'Spiritual_Ring_C','Spiritual Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bInt,2; bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2712,'Ragnarok_Limited_Ed','Ragnarok Limited Edition',4,0,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'30',0,0,'bonus bVit,3; bonus bAgi,3; bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2713,'Certificate_TW','Certificate',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2714,'Marvelous_Pandent','Marvelous Pendant',4,0,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2715,'Skul_Ring_','Skull Ring',4,10000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bSubRace,RC_Undead,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2716,'Librarian_Glove','Librarian Glove',4,20,NULL,100,NULL,0,NULL,1,0x00810200,63,2,136,NULL,'80',0,0,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2717,'Pocket_Watch_','Pocket Watch',4,20,NULL,200,NULL,0,NULL,0,0x00010204,63,2,136,NULL,'80',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2718,'Lunatic_Brooch','Lunatic Brooch',4,20,NULL,200,NULL,0,NULL,1,0x00080808,63,2,136,NULL,'65',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2719,'Iron_Wrist','Iron Wrist',4,20,NULL,700,NULL,1,NULL,0,0x000444A2,63,2,136,NULL,'50',0,0,'bonus2 bSkillAtk,"SM_BASH",6; bonus2 bSkillAtk,"MC_MAMMONITE",6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2720,'Medal_Swordman','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x00404082,63,2,136,NULL,'70',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bHit,10; bonus bMaxHP,500; bonus bMaxSP,50; bonus3 bAddEff,Eff_Stun,100,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2721,'Medal_Thief','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x02021040,63,2,136,NULL,'70',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bFlee,10; bonus bMaxHP,300; bonus bMaxSP,80; bonus3 bAddEff,Eff_Poison,100,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2722,'Medal_Acolyte','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x00008110,63,2,136,NULL,'70',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bMdef,6; bonus bMaxHP,600; bonus3 bAddEff,Eff_Silence,100,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2723,'Medal_Mage','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x00810204,63,2,136,NULL,'70',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bMdef,6; bonus bMaxHP,600; bonus2 bAddEffWhenHit,Eff_Stone,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2724,'Medal_Archer','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x00080808,63,2,136,NULL,'70',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bCritical,10; bonus bMaxHP,300; bonus bMaxSP,80; bonus3 bAddEff,Eff_Blind,100,ATF_LONG;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2725,'Medal_Merchant','Medal of Honor',4,20,NULL,0,NULL,1,NULL,0,0x00040420,63,2,136,NULL,'70',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bAspdRate,10; bonus bMaxHP,500; bonus bMaxSP,50; bonus3 bAddEff,Eff_Curse,100,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2726,'Icarus_Wing','Icarus Wings',4,20,NULL,100,NULL,0,NULL,0,0x00000800,18,2,136,NULL,'70',0,0,'bonus bMaxSP,50; bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2727,'Bowman_Scarf','Bowman Scarf',4,20,NULL,200,NULL,0,NULL,0,0x00000800,18,2,136,NULL,'70',0,0,'bonus bMaxSP,50; bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2728,'Cursed_Hand','Cursed Hand',4,20,NULL,50,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'80',0,0,'bonus3 bAutoSpell,"NPC_CRITICALWOUND",1,30; bonus bHit,10; bonus bHPrecovRate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2729,'Diabolus_Ring','Diabolus Ring',4,20,NULL,50,NULL,0,NULL,1,0x00CFFF80,18,2,136,NULL,'0',0,0,'bonus bMaxHP,100; bonus bMaxSP,100; bonus bHealPower,5; bonus2 bAddDamageClass,1916,10; bonus2 bAddDamageClass,1917,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2730,'Morroc_Seal','Seal of Continental Guard',4,20,NULL,50,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'80',0,0,'bonus bMaxHP,50; bonus bAspdRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2731,'Morroc_Charm_Stone','Rune Spellstone',4,20,NULL,50,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'80',0,0,'bonus bMaxSP,50; bonus bVariableCastrate,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2732,'Morroc_Ring','Death Loop',4,20,NULL,50,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'80',0,0,'bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2733,'Medal_Gunner','Sheriff Badge',4,20,NULL,0,NULL,1,NULL,0,0x41000000,63,2,136,NULL,'70',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus bCritical,10; bonus bMaxHP,300; bonus bMaxSP,80; bonus3 bAddEff,Eff_Blind,100,ATF_LONG;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2734,'Directive_A','Directive',4,0,NULL,0,NULL,1,NULL,0,0x00000001,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2735,'Directive_B','Directive',4,0,NULL,0,NULL,1,NULL,0,0x00000001,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2736,'Navel_Ring','Navel Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'75',0,0,'bonus bDex,3; bonus bLuk,3; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2737,'Foot_Ring','Foot Ring',4,20,NULL,150,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'75',0,0,'bonus bVit,3; bonus bMaxHPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2738,'Shiny_Coin','Shiny Coin',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bAddClass,Class_All,6; bonus bMatkRate,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2739,'Ordinary_Coin','Ordinary Coin',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2740,'Rusty_Coin','Rusty Coin',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bAddClass,Class_All,3; bonus bMatkRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2741,'All_In_One_Ring','All In One Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,1; bonus bNoCastCancel; bonus bVariableCastrate,10; skill "AL_HEAL",1; skill "AL_TELEPORT",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2742,'Lucky_Clip','Lucky Clip',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bDropAddRace,RC_All,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2743,'Angelic_Ring','Angelic Ring',4,20,NULL,100,NULL,0,NULL,0,0x00CFFF80,18,2,136,NULL,'70',0,0,'bonus bInt,2; bonus bDex,1; bonus bMdef,2; autobonus3 "{ bonus bHealPower,20; }",100,3000,"AL_HEAL","{ specialeffect2 EF_HEAL3; }"; autobonus3 "{ bonus bHealPower,20; }",100,3000,"AM_POTIONPITCHER","{ specialeffect2 EF_HEAL3; }"; autobonus3 "{ bonus bHealPower,20; }",100,3000,"PR_SANCTUARY","{ specialeffect2 EF_HEAL3; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2744,'Sprint_Ring','Sprint Ring',4,20,NULL,100,NULL,0,NULL,0,0x00CFFF80,18,2,136,NULL,'70',0,0,'bonus bVariableCastrate,-10; bonus bDelayRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2745,'Pinguicula_Corsage','Pinguicula Corsage',4,20,NULL,200,NULL,0,NULL,1,0x00CFFF80,18,2,136,NULL,'70',0,0,'bonus bMdef,2; bonus bMaxSP,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2746,'Cold_Heart','Cold Heart',4,20,NULL,100,NULL,1,NULL,0,0x00001000,18,2,136,NULL,'80',0,0,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2747,'Black_Cat','Black Cat',4,20,NULL,100,NULL,1,NULL,0,0x00020000,18,2,136,NULL,'80',0,0,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2748,'Cursed_Star','Cursed Star',4,20,NULL,200,NULL,0,NULL,0,0x00080808,18,2,136,NULL,'84',0,0,'bonus bMdef,3; bonus bDex,2; bonus bLuk,-1; bonus2 bHPLossRate,50,10000; bonus3 bAddEff,Eff_Curse,200,ATF_WEAPON|ATF_LONG|ATF_TARGET;',NULL,'heal -300,0;');
REPLACE INTO `item_db_re` VALUES (2749,'Linen_Glove','Linen Glove',4,20,NULL,120,NULL,1,NULL,1,0x00CFFF80,18,2,136,NULL,'90',0,0,'bonus bMdef,2; bonus bAgi,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2750,'Summer_Night_Dream','Summer Night Dream',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'/* skill "ALL_DREAM_SUMMERNIGHT",1; */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2751,'Academy_Badge','Academy Of Badge',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'if(BaseLevel<80) { bonus bMaxHP,400; bonus bMaxSP,200; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2752,'Praxinus_C','Praccsinos',4,2,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2753,'Beholder_Ring','Beholder Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bExpAddRace,RC_Formless,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2754,'Hallow_Ring','Hallow Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bExpAddRace,RC_Undead,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2755,'Clamorous_Ring','Clamorous Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bExpAddRace,RC_Brute,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2756,'Chemical_Ring','Chemical Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bExpAddRace,RC_Plant,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2757,'Insecticide_Ring','Insecticide Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bExpAddRace,RC_Insect,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2758,'Fisher_Ring','Fischer Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bExpAddRace,RC_Fish,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2759,'Decussate_Ring','Decussate Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bExpAddRace,RC_Demon,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2760,'Bloody_Ring','Bloody Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bExpAddRace,RC_DemiHuman,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2761,'Satanic_Ring','Satanic Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bExpAddRace,RC_Angel,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2762,'Dragoon_Ring','Dragon Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bExpAddRace,RC_Dragon,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2763,'Skul_Ring_C','Neo Skull Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,18,2,136,NULL,'95',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkrate,5; bonus bMaxHPrate,5; skill "MG_SIGHT",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2764,'Small_Fishing_Rod','Small Fishing Rod',4,10,NULL,250,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2765,'Novice_Figure','Novice Figure',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMaxHP,70; if(BaseJob==Job_Novice||BaseJob==Job_SuperNovice) bonus bMaxHP,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2766,'Swordman_Figure','Swordman Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bVit,1; if(Class==Job_Swordman) bonus bDef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2767,'Acolyte_Figure','Acolyte Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bInt,1; if(Class==Job_Acolyte) bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2768,'Mage_Figure','Mage Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bInt,1; if(Class==Job_Mage) bonus bSPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2769,'Archer_Figure','Archer Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bDex,1; if(Class==Job_Archer) bonus bBaseAtk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2770,'Thief_Figure','Thief Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAgi,1; if(Class==Job_Thief) bonus bAspdRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2771,'Merchant_Figure','Merchant Figure',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bStr,1; if(Class==Job_Merchant) bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2772,'Krieger_Ring1','Glorious Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'81',0,0,'bonus bMaxHP,300; bonus2 bSubEle,Ele_Water,10; bonus2 bSubEle,Ele_Wind,10; bonus2 bSubEle,Ele_Earth,10; bonus2 bSubEle,Ele_Fire,10; bonus bAspdRate,5; bonus bVariableCastrate,-3; bonus bHealPower,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2773,'Krieger_Ring2','Glorious Mass-Production Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'61',0,0,'bonus bAllStats,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2774,'Krieger_Ring3','Glorious Popularized Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'0',0,0,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2775,'Lure','Lure',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2776,'Cool_Towel','Adventurer\'s Trusty Towel',4,20,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,'sc_start SC_SUMMER,INFINITE_TICK,0;','sc_end SC_SUMMER;');
REPLACE INTO `item_db_re` VALUES (2777,'Shaman_Ring','Shaman Ring',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'30',0,0,'bonus bMaxHP,50; bonus bSPrecovRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2778,'Shaman_Earing','Shaman Earrings',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2779,'Dark_Knight_Belt','Dark Knight Belt',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bStr,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2780,'Dark_Knight_Glove','Dark Knight Glove',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'80',0,0,'autobonus "{ bonus bAspdRate,2; }",10,10000,0,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2781,'Aumdura\'s_Grace','Aumdura\'s Benefit',4,0,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bAllStats,1; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2782,'Ring_Of_Wise_King','Ring of the Ancient Wise King',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMaxHP,50; bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2783,'Eyes_Stone_Ring','Eye Stone Ring',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'70',0,0,'bonus bCritical,2; bonus bMaxSP,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2784,'Oh_Holy_Night','Christmas Musicbox',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'skill "ALL_WEWISH",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2785,'Orleans_Glove_M','Orlean\'s Gloves',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFE,18,2,136,NULL,'90',0,0,'bonus bDex,2; bonus bMatkRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2786,'Spiritual_Ring_M','Spiritual Ring',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2787,'Waterdrop_Brooch','Waterdrop Brooch',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,18,2,136,NULL,'1',0,0,'bonus bMdef,2; bonus bMaxHPrate,1; bonus2 bSubEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2788,'Bradium_Earing','Bradium Earring',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,18,2,136,NULL,'0',0,0,'bonus bInt,1; bonus bDex,1; bonus bMatk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2789,'Bradium_Ring','Bradium Ring',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,18,2,136,NULL,'0',0,0,'bonus bStr,1; bonus bVit,1; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2790,'Bradium_Brooch','Bradium Brooch',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,18,2,136,NULL,'0',0,0,'bonus bAgi,1; bonus bFlee,4; if(readparam(bAgi)>=120) bonus bCritical,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2791,'Just_Got_Fish','Fresh Fish',4,20,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bHit,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2792,'Ring_Of_Flame_Lord_I','Ring of Flame Lord',4,0,NULL,0,NULL,0,NULL,0,0x00CFFF80,18,2,136,NULL,'0',0,0,'bonus bStr,2; bonus bVit,1; bonus bBaseAtk,15; bonus2 bSubEle,Ele_Fire,10; bonus3 bAutoSpell,"CH_SOULCOLLECT",1,30; bonus3 bAutoSpell,"MO_EXPLOSIONSPIRITS",1,10; bonus3 bAutoSpell,"PA_PRESSURE",2,30; bonus3 bAutoSpell,"MG_FIREBALL",1,150; bonus3 bAutoSpell,"KN_BOWLINGBASH",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2793,'Ring_Of_Resonance_I','Ring of Resonance',4,0,NULL,0,NULL,2,NULL,0,0x00CFFF80,18,2,136,NULL,'0',0,0,'bonus bAgi,2; bonus bVit,1; bonus bMdef,2; bonus4 bAutoSpellWhenHit,"WZ_QUAGMIRE",1,50,0; bonus3 bAutoSpellWhenHit,"AS_SPLASHER",10,20; bonus3 bAutoSpellWhenHit,"AL_HEAL",10,30; bonus3 bAutoSpellWhenHit,"HP_ASSUMPTIO",3,20; bonus3 bAutoSpellWhenHit,"CG_TAROTCARD",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2794,'Magic_Stone_Ring','Magic Stone Ring',4,0,NULL,0,NULL,0,NULL,1,0x00000080,63,2,136,NULL,'99',0,0,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2795,'Green_Apple_Ring','Green Apple Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'99',0,0,'if(JobLevel<30) { bonus bAllStats,6-(JobLevel/5); }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2796,'Magical_Stone','Rocks',4,0,NULL,200,NULL,0,NULL,0,0x00810204,63,2,136,NULL,'99',0,0,'bonus2 bAddDamageClass,2047,10; bonus2 bAddDefMonster,2048,-10; bonus3 bAddMonsterIdDropItem,6152,2047,70;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2797,'Magical_Stone_','Rocks',4,0,NULL,200,NULL,0,NULL,0,0x00810204,63,2,136,NULL,'99',0,0,'bonus2 bAddDamageClass,2049,10; bonus2 bAddDefMonster,2050,-10; bonus3 bAddMonsterIdDropItem,6151,2049,70;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2798,'Will_Of_Exhausted_Angel','Will Of Exhausted Angel',4,0,NULL,200,NULL,0,NULL,0,0x00008100,63,2,136,NULL,'99',0,0,'if(strcharinfo(3)=="job3_arch02") { bonus2 bAddDefMonster,1761,50; bonus2 bAddDefMonster,1762,50; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2799,'Kuirpenring','Kuirpenring',4,0,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2800,'Accelerator','Accelerator',4,100000,NULL,100,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2801,'Hovering_Booster','Hovering Booster',4,100000,NULL,2000,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2802,'Suicidal_Device','Suicidal Device',4,500000,NULL,1000,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2803,'Shape_Shifter','Shape Shifter',4,100000,NULL,500,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2804,'Cooling_Device','Cooling Device',4,100000,NULL,2500,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2805,'Mag_Field_Generator','Magnetic Field Generator',4,100000,NULL,6000,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2806,'Barrier_Builder','Barrier Builder',4,150000,NULL,8000,NULL,3,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2807,'Repair_Kit','Repair Kit',4,200000,NULL,400,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2808,'Camouflage_Generator','Camouflague Generator',4,250000,NULL,1000,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2809,'High_Quality_Cooler','High Quality Cooler',4,100000,NULL,2500,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2810,'Special_Cooler','Special Cooler',4,100000,NULL,2500,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'99',0,0,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2811,'Freyja_SBracelet7','Freyja\'s Spirit Bracelet',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'20',0,0,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2812,'Freyja_SBracelet30','Freyja\'s Spirit Bracelet',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'20',0,0,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2813,'Freyja_SBracelet60','Freyja\'s Spirit Bracelet',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'20',0,0,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2814,'Freyja_SBracelet90','Freyja\'s Spirit Bracelet',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'20',0,0,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2815,'Th_Ring_Of_Water','Ring Of Water',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,1; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2816,'Radar_Ring1','Radar Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus3 bAddMonsterIdDropItem,6206,1002,400; bonus3 bAddMonsterIdDropItem,6207,1161,400; bonus3 bAddMonsterIdDropItem,6208,1153,400;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2817,'Radar_Ring2','Radar Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus3 bAddMonsterIdDropItem,6206,1026,400; bonus3 bAddMonsterIdDropItem,6207,1197,400; bonus3 bAddMonsterIdDropItem,6208,1504,400;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2818,'Radar_Ring3','Radar Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus3 bAddMonsterIdDropItem,6206,1508,400; bonus3 bAddMonsterIdDropItem,6207,1098,400; bonus3 bAddMonsterIdDropItem,6208,1315,400;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2819,'Swordman_Manual','Swordsman Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,63,2,136,NULL,'1',0,0,'bonus bMaxSP,100; skill "SM_BASH",1; skill "SM_PROVOKE",1; skill "SM_MAGNUM",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2820,'Thief_Manual','Thief Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,63,2,136,NULL,'1',0,0,'bonus bMaxSP,100; skill "TF_DOUBLE",3; bonus bDoubleRate,15; skill "TF_STEAL",1; skill "TF_HIDING",1; skill "TF_POISON",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2821,'Acolyte_Manual','Acolyte Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,63,2,136,NULL,'1',0,0,'bonus bMaxSP,100; skill "AL_HEAL",1; skill "AL_INCAGI",1; skill "AL_BLESSING",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2822,'Archer_Manual','Archer Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,63,2,136,NULL,'1',0,0,'bonus bMaxSP,100; skill "AC_OWL",1; skill "AC_CONCENTRATION",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2823,'Merchant_Manual','Merchant Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,63,2,136,NULL,'1',0,0,'bonus bMaxSP,100; skill "MC_DISCOUNT",1; skill "MC_OVERCHARGE",1; skill "MC_IDENTIFY",1; skill "MC_MAMMONITE",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2824,'Mage_Manual','Mage Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,63,2,136,NULL,'1',0,0,'bonus bMaxSP,100; skill "MG_SRECOVERY",1; skill "MG_COLDBOLT",1; skill "MG_FIREWALL",1; skill "MG_FIREBOLT",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2825,'Shaman_EaringB','Shaman Earrings',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2826,'Dark_Knight_BeltB','Dark Knight Belt',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bDex,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2827,'Dark_Knight_GloveB','Dark Knight Glove',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'autobonus "{ bonus bMaxHPrate,10; }",10,10000,0,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2828,'Upg_Clip','Upg Clip',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bMaxSP,50; bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2829,'Greed_Clip','Greed Clip',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'10',0,0,'skill "BS_GREED",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2830,'Magingiorde_C','Megingjard',4,20,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,136,NULL,'94',0,0,'bonus bStr,40; bonus bMdef,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2831,'Brysinggamen_C','Brisingamen',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'94',0,0,'bonus bStr,6; bonus bInt,6; bonus bVit,6; bonus bAgi,6; bonus bLuk,10; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2832,'Freyja_Ring','Freyja\'s Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2833,'Odin\'s_Recall','Odin\'s Recall',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bAllStats,1; skill "ALL_ODINS_RECALL",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2834,'F_All_In_One_Ring','All In One Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,1; bonus bNoCastCancel; bonus bVariableCastrate,10; skill "AL_HEAL",1; skill "AL_TELEPORT",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2835,'F_Critical_Ring_C','Critical Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bCritical,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2836,'F_Glove_C','Glove',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2837,'F_Safety_Ring_C','Safety Ring',4,1,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2838,'F_Necklace_C','Necklace',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bVit,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2839,'F_Ring_C','Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bStr,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2840,'F_Rosary_C','Rosary',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bLuk,4; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2841,'Caracas_Ring','Caracas Ring',4,0,NULL,0,NULL,2,NULL,0,0xFFFFFFFE,63,2,136,NULL,'99',0,0,'bonus bInt,2; bonus bDex,2; bonus bMdef,2; bonus2 bExpAddRace,RC_All,10; bonus2 bDropAddRace,RC_All,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2842,'F_Earing_C','Earring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2843,'Gold_Trickle','Gold Trickle',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'75',0,0,'bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2844,'El_Dicastes_Light','Light Of El Discastes',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'80',0,0,'skill "RETURN_TO_ELDICASTES",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2845,'No_Fear_Belt','No Fear Belt',4,0,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,136,NULL,'20',0,0,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2846,'E_All_In_One_Ring','All In One Ring',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2847,'E_Critical_Ring_C','Critical Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bCritical,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2848,'E_Glove_C','Glove',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2849,'E_Safety_Ring_C','Safety Ring',4,1,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2850,'E_Ring_C','Ring',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bVit,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2851,'E_Necklace_C','Necklace',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bStr,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2852,'E_Rosary_C','Rosary',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bLuk,4; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2853,'Telekinetic_Orb','Telekinetic Orb',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,63,2,136,NULL,'110',0,0,'bonus bMdef,1; bonus bInt,3; bonus bMaxSP,30; bonus2 bSkillAtk,"WL_SOULEXPANSION",10; bonus2 bSkillAtk,"SO_PSYCHIC_WAVE",10; bonus2 bSkillUseSP,"WL_SOULEXPANSION",-50; bonus2 bSkillUseSP,"SO_PSYCHIC_WAVE",-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2854,'Alchemy_Glove','Alchemy Glove',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFE,63,2,136,NULL,'125',0,0,'bonus bMdef,2; bonus bInt,1; bonus2 bMagicAtkEle,Ele_Fire,10; bonus2 bMagicAtkEle,Ele_Water,-20; bonus2 bSubEle,Ele_Water,-30; bonus3 bAutoSpell,"MG_FIREBALL",5,30; bonus5 bAutoSpell,"MG_FIREBOLT",5,30,BF_MAGIC,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2855,'Whike_Black_Tail','Whike Black Tail',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'45',0,0,'bonus bCritical,7; bonus bAspdRate,3; bonus2 bAddEff2,Eff_Curse,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2856,'Half_Megin','Half Megingjard',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'47',0,0,'bonus bMdef,3; bonus bStr,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2857,'Half_Brysing','Half Brisingamen',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'47',0,0,'bonus bStr,3; bonus bInt,5; bonus bVit,3; bonus bDex,3; bonus bAgi,3; bonus bLuk,5; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2858,'Pendant_Of_Guardian','Pendant Of Guardian',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'70',0,0,'skill "ALL_GUARDIAN_RECALL",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2859,'Golden_Rod_Orb','Golden Rod Orb',4,20,NULL,200,NULL,2,NULL,0,0x00000200,63,2,136,NULL,'100',0,0,'bonus bMdef,2; bonus bInt,1; bonus2 bSubEle,Ele_Wind,15; bonus3 bAutoSpellWhenHit,"WZ_JUPITEL",3,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2860,'Aqua_Orb','Aqua Orb',4,20,NULL,200,NULL,2,NULL,0,0x00000200,63,2,136,NULL,'100',0,0,'bonus bMdef,2; bonus bInt,1; bonus2 bSubEle,Ele_Water,15; bonus3 bAutoSpellWhenHit,"WZ_FROSTNOVA",3,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2861,'Crimson_Orb','Crismon Orb',4,20,NULL,200,NULL,2,NULL,0,0x00000200,63,2,136,NULL,'100',0,0,'bonus bMdef,2; bonus bInt,1; bonus2 bSubEle,Ele_Fire,15; bonus3 bAutoSpellWhenHit,"WZ_SIGHTRASHER",3,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2862,'Forest_Orb','Forest Orb',4,20,NULL,200,NULL,2,NULL,0,0x00000200,63,2,136,NULL,'100',0,0,'bonus bMdef,2; bonus bInt,1; bonus2 bSubEle,Ele_Earth,15; bonus3 bAutoSpellWhenHit,"WZ_QUAGMIRE",3,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2863,'Ring_Of_Valkyrie','Ring Of Valkyrie',4,0,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus2 bExpAddClass,Class_All,5; bonus2 bDropAddRace,RC_All,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2864,'Light_Of_Cure','Light Of Cure',4,20,NULL,0,NULL,0,NULL,0,0x00000100,63,2,136,NULL,'110',0,0,'bonus bVit,2; bonus bHealPower,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2865,'Seal_Of_Cathedral','Seal Of Cathedral',4,20,NULL,0,NULL,0,NULL,0,0x00000100,63,2,136,NULL,'110',0,0,'bonus bInt,2; bonus bHealPower,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2866,'Ring_Of_Archbishop','Ring Of Archbishop',4,20,NULL,0,NULL,0,NULL,0,0x00000100,63,2,136,NULL,'110',0,0,'bonus bDex,2; bonus bHealPower,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2867,'Broken_Bamboo_Piece','Broken Bamboo Piece',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2868,'Green_Batik','Green Batik',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,136,NULL,'45',0,0,'bonus bStr,1; bonus bInt,1; bonus bDex,1; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2869,'Colorful_Ketupat','Colorful Ketupat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'45',0,0,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2870,'Tw_8th_Anni_Ring','Tw 8th Anni Ring',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bStr,5; bonus bInt,5; bonus bVit,5; bonus bDex,5; bonus bAgi,5; bonus bLuk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2871,'Brazilian_Emblem','Brazilian Emblem',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'60',0,0,'bonus2 bAddClass,Class_All,3; bonus bMatkRate,3; bonus bMaxHP,50; bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2872,'G_Honor_Certificate','G Honor Certificate',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2873,'Cat_Hand_Glove','Cat Hand Glove',4,20,NULL,100,NULL,5,NULL,1,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bAgi,1; bonus bVit,1; bonus bDex,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2874,'Buffalo_Horn','Buffalo Horn',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'10',0,0,'bonus bAspd,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2875,'RO_Appreciation_Ring','RO Appreciation Ring',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2876,'Necklace_Spica','Necklace Spica',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'10',0,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2877,'Glove_Sabik','Glove Sabik',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'10',0,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2878,'Bracelet_Arunairi','Bracelet Arunairi',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'10',0,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2879,'Badge_Giorredart','Badge Giorredart',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'10',0,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2880,'Ring_Lupak','Ring Lupak',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'10',0,0,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2881,'Orleans_Necklace','Orleans Necklace',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bDex,2; bonus bMatk,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2882,'Ecoro_Cardslip','Ecoro Cardslip',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bVit,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2883,'Ur_Seal','Ur\'s Seal',4,20,NULL,200,NULL,4,NULL,1,0x00000080,56,2,136,NULL,'100',0,0,'bonus bMaxHPrate,2; bonus2 bSkillUseSP,"LK_SPIRALPIERCE",5; bonus2 bSkillUseSP,"RK_HUNDREDSPEAR",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2884,'Peuz_Seal','Peuz\'s Seal',4,20,NULL,200,NULL,3,NULL,1,0x00000080,56,2,136,NULL,'100',0,0,'bonus bBaseAtk,20; bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2885,'Mother_Heart','Mother Heart',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bBaseAtk,15; bonus bMatk,15; bonus2 bExpAddClass,Class_All,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2886,'Sabah_Ring','Sapha Ring',4,20,NULL,100,NULL,0,NULL,0,0x00001000,63,2,136,NULL,'100',0,0,'bonus bCritical,3; bonus2 bSkillUseSP,"GC_DARKILLUSION",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2887,'Nab_Ring','Nab Ring',4,20,NULL,100,NULL,0,NULL,0,0x00001000,63,2,136,NULL,'100',0,0,'bonus bBaseAtk,10; bonus bMatk,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2888,'School_Bag','School Bag',4,20,NULL,1000,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAspdRate,3; bonus bVariableCastrate,-3; if(BaseLevel<80){ bonus bMaxHP,200; bonus bMaxSP,100; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2889,'Endure_Ring','Endure Ring',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'60',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2890,'White_Wing_Brooch','White Wing Brooch',4,20,NULL,100,NULL,0,NULL,0,0x00000800,63,2,136,NULL,'100',0,0,'bonus bDex,2; bonus bLongAtkRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2891,'Black_wing_Brooch','Black Wing Brooch',4,20,NULL,100,NULL,0,NULL,0,0x00000800,56,2,136,NULL,'100',0,0,'bonus bInt,2; bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2892,'Assassin_Handcuffs','Assassin\'s Glove',4,56000,NULL,400,NULL,3,NULL,1,0x00001000,63,2,136,NULL,'100',0,0,'bonus bMaxSP,20; bonus bCritical,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2893,'Cursed_Heart','Cursed Heart',4,20,NULL,50,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'80',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2894,'Glove_Of_Shura','Sura Gauntlet',4,20,NULL,400,NULL,1,NULL,0,0x00008000,63,2,136,NULL,'130',0,0,'bonus bStr,5; bonus bMaxSPrate,6; bonus bMaxHPrate,-6; if(readparam(bStr)>=120){ bonus bBaseAtk,30; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2895,'Medal_Of_Valor1','Medal Of Valor1',4,0,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bVariableCastrate,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2896,'Medal_Of_Valor2','Medal Of Valor2',4,0,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAspdRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2897,'2011RWC_Necklace_J','2011RWC Necklace J',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus2 bAddClass,Class_All,5; bonus bMatkRate,5; bonus2 bExpAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2898,'Black_Rosary','Dark Rosary',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'90',0,0,'bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2899,'Sound_Amplifier','Sound Amplification Device',4,20,NULL,100,NULL,0,NULL,1,0x00080800,63,2,136,NULL,'90',0,0,'bonus2 bSkillAtk,"WM_METALICSOUND",150; bonus2 bSkillUseSP,"WM_METALICSOUND",-60; bonus bVariableCastrate,-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2900,'Morrigane\'s_Belt_','Morrigane\'s Belt',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'61',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2901,'Morrigane\'s_Pendant_','Morrigane\'s Pendant',4,30000,NULL,200,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'61',0,0,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2902,'Morpheus\'s_Ring_','Morpheus\'s Ring',4,30000,NULL,100,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'33',0,0,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2903,'Morpheus\'s_Armlet_','Morpheus\'s Armlet',4,30000,NULL,100,NULL,0,NULL,1,0xFFFFFFFE,63,2,136,NULL,'33',0,0,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2904,'Naqsh','Naqsi',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'skill "BS_MAXIMIZE",5; skill "BS_WEAPONPERFECT",5; skill "WL_RECOGNIZEDSPELL",5; skill "ECL_SNOWFLIP",1; skill "ECL_PEONYMAMY",1; skill "ECL_SADAGUI",1; skill "ECL_SEQUOIADUST",1; bonus2 bSkillCooldown,"WL_RECOGNIZEDSPELL",-180000; bonus bDelayRate,-100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2905,'Super_Ora_Ora','Super Ora Ora',4,0,NULL,1000,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2906,'Happy_Gauntlet','Happy Gauntlet',4,20,NULL,1000,NULL,3,NULL,1,0xFFFFFFFF,63,2,136,NULL,'70',0,0,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2907,'Buwaya_Tattoo','Bawaya Agimat Tattoo',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bMatkRate,7; bonus bFixedCastrate,-7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2908,'Light_Ring','Light Ring',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2909,'Darkness_Ring','Darkness Ring',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2910,'Bakonawa_Tattoo','Bakunawa Agimat Tattoo',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus2 bAddClass,Class_All,7; bonus bAspdRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2911,'Bangungot_Tattoo','Bangungot Agimat Tattoo',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bHealPower,4; bonus bHealPower2,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2912,'Xylitol_2011','Xylitol 2011',4,20,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2913,'Thief_Handcuff','Thief Handcuff',4,20,NULL,1400,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'10',0,0,'bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2914,'Wizard_Left_Eye','Wizard Left Eye',4,20,NULL,100,NULL,1,NULL,1,0x00CFDF80,63,2,136,NULL,'0',0,0,'bonus bInt,4; bonus bMdef,3; bonus bVariableCastrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2915,'Ettlang_Keepsake','Ettlang Keepsake',4,20,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2916,'Fairy_Wing','Fairy Wing',4,0,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'90',0,0,'skill "ECLAGE_RECALL",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2917,'Str_Glove','Str Glove',4,75000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bBaseAtk,(readparam(bStr)/10); if(readparam(bStr)>=110) bonus2 bAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2918,'Int_Glove','Int Glove',4,75000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bMatk,(readparam(bInt)/10); if(readparam(bInt)>=110) bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2919,'Agi_Glove','Agi Glove',4,75000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bFlee,(readparam(bAgi)/10); if(readparam(bAgi)>=110) bonus bFlee2,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2920,'Vit_Glove','Vit Glove',4,75000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bMaxHP,(readparam(bVit)/10)*50; if(readparam(bVit)>=110) bonus bMaxHPrate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2921,'Dex_Glove','Dex Glove',4,75000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bHit,(readparam(bDex)/10); if(readparam(bDex)>=110) bonus bLongAtkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2922,'Luk_Glove','Luk Glove',4,75000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bCritical,(readparam(bLuk)/10); if(readparam(bLuk)>=110) bonus bCritAtkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2923,'Str_Glove_','Str Glove',4,75000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bBaseAtk,(readparam(bStr)/10); if(readparam(bStr)>=110) bonus2 bAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2924,'Int_Glove_','Int Glove',4,75000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bMatk,(readparam(bInt)/10); if(readparam(bInt)>=110) bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2925,'Agi_Glove_','Agi Glove',4,75000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bFlee,(readparam(bAgi)/10); if(readparam(bAgi)>=110) bonus bFlee2,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2926,'Vit_Glove_','Vit Glove',4,75000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bMaxHP,(readparam(bVit)/10)*50; if(readparam(bVit)>=110) bonus bMaxHPrate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2927,'Dex_Glove_','Dex Glove',4,75000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bHit,(readparam(bDex)/10); if(readparam(bDex)>=110) bonus bLongAtkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2928,'Luk_Glove_','Luk Glove',4,75000,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'100',0,0,'bonus bMaxHP,100; bonus bMaxSP,20; bonus bCritical,(readparam(bLuk)/10); if(readparam(bLuk)>=110) bonus bCritAtkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2935,'Sprint_Gloves','Sprint Gloves',4,20,NULL,100,NULL,0,NULL,1,0x000FDF80,58,2,136,NULL,'1',0,0,'bonus bVariableCastrate,-1; bonus bDelayrate,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2936,'Recovery_Ring','Recovery Ring',4,20,NULL,100,NULL,5,NULL,1,0xFFFFFFFF,63,2,136,NULL,'10',0,0,'bonus bVit,1; bonus bMaxHP,250; bonus bMaxHPrate,5; bonus bHealPower2,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2940,'Ninja_Manual','Ninja Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,63,2,136,NULL,'0',0,0,'bonus bMaxSP,100; skill "NJ_UTSUSEMI",1; skill "NJ_KOUENKA",1; skill "NJ_SYURIKEN",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2941,'Gunslinger_Manual','Gunslinger Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,63,2,136,NULL,'0',0,0,'bonus bMaxSP,100; skill "GS_GLITTERING",1; skill "GS_ADJUSTMENT",1; skill "GS_MADNESSCANCEL",1; skill "GS_INCREASING",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2942,'Taekwon_Manual','Taekwon Manual',4,0,NULL,100,NULL,0,NULL,0,0x00000001,63,2,136,NULL,'0',0,0,'bonus bMaxSP,100; skill "TK_SEVENWIND",4; skill "TK_JUMPKICK",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2943,'Critical_Ring_','Critical Ring',4,0,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,NULL,0,NULL,'bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2944,'TE_Ring_Of_Protection','TE Ring Of Protection',4,0,NULL,0,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,136,NULL,'40',0,NULL,'bonus bMaxHP,100; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2945,'TE_Ring_Of_Rage','TE Ring Of Rage',4,0,NULL,0,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,136,NULL,'40',0,NULL,'bonus2 bAddRace,RC_Player,5; bonus2 bMagicAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2946,'TE_Ring_Of_Defiance','TE Ring Of Defiance',4,0,NULL,0,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,136,NULL,'40',0,NULL,'bonus bMdef,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2948,'Demon_Wing','Demon Wing',4,10,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,'70',NULL,NULL,'bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2949,'Silversmith_Bracelet','Silversmith Bracelet',4,10,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,136,NULL,'60',NULL,NULL,'bonus bAllStats,1; bonus bMdef,3; skill "SA_SPELLBREAKER",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2950,'Rune_Ring','Rune Ring',4,0,NULL,0,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,NULL,'bonus2 bExpAddClass,Class_Normal,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2951,'Kvasir_Ring_Blue','Kvasir Ring Blue',4,0,NULL,100,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,NULL,'bonus bMaxSP,30; skill "ECL_SNOWFLIP",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2952,'Kvasir_Ring_Red','Kvasir Ring Red',4,0,NULL,100,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,NULL,'bonus bMaxSP,30; skill "ECL_PEONYMAMY",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2953,'Kvasir_Ring_Green','Kvasir Ring Green',4,0,NULL,100,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,NULL,'bonus bMaxHP,100; skill "ECL_SADAGUI",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2954,'Kvasir_Ring_Brown','Kvasir Ring Brown',4,10,NULL,100,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',NULL,NULL,'bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2956,'Safety_Ring_','Advanced Safety Ring',4,75000,NULL,100,NULL,10,NULL,1,0xFFFFFFFE,63,2,136,NULL,'50',0,0,'bonus bMdef,5; bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2957,'Good_Ring_Of_Flame_Lord','Advanced Ring Of Flame Lord',4,20,NULL,100,NULL,0,NULL,0,0x7CCFDF80,63,2,136,NULL,'85',0,0,'bonus bStr,3; bonus bVit,2; bonus bBaseAtk,20; bonus2 bSubEle,Ele_Fire,10; bonus3 bAutoSpell,"CH_SOULCOLLECT",1,30; bonus3 bAutoSpell,"MO_EXPLOSIONSPIRITS",1,10; bonus3 bAutoSpell,"PA_PRESSURE",2,30; bonus3 bAutoSpell,"MG_FIREBALL",1,150; bonus3 bAutoSpell,"KN_BOWLINGBASH",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2958,'Good_Ring_Of_Resonance','Advanced Ring Of Resonance',4,20,NULL,100,NULL,2,NULL,0,0x7CCFDF80,63,2,136,NULL,'85',0,0,'bonus bAgi,3; bonus bVit,1; bonus bMdef,2; bonus bMatk,10; bonus4 bAutoSpellWhenHit,"WZ_QUAGMIRE",1,50,0; bonus3 bAutoSpellWhenHit,"AS_SPLASHER",10,20; bonus3 bAutoSpellWhenHit,"AL_HEAL",10,30; bonus3 bAutoSpellWhenHit,"HP_ASSUMPTIO",3,20; bonus3 bAutoSpellWhenHit,"CG_TAROTCARD",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2959,'Fidelity_Necklace','Fidelity Necklace',4,20,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'50',0,0,'bonus bAgi,2; bonus2 bSubRace,RC_Brute,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2960,'Badge_Of_Manny','Badge Of Manny',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2963,'Body_Power_Up_Ring','Physical Enhancer Ring',4,10,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,'90',0,0,'bonus2 bAddClass,Class_All,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2964,'Ring_Of_Spell_Explosion','Magic Intensifier Ring',4,10,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,'90',0,0,'bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2966,'RWC_2012_Ring','RWC 2012 Ring',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2967,'RWC_2012_Ring_','Chambered RWC 2012 Ring',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus2 bAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2968,'RWC_2012_Pendant','RWC 2012 Pendant',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2969,'RWC_2012_Pendant_','Chambered RWC 2012 Pendant',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2971,'Pocket_Watch','Pocket Watch',4,10,NULL,200,NULL,1,NULL,1,0x800200,63,2,136,NULL,'80',0,NULL,'bonus bHPrecovRate,15; bonus bSPrecovRate,15; bonus bMatkRate,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2976,'Red_Lantern','Red Lantern',4,10,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'100',0,NULL,'bonus bMaxSP,-300; skill "MG_SIGHT",1;',NULL,'sc_end SC_SIGHT;');
REPLACE INTO `item_db_re` VALUES (2977,'Hurt_Mind','Hurt Mind',4,10,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'110',0,NULL,'bonus bMaxSP,200; skill "DC_SCREAM",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2978,'KindHeart','Kind Heart',4,10,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'110',0,NULL,'bonus bMaxHP,500; bonus2 bHPRegenRate,300,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2979,'Strawberry_Decoration','Strawberry Decoration',4,20,NULL,500,NULL,1,NULL,1,0xFFFFFFFE,63,2,136,NULL,'1',NULL,NULL,'bonus bAllStats,1; bonus3 bAutoSpellWhenHit,"WZ_FROSTNOVA",3,10; /* Confirm: Frost Nova cast chance */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2980,'Evilspirit_Gloves','Evil Spirit Gloves',4,10,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,'110',NULL,NULL,'bonus bMaxHP,500; bonus bMaxSP,200; skill "PF_SPIDERWEB",1; bonus3 bAutoSpell,"SO_PSYCHIC_WAVE",1,20; bonus5 bAutoSpell,"HW_MAGICPOWER",1,10,BF_MAGIC,0; bonus5 bAutoSpell,"WZ_FROSTNOVA",10,10,BF_WEAPON|BF_MAGIC,0; bonus5 bAutoSpellWhenHit,"DC_SCREAM",1,50,BF_WEAPON|BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2981,'RingOfHero','Warrior\'s Ring',4,10,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'160',NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2983,'Greed_Brooch','Greed Brooch',4,10,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,'50',NULL,NULL,'bonus2 bHPLossRate,10,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2984,'Glove_Save_Rimnil','Glove Save Rimnil',4,10,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,'30',NULL,NULL,'bonus2 bExpAddRace,RC_All,5; bonus2 bSubRace,RC_All,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2985,'Gyges_Ring','Gyges Ring',4,10,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,'50',NULL,NULL,'bonus bInt,3; bonus bMatk,30; skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db_re` VALUES (2986,'Snake_Ring','Snake Ring',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bDex,3; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2987,'Snake_Pendant','Snake Pendant',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAgi,3; bonus bLuk,2; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2988,'Winged_Ring_Of_Newoz','Oz\'s New Wing Ring',4,20,NULL,100,NULL,0,NULL,1,0x00080000,56,1,136,NULL,'130',NULL,NULL,'bonus bVariableCastrate,-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2989,'Floral_Bracelet_Of_Igu','Bloody Floral Decoration Bracelet',4,20,NULL,100,NULL,0,NULL,1,0x00080000,56,0,136,NULL,'130',NULL,NULL,'bonus bVariableCastrate,-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2990,'Pendant_Of_Harmony','Pendant of Harmony',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'130',NULL,NULL,'bonus bMatkRate,6; bonus bHPrecovRate,50; bonus bSPrecovRate,50; bonus2 bSubEle,Ele_Holy,5; autobonus "{ bonus2 bHPRegenRate,1000,5000; }",100,90000,BF_NORMAL; bonus4 bAutoSpellWhenHit,"PR_SANCTUARY",3,100,0; bonus bStr,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2991,'Pendant_Of_Chaos','Pendant of Chaos',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'130',NULL,NULL,'bonus2 bAddClass,Class_All,6; bonus2 bSubEle,Ele_Dark,5; bonus2 bResEff,Eff_Confusion,10000; bonus2 bAddEff,Eff_Confusion,500; bonus3 bAutoSpellWhenHit,"NPC_WIDECONFUSE",2,30; bonus bInt,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2992,'Pendant_Of_Maelstorm','Pendant of Maelstrom',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'130',NULL,NULL,'bonus2 bAddClass,Class_All,6; bonus bMatkRate,6; bonus bAllStats,1; bonus5 bAutoSpellWhenHit,"SC_MAELSTROM",1,100,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2995,'Supplement_Part_Dex','Supplement Part Dex',4,25000,NULL,100,NULL,0,NULL,1,0x00000400,56,2,136,NULL,'100',0,0,'bonus bUseSPrate,-10; bonus bDelayrate,-10; bonus bVariableCastrate,-10; bonus2 bSkillCooldown,"NC_AXEBOOMERANG",-2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2996,'Upgrade_Part_Gun_Barrel','Reinforced Parts - Gun Barrel',4,10,NULL,500,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,'100',NULL,NULL,'bonus2 bAddClass,Class_All,4; bonus bHit,10; bonus2 bSkillAtk,"NC_BOOSTKNUCKLE",25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2997,'RWC_Gold_Brooch','RWC Gold Brooch',4,10,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,63,2,136,NULL,'0',0,NULL,'bonus bBaseAtk,25; bonus bMatk,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2998,'Shining_Trapezohedron','Shining Trapezohedron',4,0,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,136,NULL,'90',NULL,NULL,'bonus2 bSubEle,Ele_Holy,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (2999,'RWC_Brooch','RWC Brooch',4,10,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,NULL,'bonus bMaxHP,300; bonus bMaxSP,30;',NULL,NULL);
#===================================================================
# Cards
#===================================================================
REPLACE INTO `item_db_re` VALUES (4001,'Poring_Card','Poring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bLuk,2; bonus bFlee2,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4002,'Fabre_Card','Fabre Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bVit,1; bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4003,'Pupa_Card','Pupa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHP,700;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4004,'Drops_Card','Drops Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bDex,1; bonus bHit,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4005,'Poring__Card','Santa Poring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Dark,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4006,'Lunatic_Card','Lunatic Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bLuk,1; bonus bCritical,1; bonus bFlee2,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4007,'Pecopeco_Egg_Card','Peco Peco Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Formless,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4008,'Picky_Card','Picky Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus bBaseAtk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4009,'Chonchon_Card','Chonchon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus bFlee,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4010,'Wilow_Card','Willow Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMaxSP,80;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4011,'Picky__Card','Picky Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,1; bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4012,'Thief_Bug_Egg_Card','Thief Bug Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bMaxHP,400;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4013,'Andre_Egg_Card','Andre Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4014,'Roda_Frog_Card','Roda Frog Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHP,400; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4015,'Condor_Card','Condor Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4016,'Thief_Bug_Card','Thief Bug Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4017,'Savage_Babe_Card','Savage Babe Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Stun,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4018,'Andre_Larva_Card','Andre Larva Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bMaxSP,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4019,'Hornet_Card','Hornet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus bBaseAtk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4020,'Farmiliar_Card','Familiar Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Blind,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4021,'Rocker_Card','Rocker Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDex,1; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4022,'Spore_Card','Spore Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4023,'Desert_Wolf_Babe_Card','Baby Desert Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4024,'Plankton_Card','Plankton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Sleep,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4025,'Skeleton_Card','Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; bonus2 bAddEff,Eff_Stun,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4026,'Thief_Bug_Female_Card','Female Thief Bug Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus bFlee,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4027,'Kukre_Card','Kukre Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4028,'Tarou_Card','Tarou Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4029,'Wolf_Card','Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,15; bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4030,'Mandragora_Card','Mandragora Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Wind,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4031,'Pecopeco_Card','Peco Peco Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4032,'Ambernite_Card','Ambernite Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4033,'Poporing_Card','Poporing Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "TF_DETOXIFY",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4034,'Worm_Tail_Card','Wormtail Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4035,'Hydra_Card','Hydra Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_DemiHuman,20; bonus2 bAddRace,RC_Player,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4036,'Muka_Card','Muka Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4037,'Snake_Card','Snake Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Poison,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4038,'Zombie_Card','Zombie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4039,'Stainer_Card','Stainer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Silence,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4040,'Creamy_Card','Creamy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "AL_TELEPORT",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4041,'Coco_Card','Coco Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Sleep,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4042,'Steel_Chonchon_Card','Steel Chonchon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Wind,10; bonus bDef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4043,'Andre_Card','Andre Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4044,'Smokie_Card','Smokie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db_re` VALUES (4045,'Horn_Card','Horn Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bLongAtkDef,35;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4046,'Martin_Card','Martin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Blind,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4047,'Ghostring_Card','Ghostring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Ghost; bonus bHPrecovRate,-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4048,'Poison_Spore_Card','Poison Spore Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "TF_POISON",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4049,'Vadon_Card','Vadon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Fire,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4050,'Thief_Bug_Male_Card','Male Thief Bug Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4051,'Yoyo_Card','Yoyo Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bFlee2,5; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4052,'Elder_Wilow_Card','Elder Willow Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4053,'Vitata_Card','Vitata Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "AL_HEAL",1; bonus bUseSPrate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4054,'Angeling_Card','Angeling Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Holy;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4055,'Marina_Card','Marina Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Freeze,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4056,'Dustiness_Card','Dustiness Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Wind,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4057,'Metaller_Card','Metaller Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Silence,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4058,'Thara_Frog_Card','Thara Frog Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_DemiHuman,30; bonus2 bSubRace,RC_Player,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4059,'Soldier_Andre_Card','Soldier Andre Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Plant,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4060,'Goblin_Card','Goblin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Brute,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4061,'Cornutus_Card','Cornutus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bUnbreakableArmor; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4062,'Anacondaq_Card','Anacondaq Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Poison,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4063,'Caramel_Card','Caramel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Insect,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4064,'Zerom_Card','Zerom Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4065,'Kaho_Card','Kaho Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Earth,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4066,'Orc_Warrior_Card','Orc Warrior Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Brute,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4067,'Megalodon_Card','Megalodon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Freeze,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4068,'Scorpion_Card','Scorpion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Plant,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4069,'Drainliar_Card','Drainliar Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Water,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4070,'Eggyra_Card','Eggyra Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bSPrecovRate,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4071,'Orc_Zombie_Card','Orc Zombie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Undead,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4072,'Golem_Card','Golem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bUnbreakableWeapon; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4073,'Pirate_Skel_Card','Pirate Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "MC_DISCOUNT",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4074,'BigFoot_Card','Bigfoot Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Insect,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4075,'Argos_Card','Argos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Stone,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4076,'Magnolia_Card','Magnolia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Curse,500; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4077,'Phen_Card','Phen Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bNoCastCancel; bonus bVariableCastrate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4078,'Savage_Card','Savage Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4079,'Mantis_Card','Mantis Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bStr,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4080,'Flora_Card','Flora Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Fish,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4081,'Hode_Card','Hode Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Earth,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4082,'Desert_Wolf_Card','Desert Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Small,15; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4083,'Rafflesia_Card','Rafflesia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Fish,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4084,'Marine_Sphere_Card','Marine Sphere Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "SM_MAGNUM",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4085,'Orc_Skeleton_Card','Orc Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Holy,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4086,'Soldier_Skeleton_Card','Soldier Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritical,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4087,'Giearth_Card','Giearth Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Confusion,10000; bonus2 bSubEle,Ele_Earth,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4088,'Frilldora_Card','Frilldora Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'skill "AS_CLOAKING",1;',NULL,'sc_end SC_CLOAKING;');
REPLACE INTO `item_db_re` VALUES (4089,'Sword_Fish_Card','Swordfish Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Water; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4090,'Munak_Card','Munak Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Stone,1500; bonus2 bSubEle,Ele_Earth,5; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4091,'Kobold_Card','Kobold Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus bCritical,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4092,'Skel_Worker_Card','Skeleton Worker Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Medium,15; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4093,'Obeaune_Card','Obeaune Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "AL_CURE",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4094,'Archer_Skeleton_Card','Archer Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4095,'Marse_Card','Marse Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Water,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4096,'Zenorc_Card','Zenorc Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Poison,400; bonus bBaseAtk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4097,'Matyr_Card','Matyr Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,10; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4098,'Dokebi_Card','Dokebi Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Wind; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4099,'Pasana_Card','Pasana Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Fire; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4100,'Sohee_Card','Sohee Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxSPrate,15; bonus bSPrecovRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4101,'Sand_Man_Card','Sandman Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Earth; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4102,'Whisper_Card','Whisper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,20; bonus2 bSubEle,Ele_Ghost,-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4103,'Horong_Card','Horong Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "MG_SIGHT",1;',NULL,'sc_end SC_SIGHT;');
REPLACE INTO `item_db_re` VALUES (4104,'Requiem_Card','Requiem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEff,Eff_Confusion,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4105,'Marc_Card','Marc Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Water,5; bonus2 bResEff,Eff_Freeze,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4106,'Mummy_Card','Mummy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bHit,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4107,'Verit_Card','Verit Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,8; bonus bMaxSPrate,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4108,'Myst_Card','Myst Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Poison,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4109,'Jakk_Card','Jakk Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Fire,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4110,'Ghoul_Card','Ghoul Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Poison,2000; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4111,'Strouf_Card','Strouf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Demon,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4112,'Marduk_Card','Marduk Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Silence,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4113,'Marionette_Card','Marionette Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Ghost,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4114,'Argiope_Card','Argiope Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Poison; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4115,'Hunter_Fly_Card','Hunter Fly Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bHPDrainRate,30,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4116,'Isis_Card','Isis Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Dark,30; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4117,'Side_Winder_Card','Sidewinder Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'skill "TF_DOUBLE",1; bonus bDoubleRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4118,'Petit_Card','Earth Petite Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Dragon,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4119,'Bathory_Card','Bathory Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Dark;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4120,'Petit__Card','Sky Petite Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Dragon,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4121,'Phreeoni_Card','Phreeoni Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bHit,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4122,'Deviruchi_Card','Deviruchi Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4123,'Eddga_Card','Eddga Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,-25; bonus bNoWalkDelay;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4124,'Medusa_Card','Medusa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Demon,15; bonus2 bResEff,Eff_Stone,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4125,'Deviace_Card','Deviace Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_DemiHuman,7; bonus2 bAddRace,RC_Player,7; bonus2 bAddRace,RC_Brute,7; bonus2 bAddRace,RC_Plant,7; bonus2 bAddRace,RC_Insect,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4126,'Minorous_Card','Minorous Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Large,15; bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4127,'Nightmare_Card','Nightmare Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Sleep,10000; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4128,'Golden_Bug_Card','Golden Thief Bug Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bNoMagicDamage,100; bonus bUseSPrate,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4129,'Baphomet__Card','Bapho Jr. Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bAgi,3; bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4130,'Scorpion_King_Card','Scorpion King Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Undead,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4131,'Moonlight_Flower_Card','Moonlight Flower Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4132,'Mistress_Card','Mistress Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bNoGemStone; bonus bUseSPrate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4133,'Daydric_Card','Raydric Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4134,'Dracula_Card','Dracula Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPDrainRate,100,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4135,'Orc_Load_Card','Orc Lord Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bShortWeaponDamageReturn,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4136,'Khalitzburg_Card','Khalitzburg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Demon,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4137,'Drake_Card','Drake Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bNoSizeFix;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4138,'Anubis_Card','Anubis Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Angel,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4139,'Joker_Card','Joker Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "TF_STEAL",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4140,'Knight_Of_Abyss_Card','Abysmal Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_Boss,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4141,'Evil_Druid_Card','Evil Druid Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Undead; bonus bInt,1; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4142,'Doppelganger_Card','Doppelganger Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bAspdRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4143,'Orc_Hero_Card','Orc Hero Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bVit,3; bonus2 bResEff,Eff_Stun,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4144,'Osiris_Card','Osiris Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bRestartFullRecover;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4145,'Berzebub_Card','Berzebub Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bVariableCastrate,-30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4146,'Maya_Card','Maya Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bMagicDamageReturn,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4147,'Baphomet_Card','Baphomet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bHit,-10; bonus bSplashRange,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4148,'Pharaoh_Card','Pharaoh Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bUseSPrate,-30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4149,'Gargoyle_Card','Gargoyle Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12028,RC_Insect,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4150,'Goat_Card','Goat Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'if(getrefine()<6) { bonus bDef,2; bonus bMdef,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4151,'Gajomart_Card','Gajomart Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Plant,-20; bonus2 bExpAddRace,RC_Plant,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4152,'Galapago_Card','Galapago Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddItemGroupHealRate,IG_Juice,50; bonus3 bAddMonsterDropItem,531,RC_Insect,300; bonus3 bAddMonsterDropItem,532,RC_Insect,300; bonus3 bAddMonsterDropItem,534,RC_Insect,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4153,'Crab_Card','Crab Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus2 bAddDamageClass,1266,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4154,'Rice_Cake_Boy_Card','Dumpling Child Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddItemGroupHealRate,IG_Candy,50; bonus3 bAddMonsterDropItem,529,RC_DemiHuman,300; bonus3 bAddMonsterDropItem,530,RC_DemiHuman,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4155,'Goblin_Leader_Card','Goblin Leader Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,RC2_Goblin,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4156,'Steam_Goblin_Card','Goblin Steamrider Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Formless,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4157,'Goblin_Archer_Card','Goblin Archer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Undead,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4158,'Flying_Deleter_Card','Sky Deleter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,-100; bonus bHPGainValue,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4159,'Nine_Tail_Card','Nine Tail Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bAgi,2; if(getrefine()>8) bonus bFlee,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4160,'Antique_Firelock_Card','Firelock Soldier Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bStr,2; if(getrefine()>8) { bonus bMaxHPrate,10; bonus bMaxSPrate,10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4161,'Grand_Peco_Card','Grand Peco Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"PR_GLORIA",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4162,'Grizzly_Card','Grizzly Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Blind,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4163,'Gryphon_Card','Gryphon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bFlee,2; bonus bCritical,7; if(BaseClass==Job_Swordman) bonus3 bAutoSpell,"KN_BOWLINGBASH",5,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4164,'Gullinbursti_Card','Gullinbursti Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Fish,-20; bonus2 bExpAddRace,RC_Fish,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4165,'Gig_Card','Gig Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Insect,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db_re` VALUES (4166,'Nightmare_Terror_Card','Nightmare Terror Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Curse,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4167,'Neraid_Card','Nereid Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Brute,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db_re` VALUES (4168,'Dark_Lord_Card','Dark Lord Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"WZ_METEOR",5,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4169,'Dark_Illusion_Card','Dark Illusion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,-10; bonus bMaxSPrate,-10; bonus bVariableCastrate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4170,'Dark_Frame_Card','Dark Frame Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Stone,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4171,'Dark_Priest_Card','Dark Priest Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bSPVanishRate,50,10,BF_WEAPON|BF_MAGIC|BF_MISC; if(BaseJob==Job_Sage) bonus bSPDrainValue,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4172,'The_Paper_Card','The Paper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,20; bonus bSPDrainValue,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4173,'Demon_Pungus_Card','Demon Pungus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Sleep,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4174,'Deviling_Card','Deviling Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,50; bonus2 bSubEle,Ele_Water,-50; bonus2 bSubEle,Ele_Earth,-50; bonus2 bSubEle,Ele_Fire,-50; bonus2 bSubEle,Ele_Wind,-50; bonus2 bSubEle,Ele_Poison,-50; bonus2 bSubEle,Ele_Holy,-50; bonus2 bSubEle,Ele_Dark,-50; bonus2 bSubEle,Ele_Ghost,-50; bonus2 bSubEle,Ele_Undead,-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4175,'Poison_Toad_Card','Poisonous Toad Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"TF_POISON",1,20; bonus2 bAddSkillBlow,52,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4176,'Dullahan_Card','Dullahan Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Dragon,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4177,'Dryad_Card','Dryad Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,993,RC_Plant,100; bonus2 bSubEle,Ele_Earth,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4178,'Dragon_Tail_Card','Dragon Tail Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus bFlee,10; bonus2 bSkillAtk,"AC_DOUBLE",5; bonus2 bSkillAtk,"AC_SHOWER",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4179,'Dragon_Fly_Card','Dragon Fly Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4180,'Driller_Card','Driller Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Dragon,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db_re` VALUES (4181,'Disguise_Card','Disguise Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Silence,300+600*(readparam(bVit)>=77);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4182,'Diabolic_Card','Diabolic Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Demon,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db_re` VALUES (4183,'Vagabond_Wolf_Card','Vagabond Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4184,'Lava_Golem_Card','Lava Golem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,RC2_Golem,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4185,'Rideword_Card','Rideword Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,1; if(BaseClass==Job_Acolyte) { bonus bInt,1; bonus bMdef,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4186,'Raggler_Card','Raggler Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4187,'Raydric_Archer_Card','Raydric Archer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12030,RC_Demon,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4188,'Leib_Olmai_Card','Leib Olmai Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Fire,10; bonus3 bAddMonsterDropItem,990,RC_Brute,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4189,'Wraith_Dead_Card','Wraith Dead Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Curse,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4190,'Wraith_Card','Wraith Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12027,RC_Undead,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4191,'Loli_Ruri_Card','Loli Ruri Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AL_HEAL",3,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4192,'Rotar_Zairo_Card','Rotar Zairo Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Fish,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4193,'Lude_Card','Lude Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'if(BaseJob==Job_Novice||BaseJob==Job_SuperNovice) bonus3 bAutoSpellWhenHit,"SM_ENDURE",1,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4194,'Rybio_Card','Rybio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Stun,300+600*(readparam(bDex)>=77);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4195,'Leaf_Cat_Card','Leaf Cat Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Water,10; bonus3 bAddMonsterDropItem,991,RC_Fish,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4196,'Marin_Card','Marin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,909,2000; bonus2 bAddMonsterDropItem,7126,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4197,'Mastering_Card','Mastering Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4198,'Maya_Puple_Card','Maya Purple Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bIntravision;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4199,'Merman_Card','Merman Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,10; bonus bSPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4200,'Megalith_Card','Megalith Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'if(getrefine()<6) bonus bMdef,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4201,'Majoruros_Card','Majoruros Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Stun,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4202,'Civil_Servant_Card','Mao Guai Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Ghost,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4203,'Mutant_Dragon_Card','Mutant Dragonoid Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,15; bonus3 bAutoSpell,"MG_FIREBALL",3+7*(getskilllv("MG_FIREBALL")==10),50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4204,'Mini_Demon_Card','Mini Demon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Brute,-20; bonus2 bExpAddRace,RC_Brute,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4205,'Mimic_Card','Mimic Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,603,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4206,'Mystcase_Card','Myst Case Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,644,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4207,'Mysteltainn_Card','Mysteltainn Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubSize,Size_Small,25; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4208,'Miyabi_Ningyo_Card','Miyabi Doll Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxSPrate,10; bonus2 bSkillAtk,"MG_FROSTDIVER",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4209,'Violy_Card','Violy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"BA_FROSTJOKER",1+4*(getskilllv("BA_FROSTJOKER")==5),20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4210,'Wander_Man_Card','Wanderer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(!isequipped(4172,4257,4230,4272)) bonus3 bAutoSpell,"RG_INTIMIDATE",1,20; if(BaseClass==Job_Thief) bonus bFlee,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4211,'Vocal_Card','Vocal Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4212,'Bon_Gun_Card','Bongun Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"SM_BASH",1,20; bonus2 bAddSkillBlow,"SM_BASH",5; bonus2 bAddDefMonster,1026,-100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4213,'Brilight_Card','Brilight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Silence,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4214,'Bloody_Murderer_Card','Bloody Murderer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Insect,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4215,'Blazzer_Card','Blazer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItemGroup,IG_Food,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4216,'Sasquatch_Card','Sasquatch Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Freeze,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4217,'Live_Peach_Tree_Card','Enchanted Peach Tree Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"AL_HEAL",1+9*(getskilllv("AL_HEAL")==10),20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4218,'Succubus_Card','Succubus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,-3; bonus bHPrecovRate,-20; bonus bMaxHP,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4219,'Sageworm_Card','Sage Worm Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,715,30; bonus2 bAddMonsterDropItem,716,30; bonus2 bAddMonsterDropItem,717,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4220,'Solider_Card','Solider Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDef,2; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4221,'Skeleton_General_Card','Skeleton General Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Insect,-20; bonus2 bExpAddRace,RC_Insect,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4222,'Skel_Prisoner_Card','Skeleton Prisoner Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Sleep,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4223,'Stalactic_Golem_Card','Stalactic Golem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus2 bResEff,Eff_Stun,2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4224,'Stem_Worm_Card','Stem Worm Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12032,RC_Brute,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4225,'Stone_Shooter_Card','Stone Shooter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; bonus bHit,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4226,'Sting_Card','Sting Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,2; if(getrefine()>8) bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4227,'Spring_Rabbit_Card','Spring Rabbit Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddItemGroupHealRate,IG_Meat,50; bonus3 bAddMonsterDropItem,517,RC_Brute,200; bonus3 bAddMonsterDropItem,528,RC_Brute,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4228,'Sleeper_Card','Sleeper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12031,RC_Fish,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4229,'C_Tower_Manager_Card','Tower Keeper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bVariableCastrate,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4230,'Shinobi_Card','Shinobi Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus3 bAutoSpellWhenHit,"AS_CLOAKING",5,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4231,'Increase_Soil_Card','Mi Gao Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace2,RC2_Guardian,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4232,'Wild_Ginseng_Card','Hermit Plant Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddItemGroupHealRate,IG_Herb,50; bonus3 bAddMonsterDropItem,507,RC_Plant,300; bonus3 bAddMonsterDropItem,508,RC_Plant,200; bonus3 bAddMonsterDropItem,509,RC_Plant,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4233,'Baby_Leopard_Card','Baby Leopard Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bLuk,3; if(BaseClass==Job_Merchant) bonus bUnbreakableArmor;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4234,'Anolian_Card','Anolian Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AC_CONCENTRATION",1+9*(getskilllv("AC_CONCENTRATION")==10),30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4235,'Cookie_XMAS_Card','Christmas Cookie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Angel,-20; bonus2 bExpAddRace,RC_Angel,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4236,'Amon_Ra_Card','Amon Ra Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAllStats,1; bonus3 bAutoSpellWhenHit,"PR_KYRIE",10,(30+70*(readparam(bInt)>=99));',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4237,'Owl_Duke_Card','Owl Duke Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"PR_IMPOSITIO",3,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4238,'Owl_Baron_Card','Owl Baron Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"PR_LEXAETERNA",1,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4239,'Iron_Fist_Card','Iron Fist Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Formless,-20; bonus2 bExpAddRace,RC_Formless,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4240,'Arclouse_Card','Arclouze Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'if(getrefine()<6) { bonus bDef,2; bonus bMdef,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4241,'Archangeling_Card','Arc Angeling Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMaxHP,300; if(readparam(bLuk)>=77) { bonus bHPrecovRate,100; bonus bSPrecovRate,100; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4242,'Apocalips_Card','Apocalipse Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,2; if(getrefine()>8) bonus bMaxHP,800;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4243,'Antonio_Card','Antonio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AL_TELEPORT",1,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4244,'Alarm_Card','Alarm Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"MG_SIGHT",1,200; bonus bMaxHP,300; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4245,'Am_Mut_Card','Am Mut Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_DemiHuman,-20; bonus2 bSubRace,RC_Player,-20; bonus2 bExpAddRace,RC_DemiHuman,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4246,'Assulter_Card','Assaulter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_DemiHuman,7; bonus2 bCriticalAddRace,RC_Player,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4247,'Aster_Card','Aster Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus2 bAddDamageClass,1074,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4248,'Ancient_Mummy_Card','Ancient Mummy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AL_CRUCIS",5,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4249,'Ancient_Worm_Card','Ancient Worm Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Demon,-20; bonus2 bExpAddRace,RC_Demon,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4250,'Executioner_Card','Executioner Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubSize,Size_Large,25; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4251,'Elder_Card','Elder Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,RC2_Guardian,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4252,'Alligator_Card','Alligator Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bLongAtkDef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4253,'Alice_Card','Alice Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubClass,Class_Boss,40; bonus2 bSubClass,Class_Normal,-40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4254,'Tirfing_Card','Ogretooth Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubSize,Size_Medium,25; bonus bDef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4255,'Orc_Lady_Card','Orc Lady Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,RC2_Orc,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4256,'Orc_Archer_Card','Orc Archer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12034,RC_DemiHuman,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4257,'Wild_Rose_Card','Wild Rose Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAgi,1; if(BaseClass==Job_Thief) bonus bFlee2,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4258,'Wicked_Nymph_Card','Evil Nymph Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4259,'Wooden_Golem_Card','Wooden Golem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus bHPrecovRate,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4260,'Wootan_Shooter_Card','Wootan Shooter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus2 bResEff,Eff_Confusion,2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4261,'Wootan_Fighter_Card','Wootan Fighter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus2 bResEff,Eff_Bleeding,2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4262,'Evil_Cloud_Hermit_Card','Cloud Hermit Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12029,RC_Plant,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4263,'Incant_Samurai_Card','Samurai Spector Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bIgnoreDefClass,Class_Normal; bonus bHPrecovRate,-100; bonus2 bHPLossRate,666,10000;',NULL,'if((Hp<=999) && !getmapflag(strcharinfo(3),mf_pvp) && !getmapflag(strcharinfo(3),mf_pvp_noparty) && !getmapflag(strcharinfo(3),mf_pvp_noguild)) { heal(1-Hp),0; } else { heal -999,0; }');
REPLACE INTO `item_db_re` VALUES (4264,'Wind_Ghost_Card','Wind Ghost Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"WZ_JUPITEL",3+7*(getskilllv("WZ_JUPITEL")==10),20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4265,'Li_Me_Mang_Ryang_Card','Jing Guai Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12033,RC_Angel,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4266,'Eclipse_Card','Eclipse Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4267,'Explosion_Card','Explosion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Dragon,-20; bonus2 bExpAddRace,RC_Dragon,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4268,'Injustice_Card','Injustice Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"AS_SONICBLOW",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4269,'Incubus_Card','Incubus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,-3; bonus bSPrecovRate,-20; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4270,'Giant_Spider_Card','Giant Spider Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Poison,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4271,'Giant_Honet_Card','Giant Hornet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Wind,10; bonus3 bAddMonsterDropItem,992,RC_Insect,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4272,'Dancing_Dragon_Card','Zhu Po Long Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus bCritical,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4273,'Shellfish_Card','Shell Fish Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus2 bAddDamageClass,1073,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4274,'Zombie_Master_Card','Zombie Master Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Undead,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db_re` VALUES (4275,'Zombie_Prisoner_Card','Zombie Prisoner Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Undead,-20; bonus2 bExpAddRace,RC_Undead,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4276,'Lord_Of_Death_Card','Lord of The Dead Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAddEff,Eff_Stun,500,ATF_SHORT; bonus3 bAddEff,Eff_Curse,500,ATF_SHORT; bonus3 bAddEff,Eff_Silence,500,ATF_SHORT; bonus3 bAddEff,Eff_Poison,500,ATF_SHORT; bonus3 bAddEff,Eff_Bleeding,500,ATF_SHORT; bonus2 bComaClass,Class_Normal,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4277,'Zherlthsh_Card','Zealotus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bLuk,2; bonus2 bSkillAtk,"BA_MUSICALSTRIKE",10; bonus2 bSkillAtk,"DC_THROWARROW",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4278,'Gibbet_Card','Gibbet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'if(getrefine()<6) bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4279,'Deleter_Card','Earth Deleter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bSPrecovRate,-100; bonus bSPGainValue,10;',NULL,'heal 0,-100;');
REPLACE INTO `item_db_re` VALUES (4280,'Geographer_Card','Geographer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AL_BLESSING",2+8*(getskilllv("AL_BLESSING")==10),30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4281,'Zipper_Bear_Card','Zipper Bear Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,30; bonus bSPDrainValue,-1; if(BaseClass==Job_Merchant) bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4282,'Tengu_Card','Tengu Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItemGroup,IG_Recovery,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4283,'Greatest_General_Card','Greatest General Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"MO_CALLSPIRITS",5,2+18*(BaseClass==Job_Acolyte);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4284,'Chepet_Card','Chepet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus4 bAutoSpell,"AL_HEAL",5,50,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4285,'Choco_Card','Choco Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee2,5; bonus bFlee,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4286,'Karakasa_Card','Karakasa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Confusion,300+600*(readparam(bStr)>=77);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4287,'Kapha_Card','Kapha Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(getrefine()<6) bonus bMdef,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4288,'Carat_Card','Carat Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,2; if(getrefine()>8) bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4289,'Caterpillar_Card','Caterpillar Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Plant,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db_re` VALUES (4290,'Cat_O_Nine_Tail_Card','Cat O\' Nine Tails Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMdef,3; bonus bMagicDamageReturn,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4291,'Kobold_Leader_Card','Kobold Leader Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,RC2_Kobold,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4292,'Kobold_Archer_Card','Kobold Archer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Plant,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4293,'Cookie_Card','Cookie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bLuk,2; bonus2 bSkillAtk,"AL_HOLYLIGHT",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4294,'Quve_Card','Quve Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'if(BaseJob==Job_Novice||BaseJob==Job_SuperNovice) bonus3 bAutoSpellWhenHit,"AL_INCAGI",1,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4295,'Kraben_Card','Kraben Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Blind,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4296,'Cramp_Card','Cramp Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bGetZenyNum,500,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4297,'Cruiser_Card','Cruiser Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Brute,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4298,'Cremy_Fear_Card','Creamy Fear Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Confusion,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4299,'Clock_Card','Clock Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"CR_AUTOGUARD",3+7*(getskilllv("CR_AUTOGUARD")==10),30;',NULL,'sc_end SC_AUTOGUARD;');
REPLACE INTO `item_db_re` VALUES (4300,'Chimera_Card','Chimera Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Poison,300+600*(BaseJob==Job_Assassin);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4301,'Killer_Mantis_Card','Killer Mantis Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Bleeding,600;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4302,'Tao_Gunka_Card','Tao Gunka Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,100; bonus bDefRate,-50; bonus bMdefRate,-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4303,'Whisper_Boss_Card','Giant Whisper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10; if(readparam(bStr)>=80) bonus bBaseAtk,20; if(readparam(bVit)>=80) bonus bMaxHPrate,3; if(readparam(bLuk)>=80) bonus bCritical,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4304,'Tamruan_Card','Tamruan Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,2; bonus2 bSkillAtk,"CR_SHIELDCHARGE",10; bonus2 bSkillAtk,"CR_SHIELDBOOMERANG",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4305,'Turtle_General_Card','Turtle General Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,20; bonus3 bAutoSpell,"SM_MAGNUM",10,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4306,'Toad_Card','Toad Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee2,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4307,'Kind_Of_Beetle_Card','Beetle King Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Fish,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db_re` VALUES (4308,'Tri_Joint_Card','Tri Joint Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Formless,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db_re` VALUES (4309,'Parasite_Card','Parasite Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus2 bSubRace,RC_Formless,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4310,'Panzer_Goblin_Card','Panzer Goblin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus2 bCriticalAddRace,RC_Demon,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4311,'Permeter_Card','Permeter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Dark,15; bonus2 bSubEle,Ele_Undead,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4312,'Fur_Seal_Card','Seal Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bFlee,3; bonus bHit,10; if(BaseClass==Job_Acolyte) { bonus2 bCriticalAddRace,RC_Undead,9; bonus2 bCriticalAddRace,RC_Demon,9; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4313,'Punk_Card','Punk Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus4 bAutoSpellWhenHit,"WZ_QUAGMIRE",1+4*(getskilllv("WZ_QUAGMIRE")==5),50,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4314,'Penomena_Card','Penomena Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Formless,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4315,'Pest_Card','Pest Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Stone,300+600*(readparam(bInt)>=77);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4316,'Fake_Angel_Card','False Angel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_Angel,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db_re` VALUES (4317,'Mobster_Card','Mobster Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,15; if(BaseClass==Job_Thief) bonus bCritical,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4318,'Knight_Windstorm_Card','Stormy Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"WZ_STORMGUST",1,20; bonus2 bAddEff,Eff_Freeze,2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4319,'Freezer_Card','Freezer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHP,300; if(getrefine()>=9) bonus2 bSkillAtk,"SM_BASH",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4320,'Bloody_Knight_Card','Bloody Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"WZ_METEOR",1,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4321,'Hylozoist_Card','Hylozoist Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bClassChange,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4322,'High_Orc_Card','High Orc Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,1; bonus bShortWeaponDamageReturn,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4323,'Garm_Baby_Card','Hatii Babe Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"MG_FROSTDIVER",3,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4324,'Garm_Card','Hatii Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Freeze,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4325,'Harpy_Card','Harpy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,15; bonus2 bSkillAtk,"MG_NAPALMBEAT",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4326,'See_Otter_Card','Sea-Otter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddItemGroupHealRate,IG_Fish,50; bonus3 bAddMonsterDropItem,551,RC_Fish,300; bonus3 bAddMonsterDropItem,544,RC_Fish,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4327,'Blood_Butterfly_Card','Bloody Butterfly Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bVariableCastrate,30; bonus bNoCastCancel; bonus2 bSkillAtk,"MG_FIREWALL",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4328,'Hyegun_Card','Yao Jun Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,15; bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4329,'Phendark_Card','Phendark Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPGainRace,RC_DemiHuman,5; bonus2 bSPGainRace,RC_Player,5;',NULL,'heal 0,-5;');
REPLACE INTO `item_db_re` VALUES (4330,'Dark_Snake_Lord_Card','Evil Snake Lord Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,3; bonus2 bResEff,Eff_Blind,10000; bonus2 bResEff,Eff_Curse,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4331,'Heater_Card','Heater Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bCritical,3; if(BaseClass==Job_Swordman) bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4332,'Waste_Stove_Card','Waste Stove Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4333,'Venomous_Card','Venomous Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAddEffWhenHit,Eff_Poison,3000,ATF_TARGET|ATF_SELF;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4334,'Noxious_Card','Noxious Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bLongAtkDef,10; bonus2 bSubEle,Ele_Neutral,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4335,'Pitman_Card','Pitman Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"WZ_EARTHSPIKE",5; bonus2 bSkillAtk,"WZ_HEAVENDRIVE",5;',NULL,'heal 0,-50;');
REPLACE INTO `item_db_re` VALUES (4336,'Ungoliant_Card','Ungoliant Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,10; bonus2 bResEff,Eff_Bleeding,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4337,'Porcellio_Card','Porcellio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,25; bonus bDef,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4338,'Obsidian_Card','Obsidian Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,readparam(bDex)/18;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4339,'Mineral_Card','Mineral Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,-25; bonus bDef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4340,'Teddy_Bear_Card','Teddy Bear Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Undead,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4341,'Metaling_Card','Metaling Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"RG_STRIPWEAPON",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4342,'Rsx_0806_Card','RSX-0806 Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,3; bonus bUnbreakableArmor; bonus bNoKnockback;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4343,'Mole_Card','Holden Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4344,'Anopheles_Card','Anopheles Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12058,RC_Insect,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4345,'Hill_Wind_Card','Hill Wind Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"MG_THUNDERSTORM",5; bonus2 bSkillAtk,"WZ_JUPITEL",5; bonus2 bSkillAtk,"WZ_VERMILION",5;',NULL,'heal 0,-50;');
REPLACE INTO `item_db_re` VALUES (4346,'Ygnizem_Card','Egnigem Cenia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bStr,readparam(bInt)/18;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4347,'Armaia_Card','Armeyer Dinze Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12053,RC_Fish,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4348,'Whikebain_Card','Wickebine Tres Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"RG_STRIPARMOR",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4349,'Erend_Card','Errende Ebecee Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus4 bAutoSpellWhenHit,"AL_PNEUMA",1,50,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4350,'Rawrel_Card','Laurell Weinder Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"WZ_FROSTNOVA",3; bonus2 bSkillAtk,"WZ_STORMGUST",3;',NULL,'heal 0,-50;');
REPLACE INTO `item_db_re` VALUES (4351,'Kavac_Card','Kavach Icarus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(getrefine()<=4) { bonus bFlee,20; bonus bFlee2,1; } else { bonus bFlee,10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4352,'B_Ygnizem_Card','General Egnigem Cenia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,10; bonus bMaxSPrate,10; bonus2 bHPRegenRate,50,10000; bonus2 bSPRegenRate,10,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4353,'Removal_Card','Remover Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHP,800-40*getrefine(); bonus bHPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4354,'Gemini_Card','Gemini-S58 Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'if(readparam(bAgi)>=90) { bonus2 bResEff,Eff_Silence,3000; bonus2 bResEff,Eff_Stun,3000; } if(readparam(bVit)>=80) { bonus2 bResEff,Eff_Stone,5000; bonus2 bResEff,Eff_Sleep,5000; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4355,'Gremlin_Card','Gremlin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12043,RC_Brute,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4356,'Beholder_Card','Beholder Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "SA_CASTCANCEL",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4357,'B_Seyren_Card','Lord Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'skill "LK_BERSERK",1; bonus bMaxHPrate,-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4358,'Seyren_Card','Seyren Windsor Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bStr,getrefine()-6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4359,'B_Eremes_Card','Assassin Cross Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'skill "AS_CLOAKING",3;',NULL,'sc_end SC_CLOAKING;');
REPLACE INTO `item_db_re` VALUES (4360,'Eremes_Card','Eremes Guile Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bCriticalAddRace,RC_DemiHuman,10; bonus2 bCriticalAddRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4361,'B_Harword_Card','MasterSmith Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBreakWeaponRate,1000; bonus bBreakArmorRate,700;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4362,'Harword_Card','Howard Alt-Eisen Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bAspdRate,-5; bonus bHit,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4363,'B_Magaleta_Card','High Priest Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus5 bAutoSpellWhenHit,"HP_ASSUMPTIO",5,50,BF_WEAPON|BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4364,'Magaleta_Card','Margaretha Sorin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus5 bAutoSpellWhenHit,"PR_LEXDIVINA",5,150,BF_MAGIC,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4365,'B_Katrinn_Card','High Wizard Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bIgnoreMdefClassRate,Class_Normal,100; bonus bVariableCastrate,100; bonus bSPrecovRate,-100;',NULL,'heal 0,-2000;');
REPLACE INTO `item_db_re` VALUES (4366,'Katrinn_Card','Kathryne Keyron Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus bVariableCastrate,.@r*-1; if(.@r>=9) { bonus bMatkRate,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4367,'B_Shecil_Card','Sniper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bHPDrainRate,100,20; bonus bHPrecovRate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4368,'Shecil_Card','Cecil Damon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bAspdRate,5; bonus bHit,-30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4369,'Venatu_Card','Venatu Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bLuk,readparam(bAgi)/18;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4370,'Dimik_Card','Dimik Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,getrefine()-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4371,'Archdam_Card','Archdam Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; bonus bVariableCastrate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4372,'Bacsojin_Card','White Lady Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bHealPower,30; bonus bUseSPrate,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4373,'Chung_E_Card','Green Maiden Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus bLuk,.@r-5; bonus bCritical,.@r;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4374,'Apocalips_H_Card','Vesper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDex,2; bonus2 bIgnoreMdefClassRate,Class_Boss,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4375,'Orc_Baby_Card','Orc Baby Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'.@i = (getrefine()>=9?15:10); bonus2 bSubEle,Ele_Neutral,.@i; bonus bFlee,.@i;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4376,'Lady_Tanee_Card','Lady Tanee Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,-40; bonus bMaxSPrate,50; bonus2 bAddMonsterDropItem,513,200; bonus2 bAddItemHealRate,513,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4377,'Green_Iguana_Card','Grove Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12063,RC_Formless,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4378,'Acidus_Card','Gold Acidus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'if(getrefine()<=4) { bonus bMaxHPrate,8; bonus bMaxSPrate,8; bonus bHPrecovRate,5; bonus bSPrecovRate,5; } else { bonus bMaxHPrate,4; bonus bMaxSPrate,4; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4379,'Acidus__Card','Blue Acidus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'if(getrefine()<=4) { bonus bSPrecovRate,5; bonus bMaxSP,80; } else { bonus bMaxSP,40; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4380,'Ferus_Card','Red Ferus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"WZ_FIREPILLAR",5; bonus2 bSkillAtk,"WZ_METEOR",5;',NULL,'heal 0,-50;');
REPLACE INTO `item_db_re` VALUES (4381,'Ferus__Card','Green Ferus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bVit,1; bonus bMaxHPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4382,'Novus__Card','Yellow Novus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHP,500; bonus bHPrecovRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4383,'Novus_Card','Red Novus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAddEffWhenHit,Eff_Confusion,3000,ATF_TARGET|ATF_SELF;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4384,'Hydro_Card','Hydrolancer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"SA_SPELLBREAKER",1,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4385,'Dragon_Egg_Card','Dragon Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12048,RC_Dragon,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4386,'Detale_Card','Detardeurus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMdef,-20; bonus2 bResEff,Eff_Freeze,10000; bonus5 bAutoSpellWhenHit,"SA_LANDPROTECTOR",1,70,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4387,'Ancient_Mimic_Card','Ancient Mimic Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bAgi,readparam(bLuk)/18;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4388,'Deathword_Card','Death Word Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"MG_NAPALMBEAT",5; bonus2 bSkillAtk,"MG_SOULSTRIKE",5; bonus2 bSkillAtk,"HW_NAPALMVULCAN",5;',NULL,'heal 0,-50;');
REPLACE INTO `item_db_re` VALUES (4389,'Plasma_Card','Plasma Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,12118,50; bonus2 bAddMonsterDropItem,12119,50; bonus2 bAddMonsterDropItem,12120,50; bonus2 bAddMonsterDropItem,12121,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4390,'Breeze_Card','Breeze Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus2 bAddEff,Eff_Bleeding,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4391,'Retribution_Card','Baroness of Retribution Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAddMonsterDropItem,12068,RC_Angel,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4392,'Observation_Card','Dame of Sentinel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDex,readparam(bVit)/18;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4393,'Shelter_Card','Mistress of Shelter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bInt,readparam(bStr)/18;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4394,'Solace_Card','Lady Solace Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(BaseJob==Job_Priest) bonus3 bAutoSpell,"CR_GRANDCROSS",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4395,'Tha_Maero_Card','Maero of Thanatos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus3 bAutoSpell,"AL_DECAGI",3,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4396,'Tha_Odium_Card','Odium of Thanatos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAgi,getrefine()-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4397,'Tha_Despero_Card','Despero of Thanatos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bInt,getrefine()-6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4398,'Tha_Dolor_Card','Dolor of Thanatos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Angel,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4399,'Thanatos_Card','Memory of Thanatos Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bDefRatioAtkClass,Class_All; bonus bSPDrainValue,-1; bonus bDef,-30; bonus bFlee,-30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4400,'Aliza_Card','Aliza Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"DC_WINKCHARM",1,50+50*(BaseJob==Job_Dancer);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4401,'Alicel_Card','Alicel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bFlee,10; bonus bDef,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4402,'Aliot_Card','Aliot Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief) { bonus bStr,2; bonus bMaxHPrate,5; } if(BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte) { bonus bInt,2; bonus bMaxSPrate,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4403,'Kiel_Card','Kiel-D-01 Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDelayRate,-30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4404,'Skogul_Card','Skogul Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus3 bAddEffWhenHit,Eff_Bleeding,3000,ATF_TARGET|ATF_SELF;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4405,'Frus_Card','Frus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMagicDamageReturn,getrefine()*2; if(BaseClass==Job_Mage) bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4406,'Skeggiold_Card','Skeggiold Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Demon,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4407,'Randgris_Card','Randgris Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bUnbreakableWeapon; bonus2 bAddClass,Class_All,10; bonus3 bAutoSpell,"SA_DISPELL",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4408,'Gloom_Under_Night_Card','Gloom Under Night Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Holy,40; bonus2 bAddEle,Ele_Dark,40; bonus2 bAddRace,RC_Angel,40; bonus2 bAddRace,RC_Demon,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4409,'Agav_Card','Agav Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMatkRate,5; bonus bDef,-10; if(BaseClass==Job_Mage) bonus bMaxSP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4410,'Echio_Card','Echio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,15; if(BaseClass==Job_Swordman) bonus bMaxHP,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4411,'Vanberk_Card','Vanberk Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bStr,2; autobonus "{ bonus bCritical,100; }",5,5000,0,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4412,'Isilla_Card','Isilla Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,2; autobonus "{ bonus bVariableCastrate,-50; bonus bFlee,30; }",50,5000,BF_MAGIC,"{ specialeffect2 EF_SUFFRAGIUM; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4413,'Hodremlin_Card','Hodremlin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubSize,Size_All,15; autobonus2 "{ bonus bFlee2,30; }",3,10000,BF_WEAPON|BF_MAGIC,"{ specialeffect2 EF_WIND; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4414,'Seeker_Card','Seeker Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'skill "MG_STONECURSE",1; bonus2 bResEff,Eff_Stone,3000; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4415,'Snowier_Card','Snowier Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddMonsterDropItem,536,500; bonus2 bAddItemHealRate,536,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4416,'Siroma_Card','Siroma Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"MG_COLDBOLT",25; bonus2 bVariableCastrate,"MG_COLDBOLT",-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4417,'Ice_Titan_Card','Ice Titan Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bVit,2; autobonus2 "{ bonus bDef,10; }",3,10000,BF_WEAPON|BF_MAGIC,"{ specialeffect2 EF_FREEZED; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4418,'Gazeti_Card','Gazeti Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"MG_COLDBOLT",2,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4419,'Ktullanux_Card','Ktullanux Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Fire,50; bonus5 bAutoSpellWhenHit,"WZ_FROSTNOVA",10,20,BF_WEAPON|BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4420,'Muscipular_Card','Muscipular Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"AL_HEAL",1,100; bonus3 bAutoSpellWhenHit,"AL_INCAGI",1,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4421,'Drosera_Card','Drosera Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCriticalLong,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4422,'Roween_Card','Roween Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,5; bonus bFlee2,3; bonus2 bAddEle,Ele_Water,10; bonus2 bCriticalAddRace,RC_Fish,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4423,'Galion_Card','Galion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bHit,5; bonus2 bAddEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4424,'Stapo_Card','Stapo Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'skill "TF_PICKSTONE",1; skill "TF_THROWSTONE",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4425,'Atroce_Card','Atroce Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,25; autobonus "{ bonus bAspdRate,100; }",5,10000,0,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4426,'Byorgue_Card','Byorgue Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'if(BaseJob==Job_Rogue) { bonus bMatkRate,10; bonus2 bAddClass,Class_All,10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4427,'Sword_Guardian_Card','Sword Guardian Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'.@i = getiteminfo(getequipid(EQI_HAND_R),11); if(.@i==W_1HSWORD||.@i==W_2HSWORD) { bonus bHit,5; bonus bCritical,5; bonus2 bSkillAtk,62,25; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4428,'Bow_Guardian_Card','Bow Guardian Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getiteminfo(getequipid(EQI_HAND_R),11)==W_BOW) { bonus bHit,5; bonus bCritical,5; bonus2 bSkillAtk,"AC_SHOWER",50; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4429,'Salamander_Card','Salamander Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"WZ_FIREPILLAR",40; bonus2 bSkillAtk,"WZ_METEOR",40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4430,'Ifrit_Card','Ifrit Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bBaseAtk,(JobLevel/10); bonus bCritical,(JobLevel/10); bonus bHit,(JobLevel/10); bonus3 bAutoSpellWhenHit,"NPC_EARTHQUAKE",10,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4431,'Kasa_Card','Kasa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"MG_FIREBALL",5,20; bonus3 bAutoSpell,"MG_FIREBOLT",5,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4432,'Magmaring_Card','Magmaring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus2 bAddEle,Ele_Earth,10; bonus2 bCriticalAddRace,RC_Brute,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4433,'Imp_Card','Imp Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"MG_FIREBOLT",25; bonus2 bVariableCastrate,"MG_FIREBOLT",-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4434,'Knocker_Card','Knocker Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Formless,5; bonus3 bAddMonsterDropItem,756,RC_Formless,10; bonus3 bAddMonsterDropItem,757,RC_Formless,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4435,'Zombie_Slaughter_Card','Zombie Slaughter Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_DemiHuman,1; bonus2 bAddRace,RC_Player,1; bonus2 bMagicAddRace,RC_DemiHuman,1; bonus2 bMagicAddRace,RC_Player,1; bonus bHPGainValue,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4436,'Ragged_Zombie_Card','Ragged Zombie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bCriticalAddRace,RC_DemiHuman,5; bonus2 bCriticalAddRace,RC_Player,5; bonus2 bAddRace,RC_DemiHuman,1; bonus2 bAddRace,RC_Player,1; bonus2 bMagicAddRace,RC_DemiHuman,1; bonus2 bMagicAddRace,RC_Player,1; bonus2 bAddEff2,Eff_Bleeding,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4437,'Hell_Poodle_Card','Hell Poodle Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bHit,1; bonus2 bAddItemHealRate,517,100; bonus3 bAddEff,Eff_Bleeding,50,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4438,'Banshee_Card','Banshee Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'if(BaseClass==Job_Mage){ bonus bMaxSP,100; bonus bMaxHP,-100; bonus2 bSkillAtk,"MG_NAPALMBEAT",20; bonus2 bSkillAtk,"MG_SOULSTRIKE",20; bonus2 bSkillAtk,"HW_NAPALMVULCAN",20; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4439,'Flame_Skull_Card','Flame Skull Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Blind,3000; bonus2 bResEff,Eff_Stun,3000; bonus2 bResEff,Eff_Curse,3000; bonus2 bResEff,Eff_Stone,3000; bonus2 bAddEffWhenHit,Eff_Blind,500; bonus2 bAddEffWhenHit,Eff_Stun,500; bonus2 bAddEffWhenHit,Eff_Curse,500; bonus2 bAddEffWhenHit,Eff_Stone,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4440,'Necromancer_Card','Necromancer Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'.@i = getiteminfo(getequipid(EQI_HAND_R),11); if(.@i==W_STAFF || .@i==W_2HSTAFF) { bonus bInt,1; bonus2 bIgnoreMdefClassRate,Class_Normal,2; bonus2 bIgnoreMdefClassRate,Class_Boss,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4441,'Fallen_Bishop_Card','Fallen Bishop Hibram Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMatkRate,10; bonus bMaxSPrate,-50; bonus2 bMagicAddRace,RC_Angel,50; bonus2 bMagicAddRace,RC_DemiHuman,50; bonus2 bMagicAddRace,RC_Player,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4442,'Tatacho_Card','Tatacho Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubDefEle,Ele_Neutral,20; bonus2 bAddEle,Ele_Neutral,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4443,'Aqua_Elemental_Card','Aqua Elemental Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubDefEle,Ele_Water,20; bonus2 bAddEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4444,'Draco_Card','Draco Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubDefEle,Ele_Earth,20; bonus2 bAddEle,Ele_Earth,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4445,'Luciola_Vespa_Card','Luciola Vespa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubDefEle,Ele_Wind,20; bonus2 bAddEle,Ele_Wind,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4446,'Enhanced_Skeleton_Card','Enhanced Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,15; bonus2 bAddEff,Eff_Stun,(BaseLevel>=100?300:200);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4447,'Centipede_Card','Centipede Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubDefEle,Ele_Poison,20; bonus2 bAddEle,Ele_Poison,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4448,'Cornus_Card','Cornus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubDefEle,Ele_Holy,20; bonus2 bAddEle,Ele_Holy,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4449,'Dark_Shadow_Card','Dark Shadow Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubDefEle,Ele_Dark,20; bonus2 bAddEle,Ele_Dark,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4450,'Banshee_Master_Card','Banshee Master Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bMatk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4451,'Ant_Buyanne_Card','Entweihen Crothen Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMatk,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4452,'Centipede_Larva_Card','Centipede Larva Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bMatk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4453,'Hilsrion_Card','Hillsrion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4454,'Light_Up_Card1','Light Up Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4455,'Light_Up_Card2','Light Up Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4456,'Nidhogg_Shadow_Card','Nidhoggur Shadow Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bInt,5; if (Class == Job_High_Wizard || Class == Job_Baby_Warlock || Class == Job_Warlock || Class == Job_Warlock_T) bonus bFixedCastrate,-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4457,'Nahtzigger_Card','Naght Sieger Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bMagicAtkEle,Ele_Ghost,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4458,'Duneirre_Card','Duneyrr Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; autobonus "{ bonus bAspdRate,5; }",10,10000,0,"{ specialeffect2 EF_HASTEUP; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4459,'Lata_Card','Rata Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMatk,10; autobonus "{ bonus bFixedCastrate,-50; }",5,4000,BF_MAGIC,"{ specialeffect2 EF_SUFFRAGIUM; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4460,'Ringco_Card','Rhyncho Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bHealPower,4; bonus2 bSkillUseSP,"AL_HEAL",-15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4461,'Pillar_Card','Phylla Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDex,1; bonus bAgi,1; autobonus "{ bonus bCritical,20; }",15,4000,0,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4462,'Hardrock_Mommos_Card','Hardrock Mammoth Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus bDef,5; if(.@r>=12) { bonus bDef,20; bonus bMaxHPrate,10; } if(.@r>=14) { bonus bMaxHPrate,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4463,'Tendrilion_Card','Tendrilrion Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritical,5; .@r = getrefine(); if(.@r>=12) { bonus bBaseAtk,35; } if(.@r>=14) { bonus bCritical,10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4464,'Aunoe_Card','Aunoe Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4465,'Panat_Card','Fanat Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; if(getiteminfo(getequipid(EQI_HAND_R),11)==W_2HSWORD) { .@r = getrefine(); if(.@r>=10) { bonus bAspd,1; } if(.@r>=14) { bonus bAspd,1; } }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4466,'Beholder_Master_Card','Beholder Master Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,3; if(getiteminfo(getequipid(EQI_HAND_R),11)==W_BOW) { .@r = getrefine(); if(.@r>=10) { bonus bAspd,1; } if(.@r>=14) { bonus bAspd,1; } }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4467,'Heavy_Metaling_Card','Heavy Metaling Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bStr,2; if(BaseClass==Job_Merchant){ bonus2 bSkillAtk,"MC_CARTREVOLUTION",50; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4468,'Pinguicula_Dark_Card','Dark Pinguicula Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; bonus2 bAddMonsterDropItem,7932,10; bonus2 bAddMonsterDropItem,7933,10; bonus2 bAddMonsterDropItem,7934,10; bonus2 bAddMonsterDropItem,7935,10; bonus2 bAddMonsterDropItem,7936,10; bonus2 bAddMonsterDropItem,7937,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4469,'Naga_Card','Naga Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Fish,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4470,'Nepenthes_Card','Nepenthes Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Plant,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4471,'Egg_Of_Draco_Card','Draco Egg Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Dragon,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4472,'Bradium_Goram_Card','Bradium Golem Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Brute,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4473,'Ancient_Tree_Card','Ancient Tree Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Undead,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4474,'Jakudam_Card','Zakudam Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_DemiHuman,10; bonus2 bMagicAddRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4475,'Cobalt_Mineral_Card','Cobalt Mineral Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Formless,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4476,'Pinguicula_Card','Pinguicula Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Insect,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4477,'Hell_Apocalips_Card','Hell Apocalypse Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Demon,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4478,'Light_Up_Card3','Light Up Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4479,'Light_Up_Card4','Light Up Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4480,'Sealed_Kiel_Card','Sealed Kiel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDelayRate,((getrefine()>14)?-20:-15);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4481,'Sealed_Ktullanux_Card','Sealed Ktullanux Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Fire,((getrefine()>14)?35:25); bonus5 bAutoSpellWhenHit,"WZ_FROSTNOVA",10,10,BF_WEAPON|BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4482,'Sealed_B_Ygnizem_Card','Sealed General Egnigem Cenia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'.@rate = ((getrefine()>14)?7:5); bonus bMaxHPrate,.@rate; bonus bMaxSPrate,.@rate; bonus2 bHPRegenRate,50,10000; bonus2 bSPRegenRate,10,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4483,'Sealed_Dracula_Card','Sealed Dracula Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bSPDrainRate,((getrefine()>14)?70:50),5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4484,'Sealed_Mistress_Card','Sealed Mistress Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bNoGemStone; bonus bUseSPrate,((getrefine()>14)?35:50);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4485,'Sealed_Gloom_Card','Sealed Gloom Under Night Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'.@rate = ((getrefine()>14)?30:20); bonus2 bAddEle,Ele_Holy,.@rate; bonus2 bAddEle,Ele_Dark,.@rate; bonus2 bAddRace,RC_Angel,.@rate; bonus2 bAddRace,RC_Demon,.@rate;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4486,'Sealed_Berz_Card','Sealed Berzebub Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bVariableCastrate,-15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4487,'Sealed_Ifrit_Card','Sealed Ifrit Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bBaseAtk,(JobLevel/20); bonus bCritical,(JobLevel/20); bonus bHit,(JobLevel/20); bonus3 bAutoSpellWhenHit,"NPC_EARTHQUAKE",5,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4488,'Sealed_D_Lord_Card','Sealed Dark Lord Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus3 bAutoSpellWhenHit,"WZ_METEOR",5,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4489,'Sealed_Pharaoh_Card','Sealed Pharaoh Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bUseSPrate,-15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4490,'Sealed_M_Flower_Card','Sealed Moonlight Flower Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'skill "AL_INCAGI",((getrefine()>14)?5:1);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4491,'Sealed_B_Shecil_Card','Sealed Sniper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,-100; bonus2 bHPDrainRate,50,((getrefine()>14)?15:10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4492,'Sealed_Orc_Hero_Card','Sealed Orc Hero Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bVit,3; bonus2 bResEff,Eff_Stun,((getrefine()>14)?6000:4000);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4493,'Sealed_Tao_Card','Sealed Tao Gunka Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,((getrefine()>14)?75:50); bonus bDefRate,-50; bonus bMdefRate,-50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4494,'Sealed_TurtleG_Card','Sealed Turtle General Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'.@rate = ((getrefine()>14)?15:10); bonus2 bAddClass,Class_All,.@rate; bonus3 bAutoSpell,"SM_MAGNUM",10,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4495,'Sealed_Amon_Ra_Card','Sealed Amon Ra Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAllStats,1; bonus3 bAutoSpellWhenHit,"PR_KYRIE",((getrefine()>14)?8:5),(15+35*(readparam(bInt)>=99));',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4496,'Sealed_Drake_Card','Sealed Drake Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'.@rate = (getrefine()>=15?75:50); bonus2 bAddSize,Size_All,.@rate; bonus2 bMagicAddSize,Size_All,.@rate;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4497,'Sealed_Knight_WS_Card','Sealed Stormy Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"WZ_STORMGUST",1,10; bonus2 bAddEff,Eff_Freeze,((getrefine()>14)?1500:1000);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4498,'Sealed_Lady_Tanee_Card','Sealed Lady Tanee Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus bMaxHPrate,((.@r>14)?-50:-60); bonus bMaxSPrate,50; bonus2 bAddMonsterDropItem,513,100; bonus2 bAddItemHealRate,513,((.@r>14)?80:50);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4499,'Sealed_Samurai_Card','Sealed Samurai Spector Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bIgnoreDefClass,Class_Normal; bonus bHPrecovRate,-100; if (getrefine()>14) bonus2 bHPLossRate,777,8000; else bonus2 bHPLossRate,888,5000;',NULL,'if((Hp<=999) && !getmapflag(strcharinfo(3),mf_pvp) && !getmapflag(strcharinfo(3),mf_pvp_noparty) && !getmapflag(strcharinfo(3),mf_pvp_noguild)) { heal(1-Hp),0; } else { heal -999,0; }');
REPLACE INTO `item_db_re` VALUES (4500,'Sealed_Orc_Load_Card','Sealed Orc Lord Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bShortWeaponDamageReturn,((getrefine()>14)?25:15);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4501,'Sealed_B_Magaleta_Card','Sealed High Priest Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus5 bAutoSpellWhenHit,"HP_ASSUMPTIO",1,((getrefine()>14)?35:25),BF_WEAPON|BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4502,'Sealed_B_Harword_Card','Sealed MasterSmith Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus bBreakWeaponRate,(.@r>14?800:500); bonus bBreakArmorRate,(.@r>14?600:500);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4503,'Sealed_Apocalips_H_Card','Sealed Vesper Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDex,2; bonus2 bIgnoreMdefClassRate,Class_Boss,((getrefine()>14)?25:15);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4504,'Sealed_Eddga_Card','Sealed Eddga Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,((getrefine()>14)?-35:-50); bonus bNoWalkDelay;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4505,'Scaraba_Card','Scaraba Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bMatk,20; bonus bMaxSPrate,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4506,'Dolomedes_Card','Dolomedes Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bDex,2; if(BaseClass==Job_Archer){ bonus bDex,getrefine()/3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4507,'Q_Scaraba_Card','Queen Scaraba Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace2,RC2_SCARABA,30; bonus2 bAddMonsterDropItem,12806,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4508,'Gold_Scaraba_Card','Gold Scaraba Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bBaseAtk,20; bonus bMaxHPrate,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4509,'Gold_Q_Scaraba_Card','Gold Queen Scaraba Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,3; bonus2 bSubRace,RC_Insect,10; if(getrefine()>=9) { bonus2 bSubRace,RC_Insect,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4510,'Miming_Card','Miming Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"WM_LULLABY_DEEPSLEEP",1,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4511,'Little_Fatum_Card','Little Fatum Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAddEff,Eff_Silence,500,ATF_MAGIC;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4512,'Parus_Card','Parus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bHealPower,3; if(BaseClass==Job_Acolyte){ bonus bHealPower,getrefine()/2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4513,'Angra_Mantis_Card','Angra Mantis Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,2; if(BaseClass==Job_Thief){ bonus bCritAtkRate,getrefine()/2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4514,'Pom_Spider_Card','Pom Spider Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Undead,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4515,'Alnoldi_Card','Alnoldi Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Plant,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4516,'Comodo_Card','Comodo Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDef,50; bonus bFlee,-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4517,'Cendrawasih_Card','Cendrawasih Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,2; if(BaseClass==Job_Mage){ bonus bInt,getrefine()/3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4518,'Banaspaty_Card','Banaspaty Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAddEff,Eff_Burning,500,ATF_TARGET;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4519,'Butoijo_Card','Butoijo Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Angel,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4520,'Leak_Card','Leak Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bStr,3; bonus2 bAddEff,Eff_Confusion,5000; bonus3 bAddEff,Eff_Confusion,5000,ATF_TARGET;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4521,'Sedora_Card','Sedora Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4522,'Sropho_Card','Sropho Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus4 bAddEff,Eff_Crystalize,500,ATF_SHORT,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4523,'Pot_Dofle_Card','Pot Dofle Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Water; bonus2 bSubRace,RC_Fish,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4524,'King_Dramoh_Card','King Dramoh Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bStr,2; if(BaseClass==Job_Swordman){ bonus bStr,2+(getrefine()/3); }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4525,'Kraken_Card','Kraken Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10; skill "TF_HIDING",1; skill "RG_RAID",1; bonus5 bAutoSpellOnSkill,"RG_RAID","NPC_WIDEBLEEDING",1,250,1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db_re` VALUES (4526,'Odd_Coelacanth_Card','Weird Coelacanth Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxSPrate,5; bonus bMdef,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4527,'Black_Coelacanth_Card','Dark Coelacanth Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,10; bonus bDef,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4528,'Mutant_Coelacanth_Card','Mutant Coelacanth Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus bMatkRate,2+(.@r/2); bonus bMaxHPrate,-.@r/2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4529,'Cruel_Coelacanth_Card','Violent Coelacanth Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus2 bAddClass,Class_All,2+(.@r/2); bonus bMaxSPrate,-.@r/2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4530,'Siorava_Card','Siorava Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bLuk,2; if(BaseClass==Job_Merchant){ bonus bLuk,2+(getrefine()/3); }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4531,'Red_Eruma_Card','Red Eruma Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAddEff,Eff_Curse,100,ATF_MAGIC;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4532,'Wild_Rider_Card','Wild Rider Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus3 bAutoSpell,"AL_INCAGI",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4533,'Mini_Octopus_Card','Octopus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus3 bAddEff,Eff_Blind,100,ATF_MAGIC;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4534,'Giant_Octopus_Card','Giant Octopus Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,12; skill "WZ_WATERBALL",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4535,'Sealed_Rand_Card','Sealed Randgris Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,(getrefine()>=15?8:5); bonus5 bAutoSpell,"SA_DISPELL",1,1,BF_NORMAL,1; bonus bUnbreakableWeapon;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4536,'Sealed_Atroce_Card','Sealed Atroce Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus bBaseAtk,((.@r>14)?25:15); autobonus "{ bonus bAspdRate,(("+.@r+">14)?75:50); }",5,10000,0,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4537,'Sealed_Phreeoni_Card','Sealed Phreeoni Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bHit,((getrefine()>14)?75:50);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4538,'Sealed_Bacsojin_Card','Sealed White Lady Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus bHealPower,(.@r>14?25:15); bonus bUseSPrate,(.@r>14?20:30);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4539,'Sealed_F_Bishop_Card','Sealed Fallen Bishop Hibram Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus bMatkRate,((.@r>14)?8:5); bonus bMaxSPrate,-50; .@rate = ((.@r>14)?33:25); bonus2 bMagicAddRace,RC_Angel,.@rate; bonus2 bMagicAddRace,RC_DemiHuman,.@rate; bonus2 bMagicAddRace,RC_Player,.@rate;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4540,'SLD_Lord_Of_Death_Card','Sealed Lord of The Dead Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'.@rate = ((getrefine()>14)?350:250); bonus3 bAddEff,Eff_Stun,.@rate,ATF_SHORT; bonus3 bAddEff,Eff_Curse,.@rate,ATF_SHORT; bonus3 bAddEff,Eff_Silence,.@rate,ATF_SHORT; bonus3 bAddEff,Eff_Poison,.@rate,ATF_SHORT; bonus3 bAddEff,Eff_Bleeding,.@rate,ATF_SHORT; bonus2 bComaClass,Class_Normal,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4541,'SLD_B_Katrinn_Card','Sealed High Wizard Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bIgnoreMdefClassRate,Class_Normal,100; .@rate = ((getrefine()>14)?120:150); bonus bVariableCastrate,.@rate; bonus bSPrecovRate,-.@rate;',NULL,'heal 0,((getrefine()>14)?-2000:-3000);');
REPLACE INTO `item_db_re` VALUES (4542,'SLD_Detale_Card','Sealed Detale Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Freeze,(getrefine()>=15?6000:4000); bonus5 bAutoSpell,"SA_LANDPROTECTOR",1,1,BF_MAGIC,1; bonus bMdef,-20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4543,'SLD_Garm_Card','Sealed Hatii Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddEffWhenHit,Eff_Freeze,((getrefine()>14)?4000:2500);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4544,'SLD_Dark_Snake_Card','Sealed Evil Snake Lord Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bInt,3; .@i = (getrefine()>14?7500:5000); bonus2 bResEff,Eff_Blind,.@i; bonus2 bResEff,Eff_Curse,.@i;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4545,'Novice_Poring_Card','Novice Poring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4546,'Val\'khiri_Card','Val\'khiri Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4547,'Upd_Byorgue_Card','Enhanced Byorgue Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'if(BaseJob==Job_Rogue) { bonus bMatkRate,10; bonus2 bAddClass,Class_All,10; bonus bMaxHPrate,getrefine()/2; } /* Adds a chance of inflicting Confuse on target when using Body Paint skill. */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4548,'Upd_Salamander_Card','Enhanced Salamander Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"WZ_FIREPILLAR",40; bonus2 bSkillAtk,"WZ_METEOR",40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4549,'Upd_Maya_Puple_Card','Upd Maya Puple Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bIntravision; bonus bAllStats,1; skill "AL_RUWACH",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4550,'Upd_Bow_Guardian_Card','Upd Bow Guardian Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getiteminfo(getequipid(EQI_HAND_R),11)==W_BOW) { bonus2 bSkillAtk,"RA_ARROWSTORM",50; bonus bCriticalLong,25+10*(getequiprefinerycnt(EQI_HAND_R)/4); bonus bHit,5; bonus3 bAutoSpell,"HT_PHANTASMIC",1,100; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4552,'Manny_Card','Manny Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bMaxHP,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4553,'Sid_Card','Sid Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4554,'Diego_Card','Diego Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4555,'Scrat_Card','Scrat Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4556,'Fenrir_Card','Fenrir Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMatk,50+getrefine()*5; bonus bFixedCastrate,-70;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4557,'Fenrir_Card_','Weakened Fenrir Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMatk,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4559,'M_Morocc_Card','Evil Morocc Card',6,20,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bAspd,1; bonus bMaxSPrate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4560,'Clown_Card','Clown Alphoccio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'skill "BA_POEMBRAGI",10; bonus bFlee,(readparam(bVit)>=110)?40:20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4561,'Professor_Card','Professor Celia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMatkRate,(readparam(bDex)>=110)?14:7; bonus5 bAutoSpellWhenHit,"SA_LANDPROTECTOR",5,70,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4562,'Champion_Card','Champion Chen Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,(readparam(bAgi)>=110)?14:7; bonus5 bAutoSpellWhenHit,"MO_INVESTIGATE",5,70,BF_WEAPON,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4563,'Creator_Card','Creator Flamel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bCritical,(readparam(bStr)>=110)?40:20; bonus5 bAutoSpellWhenHit,"AM_ACIDTERROR",5,70,BF_WEAPON,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4564,'Stalker_Card','Stalker Gertie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bHit,(readparam(bLuk)>=110)?40:20; bonus5 bAutoSpellWhenHit,"ST_FULLSTRIP",1,70,BF_WEAPON,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4565,'Paladin_Card','Paladin Randel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,(readparam(bLuk)>=110)?20:10; bonus5 bAutoSpellWhenHit,"CR_GRANDCROSS",10,70,BF_WEAPON,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4566,'Gypsy_Card','Gypsy Trentini Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'skill "DC_FORTUNEKISS",10; bonus bFlee,(readparam(bVit)>=110)?40:20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4567,'Alphoccio_Card','Alphoccio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10; if(BaseJob==Job_Bard) { bonus bMaxHPrate,10; bonus bMaxSPrate,5;}',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4568,'Ceila_Card','Celia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10; skill "SA_ABRACADABRA",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4569,'Chen_Card','Chen Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10; skill "MO_CALLSPIRITS",2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4570,'Flamel_Card','Flamel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10; bonus2 bAddItemGroupHealRate,IG_Flamel_Card,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4571,'Gertie_Card','Gertie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10; skill "RG_CLOSECONFINE",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4572,'Randel_Card','Randel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10; skill "CR_AUTOGUARD",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4573,'Trentini_Card','Trentini Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bFlee,10; if(BaseJob==Job_Dancer) { bonus bMaxHPrate,10; bonus bMaxSPrate,5;}',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4574,'Daehyon_Card','General Daehyon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'.@i = getiteminfo(getequipid(EQI_HAND_R),11); if(.@i==W_1HSWORD||.@i==W_2HSWORD) { bonus bBaseAtk,100; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4575,'Soheon_Card','Armed Guard Soheon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; if(getiteminfo(getequipid(EQI_HAND_R),11) == W_DAGGER) { .@r = getrefine(); if(.@r>=10) { bonus bAspd,1; } if(.@r>=14) { bonus bAspd,1; } }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4576,'Gioia_Card','Gioia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bMagicAtkEle,Ele_Wind,100; bonus2 bMagicAtkEle,Ele_Ghost,100; bonus2 bSubEle,Ele_All,-30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4577,'Elvira_Card','Elvira Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bMagicAtkEle,Ele_Wind,20; bonus2 bMagicAtkEle,Ele_Ghost,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4578,'Pyuriel_Card','Angry Student Pyuriel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,30; bonus2 bSubRace,RC_All,-10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4579,'Lora_Card','Warrior Lola Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getiteminfo(getequipid(EQI_HAND_R),11) == W_MACE) { bonus bBaseAtk,20; bonus bCritical,10; } .@r = getrefine(); bonus bBaseAtk,.@r; bonus bCritical,.@r;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4580,'Kades_Card','Dark Guardian Kades Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Water,50; bonus2 bSubEle,Ele_Earth,50; bonus2 bSubEle,Ele_Fire,50; bonus2 bSubEle,Ele_Wind,50; bonus2 bSubEle,Ele_Dark,50; bonus2 bSubEle,Ele_Undead,50; bonus2 bSubEle,Ele_Holy,-100; bonus2 bSubEle,Ele_Ghost,-100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4581,'Rudo_Card','Rudo Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'autobonus "{ bonus bAgi,44; heal 0,-40; }",500,3000,0,"{ sc_start SC_SPEEDUP1,3000,50; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4582,'Bungisngis_Card','Bungisngis Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,(getrefine()/2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4583,'Engkanto_Card','Engkanto Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Poison,30; bonus2 bMagicAddEle,Ele_Poison,30; bonus2 bIgnoreDefRaceRate,RC_Plant,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4584,'Manananggal_Card','Manananggal Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bSPDrainValue,1; bonus bMaxSPrate,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4585,'Mangkukulam_Card','Mangkukulam Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxSPrate,10; bonus bHPGainValue,-666;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4586,'Tikbalang_Card','Tikbalang Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMatk,10; bonus2 bMagicAtkEle,Ele_Wind,(getrefine()>=9)?10:5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4587,'Tiyanak_Card','Tiyanak Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bCriticalAddRace,RC_Brute,12; bonus2 bCriticalAddRace,RC_Fish,12; bonus2 bCriticalAddRace,RC_DemiHuman,12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4588,'Wakwak_Card','Wakwak Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5*readparam(bStr)/10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4589,'Jejeling_Card','Jejeling Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bMaxHP,200*readparam(bVit)/10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4590,'Bangungot_Card','Bangungot Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bInt,4; bonus5 bAutoSpellWhenHit,"NPC_WIDESLEEP",5,70,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4591,'Bakonawa_Card','Bakonawa Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bStr,4; bonus5 bAutoSpellWhenHit,"NPC_WIDEBLEEDING",5,70,BF_WEAPON,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4592,'Buwaya_Card','Buwaya Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bVit,4; bonus5 bAutoSpellWhenHit,"NPC_WIDESTONE",5,70,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4593,'Menblatt_Card','Menblatt Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,readparam(bDex)/10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4594,'Petal_Card','Petal Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,2*(readparam(bLuk)/10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4595,'Cenere_Card','Cenere Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bAspdRate,2*(readparam(bAgi)/10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4596,'AntiqueBook_Card','Antique Book Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bMatk,5*(readparam(bInt)/10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4597,'LichternB_Card','Lichtern Blue Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMatk,10; bonus2 bMagicAtkEle,Ele_Water,(getrefine()>=9)?10:5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4598,'LichternY_Card','Lichtern Green Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMatk,10; bonus2 bMagicAtkEle,Ele_Ghost,(getrefine()>=9)?10:5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4599,'LichternR_Card','Lichtern Red Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMatk,10; bonus2 bMagicAtkEle,Ele_Fire,(getrefine()>=9)?10:5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4600,'LichternG_Card','Lichtern Yellow Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bMatk,10; bonus2 bMagicAtkEle,Ele_Earth,(getrefine()>=9)?10:5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4601,'Amdarais_Card','Amdarais Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,15; bonus bMatkRate,15; bonus2 bHPLossRate,666,4000; bonus2 bSPLossRate,66,4000;',NULL,'heal -6666,-666;');
REPLACE INTO `item_db_re` VALUES (4602,'AmdaraisH_Card','Realized Amdarais Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,20; bonus bMatkRate,20; bonus2 bHPLossRate,666,6000; bonus2 bSPLossRate,66,6000;',NULL,'heal -6666,-666;');
REPLACE INTO `item_db_re` VALUES (4603,'CorruptionRoot_Card','Corruption Root Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,20; bonus5 bAutoSpell,"NPC_WIDESTONE",1,70,BF_WEAPON,0; bonus5 bAutoSpell,"NPC_WIDESLEEP",1,70,BF_WEAPON,0; bonus5 bAutoSpell,"NPC_WIDECURSE",1,70,BF_WEAPON,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4604,'CorruptionRootH_Card','Realized Corruption Root Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,30; bonus5 bAutoSpell,"NPC_WIDESTONE",2,70,BF_WEAPON,0; bonus5 bAutoSpell,"NPC_WIDESLEEP",2,70,BF_WEAPON,0; bonus5 bAutoSpell,"NPC_WIDECURSE",2,70,BF_WEAPON,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4605,'UndeadKnightM_Card','Agony Of Royal Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,-44; bonus bHPGainValue,200+10*getrefine();',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4606,'UndeadKnightF_Card','Grudge of Royal Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bMaxSPrate,-44; bonus bSPGainValue,20+(getrefine()/2);',NULL,'heal 0,-444;');
REPLACE INTO `item_db_re` VALUES (4607,'FaithfulManager_Card','Faithful Manager Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,5; bonus bMatk,5; if(getiteminfo(getequipid(EQI_HAND_R),11) == W_BOOK) { .@r = getrefine(); if(.@r>=10) { bonus bBaseAtk,20; bonus bMatk,20; } if(.@r>=14) { bonus bBaseAtk,20; bonus bMatk,20; } }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4608,'White_Knight_Card','White Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bBaseAtk,15; bonus2 bAddSize,Size_Medium,20; bonus2 bAddSize,Size_Large,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4609,'Khalitzburg_Knight_Card','Khalitzburg Knight Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bDef,20; bonus2 bSubSize,Size_Medium,25; bonus2 bSubSize,Size_Large,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4610,'Sarah_Card','Sarah Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bAbsorbDmgMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4625,'Time_Holder_Card','Time Holder Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bMatkRate,20; bonus bUseSPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4626,'Big_Ben_Card','Big Ben Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Formless,5; bonus2 bMagicAddRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4627,'Big_Bell_Card','Big Bell Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Formless,10; bonus2 bAddRace,RC_Demon,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4628,'Neo_Punk_Card','Neo Punk Card',6,10,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Formless,20; bonus2 bSubRace,RC_Demon,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4629,'Arc_Elder_Card','Arc Elder Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,15; bonus2 bMagicAtkEle,Ele_Earth,getrefine()*3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4630,'Nightmare_Timer_Keeper_Card','Nightmare Timer Keeper Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus3 bAutoSpell,"NPC_WIDECURSE",2,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4631,'Owl_Viscount_Card','Owl Viscount Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bAspdRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4632,'Owl_Marquees_Card','Owl Marquees Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus5 bAutoSpell,"SA_VIOLENTGALE",(getskilllv("SA_VIOLENTGALE")==5?5:1),1,BF_WEAPON,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4633,'Enhanced_Archer_Skeleton_Card','Enhanced Archer Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,(BaseLevel>=100?12:10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4634,'Enhanced_Soldier_Skeleton_Card','Enhanced Soldier Skeleton Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if (BaseLevel<100) { bonus bCritical,9; } else { bonus bCritical,10; bonus bCritAtkRate,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4635,'Enhanced_Amdarais_Card','Enhanced Amdarais Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus bDef,(.@r*10); bonus bFlee,(.@r*-2); if (BaseLevel>=100) bonus bMaxHP,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4636,'Bijou_Card','Bijou Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Freeze,10000; bonus2 bAddClass,Class_All,10; bonus bMatkRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4637,'Immortal_Corps_Card','Immortal Corps Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bHPGainValue,50; bonus bSPGainValue,5; bonus bNoRegen,1; bonus bNoRegen,2;',NULL,'heal -1000,-100;');
REPLACE INTO `item_db_re` VALUES (4638,'Watcher_Card','Watcher Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bBaseAtk,30; bonus bSPDrainValue,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4639,'Taffy_Card','Taffy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4640,'Frozen_Wolf_Card','Frozen Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4641,'Zombie_Guard_Card','Zombie Guard Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus bNoRegen,2; bonus bSPDrainValue,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4642,'Min_Toad_Card','Infinite Toad Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'.@r = getrefine(); if(.@r>6){ .@b+=2; if(.@r>8).@b+=3; } bonus bFlee2,2+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4643,'Min_Vagabond_Wolf_Card','Infinite Vagabond Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'.@r = getrefine(); if(.@r>6){ .@b+=10; if(.@r>8).@b+=15; } bonus bAtk,10+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4644,'Min_Vocal_Card','Infinite Vocal Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'.@r = getrefine(); if(.@r>6){ .@b+=10; if(.@r>8) .@b+=15; } bonus bMdef,5+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4645,'Min_Eclipse_Card','Infinite Eclipse Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'.@r = getrefine(); if(.@r>6){ .@b+=300; if(.@r>8).@b+=400; } bonus bMaxHP,300+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4646,'Min_Chimera_Card','Infinite Chimera Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,8; bonus bMaxSPrate,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4647,'Min_Osiris_Card','Infinite Osiris Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,136,NULL,NULL,NULL,NULL,'bonus bHPGainValue,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4648,'Min_Eddga_Card','Infinite Eddga Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus4 bAutoSpellWhenHit,"SM_PROVOKE",10,500,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4649,'Min_Phreeoni_Card','Infinite Phreeoni Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bCritical,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4650,'Min_Orc_Hero_Card','Infinite Orc Hero Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bVit,3; bonus3 bAddEffWhenHit,Eff_Stun,10000,ATF_MAGIC;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4651,'Min_Tao_Gunka_Card','Infinite Tao Gunka Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxHP,10000; bonus bAgi,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4652,'N_Amon_Ra_Card','Nightmare Amon Ra Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Demon,50; bonus2 bMagicAddRace,RC_Undead,50; bonus2 bMagicAddEle,Ele_Dark,50; bonus2 bMagicAddEle,Ele_Undead,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4653,'N_Arclouse_Card','Nightmare Arclouse Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_Brute,20; bonus2 bSubRace,RC_Undead,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4654,'N_Mimic_Card','Nightmare Mimic Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_Brute,5; bonus2 bMagicAddRace,RC_Undead,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4655,'N_Minorous_Card','Nightmare Minorous Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_Brute,10; bonus2 bAddRace,RC_Undead,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4656,'N_Mummy_Card','Nightmare Mummy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'/* Unofficial chance */ bonus3 bAutoSpellWhenHit,"NPC_WIDESLEEP",2,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4657,'N_Ancient_Mummy_Card','Nightmare Ancient Mummy Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,15; bonus2 bMagicAtkEle,Ele_Fire,getrefine()*3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4658,'N_Verit_Card','Nightmare Verit Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus2 bMagicAddClass,Class_All,5; if(getrefine()>6) { bonus2 bMagicAddClass,Class_All,3; } if(getrefine()>8) { bonus2 bMagicAddClass,Class_All,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4659,'Eggring_Card','Eggring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bLuk,2; bonus bMaxHP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4660,'Scout_Basilisk_Card','Scout Basilisk Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubSize,Size_Small,5; bonus2 bSubSize,Size_Medium,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4661,'Charge_Basilisk_Card','Charge Basilisk Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,32,NULL,NULL,NULL,NULL,'bonus2 bSubSize,Size_Medium,20; bonus2 bSubSize,Size_Large,20; bonus2 bSubSize,Size_Small,-15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4662,'Big_Eggring_Card','Big Eggring Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'bonus bAtk,25-5*min(readParam(bStr)/10,5); bonus bMatk,25-5*min(readParam(bInt)/10,5); bonus bAspdRate,10-2*min(readParam(bAgi)/10,5); bonus bMaxHP,1000-200*min(readParam(bVit)/10,5); bonus bLongAtkRate,5-1*min(readParam(bDex)/10,5); bonus bCritAtkRate,10-2*min(readParam(bLuk)/10,5);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4663,'Leaf_Lunatic_Card','Leaf Lunatic Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxSP,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4664,'Grass_Fabre_Card','Grass Fabre Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bLuk,1; bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4665,'Wild_Hornet_Card','Wild Hornet Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'bonus bAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4666,'Sweet_Roda_Frog_Card','Sweet Roda Frog Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16,NULL,NULL,NULL,NULL,'bonus bMaxSP,10; bonus bMaxHP,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4667,'Hunter_Wolf_Card','Hunter Wolf Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64,NULL,NULL,NULL,NULL,'bonus bMaxSP,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4668,'Trance_Spore_Card','Trance Spore Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,769,NULL,NULL,NULL,NULL,'bonus bVit,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4669,'Jungle_Mandragora_Card','Jungle Mandragora Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus2 bAddEle,Ele_Wind,((.@r>=9)?7:((.@r>=7)?5:3));',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4670,'Fruit_Pom_Spider_Card','Fruit Pom Spider Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'.@r = getrefine(); bonus2 bAddEle,Ele_Fire,((.@r>=9)?7:((.@r>=7)?5:3));',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4671,'V_Celia_Card','Sorcerer Celia Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Sage){ bonus bMaxHPrate,10; bonus bMatkRate,10; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4672,'V_Chen_Card','Sura Chen Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Monk){ bonus bMaxHPrate,10; bonus2 bAddClass,Class_All,10; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4673,'V_Alphoccio_Card','Minstel Alphoccio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Bard){ bonus bMaxHPrate,15; bonus bMaxSPrate,10; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4674,'V_Eremes_Card','Guillotine Cross Eremes Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Assassin){ bonus bFlee2,10; bonus2 bAddClass,Class_All,15; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4675,'V_Magaleta_Card','Arch Bishop Magaleta Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Priest){ bonus bMaxHPrate,10; bonus bHealPower,10; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4676,'V_Shecil_Card','Ranger Cecil Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Hunter){ bonus bCritical,20; bonus bLongAtkRate,15; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4677,'V_Howard_Card','Mechanic Howard Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Blacksmith){ bonus bHit,20; bonus2 bAddClass,Class_All,15; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4678,'V_Katrinn_Card','Warlock Kathryne Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Wizard){ bonus bMdef,80; bonus bMatkRate,15; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4679,'V_Seyren_Card','Rune Knight Seyren Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Knight){ bonus bAspd,2; bonus2 bAddClass,Class_All,15; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4680,'V_Randel_Card','Royal Guard Randel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Crusader){ bonus bDef,350; bonus2 bAddClass,Class_All,10; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4681,'V_Flamel_Card','Genetic Flamel Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Alchemist){ bonus bFlee,20; bonus2 bAddClass,Class_All,15; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4682,'V_Gertie_Card','Shadow Chaser Gertie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Rogue){ bonus2 bAddClass,Class_All,5; bonus bMatkRate,15; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4683,'V_Trentini_Card','Wanderer Trentini Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,'if(eaclass()&EAJL_THIRD && BaseJob == Job_Dancer){ bonus bMaxHPrate,10; bonus bMaxSPrate,15; } if(BaseLevel>174) bonus bAllStats,10; if(getrefine()>9) bonus bAllStats,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4684,'V_B_Eremes_Card','True Eremes Guile Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"GC_CROSSIMPACT",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4685,'V_B_Magaleta_Card','True Margaretha Sorin Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"AB_ADORAMUS",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4686,'V_B_Katrinn_Card','True Kathryne Keyron Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"WL_CRIMSONROCK",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4687,'V_B_Shecil_Card','True Cecil Damon Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"RA_CLUSTERBOMB",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4688,'V_B_Harword_Card','True Howard Alt-Eisen Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"NC_AXETORNADO",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4689,'V_B_Seyren_Card','True Seyren Windsor Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"RK_IGNITIONBREAK",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4690,'V_B_Randel_Card','True Randel Lawrence Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"LG_EARTHDRIVE",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4691,'V_B_Flamel_Card','True Flamel Emure Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"GN_CART_TORNADO",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4692,'V_B_Celia_Card','True Celia Alde Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"SO_VARETYR_SPEAR",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4693,'V_B_Chen_Card','True Chen Liu Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"SR_RAMPAGEBLASTER",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4694,'V_B_Gertie_Card','True Gertie Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"SC_FEINTBOMB",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4695,'V_B_Trentini_Card','True Trentini Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"WM_SEVERE_RAINSTORM",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4696,'V_B_Alphoccio_Card','True Alphoccio Card',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,'if(getrefine() > 9) .@b+=20; if(getequipweaponlv(-1) == 4) .@b += 20; bonus2 bSkillAtk,"WM_REVERBERATION",20+.@b;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4697,'Charleston3_Card','Charleston3 Card',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,2,NULL,NULL,NULL,NULL,'bonus bMaxSP,-300; bonus bBreakArmorRate,1500; /* Custom rate [Secret] */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4698,'Step_Card','Step Card',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"NC_AXEBOOMERANG",30+((getrefine() >= 10)*30);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4699,'Rock_Step_Card','Rock Step Card',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,2,NULL,NULL,NULL,NULL,'bonus2 bSkillAtk,"NC_ARMSCANNON",20+((getrefine()>=10)*20);',NULL,NULL);
#===================================================================
# Armor Enchant System
#===================================================================
REPLACE INTO `item_db_re` VALUES (4700,'Strength1','STR+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4701,'Strength2','STR+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4702,'Strength3','STR+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4703,'Strength4','STR+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4704,'Strength5','STR+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4705,'Strength6','STR+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4706,'Strength7','STR+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4707,'Strength8','STR+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4708,'Strength9','STR+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4709,'Strength10','STR+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4710,'Inteligence1','INT+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4711,'Inteligence2','INT+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4712,'Inteligence3','INT+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4713,'Inteligence4','INT+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4714,'Inteligence5','INT+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4715,'Inteligence6','INT+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4716,'Inteligence7','INT+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4717,'Inteligence8','INT+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4718,'Inteligence9','INT+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4719,'Inteligence10','INT+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4720,'Dexterity1','DEX+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4721,'Dexterity2','DEX+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4722,'Dexterity3','DEX+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4723,'Dexterity4','DEX+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4724,'Dexterity5','DEX+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4725,'Dexterity6','DEX+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4726,'Dexterity7','DEX+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4727,'Dexterity8','DEX+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4728,'Dexterity9','DEX+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4729,'Dexterity10','DEX+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4730,'Agility1','AGI+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4731,'Agility2','AGI+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4732,'Agility3','AGI+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4733,'Agility4','AGI+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4734,'Agility5','AGI+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4735,'Agility6','AGI+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4736,'Agility7','AGI+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4737,'Agility8','AGI+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4738,'Agility9','AGI+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4739,'Agility10','AGI+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4740,'Vitality1','VIT+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4741,'Vitality2','VIT+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4742,'Vitality3','VIT+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4743,'Vitality4','VIT+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4744,'Vitality5','VIT+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4745,'Vitality6','VIT+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4746,'Vitality7','VIT+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4747,'Vitality8','VIT+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4748,'Vitality9','VIT+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4749,'Vitality10','VIT+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4750,'Luck1','LUK+1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4751,'Luck2','LUK+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4752,'Luck3','LUK+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4753,'Luck4','LUK+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4754,'Luck5','LUK+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4755,'Luck6','LUK+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4756,'Luck7','LUK+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4757,'Luck8','LUK+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4758,'Luck9','LUK+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4759,'Luck10','LUK+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4760,'Matk1','MATK+1%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,1; bonus bFixedCastrate,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4761,'Matk2','MATK+2%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,2; bonus bFixedCastrate,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4762,'Evasion6','FLEE+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4763,'Evasion12','FLEE+12',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee,12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4764,'Critical5','CRI+5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4765,'Critical7','CRI+7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4766,'Atk2','ATK+2%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4767,'Atk3','ATK+3%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4768,'Str1_J','Str + 1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4769,'Str2_J','Str + 2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4770,'Str3_J','Str + 3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4771,'Int1_J','Int + 1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4772,'Int2_J','Int + 2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4773,'Int3_J','Int + 3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4774,'Vit1_J','Vit + 1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4775,'Vit2_J','Vit + 2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4776,'Vit3_J','Vit + 3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4777,'Agi1_J','Agi + 1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4778,'Agi2_J','Agi + 2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4779,'Agi3_J','Agi + 3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4780,'Dex1_J','Dex + 1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4781,'Dex2_J','Dex + 2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4782,'Dex3_J','Dex + 3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4783,'Luk1_J','Luk + 1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4784,'Luk2_J','Luk + 2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4785,'Luk3_J','Luk + 3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4786,'Mdef2','MDEF+2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4787,'Mdef4','MDEF+4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4788,'Mdef6','MDEF+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMdef,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4789,'Mdef8','MDEF+8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMdef,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4790,'Mdef10','MDEF+10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4791,'Def3','DEF+3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4792,'Def6','DEF+6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDef,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4793,'Def9','DEF+9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDef,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4794,'Def12','DEF+12',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDef,12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4795,'HP100','HP+100',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4796,'HP200','HP+200',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHP,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4797,'HP300','HP+300',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHP,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4798,'HP400','HP+400',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHP,400;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4799,'HP500','HP+500',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHP,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4800,'SP50','SP+50',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4801,'SP100','SP+100',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxSP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4802,'SP150','SP+150',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4803,'Highness_Heal_3sec','Cure1Lv.',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSkillCooldown,"AB_HIGHNESSHEAL",-3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4804,'Coluceo_Heal30','Catholic1Lv.',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSkillUseSP,"AB_CHEAL",30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4805,'Heal_Amount2','Archbishop1Lv',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bHealPower,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4806,'Matk3','MATK+3%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,3; bonus bFixedCastrate,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4807,'Atk_Speed1','Atk Speed1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAspd,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4808,'Fighting_Spirit4','Fighting Spirit4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,15; bonus bHit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4809,'Fighting_Spirit3','Fighting Spirit3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,12; bonus bHit,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4810,'Fighting_Spirit2','Fighting Spirit2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,9; bonus bHit,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4811,'Fighting_Spirit1','Fighting Spirit1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,6; bonus bHit,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4812,'Spell4','Spell4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,15; bonus bVariableCastrate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4813,'Spell3','Spell3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,12; bonus bVariableCastrate,-8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4814,'Spell2','Spell2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,9; bonus bVariableCastrate,-6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4815,'Spell1','Spell1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,6; bonus bVariableCastrate,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4816,'Sharp3','Sharp3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,12; bonus bHit,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4817,'Sharp2','Sharp2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,9; bonus bHit,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4818,'Sharp1','Sharp1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,6; bonus bHit,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4819,'Atk1','Atk1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4820,'Fighting_Spirit5','Fighting Spirit5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,18; bonus bHit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4821,'Fighting_Spirit6','Fighting Spirit6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,21; bonus bHit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4822,'Fighting_Spirit7','Fighting Spirit7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,24; bonus bHit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4823,'Fighting_Spirit8','Fighting Spirit8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,27; bonus bHit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4824,'Fighting_Spirit9','Fighting Spirit9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,30; bonus bHit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4825,'Fighting_Spirit10','Fighting Spirit10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,50; bonus bHit,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4826,'Spell5','Spell5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,18; bonus bVariableCastrate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4827,'Spell6','Spell6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,21; bonus bVariableCastrate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4828,'Spell7','Spell7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,24; bonus bVariableCastrate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4829,'Spell8','Spell8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,27; bonus bVariableCastrate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4830,'Spell9','Spell9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,30; bonus bVariableCastrate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4831,'Spell10','Spell10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,50; bonus bVariableCastrate,-20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4832,'Expert_Archer1','Expert Archer1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4833,'Expert_Archer2','Expert Archer2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4834,'Expert_Archer3','Expert Archer3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4835,'Expert_Archer4','Expert Archer4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4836,'Expert_Archer5','Expert Archer5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4837,'Expert_Archer6','Expert Archer6',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4838,'Expert_Archer7','Expert Archer7',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,14;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4839,'Expert_Archer8','Expert Archer8',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,16;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4840,'Expert_Archer9','Expert Archer9',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,18;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4841,'Expert_Archer10','Expert Archer10',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,20; bonus bAspd,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4842,'Atk_Speed2','Atk Speed2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAspd,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4843,'Sharp4','Sharp4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,14; bonus bHit,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4844,'Sharp5','Sharp5',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,15; bonus bHit,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4845,'Sea_Energy','Strength Of Ocean',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4846,'2011Valentin_Angel','Fully Loved Stone',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; bonus bMatk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4847,'2011Valentin_Devil','Spelled Stone',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,10; bonus bMatk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4848,'Immuned1','Immune Level 1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4849,'Cranial1','Cranial Level 1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4850,'Heal_Amount3','Heal Amount2',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bHealPower,6; bonus bUseSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4851,'Heal_Amount4','Heal Amount3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bHealPower,12; bonus bUseSPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4852,'Heal_Amount5','Heal Amount4',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bHealPower,20; bonus bUseSPrate,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4853,'S_Str','Special Str',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,1; .@r = getrefine(); if(.@r>7) { bonus bStr,3; } if(.@r>8) { bonus2 bAddClass,Class_All,1; } if(.@r>11) { bonus bAspd,1; bonus bFixedCastrate,-7; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4854,'S_Agi','Special Agi',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,1; .@r = getrefine(); if(.@r>7) { bonus bAgi,3; } if(.@r>8) { bonus2 bAddClass,Class_All,1; } if(.@r>11) { bonus bAspd,1; bonus bFixedCastrate,-7; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4855,'S_Vital','Special Vit',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,1; .@r = getrefine(); if(.@r>7) { bonus bVit,3; } if(.@r>8) { bonus bMaxSPrate,1; } if(.@r>11) { bonus bAspd,1; bonus bFixedCastrate,-7; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4856,'S_Int','Special Int',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,1; .@r = getrefine(); if(.@r>7) { bonus bInt,3; } if(.@r>8) { bonus bMatkRate,1; } if(.@r>11) { bonus bAspd,1; bonus bFixedCastrate,-7; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4857,'S_Dex','Special Dex',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,1; .@r = getrefine(); if(.@r>7) { bonus bDex,3; } if(.@r>8) { bonus bMatkRate,1; } if(.@r>11) { bonus bAspd,1; bonus bFixedCastrate,-7; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4858,'S_Luck','Special Luk',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,1; .@r = getrefine(); if(.@r>7) { bonus bLuk,3; } if(.@r>8) { bonus bMaxHPrate,1; } if(.@r>11) { bonus bAspd,1; bonus bFixedCastrate,-7; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4859,'Evasion1','Evasion1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4860,'Evasion3','Evasion3',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4861,'MHP1','MHP+1%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4862,'MHP2','MHP+2%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4863,'Fatal1','Fatal1Lv',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,4; bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4864,'Fatal2','Fatal2Lv',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,6; bonus bCritical,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4865,'Fatal3','Fatal3Lv',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,8; bonus bCritical,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4866,'Fatal4','Fatal4Lv',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritAtkRate,10; bonus bCritical,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4867,'MHP3','MHP+3%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4868,'MHP4','MHP+4%',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4869,'Attack_Delay_1','DelayafterAttack1Lv',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAspdRate,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4870,'SP25','SP+25',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxSP,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4871,'SP75','SP+75',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxSP,75;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4872,'Attack_Delay_2','DelayafterAttack2Lv',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAspdRate,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4873,'Attack_Delay_3','DelayafterAttack3Lv',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAspdRate,8;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4875,'Bear\'s_Power','Bear\'s Power',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'autobonus2 "{ bonus bStr,200; bonus2 bHPLossRate,500,1000; }",20,5000,BF_WEAPON,"{ active_transform 1060,5000; specialeffect2 EF_POTION_BERSERK; showscript \\\"Bigfoot Power !\\\"; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4876,'Runaway_Magic','Runaway Magic',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'autobonus "{ bonus bInt,200; bonus2 bSPLossRate,200,1000; }",10,10000,BF_MAGIC,"{ specialeffect2 EF_LAMADAN; }";',NULL,'heal 0,-2000;');
REPLACE INTO `item_db_re` VALUES (4877,'Speed_Of_Light','Speed of Light',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/*TODO: Confirm the rate*/ autobonus "{ bonus bAspdRate,100; bonus bFlee,100; bonus2 bHPLossRate,400,1000; bonus2 bSPLossRate,50,1000;}",10,5000,BF_WEAPON,"{ specialeffect2 EF_AGIUP2; }";',NULL,'heal 0,-300;');
REPLACE INTO `item_db_re` VALUES (4878,'Muscle_Fool','Muscle Fool',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'autobonus2 "{ bonus bVit,200; bonus2 bAddRace,RC_All,-50; bonus bMatkRate,-50; }",10,5000,BF_WEAPON,"{ specialeffect2 EF_GUARD3; }";',NULL,'heal 0,-300;');
REPLACE INTO `item_db_re` VALUES (4879,'Hawkeye','Hawkeye',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'autobonus "{ bonus bDex,200; bonus2 bSPLossRate,50,1000; }",10,5000,BF_WEAPON,"{ specialeffect2 EF_BASH3D6; }";',NULL,'heal 0,-300;');
REPLACE INTO `item_db_re` VALUES (4880,'Lucky_Day','Lucky Day',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'autobonus "{ bonus bLuk,200; }",10,5000,BF_WEAPON|BF_MAGIC,"{ specialeffect2 EF_DANCE_BLADE_ATK; }";',NULL,'heal 0,-300;');
REPLACE INTO `item_db_re` VALUES (4881,'Attack_Delay_4','Attack Delay 4',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAspdRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4882,'Atk1p','ATK + 1%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4883,'Matk1p','MATK + 1%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4884,'HIT1','HIT + 1',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bHit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4885,'Conjure1','Spell 1',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,5; bonus bVariableCastrate,-3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4886,'Conjure2','Spell 2',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,10; bonus bVariableCastrate,-3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4887,'Conjure3','Spell 3',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,15; bonus bVariableCastrate,-3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4888,'Conjure4','Spell 4',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,20; bonus bVariableCastrate,-3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4889,'Conjure5','Spell 5',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,30; bonus bVariableCastrate,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4890,'Mdef1','MDEF+1',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4891,'Mdef3','MDEF+3',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4892,'Mdef5','MDEF+5',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4893,'Def15','DEF+15',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4894,'Atk4p','ATK + 4%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4895,'Atk5p','ATK + 5%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4896,'Matk2p','MATK + 2%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4897,'Matk3p','MATK + 3%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4898,'Matk4p','MATK + 4%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4899,'Matk5p','MATK + 5%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4900,'MHP5','MHP+5%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4902,'Def18','DEF+18',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDef,18;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4903,'Def21','DEF+21',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDef,21;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4904,'Atk6p','ATK + 6%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4905,'Atk7p','ATK + 7%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4906,'Matk6p','MATK + 6',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4907,'Matk7p','MATK + 7%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4908,'Force1','Darklord Essence Force1',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bStr,1; bonus bBaseAtk,3; bonus bInt,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4909,'Force2','Darklord Essence Force2',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bStr,2; bonus bBaseAtk,6; bonus bInt,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4910,'Force3','Darklord Essence Force3',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bStr,4; bonus bBaseAtk,12; bonus bInt,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4911,'Intellect1','Darklord Essence Intelligence1',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bInt,1; bonus bMatk,3; bonus bStr,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4912,'Intellect2','Darklord Essence Intelligence2',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bInt,2; bonus bMatk,6; bonus bStr,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4913,'Intellect3','Darklord Essence Intelligence3',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bInt,4; bonus bMatk,12; bonus bStr,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4914,'Swiftness1','Darklord Essence Speed1',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bAgi,1; bonus bFlee,2; bonus bVit,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4915,'Swiftness2','Darklord Essence Speed2',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bAgi,2; bonus bFlee,4; bonus bVit,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4916,'Swiftness3','Darklord Essence Speed3',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bAgi,4; bonus bFlee,8; bonus bVit,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4917,'Tough1','Darklord Essence Vitality1',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bVit,1; bonus bDef,3; bonus bMdef,2; bonus bAgi,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4918,'Tough2','Darklord Essence Vitality2',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bVit,2; bonus bDef,6; bonus bMdef,4; bonus bAgi,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4919,'Tough3','Darklord Essence Vitality3',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bVit,4; bonus bDef,12; bonus bMdef,8; bonus bAgi,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4920,'Artful1','Darklord Essence Concentration1',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bDex,1; bonus bHit,2; bonus bLuk,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4921,'Artful2','Darklord Essence Concentration2',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bDex,2; bonus bHit,4; bonus bLuk,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4922,'Artful3','Darklord Essence Concentration3',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bDex,4; bonus bHit,8; bonus bLuk,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4923,'Fortune1','Darklord Essence Luck1',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bLuk,1; bonus bCritical,1; bonus bDex,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4924,'Fortune2','Darklord Essence Luck2',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bLuk,2; bonus bCritical,2; bonus bDex,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4925,'Fortune3','Darklord Essence Luck3',6,20,NULL,10,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,1023,NULL,NULL,NULL,NULL,'bonus bLuk,4; bonus bCritical,4; bonus bDex,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4926,'Critical1','Cri 1Lv',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4927,'HP50','MaxHP50',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4928,'SP10','MaxSP+10',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxSP,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4929,'MSP1','MSP+1%',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxSPrate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4930,'HEAL2','Recovery UP',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bHPrecovRate,2; bonus bSPrecovRate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4931,'HEALHP1','Heal 10',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bHPRegenRate,10,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4932,'HEALSP1','SP recovery1',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bSPGainValue,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4933,'Tolerance_Not1','Neutral Resistance Lv1',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4934,'Tolerance_Not2','Neutral Resistance Lv2',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4935,'Tolerance_Not3','Neutral Resistance Lv3',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Neutral,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4936,'ATK_BIG1','Attack big1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Large,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4937,'ATK_MEDIUM1','Attack mid1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Medium,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4938,'ATK_SMALL1','Attack small1',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Small,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4939,'Critical2','CRI Lv2',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4940,'Critical3','CRI Lv3',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4941,'Critical4','CRI Lv4',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4942,'Dodge1','Parrying Lv1',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee2,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4943,'Dodge2','Parrying Lv2',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee2,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4944,'Dodge3','Parrying Lv3',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee2,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4945,'Thrift1','Economy Lv1',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bUseSPrate,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4946,'Thrift2','Economy Lv2',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bUseSPrate,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4947,'Thrift3','Economy Lv3',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bUseSPrate,-6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4948,'Skill_Delay1','After Skill Delay Lv1',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDelayrate,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4949,'Skill_Delay2','After Skill Delay Lv2',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDelayrate,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4950,'Skill_Delay3','After Skill Delay Lv3',6,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDelayrate,-6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4951,'Darkness_Drop','Darkness Drop',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Dark,2; bonus2 bMagicAtkEle,Ele_Dark,2; bonus2 bSubEle,Ele_Dark,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4952,'Fire_Drop','Fire Drop',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Fire,2; bonus2 bMagicAtkEle,Ele_Fire,2; bonus2 bSubEle,Ele_Fire,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4953,'Water_Drop','Water Drop',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Water,2; bonus2 bMagicAtkEle,Ele_Water,2; bonus2 bSubEle,Ele_Water,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4954,'Earth_Drop','Earth Drop',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Earth,2; bonus2 bMagicAtkEle,Ele_Earth,2; bonus2 bSubEle,Ele_Earth,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4955,'Holy_Drop','Holy Drop',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddEle,Ele_Holy,2; bonus2 bMagicAtkEle,Ele_Holy,2; bonus2 bSubEle,Ele_Holy,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4956,'Recovery_Drop','Recovery Drop',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'setarray .@skills$, "AL_HEAL", "PR_SANCTUARY", "AM_POTIONPITCHER", "AB_HIGHNESSHEAL", "AB_CHEAL"; for( .@i = 0; .@i < getarraysize(.@skills$); .@i++ ){ bonus2 bSkillHeal,.@skills$[.@i],2; bonus2 bSkillHeal2,.@skills$[.@i],2; } /* TODO: Depending on some recovery items HP recovery amount + 2% */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4957,'Famitsus_Power','Famitsu\'s Power',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHP,832;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4958,'Gemini','Gemini',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDelayrate,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4959,'Sagittarius','Sagittarius',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLongAtkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4960,'Aquarius','Aquarius',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bUseSPrate,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4961,'Aries','Aries',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4962,'Cancer','Cancer',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAtk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4963,'Taurus','Taurus',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAtk,4; bonus bHit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4964,'Capricorn','Capricorn',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bMagicAddRace,RC_All,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4965,'Pisces','Pisces',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVariableCastrate,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4966,'Scorpio','Scorpio',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddRace,RC_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4967,'Leo','Leo',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAspdRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4968,'Virgo','Virgo',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'setarray .@skills$, "AL_HEAL", "PR_SANCTUARY", "AM_POTIONPITCHER", "AB_HIGHNESSHEAL", "AB_CHEAL"; for( .@i = 0; .@i < getarraysize(.@skills$); .@i++ ){ bonus2 bSkillHeal,.@skills$[.@i],1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4969,'Libra','Libra',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'setarray .@skills$, "AL_HEAL", "PR_SANCTUARY", "AM_POTIONPITCHER", "AB_HIGHNESSHEAL", "AB_CHEAL"; for( .@i = 0; .@i < getarraysize(.@skills$); .@i++ ){ bonus2 bSkillHeal2,.@skills$[.@i],1; } /* TODO: Depending on some recovery items HP recovery amount + 1% */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4970,'Fire_Property_Reactor','Fire Property Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Fire;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4971,'Water_Property_Reactor','Water Property Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Water;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4972,'Earth_Property_Reactor','Earth Property Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Earth;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4973,'Wind_Property_Reactor','Wind Property Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDefEle,Ele_Wind;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4974,'Fire_Resistance_Reactor','Fire Resistance Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Fire,25; bonus2 bSubEle,Ele_Water,-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4975,'Water_Resistance_Reactor','Water Resistance Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Water,25; bonus2 bSubEle,Ele_Wind,-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4976,'Earth_Resistance_Reactor','Earth Resistance Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Earth,25; bonus2 bSubEle,Ele_Fire,-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4977,'Wind_Resistance_Reactor','Wind Resistance Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSubEle,Ele_Wind,25; bonus2 bSubEle,Ele_Earth,-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4978,'Recovery_Reactor_101','Recovery Reactor 101',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'if (getrefine()>=7) bonus2 bHPRegenRate,100,5000; else bonus2 bHPRegenRate,50,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4979,'Recovery_Reactor_102','Recovery Reactor 102',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'if (getrefine()>=7) bonus2 bSPRegenRate,5,5000; else bonus2 bHPRegenRate,3,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4980,'Recovery_Reactor_201','Recovery Reactor 201',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'if (getrefine()>=7) bonus2 bRegenPercentHP,100,5000; else bonus2 bRegenPercentHP,50,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4981,'Recovery_Reactor_202','Recovery Reactor 202',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'if (getrefine()>=7) bonus2 bRegenPercentSP,100,5000; else bonus2 bRegenPercentSP,50,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4982,'STR_Supplement_Reactor','STR Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'if (getrefine()>=7) { .@bonus = 10; } bonus bBaseAtk,.@bonus + 5*(readparam(bStr)/10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4983,'INT_Supplement_Reactor','INT Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'if (getrefine()>=7) { .@bonus = 10; } bonus bMatk,.@bonus + 5*(readparam(bInt)/10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4984,'DEF_Supplement_Reactor','DEF SupplementReactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDef,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4985,'PD_Supplement_Reactor','PD Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4986,'Attack_Supplement_Reactor','Attack Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bBaseAtk,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4987,'Magic_Supplement_Reactor','Magic Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatk,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4988,'HP_Supplement_Reactor','HP Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4989,'SP_Supplement_Reactor','SP Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxSPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4990,'Frozen_Supplement_Reactor','Frozen Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bResEff,Eff_Freeze,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4991,'ASPD_Supplement_Reactor','ASPD Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAspd,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4992,'HPAbsorb1_Supplement_Reactor','HP Absorb Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bHPDrainRate,10,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4993,'SPAbsorb1_Supplement_Reactor','SP Absorb Supplement Reactor',6,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bSPDrainRate,10,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4994,'Rune_of_Strength_Lv_1','Rune of Strength Lv 1',6,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'.@r = getrefine(); if (.@r>=7) { bonus bStr,5; } if (.@r>=10) { bonus2 bAddClass,Class_All,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4995,'Rune_of_Strength_Lv_2','Rune of Strength Lv 2',6,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'.@r = getrefine(); if (.@r>=7) { bonus bStr,6; } if (.@r>=11) { bonus bStr,1; bonus2 bAddClass,Class_All,7; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4996,'Rune_of_Strength_Lv_3','Rune of Strength_Lv 3',6,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'.@r = getrefine(); if (.@r>=7) { bonus bStr,7; } if (.@r>=12) { bonus bStr,1; bonus2 bAddClass,Class_All,8; } if (.@r>=13) { bonus bStr,1; bonus2 bAddClass,Class_All,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4997,'Rune_of_Agility_Lv_1','Rune of Agility Lv 1',6,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'.@r = getrefine(); if (.@r>=7) { bonus bAgi,5; } if (.@r>=10) { bonus bFlee2,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4998,'Rune_of_Agility_Lv_2','Rune of Agility Lv 2',6,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'.@r = getrefine(); if (.@r>=7) { bonus bAgi,6; } if (.@r>=11) { bonus bAgi,1; bonus bFlee2,7; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (4999,'Rune_of_Agility_Lv_3','Rune of Agility Lv 3',6,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'.@r = getrefine(); if (.@r>=7) { bonus bAgi,7; } if (.@r>=12) { bonus bAgi,1; bonus bFlee2,5; } if (.@r>=13) { bonus bAgi,1; bonus bFlee2,5; }',NULL,NULL);
#===================================================================
# More Headgears
#===================================================================
REPLACE INTO `item_db_re` VALUES (5001,'Headset','Headset',4,20,NULL,200,NULL,6,NULL,0,0xFFFFFFFE,63,2,256,NULL,'1',1,87,'bonus2 bResEff,Eff_Curse,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5002,'Gemmed_Crown','Jewel Crown',4,20,NULL,600,NULL,9,NULL,0,0x000654E2,63,2,256,NULL,'60',1,88,'bonus bInt,2; bonus bLuk,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5003,'Joker_Jester','Joker Jester',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,89,'bonus bLuk,2; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5004,'Oxygen_Mask','Oxygen Mask',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,63,2,1,NULL,'0',0,90,'bonus2 bResEff,Eff_Poison,2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5005,'Gas_Mask','Gas Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,513,NULL,'0',0,91,'bonus2 bResEff,Eff_Poison,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5006,'Machoman_Glasses','Machoman\'s Glasses',4,36000,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,512,NULL,'0',0,92,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5007,'Loard_Circlet','Grand Circlet',4,20,NULL,200,NULL,7,NULL,0,0xFFFFFFFE,63,2,256,NULL,'55',1,93,'bonus bStr,1; bonus bInt,1; bonus bLuk,1; bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5008,'Puppy_Love','Puppy Love',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,94,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5009,'Safety_Helmet','Safety Helmet',4,20,NULL,500,NULL,7,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,95,'bonus bMdef,3; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5010,'Indian_Hair_Piece','Indian Fillet',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,96,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5011,'Antenna','Aerial',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,97,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5012,'Ph.D_Hat','Ph.D Hat',4,20,NULL,200,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,98,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5013,'Horn_Of_Lord_Kaho','Lord Kaho\'s Horn',4,20,NULL,100,NULL,30,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,99,'bonus bMdef,10; bonus bStr,5; bonus bAgi,10; bonus bVit,10; bonus bInt,5; bonus bLuk,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5014,'Fin_Helm','Fin Helm',4,20,NULL,300,NULL,5,NULL,0,0x00004082,63,2,512,NULL,'65',0,100,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5015,'Egg_Shell','Egg Shell',4,20,NULL,200,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,101,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5016,'Boy\'s_Cap','Boy\'s Cap',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,102,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5017,'Bone_Helm','Bone Helm',4,20,NULL,800,NULL,15,NULL,0,0x000444A2,63,2,256,NULL,'70',1,103,'bonus2 bSubEle,Ele_Dark,-15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5018,'Feather_Bonnet','Feather Bonnet',4,20,NULL,300,NULL,8,NULL,0,0x00080808,63,2,256,NULL,'0',1,104,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5019,'Corsair','Corsair',4,20,NULL,500,NULL,11,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,105,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5020,'Kafra_Band','Kafra Band',4,20,NULL,500,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,106,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5021,'Bankruptcy_Of_Heart','Grief for Greed',4,20,NULL,1200,NULL,8,NULL,0,0x00040420,63,2,256,NULL,'38',1,107,'bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5022,'Helm_Of_Sun','Hat of the Sun God',4,20,NULL,2400,NULL,4,NULL,0,0x00CFDF80,63,2,768,NULL,'0',1,138,'bonus bStr,3; bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5023,'Hat_Of_Bundle','Parcel Hat',4,20,NULL,1000,NULL,0,NULL,0,0x00040420,63,2,256,NULL,'0',1,108,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5024,'Hat_Of_Cake','Cake Hat',4,20,NULL,1000,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,109,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5025,'Helm_Of_Angel','Helm of Angel',4,20,NULL,1600,NULL,10,NULL,0,0x00CFDF80,63,2,256,NULL,'74',1,110,'bonus bAgi,1; bonus bLuk,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5026,'Hat_Of_Cook','Chef Hat',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'50',1,111,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5027,'Wizardry_Hat','Mage Hat',4,20,NULL,300,NULL,2,NULL,0,0x00810204,63,2,256,NULL,'0',1,112,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5028,'Candle','Candle',4,20,NULL,150,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,113,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5029,'Spore_Hat','Spore Hat',4,20,NULL,900,NULL,6,NULL,0,0xFFFFFFFE,63,2,256,NULL,'20',1,114,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5030,'Panda_Cap','Panda Hat',4,20,NULL,800,NULL,6,NULL,0,0xFFFFFFFE,63,2,256,NULL,'40',1,115,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5031,'Mine_Helm','Mine Hat',4,20,NULL,1500,NULL,9,NULL,0,0x0006D5F2,63,2,256,NULL,'55',1,116,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5032,'Picnic_Hat','Sunday Hat',4,20,NULL,800,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,117,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5033,'Smokie_Hat','Raccoon Hat',4,20,NULL,900,NULL,6,NULL,0,0xFFFFFFFE,63,2,256,NULL,'50',1,118,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5034,'Light_Bulb_Band','Bulb Band',4,20,NULL,500,NULL,0,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,119,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5035,'Poring_Hat','Poring Hat',4,20,NULL,700,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'38',1,120,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5036,'Cross_Band','Cross Hat',4,20,NULL,250,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'10',1,121,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5037,'Fruit_Shell','Nut Shell',4,20,NULL,150,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'5',0,122,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5038,'Deviruchi_Cap','Deviruchi Hat',4,20,NULL,800,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'64',1,123,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5039,'Mottled_Egg_Shell','Rainbow Eggshell',4,20,NULL,400,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'19',0,124,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5040,'Blush','Blush',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,125,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5041,'Heart_Hair_Pin','Heart Hairpin',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,126,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5042,'Hair_Protector','Bao Bao',4,20,NULL,150,NULL,0,NULL,0,0xFFFFFFFE,63,2,256,NULL,'14',1,127,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5043,'Opera_Ghost_Mask','Opera Phantom Mask',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,63,2,512,NULL,'20',0,128,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5044,'Devil\'s_Wing','Evil Wing Ears',4,20,NULL,350,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'45',1,129,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5045,'Magician_Hat','Magician Hat',4,20,NULL,500,NULL,6,NULL,0,0x00818314,63,2,256,NULL,'50',1,130,'bonus bDex,1; bonus bAgi,1; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5046,'Bongun_Hat','Bongun Hat',4,20,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,63,2,769,NULL,'0',0,139,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5047,'Fashion_Sunglass','Fashionable Glasses',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,131,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5048,'First_Moon_Hair_Pin','Cresent Hairpin',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,132,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5049,'Stripe_Band','Striped Hairband',4,20,NULL,150,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,133,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5050,'Mystery_Fruit_Shell','Wonder Nutshell',4,20,NULL,300,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',0,134,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5051,'Kitty_Bell','Pussy Cat Bell',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,135,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5052,'Blue_Hair_Band','Blue Hairband',4,20,NULL,150,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,136,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5053,'Spinx_Helm','Sphinx Hat',4,20,NULL,3000,NULL,5,NULL,0,0x00004082,63,2,257,NULL,'65',0,137,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5054,'Assassin_Mask','Assassin Mask',4,20,NULL,100,NULL,0,NULL,0,0x00001100,63,2,1,NULL,'70',0,180,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5055,'Novice_Egg_Cap','Novice False Eggshell',4,1,NULL,1,NULL,6,NULL,0,0x00000001,63,2,256,NULL,'0',0,101,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5056,'Love_Berry','Fruit of Love',4,1,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,140,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5057,'Ear_Of_Black_Cat','Black Cat Ears',4,16000,NULL,200,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'45',1,141,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5058,'Drooping_Kitty','Drooping Cat',4,250000,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,142,'bonus bMdef,15; bonus2 bResEff,Eff_Curse,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5059,'Brown_Bear_Cap','Teddybear Hat',4,20,NULL,800,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,143,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5060,'Party_Hat','Party Hat',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,144,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5061,'Flower_Hairpin','Flower Hairpin',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,145,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5062,'Straw_Hat','Straw Hat',4,20,NULL,200,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,146,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5063,'Plaster','Giant Band Aid',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,147,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5064,'Leaf_Headgear','Smokie Leaf',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,148,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5065,'Fish_On_Head','Blue Fish',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,149,'bonus2 bAddRace,RC_Fish,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5066,'Horn_Of_Succubus','Succubus Horn',4,20,NULL,800,NULL,7,NULL,0,0xFFFFFFFE,63,2,256,NULL,'70',1,150,'bonus bInt,1; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5067,'Sombrero','Sombrero',4,20,NULL,350,NULL,8,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,151,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5068,'Ear_Of_Devil\'s_Wing','Evil Wing Ears',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,152,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5069,'Mask_Of_Fox','Kitsune Mask',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,153,'bonus bAgi,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5070,'Headband_Of_Power','Hot-blooded Headband',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,154,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5071,'Indian_Headband','Indian Headband',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,155,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5072,'Inccubus_Horn','Incubus Horn',4,20,NULL,800,NULL,7,NULL,0,0xFFFFFFFE,63,2,256,NULL,'70',1,156,'bonus bAgi,1; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5073,'Cap_Of_Concentration','Model Training Hat',4,20,NULL,700,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,157,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5074,'Ear_Of_Angel\'s_Wing','Angel Wing Ears',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,158,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5075,'Cowboy_Hat','Cowboy Hat',4,20,NULL,500,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,159,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5076,'Fur_Hat','Beanie',4,20,NULL,350,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,160,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5077,'Tulip_Hairpin','Tulip Hairpin',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,161,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5078,'Sea_Otter_Cap','Sea-Otter Hat',4,20,NULL,800,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,162,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5079,'Crossed_Hair_Band','X Hairpin',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,163,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5080,'Headgear_Of_Queen','Crown of Ancient Queen',4,20,NULL,400,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'45',1,164,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5081,'Mistress_Crown','Crown of Mistress',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'75',1,165,'bonus bMaxSP,100; bonus bInt,2; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5082,'Mushroom_Band','Decorative Mushroom',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,166,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5083,'Red_Tailed_Ribbon','Red Ribbon',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'45',1,167,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5084,'Lazy_Raccoon','Lazy Smokie',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,168,'bonus2 bResEff,Eff_Sleep,2000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5085,'Pair_Of_Red_Ribbon','Small Ribbons',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'45',0,169,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5086,'Alarm_Mask','Alarm Mask',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFE,63,2,513,NULL,'0',0,170,'bonus2 bResEff,Eff_Blind,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5087,'Goblin_Mask_01','Poker Face',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,513,NULL,'0',0,171,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5088,'Goblin_Mask_02','Surprised Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,513,NULL,'0',0,172,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5089,'Goblin_Mask_03','Annoyed Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,513,NULL,'0',0,173,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5090,'Goblin_Mask_04','Goblin Leader Mask',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,513,NULL,'0',0,174,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5091,'Big_Golden_Bell','Decorative Golden Bell',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,63,2,768,NULL,'35',1,175,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5092,'Blue_Coif','Coif',4,150000,NULL,300,NULL,5,NULL,0,0x00001100,63,2,768,NULL,'65',1,176,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5093,'Blue_Coif_','Coif',4,150000,NULL,300,NULL,5,NULL,1,0x00001100,63,2,768,NULL,'65',1,177,'bonus bMaxSP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5094,'Orc_Hero_Helm','Helmet of Orc Hero',4,500000,NULL,900,NULL,5,NULL,0,0xFFFFFFFE,63,2,768,NULL,'55',1,178,'bonus bStr,2; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5095,'Orc_Hero_Helm_','Helmet of Orc Hero',4,800000,NULL,1000,NULL,5,NULL,1,0xFFFFFFFE,63,2,768,NULL,'55',1,179,'bonus bStr,2; bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5096,'Assassin_Mask_','Assassin Mask',4,20,NULL,100,NULL,1,NULL,0,0x00001100,63,2,1,NULL,'70',0,180,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5097,'Cone_Hat_','Holiday Hat',4,0,NULL,400,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,144,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5098,'Tiger_Mask','Tiger Mask',4,20,NULL,400,NULL,2,NULL,0,0xFFFFFFFF,63,2,768,NULL,'50',0,181,'bonus bStr,3; bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5099,'Cat_Hat','Neko Mimi',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,182,'bonus bLuk,2; bonus bMdef,10; bonus2 bSubRace,RC_Brute,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5100,'Sales_Signboard','Sales Banner',4,20,NULL,800,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'75',1,183,'bonus bStr,1; bonus bAgi,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5101,'Takius_Blindfold','Takius\'s Blindfold',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,184,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5102,'Round_Eyes','Blank Eyes',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,185,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5103,'Sunflower_Hairpin','Sunflower Hairpin',4,20,NULL,600,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'30',0,186,'bonus bAgi,2; bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5104,'Dark_Blindfold','Dark Blinder',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,512,NULL,'0',0,187,'bonus2 bResEff,Eff_Blind,10000; bonus2 bResEff,Eff_Stun,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5105,'Hat_Of_Cake_','2nd Anniversary Hat',4,20,NULL,1000,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'24',1,109,'bonus bDex,1; bonus bMaxSP,80; bonus3 bAddMonsterDropItem,7864,7,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5106,'Cone_Hat_INA','2nd Anniversary Hat',4,20,NULL,300,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',0,144,'bonus bLuk,1; bonus bMatkRate,3; bonus bFlee,3; bonus bHit,3; bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5107,'Well_Baked_Toast','Crunch Toast',4,20,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,188,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5108,'Detective_Hat','Renown Detective\'s Cap',4,20,NULL,350,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,189,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5109,'Red_Bonnet','Red Bonnet',4,20,NULL,400,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,190,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5110,'Baby_Pacifier','Baby Pacifier',4,20,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,191,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5111,'Galapago_Cap','Galapago Cap',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'55',1,192,'bonus2 bAddMonsterDropItem,605,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5112,'Super_Novice_Hat','Super Novice Hat',4,8500,NULL,400,NULL,8,NULL,0,0x00000001,63,2,256,NULL,'40',1,193,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5113,'Angry_Mouth','Angry Snarl',4,20,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,194,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5114,'Fedora','Bucket Hat',4,6000,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,195,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5115,'Winter_Hat','Winter Hat',4,20,NULL,500,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,196,'bonus2 bResEff,Eff_Freeze,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5116,'Banana_Hat','Banana Hat',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,197,'bonus3 bAutoSpell,"SM_PROVOKE",3,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5117,'Mistic_Rose','Mystic Rose',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,198,'bonus2 bSubRace,RC_Plant,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5118,'Ear_Of_Puppy','Puppy Headband',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,199,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5119,'Super_Novice_Hat_','Super Novice Hat',4,8500,NULL,400,NULL,8,NULL,1,0x00000001,63,2,256,NULL,'40',1,193,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5120,'Fedora_','Bucket Hat',4,6000,NULL,300,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,195,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5121,'Zherlthsh_Mask','Zealotus Mask',4,20,NULL,400,NULL,3,NULL,0,0xFFFFFFFE,63,2,768,NULL,'70',1,200,'bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5122,'Magni_Cap','Magni\'s Cap',4,30000,NULL,1000,NULL,9,NULL,0,0xFFFFFFFE,63,2,256,NULL,'65',1,250,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5123,'Ulle_Cap','Ulle\'s Cap',4,30000,NULL,500,NULL,6,NULL,1,0xFFFFFFFE,63,2,256,NULL,'65',1,254,'bonus bDex,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5124,'Fricca_Circlet','Fricca\'s Circlet',4,30000,NULL,300,NULL,6,NULL,0,0xFFFFFFFE,63,2,256,NULL,'65',1,251,'bonus bMdef,10; bonus bInt,2; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5125,'Kiss_Of_Angel','Angel\'s Kiss',4,10000,NULL,300,NULL,6,NULL,1,0x00000001,63,2,256,NULL,'50',1,255,'bonus bSPrecovRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5126,'Morpheus\'s_Hood','Morpheus\'s Hood',4,30000,NULL,200,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'33',1,256,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5127,'Morrigane\'s_Helm','Morrigane\'s Helm',4,30000,NULL,500,NULL,8,NULL,0,0xFFFFFFFE,63,2,256,NULL,'61',1,257,'bonus bLuk,2; bonus bBaseAtk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5128,'Goibne\'s_Helmet','Goibne\'s Helm',4,30000,NULL,500,NULL,10,NULL,0,0xFFFFFFFE,63,2,256,NULL,'54',1,258,'bonus bVit,3; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5129,'Bird_Nest','Bird Nest',4,20,NULL,400,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'55',0,201,'bonus bAgi,2; bonus2 bSubRace,RC_Brute,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5130,'Lion_Mask','Lion Mask',4,20,NULL,700,NULL,0,NULL,0,0x00CFDF80,63,2,768,NULL,'75',1,202,'bonus2 bAddEffWhenHit,Eff_Silence,500; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5131,'Close_Helmet','Close Helmet',4,20,NULL,1200,NULL,8,NULL,0,0x00004082,63,2,769,NULL,'75',1,203,'bonus bVit,3; bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5132,'Angeling_Hat','Angeling Hat',4,20,NULL,700,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,204,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5133,'Sheep_Hat','Sheep Hat',4,20,NULL,150,NULL,3,NULL,0,0x00008110,63,2,256,NULL,'0',0,205,'bonus bShortWeaponDamageReturn,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5134,'Pumpkin_Hat','Pumpkin-Head',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,206,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5135,'Cyclops_Visor','Cyclop\'s Eye',4,0,NULL,200,NULL,0,NULL,0,0xFFFFFFFE,63,2,512,NULL,'75',0,207,'bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5136,'Santa\'s_Hat_','Antonio\'s Santa Hat',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,20,'bonus3 bAutoSpellWhenHit,"PR_GLORIA",5,50; bonus3 bAutoSpellWhenHit,"AL_BLESSING",10,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5137,'Alice_Doll','Alice Doll',4,20,NULL,500,NULL,1,NULL,1,0xFFFFFFFE,63,2,256,NULL,'30',0,208,'bonus bStr,1; bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus2 bAddEff2,Eff_Sleep,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5138,'Magic_Eyes','Magic Eyes',4,20,NULL,300,NULL,3,NULL,0,0x00810204,63,2,256,NULL,'30',1,209,'bonus bMdef,5; bonus bVariableCastrate,-10; bonus bUseSPrate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5139,'Hibiscus','Hibiscus',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',0,210,'bonus bDex,1; bonus bInt,1; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5140,'Charming_Ribbon','Charming Ribbon',4,20,NULL,400,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'10',1,211,'bonus2 bSubRace,RC_Undead,5; bonus2 bSubRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5141,'Marionette_Doll','Marionette Doll',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFE,63,2,256,NULL,'30',1,212,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5142,'Crescent_Helm','Crescent Helm',4,20,NULL,3000,NULL,20,NULL,1,0x000444A2,63,2,768,NULL,'50',1,213,'bonus bVit,1; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5143,'Kabuki_Mask','Kabuki Mask',4,20,NULL,1000,NULL,5,NULL,1,0xFFFFFFFE,63,1,769,NULL,'30',1,214,'bonus2 bResEff,Eff_Silence,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5144,'Gambler_Hat','Gambler Hat',4,20,NULL,200,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,16,'bonus bLuk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5145,'Carnival_Joker_Jester','Carnival Joker Jester',4,10,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,89,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5146,'Elephant_Hat','Elephant Hat',4,0,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,215,'bonus bVit,1; bonus2 bSubRace,RC_Brute,7; skill "WZ_WATERBALL",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5147,'Baseball_Cap','Baseball Cap',4,0,NULL,200,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,216,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5148,'Phrygian_Cap','Phrygian Cap',4,0,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,217,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5149,'Silver_Tiara','Silver Tiara',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,218,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5150,'Joker_Jester_','Joker Jester',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,219,'bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5151,'Headset_OST','Note Headphones',4,20,NULL,200,NULL,4,NULL,1,0xFFFFFFFF,63,2,768,NULL,'0',1,220,'bonus bMdef,3; bonus2 bResEff,Eff_Stun,1000; bonus2 bResEff,Eff_Freeze,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5152,'Chinese_Crown','Chinese Crown',4,20,NULL,2000,NULL,2,NULL,0,0xFFFFFFFF,63,2,768,NULL,'1',1,221,'bonus2 bResEff,Eff_Stun,1000; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5153,'Angeling_Hairpin','Angeling Hairpin',4,20,NULL,700,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,222,'bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5154,'Sunglasses_F','Father\'s Sunglasses',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5155,'Granpa_Beard_F','Father\'s White Moustache',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,25,'bonus bBaseAtk,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5156,'Flu_Mask_F','Father\'s Mask',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,8,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5157,'Viking_Helm_','Orc Helm',4,20,NULL,500,NULL,9,NULL,1,0x000654E2,63,2,256,NULL,'0',1,86,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5158,'Holy_Bonnet_','Monk Hat',4,30000,NULL,100,NULL,10,NULL,1,0x00008110,63,2,256,NULL,'0',1,35,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5159,'Golden_Gear_','Golden Gear',4,20,NULL,900,NULL,9,NULL,1,0xFFFFFFFE,63,2,256,NULL,'40',1,30,'bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5160,'Magestic_Goat_','Majestic Goat',4,20,NULL,800,NULL,9,NULL,1,0x006444A2,63,2,256,NULL,'0',1,41,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5161,'Sharp_Gear_','Spiky Band',4,20,NULL,1000,NULL,12,NULL,1,0x0066D5F2,63,2,256,NULL,'50',1,43,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5162,'Bone_Helm_','Bone Helm',4,20,NULL,800,NULL,15,NULL,1,0x000444A2,63,2,256,NULL,'70',1,103,'bonus2 bSubEle,Ele_Dark,-15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5163,'Corsair_','Corsair',4,20,NULL,500,NULL,10,NULL,1,0xFFFFFFFE,63,2,256,NULL,'0',1,105,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5164,'Tiara_','Tiara',4,20,NULL,400,NULL,7,NULL,1,0xFFFFFFFE,63,0,256,NULL,'45',1,19,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5165,'Crown_','Crown',4,20,NULL,400,NULL,7,NULL,1,0xFFFFFFFE,63,1,256,NULL,'45',1,45,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5166,'Spinx_Helm_','Sphinx Hat',4,20,NULL,3000,NULL,5,NULL,1,0x00004082,63,2,257,NULL,'65',0,137,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5167,'Munak_Turban_','Munak Hat',4,20,NULL,300,NULL,5,NULL,1,0xFFFFFFFF,63,2,769,NULL,'0',0,51,'bonus2 bSubRace,RC_Undead,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5168,'Bongun_Hat_','Bongun Hat',4,20,NULL,300,NULL,5,NULL,1,0xFFFFFFFF,63,2,769,NULL,'0',0,139,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5169,'Bride_Mask','Bride Mask',4,30000,NULL,500,NULL,4,NULL,1,0xFFFFFFFF,63,2,768,NULL,'40',1,223,'if(BaseClass==Job_Taekwon){ bonus bLuk,2; bonus bCritical,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5170,'Feather_Beret','Feather Beret',4,30000,NULL,600,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,224,'bonus bMdef,1; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5171,'Valkyrie_Helm','Valkyrie Helm',4,100000,NULL,1000,NULL,10,NULL,1,0xFFFFFFFE,18,2,256,NULL,'0',1,225,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5172,'Beret','Beret',4,30000,NULL,700,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,226,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5173,'Satto_Hat','Magistrate Hat',4,30000,NULL,400,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',1,227,'if(BaseClass==Job_Taekwon){ bonus bAgi,1; bonus bHPrecovRate,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5174,'Ayam','Ayam',4,30000,NULL,400,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',1,228,'if(BaseClass==Job_Taekwon){ bonus bInt,1; bonus bSPrecovRate,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5175,'Censor_Bar','Censor Bar',4,30000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,229,'bonus2 bResEff,Eff_Curse,500; bonus bMdef,1; bonus bHit,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5176,'Hahoe_Mask','Hahoe Mask',4,30000,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,513,NULL,'30',0,230,'if(BaseClass==Job_Taekwon){ bonus bLuk,1; bonus bFlee2,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5177,'Guardian_Lion_Mask','Mythical Lion Mask',4,30000,NULL,500,NULL,5,NULL,1,0xFFFFFFFF,63,2,768,NULL,'40',1,231,'if(BaseClass==Job_Taekwon){ bonus bDex,2; bonus bBaseAtk,2*getrefine(); bonus3 bAddEff,Eff_Stun,1000,ATF_SHORT; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5178,'Candle_','Candle',4,20,NULL,150,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,113,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5179,'Gold_Tiara','Golden Tiara',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,232,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5180,'Phrygian_Cap_','France Holiday Hat',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,217,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5181,'Helm_Of_Darkness','Helm of Darkness',4,20,NULL,500,NULL,3,NULL,1,0x000654E2,63,2,768,NULL,'50',1,233,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5182,'Puppy_Hat','Puppy Hat',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',0,234,'bonus bAgi,1; bonus3 bAutoSpell,"PR_GLORIA",1,10+20*(readparam(bAgi)>=77);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5183,'Bird_Nest_Hat','Bird Nest Hat',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,235,'bonus bDex,1; bonus bAgi,1; bonus2 bResEff,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5184,'Captain_Hat','Captain\'s Hat',4,20,NULL,500,NULL,8,NULL,0,0xFFFFFFFE,63,2,256,NULL,'30',1,236,'bonus2 bSubEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5185,'Laurel_Wreath','Laurel Wreath',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'10',1,237,'bonus bLuk,3; bonus2 bResEff,Eff_Blind,500; bonus2 bResEff,Eff_Curse,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5186,'Geographer_Band','Geographer Band',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',0,238,'bonus bInt,1; bonus3 bAutoSpellWhenHit,"AL_HEAL",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5187,'Twin_Ribbon','Twin Ribbon',4,20,NULL,200,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,239,'bonus bMaxSP,30; bonus bMdef,3; bonus3 bAutoSpellWhenHit,"NPC_STONESKIN",6,10; bonus5 bAutoSpellWhenHit,"NPC_ANTIMAGIC",6,120,BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5188,'Minstrel_Hat','Wandering Minstrel Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,240,'bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5189,'Fallen_Leaves','Autumn Leaves',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,241,'bonus bMaxHP,40; bonus bMaxSP,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5190,'Baseball_Cap_','Independence Memorial Hat',4,20,NULL,20,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,216,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5191,'Ribbon_Black','Black Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,0,256,NULL,'0',1,242,'bonus bInt,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5192,'Ribbon_Yellow','Yellow Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,0,256,NULL,'0',1,243,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5193,'Ribbon_Green','Green Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,0,256,NULL,'0',1,244,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5194,'Ribbon_Pink','Pink Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,0,256,NULL,'0',1,245,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5195,'Ribbon_Red','Red Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,0,256,NULL,'0',1,246,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5196,'Ribbon_Orange','Orange Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,0,256,NULL,'0',1,247,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5197,'Ribbon_White','White Ribbon',4,800,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,0,256,NULL,'0',1,248,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5198,'Drooping_Bunny','Drooping Bunny',4,10,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,249,'bonus bDex,1; bonus bFlee,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5199,'Baseball_Cap_I','Baseball Cap',4,0,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,216,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5200,'Coppola','Coppola',4,10,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,252,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5201,'Party_Hat_B','Party Hat',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,144,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5202,'Pumpkin_Hat_','Fantastic Pumpkin-Head',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,206,'bonus2 bSubRace,RC_Demon,5; bonus3 bAddMonsterDropItem,529,RC_DemiHuman,1500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5203,'Tongue_Mask','Smiling Mask',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,63,2,513,NULL,'0',0,253,'bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5204,'Event_Pierrot_Nose','Rudolph\'s Nose',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,49,'bonus2 bResEff,Eff_Blind,3000; bonus2 bAddMonsterDropItem,12130,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5205,'Wreath','Emperor\'s Laurel Crown',4,20,NULL,1000,NULL,3,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',1,261,'bonus bAllStats,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5206,'Romantic_White_Flower','Romantic White Flower',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,1,NULL,'0',0,259,'bonus2 bSubRace,RC_Plant,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5207,'Gold_Spirit_Chain','Angel Blessing',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,260,'bonus bLuk,1; bonus2 bSubEle,Ele_Holy,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5208,'Rideword_Hat','Rideword Hat',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFE,63,2,256,NULL,'40',1,262,'.@i = (getrefine()>8)?2:1; bonus2 bHPDrainRate,50,8*.@i; bonus2 bSPDrainRate,10,4*.@i; bonus2 bHPLossRate,10,5000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5209,'Yellow_Baseball_Cap','Love Dad Cap',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,263,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5210,'Flying_Angel','Flapping Angel Wing',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,264,'bonus bVariableCastrate,-3; bonus bAspdRate,3; bonus bInt,1; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5211,'Dress_Hat','Dress Hat',4,0,NULL,200,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'20',1,265,'bonus bMdef,7; bonus bStr,1; bonus bInt,1; bonus2 bAddClass,Class_All,2; bonus bMatkRate,2; bonus bHealPower,5; if(getrefine()>=7) { bonus2 bAddClass,Class_All,1; bonus bMatkRate,1; bonus bHealPower,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5212,'Satellite_Hairband','Satellite Hairband',4,0,NULL,1000,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,266,'bonus bMaxHP,50; bonus bMaxSP,10; skill "AL_RUWACH",1;',NULL,'sc_end SC_RUWACH;');
REPLACE INTO `item_db_re` VALUES (5213,'Black_Bunny_Band','Sheila Hairnet',4,0,NULL,200,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,267,'bonus bAgi,2; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5214,'Moonlight_Flower_Hat','Moonlight Flower Hat',4,0,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,63,2,768,NULL,'1',1,268,'bonus bDex,2; bonus3 bAutoSpell,"AL_INCAGI",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5215,'Angelic_Chain_','Evolved Angel Wing',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,38,'bonus bMdef,3; bonus bDex,1; bonus bInt,1; bonus2 bSubRace,RC_Demon,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5216,'Satanic_Chain_','Evolved Evil Wing',4,20,NULL,100,NULL,6,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,39,'bonus bStr,1; bonus bAgi,1; bonus bFlee,3; bonus2 bSubRace,RC_Angel,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5217,'Magestic_Goat_TW','Evolved Majestic Goat',4,20,NULL,800,NULL,10,NULL,0,0x006444A2,63,2,256,NULL,'0',1,41,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5218,'Bunny_Band_','Evolved Bunny Band',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,15,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5219,'Drooping_Kitty_','Evolved Drooping Cat',4,250000,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,142,'bonus bMdef,18; bonus bFlee,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5220,'Smoking_Pipe_','Evolved Pipe',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,1,NULL,'0',0,55,'bonus bVit,1; bonus2 bSubRace,RC_Brute,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5221,'Pair_Of_Red_Ribbon_','Evolved Pair of Red Ribbon',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,0,512,NULL,'45',0,169,'bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5222,'Fish_On_Head_','Evolved Blue Fish',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,149,'bonus bAgi,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5223,'Big_Golden_Bell_','Evolved Big Golden Bell',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFE,63,2,768,NULL,'35',1,175,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5224,'Orc_Hero_Helm_TW','Evolved Orc Hero Helm',4,500000,NULL,900,NULL,5,NULL,0,0xFFFFFFFE,63,2,768,NULL,'55',1,178,'bonus bStr,2; bonus bVit,1; bonus bMaxHPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5225,'Marcher_Hat','Parade Hat',4,20,NULL,200,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'10',1,269,'bonus bMdef,2; bonus4 bAutoSpellWhenHit,"AL_ANGELUS",5,30,0; bonus4 bAutoSpellWhenHit,"HP_ASSUMPTIO",1,1,0; bonus2 bResEff,Eff_Stun,1000; if(BaseClass==Job_Acolyte) bonus4 bAutoSpellOnSkill,"AL_HEAL","PR_LEXAETERNA",1,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5226,'Mini_Propeller_','Mini Propeller',4,20,NULL,200,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,270,'bonus bAgi,2; bonus bDex,1; bonus bFlee,10; bonus bVariableCastrate,-getrefine();',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5227,'Red_Deviruchi_Cap','Red Deviruchi Hat',4,20,NULL,800,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'64',1,271,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5228,'White_Deviruchi_Cap','Gray Deviruchi Hat',4,20,NULL,800,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'64',1,272,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5229,'Gray_Deviruchi_Cap','Brown Deviruchi Hat',4,20,NULL,800,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'64',1,273,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5230,'White_Drooping_Kitty','Gray Drooping Cat',4,250000,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,274,'bonus2 bResEff,Eff_Curse,3000; bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5231,'Gray_Drooping_Kitty','Brown Drooping Cat',4,250000,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,275,'bonus2 bResEff,Eff_Curse,3000; bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5232,'Pink_Drooping_Kitty','Pink Drooping Cat',4,250000,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,276,'bonus2 bResEff,Eff_Curse,3000; bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5233,'Blue_Drooping_Kitty','Blue Drooping Cat',4,250000,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,277,'bonus2 bResEff,Eff_Curse,3000; bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5234,'Yellow_Drooping_Kitty','Yellow Drooping Cat',4,250000,NULL,500,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,278,'bonus2 bResEff,Eff_Curse,3000; bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5235,'Gray_Fur_Hat','Brown Beanie',4,20,NULL,350,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,279,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5236,'Blue_Fur_Hat','Blue Beanie',4,20,NULL,350,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,280,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5237,'Pink_Fur_Hat','Pink Beanie',4,20,NULL,350,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,281,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5238,'Red_Wizardry_Hat','Red Mage Hat',4,20,NULL,300,NULL,2,NULL,0,0x00810204,63,2,256,NULL,'0',1,282,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5239,'White_Wizardry_Hat','Gray Mage Hat',4,20,NULL,300,NULL,2,NULL,0,0x00810204,63,2,256,NULL,'0',1,283,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5240,'Gray_Wizardry_Hat','Brown Mage Hat',4,20,NULL,300,NULL,2,NULL,0,0x00810204,63,2,256,NULL,'0',1,284,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5241,'Blue_Wizardry_Hat','Blue Mage Hat',4,20,NULL,300,NULL,2,NULL,0,0x00810204,63,2,256,NULL,'0',1,285,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5242,'Yellow_Wizardry_Hat','Yellow Mage Hat',4,20,NULL,300,NULL,2,NULL,0,0x00810204,63,2,256,NULL,'0',1,286,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5243,'Chullos','Shafka',4,20,NULL,800,NULL,2,NULL,1,0xFFFFFFFF,63,2,768,NULL,'0',1,287,'bonus2 bResEff,Eff_Freeze,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5244,'Elven_Blindfold','Elven Blindfold',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,288,'bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5245,'Elven_Sunglasses','Elven Sunglasses',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,289,'bonus2 bResEff,Eff_Blind,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5246,'Angelic_Helm','Angelic Helm',4,20,NULL,700,NULL,7,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,290,'bonus bAgi,1; bonus bLuk,1; bonus bMdef,3; bonus2 bSubRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5247,'Satanic_Helm','Satanic Helm',4,20,NULL,700,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,291,'bonus bAgi,1; bonus bLuk,1; bonus bMdef,3; bonus2 bSubRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5248,'Robotic_Blindfold','Robotic Blindfold',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,292,'bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5249,'Human_Blindfold','Human Blindfold',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,293,'bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5250,'Robotic_Ears','Robotic Ears',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,294,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5251,'Round_Ears','Round Ears',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,295,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5252,'Drooping_Nine_Tail','Drooping Ninetail',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'20',1,296,'bonus bAgi,1; bonus bDex,1; bonus3 bAutoSpellWhenHit,"PR_GLORIA",1,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5253,'Lif_Doll_Hat','Lif Doll Hat',4,20,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'20',1,297,'bonus bInt,1; .@r = getrefine(); bonus bMdef,.@r; bonus bDef,.@r*-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5254,'Deviling_Hat','Deviling Hat',4,20,NULL,500,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'20',1,298,'bonus bBaseAtk,2; bonus bMatk,2; if(getrefine()>=7) bonus2 bExpAddRace,RC_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5255,'Triple_Poring_Hat','Triple Poring Hat',4,20,NULL,600,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'20',0,299,'bonus bLuk,3; bonus3 bAutoSpell,"BS_GREED",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5256,'Valkyrie_Feather_Band','Valkyrie Feather Band',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'20',1,300,'bonus bInt,1; bonus3 bAutoSpellWhenHit,"AL_HEAL",1,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5257,'Soulless_Wing','Soul Ring',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'20',1,301,'bonus bMdef,2; bonus3 bAutoSpellWhenHit,"HP_ASSUMPTIO",1,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5258,'Afro_Wig','Afro Wig',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,768,NULL,'10',1,302,'bonus3 bAutoSpellWhenHit,"NV_FIRSTAID",1,300; bonus2 bSubEle,Ele_Neutral,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5259,'Elephant_Hat_','Elephant Hat',4,20,NULL,500,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,215,'bonus bVit,1; bonus3 bAutoSpell,"WZ_WATERBALL",3,10; skill "AL_HOLYWATER",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5260,'Cookie_Hat','Cookie Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,217,'bonus bAgi,1; bonus bFlee2,5; bonus bCritAtkRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5261,'Silver_Tiara_','Silver Tiara',4,20,NULL,500,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,218,'bonus bInt,2; if(BaseClass==Job_Mage) bonus bMatkRate,(JobLevel/20); if(Baseclass==Job_Acolyte) bonus bUseSPrate,-(JobLevel/10); if(BaseClass==Job_Archer) bonus bMaxSP,(JobLevel*2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5262,'Gold_Tiara_','Golden Tiara',4,20,NULL,500,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,232,'bonus bStr,2; bonus bUnbreakableHelm; if((readparam(bDex)<56)&&(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief)) bonus bDex,JobLevel/7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5263,'Ati_Atihan_Hat','Pagdayaw',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,769,NULL,'20',1,303,'bonus2 bSubEle,Ele_Water,1; bonus2 bSubEle,Ele_Fire,1; bonus2 bSubEle,Ele_Wind,1; bonus2 bAddEff,Eff_Curse,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5264,'Aussie_Flag_Hat','Australian Flag Hat',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,304,'bonus bAllStats,2;','specialeffect2 EF_GHOST; specialeffect2 EF_BAT; specialeffect2 EF_BAT2;',NULL);
REPLACE INTO `item_db_re` VALUES (5265,'Apple_Of_Archer_C','Apple of Archer',4,1,NULL,0,NULL,12,NULL,0,0xFFFFFFFE,63,2,256,NULL,'1',0,72,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5266,'Bunny_Band_C','Bunny Band',4,1,NULL,0,NULL,13,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',0,15,'bonus bMdef,5; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5267,'Sahkkat_C','Sakkat',4,1,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,67,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5268,'Lord_Circlet_C','Grand Circlet',4,1,NULL,0,NULL,14,NULL,0,0xFFFFFFFE,63,2,256,NULL,'1',0,93,'bonus bStr,3; bonus bInt,3; bonus bLuk,3; bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5269,'Flying_Angel_','Flapping Angel Wing',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,264,'bonus bInt,1; bonus bAgi,1; bonus bAspdRate,3; bonus bVariableCastrate,-3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5270,'Fallen_Leaves_','Autumn Leaves',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,241,'bonus bFlee2,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5271,'Chinese_Crown_','Phoenix Crown',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFF,63,2,768,NULL,'0',1,221,'bonus bMdef,3; bonus2 bSubClass,Class_Boss,getrefine();',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5272,'Tongue_Mask_','Tongue Mask',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,513,NULL,'0',0,253,'bonus3 bAutoSpell,"SM_PROVOKE",5,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5273,'Happy_Wig','Happy Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',1,305,'bonus bSpeedRate,25; bonus bDef,4; skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db_re` VALUES (5274,'Shiny_Wig','Shiny Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',1,306,'bonus bSpeedRate,25; bonus bDef,4; skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db_re` VALUES (5275,'Marvelous_Wig','Marvelous Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',1,307,'bonus bSpeedRate,25; bonus bDef,4; skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db_re` VALUES (5276,'Fantastic_Wig','Fantastic Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',1,308,'bonus bSpeedRate,25; bonus bDef,4; skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db_re` VALUES (5277,'Yellow_Bandana','Yellow Bandana',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'20',1,309,'bonus bLuk,2; bonus bVit,2; bonus bLongAtkDef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5278,'Yellow_Ribbon','Yellow Ribbon',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'20',1,310,'bonus bLuk,2; bonus bVit,2; bonus bLongAtkDef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5279,'Drooping_Kitty_C','Refined Drooping Cat',4,2,NULL,0,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,142,'bonus bMdef,15; bonus2 bResEff,Eff_Curse,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5280,'Magestic_Goat_C','Baphomet Horns',4,2,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,41,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5281,'Deviruchi_Cap_C','Refined Deviruchi Hat',4,2,NULL,0,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,123,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5282,'euRO_Baseball_Cap','Europe Baseball Cap',4,0,NULL,200,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,216,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5283,'Chick_Hat','Chick Hat',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',0,311,'bonus bLuk,2; bonus bMaxHP,50; bonus bMaxSP,50; skill "TF_DOUBLE",2; bonus bDoubleRate,10; bonus2 bSubRace,RC_DemiHuman,3; bonus2 bSubRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5284,'Water_Lily_Crown','Water Lily Crown',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',0,312,'bonus bDex,1; bonus bAgi,1; bonus bMdef,3; bonus bHPrecovRate,5; bonus bSPrecovRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5285,'Vane_Hairpin','Vane Hairpin',4,20,NULL,300,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',0,313,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5286,'Pecopeco_Hairband','Pecopeco Hairband',4,20,NULL,0,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',0,314,'bonus bSpeedRate,25; bonus bAspdRate,5; bonus bVariableCastrate,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5287,'Vacation_Hat','Vacation Hat',4,20,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',0,315,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5288,'Red_Glasses','Red Glasses',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,316,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5289,'Vanilmirth_Hat','Vanilmirth Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',0,317,'bonus bUnbreakableHelm; bonus3 bAutoSpell,"MG_FIREBOLT",1,50; bonus3 bAutoSpell,"MG_COLDBOLT",1,50; bonus3 bAutoSpell,"MG_LIGHTNINGBOLT",1,50; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5290,'Drooping_Bunny_','Drooping Bunny',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,249,'bonus bDex,1; bonus bFlee,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5291,'Kettle_Hat','Kettle Hat',4,20,NULL,600,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',1,318,'bonus4 bAutoSpell,"SA_DELUGE",2,10,0; bonus3 bAutoSpell,"WZ_WATERBALL",3,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5292,'Dragon_Skull','Dragon Skull',4,20,NULL,800,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,319,'bonus2 bSubRace,RC_Dragon,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5293,'Ramen_Hat','Ramen Hat',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,320,'bonus bDex,4; bonus4 bAutoSpellWhenHit,"AL_DECAGI",1,30,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5294,'Whisper_Mask','Whisper Mask',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,769,NULL,'0',0,321,'bonus bAgi,3; bonus2 bSubEle,Ele_Ghost,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5295,'Golden_Bandana','Golden Bandana',4,20,NULL,2400,NULL,4,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',0,138,'bonus bMdef,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5296,'Drooping_Nine_Tail_','Drooping Nine Tail',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,296,'bonus bAgi,1; bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5297,'Soulless_Wing_','Soul Wing',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,301,'bonus bAllStats,1; bonus2 bSPRegenRate,2,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5298,'Marvelous_Wig_','Dokebi\'s Wig',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,2,768,NULL,'0',1,307,'bonus2 bSubEle,Ele_Neutral,5; bonus2 bSubEle,Ele_Fire,-5; bonus2 bSubEle,Ele_Water,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5299,'Ati_Atihan_Hat_','Pagdayaw',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,2,769,NULL,'1',0,303,'bonus3 bAutoSpell,"DC_SCREAM",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5300,'Bullock_Helm','Bullock Helm',4,20,NULL,800,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'45',1,322,'bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5301,'Russian_Ribbon','Victory Hairband',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,323,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5302,'Lotus_Flower_Hat','Flower Lily',4,0,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',1,324,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5303,'Flower_Coronet','Flower Crown',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,325,'bonus bMdef,3; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5304,'Cap_Of_Blindness','Cap Of Blindness',4,20,NULL,800,NULL,4,NULL,1,0xFFFFFFFF,63,2,769,NULL,'30',1,326,'bonus2 bResEff,Eff_Curse,700; bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5305,'Pirate_Dagger','Pirate Dagger',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,327,'bonus bBaseAtk,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5306,'Freyja_Crown','Freya\'s Crown',4,0,NULL,500,NULL,20,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,328,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5307,'Carmen_Miranda\'s_Hat','Carmen Miranda\'s Hat',4,20,NULL,400,NULL,10,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,329,'bonus bMdef,3; .@r = getrefine(); bonus2 bSubEle,Ele_Fire,(.@r>=7?10:5); if(.@r>=7){ bonus bBaseAtk,15; bonus bMatk,15; } bonus3 bAddMonsterDropItem,512,RC_All,10; bonus3 bAddMonsterDropItem,513,RC_All,10; bonus3 bAddMonsterDropItem,514,RC_All,10; bonus3 bAddMonsterDropItem,578,RC_All,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5308,'Brazilian_Flag_Hat','Brazil National Flag Hat',4,20,NULL,300,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,330,'bonus bSpeedAddRate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5309,'Mahican','Wool Mask',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,769,NULL,'0',1,331,'skill "RG_GRAFFITI",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5310,'Bulb_Hairband','Shining Electric Bulb Hairband',4,20,NULL,100,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,332,'bonus2 bSubEle,Ele_Dark,10; skill "MG_SIGHT",1;',NULL,'sc_end SC_SIGHT;');
REPLACE INTO `item_db_re` VALUES (5311,'Large_Hibiscus','Large Hisbiscus',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,333,'bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5312,'Ayothaya_Hat','Ayothaya King\'s Hat',4,20,NULL,100,NULL,5,NULL,1,0x000654E2,63,2,256,NULL,'0',1,334,'bonus bStr,1; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5313,'Diadem','Diadem',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,768,NULL,'0',1,335,'bonus bInt,1; bonus bMatkRate,3; bonus bVariableCastrate,-3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5314,'Hockey_Mask','Hockey Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,513,NULL,'50',0,336,'bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5315,'Observer','Observer',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'35',0,337,'skill "WZ_ESTIMATION",1; /*Gold PC Room: bonus bAllStats,1;*/',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5316,'Umbrella_Hat','Umbrella Hat',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,338,'bonus2 bSubEle,Ele_Water,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5317,'Fisherman_Hat','Fisherman\'s Hat',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,339,'bonus3 bAutoSpell,"WZ_WATERBALL",3,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5318,'Poring_Party_Hat','Poring Party Hat',4,20,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,340,'bonus bFlee,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5319,'Hellomother_Hat','Hello Mother Hat',4,20,NULL,200,NULL,3,NULL,1,0xFFFFFFFE,63,2,256,NULL,'1',1,341,'bonus bHPrecovRate,150; bonus bMaxHP,80+(80*getrefine());',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5320,'Champion_Wreath','Champion Wreath',4,20,NULL,500,NULL,8,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,261,'bonus bAllStats,2; bonus4 bAutoSpellWhenHit,"AL_HEAL",1,50,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5321,'Indonesian_Bandana','Bandana Merah Putih',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,342,'bonus2 bAddMonsterDropItem,518,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5322,'Scarf','Kerchief',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'24',1,343,'bonus bMdef,2; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5323,'Misstrance_Crown','Misstrance Crown',4,20,NULL,0,NULL,14,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,165,'bonus bAllStats,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5324,'Little_Angel_Doll','Little Angel Doll',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,344,'bonus bDex,3; bonus4 bAutoSpellWhenHit,"CR_GRANDCROSS",3,30,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5325,'Robo_Eye','Robo Eye',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'10',0,345,'bonus2 bAddClass,Class_All,2; bonus bMatkRate,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5326,'Masquerade_C','Masquerade C',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,78,'bonus2 bAddRace,RC_DemiHuman,7; bonus2 bAddRace,RC_Player,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5327,'Orc_Hero_Helm_C','Refined Helmet of Orc Hero',4,1,NULL,0,NULL,10,NULL,0,0xFFFFFFFE,63,2,768,NULL,'0',0,178,'bonus bStr,5; bonus bVit,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5328,'Evil_Wing_Ears_C','Evil Wing Ears C',4,1,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,152,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5329,'Dark_Blindfold_C','Dark Blindfold C',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,187,'bonus2 bResEff,Eff_Blind,10000; bonus2 bResEff,Eff_Stun,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5330,'kRO_Drooping_Kitty_C','kRO Drooping Kitty C',4,1,NULL,0,NULL,9,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,142,'bonus bMdef,15; bonus2 bResEff,Eff_Curse,4000; bonus2 bResEff,Eff_Stun,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5331,'Corsair_C','Corsair C',4,1,NULL,0,NULL,14,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,105,'bonus bVit,3; bonus bInt,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5332,'Loki_Mask','Loki Mask',4,0,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,63,2,513,NULL,'20',0,346,'bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5333,'Radio_Antenna','Radio Antenna',4,0,NULL,1500,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,347,'bonus bMdef,5; bonus bCritical,5; bonus bFlee,5; skill "MG_LIGHTNINGBOLT",1; bonus4 bAutoSpellWhenHit,"MG_THUNDERSTORM",5,30,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5334,'Angeling_Wanna_Fly','Flapping Angeling',4,0,NULL,700,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,348,'bonus bLuk,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5335,'Jumping_Poring','Jumping Poring',4,0,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,349,'bonus bLuk,1; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5336,'Guildsman_Recruiter','Guildsman Recruiter Hat',4,NULL,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,350,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5337,'Party_Recruiter_Hat','Party Recruiter Hat',4,0,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,351,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5338,'Bf_Recruiter_Hat','BF Recruiter Hat',4,0,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,352,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5339,'Friend_Recruiter_Hat','Friend Recruiter Hat',4,0,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,353,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5340,'Deprotai_Doll_Hat','Defolty Doll Hat',4,0,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',0,354,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus4 bAutoSpellWhenHit,"AL_ANGELUS",10,20,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5341,'Claris_Doll_Hat','Glaris Doll Hat',4,0,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',0,355,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus bMagicHPGainValue,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5342,'Sorin_Doll_Hat','Sorin Doll Hat',4,0,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',0,356,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; autobonus "{ bonus bBaseAtk,50; }",20,10000,0,"{ specialeffect2 EF_POTION_BERSERK; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5343,'Tayelin_Doll_Hat','Telling Doll Hat',4,0,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',0,357,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus2 bAddItemHealRate,504,10; bonus2 bAddItemHealRate,547,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5344,'Binit_Doll_Hat','Bennit Doll Hat',4,0,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',0,358,'bonus bVit,2; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; autobonus "{ bonus bAspdRate,5; }",20,30000,0,"{ specialeffect2 EF_HASTEUP; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5345,'Debril_Doll_Hat','W Doll Hat',4,0,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',0,359,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus2 bAddRace,RC_Undead,5; bonus2 bMagicAddRace,RC_Undead,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5346,'Gf_Recruiter_Hat','GF Recruiter Hat',4,0,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,360,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5347,'Ph.D_Hat_','Ph.D Hat',4,20,NULL,100,NULL,5,NULL,1,0xFFFFFFFE,63,2,256,NULL,'0',1,98,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5348,'Big_Sis\'_Ribbon_','Big Ribbon',4,15000,NULL,200,NULL,3,NULL,1,0xFFFFFFFE,63,2,256,NULL,'0',1,28,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5349,'Boy\'s_Cap_','Boy\'s Cap',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFE,63,2,256,NULL,'0',1,102,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5350,'Pirate_Bandana_','Pirate Bandana',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFE,63,2,256,NULL,'0',1,74,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5351,'Sunflower_','Sunflower',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',0,37,'bonus2 bSubRace,RC_Insect,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5352,'Poporing_Cap','Poporing Cap',4,20,NULL,700,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'38',1,361,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5353,'Helm_Of_Sun_','Hat of the Sun God',4,20,NULL,2400,NULL,4,NULL,1,0x00CFDF80,63,2,768,NULL,'0',1,138,'bonus bStr,3; bonus bInt,2; bonus5 bAutoSpellWhenHit,"HP_ASSUMPTIO",1,1,BF_WEAPON|BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5354,'Muslim_Hat_M','Muslim Hat M',4,0,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,1,256,NULL,'0',0,362,'bonus bVariableCastrate,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5355,'Muslim_Hat_F','Selendang',4,0,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,0,256,NULL,'0',0,363,'bonus bVariableCastrate,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5356,'Pumpkin_Hat_H','Festival Pumpkin Hat',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,206,'bonus2 bSubRace,RC_Demon,5; bonus2 bAddRace,RC_Demon,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5357,'Wings_Of_Victory','Wings Of Victory',4,20,NULL,200,NULL,10,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',0,365,'bonus bMdef,10; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5358,'Pecopeco_Wing_Ears','Peco Ears',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,366,'bonus bAgi,1; bonus bMdef,2; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5359,'J_Captain_Hat','Ship Captain Hat',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',1,367,'bonus bDex,1; bonus bMaxHP,100; bonus bLongAtkRate,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5360,'Whikebain_Ears','Hyuke\'s Black Cat Ears',4,20,NULL,200,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'45',1,368,'bonus bFlee,10; bonus bCritAtkRate,10; autobonus "{ bonus2 bIgnoreMdefRaceRate,RC_ALL,25; }",50,5000,BF_MAGIC,"{ specialeffect2 EF_AGIUP; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5361,'Gang_Scarf','Gangster Scarf',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,369,'bonus bBaseAtk,5; if(BaseJob==Job_Rogue) skill "RG_GANGSTER",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5362,'Ninja_Scroll','Ninja Scroll',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,370,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5363,'Helm_Of_Abyss','Helm Of Abyss',4,20,NULL,1000,NULL,9,NULL,1,0x000654E2,63,2,256,NULL,'70',1,371,'bonus2 bSubClass,Class_Normal,-5; bonus2 bSubClass,Class_Boss,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5364,'Dark_Snake_Lord_Hat','Evil Snake Lord Hat',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',1,372,'bonus bStr,1; bonus bInt,1; bonus bAgi,2; bonus2 bAddMonsterDropItem,12582,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5365,'Fried_Egg','Magnolia Hat',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',0,373,'bonus bBaseAtk,5; bonus3 bAutoSpellWhenHit,"BS_GREED",1,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5366,'Hat_0f_King','Love Dad Bandana',4,20,NULL,200,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,374,'bonus bAllStats,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5367,'Hyegun_Hat','Hyegun Hat',4,20,NULL,100,NULL,5,NULL,1,0xFFFFFFFF,63,2,769,NULL,'10',0,375,'bonus bMdef,3; bonus2 bSubRace,RC_Demon,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5368,'White_Wing','White Wing',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,38,'bonus2 bAddMonsterDropItem,12280,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5369,'Dark_Wing','Dark Wing',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,39,'bonus2 bAddMonsterDropItem,12279,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5370,'Orchid_Hairband','Orchid Hairband',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,376,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5371,'Hat_Of_Judge','Judge Hat',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',1,377,'bonus bLuk,1; bonus bMaxSP,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5372,'Drooping_White_Kitty','Koneko Hat',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,378,'bonus bInt,1; bonus bDelayRate,-3; bonus bMatkRate,3; bonus bMaxSPrate,3; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5373,'Darkness_Helm','Dark Randgris Helm',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,63,2,768,NULL,'0',1,379,'bonus bDex,3; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5374,'L_Magestic_Goat','Gigantic Majestic Goat',4,20,NULL,800,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,380,'bonus2 bAddRace,RC_DemiHuman,12; bonus2 bAddRace,RC_Player,12; bonus bBaseAtk,(JobLevel*2)/7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5375,'L_Orc_Hero_Helm','Orc Hero Headdress',4,20,NULL,900,NULL,5,NULL,1,0xFFFFFFFF,63,2,768,NULL,'0',1,381,'bonus bStr,2; bonus3 bAutoSpellWhenHit,"BS_WEAPONPERFECT",3,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5376,'Satanic_Chain_P','Flying Evil Wing',4,20,NULL,100,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,382,'bonus bMaxSP,120; bonus2 bAddEff2,Eff_Curse,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5377,'Antique_Pipe','Gentleman\'s Pipe',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,383,'bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5378,'Rabbit_Ear_Hat','Bunny Top Hat',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,384,'bonus bAgi,3; bonus3 bAutoSpellWhenHit,"AL_INCAGI",5,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5379,'Balloon_Hat','Tam',4,0,NULL,800,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'50',1,385,'bonus bMdef,2; bonus bMatkRate,2+(getrefine()/2);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5380,'Fish_Head_Hat','Fish Head Hat',4,20,NULL,400,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,386,'bonus3 bAutoSpell,"SA_FROSTWEAPON",1,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5381,'Santa_Poring_Hat','Santa Poring Hat',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',0,387,'bonus bMdef,2; bonus2 bAddEle,Ele_Dark,3; bonus2 bSubEle,Ele_Dark,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5382,'Bell_Ribbon','Bell Ribbon',4,20,NULL,200,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,388,'bonus bVit,1; skill "AL_ANGELUS",1;',NULL,'sc_end SC_ANGELUS;');
REPLACE INTO `item_db_re` VALUES (5383,'Hunting_Cap','Hunter\'s Cap',4,20,NULL,250,NULL,6,NULL,1,0xFFFFFFFE,63,2,256,NULL,'50',1,389,'bonus bLuk,1; bonus2 bAddRace,RC_Brute,10; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5384,'Santa_Hat_1','Twin Pompom By JB',4,20,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'20',1,390,'bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5385,'Yoyo_Hat','Yoyo Hat',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'20',1,391,'skill "TF_HIDING",1;',NULL,'sc_end SC_HIDING;');
REPLACE INTO `item_db_re` VALUES (5386,'Ayam_','Ayam',4,0,NULL,70,NULL,7,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',0,228,'bonus bMdef,7; bonus bFlee,7; bonus2 bAddMonsterDropItem,12198,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5387,'Neko_Mimi_Kafra','Neko Mimi Kafra',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,392,'bonus bMdef,5; bonus2 bAddEffWhenHit,Eff_Silence,1000; bonus2 bAddEffWhenHit,Eff_Poison,1000; bonus2 bAddEffWhenHit,Eff_Curse,1000; bonus2 bAddEffWhenHit,Eff_Blind,1000; bonus2 bAddEffWhenHit,Eff_Stone,1000; bonus2 bAddEffWhenHit,Eff_Freeze,1000; bonus2 bAddEffWhenHit,Eff_Stun,1000; bonus2 bAddEffWhenHit,Eff_Sleep,1000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5388,'Snake_Head','Snake Head Hat',4,20,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,393,'skill "TF_DOUBLE",5; bonus bDoubleRate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5389,'Angel_Spirit','Angel Spirit',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,394,'bonus bStr,2; bonus bHit,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5390,'Santa_Hat_2','Frozen Twin Pompom',4,20,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,395,'bonus2 bResEff,Eff_Freeze,3000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5391,'Toast_C','Toast',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,188,'bonus bMaxHP,100; bonus2 bAddMonsterDropItem,617,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5392,'Louyang_Cap','Louyang NewYear Hat',4,20,NULL,300,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,396,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5393,'Valentine_Hat','Love Valentine\'s Hat',4,20,NULL,200,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,397,'bonus bMaxSPrate,7; bonus bMaxHPrate,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5394,'Bubblegum_Lower','Bubblegum',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,572,'bonus2 bExpAddClass,Class_All,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5395,'Tiraya_Bonnet','Striped Hat',4,20,NULL,500,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'50',1,398,'bonus bMaxHP,100+(getrefine()*20); bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5396,'Jasper_Crest','Jasper Crest',4,20,NULL,700,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,399,'bonus bDex,1; bonus2 bAddRace,RC_Undead,5; .@r = getrefine(); if (.@r<6) { bonus2 bAddEff2,Eff_Blind,10; } else if (.@r>8) { bonus bDex,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5397,'Scuba_Mask','Scuba Gear',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,400,'bonus2 bSubEle,Ele_Water,10; bonus2 bExpAddRace,RC_Fish,10; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5398,'Bone_Head','Bone Head',4,20,NULL,1200,NULL,10,NULL,1,0x000444A2,18,2,256,NULL,'85',1,401,'bonus bStr,2; bonus bMdef,5; bonus2 bResEff,Eff_Stun,500; bonus2 bResEff,Eff_Bleeding,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5399,'Mandragora_Cap','Mandragora Cap',4,20,NULL,300,NULL,5,NULL,1,0x00CFFF80,18,2,256,NULL,'85',0,402,'bonus bVit,3; bonus3 bAutoSpellWhenHit,"DC_SCREAM",5,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5400,'Fox_Hat','Fox Hat',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,0,769,NULL,'0',0,403,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5401,'Black_Glasses','Black Frame Glasses',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,404,'bonus bInt,1; bonus bMdef,2; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5402,'Mischievous_Fairy','Mischievous Fairy',4,10,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,405,'bonus bUnbreakableHelm; bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5403,'Fish_In_Mouth','Fish In Mouth',4,10,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'30',0,406,'bonus2 bAddMonsterDropItem,579,500; bonus2 bAddItemHealRate,579,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5404,'Blue_Ribbon','Blue Ribbon',4,10,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'45',1,407,'bonus4 bAutoSpellWhenHit,"AC_CONCENTRATION",2,7,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5405,'Filir_Hat','Filir Hat',4,10,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'80',0,408,'bonus bShortWeaponDamageReturn,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5406,'Academy_Freshman_Hat','Academy Freshman Hat',4,0,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,409,'bonus bInt,1; bonus bDex,2; bonus bVit,1; bonus bDelayrate,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5407,'Academy_Graduating_Cap','Academy Completion Hat',4,0,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,410,'bonus bMaxSP,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5408,'Old_Bandanna','Old Bandana',4,0,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,6,'bonus bInt,2; bonus bMaxSP,50; bonus bVariableCastrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5409,'New_Cowboy_Hat','Purple Cowboy Hat',4,20,NULL,500,NULL,8,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,411,'bonus bInt,2; bonus bVit,2; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5410,'Bread_Bag2','Brown Paperbag Hat',4,20,NULL,200,NULL,6,NULL,0,0xFFFFFFFF,63,2,769,NULL,'0',0,412,'bonus bMaxHP,100; bonus2 bResEff,Eff_Stun,400; bonus2 bSubRace,RC_DemiHuman,4; bonus2 bSubRace,RC_Player,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5411,'White_Snake_Hat','White Snake Hat',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,413,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5412,'Sweet_Candy','Sweet Candy',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,414,'bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5413,'Popcorn_Hat','Pop Corn Hat',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,415,'bonus2 bSubEle,Ele_Wind,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5414,'Campfire_Hat','Camp Fire Hat',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,416,'bonus2 bSubEle,Ele_Fire,10; bonus4 bAutoSpellWhenHit,"MG_FIREBALL",5,100,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5415,'Poring_Cake_Cap','Poring Cake Hat',4,20,NULL,1000,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'40',1,417,'bonus bMdef,5; bonus bCritical,5; bonus bFlee,5; bonus bFlee2,5; bonus bAspdRate,5; bonus bVariableCastrate,-5; bonus bDelayRate,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5416,'Beer_Cap','Beer Hat',4,20,NULL,600,NULL,4,NULL,0,0xFFFFFFFE,63,2,256,NULL,'18',1,418,'bonus bFlee2,5; skill "SM_RECOVERY",3; skill "MG_SRECOVERY",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5417,'Crown_Parrot','Crown Parrots',4,20,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',0,419,'bonus bInt,1; bonus2 bResEff,Eff_Silence,10000; bonus3 bAutoSpell,"DC_SCREAM",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5418,'Soldier_Hat','Legionnaire Hat',4,20,NULL,400,NULL,8,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,420,'bonus bStr,1; bonus2 bAddClass,Class_All,3; bonus bUseSPrate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5419,'Evolved_Leaf','Leaves Of Grass',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,57,'bonus bVit,1; bonus2 bSubRace,RC_Plant,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5420,'Mask_Of_Ifrit','Mask Of Ifrit',4,20,NULL,800,NULL,12,NULL,1,0xFFFFFFFE,63,2,769,NULL,'50',0,421,'bonus bStr,2; bonus bInt,2; bonus bMdef,5; bonus2 bSubEle,Ele_Fire,10; bonus2 bSubEle,Ele_Water,-10; bonus2 bAddEle,Ele_Fire,10; bonus2 bMagicAtkEle,Ele_Fire,10; bonus3 bAutoSpell,"WZ_METEOR",3,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5421,'Ifrit\'s_Ear','Ears Of Ifrit',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFE,63,2,512,NULL,'50',0,422,'bonus bStr,1; bonus bInt,1; bonus bMdef,3; bonus2 bAddEle,Ele_Fire,3; bonus2 bSkillAtk,"SM_BASH",4; bonus2 bSkillAtk,"SM_MAGNUM",4; bonus2 bSubEle,Ele_Fire,3; bonus2 bSubEle,Ele_Water,-3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5422,'Linguistic_Book_Cap','Linguistic Book Hat',4,20,NULL,70,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,423,'bonus bInt,1; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5423,'Lovecap_China','I Love China',4,20,NULL,250,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,424,'bonus bDex,3; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5424,'Fanta_Orange_Can','Fanta Orange Can Hat',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,425,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5425,'Fanta_Grape_Can','Fanta Grape Can Hat',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,426,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5426,'Karada_Meguri_Tea_Hat','Karada Meguricha Hat',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,427,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5427,'Royal_Milk_Tea_Hat','Black Tea Kochakaden Hat',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,428,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5428,'Bread_Bag1','RWC Anniversary Bread Envelope',4,NULL,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,769,NULL,'0',1,429,'bonus2 bSubRace,RC_DemiHuman,12; bonus2 bSubRace,RC_Player,12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5429,'Bogy_Cap','Bogy Cap',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,430,'bonus bHPrecovRate,5; bonus bSPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5430,'Sacred_Torch_Coronet','Torch Cap',4,20,NULL,0,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,431,'bonus2 bSubEle,Ele_Fire,20; skill "MG_FIREBOLT",5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5431,'Chicken_Hat','Chicken Hat',4,20,NULL,1000,NULL,0,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,432,'bonus3 bAutoSpell,"MC_LOUD",1,30; bonus bAspdRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5432,'Brazil_Baseball_Cap','bRO 4th Anniversary Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,433,'if(gettime(DT_MONTH)==SEPTEMBER&&gettime(DT_DAYOFMONTH)>=10&&gettime(DT_DAYOFMONTH)<=24) bonus bAllStats,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5433,'Golden_Wreath','Golden Laurel',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,434,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5434,'Cola_Can','Cola Can',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,435,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5435,'Coke_Hat','Red Minstrel Hat',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'40',1,436,'bonus bInt,1; bonus bMaxSP,80; bonus bMdef,3; .@r = getrefine(); if(.@r>5) { bonus bMdef,.@r-5; bonus bMaxSP,(.@r-5)*10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5436,'Bride\'s_Corolla','Bride\'s Corolla',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,437,'bonus bLuk,3; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5437,'Flower_Of_Fairy','Fairy Flower',4,20,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,438,'bonus bInt,1; bonus bMdef,1; bonus2 bSubRace,RC_Insect,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5438,'Fillet_Green','Cute Green Ribbon',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,439,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5439,'Fillet_Red','Cute Red Ribbon',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,440,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5440,'Fillet_Blue','Cute Blue Ribbon',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,441,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5441,'Fillet_White','Cute White Ribbon',4,500,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,442,'bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5442,'Necktie','Necktie',4,20,NULL,100,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'70',1,443,'bonus bVit,1; bonus bHit,-5; bonus bUseSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5443,'Status_Of_Baby_Angel','Statue Of Baby Angel',4,20,NULL,600,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'70',1,444,'bonus bMdef,2; bonus4 bAutoSpellWhenHit,"PR_STRECOVERY",1,20,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5444,'Hair_Brush','Hair Brush',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,445,'bonus bCritical,6;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5445,'Candy_Cane_In_The_Mouth','Candy Cane In Mouth',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,446,'bonus bMaxSP,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5446,'Cat_Foot_Hairpin','Catfoot Hairpin',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,447,'bonus bFlee,5; bonus bFlee2,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5447,'Frog_Cap','Frog Hat',4,20,NULL,500,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',1,448,'bonus bMdef,1; bonus2 bAddRace,RC_Insect,12; bonus2 bMagicAddRace,RC_Insect,12;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5448,'Solo_Play_Box1','Indifferent Solo Hat',4,20,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,63,2,769,NULL,'0',1,449,'skill "RG_GRAFFITI",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5449,'Solo_Play_Box2','Angry Solo Hat',4,20,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,63,2,769,NULL,'0',1,450,'skill "RG_GRAFFITI",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5450,'Sun_Cap','Solar Hat',4,20,NULL,1000,NULL,0,NULL,0,0xFFFFFFFE,63,2,256,NULL,'20',1,451,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5451,'Dragonhelm_Gold','RWC 2008 Dragon Helm Gold',4,20,NULL,2500,NULL,14,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',0,452,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5452,'Dragonhelm_Silver','RWC 2008 Dragon Helm Silver',4,20,NULL,2500,NULL,10,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',0,453,'bonus2 bSubRace,RC_DemiHuman,7; bonus2 bSubRace,RC_Player,7; bonus2 bAddRace,RC_DemiHuman,3; bonus2 bAddRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5453,'Dragonhelm_Copper','RWC 2008 Dragon Helm Copper',4,20,NULL,2500,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',0,454,'bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus2 bAddRace,RC_DemiHuman,1; bonus2 bAddRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5454,'Dog_Cap_','Puppy Hat',4,20,NULL,500,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,234,'bonus bStr,1; bonus bInt,1; autobonus "{ bonus bCritical,100; }",10,3000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }"; autobonus "{ bonus2 bIgnoreMdefClassRate,Class_Normal,100; bonus2 bIgnoreMdefClassRate,Class_Boss,100; }",10,3000,BF_MAGIC,"{ specialeffect2 EF_MAGICALATTHIT; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5455,'Geographer_Band_','Decorative Geographer',4,20,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,238,'bonus bInt,1; bonus3 bAutoSpell,"AL_HEAL",5,50; bonus3 bAutoSpellWhenHit,"AL_HEAL",5,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5456,'Vacation_Hat_','Summer Hat',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,315,'bonus bVit,5; bonus bHPrecovRate,20; bonus bSPrecovRate,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5457,'Spring_Rabbit_Hat','Moon Rabbit Hat',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,455,'bonus bAgi,3; bonus bBaseAtk,5; bonus bMatkRate,5; .@r = getrefine(); if(.@r>4) { bonus bBaseAtk,.@r-4; bonus bMatkRate,.@r-4; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5458,'Pinwheel_Cap','Pinwheel Hat',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,456,'bonus bMaxHPrate,5; bonus bMaxSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5459,'Drooping_Bunny_Chusuk','Drooping Bunny',4,0,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,249,'bonus bDex,1; bonus bFlee,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5460,'Adv_Dragon_Skull','Evolved Dragon Skull Hat',4,20,NULL,1000,NULL,14,NULL,0,0xFFFFFFFF,63,2,256,NULL,'60',1,457,'bonus bAllStats,2; bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5461,'Adv_Whisper_Mask','Evolved Whisper Mask',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,63,2,769,NULL,'50',1,458,'bonus bDex,3; bonus2 bSubEle,Ele_Ghost,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5462,'Spiked_Scarf','Spiked Scarf',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,1,NULL,'90',0,459,'bonus bAtk,30; bonus bMaxHPrate,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5463,'Rainbow_Scarf','Rainbow Scarf',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,1,NULL,'90',0,460,'bonus bMatk,30; bonus bMaxSPrate,-2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5464,'Zaha_Doll_Hat','Zaha Doll Hat',4,20,NULL,0,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,461,'bonus bInt,3; bonus bMdef,9; bonus2 bMagicAddRace,Ele_Undead,10; .@r0 = getrefine(); autobonus "{ .@r = getrefine(); bonus2 bSPLossRate,10,1000; bonus bMatk,30*.@r; bonus bFixedCast,-80*.@r; }",3*.@r0,3000,BF_MAGIC,"{ active_transform 1518,3000; specialeffect2 EF_POTION_BERSERK; showscript \\\"Bacsojin Power !\\\"; }"; autobonus2 "{ .@r = getrefine(); bonus2 bSPLossRate,10,1000; bonus bMatk,30*.@r; bonus bFixedCast,-80*.@r; }",.@r0,3000,BF_MAGIC,"{ active_transform 1518,3000; specialeffect2 EF_POTION_BERSERK; showscript \\\"Bacsojin Power !\\\"; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5465,'Celestial_Hat','Hat Of Fortune',4,20,NULL,500,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'40',1,462,'bonus bLuk,2; bonus bMdef,5; .@r = getrefine(); if(.@r>4) bonus bLuk,.@r-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5466,'Wind_Milestone','Wind Milestone',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,463,'bonus bAgi,2; skill "AL_TELEPORT",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5467,'Helm_Of_Dragoon','Helm Of Dragon',4,20,NULL,1000,NULL,10,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,464,'bonus bStr,2; bonus bInt,2; bonus bDex,2; .@r = getrefine(); if(.@r>=7) bonus2 bExpAddRace,RC_Dragon,3; if(.@r>=9) bonus2 bExpAddRace,RC_Dragon,5; bonus3 bAutoSpell,"NPC_DRAGONFEAR",1,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5468,'Parade_Cap','Parade Hat',4,20,NULL,800,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,465,'bonus bDelayRate,-5; bonus bMdef,2; .@r = getrefine(); if(.@r>5) bonus bVariableCastrate,-(.@r-5);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5469,'Noble_Hat','Musketeer Hat',4,20,NULL,300,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',1,466,'bonus bDex,3; bonus bFlee,3; .@r = getrefine(); if(.@r>=7){ bonus bFlee,3; bonus bLongAtkRate,3; } if(.@r>=9){ bonus bFlee,4; bonus bLongAtkRate,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5470,'Eyes_Of_Darkness','Eye Of Darkness',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'50',0,467,'bonus bDex,1; bonus2 bResEff,Eff_Blind,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5471,'Hairband_Of_Reginleif','Hairband Of Reginleif',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'50',0,468,'bonus2 bSubEle,Ele_Water,3; bonus2 bSubEle,Ele_Fire,3; bonus2 bSubEle,Ele_Undead,3; bonus2 bSubEle,Ele_Ghost,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5472,'Red_White_Hat','Red Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,469,'bonus3 bAddMonsterDropItem,554,RC_DemiHuman,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5473,'Forceps_Hairpin','Nipper Crab Hairpin',4,20,NULL,500,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',1,470,'bonus3 bAutoSpellWhenHit,"MG_COLDBOLT",1,30; bonus3 bAddMonsterDropItem,991,RC_Fish,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5474,'Notice_Board','AFK Hat',4,20,NULL,700,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',0,471,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5475,'Cube_Mask','Mask Cube',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,513,NULL,'0',0,472,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5476,'Hairband_Of_Grandpeco','Grand Peco Hairband',4,20,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,63,2,768,NULL,'1',1,473,'bonus2 bAddRace,RC_Brute,7; bonus2 bMagicAddRace,RC_Brute,7; bonus2 bAddRace,RC_DemiHuman,7; bonus2 bMagicAddRace,RC_DemiHuman,7; bonus3 bAddEff,Eff_Curse,10,ATF_SHORT;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5477,'Bro_Flag','Brazilian Flag Hat',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,474,'skill "SM_BASH",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5478,'Classic_Hat','Classic Hat',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,475,'bonus bStr,2; bonus bMaxHP,300;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5479,'Shaman\'s_Hair_Ornament','Shaman\'s Hair Decoration',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,476,'bonus bMdef,3; bonus2 bSubEle,Ele_Neutral,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5480,'Bizofnil_Wing_Deco','Bijofnil Wings',4,20,NULL,1000,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,477,'bonus bAllStats,2; bonus2 bSubEle,Ele_All,5; bonus2 bHPRegenRate,(MaxHp*2/100),10000; bonus2 bSPRegenRate,(MaxSp/100),10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5481,'Hermose_Cap','Hermode Cap',4,20,NULL,1000,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,478,'bonus bAspdRate,10; bonus bBaseAtk,-20; bonus bMatkRate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5482,'Dark_Knight_Mask','Dark Knight Mask',4,20,NULL,3000,NULL,5,NULL,0,0xFFFFFFFF,63,2,769,NULL,'1',1,479,'bonus bStr,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5483,'Odin_Mask','Odin Mask',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,513,NULL,'1',0,480,'bonus2 bSubClass,Class_Boss,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5484,'Taiwan_Flag_Hat','Holidays Hat',4,20,NULL,500,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,482,'bonus bAllStats,5; bonus2 bResEff,Eff_Stun,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5485,'Tiger_Face','Tiger Face',4,20,NULL,1000,NULL,3,NULL,0,0xFFFFFFFF,63,2,769,NULL,'60',1,483,'bonus2 bSubRace,RC_Brute,5; bonus2 bAddRace,RC_Brute,5; bonus2 bMagicAddRace,RC_Brute,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5486,'J_Anniversary_Hat','Anniversary Hat',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,395,'bonus bAllStats,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5487,'J_Poringcake_Hat','Poring Cake Hat',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,417,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5488,'J_Twin_Santahat','Twin Santa Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,390,'bonus bLuk,1; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5489,'Love_Daddy','Love Daddy Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,484,'bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5490,'Anubis_Helm','Anubis Helm',4,20,NULL,0,NULL,8,NULL,0,0xFFFFFFFF,63,2,768,NULL,'65',0,485,'bonus bMdef,5; bonus2 bSubClass,Class_Boss,10; bonus bHealpower2,10; bonus bAddItemHealRate,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5491,'Hat_Of_Outlaw','Bandit Hat',4,20,NULL,800,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,486,'bonus bStr,2; bonus2 bSubEle,Ele_Fire,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5492,'Boy\'s_Cap_I','Student Cap',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,102,'bonus bMdef,3; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5493,'Ulle_Cap_I','Ulle\'s Cap',4,0,NULL,0,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,254,'bonus bDex,2; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5494,'Spinx_Helm_I','Sphinx Hat',4,0,NULL,0,NULL,5,NULL,0,0x00004082,63,2,257,NULL,'0',0,137,'bonus bStr,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5495,'Power_Of_Thor','Power Of Thor',4,20,NULL,100,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,493,'bonus bInt,1; bonus bDex,1; bonus bMdef,3; bonus bFlee,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5496,'Dice_Hat','Dice Hat',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',0,494,'bonus bLuk,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5497,'King_Tiger_Doll_Hat','King Tiger Doll Hat',4,20,NULL,400,NULL,6,NULL,1,0xFFFFFFFE,63,2,256,NULL,'1',1,495,'bonus bStr,2; bonus bDex,2; bonus2 bAddRace,RC_Brute,10; .@r = getrefine(); autobonus "{ bonus2 bSPLossRate,5,1000; bonus bBaseAtk,25*getrefine(); }",3*.@r,3000,BF_NORMAL,"{ active_transform 1115,3000; specialeffect2 EF_POTION_BERSERK; showscript \\\"Eddga Power !\\\"; }"; autobonus2 "{ bonus2 bSPLossRate,5,1000; bonus bBaseAtk,25*getrefine(); }",.@r,3000,BF_NORMAL,"{ active_transform 1115,3000; specialeffect2 EF_POTION_BERSERK; showscript \\\"Eddga Power !\\\"; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5498,'Wondering_Wolf_Helm','Wandering Wolf Helm',4,20,NULL,600,NULL,5,NULL,1,0xFFFFFFFE,63,2,768,NULL,'1',1,490,'bonus bAgi,5; bonus bFlee,10; bonus2 bIgnoreDefRaceRate,RC_DemiHuman,10; bonus2 bIgnoreDefRaceRate,RC_Brute,10; if(getrefine()>=7){ bonus2 bAddEff,Eff_Bleeding,10; } if(getrefine()>=9){ bonus3 bAutoSpellWhenHit,"MC_LOUD",1,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5499,'Pizza_Hat','Pizza Hat',4,20,NULL,600,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,487,'skill "SM_PROVOKE",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5500,'Icecream_Hat','Icecream Hat',4,0,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',1,488,'bonus bMdef,3; skill "MG_FROSTDIVER",3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5501,'Pirate\'s_Pride','Pirate\'s Pride',4,0,NULL,100,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',0,496,'bonus2 bAddRace2,RC2_Ninja,5; bonus2 bSubRace2,RC2_Ninja,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5502,'Necromencer\'s_Hood','Necromancer\'s Hood',4,0,NULL,500,NULL,6,NULL,0,0xFFFFFFFF,63,2,768,NULL,'1',1,491,'bonus bInt,3; bonus bMdef,3; bonus bDefEle,Ele_Undead; bonus2 bSubEle,Ele_Dark,15; bonus2 bSubEle,Ele_Holy,-20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5503,'Rabbit_Magic_Hat','Magic Rabit Hat',4,0,NULL,800,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,497,'bonus bDex,2; bonus bAgi,2; bonus bMdef,1; bonus bAspdRate,5; bonus bDelayRate,-4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5504,'China_Wedding_Veil','Wedding Weil',4,20,NULL,500,NULL,5,NULL,0,0xFFFFFFFF,63,2,768,NULL,'70',1,489,'bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5505,'Asara_Fairy_Hat','Asara Fairy Hat',4,0,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,768,NULL,'50',1,492,'skill "DC_DONTFORGETME",1; bonus bDex,2; bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5506,'Blue_Pajamas_Hat','Blue Night Cap',4,0,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,501,'bonus bAtkRate,5; bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5507,'Pink_Pajamas_Hat','Pink Night Cap',4,0,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,502,'bonus bAtkRate,5; bonus bMatkRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5508,'Shark_Hat','Shark Hat',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,503,'bonus bStr,1; bonus bAgi,2; bonus bMdef,1; bonus2 bAddEle,Ele_Water,5; bonus2 bSubDefEle,Ele_Water,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5509,'Sting_Hat','Sting hat',4,20,NULL,1000,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,504,'bonus bStr,2; bonus bVit,1; bonus bMdef,3; bonus2 bAddEle,Ele_Fire,5; bonus2 bSubDefEle,Ele_Earth,5; bonus3 bAutoSpell,"WZ_EARTHSPIKE",1,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5510,'Shower_Cap','Shower Cap',4,20,NULL,0,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,507,'bonus bMdef,3; bonus bFlee,3; bonus2 bAddEle,Ele_Water,10; bonus2 bSubRace,RC_Fish,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5511,'Samambaia','Samambaia',4,20,NULL,200,NULL,5,NULL,1,0xFFFFFFFF,63,2,768,NULL,'1',1,508,'bonus bHealPower,2; bonus bAspd,1; bonus bFixedCastrate,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5512,'Aquarius_Diadem','Aquarius Diadem',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',1,509,'bonus bStr,2; bonus bFlee,10; bonus2 bSubEle,Ele_Wind,5; if(getrefine()>6) { bonus bDef,1; bonus bBaseAtk,15; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5513,'Aquarius_Crown','Aquarius Crown',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',1,510,'bonus bStr,2; bonus bFlee,10; bonus2 bSubEle,Ele_Wind,5; if(getrefine()>6) { bonus bDef,1; bonus bBaseAtk,15; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5514,'Pisces_Diadem','Pisces Diadem',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',1,511,'bonus bInt,2; bonus bMdef,5; bonus2 bSubEle,Ele_Water,5; if(getrefine()>6) { bonus bDef,1; bonus bMatkRate,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5515,'Pisces_Crown','Pisces Crown',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',1,512,'bonus bInt,2; bonus bMdef,5; bonus2 bSubEle,Ele_Water,5; if(getrefine()>6) { bonus bDef,1; bonus bMatkRate,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5516,'Hawk_Eyes01','Hawk Eyes',4,10,NULL,1000,NULL,0,NULL,0,0x00000800,18,2,512,NULL,'0',0,23,'bonus bDex,1; bonus bLongAtkRate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5517,'Hawk_Eyes02','Hawk Eyes',4,10,NULL,1000,NULL,0,NULL,0,0x00080808,63,2,512,NULL,'0',0,23,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5518,'L_Magestic_Goat2','Gigantic Majestic Goat',4,20,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,513,'bonus2 bSubRace,RC_DemiHuman,12; bonus2 bSubRace,RC_Player,12; bonus bBaseAtk,(JobLevel*2)/7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5519,'Peacock_Feather','Peacock Feather',4,20,NULL,800,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,514,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5520,'Rabbit_Earplug','Rabbit Earplugs',4,NULL,NULL,400,NULL,0,NULL,1,0xFFFFFFFF,63,2,768,NULL,'1',1,515,'bonus2 bAddClass,Class_All,4; bonus bMatkRate,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5521,'Angry_Mouth_C','Angry Mouth',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,194,'bonus bDelayRate,-3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5522,'Fanta_Zero_Lemon_Hat','Fanta Zero Lemon Hat',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,516,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5523,'Sakura_Mist_Hat','Sakura Mist Hat',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,517,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5524,'Sakura_Milk_Tea_Hat','Sakura Milk Tea Hat',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,518,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5525,'First_Leaf_Tea_Hat','Flower Hat',4,20,NULL,100,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,519,'bonus bMaxHP,80; bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5526,'Lady_Tanee_Doll','Tanigumi Girl Doll',4,20,NULL,300,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'60',0,520,'bonus bAgi,2; bonus bFlee,3; bonus2 bSubEle,Ele_Wind,5; bonus2 bAddMonsterDropItem,513,200;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5527,'Lunatic_Hat','Lunatic Hat',4,20,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,521,'bonus bLuk,3; bonus bCritical,5; bonus2 bAddRace,RC_Plant,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5528,'King_Frog_Hat','Frog King Hat',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFE,63,2,256,NULL,'30',0,522,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5529,'Evil\'s_Bone_Hat','Satanic Bone Helm',4,20,NULL,600,NULL,6,NULL,1,0xFFFFFFFF,63,2,768,NULL,'70',1,523,'bonus bStr,2; bonus bInt,2; bonus bMdef,2; bonus2 bSubEle,Ele_Neutral,5; skill "WZ_FROSTNOVA",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5530,'Raven_Cap','Raven Cap',4,20,NULL,100,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,524,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5531,'B_Dragon_Hat','Baby Dragon Hat',4,45000,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,525,'bonus bDex,2; .@bonus = max(getskilllv("TF_DOUBLE"), 5); skill "TF_DOUBLE",.@bonus; bonus bDoubleRate,.@bonus * 5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5532,'Pirate_Dagger_J','Pirate Dagger',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,327,'bonus bShortWeaponDamageReturn,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5533,'Emperor_Wreath_J','Emperor Wreath',4,20,NULL,800,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'80',1,261,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5534,'Fox_Hat_J','Fox Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,513,NULL,'70',0,403,'bonus bAgi,1; bonus bFlee2,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5535,'Side_Cap','Side Cap',4,20,NULL,500,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,529,'bonus bVit,1; bonus bDex,1; bonus bMdef,3; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5; bonus2 bAddRace,RC_DemiHuman,3; bonus2 bAddRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5536,'Spare_Card','Spare Card',4,20,NULL,10,NULL,1,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,526,'bonus bLuk,1; bonus2 bAddMonsterDropItem,6187,1000; bonus bFlee2,1; bonus2 bAddMonsterDropItem,617,5; bonus2 bAddMonsterDropItem,12132,30; bonus2 bAddMonsterDropItem,12130,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5537,'Quati_Hat','Kwati Hat',4,20,NULL,700,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'45',0,527,'bonus bAgi,3; bonus2 bAddRace,RC_Plant,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5538,'Tucan_Hat','Tucan Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,63,2,768,NULL,'45',0,528,'bonus bDex,3; bonus bCritical,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5539,'Jaguar_Hat','Jaguar Hat',4,20,NULL,400,NULL,4,NULL,1,0xFFFFFFFF,63,2,769,NULL,'25',1,530,'bonus bMdef,2; skill "MC_LOUD",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5540,'Freyja_SCirclet7','Freyja SCirclet7',4,20,NULL,700,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'20',0,18,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5541,'Freyja_SCirclet30','Freyja SCirclet30',4,20,NULL,700,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'20',0,18,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5542,'Freyja_SCirclet60','Freyja SCirclet60',4,20,NULL,700,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'20',0,18,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5543,'Freyja_SCirclet90','Freyja SCirclet90',4,20,NULL,700,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'20',0,18,'bonus bStr,1; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5544,'Time_Keeper_Hat','Time Keeper Hat',4,30000,NULL,0,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,240,'bonus bInt,2; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5545,'Aries_Diadem','Aries Diadem',4,20,NULL,400,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,531,'bonus bVit,2; bonus2 bSubEle,Ele_fire,5; if(getrefine()>6) { bonus bDef,1; bonus bVit,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5546,'Aries_Crown','Aries Crown',4,20,NULL,400,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,532,'bonus bLuk,2; bonus2 bSubEle,Ele_Fire,5; if(getrefine()>6) { bonus bFlee,2; bonus bLuk,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5547,'RJC_Katusa','RJC Katusa Flower',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,533,'bonus2 bSkillAtk,"WZ_HEAVENDRIVE",15+getequiprefinerycnt(EQI_HAND_R); bonus2 bSkillAtk,"WZ_EARTHSPIKE",15+getequiprefinerycnt(EQI_HAND_R); bonus2 bVariableCastrate,"WZ_HEAVENDRIVE",-25; bonus2 bVariableCastrate,"WZ_EARTHSPIKE",-25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5548,'Scarlet_Rose','Scarlet Rose',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,534,'bonus2 bAddClass,Class_All,1; bonus bMatkRate,1; bonus bMaxSP,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5549,'Taurus_Diadem','Taurus Diadem',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',1,535,'bonus bDex,2; bonus bMatkRate,2; bonus bDelayRate,-2; if (getrefine()>6) { bonus bMatkRate,1; bonus bDex,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5550,'Taurus_Crown','Taurus Crown',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',1,536,'bonus bAgi,2; bonus2 bSubClass,Class_All,2; bonus bDelayRate,-2; bonus2 bAddEff,Eff_Stun,2000; if(getrefine()>6) { bonus2 bSubClass,Class_All,1; bonus bStr,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5551,'Holy_Egg_Hat','Holy Egg Hat',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,537,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5552,'Fest_Lord_Circlet','Festival Grand Circlet',4,0,NULL,0,NULL,8,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,93,'bonus bStr,3; bonus bInt,3; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5553,'Fest_Bunny_Band','Festival Bunny Band',4,0,NULL,0,NULL,7,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,15,'bonus bMdef,4; bonus2 bSubRace,RC_DemiHuman,9; bonus2 bSubRace,RC_Player,9;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5554,'Octopus_Hat','Octopus Hat',4,20,NULL,200,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,538,'bonus bMdef,3; bonus3 bAutoSpell,"SM_PROVOKE",5,10; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5555,'Leaf_Cat_Hat','Leaf Cat Hat',4,20,NULL,100,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,539,'bonus bAgi,2; bonus3 bAutoSpellWhenHit,"AL_HEAL",3,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5556,'Fur_Seal_Hat','Seal Hat',4,20,NULL,500,NULL,3,NULL,0,0xFFFFFFFF,63,2,769,NULL,'55',1,540,'bonus bInt,1; bonus3 bAutoSpell,"WZ_FROSTNOVA",1,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5557,'Wild_Rose_Hat','Wild Rose Hat',4,20,NULL,500,NULL,6,NULL,1,0xFFFFFFFE,63,2,256,NULL,'20',1,541,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5558,'Saci_Hat','Luxury Hat',4,20,NULL,100,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,542,'bonus3 bAddMonsterDropItem,510,RC_Plant,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5559,'Piece_Of_White_Cloth_E','Piece Of White Cloth',4,0,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,543,'bonus2 bAddClass,Class_All,6; bonus bMatkRate,6; bonus bLongAtkRate,6; bonus bHealPower,6; bonus bVariableCastrate,-20; bonus bAspd,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5560,'Bullock_Helm_J','Bullock Helm',4,20,NULL,3000,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'75',1,322,'bonus bMaxHP,100; bonus bNoKnockback; bonus2 bSubEle,Ele_Neutral,-20; bonus2 bSubEle,Ele_Fire,-20; bonus2 bSubEle,Ele_Water,-20; bonus2 bSubEle,Ele_Wind,-20; bonus2 bSubEle,Ele_Earth,-20; bonus2 bSubEle,Ele_Dark,-20; bonus2 bSubEle,Ele_Holy,-20; bonus2 bSubEle,Ele_Ghost,-20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5561,'Rabbit_Magic_Hat_J','Magic Rabbit Hat',4,0,NULL,800,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,497,'bonus bInt,1; bonus bMaxSP,50; bonus4 bAutoSpellWhenHit,"MG_FIREBOLT",3,10,3; bonus4 bAutoSpellWhenHit,"MG_COLDBOLT",3,10,3; bonus4 bAutoSpellWhenHit,"MG_LIGHTNINGBOLT",3,10,3; bonus3 bAutoSpellWhenHit,"AL_HEAL",1,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5562,'Good_Wedding_Veil_J','Luxurious Wedding Veil',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,63,2,768,NULL,'45',0,489,'bonus bMdef,10; bonus bVariableCastrate,-3; bonus bUseSPrate,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5563,'Dolor_Hat','Dolor Hat',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',0,547,'bonus3 bAutoSpell,"PR_LEXAETERNA",1,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5564,'Crown_Of_Deceit','Crown of Deceit',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,63,2,768,NULL,'85',1,544,'.@r = getrefine(); bonus bInt,4; bonus bMdef,10; bonus bVariableCastrate,-10; if(.@r==7||.@r==8){ bonus bDef,2; bonus bMatkRate,5; bonus bVariableCastrate,-5; } if(.@r>=9){ bonus bMdef,5; bonus bMatkRate,5; bonus bVariableCastrate,-5; bonus bDelayrate,-5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5565,'Dragon_Arhat_Mask','Dragon Arhat Mask',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFF,63,2,513,NULL,'1',0,545,'bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5566,'Tiger_Arhat_Mask','Tiger Arhat Mask',4,0,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,513,NULL,'1',0,546,'bonus2 bAddRace,RC_DemiHuman,2; bonus2 bAddRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5567,'Bright_Fury','Bright Fury',4,20,NULL,300,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,548,'bonus bStr,1; bonus2 bAddClass,Class_All,2; bonus bAspdRate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5568,'Rabbit_Bonnet','Rabbit Bonnet',4,20,NULL,1000,NULL,1,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',1,549,'bonus bInt,2; bonus bDelayRate,-3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5569,'Gemini_Diadem','Gemini Diadem',4,20,NULL,300,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,550,'bonus bDex,2; bonus bMatkRate,2; if(getrefine()>6) { bonus bDex,1; bonus bMatk,30; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5570,'Gemini_Crown','Gemini Crown',4,20,NULL,300,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,551,'bonus bAgi,2; bonus bFlee,10; if(getrefine()>6) { bonus bHit,5; bonus bAtk,30; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5571,'Rasta_Wig','Rasta Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,552,'bonus bStr,1; bonus3 bAutoSpellWhenHit,"BA_FROSTJOKER",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5572,'Savage_Baby_Hat','Savage Babe Hat',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,553,'bonus bVit,2; bonus2 bAddEff,Eff_Stun,500; bonus2 bSubRace,RC_Brute,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5573,'Bogy_Horn','Dokebi Horn',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'75',1,554,'bonus2 bAddMonsterDropItemGroup,IG_Jewel,100; bonus3 bAutoSpell,"MC_MAMMONITE",5,70;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5574,'Pencil_In_Mouth','Well-Chewed Pencil',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'10',0,555,'bonus bHit,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5575,'Onigiri_Hat','Rice Ball Hat',4,20,NULL,100,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',0,556,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5576,'Japan_Winecup','Wine Cup',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,557,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5577,'Dark_Knight_MaskB','Dark Knight Mask',4,NULL,NULL,3000,NULL,5,NULL,0,0xFFFFFFFF,63,2,769,NULL,'80',1,479,'bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5578,'Voyage_Hat','Voyage Hat',4,200,NULL,10,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,236,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5579,'Wanderer\'s_Sakkat','Wanderer\'s Sakkat',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,63,2,768,NULL,'1',1,558,'bonus bFlee,3; .@r = getrefine(); if(.@r>=7){ bonus bFlee,2; bonus bAgi,2; } if(.@r>=9){ bonus bCritical,10; bonus bAspdRate,8; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5580,'Red_Beret','Red Beret',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,559,'bonus bAllStats,3; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5581,'Cancer_Diadem','Cancer Diadem',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',1,560,'bonus bInt,2; bonus2 bSubEle,Ele_Water,5; if(getrefine()>6) { bonus bMdef,1; bonus bHealPower,3; bonus bMatkRate,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5582,'Cancer_Crown','Cancer Crown',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',1,561,'bonus bStr,2; bonus2 bSubEle,Ele_Water,5; if(getrefine()>6) { bonus bDef,1; bonus bBaseAtk,15; bonus bFlee,10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5583,'Para_Team_Hat','Eden Team Hat I',4,0,NULL,0,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'12',1,465,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5584,'Majestic_Evil_Horn','Majestic Evil Horns',4,0,NULL,400,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,562,'bonus2 bSubRace,RC_Demon,3; bonus2 bHPDrainRate,3,15; bonus2 bSPDrainRate,1,7; /*Gold PC Room bonus bSPGainValue,2; bonus bMagicSPGainValue,2; bonus2 bSubRace,RC_Demon,2;*/',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5585,'Rune_Hairband','Rune Cloth Circlet',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,63,2,768,NULL,'1',1,564,'bonus2 bSubEle,Ele_Neutral,3; bonus bHit,5; bonus2 bHPDrainRate,30,10; bonus2 bSPDrainRate,10,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5586,'Mosquito_Coil','Mosquito Coil',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,563,'bonus2 bAddDamageClass,1627,100; bonus2 bAddDamageClass,1095,20; bonus2 bAddDamageClass,1160,20; bonus2 bAddDamageClass,1105,20; bonus2 bAddDamageClass,1097,20; bonus2 bAddDamageClass,1051,20; bonus2 bAddDamageClass,1053,20; bonus2 bAddDamageClass,1054,20; bonus2 bAddDamageClass,1048,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5587,'Mosquito_Coil_1Use','Mosquito Coil',4,0,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,563,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5588,'Leo_Crown','Leo Crown',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,565,'bonus bStr,2; bonus2 bSubEle,Ele_Fire,5; if(getrefine()>6) { bonus bDef,1; bonus bFlee,10; bonus3 bAutoSpell,"TK_SEVENWIND",4,50; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5589,'Leo_Diadem','Leo Diadem',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,566,'bonus bDex,2; bonus2 bSubEle,Ele_Fire,5; if(getrefine()>6) { bonus bFlee,10; bonus bAspdRate,3; autobonus "{ bonus bSplashRange,1; }",10,10000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }"; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5590,'K_Poring_Cake_Cap','Poring Cake Hat',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,417,'bonus bLuk,3; bonus bMdef,5; bonus bMaxHP,BaseLevel*2; bonus bMaxSP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5591,'Desert_Prince','Desert Prince',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',0,567,'bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5592,'Sigrun\'s_Wing','Sigrun\'s Wings',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'80',0,568,'if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief||(BaseJob==Job_Taekwon&&Class!=Job_Soul_Linker)) bonus bAspd,1; else if(BaseClass==Job_Mage||BaseClass==Job_Acolyte||Class==Job_Ninja||Class==Job_Soul_Linker){ bonus bMatk,5; bonus bHealPower,2; } else if(BaseClass==Job_Archer||BaseClass==Job_Gunslinger) bonus bLongAtkRate,2; else if(BaseJob==Job_Novice||BaseJob==Job_SuperNovice) { bonus bMaxHP,120; bonus bMaxSP,60; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5593,'K_Rabbit_Bonnet','Rabbit Bonnet',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,63,2,768,NULL,'1',1,549,'bonus bBaseAtk,10; bonus bMatk,10; bonus2 bSubRace,RC_DemiHuman,3; bonus2 bSubRace,RC_Player,3; bonus bDelayRate,-3; if(getrefine()>6) { bonus2 bSubDefEle,Ele_All,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5594,'Donut_In_Mouth','Donut In Mouth',4,20,NULL,50,NULL,1,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,569,'bonus2 bHPRegenRate,1,10000; bonus bMaxHP,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5595,'Eye_Of_Juno','Eye Of Juno',4,20,NULL,400,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,570,'bonus bMdef,2; .@i = JobLevel/14; if(BaseClass==Job_Mage||BaseClass==Job_Archer||BaseClass==Job_Acolyte){ bonus bInt,2; bonus bDex,2; bonus2 bSubEle,Ele_Neutral,.@i; bonus2 bSubEle,Ele_Water,.@i; } else if(BaseClass==Job_Swordman||BaseClass==Job_Merchant||BaseClass==Job_Thief){ bonus bAgi,2; bonus bVit,2; bonus2 bSubEle,Ele_Neutral,.@i; bonus2 bSubEle,Ele_Water,.@i; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5596,'4Leaf_Clover_In_Mouth','4Leaf Clover In Mouth',4,20,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,571,'bonus bMdef,2; bonus2 bAddMonsterDropItem,12245,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5597,'Bubble_Gum_In_Mouth','Bubble Gum In Mouth',4,20,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,572,'bonus bBaseAtk,5; bonus bMatk,5; bonus bMdef,2; /*Gold PC Room: bonus bAllStats,1;*/',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5598,'Virgo_Crown','Virgo Crown',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',1,573,'bonus bDex,2; bonus bAspdRate,1; if(getrefine()>6) { bonus2 bSubEle,Ele_Earth,5; autobonus "{ bonus bDex,20; }",10,6000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }"; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5599,'Virgo_Diadem','Virgo Diadem',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'70',1,574,'bonus bAspdRate,3; bonus2 bSubEle,Ele_Earth,5; if(getrefine()>6) bonus3 bAutoSpell,"MO_BALKYOUNG",1,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5600,'Br_Twin_Ribbon','Brazil Twin Ribbon',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,575,'bonus bAllStats,3; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5601,'Br_Beret','Brazil Beret',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,576,'bonus bAllStats,3; bonus bMdef,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5602,'Jaguar_Hat_J','Jaguar Hat J',4,20,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,63,2,513,NULL,'50',0,530,'bonus2 bAddEle,Ele_Fire,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5603,'RTC_Winner_Only','RTC First Place',4,0,NULL,250,NULL,8,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,577,'bonus bAllStats,3; bonus bAspdRate,10; bonus2 bAddRace,RC_DemiHuman,5; bonus2 bAddRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5604,'RTC_Second_Best','RTC Second Place',4,0,NULL,250,NULL,6,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,578,'bonus bAllStats,2; bonus bAspdRate,7; bonus2 bAddRace,RC_DemiHuman,3; bonus2 bAddRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5605,'RTC_Third_Best','RTC Third Place',4,0,NULL,250,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,579,'bonus bAllStats,1; bonus bAspdRate,5; bonus2 bAddRace,RC_DemiHuman,1; bonus2 bAddRace,RC_Player,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5606,'Campume_Hat','Champune Hat',4,500,NULL,1200,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'3',1,580,'bonus bAllStats,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5607,'Lyria_Doll_Hat','Lyria Doll Hat',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',0,581,'bonus bMaxHP,500; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5608,'Dorothy_Doll_Hat','Dorothy Doll Hat',4,0,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',0,582,'bonus bMaxSP,80; bonus2 bSubRace,RC_DemiHuman,5; bonus2 bSubRace,RC_Player,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5609,'Chung_Hairband','Chung Hairband',4,0,NULL,500,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',0,583,'bonus bLuk,3; bonus bMdef,4; bonus3 bAutoSpellWhenHit,"MC_MAMMONITE",5,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5610,'Ice_Wing_Ear','Ice Wing Ear',4,0,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'10',0,584,'bonus bLuk,1; bonus3 bAutoSpellWhenHit,"MG_COLDBOLT",5,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5611,'Turtle_Hat','Turtle Hat',4,0,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,585,'bonus bAgi,1; bonus3 bAutoSpellWhenHit,"AL_DECAGI",3,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5612,'F_Blue_Drooping_Kitty','F Blue Drooping Kitty',4,250000,NULL,500,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,277,'bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5613,'F_Flying_Angel','F Flying Angel',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,264,'bonus bInt,1; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5614,'F_Smoking_Pipe_','F Smoking Pipe',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFE,63,2,1,NULL,'0',0,55,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5615,'F_Pair_Of_Red_Ribbon_','F Pair Of Red Ribbon',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'45',0,169,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5616,'F_Fish_On_Head_','F Fish On Head',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,149,'bonus bDex,1; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5617,'F_Hibiscus','F Hibiscus',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',0,210,'bonus bInt,1; bonus bDex,1; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5618,'F_Cat_Hat','F Cat Hat',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,182,'bonus bLuk,2; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5619,'F_Bunny_Band_','F Bunny Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,15,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5620,'F_Magestic_Goat_TW','F Magestic Goat TW',4,20,NULL,800,NULL,5,NULL,0,0x006444A2,63,2,256,NULL,'0',1,41,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5621,'F_Sheep_Hat','F Sheep Hat',4,20,NULL,150,NULL,1,NULL,0,0x00008110,63,2,256,NULL,'0',0,205,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5622,'F_Mini_Propeller_','F Mini Propeller',4,20,NULL,200,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,270,'bonus bDex,1; bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5623,'F_Alice_Doll','F Alice Doll',4,20,NULL,500,NULL,0,NULL,1,0xFFFFFFFE,63,2,256,NULL,'30',0,208,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5624,'F_Red_Glasses','F Red Glasses',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,316,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5625,'F_Chick_Hat','F Chick Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',0,311,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5626,'F_White_Deviruchi_Cap','F White Deviruchi Cap',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'64',1,272,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5627,'F_Vane_Hairpin','F Vane Hairpin',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',0,313,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5628,'F_Pecopeco_Hairband','F Pecopeco Hairband',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,314,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5629,'F_Vacation_Hat','F Vacation Hat',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',0,315,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5630,'F_Charming_Ribbon','F Charming Ribbon',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'10',1,211,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5631,'F_Water_Lily_Crown','F Water Lily Crown',4,20,NULL,200,NULL,0,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',0,312,'bonus bDex,1; bonus bAgi,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5632,'F_Vanilmirth_Hat','F Vanilmirth Hat',4,20,NULL,1000,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',0,317,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5633,'F_Drooping_Bunny_','F Drooping Bunny',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,249,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5634,'F_Kettle_Hat','F Kettle Hat',4,20,NULL,600,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',1,318,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5635,'F_Dragon_Skull','F Dragon Skull',4,20,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,319,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5636,'F_Ramen_Hat','F Ramen Hat',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,320,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5637,'F_Pink_Fur_Hat','F Pink Fur Hat',4,20,NULL,350,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,281,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5638,'F_Puppy_Hat','F Puppy Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',0,234,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5639,'F_Magic_Eyes','F Magic Eyes',4,20,NULL,300,NULL,1,NULL,0,0x00810204,63,2,256,NULL,'30',1,209,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5640,'F_Jumping_Poring','F Jumping Poring',4,0,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,349,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5641,'F_Robo_Eye','F Robo Eye',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'10',0,345,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5642,'F_Yellow_Wizardry_Hat','F Yellow Wizardry Hat',4,20,NULL,300,NULL,1,NULL,0,0x00810204,63,2,256,NULL,'0',1,286,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5643,'F_Crescent_Helm','F Crescent Helm',4,20,NULL,3000,NULL,8,NULL,0,0x000444A2,63,2,768,NULL,'50',1,213,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5644,'F_Tiger_Mask','F Tiger Mask',4,20,NULL,400,NULL,2,NULL,0,0xFFFFFFFF,63,2,768,NULL,'50',0,181,'bonus bStr,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5645,'F_Fantastic_Wig','F Fantastic Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',1,308,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5646,'F_Whisper_Mask','F Whisper Mask',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,769,NULL,'0',0,321,'bonus bAgi,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5647,'F_Bunny_Band_C','F Bunny Band C',4,1,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',0,15,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5648,'F_Centimental_Flower_C','F Centimental Flower C',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,63,2,1,NULL,'1',0,56,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5649,'F_Apple_Of_Archer_C','F Apple Of Archer C',4,1,NULL,0,NULL,7,NULL,0,0xFFFFFFFE,63,2,256,NULL,'1',0,72,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5650,'F_Elven_Ears_C','F Elven Ears C',4,1,NULL,0,NULL,2,NULL,0,0xFFFFFFFE,63,2,512,NULL,'1',0,73,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5651,'F_Brooch_C','F Brooch C',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bAgi,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5652,'F_Magestic_Goat_C','F Magestic Goat C',4,2,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,41,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5653,'Darkness_Helm_J','Darkness Helm',4,20,NULL,500,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'70',1,586,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5654,'Holy_Marching_Hat_J','Holy Marching Hat',4,20,NULL,200,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,587,'bonus bInt,1; bonus bMdef,5; bonus bMatkRate,2; .@r = getrefine(); if(.@r>=7) bonus bHealPower,5; if(.@r>=9){ bonus bMatk,5; bonus bHealPower,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5655,'Dark_Snake_Lord_Hat_J','Evil Snake Lord Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'60',1,372,'bonus bInt,2; bonus bAgi,2; bonus bDex,-2; autobonus "{ bonus bVariableCastrate,-50; bonus bFlee,30; }",50,5000,BF_MAGIC,"{ specialeffect2 EF_SUFFRAGIUM; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5656,'Scooter_Hat_J','Scooter Helmet',4,20,NULL,1000,NULL,7,NULL,1,0xFFFFFFFF,63,2,256,NULL,'50',1,588,'bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5657,'Antique_Pipe_J','Captain\'s Pipe',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'30',0,383,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5658,'Imp_Hat','Imp Hat',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,589,'bonus3 bAutoSpell,"SA_FLAMELAUNCHER",1,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5659,'Sleepr_Hat','Sleeper Hat',4,20,NULL,400,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,590,'bonus3 bAutoSpell,"SA_SEISMICWEAPON",1,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5660,'Gryphon_Hat','Gryphon Hat',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,591,'bonus bAgi,2; if (getrefine() > 6) { bonus bAgi,2; } if (getrefine() > 8) { bonus2 bAddRace,RC_Demon,10; bonus2 bAddRace,RC_Undead,10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5661,'Red_Pirate_Bandana','Red Pirate Bandana',4,0,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,592,'bonus bStr,1; bonus bDex,1; bonus bAspdRate,2; bonus bVariableCastrate,-2; bonus3 bAutoSpell,"MO_EXTREMITYFIST",1,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5662,'Libra_Crown','Libra Crown',4,10,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,593,'bonus bDex,3; bonus2 bSubEle,Ele_Wind,7; if (getrefine()>=7) { bonus bMatkRate,3; } if (getrefine()>=9) { bonus bMatkRate,5; bonus3 bAutoSpellWhenHit,"WZ_FROSTNOVA",5,20;}',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5663,'Libra_Diadem','Libra Diadem',4,10,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,594,'bonus bBaseAtk,7; if (getrefine()>=7) { bonus3 bAutoSpell,"TK_SEVENWIND",2,5; } if (getrefine()>=9) { bonus bFlee,5; bonus2 bAddClass,Class_All,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5664,'Filir_Wing','Filir\'s Pinions',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',1,595,'bonus bAspdRate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5665,'Shaman_Hat','Shaman Hat',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,596,'bonus bMdef,5; bonus2 bSubEle,Ele_Neutral,3; bonus2 bSubEle,Ele_Water,3; bonus2 bSubEle,Ele_Earth,3; bonus2 bSubEle,Ele_Fire,3; bonus2 bSubEle,Ele_Wind,3; bonus2 bSubEle,Ele_Poison,3; bonus2 bSubEle,Ele_Holy,3; bonus2 bSubEle,Ele_Dark,3; bonus2 bSubEle,Ele_Ghost,3; bonus2 bSubEle,Ele_Undead,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5666,'Golden_Crown','Golden Crown',4,20,NULL,500,NULL,8,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,597,'bonus bInt,1; bonus bDex,1; bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5667,'Skull_Hood','Skull Hood',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,2,768,NULL,'30',1,598,'bonus2 bSubRace,RC_Demon,10; bonus2 bSubRace,RC_Undead,10; if(getrefine()>=7) autobonus "{ bonus bCritical,30; bonus bHit,10; }",10,10000,0,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5668,'Weird_Pumpkin_Hat','Weird Pumpkin Hat',4,20,NULL,0,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,206,'bonus bMdef,5; bonus2 bAddMonsterDropItem,6097,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5669,'Poring_Party_Hat_J','Poring Party Hat J',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,340,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5670,'Aniv_Star_Hat','Aniv Star Hat',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,599,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5671,'Drooping_Morocc_Minion','Drooping Morocc Minion',4,20,NULL,300,NULL,0,NULL,1,0xFFFFFFFF,63,2,256,NULL,'70',0,600,'bonus bSPGainValue,2; bonus3 bAutoSpellWhenHit,"NPC_CRITICALWOUND",2,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5672,'Southern_Cross','Southern Cross',4,20,NULL,600,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'50',1,601,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5673,'Home_Cherry_Blossom','Home Cherry Blossom',4,20,NULL,100,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,602,'bonus bNoCastCancel; bonus bVariableCastrate,35;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5674,'Pig_Moneybox','Pig Moneybox',4,20,NULL,1000,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',0,603,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5675,'Poring_Letter','Poring Letter',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'10',0,604,'bonus2 bAddMonsterDropItem,619,10; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5676,'Scorpio_Crown','Scorpio Crown',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,605,'bonus bAspdRate,3; bonus2 bSubEle,Ele_Water,5; .@r = getrefine(); if (.@r>6) { bonus3 bAutoSpell,"TK_SEVENWIND",3,20; } if (.@r>7) { bonus bAspdRate,2; } if (.@r>8) { bonus3 bAutoSpell,"WZ_FROSTNOVA",5,10; } if (.@r>9) { bonus bAspdRate,2; bonus bBaseAtk,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5677,'Scorpio_Diadem','Scorpio Diadem',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,606,'bonus bDex,2; if (getrefine()>6) { bonus bDex,1; bonus bAtk,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5678,'Notation_Hairband','Notation Hairband',4,200,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,607,'bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5679,'Engineer_Cap','Engineer Cap',4,20,NULL,200,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'10',1,608,'bonus2 bAddRace,RC_Formless,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5680,'Hawkeyes','Hawkeyes',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'10',0,609,'bonus bHit,10; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5681,'F_Ribbon_Green','Green Ribbon',4,800,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,0,256,NULL,'0',1,244,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5682,'Triangle_Rune_Cap','Triangle Rune Cap',4,20,NULL,300,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,610,'bonus bInt,1; bonus bHealPower,2; if (getrefine() > 6) { bonus bMatk,10; bonus5 bAutoSpellWhenHit,"NPC_MAGICMIRROR",8,150,BF_MAGIC,0; } else { bonus5 bAutoSpellWhenHit,"NPC_MAGICMIRROR",7,150,BF_MAGIC,0; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5683,'Majestic_Goat_Repl','Baphomet Horns',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,41,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5684,'Jewel_Crown_Repl','Ornate Crown',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,88,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5685,'Prontera_Army_Cap_Repl','Army Cap',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,48,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5686,'Feather_Bonnet_Repl','Nice Hat Feather',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,104,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5687,'Viking_Helm_Repl','Orc Helm',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,86,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5688,'2009Love_Daddy','2009 Love Dad',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,611,'bonus bVit,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5689,'Queen_Ant_Diadem','Queen Ant Diadem',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'75',1,612,'bonus3 bAutoSpellWhenHit,"MG_SIGHT",1,5; bonus2 bSubRace,RC_Insect,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5690,'Red_Wing_Hat','Red Wing Hat',4,20,NULL,600,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,613,'bonus bHPrecovRate,20; bonus bSPrecovRate,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5691,'Catain_Bandanna','Sailor\'s Bandana',4,20,NULL,10,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,542,'bonus bDex,1; bonus2 bSubEle,Ele_Poison,20; bonus2 bResEff,Eff_Poison,2000; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5692,'Sea_Cat_Hat','Sea Cat Hat',4,20,NULL,10,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,539,'bonus bDex,1; bonus2 bResEff,Eff_Curse,2000; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5693,'No_Fear_Underware','No Fear Underwear',4,0,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'20',0,30,'bonus bStr,1; bonus bInt,1; bonus bDex,1; bonus bMaxHP,700; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5694,'No_Fear_P_Headgear','No Fear P Headgear',4,0,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'20',0,614,'bonus bVit,1; bonus bMaxHP,100; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5695,'E_Blue_Drooping_Kitty','E Blue Drooping Kitty',4,250000,NULL,500,NULL,1,NULL,0,0,7,2,256,NULL,'0',1,277,'bonus bMdef,15;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5696,'E_Flying_Angel','E Flying Angel',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,264,'bonus bInt,1; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5697,'E_Smoking_Pipe_','E Smoking Pipe',4,20,NULL,100,NULL,0,NULL,0,0,7,2,1,NULL,'0',0,55,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5698,'E_Pair_OE_Red_Ribbon_','E Pair OE Red Ribbon',4,20,NULL,100,NULL,1,NULL,0,0,7,2,512,NULL,'45',0,169,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5699,'E_Fish_On_Head_','E Fish On Head',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,149,'bonus bDex,1; bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5700,'E_Hibiscus','E Hibiscus',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',0,210,'bonus bInt,1; bonus bDex,1; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5701,'E_Cat_Hat','E Cat Hat',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,182,'bonus bLuk,2; bonus bMdef,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5702,'E_Bunny_Band_','E Bunny Band',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,15,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5703,'E_Magestic_Goat_TW','E Magestic Goat TW',4,20,NULL,800,NULL,5,NULL,0,0x006444A2,63,2,256,NULL,'0',1,41,'bonus bStr,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5704,'E_Sheep_Hat','E Sheep Hat',4,20,NULL,150,NULL,1,NULL,0,0x00008110,63,2,256,NULL,'0',0,205,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5705,'E_Mini_Propeller_','E Mini Propeller',4,20,NULL,200,NULL,2,NULL,0,0,7,2,256,NULL,'0',1,270,'bonus bDex,1; bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5706,'E_Alice_Doll','E Alice Doll',4,20,NULL,500,NULL,0,NULL,1,0xFFFFFFFE,63,2,256,NULL,'30',0,208,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5707,'E_Red_Glasses','E Red Glasses',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,316,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5708,'E_Chick_Hat','E Chick Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',0,311,'bonus bLuk,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5709,'E_White_Deviruchi_Cap','E White Deviruchi Cap',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFE,63,2,256,NULL,'64',1,272,'bonus bStr,1; bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5710,'E_Vane_Hairpin','E Vane Hairpin',4,20,NULL,300,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',0,313,'bonus bAgi,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5711,'E_Pecopeco_Hairband','E Pecopeco Hairband',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,314,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5712,'E_Vacation_Hat','E Vacation Hat',4,20,NULL,200,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',0,315,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5713,'E_Charming_Ribbon','E Charming Ribbon',4,20,NULL,400,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'10',1,211,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5714,'E_Water_Lily_Crown','E Water Lily Crown',4,20,NULL,200,NULL,0,NULL,1,0,7,2,256,NULL,'30',0,312,'bonus bDex,1; bonus bAgi,1; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5715,'E_Vanilmirth_Hat','E Vanilmirth Hat',4,20,NULL,1000,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',0,317,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5716,'E_Drooping_Bunny_','E Drooping Bunny',4,20,NULL,100,NULL,1,NULL,0,0,7,2,256,NULL,'0',1,249,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5717,'E_Kettle_Hat','E Kettle Hat',4,20,NULL,600,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',1,318,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5718,'E_Dragon_Skull','E Dragon Skull',4,20,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,319,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5719,'E_Ramen_Hat','E Ramen Hat',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,320,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5720,'E_Pink_Fur_Hat','E Pink Fur Hat',4,20,NULL,350,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,281,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5721,'E_Puppy_Hat','E Puppy Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',0,234,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5722,'E_Magic_Eyes','E Magic Eyes',4,20,NULL,300,NULL,1,NULL,0,0x00810204,63,2,256,NULL,'30',1,209,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5723,'E_Jumping_Poring','E Jumping Poring',4,0,NULL,300,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,349,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5724,'E_Robo_Eye','E Robo Eye',4,20,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'10',0,345,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5725,'E_Yellow_Wizardry_Hat','E Yellow Wizardry Hat',4,20,NULL,300,NULL,1,NULL,0,0x00810204,63,2,256,NULL,'0',1,286,'bonus bInt,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5726,'E_Crescent_Helm','E Crescent Helm',4,20,NULL,3000,NULL,8,NULL,0,0x000444A2,63,2,768,NULL,'50',1,213,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5727,'E_Tiger_Mask','E Tiger Mask',4,20,NULL,400,NULL,2,NULL,0,0xFFFFFFFF,63,2,768,NULL,'50',0,181,'bonus bStr,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5728,'E_Fantastic_Wig','E Fantastic Wig',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,768,NULL,'0',1,308,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5729,'E_Bunny_Band_C','E Bunny Band C',4,1,NULL,0,NULL,9,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',0,15,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5730,'E_Centimental_Flower_C','E Centimental Flower C',4,1,NULL,0,NULL,1,NULL,0,0xFFFFFFFE,63,2,1,NULL,'1',0,56,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5731,'E_Apple_OE_Archer_C','E Apple OE Archer C',4,1,NULL,0,NULL,7,NULL,0,0xFFFFFFFE,63,2,256,NULL,'1',0,72,'bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5732,'E_Elven_Ears_C','E Elven Ears C',4,1,NULL,0,NULL,2,NULL,0,0xFFFFFFFE,63,2,512,NULL,'1',0,73,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5733,'E_Brooch_C','E Brooch C',4,1,NULL,0,NULL,0,NULL,0,0xFFFFFFFE,63,2,136,NULL,'1',0,0,'bonus bAgi,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5734,'E_Magestic_Goat_C','E Magestic Goat C',4,2,NULL,0,NULL,5,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',0,41,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5735,'E_Ribbon_Green','Green Ribbon',4,800,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,0,256,NULL,'0',1,244,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5736,'EF_Whisper_Mask','Whisper Mask',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,769,NULL,'0',0,321,'bonus bAgi,3; bonus2 bSubEle,Ele_Ghost,-10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5737,'Cactus_Hat','Cactus Hat',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',0,615,'bonus3 bAddMonsterDropItem,952,RC_Plant,500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5738,'Snowman_Hat','Snowman Hat',4,20,NULL,300,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,616,'bonus bStr,1; bonus bInt,1; bonus bMdef,3; bonus2 bSubEle,Ele_Water,7; bonus2 bAddMonsterDropItem,12354,100; bonus2 bAddMonsterDropItem,530,300; bonus5 bAutoSpellwhenhit,"BA_FROSTJOKER",(getrefine()>7?5:1),20,BF_WEAPON|BF_MAGIC,0;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5739,'Sagittarius_Crown','Sagittarius Crown',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,617,'bonus bDex,2; bonus2 bSubEle,Ele_Fire,7; .@r = getrefine(); if (.@r>6) { bonus bAspdRate,2; } if (.@r>7) { bonus bAgi,2; } if (.@r>8) { bonus bLongAtkRate,5; } if (.@r>9) { autobonus "{ bonus bAgi,10; bonus bDex,10; }",3,10000,0,"{ specialeffect2 EF_ENHANCE; }"; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5740,'Sagittarius_Diadem','Sagittarius Diadem',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,618,'bonus bDex,2; bonus bMdef,3; bonus2 bSubEle,Ele_Fire,7; .@r = getrefine(); if (.@r>6) { bonus bVariableCastrate,-3; } if (.@r>7) { bonus5 bAutoSpell,"WZ_SIGHTRASHER",10,5,BF_MAGIC,0; } if (.@r>8) { bonus bVariableCastrate,-2; } if (.@r>9) { bonus bMatkRate,4; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5741,'Im_Egg_Shell_Hat','Eternal Egg Shell',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,101,'bonus2 bAddItemGroupHealRate,IG_Potion,10; bonus bHealPower2,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5742,'Rudolf_Santa_Hat','Rudolph Santa Hat',4,20,NULL,400,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'10',1,619,'bonus2 bAddMonsterDropItem,538,100; bonus2 bAddMonsterDropItem,539,100; bonus2 bAddItemHealRate,538,100; bonus2 bAddItemHealRate,539,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5743,'Orange_Stem_Hat','Orange Stem Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',0,620,'bonus bLuk,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5744,'Capricorn_Crown','Capricorn Crown',4,20,NULL,300,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,621,'bonus bVit,2; bonus bDex,2; if (getrefine()>6) { bonus3 bAutoSpell,"TK_SEVENWIND",1,500; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5745,'Capricorn_Diadem','Capricorn Diadem',4,20,NULL,300,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,622,'bonus bDex,2; bonus bMdef,5; bonus2 bSubEle,Ele_Earth,5; .@r = getrefine(); if (.@r>6) { bonus bInt,2; } if (.@r>7) { bonus bVariableCastrate,-3; } if (.@r>8) { bonus bHealPower2,4; } if (.@r>9) { bonus3 bAutoSpell,"BS_HAMMERFALL",5,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5746,'Rune_Circlet','Rune Circlet',4,20,NULL,100,NULL,12,NULL,1,0x00000080,56,2,256,NULL,'100',1,623,'bonus bStr,1; bonus bInt,1; bonus bMdef,5; if(readparam(bStr)>=120){ bonus bBaseAtk,10; bonus bMatk,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5747,'Mitra','Mitra',4,20,NULL,100,NULL,12,NULL,1,0x00000100,56,2,256,NULL,'100',1,624,'bonus bVit,1; bonus bInt,1; bonus bMdef,5; bonus bHealPower,5; if(readparam(bInt)>=120){ bonus bMatk,10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5748,'Sniper_Goggle','Sniper Goggles',4,20,NULL,100,NULL,12,NULL,1,0x00000800,56,2,768,NULL,'100',1,625,'bonus bAgi,1; bonus bDex,1; bonus bMdef,5; if(readparam(bAgi)>=120){ bonus bLongAtkRate,4; bonus bAspd,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5749,'Driver_Band','Driver Band',4,20,NULL,100,NULL,12,NULL,1,0x00000400,56,1,256,NULL,'100',1,626,'bonus bStr,1; bonus bDex,1; bonus bMdef,5; if(readparam(bStr)>=120){ bonus bBaseAtk,10; bonus bCritical,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5750,'Shadow_Handicraft','Shadow Crown',4,20,NULL,100,NULL,12,NULL,1,0x00020000,56,2,256,NULL,'100',1,627,'bonus bAgi,1; bonus bInt,1; bonus bMdef,5; if(readparam(bAgi)>=120){ bonus bBaseAtk,10; bonus bFlee,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5751,'Minstrel_Song_Hat','Minstrel Song Hat',4,20,NULL,100,NULL,12,NULL,1,0x00080000,56,1,256,NULL,'100',1,628,'bonus bInt,1; bonus bLuk,1; bonus bMdef,5; bonus bLongAtkRate,5; bonus2 bSkillUseSP,"MI_RUSH_WINDMILL",10; bonus2 bSkillUseSP,"MI_ECHOSONG",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5752,'Midas_Whisper','Midas Whispers',4,20,NULL,100,NULL,12,NULL,1,0x00040000,56,2,256,NULL,'100',1,629,'bonus bStr,1; bonus bDex,1; bonus bMdef,5; if(readparam(bStr)>=120){ bonus bBaseAtk,5; bonus bAspd,1; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5753,'Magic_Stone_Hat','Magic Stone Hat',4,20,NULL,100,NULL,12,NULL,1,0x00000200,56,2,256,NULL,'100',1,630,'bonus bInt,1; bonus bDex,1; bonus bMdef,5; if(readparam(bDex)>=120){ bonus bMatk,10; bonus bVariableCastrate,-2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5754,'Blazing_Soul','Burning Spirit',4,20,NULL,100,NULL,12,NULL,1,0x00008000,56,2,256,NULL,'100',1,631,'bonus bStr,1; bonus bVit,1; bonus bMdef,5; if(readparam(bStr)>=120){ bonus bBaseAtk,10; bonus bHit,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5755,'Silent_Executer','Silent Enforcer',4,20,NULL,100,NULL,12,NULL,0,0x00001000,56,2,513,NULL,'100',0,632,'bonus bAgi,1; bonus bMdef,5; if(readparam(bAgi)>=120){ bonus bBaseAtk,10; bonus bFlee2,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5756,'Wind_Whisper','Wispers of Wind',4,20,NULL,100,NULL,12,NULL,1,0x00010000,56,2,256,NULL,'100',1,633,'bonus bInt,1; bonus bDex,1; bonus bMdef,5; if(readparam(bInt)>=120){ bonus bMatk,10; bonus bFlee,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5757,'Schmidt_Helm','Reissue Schmitz Helm',4,20,NULL,100,NULL,12,NULL,1,0x00004000,56,2,768,NULL,'100',1,634,'bonus bVit,2; bonus bInt,1; bonus bMdef,5; if(readparam(bInt)>=120){ bonus bMatk,10; bonus bDef,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5758,'Dying_Swan','Resting Swan',4,20,NULL,100,NULL,17,NULL,1,0x00080000,56,0,256,NULL,'100',1,635,'bonus bInt,1; bonus bLuk,1; bonus bMdef,5; bonus bLongAtkRate,5; bonus2 bSkillUseSP,"WA_SWING_DANCE",10; bonus2 bSkillUseSP,"WA_SYMPHONY_OF_LOVER",10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5759,'Noah_Hat','Noah Hat',4,20,NULL,500,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,636,'bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5760,'Driver_Band_','Driver Band',4,20,NULL,100,NULL,12,NULL,1,0x00000400,56,0,256,NULL,'100',1,637,'bonus bStr,1; bonus bDex,1; bonus bMdef,5; if(readparam(bStr)>=120){ bonus bBaseAtk,10; bonus bCritical,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5761,'Sloth_Hat','Sloth Hat',4,20,NULL,800,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,638,'bonus bAgi,2; bonus3 bAutoSpell,"AS_SONICBLOW",5,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5762,'Duneyrr_Helm','Duneyrr Helm',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,639,'bonus bAllStats,1; bonus bMdef,5; bonus2 bSubRace,RC_DemiHuman,2; bonus2 bSubRace,RC_Player,2; bonus2 bSubRace,RC_Brute,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5763,'Red_Bunny_Band','Red Bunny Band',4,0,NULL,200,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,640,'bonus bAgi,2; bonus bMdef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5764,'Love_Rabbit_Hood','Love Rabbit Hood',4,20,NULL,300,NULL,1,NULL,1,0xFFFFFFFF,63,2,769,NULL,'10',0,549,'bonus3 bAutoSpell,"PR_GLORIA",3,((readparam(bAgi)>=80)?30:10);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5765,'Black_Tail_Ribbon','Black Tail Ribbon',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,256,NULL,'10',1,642,'bonus bMdef,5; bonus bLongAtkDef,10; bonus2 bSubEle,Ele_Neutral,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5766,'Amistr_Cap','Amistr Cap',4,20,NULL,500,NULL,4,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,643,'bonus bVit,1+(getrefine()/2); bonus5 bAutoSpell,"KN_PIERCE",5,10,BF_WEAPON,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5767,'Samurai_Mask','Samurai Mask',4,20,NULL,300,NULL,1,NULL,0,0xFFFFFFFF,63,2,1,NULL,'50',0,644,'bonus2 bAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5768,'Sakura_Coronet','Sakura Coronet',4,20,NULL,800,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,645,'bonus bMdef,3; bonus bMaxSP,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5769,'Gold_Angel_Sculpture','Gold Angel Sculpture',4,100,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',0,646,'skill "RG_GRAFFITI",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5770,'Splash_Hat','Splash Hat',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,649,'autobonus "{}",3,180000,BF_WEAPON,"{ sc_start SC_WINDWEAPON,180000,1; specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5771,'Family_Hat','Family Hat',4,20,NULL,100,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,650,'bonus bDex,1; bonus bMdef,1; bonus bMaxHPrate,2; bonus bMaxSPrate,2; skill "PR_MAGNIFICAT",1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5772,'Red_Navy_Hat','Red Navy Hat',4,3000,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'95',1,651,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5773,'Navy_Beret','Navy Beret',4,3000,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'95',1,652,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5774,'Red_Pirate_Hat','Red Pirate Hat',4,3000,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'95',1,496,'bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5775,'Choco_Donut_In_Mouth','Choco Donut In Mouth',4,20,NULL,50,NULL,1,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,653,'bonus bMaxHP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5776,'Blazing_Sun','Blazing Sun',4,0,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,654,'bonus2 bVariableCastrate,"MG_FIREBOLT",-5; bonus2 bSkillAtk,"MG_FIREBOLT",5; bonus2 bVariableCastrate,"MG_FIREBALL",-5; bonus2 bSkillAtk,"MG_FIREBALL",5; bonus2 bSkillAtk,"MG_FIREWALL",3; bonus2 bSkillAtk,"WZ_METEOR",3; bonus bUseSPrate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5777,'Remover_Hat','Remover Hat',4,20,NULL,800,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',0,655,'bonus bMdef,1; bonus3 bAddMonsterDropItem,713,RC_Formless,200; bonus3 bAddMonsterDropItem,971,RC_Formless,30; bonus3 bAddMonsterDropItem,972,RC_Formless,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5778,'Blue_Arara_Hat','Blue Arara Hat',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,656,'bonus bStr,2; autobonus "{ bonus bAspdRate,5; }",10,10000,0,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5779,'Drooping_Boto','Drooping Boto',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,657,'bonus bInt,2; autobonus "{ bonus bMatkRate,3; }",10,10000,BF_MAGIC,"{ specialeffect2 EF_SUFFRAGIUM; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5780,'Tendrilion_Hat','Tendrilion Hat',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,658,'skill "WZ_EARTHSPIKE",3; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5781,'Persika','Persika',4,20,NULL,100,NULL,0,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',0,659,'bonus bFlee,1; bonus bMaxSP,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5782,'Hoplite_Helmet','Hoplite Helmet',4,20,NULL,700,'0',4,0,1,0xFFFFFFFF,63,2,769,NULL,'1',1,660,'bonus bMaxHPrate,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5783,'YellowBunny_Hairband','YellowBunny Hairband',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,662,'bonus bStr,1; bonus bInt,1; bonus bDex,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5784,'PinkBunny_Hairband','PinkBunny Hairband',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,663,'bonus bStr,1; bonus bInt,2; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5785,'Green_Bunny_Hairband','Green Bunny Hairband',4,20,NULL,200,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,664,'bonus bStr,2; bonus bInt,1; bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5786,'Ancient_Elven_Ear','Ancient Elven Ear',4,10,NULL,200,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'1',0,665,'bonus bLuk,1; bonus bMaxHP,100; bonus bMaxSP,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5787,'Tha_Maero_Mask','Tha Maero Mask',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,513,NULL,'30',0,666,'bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5788,'3D_Glasses','3D Glasses',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'1',0,661,'bonus2 bMagicAddRace,RC_Formless,4; bonus2 bSubEle,Ele_Neutral,5; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5789,'Thanatos_Mal_Mask','Thanatos Mal Mask',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,513,NULL,'30',0,667,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5790,'Holy_Mom_Love','TM',4,20,NULL,500,NULL,0,NULL,1,0xFFFFFFFF,63,2,768,NULL,'45',1,610,'bonus2 bSubRace,RC_Demon,-5; bonus2 bSubRace,RC_Undead,-5; bonus3 bAutoSpell,"AL_BLESSING",1,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5791,'Tenkaippin_Ramen','Tenkaippin Ramen',4,20,NULL,500,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',0,668,'bonus bInt,-1; bonus bDex,4;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5792,'Fish_Pin','Fish Pin',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,669,'bonus2 bSubRace,RC_Fish,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5793,'Ribbon_Of_Life','Ribbon Of Life',4,20,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'1',0,575,'bonus bInt,1; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5794,'3D_Glasses_','3D Glasses',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,512,NULL,'1',0,661,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5795,'Red_Dress_Hat','Red Dress Hat',4,20,NULL,0,NULL,0,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,670,'bonus bMdef,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5796,'Cheer_Scarf','Cheer Scarf',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,369,'bonus2 bExpAddClass,Class_All,10; bonus bMaxHP,200; bonus bMaxSP,50;',NULL,NULL);
#REPLACE INTO `item_db_re` VALUES (5796,'Rooting_Scarf','Rooting Scarf',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,369,'bonus2 bExpAddClass,Class_All,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5797,'Cheer_Scarf2','Cheer Scarf2',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,369,'bonus2 bExpAddClass,Class_All,20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5798,'Cheer_Scarf3','Cheer Scarf3',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,369,'bonus2 bExpAddClass,Class_All,30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5799,'Cheer_Scarf4','Cheer Scarf4',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,369,'bonus2 bExpAddClass,Class_All,40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5800,'Blush_Of_Groom','Blush of Groom',4,20,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,125,'bonus2 bSubRace,RC_DemiHuman,3; bonus2 bSubRace,RC_Player,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5801,'Ribbon_Of_Bride','Red Tailed Ribbon',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,167,'bonus bAllStats,2; bonus2 bSubRace,RC_DemiHuman,10; bonus2 bSubRace,RC_Player,10; bonus3 bAutoSpellWhenHit,"AL_HEAL",(getskilllv("AL_HEAL")==10?10:5),20;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5802,'Upgrade_Elephant_Hat','Upgraded Elephant Hat',4,0,NULL,500,NULL,3,NULL,1,0xFFFFFFFF,63,2,256,NULL,'0',1,215,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5803,'Flower_Love_Hat','Love Flower Hat',4,20,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,5,'bonus2 bAddMonsterDropItem,608,100;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5804,'Pirate_Eyepatch','Pirate Eye Bandage',4,1000,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,13,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5805,'Victorious_Coronet','Victorious Coronet',4,0,NULL,150,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'70',0,43,'bonus bMaxHPrate,15; bonus bSPrecovRate,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5806,'Poem_Natalia_Hat','Poet Natalie\'s Hat',4,20,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,67,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5807,'October_Fest_Cap','October Fest Cap',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFE,63,2,256,NULL,'50',1,104,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5808,'Diabolus_Helmet','Dark Bacilium',4,20,NULL,250,NULL,5,NULL,1,0x000FDF80,18,2,769,NULL,'0',1,364,'.@r = getrefine(); bonus2 bResEff,Eff_Stone,2000+(.@r*200); bonus2 bResEff,Eff_Freeze,2000+(.@r*200); bonus2 bResEff,Eff_Stun,2000+(.@r*200);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5809,'Boom_Boom_Hat','Boom Boom Hat',4,0,NULL,100,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,216,'bonus bAllStats,5; bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5810,'Ph.D_Hat_V','Ph.D Hat V',4,20,NULL,100,NULL,3,NULL,0,0xFFFFFFFE,63,2,256,NULL,'0',1,98,'bonus bInt,5; bonus bVit,3; bonus bDex,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5811,'Santa_Beard','Santa\'s Beard',4,20,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,25,'bonus2 bSubRace,RC_Brute,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5812,'Hat_Of_Expert','Hat Of Expert',4,0,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,16,'bonus3 bAddEffWhenHit,Eff_Bleeding,500,ATF_TARGET|ATF_SELF; bonus3 bAddEffWhenHit,Eff_Silence,500,ATF_TARGET|ATF_SELF; bonus3 bAddEffWhenHit,Eff_Confusion,500,ATF_TARGET|ATF_SELF; bonus3 bAddEffWhenHit,Eff_Curse,500,ATF_TARGET|ATF_SELF; bonus3 bAddEffWhenHit,Eff_Blind,500,ATF_TARGET|ATF_SELF;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5813,'Red_Ph.D_Hat','Red Ph.D Hat',4,1000,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,481,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5814,'Ati_Atihan_Hat3','Ati Atihan Hat3',4,20,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,769,NULL,'20',0,303,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5815,'Classic_Hat_J','Classic Hat',4,20,NULL,500,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,475,'bonus bStr,1; bonus2 bSubSize,Size_All,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5816,'Cowboy_Hat_J','Purple Cowboy Hat',4,20,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,411,'bonus bBaseAtk,15; bonus bFlee,-5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5817,'Valentine_Pledge','Valentine Pledge',4,20,NULL,0,NULL,3,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bAllStats,2; bonus bMdef,3; bonus bHealPower,10; bonus2 bAddClass,Class_All,3; bonus bMatkRate,3; bonus bFlee,10; bonus bAspdRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5818,'Carnival_Hat','Carnival Hat',4,0,NULL,0,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,505,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5819,'Carnival_Circlet','Carnival Circlet',4,0,NULL,0,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,506,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5820,'Black_Elven_Ears','Black Elven Ears',4,10,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,512,NULL,'0',0,498,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5821,'Gold_Tulip_Hairpin','Gold Tulip Hairpin',4,10,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,499,'bonus2 bExpAddClass,Class_All,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5822,'Love_Chick_Hat','Love Chick Hat',4,10000,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,500,'bonus bLuk,4; bonus bMaxHP,100; bonus bMaxSP,100; bonus2 bSubRace,RC_Brute,7; bonus2 bSubRace,RC_DemiHuman,7; bonus2 bSubRace,RC_Player,7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5823,'Love_Arrow','Love Arrow',4,5000,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bDex,5; bonus bAgi,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5824,'Fools_Day_Hat','Fools Day Hat',4,20,NULL,300,NULL,6,NULL,0,0xFFFFFFFF,63,2,256,NULL,'30',1,265,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5825,'Badge_Of_Order_Grace','Badge Of Order Grace',4,0,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,136,NULL,'0',0,0,'bonus bMdef,1; bonus2 bAddClass,Class_All,10; bonus bMatkRate,10; bonus bMaxHP,1500;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5826,'Valkyrie_Helmet','Valkyrie Helmet',4,0,NULL,0,NULL,10,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',0,225,'bonus bStr,2; bonus bInt,2; bonus bDex,2; bonus bAgi,2; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5827,'Book_File_Hat','Book File Hat',4,20,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,423,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5828,'Honor_Gold_Ring','Honor Gold Ring',4,0,NULL,50,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bAllStats,1; bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5829,'Ordinary_Armor','Ordinary Armor',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,16,NULL,'30',1,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5830,'Woe_Sahkkat','Woe Sahkkat',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'60',1,67,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5831,'Woe_Big_Sis_Ribbon','Woe Big Sis Ribbon',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'60',1,28,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5832,'Woe_Vane_Hairpin','Woe Vane Hairpin',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'60',1,313,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5833,'Woe_Picnic_Hat','Woe Picnic Hat',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'60',1,117,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5834,'Woe_Crown','Woe Crown',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'60',1,45,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5835,'Woe_Tiara','Woe Tiara',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'60',1,19,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5836,'Woe_Boys_Cap','Woe Boys Cap',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'60',1,102,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5837,'Woe_Sunglass','Woe Sunglass',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,12,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5838,'Woe_Fin_Helm','Woe Fin Helm',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,100,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5839,'Woe_Blush','Woe Blush',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,125,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5840,'Woe_Elven_Ears','Woe Elven Ears',4,20,NULL,10,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,73,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5841,'Shaman_Hat_','Shaman Hat',4,20,NULL,100,NULL,1,NULL,1,0xFFFFFFFF,63,2,256,NULL,'30',1,596,'bonus bLuk,2; bonus3 bSubEle,Ele_Neutral,3,BF_MAGIC; bonus3 bSubEle,Ele_Water,3,BF_MAGIC; bonus3 bSubEle,Ele_Earth,3,BF_MAGIC; bonus3 bSubEle,Ele_Fire,3,BF_MAGIC; bonus3 bSubEle,Ele_Wind,3,BF_MAGIC; bonus3 bSubEle,Ele_Poison,3,BF_MAGIC; bonus3 bSubEle,Ele_Holy,3,BF_MAGIC; bonus3 bSubEle,Ele_Dark,3,BF_MAGIC; bonus3 bSubEle,Ele_Ghost,3,BF_MAGIC; bonus3 bSubEle,Ele_Undead,3,BF_MAGIC;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5842,'Loyal_Ring1','Loyal Ring1',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5843,'Loyal_Ring2','Loyal Ring2',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bAllStats,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5844,'Loyal_Ring3','Loyal Ring3',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,136,NULL,'1',0,0,'bonus bAllStats,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5845,'Buzzy_Ball_Board','Buzzy Ball Board',4,50,NULL,400,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,641,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5846,'Buzzy_Ball_Gum','Buzzy Ball Gum',4,50,NULL,100,NULL,1,NULL,0,0xFFFFFFFF,63,2,1,NULL,'1',0,572,'bonus bMdef,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5847,'Fools_Day_hat_','Fools Day Helmet',4,0,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',0,647,'bonus bInt,5; bonus bVit,-3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5848,'Robin_Eyepatch','Robin Eyepatch',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'1',0,50,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5849,'Doctor_Hairband','Doctor Hairband',4,20,NULL,0,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',0,60,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5850,'Golden_Savage_Hat','Golden Savage Hat',4,20,NULL,500,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'50',1,648,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5851,'Summer_Knight','Summer Knight',4,20,NULL,0,NULL,1,NULL,0,0xFFFFFFFF,63,2,768,NULL,'60',0,138,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5852,'Easter_Egg_Shell','Easter Egg Shell',4,20,NULL,500,NULL,0,NULL,0,0xFFFFFFFF,63,2,256,NULL,'40',1,537,'bonus bDef,-7; bonus bMdef,-7; bonus2 bHPRegenRate,(MaxHp/100),10000; .@r = getrefine(); if (.@r>=7) bonus bFlee,2; if (.@r >= 9) bonus2 bSPRegenRate,(MaxSp/100),10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5853,'IdRO_Crown','IdRO Crown',4,10,NULL,0,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'1',1,165,'bonus bHPrecovRate,7; bonus bSPrecovRate,7; if(getrefine()>7){ bonus2 bAddClass,Class_All,2; bonus bMatkRate,2; bonus bMdef,2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5855,'Fishing_Rod','Fishing Rod',4,10,NULL,0,NULL,0,NULL,NULL,0xFFFFFFFF,63,2,136,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5856,'Passion_FB_Hat','Passion FB Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,671,'bonus bStr,2; bonus bDex,2; autobonus "{ bonus bFlee,-15; bonus2 bAddClass,Class_All,5; }",30,10000,0,"{ specialeffect2 EF_ENHANCE; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5857,'Cool_FB_Hat','Cool FB Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,672,'bonus bInt,2; bonus bVit,2; autobonus3 "{ bonus bHealPower,20; }",150,5000,"AL_HEAL","{ specialeffect2 EF_HEAL3; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5858,'Victory_FB_Hat','Victory FB Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,673,'bonus bInt,2; bonus bDex,2; autobonus "{ bonus bMatkRate,5; bonus bDef,-30; }",3,10000,BF_MAGIC,"{ specialeffect2 EF_SUFFRAGIUM; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5859,'Glory_FB_Hat','Glory FB Hat',4,20,NULL,600,NULL,2,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',1,674,'bonus bAllStats,1; bonus bAspd,1; bonus bBaseAtk,BaseLevel/7; bonus bMatk,BaseLevel/7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5864,'Shadow_Booster','Magical Booster',4,10,NULL,300,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,512,NULL,'1',1,873,'bonus bAspd,1; bonus bDelayrate,-1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5868,'Bushy_Moustache','Bushy Moustache',4,20,NULL,100,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'0',0,1004,'bonus bUnbreakableHelm; bonus bBaseAtk,10; bonus bMatk,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5869,'Mimic_Egg_Shell','Mimic Egg Shell',4,10,NULL,100,NULL,4,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,999,'bonus2 bAddEffWhenHit,Eff_Stone,600; bonus bSpeedRate,25;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5870,'Bunny_Egg_Shell','Bunny Egg Shell',4,10,NULL,100,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,1000,'bonus bAgi,3; bonus bAspd,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5871,'Picky_Egg_Shell','Picky Egg Shell',4,10,NULL,100,NULL,2,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,1001,'bonus bVit,3; bonus bMdef,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5873,'Helmet_Of_Siegfried','Helmet Of Siegfried',4,20,NULL,600,NULL,7,NULL,1,0x000444A2,63,2,256,NULL,'60',1,1055,'bonus bAllStats,5; bonus2 bSubEle,Ele_Neutral,5; bonus2 bSubRace,RC_Dragon,5; bonus3 bAutoSpellWhenHit,"HP_ASSUMPTIO",5,5; bonus2 bHPLossRate,600,1000; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5874,'Circlet_Of_Kriemhild','Circlet Of Kriemhild',4,20,NULL,600,NULL,7,NULL,1,0x000444A2,63,2,256,NULL,'60',1,1056,'bonus bAllStats,5; bonus2 bSubEle,Ele_Neutral,5; bonus2 bSubRace,RC_Dragon,5; bonus3 bAutoSpellWhenHit,"PR_KYRIE",9,5; bonus2 bHPLossRate,400,1000; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5875,'Diadem_Of_Bruenhild','Diadem Of Bruenhild',4,20,NULL,600,NULL,7,NULL,1,0x000444A2,63,2,256,NULL,'60',1,1057,'bonus bAllStats,5; bonus2 bSubEle,Ele_Neutral,5; bonus2 bSubRace,RC_Dragon,5; bonus3 bAutoSpellWhenHit,"SM_ENDURE",8,5; bonus2 bHPLossRate,400,1000; bonus bUnbreakableHelm;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5881,'Weissbier_Hat','Weissbier Hat',4,20,NULL,300,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,1079,'bonus bMaxHPrate,3; bonus bMaxSPrate,3; bonus bDex,10; if(getrefine()>6){ bonus bMaxHPrate,5; bonus bMaxSPrate,5; bonus bDex,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5882,'Red_Wizardry_Hat_C','Red Mage Hat C',4,20,NULL,300,NULL,1,NULL,0,0x00810204,63,2,256,NULL,'0',1,282,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5883,'White_Wizardry_Hat_C','Gray Mage Hat C',4,20,NULL,300,NULL,1,NULL,0,0x00810204,63,2,256,NULL,'0',1,283,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5884,'Gray_Wizardry_Hat_C','Brown Mage Hat C',4,20,NULL,300,NULL,1,NULL,0,0x00810204,63,2,256,NULL,'0',1,284,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5885,'Blue_Wizardry_Hat_C','Blue Mage Hat C',4,20,NULL,300,NULL,1,NULL,0,0x00810204,63,2,256,NULL,'0',1,285,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5886,'Yellow_Wizardry_Hat_C','Yellow Mage Hat C',4,20,NULL,300,NULL,1,NULL,0,0x00810204,63,2,256,NULL,'0',1,286,'bonus bInt,2; bonus bMaxSP,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5887,'Half_L_Magestic_Goat','Half L Majestic Goat',4,20,NULL,800,NULL,5,NULL,0,0xFFFFFFFF,63,2,256,NULL,'0',1,380,'bonus2 bAddRace,RC_DemiHuman,10; bonus2 bAddRace,RC_Player,10; bonus bBaseAtk,(JobLevel*2)/7;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5892,'RCC2013_1ST_CROWN','RCC2013 1ST CROWN',4,20,NULL,2500,NULL,7,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',0,1106,'bonus bAllStats,5; skill "AL_TELEPORT",1;','sc_start SC_SPEEDUP0,INFINITE_TICK,25;','sc_end SC_SPEEDUP0;');
REPLACE INTO `item_db_re` VALUES (5893,'RCC2013_2ND_CROWN','RCC2013 2ND CROWN',4,20,NULL,2500,NULL,7,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',0,1107,'bonus bAllStats,4; skill "AL_TELEPORT",1;','sc_start SC_SPEEDUP0,INFINITE_TICK,25;','sc_end SC_SPEEDUP0;');
REPLACE INTO `item_db_re` VALUES (5894,'RCC2013_3RD_CROWN','RCC2013 3RD CROWN',4,20,NULL,2500,NULL,7,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',0,1108,'bonus bAllStats,3; skill "AL_TELEPORT",1;','sc_start SC_SPEEDUP0,INFINITE_TICK,25;','sc_end SC_SPEEDUP0;');
REPLACE INTO `item_db_re` VALUES (5895,'RCC2013_ANV_Hat','RCC2013 ANV Hat',4,20,NULL,2500,NULL,7,NULL,1,0xFFFFFFFF,63,2,256,NULL,'1',0,1109,'bonus bAllStats,1; bonus2 bAddClass,Class_All,2; bonus bMatkRate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5900,'Divine_Guard_Hat','Divine Guard Hat',4,0,NULL,200,NULL,10,NULL,1,0x00004000,56,2,256,NULL,'100',1,1121,'.@r = getrefine(); bonus2 bSubSize,Size_All,5; if(.@r>=7) { .@level = getskilllv("AL_HEAL"); bonus3 bAutoSpellWhenHit,"AL_HEAL",(.@level ? .@level : 5),10; } if(.@r>=9) { bonus2 bSkillAtk,"LG_RAYOFGENESIS",20; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5901,'Focus_Beret','Focus Beret',4,0,NULL,200,NULL,10,NULL,1,0x00008000,56,2,256,NULL,'100',1,1122,'.@r = getrefine(); bonus4 bAutoSpellOnSkill,"SR_DRAGONCOMBO","SR_FALLENEMPIRE",max(getskilllv("SR_FALLENEMPIRE"),1),100; if(.@r>=7) { autobonus "{ bonus bAspd,2; }",30,5000,0,"{ specialeffect2 EF_ENHANCE; }"; } if(.@r>=9) { bonus2 bSkillAtk,"SR_FALLENEMPIRE",30; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5902,'Harvester_Hat','Harvester Hat',4,0,NULL,200,NULL,10,NULL,1,0x00040000,56,2,256,NULL,'100',1,1123,'.@r = getrefine(); bonus2 bAddMonsterDropItem,6211,100; bonus2 bAddMonsterDropItem,6212,100; if(.@r>=7) { bonus2 bAddMonsterDropItem,6210,50; } if(.@r>=9) { bonus2 bSkillAtk,"GN_CARTCANNON",15; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5903,'Deadman_Bandana','Deadman Bandana',4,0,NULL,200,NULL,15,NULL,1,0x00810204,63,2,256,NULL,'99',1,1124,'.@r = getrefine(); .@rate = 1; bonus bCritical,.@r*2; bonus bFixedCastrate,-2; bonus3 bAutoSpellWhenHit,"SL_SWOO",getskilllv("SL_SWOO"),(.@rate*10); if (.@r>=7) { bonus bMatk,20; .@rate += 3; } if(.@r>=9) { bonus bVariableCastrate,-20; bonus2 bSkillUseSP,"SL_STUN",5; bonus2 bSkillUseSP,"SL_SMA",5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5904,'Inconspicuous_Hat','Inconspicuous Hat',4,0,NULL,200,NULL,10,NULL,1,0x00020000,56,2,256,NULL,'100',1,1125,'.@r = getrefine(); if (.@r>=9) { .@matk = 5; } bonus bMatkRate,(7+.@matk); if (.@r>=7) { bonus bMatk,(readparam(bInt)/5)*2; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5905,'Lyrica_Hat','Lyrica Hat',4,0,NULL,200,NULL,10,NULL,1,0x00080000,56,2,256,NULL,'100',1,1126,'.@r = getrefine(); bonus2 bSkillAtk,"WM_SEVERE_RAINSTORM",15; if(.@r>=7) { bonus bFixedCastrate,4*(getskilllv("WM_LESSON")); } if(.@r>=9) { bonus2 bSkillUseSP,"WM_SEVERE_RAINSTORM",10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5906,'Oni_Horns_','Oni Horns',4,0,NULL,20,NULL,10,NULL,1,0x00001000,56,2,256,NULL,'100',1,1127,'bonus2 bSkillAtk,"GC_COUNTERSLASH",(10*getskilllv("GC_WEAPONBLOCKING")); .@r = getrefine(); if(.@r > 6){ bonus bAtk,20; bonus bHit,5; } if(.@r > 9){ bonus3 bAutoSpell,"GC_CROSSIMPACT",1,10; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5907,'Sea_Captain_Hat','Sea Captain Hat',4,0,NULL,200,NULL,20,NULL,1,0x00000400,56,2,256,NULL,'100',1,1128,'bonus2 bSkillAtk,"NC_AXEBOOMERANG",20; .@dmg = 20; .@r = getrefine(); if (.@r>=7) { .@dmg += getskilllv("BS_WEAPONRESEARCH"); } if (.@r>=9) { .@dmg += getskilllv("NC_TRAININGAXE"); } bonus2 bSkillAtk,"NC_AXETORNADO",.@dmg;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5914,'Earmuff_Flowerform','C Flutter Butterfly',4,0,NULL,0,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,4096,NULL,'1',0,1378,'hateffect HAT_EF_FLUTTER_BUTTERFLY,true;',NULL,'hateffect HAT_EF_FLUTTER_BUTTERFLY,false;');
REPLACE INTO `item_db_re` VALUES (5917,'Yellow_Scarf','Yellow Scarf',4,0,NULL,100,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,1,NULL,'90',0,1170,'bonus bLongAtkDef,3;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5918,'Gambler_Seal','Gambler Seal',4,0,NULL,500,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,1202,'.@dex = readparam(bDex); .@luk = readparam(bLuk); .@critical = 3 + (.@luk / 10); .@critical_dmg = 3 - (.@dex/10) * 2; .@sub_arrowstorm = 10; .@sub_gateofhell = 10; bonus bBaseAtk,(.@luk/10)*2; bonus bMatk,(.@luk / 10) * 2; if (.@luk > 107) { .@critical += 5; .@critical_dmg += 10; } if (.@luk > 119) { .@critical += 10; .@critical_dmg += 17; .@sub_arrowstorm += 30; .@sub_gateofhell += 30; } bonus bCritical,.@critical; bonus bCritAtkRate,.@critical_dmg; bonus2 bSubSkill,"RA_ARROWSTORM",.@sub_arrowstorm; bonus2 bSubSkill,"SR_GATEOFHELL",.@sub_gateofhell;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5919,'Camellia_Hair_Pin','Camellia Hair Pin',4,0,NULL,1000,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,256,NULL,'50',1,1203,'bonus bMdef,20; bonus3 bAutoSpell,"AL_PNEUMA",1,30+getrefine()*5; hateffect(HAT_EF_CAMELLIA_HAIR_PIN,true); /* CONFIRM The Rate*/',NULL,'hateffect(HAT_EF_CAMELLIA_HAIR_PIN,false);');
REPLACE INTO `item_db_re` VALUES (5920,'Medical_Boots','Medical Boots',4,0,NULL,300,NULL,10,NULL,0,0xFFFFFFFF,63,2,64,NULL,'10',1,NULL,'.@r = getrefine(); bonus bHealPower,10+((.@r/2) * 2); bonus2 bSkillUseSP,"AB_CHEAL",(.@r * 5);',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5933,'Crow_Tengu_Mask','Crow Tengu Mask',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,63,2,512,NULL,'80',0,1287,'bonus2 bAddSize,Size_All,1; bonus bLongAtkRate,2; if(readparam(bStr)>=108) { bonus2 bAddSize,Size_All,1; bonus bLongAtkRate,2; } if(readparam(bStr)>=120) { bonus2 bAddSize,Size_All,2; bonus bLongAtkRate,3; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5937,'Flying_Helmet','Flying Helmet',4,1,NULL,300,NULL,5,NULL,1,0xFFFFFFFF,63,2,256,NULL,'20',1,820,'bonus bMdef,5; bonus bHPGainValue,100; bonus2 bSPGainRace,RC_Dragon,5; .@r = getrefine(); if (.@r>=5) { bonus2 bSubRace,RC_Dragon,5; } if (.@r>=7) { bonus2 bSubRace,RC_Dragon,5; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5938,'Octopus_Hat_','Octopus Hat',4,20,NULL,880,NULL,8,NULL,1,0xFFFFFFFF,63,2,256,NULL,'60',1,538,'bonus bMdef,8; bonus bUnbreakableHelm,1; bonus2 bAddItemHealRate,579,50; bonus2 bAddItemHealRate,544,125; bonus2 bAddItemHealRate,551,125; .@r = getrefine(); if (.@r>=5) { bonus2 bAddItemHealRate,579,50; bonus2 bAddItemHealRate,544,125; bonus2 bAddItemHealRate,551,125; } if (.@r>=6) { bonus2 bAddItemHealRate,579,50; bonus2 bAddItemHealRate,544,125; bonus2 bAddItemHealRate,551,125; } if (.@r>=7) { bonus2 bAddItemHealRate,579,50; bonus2 bAddItemHealRate,544,125; bonus2 bAddItemHealRate,551,125; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5943,'Owlviscount_Silk_Hat','Owl Viscount Silk Hat',4,0,NULL,500,NULL,15,NULL,1,0xFFFFFFFF,63,2,256,NULL,'70',1,1323,'bonus bInt,1; bonus bAspdRate,10; .@r = getrefine(); bonus bMatk,7*.@r; autobonus "{ .@r = getrefine(); bonus bAspdRate,(.@r >= 9 ? 40 : ((.@r >= 7) ? 10 : ((.@r >= 5) ? 5 : 1))); }",.@r*20,30000,BF_MAGIC,"{ specialeffect2 EF_SPELLBREAKER; }";',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5945,'Well_Chewed_Pencil','Well-Chewed Pencil',4,20,NULL,300,NULL,0,NULL,0,0xFFFFFFFF,63,2,1,NULL,'30',0,931,'bonus bStr,1; autobonus "{ bonus bAtkEle,Ele_Fire; }",50,60000,BF_WEAPON,"{ specialeffect2 EF_ENHANCE; }"; /* Unknow rate and specialeffect */',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5966,'KarduiEar','KarduiEar',4,0,NULL,300,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,1357,'.@dex = readparam(bDex); bonus bMatk,(.@dex > 10) ? .@dex/10*2 : 0; if (.@dex > 107) { bonus bVariableCastrate,-10; bonus bMatk,60; } if (.@dex > 119) { bonus bVariableCastrate,-5; bonus bMatk,100; }',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5967,'FlyingGalapago','Flying Galapago',4,0,NULL,500,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,1,NULL,'110',0,1358,'set .@bblvl,max(getskilllv("HT_BLITZBEAT"),1); set .@luk,min(readparam(bLuk),120); bonus bAgi,1; bonus3 bAutoSpell,"HT_BLITZBEAT",.@bblvl,50 + (.@luk / 3) + (.@bblvl * 2); bonus2 bSkillAtk,"HT_BLITZBEAT",getskilllv("HT_STEELCROW") * 40;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5968,'DVAngelNurseCap','DVAngelNurseCap',4,0,NULL,500,NULL,10,NULL,1,0xFFFFFFFF,63,2,256,NULL,'50',1,1359,'if (BaseClass == Job_Acolyte) bonus bHealPower,3; bonus bNoCastCancel; .@r = getrefine(); bonus bHealPower,(.@r > 8) ? 12 : ((.@r > 6) ? 9 : ((.@r > 4) ? 6 : 0));',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5969,'QueenAnzRevenge','QueenAnzRevenge',4,0,NULL,400,NULL,7,NULL,1,0xFFFFFFFF,63,2,256,NULL,'100',1,1360,'bonus bStr,5; .@r = getrefine(); bonus2 bAddClass,Class_All,7+(.@r > 8 ? 4 : (.@r > 6 ? 3 : (.@r > 4 ? 2 : 0))); bonus bNoSizeFix;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5971,'Moon_Eyepatch','Moon Eyepatch',4,0,NULL,100,NULL,NULL,NULL,1,0xFFFFFFFF,63,2,512,NULL,'10',0,1370,'bonus2 bSubEle,Ele_Water,5;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5972,'Chatty_Parrot','Chatty Parrot',4,0,NULL,100,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,1,NULL,'80',0,1116,'bonus bMatkRate,BaseLevel/50; bonus bVariableCast,-readparam(bInt)/30;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5973,'Ancient_Elven_Ear_J','Ancient Elven Ear J',4,0,NULL,200,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,512,NULL,'70',0,665,'bonus bLuk,10; bonus bMdef,10; bonus bFlee2,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5978,'Syringe_Toy','Toy Syringe',4,0,NULL,100,NULL,3,NULL,0,0xFFFFFFFF,63,2,1,NULL,'70',0,842,'bonus bMdef,3; bonus2 bAddItemHealRate,545,150; bonus2 bAddItemHealRate,546,150; bonus2 bAddItemHealRate,547,150;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5979,'C_Angel_Fluttering','C Angel Fluttering',4,0,NULL,0,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,4096,NULL,'1',0,1380,'hateffect HAT_EF_ANGEL_FLUTTERING,true;',NULL,'hateffect HAT_EF_ANGEL_FLUTTERING,false;');
REPLACE INTO `item_db_re` VALUES (5980,'C_Classical_Fhat','C Classical Fhat',4,0,NULL,0,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,1024,NULL,'1',0,1381,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (5985,'Noble_Mask','Noble Mask',4,0,NULL,200,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,512,NULL,'30',1,1409,'bonus2 bSkillAtk,"PA_SACRIFICE",BaseLevel*2; bonus2 bSkillVariableCast,"PA_PRESSURE",-2000; bonus2 bSkillVariableCast,"CR_DEVOTION",-2000; if (BaseLevel > 149) { bonus bMaxHPrate,3; bonus bAspdRate,3; } else if (BaseLevel > 99) { bonus bMaxHPrate,2; bonus bAspdRate,2; } else { bonus bMaxHPrate,1; bonus bAspdRate,1; }',NULL,NULL);
#===================================================================
# More Etc Items
#===================================================================
REPLACE INTO `item_db_re` VALUES (6000,'Dark_Ashes','Ashes of Darkness',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6001,'Essence_Of_Fire','Essence of Fire',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6002,'Token_Of_Apostle','Token of Apostle',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6003,'Soul_Pendant','Pendant of Spirit',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6004,'Bapho_Doll','Cursed Baphomet Doll',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6005,'New_Year_Rice_Cake','New Year Rice Cake',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6006,'Rice_Cake_Delivery_Box','Rice Cake Delivery Box',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6007,'New_Year_Rice_Cake_Soup','New Year Rice Cake Soup',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6008,'Wood','Wood',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6009,'Large_Magical_Fan','Big Fan Of Magic',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6010,'Pickaxe','Hoe',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6011,'Blue_Card_B','Blue B Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6012,'Blue_Card_C','Blue C Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6013,'Blue_Card_J','Blue J Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6015,'Blue_Card_M','Blue M Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6016,'Blue_Card_Q','Blue Q Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6017,'Blue_Card_T','Blue T Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6018,'Blue_Card_V','Blue V Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6019,'Blue_Card_Z','Blue Z Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6020,'Fur','Fur',3,704,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6021,'Peaked_Hat','Peaked Hat',3,433,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6022,'Hard_Skin','Hard Skin',3,884,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6023,'Mystic_Horn','Mystic Horn',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6024,'17Carat_Dia','17Carat Diamond',3,6000000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6025,'Towel_Of_Memory','Towel of Memory',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6026,'Marriage_Covenant','Written Oath Of Marriage',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6027,'Crystal_Of_Feardoom','Crystal Of Feardom',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6028,'Seal_Scroll','Sealed Scroll',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6029,'Morocc_Tracing_Log','Morroc Tracing Log',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6030,'Glitering_PaperA','Glittering Paper',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6031,'Glitering_PaperB','Glittering Paper',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6032,'Horn_Of_Hilsrion','Horn of Hillslion',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6033,'Horn_Of_Tendrilion','Horn of Tendrilion',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6034,'Weird_Part','Weird Part',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6035,'Decaying_Stem','Decaying Stem',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6036,'Invite_To_Meeting','Meeting Invitation',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6037,'Rough_File','Messy File',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6038,'Neat_Report','Neat Report',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6039,'Piece_Of_Fish','Piece of Fish',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6040,'Some_Of_Report','Part of a Report',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6041,'Strong_Bine','Strong Vine',3,30,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6042,'Ordinary_Branch','Ordinary Branch',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6043,'Letter_From_Lugen','Letter from Lugen',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6044,'Letter_From_Otto','Letter from Otto',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6045,'Supply_Box','Supply Box',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6046,'Clothing_Dye_Coupon','Clothing Dye Coupon',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6047,'Clothing_Dye_Coupon_II','Clothing Dye Coupon II',2,0,NULL,0,NULL,NULL,NULL,NULL,0xFFFFFFFF,63,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6048,'Unidentified_Mineral','Unidentified Mineral',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6049,'Marlin','Marlin',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6050,'Mercenary_Contract','Mercenary Contract',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6051,'Gray_Hollow','Gray Hollow',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6052,'Ornamental_Hairpin','Ornament Hairpin',3,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6053,'Yuanbao','Circle Step',3,100,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6054,'Blue_Card_6','Number 6 Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6055,'Blue_Card_Annyver','Character Week Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6056,'Blue_Card_Sary','Character Year Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6057,'Blue_Card_E','Character Lee Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6058,'Blue_Card_Ven','Character Ben Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6059,'Blue_Card_Nt','Character Project Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6060,'Moon_Admin_Ticket','Month Viewing Ticket',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6061,'Plantain','Blood Beginner',3,100,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6062,'Moon_Cake15','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6063,'Moon_Cake16','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6064,'Moon_Cake17','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6065,'Moon_Cake18','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6066,'Moon_Cake19','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6067,'Moon_Cake20','Letter Moon Cake',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6068,'Rabbit_Skin','Leather Rabbit',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6069,'ABUNDANCE','Abundance',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6070,'Shaman\'s_Old_Paper','Shaman\'s Document',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6071,'Broken_Sword','Broken Sword',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6072,'Wing_Of_Bizofnil','Bijofnil Feather',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6073,'Dragon\'s_Mane','Dragon\'s Mane',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6074,'Bazett\'s_Order','Bazett\'s Order',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6075,'Crystalized_Teardrop','Crystalized Teardrop',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6076,'Portable_Toolbox','Portable Toolbox',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6077,'Rough_Mineral','Rough Mineral',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6078,'Stone_Fragments','Stone Fragment',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6079,'Flower_Of_Alfheim','Flower Of Alfheim',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6080,'Manuk_Coin','Manuk Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6081,'Splendide_Coin','Splendide Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6082,'Spirit_Of_Alfheim','Spirit Of Alfheim',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6083,'Dolly_Capsule','Capsule Dolls',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6084,'Bradium_Fragments','Bradium Fragments',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6085,'Shaggy_Muffler','Shaggy Muffler',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6086,'Withered_Flower','Withered Flower',3,890,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6087,'Crystal_Of_Soul_01','Spiritual Crystal',3,1050,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6088,'Crystal_Of_Soul_02','Spiritual Crystal',3,1050,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6089,'Piece_Of_Darkness','Dark Piece',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6090,'Purified_Bradium','Refined Bradium',3,1100,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6091,'Dark_Red_Scale','Darkred Scale Piece',3,200000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6092,'Singing_Crystal_Piece','Piece Of Singing Crystal',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6093,'Egg_Of_Draco','Draco\'s Egg',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6094,'Traditional_Cookie','Traditional Sweets',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6095,'Flavored_Alcohol','Flavored Alcohol',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6096,'Fish_With_Blue_Back','Fish With Blue Back',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6097,'Pumpkin_Pie_','Pumpkin Pie',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6098,'Small_Snow_Flower','Small Snow Flower',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6099,'Grilled_Rice_Cake','Grilled Rice Cake',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6100,'Damp_Darkness','Damp Darkness',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6101,'Attendance_Card','Attendance Card',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6102,'Report_On_Splendide','Report On Splendide',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6103,'Report_On_Manuk','Report On Manuk',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6104,'Big_Cell','Big Cell',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6105,'Morning_Dew','Morning Dew',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6106,'Well_Ripened_Berry','Well Ripened Berry',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6107,'Sunset_On_The_Rock','Sunset On The Rock',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6108,'Apple_Pudding','Apple Pudding',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6109,'Plant_Neutrient','Plant Neutrient',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6110,'Vital_Flower','Vital Flower',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6111,'Mystic_Stone','Mystic Stone',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6112,'Fresh_Plant','Fresh Plant',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6113,'Vital_Flower_','Vital Flower',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6114,'Flame_Gemstone','Flame Gemstone',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6115,'Bun_','Bun',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6116,'Succu_Pet_Coupon','Succubus Pet Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6117,'Imp_Pet_Coupon','Imp Pet Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6118,'Chung_E_Pet_Coupon','Chung E Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6119,'Natural_Leather','Cow Leather',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6120,'Face_Paint','Face Paint',3,120,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6121,'Makeover_Brush','Makeover Brush',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6122,'Paint_Brush','Paint Brush',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6123,'Surface_Paint','Surface Paint',3,200,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6124,'Wolf\'s_Flute','Wolf Flute',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6125,'Lucky_Box','Spring Time Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6126,'Happy_Box','Summer Happy Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6127,'Purification_Stone','Purification Stone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6128,'Guillotine_Antidote','Antidote',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6129,'Ticket_Nightmare','Nightmare Terror Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6130,'Ticket_Loli_Ruri','Loli Ruri Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6131,'Ticket_Goblin_Leader','Goblin Leader Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6132,'Ticket_Incubus','Incubus Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6133,'Ticket_Miyabi_Ningyo','Miyabi Ningyo Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6134,'Ticket_Whisper','Giant Whisper Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6135,'Ticket_Wicked_Nymph','Evil Nymph Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6136,'Ticket_Medusa','Medusa Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6137,'Ticket_Stoneshooter','Stone Shooter Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6138,'Ticket_Marionette','Marionette Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6139,'Ticket_Leafcat','Leaf Cat Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6140,'Ticket_Dullahan','Dullahan Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6141,'Ticket_Shinobi','Shinobi Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6142,'Ticket_Golem','Golem Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6143,'Ticket_Civil_Servant','Civil Servant Exchange Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6144,'Heartbroken_Tears','Regrettable Tears',3,1000,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6145,'Vulcan_Bullet','Vulcan Bullet',3,10,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6146,'Magic_Gear_Fuel','Magic Gear Fuel',3,300,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6147,'Liquid_Condensed_Bullet','Liquid Condensed Bullet',3,100,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6148,'Chocolate_Of_Eternity','Eternity Of Chocolate',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6149,'Plain_Chocolate','Simple Chocolate',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6150,'Key_Of_The_Mansion','Key of The Mansion',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6151,'Peice_Of_Great_Bradium','Giant Bradium Fragment',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6152,'Glittering_Crystal','Glittering Crystal',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6153,'Special_Exchange_Coupon','Special Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6154,'Broken_Horn_Pipe','Broken Horn Pipe',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6155,'Coke_Membership_Card','Member Card',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6156,'Approval_Report','Approval Report',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6157,'Poring_Ticket','Poring Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6158,'Drops_Ticket','Drops Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6159,'Poporing_Ticket','Poporing Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6160,'Lunatic_Ticket','Lunatic Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6161,'Picky_Ticket','Picky Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6162,'Pecopeco_Ticket','Peco Peco Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6163,'Savage_Baby_Ticket','Savage Babe Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6164,'Spore_Ticket','Spore Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6165,'Poison_Spore_Ticket','Poison Spore Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6166,'Chonchon_Ticket','Chonchon Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6167,'Steel_Chonchon_Ticket','Steel Chonchon Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6168,'Petit_Ticket','Sky Petite Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6169,'Deviruchi_Ticket','Deviruchi Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6170,'Isis_Ticket','Isis Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6171,'Smokie_Ticket','Smokie Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6172,'Dokebi_Ticket','Dokebi Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6173,'Desert_Wolf_B_Ticket','Baby Desert Wolf Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6174,'Yoyo_Ticket','Yoyo Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6175,'Sohee_Ticket','Sohee Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6176,'Rocker_Ticket','Rocker Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6177,'Hunter_Fly_Ticket','Hunter Fly Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6178,'Orc_Warrior_Ticket','Orc Warrior Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6179,'Bapho_Jr_Ticket','Bapho Jr. Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6180,'Munak_Ticket','Munak Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6181,'Bongun_Ticket','Bongun Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6182,'Goblin_Ticket','Christmas Goblin Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6183,'Hardtack_Ticket','Rice Cake Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6184,'Zherlthsh_Ticket','Zherlthsh Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6185,'Alice_Ticket','Alice Exchange Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6186,'Monkey_Wrench','Monkey Wrench',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6187,'Blank_Card','Blank Card',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6188,'Slot_Coupon','Slotting Advertisement',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6189,'Magic_Book_FB','Spell Book (Fire Bolt)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6190,'Magic_Book_CB','Spell Book (Cold Bolt)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6191,'Magic_Book_LB','Spell Book (Lightening Bolt)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6192,'Magic_Book_SG','Spell Book (Storm Gust)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6193,'Magic_Book_LOV','Spell Book (Lord Of Vermilion)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6194,'Magic_Book_MS','Spell Book (Meteor Storm)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6195,'Magic_Book_CM','Spell Book (Comet)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6196,'Magic_Book_TV','Spell Book (Tetra Vortex)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6197,'Magic_Book_TS','Spell Book (Thunder Storm)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6198,'Magic_Book_JT','Spell Book (Jupitel Thunder)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6199,'Magic_Book_WB','Spell Book (Water Ball)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6200,'Magic_Book_HD','Spell Book (Heaven\'s Drive)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6201,'Magic_Book_ES','Spell Book (Earth Spike)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6202,'Magic_Book_ES_','Spell Book (Earth Strain)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6203,'Magic_Book_CL','Spell Book (Chain Lightning)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6204,'Magic_Book_CR','Spell Book (Crimson Rock)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6205,'Magic_Book_DL','Spell Book (Drain Life)',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6206,'I_Love_You','I Love You',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6207,'Thank_You','Thank You',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6208,'I_Respect_You','I Respect You',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6209,'Glory_Of_Knights','Knight\'s Honor',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6210,'Seed_Of_Horny_Plant','Seed Of Thorny Plant',3,600,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6211,'Bloodsuck_Plant_Seed','Bloodsuck Plant Seed',3,800,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6212,'Bomb_Mushroom_Spore','Bomb Mushroom Spore',3,1000,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6213,'Explosive_Powder','Explosive Powder',3,500,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6214,'Smoke_Powder','Smoke Powder',3,500,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6215,'Tear_Gas','Tear Gas',3,500,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6216,'Oil_Bottle','Oil Bottle',3,1000,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6217,'Mandragora_Flowerpot','Mandragora Flowerpot',3,2000,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6218,'Disin_Delivery_Box','Delivery Daishin Box',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6219,'Para_Team_Mark','Eden Group Mark',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6220,'Mysterious_Dyestuff','Mysterious Dyestuff',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6221,'Mystic_Leaf_Cat_Ball','Mystic Leaf Cat Ball',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6222,'Shining_Beads','Shining Beads',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6223,'Carnium','Carnium',3,2000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6224,'Bradium','Bradium',3,2000,NULL,150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6225,'HD_Carnium','HD Carnium',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6226,'HD_Bradium','HD Bradium',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6228,'Guarantee_Weapon_9Up','+9 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6229,'Guarantee_Weapon_8Up','+8 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6230,'Guarantee_Weapon_7Up','+7 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6231,'Guarantee_Weapon_6Up','+6 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6232,'Guarantee_Armor_9Up','+9 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6233,'Guarantee_Armor_8Up','+8 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6234,'Guarantee_Armor_7Up','+7 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6235,'Guarantee_Armor_6Up','+6 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6236,'Blue_Card_7','Blue Card 7',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6237,'Guarana_Fruit','Guarana Fruit',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6238,'Guarantee_Weapon_11Up','+11 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6239,'Guarantee_Armor_11Up','+11 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6240,'HD_Oridecon','HD Oridecon',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6241,'HD_Elunium','HD Elunium',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6242,'Midgard_Coin','Midgard Coin',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6243,'Exchange_Coupon','Exchange Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6244,'Gun_Powder','Gun Powder',3,10,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6245,'Black_Powder','Black Powder',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6246,'Yellow_Powder','Yellow Powder',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6247,'White_Powder','White Powder',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6248,'Melange_Pot','Melange Pot',3,600,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6249,'Savage_Meat','Savage Meat',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6250,'Cooking_Skewer','Cooking Skewer',3,300,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6251,'Black_Charcoal','Black Charcoal',3,300,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6252,'Wolf_Blood','Blood Of Wolf',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6253,'Cold_Ice','Cold Ice',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6254,'Beef_Head_Meat','Beef Head',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6255,'Large_Cookpot','Large Cookpot',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6256,'Ice_Fragment','Ice Piece',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6257,'Ice_Crystal','Ice Crystal',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6258,'Comodo_Tropic_Fruit','Comodo Tropical Fruit',3,800,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6259,'Drocera_Tentacle','Drosera Tentacle',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6260,'Petti_Tail','Petite\'s Tail',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6261,'Fine_Noodle','Fine Noodles',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6262,'Cool_Gravy','Cool Gravy',3,400,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6263,'Coconut_Fruit','Coconut Fruit',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6264,'Melon','Melon',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6265,'Pineapple','Pineapple',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6266,'Cheat_Key','Key Of Deception',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6267,'Virtual_Key','Key Of Illusion',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6268,'Mirth_Key','Key Of Gaiety',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6269,'Master_Brush','A Master\'s Blush',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6270,'Mins_Picture','A Picture Of Minstrel Song',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6271,'Mins_Receipt','Receipt',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6272,'Experiment_Seed','Experiment Seed',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6273,'Altered_Seed','Seed For Experiment',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6274,'Saint_Cloth_Piece','A Piece Of Cloth Of A Saint',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6275,'King_Shield','Shield Of King',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6276,'Clear_Reagent','Clear Reagent',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6277,'Red_Reagent','Red Reagent',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6278,'Black_Reagent','Black Reagent',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6279,'Apple_Bomb_CB','Apple Bomb Guidebook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6280,'Pinepple_Bomb_CB','Pineapple Bomb Guidebook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6281,'Coconut_Bomb_CB','Coconut Fruit Bomb Guidebook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6282,'Melon_Bomb_CB','Melon Bomb Guidebook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6283,'Banana_Bomb_CB','Banana Bomb Guidebook',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6284,'Plant_Genetic_Grow','How To Grow Plant Genes',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6285,'Quality_Potion_Book','Manual: How To Make High Quality Potion',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6286,'F_Max_Weight_Up_Scroll','F Max Weight Up Scroll',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6287,'F_Clothing_Dye_Coupon','Omni Clothing Dye',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6288,'F_Happy_Box','F Happy Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6289,'F_Mysterious_Dyestuff','F Mysterious Dyestuff',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6290,'F_New_Style_Coupon','F New Style Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6291,'F_Enriched_Elunium','F Enriched Elunium',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6292,'F_Enriched_Oridecon','F Enriched Oridecon',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6293,'F_Token_Of_Siegfried','F Token Of Siegfried',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6294,'F_Marriage_Covenant','F Marriage Covenant',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6295,'F_Clothing_Dye_Coupon2','F Clothing Dye Coupon2',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6296,'RF_Taining_Notice','Training Notice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6297,'Bottle_To_Throw','Throwing Bottle',3,300,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6298,'Pumpkin_Head_Crushed','Pumpkin Head Crushed',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6299,'Worn_Cloth_Piece','Worn Cloth Piece',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6300,'J_7Draw','event',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6301,'J_Semi_Draw','event',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6302,'GM_Handwriting','GM Handwriting',3,20004,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6303,'Changed_Hydra_Ball','Changed Hydra Ball',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6304,'Sapa_Feat_Cert','Proof Of Sapha\'s Honor',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6305,'Frozen_Skin_Piece','Frozen Piece Of Skin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6306,'Solid_Bloodstain','Hard Bloodstain',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6307,'Suspicious_Magic_Stone','Cursed Magical Stone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6308,'Unidentified_Relic','Unidentified Relic',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6309,'E_Max_Weight_Up_Scroll','E Max Weight Up Scroll',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6310,'E_Cloth_Dye_Coupon','E Cloth Dye Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6311,'E_Happy_Box','E Happy Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6312,'E_Mysterious_Dyestuff','E Mysterious Dyestuff',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6313,'E_New_Style_Coupon','E New Style Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6314,'E_Enriched_Elunium','E Enriched Elunium',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6315,'E_Enriched_Oridecon','E Enriched Oridecon',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6316,'E_Token_Of_Siegfried','E Token Of Siegfried',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6317,'E_Marriage_Covenant','E Marriage Covenant',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6318,'E_Cloth_Dye_Coupon2','E Cloth Dye Coupon2',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6319,'Small_Bradium','Small Bradium',3,324,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6320,'Premium_Reset_Stone','Premium Reset Stone',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6321,'Rakehorn_Helm','Rakehorn Helm',3,822,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6322,'Antler_Helm','Antler Helmet',3,800,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6323,'Twinhorn_Helm','Two-Horned Helmet',3,728,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6324,'Singlehorn_Helm','Single Horned Helmet',3,702,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6325,'White_Spider_Limb','White Spider Limb',3,1004,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6326,'Queen_Wing_Piece','Queen Wing Piece',3,1630,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6327,'Limited_High_Density_Bradium','(Limited)High Density Bradium',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6328,'Calender_January','Calender January',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6329,'Calender_February','Calender February',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6330,'Calender_March','Calender March',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6331,'Calender_April','Calender April',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6332,'Calender_May','Calender May',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6333,'Calender_June','Calender June',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6334,'Calender_July','Calender July',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6335,'Calender_August','Calender August',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6336,'Calender_September','Calender September',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6337,'Calender_October','Calender October',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6338,'Calender_November','Calender November',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6339,'Calender_December','Calender December',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6340,'Fade_Notation_Green','Fade Notation Green',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6341,'Fade_Notation_Red','Fade Notation Red',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6342,'Fade_Notation_Purple','Fade Notation Purple',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6343,'Fade_Notation_Blue','Fade Notation Blue',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6344,'Muscle_Story','Muscle Story',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6345,'Love_Ball','Love Lump',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6346,'Seagate_Mark','Seagate Mark',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6347,'Bless_Word_Paper1','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6348,'Bless_Word_Paper2','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6349,'Bless_Word_Paper3','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6350,'Bless_Word_Paper4','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6351,'Bless_Word_Paper5','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6352,'Bless_Word_Paper6','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6353,'Bless_Word_Paper7','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6354,'Bless_Word_Paper8','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6355,'Bless_Word_Paper9','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6356,'Bless_Word_Paper10','Bless Word Paper',3,4020,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6357,'Fortune_Cookie_Fail','Fortune Cookie Fail',3,4020,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6358,'Free_Cash_Coupon','Free Cash Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6359,'Guidebook_Exchange','Guidebook Exchange',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6360,'Scarlet_Pts','Scarlet Point',3,100,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6361,'Indigo_Pts','Indigo Point',3,100,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6362,'Yellow_Wish_Pts','Yellow Wish Point',3,100,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6363,'Lime_Green_Pts','Lime Green Point',3,100,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6369,'Amatsu_Bead_A','Amatsu Bead A',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6370,'Amatsu_Bead_Ma','Amatsu Bead Ma',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6371,'Amatsu_Bead_Tsu','Amatsu Bead Tsu',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6372,'Amatsu_Bead_Jam','Amatsu Bead Jam',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6373,'Amatsu_Bead_Bo','Amatsu Bead Bo',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6374,'Amatsu_Bead_Ree','Amatsu Bead Ree',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6375,'Amatsu_Bead_!','Amatsu Bead !',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6376,'KVM_Badge','KVM Badge',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6377,'Buy_Market_Permit','Buy Market Permit',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6378,'Winning_Mark','Winning Mark',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6379,'Card_Coin','Card Coin',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6380,'Mora_Coin','Mora Coin',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6381,'Field_Shovel','Field Shovel',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6382,'Urn','Urn',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6383,'Clue_Of_Lope','Lope\'s Clue',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6384,'Ring_Of_Lope','Lope\'s Ring',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6385,'Research_Tool_Bag','Research Tool Bag',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6386,'Bathtub_R_Sample','Bath Water Sample',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6387,'Teeth_Sample','Teeth Sample',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6388,'Scale_Sample','Scale Sample',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6389,'Puddle_R_Sample','Sample Of Puddle Research',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6390,'Small_Pocket','Small Pocket',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6391,'Splendid_Supply_Kit','Splendid Supply Kit',3,20,NULL,2000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6392,'Bradium_Box','Bradium Box',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6393,'Round_Feather','Round Feather',3,525,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6394,'Golden_Feather','Golden Feather',3,487,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6395,'Angel_Magic_Power','Angel Magic Powder',3,615,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6396,'Auger_Of_Spirit','Auger Of Spirit',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6397,'PR_Team_Ticket','PR Team Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6398,'Develop_Team_Ticket','Develop Team Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6399,'Marketing_Team_Ticket','Marketing Team Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6400,'Operating_Team_Ticket','Operating Team Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6401,'Palm_O','Palm Oil',3,0,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6402,'Oil_Palm_F','Palm Oil Fruit',3,0,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6403,'Comodo_L','Comodo Leather',3,5,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6404,'Caress_H','Keris Hilt',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6405,'Cendrawasih_F','Cendrawasih Feather',3,3,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6406,'Cendrawasih_SF','Shining Cendrawasih Feather',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6407,'Sang_Stone_Fragment','Raw Crystal Stone Fragment',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6408,'Sang_Stone','Raw Crystal Stone',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6409,'Sang_Stone_Mass','Raw Crystal Stone Mass',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6410,'Idul_Fitri_Card','Idul Fitri Card',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6411,'Ripe_Watermelon','Ripe Watermelon',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6412,'Special_Medal','Special Medal',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6413,'New_Insurance','New Insurance',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6414,'Raganta_Card','Ragunta Card',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6415,'Strange_Embryo','Strange Embryo',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6416,'Pet_Exchange','Pet Exchange',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6417,'Silvervine','Silvervine Fruit',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6418,'Agrade_Coin','A Grade Coin',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6419,'Bgrade_Coin','B Grade Coin',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6420,'Cgrade_Coin','C Grade Coin',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6421,'Dgrade_Coin','D Grade Coin',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6422,'Egrade_Coin','E Grade Coin',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6423,'Anger_Seagod','Sea God\'s Wrath',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6424,'Halloween_Fragment','Spirit Piece',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6425,'Halloween_Certificate','Halloween Certificate',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6426,'Bad_Can','Bad Canned Food',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6427,'Bad_Can_Sack','Bad Canned Food Sack',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6428,'Bravery_Card_A','Adventure Card A',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6429,'Bravery_Card_B','Adventure Card B',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6430,'Picture_Piece','Picture Fragment',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6431,'Bucket','Pail',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6432,'Full_Bucket','Full Pail',3,0,NULL,3000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6433,'Clean_Brush','Cleaning Brush',3,0,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6434,'Fix_Kit','Fix Kit',3,0,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6435,'Fresh_Fruit','Fresh Fruit',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6436,'Ptotection_Seagod','Sea God\'s Call',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6437,'Scaraba_Perfume','Scaraba Perfume',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6438,'Unbreakable_Weap','Unbreakable Weapon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6439,'Unbreakable_Def','Unbreakable Armor',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6440,'General_Lubricant','General Lubrication',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6441,'High_RankLubricant','Advanced Lubrication',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6442,'Octopus_Hunt_Stick','Octopus Hunting Skewer',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6443,'Sillit_Pong_Bottle','Sillit Pong Bottle',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6444,'Emperium_G','Emperium G',3,2,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6445,'Blue_Card_X','Blue Card X',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6446,'Green_Paper','Green Paper',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6447,'Red_Paper','Red Paper',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6448,'White_Paper','White Paper',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6449,'Casual_Diary','Casual Diary',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6450,'Honest_Diary','Honest Diary',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6451,'Unknown_Fish','Unknown Fish',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6452,'Etoile_Ring','Etoile Ring',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6453,'Undelivered_Gift','Undelivered Gift',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6454,'Santa_Bag','Santa Bag',3,2,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6455,'Tiny_Ticket','Tiny Ticket',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6456,'Guarantee_Weapon_5Up','+5 Weapon Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6457,'Guarantee_Armor_5Up','+5 Armor Refine Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6459,'Jae_Sinho_Unpo','Jae Sinho Unpo',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6460,'Jae_Sinho_Undo','Jae Sinho Undo',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6461,'Mimong_Sungjin','Mimong Sungjin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6462,'Gilsang_Yeoui','Gilsang Yeoui',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6463,'Sin_Sun_Jeonsul','Sin Sun Jeonsul',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6464,'Hate_Bundle','Hate Crate',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6465,'Guard_Coin','Guard Coin',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6466,'Clean_Water','Clean Water',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6467,'Perfume','Perfume',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6468,'Thai_Perfume','Thai Perfume',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6469,'Will_Of_Warrior','Warrior\'s Will',3,1000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6470,'Blood_Thirst','Blood Thirst',3,1200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6471,'Goast_Chill','Chills Of Death',3,1600,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6472,'Holy_Mom_Blaze','Holy Mom Blaze',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6473,'Amatsu_Orb01','Amatsu Orb01',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6474,'Amatsu_Orb02','Amatsu Orb02',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6475,'Amatsu_Orb03','Amatsu Orb03',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6476,'Amatsu_Orb04','Amatsu Orb04',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6477,'Amatsu_Orb05','Amatsu Orb05',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6478,'Amatsu_Orb06','Amatsu Orb06',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6479,'Amatsu_Orb07','Amatsu Orb07',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6480,'Event_coin','Poring Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6481,'Holy_Rock_Piece','Holy Rock Piece',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6482,'Ancient_City_Key','Ancient City Key',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6483,'Dream_Scroll','Dream Scroll',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6484,'Enchant_Book','Enchant Book',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6485,'BlueCard_2','Blue 2 Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6486,'BlueCard_0','Blue 0 Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6487,'BlueCard_1','Blue 1 Card',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6488,'Thanks_Invest_Ticket','Thanks Invest Ticket',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6489,'Cats_Invest_Certif','Cats Invest Certificate',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6490,'Magic_Clay_Fragment','Magic Clay Fragment',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6491,'Magic_Clay','Magic Clay',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6492,'Magic_Clay_Lump','Magic Clay Lump',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6493,'Makibishi','Makibishi',3,30,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6494,'Kafra_Coin2','Kafra Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6495,'Para_Logro_Badge','Eden Merit Badge',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6496,'Tikbalang_Thick_Spine','Tikbalang\'s Thick Spine',3,300,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6497,'Lesser_Agimat','Lesser Agimat',3,20,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6498,'Jejellopy','Jejellopy',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6499,'Ancient_Grudge','Ancient Grudge',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6500,'Sharp_Bamboo','Sharpened Bamboo',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6501,'Salt_Bag','Salt Bag',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6502,'Silver_Cross','The Cross',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6503,'Soul_Protection','Spiritual Protection',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6504,'Cast_Iron_Caldron','Cast-Iron Caldron',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6505,'Purified_Bone','Purified Spirit Bone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6506,'Memorial_Bouquet','Offering Bouquet',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6507,'Evil_Bone','Evil Spirit Bone',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6508,'Silver_Bracelet','Silver Bracelet',3,300,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6509,'Mysterious_Flower','Mysterious Flower',3,500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6510,'Elegant_Flower','Elegant Flower',3,300,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6511,'Beautiful_Flower','Beautiful Flower',3,300,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6512,'Charm_Fire','Fire Amulet',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6513,'Charm_Ice','Ice Amulet',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6514,'Charm_Wind','Wind Amulet',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6515,'Charm_Earth','Earth Amulet',3,100,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6516,'Bakonawa_Doll','Bakonawa Doll',3,3000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6517,'Bangungot_Doll','Bangungot Doll',3,3000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6518,'Buwaya_Doll','Buwaya Doll',3,3000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6519,'Collected_Samples','Collected Sample',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6520,'Lost_Belongings','Lost Belongings',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6521,'Royal_Certificate','Royal Certificate',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6522,'Royal_Certificate_','Royal Certificate',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6523,'Bakonawa_Spirit_Piece','Piece of Bakonawa\'s Spirit',3,3000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6524,'Bangungot_Spirit_Piece','Piece of Bangungot\'s Spirit',3,3000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6525,'Buwaya_Spirit_Piece','Piece of Buwaya\'s Spirit',3,3000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6526,'BlueCard_Happy','BlueCard Happy',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6527,'BlueCard_Enjoy','BlueCard Enjoy',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6528,'BlueCard_Light','BlueCard Light',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6529,'BlueCard_Mid','BlueCard Mid',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6530,'BlueCard_Fall','BlueCard Fall',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6531,'Royal_Certificate__','Royal Certificate',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6532,'Honey_Songpyun','Honey Songpyun',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6533,'Torn_Document','Torn Document',3,2,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6534,'Fruit_Sundae','Fruit Sundae',3,2,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6535,'Red_Cloth','Red Cloth',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6536,'Star_Decor','Star Decor',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6537,'Sky_Medal','Sky Medal',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6538,'Real_Blank_Card','Real Blank Card',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6539,'Old_Left_Lapine','Old Left Lapine',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6540,'Golden_Leaf','Golden Leaf',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6541,'Avant_Research_Data','Avant Research Data',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6542,'Star_Shape_Mushroom','Star Shape Mushroom',3,20,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6543,'Lv110_Achieved_Coin','Lv110 Achieved Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6544,'Lv120_Achieved_Coin','Lv120 Achieved Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6545,'Firm_Hair','Firm Hair',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6546,'Younger_Bro_Letter','Younger Bro Letter',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6547,'Stained_Research_Book','Stained Research Book',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6548,'Piece_Of_Lapine_Wing','Piece Of Lapine Wing',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6549,'Courtesy_Ticket','Courtesy Ticket',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6550,'Brownie_Ticket','Brownie Ticket',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6551,'RWC_Spirit_Auger','RWC Spirit Auger',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6552,'Mail_Package','Mail Package',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6553,'Leaf_Made_Wood','Leaf Made Wood',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6554,'Seed_Box','Seed Box',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6555,'Birthday_Candle','Birthday Candle',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6556,'Nespresso_Ticket','Nespresso Ticket',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6557,'Fancy_Fairy_Wing','Fancy Fairy Wing',3,2350,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6558,'Pile_Of_Acorn','Pile Of Acorn',3,1500,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6559,'Eye_Drops','Eye Drops',3,1780,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6560,'Leaf_Bookmark','Leaf Bookmark',3,3000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6561,'Dustball','Dustball',3,2000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6562,'Tiny_Mouse_Tail','Tiny Mouse Tail',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6563,'Weeds','Weeds',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6564,'Captive_Hatchling','Captive Hatchling',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6565,'Racy_Spice','Racy Spice',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6566,'Cacao99_Recipe','Cacao99 Recipe',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6567,'Choco_Drink_Recipe','Choco Drink Recipe',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6581,'Holy_Amulet','Holy Amulet',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6583,'3rd_Test_Pass','3rd Test Pass',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6592,'Small_Wooden_Chest','Small Wooden Chest',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6593,'Cryptura_Hair_Coupon','Cryptura Hair Coupon',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6594,'Magic_Bronze_Bullion','Magic Bronze Bullion',3,0,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6595,'Hammer_Of_Velund','Hammer Of Velund',3,0,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6596,'Anvil_Of_Velund','Anvil Of Velund',3,0,NULL,2000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6597,'Bracelet_Of_Velund','Bracelet Of Velund',3,0,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6598,'Rib_Of_Jormungand','Rib Of Jormungand',3,0,NULL,10000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6599,'Spirit_Of_Hugin','Spirit Of Hugin',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6600,'Spirit_Of_Munin','Spirit Of Munin',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6601,'Chisel_Of_Giant','Chisel Of Giant',3,0,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6602,'Secret_Of_Rune','Secret Of Rune',3,0,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6603,'Skin_Of_Hraesvelg','Skin Of Hraesvelg',3,0,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6604,'Essence_Rune_Magic','Essence Rune Magic',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6605,'Muspellium','Muspellium',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6606,'Cute_Cart_Coupon','Cute Cart Remodel Coupon',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6607,'Temporal_Crystal','Temporal Crystal',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6608,'Coagulated_Spell','Coagulated Spell',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6609,'Glast_Decayed_Nail','Glast Decayed Nail',3,2800,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6610,'Glast_Horrendous_Mouth','Glast Horrendous Mouth',3,3200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6611,'Colorful_Key','Colorful Key',3,50000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6612,'Gold_Coin_Basket','Gold Coin Basket',3,300000,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6613,'Colorful_Brooch','Colorful Brooch',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6615,'Siege_Guild_Coin','Siege Guild Coin',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6616,'Lmtd_Manny_Card','Limited Manny Card',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6617,'Lmtd_Sid_Card','Limited Sid Card',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6618,'Lmtd_Diego_Card','Limited Diego Card',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6619,'Lmtd_Scrat_Card','Limited Scrat Card',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6623,'Rough_Energy_Crystal','Rough Energy Crystal',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6624,'Purified_Energy_Crystal','Purified Energy Crystal',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6625,'High_Purity_Energy_Xtal','High Energy Crystal',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#
REPLACE INTO `item_db_re` VALUES (6635,'Blacksmith_Blessing','Blacksmith Blessing',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6636,'Floor_Str','Strength Stone(Upper)',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6637,'Floor_Int','Intelligence Stone(Upper)',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6638,'Floor_Agi','Agility Stone(Upper)',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6639,'Floor_Dex','Dexterity Stone(Upper)',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6640,'Floor_Vit','Health Stone(Upper)',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6641,'Floor_Luk','Lucky Stone(Upper)',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6642,'ATKStone_Middle','Attack Stone(Middle)',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6643,'Floor_Matk','Magical Stone(Middle)',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6644,'HITStone_Bottom','Hit Stone(Lower)',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bHit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6645,'FLEEStone_Bottom','Evasion Stone(Lower)',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bFlee,1;',NULL,NULL);
#
REPLACE INTO `item_db_re` VALUES (6697,'Costumes_Exchange_Coupons','Costumes Exchange Coupons',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6646,'Poring_Badge','Poring Badge',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6648,'Shabby_Crown','Old Crown',3,10,NULL,10,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6649,'Broken_Horn','Broken Horn',3,10,NULL,10,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6650,'Shabby_Ring','Old Ring',3,10,NULL,10,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6651,'Rusty_Bracelet','Rusty Bracalet',3,10,NULL,10,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6652,'Old_Photo_Album','Old Photo Album',3,10,NULL,10,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6653,'Shabby_Pill','Old Pill',3,10,NULL,10,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6654,'Needle_And_Thread','Needle And Thread',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6655,'Firm_Pumpkin','Firm Pumpkin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6656,'Goast_Free_Charm','Goast Free Charm',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6657,'Memory_Of_Jack','Memory Of Jack',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6658,'Halloween_Coin','Halloween Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6665,'RWC_Inicializer','RWC Inicializer',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6671,'Geffen_Coin_Magic_Tournament','Geffen Coin Magic Tournament',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6672,'Shard_of_Gray','Shard of Gray',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6673,'Bossnia_Tickets','Bossnia Tickets',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6674,'GM_Coin','GM Coin',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6681,'XMAS_Cookie','Christmas Cookie',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6682,'Bag_Of_Selling_Goods','Bag Of Selling Goods',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6683,'Dried_Flower','Dried Flower',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6684,'TokenOfHero','Token Of Hero',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6685,'Morocc_Certification','Morocc Certification',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6686,'Brick','Brick',3,10,NULL,2000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6687,'Rope__','Rope',3,10,NULL,2000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6688,'Wood_','Wood',3,10,NULL,2000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6689,'Fire_Beetle_Shell','Fire Beetle Shell',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6690,'Delicious_Stem','Delicious Stem',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6691,'Fire_Feather','Fire Feather',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6692,'Patrol_Journal','Patrol Journal',3,10,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6693,'Stone_Blessing','Stone Blessing',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6694,'Blood_of_The_Monster','Blood of The Monster',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6695,'Tooth_Rock_Of_Fire_Golem','Tooth Rock Of Fire Golem',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6696,'Fire_Frill','Fire Frill',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6698,'Wooden_Axe','Wooden Axe',3,10,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6699,'Faith_Silence','Faith Silence',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6700,'White_Snake_Scale','White Snake Scale',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6701,'Treasure_Dwarf','Treasure Dwarf',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6702,'Sweat_Dwarf','Sweat Dwarf',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6703,'Warrior_Tears','Warrior Tears',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6704,'Warrior_Anger','Warrior Anger',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6705,'Warrior_Certificate','Warrior Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6706,'Guardian_Flowers','Guardian Flowers',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6707,'Jeremy_Beauty_Coupon','Jeremy Beauty Coupon',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6708,'Mana_crystal','Mana Crystal',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6709,'Crisp_Silk','Crisp Silk',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6710,'Tied_Snake','Tied Snake',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6712,'Lovely_Stick','Lovely Stick',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6713,'Heart_of_Soul','Heart of Soul',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6714,'Sheenas_Soul','Sheena\'s Soul',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6715,'P_Of_Evil_Soul','Darklord Soulpiece',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6716,'Cri_Stone','Critical Stone(Upper)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bCritical,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6717,'MHPStone_Middle','Fitness Stone(Middle)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHP,50;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6718,'MSPStone_Bottom','Magical Stone(Lower)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxSP,10;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6719,'Jitterbug\'s_Tooth','Jitterbug\'s Tooth',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6720,'Status_Reset_Coupon','Status Reset Coupon',18,10,NULL,0,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,NULL,NULL,'1',NULL,NULL,'resetstatus;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6721,'Status_Reset_Coupon_','Status Reset Coupon',18,10,NULL,0,NULL,NULL,NULL,0,0xFFFFFFFF,63,2,NULL,NULL,'1',NULL,NULL,'resetstatus;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6722,'Delicious_Clam_Flesh','Delicious Clam Flesh',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6723,'Delicious_Canned_Food','Delicious Canned Food',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6724,'Savage_Box','Savage Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6725,'Grand_Peco_Box','Grand Peco Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6726,'Desert_Wolf_Box','Desert Wolf Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6727,'Arranged_Photo_Album','Arranged Photo Album',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6732,'Monster_Coin','Monster Coin',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6733,'Tingly_Feather','Tingly Feather',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6734,'Unknown_Meal','Unknown Meal',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6735,'Special_Condiment','Special Condiment',3,0,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6736,'Minced_Meat','Minced Meat',3,0,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6737,'Fermented_Wheat_Flour','Fermented Wheat Flour',3,0,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6738,'Rissole','Rissole',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6739,'Recipe','Recipe',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6740,'HealStone_Top','Stone Recovery(Upper)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAddItemHealRate,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6741,'HealStone2_Top','Stone Recovery Skills(Upper)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bHealPower2,2;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6742,'HealStone_Middle','Stone Recovery(Middle)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bHPRegenRate,10,10000;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6743,'HPStone_Middle','HP Stone(Middle)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6744,'SPStone_Middle','SP Stone(Middle)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxSPrate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6745,'HealStone_Bottom','Recovery Stone(Low)',6,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bSPGainValue,1; bonus bMagicHPGainValue,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6746,'Iron_Artifacts','Steel Artifact',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6747,'Iron_Artifacts_','Steel Artifact',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6748,'Daily_Report_He_And_His_Team','Daily Report He And His Team',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6749,'Operation_Control_Device','Operation Control Device',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6750,'Failed_Engine','Failed Engine',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6751,'Crushed_Can_Iron_Plate','Crushed Can Iron Plate',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6752,'Charleston_Parts','Charleston Parts',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6753,'Token_Of_Destruction','Token Of Destruction',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6754,'Collected_Medicinal_Herbs','Collected Medicinal Herbs',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6755,'Contaminated_Magic','Contaminated Magic',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6756,'Cohesive_Energy','Cohesive Energy',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6757,'The_Memory_Recorder','The Memory Recorder',3,20,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6766,'Ice_World_Ticket','Tickets Ice Kingdom',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6767,'Summer_Fes_Coin','Summer Festival Coins',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6768,'Red_Beans_Of_Ice','Shaved Ice For Red Beans',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6769,'Sweet_Rice_Cake','Sweet Bread',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6770,'Shark','Shark',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6771,'Bluefin_Tuna','Bonito',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6772,'Octopus','Octopus',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6773,'Snapper','Sea Bream',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6774,'Piranha','Piranha',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6775,'Salmon','Salmon',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6776,'Eels','Eel',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6777,'Carp','Carp',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6778,'Squid_2','Squid',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6779,'Mackerel','Mackerel',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6780,'Crucian_Carp','Crucian Carp',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6781,'Living_Earthworm','Earthworms Alive',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6782,'Fresh_Lobster','Fresh Shrimp',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6784,'Squid_Skewer','Squid Skewer',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6785,'Fantastic_Sauce','Source Of Fantasy',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6786,'Squid_Of_Bbq','Squid Barbecue',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6787,'Good_Firewood','Long Firewood',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6788,'Rose_Knife','Rose Knife',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6789,'Custom_Pan','Customized Plates',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6790,'BigStone_Top','Large Stone(Upper)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Large,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6791,'MediumStone_Top','Medium Stone(Upper)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Medium,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6792,'SmallStone_Top','Small Stone(Upper)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddSize,Size_Small,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6795,'Ticket_Special_RO2','Ticket Special RO2',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6796,'RO2_Name_Card','RO2 Name Card',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6797,'11th_Coin','11th Anniversary Coin',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6803,'Fragments_Of_Gigan','Fragments Of Gigan',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6804,'ORGANIC_PUMPKIN','Organic Pumpkin',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6805,'INORGANIC_PUMPKIN','Inorganic Pumpkin',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6813,'Kafra_Ticket','Kafra Ticket',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6814,'Swordman_Soul','Swordman Soul',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6815,'Merchant_Soul','Merchant Soul',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6816,'Thief_Soul','Thief Soul',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6817,'Mage_Soul','Mage Soul',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6818,'Archer_Soul','Archer Soul',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6819,'Acolyte_Soul','Acolyte Soul',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6820,'Particles_Of_Energy','Energy Fragment',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6821,'Solo_Troops_Badge','Single Union Badge',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6824,'Experimental_Dong_Memory_Record','Experimental Dong Memory Record',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6825,'Air_Cleaner_Box','Air Cleaner Box',3,10,NULL,10000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6826,'Fresh_Grapes','Fresh Grapes',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6827,'Complete_Machine_Parts','Complete Machine Parts',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6828,'Gravity_Safety_Device','Gravity Safety Device',3,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6832,'Questioned_Parts','Questioned Parts',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6833,'Limited_Token_of_Ziegfried','(Limited) Token of Ziegfried',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6834,'Legendary_Fur','Legendary Fur',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6835,'Legendary_Mane','Legendary Mane',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6836,'Talisman_Of_Soul','Talisman Of Soul',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6837,'Piece_Of_Soul_Mouse','Piece Of Soul Mouse',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6838,'Secret_Orders_Of_Prophet_K','Secret Orders Of Prophet K',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6839,'Gold_Choco_Coin','Gold Choco Coin',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6840,'Silver_Choco_Coin','Silver Choco Coin',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6841,'Bronze_Choco_Coin','Bronze Choco Coin',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6842,'Huge_Jewery','Huge Jewery',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6843,'Thin_Ring','Thin Ring',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6844,'Mild_Stone','Mild Stone',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6845,'That_Thing','That Thing',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6846,'Limited_Gym_Membership_Card','(Limited)Gym Membership Card',6,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6847,'Very_Small_Box','Very Small Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6848,'Light_Box','Light Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6849,'Request_Complete_Certificate','Request Complete Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6850,'Questionable_Box','Questionable Box',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6851,'Questionable_Document','Questionable Document',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6852,'Super_Corrector','Super Corrector',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6853,'Thanks_Bouquet','Thanks Bouquet',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6854,'Novus_Captured','Novus Captured',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6855,'Tatacho_Captured','Tatacho Captured',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6856,'Manuscript_Written_By_Pigoreum','Manuscript Written By Pigoreum',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6857,'Very_Hard_Stone','Very Hard Stone',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6858,'Lude_Captured','Lude Captured',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6859,'Wanderer_Captured','Wanderer Captured',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6860,'Piece_Of_Soul_Cow','Piece Of Soul Cow',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6862,'Piece_Of_Soul_Tiger','Piece Of Soul Tiger',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6863,'Strong_Piece_Of_Soul_Tiger','Strong Piece Of Soul Tiger',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6864,'Safe_to_19_Weapon_Certificate','Safe to 19 Weapon Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6865,'Safe_to_19_Armor_Certificate','Safe to 19 Armor Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6866,'Piece_Of_Soul_Rabbit','Piece Of Soul Rabbit',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6867,'Large_Insect_Barrel','Large Insect Barrel',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6868,'Medium_Insect_Barrel','Medium Insect Barrel',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6869,'Dust','Dust',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6870,'Safe_to_13_Weapon_Certificate','Safe to 13 Weapon Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6871,'Safe_to_14_Weapon_Certificate','Safe to 14 Weapon Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6872,'Safe_to_15_Weapon_Certificate','Safe to 15 Weapon Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6873,'Safe_to_16_Weapon_Certificate','Safe to 16 Weapon Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6874,'Safe_to_17_Weapon_Certificate','Safe to 17 Weapon Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6875,'Safe_to_18_Weapon_Certificate','Safe to 18 Weapon Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6876,'Safe_to_13_Armor_Certificate','Safe to 13 Armor Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6877,'Safe_to_14_Armor_Certificate','Safe to 14 Armor Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6878,'Safe_to_15_Armor_Certificate','Safe to 15 Armor Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6879,'Safe_to_16_Armor_Certificate','Safe to 16 Armor Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6880,'Safe_to_17_Armor_Certificate','Safe to 17 Armor Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6881,'Safe_to_18_Armor_Certificate','Safe to 18 Armor Certificate',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6882,'Advanced_Bait','Advanced Bait',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6883,'Pet_Snow_Bunny_Exchange_Ticket','Pet Snow Bunny Exchange Ticket',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6884,'Pet_Tikbalang_Exchange_Ticket','Pet Tikbalang Exchange Ticket',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6885,'Piece_Of_Soul_Dragon','Piece Of Soul Dragon',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6886,'Strong_Piece_Of_Soul_Dragon','Strong Piece Of Soul Dragon',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6892,'Invasion_Plan','Invasion Plan',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6893,'Human\'s_Cookbook','Human\'s Cookbook',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6894,'Champion_Badge','Champion Badge',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6895,'Processed_Ancient_Rune','Processed Ancient Rune',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6896,'Processed_Mystic_Rune','Processed Mystic Rune',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6897,'Blue_Whale','Blue Whale',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6898,'Whale','Whale',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6899,'Giant_Octopus','Giant Octopus',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6900,'Giant_Squid','Giant Squid',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6901,'Sturgeon','Sturgeon',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6902,'King_Lobster','King Lobster',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6903,'King_Earthworm','King Earthworm',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6904,'Piece_Of_Soul_Snake','Piece Of Soul Snake',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6905,'Broken_Magic_Stone','Broken Magic Stone',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6906,'Limited_High_Density_Kalunium','(Limited)High Density Kalunium',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6907,'Piece_Of_Soul_Horse','Piece Of Soul Horse',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6908,'ASPDStone_Robe','Stone ASPD (Garment)',6,20,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAspd,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6909,'Actinidia_Cat_Fruit','Actinidia Cat Fruit',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6910,'Limited_Purified_Oridecon','(Limited) Purified Oridecon',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6911,'Limited_Purified_Eluminium','(Limited) Purified Eluminium',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6912,'Piece_Of_Soul_Sheep','Piece Of Soul Sheep',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6913,'Holy_Rosary','Holy Rosary',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6914,'Black_Horn','Black Horn',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6915,'Captured_Soul','Captured Soul',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6916,'Piece_Of_Soul_Monkey','Piece Of Soul Monkey',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6917,'Piece_Of_Soul_Chicken','Piece Of Soul Chicken',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6919,'Honor_Proof','Honor Token',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6920,'Rune_Magic_Powder','Rune Magic Powder',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6921,'Dehumidifiers','Dehumidifiers',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6922,'Sandpaper','Sandpaper',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6923,'Bright_Fire_Lights','Bright Fire Lights',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6924,'Red_Eye','Red Eye',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6925,'Letter_Of_Prisoner','Letter Of Prisoner',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6926,'Rune-Midgard_History_Book','Rune-Midgard History Book',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6927,'Stone_That_Contained_Sea','Stone That Contained Sea',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6928,'Poring_Scourer','Poring Scourer',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6929,'Letter_With_Stamped_Seal','Letter With Stamped Seal',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6930,'Samples_New_Business_Items','Samples New Business Items',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6931,'Secret_Documents','Secret Documents',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6932,'Rare_Book','Rare Book',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6933,'Banquet_Invitation_Letter','Banquet Invitation Letter',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6934,'Magnificent_Dish','Magnificent Dish',3,10,NULL,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6935,'Advanced_Dish','Advanced Dish',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6936,'Cold_Core','Cold Core',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6937,'Silicone_Shell','Silicone Shell',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6938,'Hedgehog_Picks','Hedgehog Picks',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6939,'Old_Belt','Worn-Out Belt',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6940,'Moving_Dark_Matter','Moving Black Material',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6941,'Fragments_Valkyrie_Power','Fragments Valkyrie Power',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6942,'Will_Master','Will Master',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6943,'ATKStone_Top','Attack Stone(Upper)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus2 bAddClass,Class_All,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6944,'MATKStone_Top','Magic Stone(Upper)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMatkRate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6945,'Floor_Str2','Strength Stone(Middle)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bStr,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6946,'Floor_Int2','Intelligence Stone(Middle)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bInt,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6947,'Floor_Agi2','Agility Stone(Middle)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bAgi,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6948,'Floor_Dex2','Dexterity Stone(Middle)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bDex,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6949,'Floor_Vit2','Vitality Stone(Middle)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bVit,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6950,'Floor_Luk2','Lucky Stone(Middle)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bLuk,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6951,'HPStone_Bottom','HP Stone(Lower)',6,10,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'bonus bMaxHPrate,1;',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6953,'Ramor_Refine_Ticket','Ramor Refine Ticket',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/*Refine succeed guarantee until +9 for item 2598 only*/',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6954,'Piece_Of_Soul_Dog','Piece Of Soul Dog',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6955,'Piece_Of_Soul_Pig','Piece Of Soul Pig',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6956,'Captured_Sheep','Captured Sheep',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6957,'Lamb_Fleece','Lamb Fleece',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6958,'Lamb_Horns','Lamb Horns',3,10,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6960,'Key_Air_Fortress','Key Air Fortress',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6961,'Huge_Metal_Scrap','Huge Metal Scrap',3,10,0,1000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6962,'Old_Fuel','Old Fuel',3,10,0,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

REPLACE INTO `item_db_re` VALUES (6965,'Fire_Property_Reactor_Blueprint','Fire Property Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6966,'Water_Property_Reactor_Blueprint','Water Property Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6967,'Earth_Property_Reactor_Blueprint','Earth Property Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6968,'Wind_Property_Reactor_Blueprint','Wind Property Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6969,'Fire_Res_Reactor_Blueprint','Fire Resistance Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6970,'Water_Res_Reactor_Blueprint','Water Resistance Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6971,'Earth_Res_Reactor_Blueprint','Earth Resistance Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6972,'Wind_Res_Reactor_Blueprint','Wind Resistance Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6973,'Recovery101_Reactor_Blueprint','Recovery101 Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6974,'Recovery102_Reactor_Blueprint','Recovery102 Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6975,'Recovery201_Reactor_Blueprint','Recovery201 Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6976,'Recovery202_Reactor_Blueprint','Recovery202 Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6977,'STR_Reactor_Blueprint','STR Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6978,'INT_Reactor_Blueprint','INT Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6979,'DEF_Reactor_Blueprint','DEF Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6980,'PD_Reactor_Blueprint','Perfect Dodge Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6981,'ATK_Reactor_Blueprint','Attack Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6982,'MATK_Reactor_Blueprint','Magical Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6983,'HP_Reactor_Blueprint','HP Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6984,'SP_Reactor_Blueprint','SP Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6985,'Frozen_Reactor_Blueprint','Frozen Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (6986,'ASPD_Reactor_Blueprint','ASPD Reactor Blueprint',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

#
REPLACE INTO `item_db_re` VALUES (7001,'Mould_Powder','Mould Powder',3,466,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7002,'Ogre_Tooth','Ogre Tooth',3,658,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7003,'Anolian_Skin','Anolian Skin',3,968,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7004,'Mud_Lump','Mud Lump',3,876,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7005,'Skull','Skull',3,1044,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7006,'Wing_Of_Red_Bat','Wing of Red Bat',3,168,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7007,'Claw_Of_Rat','Claw of Rat',3,748,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7008,'Stiff_Horn','Stiff Horn',3,636,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7009,'Glitter_Shell','Glitter Shell',3,528,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7010,'Tail_Of_Steel_Scorpion','Tail of Steel Scorpion',3,548,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7011,'Claw_Of_Monkey','Claw of Monkey',3,466,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7012,'Tough_Scalelike_Stem','Tough Scalelike Stem',3,412,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7013,'Coral_Reef','Coral Reef',3,772,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7014,'Old_Portrait','Old Portrait',3,1500,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7015,'Bookclip_In_Memory','Bookclip in Memory',3,3000,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7016,'Spoon_Stub','Spoon Stub',3,2500,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7017,'Executioner\'s_Mitten','Executioner\'s Mitten',3,4500,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7018,'Young_Twig','Young Twig',3,50,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7019,'Loki\'s_Whispers','Loki\'s Whispers',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7020,'Mother\'s_Nightmare','Mother\'s Nightmare',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7021,'Foolishness_Of_Blind','Foolishness of the Blind',3,20,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7022,'Old_Hilt','Old Hilt',3,150,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7023,'Blade_Lost_In_Darkness','Blade Lost in Darkness',3,12000,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7024,'Bloody_Edge','Bloody Edge',3,10000,NULL,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7025,'Lucifer\'s_Lament','Lucifer\'s Lament',3,30000,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7026,'Key_Of_Clock_Tower','Key of Clock Tower',3,100,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7027,'Underground_Key','Key of Underground',3,100,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7028,'Invite_For_Duel','Invite for Duel',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7029,'Admission_For_Duel','Admission for Duel',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7030,'Claw_Of_Desert_Wolf','Claw of Desert Wolf',3,208,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7031,'Old_Frying_Pan','Old Frying Pan',3,196,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7032,'Piece_Of_Egg_Shell','Piece of Egg Shell',3,168,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7033,'Poison_Spore','Poison Spore',3,114,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7034,'Red_Socks_With_Holes','Red Stocking',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7035,'Matchstick','Matchstick',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7036,'Fang_Of_Garm','Fang of Hatii',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7037,'Trade_Coupon','Coupon',2,100,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/*set pcroom,(gettimetick(2)+7200);*/',NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7038,'Yarn','Yarn',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7039,'Novice_Nametag','Newbie Tag',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7040,'Megaphone','Megaphone',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7041,'Fine_Grit','Fine Grit',3,120,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7042,'Leather_Bag_Of_Infinity','Leather Bag of Infinity',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7043,'Fine_Sand','Fine Sand',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7044,'Vigorgra','Vigorgra',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7045,'Magic_Paint','Magic Paint',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7046,'Cart_Parts','Cart Parts',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7047,'Alice\'s_Apron','Alice\'s Apron',3,2424,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7048,'Talon_Of_Griffin','Talon of Griffon',3,5418,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7049,'Stone','Stone',3,0,NULL,30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7050,'Cotton_Mat','Cotton Mat',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7051,'Silk_Mat','Silk Mat',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7052,'Old_Magazine','Old Papers',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7053,'Cyfar','Cyfar',3,772,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7054,'Brigan','Brigan',3,746,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7055,'Animal_Pooopoo','Animal Poop',3,100,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7056,'Payroll_Of_Kafra','Payment Statement for Kafra Employee',3,1,NULL,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7057,'Gallar_Horn','Gjallar',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7058,'Gullraifnir','Gleipnir',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7059,'Cargo_Free_Ticket','Free Ticket for Kafra Storage',3,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7060,'Warp_Free_Ticket','Free Ticket for Kafra Transportation',3,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7061,'Cart_Free_Ticket','Free Ticket for the Cart Service',3,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7062,'Broken_Turtle_Shell','Broken Turtle Shell',3,280,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7063,'Soft_Feather','Soft Feather',3,280,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7064,'Dragon_Fly_Wing','Wing of Dragonfly',3,520,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7065,'Sea_Otter_Leather','Sea-Otter Fur',3,820,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7066,'Ice_Piece','Ice Cubic',3,660,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7067,'Stone_Piece','Stone Fragment',3,640,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7068,'Burn_Tree','Burnt Tree',3,722,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7069,'Broken_Armor_Piece','Destroyed Armor',3,1042,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7070,'Broken_Shell','Broken Shell',3,900,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7071,'Tatters_Clothes','Tattered Clothes',3,1280,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7072,'Rust_Suriken','Old Shuriken',3,1780,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7073,'Jewel_Of_Prayer','Freya\'s Jewel',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7074,'Iron_Glove','Thor\'s Gauntlets',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7075,'Iron_Maiden','Iron Maiden',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7076,'Mystery_Wheel','Wheel of the Unknown',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7077,'Silver_Fancy','Silver Ornament',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7078,'Anger_Of_Valkurye','Wrath of Valkyrie',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7079,'Feather_Of_Angel','Feather of Angel Wing',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7080,'Foot_Step_Of_Cat','Cat Tread',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7081,'Beard_Of_Women','Woman\'s Moustache',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7082,'Root_Of_Stone','Root of Stone',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7083,'Soul_Of_Fish','Spirit of Fish',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7084,'Saliva_Of_Bird','Sputum of Bird',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7085,'Tendon_Of_Bear','Sinew of Bear',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7086,'Symbol_Of_Sun','Emblem of the Sun God',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7087,'Breath_Of_Soul','Breath of Spirit',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7088,'Crystal_Of_Snow','Snow Crystal',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7089,'Indication_Of_Tempest','Omen of Tempest',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7090,'Slilince_Wave','Ripple',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7091,'Rough_Billows','Billow',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7092,'Air_Stream','Drifting Air',3,1,NULL,500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7093,'Wheel','Cogwheel',3,1512,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7094,'Mystery_Piece','Fragment',3,1344,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7095,'Broken_Steel_Piece','Metal Fragment',3,1075,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7096,'Cold_Magma','Lava',3,1109,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7097,'Burning_Heart','Burning Heart',3,924,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7098,'Live_Coal','Live Coal',3,638,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7099,'Old_Magic_Circle','Worn-out Magic Scroll',3,773,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7100,'Sharp_Leaf','Sharp Leaf',3,806,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7101,'Peco_Wing_Feather','Peco Peco Feather',3,454,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7102,'Hideous_Dream','Nightmare',3,1075,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7103,'Unknown_Liquid_Bottle','Unknown Liquid Bottle',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7104,'Fake_Angel_Wing','False Angel Wing',3,756,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7105,'Fake_Angel_Loop','False Heaven Ring',3,924,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7106,'Goat\'s_Horn','Antelope Horn',3,672,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7107,'Gaoat\'s_Skin','Antelope Skin',3,756,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7108,'Boroken_Shiled_Piece','Piece of Shield',3,1680,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7109,'Shine_Spear_Blade','Shining Spear Blade',3,840,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7110,'Vroken_Sword','Broken Sword',3,588,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7111,'Smooth_Paper','Slick Paper',3,706,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7112,'Fright_Paper_Blade','Sharp Paper',3,907,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7113,'Broken_Pharaoh_Symbol','Broken Pharaoh Emblem',3,2016,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7114,'Tutankhamen\'s_Mask','Masque of Tutankhamen',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7115,'Harpy\'s_Feather','Harpy Feather',3,1142,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7116,'Harpy\'s_Claw','Harpy Talon',3,1210,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7117,'Rent_Spell_Book','Torn Magic Book',3,1142,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7118,'Rent_Scroll','Torn Scroll',3,1361,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7119,'Spawns','Bacillus',3,1025,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7120,'Burning_Horse_Shoe','Burning Horseshoe',3,823,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7121,'Honey_Jar','Honey Pot',3,622,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7122,'Hot_Hair','Burning Hair',3,974,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7123,'Dragon\'s_Skin','Dragon Skin',3,1025,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7124,'Sand_Lump','Sand Clump',3,706,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7125,'Scropion\'s_Nipper','Scorpion Claw',3,706,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7126,'Large_Jellopy','Large Jellopy',3,840,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7127,'Alcol_Create_Book','Alcohol Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7128,'FireBottle_Create_Book','Bottle Grenade Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7129,'Acid_Create_Book','Acid Bottle Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7130,'Plant_Create_Book','Plant Bottle Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7131,'Mine_Create_Book','Marine Sphere Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7132,'Coating_Create_Book','Glistening Coat Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7133,'Slim_Potion_Create_Book','Condensed Potion Creation Guide',3,240000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7134,'Medicine_Bowl','Medicine Bowl',3,8,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7135,'Fire_Bottle','Bottle Grenade',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7136,'Acid_Bottle','Acid Bottle',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7137,'MenEater_Plant_Bottle','Plant Bottle',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7138,'Mini_Bottle','Marine Sphere Bottle',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7139,'Coating_Bottle','Glistening Coat',3,200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7140,'Seed_Of_Life','Seed of Life',3,60000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7141,'Yggdrasilberry_Dew','Morning Dew of Yggdrasil',3,20000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7142,'Germination_Breed','Embryo',3,10,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7143,'Life_Force_Pot','Glass Tube',3,5000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7144,'Normal_Potion_Book','Potion Creation Guide',3,100000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7145,'Rag_T_Shirts','Ragnarok T-shirt',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7146,'Vacance_Ticket','Vacation Ticket',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7147,'Jasmin','Jasmine',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7148,'Mother_Letter','Mother\'s Letter',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7149,'Yellow_Plate','Yellow Plate',3,220,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7150,'Bamboo_Cut','Piece of Bamboo',3,310,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7151,'Oil_Paper','Oil Paper',3,210,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7152,'Glossy_Hair','Glossy Hair',3,340,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7153,'Old_Japaness_Clothes','Worn-out Kimono',3,590,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7154,'Poison_Powder','Poisonous Powder',3,160,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7155,'Poison_Toad\'s_Skin','Poisonous Toad Skin',3,280,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7156,'Broken_Shuriken','Broken Shuriken',3,470,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7157,'Black_Mask','Dark Mask',3,315,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7158,'Broken_Wine_Vessel','Broken Liquor Jar',3,160,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7159,'Tengu\'s_Nose','Tengu Nose',3,400,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7160,'Lord\'s_Passable_Ticket','Feudal Lord Permit',3,1,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7161,'Black_Bear\'s_Skin','Black Bear Skin',3,384,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7162,'Cloud_Piece','Cloud Crumb',3,390,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7163,'Sharp_Feeler','Hard Feeler',3,570,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7164,'Hard_Peach','Solid Peach',3,400,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7165,'Limpid_Celestial_Robe','Transparent Celestial Robe',3,650,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7166,'Soft_Silk_Cloth','Soft Silk',3,1200,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7167,'Mystery_Iron_Bit','Strange Steel Piece',3,430,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7168,'Great_Wing','Giant Butterfly Wing',3,614,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7169,'Taegeuk_Plate','Ba Gua',3,2800,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7170,'Tuxedo','Tuxedo',3,43000,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7171,'Leopard_Skin','Leopard Skin',3,282,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7172,'Leopard_Talon','Leopard Claw',3,290,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7173,'BurnBuster_Bag','iROGM02\'s Backpack',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7174,'Packing_Ribbon','Wrapping Lace',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7175,'Packing_Paper','Wrapping Paper',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7176,'XMAS_Coupon','Royal Certificate',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7177,'Part_Of_Star\'s_Sob','Crumb of Sobbing Starlight',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7178,'Star\'s_Sob','Sobbing Starlight',3,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7179,'Donation_Card','Proof of Donation',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7180,'Introduction_Of_Mr.Han','Hahn Sukbong\'s Recommendation',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7181,'Receipt_01','Receipt',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7182,'Cacao','Cacao',3,200,NULL,20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7183,'Sister_Letter','Letter from Sister',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7184,'Piano_Keyboard','Piano Key',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7185,'Quiz_Ticket','Quiz Entry',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7186,'Thin_Stem','Thin Trunk',3,380,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7187,'Festival_Mask','Festival Mask',3,100,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7188,'Browny_Root','Brown Root',3,560,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7189,'Heart_Of_Tree','Wooden Heart',3,680,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7190,'Solid_Peeling','Solid Husk',3,140,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7191,'Lamplight','Lamp',3,0,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7192,'Blade_Of_Pinwheel','Vane',3,160,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7193,'Germinating_Sprout','Sprout',3,230,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `item_db_re` VALUES (7194,'Soft_Leaf','Soft Blade of Grass',3,400,NULL,10,NULL,NULL