// Copyright (c) rAthena Dev Teams - Licensed under GNU GPL
// For more information, see LICENCE in the main folder

#ifndef SCRIPT_CONSTANTS_HPP
#define SCRIPT_CONSTANTS_HPP

	#define export_constant(a) script_set_constant(#a,a,false,false)
	#define export_constant2(a,b) script_set_constant(a,b,false,false)
	#define export_constant_offset(a,offset) script_set_constant(#a + (offset),a,false,false)
	#define export_parameter(a,b) script_set_constant(a,b,true,false)
	#define export_deprecated_constant(a) script_set_constant(#a,a,false,true)
	#define export_deprecated_constant2(a,b) script_set_constant(a,b,false,true)
	#define export_deprecated_constant3(a,b,c) script_set_constant_(a,b,c,false,true)

	/* min and maximum variable value */
	export_constant(INT_MIN);
	export_constant(INT_MAX);

	/* server defines */
	export_constant(PACKETVER);
	export_constant(MAX_LEVEL);
	export_constant(MAX_STORAGE);
	export_constant(MAX_INVENTORY);
	export_constant(MAX_CART);
	export_constant(MAX_ZENY);
	export_constant(MAX_PARTY);
	export_constant(MAX_GUILD);
	export_constant(MAX_GUILDLEVEL);
	export_constant(MAX_GUARDIANS);
	export_constant(MAX_GUILD_STORAGE);
	export_constant(MAX_BG_MEMBERS);
	export_constant(MAX_CHAT_USERS);
	export_constant(VIP_SCRIPT);
	export_constant(MIN_STORAGE);
	export_constant(MAX_SLOTS);
	export_constant(MAX_ITEM_RDM_OPT);
	export_constant(NAME_LENGTH);
	export_constant(PASSWD_LENGTH);

	/* boolean values */
	export_constant(true);
	export_constant(false);

	/* jobs */
	export_constant(JOB_NOVICE);
	export_constant(JOB_SWORDMAN);
	export_constant(JOB_MAGE);
	export_constant(JOB_ARCHER);
	export_constant(JOB_ACOLYTE);
	export_constant(JOB_MERCHANT);
	export_constant(JOB_THIEF);
	export_constant(JOB_KNIGHT);
	export_constant(JOB_PRIEST);
	export_constant(JOB_WIZARD);
	export_constant(JOB_BLACKSMITH);
	export_constant(JOB_HUNTER);
	export_constant(JOB_ASSASSIN);
	export_constant(JOB_KNIGHT2);
	export_constant(JOB_CRUSADER);
	export_constant(JOB_MONK);
	export_constant(JOB_SAGE);
	export_constant(JOB_ROGUE);
	export_constant(JOB_ALCHEMIST);
	export_constant(JOB_BARD);
	export_constant(JOB_DANCER);
	export_constant(JOB_CRUSADER2);
	export_constant(JOB_WEDDING);
	export_constant(JOB_SUPER_NOVICE);
	// For backwards compatability
	export_constant2("Job_SuperNovice",JOB_SUPER_NOVICE); // TODO: Refactor NPCs to use the new constant
	export_constant(JOB_GUNSLINGER);
	export_constant(JOB_NINJA);
	export_constant(JOB_XMAS);
	export_constant(JOB_SUMMER);
	export_constant(JOB_HANBOK);
	export_constant(JOB_OKTOBERFEST);
	export_constant(JOB_SUMMER2);

	export_constant(JOB_NOVICE_HIGH);
	export_constant(JOB_SWORDMAN_HIGH);
	export_constant(JOB_MAGE_HIGH);
	export_constant(JOB_ARCHER_HIGH);
	export_constant(JOB_ACOLYTE_HIGH);
	export_constant(JOB_MERCHANT_HIGH);
	export_constant(JOB_THIEF_HIGH);
	export_constant(JOB_LORD_KNIGHT);
	export_constant(JOB_HIGH_PRIEST);
	export_constant(JOB_HIGH_WIZARD);
	export_constant(JOB_WHITESMITH);
	export_constant(JOB_SNIPER);
	export_constant(JOB_ASSASSIN_CROSS);
	export_constant(JOB_LORD_KNIGHT2);
	export_constant(JOB_PALADIN);
	export_constant(JOB_CHAMPION);
	export_constant(JOB_PROFESSOR);
	export_constant(JOB_STALKER);
	export_constant(JOB_CREATOR);
	export_constant(JOB_CLOWN);
	export_constant(JOB_GYPSY);
	export_constant(JOB_PALADIN2);

	export_constant(JOB_BABY);
	export_constant(JOB_BABY_SWORDMAN);
	export_constant(JOB_BABY_MAGE);
	export_constant(JOB_BABY_ARCHER);
	export_constant(JOB_BABY_ACOLYTE);
	export_constant(JOB_BABY_MERCHANT);
	export_constant(JOB_BABY_THIEF);
	export_constant(JOB_BABY_KNIGHT);
	export_constant(JOB_BABY_PRIEST);
	export_constant(JOB_BABY_WIZARD);
	export_constant(JOB_BABY_BLACKSMITH);
	export_constant(JOB_BABY_HUNTER);
	export_constant(JOB_BABY_ASSASSIN);
	export_constant(JOB_BABY_KNIGHT2);
	export_constant(JOB_BABY_CRUSADER);
	export_constant(JOB_BABY_MONK);
	export_constant(JOB_BABY_SAGE);
	export_constant(JOB_BABY_ROGUE);
	export_constant(JOB_BABY_ALCHEMIST);
	export_constant(JOB_BABY_BARD);
	export_constant(JOB_BABY_DANCER);
	export_constant(JOB_BABY_CRUSADER2);
	export_constant(JOB_SUPER_BABY);

	export_constant(JOB_TAEKWON);
	export_constant(JOB_STAR_GLADIATOR);
	export_constant(JOB_STAR_GLADIATOR2);
	export_constant(JOB_SOUL_LINKER);

	export_constant(JOB_GANGSI);
	export_constant(JOB_DEATH_KNIGHT);
	export_constant(JOB_DARK_COLLECTOR);

	export_constant(JOB_RUNE_KNIGHT);
	export_constant(JOB_WARLOCK);
	export_constant(JOB_RANGER);
	export_constant(JOB_ARCH_BISHOP);
	export_constant(JOB_MECHANIC);
	export_constant(JOB_GUILLOTINE_CROSS);

	export_constant(JOB_RUNE_KNIGHT_T);
	export_constant(JOB_WARLOCK_T);
	export_constant(JOB_RANGER_T);
	export_constant(JOB_ARCH_BISHOP_T);
	export_constant(JOB_MECHANIC_T);
	export_constant(JOB_GUILLOTINE_CROSS_T);

	export_constant(JOB_ROYAL_GUARD);
	export_constant(JOB_SORCERER);
	export_constant(JOB_MINSTREL);
	export_constant(JOB_WANDERER);
	export_constant(JOB_SURA);
	export_constant(JOB_GENETIC);
	export_constant(JOB_SHADOW_CHASER);

	export_constant(JOB_ROYAL_GUARD_T);
	export_constant(JOB_SORCERER_T);
	export_constant(JOB_MINSTREL_T);
	export_constant(JOB_WANDERER_T);
	export_constant(JOB_SURA_T);
	export_constant(JOB_GENETIC_T);
	export_constant(JOB_SHADOW_CHASER_T);

	export_constant(JOB_RUNE_KNIGHT2);
	export_constant(JOB_RUNE_KNIGHT_T2);
	export_constant(JOB_ROYAL_GUARD2);
	export_constant(JOB_ROYAL_GUARD_T2);
	export_constant(JOB_RANGER2);
	export_constant(JOB_RANGER_T2);
	export_constant(JOB_MECHANIC2);
	export_constant(JOB_MECHANIC_T2);

	export_constant(JOB_BABY_RUNE);
	export_constant(JOB_BABY_WARLOCK);
	export_constant(JOB_BABY_RANGER);
	export_constant(JOB_BABY_BISHOP);
	export_constant(JOB_BABY_MECHANIC);
	export_constant(JOB_BABY_CROSS);
	export_constant(JOB_BABY_GUARD);
	export_constant(JOB_BABY_SORCERER);
	export_constant(JOB_BABY_MINSTREL);
	export_constant(JOB_BABY_WANDERER);
	export_constant(JOB_BABY_SURA);
	export_constant(JOB_BABY_GENETIC);
	export_constant(JOB_BABY_CHASER);

	export_constant(JOB_BABY_RUNE2);
	export_constant(JOB_BABY_GUARD2);
	export_constant(JOB_BABY_RANGER2);
	export_constant(JOB_BABY_MECHANIC2);

	export_constant(JOB_SUPER_NOVICE_E);
	export_constant(JOB_SUPER_BABY_E);

	export_constant(JOB_KAGEROU);
	export_constant(JOB_OBORO);

	export_constant(JOB_REBELLION);

	export_constant(JOB_SUMMONER);

	export_constant(JOB_BABY_SUMMONER);

	export_constant(JOB_BABY_NINJA);
	export_constant(JOB_BABY_KAGEROU);
	export_constant(JOB_BABY_OBORO);
	export_constant(JOB_BABY_TAEKWON);
	export_constant(JOB_BABY_STAR_GLADIATOR);
	export_constant(JOB_BABY_SOUL_LINKER);
	export_constant(JOB_BABY_GUNSLINGER);
	export_constant(JOB_BABY_REBELLION);

	export_constant(JOB_BABY_STAR_GLADIATOR2);

	export_constant(JOB_STAR_EMPEROR);
	export_constant(JOB_SOUL_REAPER);
	export_constant(JOB_BABY_STAR_EMPEROR);
	export_constant(JOB_BABY_SOUL_REAPER);
	export_constant(JOB_STAR_EMPEROR2);
	export_constant(JOB_BABY_STAR_EMPEROR2);

	/* EA jobs */
	export_constant2("EAJL_2_1",JOBL_2_1);
	export_constant2("EAJL_2_2",JOBL_2_2);
	export_constant2("EAJL_2",JOBL_2);
	export_constant2("EAJL_UPPER",JOBL_UPPER);
	export_constant2("EAJL_BABY",JOBL_BABY);
	export_constant2("EAJL_THIRD",JOBL_THIRD);

	export_constant2("EAJ_BASEMASK",MAPID_BASEMASK);
	export_constant2("EAJ_UPPERMASK",MAPID_UPPERMASK);
	export_constant2("EAJ_THIRDMASK",MAPID_THIRDMASK);

	export_constant2("EAJ_NOVICE",MAPID_NOVICE);
	export_constant2("EAJ_SWORDMAN",MAPID_SWORDMAN);
	export_constant2("EAJ_MAGE",MAPID_MAGE);
	export_constant2("EAJ_ARCHER",MAPID_ARCHER);
	export_constant2("EAJ_ACOLYTE",MAPID_ACOLYTE);
	export_constant2("EAJ_MERCHANT",MAPID_MERCHANT);
	export_constant2("EAJ_THIEF",MAPID_THIEF);
	export_constant2("EAJ_TAEKWON",MAPID_TAEKWON);
	export_constant2("EAJ_GUNSLINGER",MAPID_GUNSLINGER);
	export_constant2("EAJ_NINJA",MAPID_NINJA);
	export_constant2("EAJ_GANGSI",MAPID_GANGSI);

	export_constant2("EAJ_KNIGHT",MAPID_KNIGHT);
	export_constant2("EAJ_WIZARD",MAPID_WIZARD);
	export_constant2("EAJ_HUNTER",MAPID_HUNTER);
	export_constant2("EAJ_PRIEST",MAPID_PRIEST);
	export_constant2("EAJ_BLACKSMITH",MAPID_BLACKSMITH);
	export_constant2("EAJ_ASSASSIN",MAPID_ASSASSIN);
	export_constant2("EAJ_STAR_GLADIATOR",MAPID_STAR_GLADIATOR);
	export_constant2("EAJ_REBELLION",MAPID_REBELLION);
	export_constant2("EAJ_KAGEROUOBORO",MAPID_KAGEROUOBORO);
	export_constant2("EAJ_DEATH_KNIGHT",MAPID_DEATH_KNIGHT);

	export_constant2("EAJ_CRUSADER",MAPID_CRUSADER);
	export_constant2("EAJ_SAGE",MAPID_SAGE);
	export_constant2("EAJ_BARDDANCER",MAPID_BARDDANCER);
	export_constant2("EAJ_MONK",MAPID_MONK);
	export_constant2("EAJ_ALCHEMIST",MAPID_ALCHEMIST);
	export_constant2("EAJ_ROGUE",MAPID_ROGUE);
	export_constant2("EAJ_SOUL_LINKER",MAPID_SOUL_LINKER);
	export_constant2("EAJ_DARK_COLLECTOR",MAPID_DARK_COLLECTOR);

	export_constant2("EAJ_NOVICE_HIGH",MAPID_NOVICE_HIGH);
	export_constant2("EAJ_SWORDMAN_HIGH",MAPID_SWORDMAN_HIGH);
	export_constant2("EAJ_MAGE_HIGH",MAPID_MAGE_HIGH);
	export_constant2("EAJ_ARCHER_HIGH",MAPID_ARCHER_HIGH);
	export_constant2("EAJ_ACOLYTE_HIGH",MAPID_ACOLYTE_HIGH);
	export_constant2("EAJ_MERCHANT_HIGH",MAPID_MERCHANT_HIGH);
	export_constant2("EAJ_THIEF_HIGH",MAPID_THIEF_HIGH);

	export_constant2("EAJ_LORD_KNIGHT",MAPID_LORD_KNIGHT);
	export_constant2("EAJ_HIGH_WIZARD",MAPID_HIGH_WIZARD);
	export_constant2("EAJ_SNIPER",MAPID_SNIPER);
	export_constant2("EAJ_HIGH_PRIEST",MAPID_HIGH_PRIEST);
	export_constant2("EAJ_WHITESMITH",MAPID_WHITESMITH);
	export_constant2("EAJ_ASSASSIN_CROSS",MAPID_ASSASSIN_CROSS);

	export_constant2("EAJ_PALADIN",MAPID_PALADIN);
	export_constant2("EAJ_PROFESSOR",MAPID_PROFESSOR);
	export_constant2("EAJ_CLOWNGYPSY",MAPID_CLOWNGYPSY);
	export_constant2("EAJ_CHAMPION",MAPID_CHAMPION);
	export_constant2("EAJ_CREATOR",MAPID_CREATOR);
	export_constant2("EAJ_STALKER",MAPID_STALKER);

	export_constant2("EAJ_BABY",MAPID_BABY);
	export_constant2("EAJ_BABY_SWORDMAN",MAPID_BABY_SWORDMAN);
	export_constant2("EAJ_BABY_MAGE",MAPID_BABY_MAGE);
	export_constant2("EAJ_BABY_ARCHER",MAPID_BABY_ARCHER);
	export_constant2("EAJ_BABY_ACOLYTE",MAPID_BABY_ACOLYTE);
	export_constant2("EAJ_BABY_MERCHANT",MAPID_BABY_MERCHANT);
	export_constant2("EAJ_BABY_THIEF",MAPID_BABY_THIEF);
	export_constant2("EAJ_BABY_TAEKWON",MAPID_BABY_TAEKWON);
	export_constant2("EAJ_BABY_GUNSLINGER",MAPID_BABY_GUNSLINGER);
	export_constant2("EAJ_BABY_NINJA",MAPID_BABY_NINJA);
	export_constant2("EAJ_BABY_SUMMONER",MAPID_BABY_SUMMONER);

	export_constant2("EAJ_BABY_KNIGHT",MAPID_BABY_KNIGHT);
	export_constant2("EAJ_BABY_WIZARD",MAPID_BABY_WIZARD);
	export_constant2("EAJ_BABY_HUNTER",MAPID_BABY_HUNTER);
	export_constant2("EAJ_BABY_PRIEST",MAPID_BABY_PRIEST);
	export_constant2("EAJ_BABY_BLACKSMITH",MAPID_BABY_BLACKSMITH);
	export_constant2("EAJ_BABY_ASSASSIN",MAPID_BABY_ASSASSIN);
	export_constant2("EAJ_BABY_STAR_GLADIATOR",MAPID_BABY_STAR_GLADIATOR);
	export_constant2("EAJ_BABY_REBELLION",MAPID_BABY_REBELLION);
	export_constant2("EAJ_BABY_KAGEROUOBORO",MAPID_BABY_KAGEROUOBORO);

	export_constant2("EAJ_BABY_CRUSADER",MAPID_BABY_CRUSADER);
	export_constant2("EAJ_BABY_SAGE",MAPID_BABY_SAGE);
	export_constant2("EAJ_BABY_BARDDANCER",MAPID_BABY_BARDDANCER);
	export_constant2("EAJ_BABY_MONK",MAPID_BABY_MONK);
	export_constant2("EAJ_BABY_ALCHEMIST",MAPID_BABY_ALCHEMIST);
	export_constant2("EAJ_BABY_ROGUE",MAPID_BABY_ROGUE);
	export_constant2("EAJ_BABY_SOUL_LINKER",MAPID_BABY_SOUL_LINKER);

	export_constant2("EAJ_RUNE_KNIGHT",MAPID_RUNE_KNIGHT);
	export_constant2("EAJ_WARLOCK",MAPID_WARLOCK);
	export_constant2("EAJ_RANGER",MAPID_RANGER);
	export_constant2("EAJ_ARCH_BISHOP",MAPID_ARCH_BISHOP);
	export_constant2("EAJ_MECHANIC",MAPID_MECHANIC);
	export_constant2("EAJ_GUILLOTINE_CROSS",MAPID_GUILLOTINE_CROSS);
	export_constant2("EAJ_STAR_EMPEROR",MAPID_STAR_EMPEROR);

	export_constant2("EAJ_ROYAL_GUARD",MAPID_ROYAL_GUARD);
	export_constant2("EAJ_SORCERER",MAPID_SORCERER);
	export_constant2("EAJ_MINSTRELWANDERER",MAPID_MINSTRELWANDERER);
	export_constant2("EAJ_SURA",MAPID_SURA);
	export_constant2("EAJ_GENETIC",MAPID_GENETIC);
	export_constant2("EAJ_SHADOW_CHASER",MAPID_SHADOW_CHASER);
	export_constant2("EAJ_SOUL_REAPER",MAPID_SOUL_REAPER);

	export_constant2("EAJ_RUNE_KNIGHT_T",MAPID_RUNE_KNIGHT_T);
	export_constant2("EAJ_WARLOCK_T",MAPID_WARLOCK_T);
	export_constant2("EAJ_RANGER_T",MAPID_RANGER_T);
	export_constant2("EAJ_ARCH_BISHOP_T",MAPID_ARCH_BISHOP_T);
	export_constant2("EAJ_MECHANIC_T",MAPID_MECHANIC_T);
	export_constant2("EAJ_GUILLOTINE_CROSS_T",MAPID_GUILLOTINE_CROSS_T);

	export_constant2("EAJ_ROYAL_GUARD_T",MAPID_ROYAL_GUARD_T);
	export_constant2("EAJ_SORCERER_T",MAPID_SORCERER_T);
	export_constant2("EAJ_MINSTRELWANDERER_T",MAPID_MINSTRELWANDERER_T);
	export_constant2("EAJ_SURA_T",MAPID_SURA_T);
	export_constant2("EAJ_GENETIC_T",MAPID_GENETIC_T);
	export_constant2("EAJ_SHADOW_CHASER_T",MAPID_SHADOW_CHASER_T);

	export_constant2("EAJ_BABY_RUNE",MAPID_BABY_RUNE);
	export_constant2("EAJ_BABY_WARLOCK",MAPID_BABY_WARLOCK);
	export_constant2("EAJ_BABY_RANGER",MAPID_BABY_RANGER);
	export_constant2("EAJ_BABY_BISHOP",MAPID_BABY_BISHOP);
	export_constant2("EAJ_BABY_MECHANIC",MAPID_BABY_MECHANIC);
	export_constant2("EAJ_BABY_CROSS",MAPID_BABY_CROSS);
	export_constant2("EAJ_BABY_STAR_EMPEROR",MAPID_BABY_STAR_EMPEROR);

	export_constant2("EAJ_BABY_GUARD",MAPID_BABY_GUARD);
	export_constant2("EAJ_BABY_SORCERER",MAPID_BABY_SORCERER);
	export_constant2("EAJ_BABY_MINSTRELWANDERER",MAPID_BABY_MINSTRELWANDERER);
	export_constant2("EAJ_BABY_SURA",MAPID_BABY_SURA);
	export_constant2("EAJ_BABY_GENETIC",MAPID_BABY_GENETIC);
	export_constant2("EAJ_BABY_CHASER",MAPID_BABY_CHASER);
	export_constant2("EAJ_BABY_SOUL_REAPER",MAPID_BABY_SOUL_REAPER);

	export_constant2("EAJ_SUPER_NOVICE",MAPID_SUPER_NOVICE);
	export_constant2("EAJ_SUPER_BABY",MAPID_SUPER_BABY);
	export_constant2("EAJ_SUPER_NOVICE_E",MAPID_SUPER_NOVICE_E);
	export_constant2("EAJ_SUPER_BABY_E",MAPID_SUPER_BABY_E);

	export_constant2("EAJ_SUMMONER",MAPID_SUMMONER);

	/* sex */
	export_constant(SEX_FEMALE);
	export_constant(SEX_MALE);

	/* broadcasts */
	export_constant(BC_ALL);
	export_constant(BC_MAP);
	export_constant(BC_AREA);
	export_constant(BC_SELF);
	export_constant(BC_PC);
	export_constant(BC_NPC);
	export_constant(BC_YELLOW);
	export_constant(BC_BLUE);
	export_constant(BC_WOE);

	/* mapflags */
	export_constant(MF_NOMEMO);
	export_constant(MF_NOTELEPORT);
	export_constant(MF_NOSAVE);
	export_constant(MF_NOBRANCH);
	export_constant(MF_NOPENALTY);
	export_constant(MF_NOZENYPENALTY);
	export_constant(MF_PVP);
	export_constant(MF_PVP_NOPARTY);
	export_constant(MF_PVP_NOGUILD);
	export_constant(MF_GVG);
	export_constant(MF_GVG_NOPARTY);
	export_constant(MF_NOTRADE);
	export_constant(MF_NOSKILL);
	export_constant(MF_NOWARP);
	export_constant(MF_PARTYLOCK);
	export_constant(MF_NOICEWALL);
	export_constant(MF_SNOW);
	export_constant(MF_FOG);
	export_constant(MF_SAKURA);
	export_constant(MF_LEAVES);
	// Intentionally disabled mf_rain because Ind removed it source side
	//export_constant(MF_RAIN);
	export_constant(MF_NOGO);
	export_constant(MF_CLOUDS);
	export_constant(MF_CLOUDS2);
	export_constant(MF_FIREWORKS);
	export_constant(MF_GVG_CASTLE);
	export_constant(MF_GVG_DUNGEON);
	export_constant(MF_NIGHTENABLED);
	export_constant(MF_NOBASEEXP);
	export_constant(MF_NOJOBEXP);
	export_constant(MF_NOMOBLOOT);
	export_constant(MF_NOMVPLOOT);
	export_constant(MF_NORETURN);
	export_constant(MF_NOWARPTO);
	export_constant(MF_PVP_NIGHTMAREDROP);
	export_deprecated_constant3("mf_nightmaredrop", MF_PVP_NIGHTMAREDROP, "MF_PVP_NIGHTMAREDROP");
	export_constant(MF_RESTRICTED);
	export_constant(MF_NOCOMMAND);
	export_constant(MF_NODROP);
	export_constant(MF_JEXP);
	export_constant(MF_BEXP);
	export_constant(MF_NOVENDING);
	export_constant(MF_LOADEVENT);
	export_constant(MF_NOCHAT);
	export_constant(MF_NOEXPPENALTY);
	export_constant(MF_GUILDLOCK);
	export_constant(MF_TOWN);
	export_constant(MF_AUTOTRADE);
	export_constant(MF_ALLOWKS);
	export_constant(MF_MONSTER_NOTELEPORT);
	export_constant(MF_PVP_NOCALCRANK);
	export_constant(MF_BATTLEGROUND);
	export_constant(MF_RESET);
	export_constant(MF_NOMAPCHANNELAUTOJOIN);
	export_constant(MF_NOUSECART);
	export_constant(MF_NOITEMCONSUMPTION);
	export_constant(MF_NOSUNMOONSTARMIRACLE);
	export_deprecated_constant3("mf_sumstarmiracle", MF_NOSUNMOONSTARMIRACLE, "MF_NOSUNMOONSTARMIRACLE");
	export_constant(MF_NOMINEEFFECT);
	export_constant(MF_NOLOCKON);
	export_constant(MF_NOTOMB);
	export_constant(MF_SKILL_DAMAGE);
	export_constant(MF_NOCOSTUME);
	export_constant(MF_GVG_TE_CASTLE);
	export_constant(MF_GVG_TE);
	export_constant(MF_HIDEMOBHPBAR);
	export_constant(MF_NOLOOT);
	export_constant(MF_NOEXP);
	export_constant(MF_PRIVATEAIRSHIP_SOURCE);
	export_constant(MF_PRIVATEAIRSHIP_DESTINATION);
	export_constant(MF_SKILL_DURATION);

	/* setcell types */
	export_constant(CELL_WALKABLE);
	export_constant(CELL_SHOOTABLE);
	export_constant(CELL_WATER);
	export_constant(CELL_NPC);
	export_constant(CELL_BASILICA);
	export_constant(CELL_LANDPROTECTOR);
	export_constant(CELL_NOVENDING);
	export_constant(CELL_NOCHAT);
	export_constant(CELL_MAELSTROM);
	export_constant(CELL_ICEWALL);

	/* getcell types */
	export_constant(CELL_CHKWALL);
	export_constant(CELL_CHKWATER);
	export_constant(CELL_CHKCLIFF);
	export_constant(CELL_CHKPASS);
	export_constant(CELL_CHKREACH);
	export_constant(CELL_CHKNOPASS);
	export_constant(CELL_CHKNOREACH);
	// TODO: Check why this was commented until now
	//export_constant(CELL_CHKSTACK);
	export_constant(CELL_CHKNPC);
	export_constant(CELL_CHKBASILICA);
	export_constant(CELL_CHKLANDPROTECTOR);
	export_constant(CELL_CHKNOVENDING);
	export_constant(CELL_CHKNOCHAT);
	export_constant(CELL_CHKMAELSTROM);
	export_constant(CELL_CHKICEWALL);

	/* parameters */
	export_parameter("StatusPoint",SP_STATUSPOINT);
	export_parameter("BaseLevel",SP_BASELEVEL);
	export_parameter("SkillPoint",SP_SKILLPOINT);
	export_parameter("Class",SP_CLASS);
	export_parameter("Upper",SP_UPPER);
	export_parameter("Zeny",SP_ZENY);
	export_parameter("Sex",SP_SEX);
	export_parameter("Weight",SP_WEIGHT);
	export_parameter("MaxWeight",SP_MAXWEIGHT);
	export_parameter("JobLevel",SP_JOBLEVEL);
	export_parameter("BaseExp",SP_BASEEXP);
	export_parameter("JobExp",SP_JOBEXP);
	export_parameter("Karma",SP_KARMA);
	export_parameter("Manner",SP_MANNER);
	export_parameter("NextBaseExp",SP_NEXTBASEEXP);
	export_parameter("NextJobExp",SP_NEXTJOBEXP);
	export_parameter("Hp",SP_HP);
	export_parameter("MaxHp",SP_MAXHP);
	export_parameter("Sp",SP_SP);
	export_parameter("MaxSp",SP_MAXSP);
	export_parameter("BaseJob",SP_BASEJOB);
	export_parameter("BaseClass",SP_BASECLASS);
	export_parameter("killerrid",SP_KILLERRID);
	export_parameter("killedrid",SP_KILLEDRID);
	export_parameter("killedgid",SP_KILLEDGID);
	export_parameter("Sitting",SP_SITTING);
	export_parameter("CharMoves",SP_CHARMOVE);
	export_parameter("CharRename",SP_CHARRENAME);
	export_parameter("Font",SP_CHARFONT);
	export_parameter("BankVault",SP_BANK_VAULT);
	export_parameter(ROULETTE_BRONZE_VAR,SP_ROULETTE_BRONZE);
	export_parameter(ROULETTE_SILVER_VAR,SP_ROULETTE_SILVER);
	export_parameter(ROULETTE_GOLD_VAR,SP_ROULETTE_GOLD);
	export_parameter(CASHPOINT_VAR, SP_CASHPOINTS);
	export_parameter(KAFRAPOINT_VAR, SP_KAFRAPOINTS);
	export_parameter(PCDIECOUNTER_VAR, SP_PCDIECOUNTER);
	export_parameter(COOKMASTERY_VAR, SP_COOKMASTERY);

	export_constant2("bMaxHP",SP_MAXHP);
	export_constant2("bMaxSP",SP_MAXSP);
	export_constant2("bStr",SP_STR);
	export_constant2("bAgi",SP_AGI);
	export_constant2("bVit",SP_VIT);
	export_constant2("bInt",SP_INT);
	export_constant2("bDex",SP_DEX);
	export_constant2("bLuk",SP_LUK);
	export_constant2("bAtk",SP_ATK1);
	export_constant2("bAtk2",SP_ATK2);
	export_constant2("bDef",SP_DEF1);
	export_constant2("bDef2",SP_DEF2);
	export_constant2("bMdef",SP_MDEF1);
	export_constant2("bMdef2",SP_MDEF2);
	export_constant2("bHit",SP_HIT);
	export_constant2("bFlee",SP_FLEE1);
	export_constant2("bFlee2",SP_FLEE2);
	export_constant2("bCritical",SP_CRITICAL);
	export_constant2("bAspd",SP_ASPD);
	export_constant2("bFame",SP_FAME);
	export_constant2("bUnbreakable",SP_UNBREAKABLE);

	export_constant2("bAtkRange",SP_ATTACKRANGE);
	export_constant2("bAtkEle",SP_ATKELE);
	export_constant2("bDefEle",SP_DEFELE);
	export_constant2("bCastrate",SP_CASTRATE);
	export_constant2("bMaxHPrate",SP_MAXHPRATE);
	export_constant2("bMaxSPrate",SP_MAXSPRATE);
	export_constant2("bUseSPrate",SP_SPRATE);
	export_constant2("bAddEle",SP_ADDELE);
	export_constant2("bAddRace",SP_ADDRACE);
	export_constant2("bAddSize",SP_ADDSIZE);
	export_constant2("bSubEle",SP_SUBELE);
	export_constant2("bSubRace",SP_SUBRACE);
	export_constant2("bAddEff",SP_ADDEFF);
	export_constant2("bResEff",SP_RESEFF);
	export_constant2("bBaseAtk",SP_BASE_ATK);
	export_constant2("bAspdRate",SP_ASPD_RATE);
	export_constant2("bHPrecovRate",SP_HP_RECOV_RATE);
	export_constant2("bSPrecovRate",SP_SP_RECOV_RATE);
	export_constant2("bSpeedRate",SP_SPEED_RATE);
	export_constant2("bCriticalDef",SP_CRITICAL_DEF);
	export_constant2("bNearAtkDef",SP_NEAR_ATK_DEF);
	export_constant2("bLongAtkDef",SP_LONG_ATK_DEF);
	export_constant2("bDoubleRate",SP_DOUBLE_RATE);
	export_constant2("bDoubleAddRate",SP_DOUBLE_ADD_RATE);
	export_constant2("bSkillHeal",SP_SKILL_HEAL);
	export_constant2("bMatkRate",SP_MATK_RATE);
	export_constant2("bWeaponMatkRate",SP_WEAPON_MATK_RATE);
	export_constant2("bIgnoreDefEle",SP_IGNORE_DEF_ELE);
	export_constant2("bIgnoreDefRace",SP_IGNORE_DEF_RACE);
	export_constant2("bAtkRate",SP_ATK_RATE);
	export_constant2("bWeaponAtkRate",SP_WEAPON_ATK_RATE);
	export_constant2("bSpeedAddRate",SP_SPEED_ADDRATE);
	export_constant2("bSPRegenRate",SP_SP_REGEN_RATE);
	export_constant2("bMagicAtkDef",SP_MAGIC_ATK_DEF);
	export_constant2("bMiscAtkDef",SP_MISC_ATK_DEF);
	export_constant2("bIgnoreMdefEle",SP_IGNORE_MDEF_ELE);
	export_constant2("bIgnoreMdefRace",SP_IGNORE_MDEF_RACE);
	export_constant2("bMagicAddEle",SP_MAGIC_ADDELE);
	export_constant2("bMagicAddRace",SP_MAGIC_ADDRACE);
	export_constant2("bMagicAddSize",SP_MAGIC_ADDSIZE);
	export_constant2("bPerfectHitRate",SP_PERFECT_HIT_RATE);
	export_constant2("bPerfectHitAddRate",SP_PERFECT_HIT_ADD_RATE);
	export_constant2("bCriticalRate",SP_CRITICAL_RATE);
	export_constant2("bGetZenyNum",SP_GET_ZENY_NUM);
	export_constant2("bAddGetZenyNum",SP_ADD_GET_ZENY_NUM);
	export_constant2("bAddDamageClass",SP_ADD_DAMAGE_CLASS);
	export_constant2("bAddMagicDamageClass",SP_ADD_MAGIC_DAMAGE_CLASS);
	export_constant2("bAddDefMonster",SP_ADD_DEF_MONSTER);
	export_constant2("bAddMdefMonster",SP_ADD_MDEF_MONSTER);
	export_constant2("bAddMonsterDropItem",SP_ADD_MONSTER_DROP_ITEM);
	export_constant2("bDefRatioAtkEle",SP_DEF_RATIO_ATK_ELE);
	export_constant2("bDefRatioAtkRace",SP_DEF_RATIO_ATK_RACE);
	export_constant2("bUnbreakableGarment",SP_UNBREAKABLE_GARMENT);
	export_constant2("bHitRate",SP_HIT_RATE);
	export_constant2("bFleeRate",SP_FLEE_RATE);
	export_constant2("bFlee2Rate",SP_FLEE2_RATE);
	export_constant2("bDefRate",SP_DEF_RATE);
	export_constant2("bDef2Rate",SP_DEF2_RATE);
	export_constant2("bMdefRate",SP_MDEF_RATE);
	export_constant2("bMdef2Rate",SP_MDEF2_RATE);
	export_constant2("bSplashRange",SP_SPLASH_RANGE);
	export_constant2("bSplashAddRange",SP_SPLASH_ADD_RANGE);
	export_constant2("bAutoSpell",SP_AUTOSPELL);
	export_constant2("bHPDrainRate",SP_HP_DRAIN_RATE);
	export_constant2("bSPDrainRate",SP_SP_DRAIN_RATE);
	export_constant2("bShortWeaponDamageReturn",SP_SHORT_WEAPON_DAMAGE_RETURN);
	export_constant2("bLongWeaponDamageReturn",SP_LONG_WEAPON_DAMAGE_RETURN);
	export_constant2("bWeaponComaEle",SP_WEAPON_COMA_ELE);
	export_constant2("bWeaponComaRace",SP_WEAPON_COMA_RACE);
	export_constant2("bAddEff2",SP_ADDEFF2);
	export_constant2("bBreakWeaponRate",SP_BREAK_WEAPON_RATE);
	export_constant2("bBreakArmorRate",SP_BREAK_ARMOR_RATE);
	export_constant2("bAddStealRate",SP_ADD_STEAL_RATE);
	export_constant2("bMagicDamageReturn",SP_MAGIC_DAMAGE_RETURN);
	export_constant2("bAllStats",SP_ALL_STATS);
	export_constant2("bAgiVit",SP_AGI_VIT);
	export_constant2("bAgiDexStr",SP_AGI_DEX_STR);
	export_constant2("bPerfectHide",SP_PERFECT_HIDE);
	export_constant2("bNoKnockback",SP_NO_KNOCKBACK);
	export_constant2("bClassChange",SP_CLASSCHANGE);
	export_constant2("bHPDrainValue",SP_HP_DRAIN_VALUE);
	export_constant2("bSPDrainValue",SP_SP_DRAIN_VALUE);
	export_constant2("bWeaponAtk",SP_WEAPON_ATK);
	export_constant2("bWeaponDamageRate",SP_WEAPON_DAMAGE_RATE);
	export_constant2("bDelayrate",SP_DELAYRATE);
	export_constant2("bHPDrainValueRace",SP_HP_DRAIN_VALUE_RACE);
	export_constant2("bSPDrainValueRace",SP_SP_DRAIN_VALUE_RACE);
	export_constant2("bIgnoreMdefRaceRate",SP_IGNORE_MDEF_RACE_RATE);
	export_constant2("bIgnoreDefRaceRate",SP_IGNORE_DEF_RACE_RATE);
	export_constant2("bSkillHeal2",SP_SKILL_HEAL2);
	export_constant2("bAddEffOnSkill",SP_ADDEFF_ONSKILL);
	export_constant2("bHealPower",SP_ADD_HEAL_RATE);
	export_constant2("bHealPower2",SP_ADD_HEAL2_RATE);

	export_constant2("bRestartFullRecover",SP_RESTART_FULL_RECOVER);
	export_constant2("bNoCastCancel",SP_NO_CASTCANCEL);
	export_constant2("bNoSizeFix",SP_NO_SIZEFIX);
	export_constant2("bNoMagicDamage",SP_NO_MAGIC_DAMAGE);
	export_constant2("bNoWeaponDamage",SP_NO_WEAPON_DAMAGE);
	export_constant2("bNoGemStone",SP_NO_GEMSTONE);
	export_constant2("bNoCastCancel2",SP_NO_CASTCANCEL2);
	export_constant2("bNoMiscDamage",SP_NO_MISC_DAMAGE);
	export_constant2("bUnbreakableWeapon",SP_UNBREAKABLE_WEAPON);
	export_constant2("bUnbreakableArmor",SP_UNBREAKABLE_ARMOR);
	export_constant2("bUnbreakableHelm",SP_UNBREAKABLE_HELM);
	export_constant2("bUnbreakableShield",SP_UNBREAKABLE_SHIELD);
	export_constant2("bLongAtkRate",SP_LONG_ATK_RATE);
	export_constant2("bCritAtkRate",SP_CRIT_ATK_RATE);
	export_constant2("bCriticalAddRace",SP_CRITICAL_ADDRACE);
	export_constant2("bNoRegen",SP_NO_REGEN);
	export_constant2("bAddEffWhenHit",SP_ADDEFF_WHENHIT);
	export_constant2("bAutoSpellWhenHit",SP_AUTOSPELL_WHENHIT);
	export_constant2("bSkillAtk",SP_SKILL_ATK);
	export_constant2("bUnstripable",SP_UNSTRIPABLE);
	export_constant2("bAutoSpellOnSkill",SP_AUTOSPELL_ONSKILL);
	export_constant2("bSPGainValue",SP_SP_GAIN_VALUE);
	export_constant2("bHPRegenRate",SP_HP_REGEN_RATE);
	export_constant2("bHPLossRate",SP_HP_LOSS_RATE);
	export_constant2("bAddRace2",SP_ADDRACE2);
	export_constant2("bHPGainValue",SP_HP_GAIN_VALUE);
	export_constant2("bSubSize",SP_SUBSIZE);
	export_constant2("bHPDrainValueClass",SP_HP_DRAIN_VALUE_CLASS);
	export_constant2("bAddItemHealRate",SP_ADD_ITEM_HEAL_RATE);
	export_constant2("bSPDrainValueClass",SP_SP_DRAIN_VALUE_CLASS);
	export_constant2("bExpAddRace",SP_EXP_ADDRACE);
	export_constant2("bSPGainRace",SP_SP_GAIN_RACE);
	export_constant2("bSubRace2",SP_SUBRACE2);
	export_constant2("bUnbreakableShoes",SP_UNBREAKABLE_SHOES);
	export_constant2("bUnstripableWeapon",SP_UNSTRIPABLE_WEAPON);
	export_constant2("bUnstripableArmor",SP_UNSTRIPABLE_ARMOR);
	export_constant2("bUnstripableHelm",SP_UNSTRIPABLE_HELM);
	export_constant2("bUnstripableShield",SP_UNSTRIPABLE_SHIELD);
	export_constant2("bIntravision",SP_INTRAVISION);
	export_constant2("bAddMonsterDropItemGroup",SP_ADD_MONSTER_DROP_ITEMGROUP);
	export_constant2("bSPLossRate",SP_SP_LOSS_RATE);
	export_constant2("bAddSkillBlow",SP_ADD_SKILL_BLOW);
	export_constant2("bSPVanishRate",SP_SP_VANISH_RATE);
	export_constant2("bMagicSPGainValue",SP_MAGIC_SP_GAIN_VALUE);
	export_constant2("bMagicHPGainValue",SP_MAGIC_HP_GAIN_VALUE);
	export_constant2("bAddMonsterIdDropItem",SP_ADD_MONSTER_ID_DROP_ITEM);
	export_constant2("bMatk",SP_EMATK);
	export_constant2("bComaClass",SP_COMA_CLASS);
	export_constant2("bComaRace",SP_COMA_RACE);
	export_constant2("bSkillUseSPrate",SP_SKILL_USE_SP_RATE);
	export_constant2("bSkillCooldown",SP_SKILL_COOLDOWN);
	export_constant2("bSkillFixedCast",SP_SKILL_FIXEDCAST);
	export_constant2("bSkillVariableCast",SP_SKILL_VARIABLECAST);
	export_constant2("bFixedCastrate",SP_FIXCASTRATE);
	export_constant2("bVariableCastrate",SP_VARCASTRATE);
	export_constant2("bSkillUseSP",SP_SKILL_USE_SP);
	export_constant2("bMagicAtkEle",SP_MAGIC_ATK_ELE);
	export_constant2("bFixedCast",SP_ADD_FIXEDCAST);
	export_constant2("bVariableCast",SP_ADD_VARIABLECAST);
	export_constant2("bSetDefRace",SP_SET_DEF_RACE);
	export_constant2("bSetMDefRace",SP_SET_MDEF_RACE);
	export_constant2("bHPVanishRate",SP_HP_VANISH_RATE);
	export_constant2("bIgnoreDefClass",SP_IGNORE_DEF_CLASS);
	export_constant2("bDefRatioAtkClass",SP_DEF_RATIO_ATK_CLASS);
	export_constant2("bAddClass",SP_ADDCLASS);
	export_constant2("bSubClass",SP_SUBCLASS);
	export_constant2("bMagicAddClass",SP_MAGIC_ADDCLASS);
	export_constant2("bWeaponComaClass",SP_WEAPON_COMA_CLASS);
	export_constant2("bIgnoreMdefClassRate",SP_IGNORE_MDEF_CLASS_RATE);
	export_constant2("bExpAddClass",SP_EXP_ADDCLASS);
	export_constant2("bAddClassDropItem",SP_ADD_CLASS_DROP_ITEM);
	export_constant2("bAddClassDropItemGroup",SP_ADD_CLASS_DROP_ITEMGROUP);
	export_constant2("bAddMaxWeight",SP_ADDMAXWEIGHT);
	export_constant2("bAddItemGroupHealRate",SP_ADD_ITEMGROUP_HEAL_RATE);
	export_constant2("bHPVanishRaceRate",SP_HP_VANISH_RACE_RATE);
	export_constant2("bSPVanishRaceRate",SP_SP_VANISH_RACE_RATE);
	export_constant2("bAbsorbDmgMaxHP",SP_ABSORB_DMG_MAXHP);
	export_constant2("bSubSkill",SP_SUB_SKILL);
	export_constant2("bSubDefEle",SP_SUBDEF_ELE);
	export_constant2("bStateNoRecoverRace",SP_STATE_NORECOVER_RACE);
	export_constant2("bCriticalLong",SP_CRITICAL_RANGEATK);
	export_constant2("bMagicAddRace2", SP_MAGIC_ADDRACE2);
	export_constant2("bIgnoreMdefRace2Rate", SP_IGNORE_MDEF_RACE2_RATE);
	export_constant2("bDropAddRace", SP_DROP_ADDRACE);
	export_constant2("bDropAddClass", SP_DROP_ADDCLASS);
	export_constant2("bNoMadoFuel", SP_NO_MADO_FUEL);
	export_constant2("bIgnoreDefClassRate", SP_IGNORE_DEF_CLASS_RATE);
	export_constant2("bRegenPercentHP", SP_REGEN_PERCENT_HP);
	export_constant2("bRegenPercentSP", SP_REGEN_PERCENT_SP);
	export_constant2("bSkillDelay",SP_SKILL_DELAY);
	export_constant2("bNoWalkDelay",SP_NO_WALK_DELAY);
	export_constant2("bLongSPGainValue",SP_LONG_SP_GAIN_VALUE);
	export_constant2("bLongHPGainValue",SP_LONG_HP_GAIN_VALUE);

	/* equip indices */
	export_constant(EQI_COMPOUND_ON);
	export_constant(EQI_HEAD_TOP);
	export_constant(EQI_ARMOR);
	export_constant(EQI_HAND_L);
	export_constant(EQI_HAND_R);
	export_constant(EQI_GARMENT);
	export_constant(EQI_SHOES);
	export_constant(EQI_ACC_L);
	export_constant(EQI_ACC_R);
	export_constant(EQI_HEAD_MID);
	export_constant(EQI_HEAD_LOW);
	export_constant(EQI_COSTUME_HEAD_LOW);
	export_constant(EQI_COSTUME_HEAD_MID);
	export_constant(EQI_COSTUME_HEAD_TOP);
	export_constant(EQI_COSTUME_GARMENT);
	export_constant(EQI_AMMO);
	export_constant(EQI_SHADOW_ARMOR );
	export_constant(EQI_SHADOW_WEAPON);
	export_constant(EQI_SHADOW_SHIELD);
	export_constant(EQI_SHADOW_SHOES);
	export_constant(EQI_SHADOW_ACC_R);
	export_constant(EQI_SHADOW_ACC_L);
	export_constant(EQI_MAX);

	/* equip positions */
	export_constant(EQP_ACC_L);
	export_constant(EQP_ACC_R);
	export_constant(EQP_SHOES);
	export_constant(EQP_GARMENT);
	export_constant(EQP_HEAD_LOW);
	export_constant(EQP_HEAD_MID);
	export_constant(EQP_HEAD_TOP);
	export_constant(EQP_ARMOR);
	export_constant(EQP_HAND_L);
	export_constant(EQP_HAND_R);
	export_constant(EQP_COSTUME_HEAD_TOP);
	export_constant(EQP_COSTUME_HEAD_MID);
	export_constant(EQP_COSTUME_HEAD_LOW);
	export_constant(EQP_COSTUME_GARMENT);
	export_constant(EQP_AMMO);
	export_constant(EQP_SHADOW_ARMOR);
	export_constant(EQP_SHADOW_WEAPON);
	export_constant(EQP_SHADOW_SHIELD);
	export_constant(EQP_SHADOW_SHOES);
	export_constant(EQP_SHADOW_ACC_R);
	export_constant(EQP_SHADOW_ACC_L);
	export_constant(EQP_ACC_RL);
	export_constant(EQP_SHADOW_ACC_RL);

	/* looks */
	export_constant(LOOK_BASE);
	export_constant(LOOK_HAIR);
	export_constant(LOOK_WEAPON);
	export_constant(LOOK_HEAD_BOTTOM);
	export_constant(LOOK_HEAD_TOP);
	export_constant(LOOK_HEAD_MID);
	export_constant(LOOK_HAIR_COLOR);
	export_constant(LOOK_CLOTHES_COLOR);
	export_constant(LOOK_SHIELD);
	export_constant(LOOK_SHOES);
	export_constant(LOOK_BODY);
	export_constant(LOOK_RESET_COSTUMES);
	export_constant(LOOK_ROBE);
	export_constant(LOOK_BODY2);
	// TODO: check why we didnt have floor and enable it
	//export_constant(LOOK_FLOOR);

	// For backwards compatability - might be removed in the near future
	export_constant2("VAR_HEAD",LOOK_HAIR);
	export_constant2("VAR_WEAPON",LOOK_WEAPON);
	export_constant2("VAR_HEAD_TOP",LOOK_HEAD_TOP); // This one was actually pointing to LOOK_HEAD_BOTTOM until now, so we might be safe to remove them anyway(since we got no bug report until today)
	export_constant2("VAR_HEAD_MID",LOOK_HEAD_MID); // This one was actually pointing to LOOK_HEAD_TOP until now, so we might be safe to remove them anyway(since we got no bug report until today)
	export_constant2("VAR_HEAD_BOTTOM",LOOK_HEAD_BOTTOM);  // This one was actually pointing to LOOK_HEAD_MID until now, so we might be safe to remove them anyway(since we got no bug report until today)
	export_constant2("VAR_HEADPALETTE",LOOK_HAIR_COLOR);
	export_constant2("VAR_BODYPALETTE",LOOK_CLOTHES_COLOR);
	export_constant2("VAR_SHIELD",LOOK_SHIELD);
	export_constant2("VAR_SHOES",LOOK_SHOES);

	/* status changes */
	export_constant2("Eff_Stone",SC_STONE);
	export_constant2("Eff_Freeze",SC_FREEZE);
	export_constant2("Eff_Stun",SC_STUN);
	export_constant2("Eff_Sleep",SC_SLEEP);
	export_constant2("Eff_Poison",SC_POISON);
	export_constant2("Eff_Curse",SC_CURSE);
	export_constant2("Eff_Silence",SC_SILENCE);
	export_constant2("Eff_Confusion",SC_CONFUSION);
	export_constant2("Eff_Blind",SC_BLIND);
	export_constant2("Eff_Bleeding",SC_BLEEDING);
	export_constant2("Eff_DPoison",SC_DPOISON);
	export_constant2("Eff_Fear",SC_FEAR);
	export_constant2("Eff_Burning",SC_BURNING);
	export_constant2("Eff_Crystalize",SC_CRYSTALIZE);

	export_constant2("SC_ALL",SC_NONE);

	export_constant(SC_NONE);
	export_constant(SC_STONE);
	export_constant(SC_FREEZE);
	export_constant(SC_STUN);
	export_constant(SC_SLEEP);
	export_constant(SC_POISON);
	export_constant(SC_CURSE);
	export_constant(SC_SILENCE);
	export_constant(SC_CONFUSION);
	export_constant(SC_BLIND);
	export_constant(SC_BLEEDING);
	export_constant(SC_DPOISON);
	export_constant(SC_PROVOKE);
	export_constant(SC_ENDURE);
	export_constant(SC_TWOHANDQUICKEN);
	export_constant(SC_CONCENTRATE);
	export_constant(SC_HIDING);
	export_constant(SC_CLOAKING);
	export_constant(SC_ENCPOISON);
	export_constant(SC_POISONREACT);
	export_constant(SC_QUAGMIRE);
	export_constant(SC_ANGELUS);
	export_constant(SC_BLESSING);
	export_constant(SC_SIGNUMCRUCIS);
	export_constant(SC_INCREASEAGI);
	export_constant(SC_DECREASEAGI);
	export_constant(SC_SLOWPOISON);
	export_constant(SC_IMPOSITIO);
	export_constant(SC_SUFFRAGIUM);
	export_constant(SC_ASPERSIO);
	export_constant(SC_BENEDICTIO);
	export_constant(SC_KYRIE);
	export_constant(SC_MAGNIFICAT);
	export_constant(SC_GLORIA);
	export_constant(SC_AETERNA);
	export_constant(SC_ADRENALINE);
	export_constant(SC_WEAPONPERFECTION);
	export_constant(SC_OVERTHRUST);
	export_constant(SC_MAXIMIZEPOWER);
	export_constant(SC_TRICKDEAD);
	export_constant(SC_LOUD);
	export_constant(SC_ENERGYCOAT);
	export_constant(SC_BROKENARMOR);
	export_constant(SC_BROKENWEAPON);
	export_constant(SC_HALLUCINATION);
	export_constant(SC_WEIGHT50);
	export_constant(SC_WEIGHT90);
	export_constant(SC_ASPDPOTION0);
	export_constant(SC_ASPDPOTION1);
	export_constant(SC_ASPDPOTION2);
	export_constant(SC_ASPDPOTION3);
	export_constant(SC_SPEEDUP0);
	export_constant(SC_SPEEDUP1);
	export_constant(SC_ATKPOTION);
	export_constant(SC_MATKPOTION);
	export_constant(SC_WEDDING);
	export_constant(SC_SLOWDOWN);
	export_constant(SC_ANKLE);
	export_constant(SC_KEEPING);
	export_constant(SC_BARRIER);
	export_constant(SC_STRIPWEAPON);
	export_constant(SC_STRIPSHIELD);
	export_constant(SC_STRIPARMOR);
	export_constant(SC_STRIPHELM);
	export_constant(SC_CP_WEAPON);
	export_constant(SC_CP_SHIELD);
	export_constant(SC_CP_ARMOR);
	export_constant(SC_CP_HELM);
	export_constant(SC_AUTOGUARD);
	export_constant(SC_REFLECTSHIELD);
	export_constant(SC_SPLASHER);
	export_constant(SC_PROVIDENCE);
	export_constant(SC_DEFENDER);
	export_constant(SC_MAGICROD);
	export_constant(SC_SPELLBREAKER);
	export_constant(SC_AUTOSPELL);
	export_constant(SC_SIGHTTRASHER);
	export_constant(SC_AUTOBERSERK);
	export_constant(SC_SPEARQUICKEN);
	export_constant(SC_AUTOCOUNTER);
	export_constant(SC_SIGHT);
	export_constant(SC_SAFETYWALL);
	export_constant(SC_RUWACH);
	export_constant(SC_EXTREMITYFIST);
	export_constant(SC_EXPLOSIONSPIRITS);
	export_constant(SC_COMBO);
	export_constant(SC_BLADESTOP_WAIT);
	export_constant(SC_BLADESTOP);
	export_constant(SC_FIREWEAPON);
	export_constant(SC_WATERWEAPON);
	export_constant(SC_WINDWEAPON);
	export_constant(SC_EARTHWEAPON);
	export_constant(SC_VOLCANO);
	export_constant(SC_DELUGE);
	export_constant(SC_VIOLENTGALE);
	export_constant(SC_WATK_ELEMENT);
	export_constant(SC_ARMOR);
	export_constant(SC_ARMOR_ELEMENT_WATER);
	export_constant(SC_NOCHAT);
	export_constant(SC_BABY);
	export_constant(SC_AURABLADE);
	export_constant(SC_PARRYING);
	export_constant(SC_CONCENTRATION);
	export_constant(SC_TENSIONRELAX);
	export_constant(SC_BERSERK);
	export_constant(SC_FURY);
	export_constant(SC_GOSPEL);
	export_constant(SC_ASSUMPTIO);
	export_constant(SC_BASILICA);
	export_constant(SC_GUILDAURA);
	export_constant(SC_MAGICPOWER);
	export_constant(SC_EDP);
	export_constant(SC_TRUESIGHT);
	export_constant(SC_WINDWALK);
	export_constant(SC_MELTDOWN);
	export_constant(SC_CARTBOOST);
	export_constant(SC_CHASEWALK);
	export_constant(SC_REJECTSWORD);
	export_constant(SC_MARIONETTE);
	export_constant(SC_MARIONETTE2);
	export_constant(SC_CHANGEUNDEAD);
	export_constant(SC_JOINTBEAT);
	export_constant(SC_MINDBREAKER);
	export_constant(SC_MEMORIZE);
	export_constant(SC_FOGWALL);
	export_constant(SC_SPIDERWEB);
	export_constant(SC_DEVOTION);
	export_constant(SC_SACRIFICE);
	export_constant(SC_STEELBODY);
	export_constant(SC_ORCISH);
	export_constant(SC_READYSTORM);
	export_constant(SC_READYDOWN);
	export_constant(SC_READYTURN);
	export_constant(SC_READYCOUNTER);
	export_constant(SC_DODGE);
	export_constant(SC_RUN);
	export_constant(SC_SHADOWWEAPON);
	export_constant(SC_ADRENALINE2);
	export_constant(SC_GHOSTWEAPON);
	export_constant(SC_KAIZEL);
	export_constant(SC_KAAHI);
	export_constant(SC_KAUPE);
	export_constant(SC_ONEHAND);
	export_constant(SC_PRESERVE);
	export_constant(SC_BATTLEORDERS);
	export_constant(SC_REGENERATION);
	export_constant(SC_DOUBLECAST);
	export_constant(SC_GRAVITATION);
	export_constant(SC_MAXOVERTHRUST);
	export_constant(SC_LONGING);
	export_constant(SC_HERMODE);
	export_constant(SC_SHRINK);
	export_constant(SC_SIGHTBLASTER);
	export_constant(SC_WINKCHARM);
	export_constant(SC_CLOSECONFINE);
	export_constant(SC_CLOSECONFINE2);
	export_constant(SC_DANCING);
	export_constant(SC_ELEMENTALCHANGE);
	export_constant(SC_RICHMANKIM);
	export_constant(SC_ETERNALCHAOS);
	export_constant(SC_DRUMBATTLE);
	export_constant(SC_NIBELUNGEN);
	export_constant(SC_ROKISWEIL);
	export_constant(SC_INTOABYSS);
	export_constant(SC_SIEGFRIED);
	export_constant(SC_WHISTLE);
	export_constant(SC_ASSNCROS);
	export_constant(SC_POEMBRAGI);
	export_constant(SC_APPLEIDUN);
	export_constant(SC_MODECHANGE);
	export_constant(SC_HUMMING);
	export_constant(SC_DONTFORGETME);
	export_constant(SC_FORTUNE);
	export_constant(SC_SERVICE4U);
	export_constant(SC_STOP);
	export_constant(SC_SPURT);
	export_constant(SC_SPIRIT);
	export_constant(SC_COMA);
	export_constant(SC_INTRAVISION);
	export_constant(SC_INCALLSTATUS);
	export_constant(SC_INCSTR);
	export_constant(SC_INCAGI);
	export_constant(SC_INCVIT);
	export_constant(SC_INCINT);
	export_constant(SC_INCDEX);
	export_constant(SC_INCLUK);
	export_constant(SC_INCHIT);
	export_constant(SC_INCHITRATE);
	export_constant(SC_INCFLEE);
	export_constant(SC_INCFLEERATE);
	export_constant(SC_INCMHPRATE);
	export_constant(SC_INCMSPRATE);
	export_constant(SC_INCATKRATE);
	export_constant(SC_INCMATKRATE);
	export_constant(SC_INCDEFRATE);
	export_constant(SC_STRFOOD);
	export_constant(SC_AGIFOOD);
	export_constant(SC_VITFOOD);
	export_constant(SC_INTFOOD);
	export_constant(SC_DEXFOOD);
	export_constant(SC_LUKFOOD);
	export_constant(SC_HITFOOD);
	export_constant(SC_FLEEFOOD);
	export_constant(SC_BATKFOOD);
	export_constant(SC_WATKFOOD);
	export_constant(SC_MATKFOOD);
	export_constant(SC_SCRESIST);
	export_constant(SC_XMAS);
	export_constant(SC_WARM);
	export_constant(SC_SUN_COMFORT);
	export_constant(SC_MOON_COMFORT);
	export_constant(SC_STAR_COMFORT);
	export_constant(SC_FUSION);
	export_constant(SC_SKILLRATE_UP);
	export_constant(SC_SKE);
	export_constant(SC_KAITE);
	export_constant(SC_SWOO);
	export_constant(SC_SKA);
	export_constant(SC_EARTHSCROLL);
	export_constant(SC_MIRACLE);
	export_constant(SC_MADNESSCANCEL);
	export_constant(SC_ADJUSTMENT);
	export_constant(SC_INCREASING);
	export_constant(SC_GATLINGFEVER);
	export_constant(SC_TATAMIGAESHI);
	export_constant(SC_UTSUSEMI);
	export_constant(SC_BUNSINJYUTSU);
	export_constant(SC_KAENSIN);
	export_constant(SC_SUITON);
	export_constant(SC_NEN);
	export_constant(SC_KNOWLEDGE);
	export_constant(SC_SMA);
	export_constant(SC_FLING);
	export_constant(SC_AVOID);
	export_constant(SC_CHANGE);
	export_constant(SC_BLOODLUST);
	export_constant(SC_FLEET);
	export_constant(SC_SPEED);
	export_constant(SC_DEFENCE);
	export_constant(SC_INCASPDRATE);
	export_constant(SC_INCFLEE2);
	export_constant(SC_JAILED);
	export_constant(SC_ENCHANTARMS);
	export_constant(SC_MAGICALATTACK);
	export_constant(SC_ARMORCHANGE);
	export_constant(SC_CRITICALWOUND);
	export_constant(SC_MAGICMIRROR);
	export_constant(SC_SLOWCAST);
	export_constant(SC_SUMMER);
	export_constant(SC_EXPBOOST);
	export_constant(SC_ITEMBOOST);
	export_constant(SC_BOSSMAPINFO);
	export_constant(SC_LIFEINSURANCE);
	export_constant(SC_INCCRI);
	//export_constant(SC_INCDEF);
	//export_constant(SC_INCBASEATK);
	//export_constant(SC_FASTCAST);
	export_constant(SC_MDEF_RATE);
	//export_constant(SC_HPREGEN);
	export_constant(SC_INCHEALRATE);
	export_constant(SC_PNEUMA);
	export_constant(SC_AUTOTRADE);
	export_constant(SC_KSPROTECTED);
	export_constant(SC_ARMOR_RESIST);
	export_constant(SC_SPCOST_RATE);
	export_constant(SC_COMMONSC_RESIST);
	export_constant(SC_SEVENWIND);
	export_constant(SC_DEF_RATE);
	//export_constant(SC_SPREGEN);
	export_constant(SC_WALKSPEED);
	export_constant(SC_MERC_FLEEUP);
	export_constant(SC_MERC_ATKUP);
	export_constant(SC_MERC_HPUP);
	export_constant(SC_MERC_SPUP);
	export_constant(SC_MERC_HITUP);
	export_constant(SC_MERC_QUICKEN);
	export_constant(SC_REBIRTH);
	//export_constant(SC_SKILLCASTRATE);
	//export_constant(SC_DEFRATIOATK);
	//export_constant(SC_HPDRAIN);
	//export_constant(SC_SKILLATKBONUS);
	export_constant(SC_ITEMSCRIPT);
	export_constant(SC_S_LIFEPOTION);
	export_constant(SC_L_LIFEPOTION);
	export_constant(SC_JEXPBOOST);
	//export_constant(SC_IGNOREDEF);
	export_constant(SC_HELLPOWER);
	export_constant(SC_INVINCIBLE);
	export_constant(SC_INVINCIBLEOFF);
	export_constant(SC_MANU_ATK);
	export_constant(SC_MANU_DEF);
	export_constant(SC_SPL_ATK);
	export_constant(SC_SPL_DEF);
	export_constant(SC_MANU_MATK);
	export_constant(SC_SPL_MATK);
	export_constant(SC_FOOD_STR_CASH);
	export_constant(SC_FOOD_AGI_CASH);
	export_constant(SC_FOOD_VIT_CASH);
	export_constant(SC_FOOD_DEX_CASH);
	export_constant(SC_FOOD_INT_CASH);
	export_constant(SC_FOOD_LUK_CASH);
	export_constant(SC_FEAR);
	export_constant(SC_BURNING);
	export_constant(SC_FREEZING);
	export_constant(SC_ENCHANTBLADE);
	export_constant(SC_DEATHBOUND);
	export_constant(SC_MILLENNIUMSHIELD);
	export_constant(SC_CRUSHSTRIKE);
	export_constant(SC_REFRESH);
	export_constant(SC_REUSE_REFRESH);
	export_constant(SC_GIANTGROWTH);
	export_constant(SC_STONEHARDSKIN);
	export_constant(SC_VITALITYACTIVATION);
	export_constant(SC_STORMBLAST);
	export_constant(SC_FIGHTINGSPIRIT);
	export_constant(SC_ABUNDANCE);
	export_constant(SC_ADORAMUS);
	export_constant(SC_EPICLESIS);
	export_constant(SC_ORATIO);
	export_constant(SC_LAUDAAGNUS);
	export_constant(SC_LAUDARAMUS);
	export_constant(SC_RENOVATIO);
	export_constant(SC_EXPIATIO);
	export_constant(SC_DUPLELIGHT);
	export_constant(SC_SECRAMENT);
	export_constant(SC_WHITEIMPRISON);
	export_constant(SC_MARSHOFABYSS);
	export_constant(SC_RECOGNIZEDSPELL);
	export_constant(SC_STASIS);
	export_constant(SC_SPHERE_1);
	export_constant(SC_SPHERE_2);
	export_constant(SC_SPHERE_3);
	export_constant(SC_SPHERE_4);
	export_constant(SC_SPHERE_5);
	export_constant(SC_READING_SB);
	export_constant(SC_FREEZE_SP);
	export_constant(SC_FEARBREEZE);
	export_constant(SC_ELECTRICSHOCKER);
	export_constant(SC_WUGDASH);
	export_constant(SC_BITE);
	export_constant(SC_CAMOUFLAGE);
	export_constant(SC_ACCELERATION);
	export_constant(SC_HOVERING);
	export_constant(SC_SHAPESHIFT);
	export_constant(SC_INFRAREDSCAN);
	export_constant(SC_ANALYZE);
	export_constant(SC_MAGNETICFIELD);
	export_constant(SC_NEUTRALBARRIER);
	export_constant(SC_NEUTRALBARRIER_MASTER);
	export_constant(SC_STEALTHFIELD);
	export_constant(SC_STEALTHFIELD_MASTER);
	export_constant(SC_OVERHEAT);
	export_constant(SC_OVERHEAT_LIMITPOINT);
	export_constant(SC_VENOMIMPRESS);
	export_constant(SC_POISONINGWEAPON);
	export_constant(SC_WEAPONBLOCKING);
	export_constant(SC_CLOAKINGEXCEED);
	export_constant(SC_HALLUCINATIONWALK);
	export_constant(SC_HALLUCINATIONWALK_POSTDELAY);
	export_constant(SC_ROLLINGCUTTER);
	export_constant(SC_TOXIN);
	export_constant(SC_PARALYSE);
	export_constant(SC_VENOMBLEED);
	export_constant(SC_MAGICMUSHROOM);
	export_constant(SC_DEATHHURT);
	export_constant(SC_PYREXIA);
	export_constant(SC_OBLIVIONCURSE);
	export_constant(SC_LEECHESEND);
	export_constant(SC_REFLECTDAMAGE);
	export_constant(SC_FORCEOFVANGUARD);
	export_constant(SC_SHIELDSPELL_DEF);
	export_constant(SC_SHIELDSPELL_MDEF);
	export_constant(SC_SHIELDSPELL_REF);
	export_constant(SC_EXEEDBREAK);
	export_constant(SC_PRESTIGE);
	export_constant(SC_BANDING);
	export_constant(SC_BANDING_DEFENCE);
	export_constant(SC_EARTHDRIVE);
	export_constant(SC_INSPIRATION);
	export_constant(SC_SPELLFIST);
	export_constant(SC_CRYSTALIZE);
	export_constant(SC_STRIKING);
	export_constant(SC_WARMER);
	export_constant(SC_VACUUM_EXTREME);
	export_constant(SC_PROPERTYWALK);
	export_constant(SC_SWINGDANCE);
	export_constant(SC_SYMPHONYOFLOVER);
	export_constant(SC_MOONLITSERENADE);
	export_constant(SC_RUSHWINDMILL);
	export_constant(SC_ECHOSONG);
	export_constant(SC_HARMONIZE);
	export_constant(SC_VOICEOFSIREN);
	export_constant(SC_DEEPSLEEP);
	export_constant(SC_SIRCLEOFNATURE);
	export_constant(SC_GLOOMYDAY);
	export_constant(SC_GLOOMYDAY_SK);
	export_constant(SC_SONGOFMANA);
	export_constant(SC_DANCEWITHWUG);
	export_constant(SC_SATURDAYNIGHTFEVER);
	export_constant(SC_LERADSDEW);
	export_constant(SC_MELODYOFSINK);
	export_constant(SC_BEYONDOFWARCRY);
	export_constant(SC_UNLIMITEDHUMMINGVOICE);
	export_constant(SC_SITDOWN_FORCE);
	export_constant(SC_NETHERWORLD);
	export_constant(SC_CRESCENTELBOW);
	export_constant(SC_CURSEDCIRCLE_ATKER);
	export_constant(SC_CURSEDCIRCLE_TARGET);
	export_constant(SC_LIGHTNINGWALK);
	export_constant(SC_RAISINGDRAGON);
	export_constant(SC_GT_ENERGYGAIN);
	export_constant(SC_GT_CHANGE);
	export_constant(SC_GT_REVITALIZE);
	export_constant(SC_GN_CARTBOOST);
	export_constant(SC_THORNSTRAP);
	export_constant(SC_BLOODSUCKER);
	export_constant(SC_SMOKEPOWDER);
	export_constant(SC_TEARGAS);
	export_constant(SC_MANDRAGORA);
	export_constant(SC_STOMACHACHE);
	export_constant(SC_MYSTERIOUS_POWDER);
	export_constant(SC_MELON_BOMB);
	export_constant(SC_BANANA_BOMB);
	export_constant(SC_BANANA_BOMB_SITDOWN);
	export_constant(SC_SAVAGE_STEAK);
	export_constant(SC_COCKTAIL_WARG_BLOOD);
	export_constant(SC_MINOR_BBQ);
	export_constant(SC_SIROMA_ICE_TEA);
	export_constant(SC_DROCERA_HERB_STEAMED);
	export_constant(SC_PUTTI_TAILS_NOODLES);
	export_constant(SC_BOOST500);
	export_constant(SC_FULL_SWING_K);
	export_constant(SC_MANA_PLUS);
	export_constant(SC_MUSTLE_M);
	export_constant(SC_LIFE_FORCE_F);
	export_constant(SC_EXTRACT_WHITE_POTION_Z);
	export_constant(SC_VITATA_500);
	export_constant(SC_EXTRACT_SALAMINE_JUICE);
	export_constant(SC__REPRODUCE);
	export_constant(SC__AUTOSHADOWSPELL);
	export_constant(SC__SHADOWFORM);
	export_constant(SC__BODYPAINT);
	export_constant(SC__INVISIBILITY);
	export_constant(SC__DEADLYINFECT);
	export_constant(SC__ENERVATION);
	export_constant(SC__GROOMY);
	export_constant(SC__IGNORANCE);
	export_constant(SC__LAZINESS);
	export_constant(SC__UNLUCKY);
	export_constant(SC__WEAKNESS);
	export_constant(SC__STRIPACCESSORY);
	export_constant(SC__MANHOLE);
	export_constant(SC__BLOODYLUST);
	export_constant(SC_CIRCLE_OF_FIRE);
	export_constant(SC_CIRCLE_OF_FIRE_OPTION);
	export_constant(SC_FIRE_CLOAK);
	export_constant(SC_FIRE_CLOAK_OPTION);
	export_constant(SC_WATER_SCREEN);
	export_constant(SC_WATER_SCREEN_OPTION);
	export_constant(SC_WATER_DROP);
	export_constant(SC_WATER_DROP_OPTION);
	export_constant(SC_WATER_BARRIER);
	export_constant(SC_WIND_STEP);
	export_constant(SC_WIND_STEP_OPTION);
	export_constant(SC_WIND_CURTAIN);
	export_constant(SC_WIND_CURTAIN_OPTION);
	export_constant(SC_ZEPHYR);
	export_constant(SC_SOLID_SKIN);
	export_constant(SC_SOLID_SKIN_OPTION);
	export_constant(SC_STONE_SHIELD);
	export_constant(SC_STONE_SHIELD_OPTION);
	export_constant(SC_POWER_OF_GAIA);
	export_constant(SC_PYROTECHNIC);
	export_constant(SC_PYROTECHNIC_OPTION);
	export_constant(SC_HEATER);
	export_constant(SC_HEATER_OPTION);
	export_constant(SC_TROPIC);
	export_constant(SC_TROPIC_OPTION);
	export_constant(SC_AQUAPLAY);
	export_constant(SC_AQUAPLAY_OPTION);
	export_constant(SC_COOLER);
	export_constant(SC_COOLER_OPTION);
	export_constant(SC_CHILLY_AIR);
	export_constant(SC_CHILLY_AIR_OPTION);
	export_constant(SC_GUST);
	export_constant(SC_GUST_OPTION);
	export_constant(SC_BLAST);
	export_constant(SC_BLAST_OPTION);
	export_constant(SC_WILD_STORM);
	export_constant(SC_WILD_STORM_OPTION);
	export_constant(SC_PETROLOGY);
	export_constant(SC_PETROLOGY_OPTION);
	export_constant(SC_CURSED_SOIL);
	export_constant(SC_CURSED_SOIL_OPTION);
	export_constant(SC_UPHEAVAL);
	export_constant(SC_UPHEAVAL_OPTION);
	export_constant(SC_TIDAL_WEAPON);
	export_constant(SC_TIDAL_WEAPON_OPTION);
	export_constant(SC_ROCK_CRUSHER);
	export_constant(SC_ROCK_CRUSHER_ATK);
	export_constant(SC_LEADERSHIP);
	export_constant(SC_GLORYWOUNDS);
	export_constant(SC_SOULCOLD);
	export_constant(SC_HAWKEYES);
	export_constant(SC_ODINS_POWER);
	export_constant(SC_RAID);
	export_constant(SC_FIRE_INSIGNIA);
	export_constant(SC_WATER_INSIGNIA);
	export_constant(SC_WIND_INSIGNIA);
	export_constant(SC_EARTH_INSIGNIA);
	export_constant(SC_PUSH_CART);
	export_constant(SC_SPELLBOOK1);
	export_constant(SC_SPELLBOOK2);
	export_constant(SC_SPELLBOOK3);
	export_constant(SC_SPELLBOOK4);
	export_constant(SC_SPELLBOOK5);
	export_constant(SC_SPELLBOOK6);
	export_constant(SC_MAXSPELLBOOK);
	export_constant(SC_INCMHP);
	export_constant(SC_INCMSP);
	export_constant(SC_PARTYFLEE);
	export_constant(SC_MEIKYOUSISUI);
	export_constant(SC_JYUMONJIKIRI);
	export_constant(SC_KYOUGAKU);
	export_constant(SC_IZAYOI);
	export_constant(SC_ZENKAI);
	export_constant(SC_KAGEHUMI);
	export_constant(SC_KYOMU);
	export_constant(SC_KAGEMUSYA);
	export_constant(SC_ZANGETSU);
	export_constant(SC_GENSOU);
	export_constant(SC_AKAITSUKI);
	export_constant(SC_STYLE_CHANGE);
	export_constant(SC_TINDER_BREAKER);
	export_constant(SC_TINDER_BREAKER2);
	export_constant(SC_CBC);
	export_constant(SC_EQC);
	export_constant(SC_GOLDENE_FERSE);
	export_constant(SC_ANGRIFFS_MODUS);
	export_constant(SC_OVERED_BOOST);
	export_constant(SC_LIGHT_OF_REGENE);
	export_constant(SC_ASH);
	export_constant(SC_GRANITIC_ARMOR);
	export_constant(SC_MAGMA_FLOW);
	export_constant(SC_PYROCLASTIC);
	export_constant(SC_PARALYSIS);
	export_constant(SC_PAIN_KILLER);
	export_constant(SC_HANBOK);
	export_constant(SC_DEFSET);
	export_constant(SC_MDEFSET);
	export_constant(SC_DARKCROW);
	export_constant(SC_FULL_THROTTLE);
	export_constant(SC_REBOUND);
	export_constant(SC_UNLIMIT);
	export_constant(SC_KINGS_GRACE);
	export_constant(SC_TELEKINESIS_INTENSE);
	export_constant(SC_OFFERTORIUM);
	export_constant(SC_FRIGG_SONG);
	export_constant(SC_MONSTER_TRANSFORM);
	export_constant(SC_ANGEL_PROTECT);
	export_constant(SC_ILLUSIONDOPING);
	export_constant(SC_FLASHCOMBO);
	export_constant(SC_MOONSTAR);
	export_constant(SC_SUPER_STAR);
	export_constant(SC_HEAT_BARREL);
	export_constant(SC_MAGICALBULLET);
	export_constant(SC_P_ALTER);
	export_constant(SC_E_CHAIN);
	export_constant(SC_C_MARKER);
	export_constant(SC_ANTI_M_BLAST);
	export_constant(SC_B_TRAP);
	export_constant(SC_H_MINE);
	export_constant(SC_QD_SHOT_READY);
	export_constant(SC_MTF_ASPD);
	export_constant(SC_MTF_RANGEATK);
	export_constant(SC_MTF_MATK);
	export_constant(SC_MTF_MLEATKED);
	export_constant(SC_MTF_CRIDAMAGE);
	export_constant(SC_OKTOBERFEST);
	export_constant(SC_STRANGELIGHTS);
	export_constant(SC_DECORATION_OF_MUSIC);
	export_constant(SC_QUEST_BUFF1);
	export_constant(SC_QUEST_BUFF2);
	export_constant(SC_QUEST_BUFF3);
	export_constant(SC_ALL_RIDING);
	export_constant(SC_TEARGAS_SOB);
	export_constant(SC__FEINTBOMB);
	export_constant(SC__CHAOS);
	export_constant(SC_CHASEWALK2);
	export_constant(SC_VACUUM_EXTREME_POSTDELAY);
	export_constant(SC_MTF_ASPD2);
	export_constant(SC_MTF_RANGEATK2);
	export_constant(SC_MTF_MATK2);
	export_constant(SC_2011RWC_SCROLL);
	export_constant(SC_JP_EVENT04);
	export_constant(SC_MTF_MHP);
	export_constant(SC_MTF_MSP);
	export_constant(SC_MTF_PUMPKIN);
	export_constant(SC_MTF_HITFLEE);
	export_constant(SC_CRIFOOD);
	export_constant(SC_ATTHASTE_CASH);
	export_constant(SC_REUSE_LIMIT_A);
	export_constant(SC_REUSE_LIMIT_B);
	export_constant(SC_REUSE_LIMIT_C);
	export_constant(SC_REUSE_LIMIT_D);
	export_constant(SC_REUSE_LIMIT_E);
	export_constant(SC_REUSE_LIMIT_F);
	export_constant(SC_REUSE_LIMIT_G);
	export_constant(SC_REUSE_LIMIT_H);
	export_constant(SC_REUSE_LIMIT_MTF);
	export_constant(SC_REUSE_LIMIT_ASPD_POTION);
	export_constant(SC_REUSE_MILLENNIUMSHIELD);
	export_constant(SC_REUSE_CRUSHSTRIKE);
	export_constant(SC_REUSE_STORMBLAST);
	export_constant(SC_ALL_RIDING_REUSE_LIMIT);
	export_constant(SC_REUSE_LIMIT_ECL);
	export_constant(SC_REUSE_LIMIT_RECALL);
	export_constant(SC_PROMOTE_HEALTH_RESERCH);
	export_constant(SC_ENERGY_DRINK_RESERCH);
	export_constant(SC_NORECOVER_STATE);
	export_constant(SC_SUHIDE);
	export_constant(SC_SU_STOOP);
	export_constant(SC_SPRITEMABLE);
	export_constant(SC_CATNIPPOWDER);
	export_constant(SC_SV_ROOTTWIST);
	export_constant(SC_BITESCAR);
	export_constant(SC_ARCLOUSEDASH);
	export_constant(SC_TUNAPARTY);
	export_constant(SC_SHRIMP);
	export_constant(SC_FRESHSHRIMP);
	export_constant(SC_ACTIVE_MONSTER_TRANSFORM);
	export_deprecated_constant(SC_CLOUD_KILL);
	export_constant(SC_LJOSALFAR);
	export_constant(SC_MERMAID_LONGING);
	export_constant(SC_HAT_EFFECT);
	export_constant(SC_FLOWERSMOKE);
	export_constant(SC_FSTONE);
	export_constant(SC_HAPPINESS_STAR);
	export_constant(SC_MAPLE_FALLS);
	export_constant(SC_TIME_ACCESSORY);
	export_constant(SC_MAGICAL_FEATHER);
	export_constant(SC_GVG_GIANT);
	export_constant(SC_GVG_GOLEM);
	export_constant(SC_GVG_STUN);
	export_constant(SC_GVG_STONE);
	export_constant(SC_GVG_FREEZ);
	export_constant(SC_GVG_SLEEP);
	export_constant(SC_GVG_CURSE);
	export_constant(SC_GVG_SILENCE);
	export_constant(SC_GVG_BLIND);
	export_constant(SC_CLAN_INFO);
	export_constant(SC_SWORDCLAN);
	export_constant(SC_ARCWANDCLAN);
	export_constant(SC_GOLDENMACECLAN);
	export_constant(SC_CROSSBOWCLAN);
	export_constant(SC_JUMPINGCLAN);
	export_constant(SC_GEFFEN_MAGIC1);
	export_constant(SC_GEFFEN_MAGIC2);
	export_constant(SC_GEFFEN_MAGIC3);
	export_constant(SC_MAXPAIN);
	export_constant(SC_ARMOR_ELEMENT_EARTH);
	export_constant(SC_ARMOR_ELEMENT_FIRE);
	export_constant(SC_ARMOR_ELEMENT_WIND);
	export_constant(SC_DAILYSENDMAILCNT);
	export_constant(SC_DORAM_BUF_01);
	export_constant(SC_DORAM_BUF_02);
	export_constant(SC_HISS);
	export_constant(SC_NYANGGRASS);
	export_constant(SC_GROOMING);
	export_constant(SC_SHRIMPBLESSING);
	export_constant(SC_CHATTERING);
	export_constant(SC_DORAM_WALKSPEED);
	export_constant(SC_DORAM_MATK);
	export_constant(SC_DORAM_FLEE2);
	export_constant(SC_DORAM_SVSP);
	export_constant(SC_FALLEN_ANGEL);
	export_constant(SC_CHEERUP);
	export_constant(SC_DRESSUP);
	export_constant(SC_GLASTHEIM_ATK);
	export_constant(SC_GLASTHEIM_DEF);
	export_constant(SC_GLASTHEIM_HEAL);
	export_constant(SC_GLASTHEIM_HIDDEN);
	export_constant(SC_GLASTHEIM_STATE);
	export_constant(SC_GLASTHEIM_ITEMDEF);
	export_constant(SC_GLASTHEIM_HPSP);
	export_constant(SC_LHZ_DUN_N1);
	export_constant(SC_LHZ_DUN_N2);
	export_constant(SC_LHZ_DUN_N3);
	export_constant(SC_LHZ_DUN_N4);
	export_constant(SC_ANCILLA);
#ifdef RENEWAL
	export_constant(SC_EXTREMITYFIST2);
#endif

	/* status icons */
	export_deprecated_constant2("SI_BLANK",-1);
	export_deprecated_constant2("SI_PROVOKE",0);
	export_deprecated_constant2("SI_ENDURE",1);
	export_deprecated_constant2("SI_TWOHANDQUICKEN",2);
	export_deprecated_constant2("SI_CONCENTRATE",3);
	export_deprecated_constant2("SI_HIDING",4);
	export_deprecated_constant2("SI_CLOAKING",5);
	export_deprecated_constant2("SI_ENCPOISON",6);
	export_deprecated_constant2("SI_POISONREACT",7);
	export_deprecated_constant2("SI_QUAGMIRE",8);
	export_deprecated_constant2("SI_ANGELUS",9);
	export_deprecated_constant2("SI_BLESSING",10);
	export_deprecated_constant2("SI_SIGNUMCRUCIS",11);
	export_deprecated_constant2("SI_INCREASEAGI",12);
	export_deprecated_constant2("SI_DECREASEAGI",13);
	export_deprecated_constant2("SI_SLOWPOISON",14);
	export_deprecated_constant2("SI_IMPOSITIO",15);
	export_deprecated_constant2("SI_SUFFRAGIUM",16);
	export_deprecated_constant2("SI_ASPERSIO",17);
	export_deprecated_constant2("SI_BENEDICTIO",18);
	export_deprecated_constant2("SI_KYRIE",19);
	export_deprecated_constant2("SI_MAGNIFICAT",20);
	export_deprecated_constant2("SI_GLORIA",21);
	export_deprecated_constant2("SI_AETERNA",22);
	export_deprecated_constant2("SI_ADRENALINE",23);
	export_deprecated_constant2("SI_WEAPONPERFECTION",24);
	export_deprecated_constant2("SI_OVERTHRUST",25);
	export_deprecated_constant2("SI_MAXIMIZEPOWER",26);
	export_deprecated_constant2("SI_RIDING",27);
	export_deprecated_constant2("SI_FALCON",28);
	export_deprecated_constant2("SI_TRICKDEAD",29);
	export_deprecated_constant2("SI_LOUD",30);
	export_deprecated_constant2("SI_ENERGYCOAT",31);
	export_deprecated_constant2("SI_BROKENARMOR",32);
	export_deprecated_constant2("SI_BROKENWEAPON",33);
	export_deprecated_constant2("SI_HALLUCINATION",34);
	export_deprecated_constant2("SI_WEIGHT50",35);
	export_deprecated_constant2("SI_WEIGHT90",36);
	export_deprecated_constant2("SI_ASPDPOTION0",37);
	export_deprecated_constant2("SI_ASPDPOTION1",38);
	export_deprecated_constant2("SI_ASPDPOTION2",39);
	export_deprecated_constant2("SI_ASPDPOTIONINFINITY",40);
	export_deprecated_constant2("SI_SPEEDPOTION1",41);
	export_deprecated_constant2("SI_AUTOCOUNTER",43);
	export_deprecated_constant2("SI_SPLASHER",44);
	export_deprecated_constant2("SI_ANKLESNARE",45);
	export_deprecated_constant2("SI_ACTIONDELAY",46);
	export_deprecated_constant2("SI_BARRIER",49);
	export_deprecated_constant2("SI_STRIPWEAPON",50);
	export_deprecated_constant2("SI_STRIPSHIELD",51);
	export_deprecated_constant2("SI_STRIPARMOR",52);
	export_deprecated_constant2("SI_STRIPHELM",53);
	export_deprecated_constant2("SI_CP_WEAPON",54);
	export_deprecated_constant2("SI_CP_SHIELD",55);
	export_deprecated_constant2("SI_CP_ARMOR",56);
	export_deprecated_constant2("SI_CP_HELM",57);
	export_deprecated_constant2("SI_AUTOGUARD",58);
	export_deprecated_constant2("SI_REFLECTSHIELD",59);
	export_deprecated_constant2("SI_DEVOTION",60);
	export_deprecated_constant2("SI_PROVIDENCE",61);
	export_deprecated_constant2("SI_DEFENDER",62);
	export_deprecated_constant2("SI_MAGICROD",63);
	export_deprecated_constant2("SI_AUTOSPELL",65);
	export_deprecated_constant2("SI_SPEARQUICKEN",68);
	export_deprecated_constant2("SI_BDPLAYING",69);
	export_deprecated_constant2("SI_WHISTLE",70);
	export_deprecated_constant2("SI_ASSASSINCROSS",71);
	export_deprecated_constant2("SI_POEMBRAGI",72);
	export_deprecated_constant2("SI_APPLEIDUN",73);
	export_deprecated_constant2("SI_HUMMING",74);
	export_deprecated_constant2("SI_DONTFORGETME",75);
	export_deprecated_constant2("SI_FORTUNEKISS",76);
	export_deprecated_constant2("SI_SERVICEFORYOU",77);
	export_deprecated_constant2("SI_RICHMANKIM",78);
	export_deprecated_constant2("SI_ETERNALCHAOS",79);
	export_deprecated_constant2("SI_DRUMBATTLEFIELD",80);
	export_deprecated_constant2("SI_RINGNIBELUNGEN",81);
	export_deprecated_constant2("SI_ROKISWEIL",82);
	export_deprecated_constant2("SI_INTOABYSS",83);
	export_deprecated_constant2("SI_SIEGFRIED",84);
	export_deprecated_constant2("SI_BLADESTOP",85);
	export_deprecated_constant2("SI_EXPLOSIONSPIRITS",86);
	export_deprecated_constant2("SI_STEELBODY",87);
	export_deprecated_constant2("SI_EXTREMITYFIST",88);
	export_deprecated_constant2("SI_FIREWEAPON",90);
	export_deprecated_constant2("SI_WATERWEAPON",91);
	export_deprecated_constant2("SI_WINDWEAPON",92);
	export_deprecated_constant2("SI_EARTHWEAPON",93);
	export_deprecated_constant2("SI_STOP",95);
	export_deprecated_constant2("SI_UNDEAD",97);
	export_deprecated_constant2("SI_AURABLADE",103);
	export_deprecated_constant2("SI_PARRYING",104);
	export_deprecated_constant2("SI_CONCENTRATION",105);
	export_deprecated_constant2("SI_TENSIONRELAX",106);
	export_deprecated_constant2("SI_BERSERK",107);
	export_deprecated_constant2("SI_GOSPEL",109);
	export_deprecated_constant2("SI_ASSUMPTIO",110);
	export_deprecated_constant2("SI_BASILICA",111);
	export_deprecated_constant2("SI_LANDENDOW",112);
	export_deprecated_constant2("SI_MAGICPOWER",113);
	export_deprecated_constant2("SI_EDP",114);
	export_deprecated_constant2("SI_TRUESIGHT",115);
	export_deprecated_constant2("SI_WINDWALK",116);
	export_deprecated_constant2("SI_MELTDOWN",117);
	export_deprecated_constant2("SI_CARTBOOST",118);
	export_deprecated_constant2("SI_CHASEWALK",119);
	export_deprecated_constant2("SI_REJECTSWORD",120);
	export_deprecated_constant2("SI_MARIONETTE",121);
	export_deprecated_constant2("SI_MARIONETTE2",122);
	export_deprecated_constant2("SI_MOONLIT",123);
	export_deprecated_constant2("SI_BLEEDING",124);
	export_deprecated_constant2("SI_JOINTBEAT",125);
	export_deprecated_constant2("SI_MINDBREAKER",126);
	export_deprecated_constant2("SI_MEMORIZE",127);
	export_deprecated_constant2("SI_FOGWALL",128);
	export_deprecated_constant2("SI_SPIDERWEB",129);
	export_deprecated_constant2("SI_BABY",130);
	export_deprecated_constant2("SI_AUTOBERSERK",132);
	export_deprecated_constant2("SI_RUN",133);
	export_deprecated_constant2("SI_BUMP",134);
	export_deprecated_constant2("SI_READYSTORM",135);
	export_deprecated_constant2("SI_READYDOWN",137);
	export_deprecated_constant2("SI_READYTURN",139);
	export_deprecated_constant2("SI_READYCOUNTER",141);
	export_deprecated_constant2("SI_DODGE",143);
	export_deprecated_constant2("SI_SPURT",145);
	export_deprecated_constant2("SI_SHADOWWEAPON",146);
	export_deprecated_constant2("SI_ADRENALINE2",147);
	export_deprecated_constant2("SI_GHOSTWEAPON",148);
	export_deprecated_constant2("SI_SPIRIT",149);
	export_deprecated_constant2("SI_PLUSATTACKPOWER",150);
	export_deprecated_constant2("SI_PLUSMAGICPOWER",151);
	export_deprecated_constant2("SI_DEVIL",152);
	export_deprecated_constant2("SI_KAITE",153);
	export_deprecated_constant2("SI_SWOO",154);
	export_deprecated_constant2("SI_KAIZEL",156);
	export_deprecated_constant2("SI_KAAHI",157);
	export_deprecated_constant2("SI_KAUPE",158);
	export_deprecated_constant2("SI_SMA",159);
	export_deprecated_constant2("SI_NIGHT",160);
	export_deprecated_constant2("SI_ONEHAND",161);
	export_deprecated_constant2("SI_WARM",165);
	export_deprecated_constant2("SI_SUN_COMFORT",169);
	export_deprecated_constant2("SI_MOON_COMFORT",170);
	export_deprecated_constant2("SI_STAR_COMFORT",171);
	export_deprecated_constant2("SI_GDSKILL_BATTLEORDER",173);
	export_deprecated_constant2("SI_GDSKILL_REGENERATION",174);
	export_deprecated_constant2("SI_PRESERVE",181);
	export_deprecated_constant2("SI_CHASEWALK2",182);
	export_deprecated_constant2("SI_INTRAVISION",184);
	export_deprecated_constant2("SI_DOUBLECAST",186);
	export_deprecated_constant2("SI_GRAVITATION",187);
	export_deprecated_constant2("SI_MAXOVERTHRUST",188);
	export_deprecated_constant2("SI_LONGING",189);
	export_deprecated_constant2("SI_HERMODE",190);
	export_deprecated_constant2("SI_TAROT",191);
	export_deprecated_constant2("SI_SHRINK",197);
	export_deprecated_constant2("SI_SIGHTBLASTER",198);
	export_deprecated_constant2("SI_WINKCHARM",199);
	export_deprecated_constant2("SI_CLOSECONFINE",200);
	export_deprecated_constant2("SI_CLOSECONFINE2",201);
	export_deprecated_constant2("SI_MADNESSCANCEL",203);
	export_deprecated_constant2("SI_GATLINGFEVER",204);
	export_deprecated_constant2("SI_EARTHSCROLL",205);
	export_deprecated_constant2("SI_UTSUSEMI",206);
	export_deprecated_constant2("SI_BUNSINJYUTSU",207);
	export_deprecated_constant2("SI_NEN",208);
	export_deprecated_constant2("SI_ADJUSTMENT",209);
	export_deprecated_constant2("SI_ACCURACY",210);
	export_deprecated_constant2("SI_FOODSTR",241);
	export_deprecated_constant2("SI_FOODAGI",242);
	export_deprecated_constant2("SI_FOODVIT",243);
	export_deprecated_constant2("SI_FOODDEX",244);
	export_deprecated_constant2("SI_FOODINT",245);
	export_deprecated_constant2("SI_FOODLUK",246);
	export_deprecated_constant2("SI_FOODFLEE",247);
	export_deprecated_constant2("SI_FOODHIT",248);
	export_deprecated_constant2("SI_FOODCRI",249);
	export_deprecated_constant2("SI_EXPBOOST",250);
	export_deprecated_constant2("SI_LIFEINSURANCE",251);
	export_deprecated_constant2("SI_ITEMBOOST",252);
	export_deprecated_constant2("SI_BOSSMAPINFO",253);
	export_deprecated_constant2("SI_FOOD_STR_CASH",271);
	export_deprecated_constant2("SI_FOOD_AGI_CASH",272);
	export_deprecated_constant2("SI_FOOD_VIT_CASH",273);
	export_deprecated_constant2("SI_FOOD_DEX_CASH",274);
	export_deprecated_constant2("SI_FOOD_INT_CASH",275);
	export_deprecated_constant2("SI_FOOD_LUK_CASH",276);
	export_deprecated_constant2("SI_MERC_FLEEUP",277);
	export_deprecated_constant2("SI_MERC_ATKUP",278);
	export_deprecated_constant2("SI_MERC_HPUP",279);
	export_deprecated_constant2("SI_MERC_SPUP",280);
	export_deprecated_constant2("SI_MERC_HITUP",281);
	export_deprecated_constant2("SI_SLOWCAST",282);
	export_deprecated_constant2("SI_CRITICALWOUND",286);
	export_deprecated_constant2("SI_MOVHASTE_HORSE",289);
	export_deprecated_constant2("SI_DEF_RATE",290);
	export_deprecated_constant2("SI_MDEF_RATE",291);
	export_deprecated_constant2("SI_INCHEALRATE",292);
	export_deprecated_constant2("SI_S_LIFEPOTION",293);
	export_deprecated_constant2("SI_L_LIFEPOTION",294);
	export_deprecated_constant2("SI_INCCRI",295);
	export_deprecated_constant2("SI_PLUSAVOIDVALUE",296);
	export_deprecated_constant2("SI_ATKER_BLOOD",300);
	export_deprecated_constant2("SI_TARGET_BLOOD",301);
	export_deprecated_constant2("SI_ARMOR_PROPERTY",302);
	export_deprecated_constant2("SI_REUSE_LIMIT_A",303);
	export_deprecated_constant2("SI_HELLPOWER",304);
	export_deprecated_constant2("SI_STEAMPACK",305);
	export_deprecated_constant2("SI_REUSE_LIMIT_B",306);
	export_deprecated_constant2("SI_REUSE_LIMIT_C",307);
	export_deprecated_constant2("SI_REUSE_LIMIT_D",308);
	export_deprecated_constant2("SI_REUSE_LIMIT_E",309);
	export_deprecated_constant2("SI_REUSE_LIMIT_F",310);
	export_deprecated_constant2("SI_INVINCIBLE",311);
	export_deprecated_constant2("SI_CASH_PLUSONLYJOBEXP",312);
	export_deprecated_constant2("SI_PARTYFLEE",313);
	export_deprecated_constant2("SI_ANGEL_PROTECT",314);
	export_deprecated_constant2("SI_ENDURE_MDEF",315);
	export_deprecated_constant2("SI_ENCHANTBLADE",316);
	export_deprecated_constant2("SI_DEATHBOUND",317);
	export_deprecated_constant2("SI_REFRESH",318);
	export_deprecated_constant2("SI_GIANTGROWTH",319);
	export_deprecated_constant2("SI_STONEHARDSKIN",320);
	export_deprecated_constant2("SI_VITALITYACTIVATION",321);
	export_deprecated_constant2("SI_FIGHTINGSPIRIT",322);
	export_deprecated_constant2("SI_ABUNDANCE",323);
	export_deprecated_constant2("SI_REUSE_MILLENNIUMSHIELD",324);
	export_deprecated_constant2("SI_REUSE_CRUSHSTRIKE",325);
	export_deprecated_constant2("SI_REUSE_REFRESH",326);
	export_deprecated_constant2("SI_REUSE_STORMBLAST",327);
	export_deprecated_constant2("SI_VENOMIMPRESS",328);
	export_deprecated_constant2("SI_EPICLESIS",329);
	export_deprecated_constant2("SI_ORATIO",330);
	export_deprecated_constant2("SI_LAUDAAGNUS",331);
	export_deprecated_constant2("SI_LAUDARAMUS",332);
	export_deprecated_constant2("SI_CLOAKINGEXCEED",333);
	export_deprecated_constant2("SI_HALLUCINATIONWALK",334);
	export_deprecated_constant2("SI_HALLUCINATIONWALK_POSTDELAY",335);
	export_deprecated_constant2("SI_RENOVATIO",336);
	export_deprecated_constant2("SI_WEAPONBLOCKING",337);
	export_deprecated_constant2("SI_WEAPONBLOCKING_POSTDELAY",338);
	export_deprecated_constant2("SI_ROLLINGCUTTER",339);
	export_deprecated_constant2("SI_EXPIATIO",340);
	export_deprecated_constant2("SI_POISONINGWEAPON",341);
	export_deprecated_constant2("SI_TOXIN",342);
	export_deprecated_constant2("SI_PARALYSE",343);
	export_deprecated_constant2("SI_VENOMBLEED",344);
	export_deprecated_constant2("SI_MAGICMUSHROOM",345);
	export_deprecated_constant2("SI_DEATHHURT",346);
	export_deprecated_constant2("SI_PYREXIA",347);
	export_deprecated_constant2("SI_OBLIVIONCURSE",348);
	export_deprecated_constant2("SI_LEECHESEND",349);
	export_deprecated_constant2("SI_DUPLELIGHT",350);
	export_deprecated_constant2("SI_FROSTMISTY",351);
	export_deprecated_constant2("SI_FEARBREEZE",352);
	export_deprecated_constant2("SI_ELECTRICSHOCKER",353);
	export_deprecated_constant2("SI_MARSHOFABYSS",354);
	export_deprecated_constant2("SI_RECOGNIZEDSPELL",355);
	export_deprecated_constant2("SI_STASIS",356);
	export_deprecated_constant2("SI_WUGRIDER",357);
	export_deprecated_constant2("SI_WUGDASH",358);
	export_deprecated_constant2("SI_WUGBITE",359);
	export_deprecated_constant2("SI_CAMOUFLAGE",360);
	export_deprecated_constant2("SI_ACCELERATION",361);
	export_deprecated_constant2("SI_HOVERING",362);
	export_deprecated_constant2("SI_SPHERE_1",363);
	export_deprecated_constant2("SI_SPHERE_2",364);
	export_deprecated_constant2("SI_SPHERE_3",365);
	export_deprecated_constant2("SI_SPHERE_4",366);
	export_deprecated_constant2("SI_SPHERE_5",367);
	export_deprecated_constant2("SI_MVPCARD_TAOGUNKA",368);
	export_deprecated_constant2("SI_MVPCARD_MISTRESS",369);
	export_deprecated_constant2("SI_MVPCARD_ORCHERO",370);
	export_deprecated_constant2("SI_MVPCARD_ORCLORD",371);
	export_deprecated_constant2("SI_OVERHEAT_LIMITPOINT",372);
	export_deprecated_constant2("SI_OVERHEAT",373);
	export_deprecated_constant2("SI_SHAPESHIFT",374);
	export_deprecated_constant2("SI_INFRAREDSCAN",375);
	export_deprecated_constant2("SI_MAGNETICFIELD",376);
	export_deprecated_constant2("SI_NEUTRALBARRIER",377);
	export_deprecated_constant2("SI_NEUTRALBARRIER_MASTER",378);
	export_deprecated_constant2("SI_STEALTHFIELD",379);
	export_deprecated_constant2("SI_STEALTHFIELD_MASTER",380);
	export_deprecated_constant2("SI_MANU_ATK",381);
	export_deprecated_constant2("SI_MANU_DEF",382);
	export_deprecated_constant2("SI_SPL_ATK",383);
	export_deprecated_constant2("SI_SPL_DEF",384);
	export_deprecated_constant2("SI_REPRODUCE",385);
	export_deprecated_constant2("SI_MANU_MATK",386);
	export_deprecated_constant2("SI_SPL_MATK",387);
	export_deprecated_constant2("SI_STR_SCROLL",388);
	export_deprecated_constant2("SI_INT_SCROLL",389);
	export_deprecated_constant2("SI_LG_REFLECTDAMAGE",390);
	export_deprecated_constant2("SI_FORCEOFVANGUARD",391);
	export_deprecated_constant2("SI_BUCHEDENOEL",392);
	export_deprecated_constant2("SI_AUTOSHADOWSPELL",393);
	export_deprecated_constant2("SI_SHADOWFORM",394);
	export_deprecated_constant2("SI_RAID",395);
	export_deprecated_constant2("SI_SHIELDSPELL_DEF",396);
	export_deprecated_constant2("SI_SHIELDSPELL_MDEF",397);
	export_deprecated_constant2("SI_SHIELDSPELL_REF",398);
	export_deprecated_constant2("SI_BODYPAINT",399);
	export_deprecated_constant2("SI_EXEEDBREAK",400);
	export_deprecated_constant2("SI_ADORAMUS",401);
	export_deprecated_constant2("SI_PRESTIGE",402);
	export_deprecated_constant2("SI_INVISIBILITY",403);
	export_deprecated_constant2("SI_DEADLYINFECT",404);
	export_deprecated_constant2("SI_BANDING",405);
	export_deprecated_constant2("SI_EARTHDRIVE",406);
	export_deprecated_constant2("SI_INSPIRATION",407);
	export_deprecated_constant2("SI_ENERVATION",408);
	export_deprecated_constant2("SI_GROOMY",409);
	export_deprecated_constant2("SI_RAISINGDRAGON",410);
	export_deprecated_constant2("SI_IGNORANCE",411);
	export_deprecated_constant2("SI_LAZINESS",412);
	export_deprecated_constant2("SI_LIGHTNINGWALK",413);
	export_deprecated_constant2("SI_ACARAJE",414);
	export_deprecated_constant2("SI_UNLUCKY",415);
	export_deprecated_constant2("SI_CURSEDCIRCLE_ATKER",416);
	export_deprecated_constant2("SI_CURSEDCIRCLE_TARGET",417);
	export_deprecated_constant2("SI_WEAKNESS",418);
	export_deprecated_constant2("SI_CRESCENTELBOW",419);
	export_deprecated_constant2("SI_NOEQUIPACCESSARY",420);
	export_deprecated_constant2("SI_STRIPACCESSARY",421);
	export_deprecated_constant2("SI_MANHOLE",422);
	export_deprecated_constant2("SI_POPECOOKIE",423);
	export_deprecated_constant2("SI_FALLENEMPIRE",424);
	export_deprecated_constant2("SI_GENTLETOUCH_ENERGYGAIN",425);
	export_deprecated_constant2("SI_GENTLETOUCH_CHANGE",426);
	export_deprecated_constant2("SI_GENTLETOUCH_REVITALIZE",427);
	export_deprecated_constant2("SI_BLOODYLUST",428);
	export_deprecated_constant2("SI_SWINGDANCE",429);
	export_deprecated_constant2("SI_SYMPHONYOFLOVERS",430);
	export_deprecated_constant2("SI_PROPERTYWALK",431);
	export_deprecated_constant2("SI_SPELLFIST",432);
	export_deprecated_constant2("SI_NETHERWORLD",433);
	export_deprecated_constant2("SI_VOICEOFSIREN",434);
	export_deprecated_constant2("SI_DEEPSLEEP",435);
	export_deprecated_constant2("SI_SIRCLEOFNATURE",436);
	export_deprecated_constant2("SI_COLD",437);
	export_deprecated_constant2("SI_GLOOMYDAY",438);
	export_deprecated_constant2("SI_SONGOFMANA",439);
	export_deprecated_constant2("SI_CLOUDKILL",440);
	export_deprecated_constant2("SI_DANCEWITHWUG",441);
	export_deprecated_constant2("SI_RUSHWINDMILL",442);
	export_deprecated_constant2("SI_ECHOSONG",443);
	export_deprecated_constant2("SI_HARMONIZE",444);
	export_deprecated_constant2("SI_STRIKING",445);
	export_deprecated_constant2("SI_WARMER",446);
	export_deprecated_constant2("SI_MOONLITSERENADE",447);
	export_deprecated_constant2("SI_SATURDAYNIGHTFEVER",448);
	export_deprecated_constant2("SI_SITDOWN_FORCE",449);
	export_deprecated_constant2("SI_ANALYZE",450);
	export_deprecated_constant2("SI_LERADSDEW",451);
	export_deprecated_constant2("SI_MELODYOFSINK",452);
	export_deprecated_constant2("SI_WARCRYOFBEYOND",453);
	export_deprecated_constant2("SI_UNLIMITEDHUMMINGVOICE",454);
	export_deprecated_constant2("SI_SPELLBOOK1",455);
	export_deprecated_constant2("SI_SPELLBOOK2",456);
	export_deprecated_constant2("SI_SPELLBOOK3",457);
	export_deprecated_constant2("SI_FREEZE_SP",458);
	export_deprecated_constant2("SI_GN_TRAINING_SWORD",459);
	export_deprecated_constant2("SI_GN_REMODELING_CART",460);
	export_deprecated_constant2("SI_GN_CARTBOOST",461);
	export_deprecated_constant2("SI_FIXEDCASTINGTM_REDUCE",462);
	export_deprecated_constant2("SI_THORNTRAP",463);
	export_deprecated_constant2("SI_BLOODSUCKER",464);
	export_deprecated_constant2("SI_SPORE_EXPLOSION",465);
	export_deprecated_constant2("SI_DEMONIC_FIRE",466);
	export_deprecated_constant2("SI_FIRE_EXPANSION_SMOKE_POWDER",467);
	export_deprecated_constant2("SI_FIRE_EXPANSION_TEAR_GAS",468);
	export_deprecated_constant2("SI_BLOCKING_PLAY",469);
	export_deprecated_constant2("SI_MANDRAGORA",470);
	export_deprecated_constant2("SI_ACTIVATE",471);
	export_deprecated_constant2("SI_SECRAMENT",472);
	export_deprecated_constant2("SI_ASSUMPTIO2",473);
	export_deprecated_constant2("SI_TK_SEVENWIND",474);
	export_deprecated_constant2("SI_LIMIT_ODINS_RECALL",475);
	export_deprecated_constant2("SI_STOMACHACHE",476);
	export_deprecated_constant2("SI_MYSTERIOUS_POWDER",477);
	export_deprecated_constant2("SI_MELON_BOMB",478);
	export_deprecated_constant2("SI_BANANA_BOMB_SITDOWN_POSTDELAY",479);
	export_deprecated_constant2("SI_PROMOTE_HEALTH_RESERCH",480);
	export_deprecated_constant2("SI_ENERGY_DRINK_RESERCH",481);
	export_deprecated_constant2("SI_EXTRACT_WHITE_POTION_Z",482);
	export_deprecated_constant2("SI_VITATA_500",483);
	export_deprecated_constant2("SI_EXTRACT_SALAMINE_JUICE",484);
	export_deprecated_constant2("SI_BOOST500",485);
	export_deprecated_constant2("SI_FULL_SWING_K",486);
	export_deprecated_constant2("SI_MANA_PLUS",487);
	export_deprecated_constant2("SI_MUSTLE_M",488);
	export_deprecated_constant2("SI_LIFE_FORCE_F",489);
	export_deprecated_constant2("SI_VACUUM_EXTREME",490);
	export_deprecated_constant2("SI_SAVAGE_STEAK",491);
	export_deprecated_constant2("SI_COCKTAIL_WARG_BLOOD",492);
	export_deprecated_constant2("SI_MINOR_BBQ",493);
	export_deprecated_constant2("SI_SIROMA_ICE_TEA",494);
	export_deprecated_constant2("SI_DROCERA_HERB_STEAMED",495);
	export_deprecated_constant2("SI_PUTTI_TAILS_NOODLES",496);
	export_deprecated_constant2("SI_BANANA_BOMB",497);
	export_deprecated_constant2("SI_SUMMON_AGNI",498);
	export_deprecated_constant2("SI_SPELLBOOK4",499);
	export_deprecated_constant2("SI_SPELLBOOK5",500);
	export_deprecated_constant2("SI_SPELLBOOK6",501);
	export_deprecated_constant2("SI_SPELLBOOK7",502);
	export_deprecated_constant2("SI_ELEMENTAL_AGGRESSIVE",503);
	export_deprecated_constant2("SI_RETURN_TO_ELDICASTES",504);
	export_deprecated_constant2("SI_BANDING_DEFENCE",505);
	export_deprecated_constant2("SI_SKELSCROLL",506);
	export_deprecated_constant2("SI_DISTRUCTIONSCROLL",507);
	export_deprecated_constant2("SI_ROYALSCROLL",508);
	export_deprecated_constant2("SI_IMMUNITYSCROLL",509);
	export_deprecated_constant2("SI_MYSTICSCROLL",510);
	export_deprecated_constant2("SI_BATTLESCROLL",511);
	export_deprecated_constant2("SI_ARMORSCROLL",512);
	export_deprecated_constant2("SI_FREYJASCROLL",513);
	export_deprecated_constant2("SI_SOULSCROLL",514);
	export_deprecated_constant2("SI_CIRCLE_OF_FIRE",515);
	export_deprecated_constant2("SI_CIRCLE_OF_FIRE_OPTION",516);
	export_deprecated_constant2("SI_FIRE_CLOAK",517);
	export_deprecated_constant2("SI_FIRE_CLOAK_OPTION",518);
	export_deprecated_constant2("SI_WATER_SCREEN",519);
	export_deprecated_constant2("SI_WATER_SCREEN_OPTION",520);
	export_deprecated_constant2("SI_WATER_DROP",521);
	export_deprecated_constant2("SI_WATER_DROP_OPTION",522);
	export_deprecated_constant2("SI_WIND_STEP",523);
	export_deprecated_constant2("SI_WIND_STEP_OPTION",524);
	export_deprecated_constant2("SI_WIND_CURTAIN",525);
	export_deprecated_constant2("SI_WIND_CURTAIN_OPTION",526);
	export_deprecated_constant2("SI_WATER_BARRIER",527);
	export_deprecated_constant2("SI_ZEPHYR",528);
	export_deprecated_constant2("SI_SOLID_SKIN",529);
	export_deprecated_constant2("SI_SOLID_SKIN_OPTION",530);
	export_deprecated_constant2("SI_STONE_SHIELD",531);
	export_deprecated_constant2("SI_STONE_SHIELD_OPTION",532);
	export_deprecated_constant2("SI_POWER_OF_GAIA",533);
	export_deprecated_constant2("SI_PYROTECHNIC",539);
	export_deprecated_constant2("SI_PYROTECHNIC_OPTION",540);
	export_deprecated_constant2("SI_HEATER",541);
	export_deprecated_constant2("SI_HEATER_OPTION",542);
	export_deprecated_constant2("SI_TROPIC",543);
	export_deprecated_constant2("SI_TROPIC_OPTION",544);
	export_deprecated_constant2("SI_AQUAPLAY",545);
	export_deprecated_constant2("SI_AQUAPLAY_OPTION",546);
	export_deprecated_constant2("SI_COOLER",547);
	export_deprecated_constant2("SI_COOLER_OPTION",548);
	export_deprecated_constant2("SI_CHILLY_AIR",549);
	export_deprecated_constant2("SI_CHILLY_AIR_OPTION",550);
	export_deprecated_constant2("SI_GUST",551);
	export_deprecated_constant2("SI_GUST_OPTION",552);
	export_deprecated_constant2("SI_BLAST",553);
	export_deprecated_constant2("SI_BLAST_OPTION",554);
	export_deprecated_constant2("SI_WILD_STORM",555);
	export_deprecated_constant2("SI_WILD_STORM_OPTION",556);
	export_deprecated_constant2("SI_PETROLOGY",557);
	export_deprecated_constant2("SI_PETROLOGY_OPTION",558);
	export_deprecated_constant2("SI_CURSED_SOIL",559);
	export_deprecated_constant2("SI_CURSED_SOIL_OPTION",560);
	export_deprecated_constant2("SI_UPHEAVAL",561);
	export_deprecated_constant2("SI_UPHEAVAL_OPTION",562);
	export_deprecated_constant2("SI_TIDAL_WEAPON",563);
	export_deprecated_constant2("SI_TIDAL_WEAPON_OPTION",564);
	export_deprecated_constant2("SI_ROCK_CRUSHER",565);
	export_deprecated_constant2("SI_ROCK_CRUSHER_ATK",566);
	export_deprecated_constant2("SI_FIRE_INSIGNIA",567);
	export_deprecated_constant2("SI_WATER_INSIGNIA",568);
	export_deprecated_constant2("SI_WIND_INSIGNIA",569);
	export_deprecated_constant2("SI_EARTH_INSIGNIA",570);
	export_deprecated_constant2("SI_EQUIPED_FLOOR",571);
	export_deprecated_constant2("SI_GUARDIAN_RECALL",572);
	export_deprecated_constant2("SI_MORA_BUFF",573);
	export_deprecated_constant2("SI_REUSE_LIMIT_G",574);
	export_deprecated_constant2("SI_REUSE_LIMIT_H",575);
	export_deprecated_constant2("SI_NEEDLE_OF_PARALYZE",576);
	export_deprecated_constant2("SI_PAIN_KILLER",577);
	export_deprecated_constant2("SI_G_LIFEPOTION",578);
	export_deprecated_constant2("SI_VITALIZE_POTION",579);
	export_deprecated_constant2("SI_LIGHT_OF_REGENE",580);
	export_deprecated_constant2("SI_OVERED_BOOST",581);
	export_deprecated_constant2("SI_SILENT_BREEZE",582);
	export_deprecated_constant2("SI_ODINS_POWER",583);
	export_deprecated_constant2("SI_STYLE_CHANGE",584);
	export_deprecated_constant2("SI_SONIC_CLAW_POSTDELAY",585);
	export_deprecated_constant2("SI_SILVERVEIN_RUSH_POSTDELAY",596);
	export_deprecated_constant2("SI_MIDNIGHT_FRENZY_POSTDELAY",597);
	export_deprecated_constant2("SI_GOLDENE_FERSE",598);
	export_deprecated_constant2("SI_ANGRIFFS_MODUS",599);
	export_deprecated_constant2("SI_TINDER_BREAKER",600);
	export_deprecated_constant2("SI_TINDER_BREAKER_POSTDELAY",601);
	export_deprecated_constant2("SI_CBC",602);
	export_deprecated_constant2("SI_CBC_POSTDELAY",603);
	export_deprecated_constant2("SI_EQC",604);
	export_deprecated_constant2("SI_MAGMA_FLOW",605);
	export_deprecated_constant2("SI_GRANITIC_ARMOR",606);
	export_deprecated_constant2("SI_PYROCLASTIC",607);
	export_deprecated_constant2("SI_VOLCANIC_ASH",608);
	export_deprecated_constant2("SI_SPIRITS_SAVEINFO1",609);
	export_deprecated_constant2("SI_SPIRITS_SAVEINFO2",610);
	export_deprecated_constant2("SI_MAGIC_CANDY",611);
	export_deprecated_constant2("SI_SEARCH_STORE_INFO",612);
	export_deprecated_constant2("SI_ALL_RIDING",613);
	export_deprecated_constant2("SI_ALL_RIDING_REUSE_LIMIT",614);
	export_deprecated_constant2("SI_MACRO",615);
	export_deprecated_constant2("SI_MACRO_POSTDELAY",616);
	export_deprecated_constant2("SI_BEER_BOTTLE_CAP",617);
	export_deprecated_constant2("SI_OVERLAPEXPUP",618);
	export_deprecated_constant2("SI_PC_IZ_DUN05",619);
	export_deprecated_constant2("SI_CRUSHSTRIKE",620);
	export_deprecated_constant2("SI_MONSTER_TRANSFORM",621);
	export_deprecated_constant2("SI_SIT",622);
	export_deprecated_constant2("SI_ONAIR",623);
	export_deprecated_constant2("SI_MTF_ASPD",624);
	export_deprecated_constant2("SI_MTF_RANGEATK",625);
	export_deprecated_constant2("SI_MTF_MATK",626);
	export_deprecated_constant2("SI_MTF_MLEATKED",627);
	export_deprecated_constant2("SI_MTF_CRIDAMAGE",628);
	export_deprecated_constant2("SI_REUSE_LIMIT_MTF",629);
	export_deprecated_constant2("SI_MACRO_PERMIT",630);
	export_deprecated_constant2("SI_MACRO_PLAY",631);
	export_deprecated_constant2("SI_SKF_CAST",632);
	export_deprecated_constant2("SI_SKF_ASPD",633);
	export_deprecated_constant2("SI_SKF_ATK",634);
	export_deprecated_constant2("SI_SKF_MATK",635);
	export_deprecated_constant2("SI_REWARD_PLUSONLYJOBEXP",636);
	export_deprecated_constant2("SI_HANDICAPSTATE_NORECOVER",637);
	export_deprecated_constant2("SI_SET_NUM_DEF",638);
	export_deprecated_constant2("SI_SET_NUM_MDEF",639);
	export_deprecated_constant2("SI_SET_PER_DEF",640);
	export_deprecated_constant2("SI_SET_PER_MDEF",641);
	export_deprecated_constant2("SI_PARTYBOOKING_SEARCH_DELAY",642);
	export_deprecated_constant2("SI_PARTYBOOKING_REGISTER_DELAY",643);
	export_deprecated_constant2("SI_PERIOD_TIME_CHECK_DETECT_SKILL",644);
	export_deprecated_constant2("SI_KO_JYUMONJIKIRI",645);
	export_deprecated_constant2("SI_MEIKYOUSISUI",646);
	export_deprecated_constant2("SI_ATTHASTE_CASH",647);
	export_deprecated_constant2("SI_EQUIPPED_DIVINE_ARMOR",648);
	export_deprecated_constant2("SI_EQUIPPED_HOLY_ARMOR",649);
	export_deprecated_constant2("SI_2011RWC",650);
	export_deprecated_constant2("SI_KYOUGAKU",651);
	export_deprecated_constant2("SI_IZAYOI",652);
	export_deprecated_constant2("SI_ZENKAI",653);
	export_deprecated_constant2("SI_KG_KAGEHUMI",654);
	export_deprecated_constant2("SI_KYOMU",655);
	export_deprecated_constant2("SI_KAGEMUSYA",656);
	export_deprecated_constant2("SI_ZANGETSU",657);
	export_deprecated_constant2("SI_PHI_DEMON",658);
	export_deprecated_constant2("SI_GENSOU",659);
	export_deprecated_constant2("SI_AKAITSUKI",660);
	export_deprecated_constant2("SI_TETANY",661);
	export_deprecated_constant2("SI_GM_BATTLE",662);
	export_deprecated_constant2("SI_GM_BATTLE2",663);
	export_deprecated_constant2("SI_2011RWC_SCROLL",664);
	export_deprecated_constant2("SI_ACTIVE_MONSTER_TRANSFORM",665);
	export_deprecated_constant2("SI_MYSTICPOWDER",666);
	export_deprecated_constant2("SI_ECLAGE_RECALL",667);
	export_deprecated_constant2("SI_ENTRY_QUEUE_APPLY_DELAY",668);
	export_deprecated_constant2("SI_REUSE_LIMIT_ECL",669);
	export_deprecated_constant2("SI_M_LIFEPOTION",670);
	export_deprecated_constant2("SI_ENTRY_QUEUE_NOTIFY_ADMISSION_TIME_OUT",671);
	export_deprecated_constant2("SI_UNKNOWN_NAME",672);
	export_deprecated_constant2("SI_ON_PUSH_CART",673);
	export_deprecated_constant2("SI_HAT_EFFECT",674);
	export_deprecated_constant2("SI_FLOWER_LEAF",675);
	export_deprecated_constant2("SI_RAY_OF_PROTECTION",676);
	export_deprecated_constant2("SI_GLASTHEIM_ATK",677);
	export_deprecated_constant2("SI_GLASTHEIM_DEF",678);
	export_deprecated_constant2("SI_GLASTHEIM_HEAL",679);
	export_deprecated_constant2("SI_GLASTHEIM_HIDDEN",680);
	export_deprecated_constant2("SI_GLASTHEIM_STATE",681);
	export_deprecated_constant2("SI_GLASTHEIM_ITEMDEF",682);
	export_deprecated_constant2("SI_GLASTHEIM_HPSP",683);
	export_deprecated_constant2("SI_HOMUN_SKILL_POSTDELAY",684);
	export_deprecated_constant2("SI_ALMIGHTY",685);
	export_deprecated_constant2("SI_GVG_GIANT",686);
	export_deprecated_constant2("SI_GVG_GOLEM",687);
	export_deprecated_constant2("SI_GVG_STUN",688);
	export_deprecated_constant2("SI_GVG_STONE",689);
	export_deprecated_constant2("SI_GVG_FREEZ",690);
	export_deprecated_constant2("SI_GVG_SLEEP",691);
	export_deprecated_constant2("SI_GVG_CURSE",692);
	export_deprecated_constant2("SI_GVG_SILENCE",693);
	export_deprecated_constant2("SI_GVG_BLIND",694);
	export_deprecated_constant2("SI_CLIENT_ONLY_EQUIP_ARROW",695);
	export_deprecated_constant2("SI_CLAN_INFO",696);
	export_deprecated_constant2("SI_JP_EVENT01",697);
	export_deprecated_constant2("SI_JP_EVENT02",698);
	export_deprecated_constant2("SI_JP_EVENT03",699);
	export_deprecated_constant2("SI_JP_EVENT04",700);
	export_deprecated_constant2("SI_TELEPORT_FIXEDCASTINGDELAY",701);
	export_deprecated_constant2("SI_GEFFEN_MAGIC1",702);
	export_deprecated_constant2("SI_GEFFEN_MAGIC2",703);
	export_deprecated_constant2("SI_GEFFEN_MAGIC3",704);
	export_deprecated_constant2("SI_QUEST_BUFF1",705);
	export_deprecated_constant2("SI_QUEST_BUFF2",706);
	export_deprecated_constant2("SI_QUEST_BUFF3",707);
	export_deprecated_constant2("SI_REUSE_LIMIT_RECALL",708);
	export_deprecated_constant2("SI_SAVEPOSITION",709);
	export_deprecated_constant2("SI_HANDICAPSTATE_ICEEXPLO",710);
	export_deprecated_constant2("SI_FENRIR_CARD",711);
	export_deprecated_constant2("SI_REUSE_LIMIT_ASPD_POTION",712);
	export_deprecated_constant2("SI_MAXPAIN",713);
	export_deprecated_constant2("SI_PC_STOP",714);
	export_deprecated_constant2("SI_FRIGG_SONG",715);
	export_deprecated_constant2("SI_OFFERTORIUM",716);
	export_deprecated_constant2("SI_TELEKINESIS_INTENSE",717);
	export_deprecated_constant2("SI_MOONSTAR",718);
	export_deprecated_constant2("SI_STRANGELIGHTS",719);
	export_deprecated_constant2("SI_FULL_THROTTLE",720);
	export_deprecated_constant2("SI_REBOUND",721);
	export_deprecated_constant2("SI_UNLIMIT",722);
	export_deprecated_constant2("SI_KINGS_GRACE",723);
	export_deprecated_constant2("SI_ITEM_ATKMAX",724);
	export_deprecated_constant2("SI_ITEM_ATKMIN",725);
	export_deprecated_constant2("SI_ITEM_MATKMAX",726);
	export_deprecated_constant2("SI_ITEM_MATKMIN",727);
	export_deprecated_constant2("SI_SUPER_STAR",728);
	export_deprecated_constant2("SI_HIGH_RANKER",729);
	export_deprecated_constant2("SI_DARKCROW",730);
	export_deprecated_constant2("SI_2013_VALENTINE1",731);
	export_deprecated_constant2("SI_2013_VALENTINE2",732);
	export_deprecated_constant2("SI_2013_VALENTINE3",733);
	export_deprecated_constant2("SI_ILLUSIONDOPING",734);
	export_deprecated_constant2("SI_WIDEWEB",735);
	export_deprecated_constant2("SI_CHILL",736);
	export_deprecated_constant2("SI_BURNT",737);
	export_deprecated_constant2("SI_PCCAFE_PLAY_TIME",738);
	export_deprecated_constant2("SI_TWISTED_TIME",739);
	export_deprecated_constant2("SI_FLASHCOMBO",740);
	export_deprecated_constant2("SI_JITTER_BUFF1",741);
	export_deprecated_constant2("SI_JITTER_BUFF2",742);
	export_deprecated_constant2("SI_JITTER_BUFF3",743);
	export_deprecated_constant2("SI_JITTER_BUFF4",744);
	export_deprecated_constant2("SI_JITTER_BUFF5",745);
	export_deprecated_constant2("SI_JITTER_BUFF6",746);
	export_deprecated_constant2("SI_JITTER_BUFF7",747);
	export_deprecated_constant2("SI_JITTER_BUFF8",748);
	export_deprecated_constant2("SI_JITTER_BUFF9",749);
	export_deprecated_constant2("SI_JITTER_BUFF10",750);
	export_deprecated_constant2("SI_CUP_OF_BOZA",751);
	export_deprecated_constant2("SI_B_TRAP",752);
	export_deprecated_constant2("SI_E_CHAIN",753);
	export_deprecated_constant2("SI_E_QD_SHOT_READY",754);
	export_deprecated_constant2("SI_C_MARKER",755);
	export_deprecated_constant2("SI_H_MINE",756);
	export_deprecated_constant2("SI_H_MINE_SPLASH",757);
	export_deprecated_constant2("SI_P_ALTER",758);
	export_deprecated_constant2("SI_HEAT_BARREL",759);
	export_deprecated_constant2("SI_ANTI_M_BLAST",760);
	export_deprecated_constant2("SI_SLUGSHOT",761);
	export_deprecated_constant2("SI_SWORDCLAN",762);
	export_deprecated_constant2("SI_ARCWANDCLAN",763);
	export_deprecated_constant2("SI_GOLDENMACECLAN",764);
	export_deprecated_constant2("SI_CROSSBOWCLAN",765);
	export_deprecated_constant2("SI_PACKING_ENVELOPE1",766);
	export_deprecated_constant2("SI_PACKING_ENVELOPE2",767);
	export_deprecated_constant2("SI_PACKING_ENVELOPE3",768);
	export_deprecated_constant2("SI_PACKING_ENVELOPE4",769);
	export_deprecated_constant2("SI_PACKING_ENVELOPE5",770);
	export_deprecated_constant2("SI_PACKING_ENVELOPE6",771);
	export_deprecated_constant2("SI_PACKING_ENVELOPE7",772);
	export_deprecated_constant2("SI_PACKING_ENVELOPE8",773);
	export_deprecated_constant2("SI_PACKING_ENVELOPE9",774);
	export_deprecated_constant2("SI_PACKING_ENVELOPE10",775);
	export_deprecated_constant2("SI_GLASTHEIM_TRANS",776);
	export_deprecated_constant2("SI_ZONGZI_POUCH_TRANS",777);
	export_deprecated_constant2("SI_HEAT_BARREL_AFTER",778);
	export_deprecated_constant2("SI_DECORATION_OF_MUSIC",779);
	export_deprecated_constant2("SI_OVERSEAEXPUP",780);
	export_deprecated_constant2("SI_CLOWN_N_GYPSY_CARD",781);
	export_deprecated_constant2("SI_OPEN_NPC_MARKET",782);
	export_deprecated_constant2("SI_BEEF_RIB_STEW",783);
	export_deprecated_constant2("SI_PORK_RIB_STEW",784);
	export_deprecated_constant2("SI_CHUSEOK_MONDAY",785);
	export_deprecated_constant2("SI_CHUSEOK_TUESDAY",786);
	export_deprecated_constant2("SI_CHUSEOK_WEDNESDAY",787);
	export_deprecated_constant2("SI_CHUSEOK_THURSDAY",788);
	export_deprecated_constant2("SI_CHUSEOK_FRIDAY",789);
	export_deprecated_constant2("SI_CHUSEOK_WEEKEND",790);
	export_deprecated_constant2("SI_ALL_LIGHTGUARD",791);
	export_deprecated_constant2("SI_ALL_LIGHTGUARD_COOL_TIME",792);
	export_deprecated_constant2("SI_MTF_MHP",793);
	export_deprecated_constant2("SI_MTF_MSP",794);
	export_deprecated_constant2("SI_MTF_PUMPKIN",795);
	export_deprecated_constant2("SI_MTF_HITFLEE",796);
	export_deprecated_constant2("SI_MTF_CRIDAMAGE2",797);
	export_deprecated_constant2("SI_MTF_SPDRAIN",798);
	export_deprecated_constant2("SI_ACUO_MINT_GUM",799);
	export_deprecated_constant2("SI_S_HEALPOTION",800);
	export_deprecated_constant2("SI_REUSE_LIMIT_S_HEAL_POTION",801);
	export_deprecated_constant2("SI_PLAYTIME_STATISTICS",802);
	export_deprecated_constant2("SI_GN_CHANGEMATERIAL_OPERATOR",803);
	export_deprecated_constant2("SI_GN_MIX_COOKING_OPERATOR",804);
	export_deprecated_constant2("SI_GN_MAKEBOMB_OPERATOR",805);
	export_deprecated_constant2("SI_GN_S_PHARMACY_OPERATOR",806);
	export_deprecated_constant2("SI_SO_EL_ANALYSIS_DISASSEMBLY_OPERATOR",807);
	export_deprecated_constant2("SI_SO_EL_ANALYSIS_COMBINATION_OPERATOR",808);
	export_deprecated_constant2("SI_NC_MAGICDECOY_OPERATOR",809);
	export_deprecated_constant2("SI_GUILD_STORAGE",810);
	export_deprecated_constant2("SI_GC_POISONINGWEAPON_OPERATOR",811);
	export_deprecated_constant2("SI_WS_WEAPONREFINE_OPERATOR",812);
	export_deprecated_constant2("SI_BS_REPAIRWEAPON_OPERATOR",813);
	export_deprecated_constant2("SI_GET_MAILBOX",814);
	export_deprecated_constant2("SI_JUMPINGCLAN",815);
	export_deprecated_constant2("SI_JP_OTP",816);
	export_deprecated_constant2("SI_HANDICAPTOLERANCE_LEVELGAP",817);
	export_deprecated_constant2("SI_MTF_RANGEATK2",818);
	export_deprecated_constant2("SI_MTF_ASPD2",819);
	export_deprecated_constant2("SI_MTF_MATK2",820);
	export_deprecated_constant2("SI_SHOW_NPCHPBAR",821);
	export_deprecated_constant2("SI_FLOWERSMOKE",822);
	export_deprecated_constant2("SI_FSTONE",823);
	export_deprecated_constant2("SI_DAILYSENDMAILCNT",824);
	export_deprecated_constant2("SI_QSCARABA",825);
	export_deprecated_constant2("SI_LJOSALFAR",826);
	export_deprecated_constant2("SI_PAD_READER_KNIGHT",827);
	export_deprecated_constant2("SI_PAD_READER_CRUSADER",828);
	export_deprecated_constant2("SI_PAD_READER_BLACKSMITH",829);
	export_deprecated_constant2("SI_PAD_READER_ALCHEMIST",830);
	export_deprecated_constant2("SI_PAD_READER_ASSASSIN",831);
	export_deprecated_constant2("SI_PAD_READER_ROGUE",832);
	export_deprecated_constant2("SI_PAD_READER_WIZARD",833);
	export_deprecated_constant2("SI_PAD_READER_SAGE",834);
	export_deprecated_constant2("SI_PAD_READER_PRIEST",835);
	export_deprecated_constant2("SI_PAD_READER_MONK",836);
	export_deprecated_constant2("SI_PAD_READER_HUNTER",837);
	export_deprecated_constant2("SI_PAD_READER_BARD",838);
	export_deprecated_constant2("SI_PAD_READER_DANCER",839);
	export_deprecated_constant2("SI_PAD_READER_TAEKWON",840);
	export_deprecated_constant2("SI_PAD_READER_NINJA",841);
	export_deprecated_constant2("SI_PAD_READER_GUNSLINGER",842);
	export_deprecated_constant2("SI_PAD_READER_SUPERNOVICE",843);
	export_deprecated_constant2("SI_ESSENCE_OF_TIME",844);
	export_deprecated_constant2("SI_MINIGAME_ROULETTE",845);
	export_deprecated_constant2("SI_MINIGAME_GOLD_POINT",846);
	export_deprecated_constant2("SI_MINIGAME_SILVER_POINT",847);
	export_deprecated_constant2("SI_MINIGAME_BRONZE_POINT",848);
	export_deprecated_constant2("SI_HAPPINESS_STAR",849);
	export_deprecated_constant2("SI_SUMMEREVENT01",850);
	export_deprecated_constant2("SI_SUMMEREVENT02",851);
	export_deprecated_constant2("SI_SUMMEREVENT03",852);
	export_deprecated_constant2("SI_SUMMEREVENT04",853);
	export_deprecated_constant2("SI_SUMMEREVENT05",854);
	export_deprecated_constant2("SI_MINIGAME_ROULETTE_BONUS_ITEM",855);
	export_deprecated_constant2("SI_DRESS_UP",856);
	export_deprecated_constant2("SI_MAPLE_FALLS",857);
	export_deprecated_constant2("SI_ALL_NIFLHEIM_RECALL",858);
	export_deprecated_constant2("SI_MTF_MARIONETTE",860);
	export_deprecated_constant2("SI_MTF_LUDE",861);
	export_deprecated_constant2("SI_MTF_CRUISER",862);
	export_deprecated_constant2("SI_MERMAID_LONGING",863);
	export_deprecated_constant2("SI_MAGICAL_FEATHER",864);
	export_deprecated_constant2("SI_DRACULA_CARD",865);
	export_deprecated_constant2("SI_LIMIT_POWER_BOOSTER",867);
	export_deprecated_constant2("SI_TIME_ACCESSORY",872);
	export_deprecated_constant2("SI_EP16_DEF",873);
	export_deprecated_constant2("SI_NORMAL_ATKED_SP",874);
	export_deprecated_constant2("SI_BODYSTATE_STONECURSE",875);
	export_deprecated_constant2("SI_BODYSTATE_FREEZING",876);
	export_deprecated_constant2("SI_BODYSTATE_STUN",877);
	export_deprecated_constant2("SI_BODYSTATE_SLEEP",878);
	export_deprecated_constant2("SI_BODYSTATE_UNDEAD",879);
	export_deprecated_constant2("SI_BODYSTATE_STONECURSE_ING",880);
	export_deprecated_constant2("SI_BODYSTATE_BURNNING",881);
	export_deprecated_constant2("SI_BODYSTATE_IMPRISON",882);
	export_deprecated_constant2("SI_HEALTHSTATE_POISON",883);
	export_deprecated_constant2("SI_HEALTHSTATE_CURSE",884);
	export_deprecated_constant2("SI_HEALTHSTATE_SILENCE",885);
	export_deprecated_constant2("SI_HEALTHSTATE_CONFUSION",886);
	export_deprecated_constant2("SI_HEALTHSTATE_BLIND",887);
	export_deprecated_constant2("SI_HEALTHSTATE_ANGELUS",888);
	export_deprecated_constant2("SI_HEALTHSTATE_BLOODING",889);
	export_deprecated_constant2("SI_HEALTHSTATE_HEAVYPOISON",890);
	export_deprecated_constant2("SI_HEALTHSTATE_FEAR",891);
	export_deprecated_constant2("SI_CHERRY_BLOSSOM_CAKE",892);
	export_deprecated_constant2("SI_SU_STOOP",893);
	export_deprecated_constant2("SI_CATNIPPOWDER",894);
	export_deprecated_constant2("SI_SV_ROOTTWIST",896);
	export_deprecated_constant2("SI_ATTACK_PROPERTY_NOTHING",897);
	export_deprecated_constant2("SI_ATTACK_PROPERTY_WATER",898);
	export_deprecated_constant2("SI_ATTACK_PROPERTY_GROUND",899);
	export_deprecated_constant2("SI_ATTACK_PROPERTY_FIRE",900);
	export_deprecated_constant2("SI_ATTACK_PROPERTY_WIND",901);
	export_deprecated_constant2("SI_ATTACK_PROPERTY_POISON",902);
	export_deprecated_constant2("SI_ATTACK_PROPERTY_SAINT",903);
	export_deprecated_constant2("SI_ATTACK_PROPERTY_DARKNESS",904);
	export_deprecated_constant2("SI_ATTACK_PROPERTY_TELEKINESIS",905);
	export_deprecated_constant2("SI_ATTACK_PROPERTY_UNDEAD",906);
	export_deprecated_constant2("SI_RESIST_PROPERTY_NOTHING",907);
	export_deprecated_constant2("SI_RESIST_PROPERTY_WATER",908);
	export_deprecated_constant2("SI_RESIST_PROPERTY_GROUND",909);
	export_deprecated_constant2("SI_RESIST_PROPERTY_FIRE",910);
	export_deprecated_constant2("SI_RESIST_PROPERTY_WIND",911);
	export_deprecated_constant2("SI_RESIST_PROPERTY_POISON",912);
	export_deprecated_constant2("SI_RESIST_PROPERTY_SAINT",913);
	export_deprecated_constant2("SI_RESIST_PROPERTY_DARKNESS",914);
	export_deprecated_constant2("SI_RESIST_PROPERTY_TELEKINESIS",915);
	export_deprecated_constant2("SI_RESIST_PROPERTY_UNDEAD",916);
	export_deprecated_constant2("SI_BITESCAR",917);
	export_deprecated_constant2("SI_ARCLOUSEDASH",918);
	export_deprecated_constant2("SI_TUNAPARTY",919);
	export_deprecated_constant2("SI_SHRIMP",920);
	export_deprecated_constant2("SI_FRESHSHRIMP",921);
	export_deprecated_constant2("SI_PERIOD_RECEIVEITEM",922);
	export_deprecated_constant2("SI_PERIOD_PLUSEXP",923);
	export_deprecated_constant2("SI_PERIOD_PLUSJOBEXP",924);
	export_deprecated_constant2("SI_RUNEHELM",925);
	export_deprecated_constant2("SI_HELM_VERKANA",926);
	export_deprecated_constant2("SI_HELM_RHYDO",927);
	export_deprecated_constant2("SI_HELM_TURISUS",928);
	export_deprecated_constant2("SI_HELM_HAGALAS",929);
	export_deprecated_constant2("SI_HELM_ISIA",930);
	export_deprecated_constant2("SI_HELM_ASIR",931);
	export_deprecated_constant2("SI_HELM_URJ",932);
	export_deprecated_constant2("SI_SUHIDE",933);
	export_deprecated_constant2("SI_DORAM_BUF_01",935);
	export_deprecated_constant2("SI_DORAM_BUF_02",936);
	export_deprecated_constant2("SI_SPRITEMABLE",937);
	export_deprecated_constant2("SI_AID_PERIOD_RECEIVEITEM",938);
	export_deprecated_constant2("SI_AID_PERIOD_PLUSEXP",939);
	export_deprecated_constant2("SI_AID_PERIOD_PLUSJOBEXP",940);
	export_deprecated_constant2("SI_AID_PERIOD_DEADPENALTY",941);
	export_deprecated_constant2("SI_AID_PERIOD_ADDSTOREITEMCOUNT",942);
	export_deprecated_constant2("SI_HISS",950);
	export_deprecated_constant2("SI_NYANGGRASS",952);
	export_deprecated_constant2("SI_CHATTERING",953);
	export_deprecated_constant2("SI_GROOMING",961);
	export_deprecated_constant2("SI_PROTECTIONOFSHRIMP",962);
	export_deprecated_constant2("SI_EP16_2_BUFF_SS",963);
	export_deprecated_constant2("SI_EP16_2_BUFF_SC",964);
	export_deprecated_constant2("SI_EP16_2_BUFF_AC",965);
	export_deprecated_constant2("SI_GS_MAGICAL_BULLET",966);
	export_deprecated_constant2("SI_FALLEN_ANGEL",976);
	export_deprecated_constant2("SI_BLAZE_BEAD",979);
	export_deprecated_constant2("SI_FROZEN_BEAD",980);
	export_deprecated_constant2("SI_BREEZE_BEAD",981);
	export_deprecated_constant2("SI_AID_PERIOD_RECEIVEITEM_2ND",983);
	export_deprecated_constant2("SI_AID_PERIOD_PLUSEXP_2ND",984);
	export_deprecated_constant2("SI_AID_PERIOD_PLUSJOBEXP_2ND",985);
	export_deprecated_constant2("SI_PRONTERA_JP",986);
	export_deprecated_constant2("SI_GLOOM_CARD",988);
	export_deprecated_constant2("SI_PHARAOH_CARD",989);
	export_deprecated_constant2("SI_KIEL_CARD",990);
	export_deprecated_constant2("SI_CHEERUP",992);
	export_deprecated_constant2("SI_S_MANAPOTION",995);
	export_deprecated_constant2("SI_M_DEFSCROLL",996);

/// Do not modify code below this, until the end of the API hook, since it will be automatically generated again
/// @APIHOOK_START(EFST_CONST)
	export_constant(EFST_BLANK);
	export_constant(EFST_PROVOKE);
	export_constant(EFST_ENDURE);
	export_constant(EFST_TWOHANDQUICKEN);
	export_constant(EFST_CONCENTRATION);
	export_constant(EFST_HIDING);
	export_constant(EFST_CLOAKING);
	export_constant(EFST_ENCHANTPOISON);
	export_constant(EFST_POISONREACT);
	export_constant(EFST_QUAGMIRE);
	export_constant(EFST_ANGELUS);
	export_constant(EFST_BLESSING);
	export_constant(EFST_CRUCIS);
	export_constant(EFST_INC_AGI);
	export_constant(EFST_DEC_AGI);
	export_constant(EFST_SLOWPOISON);
	export_constant(EFST_IMPOSITIO);
	export_constant(EFST_SUFFRAGIUM);
	export_constant(EFST_ASPERSIO);
	export_constant(EFST_BENEDICTIO);
	export_constant(EFST_KYRIE);
	export_constant(EFST_MAGNIFICAT);
	export_constant(EFST_GLORIA);
	export_constant(EFST_LEXAETERNA);
	export_constant(EFST_ADRENALINE);
	export_constant(EFST_WEAPONPERFECT);
	export_constant(EFST_OVERTHRUST);
	export_constant(EFST_MAXIMIZE);
	export_constant(EFST_RIDING);
	export_constant(EFST_FALCON);
	export_constant(EFST_TRICKDEAD);
	export_constant(EFST_SHOUT);
	export_constant(EFST_ENERGYCOAT);
	export_constant(EFST_BROKENARMOR);
	export_constant(EFST_BROKENWEAPON);
	export_constant(EFST_ILLUSION);
	export_constant(EFST_WEIGHTOVER50);
	export_constant(EFST_WEIGHTOVER90);
	export_constant(EFST_ATTHASTE_POTION1);
	export_constant(EFST_ATTHASTE_POTION2);
	export_constant(EFST_ATTHASTE_POTION3);
	export_constant(EFST_ATTHASTE_INFINITY);
	export_constant(EFST_MOVHASTE_POTION);
	export_constant(EFST_MOVHASTE_INFINITY);
	export_constant(EFST_AUTOCOUNTER);
	export_constant(EFST_SPLASHER);
	export_constant(EFST_ANKLESNARE);
	export_constant(EFST_POSTDELAY);
	export_constant(EFST_NOACTION);
	export_constant(EFST_IMPOSSIBLEPICKUP);
	export_constant(EFST_BARRIER);
	export_constant(EFST_NOEQUIPWEAPON);
	export_constant(EFST_NOEQUIPSHIELD);
	export_constant(EFST_NOEQUIPARMOR);
	export_constant(EFST_NOEQUIPHELM);
	export_constant(EFST_PROTECTWEAPON);
	export_constant(EFST_PROTECTSHIELD);
	export_constant(EFST_PROTECTARMOR);
	export_constant(EFST_PROTECTHELM);
	export_constant(EFST_AUTOGUARD);
	export_constant(EFST_REFLECTSHIELD);
	export_constant(EFST_DEVOTION);
	export_constant(EFST_PROVIDENCE);
	export_constant(EFST_DEFENDER);
	export_constant(EFST_MAGICROD);
	export_constant(EFST_WEAPONPROPERTY);
	export_constant(EFST_AUTOSPELL);
	export_constant(EFST_SPECIALZONE);
	export_constant(EFST_MASK);
	export_constant(EFST_SPEARQUICKEN);
	export_constant(EFST_BDPLAYING);
	export_constant(EFST_WHISTLE);
	export_constant(EFST_ASSASSINCROSS);
	export_constant(EFST_POEMBRAGI);
	export_constant(EFST_APPLEIDUN);
	export_constant(EFST_HUMMING);
	export_constant(EFST_DONTFORGETME);
	export_constant(EFST_FORTUNEKISS);
	export_constant(EFST_SERVICEFORYOU);
	export_constant(EFST_RICHMANKIM);
	export_constant(EFST_ETERNALCHAOS);
	export_constant(EFST_DRUMBATTLEFIELD);
	export_constant(EFST_RINGNIBELUNGEN);
	export_constant(EFST_ROKISWEIL);
	export_constant(EFST_INTOABYSS);
	export_constant(EFST_SIEGFRIED);
	export_constant(EFST_BLADESTOP);
	export_constant(EFST_EXPLOSIONSPIRITS);
	export_constant(EFST_STEELBODY);
	export_constant(EFST_EXTREMITYFIST);
	export_constant(EFST_COMBOATTACK);
	export_constant(EFST_PROPERTYFIRE);
	export_constant(EFST_PROPERTYWATER);
	export_constant(EFST_PROPERTYWIND);
	export_constant(EFST_PROPERTYGROUND);
	export_constant(EFST_MAGICATTACK);
	export_constant(EFST_STOP);
	export_constant(EFST_WEAPONBRAKER);
	export_constant(EFST_PROPERTYUNDEAD);
	export_constant(EFST_POWERUP);
	export_constant(EFST_AGIUP);
	export_constant(EFST_SIEGEMODE);
	export_constant(EFST_INVISIBLE);
	export_constant(EFST_STATUSONE);
	export_constant(EFST_AURABLADE);
	export_constant(EFST_PARRYING);
	export_constant(EFST_LKCONCENTRATION);
	export_constant(EFST_TENSIONRELAX);
	export_constant(EFST_BERSERK);
	export_constant(EFST_SACRIFICE);
	export_constant(EFST_GOSPEL);
	export_constant(EFST_ASSUMPTIO);
	export_constant(EFST_BASILICA);
	export_constant(EFST_GROUNDMAGIC);
	export_constant(EFST_MAGICPOWER);
	export_constant(EFST_EDP);
	export_constant(EFST_TRUESIGHT);
	export_constant(EFST_WINDWALK);
	export_constant(EFST_MELTDOWN);
	export_constant(EFST_CARTBOOST);
	export_constant(EFST_CHASEWALK);
	export_constant(EFST_SWORDREJECT);
	export_constant(EFST_MARIONETTE_MASTER);
	export_constant(EFST_MARIONETTE);
	export_constant(EFST_MOON);
	export_constant(EFST_BLOODING);
	export_constant(EFST_JOINTBEAT);
	export_constant(EFST_MINDBREAKER);
	export_constant(EFST_MEMORIZE);
	export_constant(EFST_FOGWALL);
	export_constant(EFST_SPIDERWEB);
	export_constant(EFST_PROTECTEXP);
	export_constant(EFST_SUB_WEAPONPROPERTY);
	export_constant(EFST_AUTOBERSERK);
	export_constant(EFST_RUN);
	export_constant(EFST_TING);
	export_constant(EFST_STORMKICK_ON);
	export_constant(EFST_STORMKICK_READY);
	export_constant(EFST_DOWNKICK_ON);
	export_constant(EFST_DOWNKICK_READY);
	export_constant(EFST_TURNKICK_ON);
	export_constant(EFST_TURNKICK_READY);
	export_constant(EFST_COUNTER_ON);
	export_constant(EFST_COUNTER_READY);
	export_constant(EFST_DODGE_ON);
	export_constant(EFST_DODGE_READY);
	export_constant(EFST_STRUP);
	export_constant(EFST_PROPERTYDARK);
	export_constant(EFST_ADRENALINE2);
	export_constant(EFST_PROPERTYTELEKINESIS);
	export_constant(EFST_SOULLINK);
	export_constant(EFST_PLUSATTACKPOWER);
	export_constant(EFST_PLUSMAGICPOWER);
	export_constant(EFST_DEVIL1);
	export_constant(EFST_KAITE);
	export_constant(EFST_SWOO);
	export_constant(EFST_STAR2);
	export_constant(EFST_KAIZEL);
	export_constant(EFST_KAAHI);
	export_constant(EFST_KAUPE);
	export_constant(EFST_SMA_READY);
	export_constant(EFST_SKE);
	export_constant(EFST_ONEHANDQUICKEN);
	export_constant(EFST_FRIEND);
	export_constant(EFST_FRIENDUP);
	export_constant(EFST_SG_WARM);
	export_constant(EFST_SG_SUN_WARM);
	export_constant(EFST_SG_MOON_WARM);
	export_constant(EFST_SG_STAR_WARM);
	export_constant(EFST_EMOTION);
	export_constant(EFST_SUN_COMFORT);
	export_constant(EFST_MOON_COMFORT);
	export_constant(EFST_STAR_COMFORT);
	export_constant(EFST_EXPUP);
	export_constant(EFST_GDSKILL_BATTLEORDER);
	export_constant(EFST_GDSKILL_REGENERATION);
	export_constant(EFST_GDSKILL_POSTDELAY);
	export_constant(EFST_RESISTHANDICAP);
	export_constant(EFST_MAXHPPERCENT);
	export_constant(EFST_MAXSPPERCENT);
	export_constant(EFST_DEFENCE);
	export_constant(EFST_SLOWDOWN);
	export_constant(EFST_PRESERVE);
	export_constant(EFST_CHASEWALK2);
	export_constant(EFST_NOT_EXTREMITYFIST);
	export_constant(EFST_CLAIRVOYANCE);
	export_constant(EFST_MOVESLOW_POTION);
	export_constant(EFST_DOUBLECASTING);
	export_constant(EFST_GRAVITATION);
	export_constant(EFST_OVERTHRUSTMAX);
	export_constant(EFST_LONGING);
	export_constant(EFST_HERMODE);
	export_constant(EFST_TAROTCARD);
	export_constant(EFST_HLIF_AVOID);
	export_constant(EFST_HFLI_FLEET);
	export_constant(EFST_HFLI_SPEED);
	export_constant(EFST_HLIF_CHANGE);
	export_constant(EFST_HAMI_BLOODLUST);
	export_constant(EFST_CR_SHRINK);
	export_constant(EFST_WZ_SIGHTBLASTER);
	export_constant(EFST_DC_WINKCHARM);
	export_constant(EFST_RG_CCONFINE_M);
	export_constant(EFST_RG_CCONFINE_S);
	export_constant(EFST_DISABLEMOVE);
	export_constant(EFST_GS_MADNESSCANCEL);
	export_constant(EFST_GS_GATLINGFEVER);
	export_constant(EFST_EARTHSCROLL);
	export_constant(EFST_NJ_UTSUSEMI);
	export_constant(EFST_NJ_BUNSINJYUTSU);
	export_constant(EFST_NJ_NEN);
	export_constant(EFST_GS_ADJUSTMENT);
	export_constant(EFST_GS_ACCURACY);
	export_constant(EFST_NJ_SUITON);
	export_constant(EFST_PET);
	export_constant(EFST_MENTAL);
	export_constant(EFST_EXPMEMORY);
	export_constant(EFST_PERFORMANCE);
	export_constant(EFST_GAIN);
	export_constant(EFST_GRIFFON);
	export_constant(EFST_DRIFT);
	export_constant(EFST_WALLSHIFT);
	export_constant(EFST_REINCARNATION);
	export_constant(EFST_PATTACK);
	export_constant(EFST_PSPEED);
	export_constant(EFST_PDEFENSE);
	export_constant(EFST_PCRITICAL);
	export_constant(EFST_RANKING);
	export_constant(EFST_PTRIPLE);
	export_constant(EFST_DENERGY);
	export_constant(EFST_WAVE1);
	export_constant(EFST_WAVE2);
	export_constant(EFST_WAVE3);
	export_constant(EFST_WAVE4);
	export_constant(EFST_DAURA);
	export_constant(EFST_DFREEZER);
	export_constant(EFST_DPUNISH);
	export_constant(EFST_DBARRIER);
	export_constant(EFST_DWARNING);
	export_constant(EFST_MOUSEWHEEL);
	export_constant(EFST_DGAUGE);
	export_constant(EFST_DACCEL);
	export_constant(EFST_DBLOCK);
	export_constant(EFST_FOOD_STR);
	export_constant(EFST_FOOD_AGI);
	export_constant(EFST_FOOD_VIT);
	export_constant(EFST_FOOD_DEX);
	export_constant(EFST_FOOD_INT);
	export_constant(EFST_FOOD_LUK);
	export_constant(EFST_FOOD_BASICAVOIDANCE);
	export_constant(EFST_FOOD_BASICHIT);
	export_constant(EFST_FOOD_CRITICALSUCCESSVALUE);
	export_constant(EFST_CASH_PLUSEXP);
	export_constant(EFST_CASH_DEATHPENALTY);
	export_constant(EFST_CASH_RECEIVEITEM);
	export_constant(EFST_CASH_BOSS_ALARM);
	export_constant(EFST_DA_ENERGY);
	export_constant(EFST_DA_FIRSTSLOT);
	export_constant(EFST_DA_HEADDEF);
	export_constant(EFST_DA_SPACE);
	export_constant(EFST_DA_TRANSFORM);
	export_constant(EFST_DA_ITEMREBUILD);
	export_constant(EFST_DA_ILLUSION);
	export_constant(EFST_DA_DARKPOWER);
	export_constant(EFST_DA_EARPLUG);
	export_constant(EFST_DA_CONTRACT);
	export_constant(EFST_DA_BLACK);
	export_constant(EFST_DA_MAGICCART);
	export_constant(EFST_CRYSTAL);
	export_constant(EFST_DA_REBUILD);
	export_constant(EFST_DA_EDARKNESS);
	export_constant(EFST_DA_EGUARDIAN);
	export_constant(EFST_DA_TIMEOUT);
	export_constant(EFST_FOOD_STR_CASH);
	export_constant(EFST_FOOD_AGI_CASH);
	export_constant(EFST_FOOD_VIT_CASH);
	export_constant(EFST_FOOD_DEX_CASH);
	export_constant(EFST_FOOD_INT_CASH);
	export_constant(EFST_FOOD_LUK_CASH);
	export_constant(EFST_MER_FLEE);
	export_constant(EFST_MER_ATK);
	export_constant(EFST_MER_HP);
	export_constant(EFST_MER_SP);
	export_constant(EFST_MER_HIT);
	export_constant(EFST_SLOWCAST);
	export_constant(EFST_MAGICMIRROR);
	export_constant(EFST_STONESKIN);
	export_constant(EFST_ANTIMAGIC);
	export_constant(EFST_CRITICALWOUND);
	export_constant(EFST_NPC_DEFENDER);
	export_constant(EFST_NOACTION_WAIT);
	export_constant(EFST_MOVHASTE_HORSE);
	export_constant(EFST_PROTECT_DEF);
	export_constant(EFST_PROTECT_MDEF);
	export_constant(EFST_HEALPLUS);
	export_constant(EFST_S_LIFEPOTION);
	export_constant(EFST_L_LIFEPOTION);
	export_constant(EFST_CRITICALPERCENT);
	export_constant(EFST_PLUSAVOIDVALUE);
	export_constant(EFST_ATKER_ASPD);
	export_constant(EFST_TARGET_ASPD);
	export_constant(EFST_ATKER_MOVESPEED);
	export_constant(EFST_ATKER_BLOOD);
	export_constant(EFST_TARGET_BLOOD);
	export_constant(EFST_ARMOR_PROPERTY);
	export_constant(EFST_REUSE_LIMIT_A);
	export_constant(EFST_HELLPOWER);
	export_constant(EFST_STEAMPACK);
	export_constant(EFST_REUSE_LIMIT_B);
	export_constant(EFST_REUSE_LIMIT_C);
	export_constant(EFST_REUSE_LIMIT_D);
	export_constant(EFST_REUSE_LIMIT_E);
	export_constant(EFST_REUSE_LIMIT_F);
	export_constant(EFST_INVINCIBLE);
	export_constant(EFST_CASH_PLUSONLYJOBEXP);
	export_constant(EFST_PARTYFLEE);
	export_constant(EFST_ANGEL_PROTECT);
	export_constant(EFST_ENDURE_MDEF);
	export_constant(EFST_ENCHANTBLADE);
	export_constant(EFST_DEATHBOUND);
	export_constant(EFST_REFRESH);
	export_constant(EFST_GIANTGROWTH);
	export_constant(EFST_STONEHARDSKIN);
	export_constant(EFST_VITALITYACTIVATION);
	export_constant(EFST_FIGHTINGSPIRIT);
	export_constant(EFST_ABUNDANCE);
	export_constant(EFST_REUSE_MILLENNIUMSHIELD);
	export_constant(EFST_REUSE_CRUSHSTRIKE);
	export_constant(EFST_REUSE_REFRESH);
	export_constant(EFST_REUSE_STORMBLAST);
	export_constant(EFST_VENOMIMPRESS);
	export_constant(EFST_EPICLESIS);
	export_constant(EFST_ORATIO);
	export_constant(EFST_LAUDAAGNUS);
	export_constant(EFST_LAUDARAMUS);
	export_constant(EFST_CLOAKINGEXCEED);
	export_constant(EFST_HALLUCINATIONWALK);
	export_constant(EFST_HALLUCINATIONWALK_POSTDELAY);
	export_constant(EFST_RENOVATIO);
	export_constant(EFST_WEAPONBLOCKING);
	export_constant(EFST_WEAPONBLOCKING_POSTDELAY);
	export_constant(EFST_ROLLINGCUTTER);
	export_constant(EFST_EXPIATIO);
	export_constant(EFST_POISONINGWEAPON);
	export_constant(EFST_TOXIN);
	export_constant(EFST_PARALYSE);
	export_constant(EFST_VENOMBLEED);
	export_constant(EFST_MAGICMUSHROOM);
	export_constant(EFST_DEATHHURT);
	export_constant(EFST_PYREXIA);
	export_constant(EFST_OBLIVIONCURSE);
	export_constant(EFST_LEECHESEND);
	export_constant(EFST_DUPLELIGHT);
	export_constant(EFST_FROSTMISTY);
	export_constant(EFST_FEARBREEZE);
	export_constant(EFST_ELECTRICSHOCKER);
	export_constant(EFST_MARSHOFABYSS);
	export_constant(EFST_RECOGNIZEDSPELL);
	export_constant(EFST_STASIS);
	export_constant(EFST_WUGRIDER);
	export_constant(EFST_WUGDASH);
	export_constant(EFST_WUGBITE);
	export_constant(EFST_CAMOUFLAGE);
	export_constant(EFST_ACCELERATION);
	export_constant(EFST_HOVERING);
	export_constant(EFST_SUMMON1);
	export_constant(EFST_SUMMON2);
	export_constant(EFST_SUMMON3);
	export_constant(EFST_SUMMON4);
	export_constant(EFST_SUMMON5);
	export_constant(EFST_MVPCARD_TAOGUNKA);
	export_constant(EFST_MVPCARD_MISTRESS);
	export_constant(EFST_MVPCARD_ORCHERO);
	export_constant(EFST_MVPCARD_ORCLORD);
	export_constant(EFST_OVERHEAT_LIMITPOINT);
	export_constant(EFST_OVERHEAT);
	export_constant(EFST_SHAPESHIFT);
	export_constant(EFST_INFRAREDSCAN);
	export_constant(EFST_MAGNETICFIELD);
	export_constant(EFST_NEUTRALBARRIER);
	export_constant(EFST_NEUTRALBARRIER_MASTER);
	export_constant(EFST_STEALTHFIELD);
	export_constant(EFST_STEALTHFIELD_MASTER);
	export_constant(EFST_MANU_ATK);
	export_constant(EFST_MANU_DEF);
	export_constant(EFST_SPL_ATK);
	export_constant(EFST_SPL_DEF);
	export_constant(EFST_REPRODUCE);
	export_constant(EFST_MANU_MATK);
	export_constant(EFST_SPL_MATK);
	export_constant(EFST_STR_SCROLL);
	export_constant(EFST_INT_SCROLL);
	export_constant(EFST_LG_REFLECTDAMAGE);
	export_constant(EFST_FORCEOFVANGUARD);
	export_constant(EFST_BUCHEDENOEL);
	export_constant(EFST_AUTOSHADOWSPELL);
	export_constant(EFST_SHADOWFORM);
	export_constant(EFST_RAID);
	export_constant(EFST_SHIELDSPELL_DEF);
	export_constant(EFST_SHIELDSPELL_MDEF);
	export_constant(EFST_SHIELDSPELL_REF);
	export_constant(EFST_BODYPAINT);
	export_constant(EFST_EXEEDBREAK);
	export_constant(EFST_ADORAMUS);
	export_constant(EFST_PRESTIGE);
	export_constant(EFST_INVISIBILITY);
	export_constant(EFST_DEADLYINFECT);
	export_constant(EFST_BANDING);
	export_constant(EFST_EARTHDRIVE);
	export_constant(EFST_INSPIRATION);
	export_constant(EFST_ENERVATION);
	export_constant(EFST_GROOMY);
	export_constant(EFST_RAISINGDRAGON);
	export_constant(EFST_IGNORANCE);
	export_constant(EFST_LAZINESS);
	export_constant(EFST_LIGHTNINGWALK);
	export_constant(EFST_ACARAJE);
	export_constant(EFST_UNLUCKY);
	export_constant(EFST_CURSEDCIRCLE_ATKER);
	export_constant(EFST_CURSEDCIRCLE_TARGET);
	export_constant(EFST_WEAKNESS);
	export_constant(EFST_CRESCENTELBOW);
	export_constant(EFST_NOEQUIPACCESSARY);
	export_constant(EFST_STRIPACCESSARY);
	export_constant(EFST_MANHOLE);
	export_constant(EFST_POPECOOKIE);
	export_constant(EFST_FALLENEMPIRE);
	export_constant(EFST_GENTLETOUCH_ENERGYGAIN);
	export_constant(EFST_GENTLETOUCH_CHANGE);
	export_constant(EFST_GENTLETOUCH_REVITALIZE);
	export_constant(EFST_BLOODYLUST);
	export_constant(EFST_SWING);
	export_constant(EFST_SYMPHONY_LOVE);
	export_constant(EFST_PROPERTYWALK);
	export_constant(EFST_SPELLFIST);
	export_constant(EFST_NETHERWORLD);
	export_constant(EFST_SIREN);
	export_constant(EFST_HANDICAPSTATE_DEEP_SLEEP);
	export_constant(EFST_SIRCLEOFNATURE);
	export_constant(EFST_COLD);
	export_constant(EFST_GLOOMYDAY);
	export_constant(EFST_SONG_OF_MANA);
	export_constant(EFST_CLOUD_KILL);
	export_constant(EFST_DANCE_WITH_WUG);
	export_constant(EFST_RUSH_WINDMILL);
	export_constant(EFST_ECHOSONG);
	export_constant(EFST_HARMONIZE);
	export_constant(EFST_STRIKING);
	export_constant(EFST_WARMER);
	export_constant(EFST_MOONLIT_SERENADE);
	export_constant(EFST_SATURDAY_NIGHT_FEVER);
	export_constant(EFST_SITDOWN_FORCE);
	export_constant(EFST_ANALYZE);
	export_constant(EFST_LERADS_DEW);
	export_constant(EFST_MELODYOFSINK);
	export_constant(EFST_BEYOND_OF_WARCRY);
	export_constant(EFST_UNLIMITED_HUMMING_VOICE);
	export_constant(EFST_SPELLBOOK1);
	export_constant(EFST_SPELLBOOK2);
	export_constant(EFST_SPELLBOOK3);
	export_constant(EFST_FREEZE_SP);
	export_constant(EFST_GN_TRAINING_SWORD);
	export_constant(EFST_GN_REMODELING_CART);
	export_constant(EFST_GN_CARTBOOST);
	export_constant(EFST_FIXEDCASTINGTM_REDUCE);
	export_constant(EFST_THORNS_TRAP);
	export_constant(EFST_BLOOD_SUCKER);
	export_constant(EFST_SPORE_EXPLOSION);
	export_constant(EFST_DEMONIC_FIRE);
	export_constant(EFST_FIRE_EXPANSION_SMOKE_POWDER);
	export_constant(EFST_FIRE_EXPANSION_TEAR_GAS);
	export_constant(EFST_BLOCKING_PLAY);
	export_constant(EFST_MANDRAGORA);
	export_constant(EFST_ACTIVATE);
	export_constant(EFST_AB_SECRAMENT);
	export_constant(EFST_ASSUMPTIO2);
	export_constant(EFST_TK_SEVENWIND);
	export_constant(EFST_LIMIT_ODINS_RECALL);
	export_constant(EFST_STOMACHACHE);
	export_constant(EFST_MYSTERIOUS_POWDER);
	export_constant(EFST_MELON_BOMB);
	export_constant(EFST_BANANA_BOMB_SITDOWN_POSTDELAY);
	export_constant(EFST_PROMOTE_HEALTH_RESERCH);
	export_constant(EFST_ENERGY_DRINK_RESERCH);
	export_constant(EFST_EXTRACT_WHITE_POTION_Z);
	export_constant(EFST_VITATA_500);
	export_constant(EFST_EXTRACT_SALAMINE_JUICE);
	export_constant(EFST_BOOST500);
	export_constant(EFST_FULL_SWING_K);
	export_constant(EFST_MANA_PLUS);
	export_constant(EFST_MUSTLE_M);
	export_constant(EFST_LIFE_FORCE_F);
	export_constant(EFST_VACUUM_EXTREME);
	export_constant(EFST_SAVAGE_STEAK);
	export_constant(EFST_COCKTAIL_WARG_BLOOD);
	export_constant(EFST_MINOR_BBQ);
	export_constant(EFST_SIROMA_ICE_TEA);
	export_constant(EFST_DROCERA_HERB_STEAMED);
	export_constant(EFST_PUTTI_TAILS_NOODLES);
	export_constant(EFST_BANANA_BOMB);
	export_constant(XXX_EFST_SM_ELEMENTAL);
	export_constant(EFST_SPELLBOOK4);
	export_constant(EFST_SPELLBOOK5);
	export_constant(EFST_SPELLBOOK6);
	export_constant(EFST_SPELLBOOK7);
	export_constant(EFST_ELEMENTAL_AGGRESSIVE);
	export_constant(EFST_RETURN_TO_ELDICASTES);
	export_constant(EFST_BANDING_DEFENCE);
	export_constant(EFST_SKELSCROLL);
	export_constant(EFST_DISTRUCTIONSCROLL);
	export_constant(EFST_ROYALSCROLL);
	export_constant(EFST_IMMUNITYSCROLL);
	export_constant(EFST_MYSTICSCROLL);
	export_constant(EFST_BATTLESCROLL);
	export_constant(EFST_ARMORSCROLL);
	export_constant(EFST_FREYJASCROLL);
	export_constant(EFST_SOULSCROLL);
	export_constant(EFST_CIRCLE_OF_FIRE);
	export_constant(EFST_CIRCLE_OF_FIRE_OPTION);
	export_constant(EFST_FIRE_CLOAK);
	export_constant(EFST_FIRE_CLOAK_OPTION);
	export_constant(EFST_WATER_SCREEN);
	export_constant(EFST_WATER_SCREEN_OPTION);
	export_constant(EFST_WATER_DROP);
	export_constant(EFST_WATER_DROP_OPTION);
	export_constant(EFST_WIND_STEP);
	export_constant(EFST_WIND_STEP_OPTION);
	export_constant(EFST_WIND_CURTAIN);
	export_constant(EFST_WIND_CURTAIN_OPTION);
	export_constant(EFST_WATER_BARRIER);
	export_constant(EFST_ZEPHYR);
	export_constant(EFST_SOLID_SKIN);
	export_constant(EFST_SOLID_SKIN_OPTION);
	export_constant(EFST_STONE_SHIELD);
	export_constant(EFST_STONE_SHIELD_OPTION);
	export_constant(EFST_POWER_OF_GAIA);
	export_constant(EFST_EL_WAIT);
	export_constant(EFST_EL_PASSIVE);
	export_constant(EFST_EL_DEFENSIVE);
	export_constant(EFST_EL_OFFENSIVE);
	export_constant(EFST_EL_COST);
	export_constant(EFST_PYROTECHNIC);
	export_constant(EFST_PYROTECHNIC_OPTION);
	export_constant(EFST_HEATER);
	export_constant(EFST_HEATER_OPTION);
	export_constant(EFST_TROPIC);
	export_constant(EFST_TROPIC_OPTION);
	export_constant(EFST_AQUAPLAY);
	export_constant(EFST_AQUAPLAY_OPTION);
	export_constant(EFST_COOLER);
	export_constant(EFST_COOLER_OPTION);
	export_constant(EFST_CHILLY_AIR);
	export_constant(EFST_CHILLY_AIR_OPTION);
	export_constant(EFST_GUST);
	export_constant(EFST_GUST_OPTION);
	export_constant(EFST_BLAST);
	export_constant(EFST_BLAST_OPTION);
	export_constant(EFST_WILD_STORM);
	export_constant(EFST_WILD_STORM_OPTION);
	export_constant(EFST_PETROLOGY);
	export_constant(EFST_PETROLOGY_OPTION);
	export_constant(EFST_CURSED_SOIL);
	export_constant(EFST_CURSED_SOIL_OPTION);
	export_constant(EFST_UPHEAVAL);
	export_constant(EFST_UPHEAVAL_OPTION);
	export_constant(EFST_TIDAL_WEAPON);
	export_constant(EFST_TIDAL_WEAPON_OPTION);
	export_constant(EFST_ROCK_CRUSHER);
	export_constant(EFST_ROCK_CRUSHER_ATK);
	export_constant(EFST_FIRE_INSIGNIA);
	export_constant(EFST_WATER_INSIGNIA);
	export_constant(EFST_WIND_INSIGNIA);
	export_constant(EFST_EARTH_INSIGNIA);
	export_constant(EFST_EQUIPED_FLOOR);
	export_constant(EFST_GUARDIAN_RECALL);
	export_constant(EFST_MORA_BUFF);
	export_constant(EFST_REUSE_LIMIT_G);
	export_constant(EFST_REUSE_LIMIT_H);
	export_constant(EFST_NEEDLE_OF_PARALYZE);
	export_constant(EFST_PAIN_KILLER);
	export_constant(EFST_G_LIFEPOTION);
	export_constant(EFST_VITALIZE_POTION);
	export_constant(EFST_LIGHT_OF_REGENE);
	export_constant(EFST_OVERED_BOOST);
	export_constant(EFST_SILENT_BREEZE);
	export_constant(EFST_ODINS_POWER);
	export_constant(EFST_STYLE_CHANGE);
	export_constant(EFST_SONIC_CLAW_POSTDELAY);
	export_constant(EFST_SILVERVEIN_RUSH_POSTDELAY);
	export_constant(EFST_MIDNIGHT_FRENZY_POSTDELAY);
	export_constant(EFST_GOLDENE_FERSE);
	export_constant(EFST_ANGRIFFS_MODUS);
	export_constant(EFST_TINDER_BREAKER);
	export_constant(EFST_TINDER_BREAKER_POSTDELAY);
	export_constant(EFST_CBC);
	export_constant(EFST_CBC_POSTDELAY);
	export_constant(EFST_EQC);
	export_constant(EFST_MAGMA_FLOW);
	export_constant(EFST_GRANITIC_ARMOR);
	export_constant(EFST_PYROCLASTIC);
	export_constant(EFST_VOLCANIC_ASH);
	export_constant(EFST_SPIRITS_SAVEINFO1);
	export_constant(EFST_SPIRITS_SAVEINFO2);
	export_constant(EFST_MAGIC_CANDY);
	export_constant(EFST_SEARCH_STORE_INFO);
	export_constant(EFST_ALL_RIDING);
	export_constant(EFST_ALL_RIDING_REUSE_LIMIT);
	export_constant(EFST_MACRO);
	export_constant(EFST_MACRO_POSTDELAY);
	export_constant(EFST_BEER_BOTTLE_CAP);
	export_constant(EFST_OVERLAPEXPUP);
	export_constant(EFST_PC_IZ_DUN05);
	export_constant(EFST_CRUSHSTRIKE);
	export_constant(EFST_MONSTER_TRANSFORM);
	export_constant(EFST_SIT);
	export_constant(EFST_ONAIR);
	export_constant(EFST_MTF_ASPD);
	export_constant(EFST_MTF_RANGEATK);
	export_constant(EFST_MTF_MATK);
	export_constant(EFST_MTF_MLEATKED);
	export_constant(EFST_MTF_CRIDAMAGE);
	export_constant(EFST_REUSE_LIMIT_MTF);
	export_constant(EFST_MACRO_PERMIT);
	export_constant(EFST_MACRO_PLAY);
	export_constant(EFST_SKF_CAST);
	export_constant(EFST_SKF_ASPD);
	export_constant(EFST_SKF_ATK);
	export_constant(EFST_SKF_MATK);
	export_constant(EFST_REWARD_PLUSONLYJOBEXP);
	export_constant(EFST_HANDICAPSTATE_NORECOVER);
	export_constant(EFST_SET_NUM_DEF);
	export_constant(EFST_SET_NUM_MDEF);
	export_constant(EFST_SET_PER_DEF);
	export_constant(EFST_SET_PER_MDEF);
	export_constant(EFST_PARTYBOOKING_SEARCH_DELAY);
	export_constant(EFST_PARTYBOOKING_REGISTER_DELAY);
	export_constant(EFST_PERIOD_TIME_CHECK_DETECT_SKILL);
	export_constant(EFST_KO_JYUMONJIKIRI);
	export_constant(EFST_MEIKYOUSISUI);
	export_constant(EFST_ATTHASTE_CASH);
	export_constant(EFST_EQUIPPED_DIVINE_ARMOR);
	export_constant(EFST_EQUIPPED_HOLY_ARMOR);
	export_constant(EFST_2011RWC);
	export_constant(EFST_KYOUGAKU);
	export_constant(EFST_IZAYOI);
	export_constant(EFST_ZENKAI);
	export_constant(EFST_KG_KAGEHUMI);
	export_constant(EFST_KYOMU);
	export_constant(EFST_KAGEMUSYA);
	export_constant(EFST_ZANGETSU);
	export_constant(EFST_PHI_DEMON);
	export_constant(EFST_GENSOU);
	export_constant(EFST_AKAITSUKI);
	export_constant(EFST_TETANY);
	export_constant(EFST_GM_BATTLE);
	export_constant(EFST_GM_BATTLE2);
	export_constant(EFST_2011RWC_SCROLL);
	export_constant(EFST_ACTIVE_MONSTER_TRANSFORM);
	export_constant(EFST_MYSTICPOWDER);
	export_constant(EFST_ECLAGE_RECALL);
	export_constant(EFST_ENTRY_QUEUE_APPLY_DELAY);
	export_constant(EFST_REUSE_LIMIT_ECL);
	export_constant(EFST_M_LIFEPOTION);
	export_constant(EFST_ENTRY_QUEUE_NOTIFY_ADMISSION_TIME_OUT);
	export_constant(EFST_UNKNOWN_NAME);
	export_constant(EFST_ON_PUSH_CART);
	export_constant(EFST_HAT_EFFECT);
	export_constant(EFST_FLOWER_LEAF);
	export_constant(EFST_RAY_OF_PROTECTION);
	export_constant(EFST_GLASTHEIM_ATK);
	export_constant(EFST_GLASTHEIM_DEF);
	export_constant(EFST_GLASTHEIM_HEAL);
	export_constant(EFST_GLASTHEIM_HIDDEN);
	export_constant(EFST_GLASTHEIM_STATE);
	export_constant(EFST_GLASTHEIM_ITEMDEF);
	export_constant(EFST_GLASTHEIM_HPSP);
	export_constant(EFST_FOLLOWER_NPC_SKILL_POSTDELAY);
	export_constant(EFST_ALMIGHTY);
	export_constant(EFST_GVG_GIANT);
	export_constant(EFST_GVG_GOLEM);
	export_constant(EFST_GVG_STUN);
	export_constant(EFST_GVG_STONE);
	export_constant(EFST_GVG_FREEZ);
	export_constant(EFST_GVG_SLEEP);
	export_constant(EFST_GVG_CURSE);
	export_constant(EFST_GVG_SILENCE);
	export_constant(EFST_GVG_BLIND);
	export_constant(EFST_CLIENT_ONLY_EQUIP_ARROW);
	export_constant(EFST_CLAN_INFO);
	export_constant(EFST_JP_EVENT01);
	export_constant(EFST_JP_EVENT02);
	export_constant(EFST_JP_EVENT03);
	export_constant(EFST_JP_EVENT04);
	export_constant(EFST_TELEPORT_FIXEDCASTINGDELAY);
	export_constant(EFST_GEFFEN_MAGIC1);
	export_constant(EFST_GEFFEN_MAGIC2);
	export_constant(EFST_GEFFEN_MAGIC3);
	export_constant(EFST_QUEST_BUFF1);
	export_constant(EFST_QUEST_BUFF2);
	export_constant(EFST_QUEST_BUFF3);
	export_constant(EFST_REUSE_LIMIT_RECALL);
	export_constant(EFST_SAVEPOSITION);
	export_constant(EFST_NPC_ICEEXPLO);
	export_constant(EFST_FENRIR_CARD);
	export_constant(EFST_REUSE_LIMIT_ASPD_POTION);
	export_constant(EFST_MAXPAIN);
	export_constant(EFST_PC_STOP);
	export_constant(EFST_FRIGG_SONG);
	export_constant(EFST_OFFERTORIUM);
	export_constant(EFST_TELEKINESIS_INTENSE);
	export_constant(EFST_MOONSTAR);
	export_constant(EFST_STRANGELIGHTS);
	export_constant(EFST_FULL_THROTTLE);
	export_constant(EFST_REBOUND);
	export_constant(EFST_UNLIMIT);
	export_constant(EFST_KINGS_GRACE);
	export_constant(EFST_ITEM_ATKMAX);
	export_constant(EFST_ITEM_ATKMIN);
	export_constant(EFST_ITEM_MATKMAX);
	export_constant(EFST_ITEM_MATKMIN);
	export_constant(EFST_SUPER_STAR);
	export_constant(EFST_HIGH_RANKER);
	export_constant(EFST_DARKCROW);
	export_constant(EFST_2013_VALENTINE1);
	export_constant(EFST_2013_VALENTINE2);
	export_constant(EFST_2013_VALENTINE3);
	export_constant(EFST_ILLUSIONDOPING);
	export_constant(EFST_WIDEWEB);
	export_constant(EFST_CHILL);
	export_constant(EFST_BURNT);
	export_constant(EFST_PCCAFE_PLAY_TIME);
	export_constant(EFST_TWISTED_TIME);
	export_constant(EFST_FLASHCOMBO);
	export_constant(EFST_JITTER_BUFF1);
	export_constant(EFST_JITTER_BUFF2);
	export_constant(EFST_JITTER_BUFF3);
	export_constant(EFST_JITTER_BUFF4);
	export_constant(EFST_JITTER_BUFF5);
	export_constant(EFST_JITTER_BUFF6);
	export_constant(EFST_JITTER_BUFF7);
	export_constant(EFST_JITTER_BUFF8);
	export_constant(EFST_JITTER_BUFF9);
	export_constant(EFST_JITTER_BUFF10);
	export_constant(EFST_CUP_OF_BOZA);
	export_constant(EFST_B_TRAP);
	export_constant(EFST_E_CHAIN);
	export_constant(EFST_E_QD_SHOT_READY);
	export_constant(EFST_C_MARKER);
	export_constant(EFST_H_MINE);
	export_constant(EFST_H_MINE_SPLASH);
	export_constant(EFST_P_ALTER);
	export_constant(EFST_HEAT_BARREL);
	export_constant(EFST_ANTI_M_BLAST);
	export_constant(EFST_SLUGSHOT);
	export_constant(EFST_SWORDCLAN);
	export_constant(EFST_ARCWANDCLAN);
	export_constant(EFST_GOLDENMACECLAN);
	export_constant(EFST_CROSSBOWCLAN);
	export_constant(EFST_PACKING_ENVELOPE1);
	export_constant(EFST_PACKING_ENVELOPE2);
	export_constant(EFST_PACKING_ENVELOPE3);
	export_constant(EFST_PACKING_ENVELOPE4);
	export_constant(EFST_PACKING_ENVELOPE5);
	export_constant(EFST_PACKING_ENVELOPE6);
	export_constant(EFST_PACKING_ENVELOPE7);
	export_constant(EFST_PACKING_ENVELOPE8);
	export_constant(EFST_PACKING_ENVELOPE9);
	export_constant(EFST_PACKING_ENVELOPE10);
	export_constant(EFST_GLASTHEIM_TRANS);
	export_constant(EFST_ZONGZI_POUCH_TRANS);
	export_constant(EFST_HEAT_BARREL_AFTER);
	export_constant(EFST_DECORATION_OF_MUSIC);
	export_constant(EFST_OVERSEAEXPUP);
	export_constant(EFST_CLOWN_N_GYPSY_CARD);
	export_constant(EFST_OPEN_NPC_MARKET);
	export_constant(EFST_BEEF_RIB_STEW);
	export_constant(EFST_PORK_RIB_STEW);
	export_constant(EFST_CHUSEOK_MONDAY);
	export_constant(EFST_CHUSEOK_TUESDAY);
	export_constant(EFST_CHUSEOK_WEDNESDAY);
	export_constant(EFST_CHUSEOK_THURSDAY);
	export_constant(EFST_CHUSEOK_FRIDAY);
	export_constant(EFST_CHUSEOK_WEEKEND);
	export_constant(EFST_ALL_LIGHTGUARD);
	export_constant(EFST_ALL_LIGHTGUARD_COOL_TIME);
	export_constant(EFST_MTF_MHP);
	export_constant(EFST_MTF_MSP);
	export_constant(EFST_MTF_PUMPKIN);
	export_constant(EFST_MTF_HITFLEE);
	export_constant(EFST_MTF_CRIDAMAGE2);
	export_constant(EFST_MTF_SPDRAIN);
	export_constant(EFST_ACUO_MINT_GUM);
	export_constant(EFST_S_HEALPOTION);
	export_constant(EFST_REUSE_LIMIT_S_HEAL_POTION);
	export_constant(EFST_PLAYTIME_STATISTICS);
	export_constant(EFST_GN_CHANGEMATERIAL_OPERATOR);
	export_constant(EFST_GN_MIX_COOKING_OPERATOR);
	export_constant(EFST_GN_MAKEBOMB_OPERATOR);
	export_constant(EFST_GN_S_PHARMACY_OPERATOR);
	export_constant(EFST_SO_EL_ANALYSIS_DISASSEMBLY_OPERATOR);
	export_constant(EFST_SO_EL_ANALYSIS_COMBINATION_OPERATOR);
	export_constant(EFST_NC_MAGICDECOY_OPERATOR);
	export_constant(EFST_GUILD_STORAGE);
	export_constant(EFST_GC_POISONINGWEAPON_OPERATOR);
	export_constant(EFST_WS_WEAPONREFINE_OPERATOR);
	export_constant(EFST_BS_REPAIRWEAPON_OPERATOR);
	export_constant(EFST_UNREADMAIL_CHECK);
	export_constant(EFST_JUMPINGCLAN);
	export_constant(EFST_JP_OTP);
	export_constant(EFST_HANDICAPTOLERANCE_LEVELGAP);
	export_constant(EFST_MTF_RANGEATK2);
	export_constant(EFST_MTF_ASPD2);
	export_constant(EFST_MTF_MATK2);
	export_constant(EFST_SHOW_NPCHPBAR);
	export_constant(EFST_FLOWERSMOKE);
	export_constant(EFST_FSTONE);
	export_constant(EFST_DAILYSENDMAILCNT);
	export_constant(EFST_QSCARABA);
	export_constant(EFST_LJOSALFAR);
	export_constant(EFST_PAD_READER_KNIGHT);
	export_constant(EFST_PAD_READER_CRUSADER);
	export_constant(EFST_PAD_READER_BLACKSMITH);
	export_constant(EFST_PAD_READER_ALCHEMIST);
	export_constant(EFST_PAD_READER_ASSASSIN);
	export_constant(EFST_PAD_READER_ROGUE);
	export_constant(EFST_PAD_READER_WIZARD);
	export_constant(EFST_PAD_READER_SAGE);
	export_constant(EFST_PAD_READER_PRIEST);
	export_constant(EFST_PAD_READER_MONK);
	export_constant(EFST_PAD_READER_HUNTER);
	export_constant(EFST_PAD_READER_BARD);
	export_constant(EFST_PAD_READER_DANCER);
	export_constant(EFST_PAD_READER_TAEKWON);
	export_constant(EFST_PAD_READER_NINJA);
	export_constant(EFST_PAD_READER_GUNSLINGER);
	export_constant(EFST_PAD_READER_SUPERNOVICE);
	export_constant(EFST_ESSENCE_OF_TIME);
	export_constant(EFST_MINIGAME_ROULETTE);
	export_constant(EFST_MINIGAME_GOLD_POINT);
	export_constant(EFST_MINIGAME_SILVER_POINT);
	export_constant(EFST_MINIGAME_BRONZE_POINT);
	export_constant(EFST_HAPPINESS_STAR);
	export_constant(EFST_SUMMEREVENT01);
	export_constant(EFST_SUMMEREVENT02);
	export_constant(EFST_SUMMEREVENT03);
	export_constant(EFST_SUMMEREVENT04);
	export_constant(EFST_SUMMEREVENT05);
	export_constant(EFST_MINIGAME_ROULETTE_BONUS_ITEM);
	export_constant(EFST_DRESS_UP);
	export_constant(EFST_MAPLE_FALLS);
	export_constant(EFST_ALL_NIFLHEIM_RECALL);
	export_constant(EFST_MTF_MARIONETTE);
	export_constant(EFST_MTF_LUDE);
	export_constant(EFST_MTF_CRUISER);
	export_constant(EFST_MERMAID_LONGING);
	export_constant(EFST_MAGICAL_FEATHER);
	export_constant(EFST_DRACULA_CARD);
	export_constant(EFST_ALL_PRONTERA_RECALL);
	export_constant(EFST_LIMIT_POWER_BOOSTER);
	export_constant(EFST_GIFT_OF_SNOW);
	export_constant(EFST_NPC_HALLUCINATIONWALK);
	export_constant(EFST_TIME_ACCESSORY);
	export_constant(EFST_EP16_DEF);
	export_constant(EFST_NORMAL_ATKED_SP);
	export_constant(EFST_BODYSTATE_STONECURSE);
	export_constant(EFST_BODYSTATE_FREEZING);
	export_constant(EFST_BODYSTATE_STUN);
	export_constant(EFST_BODYSTATE_SLEEP);
	export_constant(EFST_BODYSTATE_UNDEAD);
	export_constant(EFST_BODYSTATE_STONECURSE_ING);
	export_constant(EFST_BODYSTATE_BURNNING);
	export_constant(EFST_BODYSTATE_IMPRISON);
	export_constant(EFST_HEALTHSTATE_POISON);
	export_constant(EFST_HEALTHSTATE_CURSE);
	export_constant(EFST_HEALTHSTATE_SILENCE);
	export_constant(EFST_HEALTHSTATE_CONFUSION);
	export_constant(EFST_HEALTHSTATE_BLIND);
	export_constant(EFST_HEALTHSTATE_ANGELUS);
	export_constant(EFST_HEALTHSTATE_BLOODING);
	export_constant(EFST_HEALTHSTATE_HEAVYPOISON);
	export_constant(EFST_HEALTHSTATE_FEAR);
	export_constant(EFST_CHERRY_BLOSSOM_CAKE);
	export_constant(EFST_SU_STOOP);
	export_constant(EFST_CATNIPPOWDER);
	export_constant(EFST_HEAD_EQUIPMENT_EFFECT);
	export_constant(EFST_SV_ROOTTWIST);
	export_constant(EFST_ATTACK_PROPERTY_NOTHING);
	export_constant(EFST_ATTACK_PROPERTY_WATER);
	export_constant(EFST_ATTACK_PROPERTY_GROUND);
	export_constant(EFST_ATTACK_PROPERTY_FIRE);
	export_constant(EFST_ATTACK_PROPERTY_WIND);
	export_constant(EFST_ATTACK_PROPERTY_POISON);
	export_constant(EFST_ATTACK_PROPERTY_SAINT);
	export_constant(EFST_ATTACK_PROPERTY_DARKNESS);
	export_constant(EFST_ATTACK_PROPERTY_TELEKINESIS);
	export_constant(EFST_ATTACK_PROPERTY_UNDEAD);
	export_constant(EFST_RESIST_PROPERTY_NOTHING);
	export_constant(EFST_RESIST_PROPERTY_WATER);
	export_constant(EFST_RESIST_PROPERTY_GROUND);
	export_constant(EFST_RESIST_PROPERTY_FIRE);
	export_constant(EFST_RESIST_PROPERTY_WIND);
	export_constant(EFST_RESIST_PROPERTY_POISON);
	export_constant(EFST_RESIST_PROPERTY_SAINT);
	export_constant(EFST_RESIST_PROPERTY_DARKNESS);
	export_constant(EFST_RESIST_PROPERTY_TELEKINESIS);
	export_constant(EFST_RESIST_PROPERTY_UNDEAD);
	export_constant(EFST_BITESCAR);
	export_constant(EFST_ARCLOUSEDASH);
	export_constant(EFST_TUNAPARTY);
	export_constant(EFST_SHRIMP);
	export_constant(EFST_FRESHSHRIMP);
	export_constant(EFST_PERIOD_RECEIVEITEM);
	export_constant(EFST_PERIOD_PLUSEXP);
	export_constant(EFST_PERIOD_PLUSJOBEXP);
	export_constant(EFST_RUNEHELM);
	export_constant(EFST_HELM_VERKANA);
	export_constant(EFST_HELM_RHYDO);
	export_constant(EFST_HELM_TURISUS);
	export_constant(EFST_HELM_HAGALAS);
	export_constant(EFST_HELM_ISIA);
	export_constant(EFST_HELM_ASIR);
	export_constant(EFST_HELM_URJ);
	export_constant(EFST_SUHIDE);
	export_constant(EFST_DORAM_BUF_01);
	export_constant(EFST_DORAM_BUF_02);
	export_constant(EFST_SPRITEMABLE);
	export_constant(EFST_AID_PERIOD_RECEIVEITEM);
	export_constant(EFST_AID_PERIOD_PLUSEXP);
	export_constant(EFST_AID_PERIOD_PLUSJOBEXP);
	export_constant(EFST_AID_PERIOD_DEADPENALTY);
	export_constant(EFST_AID_PERIOD_ADDSTOREITEMCOUNT);
	export_constant(EFST_ALL_GLASTHEIM_RECALL);
	export_constant(EFST_ALL_THANATOS_RECALL);
	export_constant(EFST_MAGICSTONE_OF_GRACE_SET);
	export_constant(EFST_HISS);
	export_constant(EFST_NYANGGRASS);
	export_constant(EFST_CHATTERING);
	export_constant(EFST_GROOMING);
	export_constant(EFST_PROTECTIONOFSHRIMP);
	export_constant(EFST_EP16_2_BUFF_SS);
	export_constant(EFST_EP16_2_BUFF_SC);
	export_constant(EFST_EP16_2_BUFF_AC);
	export_constant(EFST_GS_MAGICAL_BULLET);
	export_constant(EFST_FALLEN_ANGEL);
	export_constant(EFST_BLAZE_BEAD);
	export_constant(EFST_FROZEN_BEAD);
	export_constant(EFST_BREEZE_BEAD);
	export_constant(EFST_SOULATTACK);
	export_constant(EFST_AID_PERIOD_RECEIVEITEM_2ND);
	export_constant(EFST_AID_PERIOD_PLUSEXP_2ND);
	export_constant(EFST_AID_PERIOD_PLUSJOBEXP_2ND);
	export_constant(EFST_PRONTERA_JP);
	export_constant(EFST_GLOOM_CARD);
	export_constant(EFST_PHARAOH_CARD);
	export_constant(EFST_KIEL_CARD);
	export_constant(EFST_CHEERUP);
	export_constant(EFST_GET_CNT_UNREAD_RODEX_CHARDB);
	export_constant(EFST_GET_CNT_UNREAD_RODEX_GLOBALDB);
	export_constant(EFST_S_MANAPOTION);
	export_constant(EFST_M_DEFSCROLL);
	export_constant(EFST_AS_RAGGED_GOLEM_CARD);
	export_constant(EFST_LHZ_DUN_N1);
	export_constant(EFST_LHZ_DUN_N2);
	export_constant(EFST_LHZ_DUN_N3);
	export_constant(EFST_LHZ_DUN_N4);
	export_constant(EFST_ALL_STAT_DOWN);
	export_constant(EFST_GRADUAL_GRAVITY);
	export_constant(EFST_DAMAGE_HEAL);
	export_constant(EFST_IMMUNE_PROPERTY_NOTHING);
	export_constant(EFST_IMMUNE_PROPERTY_WATER);
	export_constant(EFST_IMMUNE_PROPERTY_GROUND);
	export_constant(EFST_IMMUNE_PROPERTY_FIRE);
	export_constant(EFST_IMMUNE_PROPERTY_WIND);
	export_constant(EFST_IMMUNE_PROPERTY_POISON);
	export_constant(EFST_IMMUNE_PROPERTY_SAINT);
	export_constant(EFST_IMMUNE_PROPERTY_DARKNESS);
	export_constant(EFST_IMMUNE_PROPERTY_TELEKINESIS);
	export_constant(EFST_IMMUNE_PROPERTY_UNDEAD);
	export_constant(EFST_REUSE_LIMIT_NP);
	export_constant(EFST_SPECIALCOOKIE);
	export_constant(EFST_DAMAGE_HEAL2);
	export_constant(EFST_DAMAGE_HEAL3);
	export_constant(EFST_GLORY_OF_RETURN);
	export_constant(EFST_ATK_POPCORN);
	export_constant(EFST_MATK_POPCORN);
	export_constant(EFST_ASPD_POPCORN);
	export_constant(EFST_ULTIMATECOOK);
	export_constant(EFST_LIGHTOFMOON);
	export_constant(EFST_LIGHTOFSUN);
	export_constant(EFST_LIGHTOFSTAR);
	export_constant(EFST_LUNARSTANCE);
	export_constant(EFST_UNIVERSESTANCE);
	export_constant(EFST_SUNSTANCE);
	export_constant(EFST_FLASHKICK);
	export_constant(EFST_NEWMOON);
	export_constant(EFST_STARSTANCE);
	export_constant(EFST_DIMENSION);
	export_constant(EFST_DIMENSION1);
	export_constant(EFST_DIMENSION2);
	export_constant(EFST_CREATINGSTAR);
	export_constant(EFST_FALLINGSTAR);
	export_constant(EFST_NOVAEXPLOSING);
	export_constant(EFST_GRAVITYCONTROL);
	export_constant(EFST_SOULCOLLECT);
	export_constant(EFST_SOULREAPER);
	export_constant(EFST_SOULUNITY);
	export_constant(EFST_SOULSHADOW);
	export_constant(EFST_SOULFAIRY);
	export_constant(EFST_SOULFALCON);
	export_constant(EFST_SOULGOLEM);
	export_constant(EFST_SOULDIVISION);
	export_constant(EFST_SOULENERGY);
	export_constant(EFST_USE_SKILL_SP_SPA);
	export_constant(EFST_USE_SKILL_SP_SHA);
	export_constant(EFST_SP_SHA);
	export_constant(EFST_INFINITY_DRINK);
	export_constant(EFST_ABYSS_001);
	export_constant(EFST_ABYSS_002);
	export_constant(EFST_ABYSS_003);
	export_constant(EFST_ABYSS_004);
	export_constant(EFST_ABYSS_005);
	export_constant(EFST_ABYSS_006);
	export_constant(EFST_ABYSS_007);
	export_constant(EFST_ABYSS_008);
	export_constant(EFST_YGGDRASIL_BLESS);
	export_constant(EFST_HUNTING_EVENT);
	export_constant(EFST_PERIOD_RECEIVEITEM_2ND);
	export_constant(EFST_PERIOD_PLUSEXP_2ND);
	export_constant(EFST_EXPDROPUP);
	export_constant(EFST_TW_NEWYEAR_EVENT);
	export_constant(EFST_ENSEMBLEFATIGUE);
	export_constant(EFST_ADAPTATION);
	export_constant(EFST_ANCILLA);
	export_constant(EFST_FESTIVE_ENERGY);
	export_constant(EFST_WEAPONBLOCK_ON);
	export_constant(EFST_CRI_DAMAGE);
	export_constant(EFST_DEF_POWER);
	export_constant(EFST_DEF_IGNORE);
	export_constant(EFST_BOW_ATK_POWER);
	export_constant(EFST_RED_ORG_POTION);
	export_constant(EFST_CAST_TIME);
	export_constant(EFST_LEAPIMPAIRED);
	export_constant(EFST_EXCLUSIVE_RECEIVEITEM);
	export_constant(EFST_EXCLUSIVE_PLUSEXP);
	export_constant(EFST_ASSUMPTIO_BUFF);
	export_constant(EFST_BASILICA_BUFF);
	export_constant(EFST_OVERLAPEXPUP2);
	export_constant(EFST_SOULCURSE);
	export_constant(EFST_SOUND_OF_DESTRUCTION);
	export_constant(EFST_DF_MANAPLUS);
	export_constant(EFST_DF_FULLSWINGK);
	export_constant(EFST_NV_BREAKTHROUGH);
	export_constant(EFST_HELPANGEL);
	export_constant(EFST_NV_TRANSCENDENCE);
	export_constant(EFST_SWEETSFAIR_ATK);
	export_constant(EFST_SWEETSFAIR_MATK);
	export_constant(EFST_FLOWER_LEAF2);
	export_constant(EFST_FLOWER_LEAF3);
	export_constant(EFST_FLOWER_LEAF4);
	export_constant(EFST_MISTY_FROST);
	export_constant(EFST_MAGIC_POISON);
	export_constant(EFST_KAUTE);
	export_constant(EFST_JPNONLY_TACTICS);
/// @APIHOOK_END
/// Do not modify code above this, since it will be automatically generated by the API again
	export_constant(EFST_MAX);

	/* elements */
	export_constant(ELE_NEUTRAL);
	export_constant(ELE_WATER);
	export_constant(ELE_EARTH);
	export_constant(ELE_FIRE);
	export_constant(ELE_WIND);
	export_constant(ELE_POISON);
	export_constant(ELE_HOLY);
	export_constant(ELE_DARK);
	export_constant(ELE_GHOST);
	export_constant(ELE_UNDEAD);
	export_constant(ELE_ALL);

	/* races */
	export_constant(RC_FORMLESS);
	export_constant(RC_UNDEAD);
	export_constant(RC_BRUTE);
	export_constant(RC_PLANT);
	export_constant(RC_INSECT);
	export_constant(RC_FISH);
	export_constant(RC_DEMON);
	export_constant(RC_DEMIHUMAN);
	export_constant(RC_ANGEL);
	export_constant(RC_DRAGON);
	export_constant(RC_PLAYER);
	export_constant(RC_ALL);

	export_constant(RC2_NONE);
	export_constant(RC2_GOBLIN);
	export_constant(RC2_KOBOLD);
	export_constant(RC2_ORC);
	export_constant(RC2_GOLEM);
	export_constant(RC2_GUARDIAN);
	export_constant(RC2_NINJA);
	export_constant(RC2_GVG);
	export_constant(RC2_BATTLEFIELD);
	export_constant(RC2_TREASURE);
	export_constant(RC2_BIOLAB);
	export_constant(RC2_MANUK);
	export_constant(RC2_SPLENDIDE);
	export_constant(RC2_SCARABA);
	export_constant(RC2_OGH_ATK_DEF);
	export_constant(RC2_OGH_HIDDEN);
	export_constant(RC2_BIO5_SWORDMAN_THIEF);
	export_constant(RC2_BIO5_ACOLYTE_MERCHANT);
	export_constant(RC2_BIO5_MAGE_ARCHER);
	export_constant(RC2_BIO5_MVP);
	export_constant(RC2_CLOCKTOWER);
	export_constant(RC2_THANATOS);
	export_constant(RC2_FACEWORM);
	export_constant(RC2_HEARTHUNTER);
	export_constant(RC2_ROCKRIDGE);
	export_constant(RC2_WERNER_LAB);
	export_constant(RC2_MAX);

	/* classes */
	export_constant(CLASS_NORMAL);
	export_constant(CLASS_BOSS);
	export_constant(CLASS_GUARDIAN);
	export_constant(CLASS_BATTLEFIELD);
	export_constant(CLASS_ALL);

	/* sizes */
	export_constant2("Size_Small",SZ_SMALL);
	export_constant2("Size_Medium",SZ_MEDIUM);
	export_constant2("Size_Large",SZ_BIG);
	export_constant2("Size_All",SZ_ALL);

	/* ai */
	export_constant(AI_NONE);
	export_constant(AI_ATTACK);
	export_constant(AI_SPHERE);
	export_constant(AI_FLORA);
	export_constant(AI_ZANZOU);
	export_constant(AI_LEGION);
	export_constant(AI_FAW);

	/* battle flags */
	export_constant(BF_WEAPON);
	export_constant(BF_MAGIC);
	export_constant(BF_MISC);
	export_constant(BF_SHORT);
	export_constant(BF_LONG);
	export_constant(BF_SKILL);
	export_constant(BF_NORMAL);

	/* auto trigger flags */
	export_constant(ATF_SELF);
	export_constant(ATF_TARGET);
	export_constant(ATF_SHORT);
	export_constant(ATF_LONG);
	export_constant(ATF_WEAPON);
	export_constant(ATF_MAGIC);
	export_constant(ATF_MISC);
	// TODO: Check why this was in const.txt, but not on source side
	export_constant2("ATF_SKILL",ATF_MAGIC|ATF_MISC);

	/* emoticons */
	export_constant(ET_SURPRISE);
	export_constant(ET_QUESTION);
	export_constant(ET_DELIGHT);
	export_constant(ET_THROB);
	export_constant(ET_SWEAT);
	export_constant(ET_AHA);
	export_constant(ET_FRET);
	export_constant(ET_ANGER);
	export_constant(ET_MONEY);
	export_constant(ET_THINK);
	export_constant(ET_SCISSOR);
	export_constant(ET_ROCK);
	export_constant(ET_WRAP);
	export_constant(ET_FLAG);
	export_constant(ET_BIGTHROB);
	export_constant(ET_THANKS);
	export_constant(ET_KEK);
	export_constant(ET_SORRY);
	export_constant(ET_SMILE);
	export_constant(ET_PROFUSELY_SWEAT);
	export_constant(ET_SCRATCH);
	export_constant(ET_BEST);
	export_constant(ET_STARE_ABOUT);
	export_constant(ET_HUK);
	export_constant(ET_O);
	export_constant(ET_X);
	export_constant(ET_HELP);
	export_constant(ET_GO);
	export_constant(ET_CRY);
	export_constant(ET_KIK);
	export_constant(ET_CHUP);
	export_constant(ET_CHUPCHUP);
	export_constant(ET_HNG);
	export_constant(ET_OK);
	export_constant(ET_CHAT_PROHIBIT);
	export_constant(ET_INDONESIA_FLAG);
	export_constant(ET_STARE);
	export_constant(ET_HUNGRY);
	export_constant(ET_COOL);
	export_constant(ET_MERONG);
	export_constant(ET_SHY);
	export_constant(ET_GOODBOY);
	export_constant(ET_SPTIME);
	export_constant(ET_SEXY);
	export_constant(ET_COMEON);
	export_constant(ET_SLEEPY);
	export_constant(ET_CONGRATULATION);
	export_constant(ET_HPTIME);
	export_constant(ET_PH_FLAG);
	export_constant(ET_MY_FLAG);
	export_constant(ET_SI_FLAG);
	export_constant(ET_BR_FLAG);
	export_constant(ET_SPARK);
	export_constant(ET_CONFUSE);
	export_constant(ET_OHNO);
	export_constant(ET_HUM);
	export_constant(ET_BLABLA);
	export_constant(ET_OTL);
	export_constant(ET_DICE1);
	export_constant(ET_DICE2);
	export_constant(ET_DICE3);
	export_constant(ET_DICE4);
	export_constant(ET_DICE5);
	export_constant(ET_DICE6);
	export_constant(ET_INDIA_FLAG);
	export_constant(ET_LUV);
	export_constant(ET_FLAG8);
	export_constant(ET_FLAG9);
	export_constant(ET_MOBILE);
	export_constant(ET_MAIL);
	export_constant(ET_ANTENNA0);
	export_constant(ET_ANTENNA1);
	export_constant(ET_ANTENNA2);
	export_constant(ET_ANTENNA3);
	export_constant(ET_HUM2);
	export_constant(ET_ABS);
	export_constant(ET_OOPS);
	export_constant(ET_SPIT);
	export_constant(ET_ENE);
	export_constant(ET_PANIC);
	export_constant(ET_WHISP);
	export_constant(ET_YUT1);
	export_constant(ET_YUT2);
	export_constant(ET_YUT3);
	export_constant(ET_YUT4);
	export_constant(ET_YUT5);
	export_constant(ET_YUT6);
	export_constant(ET_YUT7);

	/* emoticons deprecated */
	export_deprecated_constant3("E_GASP", ET_SURPRISE, "ET_SURPRISE");
	export_deprecated_constant3("E_WHAT", ET_QUESTION, "ET_QUESTION");
	export_deprecated_constant3("E_HO", ET_DELIGHT, "ET_DELIGHT");
	export_deprecated_constant3("E_LV", ET_THROB, "ET_THROB");
	export_deprecated_constant3("E_SWT", ET_SWEAT, "ET_SWEAT");
	export_deprecated_constant3("E_IC", ET_AHA, "ET_AHA");
	export_deprecated_constant3("E_AN", ET_FRET, "ET_FRET");
	export_deprecated_constant3("E_AG", ET_ANGER, "ET_ANGER");
	export_deprecated_constant3("E_CASH", ET_MONEY, "ET_MONEY");
	export_deprecated_constant3("E_DOTS", ET_THINK, "ET_THINK");
	export_deprecated_constant3("E_SCISSORS", ET_SCISSOR, "ET_SCISSOR");
	export_deprecated_constant3("E_ROCK", ET_ROCK, "ET_ROCK");
	export_deprecated_constant3("E_PAPER", ET_WRAP, "ET_WRAP");
	export_deprecated_constant3("E_KOREA", ET_FLAG, "ET_FLAG");
	export_deprecated_constant3("E_LV2", ET_BIGTHROB, "ET_BIGTHROB");
	export_deprecated_constant3("E_THX", ET_THANKS, "ET_THANKS");
	export_deprecated_constant3("E_WAH", ET_KEK, "ET_KEK");
	export_deprecated_constant3("E_SRY", ET_SORRY, "ET_SORRY");
	export_deprecated_constant3("E_HEH", ET_SMILE, "ET_SMILE");
	export_deprecated_constant3("E_SWT2", ET_PROFUSELY_SWEAT, "ET_PROFUSELY_SWEAT");
	export_deprecated_constant3("E_HMM", ET_SCRATCH, "ET_SCRATCH");
	export_deprecated_constant3("E_NO1", ET_BEST, "ET_BEST");
	export_deprecated_constant3("E_NO", ET_STARE_ABOUT, "ET_STARE_ABOUT");
	export_deprecated_constant3("E_OMG", ET_HUK, "ET_HUK");
	export_deprecated_constant3("E_OH", ET_O, "ET_O");
	export_deprecated_constant3("E_X", ET_X, "ET_X");
	export_deprecated_constant3("E_HLP", ET_HELP, "ET_HELP");
	export_deprecated_constant3("E_GO", ET_GO, "ET_GO");
	export_deprecated_constant3("E_SOB", ET_CRY, "ET_CRY");
	export_deprecated_constant3("E_GG", ET_KIK, "ET_KIK");
	export_deprecated_constant3("E_KIS", ET_CHUP, "ET_CHUP");
	export_deprecated_constant3("E_KIS2", ET_CHUPCHUP, "ET_CHUPCHUP");
	export_deprecated_constant3("E_PIF", ET_HNG, "ET_HNG");
	export_deprecated_constant3("E_OK", ET_OK, "ET_OK");
	export_deprecated_constant3("E_MUTE", ET_CHAT_PROHIBIT, "ET_CHAT_PROHIBIT");
	export_deprecated_constant3("E_INDONESIA", ET_INDONESIA_FLAG, "ET_INDONESIA_FLAG");
	export_deprecated_constant3("E_BZZ", ET_STARE, "ET_STARE");
	export_deprecated_constant3("E_RICE", ET_HUNGRY, "ET_HUNGRY");
	export_deprecated_constant3("E_AWSM", ET_COOL, "ET_COOL");
	export_deprecated_constant3("E_MEH", ET_MERONG, "ET_MERONG");
	export_deprecated_constant3("E_SHY", ET_SHY, "ET_SHY");
	export_deprecated_constant3("E_PAT", ET_GOODBOY, "ET_GOODBOY");
	export_deprecated_constant3("E_MP", ET_SPTIME, "ET_SPTIME");
	export_deprecated_constant3("E_SLUR", ET_SEXY, "ET_SEXY");
	export_deprecated_constant3("E_COM", ET_COMEON, "ET_COMEON");
	export_deprecated_constant3("E_YAWN", ET_SLEEPY, "ET_SLEEPY");
	export_deprecated_constant3("E_GRAT", ET_CONGRATULATION, "ET_CONGRATULATION");
	export_deprecated_constant3("E_HP", ET_HPTIME, "ET_HPTIME");
	export_deprecated_constant3("E_PHILIPPINES", ET_PH_FLAG, "ET_PH_FLAG");
	export_deprecated_constant3("E_MALAYSIA", ET_MY_FLAG, "ET_MY_FLAG");
	export_deprecated_constant3("E_SINGAPORE", ET_SI_FLAG, "ET_SI_FLAG");
	export_deprecated_constant3("E_BRAZIL", ET_BR_FLAG, "ET_BR_FLAG");
	export_deprecated_constant3("E_FLASH", ET_SPARK, "ET_SPARK");
	export_deprecated_constant3("E_SPIN", ET_CONFUSE, "ET_CONFUSE");
	export_deprecated_constant3("E_SIGH", ET_OHNO, "ET_OHNO");
	export_deprecated_constant3("E_DUM", ET_HUM, "ET_HUM");
	export_deprecated_constant3("E_LOUD", ET_BLABLA, "ET_BLABLA");
	export_deprecated_constant3("E_OTL", ET_OTL, "ET_OTL");
	export_deprecated_constant3("E_DICE1", ET_DICE1, "ET_DICE1");
	export_deprecated_constant3("E_DICE2", ET_DICE2, "ET_DICE2");
	export_deprecated_constant3("E_DICE3", ET_DICE3, "ET_DICE3");
	export_deprecated_constant3("E_DICE4", ET_DICE4, "ET_DICE4");
	export_deprecated_constant3("E_DICE5", ET_DICE5, "ET_DICE5");
	export_deprecated_constant3("E_DICE6", ET_DICE6, "ET_DICE6");
	export_deprecated_constant3("E_INDIA", ET_INDIA_FLAG, "ET_INDIA_FLAG");
	export_deprecated_constant3("E_LUV", ET_LUV, "ET_LUV");
	export_deprecated_constant3("E_RUSSIA", ET_FLAG8, "ET_FLAG8");
	export_deprecated_constant3("E_VIRGIN", ET_FLAG9, "ET_FLAG9");
	export_deprecated_constant3("E_MOBILE", ET_MOBILE, "ET_MOBILE");
	export_deprecated_constant3("E_MAIL", ET_MAIL, "ET_MAIL");
	export_deprecated_constant3("E_CHINESE", ET_ANTENNA0, "ET_ANTENNA0");
	export_deprecated_constant3("E_ANTENNA1", ET_ANTENNA1, "ET_ANTENNA1");
	export_deprecated_constant3("E_ANTENNA2", ET_ANTENNA2, "ET_ANTENNA2");
	export_deprecated_constant3("E_ANTENNA3", ET_ANTENNA3, "ET_ANTENNA3");
	export_deprecated_constant3("E_HUM", ET_HUM2, "ET_HUM2");
	export_deprecated_constant3("E_ABS", ET_ABS, "ET_ABS");
	export_deprecated_constant3("E_OOPS", ET_OOPS, "ET_OOPS");
	export_deprecated_constant3("E_SPIT", ET_SPIT, "ET_SPIT");
	export_deprecated_constant3("E_ENE", ET_ENE, "ET_ENE");
	export_deprecated_constant3("E_PANIC", ET_PANIC, "ET_PANIC");
	export_deprecated_constant3("E_WHISP", ET_WHISP, "ET_WHISP");
	export_deprecated_constant3("E_YUT1", ET_YUT1, "ET_YUT1");
	export_deprecated_constant3("E_YUT2", ET_YUT2, "ET_YUT2");
	export_deprecated_constant3("E_YUT3", ET_YUT3, "ET_YUT3");
	export_deprecated_constant3("E_YUT4", ET_YUT4, "ET_YUT4");
	export_deprecated_constant3("E_YUT5", ET_YUT5, "ET_YUT5");
	export_deprecated_constant3("E_YUT6", ET_YUT6, "ET_YUT6");
	export_deprecated_constant3("E_YUT7", ET_YUT7, "ET_YUT7");

	/* send targets */
	export_constant(ALL_CLIENT);
	export_constant(ALL_SAMEMAP);
	export_constant(AREA);
	export_constant(AREA_WOS);
	export_constant(AREA_WOC);
	export_constant(AREA_WOSC);
	export_constant(AREA_CHAT_WOC);
	export_constant(CHAT);
	export_constant(CHAT_WOS);
	export_constant(PARTY);
	export_constant(PARTY_WOS);
	export_constant(PARTY_SAMEMAP);
	export_constant(PARTY_SAMEMAP_WOS);
	export_constant(PARTY_AREA);
	export_constant(PARTY_AREA_WOS);
	export_constant(GUILD);
	export_constant(GUILD_WOS);
	export_constant(GUILD_SAMEMAP);
	export_constant(GUILD_SAMEMAP_WOS);
	export_constant(GUILD_AREA);
	export_constant(GUILD_AREA_WOS);
	export_constant(GUILD_NOBG);
	export_constant(DUEL);
	export_constant(DUEL_WOS);
	export_constant(SELF);
	export_constant(BG);
	export_constant(BG_WOS);
	export_constant(BG_SAMEMAP);
	export_constant(BG_SAMEMAP_WOS);
	export_constant(BG_AREA);
	export_constant(BG_AREA_WOS);
	export_constant(CLAN);

	/* mercenary guilds */
	export_constant(ARCH_MERC_GUILD);
	export_constant(SPEAR_MERC_GUILD);
	export_constant(SWORD_MERC_GUILD);

	/* item types */
	export_constant(IT_HEALING);
	export_constant(IT_USABLE);
	export_constant(IT_ETC);
	export_constant(IT_ARMOR);
	export_constant(IT_WEAPON);
	export_constant(IT_CARD);
	export_constant(IT_PETEGG);
	export_constant(IT_PETARMOR);
	export_constant(IT_AMMO);
	export_constant(IT_DELAYCONSUME);
	export_constant(IT_SHADOWGEAR);
	export_constant(IT_CASH);

	/* weapon types */
	export_constant(W_FIST);
	export_constant(W_DAGGER);
	export_constant(W_1HSWORD);
	export_constant(W_2HSWORD);
	export_constant(W_1HSPEAR);
	export_constant(W_2HSPEAR);
	export_constant(W_1HAXE);
	export_constant(W_2HAXE);
	export_constant(W_MACE);
	export_constant(W_2HMACE);
	export_constant(W_STAFF);
	export_constant(W_BOW);
	export_constant(W_KNUCKLE);
	export_constant(W_MUSICAL);
	export_constant(W_WHIP);
	export_constant(W_BOOK);
	export_constant(W_KATAR);
	export_constant(W_REVOLVER);
	export_constant(W_RIFLE);
	export_constant(W_GATLING);
	export_constant(W_SHOTGUN);
	export_constant(W_GRENADE);
	export_constant(W_HUUMA);
	export_constant(W_2HSTAFF);
	export_constant(MAX_WEAPON_TYPE);
	export_constant(W_DOUBLE_DD);
	export_constant(W_DOUBLE_SS);
	export_constant(W_DOUBLE_AA);
	export_constant(W_DOUBLE_DS);
	export_constant(W_DOUBLE_DA);
	export_constant(W_DOUBLE_SA);
	export_constant(MAX_WEAPON_TYPE_ALL);

	/* ammunition types */
	export_constant(A_ARROW);
	export_constant(A_DAGGER);
	export_constant(A_BULLET);
	export_constant(A_SHELL);
	export_constant(A_GRENADE);
	export_constant(A_SHURIKEN);
	export_constant(A_KUNAI);
	export_constant(A_CANNONBALL);
	export_constant(A_THROWWEAPON);

	/* monsterinfo types */
	export_constant(MOB_NAME);
	export_constant(MOB_LV);
	export_constant(MOB_MAXHP);
	export_constant(MOB_BASEEXP);
	export_constant(MOB_JOBEXP);
	export_constant(MOB_ATK1);
	export_constant(MOB_ATK2);
	export_constant(MOB_DEF);
	export_constant(MOB_MDEF);
	export_constant(MOB_STR);
	export_constant(MOB_AGI);
	export_constant(MOB_VIT);
	export_constant(MOB_INT);
	export_constant(MOB_DEX);
	export_constant(MOB_LUK);
	export_constant(MOB_RANGE);
	export_constant(MOB_RANGE2);
	export_constant(MOB_RANGE3);
	export_constant(MOB_SIZE);
	export_constant(MOB_RACE);
	export_constant(MOB_ELEMENT);
	export_constant(MOB_MODE);
	export_constant(MOB_MVPEXP);

	/* petinfo types */
	export_constant(PETINFO_ID);
	export_constant(PETINFO_CLASS);
	export_constant(PETINFO_NAME);
	export_constant(PETINFO_INTIMATE);
	export_constant(PETINFO_HUNGRY);
	export_constant(PETINFO_RENAMED);
	export_constant(PETINFO_LEVEL);
	export_constant(PETINFO_BLOCKID);
	export_constant(PETINFO_EGGID);
	export_constant(PETINFO_FOODID);

	// For backwards compatability - might be removed in the near future
	export_constant2("PET_ID",PETINFO_ID);
	export_constant2("PET_CLASS",PETINFO_CLASS);
	export_constant2("PET_NAME",PETINFO_NAME);
	export_constant2("PET_INTIMATE",PETINFO_INTIMATE);
	export_constant2("PET_HUNGRY",PETINFO_HUNGRY);
	export_constant2("PET_RENAMED",PETINFO_RENAMED);
	export_constant2("PET_LEVEL",PETINFO_LEVEL);

	/* questinfo types */
	export_constant(QTYPE_QUEST);
	export_constant(QTYPE_QUEST2);
	export_constant(QTYPE_JOB);
	export_constant(QTYPE_JOB2);
	export_constant(QTYPE_EVENT);
	export_constant(QTYPE_EVENT2);
	export_constant(QTYPE_WARG);
	export_constant(QTYPE_CLICKME);
	export_constant(QTYPE_DAILYQUEST);
	export_constant(QTYPE_WARG2);
	export_constant(QTYPE_EVENT3);
	export_constant(QTYPE_JOBQUEST);
	export_constant(QTYPE_JUMPING_PORING);
	export_constant(QTYPE_NONE);

	/* font weight types */
	export_constant(FW_DONTCARE);
	export_constant(FW_THIN);
	export_constant(FW_EXTRALIGHT);
	export_constant(FW_LIGHT);
	export_constant(FW_NORMAL);
	export_constant(FW_MEDIUM);
	export_constant(FW_SEMIBOLD);
	export_constant(FW_BOLD);
	export_constant(FW_EXTRABOLD);
	export_constant(FW_HEAVY);

	/* add skill types */
	export_constant2("SKILL_PERM",ADDSKILL_PERMANENT);
	export_constant2("SKILL_TEMP",ADDSKILL_TEMP);
	export_constant2("SKILL_TEMPLEVEL",ADDSKILL_TEMP_ADDLEVEL);
	export_constant2("SKILL_PERM_GRANT",ADDSKILL_PERMANENT_GRANTED);

	/* bonus script flags */
	export_constant(BSF_REM_ON_DEAD);
	export_constant(BSF_REM_ON_DISPELL);
	export_constant(BSF_REM_ON_CLEARANCE);
	export_constant(BSF_REM_ON_LOGOUT);
	export_constant(BSF_REM_ON_BANISHING_BUSTER);
	export_constant(BSF_REM_ON_REFRESH);
	export_constant(BSF_REM_ON_LUXANIMA);
	export_constant(BSF_REM_ON_MADOGEAR);
	export_constant(BSF_REM_ON_DAMAGED);
	export_constant(BSF_PERMANENT);
	export_constant(BSF_FORCE_REPLACE);
	export_constant(BSF_FORCE_DUPLICATE);

	/* bindings */
	export_constant(BOUND_NONE);
	export_constant(BOUND_ACCOUNT);
	export_constant(BOUND_GUILD);
	export_constant(BOUND_PARTY);
	export_constant(BOUND_CHAR);

	/* quest check types */
	export_constant(HAVEQUEST);
	export_constant(PLAYTIME);
	export_constant(HUNTING);

	/* status options */
	export_constant(OPTION_NOTHING);
	export_constant(OPTION_SIGHT);
	export_constant(OPTION_HIDE);
	export_constant(OPTION_CLOAK);
	export_constant(OPTION_FALCON);
	export_constant(OPTION_RIDING);
	export_constant(OPTION_INVISIBLE);
	export_constant(OPTION_ORCISH);
	export_constant(OPTION_WEDDING);
	export_constant(OPTION_RUWACH);
	export_constant(OPTION_CHASEWALK);
	export_constant(OPTION_FLYING);
	export_constant(OPTION_XMAS);
	export_constant(OPTION_TRANSFORM);
	export_constant(OPTION_SUMMER);
	export_constant(OPTION_DRAGON1);
	export_constant(OPTION_WUG);
	export_constant(OPTION_WUGRIDER);
	export_constant(OPTION_MADOGEAR);
	export_constant(OPTION_DRAGON2);
	export_constant(OPTION_DRAGON3);
	export_constant(OPTION_DRAGON4);
	export_constant(OPTION_DRAGON5);
	export_constant(OPTION_HANBOK);
	export_constant(OPTION_OKTOBERFEST);

	/* status option compounds */
	export_constant(OPTION_DRAGON);
	export_constant(OPTION_COSTUME);

	/* sc_start flags */
	export_constant(SCSTART_NONE);
	export_constant(SCSTART_NOAVOID);
	export_constant(SCSTART_NOTICKDEF);
	export_constant(SCSTART_LOADED);
	export_constant(SCSTART_NORATEDEF);
	export_constant(SCSTART_NOICON);

	/* unit control - types */
	/* Send deprecation notice and temporarily replace with new constant value. */
	export_deprecated_constant3("UNITTYPE_PC", BL_PC, "BL_PC");
	export_deprecated_constant3("UNITTYPE_NPC", BL_NPC, "BL_NPC");
	export_deprecated_constant3("UNITTYPE_PET", BL_PET, "BL_PET");
	export_deprecated_constant3("UNITTYPE_MOB", BL_MOB, "BL_MOB");
	export_deprecated_constant3("UNITTYPE_HOM", BL_HOM, "BL_HOM");
	export_deprecated_constant3("UNITTYPE_MER", BL_MER, "BL_MER");
	export_deprecated_constant3("UNITTYPE_ELEM", BL_ELEM, "BL_ELEM");

	/* unit control - mob */
	export_constant(UMOB_SIZE);
	export_constant(UMOB_LEVEL);
	export_constant(UMOB_HP);
	export_constant(UMOB_MAXHP);
	export_constant(UMOB_MASTERAID);
	export_constant(UMOB_MAPID);
	export_constant(UMOB_X);
	export_constant(UMOB_Y);
	export_constant(UMOB_SPEED);
	export_constant(UMOB_MODE);
	export_constant(UMOB_AI);
	export_constant(UMOB_SCOPTION);
	export_constant(UMOB_SEX);
	export_constant(UMOB_CLASS);
	export_constant(UMOB_HAIRSTYLE);
	export_constant(UMOB_HAIRCOLOR);
	export_constant(UMOB_HEADBOTTOM);
	export_constant(UMOB_HEADMIDDLE);
	export_constant(UMOB_HEADTOP);
	export_constant(UMOB_CLOTHCOLOR);
	export_constant(UMOB_SHIELD);
	export_constant(UMOB_WEAPON);
	export_constant(UMOB_LOOKDIR);
	export_constant(UMOB_CANMOVETICK);
	export_constant(UMOB_STR);
	export_constant(UMOB_AGI);
	export_constant(UMOB_VIT);
	export_constant(UMOB_INT);
	export_constant(UMOB_DEX);
	export_constant(UMOB_LUK);
	export_constant(UMOB_SLAVECPYMSTRMD);
	export_constant(UMOB_DMGIMMUNE);
	export_constant(UMOB_ATKRANGE);
	export_constant(UMOB_ATKMIN);
	export_constant(UMOB_ATKMAX);
	export_constant(UMOB_MATKMIN);
	export_constant(UMOB_MATKMAX);
	export_constant(UMOB_DEF);
	export_constant(UMOB_MDEF);
	export_constant(UMOB_HIT);
	export_constant(UMOB_FLEE);
	export_constant(UMOB_PDODGE);
	export_constant(UMOB_CRIT);
	export_constant(UMOB_RACE);
	export_constant(UMOB_ELETYPE);
	export_constant(UMOB_ELELEVEL);
	export_constant(UMOB_AMOTION);
	export_constant(UMOB_ADELAY);
	export_constant(UMOB_DMOTION);
	export_constant(UMOB_TARGETID);

	/* unit control - homunculus */
	export_constant(UHOM_SIZE);
	export_constant(UHOM_LEVEL);
	export_constant(UHOM_HP);
	export_constant(UHOM_MAXHP);
	export_constant(UHOM_SP);
	export_constant(UHOM_MAXSP);
	export_constant(UHOM_MASTERCID);
	export_constant(UHOM_MAPID);
	export_constant(UHOM_X);
	export_constant(UHOM_Y);
	export_constant(UHOM_HUNGER);
	export_constant(UHOM_INTIMACY);
	export_constant(UHOM_SPEED);
	export_constant(UHOM_LOOKDIR);
	export_constant(UHOM_CANMOVETICK);
	export_constant(UHOM_STR);
	export_constant(UHOM_AGI);
	export_constant(UHOM_VIT);
	export_constant(UHOM_INT);
	export_constant(UHOM_DEX);
	export_constant(UHOM_LUK);
	export_constant(UHOM_DMGIMMUNE);
	export_constant(UHOM_ATKRANGE);
	export_constant(UHOM_ATKMIN);
	export_constant(UHOM_ATKMAX);
	export_constant(UHOM_MATKMIN);
	export_constant(UHOM_MATKMAX);
	export_constant(UHOM_DEF);
	export_constant(UHOM_MDEF);
	export_constant(UHOM_HIT);
	export_constant(UHOM_FLEE);
	export_constant(UHOM_PDODGE);
	export_constant(UHOM_CRIT);
	export_constant(UHOM_RACE);
	export_constant(UHOM_ELETYPE);
	export_constant(UHOM_ELELEVEL);
	export_constant(UHOM_AMOTION);
	export_constant(UHOM_ADELAY);
	export_constant(UHOM_DMOTION);
	export_constant(UHOM_TARGETID);

	/* unit control - pet */
	export_constant(UPET_SIZE);
	export_constant(UPET_LEVEL);
	export_constant(UPET_HP);
	export_constant(UPET_MAXHP);
	export_constant(UPET_MASTERAID);
	export_constant(UPET_MAPID);
	export_constant(UPET_X);
	export_constant(UPET_Y);
	export_constant(UPET_HUNGER);
	export_constant(UPET_INTIMACY);
	export_constant(UPET_SPEED);
	export_constant(UPET_LOOKDIR);
	export_constant(UPET_CANMOVETICK);
	export_constant(UPET_STR);
	export_constant(UPET_AGI);
	export_constant(UPET_VIT);
	export_constant(UPET_INT);
	export_constant(UPET_DEX);
	export_constant(UPET_LUK);
	export_constant(UPET_DMGIMMUNE);
	export_constant(UPET_ATKRANGE);
	export_constant(UPET_ATKMIN);
	export_constant(UPET_ATKMAX);
	export_constant(UPET_MATKMIN);
	export_constant(UPET_MATKMAX);
	export_constant(UPET_DEF);
	export_constant(UPET_MDEF);
	export_constant(UPET_HIT);
	export_constant(UPET_FLEE);
	export_constant(UPET_PDODGE);
	export_constant(UPET_CRIT);
	export_constant(UPET_RACE);
	export_constant(UPET_ELETYPE);
	export_constant(UPET_ELELEVEL);
	export_constant(UPET_AMOTION);
	export_constant(UPET_ADELAY);
	export_constant(UPET_DMOTION);

	/* unit control - mercenary */
	export_constant(UMER_SIZE);
	export_constant(UMER_HP);
	export_constant(UMER_MAXHP);
	export_constant(UMER_MASTERCID);
	export_constant(UMER_MAPID);
	export_constant(UMER_X);
	export_constant(UMER_Y);
	export_constant(UMER_KILLCOUNT);
	export_constant(UMER_LIFETIME);
	export_constant(UMER_SPEED);
	export_constant(UMER_LOOKDIR);
	export_constant(UMER_CANMOVETICK);
	export_constant(UMER_STR);
	export_constant(UMER_AGI);
	export_constant(UMER_VIT);
	export_constant(UMER_INT);
	export_constant(UMER_DEX);
	export_constant(UMER_LUK);
	export_constant(UMER_DMGIMMUNE);
	export_constant(UMER_ATKRANGE);
	export_constant(UMER_ATKMIN);
	export_constant(UMER_ATKMAX);
	export_constant(UMER_MATKMIN);
	export_constant(UMER_MATKMAX);
	export_constant(UMER_DEF);
	export_constant(UMER_MDEF);
	export_constant(UMER_HIT);
	export_constant(UMER_FLEE);
	export_constant(UMER_PDODGE);
	export_constant(UMER_CRIT);
	export_constant(UMER_RACE);
	export_constant(UMER_ELETYPE);
	export_constant(UMER_ELELEVEL);
	export_constant(UMER_AMOTION);
	export_constant(UMER_ADELAY);
	export_constant(UMER_DMOTION);
	export_constant(UMER_TARGETID);

	/* unit control - elemental */
	export_constant(UELE_SIZE);
	export_constant(UELE_HP);
	export_constant(UELE_MAXHP);
	export_constant(UELE_SP);
	export_constant(UELE_MAXSP);
	export_constant(UELE_MASTERCID);
	export_constant(UELE_MAPID);
	export_constant(UELE_X);
	export_constant(UELE_Y);
	export_constant(UELE_LIFETIME);
	export_constant(UELE_MODE);
	export_constant(UELE_SPEED);
	export_constant(UELE_LOOKDIR);
	export_constant(UELE_CANMOVETICK);
	export_constant(UELE_STR);
	export_constant(UELE_AGI);
	export_constant(UELE_VIT);
	export_constant(UELE_INT);
	export_constant(UELE_DEX);
	export_constant(UELE_LUK);
	export_constant(UELE_DMGIMMUNE);
	export_constant(UELE_ATKRANGE);
	export_constant(UELE_ATKMIN);
	export_constant(UELE_ATKMAX);
	export_constant(UELE_MATKMIN);
	export_constant(UELE_MATKMAX);
	export_constant(UELE_DEF);
	export_constant(UELE_MDEF);
	export_constant(UELE_HIT);
	export_constant(UELE_FLEE);
	export_constant(UELE_PDODGE);
	export_constant(UELE_CRIT);
	export_constant(UELE_RACE);
	export_constant(UELE_ELETYPE);
	export_constant(UELE_ELELEVEL);
	export_constant(UELE_AMOTION);
	export_constant(UELE_ADELAY);
	export_constant(UELE_DMOTION);
	export_constant(UELE_TARGETID);

	/* unit control - NPC */
	export_constant(UNPC_DISPLAY);
	export_constant(UNPC_LEVEL);
	export_constant(UNPC_HP);
	export_constant(UNPC_MAXHP);
	export_constant(UNPC_MAPID);
	export_constant(UNPC_X);
	export_constant(UNPC_Y);
	export_constant(UNPC_LOOKDIR);
	export_constant(UNPC_STR);
	export_constant(UNPC_AGI);
	export_constant(UNPC_VIT);
	export_constant(UNPC_INT);
	export_constant(UNPC_DEX);
	export_constant(UNPC_LUK);
	export_constant(UNPC_PLUSALLSTAT);
	export_constant(UNPC_DMGIMMUNE);
	export_constant(UNPC_ATKRANGE);
	export_constant(UNPC_ATKMIN);
	export_constant(UNPC_ATKMAX);
	export_constant(UNPC_MATKMIN);
	export_constant(UNPC_MATKMAX);
	export_constant(UNPC_DEF);
	export_constant(UNPC_MDEF);
	export_constant(UNPC_HIT);
	export_constant(UNPC_FLEE);
	export_constant(UNPC_PDODGE);
	export_constant(UNPC_CRIT);
	export_constant(UNPC_RACE);
	export_constant(UNPC_ELETYPE);
	export_constant(UNPC_ELELEVEL);
	export_constant(UNPC_AMOTION);
	export_constant(UNPC_ADELAY);
	export_constant(UNPC_DMOTION);

	export_constant(NAV_NONE);
	export_constant(NAV_AIRSHIP_ONLY);
	export_constant(NAV_SCROLL_ONLY);
	export_constant(NAV_AIRSHIP_AND_SCROLL);
	export_constant(NAV_KAFRA_ONLY);
	export_constant(NAV_KAFRA_AND_AIRSHIP);
	export_constant(NAV_KAFRA_AND_SCROLL);
	export_constant(NAV_ALL);

	export_constant(ADOPT_ALLOWED);
	export_constant(ADOPT_ALREADY_ADOPTED);
	export_constant(ADOPT_MARRIED_AND_PARTY);
	export_constant(ADOPT_EQUIP_RINGS);
	export_constant(ADOPT_NOT_NOVICE);
	export_constant(ADOPT_CHARACTER_NOT_FOUND);
	export_constant(ADOPT_MORE_CHILDREN);
	export_constant(ADOPT_LEVEL_70);
	export_constant(ADOPT_MARRIED);
	
	/* directions */
	export_constant(DIR_NORTH);
	export_constant(DIR_NORTHWEST);
	export_constant(DIR_WEST);
	export_constant(DIR_SOUTHWEST);
	export_constant(DIR_SOUTH);
	export_constant(DIR_SOUTHEAST);
	export_constant(DIR_EAST);
	export_constant(DIR_NORTHEAST);

	/* instance modes */
	export_constant(IM_NONE);
	export_constant(IM_CHAR);
	export_constant(IM_PARTY);
	export_constant(IM_GUILD);
	export_constant(IM_CLAN);

	/* mob random groups */
	export_constant(MOBG_Branch_Of_Dead_Tree);
	export_constant(MOBG_Poring_Box);
	export_constant(MOBG_Bloody_Dead_Branch);
	export_constant(MOBG_Red_Pouch_Of_Surprise);
	export_constant(MOBG_ClassChange);
	export_constant(MOBG_Taekwon_Mission);

	/* Item Random Option Group */
	export_constant(RDMOPTG_None);
	export_constant(RDMOPTG_Crimson_Weapon);

	/* random option attributes */
	export_constant(ROA_ID);
	export_constant(ROA_VALUE);
	export_constant(ROA_PARAM);

	/* special card flags */
	export_constant(CARD0_FORGE);
	export_constant(CARD0_CREATE);
	export_constant(CARD0_PET);

	/* Channel System */
	export_constant(CHAN_TYPE_PUBLIC);
	export_constant(CHAN_TYPE_PRIVATE);
	export_constant(CHAN_TYPE_MAP);
	export_constant(CHAN_TYPE_ALLY);
	export_constant(CHAN_OPT_BASE);
	export_constant(CHAN_OPT_ANNOUNCE_SELF);
	export_constant(CHAN_OPT_ANNOUNCE_JOIN);
	export_constant(CHAN_OPT_ANNOUNCE_LEAVE);
	export_constant(CHAN_OPT_MSG_DELAY);
	export_constant(CHAN_OPT_COLOR_OVERRIDE);
	export_constant(CHAN_OPT_CAN_CHAT);
	export_constant(CHAN_OPT_CAN_LEAVE);
	export_constant(CHAN_OPT_AUTOJOIN);

	export_constant(STOR_MODE_NONE);
	export_constant(STOR_MODE_GET);
	export_constant(STOR_MODE_PUT);
	
	/* instance enter */
	export_constant(IE_OK);
	export_constant(IE_NOMEMBER);
	export_constant(IE_NOINSTANCE);
	export_constant(IE_OTHER);
	
	/* months */
	export_constant(JANUARY);
	export_constant(FEBRUARY);
	export_constant(MARCH);
	export_constant(APRIL);
	export_constant(MAY);
	export_constant(JUNE);
	export_constant(JULY);
	export_constant(AUGUST);
	export_constant(SEPTEMBER);
	export_constant(OCTOBER);
	export_constant(NOVEMBER);
	export_constant(DECEMBER);
	
	/* days of the week */
	export_constant(SUNDAY);
	export_constant(MONDAY);
	export_constant(TUESDAY);
	export_constant(WEDNESDAY);
	export_constant(THURSDAY);
	export_constant(FRIDAY);
	export_constant(SATURDAY);
	
	/* date types */
	export_constant(DT_SECOND);
	export_constant(DT_MINUTE);
	export_constant(DT_HOUR);
	export_constant(DT_DAYOFWEEK);
	export_constant(DT_DAYOFMONTH);
	export_constant(DT_MONTH);
	export_constant(DT_YEAR);
	export_constant(DT_DAYOFYEAR);
	export_constant(DT_YYYYMMDD);

	/* instance info */
	export_constant(IIT_ID);
	export_constant(IIT_TIME_LIMIT);
	export_constant(IIT_IDLE_TIMEOUT);
	export_constant(IIT_ENTER_MAP);
	export_constant(IIT_ENTER_X);
	export_constant(IIT_ENTER_Y);
	export_constant(IIT_MAPCOUNT);
	export_constant(IIT_MAP);

	/* instance live info */
	export_constant(ILI_NAME);
	export_constant(ILI_MODE);
	export_constant(ILI_OWNER);

	/* VIP status */
	export_constant(VIP_STATUS_ACTIVE);
	export_constant(VIP_STATUS_EXPIRE);
	export_constant(VIP_STATUS_REMAINING);

	/* item groups */
	export_constant(IG_BLUEBOX);
	export_constant(IG_VIOLETBOX);
	export_constant(IG_CARDALBUM);
	export_constant(IG_GIFTBOX);
	export_constant(IG_SCROLLBOX);
	export_constant(IG_FINDINGORE);
	export_constant(IG_COOKIEBAG);
	export_constant(IG_FIRSTAID);
	export_constant(IG_HERB);
	export_constant(IG_FRUIT);
	export_constant(IG_MEAT);
	export_constant(IG_CANDY);
	export_constant(IG_JUICE);
	export_constant(IG_FISH);
	export_constant(IG_BOX);
	export_constant(IG_GEMSTONE);
	export_constant(IG_RESIST);
	export_constant(IG_ORE);
	export_constant(IG_FOOD);
	export_constant(IG_RECOVERY);
	export_constant(IG_MINERAL);
	export_constant(IG_TAMING);
	export_constant(IG_SCROLL);
	export_constant(IG_QUIVER);
	export_constant(IG_MASK);
	export_constant(IG_ACCESORY);
	export_constant(IG_JEWEL);
	export_constant(IG_GIFTBOX_1);
	export_constant(IG_GIFTBOX_2);
	export_constant(IG_GIFTBOX_3);
	export_constant(IG_GIFTBOX_4);
	export_constant(IG_EGGBOY);
	export_constant(IG_EGGGIRL);
	export_constant(IG_GIFTBOXCHINA);
	export_constant(IG_LOTTOBOX);
	export_constant(IG_FOODBAG);
	export_constant(IG_POTION);
	export_constant(IG_REDBOX_2);
	export_constant(IG_BLEUBOX);
	export_constant(IG_REDBOX);
	export_constant(IG_GREENBOX);
	export_constant(IG_YELLOWBOX);
	export_constant(IG_OLDGIFTBOX);
	export_constant(IG_MAGICCARDALBUM);
	export_constant(IG_HOMETOWNGIFT);
	export_constant(IG_MASQUERADE);
	export_constant(IG_TRESURE_BOX_WOE);
	export_constant(IG_MASQUERADE_2);
	export_constant(IG_EASTER_SCROLL);
	export_constant(IG_PIERRE_TREASUREBOX);
	export_constant(IG_CHERISH_BOX);
	export_constant(IG_CHERISH_BOX_ORI);
	export_constant(IG_LOUISE_COSTUME_BOX);
	export_constant(IG_XMAS_GIFT);
	export_constant(IG_FRUIT_BASKET);
	export_constant(IG_IMPROVED_COIN_BAG);
	export_constant(IG_INTERMEDIATE_COIN_BAG);
	export_constant(IG_MINOR_COIN_BAG);
	export_constant(IG_S_GRADE_COIN_BAG);
	export_constant(IG_A_GRADE_COIN_BAG);
	export_constant(IG_ADVANCED_WEAPONS_BOX);
	export_constant(IG_SPLENDID_BOX);
	export_constant(IG_CARDALBUM_ARMOR);
	export_constant(IG_CARDALBUM_HELM);
	export_constant(IG_CARDALBUM_ACC);
	export_constant(IG_CARDALBUM_SHOES);
	export_constant(IG_CARDALBUM_SHIELD);
	export_constant(IG_CARDALBUM_WEAPON);
	export_constant(IG_CARDALBUM_GARMENT);
	export_constant(IG_FLAMEL_CARD);
	export_constant(IG_SPECIAL_BOX);
	export_constant(IG_TRESURE_BOX_WOE_);
	export_constant(IG_RWC_PARTI_BOX);
	export_constant(IG_RWC_FINAL_COMP_BOX);
	export_constant(IG_GIFT_BUNDLE);
	export_constant(IG_CARACAS_RING_BOX);
	export_constant(IG_CRUMPLED_PAPER);
	export_constant(IG_SOLO_GIFT_BASKET);
	export_constant(IG_COUPLE_EVENT_BASKET);
	export_constant(IG_GM_WARP_BOX);
	export_constant(IG_FORTUNE_COOKIE1);
	export_constant(IG_FORTUNE_COOKIE2);
	export_constant(IG_FORTUNE_COOKIE3);
	export_constant(IG_NEW_GIFT_ENVELOPE);
	export_constant(IG_PASSION_FB_HAT_BOX);
	export_constant(IG_COOL_FB_HAT_BOX);
	export_constant(IG_VICTORY_FB_HAT_BOX);
	export_constant(IG_GLORY_FB_HAT_BOX);
	export_constant(IG_PASSION_HAT_BOX2);
	export_constant(IG_COOL_HAT_BOX2);
	export_constant(IG_VICTORY_HAT_BOX2);
	export_constant(IG_ASPERSIO_5_SCROLL_BOX);
	export_constant(IG_PET_EGG_SCROLL_BOX1);
	export_constant(IG_PET_EGG_SCROLL_BOX2);
	export_constant(IG_PET_EGG_SCROLL1);
	export_constant(IG_PET_EGG_SCROLL2);
	export_constant(IG_PET_EGG_SCROLL_BOX3);
	export_constant(IG_PET_EGG_SCROLL_BOX4);
	export_constant(IG_PET_EGG_SCROLL_BOX5);
	export_constant(IG_PET_EGG_SCROLL3);
	export_constant(IG_PET_EGG_SCROLL4);
	export_constant(IG_PET_EGG_SCROLL5);
	export_constant(IG_INFILTRATOR_BOX);
	export_constant(IG_MURAMASA_BOX);
	export_constant(IG_EXCALIBUR_BOX);
	export_constant(IG_COMBAT_KNIFE_BOX);
	export_constant(IG_COUNTER_DAGGER_BOX);
	export_constant(IG_KAISER_KNUCKLE_BOX);
	export_constant(IG_POLE_AXE_BOX);
	export_constant(IG_MIGHTY_STAFF_BOX);
	export_constant(IG_RIGHT_EPSILON_BOX);
	export_constant(IG_BALISTAR_BOX);
	export_constant(IG_DIARY_OF_GREAT_SAGE_BOX);
	export_constant(IG_ASURA_BOX);
	export_constant(IG_APPLE_OF_ARCHER_BOX);
	export_constant(IG_BUNNY_BAND_BOX);
	export_constant(IG_SAHKKAT_BOX);
	export_constant(IG_LORD_CIRCLET_BOX);
	export_constant(IG_ELVEN_EARS_BOX);
	export_constant(IG_STEEL_FLOWER_BOX);
	export_constant(IG_CRITICAL_RING_BOX);
	export_constant(IG_EARRING_BOX);
	export_constant(IG_RING_BOX);
	export_constant(IG_NECKLACE_BOX);
	export_constant(IG_GLOVE_BOX);
	export_constant(IG_BROOCH_BOX);
	export_constant(IG_ROSARY_BOX);
	export_constant(IG_SAFETY_RING_BOX);
	export_constant(IG_VESPER_CORE01_BOX);
	export_constant(IG_VESPER_CORE02_BOX);
	export_constant(IG_VESPER_CORE03_BOX);
	export_constant(IG_VESPER_CORE04_BOX);
	export_constant(IG_PET_EGG_SCROLL_BOX6);
	export_constant(IG_PET_EGG_SCROLL_BOX7);
	export_constant(IG_PET_EGG_SCROLL_BOX8);
	export_constant(IG_PET_EGG_SCROLL_BOX9);
	export_constant(IG_PET_EGG_SCROLL_BOX10);
	export_constant(IG_PET_EGG_SCROLL_BOX11);
	export_constant(IG_PET_EGG_SCROLL6);
	export_constant(IG_PET_EGG_SCROLL7);
	export_constant(IG_PET_EGG_SCROLL8);
	export_constant(IG_PET_EGG_SCROLL9);
	export_constant(IG_PET_EGG_SCROLL10);
	export_constant(IG_PET_EGG_SCROLL11);
	export_constant(IG_CP_HELM_SCROLL_BOX);
	export_constant(IG_CP_SHIELD_SCROLL_BOX);
	export_constant(IG_CP_ARMOR_SCROLL_BOX);
	export_constant(IG_CP_WEAPON_SCROLL_BOX);
	export_constant(IG_REPAIR_SCROLL_BOX);
	export_constant(IG_SUPER_PET_EGG1);
	export_constant(IG_SUPER_PET_EGG2);
	export_constant(IG_SUPER_PET_EGG3);
	export_constant(IG_SUPER_PET_EGG4);
	export_constant(IG_SUPER_CARD_PET_EGG1);
	export_constant(IG_SUPER_CARD_PET_EGG2);
	export_constant(IG_SUPER_CARD_PET_EGG3);
	export_constant(IG_SUPER_CARD_PET_EGG4);
	export_constant(IG_VIGORGRA_PACKAGE1);
	export_constant(IG_VIGORGRA_PACKAGE2);
	export_constant(IG_VIGORGRA_PACKAGE3);
	export_constant(IG_VIGORGRA_PACKAGE4);
	export_constant(IG_VIGORGRA_PACKAGE5);
	export_constant(IG_VIGORGRA_PACKAGE6);
	export_constant(IG_VIGORGRA_PACKAGE7);
	export_constant(IG_VIGORGRA_PACKAGE8);
	export_constant(IG_VIGORGRA_PACKAGE9);
	export_constant(IG_VIGORGRA_PACKAGE10);
	export_constant(IG_VIGORGRA_PACKAGE11);
	export_constant(IG_VIGORGRA_PACKAGE12);
	export_constant(IG_PET_EGG_SCROLL12);
	export_constant(IG_PET_EGG_SCROLL13);
	export_constant(IG_PET_EGG_SCROLL14);
	export_constant(IG_SUPER_PET_EGG5);
	export_constant(IG_SUPER_PET_EGG6);
	export_constant(IG_SUPER_PET_EGG7);
	export_constant(IG_SUPER_PET_EGG8);
	export_constant(IG_PET_EGG_SCROLL_E);
	export_constant(IG_RAMEN_HAT_BOX);
	export_constant(IG_MYSTERIOUS_TRAVEL_SACK1);
	export_constant(IG_MYSTERIOUS_TRAVEL_SACK2);
	export_constant(IG_MYSTERIOUS_TRAVEL_SACK3);
	export_constant(IG_MYSTERIOUS_TRAVEL_SACK4);
	export_constant(IG_MAGICIAN_CARD_BOX);
	export_constant(IG_ACOLYTE_CARD_BOX);
	export_constant(IG_ARCHER_CARD_BOX);
	export_constant(IG_SWORDMAN_CARD_BOX);
	export_constant(IG_THIEF_CARD_BOX);
	export_constant(IG_MERCHANT_CARD_BOX);
	export_constant(IG_HARD_CORE_SET_BOX);
	export_constant(IG_KITTY_SET_BOX);
	export_constant(IG_SOFT_CORE_SET_BOX);
	export_constant(IG_DEVIRUCHI_SET_BOX);
	export_constant(IG_MVP_HUNT_BOX);
	export_constant(IG_BREWING_BOX);
	export_constant(IG_XMAS_PET_SCROLL);
	export_constant(IG_LUCKY_SCROLL08);
	export_constant(IG_BR_SWORDPACKAGE);
	export_constant(IG_BR_MAGEPACKAGE);
	export_constant(IG_BR_ACOLPACKAGE);
	export_constant(IG_BR_ARCHERPACKAGE);
	export_constant(IG_BR_MERPACKAGE);
	export_constant(IG_BR_THIEFPACKAGE);
	export_constant(IG_ACIDBOMB_10_BOX);
	export_constant(IG_BASIC_SIEGE_SUPPLY_BOX);
	export_constant(IG_ADV_SIEGE_SUPPLY_BOX);
	export_constant(IG_ELITE_SIEGE_SUPPLY_BOX);
	export_constant(IG_SAKURA_SCROLL);
	export_constant(IG_BEHOLDER_RING_BOX);
	export_constant(IG_HALLOW_RING_BOX);
	export_constant(IG_CLAMOROUS_RING_BOX);
	export_constant(IG_CHEMICAL_RING_BOX);
	export_constant(IG_INSECTICIDE_RING_BOX);
	export_constant(IG_FISHER_RING_BOX);
	export_constant(IG_DECUSSATE_RING_BOX);
	export_constant(IG_BLOODY_RING_BOX);
	export_constant(IG_SATANIC_RING_BOX);
	export_constant(IG_DRAGOON_RING_BOX);
	export_constant(IG_ANGEL_SCROLL);
	export_constant(IG_DEVIL_SCROLL);
	export_constant(IG_SURPRISE_SCROLL);
	export_constant(IG_JULY7_SCROLL);
	export_constant(IG_BACSOJIN_SCROLL);
	export_constant(IG_ANIMAL_SCROLL);
	export_constant(IG_HEART_SCROLL);
	export_constant(IG_NEW_YEAR_SCROLL);
	export_constant(IG_VALENTINE_PLEDGE_BOX);
	export_constant(IG_OX_TAIL_SCROLL);
	export_constant(IG_BUDDAH_SCROLL);
	export_constant(IG_EVIL_INCARNATION);
	export_constant(IG_F_CLOVER_BOX_MOUTH);
	export_constant(IG_MOUTH_BUBBLE_GUM_BOX);
	export_constant(IG_F_CLOVER_BOX_MOUTH2);
	export_constant(IG_F_CLOVER_BOX_MOUTH4);
	export_constant(IG_BGUM_BOX_IN_MOUTH2);
	export_constant(IG_BGUM_BOX_IN_MOUTH4);
	export_constant(IG_TW_OCTOBER_SCROLL);
	export_constant(IG_MY_SCROLL1);
	export_constant(IG_TW_NOV_SCROLL);
	export_constant(IG_MY_SCROLL2);
	export_constant(IG_PR_RESET_STONE_BOX);
	export_constant(IG_FPR_RESET_STONE_BOX);
	export_constant(IG_MAJESTIC_DEVIL_SCROLL);
	export_constant(IG_LIFE_RIBBON_BOX);
	export_constant(IG_LIFE_RIBBON_BOX2);
	export_constant(IG_LIFE_RIBBON_BOX3);
	export_constant(IG_MAGIC_CANDY_BOX10);
	export_constant(IG_RWC2010_SUITCASEA);
	export_constant(IG_RWC2010_SUITCASEB);
	export_constant(IG_SAGITTARIUS_SCROLL);
	export_constant(IG_SAGITTARIUS_SCR_BOX);
	export_constant(IG_SAGITTAR_DIADEM_SCROLL);
	export_constant(IG_SAGITTAR_DI_SCROLL_BOX);
	export_constant(IG_CAPRI_CROWN_SCROLL);
	export_constant(IG_CAPRI_CROWN_SCROLL_BOX);
	export_constant(IG_CAPRICON_DI_SCROLL);
	export_constant(IG_CAPRICON_DI_SCROLL_BOX);
	export_constant(IG_AQUARIUS_DIADEM_SCROLL);
	export_constant(IG_AQUARIUS_DI_SCROLL_BOX);
	export_constant(IG_LOVELY_AQUARIUS_SCROLL);
	export_constant(IG_LOVELY_AQUARIUS_BOX);
	export_constant(IG_PISCES_DIADEM_SCROLL);
	export_constant(IG_PISCES_DIADEM_BOX);
	export_constant(IG_ENERGETIC_PISCES_SCROLL);
	export_constant(IG_ENERGETIC_PISCES_BOX);
	export_constant(IG_ARIES_SCROLL);
	export_constant(IG_ARIES_SCROLL_BOX);
	export_constant(IG_BOARDING_HALTER_BOX);
	export_constant(IG_TAURUS_DIADEM_SCROLL);
	export_constant(IG_TAURUS_DI_SCROLL_BOX);
	export_constant(IG_UMBALA_SPIRIT_BOX2);
	export_constant(IG_F_UMBALA_SPIRIT_BOX2);
	export_constant(IG_TAURUS_CROWN_SCROLL);
	export_constant(IG_TAURUS_CROWN_SCROLL_BOX);
	export_constant(IG_GEMI_DIADEM_SCROLL);
	export_constant(IG_GEMI_DIADEM_SCROLL_BOX);
	export_constant(IG_SUPER_PET_EGG1_2);
	export_constant(IG_SUPER_PET_EGG4_2);
	export_constant(IG_FIRE_BRAND_BOX);
	export_constant(IG_BR_INDEPENDENCE_SCROLL);
	export_constant(IG_ALL_IN_ONE_RING_BOX);
	export_constant(IG_GEMI_CROWN_SCROLL);
	export_constant(IG_GEMI_CROWN_SCROLL_BOX);
	export_constant(IG_RWC_SPECIAL_SCROLL);
	export_constant(IG_RWC_LIMITED_SCROLL);
	export_constant(IG_ASGARD_SCROLL);
	export_constant(IG_MS_CANCER_SCROLL);
	export_constant(IG_RWC_SUPER_SCROLL);
	export_constant(IG_LEO_SCROLL);
	export_constant(IG_MS_VIRGO_SCROLL);
	export_constant(IG_LUCKY_EGG_C6);
	export_constant(IG_LIBRA_SCROLL);
	export_constant(IG_HALLO_SCROLL);
	export_constant(IG_MS_SCORPIO_SCROLL);
	export_constant(IG_TCG_CARD_SCROLL);
	export_constant(IG_BOITATA_SCROLL);
	export_constant(IG_LUCKY_EGG_C2);
	export_constant(IG_LUCKY_EGG_C6_);
	export_constant(IG_LUCKY_EGG_C9);
	export_constant(IG_LUCKY_EGG_C7);
	export_constant(IG_LUCKY_EGG_C8);
	export_constant(IG_LUCKY_EGG_C10);
	export_constant(IG_WIND_TYPE_SCROLL);
	export_constant(IG_LUCKY_EGG_C3);
	export_constant(IG_LUCKY_EGG_C4);
	export_constant(IG_LUCKY_EGG_C5);
	export_constant(IG_WEATHER_REPORT_BOX);
	export_constant(IG_COMIN_ACTOR_BOX);
	export_constant(IG_HEN_SET_BOX);
	export_constant(IG_LUCKY_EGG_C);
	export_constant(IG_WATER_TYPE_SCROLL);
	export_constant(IG_EARTH_TYPE_SCROLL);
	export_constant(IG_EARTH_TYPE_SCROLL_);
	export_constant(IG_SPLASH_SCROLL);
	export_constant(IG_VOCATION_SCROLL);
	export_constant(IG_WISDOM_SCROLL);
	export_constant(IG_PATRON_SCROLL);
	export_constant(IG_HEAVEN_SCROLL);
	export_constant(IG_TW_AUG_SCROLL);
	export_constant(IG_TW_NOV_SCROLL2);
	export_constant(IG_ILLUSION_NOTHING);
	export_constant(IG_TW_SEP_SCROLL);
	export_constant(IG_FLAME_LIGHT);
	export_constant(IG_TW_RAINBOW_SCROLL);
	export_constant(IG_TW_RED_SCROLL);
	export_constant(IG_TW_ORANGE_SCROLL);
	export_constant(IG_TW_YELLOW_SCROLL);
	export_constant(IG_SCROLL_OF_DEATH);
	export_constant(IG_SCROLL_OF_LIFE);
	export_constant(IG_SCROLL_OF_MAGIC);
	export_constant(IG_SCROLL_OF_THEWS);
	export_constant(IG_SCROLL_OF_DARKNESS);
	export_constant(IG_SCROLL_OF_HOLINESS);
	export_constant(IG_HORNED_SCROLL);
	export_constant(IG_MERCURY_SCROLL);
	export_constant(IG_CHALLENGE_KIT);
	export_constant(IG_TW_APRIL_SCROLL);
	export_constant(IG_TW_OCTOBER_SCROLL_);
	export_constant(IG_SUMMER_SCROLL3);
	export_constant(IG_C_WING_OF_FLY_3DAY_BOX);
	export_constant(IG_RWC_2012_SET_BOX);
	export_constant(IG_EX_DEF_POTION_BOX);
	export_constant(IG_RWC_SCROLL_2012);
	export_constant(IG_OLD_COIN_POCKET);
	export_constant(IG_HIGH_COIN_POCKET);
	export_constant(IG_MID_COIN_POCKET);
	export_constant(IG_LOW_COIN_POCKET);
	export_constant(IG_SGRADE_POCKET);
	export_constant(IG_AGRADE_POCKET);
	export_constant(IG_BGRADE_POCKET);
	export_constant(IG_CGRADE_POCKET);
	export_constant(IG_DGRADE_POCKET);
	export_constant(IG_EGRADE_POCKET);
	export_constant(IG_PTOTECTION_SEAGOD_BOX);
	export_constant(IG_HAIRTAIL_BOX1);
	export_constant(IG_HAIRTAIL_BOX2);
	export_constant(IG_SPEARFISH_BOX1);
	export_constant(IG_SPEARFISH_BOX2);
	export_constant(IG_SAUREL_BOX1);
	export_constant(IG_SAUREL_BOX2);
	export_constant(IG_TUNA_BOX1);
	export_constant(IG_TUNA_BOX2);
	export_constant(IG_MALANG_CRAB_BOX1);
	export_constant(IG_MALANG_CRAB_BOX2);
	export_constant(IG_BRINDLE_EEL_BOX1);
	export_constant(IG_BRINDLE_EEL_BOX2);
	export_constant(IG_PTOTECTION_SEAGOD_BOX2);
	export_constant(IG_PTOTECTION_SEAGOD_BOX3);
	export_constant(IG_OCTO_HSTICK_BOX);
	export_constant(IG_OCTO_HSTICK_BOX2);
	export_constant(IG_OCTO_HSTICK_BOX3);
	export_constant(IG_SILVERVINE_FRUIT_BOX10);
	export_constant(IG_SILVERVINE_FRUIT_BOX40);
	export_constant(IG_SILVERVINE_FRUIT_BOX4);
	export_constant(IG_MALANG_WOE_ENCARD_BOX);
	export_constant(IG_XMAS_BLESS);
	export_constant(IG_FIRE_TYPE_SCROLL);
	export_constant(IG_BLUE_SCROLL);
	export_constant(IG_GOOD_STUDENT_GIFT_BOX);
	export_constant(IG_BAD_STUDENT_GIFT_BOX);
	export_constant(IG_INDIGO_SCROLL);
	export_constant(IG_VIOLET_SCROLL);
	export_constant(IG_BI_HWANG_SCROLL);
	export_constant(IG_JUNG_BI_SCROLL);
	export_constant(IG_JE_UN_SCROLL);
	export_constant(IG_YONG_KWANG_SCROLL);
	export_constant(IG_HALLOWEEN_G_BOX);
	export_constant(IG_SOLO_CHRISTMAS_GIFT);
	export_constant(IG_SG_WEAPON_SUPPLY_BOX);
	export_constant(IG_CANDY_HOLDER);
	export_constant(IG_LUCKY_BAG);
	export_constant(IG_HOLY_EGG_2);
	export_constant(IG_ADVENTURER_RETURNS_SUPPORT_BOX);
	export_constant(IG_SUPPORT_PACKAGE);
	export_constant(IG_SUPPORT_PACKAGE_10);
	export_constant(IG_EVENT_ALMIGHTY_BOX);
	export_constant(IG_EVENT_ALMIGHTY_BOX_100);
	export_constant(IG_LOTTOBOX1);
	export_constant(IG_LOTTOBOX2);
	export_constant(IG_LOTTOBOX3);
	export_constant(IG_LOTTOBOX4);
	export_constant(IG_LOTTOBOX5);
	export_constant(IG_SUPPORT_PACKAGE_III);
	export_constant(IG_SUPPORT_PACKAGE_III_10);
	export_constant(IG_UNLIMITED_BOX);
	export_constant(IG_UNLIMITED_BOX_10);
	export_constant(IG_UNLIMITED_BOX_II);
	export_constant(IG_UNLIMITED_BOX_II_10);
	export_constant(IG_THREE_MASTER_PACKAGE_III);
	export_constant(IG_THREE_MASTER_PACKAGE_III_10);
	export_constant(IG_2013_RWC_SCROLL);
	export_constant(IG_SUPPORT_PACKAGE_II);
	export_constant(IG_SUPPORT_PACKAGE_II_10);
	export_constant(IG_LEVEL_UP_BOX100);
	export_constant(IG_LEVEL_UP_BOX120);
	export_constant(IG_LEVEL_UP_BOX130);
	export_constant(IG_LEVEL_UP_BOX140);
	export_constant(IG_LEVEL_UP_BOX150);
	export_constant(IG_LEVEL_UP_BOX160);
	export_constant(IG_GIFT_BUFF_SET);
	export_constant(IG_LUCKY_SILVERVINE_FRUIT_BOX_III10);
	export_constant(IG_LUCKY_SILVERVINE_FRUIT_BOX_III110);
	export_constant(IG_OLD_ORE_BOX);
	export_constant(IG_BLESSING_LUCKY_SCROLL);
	export_constant(IG_SOGRAT_LUCKY_SCROLL);
	export_constant(IG_GARNET_LUCKY_SCROLL);
	export_constant(IG_AMORA_LUCKY_SCROLL);
	export_constant(IG_VENUS_LUCKY_SCROLL);
	export_constant(IG_ERZULIE_LUCKY_SCROLL);
	export_constant(IG_MAJESTIC_LUCKY_SCROLL);
	export_constant(IG_EPIC_HEROES_LUCKY_EGG);
	export_constant(IG_HERO_MIDGARD_EGG);
	export_constant(IG_IMORTAL_MIDGARD_SCROLL);
	export_constant(IG_TW_13Y_LUCKY_EGG_06);
	export_constant(IG_HAPPY_TIME_SCROLL);
	export_constant(IG_TIME_TRAVEL_SCROLL);
	export_constant(IG_SOLARIS_FESTIVAL_SCROLL);
	export_constant(IG_MIDGARD_FES_SCROLL);
	export_constant(IG_MIDGARD_SCROLL);
	export_constant(IG_SWEET_MIDGARD_SCROLL);
	export_constant(IG_WINTER_MIDGARD_SCROLL);
	export_constant(IG_SPRING_FESTIVAL_SCROLL);
	export_constant(IG_IDRO10TH_SCROLL);
	export_constant(IG_REQUIEM_SCROLL);
	export_constant(IG_HOLY_SPIRIT_SCROLL);
	export_constant(IG_GARUDA_SCROLL);
	export_constant(IG_THANKS_GIVING_SCROLL);
	export_constant(IG_IDN_LEGEND_HERO_SCROLL);
	export_constant(IG_BLESSING_MIDGARD_SCROLL);
	export_constant(IG_CHRONOSIAN_LUCKY_SCROLL);
	export_constant(IG_SANCTUARY_LUCKY_SCROLL);
	export_constant(IG_CYBORG_LUCKY_SCROLL);
	export_constant(IG_UNDINE_LUCKY_SCROLL);
	export_constant(IG_GOD_MATERIAL_BOX);
	export_constant(IG_SEALED_MIND_BOX);
	export_constant(IG_COSTAMA_EGG18);
	export_constant(IG_COSTAMA_EGG19);
	export_constant(IG_FLOWER_BLOSSOM_SCROLL);
	export_constant(IG_COSTAMA_EGG24);
	export_constant(IG_SMITHY_LUCKY_SCROLL);
	export_constant(IG_GANYMEDE_LUCKY_SCROLL);
	export_constant(IG_LASTANGEL_LUCKYSCROLL);
	export_constant(IG_VALKYRIE_LUCKY_SCROLL);
	export_constant(IG_SPLASH_RAINBOW_LUCKY_SCROLL);
	export_constant(IG_SHAPESHIFTER_COSTUME);
	export_constant(IG_JULY_LUCKY_SCROLL);
	export_constant(IG_COSTAMA_EGG23);
	export_constant(IG_COSTAMA_EGG28);
	export_constant(IG_MIDGARD_LUCKY_SCROLL);
	export_constant(IG_BLESSING_SCARLET_SCROLL);
	export_constant(IG_COSTAMA_EGG29);
	export_constant(IG_INK_BALL);
	export_constant(IG_SOMETHING_CANDY_HOLDER);
	export_constant(IG_SHINING_EGG);
	export_constant(IG_AGUST_LUCKY_SCROLL);
	export_constant(IG_ELEMENT);
	export_constant(IG_POISON);
	export_constant(IG_CASH_FOOD);
	export_constant(IG_BOMB);
	export_constant(IG_THROWABLE);
	export_constant(IG_MERCENARY);
	export_constant(IG_NOIVE_BOX);
	export_constant(IG_VALERIAN_SCROLL);
	export_constant(IG_IMMORTAL_EGG);
	export_constant(IG_SAPPHIRE_EGG);
	export_constant(IG_IDN_HEART_SCROLL);
	export_constant(IG_IDN_WISDOM_EGG);
	export_constant(IG_CHRISTMAS_BOX);
	export_constant(IG_SPECIAL_CHRISTMAS_BOX);
	export_constant(IG_SANTA_GIFT);
	export_constant(IG_PRIZEOFHERO);
	export_constant(IG_PRIVATE_AIRSHIP);
	export_constant(IG_TOKEN_OF_SIEGFRIED);

	/* unit stop walking */
	export_constant(USW_NONE);
	export_constant(USW_FIXPOS);
	export_constant(USW_MOVE_ONCE);
	export_constant(USW_MOVE_FULL_CELL);
	export_constant(USW_FORCE_STOP);
	export_constant(USW_ALL);

	/* achievement groups */
	export_constant2("AG_ADD_FRIEND", AG_ADD_FRIEND);
	export_constant2("AG_ADVENTURE", AG_ADVENTURE);
	export_constant2("AG_BABY", AG_BABY);
	export_constant2("AG_BATTLE", AG_BATTLE);
	export_constant2("AG_CHATTING", AG_CHAT);
	export_constant2("AG_CHATTING_COUNT", AG_CHAT_COUNT);
	export_constant2("AG_CHATTING_CREATE", AG_CHAT_CREATE);
	export_constant2("AG_CHATTING_DYING", AG_CHAT_DYING);
	export_constant2("AG_EAT", AG_EAT);
	export_constant2("AG_GET_ITEM", AG_GET_ITEM);
	export_constant2("AG_GET_ZENY", AG_GET_ZENY);
	export_constant2("AG_GOAL_ACHIEVE", AG_GOAL_ACHIEVE);
	export_constant2("AG_GOAL_LEVEL", AG_GOAL_LEVEL);
	export_constant2("AG_GOAL_STATUS", AG_GOAL_STATUS);
	export_constant2("AG_HEAR", AG_HEAR);
	export_constant2("AG_JOB_CHANGE", AG_JOB_CHANGE);
	export_constant2("AG_MARRY", AG_MARRY);
	export_constant2("AG_PARTY", AG_PARTY);
	export_constant2("AG_ENCHANT_FAIL", AG_REFINE_FAIL);
	export_constant2("AG_ENCHANT_SUCCESS", AG_REFINE_SUCCESS);
	export_constant2("AG_SEE", AG_SEE);
	export_constant2("AG_SPEND_ZENY", AG_SPEND_ZENY);
	export_constant2("AG_TAMING", AG_TAMING);

	/* achievement info */
	export_constant(ACHIEVEINFO_COUNT1);
	export_constant(ACHIEVEINFO_COUNT2);
	export_constant(ACHIEVEINFO_COUNT3);
	export_constant(ACHIEVEINFO_COUNT4);
	export_constant(ACHIEVEINFO_COUNT5);
	export_constant(ACHIEVEINFO_COUNT6);
	export_constant(ACHIEVEINFO_COUNT7);
	export_constant(ACHIEVEINFO_COUNT8);
	export_constant(ACHIEVEINFO_COUNT9);
	export_constant(ACHIEVEINFO_COUNT10);
	export_constant(ACHIEVEINFO_COMPLETE);
	export_constant(ACHIEVEINFO_COMPLETEDATE);
	export_constant(ACHIEVEINFO_GOTREWARD);
	export_constant(ACHIEVEINFO_LEVEL);
	export_constant(ACHIEVEINFO_SCORE);
	export_constant(ACHIEVEINFO_MAX);

	/* refine cost types */
	export_constant(REFINE_COST_NORMAL);
	export_constant(REFINE_COST_OVER10);
	export_constant(REFINE_COST_HD);
	export_constant(REFINE_COST_ENRICHED);
	export_constant(REFINE_COST_OVER10_HD);
	export_constant(REFINE_COST_HOLINK);
	export_constant(REFINE_COST_WAGJAK);
	export_constant(REFINE_COST_MAX);

	/* refine information types */
	script_set_constant("REFINE_MATERIAL_ID", 0, false, false);
	script_set_constant("REFINE_ZENY_COST", 1, false, false);

	/* NPC view ids */
	// Special macro to strip the prefix 'JT_'
	#define export_constant_npc(a) export_constant_offset(a,3)

	export_constant_npc(JT_WARPNPC);
	export_constant_npc(JT_1_ETC_01);
	export_constant_npc(JT_1_M_01);
	export_constant_npc(JT_1_M_02);
	export_constant_npc(JT_1_M_03);
	export_constant_npc(JT_1_M_04);
	export_constant_npc(JT_1_M_BARD);
	export_constant_npc(JT_1_M_HOF);
	export_constant_npc(JT_1_M_INNKEEPER);
	export_constant_npc(JT_1_M_JOBGUIDER);
	export_constant_npc(JT_1_M_JOBTESTER);
	export_constant_npc(JT_1_M_KNIGHTMASTER);
	export_constant_npc(JT_1_M_LIBRARYMASTER);
	export_constant_npc(JT_1_M_MERCHANT);
	export_constant_npc(JT_1_M_ORIENT01);
	export_constant_npc(JT_1_M_PASTOR);
	export_constant_npc(JT_1_M_PUBMASTER);
	export_constant_npc(JT_1_M_SIZ);
	export_constant_npc(JT_1_M_SMITH);
	export_constant_npc(JT_1_M_WIZARD);
	export_constant_npc(JT_1_M_YOUNGKNIGHT);
	export_constant_npc(JT_1_F_01);
	export_constant_npc(JT_1_F_02);
	export_constant_npc(JT_1_F_03);
	export_constant_npc(JT_1_F_04);
	export_constant_npc(JT_1_F_GYPSY);
	export_constant_npc(JT_1_F_LIBRARYGIRL);
	export_constant_npc(JT_1_F_MARIA);
	export_constant_npc(JT_1_F_MERCHANT_01);
	export_constant_npc(JT_1_F_MERCHANT_02);
	export_constant_npc(JT_1_F_ORIENT_01);
	export_constant_npc(JT_1_F_ORIENT_02);
	export_constant_npc(JT_1_F_ORIENT_03);
	export_constant_npc(JT_1_F_ORIENT_04);
	export_constant_npc(JT_1_F_PRIEST);
	export_constant_npc(JT_1_F_PUBGIRL);
	export_constant_npc(JT_4_DOG01);
	export_constant_npc(JT_4_KID01);
	export_constant_npc(JT_4_M_01);
	export_constant_npc(JT_4_M_02);
	export_constant_npc(JT_4_M_03);
	export_constant_npc(JT_4_M_04);
	export_constant_npc(JT_4_M_BARBER);
	export_constant_npc(JT_4_M_ORIENT01);
	export_constant_npc(JT_4_M_ORIENT02);
	export_constant_npc(JT_4_F_01);
	export_constant_npc(JT_4_F_02);
	export_constant_npc(JT_4_F_03);
	export_constant_npc(JT_4_F_04);
	export_constant_npc(JT_4_F_MAID);
	export_constant_npc(JT_4_F_SISTER);
	export_constant_npc(JT_4W_KID);
	export_constant_npc(JT_4W_M_01);
	export_constant_npc(JT_4W_M_02);
	export_constant_npc(JT_4W_M_03);
	export_constant_npc(JT_4W_SAILOR);
	export_constant_npc(JT_4W_F_01);
	export_constant_npc(JT_8_F);
	export_constant_npc(JT_8_F_GRANDMOTHER);
	export_constant_npc(JT_EFFECTLAUNCHER);
	export_constant_npc(JT_8W_SOLDIER);
	export_constant_npc(JT_1_M_MOC_LORD);
	export_constant_npc(JT_1_M_PAY_ELDER);
	export_constant_npc(JT_1_M_PRON_KING);
	export_constant_npc(JT_4_M_MANAGER);
	export_constant_npc(JT_4_M_MINISTER);
	export_constant_npc(JT_HIDDEN_NPC);
	export_constant_npc(JT_4_F_KAFRA6);
	export_constant_npc(JT_4_F_KAFRA5);
	export_constant_npc(JT_4_F_KAFRA4);
	export_constant_npc(JT_4_F_KAFRA3);
	export_constant_npc(JT_4_F_KAFRA2);
	export_constant_npc(JT_4_F_KAFRA1);
	export_constant_npc(JT_2_M_THIEFMASTER);
	export_constant_npc(JT_2_M_SWORDMASTER);
	export_constant_npc(JT_2_M_PHARMACIST);
	export_constant_npc(JT_2_M_MOLGENSTEIN);
	export_constant_npc(JT_2_M_DYEINGER);
	export_constant_npc(JT_2_F_MAGICMASTER);
	export_constant_npc(JT_4_F_TELEPORTER);
	export_constant_npc(JT_4_M_TELEPORTER);
	export_constant_npc(JT_HIDDEN_WARP_NPC);
	export_constant_npc(JT_4_M_MUT2);
	export_constant_npc(JT_4_M_SCIENCE);
	export_constant_npc(JT_4_F_VALKYRIE2);
	export_constant_npc(JT_4_M_UNCLEKNIGHT);
	export_constant_npc(JT_4_M_YOUNGKNIGHT);
	export_constant_npc(JT_2_MONEMUS);
	export_constant_npc(JT_4_M_ATEIL);
	export_constant_npc(JT_4_F_ANNIVERSARY);
	export_constant_npc(JT_4_M_GREATPO);
	export_constant_npc(JT_4_M_NOVELIST);
	export_constant_npc(JT_4_M_CHAMPSOUL);
	export_constant_npc(JT_4_M_OLDFRIAR);
	export_constant_npc(JT_4_M_CRU_SOLD);
	export_constant_npc(JT_4_M_CRU_KNT);
	export_constant_npc(JT_4_M_CRU_HEAD);
	export_constant_npc(JT_4_M_CRU_CRUA);
	export_constant_npc(JT_4_M_KY_SOLD);
	export_constant_npc(JT_4_M_KY_KNT);
	export_constant_npc(JT_4_M_KY_HEAD);
	export_constant_npc(JT_4_M_KY_KIYOM);
	export_constant_npc(JT_4_M_BOSSCAT);
	export_constant_npc(JT_4_M_BABYCAT);
	export_constant_npc(JT_4W_F_KAFRA2);
	export_constant_npc(JT_4_F_MUNAK);
	export_constant_npc(JT_4_M_BONGUN);
	export_constant_npc(JT_4_BEAR);
	export_constant_npc(JT_4_BLUEWOLF);
	export_constant_npc(JT_4_PECOPECO);
	export_constant_npc(JT_4_M_JP_MID);
	export_constant_npc(JT_4_M_JP_RUN);
	export_constant_npc(JT_4_ORCLADY);
	export_constant_npc(JT_4_ORCLADY2);
	export_constant_npc(JT_4_ORCWARRIOR);
	export_constant_npc(JT_4_ORCWARRIOR2);
	export_constant_npc(JT_4_F_FAIRY);
	export_constant_npc(JT_4_F_FAIRYKID);
	export_constant_npc(JT_4_F_FAIRYKID2);
	export_constant_npc(JT_4_F_FAIRYKID3);
	export_constant_npc(JT_4_F_FAIRYKID4);
	export_constant_npc(JT_4_F_FAIRYKID5);
	export_constant_npc(JT_4_F_FAIRYKID6);
	export_constant_npc(JT_4_M_FAIRYKID);
	export_constant_npc(JT_4_M_FAIRYKID2);
	export_constant_npc(JT_4_M_FAIRYKID3);
	export_constant_npc(JT_4_M_FAIRYKID4);
	export_constant_npc(JT_4_M_FAIRYKID5);
	export_constant_npc(JT_4_M_FAIRYSOLDIER);
	export_constant_npc(JT_4_M_TUFFOLD);
	export_constant_npc(JT_4_MAN_BENKUNI);
	export_constant_npc(JT_4_MAN_GALTUN);
	export_constant_npc(JT_4_MAN_JERUTOO);
	export_constant_npc(JT_4_MAN_LAVAIL);
	export_constant_npc(JT_4_MAN_NITT);
	export_constant_npc(JT_4_MAN_PIOM);
	export_constant_npc(JT_4_MAN_PIOM2);
	export_constant_npc(JT_4_M_DSTMAN);
	export_constant_npc(JT_4_M_DSTMANDEAD);
	export_constant_npc(JT_4_BABYLEOPARD);
	export_constant_npc(JT_4_M_REDSWORD);
	export_constant_npc(JT_4_MAN_PIOM3);
	export_constant_npc(JT_4_M_FAIRYSOLDIER2);
	export_constant_npc(JT_4_F_FAIRYSOLDIER);
	export_constant_npc(JT_4_DRAGON_EGG);
	export_constant_npc(JT_4_MIMIC);
	export_constant_npc(JT_4_F_FAIRY1);
	export_constant_npc(JT_4_F_GUILLOTINE);
	export_constant_npc(JT_4_M_GUILLOTINE);
	export_constant_npc(JT_4_M_KNIGHT_BLACK);
	export_constant_npc(JT_4_M_KNIGHT_GOLD);
	export_constant_npc(JT_4_M_KNIGHT_SILVER);
	export_constant_npc(JT_4_SKULL_MUD);
	export_constant_npc(JT_4_M_BRZ_INDIAN);
	export_constant_npc(JT_4_F_BRZ_INDIAN);
	export_constant_npc(JT_4_F_BRZ_INDOLD);
	export_constant_npc(JT_4_M_BRZ_JACI);
	export_constant_npc(JT_4_M_BRZ_MAN1);
	export_constant_npc(JT_4_M_BRZ_MAN2);
	export_constant_npc(JT_4_F_BRZ_WOMAN);
	export_constant_npc(JT_4_M_MINSTREL);
	export_constant_npc(JT_4_M_MINSTREL1);
	export_constant_npc(JT_4_M_SHADOWCHASER);
	export_constant_npc(JT_4_F_SHADOWCHASER);
	export_constant_npc(JT_4_M_SURA);
	export_constant_npc(JT_4_F_SURA);
	export_constant_npc(JT_4_F_WANDERER);
	export_constant_npc(JT_4_M_BARD);
	export_constant_npc(JT_1_FLAG_NOFEAR);
	export_constant_npc(JT_4_M_NOFEARGUY);
	export_constant_npc(JT_4_MAN_PIOM6);
	export_constant_npc(JT_4_MAN_PIOM4);
	export_constant_npc(JT_4_MAN_PIOM5);
	export_constant_npc(JT_4_MAN_GALTUN1);
	export_constant_npc(JT_4_HUMAN_GERUTOO);
	export_constant_npc(JT_4_M_ROKI);
	export_constant_npc(JT_4_M_MERCAT1);
	export_constant_npc(JT_4_M_MERCAT2);
	export_constant_npc(JT_4_M_CATMAN1);
	export_constant_npc(JT_4_M_CATMAN2);
	export_constant_npc(JT_4_F_BRZ_WOMAN2);
	export_constant_npc(JT_4_M_JP_DISH);
	export_constant_npc(JT_4_F_JP_NOAH);
	export_constant_npc(JT_4_F_JP_OZ);
	export_constant_npc(JT_4_F_JP_CHROME);
	export_constant_npc(JT_4_F_JP_RINNE);
	export_constant_npc(JT_4_WHITETIGER);
	export_constant_npc(JT_4_VENDING_MACHINE);
	export_constant_npc(JT_4_MISTY);
	export_constant_npc(JT_4_NECORING);
	export_constant_npc(JT_4_ELEPHANT);
	export_constant_npc(JT_4_F_NYDHOG);
	export_constant_npc(JT_4_F_NYDHOG2);
	export_constant_npc(JT_4_M_ROKI2);
	export_constant_npc(JT_4_M_DOGTRAVELER);
	export_constant_npc(JT_4_M_DOGTRAVELER2);
	export_constant_npc(JT_4_F_DOGTRAVELER);
	export_constant_npc(JT_4_M_RAFLE_GR);
	export_constant_npc(JT_4_M_RAFLE_OLD);
	export_constant_npc(JT_4_F_RAFLE_PK);
	export_constant_npc(JT_4_M_LYINGDOG);
	export_constant_npc(JT_4_F_MORAFINE1);
	export_constant_npc(JT_4_F_MORAFINE2);
	export_constant_npc(JT_4_M_RAFLE_OR);
	export_constant_npc(JT_4_F_RAFLE_YE);
	export_constant_npc(JT_4_M_RAFLE_VI);
	export_constant_npc(JT_4_F_RAFLE_VI);
	export_constant_npc(JT_4_M_ARDHA);
	export_constant_npc(JT_4_CREEPER);
	export_constant_npc(JT_JP_RUFAKU);
	export_constant_npc(JT_JP_SUPIKA);
	export_constant_npc(JT_JP_SABIKU);
	export_constant_npc(JT_JP_ARUGORU);
	export_constant_npc(JT_JP_ARUNA);
	export_constant_npc(JT_JP_AIRI);
	export_constant_npc(JT_4_M_DEWOLDMAN);
	export_constant_npc(JT_4_M_DEWOLDWOMAN);
	export_constant_npc(JT_4_M_DEWMAN);
	export_constant_npc(JT_4_M_DEWWOMAN);
	export_constant_npc(JT_4_M_DEWBOY);
	export_constant_npc(JT_4_M_DEWGIRL);
	export_constant_npc(JT_4_M_DEWZATICHIEF);
	export_constant_npc(JT_4_M_DEWZATIMAN);
	export_constant_npc(JT_4_M_ALCHE_E);
	export_constant_npc(JT_4_MASK_SMOKEY);
	export_constant_npc(JT_4_CAT_SAILOR1);
	export_constant_npc(JT_4_CAT_SAILOR2);
	export_constant_npc(JT_4_CAT_SAILOR3);
	export_constant_npc(JT_4_CAT_SAILOR4);
	export_constant_npc(JT_4_CAT_CHEF);
	export_constant_npc(JT_4_CAT_MERMASTER);
	export_constant_npc(JT_4_CRACK);
	export_constant_npc(JT_4_ASTER);
	export_constant_npc(JT_4_F_STARFISHGIRL);
	export_constant_npc(JT_4_CAT_DOWN);
	export_constant_npc(JT_4_CAT_REST);
	export_constant_npc(JT_4_CAT_3COLOR);
	export_constant_npc(JT_4_CAT_ADMIRAL);
	export_constant_npc(JT_4_SOIL);
	export_constant_npc(JT_4_F_ALCHE_A);
	export_constant_npc(JT_4_CAT_ADV1);
	export_constant_npc(JT_4_CAT_ADV2);
	export_constant_npc(JT_4_CAT_SAILOR5);
	export_constant_npc(JT_2_DROP_MACHINE);
	export_constant_npc(JT_2_SLOT_MACHINE);
	export_constant_npc(JT_2_VENDING_MACHINE1);
	export_constant_npc(JT_MOB_TOMB);
	export_constant_npc(JT_4_MYSTCASE);
	export_constant_npc(JT_4_M_SIT_NOVICE);
	export_constant_npc(JT_4_OCTOPUS_LEG);
	export_constant_npc(JT_4_F_NURSE);
	export_constant_npc(JT_4_MAL_SOLDIER);
	export_constant_npc(JT_4_MAL_CAPTAIN);
	export_constant_npc(JT_4_MAL_BUDIDAI);
	export_constant_npc(JT_4_M_MAYOR);
	export_constant_npc(JT_4_M_BARYO_OLD);
	export_constant_npc(JT_4_F_BARYO_OLD);
	export_constant_npc(JT_4_F_BARYO_GIRL);
	export_constant_npc(JT_4_M_BARYO_BOY);
	export_constant_npc(JT_4_M_BARYO_MAN);
	export_constant_npc(JT_4_F_BARYO_WOMAN);
	export_constant_npc(JT_4_BARYO_CHIEF);
	export_constant_npc(JT_4_MAL_KAFRA);
	export_constant_npc(JT_4_M_MALAYA);
	export_constant_npc(JT_4_F_MALAYA);
	export_constant_npc(JT_4_F_PATIENT);
	export_constant_npc(JT_4_M_PATIENT);
	export_constant_npc(JT_4_F_KR_TIGER);
	export_constant_npc(JT_4_M_KR_BOY);
	export_constant_npc(JT_4_M_KAGE_OLD);
	export_constant_npc(JT_4_WHIKEBAIN);
	export_constant_npc(JT_4_EREND);
	export_constant_npc(JT_4_RAWREL);
	export_constant_npc(JT_4_ARMAIA);
	export_constant_npc(JT_4_KAVAC);
	export_constant_npc(JT_4_YGNIZEM);
	export_constant_npc(JT_4_EREMES);
	export_constant_npc(JT_4_MAGALETA);
	export_constant_npc(JT_4_KATRINN);
	export_constant_npc(JT_4_SHECIL);
	export_constant_npc(JT_4_SEYREN);
	export_constant_npc(JT_4_HARWORD);
	export_constant_npc(JT_4_F_JP_CYNTHIA);
	export_constant_npc(JT_4_M_JP_GUSTON);
	export_constant_npc(JT_4_M_JP_BERKUT);
	export_constant_npc(JT_4_F_JP_DARK_ADELAIDE);
	export_constant_npc(JT_4_M_JP_DARK_DARIUS);
	export_constant_npc(JT_4_M_JP_JESTER);
	export_constant_npc(JT_XMAS_SMOKEY_B);
	export_constant_npc(JT_XMAS_SMOKEY_R);
	export_constant_npc(JT_XMAS_SMOKEY_Y);
	export_constant_npc(JT_4_F_CLOCKDOLL);
	export_constant_npc(JT_4_F_FAIRY2);
	export_constant_npc(JT_4_F_PINKWOMAN);
	export_constant_npc(JT_4_FAIRYDEADLEAF);
	export_constant_npc(JT_4_FROG);
	export_constant_npc(JT_4_M_BLACKMAN);
	export_constant_npc(JT_4_M_BLUEMAN);
	export_constant_npc(JT_4_M_FAIRYANG);
	export_constant_npc(JT_4_M_FAIRYAVANT);
	export_constant_npc(JT_4_M_FAIRYFREAK);
	export_constant_npc(JT_4_M_FAIRYKID6);
	export_constant_npc(JT_4_M_FAIRYSCHOLAR);
	export_constant_npc(JT_4_M_FAIRYSCHOLAR_DIRTY);
	export_constant_npc(JT_4_M_FARIY_HISIE);
	export_constant_npc(JT_4_M_FARIYKING);
	export_constant_npc(JT_4_M_NEWOZ);
	export_constant_npc(JT_4_M_OLIVER);
	export_constant_npc(JT_4_M_PROFESSORWORM);
	export_constant_npc(JT_4_M_REDMAN);
	export_constant_npc(JT_4_F_GELKA);
	export_constant_npc(JT_4_M_ROTERT);
	export_constant_npc(JT_4_BLACKDRAGON);
	export_constant_npc(JT_4_M_GUNSLINGER);
	export_constant_npc(JT_4_F_GUNSLINGER);
	export_constant_npc(JT_4_M_ARCHER);
	export_constant_npc(JT_4_M_SWORDMAN);
	export_constant_npc(JT_4_M_NINJA_RED);
	export_constant_npc(JT_4_M_NINJA_BLUE);
	export_constant_npc(JT_4_M_THIEF_RUMIN);
	export_constant_npc(JT_4_M_NOV_RUMIN);
	export_constant_npc(JT_4_F_MAYSEL);
	export_constant_npc(JT_4_F_ACOLYTE);
	export_constant_npc(JT_4_M_NOV_HUNT);
	export_constant_npc(JT_4_F_GENETIC);
	export_constant_npc(JT_4_F_TAEKWON);
	export_constant_npc(JT_4_F_SWORDMAN);
	export_constant_npc(JT_4_F_IU);
	export_constant_npc(JT_4_M_RAGI);
	export_constant_npc(JT_4_M_MELODY);
	export_constant_npc(JT_4_TRACE);
	export_constant_npc(JT_4_F_HIMEL);
	export_constant_npc(JT_4_LEVITATEMAN);
	export_constant_npc(JT_4_M_HEINRICH);
	export_constant_npc(JT_4_M_ROYALGUARD);
	export_constant_npc(JT_4_M_BARMUND);
	export_constant_npc(JT_4_F_KHALITZBURG);
	export_constant_npc(JT_4_F_HIMEL2);
	export_constant_npc(JT_4_WHITEKNIGHT);
	export_constant_npc(JT_4_COCO);
	export_constant_npc(JT_4_M_ALADDIN);
	export_constant_npc(JT_4_M_GENIE);
	export_constant_npc(JT_4_F_GENIE);
	export_constant_npc(JT_4_JP_MID_SWIM);
	export_constant_npc(JT_4_JP_RUNE_SWIM);
	export_constant_npc(JT_4_F_FENRIR);
	export_constant_npc(JT_4_F_GEFFEN_FAY);
	export_constant_npc(JT_4_F_IRIS);
	export_constant_npc(JT_4_F_LUCILE);
	export_constant_npc(JT_4_F_SARAH_BABY);
	export_constant_npc(JT_4_GEFFEN_01);
	export_constant_npc(JT_4_GEFFEN_02);
	export_constant_npc(JT_4_GEFFEN_03);
	export_constant_npc(JT_4_GEFFEN_04);
	export_constant_npc(JT_4_GEFFEN_05);
	export_constant_npc(JT_4_GEFFEN_06);
	export_constant_npc(JT_4_GEFFEN_07);
	export_constant_npc(JT_4_GEFFEN_08);
	export_constant_npc(JT_4_GEFFEN_09);
	export_constant_npc(JT_4_GEFFEN_10);
	export_constant_npc(JT_4_GEFFEN_11);
	export_constant_npc(JT_4_GEFFEN_12);
	export_constant_npc(JT_4_GEFFEN_13);
	export_constant_npc(JT_4_GEFFEN_14);
	export_constant_npc(JT_4_M_CHAOS);
	export_constant_npc(JT_4_M_CHIEF_IRIN);
	export_constant_npc(JT_4_M_SAKRAY);
	export_constant_npc(JT_4_M_SAKRAYROYAL);
	export_constant_npc(JT_4_TOWER_01);
	export_constant_npc(JT_4_TOWER_02);
	export_constant_npc(JT_4_TOWER_03);
	export_constant_npc(JT_4_TOWER_04);
	export_constant_npc(JT_4_TOWER_05);
	export_constant_npc(JT_4_TOWER_06);
	export_constant_npc(JT_4_TOWER_07);
	export_constant_npc(JT_4_TOWER_08);
	export_constant_npc(JT_4_TOWER_09);
	export_constant_npc(JT_4_TOWER_10);
	export_constant_npc(JT_4_TOWER_11);
	export_constant_npc(JT_4_TOWER_12);
	export_constant_npc(JT_4_TOWER_13);
	export_constant_npc(JT_8_F_GIRL);
	export_constant_npc(JT_4_F_GODEMOM);
	export_constant_npc(JT_4_F_GON);
	export_constant_npc(JT_4_F_KID2);
	export_constant_npc(JT_4_M_BIBI);
	export_constant_npc(JT_4_M_GEF_SOLDIER);
	export_constant_npc(JT_4_M_KID1);
	export_constant_npc(JT_4_M_MOC_SOLDIER);
	export_constant_npc(JT_4_M_PAY_SOLDIER);
	export_constant_npc(JT_4_M_SEAMAN);
	export_constant_npc(JT_4_M_SNOWMAN);
	export_constant_npc(JT_4_F_05);
	export_constant_npc(JT_4_M_05);
	export_constant_npc(JT_4_M_06);
	export_constant_npc(JT_4_F_06);
	export_constant_npc(JT_4_M_PIERROT);
	export_constant_npc(JT_4_M_KID2);
	export_constant_npc(JT_4_F_KID3);
	export_constant_npc(JT_4_M_SANTA);
	export_constant_npc(JT_4_F_NACORURI);
	export_constant_npc(JT_4_F_SHAMAN);
	export_constant_npc(JT_4_F_KAFRA7);
	export_constant_npc(JT_GUILD_FLAG);
	export_constant_npc(JT_1_SHADOW_NPC);
	export_constant_npc(JT_4_F_07);
	export_constant_npc(JT_4_F_JOB_ASSASSIN);
	export_constant_npc(JT_4_F_JOB_BLACKSMITH);
	export_constant_npc(JT_4_F_JOB_HUNTER);
	export_constant_npc(JT_4_F_JOB_KNIGHT);
	export_constant_npc(JT_4_F_NOVICE);
	export_constant_npc(JT_4_M_JOB_ASSASSIN);
	export_constant_npc(JT_4_M_JOB_BLACKSMITH);
	export_constant_npc(JT_4_M_JOB_HUNTER);
	export_constant_npc(JT_4_M_JOB_KNIGHT1);
	export_constant_npc(JT_4_M_JOB_KNIGHT2);
	export_constant_npc(JT_4_M_JOB_WIZARD);
	export_constant_npc(JT_4_BAPHOMET);
	export_constant_npc(JT_4_DARKLORD);
	export_constant_npc(JT_4_DEVIRUCHI);
	export_constant_npc(JT_8_DOPPEL);
	export_constant_npc(JT_2_M_ALCHE);
	export_constant_npc(JT_2_M_BARD_ORIENT);
	export_constant_npc(JT_2_M_SAGE_B);
	export_constant_npc(JT_2_M_SAGE_OLD);
	export_constant_npc(JT_4_F_ALCHE);
	export_constant_npc(JT_4_F_CRU);
	export_constant_npc(JT_4_F_MONK);
	export_constant_npc(JT_4_F_ROGUE);
	export_constant_npc(JT_4_M_ALCHE_A);
	export_constant_npc(JT_4_M_ALCHE_B);
	export_constant_npc(JT_4_M_ALCHE_C);
	export_constant_npc(JT_4_M_CRU);
	export_constant_npc(JT_4_M_CRU_OLD);
	export_constant_npc(JT_4_M_MONK);
	export_constant_npc(JT_4_M_SAGE_A);
	export_constant_npc(JT_4_M_SAGE_C);
	export_constant_npc(JT_4_F_SON);
	export_constant_npc(JT_4_F_JPN2);
	export_constant_npc(JT_4_F_JPN);
	export_constant_npc(JT_4_F_JPNCHIBI);
	export_constant_npc(JT_4_F_JPNOBA2);
	export_constant_npc(JT_4_F_JPNOBA);
	export_constant_npc(JT_4_M_JPN2);
	export_constant_npc(JT_4_M_JPN);
	export_constant_npc(JT_4_M_JPNCHIBI);
	export_constant_npc(JT_4_M_JPNOJI2);
	export_constant_npc(JT_4_M_JPNOJI);
	export_constant_npc(JT_8_M_JPNSOLDIER);
	export_constant_npc(JT_8_M_JPNMASTER);
	export_constant_npc(JT_4_F_JPNMU);
	export_constant_npc(JT_4_F_TWGIRL);
	export_constant_npc(JT_4_F_TWGRANDMOM);
	export_constant_npc(JT_4_F_TWMASKGIRL);
	export_constant_npc(JT_4_F_TWMIDWOMAN);
	export_constant_npc(JT_4_M_TWBOY);
	export_constant_npc(JT_4_M_TWMASKMAN);
	export_constant_npc(JT_4_M_TWMIDMAN);
	export_constant_npc(JT_4_M_TWOLDMAN);
	export_constant_npc(JT_4_M_TWTEAMAN);
	export_constant_npc(JT_4_M_YOYOROGUE);
	export_constant_npc(JT_8_M_TWSOLDIER);
	export_constant_npc(JT_4_F_UMGIRL);
	export_constant_npc(JT_4_F_UMOLDWOMAN);
	export_constant_npc(JT_4_F_UMWOMAN);
	export_constant_npc(JT_4_M_UMCHIEF);
	export_constant_npc(JT_4_M_UMDANCEKID2);
	export_constant_npc(JT_4_M_UMDANCEKID);
	export_constant_npc(JT_4_M_UMKID);
	export_constant_npc(JT_4_M_UMOLDMAN);
	export_constant_npc(JT_4_M_UMSOLDIER);
	export_constant_npc(JT_4_M_SALVATION);
	export_constant_npc(JT_4_F_NFDEADKAFRA);
	export_constant_npc(JT_4_F_NFDEADMGCIAN);
	export_constant_npc(JT_4_F_NFLOSTGIRL);
	export_constant_npc(JT_4_M_NFDEADMAN2);
	export_constant_npc(JT_4_M_NFDEADMAN);
	export_constant_npc(JT_4_M_NFDEADSWDMAN);
	export_constant_npc(JT_4_M_NFLOSTMAN);
	export_constant_npc(JT_4_M_NFMAN);
	export_constant_npc(JT_4_NFBAT);
	export_constant_npc(JT_4_NFCOCK);
	export_constant_npc(JT_4_NFCOFFIN);
	export_constant_npc(JT_4_NFWISP);
	export_constant_npc(JT_1_F_SIGNZISK);
	export_constant_npc(JT_1_M_SIGN1);
	export_constant_npc(JT_1_M_SIGNALCHE);
	export_constant_npc(JT_1_M_SIGNART);
	export_constant_npc(JT_1_M_SIGNMCNT);
	export_constant_npc(JT_1_M_SIGNMONK2);
	export_constant_npc(JT_1_M_SIGNMONK);
	export_constant_npc(JT_1_M_SIGNROGUE);
	export_constant_npc(JT_4_F_VALKYRIE);
	export_constant_npc(JT_TW_TOWER);
	export_constant_npc(JT_2_M_OLDBLSMITH);
	export_constant_npc(JT_4_F_CHNDOCTOR);
	export_constant_npc(JT_4_F_CHNDRESS1);
	export_constant_npc(JT_4_F_CHNDRESS2);
	export_constant_npc(JT_4_F_CHNDRESS3);
	export_constant_npc(JT_4_F_CHNWOMAN);
	export_constant_npc(JT_4_M_CHN8GUEK);
	export_constant_npc(JT_4_M_CHNCOOK);
	export_constant_npc(JT_4_M_CHNGENERL);
	export_constant_npc(JT_4_M_CHNMAN);
	export_constant_npc(JT_4_M_CHNMONK);
	export_constant_npc(JT_4_M_CHNOLD);
	export_constant_npc(JT_4_M_CHNSOLDIER);
	export_constant_npc(JT_4_M_DWARF);
	export_constant_npc(JT_4_M_GRANDMONK);
	export_constant_npc(JT_4_M_ROGUE);
	export_constant_npc(JT_4_M_DOMINO);
	export_constant_npc(JT_4_F_DOMINO);
	export_constant_npc(JT_4_F_ZONDAGIRL);
	export_constant_npc(JT_4_M_REIDIN_KURS);
	export_constant_npc(JT_4_M_ZONDAOYAJI);
	export_constant_npc(JT_4_M_BUDDHIST);
	export_constant_npc(JT_2_BOARD1);
	export_constant_npc(JT_2_BOARD2);
	export_constant_npc(JT_2_BULLETIN_BOARD);
	export_constant_npc(JT_4_F_THAIAYO);
	export_constant_npc(JT_4_F_THAIGIRL);
	export_constant_npc(JT_4_F_THAISHAMAN);
	export_constant_npc(JT_4_M_THAIAYO);
	export_constant_npc(JT_4_M_THAIOLD);
	export_constant_npc(JT_4_M_THAIONGBAK);
	export_constant_npc(JT_CLEAR_NPC);
	export_constant_npc(JT_4_F_RACING);
	export_constant_npc(JT_4_F_EINOLD);
	export_constant_npc(JT_4_M_EINOLD);
	export_constant_npc(JT_4_M_EINMINER);
	export_constant_npc(JT_4_M_DIEMAN);
	export_constant_npc(JT_4_F_EINWOMAN);
	export_constant_npc(JT_4_M_REPAIR);
	export_constant_npc(JT_4_M_EIN_SOLDIER);
	export_constant_npc(JT_4_M_YURI);
	export_constant_npc(JT_4_M_EINMAN2);
	export_constant_npc(JT_4_M_EINMAN);
	export_constant_npc(JT_2_F_SIGN1);
	export_constant_npc(JT_4_BOARD3);
	export_constant_npc(JT_4_BULLETIN_BOARD2);
	export_constant_npc(JT_4_F_AGENTKAFRA);
	export_constant_npc(JT_4_F_KAFRA8);
	export_constant_npc(JT_4_F_KAFRA9);
	export_constant_npc(JT_4_F_LGTGIRL);
	export_constant_npc(JT_4_F_LGTGRAND);
	export_constant_npc(JT_4_F_OPERATION);
	export_constant_npc(JT_4_LGTSCIENCE);
	export_constant_npc(JT_4_M_LGTGRAND);
	export_constant_npc(JT_4_M_LGTGUARD2);
	export_constant_npc(JT_4_M_LGTGUARD);
	export_constant_npc(JT_4_M_LGTMAN);
	export_constant_npc(JT_4_M_LGTPOOR);
	export_constant_npc(JT_4_M_OPERATION);
	export_constant_npc(JT_4_M_PRESIDENT);
	export_constant_npc(JT_4_M_REINDEER);
	export_constant_npc(JT_4_M_ZONDAMAN);
	export_constant_npc(JT_4_M_PECOKNIGHT);
	export_constant_npc(JT_4_CAT);
	export_constant_npc(JT_4_F_YUNYANG);
	export_constant_npc(JT_4_M_OILMAN);
	export_constant_npc(JT_4_F_CAPEGIRL);
	export_constant_npc(JT_4_M_MASKMAN);
	export_constant_npc(JT_4_M_SITDOWN);
	export_constant_npc(JT_4_F_SITDOWN);
	export_constant_npc(JT_4_M_ALCHE_D);
	export_constant_npc(JT_4_M_ACROSS);
	export_constant_npc(JT_4_F_ACROSS);
	export_constant_npc(JT_4_COOK);
	export_constant_npc(JT_4_M_LIEMAN);
	export_constant_npc(JT_2_POSTBOX);
	export_constant_npc(JT_4_BULL);
	export_constant_npc(JT_4_LAM);
	export_constant_npc(JT_4_F_HUGIRL);
	export_constant_npc(JT_4_F_HUGRANMA);
	export_constant_npc(JT_4_F_HUWOMAN);
	export_constant_npc(JT_4_F_KHELLISIA);
	export_constant_npc(JT_4_F_KHELLY);
	export_constant_npc(JT_4_M_HUBOY);
	export_constant_npc(JT_4_M_HUGRANFA);
	export_constant_npc(JT_4_M_HUMAN_01);
	export_constant_npc(JT_4_M_HUMAN_02);
	export_constant_npc(JT_4_M_HUMERCHANT);
	export_constant_npc(JT_4_M_HUOLDARMY);
	export_constant_npc(JT_4_M_KHKIEL);
	export_constant_npc(JT_4_M_KHKYEL);
	export_constant_npc(JT_4_M_KHMAN);
	export_constant_npc(JT_4_F_KHWOMAN);
	export_constant_npc(JT_4_F_KHGIRL);
	export_constant_npc(JT_4_M_KHBOY);
	export_constant_npc(JT_4_M_PHILMAN);
	export_constant_npc(JT_4_PORING);
	export_constant_npc(JT_2_COLAVEND);
	export_constant_npc(JT_4_F_SOCCER);
	export_constant_npc(JT_4_M_SOCCER7);
	export_constant_npc(JT_4_M_SOCCER9);
	export_constant_npc(JT_4_F_CHILD);
	export_constant_npc(JT_4_F_MADAME);
	export_constant_npc(JT_4_F_MASK1);
	export_constant_npc(JT_4_F_MASK);
	export_constant_npc(JT_4_F_RACHOLD);
	export_constant_npc(JT_4_F_SHABBY);
	export_constant_npc(JT_4_F_TRAINEE);
	export_constant_npc(JT_4_M_CHILD1);
	export_constant_npc(JT_4_M_CHILD);
	export_constant_npc(JT_4_M_DOCTOR);
	export_constant_npc(JT_4_M_FROZEN1);
	export_constant_npc(JT_4_M_FROZEN);
	export_constant_npc(JT_4_M_MASK1);
	export_constant_npc(JT_4_M_MASK);
	export_constant_npc(JT_4_M_MIDDLE1);
	export_constant_npc(JT_4_M_MIDDLE);
	export_constant_npc(JT_4_M_RACHMAN2);
	export_constant_npc(JT_4_M_RACHMAN1);
	export_constant_npc(JT_4_M_RACHOLD1);
	export_constant_npc(JT_4_M_RACHOLD);
	export_constant_npc(JT_4_M_RASWORD);
	export_constant_npc(JT_4_M_TRAINEE);
	export_constant_npc(JT_4_F_ARUNA_POP);
	export_constant_npc(JT_4_M_ARUNA_NFM1);
	export_constant_npc(JT_4_DST_CAMEL);
	export_constant_npc(JT_4_DST_SOLDIER);
	export_constant_npc(JT_4_F_DESERT);
	export_constant_npc(JT_4_F_DST_CHILD);
	export_constant_npc(JT_4_F_DST_GRAND);
	export_constant_npc(JT_4_M_DESERT);
	export_constant_npc(JT_4_M_DST_CHILD);
	export_constant_npc(JT_4_M_DST_GRAND);
	export_constant_npc(JT_4_M_DST_MASTER);
	export_constant_npc(JT_4_M_DST_TOUGH);
	export_constant_npc(JT_4_ANGELING);
	export_constant_npc(JT_4_ARCHANGELING);
	export_constant_npc(JT_4_GHOSTRING);
	export_constant_npc(JT_4_F_EDEN_MASTER);
	export_constant_npc(JT_4_F_EDEN_OFFICER);
	export_constant_npc(JT_4_M_EDEN_GUARDER);
	export_constant_npc(JT_4_M_PATRICK);
	export_constant_npc(JT_4_DONKEY);
	export_constant_npc(JT_4_M_TRISTAN);
	export_constant_npc(JT_4_WHITE_COW);
	export_constant_npc(JT_4_F_RUSCHILD);
	export_constant_npc(JT_4_F_RUSWOMAN1);
	export_constant_npc(JT_4_F_RUSWOMAN2);
	export_constant_npc(JT_4_F_RUSWOMAN3);
	export_constant_npc(JT_4_M_RUSCHILD);
	export_constant_npc(JT_4_M_GUSLIMAN);
	export_constant_npc(JT_4_M_RUSBALD);
	export_constant_npc(JT_4_M_RUSKING);
	export_constant_npc(JT_4_M_RUSKNIGHT);
	export_constant_npc(JT_4_M_RUSMAN1);
	export_constant_npc(JT_4_M_RUSMAN2);
	export_constant_npc(JT_4_M_DRAKE);
	export_constant_npc(JT_4_F_BABAYAGA);
	export_constant_npc(JT_4_F_RUSGREEN);
	export_constant_npc(JT_4_RUS_DWOLF);
	export_constant_npc(JT_1_FLAG_LION);
	export_constant_npc(JT_1_FLAG_EAGLE);
	export_constant_npc(JT_4_M_MIKID);
	export_constant_npc(JT_4_BLUE_FLOWER);
	export_constant_npc(JT_4_RED_FLOWER);
	export_constant_npc(JT_4_YELL_FLOWER);
	export_constant_npc(JT_4_F_CAVE1);
	export_constant_npc(JT_4_F_MUT1);
	export_constant_npc(JT_4_F_MUT2);
	export_constant_npc(JT_4_F_SCIENCE);
	export_constant_npc(JT_4_M_1STPRIN1);
	export_constant_npc(JT_4_M_1STPRIN2);
	export_constant_npc(JT_4_M_2NDPRIN1);
	export_constant_npc(JT_4_M_2NDPRIN2);
	export_constant_npc(JT_4_M_3RDPRIN1);
	export_constant_npc(JT_4_M_3RDPRIN2);
	export_constant_npc(JT_4_M_4THPRIN1);
	export_constant_npc(JT_4_M_4THPRIN2);
	export_constant_npc(JT_4_M_5THPRIN1);
	export_constant_npc(JT_4_M_5THPRIN2);
	export_constant_npc(JT_4_M_6THPRIN1);
	export_constant_npc(JT_4_M_6THPRIN2);
	export_constant_npc(JT_4_M_CASMAN1);
	export_constant_npc(JT_4_M_CAVE1);
	export_constant_npc(JT_4_M_MOCASS1);
	export_constant_npc(JT_4_M_MOCASS2);
	export_constant_npc(JT_4_M_MUT1);
	export_constant_npc(JT_4_TOWER_14);
	export_constant_npc(JT_4_TOWER_15);
	export_constant_npc(JT_4_TOWER_16);
	export_constant_npc(JT_4_TOWER_17);
	export_constant_npc(JT_4_TREASURE_BOX);
	export_constant_npc(JT_ACADEMY_MASTER);
	export_constant_npc(JT_PORTAL);
	export_constant_npc(JT_THANATOS_BATTLE);
	export_constant_npc(JT_THANATOS_KEEP);
	export_constant_npc(JT_4_F_LYDIA);
	export_constant_npc(JT_4_LUDE);
	export_constant_npc(JT_4_ALIZA);
	export_constant_npc(JT_4_ALICE);
	export_constant_npc(JT_4_ARCHER_SKEL);
	export_constant_npc(JT_4_JACK);
	export_constant_npc(JT_4_SOLDIER_SKEL);
	export_constant_npc(JT_4_LOLI_RURI);
	export_constant_npc(JT_4_M_SAKRAY_TIED);
	export_constant_npc(JT_4_M_ANTONIO);
	export_constant_npc(JT_4_M_COOKIE);
	export_constant_npc(JT_4_M_BELIEVER01);
	export_constant_npc(JT_4_F_BELIEVER01);
	export_constant_npc(JT_4_M_BELIEVER02);
	export_constant_npc(JT_4_ROPEPILE);
	export_constant_npc(JT_4_BRICKPILE);
	export_constant_npc(JT_4_WOODPILE);
	export_constant_npc(JT_4_M_TAMARIN);
	export_constant_npc(JT_4_M_DEATH);
	export_constant_npc(JT_4_GHOST_STAND);
	export_constant_npc(JT_4_GHOST_COLLAPSE);
	export_constant_npc(JT_4_COOKIEHOUSE);
	export_constant_npc(JT_4_F_SKULL06GIRL);
	export_constant_npc(JT_4_NONMYSTCASE);
	export_constant_npc(JT_4_F_KIMI);
	export_constant_npc(JT_4_M_FROZEN_GC);
	export_constant_npc(JT_4_M_FROZEN_KN);
	export_constant_npc(JT_4_SNAKE_LORD);
	export_constant_npc(JT_4_F_MOCBOY);
	export_constant_npc(JT_4_F_RUNAIN);
	export_constant_npc(JT_4_M_ROEL);
	export_constant_npc(JT_4_F_SHALOSH);
	export_constant_npc(JT_4_ENERGY_RED);
	export_constant_npc(JT_4_ENERGY_BLUE);
	export_constant_npc(JT_4_ENERGY_YELLOW);
	export_constant_npc(JT_4_ENERGY_BLACK);
	export_constant_npc(JT_4_ENERGY_WHITE);
	export_constant_npc(JT_4_F_PERE01);
	export_constant_npc(JT_4_JITTERBUG);
	export_constant_npc(JT_4_SEA_OTTER);
	export_constant_npc(JT_4_GALAPAGO);
	export_constant_npc(JT_4_DESERTWOLF_B);
	export_constant_npc(JT_4_BB_PORING);
	export_constant_npc(JT_4_F_CHARLESTON01);
	export_constant_npc(JT_4_F_CHARLESTON02);
	export_constant_npc(JT_4_F_CHARLESTON03);
	export_constant_npc(JT_4_M_IAN);
	export_constant_npc(JT_4_M_OLDSCHOLAR);
	export_constant_npc(JT_4_F_LAPERM);
	export_constant_npc(JT_4_M_DEBON);
	export_constant_npc(JT_4_M_BIRMAN);
	export_constant_npc(JT_4_F_SHAM);
	export_constant_npc(JT_4_M_REBELLION);
	export_constant_npc(JT_4_F_REBELLION);
	export_constant_npc(JT_4_CHN_SHAOTH);
	export_constant_npc(JT_4_SHOAL);
	export_constant_npc(JT_4_F_SARAH);
	export_constant_npc(JT_4_GIGANTES_BIG);
	export_constant_npc(JT_4_GIGANTES);
	export_constant_npc(JT_4_GIGANTES_SMALL);
	export_constant_npc(JT_4_GARGOYLE_STATUE);
	export_constant_npc(JT_4_AIRA);
	export_constant_npc(JT_4_EZELLA);
	export_constant_npc(JT_4_KULUNA);
	export_constant_npc(JT_4_LUNE);
	export_constant_npc(JT_4_MALLINA);
	export_constant_npc(JT_4_MORIN);
	export_constant_npc(JT_4_NASARIN);
	export_constant_npc(JT_4_F_BERRYTEA);
	export_constant_npc(JT_4_F_FRUIT);
	export_constant_npc(JT_4_SCR_MT_ROBOTS);
	export_constant_npc(JT_4_MACHINE_DEVICE);
	export_constant_npc(JT_4_GC109);
	export_constant_npc(JT_4_SYS_MSG);
	export_constant_npc(JT_4_M_TATIO);
	export_constant_npc(JT_4_M_REKENBER);
	export_constant_npc(JT_4_XMAS_CAT1);
	export_constant_npc(JT_4_XMAS_CAT2);
	export_constant_npc(JT_4_XMAS_CAT3);
	export_constant_npc(JT_4_XMAS_CAT4);
	export_constant_npc(JT_4_XMAS_CAT5);
	export_constant_npc(JT_4_XMAS_CAT6);
	export_constant_npc(JT_4_M_DEATH2);
	export_constant_npc(JT_4_S_KADOMATSU);
	export_constant_npc(JT_4_B_KADOMATSU);
	export_constant_npc(JT_4_F_08);
	export_constant_npc(JT_4_F_08_STATUE);
	export_constant_npc(JT_4_M_DARKPRIEST);
	export_constant_npc(JT_4_JP_GARM_H);
	export_constant_npc(JT_4_JP_MEDUSA_H);
	export_constant_npc(JT_4_CHN_GVG_01);
	export_constant_npc(JT_4_SPRING_RABBIT);
	export_constant_npc(JT_4_PD_TYRA);
	export_constant_npc(JT_4_PD_TYRANOS);
	export_constant_npc(JT_4_PD_PLESI);
	export_constant_npc(JT_4_PD_PLESIO);
	export_constant_npc(JT_4_PD_BRACHI);
	export_constant_npc(JT_4_PD_BRACHIOS);
	export_constant_npc(JT_4_PD_GOLDDRAGON);
	export_constant_npc(JT_4_PD_ZAEROG);
	export_constant_npc(JT_4_PD_TAMADORA);
	export_constant_npc(JT_4_JP_EDGA_H);
	export_constant_npc(JT_4_JP_BRAGOLEM_H);
	export_constant_npc(JT_4_EL_AQUA);
	export_constant_npc(JT_4_EP16_NIHIL);
	export_constant_npc(JT_4_EP16_SPICA);
	export_constant_npc(JT_4_EP16_SKIA);
	export_constant_npc(JT_4_EP16_PETER);
	export_constant_npc(JT_4_EP16_CRUX);
	export_constant_npc(JT_4_EP16_GRANZ);
	export_constant_npc(JT_4_EP16_STOLZ);
	export_constant_npc(JT_4_EP16_EGEO);
	export_constant_npc(JT_4_EP16_COOK);
	export_constant_npc(JT_4_EP16_MARK);
	export_constant_npc(JT_4_EP16_TAMARIN);
	export_constant_npc(JT_4_EP16_POE);
	export_constant_npc(JT_4_EP16_ISAAC);
	export_constant_npc(JT_4_EP16_HELMUT);
	export_constant_npc(JT_4_EP16_WOLF);
	export_constant_npc(JT_4_EP16_MEYER);
	export_constant_npc(JT_4_EP16_AGNES);
	export_constant_npc(JT_4_EP16_FOOD);
	export_constant_npc(JT_4_EP16_LOUVIERE);
	export_constant_npc(JT_4_EP16_MAX);
	export_constant_npc(JT_4_EP16_SPIEGEL);
	export_constant_npc(JT_4_MOONLIGHT);
	export_constant_npc(JT_4_MISTRESS);
	export_constant_npc(JT_4_DRACULA);
	export_constant_npc(JT_4_STORMKNIGHT);
	export_constant_npc(JT_4_TATTER);
	export_constant_npc(JT_4_AS_RAGGED_GOLEM);
	export_constant_npc(JT_4_AS_BLOODY_KNIGHT);
	export_constant_npc(JT_4_AS_WIND_GHOST);
	export_constant_npc(JT_4_F_BIJOU);
	export_constant_npc(JT_4_EP16_COOK2);
	export_constant_npc(JT_4_SERVICE_30_M_01);
	export_constant_npc(JT_4_SERVICE_30_F_01);
	export_constant_npc(JT_4_SCR_AT_ROBOTS);
	export_constant_npc(JT_4_F_RANGER);
	export_constant_npc(JT_4_WAG);
	export_constant_npc(JT_4_NPC_TRAP);
	export_constant_npc(JT_4_RAGGLER);
	export_constant_npc(JT_4_DR_PEPE);
	export_constant_npc(JT_4_DR_GAMBERI);
	export_constant_npc(JT_4_DR_AGLIO);
	export_constant_npc(JT_4_DR_OLIO);
	export_constant_npc(JT_4_DR_STELO);
	export_constant_npc(JT_4_DR_TORTEL);
	export_constant_npc(JT_4_BASIL_SLAVE);
	export_constant_npc(JT_4_DOU_JINDO);
	export_constant_npc(JT_4_DOU_SIBA);
	export_constant_npc(JT_4_TARUTUPI);
	export_constant_npc(JT_4_DR_SOLDIER);
	export_constant_npc(JT_4_DR_M_01);
	export_constant_npc(JT_4_DR_M_02);
	export_constant_npc(JT_4_DR_F_01);
	export_constant_npc(JT_4_DR_F_02);
	export_constant_npc(JT_4_DR_KID_01);
	export_constant_npc(JT_4_JP_2015EVT);
	export_constant_npc(JT_4_ALLIGATOR);
	export_constant_npc(JT_4_ANOLIAN);
	export_constant_npc(JT_4_TACNU);
	export_constant_npc(JT_4_CENERE);
	export_constant_npc(JT_4_F_ARUNA_POP2);
	export_constant_npc(JT_4_JACK_HEAD);
	export_constant_npc(JT_4_INJUSTICE);
	export_constant_npc(JT_4_BLOODYMAN);
	export_constant_npc(JT_4_GIBBET);
	export_constant_npc(JT_4_DULLAHAN);
	export_constant_npc(JT_4_M_LAZY);
	export_constant_npc(JT_4_M_GONY);
	export_constant_npc(JT_4_M_ROOKIE);
	export_constant_npc(JT_4_M_PHILOFONTES);
	export_constant_npc(JT_4_F_ESTLOVELOY);
	export_constant_npc(JT_4_F_LEEDSH);
	export_constant_npc(JT_4_F_DIENE);
	export_constant_npc(JT_4_F_COATNEIS);
	export_constant_npc(JT_4_M_RUPERT);
	export_constant_npc(JT_4_M_FALLENGONY);
	export_constant_npc(JT_4_M_EISEN);
	export_constant_npc(JT_4_F_DEADEVIL);
	export_constant_npc(JT_4_F_HUNTER_EVIL);
	export_constant_npc(JT_4_F_ELENA);
	export_constant_npc(JT_4_F_ANYA);
	export_constant_npc(JT_4_M_SEIREN_UC);
	export_constant_npc(JT_4_M_GUNSLINGER2);
	export_constant_npc(JT_4_M_GUNSLINGER3);
	export_constant_npc(JT_4_M_REBELLION2);
	export_constant_npc(JT_4_M_REBELLION3);
	export_constant_npc(JT_4_F_GUNSLINGER2);
	export_constant_npc(JT_4_F_GUNSLINGER3);
	export_constant_npc(JT_4_F_REBELLION2);
	export_constant_npc(JT_4_F_REBELLION3);
	export_constant_npc(JT_4_M_ILYA);
	export_constant_npc(JT_4_ELDER);
	export_constant_npc(JT_4_LUNATIC);
	export_constant_npc(JT_4_F_NOVICE2);
	export_constant_npc(JT_4_WICKEDNYMPH);
	export_constant_npc(JT_4_F_PREMI);
	export_constant_npc(JT_4_M_COSTELL);
	export_constant_npc(JT_4_M_YATTWARP);
	export_constant_npc(JT_4_M_EVOKASCUDI);
	export_constant_npc(JT_4_M_JOHNNYJAMES);
	export_constant_npc(JT_4_M_ALBERTFORD);
	export_constant_npc(JT_4_M_SEANMCCURDY);
	export_constant_npc(JT_4_M_KARAMPUCCI);
	export_constant_npc(JT_4_M_CACTUSMAN1);
	export_constant_npc(JT_4_M_CACTUSMAN2);
	export_constant_npc(JT_4_M_CACTUSMAN3);
	export_constant_npc(JT_4_M_CACTUSLADY);
	export_constant_npc(JT_4_M_GAST);
	export_constant_npc(JT_4_M_CACTUSCHILD);
	export_constant_npc(JT_4_KING);
	export_constant_npc(JT_4_F_BOMI);
	export_constant_npc(JT_4_M_CACTUSCHIEF);
	export_constant_npc(JT_4_F_CACTUSCHILD2);
	export_constant_npc(JT_4_F_CACTUSLADY2);
	export_constant_npc(JT_4_F_CACTUSLADY3);
	export_constant_npc(JT_4_M_CACTUS);
	export_constant_npc(JT_4_M_COWRAIDERS1);
	export_constant_npc(JT_4_M_COWRAIDERS2);
	export_constant_npc(JT_4_M_COWRAIDERS3);
	export_constant_npc(JT_4_F_JP14THEVT);
	export_constant_npc(JT_4_M_POORSCHOLAR);
	export_constant_npc(JT_4_M_PEPPERROTI);
	export_constant_npc(JT_JP_NPC01);
	export_constant_npc(JT_4_PURPLE_WARP);
	export_constant_npc(JT_4_F_NARIN);
	export_constant_npc(JT_4_M_URGENT_MAN);
	export_constant_npc(JT_4_M_KEEN_SOLDIER);
	export_constant_npc(JT_4_F_SLOPPY_WOMAN);
	export_constant_npc(JT_4_F_DRKAFRA01);
	export_constant_npc(JT_4_M_DRZONDA01);
	export_constant_npc(JT_4_M_SWD_RENO);
	export_constant_npc(JT_4_M_KNG_RENO);
	export_constant_npc(JT_4_M_AC_RUMIN);
	export_constant_npc(JT_4_M_HIGH_WIZARD);
	export_constant_npc(JT_4_SYSTEM_BOX);
	export_constant_npc(JT_4_STEELBOX);
	export_constant_npc(JT_4_WOODBOX);
	export_constant_npc(JT_4_M_POPFESTA);
	export_constant_npc(JT_4_BONFIRE);
	export_constant_npc(JT_4_PCCOUNT);
	export_constant_npc(JT_4_LAVAGOLEM);
	export_constant_npc(JT_4_F_IA);
	export_constant_npc(JT_4_LOCKE);
	export_constant_npc(JT_4_LIL_LIF);
	export_constant_npc(JT_4_LIL_LIF2);
	export_constant_npc(JT_4_F_DRAGONHAT);
	export_constant_npc(JT_4_M_DRAGONHAT);
	export_constant_npc(JT_JP_NPC02);
	export_constant_npc(JT_JP_NPC03);
	export_constant_npc(JT_JP_NPC04);
	export_constant_npc(JT_JP_NPC05);
	export_constant_npc(JT_JP_NPC06);
	export_constant_npc(JT_JP_NPC07);
	export_constant_npc(JT_JP_NPC08);
	export_constant_npc(JT_JP_NPC09);
	export_constant_npc(JT_JP_NPC10);
	export_constant_npc(JT_4_FIRERING);
	export_constant_npc(JT_4_SCATLETON);
	export_constant_npc(JT_4_JP_AB_NPC_001);
	export_constant_npc(JT_4_JP_AB_NPC_002);
	export_constant_npc(JT_4_JP_AB_NPC_003);
	export_constant_npc(JT_4_JP_AB_NPC_004);
	export_constant_npc(JT_4_JP_AB_NPC_005);
	export_constant_npc(JT_4_JP_AB_NPC_006);
	export_constant_npc(JT_4_JP_AB_NPC_007);
	export_constant_npc(JT_4_JP_AB_NPC_008);
	export_constant_npc(JT_4_JJAK);
	export_constant_npc(JT_4_M_SNOWMAN_B);
	export_constant_npc(JT_4_M_SNOWMAN_R);
	export_constant_npc(JT_4_M_SNOWMAN_G);
	export_constant_npc(JT_WARPEFFECTNPC);
	export_constant_npc(JT_4_HEN);
	export_constant_npc(JT_4_F_DANGDANG);
	export_constant_npc(JT_4_M_DANGDANG);
	export_constant_npc(JT_4_F_DANGDANG1);
	export_constant_npc(JT_4_LEAFCAT);
	export_constant_npc(JT_4_NASARIAN);
	export_constant_npc(JT_4_NASARIAN_EM);
	export_constant_npc(JT_4_TEDDY_BEAR_W);
	export_constant_npc(JT_4_TEDDY_BEAR_B);
	export_constant_npc(JT_4_TEDDY_BEAR_B_L);
	export_constant_npc(JT_4_M_SOULREAPER);
	export_constant_npc(JT_4_F_SE_SUN);
	export_constant_npc(JT_4_M_SE_MOON);
	export_constant_npc(JT_4_M_SE_STAR);
	export_constant_npc(JT_4_EP17_KAYA);
	export_constant_npc(JT_4_EP17_AS);
	export_constant_npc(JT_4_EP17_ELYUMINA);
	export_constant_npc(JT_4_EP17_MORNING);
	export_constant_npc(JT_4_EP17_MIGUEL);
	export_constant_npc(JT_4_EP17_NIHIL_K);
	export_constant_npc(JT_4_EP17_MIGUEL_D);
	export_constant_npc(JT_4_ED_SCHMIDT);
	export_constant_npc(JT_4_ED_OSCAR);
	export_constant_npc(JT_4_ED_ORB);
	export_constant_npc(JT_4_ED_FENCE);
	export_constant_npc(JT_4_M_ANDREA);
	export_constant_npc(JT_4_M_ANDREA_D);
	export_constant_npc(JT_4_F_ANES);
	export_constant_npc(JT_4_F_ANES_D);
	export_constant_npc(JT_4_M_SILVANO);
	export_constant_npc(JT_4_M_SILVANO_D);
	export_constant_npc(JT_4_F_CECILIA);
	export_constant_npc(JT_4_F_CECILIA_D);
	export_constant_npc(JT_4_M_MD_SEYREN);
	export_constant_npc(JT_4_M_MD_EREMES);
	export_constant_npc(JT_4_M_MD_HARWORD);
	export_constant_npc(JT_4_F_MD_MAGALETA);
	export_constant_npc(JT_4_F_MD_SHECIL);
	export_constant_npc(JT_4_F_MD_KATRINN);
	export_constant_npc(JT_4_M_MD_SEYREN_H);
	export_constant_npc(JT_4_M_MD_EREMES_H);
	export_constant_npc(JT_4_M_MD_HARWORD_H);
	export_constant_npc(JT_4_F_MD_MAGALETA_H);
	export_constant_npc(JT_4_F_MD_SHECIL_H);
	export_constant_npc(JT_4_F_MD_KATRINN_H);
	export_constant_npc(JT_4_M_MD_SEYREN_D);
	export_constant_npc(JT_4_M_MD_EREMES_D);
	export_constant_npc(JT_4_M_MD_HARWORD_D);
	export_constant_npc(JT_4_F_MD_MAGALETA_D);
	export_constant_npc(JT_4_F_MD_SHECIL_D);
	export_constant_npc(JT_4_F_MD_KATRINN_D);
	export_constant_npc(JT_4_F_MD_YGNIZEM);
	export_constant_npc(JT_4_F_ERENE);
	export_constant_npc(JT_4_M_EINCPTMINER);
	export_constant_npc(JT_4_F_EINRESERCHER);
	export_constant_npc(JT_4_F_REINDEER);
	export_constant_npc(JT_4_PIGOCTO);
	export_constant_npc(JT_4_ORK_HERO);
	export_constant_npc(JT_4_JP_16TH);
	export_constant_npc(JT_NEW_NPC_3RD_END);
	#undef export_constant_npc

	/* special effects */
	export_constant(EF_NONE);
	export_constant(EF_HIT1);
	export_constant(EF_HIT2);
	export_constant(EF_HIT3);
	export_constant(EF_HIT4);
	export_constant(EF_HIT5);
	export_constant(EF_HIT6);
	export_constant(EF_ENTRY);
	export_constant(EF_EXIT);
	export_constant(EF_WARP);
	export_constant(EF_ENHANCE);
	export_constant(EF_COIN);
	export_constant(EF_ENDURE);
	export_constant(EF_BEGINSPELL);
	export_constant(EF_GLASSWALL);
	export_constant(EF_HEALSP);
	export_constant(EF_SOULSTRIKE);
	export_constant(EF_BASH);
	export_constant(EF_MAGNUMBREAK);
	export_constant(EF_STEAL);
	export_constant(EF_HIDING);
	export_constant(EF_PATTACK);
	export_constant(EF_DETOXICATION);
	export_constant(EF_SIGHT);
	export_constant(EF_STONECURSE);
	export_constant(EF_FIREBALL);
	export_constant(EF_FIREWALL);
	export_constant(EF_ICEARROW);
	export_constant(EF_FROSTDIVER);
	export_constant(EF_FROSTDIVER2);
	export_constant(EF_LIGHTBOLT);
	export_constant(EF_THUNDERSTORM);
	export_constant(EF_FIREARROW);
	export_constant(EF_NAPALMBEAT);
	export_constant(EF_RUWACH);
	export_constant(EF_TELEPORTATION);
	export_constant(EF_READYPORTAL);
	export_constant(EF_PORTAL);
	export_constant(EF_INCAGILITY);
	export_constant(EF_DECAGILITY);
	export_constant(EF_AQUA);
	export_constant(EF_SIGNUM);
	export_constant(EF_ANGELUS);
	export_constant(EF_BLESSING);
	export_constant(EF_INCAGIDEX);
	export_constant(EF_SMOKE);
	export_constant(EF_FIREFLY);
	export_constant(EF_SANDWIND);
	export_constant(EF_TORCH);
	export_constant(EF_SPRAYPOND);
	export_constant(EF_FIREHIT);
	export_constant(EF_FIRESPLASHHIT);
	export_constant(EF_COLDHIT);
	export_constant(EF_WINDHIT);
	export_constant(EF_POISONHIT);
	export_constant(EF_BEGINSPELL2);
	export_constant(EF_BEGINSPELL3);
	export_constant(EF_BEGINSPELL4);
	export_constant(EF_BEGINSPELL5);
	export_constant(EF_BEGINSPELL6);
	export_constant(EF_BEGINSPELL7);
	export_constant(EF_LOCKON);
	export_constant(EF_WARPZONE);
	export_constant(EF_SIGHTRASHER);
	export_constant(EF_BARRIER);
	export_constant(EF_ARROWSHOT);
	export_constant(EF_INVENOM);
	export_constant(EF_CURE);
	export_constant(EF_PROVOKE);
	export_constant(EF_MVP);
	export_constant(EF_SKIDTRAP);
	export_constant(EF_BRANDISHSPEAR);
	export_constant(EF_CONE);
	export_constant(EF_SPHERE);
	export_constant(EF_BOWLINGBASH);
	export_constant(EF_ICEWALL);
	export_constant(EF_GLORIA);
	export_constant(EF_MAGNIFICAT);
	export_constant(EF_RESURRECTION);
	export_constant(EF_RECOVERY);
	export_constant(EF_EARTHSPIKE);
	export_constant(EF_SPEARBMR);
	export_constant(EF_PIERCE);
	export_constant(EF_TURNUNDEAD);
	export_constant(EF_SANCTUARY);
	export_constant(EF_IMPOSITIO);
	export_constant(EF_LEXAETERNA);
	export_constant(EF_ASPERSIO);
	export_constant(EF_LEXDIVINA);
	export_constant(EF_SUFFRAGIUM);
	export_constant(EF_STORMGUST);
	export_constant(EF_LORD);
	export_constant(EF_BENEDICTIO);
	export_constant(EF_METEORSTORM);
	export_constant(EF_YUFITEL);
	export_constant(EF_YUFITELHIT);
	export_constant(EF_QUAGMIRE);
	export_constant(EF_FIREPILLAR);
	export_constant(EF_FIREPILLARBOMB);
	export_constant(EF_HASTEUP);
	export_constant(EF_FLASHER);
	export_constant(EF_REMOVETRAP);
	export_constant(EF_REPAIRWEAPON);
	export_constant(EF_CRASHEARTH);
	export_constant(EF_PERFECTION);
	export_constant(EF_MAXPOWER);
	export_constant(EF_BLASTMINE);
	export_constant(EF_BLASTMINEBOMB);
	export_constant(EF_CLAYMORE);
	export_constant(EF_FREEZING);
	export_constant(EF_BUBBLE);
	export_constant(EF_GASPUSH);
	export_constant(EF_SPRINGTRAP);
	export_constant(EF_KYRIE);
	export_constant(EF_MAGNUS);
	export_constant(EF_BOTTOM);
	export_constant(EF_BLITZBEAT);
	export_constant(EF_WATERBALL);
	export_constant(EF_WATERBALL2);
	export_constant(EF_FIREIVY);
	export_constant(EF_DETECTING);
	export_constant(EF_CLOAKING);
	export_constant(EF_SONICBLOW);
	export_constant(EF_SONICBLOWHIT);
	export_constant(EF_GRIMTOOTH);
	export_constant(EF_VENOMDUST);
	export_constant(EF_ENCHANTPOISON);
	export_constant(EF_POISONREACT);
	export_constant(EF_POISONREACT2);
	export_constant(EF_OVERTHRUST);
	export_constant(EF_SPLASHER);
	export_constant(EF_TWOHANDQUICKEN);
	export_constant(EF_AUTOCOUNTER);
	export_constant(EF_GRIMTOOTHATK);
	export_constant(EF_FREEZE);
	export_constant(EF_FREEZED);
	export_constant(EF_ICECRASH);
	export_constant(EF_SLOWPOISON);
	export_constant(EF_BOTTOM2);
	export_constant(EF_FIREPILLARON);
	export_constant(EF_SANDMAN);
	export_constant(EF_REVIVE);
	export_constant(EF_PNEUMA);
	export_constant(EF_HEAVENSDRIVE);
	export_constant(EF_SONICBLOW2);
	export_constant(EF_BRANDISH2);
	export_constant(EF_SHOCKWAVE);
	export_constant(EF_SHOCKWAVEHIT);
	export_constant(EF_EARTHHIT);
	export_constant(EF_PIERCESELF);
	export_constant(EF_BOWLINGSELF);
	export_constant(EF_SPEARSTABSELF);
	export_constant(EF_SPEARBMRSELF);
	export_constant(EF_HOLYHIT);
	export_constant(EF_CONCENTRATION);
	export_constant(EF_REFINEOK);
	export_constant(EF_REFINEFAIL);
	export_constant(EF_JOBCHANGE);
	export_constant(EF_LVUP);
	export_constant(EF_JOBLVUP);
	export_constant(EF_TOPRANK);
	export_constant(EF_PARTY);
	export_constant(EF_RAIN);
	export_constant(EF_SNOW);
	export_constant(EF_SAKURA);
	export_constant(EF_STATUS_STATE);
	export_constant(EF_BANJJAKII);
	export_constant(EF_MAKEBLUR);
	export_constant(EF_TAMINGSUCCESS);
	export_constant(EF_TAMINGFAILED);
	export_constant(EF_ENERGYCOAT);
	export_constant(EF_CARTREVOLUTION);
	export_constant(EF_VENOMDUST2);
	export_constant(EF_CHANGEDARK);
	export_constant(EF_CHANGEFIRE);
	export_constant(EF_CHANGECOLD);
	export_constant(EF_CHANGEWIND);
	export_constant(EF_CHANGEFLAME);
	export_constant(EF_CHANGEEARTH);
	export_constant(EF_CHAINGEHOLY);
	export_constant(EF_CHANGEPOISON);
	export_constant(EF_HITDARK);
	export_constant(EF_MENTALBREAK);
	export_constant(EF_MAGICALATTHIT);
	export_constant(EF_SUI_EXPLOSION);
	export_constant(EF_DARKATTACK);
	export_constant(EF_SUICIDE);
	export_constant(EF_COMBOATTACK1);
	export_constant(EF_COMBOATTACK2);
	export_constant(EF_COMBOATTACK3);
	export_constant(EF_COMBOATTACK4);
	export_constant(EF_COMBOATTACK5);
	export_constant(EF_GUIDEDATTACK);
	export_constant(EF_POISONATTACK);
	export_constant(EF_SILENCEATTACK);
	export_constant(EF_STUNATTACK);
	export_constant(EF_PETRIFYATTACK);
	export_constant(EF_CURSEATTACK);
	export_constant(EF_SLEEPATTACK);
	export_constant(EF_TELEKHIT);
	export_constant(EF_PONG);
	export_constant(EF_LEVEL99);
	export_constant(EF_LEVEL99_2);
	export_constant(EF_LEVEL99_3);
	export_constant(EF_GUMGANG);
	export_constant(EF_POTION1);
	export_constant(EF_POTION2);
	export_constant(EF_POTION3);
	export_constant(EF_POTION4);
	export_constant(EF_POTION5);
	export_constant(EF_POTION6);
	export_constant(EF_POTION7);
	export_constant(EF_POTION8);
	export_constant(EF_DARKBREATH);
	export_constant(EF_DEFFENDER);
	export_constant(EF_KEEPING);
	export_constant(EF_SUMMONSLAVE);
	export_constant(EF_BLOODDRAIN);
	export_constant(EF_ENERGYDRAIN);
	export_constant(EF_POTION_CON);
	export_constant(EF_POTION_);
	export_constant(EF_POTION_BERSERK);
	export_constant(EF_POTIONPILLAR);
	export_constant(EF_DEFENDER);
	export_constant(EF_GANBANTEIN);
	export_constant(EF_WIND);
	export_constant(EF_VOLCANO);
	export_constant(EF_GRANDCROSS);
	export_constant(EF_INTIMIDATE);
	export_constant(EF_CHOOKGI);
	export_constant(EF_CLOUD);
	export_constant(EF_CLOUD2);
	export_constant(EF_MAPPILLAR);
	export_constant(EF_LINELINK);
	export_constant(EF_CLOUD3);
	export_constant(EF_SPELLBREAKER);
	export_constant(EF_DISPELL);
	export_constant(EF_DELUGE);
	export_constant(EF_VIOLENTGALE);
	export_constant(EF_LANDPROTECTOR);
	export_constant(EF_BOTTOM_VO);
	export_constant(EF_BOTTOM_DE);
	export_constant(EF_BOTTOM_VI);
	export_constant(EF_BOTTOM_LA);
	export_constant(EF_FASTMOVE);
	export_constant(EF_MAGICROD);
	export_constant(EF_HOLYCROSS);
	export_constant(EF_SHIELDCHARGE);
	export_constant(EF_MAPPILLAR2);
	export_constant(EF_PROVIDENCE);
	export_constant(EF_SHIELDBOOMERANG);
	export_constant(EF_SPEARQUICKEN);
	export_constant(EF_DEVOTION);
	export_constant(EF_REFLECTSHIELD);
	export_constant(EF_ABSORBSPIRITS);
	export_constant(EF_STEELBODY);
	export_constant(EF_FLAMELAUNCHER);
	export_constant(EF_FROSTWEAPON);
	export_constant(EF_LIGHTNINGLOADER);
	export_constant(EF_SEISMICWEAPON);
	export_constant(EF_MAPPILLAR3);
	export_constant(EF_MAPPILLAR4);
	export_constant(EF_GUMGANG2);
	export_constant(EF_TEIHIT1);
	export_constant(EF_GUMGANG3);
	export_constant(EF_TEIHIT2);
	export_constant(EF_TANJI);
	export_constant(EF_TEIHIT1X);
	export_constant(EF_CHIMTO);
	export_constant(EF_STEALCOIN);
	export_constant(EF_STRIPWEAPON);
	export_constant(EF_STRIPSHIELD);
	export_constant(EF_STRIPARMOR);
	export_constant(EF_STRIPHELM);
	export_constant(EF_CHAINCOMBO);
	export_constant(EF_RG_COIN);
	export_constant(EF_BACKSTAP);
	export_constant(EF_TEIHIT3);
	export_constant(EF_BOTTOM_DISSONANCE);
	export_constant(EF_BOTTOM_LULLABY);
	export_constant(EF_BOTTOM_RICHMANKIM);
	export_constant(EF_BOTTOM_ETERNALCHAOS);
	export_constant(EF_BOTTOM_DRUMBATTLEFIELD);
	export_constant(EF_BOTTOM_RINGNIBELUNGEN);
	export_constant(EF_BOTTOM_ROKISWEIL);
	export_constant(EF_BOTTOM_INTOABYSS);
	export_constant(EF_BOTTOM_SIEGFRIED);
	export_constant(EF_BOTTOM_WHISTLE);
	export_constant(EF_BOTTOM_ASSASSINCROSS);
	export_constant(EF_BOTTOM_POEMBRAGI);
	export_constant(EF_BOTTOM_APPLEIDUN);
	export_constant(EF_BOTTOM_UGLYDANCE);
	export_constant(EF_BOTTOM_HUMMING);
	export_constant(EF_BOTTOM_DONTFORGETME);
	export_constant(EF_BOTTOM_FORTUNEKISS);
	export_constant(EF_BOTTOM_SERVICEFORYOU);
	export_constant(EF_TALK_FROSTJOKE);
	export_constant(EF_TALK_SCREAM);
	export_constant(EF_POKJUK);
	export_constant(EF_THROWITEM);
	export_constant(EF_THROWITEM2);
	export_constant(EF_CHEMICALPROTECTION);
	export_constant(EF_POKJUK_SOUND);
	export_constant(EF_DEMONSTRATION);
	export_constant(EF_CHEMICAL2);
	export_constant(EF_TELEPORTATION2);
	export_constant(EF_PHARMACY_OK);
	export_constant(EF_PHARMACY_FAIL);
	export_constant(EF_FORESTLIGHT);
	export_constant(EF_THROWITEM3);
	export_constant(EF_FIRSTAID);
	export_constant(EF_SPRINKLESAND);
	export_constant(EF_LOUD);
	export_constant(EF_HEAL);
	export_constant(EF_HEAL2);
	export_constant(EF_EXIT2);
	export_constant(EF_GLASSWALL2);
	export_constant(EF_READYPORTAL2);
	export_constant(EF_PORTAL2);
	export_constant(EF_BOTTOM_MAG);
	export_constant(EF_BOTTOM_SANC);
	export_constant(EF_HEAL3);
	export_constant(EF_WARPZONE2);
	export_constant(EF_FORESTLIGHT2);
	export_constant(EF_FORESTLIGHT3);
	export_constant(EF_FORESTLIGHT4);
	export_constant(EF_HEAL4);
	export_constant(EF_FOOT);
	export_constant(EF_FOOT2);
	export_constant(EF_BEGINASURA);
	export_constant(EF_TRIPLEATTACK);
	export_constant(EF_HITLINE);
	export_constant(EF_HPTIME);
	export_constant(EF_SPTIME);
	export_constant(EF_MAPLE);
	export_constant(EF_BLIND);
	export_constant(EF_POISON);
	export_constant(EF_GUARD);
	export_constant(EF_JOBLVUP50);
	export_constant(EF_ANGEL2);
	export_constant(EF_MAGNUM2);
	export_constant(EF_CALLZONE);
	export_constant(EF_PORTAL3);
	export_constant(EF_COUPLECASTING);
	export_constant(EF_HEARTCASTING);
	export_constant(EF_ENTRY2);
	export_constant(EF_SAINTWING);
	export_constant(EF_SPHEREWIND);
	export_constant(EF_COLORPAPER);
	export_constant(EF_LIGHTSPHERE);
	export_constant(EF_WATERFALL);
	export_constant(EF_WATERFALL_90);
	export_constant(EF_WATERFALL_SMALL);
	export_constant(EF_WATERFALL_SMALL_90);
	export_constant(EF_WATERFALL_T2);
	export_constant(EF_WATERFALL_T2_90);
	export_constant(EF_WATERFALL_SMALL_T2);
	export_constant(EF_WATERFALL_SMALL_T2_90);
	export_constant(EF_MINI_TETRIS);
	export_constant(EF_GHOST);
	export_constant(EF_BAT);
	export_constant(EF_BAT2);
	export_constant(EF_SOULBREAKER);
	export_constant(EF_LEVEL99_4);
	export_constant(EF_VALLENTINE);
	export_constant(EF_VALLENTINE2);
	export_constant(EF_PRESSURE);
	export_constant(EF_BASH3D);
	export_constant(EF_AURABLADE);
	export_constant(EF_REDBODY);
	export_constant(EF_LKCONCENTRATION);
	export_constant(EF_BOTTOM_GOSPEL);
	export_constant(EF_ANGEL);
	export_constant(EF_DEVIL);
	export_constant(EF_DRAGONSMOKE);
	export_constant(EF_BOTTOM_BASILICA);
	export_constant(EF_ASSUMPTIO);
	export_constant(EF_HITLINE2);
	export_constant(EF_BASH3D2);
	export_constant(EF_ENERGYDRAIN2);
	export_constant(EF_TRANSBLUEBODY);
	export_constant(EF_MAGICCRASHER);
	export_constant(EF_LIGHTSPHERE2);
	export_constant(EF_LIGHTBLADE);
	export_constant(EF_ENERGYDRAIN3);
	export_constant(EF_LINELINK2);
	export_constant(EF_LINKLIGHT);
	export_constant(EF_TRUESIGHT);
	export_constant(EF_FALCONASSAULT);
	export_constant(EF_TRIPLEATTACK2);
	export_constant(EF_PORTAL4);
	export_constant(EF_MELTDOWN);
	export_constant(EF_CARTBOOST);
	export_constant(EF_REJECTSWORD);
	export_constant(EF_TRIPLEATTACK3);
	export_constant(EF_SPHEREWIND2);
	export_constant(EF_LINELINK3);
	export_constant(EF_PINKBODY);
	export_constant(EF_LEVEL99_5);
	export_constant(EF_LEVEL99_6);
	export_constant(EF_BASH3D3);
	export_constant(EF_BASH3D4);
	export_constant(EF_NAPALMVALCAN);
	export_constant(EF_PORTAL5);
	export_constant(EF_MAGICCRASHER2);
	export_constant(EF_BOTTOM_SPIDER);
	export_constant(EF_BOTTOM_FOGWALL);
	export_constant(EF_SOULBURN);
	export_constant(EF_SOULCHANGE);
	export_constant(EF_BABY);
	export_constant(EF_SOULBREAKER2);
	export_constant(EF_RAINBOW);
	export_constant(EF_PEONG);
	export_constant(EF_TANJI2);
	export_constant(EF_PRESSEDBODY);
	export_constant(EF_SPINEDBODY);
	export_constant(EF_KICKEDBODY);
	export_constant(EF_AIRTEXTURE);
	export_constant(EF_HITBODY);
	export_constant(EF_DOUBLEGUMGANG);
	export_constant(EF_REFLECTBODY);
	export_constant(EF_BABYBODY);
	export_constant(EF_BABYBODY2);
	export_constant(EF_GIANTBODY);
	export_constant(EF_GIANTBODY2);
	export_constant(EF_ASURABODY);
	export_constant(EF_4WAYBODY);
	export_constant(EF_QUAKEBODY);
	export_constant(EF_ASURABODY_MONSTER);
	export_constant(EF_HITLINE3);
	export_constant(EF_HITLINE4);
	export_constant(EF_HITLINE5);
	export_constant(EF_HITLINE6);
	export_constant(EF_ELECTRIC);
	export_constant(EF_ELECTRIC2);
	export_constant(EF_HITLINE7);
	export_constant(EF_STORMKICK);
	export_constant(EF_HALFSPHERE);
	export_constant(EF_ATTACKENERGY);
	export_constant(EF_ATTACKENERGY2);
	export_constant(EF_CHEMICAL3);
	export_constant(EF_ASSUMPTIO2);
	export_constant(EF_BLUECASTING);
	export_constant(EF_RUN);
	export_constant(EF_STOPRUN);
	export_constant(EF_STOPEFFECT);
	export_constant(EF_JUMPBODY);
	export_constant(EF_LANDBODY);
	export_constant(EF_FOOT3);
	export_constant(EF_FOOT4);
	export_constant(EF_TAE_READY);
	export_constant(EF_GRANDCROSS2);
	export_constant(EF_SOULSTRIKE2);
	export_constant(EF_YUFITEL2);
	export_constant(EF_NPC_STOP);
	export_constant(EF_DARKCASTING);
	export_constant(EF_GUMGANGNPC);
	export_constant(EF_AGIUP);
	export_constant(EF_JUMPKICK);
	export_constant(EF_QUAKEBODY2);
	export_constant(EF_STORMKICK1);
	export_constant(EF_STORMKICK2);
	export_constant(EF_STORMKICK3);
	export_constant(EF_STORMKICK4);
	export_constant(EF_STORMKICK5);
	export_constant(EF_STORMKICK6);
	export_constant(EF_STORMKICK7);
	export_constant(EF_SPINEDBODY2);
	export_constant(EF_BEGINASURA1);
	export_constant(EF_BEGINASURA2);
	export_constant(EF_BEGINASURA3);
	export_constant(EF_BEGINASURA4);
	export_constant(EF_BEGINASURA5);
	export_constant(EF_BEGINASURA6);
	export_constant(EF_BEGINASURA7);
	export_constant(EF_AURABLADE2);
	export_constant(EF_DEVIL1);
	export_constant(EF_DEVIL2);
	export_constant(EF_DEVIL3);
	export_constant(EF_DEVIL4);
	export_constant(EF_DEVIL5);
	export_constant(EF_DEVIL6);
	export_constant(EF_DEVIL7);
	export_constant(EF_DEVIL8);
	export_constant(EF_DEVIL9);
	export_constant(EF_DEVIL10);
	export_constant(EF_DOUBLEGUMGANG2);
	export_constant(EF_DOUBLEGUMGANG3);
	export_constant(EF_BLACKDEVIL);
	export_constant(EF_FLOWERCAST);
	export_constant(EF_FLOWERCAST2);
	export_constant(EF_FLOWERCAST3);
	export_constant(EF_MOCHI);
	export_constant(EF_LAMADAN);
	export_constant(EF_EDP);
	export_constant(EF_SHIELDBOOMERANG2);
	export_constant(EF_RG_COIN2);
	export_constant(EF_GUARD2);
	export_constant(EF_SLIM);
	export_constant(EF_SLIM2);
	export_constant(EF_SLIM3);
	export_constant(EF_CHEMICALBODY);
	export_constant(EF_CASTSPIN);
	export_constant(EF_PIERCEBODY);
	export_constant(EF_SOULLINK);
	export_constant(EF_CHOOKGI2);
	export_constant(EF_MEMORIZE);
	export_constant(EF_SOULLIGHT);
	export_constant(EF_MAPAE);
	export_constant(EF_ITEMPOKJUK);
	export_constant(EF_05VAL);
	export_constant(EF_BEGINASURA11);
	export_constant(EF_NIGHT);
	export_constant(EF_CHEMICAL2DASH);
	export_constant(EF_GROUNDSAMPLE);
	export_constant(EF_GI_EXPLOSION);
	export_constant(EF_CLOUD4);
	export_constant(EF_CLOUD5);
	export_constant(EF_BOTTOM_HERMODE);
	export_constant(EF_CARTTER);
	export_constant(EF_ITEMFAST);
	export_constant(EF_SHIELDBOOMERANG3);
	export_constant(EF_DOUBLECASTBODY);
	export_constant(EF_GRAVITATION);
	export_constant(EF_TAROTCARD1);
	export_constant(EF_TAROTCARD2);
	export_constant(EF_TAROTCARD3);
	export_constant(EF_TAROTCARD4);
	export_constant(EF_TAROTCARD5);
	export_constant(EF_TAROTCARD6);
	export_constant(EF_TAROTCARD7);
	export_constant(EF_TAROTCARD8);
	export_constant(EF_TAROTCARD9);
	export_constant(EF_TAROTCARD10);
	export_constant(EF_TAROTCARD11);
	export_constant(EF_TAROTCARD12);
	export_constant(EF_TAROTCARD13);
	export_constant(EF_TAROTCARD14);
	export_constant(EF_ACIDDEMON);
	export_constant(EF_GREENBODY);
	export_constant(EF_THROWITEM4);
	export_constant(EF_BABYBODY_BACK);
	export_constant(EF_THROWITEM5);
	export_constant(EF_BLUEBODY);
	export_constant(EF_HATED);
	export_constant(EF_REDLIGHTBODY);
	export_constant(EF_RO2YEAR);
	export_constant(EF_SMA_READY);
	export_constant(EF_STIN);
	export_constant(EF_RED_HIT);
	export_constant(EF_BLUE_HIT);
	export_constant(EF_QUAKEBODY3);
	export_constant(EF_SMA);
	export_constant(EF_SMA2);
	export_constant(EF_STIN2);
	export_constant(EF_HITTEXTURE);
	export_constant(EF_STIN3);
	export_constant(EF_SMA3);
	export_constant(EF_BLUEFALL);
	export_constant(EF_BLUEFALL_90);
	export_constant(EF_FASTBLUEFALL);
	export_constant(EF_FASTBLUEFALL_90);
	export_constant(EF_BIG_PORTAL);
	export_constant(EF_BIG_PORTAL2);
	export_constant(EF_SCREEN_QUAKE);
	export_constant(EF_HOMUNCASTING);
	export_constant(EF_HFLIMOON1);
	export_constant(EF_HFLIMOON2);
	export_constant(EF_HFLIMOON3);
	export_constant(EF_HO_UP);
	export_constant(EF_HAMIDEFENCE);
	export_constant(EF_HAMICASTLE);
	export_constant(EF_HAMIBLOOD);
	export_constant(EF_HATED2);
	export_constant(EF_TWILIGHT1);
	export_constant(EF_TWILIGHT2);
	export_constant(EF_TWILIGHT3);
	export_constant(EF_ITEM_THUNDER);
	export_constant(EF_ITEM_CLOUD);
	export_constant(EF_ITEM_CURSE);
	export_constant(EF_ITEM_ZZZ);
	export_constant(EF_ITEM_RAIN);
	export_constant(EF_ITEM_LIGHT);
	export_constant(EF_ANGEL3);
	export_constant(EF_M01);
	export_constant(EF_M02);
	export_constant(EF_M03);
	export_constant(EF_M04);
	export_constant(EF_M05);
	export_constant(EF_M06);
	export_constant(EF_M07);
	export_constant(EF_KAIZEL);
	export_constant(EF_KAAHI);
	export_constant(EF_CLOUD6);
	export_constant(EF_FOOD01);
	export_constant(EF_FOOD02);
	export_constant(EF_FOOD03);
	export_constant(EF_FOOD04);
	export_constant(EF_FOOD05);
	export_constant(EF_FOOD06);
	export_constant(EF_SHRINK);
	export_constant(EF_THROWITEM6);
	export_constant(EF_SIGHT2);
	export_constant(EF_QUAKEBODY4);
	export_constant(EF_FIREHIT2);
	export_constant(EF_NPC_STOP2);
	export_constant(EF_NPC_STOP2_DEL);
	export_constant(EF_FVOICE);
	export_constant(EF_WINK);
	export_constant(EF_COOKING_OK);
	export_constant(EF_COOKING_FAIL);
	export_constant(EF_TEMP_OK);
	export_constant(EF_TEMP_FAIL);
	export_constant(EF_HAPGYEOK);
	export_constant(EF_THROWITEM7);
	export_constant(EF_THROWITEM8);
	export_constant(EF_THROWITEM9);
	export_constant(EF_THROWITEM10);
	export_constant(EF_BUNSINJYUTSU);
	export_constant(EF_KOUENKA);
	export_constant(EF_HYOUSENSOU);
	export_constant(EF_BOTTOM_SUITON);
	export_constant(EF_STIN4);
	export_constant(EF_THUNDERSTORM2);
	export_constant(EF_CHEMICAL4);
	export_constant(EF_STIN5);
	export_constant(EF_MADNESS_BLUE);
	export_constant(EF_MADNESS_RED);
	export_constant(EF_RG_COIN3);
	export_constant(EF_BASH3D5);
	export_constant(EF_CHOOKGI3);
	export_constant(EF_KIRIKAGE);
	export_constant(EF_TATAMI);
	export_constant(EF_KASUMIKIRI);
	export_constant(EF_ISSEN);
	export_constant(EF_KAEN);
	export_constant(EF_BAKU);
	export_constant(EF_HYOUSYOURAKU);
	export_constant(EF_DESPERADO);
	export_constant(EF_LIGHTNING_S);
	export_constant(EF_BLIND_S);
	export_constant(EF_POISON_S);
	export_constant(EF_FREEZING_S);
	export_constant(EF_FLARE_S);
	export_constant(EF_RAPIDSHOWER);
	export_constant(EF_MAGICALBULLET);
	export_constant(EF_SPREADATTACK);
	export_constant(EF_TRACKCASTING);
	export_constant(EF_TRACKING);
	export_constant(EF_TRIPLEACTION);
	export_constant(EF_BULLSEYE);
	export_constant(EF_MAP_MAGICZONE);
	export_constant(EF_MAP_MAGICZONE2);
	export_constant(EF_DAMAGE1);
	export_constant(EF_DAMAGE1_2);
	export_constant(EF_DAMAGE1_3);
	export_constant(EF_UNDEADBODY);
	export_constant(EF_UNDEADBODY_DEL);
	export_constant(EF_GREEN_NUMBER);
	export_constant(EF_BLUE_NUMBER);
	export_constant(EF_RED_NUMBER);
	export_constant(EF_PURPLE_NUMBER);
	export_constant(EF_BLACK_NUMBER);
	export_constant(EF_WHITE_NUMBER);
	export_constant(EF_YELLOW_NUMBER);
	export_constant(EF_PINK_NUMBER);
	export_constant(EF_BUBBLE_DROP);
	export_constant(EF_NPC_EARTHQUAKE);
	export_constant(EF_DA_SPACE);
	export_constant(EF_DRAGONFEAR);
	export_constant(EF_BLEEDING);
	export_constant(EF_WIDECONFUSE);
	export_constant(EF_BOTTOM_RUNNER);
	export_constant(EF_BOTTOM_TRANSFER);
	export_constant(EF_CRYSTAL_BLUE);
	export_constant(EF_BOTTOM_EVILLAND);
	export_constant(EF_GUARD3);
	export_constant(EF_NPC_SLOWCAST);
	export_constant(EF_CRITICALWOUND);
	export_constant(EF_GREEN99_3);
	export_constant(EF_GREEN99_5);
	export_constant(EF_GREEN99_6);
	export_constant(EF_MAPSPHERE);
	export_constant(EF_POK_LOVE);
	export_constant(EF_POK_WHITE);
	export_constant(EF_POK_VALEN);
	export_constant(EF_POK_BIRTH);
	export_constant(EF_POK_CHRISTMAS);
	export_constant(EF_MAP_MAGICZONE3);
	export_constant(EF_MAP_MAGICZONE4);
	export_constant(EF_DUST);
	export_constant(EF_TORCH_RED);
	export_constant(EF_TORCH_GREEN);
	export_constant(EF_MAP_GHOST);
	export_constant(EF_GLOW1);
	export_constant(EF_GLOW2);
	export_constant(EF_GLOW4);
	export_constant(EF_TORCH_PURPLE);
	export_constant(EF_CLOUD7);
	export_constant(EF_CLOUD8);
	export_constant(EF_FLOWERLEAF);
	export_constant(EF_MAPSPHERE2);
	export_constant(EF_GLOW11);
	export_constant(EF_GLOW12);
	export_constant(EF_CIRCLELIGHT);
	export_constant(EF_ITEM315);
	export_constant(EF_ITEM316);
	export_constant(EF_ITEM317);
	export_constant(EF_ITEM318);
	export_constant(EF_STORM_MIN);
	export_constant(EF_POK_JAP);
	export_constant(EF_MAP_GREENLIGHT);
	export_constant(EF_MAP_MAGICWALL);
	export_constant(EF_MAP_GREENLIGHT2);
	export_constant(EF_YELLOWFLY1);
	export_constant(EF_YELLOWFLY2);
	export_constant(EF_BOTTOM_BLUE);
	export_constant(EF_BOTTOM_BLUE2);
	export_constant(EF_WEWISH);
	export_constant(EF_FIREPILLARON2);
	export_constant(EF_FORESTLIGHT5);
	export_constant(EF_SOULBREAKER3);
	export_constant(EF_ADO_STR);
	export_constant(EF_IGN_STR);
	export_constant(EF_CHIMTO2);
	export_constant(EF_WINDCUTTER);
	export_constant(EF_DETECT2);
	export_constant(EF_FROSTMYSTY);
	export_constant(EF_CRIMSON_STR);
	export_constant(EF_HELL_STR);
	export_constant(EF_SPR_MASH);
	export_constant(EF_SPR_SOULE);
	export_constant(EF_DHOWL_STR);
	export_constant(EF_EARTHWALL);
	export_constant(EF_SOULBREAKER4);
	export_constant(EF_CHAINL_STR);
	export_constant(EF_CHOOKGI_FIRE);
	export_constant(EF_CHOOKGI_WIND);
	export_constant(EF_CHOOKGI_WATER);
	export_constant(EF_CHOOKGI_GROUND);
	export_constant(EF_MAGENTA_TRAP);
	export_constant(EF_COBALT_TRAP);
	export_constant(EF_MAIZE_TRAP);
	export_constant(EF_VERDURE_TRAP);
	export_constant(EF_NORMAL_TRAP);
	export_constant(EF_CLOAKING2);
	export_constant(EF_AIMED_STR);
	export_constant(EF_ARROWSTORM_STR);
	export_constant(EF_LAULAMUS_STR);
	export_constant(EF_LAUAGNUS_STR);
	export_constant(EF_MILSHIELD_STR);
	export_constant(EF_CONCENTRATION2);
	export_constant(EF_FIREBALL2);
	export_constant(EF_BUNSINJYUTSU2);
	export_constant(EF_CLEARTIME);
	export_constant(EF_GLASSWALL3);
	export_constant(EF_ORATIO);
	export_constant(EF_POTION_BERSERK2);
	export_constant(EF_CIRCLEPOWER);
	export_constant(EF_ROLLING1);
	export_constant(EF_ROLLING2);
	export_constant(EF_ROLLING3);
	export_constant(EF_ROLLING4);
	export_constant(EF_ROLLING5);
	export_constant(EF_ROLLING6);
	export_constant(EF_ROLLING7);
	export_constant(EF_ROLLING8);
	export_constant(EF_ROLLING9);
	export_constant(EF_ROLLING10);
	export_constant(EF_PURPLEBODY);
	export_constant(EF_STIN6);
	export_constant(EF_RG_COIN4);
	export_constant(EF_POISONWAV);
	export_constant(EF_POISONSMOKE);
	export_constant(EF_GUMGANG4);
	export_constant(EF_SHIELDBOOMERANG4);
	export_constant(EF_CASTSPIN2);
	export_constant(EF_VULCANWAV);
	export_constant(EF_AGIUP2);
	export_constant(EF_DETECT3);
	export_constant(EF_AGIUP3);
	export_constant(EF_DETECT4);
	export_constant(EF_ELECTRIC3);
	export_constant(EF_GUARD4);
	export_constant(EF_BOTTOM_BARRIER);
	export_constant(EF_BOTTOM_STEALTH);
	export_constant(EF_REPAIRTIME);
	export_constant(EF_NC_ANAL);
	export_constant(EF_FIRETHROW);
	export_constant(EF_VENOMIMPRESS);
	export_constant(EF_FROSTMISTY);
	export_constant(EF_BURNING);
	export_constant(EF_COLDTHROW);
	export_constant(EF_MAKEHALLU);
	export_constant(EF_HALLUTIME);
	export_constant(EF_INFRAREDSCAN);
	export_constant(EF_CRASHAXE);
	export_constant(EF_GTHUNDER);
	export_constant(EF_STONERING);
	export_constant(EF_INTIMIDATE2);
	export_constant(EF_STASIS);
	export_constant(EF_REDLINE);
	export_constant(EF_FROSTDIVER3);
	export_constant(EF_BOTTOM_BASILICA2);
	export_constant(EF_RECOGNIZED);
	export_constant(EF_TETRA);
	export_constant(EF_TETRACASTING);
	export_constant(EF_FIREBALL3);
	export_constant(EF_INTIMIDATE3);
	export_constant(EF_RECOGNIZED2);
	export_constant(EF_CLOAKING3);
	export_constant(EF_INTIMIDATE4);
	export_constant(EF_STRETCH);
	export_constant(EF_BLACKBODY);
	export_constant(EF_ENERVATION);
	export_constant(EF_ENERVATION2);
	export_constant(EF_ENERVATION3);
	export_constant(EF_ENERVATION4);
	export_constant(EF_ENERVATION5);
	export_constant(EF_ENERVATION6);
	export_constant(EF_LINELINK4);
	export_constant(EF_RG_COIN5);
	export_constant(EF_WATERFALL_ANI);
	export_constant(EF_BOTTOM_MANHOLE);
	export_constant(EF_MANHOLE);
	export_constant(EF_MAKEFEINT);
	export_constant(EF_FORESTLIGHT6);
	export_constant(EF_DARKCASTING2);
	export_constant(EF_BOTTOM_ANI);
	export_constant(EF_BOTTOM_MAELSTROM);
	export_constant(EF_BOTTOM_BLOODYLUST);
	export_constant(EF_BEGINSPELL_N1);
	export_constant(EF_BEGINSPELL_N2);
	export_constant(EF_HEAL_N);
	export_constant(EF_CHOOKGI_N);
	export_constant(EF_JOBLVUP50_2);
	export_constant(EF_CHEMICAL2DASH2);
	export_constant(EF_CHEMICAL2DASH3);
	export_constant(EF_ROLLINGCAST);
	export_constant(EF_WATER_BELOW);
	export_constant(EF_WATER_FADE);
	export_constant(EF_BEGINSPELL_N3);
	export_constant(EF_BEGINSPELL_N4);
	export_constant(EF_BEGINSPELL_N5);
	export_constant(EF_BEGINSPELL_N6);
	export_constant(EF_BEGINSPELL_N7);
	export_constant(EF_BEGINSPELL_N8);
	export_constant(EF_WATER_SMOKE);
	export_constant(EF_DANCE1);
	export_constant(EF_DANCE2);
	export_constant(EF_LINKPARTICLE);
	export_constant(EF_SOULLIGHT2);
	export_constant(EF_SPR_PARTICLE);
	export_constant(EF_SPR_PARTICLE2);
	export_constant(EF_SPR_PLANT);
	export_constant(EF_CHEMICAL_V);
	export_constant(EF_SHOOTPARTICLE);
	export_constant(EF_BOT_REVERB);
	export_constant(EF_RAIN_PARTICLE);
	export_constant(EF_CHEMICAL_V2);
	export_constant(EF_SECRA);
	export_constant(EF_BOT_REVERB2);
	export_constant(EF_CIRCLEPOWER2);
	export_constant(EF_SECRA2);
	export_constant(EF_CHEMICAL_V3);
	export_constant(EF_ENERVATION7);
	export_constant(EF_CIRCLEPOWER3);
	export_constant(EF_SPR_PLANT2);
	export_constant(EF_CIRCLEPOWER4);
	export_constant(EF_SPR_PLANT3);
	export_constant(EF_RG_COIN6);
	export_constant(EF_SPR_PLANT4);
	export_constant(EF_CIRCLEPOWER5);
	export_constant(EF_SPR_PLANT5);
	export_constant(EF_CIRCLEPOWER6);
	export_constant(EF_SPR_PLANT6);
	export_constant(EF_CIRCLEPOWER7);
	export_constant(EF_SPR_PLANT7);
	export_constant(EF_CIRCLEPOWER8);
	export_constant(EF_SPR_PLANT8);
	export_constant(EF_HEARTASURA);
	export_constant(EF_BEGINSPELL_150);
	export_constant(EF_LEVEL99_150);
	export_constant(EF_PRIMECHARGE);
	export_constant(EF_GLASSWALL4);
	export_constant(EF_GRADIUS_LASER);
	export_constant(EF_BASH3D6);
	export_constant(EF_GUMGANG5);
	export_constant(EF_HITLINE8);
	export_constant(EF_ELECTRIC4);
	export_constant(EF_TEIHIT1T);
	export_constant(EF_SPINMOVE);
	export_constant(EF_FIREBALL4);
	export_constant(EF_TRIPLEATTACK4);
	export_constant(EF_CHEMICAL3S);
	export_constant(EF_GROUNDSHAKE);
	export_constant(EF_DQ9_CHARGE);
	export_constant(EF_DQ9_CHARGE2);
	export_constant(EF_DQ9_CHARGE3);
	export_constant(EF_DQ9_CHARGE4);
	export_constant(EF_BLUELINE);
	export_constant(EF_SELFSCROLL);
	export_constant(EF_SPR_LIGHTPRINT);
	export_constant(EF_PNG_TEST);
	export_constant(EF_BEGINSPELL_YB);
	export_constant(EF_CHEMICAL2DASH4);
	export_constant(EF_GROUNDSHAKE2);
	export_constant(EF_PRESSURE2);
	export_constant(EF_RG_COIN7);
	export_constant(EF_PRIMECHARGE2);
	export_constant(EF_PRIMECHARGE3);
	export_constant(EF_PRIMECHARGE4);
	export_constant(EF_GREENCASTING);
	export_constant(EF_WALLOFTHORN);
	export_constant(EF_FIREBALL5);
	export_constant(EF_THROWITEM11);
	export_constant(EF_SPR_PLANT9);
	export_constant(EF_DEMONICFIRE);
	export_constant(EF_DEMONICFIRE2);
	export_constant(EF_DEMONICFIRE3);
	export_constant(EF_HELLSPLANT);
	export_constant(EF_FIREWALL2);
	export_constant(EF_VACUUM);
	export_constant(EF_SPR_PLANT10);
	export_constant(EF_SPR_LIGHTPRINT2);
	export_constant(EF_POISONSMOKE2);
	export_constant(EF_MAKEHALLU2);
	export_constant(EF_SHOCKWAVE2);
	export_constant(EF_SPR_PLANT11);
	export_constant(EF_COLDTHROW2);
	export_constant(EF_DEMONICFIRE4);
	export_constant(EF_PRESSURE3);
	export_constant(EF_LINKPARTICLE2);
	export_constant(EF_SOULLIGHT3);
	export_constant(EF_CHAREFFECT);
	export_constant(EF_GUMGANG6);
	export_constant(EF_FIREBALL6);
	export_constant(EF_GUMGANG7);
	export_constant(EF_GUMGANG8);
	export_constant(EF_GUMGANG9);
	export_constant(EF_BOTTOM_DE2);
	export_constant(EF_COLDSTATUS);
	export_constant(EF_SPR_LIGHTPRINT3);
	export_constant(EF_WATERBALL3);
	export_constant(EF_HEAL_N2);
	export_constant(EF_RAIN_PARTICLE2);
	export_constant(EF_CLOUD9);
	export_constant(EF_YELLOWFLY3);
	export_constant(EF_EL_GUST);
	export_constant(EF_EL_BLAST);
	export_constant(EF_EL_AQUAPLAY);
	export_constant(EF_EL_UPHEAVAL);
	export_constant(EF_EL_WILD_STORM);
	export_constant(EF_EL_CHILLY_AIR);
	export_constant(EF_EL_CURSED_SOIL);
	export_constant(EF_EL_COOLER);
	export_constant(EF_EL_TROPIC);
	export_constant(EF_EL_PYROTECHNIC);
	export_constant(EF_EL_PETROLOGY);
	export_constant(EF_EL_HEATER);
	export_constant(EF_POISON_MIST);
	export_constant(EF_ERASER_CUTTER);
	export_constant(EF_SILENT_BREEZE);
	export_constant(EF_MAGMA_FLOW);
	export_constant(EF_GRAYBODY);
	export_constant(EF_LAVA_SLIDE);
	export_constant(EF_SONIC_CLAW);
	export_constant(EF_TINDER_BREAKER);
	export_constant(EF_MIDNIGHT_FRENZY);
	export_constant(EF_MACRO);
	export_constant(EF_CHEMICAL_ALLRANGE);
	export_constant(EF_TETRA_FIRE);
	export_constant(EF_TETRA_WATER);
	export_constant(EF_TETRA_WIND);
	export_constant(EF_TETRA_GROUND);
	export_constant(EF_EMITTER);
	export_constant(EF_VOLCANIC_ASH);
	export_constant(EF_LEVEL99_ORB1);
	export_constant(EF_LEVEL99_ORB2);
	export_constant(EF_LEVEL150);
	export_constant(EF_LEVEL150_SUB);
	export_constant(EF_THROWITEM4_1);
	export_constant(EF_THROW_HAPPOKUNAI);
	export_constant(EF_THROW_MULTIPLE_COIN);
	export_constant(EF_THROW_BAKURETSU);
	export_constant(EF_ROTATE_HUUMARANKA);
	export_constant(EF_ROTATE_BG);
	export_constant(EF_ROTATE_LINE_GRAY);
	export_constant(EF_2011RWC);
	export_constant(EF_2011RWC2);
	export_constant(EF_KAIHOU);
	export_constant(EF_GROUND_EXPLOSION);
	export_constant(EF_KG_KAGEHUMI);
	export_constant(EF_KO_ZENKAI_WATER);
	export_constant(EF_KO_ZENKAI_LAND);
	export_constant(EF_KO_ZENKAI_FIRE);
	export_constant(EF_KO_ZENKAI_WIND);
	export_constant(EF_KO_JYUMONJIKIRI);
	export_constant(EF_KO_SETSUDAN);
	export_constant(EF_RED_CROSS);
	export_constant(EF_KO_IZAYOI);
	export_constant(EF_ROTATE_LINE_BLUE);
	export_constant(EF_KG_KYOMU);
	export_constant(EF_KO_HUUMARANKA);
	export_constant(EF_BLUELIGHTBODY);
	export_constant(EF_KAGEMUSYA);
	export_constant(EF_OB_GENSOU);
	export_constant(EF_NO100_FIRECRACKER);
	export_constant(EF_KO_MAKIBISHI);
	export_constant(EF_KAIHOU1);
	export_constant(EF_AKAITSUKI);
	export_constant(EF_ZANGETSU);
	export_constant(EF_GENSOU);
	export_constant(EF_HAT_EFFECT);
	export_constant(EF_CHERRYBLOSSOM);
	export_constant(EF_EVENT_CLOUD);
	export_constant(EF_RUN_MAKE_OK);
	export_constant(EF_RUN_MAKE_FAILURE);
	export_constant(EF_MIRESULT_MAKE_OK);
	export_constant(EF_MIRESULT_MAKE_FAIL);
	export_constant(EF_ALL_RAY_OF_PROTECTION);
	export_constant(EF_VENOMFOG);
	export_constant(EF_DUSTSTORM);
	export_constant(EF_LEVEL160);
	export_constant(EF_LEVEL160_SUB);
	export_constant(EF_MAPCHAIN);
	export_constant(EF_MAGIC_FLOOR);
	export_constant(EF_ICEMINE);
	export_constant(EF_FLAMECORSS);
	export_constant(EF_ICEMINE_1);
	export_constant(EF_DANCE_BLADE_ATK);
	export_constant(EF_DARKPIERCING);
	export_constant(EF_INVINCIBLEOFF2);
	export_constant(EF_MAXPAIN);
	export_constant(EF_DEATHSUMMON);
	export_constant(EF_MOONSTAR);
	export_constant(EF_STRANGELIGHTS);
	export_constant(EF_SUPER_STAR);
	export_constant(EF_YELLOBODY);
	export_constant(EF_COLORPAPER2);
	export_constant(EF_EVILS_PAW);
	export_constant(EF_GC_DARKCROW);
	export_constant(EF_RK_DRAGONBREATH_WATER);
	export_constant(EF_ALL_FULL_THROTTLE);
	export_constant(EF_SR_FLASHCOMBO);
	export_constant(EF_RK_LUXANIMA);
	export_constant(EF_CLOUD10);
	export_constant(EF_SO_ELEMENTAL_SHIELD);
	export_constant(EF_AB_OFFERTORIUM);
	export_constant(EF_WL_TELEKINESIS_INTENSE);
	export_constant(EF_GN_ILLUSIONDOPING);
	export_constant(EF_NC_MAGMA_ERUPTION);
	export_constant(EF_LG_KINGS_GRACE);
	export_constant(EF_BLOODDRAIN2);
	export_constant(EF_NPC_WIDEWEB);
	export_constant(EF_NPC_BURNT);
	export_constant(EF_NPC_CHILL);
	export_constant(EF_RA_UNLIMIT);
	export_constant(EF_AB_OFFERTORIUM_RING);
	export_constant(EF_SC_ESCAPE);
	export_constant(EF_WM_FRIGG_SONG);
	export_constant(EF_FLICKER);
	export_constant(EF_C_MAKER);
	export_constant(EF_HAMMER_OF_GOD);
	export_constant(EF_MASS_SPIRAL);
	export_constant(EF_FIRE_RAIN);
	export_constant(EF_WHITEBODY);
	export_constant(EF_BANISHING_BUSTER);
	export_constant(EF_SLUGSHOT);
	export_constant(EF_D_TAIL);
	export_constant(EF_BIND_TRAP1);
	export_constant(EF_BIND_TRAP2);
	export_constant(EF_BIND_TRAP3);
	export_constant(EF_JUMPBODY1);
	export_constant(EF_ANIMATED_EMITTER);
	export_constant(EF_RL_EXPLOSION);
	export_constant(EF_C_MAKER_1);
	export_constant(EF_QD_SHOT);
	export_constant(EF_P_ALTER);
	export_constant(EF_S_STORM);
	export_constant(EF_MUSIC_HAT);
	export_constant(EF_CLOUD_KILL);
	export_constant(EF_ESCAPE);
	export_constant(EF_XENO_SLASHER);
	export_constant(EF_FLOWERSMOKE);
	export_constant(EF_FSTONE);
	export_constant(EF_QSCARABA);
	export_constant(EF_LJOSALFAR);
	export_constant(EF_HAPPINESSSTAR);
	export_constant(EF_POWER_OF_GAIA);
	export_constant(EF_MAPLE_FALLS);
	export_constant(EF_MARKING_USE_CHANGEMONSTER);
	export_constant(EF_MAGICAL_FEATHER);
	export_constant(EF_MERMAID_LONGING);
	export_constant(EF_GIFT_OF_SNOW);
	export_constant(EF_ACH_COMPLETE);
	export_constant(EF_TIME_ACCESSORY);
	export_constant(EF_SPRITEMABLE);
	export_constant(EF_TUNAPARTY);

	/* hat effects */
	export_constant(HAT_EF_BLOSSOM_FLUTTERING);
	export_constant(HAT_EF_MERMAID_LONGING);
	export_constant(HAT_EF_RL_BANISHING_BUSTER);
	export_constant(HAT_EF_LJOSALFAR);
	export_constant(HAT_EF_CLOCKING);
	export_constant(HAT_EF_SNOW);
	export_constant(HAT_EF_MAKEBLUR);
	export_constant(HAT_EF_SLEEPATTACK);
	export_constant(HAT_EF_GUMGANG);
	export_constant(HAT_EF_TALK_FROSTJOKE);
	export_constant(HAT_EF_DEMONSTRATION);
	export_constant(HAT_EF_FLUTTER_BUTTERFLY);
	export_constant(HAT_EF_ANGEL_FLUTTERING);
	export_constant(HAT_EF_BLESSING_OF_ANGELS);
	export_constant(HAT_EF_ELECTRIC);
	export_constant(HAT_EF_GREEN_FLOOR);
	export_constant(HAT_EF_SHRINK);
	export_constant(HAT_EF_VALHALLA_IDOL);
	export_constant(HAT_EF_ANGEL_STAIRS);
	export_constant(HAT_EF_GLOW_OF_NEW_YEAR);
	export_constant(HAT_EF_BOTTOM_FORTUNEKISS);
	export_constant(HAT_EF_PINKBODY);
	export_constant(HAT_EF_DOUBLEGUMGANG);
	export_constant(HAT_EF_GIANTBODY);
	export_constant(HAT_EF_GREEN99_6);
	export_constant(HAT_EF_CIRCLEPOWER);
	export_constant(HAT_EF_BOTTOM_BLOODYLUST);
	export_constant(HAT_EF_WATER_BELOW);
	export_constant(HAT_EF_LEVEL99_150);
	export_constant(HAT_EF_YELLOWFLY3);
	export_constant(HAT_EF_KAGEMUSYA);
	export_constant(HAT_EF_CHERRYBLOSSOM);
	export_constant(HAT_EF_STRANGELIGHTS);
	export_constant(HAT_EF_WL_TELEKINESIS_INTENSE);
	export_constant(HAT_EF_AB_OFFERTORIUM_RING);
	export_constant(HAT_EF_WHITEBODY2);
	export_constant(HAT_EF_SAKURA);
	export_constant(HAT_EF_CLOUD2);
	export_constant(HAT_EF_FEATHER_FLUTTERING);
	export_constant(HAT_EF_CAMELLIA_HAIR_PIN);
	export_constant(HAT_EF_JP_EV_EFFECT01);
	export_constant(HAT_EF_JP_EV_EFFECT02);
	export_constant(HAT_EF_JP_EV_EFFECT03);
	export_constant(HAT_EF_FLORAL_WALTZ);
	export_constant(HAT_EF_MAGICAL_FEATHER);
	export_constant(HAT_EF_HAT_EFFECT);
	export_constant(HAT_EF_BAKURETSU_HADOU);
	export_constant(HAT_EF_GOLD_SHOWER);
	export_constant(HAT_EF_WHITEBODY);
	export_constant(HAT_EF_WATER_BELOW2);
	export_constant(HAT_EF_FIREWORK);
	export_constant(HAT_EF_RETURN_TW_1ST_HAT);
	export_constant(HAT_EF_C_FLUTTERBUTTERFLY_BL);
	export_constant(HAT_EF_QSCARABA);
	export_constant(HAT_EF_FSTONE);
	export_constant(HAT_EF_MAGICCIRCLE);
	export_constant(HAT_EF_GODCLASS);
	export_constant(HAT_EF_GODCLASS2);
	export_constant(HAT_EF_LEVEL99_RED);
	export_constant(HAT_EF_LEVEL99_ULTRAMARINE);
	export_constant(HAT_EF_LEVEL99_CYAN);
	export_constant(HAT_EF_LEVEL99_LIME);
	export_constant(HAT_EF_LEVEL99_VIOLET);
	export_constant(HAT_EF_LEVEL99_LILAC);
	export_constant(HAT_EF_LEVEL99_SUN_ORANGE);
	export_constant(HAT_EF_LEVEL99_DEEP_PINK);
	export_constant(HAT_EF_LEVEL99_BLACK);
	export_constant(HAT_EF_LEVEL99_WHITE);
	export_constant(HAT_EF_LEVEL160_RED);
	export_constant(HAT_EF_LEVEL160_ULTRAMARINE);
	export_constant(HAT_EF_LEVEL160_CYAN);
	export_constant(HAT_EF_LEVEL160_LIME);
	export_constant(HAT_EF_LEVEL160_VIOLET);
	export_constant(HAT_EF_LEVEL160_LILAC);
	export_constant(HAT_EF_LEVEL160_SUN_ORANGE);
	export_constant(HAT_EF_LEVEL160_DEEP_PINK);
	export_constant(HAT_EF_LEVEL160_BLACK);
	export_constant(HAT_EF_LEVEL160_WHITE);
	export_constant(HAT_EF_FULL_BLOOMCHERRY_TREE);
	export_constant(HAT_EF_C_BLESSINGS_OF_SOUL);
	export_constant(HAT_EF_MANYSTARS);
	export_constant(HAT_EF_SUBJECT_AURA_GOLD);
	export_constant(HAT_EF_SUBJECT_AURA_WHITE);
	export_constant(HAT_EF_SUBJECT_AURA_RED);
	export_constant(HAT_EF_C_SHINING_ANGEL_WING);
	export_constant(HAT_EF_MAGIC_STAR_TW);
	export_constant(HAT_EF_DIGITAL_SPACE);
	export_constant(HAT_EF_SLEIPNIR);
	export_constant(HAT_EF_C_MAPLE_WHICH_FALLS_RD);
	export_constant(HAT_EF_MAGICCIRCLERAINBOW);
	export_constant(HAT_EF_SNOWFLAKE_TIARA);
	export_constant(HAT_EF_MIDGARTS_GLORY);
	export_constant(HAT_EF_LEVEL99_TIGER);
	export_constant(HAT_EF_LEVEL160_TIGER);
	export_constant(HAT_EF_FLUFFYWING);
	export_constant(HAT_EF_C_GHOST_EFFECT);
	export_constant(HAT_EF_C_POPPING_PORING_AURA);
	export_constant(HAT_EF_RESONATETAEGO);
	export_constant(HAT_EF_99LV_RUNE_RED);
	export_constant(HAT_EF_99LV_ROYAL_GUARD_BLUE);
	export_constant(HAT_EF_99LV_WARLOCK_VIOLET);
	export_constant(HAT_EF_99LV_SORCERER_LBLUE);
	export_constant(HAT_EF_99LV_RANGER_GREEN);
	export_constant(HAT_EF_99LV_MINSTREL_PINK);
	export_constant(HAT_EF_99LV_ARCHBISHOP_WHITE);
	export_constant(HAT_EF_99LV_GUILL_SILVER);
	export_constant(HAT_EF_99LV_SHADOWC_BLACK);
	export_constant(HAT_EF_99LV_MECHANIC_GOLD);
	export_constant(HAT_EF_99LV_GENETIC_YGREEN);
	export_constant(HAT_EF_160LV_RUNE_RED);
	export_constant(HAT_EF_160LV_ROYAL_G_BLUE);
	export_constant(HAT_EF_160LV_WARLOCK_VIOLET);
	export_constant(HAT_EF_160LV_SORCERER_LBLUE);
	export_constant(HAT_EF_160LV_RANGER_GREEN);
	export_constant(HAT_EF_160LV_MINSTREL_PINK);
	export_constant(HAT_EF_160LV_ARCHB_WHITE);
	export_constant(HAT_EF_160LV_GUILL_SILVER);
	export_constant(HAT_EF_160LV_SHADOWC_BLACK);
	export_constant(HAT_EF_160LV_MECHANIC_GOLD);
	export_constant(HAT_EF_160LV_GENETIC_YGREEN);
	export_constant(HAT_EF_WATER_BELOW3);
	export_constant(HAT_EF_WATER_BELOW4);
	export_constant(HAT_EF_C_VALKYRIE_WING);

	/* pet catch */
	export_constant(PET_CATCH_UNIVERSAL);
	export_constant(PET_CATCH_UNIVERSAL_ITEM);

	/* pet intimacy levels */
	export_constant(PET_INTIMATE_NONE);
	export_constant(PET_INTIMATE_AWKWARD);
	export_constant(PET_INTIMATE_SHY);
	export_constant(PET_INTIMATE_NEUTRAL);
	export_constant(PET_INTIMATE_CORDIAL);
	export_constant(PET_INTIMATE_LOYAL);
	export_constant(PET_INTIMATE_MAX);

	/* pet hunger levels */
	export_constant(PET_HUNGRY_NONE);
	export_constant(PET_HUNGRY_VERY_HUNGRY);
	export_constant(PET_HUNGRY_HUNGRY);
	export_constant(PET_HUNGRY_NEUTRAL);
	export_constant(PET_HUNGRY_SATISFIED);
	export_constant(PET_HUNGRY_STUFFED);

	/* monster modes */
	export_constant(MD_NONE);
	export_constant(MD_CANMOVE);
	export_constant(MD_LOOTER);
	export_constant(MD_AGGRESSIVE);
	export_constant(MD_ASSIST);
	export_constant(MD_CASTSENSOR_IDLE);
	export_constant(MD_NORANDOM_WALK);
	export_constant(MD_NOCAST_SKILL);
	export_constant(MD_CANATTACK);
	export_constant(MD_CASTSENSOR_CHASE);
	export_constant(MD_CHANGECHASE);
	export_constant(MD_ANGRY);
	export_constant(MD_CHANGETARGET_MELEE);
	export_constant(MD_CHANGETARGET_CHASE);
	export_constant(MD_TARGETWEAK);
	export_constant(MD_RANDOMTARGET);
	export_constant(MD_IGNOREMELEE);
	export_constant(MD_IGNOREMAGIC);
	export_constant(MD_IGNORERANGED);
	export_constant(MD_MVP);
	export_constant(MD_IGNOREMISC);
	export_constant(MD_KNOCKBACK_IMMUNE);
	export_constant(MD_TELEPORT_BLOCK);
	export_constant(MD_FIXED_ITEMDROP);
	export_constant(MD_DETECTOR);
	export_constant(MD_STATUS_IMMUNE);
	export_constant(MD_SKILL_IMMUNE);

	/* guild storage flags */
	export_constant(GSTORAGE_OPEN);
	export_constant(GSTORAGE_STORAGE_ALREADY_OPEN);
	export_constant(GSTORAGE_ALREADY_OPEN);
	export_constant(GSTORAGE_NO_GUILD);
	export_constant(GSTORAGE_NO_STORAGE);
	export_constant(GSTORAGE_NO_PERMISSION);

	/* block list types */
	export_constant(BL_PC);
	export_constant(BL_MOB);
	export_constant(BL_PET);
	export_constant(BL_HOM);
	export_constant(BL_MER);
	export_constant(BL_NPC);
	export_constant(BL_ELEM);

	/* skill damage mapflag types */
	export_constant(SKILLDMG_PC);
	export_constant(SKILLDMG_MOB);
	export_constant(SKILLDMG_BOSS);
	export_constant(SKILLDMG_OTHER);
	export_constant(SKILLDMG_MAX);
	export_constant(SKILLDMG_CASTER);

	/* guild permissions */
	export_constant(GUILD_PERM_INVITE);
	export_constant(GUILD_PERM_EXPEL);
	export_constant(GUILD_PERM_STORAGE);
	export_constant(GUILD_PERM_ALL);

	/* guild storage log */
	export_constant(GUILDSTORAGE_LOG_FINAL_SUCCESS);
	export_constant(GUILDSTORAGE_LOG_EMPTY);
	export_constant(GUILDSTORAGE_LOG_FAILED);

	/* castle data flags */
	export_constant(CD_NONE);
	export_constant(CD_GUILD_ID);
	export_constant(CD_CURRENT_ECONOMY);
	export_constant(CD_CURRENT_DEFENSE);
	export_constant(CD_INVESTED_ECONOMY);
	export_constant(CD_INVESTED_DEFENSE);
	export_constant(CD_NEXT_TIME);
	export_constant(CD_PAY_TIME);
	export_constant(CD_CREATE_TIME);
	export_constant(CD_ENABLED_KAFRA);
	for( int i = CD_ENABLED_GUARDIAN00, j = 0; i < CD_MAX; i++, j++ ){
		char constant[32];

		sprintf( constant, "CD_ENABLED_GUARDIAN%02d", j );

		script_set_constant( constant, i, false, false );
	}
	export_constant(CD_MAX);

	/* timer related */
	export_constant(INFINITE_TICK);

	/* block action */
	export_constant(PCBLOCK_MOVE);
	export_constant(PCBLOCK_ATTACK);
	export_constant(PCBLOCK_SKILL);
	export_constant(PCBLOCK_USEITEM);
	export_constant(PCBLOCK_CHAT);
	export_constant(PCBLOCK_IMMUNE);
	export_constant(PCBLOCK_SITSTAND);
	export_constant(PCBLOCK_COMMANDS);
	export_constant(PCBLOCK_NPCCLICK);
	export_constant(PCBLOCK_NPC);
	export_constant(PCBLOCK_EMOTION);
	export_constant(PCBLOCK_ALL);

	/* convertpcinfo command */
	export_constant(CPC_NAME);
	export_constant(CPC_CHAR);
	export_constant(CPC_ACCOUNT);

	#undef export_constant
	#undef export_constant2
	#undef export_parameter
	#undef export_constant_offset
	#undef export_deprecated_constant
	#undef export_deprecated_constant2

#endif /* SCRIPT_CONSTANTS_HPP */
