// This file is auto-generated by scripts/generate-models.ts
// Do not edit manually - run 'npm run generate-models' to update
export const MODELS = {
    "amazon-bedrock": {
        "amazon.nova-2-lite-v1:0": {
            id: "amazon.nova-2-lite-v1:0",
            name: "Nova 2 Lite",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.33,
                output: 2.75,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "amazon.nova-lite-v1:0": {
            id: "amazon.nova-lite-v1:0",
            name: "Nova Lite",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.06,
                output: 0.24,
                cacheRead: 0.015,
                cacheWrite: 0,
            },
            contextWindow: 300000,
            maxTokens: 8192,
        },
        "amazon.nova-micro-v1:0": {
            id: "amazon.nova-micro-v1:0",
            name: "Nova Micro",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.035,
                output: 0.14,
                cacheRead: 0.00875,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 8192,
        },
        "amazon.nova-premier-v1:0": {
            id: "amazon.nova-premier-v1:0",
            name: "Nova Premier",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 12.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 16384,
        },
        "amazon.nova-pro-v1:0": {
            id: "amazon.nova-pro-v1:0",
            name: "Nova Pro",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.8,
                output: 3.2,
                cacheRead: 0.2,
                cacheWrite: 0,
            },
            contextWindow: 300000,
            maxTokens: 8192,
        },
        "amazon.titan-text-express-v1": {
            id: "amazon.titan-text-express-v1",
            name: "Titan Text G1 - Express",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.2,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "amazon.titan-text-express-v1:0:8k": {
            id: "amazon.titan-text-express-v1:0:8k",
            name: "Titan Text G1 - Express",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.2,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "anthropic.claude-3-5-haiku-20241022-v1:0": {
            id: "anthropic.claude-3-5-haiku-20241022-v1:0",
            name: "Claude Haiku 3.5",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.8,
                output: 4,
                cacheRead: 0.08,
                cacheWrite: 1,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "anthropic.claude-3-5-sonnet-20240620-v1:0": {
            id: "anthropic.claude-3-5-sonnet-20240620-v1:0",
            name: "Claude Sonnet 3.5",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "anthropic.claude-3-5-sonnet-20241022-v2:0": {
            id: "anthropic.claude-3-5-sonnet-20241022-v2:0",
            name: "Claude Sonnet 3.5 v2",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "anthropic.claude-3-7-sonnet-20250219-v1:0": {
            id: "anthropic.claude-3-7-sonnet-20250219-v1:0",
            name: "Claude Sonnet 3.7",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "anthropic.claude-3-haiku-20240307-v1:0": {
            id: "anthropic.claude-3-haiku-20240307-v1:0",
            name: "Claude Haiku 3",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 1.25,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 4096,
        },
        "anthropic.claude-3-opus-20240229-v1:0": {
            id: "anthropic.claude-3-opus-20240229-v1:0",
            name: "Claude Opus 3",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 4096,
        },
        "anthropic.claude-3-sonnet-20240229-v1:0": {
            id: "anthropic.claude-3-sonnet-20240229-v1:0",
            name: "Claude Sonnet 3",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 4096,
        },
        "anthropic.claude-haiku-4-5-20251001-v1:0": {
            id: "anthropic.claude-haiku-4-5-20251001-v1:0",
            name: "Claude Haiku 4.5",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.1,
                cacheWrite: 1.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "anthropic.claude-opus-4-1-20250805-v1:0": {
            id: "anthropic.claude-opus-4-1-20250805-v1:0",
            name: "Claude Opus 4.1",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "anthropic.claude-opus-4-20250514-v1:0": {
            id: "anthropic.claude-opus-4-20250514-v1:0",
            name: "Claude Opus 4",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "anthropic.claude-opus-4-5-20251101-v1:0": {
            id: "anthropic.claude-opus-4-5-20251101-v1:0",
            name: "Claude Opus 4.5",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "anthropic.claude-opus-4-6-v1": {
            id: "anthropic.claude-opus-4-6-v1",
            name: "Claude Opus 4.6",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 128000,
        },
        "anthropic.claude-sonnet-4-20250514-v1:0": {
            id: "anthropic.claude-sonnet-4-20250514-v1:0",
            name: "Claude Sonnet 4",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "anthropic.claude-sonnet-4-5-20250929-v1:0": {
            id: "anthropic.claude-sonnet-4-5-20250929-v1:0",
            name: "Claude Sonnet 4.5",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "cohere.command-r-plus-v1:0": {
            id: "cohere.command-r-plus-v1:0",
            name: "Command R+",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "cohere.command-r-v1:0": {
            id: "cohere.command-r-v1:0",
            name: "Command R",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.5,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "deepseek.r1-v1:0": {
            id: "deepseek.r1-v1:0",
            name: "DeepSeek-R1",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 1.35,
                output: 5.4,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 32768,
        },
        "deepseek.v3-v1:0": {
            id: "deepseek.v3-v1:0",
            name: "DeepSeek-V3.1",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.58,
                output: 1.68,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 81920,
        },
        "eu.anthropic.claude-haiku-4-5-20251001-v1:0": {
            id: "eu.anthropic.claude-haiku-4-5-20251001-v1:0",
            name: "Claude Haiku 4.5 (EU)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.1,
                cacheWrite: 1.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "eu.anthropic.claude-opus-4-5-20251101-v1:0": {
            id: "eu.anthropic.claude-opus-4-5-20251101-v1:0",
            name: "Claude Opus 4.5 (EU)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "eu.anthropic.claude-opus-4-6-v1": {
            id: "eu.anthropic.claude-opus-4-6-v1",
            name: "Claude Opus 4.6 (EU)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 128000,
        },
        "eu.anthropic.claude-sonnet-4-20250514-v1:0": {
            id: "eu.anthropic.claude-sonnet-4-20250514-v1:0",
            name: "Claude Sonnet 4 (EU)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "eu.anthropic.claude-sonnet-4-5-20250929-v1:0": {
            id: "eu.anthropic.claude-sonnet-4-5-20250929-v1:0",
            name: "Claude Sonnet 4.5 (EU)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "global.anthropic.claude-haiku-4-5-20251001-v1:0": {
            id: "global.anthropic.claude-haiku-4-5-20251001-v1:0",
            name: "Claude Haiku 4.5 (Global)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.1,
                cacheWrite: 1.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "global.anthropic.claude-opus-4-5-20251101-v1:0": {
            id: "global.anthropic.claude-opus-4-5-20251101-v1:0",
            name: "Claude Opus 4.5 (Global)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "global.anthropic.claude-opus-4-6-v1": {
            id: "global.anthropic.claude-opus-4-6-v1",
            name: "Claude Opus 4.6 (Global)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 128000,
        },
        "global.anthropic.claude-sonnet-4-20250514-v1:0": {
            id: "global.anthropic.claude-sonnet-4-20250514-v1:0",
            name: "Claude Sonnet 4 (Global)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "global.anthropic.claude-sonnet-4-5-20250929-v1:0": {
            id: "global.anthropic.claude-sonnet-4-5-20250929-v1:0",
            name: "Claude Sonnet 4.5 (Global)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "google.gemma-3-27b-it": {
            id: "google.gemma-3-27b-it",
            name: "Google Gemma 3 27B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.12,
                output: 0.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 202752,
            maxTokens: 8192,
        },
        "google.gemma-3-4b-it": {
            id: "google.gemma-3-4b-it",
            name: "Gemma 3 4B IT",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.04,
                output: 0.08,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "meta.llama3-1-70b-instruct-v1:0": {
            id: "meta.llama3-1-70b-instruct-v1:0",
            name: "Llama 3.1 70B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.72,
                output: 0.72,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "meta.llama3-1-8b-instruct-v1:0": {
            id: "meta.llama3-1-8b-instruct-v1:0",
            name: "Llama 3.1 8B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.22,
                output: 0.22,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "meta.llama3-2-11b-instruct-v1:0": {
            id: "meta.llama3-2-11b-instruct-v1:0",
            name: "Llama 3.2 11B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.16,
                output: 0.16,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "meta.llama3-2-1b-instruct-v1:0": {
            id: "meta.llama3-2-1b-instruct-v1:0",
            name: "Llama 3.2 1B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.1,
                output: 0.1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131000,
            maxTokens: 4096,
        },
        "meta.llama3-2-3b-instruct-v1:0": {
            id: "meta.llama3-2-3b-instruct-v1:0",
            name: "Llama 3.2 3B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131000,
            maxTokens: 4096,
        },
        "meta.llama3-2-90b-instruct-v1:0": {
            id: "meta.llama3-2-90b-instruct-v1:0",
            name: "Llama 3.2 90B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.72,
                output: 0.72,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "meta.llama3-3-70b-instruct-v1:0": {
            id: "meta.llama3-3-70b-instruct-v1:0",
            name: "Llama 3.3 70B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.72,
                output: 0.72,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "meta.llama4-maverick-17b-instruct-v1:0": {
            id: "meta.llama4-maverick-17b-instruct-v1:0",
            name: "Llama 4 Maverick 17B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.24,
                output: 0.97,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 16384,
        },
        "meta.llama4-scout-17b-instruct-v1:0": {
            id: "meta.llama4-scout-17b-instruct-v1:0",
            name: "Llama 4 Scout 17B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.17,
                output: 0.66,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 3500000,
            maxTokens: 16384,
        },
        "minimax.minimax-m2": {
            id: "minimax.minimax-m2",
            name: "MiniMax M2",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 204608,
            maxTokens: 128000,
        },
        "mistral.ministral-3-14b-instruct": {
            id: "mistral.ministral-3-14b-instruct",
            name: "Ministral 14B 3.0",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.2,
                output: 0.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "mistral.ministral-3-8b-instruct": {
            id: "mistral.ministral-3-8b-instruct",
            name: "Ministral 3 8B",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "mistral.mistral-large-2402-v1:0": {
            id: "mistral.mistral-large-2402-v1:0",
            name: "Mistral Large (24.02)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.5,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "mistral.voxtral-mini-3b-2507": {
            id: "mistral.voxtral-mini-3b-2507",
            name: "Voxtral Mini 3B 2507",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.04,
                output: 0.04,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "mistral.voxtral-small-24b-2507": {
            id: "mistral.voxtral-small-24b-2507",
            name: "Voxtral Small 24B 2507",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.35,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32000,
            maxTokens: 8192,
        },
        "moonshot.kimi-k2-thinking": {
            id: "moonshot.kimi-k2-thinking",
            name: "Kimi K2 Thinking",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 2.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 256000,
        },
        "nvidia.nemotron-nano-12b-v2": {
            id: "nvidia.nemotron-nano-12b-v2",
            name: "NVIDIA Nemotron Nano 12B v2 VL BF16",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.2,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "nvidia.nemotron-nano-9b-v2": {
            id: "nvidia.nemotron-nano-9b-v2",
            name: "NVIDIA Nemotron Nano 9B v2",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.06,
                output: 0.23,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "openai.gpt-oss-120b-1:0": {
            id: "openai.gpt-oss-120b-1:0",
            name: "gpt-oss-120b",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "openai.gpt-oss-20b-1:0": {
            id: "openai.gpt-oss-20b-1:0",
            name: "gpt-oss-20b",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.07,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "openai.gpt-oss-safeguard-120b": {
            id: "openai.gpt-oss-safeguard-120b",
            name: "GPT OSS Safeguard 120B",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "openai.gpt-oss-safeguard-20b": {
            id: "openai.gpt-oss-safeguard-20b",
            name: "GPT OSS Safeguard 20B",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.07,
                output: 0.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "qwen.qwen3-235b-a22b-2507-v1:0": {
            id: "qwen.qwen3-235b-a22b-2507-v1:0",
            name: "Qwen3 235B A22B 2507",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.22,
                output: 0.88,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 131072,
        },
        "qwen.qwen3-32b-v1:0": {
            id: "qwen.qwen3-32b-v1:0",
            name: "Qwen3 32B (dense)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 16384,
            maxTokens: 16384,
        },
        "qwen.qwen3-coder-30b-a3b-v1:0": {
            id: "qwen.qwen3-coder-30b-a3b-v1:0",
            name: "Qwen3 Coder 30B A3B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 131072,
        },
        "qwen.qwen3-coder-480b-a35b-v1:0": {
            id: "qwen.qwen3-coder-480b-a35b-v1:0",
            name: "Qwen3 Coder 480B A35B Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.22,
                output: 1.8,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 65536,
        },
        "qwen.qwen3-next-80b-a3b": {
            id: "qwen.qwen3-next-80b-a3b",
            name: "Qwen/Qwen3-Next-80B-A3B-Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.14,
                output: 1.4,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262000,
            maxTokens: 262000,
        },
        "qwen.qwen3-vl-235b-a22b": {
            id: "qwen.qwen3-vl-235b-a22b",
            name: "Qwen/Qwen3-VL-235B-A22B-Instruct",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262000,
            maxTokens: 262000,
        },
        "us.anthropic.claude-haiku-4-5-20251001-v1:0": {
            id: "us.anthropic.claude-haiku-4-5-20251001-v1:0",
            name: "Claude Haiku 4.5 (US)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.1,
                cacheWrite: 1.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "us.anthropic.claude-opus-4-1-20250805-v1:0": {
            id: "us.anthropic.claude-opus-4-1-20250805-v1:0",
            name: "Claude Opus 4.1 (US)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "us.anthropic.claude-opus-4-20250514-v1:0": {
            id: "us.anthropic.claude-opus-4-20250514-v1:0",
            name: "Claude Opus 4 (US)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "us.anthropic.claude-opus-4-5-20251101-v1:0": {
            id: "us.anthropic.claude-opus-4-5-20251101-v1:0",
            name: "Claude Opus 4.5 (US)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "us.anthropic.claude-opus-4-6-v1": {
            id: "us.anthropic.claude-opus-4-6-v1",
            name: "Claude Opus 4.6 (US)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 128000,
        },
        "us.anthropic.claude-sonnet-4-20250514-v1:0": {
            id: "us.anthropic.claude-sonnet-4-20250514-v1:0",
            name: "Claude Sonnet 4 (US)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "us.anthropic.claude-sonnet-4-5-20250929-v1:0": {
            id: "us.anthropic.claude-sonnet-4-5-20250929-v1:0",
            name: "Claude Sonnet 4.5 (US)",
            api: "bedrock-converse-stream",
            provider: "amazon-bedrock",
            baseUrl: "https://bedrock-runtime.us-east-1.amazonaws.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
    },
    "anthropic": {
        "claude-3-5-haiku-20241022": {
            id: "claude-3-5-haiku-20241022",
            name: "Claude Haiku 3.5",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.8,
                output: 4,
                cacheRead: 0.08,
                cacheWrite: 1,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "claude-3-5-haiku-latest": {
            id: "claude-3-5-haiku-latest",
            name: "Claude Haiku 3.5 (latest)",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.8,
                output: 4,
                cacheRead: 0.08,
                cacheWrite: 1,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "claude-3-5-sonnet-20240620": {
            id: "claude-3-5-sonnet-20240620",
            name: "Claude Sonnet 3.5",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "claude-3-5-sonnet-20241022": {
            id: "claude-3-5-sonnet-20241022",
            name: "Claude Sonnet 3.5 v2",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "claude-3-7-sonnet-20250219": {
            id: "claude-3-7-sonnet-20250219",
            name: "Claude Sonnet 3.7",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-3-7-sonnet-latest": {
            id: "claude-3-7-sonnet-latest",
            name: "Claude Sonnet 3.7 (latest)",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-3-haiku-20240307": {
            id: "claude-3-haiku-20240307",
            name: "Claude Haiku 3",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 1.25,
                cacheRead: 0.03,
                cacheWrite: 0.3,
            },
            contextWindow: 200000,
            maxTokens: 4096,
        },
        "claude-3-opus-20240229": {
            id: "claude-3-opus-20240229",
            name: "Claude Opus 3",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 4096,
        },
        "claude-3-sonnet-20240229": {
            id: "claude-3-sonnet-20240229",
            name: "Claude Sonnet 3",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 0.3,
            },
            contextWindow: 200000,
            maxTokens: 4096,
        },
        "claude-haiku-4-5": {
            id: "claude-haiku-4-5",
            name: "Claude Haiku 4.5 (latest)",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.1,
                cacheWrite: 1.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-haiku-4-5-20251001": {
            id: "claude-haiku-4-5-20251001",
            name: "Claude Haiku 4.5",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.1,
                cacheWrite: 1.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-opus-4-0": {
            id: "claude-opus-4-0",
            name: "Claude Opus 4 (latest)",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "claude-opus-4-1": {
            id: "claude-opus-4-1",
            name: "Claude Opus 4.1 (latest)",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "claude-opus-4-1-20250805": {
            id: "claude-opus-4-1-20250805",
            name: "Claude Opus 4.1",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "claude-opus-4-20250514": {
            id: "claude-opus-4-20250514",
            name: "Claude Opus 4",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "claude-opus-4-5": {
            id: "claude-opus-4-5",
            name: "Claude Opus 4.5 (latest)",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-opus-4-5-20251101": {
            id: "claude-opus-4-5-20251101",
            name: "Claude Opus 4.5",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-opus-4-6": {
            id: "claude-opus-4-6",
            name: "Claude Opus 4.6",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 128000,
        },
        "claude-sonnet-4-0": {
            id: "claude-sonnet-4-0",
            name: "Claude Sonnet 4 (latest)",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-sonnet-4-20250514": {
            id: "claude-sonnet-4-20250514",
            name: "Claude Sonnet 4",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-sonnet-4-5": {
            id: "claude-sonnet-4-5",
            name: "Claude Sonnet 4.5 (latest)",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-sonnet-4-5-20250929": {
            id: "claude-sonnet-4-5-20250929",
            name: "Claude Sonnet 4.5",
            api: "anthropic-messages",
            provider: "anthropic",
            baseUrl: "https://api.anthropic.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
    },
    "azure-openai-responses": {
        "codex-mini-latest": {
            id: "codex-mini-latest",
            name: "Codex Mini",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 1.5,
                output: 6,
                cacheRead: 0.375,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "gpt-4": {
            id: "gpt-4",
            name: "GPT-4",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 30,
                output: 60,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 8192,
        },
        "gpt-4-turbo": {
            id: "gpt-4-turbo",
            name: "GPT-4 Turbo",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 10,
                output: 30,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "gpt-4.1": {
            id: "gpt-4.1",
            name: "GPT-4.1",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "gpt-4.1-mini": {
            id: "gpt-4.1-mini",
            name: "GPT-4.1 mini",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.4,
                output: 1.6,
                cacheRead: 0.1,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "gpt-4.1-nano": {
            id: "gpt-4.1-nano",
            name: "GPT-4.1 nano",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.4,
                cacheRead: 0.03,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "gpt-4o": {
            id: "gpt-4o",
            name: "GPT-4o",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-4o-2024-05-13": {
            id: "gpt-4o-2024-05-13",
            name: "GPT-4o (2024-05-13)",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "gpt-4o-2024-08-06": {
            id: "gpt-4o-2024-08-06",
            name: "GPT-4o (2024-08-06)",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-4o-2024-11-20": {
            id: "gpt-4o-2024-11-20",
            name: "GPT-4o (2024-11-20)",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-4o-mini": {
            id: "gpt-4o-mini",
            name: "GPT-4o mini",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0.08,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-5": {
            id: "gpt-5",
            name: "GPT-5",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5-chat-latest": {
            id: "gpt-5-chat-latest",
            name: "GPT-5 Chat Latest",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-5-codex": {
            id: "gpt-5-codex",
            name: "GPT-5-Codex",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5-mini": {
            id: "gpt-5-mini",
            name: "GPT-5 Mini",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5-nano": {
            id: "gpt-5-nano",
            name: "GPT-5 Nano",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.05,
                output: 0.4,
                cacheRead: 0.005,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5-pro": {
            id: "gpt-5-pro",
            name: "GPT-5 Pro",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 120,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 272000,
        },
        "gpt-5.1": {
            id: "gpt-5.1",
            name: "GPT-5.1",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.13,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.1-chat-latest": {
            id: "gpt-5.1-chat-latest",
            name: "GPT-5.1 Chat",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-5.1-codex": {
            id: "gpt-5.1-codex",
            name: "GPT-5.1 Codex",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex-max": {
            id: "gpt-5.1-codex-max",
            name: "GPT-5.1 Codex Max",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex-mini": {
            id: "gpt-5.1-codex-mini",
            name: "GPT-5.1 Codex mini",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.2": {
            id: "gpt-5.2",
            name: "GPT-5.2",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.2-chat-latest": {
            id: "gpt-5.2-chat-latest",
            name: "GPT-5.2 Chat",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-5.2-codex": {
            id: "gpt-5.2-codex",
            name: "GPT-5.2 Codex",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.2-pro": {
            id: "gpt-5.2-pro",
            name: "GPT-5.2 Pro",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 21,
                output: 168,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.3-codex": {
            id: "gpt-5.3-codex",
            name: "GPT-5.3 Codex",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "o1": {
            id: "o1",
            name: "o1",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 60,
                cacheRead: 7.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o1-pro": {
            id: "o1-pro",
            name: "o1-pro",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 150,
                output: 600,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o3": {
            id: "o3",
            name: "o3",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o3-deep-research": {
            id: "o3-deep-research",
            name: "o3-deep-research",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 10,
                output: 40,
                cacheRead: 2.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o3-mini": {
            id: "o3-mini",
            name: "o3-mini",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 1.1,
                output: 4.4,
                cacheRead: 0.55,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o3-pro": {
            id: "o3-pro",
            name: "o3-pro",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 20,
                output: 80,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o4-mini": {
            id: "o4-mini",
            name: "o4-mini",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.1,
                output: 4.4,
                cacheRead: 0.28,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o4-mini-deep-research": {
            id: "o4-mini-deep-research",
            name: "o4-mini-deep-research",
            api: "azure-openai-responses",
            provider: "azure-openai-responses",
            baseUrl: "",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
    },
    "cerebras": {
        "gpt-oss-120b": {
            id: "gpt-oss-120b",
            name: "GPT OSS 120B",
            api: "openai-completions",
            provider: "cerebras",
            baseUrl: "https://api.cerebras.ai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 0.69,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 32768,
        },
        "qwen-3-235b-a22b-instruct-2507": {
            id: "qwen-3-235b-a22b-instruct-2507",
            name: "Qwen 3 235B Instruct",
            api: "openai-completions",
            provider: "cerebras",
            baseUrl: "https://api.cerebras.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131000,
            maxTokens: 32000,
        },
        "zai-glm-4.7": {
            id: "zai-glm-4.7",
            name: "Z.AI GLM-4.7",
            api: "openai-completions",
            provider: "cerebras",
            baseUrl: "https://api.cerebras.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 40000,
        },
    },
    "github-copilot": {
        "claude-haiku-4.5": {
            id: "claude-haiku-4.5",
            name: "Claude Haiku 4.5",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16000,
        },
        "claude-opus-4.5": {
            id: "claude-opus-4.5",
            name: "Claude Opus 4.5",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16000,
        },
        "claude-opus-4.6": {
            id: "claude-opus-4.6",
            name: "Claude Opus 4.6",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
        "claude-sonnet-4": {
            id: "claude-sonnet-4",
            name: "Claude Sonnet 4",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16000,
        },
        "claude-sonnet-4.5": {
            id: "claude-sonnet-4.5",
            name: "Claude Sonnet 4.5",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16000,
        },
        "gemini-2.5-pro": {
            id: "gemini-2.5-pro",
            name: "Gemini 2.5 Pro",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
        "gemini-3-flash-preview": {
            id: "gemini-3-flash-preview",
            name: "Gemini 3 Flash",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
        "gemini-3-pro-preview": {
            id: "gemini-3-pro-preview",
            name: "Gemini 3 Pro Preview",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
        "gpt-4.1": {
            id: "gpt-4.1",
            name: "GPT-4.1",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-4o": {
            id: "gpt-4o",
            name: "GPT-4o",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 64000,
            maxTokens: 16384,
        },
        "gpt-5": {
            id: "gpt-5",
            name: "GPT-5",
            api: "openai-responses",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "gpt-5-mini": {
            id: "gpt-5-mini",
            name: "GPT-5-mini",
            api: "openai-responses",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
        "gpt-5.1": {
            id: "gpt-5.1",
            name: "GPT-5.1",
            api: "openai-responses",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex": {
            id: "gpt-5.1-codex",
            name: "GPT-5.1-Codex",
            api: "openai-responses",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex-max": {
            id: "gpt-5.1-codex-max",
            name: "GPT-5.1-Codex-max",
            api: "openai-responses",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex-mini": {
            id: "gpt-5.1-codex-mini",
            name: "GPT-5.1-Codex-mini",
            api: "openai-responses",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 100000,
        },
        "gpt-5.2": {
            id: "gpt-5.2",
            name: "GPT-5.2",
            api: "openai-responses",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
        "gpt-5.2-codex": {
            id: "gpt-5.2-codex",
            name: "GPT-5.2-Codex",
            api: "openai-responses",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 272000,
            maxTokens: 128000,
        },
        "grok-code-fast-1": {
            id: "grok-code-fast-1",
            name: "Grok Code Fast 1",
            api: "openai-completions",
            provider: "github-copilot",
            baseUrl: "https://api.individual.githubcopilot.com",
            headers: { "User-Agent": "GitHubCopilotChat/0.35.0", "Editor-Version": "vscode/1.107.0", "Editor-Plugin-Version": "copilot-chat/0.35.0", "Copilot-Integration-Id": "vscode-chat" },
            compat: { "supportsStore": false, "supportsDeveloperRole": false, "supportsReasoningEffort": false },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
    },
    "google": {
        "gemini-1.5-flash": {
            id: "gemini-1.5-flash",
            name: "Gemini 1.5 Flash",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.075,
                output: 0.3,
                cacheRead: 0.01875,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 8192,
        },
        "gemini-1.5-flash-8b": {
            id: "gemini-1.5-flash-8b",
            name: "Gemini 1.5 Flash-8B",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.0375,
                output: 0.15,
                cacheRead: 0.01,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 8192,
        },
        "gemini-1.5-pro": {
            id: "gemini-1.5-pro",
            name: "Gemini 1.5 Pro",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 5,
                cacheRead: 0.3125,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 8192,
        },
        "gemini-2.0-flash": {
            id: "gemini-2.0-flash",
            name: "Gemini 2.0 Flash",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.4,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 8192,
        },
        "gemini-2.0-flash-lite": {
            id: "gemini-2.0-flash-lite",
            name: "Gemini 2.0 Flash Lite",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.075,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 8192,
        },
        "gemini-2.5-flash": {
            id: "gemini-2.5-flash",
            name: "Gemini 2.5 Flash",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 2.5,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-flash-lite": {
            id: "gemini-2.5-flash-lite",
            name: "Gemini 2.5 Flash Lite",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.4,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-flash-lite-preview-06-17": {
            id: "gemini-2.5-flash-lite-preview-06-17",
            name: "Gemini 2.5 Flash Lite Preview 06-17",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.4,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-flash-lite-preview-09-2025": {
            id: "gemini-2.5-flash-lite-preview-09-2025",
            name: "Gemini 2.5 Flash Lite Preview 09-25",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.4,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-flash-preview-04-17": {
            id: "gemini-2.5-flash-preview-04-17",
            name: "Gemini 2.5 Flash Preview 04-17",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0.0375,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-flash-preview-05-20": {
            id: "gemini-2.5-flash-preview-05-20",
            name: "Gemini 2.5 Flash Preview 05-20",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0.0375,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-flash-preview-09-2025": {
            id: "gemini-2.5-flash-preview-09-2025",
            name: "Gemini 2.5 Flash Preview 09-25",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 2.5,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-pro": {
            id: "gemini-2.5-pro",
            name: "Gemini 2.5 Pro",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.31,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-pro-preview-05-06": {
            id: "gemini-2.5-pro-preview-05-06",
            name: "Gemini 2.5 Pro Preview 05-06",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.31,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-pro-preview-06-05": {
            id: "gemini-2.5-pro-preview-06-05",
            name: "Gemini 2.5 Pro Preview 06-05",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.31,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-3-flash-preview": {
            id: "gemini-3-flash-preview",
            name: "Gemini 3 Flash Preview",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 3,
                cacheRead: 0.05,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-3-pro-preview": {
            id: "gemini-3-pro-preview",
            name: "Gemini 3 Pro Preview",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 12,
                cacheRead: 0.2,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 64000,
        },
        "gemini-flash-latest": {
            id: "gemini-flash-latest",
            name: "Gemini Flash Latest",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 2.5,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-flash-lite-latest": {
            id: "gemini-flash-lite-latest",
            name: "Gemini Flash-Lite Latest",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.4,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-live-2.5-flash": {
            id: "gemini-live-2.5-flash",
            name: "Gemini Live 2.5 Flash",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 8000,
        },
        "gemini-live-2.5-flash-preview-native-audio": {
            id: "gemini-live-2.5-flash-preview-native-audio",
            name: "Gemini Live 2.5 Flash Preview Native Audio",
            api: "google-generative-ai",
            provider: "google",
            baseUrl: "https://generativelanguage.googleapis.com/v1beta",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.5,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 65536,
        },
    },
    "google-antigravity": {
        "claude-opus-4-5-thinking": {
            id: "claude-opus-4-5-thinking",
            name: "Claude Opus 4.5 Thinking (Antigravity)",
            api: "google-gemini-cli",
            provider: "google-antigravity",
            baseUrl: "https://daily-cloudcode-pa.sandbox.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-sonnet-4-5": {
            id: "claude-sonnet-4-5",
            name: "Claude Sonnet 4.5 (Antigravity)",
            api: "google-gemini-cli",
            provider: "google-antigravity",
            baseUrl: "https://daily-cloudcode-pa.sandbox.googleapis.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-sonnet-4-5-thinking": {
            id: "claude-sonnet-4-5-thinking",
            name: "Claude Sonnet 4.5 Thinking (Antigravity)",
            api: "google-gemini-cli",
            provider: "google-antigravity",
            baseUrl: "https://daily-cloudcode-pa.sandbox.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "gemini-3-flash": {
            id: "gemini-3-flash",
            name: "Gemini 3 Flash (Antigravity)",
            api: "google-gemini-cli",
            provider: "google-antigravity",
            baseUrl: "https://daily-cloudcode-pa.sandbox.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 3,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "gemini-3-pro-high": {
            id: "gemini-3-pro-high",
            name: "Gemini 3 Pro High (Antigravity)",
            api: "google-gemini-cli",
            provider: "google-antigravity",
            baseUrl: "https://daily-cloudcode-pa.sandbox.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 12,
                cacheRead: 0.2,
                cacheWrite: 2.375,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "gemini-3-pro-low": {
            id: "gemini-3-pro-low",
            name: "Gemini 3 Pro Low (Antigravity)",
            api: "google-gemini-cli",
            provider: "google-antigravity",
            baseUrl: "https://daily-cloudcode-pa.sandbox.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 12,
                cacheRead: 0.2,
                cacheWrite: 2.375,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "gpt-oss-120b-medium": {
            id: "gpt-oss-120b-medium",
            name: "GPT-OSS 120B Medium (Antigravity)",
            api: "google-gemini-cli",
            provider: "google-antigravity",
            baseUrl: "https://daily-cloudcode-pa.sandbox.googleapis.com",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.09,
                output: 0.36,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 32768,
        },
    },
    "google-gemini-cli": {
        "gemini-2.0-flash": {
            id: "gemini-2.0-flash",
            name: "Gemini 2.0 Flash (Cloud Code Assist)",
            api: "google-gemini-cli",
            provider: "google-gemini-cli",
            baseUrl: "https://cloudcode-pa.googleapis.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 8192,
        },
        "gemini-2.5-flash": {
            id: "gemini-2.5-flash",
            name: "Gemini 2.5 Flash (Cloud Code Assist)",
            api: "google-gemini-cli",
            provider: "google-gemini-cli",
            baseUrl: "https://cloudcode-pa.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "gemini-2.5-pro": {
            id: "gemini-2.5-pro",
            name: "Gemini 2.5 Pro (Cloud Code Assist)",
            api: "google-gemini-cli",
            provider: "google-gemini-cli",
            baseUrl: "https://cloudcode-pa.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "gemini-3-flash-preview": {
            id: "gemini-3-flash-preview",
            name: "Gemini 3 Flash Preview (Cloud Code Assist)",
            api: "google-gemini-cli",
            provider: "google-gemini-cli",
            baseUrl: "https://cloudcode-pa.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "gemini-3-pro-preview": {
            id: "gemini-3-pro-preview",
            name: "Gemini 3 Pro Preview (Cloud Code Assist)",
            api: "google-gemini-cli",
            provider: "google-gemini-cli",
            baseUrl: "https://cloudcode-pa.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
    },
    "google-vertex": {
        "gemini-1.5-flash": {
            id: "gemini-1.5-flash",
            name: "Gemini 1.5 Flash (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.075,
                output: 0.3,
                cacheRead: 0.01875,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 8192,
        },
        "gemini-1.5-flash-8b": {
            id: "gemini-1.5-flash-8b",
            name: "Gemini 1.5 Flash-8B (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.0375,
                output: 0.15,
                cacheRead: 0.01,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 8192,
        },
        "gemini-1.5-pro": {
            id: "gemini-1.5-pro",
            name: "Gemini 1.5 Pro (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 5,
                cacheRead: 0.3125,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 8192,
        },
        "gemini-2.0-flash": {
            id: "gemini-2.0-flash",
            name: "Gemini 2.0 Flash (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0.0375,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 8192,
        },
        "gemini-2.0-flash-lite": {
            id: "gemini-2.0-flash-lite",
            name: "Gemini 2.0 Flash Lite (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.075,
                output: 0.3,
                cacheRead: 0.01875,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-flash": {
            id: "gemini-2.5-flash",
            name: "Gemini 2.5 Flash (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 2.5,
                cacheRead: 0.03,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-flash-lite": {
            id: "gemini-2.5-flash-lite",
            name: "Gemini 2.5 Flash Lite (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.4,
                cacheRead: 0.01,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-flash-lite-preview-09-2025": {
            id: "gemini-2.5-flash-lite-preview-09-2025",
            name: "Gemini 2.5 Flash Lite Preview 09-25 (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.4,
                cacheRead: 0.01,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-2.5-pro": {
            id: "gemini-2.5-pro",
            name: "Gemini 2.5 Pro (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-3-flash-preview": {
            id: "gemini-3-flash-preview",
            name: "Gemini 3 Flash Preview (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 3,
                cacheRead: 0.05,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-3-pro-preview": {
            id: "gemini-3-pro-preview",
            name: "Gemini 3 Pro Preview (Vertex)",
            api: "google-vertex",
            provider: "google-vertex",
            baseUrl: "https://{location}-aiplatform.googleapis.com",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 12,
                cacheRead: 0.2,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 64000,
        },
    },
    "groq": {
        "deepseek-r1-distill-llama-70b": {
            id: "deepseek-r1-distill-llama-70b",
            name: "DeepSeek R1 Distill Llama 70B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.75,
                output: 0.99,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "gemma2-9b-it": {
            id: "gemma2-9b-it",
            name: "Gemma 2 9B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.2,
                output: 0.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 8192,
        },
        "llama-3.1-8b-instant": {
            id: "llama-3.1-8b-instant",
            name: "Llama 3.1 8B Instant",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.05,
                output: 0.08,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "llama-3.3-70b-versatile": {
            id: "llama-3.3-70b-versatile",
            name: "Llama 3.3 70B Versatile",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.59,
                output: 0.79,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 32768,
        },
        "llama3-70b-8192": {
            id: "llama3-70b-8192",
            name: "Llama 3 70B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.59,
                output: 0.79,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 8192,
        },
        "llama3-8b-8192": {
            id: "llama3-8b-8192",
            name: "Llama 3 8B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.05,
                output: 0.08,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 8192,
        },
        "meta-llama/llama-4-maverick-17b-128e-instruct": {
            id: "meta-llama/llama-4-maverick-17b-128e-instruct",
            name: "Llama 4 Maverick 17B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.2,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "meta-llama/llama-4-scout-17b-16e-instruct": {
            id: "meta-llama/llama-4-scout-17b-16e-instruct",
            name: "Llama 4 Scout 17B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.11,
                output: 0.34,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "mistral-saba-24b": {
            id: "mistral-saba-24b",
            name: "Mistral Saba 24B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.79,
                output: 0.79,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 32768,
        },
        "moonshotai/kimi-k2-instruct": {
            id: "moonshotai/kimi-k2-instruct",
            name: "Kimi K2 Instruct",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1,
                output: 3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
        "moonshotai/kimi-k2-instruct-0905": {
            id: "moonshotai/kimi-k2-instruct-0905",
            name: "Kimi K2 Instruct 0905",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1,
                output: 3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 16384,
        },
        "openai/gpt-oss-120b": {
            id: "openai/gpt-oss-120b",
            name: "GPT OSS 120B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 65536,
        },
        "openai/gpt-oss-20b": {
            id: "openai/gpt-oss-20b",
            name: "GPT OSS 20B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.075,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 65536,
        },
        "qwen-qwq-32b": {
            id: "qwen-qwq-32b",
            name: "Qwen QwQ 32B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.29,
                output: 0.39,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
        "qwen/qwen3-32b": {
            id: "qwen/qwen3-32b",
            name: "Qwen3 32B",
            api: "openai-completions",
            provider: "groq",
            baseUrl: "https://api.groq.com/openai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.29,
                output: 0.59,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
    },
    "huggingface": {
        "MiniMaxAI/MiniMax-M2.1": {
            id: "MiniMaxAI/MiniMax-M2.1",
            name: "MiniMax-M2.1",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "Qwen/Qwen3-235B-A22B-Thinking-2507": {
            id: "Qwen/Qwen3-235B-A22B-Thinking-2507",
            name: "Qwen3-235B-A22B-Thinking-2507",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 131072,
        },
        "Qwen/Qwen3-Coder-480B-A35B-Instruct": {
            id: "Qwen/Qwen3-Coder-480B-A35B-Instruct",
            name: "Qwen3-Coder-480B-A35B-Instruct",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 66536,
        },
        "Qwen/Qwen3-Next-80B-A3B-Instruct": {
            id: "Qwen/Qwen3-Next-80B-A3B-Instruct",
            name: "Qwen3-Next-80B-A3B-Instruct",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 66536,
        },
        "Qwen/Qwen3-Next-80B-A3B-Thinking": {
            id: "Qwen/Qwen3-Next-80B-A3B-Thinking",
            name: "Qwen3-Next-80B-A3B-Thinking",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 131072,
        },
        "XiaomiMiMo/MiMo-V2-Flash": {
            id: "XiaomiMiMo/MiMo-V2-Flash",
            name: "MiMo-V2-Flash",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.1,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "deepseek-ai/DeepSeek-R1-0528": {
            id: "deepseek-ai/DeepSeek-R1-0528",
            name: "DeepSeek-R1-0528",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 3,
                output: 5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 163840,
        },
        "deepseek-ai/DeepSeek-V3.2": {
            id: "deepseek-ai/DeepSeek-V3.2",
            name: "DeepSeek-V3.2",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.28,
                output: 0.4,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 65536,
        },
        "moonshotai/Kimi-K2-Instruct": {
            id: "moonshotai/Kimi-K2-Instruct",
            name: "Kimi-K2-Instruct",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1,
                output: 3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
        "moonshotai/Kimi-K2-Instruct-0905": {
            id: "moonshotai/Kimi-K2-Instruct-0905",
            name: "Kimi-K2-Instruct-0905",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1,
                output: 3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 16384,
        },
        "moonshotai/Kimi-K2-Thinking": {
            id: "moonshotai/Kimi-K2-Thinking",
            name: "Kimi-K2-Thinking",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 2.5,
                cacheRead: 0.15,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "moonshotai/Kimi-K2.5": {
            id: "moonshotai/Kimi-K2.5",
            name: "Kimi-K2.5",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.6,
                output: 3,
                cacheRead: 0.1,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "zai-org/GLM-4.7": {
            id: "zai-org/GLM-4.7",
            name: "GLM-4.7",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 2.2,
                cacheRead: 0.11,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "zai-org/GLM-4.7-Flash": {
            id: "zai-org/GLM-4.7-Flash",
            name: "GLM-4.7-Flash",
            api: "openai-completions",
            provider: "huggingface",
            baseUrl: "https://router.huggingface.co/v1",
            compat: { "supportsDeveloperRole": false },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 128000,
        },
    },
    "kimi-coding": {
        "k2p5": {
            id: "k2p5",
            name: "Kimi K2.5",
            api: "anthropic-messages",
            provider: "kimi-coding",
            baseUrl: "https://api.kimi.com/coding",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 32768,
        },
        "kimi-k2-thinking": {
            id: "kimi-k2-thinking",
            name: "Kimi K2 Thinking",
            api: "anthropic-messages",
            provider: "kimi-coding",
            baseUrl: "https://api.kimi.com/coding",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 32768,
        },
    },
    "minimax": {
        "MiniMax-M2": {
            id: "MiniMax-M2",
            name: "MiniMax-M2",
            api: "anthropic-messages",
            provider: "minimax",
            baseUrl: "https://api.minimax.io/anthropic",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 196608,
            maxTokens: 128000,
        },
        "MiniMax-M2.1": {
            id: "MiniMax-M2.1",
            name: "MiniMax-M2.1",
            api: "anthropic-messages",
            provider: "minimax",
            baseUrl: "https://api.minimax.io/anthropic",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
    },
    "minimax-cn": {
        "MiniMax-M2": {
            id: "MiniMax-M2",
            name: "MiniMax-M2",
            api: "anthropic-messages",
            provider: "minimax-cn",
            baseUrl: "https://api.minimaxi.com/anthropic",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 196608,
            maxTokens: 128000,
        },
        "MiniMax-M2.1": {
            id: "MiniMax-M2.1",
            name: "MiniMax-M2.1",
            api: "anthropic-messages",
            provider: "minimax-cn",
            baseUrl: "https://api.minimaxi.com/anthropic",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
    },
    "mistral": {
        "codestral-latest": {
            id: "codestral-latest",
            name: "Codestral",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 0.9,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 4096,
        },
        "devstral-2512": {
            id: "devstral-2512",
            name: "Devstral 2",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.4,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "devstral-medium-2507": {
            id: "devstral-medium-2507",
            name: "Devstral Medium",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.4,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "devstral-medium-latest": {
            id: "devstral-medium-latest",
            name: "Devstral 2",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.4,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "devstral-small-2505": {
            id: "devstral-small-2505",
            name: "Devstral Small 2505",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.1,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "devstral-small-2507": {
            id: "devstral-small-2507",
            name: "Devstral Small",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.1,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "labs-devstral-small-2512": {
            id: "labs-devstral-small-2512",
            name: "Devstral Small 2",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 256000,
        },
        "magistral-medium-latest": {
            id: "magistral-medium-latest",
            name: "Magistral Medium",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 2,
                output: 5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "magistral-small": {
            id: "magistral-small",
            name: "Magistral Small",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.5,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "ministral-3b-latest": {
            id: "ministral-3b-latest",
            name: "Ministral 3B",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.04,
                output: 0.04,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "ministral-8b-latest": {
            id: "ministral-8b-latest",
            name: "Ministral 8B",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.1,
                output: 0.1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "mistral-large-2411": {
            id: "mistral-large-2411",
            name: "Mistral Large 2.1",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
        "mistral-large-2512": {
            id: "mistral-large-2512",
            name: "Mistral Large 3",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "mistral-large-latest": {
            id: "mistral-large-latest",
            name: "Mistral Large",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "mistral-medium-2505": {
            id: "mistral-medium-2505",
            name: "Mistral Medium 3",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.4,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "mistral-medium-2508": {
            id: "mistral-medium-2508",
            name: "Mistral Medium 3.1",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.4,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "mistral-medium-latest": {
            id: "mistral-medium-latest",
            name: "Mistral Medium",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.4,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "mistral-nemo": {
            id: "mistral-nemo",
            name: "Mistral Nemo",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "mistral-small-2506": {
            id: "mistral-small-2506",
            name: "Mistral Small 3.2",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "mistral-small-latest": {
            id: "mistral-small-latest",
            name: "Mistral Small",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "open-mistral-7b": {
            id: "open-mistral-7b",
            name: "Mistral 7B",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 0.25,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 8000,
            maxTokens: 8000,
        },
        "open-mixtral-8x22b": {
            id: "open-mixtral-8x22b",
            name: "Mixtral 8x22B",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 64000,
            maxTokens: 64000,
        },
        "open-mixtral-8x7b": {
            id: "open-mixtral-8x7b",
            name: "Mixtral 8x7B",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.7,
                output: 0.7,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32000,
            maxTokens: 32000,
        },
        "pixtral-12b": {
            id: "pixtral-12b",
            name: "Pixtral 12B",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "pixtral-large-latest": {
            id: "pixtral-large-latest",
            name: "Pixtral Large",
            api: "openai-completions",
            provider: "mistral",
            baseUrl: "https://api.mistral.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
    },
    "openai": {
        "codex-mini-latest": {
            id: "codex-mini-latest",
            name: "Codex Mini",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 1.5,
                output: 6,
                cacheRead: 0.375,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "gpt-4": {
            id: "gpt-4",
            name: "GPT-4",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 30,
                output: 60,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 8192,
        },
        "gpt-4-turbo": {
            id: "gpt-4-turbo",
            name: "GPT-4 Turbo",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 10,
                output: 30,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "gpt-4.1": {
            id: "gpt-4.1",
            name: "GPT-4.1",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "gpt-4.1-mini": {
            id: "gpt-4.1-mini",
            name: "GPT-4.1 mini",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.4,
                output: 1.6,
                cacheRead: 0.1,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "gpt-4.1-nano": {
            id: "gpt-4.1-nano",
            name: "GPT-4.1 nano",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.1,
                output: 0.4,
                cacheRead: 0.03,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "gpt-4o": {
            id: "gpt-4o",
            name: "GPT-4o",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-4o-2024-05-13": {
            id: "gpt-4o-2024-05-13",
            name: "GPT-4o (2024-05-13)",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "gpt-4o-2024-08-06": {
            id: "gpt-4o-2024-08-06",
            name: "GPT-4o (2024-08-06)",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-4o-2024-11-20": {
            id: "gpt-4o-2024-11-20",
            name: "GPT-4o (2024-11-20)",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-4o-mini": {
            id: "gpt-4o-mini",
            name: "GPT-4o mini",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0.08,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-5": {
            id: "gpt-5",
            name: "GPT-5",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5-chat-latest": {
            id: "gpt-5-chat-latest",
            name: "GPT-5 Chat Latest",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-5-codex": {
            id: "gpt-5-codex",
            name: "GPT-5-Codex",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5-mini": {
            id: "gpt-5-mini",
            name: "GPT-5 Mini",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5-nano": {
            id: "gpt-5-nano",
            name: "GPT-5 Nano",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.05,
                output: 0.4,
                cacheRead: 0.005,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5-pro": {
            id: "gpt-5-pro",
            name: "GPT-5 Pro",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 120,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 272000,
        },
        "gpt-5.1": {
            id: "gpt-5.1",
            name: "GPT-5.1",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.13,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.1-chat-latest": {
            id: "gpt-5.1-chat-latest",
            name: "GPT-5.1 Chat",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-5.1-codex": {
            id: "gpt-5.1-codex",
            name: "GPT-5.1 Codex",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex-max": {
            id: "gpt-5.1-codex-max",
            name: "GPT-5.1 Codex Max",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex-mini": {
            id: "gpt-5.1-codex-mini",
            name: "GPT-5.1 Codex mini",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.2": {
            id: "gpt-5.2",
            name: "GPT-5.2",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.2-chat-latest": {
            id: "gpt-5.2-chat-latest",
            name: "GPT-5.2 Chat",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "gpt-5.2-codex": {
            id: "gpt-5.2-codex",
            name: "GPT-5.2 Codex",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.2-pro": {
            id: "gpt-5.2-pro",
            name: "GPT-5.2 Pro",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 21,
                output: 168,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.3-codex": {
            id: "gpt-5.3-codex",
            name: "GPT-5.3 Codex",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "o1": {
            id: "o1",
            name: "o1",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 60,
                cacheRead: 7.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o1-pro": {
            id: "o1-pro",
            name: "o1-pro",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 150,
                output: 600,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o3": {
            id: "o3",
            name: "o3",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o3-deep-research": {
            id: "o3-deep-research",
            name: "o3-deep-research",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 10,
                output: 40,
                cacheRead: 2.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o3-mini": {
            id: "o3-mini",
            name: "o3-mini",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 1.1,
                output: 4.4,
                cacheRead: 0.55,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o3-pro": {
            id: "o3-pro",
            name: "o3-pro",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 20,
                output: 80,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o4-mini": {
            id: "o4-mini",
            name: "o4-mini",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.1,
                output: 4.4,
                cacheRead: 0.28,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "o4-mini-deep-research": {
            id: "o4-mini-deep-research",
            name: "o4-mini-deep-research",
            api: "openai-responses",
            provider: "openai",
            baseUrl: "https://api.openai.com/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
    },
    "openai-codex": {
        "gpt-5.1": {
            id: "gpt-5.1",
            name: "GPT-5.1",
            api: "openai-codex-responses",
            provider: "openai-codex",
            baseUrl: "https://chatgpt.com/backend-api",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 272000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex-max": {
            id: "gpt-5.1-codex-max",
            name: "GPT-5.1 Codex Max",
            api: "openai-codex-responses",
            provider: "openai-codex",
            baseUrl: "https://chatgpt.com/backend-api",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 272000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex-mini": {
            id: "gpt-5.1-codex-mini",
            name: "GPT-5.1 Codex Mini",
            api: "openai-codex-responses",
            provider: "openai-codex",
            baseUrl: "https://chatgpt.com/backend-api",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 272000,
            maxTokens: 128000,
        },
        "gpt-5.2": {
            id: "gpt-5.2",
            name: "GPT-5.2",
            api: "openai-codex-responses",
            provider: "openai-codex",
            baseUrl: "https://chatgpt.com/backend-api",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 272000,
            maxTokens: 128000,
        },
        "gpt-5.2-codex": {
            id: "gpt-5.2-codex",
            name: "GPT-5.2 Codex",
            api: "openai-codex-responses",
            provider: "openai-codex",
            baseUrl: "https://chatgpt.com/backend-api",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 272000,
            maxTokens: 128000,
        },
        "gpt-5.3-codex": {
            id: "gpt-5.3-codex",
            name: "GPT-5.3 Codex",
            api: "openai-codex-responses",
            provider: "openai-codex",
            baseUrl: "https://chatgpt.com/backend-api",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 272000,
            maxTokens: 128000,
        },
    },
    "opencode": {
        "big-pickle": {
            id: "big-pickle",
            name: "Big Pickle",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 128000,
        },
        "claude-3-5-haiku": {
            id: "claude-3-5-haiku",
            name: "Claude Haiku 3.5",
            api: "anthropic-messages",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.8,
                output: 4,
                cacheRead: 0.08,
                cacheWrite: 1,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "claude-haiku-4-5": {
            id: "claude-haiku-4-5",
            name: "Claude Haiku 4.5",
            api: "anthropic-messages",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.1,
                cacheWrite: 1.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-opus-4-1": {
            id: "claude-opus-4-1",
            name: "Claude Opus 4.1",
            api: "anthropic-messages",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "claude-opus-4-5": {
            id: "claude-opus-4-5",
            name: "Claude Opus 4.5",
            api: "anthropic-messages",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "claude-opus-4-6": {
            id: "claude-opus-4-6",
            name: "Claude Opus 4.6",
            api: "anthropic-messages",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 128000,
        },
        "claude-sonnet-4": {
            id: "claude-sonnet-4",
            name: "Claude Sonnet 4",
            api: "anthropic-messages",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 1000000,
            maxTokens: 64000,
        },
        "claude-sonnet-4-5": {
            id: "claude-sonnet-4-5",
            name: "Claude Sonnet 4.5",
            api: "anthropic-messages",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 1000000,
            maxTokens: 64000,
        },
        "gemini-3-flash": {
            id: "gemini-3-flash",
            name: "Gemini 3 Flash",
            api: "google-generative-ai",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 3,
                cacheRead: 0.05,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "gemini-3-pro": {
            id: "gemini-3-pro",
            name: "Gemini 3 Pro",
            api: "google-generative-ai",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 12,
                cacheRead: 0.2,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "glm-4.6": {
            id: "glm-4.6",
            name: "GLM-4.6",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 2.2,
                cacheRead: 0.1,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "glm-4.7": {
            id: "glm-4.7",
            name: "GLM-4.7",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 2.2,
                cacheRead: 0.1,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "glm-4.7-free": {
            id: "glm-4.7-free",
            name: "GLM-4.7 Free",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "gpt-5": {
            id: "gpt-5",
            name: "GPT-5",
            api: "openai-responses",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.07,
                output: 8.5,
                cacheRead: 0.107,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5-codex": {
            id: "gpt-5-codex",
            name: "GPT-5 Codex",
            api: "openai-responses",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.07,
                output: 8.5,
                cacheRead: 0.107,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5-nano": {
            id: "gpt-5-nano",
            name: "GPT-5 Nano",
            api: "openai-responses",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.1": {
            id: "gpt-5.1",
            name: "GPT-5.1",
            api: "openai-responses",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.07,
                output: 8.5,
                cacheRead: 0.107,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex": {
            id: "gpt-5.1-codex",
            name: "GPT-5.1 Codex",
            api: "openai-responses",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.07,
                output: 8.5,
                cacheRead: 0.107,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex-max": {
            id: "gpt-5.1-codex-max",
            name: "GPT-5.1 Codex Max",
            api: "openai-responses",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.1-codex-mini": {
            id: "gpt-5.1-codex-mini",
            name: "GPT-5.1 Codex Mini",
            api: "openai-responses",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.025,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.2": {
            id: "gpt-5.2",
            name: "GPT-5.2",
            api: "openai-responses",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "gpt-5.2-codex": {
            id: "gpt-5.2-codex",
            name: "GPT-5.2 Codex",
            api: "openai-responses",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "kimi-k2": {
            id: "kimi-k2",
            name: "Kimi K2",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.4,
                output: 2.5,
                cacheRead: 0.4,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "kimi-k2-thinking": {
            id: "kimi-k2-thinking",
            name: "Kimi K2 Thinking",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.4,
                output: 2.5,
                cacheRead: 0.4,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "kimi-k2.5": {
            id: "kimi-k2.5",
            name: "Kimi K2.5",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.6,
                output: 3,
                cacheRead: 0.08,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "kimi-k2.5-free": {
            id: "kimi-k2.5-free",
            name: "Kimi K2.5 Free",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "minimax-m2.1": {
            id: "minimax-m2.1",
            name: "MiniMax M2.1",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1.2,
                cacheRead: 0.1,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "minimax-m2.1-free": {
            id: "minimax-m2.1-free",
            name: "MiniMax M2.1 Free",
            api: "anthropic-messages",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "qwen3-coder": {
            id: "qwen3-coder",
            name: "Qwen3 Coder",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.45,
                output: 1.8,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 65536,
        },
        "trinity-large-preview-free": {
            id: "trinity-large-preview-free",
            name: "Trinity Large Preview",
            api: "openai-completions",
            provider: "opencode",
            baseUrl: "https://opencode.ai/zen/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
    },
    "openrouter": {
        "ai21/jamba-large-1.7": {
            id: "ai21/jamba-large-1.7",
            name: "AI21: Jamba Large 1.7",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 4096,
        },
        "ai21/jamba-mini-1.7": {
            id: "ai21/jamba-mini-1.7",
            name: "AI21: Jamba Mini 1.7",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 0.39999999999999997,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 4096,
        },
        "alibaba/tongyi-deepresearch-30b-a3b": {
            id: "alibaba/tongyi-deepresearch-30b-a3b",
            name: "Tongyi DeepResearch 30B A3B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.09,
                output: 0.44999999999999996,
                cacheRead: 0.09,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "allenai/olmo-3.1-32b-instruct": {
            id: "allenai/olmo-3.1-32b-instruct",
            name: "AllenAI: Olmo 3.1 32B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 65536,
            maxTokens: 4096,
        },
        "amazon/nova-2-lite-v1": {
            id: "amazon/nova-2-lite-v1",
            name: "Amazon: Nova 2 Lite",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 2.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 65535,
        },
        "amazon/nova-lite-v1": {
            id: "amazon/nova-lite-v1",
            name: "Amazon: Nova Lite 1.0",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.06,
                output: 0.24,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 300000,
            maxTokens: 5120,
        },
        "amazon/nova-micro-v1": {
            id: "amazon/nova-micro-v1",
            name: "Amazon: Nova Micro 1.0",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.035,
                output: 0.14,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 5120,
        },
        "amazon/nova-premier-v1": {
            id: "amazon/nova-premier-v1",
            name: "Amazon: Nova Premier 1.0",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 12.5,
                cacheRead: 0.625,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 32000,
        },
        "amazon/nova-pro-v1": {
            id: "amazon/nova-pro-v1",
            name: "Amazon: Nova Pro 1.0",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.7999999999999999,
                output: 3.1999999999999997,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 300000,
            maxTokens: 5120,
        },
        "anthropic/claude-3-haiku": {
            id: "anthropic/claude-3-haiku",
            name: "Anthropic: Claude 3 Haiku",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 1.25,
                cacheRead: 0.03,
                cacheWrite: 0.3,
            },
            contextWindow: 200000,
            maxTokens: 4096,
        },
        "anthropic/claude-3.5-haiku": {
            id: "anthropic/claude-3.5-haiku",
            name: "Anthropic: Claude 3.5 Haiku",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.7999999999999999,
                output: 4,
                cacheRead: 0.08,
                cacheWrite: 1,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "anthropic/claude-3.5-sonnet": {
            id: "anthropic/claude-3.5-sonnet",
            name: "Anthropic: Claude 3.5 Sonnet",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 6,
                output: 30,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "anthropic/claude-3.7-sonnet": {
            id: "anthropic/claude-3.7-sonnet",
            name: "Anthropic: Claude 3.7 Sonnet",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "anthropic/claude-3.7-sonnet:thinking": {
            id: "anthropic/claude-3.7-sonnet:thinking",
            name: "Anthropic: Claude 3.7 Sonnet (thinking)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "anthropic/claude-haiku-4.5": {
            id: "anthropic/claude-haiku-4.5",
            name: "Anthropic: Claude Haiku 4.5",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.09999999999999999,
                cacheWrite: 1.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "anthropic/claude-opus-4": {
            id: "anthropic/claude-opus-4",
            name: "Anthropic: Claude Opus 4",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "anthropic/claude-opus-4.1": {
            id: "anthropic/claude-opus-4.1",
            name: "Anthropic: Claude Opus 4.1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "anthropic/claude-opus-4.5": {
            id: "anthropic/claude-opus-4.5",
            name: "Anthropic: Claude Opus 4.5",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "anthropic/claude-opus-4.6": {
            id: "anthropic/claude-opus-4.6",
            name: "Anthropic: Claude Opus 4.6",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 1000000,
            maxTokens: 128000,
        },
        "anthropic/claude-sonnet-4": {
            id: "anthropic/claude-sonnet-4",
            name: "Anthropic: Claude Sonnet 4",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 1000000,
            maxTokens: 64000,
        },
        "anthropic/claude-sonnet-4.5": {
            id: "anthropic/claude-sonnet-4.5",
            name: "Anthropic: Claude Sonnet 4.5",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 1000000,
            maxTokens: 64000,
        },
        "arcee-ai/trinity-large-preview:free": {
            id: "arcee-ai/trinity-large-preview:free",
            name: "Arcee AI: Trinity Large Preview (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131000,
            maxTokens: 4096,
        },
        "arcee-ai/trinity-mini": {
            id: "arcee-ai/trinity-mini",
            name: "Arcee AI: Trinity Mini",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.045,
                output: 0.15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "arcee-ai/trinity-mini:free": {
            id: "arcee-ai/trinity-mini:free",
            name: "Arcee AI: Trinity Mini (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "arcee-ai/virtuoso-large": {
            id: "arcee-ai/virtuoso-large",
            name: "Arcee AI: Virtuoso Large",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.75,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 64000,
        },
        "baidu/ernie-4.5-21b-a3b": {
            id: "baidu/ernie-4.5-21b-a3b",
            name: "Baidu: ERNIE 4.5 21B A3B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.07,
                output: 0.28,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 120000,
            maxTokens: 8000,
        },
        "baidu/ernie-4.5-vl-28b-a3b": {
            id: "baidu/ernie-4.5-vl-28b-a3b",
            name: "Baidu: ERNIE 4.5 VL 28B A3B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.14,
                output: 0.56,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 30000,
            maxTokens: 8000,
        },
        "bytedance-seed/seed-1.6": {
            id: "bytedance-seed/seed-1.6",
            name: "ByteDance Seed: Seed 1.6",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 32768,
        },
        "bytedance-seed/seed-1.6-flash": {
            id: "bytedance-seed/seed-1.6-flash",
            name: "ByteDance Seed: Seed 1.6 Flash",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.075,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 32768,
        },
        "cohere/command-r-08-2024": {
            id: "cohere/command-r-08-2024",
            name: "Cohere: Command R (08-2024)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4000,
        },
        "cohere/command-r-plus-08-2024": {
            id: "cohere/command-r-plus-08-2024",
            name: "Cohere: Command R+ (08-2024)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4000,
        },
        "deepseek/deepseek-chat": {
            id: "deepseek/deepseek-chat",
            name: "DeepSeek: DeepSeek V3",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 163840,
        },
        "deepseek/deepseek-chat-v3-0324": {
            id: "deepseek/deepseek-chat-v3-0324",
            name: "DeepSeek: DeepSeek V3 0324",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.19,
                output: 0.87,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 65536,
        },
        "deepseek/deepseek-chat-v3.1": {
            id: "deepseek/deepseek-chat-v3.1",
            name: "DeepSeek: DeepSeek V3.1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.75,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 7168,
        },
        "deepseek/deepseek-r1": {
            id: "deepseek/deepseek-r1",
            name: "DeepSeek: R1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.7,
                output: 2.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 64000,
            maxTokens: 16000,
        },
        "deepseek/deepseek-r1-0528": {
            id: "deepseek/deepseek-r1-0528",
            name: "DeepSeek: R1 0528",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 1.75,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 65536,
        },
        "deepseek/deepseek-v3.1-terminus": {
            id: "deepseek/deepseek-v3.1-terminus",
            name: "DeepSeek: DeepSeek V3.1 Terminus",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.21,
                output: 0.7899999999999999,
                cacheRead: 0.1300000002,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 4096,
        },
        "deepseek/deepseek-v3.1-terminus:exacto": {
            id: "deepseek/deepseek-v3.1-terminus:exacto",
            name: "DeepSeek: DeepSeek V3.1 Terminus (exacto)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.21,
                output: 0.7899999999999999,
                cacheRead: 0.16799999999999998,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 4096,
        },
        "deepseek/deepseek-v3.2": {
            id: "deepseek/deepseek-v3.2",
            name: "DeepSeek: DeepSeek V3.2",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 0.38,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 65536,
        },
        "deepseek/deepseek-v3.2-exp": {
            id: "deepseek/deepseek-v3.2-exp",
            name: "DeepSeek: DeepSeek V3.2 Exp",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.27,
                output: 0.41,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 65536,
        },
        "google/gemini-2.0-flash-001": {
            id: "google/gemini-2.0-flash-001",
            name: "Google: Gemini 2.0 Flash",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.09999999999999999,
                output: 0.39999999999999997,
                cacheRead: 0.024999999999999998,
                cacheWrite: 0.08333333333333334,
            },
            contextWindow: 1048576,
            maxTokens: 8192,
        },
        "google/gemini-2.0-flash-lite-001": {
            id: "google/gemini-2.0-flash-lite-001",
            name: "Google: Gemini 2.0 Flash Lite",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.075,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 8192,
        },
        "google/gemini-2.5-flash": {
            id: "google/gemini-2.5-flash",
            name: "Google: Gemini 2.5 Flash",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 2.5,
                cacheRead: 0.03,
                cacheWrite: 0.08333333333333334,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "google/gemini-2.5-flash-lite": {
            id: "google/gemini-2.5-flash-lite",
            name: "Google: Gemini 2.5 Flash Lite",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.09999999999999999,
                output: 0.39999999999999997,
                cacheRead: 0.01,
                cacheWrite: 0.08333333333333334,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "google/gemini-2.5-flash-lite-preview-09-2025": {
            id: "google/gemini-2.5-flash-lite-preview-09-2025",
            name: "Google: Gemini 2.5 Flash Lite Preview 09-2025",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.09999999999999999,
                output: 0.39999999999999997,
                cacheRead: 0.01,
                cacheWrite: 0.08333333333333334,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "google/gemini-2.5-flash-preview-09-2025": {
            id: "google/gemini-2.5-flash-preview-09-2025",
            name: "Google: Gemini 2.5 Flash Preview 09-2025",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 2.5,
                cacheRead: 0.03,
                cacheWrite: 0.08333333333333334,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "google/gemini-2.5-pro": {
            id: "google/gemini-2.5-pro",
            name: "Google: Gemini 2.5 Pro",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0.375,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "google/gemini-2.5-pro-preview": {
            id: "google/gemini-2.5-pro-preview",
            name: "Google: Gemini 2.5 Pro Preview 06-05",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0.375,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "google/gemini-2.5-pro-preview-05-06": {
            id: "google/gemini-2.5-pro-preview-05-06",
            name: "Google: Gemini 2.5 Pro Preview 05-06",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0.375,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "google/gemini-3-flash-preview": {
            id: "google/gemini-3-flash-preview",
            name: "Google: Gemini 3 Flash Preview",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 3,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0.08333333333333334,
            },
            contextWindow: 1048576,
            maxTokens: 65535,
        },
        "google/gemini-3-pro-preview": {
            id: "google/gemini-3-pro-preview",
            name: "Google: Gemini 3 Pro Preview",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 12,
                cacheRead: 0.19999999999999998,
                cacheWrite: 0.375,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "google/gemma-3-27b-it": {
            id: "google/gemma-3-27b-it",
            name: "Google: Gemma 3 27B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.04,
                output: 0.15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 65536,
        },
        "google/gemma-3-27b-it:free": {
            id: "google/gemma-3-27b-it:free",
            name: "Google: Gemma 3 27B (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "inception/mercury": {
            id: "inception/mercury",
            name: "Inception: Mercury",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "inception/mercury-coder": {
            id: "inception/mercury-coder",
            name: "Inception: Mercury Coder",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "kwaipilot/kat-coder-pro": {
            id: "kwaipilot/kat-coder-pro",
            name: "Kwaipilot: KAT-Coder-Pro V1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.207,
                output: 0.828,
                cacheRead: 0.0414,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 128000,
        },
        "meta-llama/llama-3-8b-instruct": {
            id: "meta-llama/llama-3-8b-instruct",
            name: "Meta: Llama 3 8B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.03,
                output: 0.04,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 16384,
        },
        "meta-llama/llama-3.1-405b-instruct": {
            id: "meta-llama/llama-3.1-405b-instruct",
            name: "Meta: Llama 3.1 405B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 4,
                output: 4,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131000,
            maxTokens: 4096,
        },
        "meta-llama/llama-3.1-70b-instruct": {
            id: "meta-llama/llama-3.1-70b-instruct",
            name: "Meta: Llama 3.1 70B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 0.39999999999999997,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "meta-llama/llama-3.1-8b-instruct": {
            id: "meta-llama/llama-3.1-8b-instruct",
            name: "Meta: Llama 3.1 8B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.02,
                output: 0.049999999999999996,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 16384,
            maxTokens: 16384,
        },
        "meta-llama/llama-3.3-70b-instruct": {
            id: "meta-llama/llama-3.3-70b-instruct",
            name: "Meta: Llama 3.3 70B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.32,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
        "meta-llama/llama-3.3-70b-instruct:free": {
            id: "meta-llama/llama-3.3-70b-instruct:free",
            name: "Meta: Llama 3.3 70B Instruct (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "meta-llama/llama-4-maverick": {
            id: "meta-llama/llama-4-maverick",
            name: "Meta: Llama 4 Maverick",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 16384,
        },
        "meta-llama/llama-4-scout": {
            id: "meta-llama/llama-4-scout",
            name: "Meta: Llama 4 Scout",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.08,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 327680,
            maxTokens: 16384,
        },
        "minimax/minimax-m1": {
            id: "minimax/minimax-m1",
            name: "MiniMax: MiniMax M1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 2.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 40000,
        },
        "minimax/minimax-m2": {
            id: "minimax/minimax-m2",
            name: "MiniMax: MiniMax M2",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.255,
                output: 1,
                cacheRead: 0.03,
                cacheWrite: 0,
            },
            contextWindow: 196608,
            maxTokens: 65536,
        },
        "minimax/minimax-m2.1": {
            id: "minimax/minimax-m2.1",
            name: "MiniMax: MiniMax M2.1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.27,
                output: 0.95,
                cacheRead: 0.0299999997,
                cacheWrite: 0,
            },
            contextWindow: 196608,
            maxTokens: 4096,
        },
        "mistralai/codestral-2508": {
            id: "mistralai/codestral-2508",
            name: "Mistral: Codestral 2508",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 0.8999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 4096,
        },
        "mistralai/devstral-2512": {
            id: "mistralai/devstral-2512",
            name: "Mistral: Devstral 2 2512",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.049999999999999996,
                output: 0.22,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 65536,
        },
        "mistralai/devstral-medium": {
            id: "mistralai/devstral-medium",
            name: "Mistral: Devstral Medium",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "mistralai/devstral-small": {
            id: "mistralai/devstral-small",
            name: "Mistral: Devstral Small 1.1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "mistralai/ministral-14b-2512": {
            id: "mistralai/ministral-14b-2512",
            name: "Mistral: Ministral 3 14B 2512",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.19999999999999998,
                output: 0.19999999999999998,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "mistralai/ministral-3b": {
            id: "mistralai/ministral-3b",
            name: "Mistral: Ministral 3B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.04,
                output: 0.04,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "mistralai/ministral-3b-2512": {
            id: "mistralai/ministral-3b-2512",
            name: "Mistral: Ministral 3 3B 2512",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.09999999999999999,
                output: 0.09999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "mistralai/ministral-8b": {
            id: "mistralai/ministral-8b",
            name: "Mistral: Ministral 8B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.09999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "mistralai/ministral-8b-2512": {
            id: "mistralai/ministral-8b-2512",
            name: "Mistral: Ministral 3 8B 2512",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "mistralai/mistral-large": {
            id: "mistralai/mistral-large",
            name: "Mistral Large",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "mistralai/mistral-large-2407": {
            id: "mistralai/mistral-large-2407",
            name: "Mistral Large 2407",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "mistralai/mistral-large-2411": {
            id: "mistralai/mistral-large-2411",
            name: "Mistral Large 2411",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "mistralai/mistral-large-2512": {
            id: "mistralai/mistral-large-2512",
            name: "Mistral: Mistral Large 3 2512",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "mistralai/mistral-medium-3": {
            id: "mistralai/mistral-medium-3",
            name: "Mistral: Mistral Medium 3",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.39999999999999997,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "mistralai/mistral-medium-3.1": {
            id: "mistralai/mistral-medium-3.1",
            name: "Mistral: Mistral Medium 3.1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.39999999999999997,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "mistralai/mistral-nemo": {
            id: "mistralai/mistral-nemo",
            name: "Mistral: Mistral Nemo",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.02,
                output: 0.04,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
        "mistralai/mistral-saba": {
            id: "mistralai/mistral-saba",
            name: "Mistral: Saba",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 4096,
        },
        "mistralai/mistral-small-24b-instruct-2501": {
            id: "mistralai/mistral-small-24b-instruct-2501",
            name: "Mistral: Mistral Small 3",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.03,
                output: 0.11,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 32768,
        },
        "mistralai/mistral-small-3.1-24b-instruct": {
            id: "mistralai/mistral-small-3.1-24b-instruct",
            name: "Mistral: Mistral Small 3.1 24B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.03,
                output: 0.11,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "mistralai/mistral-small-3.1-24b-instruct:free": {
            id: "mistralai/mistral-small-3.1-24b-instruct:free",
            name: "Mistral: Mistral Small 3.1 24B (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "mistralai/mistral-small-3.2-24b-instruct": {
            id: "mistralai/mistral-small-3.2-24b-instruct",
            name: "Mistral: Mistral Small 3.2 24B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.06,
                output: 0.18,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "mistralai/mistral-small-creative": {
            id: "mistralai/mistral-small-creative",
            name: "Mistral: Mistral Small Creative",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 4096,
        },
        "mistralai/mistral-tiny": {
            id: "mistralai/mistral-tiny",
            name: "Mistral Tiny",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 0.25,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 4096,
        },
        "mistralai/mixtral-8x22b-instruct": {
            id: "mistralai/mixtral-8x22b-instruct",
            name: "Mistral: Mixtral 8x22B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 65536,
            maxTokens: 4096,
        },
        "mistralai/mixtral-8x7b-instruct": {
            id: "mistralai/mixtral-8x7b-instruct",
            name: "Mistral: Mixtral 8x7B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.54,
                output: 0.54,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 16384,
        },
        "mistralai/pixtral-12b": {
            id: "mistralai/pixtral-12b",
            name: "Mistral: Pixtral 12B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.09999999999999999,
                output: 0.09999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 4096,
        },
        "mistralai/pixtral-large-2411": {
            id: "mistralai/pixtral-large-2411",
            name: "Mistral: Pixtral Large 2411",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "mistralai/voxtral-small-24b-2507": {
            id: "mistralai/voxtral-small-24b-2507",
            name: "Mistral: Voxtral Small 24B 2507",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32000,
            maxTokens: 4096,
        },
        "moonshotai/kimi-k2": {
            id: "moonshotai/kimi-k2",
            name: "MoonshotAI: Kimi K2 0711",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.5,
                output: 2.4,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "moonshotai/kimi-k2-0905": {
            id: "moonshotai/kimi-k2-0905",
            name: "MoonshotAI: Kimi K2 0905",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.39,
                output: 1.9,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "moonshotai/kimi-k2-0905:exacto": {
            id: "moonshotai/kimi-k2-0905:exacto",
            name: "MoonshotAI: Kimi K2 0905 (exacto)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 2.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "moonshotai/kimi-k2-thinking": {
            id: "moonshotai/kimi-k2-thinking",
            name: "MoonshotAI: Kimi K2 Thinking",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 1.75,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 65535,
        },
        "moonshotai/kimi-k2.5": {
            id: "moonshotai/kimi-k2.5",
            name: "MoonshotAI: Kimi K2.5",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.44999999999999996,
                output: 2.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 65535,
        },
        "nex-agi/deepseek-v3.1-nex-n1": {
            id: "nex-agi/deepseek-v3.1-nex-n1",
            name: "Nex AGI: DeepSeek V3.1 Nex N1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.27,
                output: 1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 163840,
        },
        "nousresearch/deephermes-3-mistral-24b-preview": {
            id: "nousresearch/deephermes-3-mistral-24b-preview",
            name: "Nous: DeepHermes 3 Mistral 24B Preview",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.02,
                output: 0.09999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 32768,
        },
        "nousresearch/hermes-4-70b": {
            id: "nousresearch/hermes-4-70b",
            name: "Nous: Hermes 4 70B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.11,
                output: 0.38,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "nvidia/llama-3.1-nemotron-70b-instruct": {
            id: "nvidia/llama-3.1-nemotron-70b-instruct",
            name: "NVIDIA: Llama 3.1 Nemotron 70B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1.2,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
        "nvidia/llama-3.3-nemotron-super-49b-v1.5": {
            id: "nvidia/llama-3.3-nemotron-super-49b-v1.5",
            name: "NVIDIA: Llama 3.3 Nemotron Super 49B V1.5",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.39999999999999997,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "nvidia/nemotron-3-nano-30b-a3b": {
            id: "nvidia/nemotron-3-nano-30b-a3b",
            name: "NVIDIA: Nemotron 3 Nano 30B A3B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.049999999999999996,
                output: 0.19999999999999998,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "nvidia/nemotron-3-nano-30b-a3b:free": {
            id: "nvidia/nemotron-3-nano-30b-a3b:free",
            name: "NVIDIA: Nemotron 3 Nano 30B A3B (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 4096,
        },
        "nvidia/nemotron-nano-12b-v2-vl:free": {
            id: "nvidia/nemotron-nano-12b-v2-vl:free",
            name: "NVIDIA: Nemotron Nano 12B 2 VL (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 128000,
        },
        "nvidia/nemotron-nano-9b-v2": {
            id: "nvidia/nemotron-nano-9b-v2",
            name: "NVIDIA: Nemotron Nano 9B V2",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.04,
                output: 0.16,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "nvidia/nemotron-nano-9b-v2:free": {
            id: "nvidia/nemotron-nano-9b-v2:free",
            name: "NVIDIA: Nemotron Nano 9B V2 (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "openai/gpt-3.5-turbo": {
            id: "openai/gpt-3.5-turbo",
            name: "OpenAI: GPT-3.5 Turbo",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.5,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 16385,
            maxTokens: 4096,
        },
        "openai/gpt-3.5-turbo-0613": {
            id: "openai/gpt-3.5-turbo-0613",
            name: "OpenAI: GPT-3.5 Turbo (older v0613)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 4095,
            maxTokens: 4096,
        },
        "openai/gpt-3.5-turbo-16k": {
            id: "openai/gpt-3.5-turbo-16k",
            name: "OpenAI: GPT-3.5 Turbo 16k",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 3,
                output: 4,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 16385,
            maxTokens: 4096,
        },
        "openai/gpt-4": {
            id: "openai/gpt-4",
            name: "OpenAI: GPT-4",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 30,
                output: 60,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 8191,
            maxTokens: 4096,
        },
        "openai/gpt-4-0314": {
            id: "openai/gpt-4-0314",
            name: "OpenAI: GPT-4 (older v0314)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 30,
                output: 60,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 8191,
            maxTokens: 4096,
        },
        "openai/gpt-4-1106-preview": {
            id: "openai/gpt-4-1106-preview",
            name: "OpenAI: GPT-4 Turbo (older v1106)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 10,
                output: 30,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "openai/gpt-4-turbo": {
            id: "openai/gpt-4-turbo",
            name: "OpenAI: GPT-4 Turbo",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 10,
                output: 30,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "openai/gpt-4-turbo-preview": {
            id: "openai/gpt-4-turbo-preview",
            name: "OpenAI: GPT-4 Turbo Preview",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 10,
                output: 30,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "openai/gpt-4.1": {
            id: "openai/gpt-4.1",
            name: "OpenAI: GPT-4.1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "openai/gpt-4.1-mini": {
            id: "openai/gpt-4.1-mini",
            name: "OpenAI: GPT-4.1 Mini",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.39999999999999997,
                output: 1.5999999999999999,
                cacheRead: 0.09999999999999999,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "openai/gpt-4.1-nano": {
            id: "openai/gpt-4.1-nano",
            name: "OpenAI: GPT-4.1 Nano",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.09999999999999999,
                output: 0.39999999999999997,
                cacheRead: 0.024999999999999998,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "openai/gpt-4o": {
            id: "openai/gpt-4o",
            name: "OpenAI: GPT-4o",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-4o-2024-05-13": {
            id: "openai/gpt-4o-2024-05-13",
            name: "OpenAI: GPT-4o (2024-05-13)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "openai/gpt-4o-2024-08-06": {
            id: "openai/gpt-4o-2024-08-06",
            name: "OpenAI: GPT-4o (2024-08-06)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-4o-2024-11-20": {
            id: "openai/gpt-4o-2024-11-20",
            name: "OpenAI: GPT-4o (2024-11-20)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-4o-audio-preview": {
            id: "openai/gpt-4o-audio-preview",
            name: "OpenAI: GPT-4o Audio",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-4o-mini": {
            id: "openai/gpt-4o-mini",
            name: "OpenAI: GPT-4o-mini",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-4o-mini-2024-07-18": {
            id: "openai/gpt-4o-mini-2024-07-18",
            name: "OpenAI: GPT-4o-mini (2024-07-18)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-4o:extended": {
            id: "openai/gpt-4o:extended",
            name: "OpenAI: GPT-4o (extended)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 6,
                output: 18,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
        "openai/gpt-5": {
            id: "openai/gpt-5",
            name: "OpenAI: GPT-5",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5-codex": {
            id: "openai/gpt-5-codex",
            name: "OpenAI: GPT-5 Codex",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5-image": {
            id: "openai/gpt-5-image",
            name: "OpenAI: GPT-5 Image",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 10,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5-image-mini": {
            id: "openai/gpt-5-image-mini",
            name: "OpenAI: GPT-5 Image Mini",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 2,
                cacheRead: 0.25,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5-mini": {
            id: "openai/gpt-5-mini",
            name: "OpenAI: GPT-5 Mini",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.024999999999999998,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5-nano": {
            id: "openai/gpt-5-nano",
            name: "OpenAI: GPT-5 Nano",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.049999999999999996,
                output: 0.39999999999999997,
                cacheRead: 0.005,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5-pro": {
            id: "openai/gpt-5-pro",
            name: "OpenAI: GPT-5 Pro",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 120,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.1": {
            id: "openai/gpt-5.1",
            name: "OpenAI: GPT-5.1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.1-chat": {
            id: "openai/gpt-5.1-chat",
            name: "OpenAI: GPT-5.1 Chat",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-5.1-codex": {
            id: "openai/gpt-5.1-codex",
            name: "OpenAI: GPT-5.1-Codex",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.1-codex-max": {
            id: "openai/gpt-5.1-codex-max",
            name: "OpenAI: GPT-5.1-Codex-Max",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.1-codex-mini": {
            id: "openai/gpt-5.1-codex-mini",
            name: "OpenAI: GPT-5.1-Codex-Mini",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.024999999999999998,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 100000,
        },
        "openai/gpt-5.2": {
            id: "openai/gpt-5.2",
            name: "OpenAI: GPT-5.2",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.2-chat": {
            id: "openai/gpt-5.2-chat",
            name: "OpenAI: GPT-5.2 Chat",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-5.2-codex": {
            id: "openai/gpt-5.2-codex",
            name: "OpenAI: GPT-5.2-Codex",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.2-pro": {
            id: "openai/gpt-5.2-pro",
            name: "OpenAI: GPT-5.2 Pro",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 21,
                output: 168,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-oss-120b": {
            id: "openai/gpt-oss-120b",
            name: "OpenAI: gpt-oss-120b",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.039,
                output: 0.19,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "openai/gpt-oss-120b:exacto": {
            id: "openai/gpt-oss-120b:exacto",
            name: "OpenAI: gpt-oss-120b (exacto)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.039,
                output: 0.19,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "openai/gpt-oss-120b:free": {
            id: "openai/gpt-oss-120b:free",
            name: "OpenAI: gpt-oss-120b (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "openai/gpt-oss-20b": {
            id: "openai/gpt-oss-20b",
            name: "OpenAI: gpt-oss-20b",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.02,
                output: 0.09999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "openai/gpt-oss-20b:free": {
            id: "openai/gpt-oss-20b:free",
            name: "OpenAI: gpt-oss-20b (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "openai/gpt-oss-safeguard-20b": {
            id: "openai/gpt-oss-safeguard-20b",
            name: "OpenAI: gpt-oss-safeguard-20b",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.075,
                output: 0.3,
                cacheRead: 0.037,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 65536,
        },
        "openai/o1": {
            id: "openai/o1",
            name: "OpenAI: o1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 60,
                cacheRead: 7.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o3": {
            id: "openai/o3",
            name: "OpenAI: o3",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o3-deep-research": {
            id: "openai/o3-deep-research",
            name: "OpenAI: o3 Deep Research",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 10,
                output: 40,
                cacheRead: 2.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o3-mini": {
            id: "openai/o3-mini",
            name: "OpenAI: o3 Mini",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1.1,
                output: 4.4,
                cacheRead: 0.55,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o3-mini-high": {
            id: "openai/o3-mini-high",
            name: "OpenAI: o3 Mini High",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1.1,
                output: 4.4,
                cacheRead: 0.55,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o3-pro": {
            id: "openai/o3-pro",
            name: "OpenAI: o3 Pro",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 20,
                output: 80,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o4-mini": {
            id: "openai/o4-mini",
            name: "OpenAI: o4 Mini",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.1,
                output: 4.4,
                cacheRead: 0.275,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o4-mini-deep-research": {
            id: "openai/o4-mini-deep-research",
            name: "OpenAI: o4 Mini Deep Research",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o4-mini-high": {
            id: "openai/o4-mini-high",
            name: "OpenAI: o4 Mini High",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.1,
                output: 4.4,
                cacheRead: 0.275,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openrouter/auto": {
            id: "openrouter/auto",
            name: "Auto Router",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: -1000000,
                output: -1000000,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 4096,
        },
        "openrouter/free": {
            id: "openrouter/free",
            name: "Free Models Router",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 4096,
        },
        "openrouter/pony-alpha": {
            id: "openrouter/pony-alpha",
            name: "Pony Alpha",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 131000,
        },
        "prime-intellect/intellect-3": {
            id: "prime-intellect/intellect-3",
            name: "Prime Intellect: INTELLECT-3",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 1.1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "qwen/qwen-2.5-72b-instruct": {
            id: "qwen/qwen-2.5-72b-instruct",
            name: "Qwen2.5 72B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.12,
                output: 0.39,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 16384,
        },
        "qwen/qwen-2.5-7b-instruct": {
            id: "qwen/qwen-2.5-7b-instruct",
            name: "Qwen: Qwen2.5 7B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.04,
                output: 0.09999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 4096,
        },
        "qwen/qwen-max": {
            id: "qwen/qwen-max",
            name: "Qwen: Qwen-Max ",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1.5999999999999999,
                output: 6.3999999999999995,
                cacheRead: 0.64,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 8192,
        },
        "qwen/qwen-plus": {
            id: "qwen/qwen-plus",
            name: "Qwen: Qwen-Plus",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 1.2,
                cacheRead: 0.16,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "qwen/qwen-plus-2025-07-28": {
            id: "qwen/qwen-plus-2025-07-28",
            name: "Qwen: Qwen Plus 0728",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 32768,
        },
        "qwen/qwen-plus-2025-07-28:thinking": {
            id: "qwen/qwen-plus-2025-07-28:thinking",
            name: "Qwen: Qwen Plus 0728 (thinking)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 4,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 32768,
        },
        "qwen/qwen-turbo": {
            id: "qwen/qwen-turbo",
            name: "Qwen: Qwen-Turbo",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.049999999999999996,
                output: 0.19999999999999998,
                cacheRead: 0.02,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 8192,
        },
        "qwen/qwen-vl-max": {
            id: "qwen/qwen-vl-max",
            name: "Qwen: Qwen VL Max",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.7999999999999999,
                output: 3.1999999999999997,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "qwen/qwen3-14b": {
            id: "qwen/qwen3-14b",
            name: "Qwen: Qwen3 14B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.049999999999999996,
                output: 0.22,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 40960,
            maxTokens: 40960,
        },
        "qwen/qwen3-235b-a22b": {
            id: "qwen/qwen3-235b-a22b",
            name: "Qwen: Qwen3 235B A22B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 40960,
            maxTokens: 4096,
        },
        "qwen/qwen3-235b-a22b-2507": {
            id: "qwen/qwen3-235b-a22b-2507",
            name: "Qwen: Qwen3 235B A22B Instruct 2507",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.071,
                output: 0.09999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "qwen/qwen3-235b-a22b-thinking-2507": {
            id: "qwen/qwen3-235b-a22b-thinking-2507",
            name: "Qwen: Qwen3 235B A22B Thinking 2507",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.11,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "qwen/qwen3-30b-a3b": {
            id: "qwen/qwen3-30b-a3b",
            name: "Qwen: Qwen3 30B A3B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.06,
                output: 0.22,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 40960,
            maxTokens: 40960,
        },
        "qwen/qwen3-30b-a3b-instruct-2507": {
            id: "qwen/qwen3-30b-a3b-instruct-2507",
            name: "Qwen: Qwen3 30B A3B Instruct 2507",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.08,
                output: 0.33,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "qwen/qwen3-30b-a3b-thinking-2507": {
            id: "qwen/qwen3-30b-a3b-thinking-2507",
            name: "Qwen: Qwen3 30B A3B Thinking 2507",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.051,
                output: 0.33999999999999997,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 4096,
        },
        "qwen/qwen3-32b": {
            id: "qwen/qwen3-32b",
            name: "Qwen: Qwen3 32B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.08,
                output: 0.24,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 40960,
            maxTokens: 40960,
        },
        "qwen/qwen3-4b:free": {
            id: "qwen/qwen3-4b:free",
            name: "Qwen: Qwen3 4B (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 40960,
            maxTokens: 4096,
        },
        "qwen/qwen3-8b": {
            id: "qwen/qwen3-8b",
            name: "Qwen: Qwen3 8B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.049999999999999996,
                output: 0.39999999999999997,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0,
            },
            contextWindow: 32000,
            maxTokens: 8192,
        },
        "qwen/qwen3-coder": {
            id: "qwen/qwen3-coder",
            name: "Qwen: Qwen3 Coder 480B A35B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.22,
                output: 0.95,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "qwen/qwen3-coder-30b-a3b-instruct": {
            id: "qwen/qwen3-coder-30b-a3b-instruct",
            name: "Qwen: Qwen3 Coder 30B A3B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.07,
                output: 0.27,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 160000,
            maxTokens: 32768,
        },
        "qwen/qwen3-coder-flash": {
            id: "qwen/qwen3-coder-flash",
            name: "Qwen: Qwen3 Coder Flash",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1.5,
                cacheRead: 0.08,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 65536,
        },
        "qwen/qwen3-coder-next": {
            id: "qwen/qwen3-coder-next",
            name: "Qwen: Qwen3 Coder Next",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.07,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 65536,
        },
        "qwen/qwen3-coder-plus": {
            id: "qwen/qwen3-coder-plus",
            name: "Qwen: Qwen3 Coder Plus",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.09999999999999999,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 65536,
        },
        "qwen/qwen3-coder:exacto": {
            id: "qwen/qwen3-coder:exacto",
            name: "Qwen: Qwen3 Coder 480B A35B (exacto)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.22,
                output: 1.7999999999999998,
                cacheRead: 0.022,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 65536,
        },
        "qwen/qwen3-coder:free": {
            id: "qwen/qwen3-coder:free",
            name: "Qwen: Qwen3 Coder 480B A35B (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262000,
            maxTokens: 262000,
        },
        "qwen/qwen3-max": {
            id: "qwen/qwen3-max",
            name: "Qwen: Qwen3 Max",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1.2,
                output: 6,
                cacheRead: 0.24,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 32768,
        },
        "qwen/qwen3-next-80b-a3b-instruct": {
            id: "qwen/qwen3-next-80b-a3b-instruct",
            name: "Qwen: Qwen3 Next 80B A3B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.09,
                output: 1.1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "qwen/qwen3-next-80b-a3b-instruct:free": {
            id: "qwen/qwen3-next-80b-a3b-instruct:free",
            name: "Qwen: Qwen3 Next 80B A3B Instruct (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "qwen/qwen3-next-80b-a3b-thinking": {
            id: "qwen/qwen3-next-80b-a3b-thinking",
            name: "Qwen: Qwen3 Next 80B A3B Thinking",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "qwen/qwen3-vl-235b-a22b-instruct": {
            id: "qwen/qwen3-vl-235b-a22b-instruct",
            name: "Qwen: Qwen3 VL 235B A22B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.19999999999999998,
                output: 0.88,
                cacheRead: 0.11,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "qwen/qwen3-vl-235b-a22b-thinking": {
            id: "qwen/qwen3-vl-235b-a22b-thinking",
            name: "Qwen: Qwen3 VL 235B A22B Thinking",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.44999999999999996,
                output: 3.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 262144,
        },
        "qwen/qwen3-vl-30b-a3b-instruct": {
            id: "qwen/qwen3-vl-30b-a3b-instruct",
            name: "Qwen: Qwen3 VL 30B A3B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "qwen/qwen3-vl-30b-a3b-thinking": {
            id: "qwen/qwen3-vl-30b-a3b-thinking",
            name: "Qwen: Qwen3 VL 30B A3B Thinking",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.19999999999999998,
                output: 1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 32768,
        },
        "qwen/qwen3-vl-8b-instruct": {
            id: "qwen/qwen3-vl-8b-instruct",
            name: "Qwen: Qwen3 VL 8B Instruct",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.08,
                output: 0.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 32768,
        },
        "qwen/qwen3-vl-8b-thinking": {
            id: "qwen/qwen3-vl-8b-thinking",
            name: "Qwen: Qwen3 VL 8B Thinking",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.18,
                output: 2.0999999999999996,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 32768,
        },
        "qwen/qwq-32b": {
            id: "qwen/qwq-32b",
            name: "Qwen: QwQ 32B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 0.39999999999999997,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 32768,
        },
        "relace/relace-search": {
            id: "relace/relace-search",
            name: "Relace: Relace Search",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1,
                output: 3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 128000,
        },
        "sao10k/l3-euryale-70b": {
            id: "sao10k/l3-euryale-70b",
            name: "Sao10k: Llama 3 Euryale 70B v2.1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1.48,
                output: 1.48,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 8192,
        },
        "sao10k/l3.1-euryale-70b": {
            id: "sao10k/l3.1-euryale-70b",
            name: "Sao10K: Llama 3.1 Euryale 70B v2.2",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.65,
                output: 0.75,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 32768,
        },
        "stepfun-ai/step3": {
            id: "stepfun-ai/step3",
            name: "StepFun: Step3",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.5700000000000001,
                output: 1.42,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 65536,
            maxTokens: 65536,
        },
        "stepfun/step-3.5-flash:free": {
            id: "stepfun/step-3.5-flash:free",
            name: "StepFun: Step 3.5 Flash (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 256000,
        },
        "thedrummer/rocinante-12b": {
            id: "thedrummer/rocinante-12b",
            name: "TheDrummer: Rocinante 12B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.16999999999999998,
                output: 0.43,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 32768,
        },
        "thedrummer/unslopnemo-12b": {
            id: "thedrummer/unslopnemo-12b",
            name: "TheDrummer: UnslopNemo 12B",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 0.39999999999999997,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 32768,
        },
        "tngtech/deepseek-r1t2-chimera": {
            id: "tngtech/deepseek-r1t2-chimera",
            name: "TNG: DeepSeek R1T2 Chimera",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 0.85,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 163840,
        },
        "tngtech/tng-r1t-chimera": {
            id: "tngtech/tng-r1t-chimera",
            name: "TNG: R1T Chimera",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 0.85,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 65536,
        },
        "tngtech/tng-r1t-chimera:free": {
            id: "tngtech/tng-r1t-chimera:free",
            name: "TNG: R1T Chimera (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 65536,
        },
        "upstage/solar-pro-3:free": {
            id: "upstage/solar-pro-3:free",
            name: "Upstage: Solar Pro 3 (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "x-ai/grok-3": {
            id: "x-ai/grok-3",
            name: "xAI: Grok 3",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.75,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "x-ai/grok-3-beta": {
            id: "x-ai/grok-3-beta",
            name: "xAI: Grok 3 Beta",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.75,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "x-ai/grok-3-mini": {
            id: "x-ai/grok-3-mini",
            name: "xAI: Grok 3 Mini",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 0.5,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "x-ai/grok-3-mini-beta": {
            id: "x-ai/grok-3-mini-beta",
            name: "xAI: Grok 3 Mini Beta",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 0.5,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "x-ai/grok-4": {
            id: "x-ai/grok-4",
            name: "xAI: Grok 4",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.75,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 4096,
        },
        "x-ai/grok-4-fast": {
            id: "x-ai/grok-4-fast",
            name: "xAI: Grok 4 Fast",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.19999999999999998,
                output: 0.5,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 30000,
        },
        "x-ai/grok-4.1-fast": {
            id: "x-ai/grok-4.1-fast",
            name: "xAI: Grok 4.1 Fast",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.19999999999999998,
                output: 0.5,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 30000,
        },
        "x-ai/grok-code-fast-1": {
            id: "x-ai/grok-code-fast-1",
            name: "xAI: Grok Code Fast 1",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 1.5,
                cacheRead: 0.02,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 10000,
        },
        "xiaomi/mimo-v2-flash": {
            id: "xiaomi/mimo-v2-flash",
            name: "Xiaomi: MiMo-V2-Flash",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.09,
                output: 0.29,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 4096,
        },
        "z-ai/glm-4-32b": {
            id: "z-ai/glm-4-32b",
            name: "Z.AI: GLM 4 32B ",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.09999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "z-ai/glm-4.5": {
            id: "z-ai/glm-4.5",
            name: "Z.AI: GLM 4.5",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.35,
                output: 1.55,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 65536,
        },
        "z-ai/glm-4.5-air": {
            id: "z-ai/glm-4.5-air",
            name: "Z.AI: GLM 4.5 Air",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.049999999999999996,
                output: 0.22,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "z-ai/glm-4.5-air:free": {
            id: "z-ai/glm-4.5-air:free",
            name: "Z.AI: GLM 4.5 Air (free)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 96000,
        },
        "z-ai/glm-4.5v": {
            id: "z-ai/glm-4.5v",
            name: "Z.AI: GLM 4.5V",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.6,
                output: 1.7999999999999998,
                cacheRead: 0.11,
                cacheWrite: 0,
            },
            contextWindow: 65536,
            maxTokens: 16384,
        },
        "z-ai/glm-4.6": {
            id: "z-ai/glm-4.6",
            name: "Z.AI: GLM 4.6",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.35,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 202752,
            maxTokens: 65536,
        },
        "z-ai/glm-4.6:exacto": {
            id: "z-ai/glm-4.6:exacto",
            name: "Z.AI: GLM 4.6 (exacto)",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.44,
                output: 1.76,
                cacheRead: 0.11,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "z-ai/glm-4.6v": {
            id: "z-ai/glm-4.6v",
            name: "Z.AI: GLM 4.6V",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 0.8999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "z-ai/glm-4.7": {
            id: "z-ai/glm-4.7",
            name: "Z.AI: GLM 4.7",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 202752,
            maxTokens: 65535,
        },
        "z-ai/glm-4.7-flash": {
            id: "z-ai/glm-4.7-flash",
            name: "Z.AI: GLM 4.7 Flash",
            api: "openai-completions",
            provider: "openrouter",
            baseUrl: "https://openrouter.ai/api/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.06,
                output: 0.39999999999999997,
                cacheRead: 0.0100000002,
                cacheWrite: 0,
            },
            contextWindow: 202752,
            maxTokens: 4096,
        },
    },
    "vercel-ai-gateway": {
        "alibaba/qwen-3-14b": {
            id: "alibaba/qwen-3-14b",
            name: "Qwen3-14B",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.06,
                output: 0.24,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 40960,
            maxTokens: 16384,
        },
        "alibaba/qwen-3-235b": {
            id: "alibaba/qwen-3-235b",
            name: "Qwen3-235B-A22B",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.071,
                output: 0.463,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 40960,
            maxTokens: 16384,
        },
        "alibaba/qwen-3-30b": {
            id: "alibaba/qwen-3-30b",
            name: "Qwen3-30B-A3B",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.08,
                output: 0.29,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 40960,
            maxTokens: 16384,
        },
        "alibaba/qwen-3-32b": {
            id: "alibaba/qwen-3-32b",
            name: "Qwen 3 32B",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 40960,
            maxTokens: 16384,
        },
        "alibaba/qwen3-235b-a22b-thinking": {
            id: "alibaba/qwen3-235b-a22b-thinking",
            name: "Qwen3 235B A22B Thinking 2507",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 2.9000000000000004,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262114,
            maxTokens: 262114,
        },
        "alibaba/qwen3-coder": {
            id: "alibaba/qwen3-coder",
            name: "Qwen3 Coder 480B A35B Instruct",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.38,
                output: 1.53,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 66536,
        },
        "alibaba/qwen3-coder-30b-a3b": {
            id: "alibaba/qwen3-coder-30b-a3b",
            name: "Qwen 3 Coder 30B A3B Instruct",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.07,
                output: 0.27,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 160000,
            maxTokens: 32768,
        },
        "alibaba/qwen3-coder-next": {
            id: "alibaba/qwen3-coder-next",
            name: "Qwen3 Coder Next",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.5,
                output: 1.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 256000,
        },
        "alibaba/qwen3-coder-plus": {
            id: "alibaba/qwen3-coder-plus",
            name: "Qwen3 Coder Plus",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.19999999999999998,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 65536,
        },
        "alibaba/qwen3-max-preview": {
            id: "alibaba/qwen3-max-preview",
            name: "Qwen3 Max Preview",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 1.2,
                output: 6,
                cacheRead: 0.24,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 32768,
        },
        "alibaba/qwen3-max-thinking": {
            id: "alibaba/qwen3-max-thinking",
            name: "Qwen 3 Max Thinking",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 1.2,
                output: 6,
                cacheRead: 0.24,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 65536,
        },
        "alibaba/qwen3-vl-thinking": {
            id: "alibaba/qwen3-vl-thinking",
            name: "Qwen3 VL 235B A22B Thinking",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.22,
                output: 0.88,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 256000,
        },
        "anthropic/claude-3-haiku": {
            id: "anthropic/claude-3-haiku",
            name: "Claude 3 Haiku",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 1.25,
                cacheRead: 0.03,
                cacheWrite: 0.3,
            },
            contextWindow: 200000,
            maxTokens: 4096,
        },
        "anthropic/claude-3.5-haiku": {
            id: "anthropic/claude-3.5-haiku",
            name: "Claude 3.5 Haiku",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.7999999999999999,
                output: 4,
                cacheRead: 0.08,
                cacheWrite: 1,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "anthropic/claude-3.5-sonnet": {
            id: "anthropic/claude-3.5-sonnet",
            name: "Claude 3.5 Sonnet",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "anthropic/claude-3.5-sonnet-20240620": {
            id: "anthropic/claude-3.5-sonnet-20240620",
            name: "Claude 3.5 Sonnet (2024-06-20)",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 8192,
        },
        "anthropic/claude-3.7-sonnet": {
            id: "anthropic/claude-3.7-sonnet",
            name: "Claude 3.7 Sonnet",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "anthropic/claude-haiku-4.5": {
            id: "anthropic/claude-haiku-4.5",
            name: "Claude Haiku 4.5",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1,
                output: 5,
                cacheRead: 0.09999999999999999,
                cacheWrite: 1.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "anthropic/claude-opus-4": {
            id: "anthropic/claude-opus-4",
            name: "Claude Opus 4",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "anthropic/claude-opus-4.1": {
            id: "anthropic/claude-opus-4.1",
            name: "Claude Opus 4.1",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 75,
                cacheRead: 1.5,
                cacheWrite: 18.75,
            },
            contextWindow: 200000,
            maxTokens: 32000,
        },
        "anthropic/claude-opus-4.5": {
            id: "anthropic/claude-opus-4.5",
            name: "Claude Opus 4.5",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 200000,
            maxTokens: 64000,
        },
        "anthropic/claude-opus-4.6": {
            id: "anthropic/claude-opus-4.6",
            name: "Claude Opus 4.6",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0.5,
                cacheWrite: 6.25,
            },
            contextWindow: 1000000,
            maxTokens: 128000,
        },
        "anthropic/claude-sonnet-4": {
            id: "anthropic/claude-sonnet-4",
            name: "Claude Sonnet 4",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 1000000,
            maxTokens: 64000,
        },
        "anthropic/claude-sonnet-4.5": {
            id: "anthropic/claude-sonnet-4.5",
            name: "Claude Sonnet 4.5",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.3,
                cacheWrite: 3.75,
            },
            contextWindow: 1000000,
            maxTokens: 64000,
        },
        "arcee-ai/trinity-large-preview": {
            id: "arcee-ai/trinity-large-preview",
            name: "Trinity Large Preview",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131000,
            maxTokens: 131000,
        },
        "bytedance/seed-1.6": {
            id: "bytedance/seed-1.6",
            name: "Seed 1.6",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 32000,
        },
        "cohere/command-a": {
            id: "cohere/command-a",
            name: "Command A",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 8000,
        },
        "deepseek/deepseek-v3": {
            id: "deepseek/deepseek-v3",
            name: "DeepSeek V3 0324",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.77,
                output: 0.77,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 16384,
        },
        "deepseek/deepseek-v3.1": {
            id: "deepseek/deepseek-v3.1",
            name: "DeepSeek-V3.1",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 128000,
        },
        "deepseek/deepseek-v3.1-terminus": {
            id: "deepseek/deepseek-v3.1-terminus",
            name: "DeepSeek V3.1 Terminus",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.27,
                output: 1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 65536,
        },
        "deepseek/deepseek-v3.2-exp": {
            id: "deepseek/deepseek-v3.2-exp",
            name: "DeepSeek V3.2 Exp",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.27,
                output: 0.39999999999999997,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 163840,
            maxTokens: 163840,
        },
        "deepseek/deepseek-v3.2-thinking": {
            id: "deepseek/deepseek-v3.2-thinking",
            name: "DeepSeek V3.2 Thinking",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.28,
                output: 0.42,
                cacheRead: 0.028,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
        "google/gemini-2.5-flash": {
            id: "google/gemini-2.5-flash",
            name: "Gemini 2.5 Flash",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 2.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 65536,
        },
        "google/gemini-2.5-flash-lite": {
            id: "google/gemini-2.5-flash-lite",
            name: "Gemini 2.5 Flash Lite",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.09999999999999999,
                output: 0.39999999999999997,
                cacheRead: 0.01,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "google/gemini-2.5-flash-lite-preview-09-2025": {
            id: "google/gemini-2.5-flash-lite-preview-09-2025",
            name: "Gemini 2.5 Flash Lite Preview 09-2025",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.09999999999999999,
                output: 0.39999999999999997,
                cacheRead: 0.01,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "google/gemini-2.5-flash-preview-09-2025": {
            id: "google/gemini-2.5-flash-preview-09-2025",
            name: "Gemini 2.5 Flash Preview 09-2025",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 2.5,
                cacheRead: 0.03,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 65536,
        },
        "google/gemini-2.5-pro": {
            id: "google/gemini-2.5-pro",
            name: "Gemini 2.5 Pro",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 1048576,
            maxTokens: 65536,
        },
        "google/gemini-3-flash": {
            id: "google/gemini-3-flash",
            name: "Gemini 3 Flash",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 3,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 64000,
        },
        "google/gemini-3-pro-preview": {
            id: "google/gemini-3-pro-preview",
            name: "Gemini 3 Pro Preview",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 12,
                cacheRead: 0.19999999999999998,
                cacheWrite: 0,
            },
            contextWindow: 1000000,
            maxTokens: 64000,
        },
        "inception/mercury-coder-small": {
            id: "inception/mercury-coder-small",
            name: "Mercury Coder Small Beta",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.25,
                output: 1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32000,
            maxTokens: 16384,
        },
        "meituan/longcat-flash-chat": {
            id: "meituan/longcat-flash-chat",
            name: "LongCat Flash Chat",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 8192,
        },
        "meituan/longcat-flash-thinking": {
            id: "meituan/longcat-flash-thinking",
            name: "LongCat Flash Thinking",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.15,
                output: 1.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 8192,
        },
        "meta/llama-3.1-70b": {
            id: "meta/llama-3.1-70b",
            name: "Llama 3.1 70B Instruct",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.39999999999999997,
                output: 0.39999999999999997,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
        "meta/llama-3.1-8b": {
            id: "meta/llama-3.1-8b",
            name: "Llama 3.1 8B Instruct",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.03,
                output: 0.049999999999999996,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
        "meta/llama-3.2-11b": {
            id: "meta/llama-3.2-11b",
            name: "Llama 3.2 11B Vision Instruct",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.16,
                output: 0.16,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 8192,
        },
        "meta/llama-3.2-90b": {
            id: "meta/llama-3.2-90b",
            name: "Llama 3.2 90B Vision Instruct",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.72,
                output: 0.72,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 8192,
        },
        "meta/llama-3.3-70b": {
            id: "meta/llama-3.3-70b",
            name: "Llama 3.3 70B Instruct",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.72,
                output: 0.72,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 8192,
        },
        "meta/llama-4-maverick": {
            id: "meta/llama-4-maverick",
            name: "Llama 4 Maverick 17B Instruct",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "meta/llama-4-scout": {
            id: "meta/llama-4-scout",
            name: "Llama 4 Scout 17B Instruct",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.08,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "minimax/minimax-m2": {
            id: "minimax/minimax-m2",
            name: "MiniMax M2",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 1.2,
                cacheRead: 0.03,
                cacheWrite: 0.375,
            },
            contextWindow: 205000,
            maxTokens: 205000,
        },
        "minimax/minimax-m2.1": {
            id: "minimax/minimax-m2.1",
            name: "MiniMax M2.1",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.28,
                output: 1.2,
                cacheRead: 0.14,
                cacheWrite: 0,
            },
            contextWindow: 196608,
            maxTokens: 196608,
        },
        "minimax/minimax-m2.1-lightning": {
            id: "minimax/minimax-m2.1-lightning",
            name: "MiniMax M2.1 Lightning",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 2.4,
                cacheRead: 0.03,
                cacheWrite: 0.375,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "mistral/codestral": {
            id: "mistral/codestral",
            name: "Mistral Codestral",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 0.8999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4000,
        },
        "mistral/devstral-2": {
            id: "mistral/devstral-2",
            name: "Devstral 2",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 256000,
        },
        "mistral/devstral-small": {
            id: "mistral/devstral-small",
            name: "Devstral Small 1.1",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
        "mistral/devstral-small-2": {
            id: "mistral/devstral-small-2",
            name: "Devstral Small 2",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 256000,
        },
        "mistral/ministral-3b": {
            id: "mistral/ministral-3b",
            name: "Ministral 3B",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.04,
                output: 0.04,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4000,
        },
        "mistral/ministral-8b": {
            id: "mistral/ministral-8b",
            name: "Ministral 8B",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.09999999999999999,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4000,
        },
        "mistral/mistral-medium": {
            id: "mistral/mistral-medium",
            name: "Mistral Medium 3.1",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.39999999999999997,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 64000,
        },
        "mistral/mistral-small": {
            id: "mistral/mistral-small",
            name: "Mistral Small",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.09999999999999999,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32000,
            maxTokens: 4000,
        },
        "mistral/pixtral-12b": {
            id: "mistral/pixtral-12b",
            name: "Pixtral 12B 2409",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4000,
        },
        "mistral/pixtral-large": {
            id: "mistral/pixtral-large",
            name: "Pixtral Large",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4000,
        },
        "moonshotai/kimi-k2": {
            id: "moonshotai/kimi-k2",
            name: "Kimi K2",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.5,
                output: 2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 16384,
        },
        "moonshotai/kimi-k2-thinking": {
            id: "moonshotai/kimi-k2-thinking",
            name: "Kimi K2 Thinking",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.47,
                output: 2,
                cacheRead: 0.14100000000000001,
                cacheWrite: 0,
            },
            contextWindow: 216144,
            maxTokens: 216144,
        },
        "moonshotai/kimi-k2-thinking-turbo": {
            id: "moonshotai/kimi-k2-thinking-turbo",
            name: "Kimi K2 Thinking Turbo",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 1.15,
                output: 8,
                cacheRead: 0.15,
                cacheWrite: 0,
            },
            contextWindow: 262114,
            maxTokens: 262114,
        },
        "moonshotai/kimi-k2-turbo": {
            id: "moonshotai/kimi-k2-turbo",
            name: "Kimi K2 Turbo",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2.4,
                output: 10,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 16384,
        },
        "moonshotai/kimi-k2.5": {
            id: "moonshotai/kimi-k2.5",
            name: "Kimi K2.5",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.5,
                output: 2.8,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 256000,
        },
        "nvidia/nemotron-nano-12b-v2-vl": {
            id: "nvidia/nemotron-nano-12b-v2-vl",
            name: "Nvidia Nemotron Nano 12B V2 VL",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.19999999999999998,
                output: 0.6,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "nvidia/nemotron-nano-9b-v2": {
            id: "nvidia/nemotron-nano-9b-v2",
            name: "Nvidia Nemotron Nano 9B V2",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.04,
                output: 0.16,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "openai/codex-mini": {
            id: "openai/codex-mini",
            name: "Codex Mini",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.5,
                output: 6,
                cacheRead: 0.375,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/gpt-4-turbo": {
            id: "openai/gpt-4-turbo",
            name: "GPT-4 Turbo",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 10,
                output: 30,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 4096,
        },
        "openai/gpt-4.1": {
            id: "openai/gpt-4.1",
            name: "GPT-4.1",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "openai/gpt-4.1-mini": {
            id: "openai/gpt-4.1-mini",
            name: "GPT-4.1 mini",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.39999999999999997,
                output: 1.5999999999999999,
                cacheRead: 0.09999999999999999,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "openai/gpt-4.1-nano": {
            id: "openai/gpt-4.1-nano",
            name: "GPT-4.1 nano",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.09999999999999999,
                output: 0.39999999999999997,
                cacheRead: 0.03,
                cacheWrite: 0,
            },
            contextWindow: 1047576,
            maxTokens: 32768,
        },
        "openai/gpt-4o": {
            id: "openai/gpt-4o",
            name: "GPT-4o",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2.5,
                output: 10,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-4o-mini": {
            id: "openai/gpt-4o-mini",
            name: "GPT-4o mini",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.15,
                output: 0.6,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-5": {
            id: "openai/gpt-5",
            name: "GPT-5",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.13,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5-chat": {
            id: "openai/gpt-5-chat",
            name: "GPT-5 Chat",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-5-codex": {
            id: "openai/gpt-5-codex",
            name: "GPT-5-Codex",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.13,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5-mini": {
            id: "openai/gpt-5-mini",
            name: "GPT-5 mini",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.03,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5-nano": {
            id: "openai/gpt-5-nano",
            name: "GPT-5 nano",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.049999999999999996,
                output: 0.39999999999999997,
                cacheRead: 0.01,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5-pro": {
            id: "openai/gpt-5-pro",
            name: "GPT-5 pro",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 120,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 272000,
        },
        "openai/gpt-5.1-codex": {
            id: "openai/gpt-5.1-codex",
            name: "GPT-5.1-Codex",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.1-codex-max": {
            id: "openai/gpt-5.1-codex-max",
            name: "GPT 5.1 Codex Max",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.125,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.1-codex-mini": {
            id: "openai/gpt-5.1-codex-mini",
            name: "GPT-5.1 Codex mini",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.25,
                output: 2,
                cacheRead: 0.024999999999999998,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.1-instant": {
            id: "openai/gpt-5.1-instant",
            name: "GPT-5.1 Instant",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.13,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-5.1-thinking": {
            id: "openai/gpt-5.1-thinking",
            name: "GPT 5.1 Thinking",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.25,
                output: 10,
                cacheRead: 0.13,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.2": {
            id: "openai/gpt-5.2",
            name: "GPT 5.2",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.18,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.2-chat": {
            id: "openai/gpt-5.2-chat",
            name: "GPT-5.2 Chat",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 16384,
        },
        "openai/gpt-5.2-codex": {
            id: "openai/gpt-5.2-codex",
            name: "GPT-5.2-Codex",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.75,
                output: 14,
                cacheRead: 0.175,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-5.2-pro": {
            id: "openai/gpt-5.2-pro",
            name: "GPT 5.2 ",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 21,
                output: 168,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 400000,
            maxTokens: 128000,
        },
        "openai/gpt-oss-120b": {
            id: "openai/gpt-oss-120b",
            name: "gpt-oss-120b",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.09999999999999999,
                output: 0.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "openai/gpt-oss-20b": {
            id: "openai/gpt-oss-20b",
            name: "gpt-oss-20b",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.07,
                output: 0.3,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 8192,
        },
        "openai/gpt-oss-safeguard-20b": {
            id: "openai/gpt-oss-safeguard-20b",
            name: "gpt-oss-safeguard-20b",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.075,
                output: 0.3,
                cacheRead: 0.037,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 65536,
        },
        "openai/o1": {
            id: "openai/o1",
            name: "o1",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 15,
                output: 60,
                cacheRead: 7.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o3": {
            id: "openai/o3",
            name: "o3",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 8,
                cacheRead: 0.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o3-deep-research": {
            id: "openai/o3-deep-research",
            name: "o3-deep-research",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 10,
                output: 40,
                cacheRead: 2.5,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o3-mini": {
            id: "openai/o3-mini",
            name: "o3-mini",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 1.1,
                output: 4.4,
                cacheRead: 0.55,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o3-pro": {
            id: "openai/o3-pro",
            name: "o3 Pro",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 20,
                output: 80,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "openai/o4-mini": {
            id: "openai/o4-mini",
            name: "o4-mini",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 1.1,
                output: 4.4,
                cacheRead: 0.275,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 100000,
        },
        "perplexity/sonar": {
            id: "perplexity/sonar",
            name: "Sonar",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 1,
                output: 1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 127000,
            maxTokens: 8000,
        },
        "perplexity/sonar-pro": {
            id: "perplexity/sonar-pro",
            name: "Sonar Pro",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 8000,
        },
        "prime-intellect/intellect-3": {
            id: "prime-intellect/intellect-3",
            name: "INTELLECT 3",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 1.1,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "vercel/v0-1.0-md": {
            id: "vercel/v0-1.0-md",
            name: "v0-1.0-md",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 32000,
        },
        "vercel/v0-1.5-md": {
            id: "vercel/v0-1.5-md",
            name: "v0-1.5-md",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 32768,
        },
        "xai/grok-2-vision": {
            id: "xai/grok-2-vision",
            name: "Grok 2 Vision",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 10,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 32768,
            maxTokens: 32768,
        },
        "xai/grok-3": {
            id: "xai/grok-3",
            name: "Grok 3 Beta",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "xai/grok-3-fast": {
            id: "xai/grok-3-fast",
            name: "Grok 3 Fast Beta",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "xai/grok-3-mini": {
            id: "xai/grok-3-mini",
            name: "Grok 3 Mini Beta",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 0.5,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "xai/grok-3-mini-fast": {
            id: "xai/grok-3-mini-fast",
            name: "Grok 3 Mini Fast Beta",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 4,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "xai/grok-4": {
            id: "xai/grok-4",
            name: "Grok 4",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 256000,
        },
        "xai/grok-4-fast-non-reasoning": {
            id: "xai/grok-4-fast-non-reasoning",
            name: "Grok 4 Fast Non-Reasoning",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 0.5,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 256000,
        },
        "xai/grok-4-fast-reasoning": {
            id: "xai/grok-4-fast-reasoning",
            name: "Grok 4 Fast Reasoning",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 0.5,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 256000,
        },
        "xai/grok-4.1-fast-non-reasoning": {
            id: "xai/grok-4.1-fast-non-reasoning",
            name: "Grok 4.1 Fast Non-Reasoning",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 0.5,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 30000,
        },
        "xai/grok-4.1-fast-reasoning": {
            id: "xai/grok-4.1-fast-reasoning",
            name: "Grok 4.1 Fast Reasoning",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 0.5,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 30000,
        },
        "xai/grok-code-fast-1": {
            id: "xai/grok-code-fast-1",
            name: "Grok Code Fast 1",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 1.5,
                cacheRead: 0.02,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 256000,
        },
        "xiaomi/mimo-v2-flash": {
            id: "xiaomi/mimo-v2-flash",
            name: "MiMo V2 Flash",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.09,
                output: 0.29,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 262144,
            maxTokens: 32000,
        },
        "zai/glm-4.5": {
            id: "zai/glm-4.5",
            name: "GLM-4.5",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 2.2,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 131072,
        },
        "zai/glm-4.5-air": {
            id: "zai/glm-4.5-air",
            name: "GLM 4.5 Air",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.19999999999999998,
                output: 1.1,
                cacheRead: 0.03,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 96000,
        },
        "zai/glm-4.5v": {
            id: "zai/glm-4.5v",
            name: "GLM 4.5V",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.6,
                output: 1.7999999999999998,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 65536,
            maxTokens: 16384,
        },
        "zai/glm-4.6": {
            id: "zai/glm-4.6",
            name: "GLM 4.6",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.44999999999999996,
                output: 1.7999999999999998,
                cacheRead: 0.11,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 96000,
        },
        "zai/glm-4.6v": {
            id: "zai/glm-4.6v",
            name: "GLM-4.6V",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 0.8999999999999999,
                cacheRead: 0.049999999999999996,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 24000,
        },
        "zai/glm-4.6v-flash": {
            id: "zai/glm-4.6v-flash",
            name: "GLM-4.6V-Flash",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 24000,
        },
        "zai/glm-4.7": {
            id: "zai/glm-4.7",
            name: "GLM 4.7",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.43,
                output: 1.75,
                cacheRead: 0.08,
                cacheWrite: 0,
            },
            contextWindow: 202752,
            maxTokens: 120000,
        },
        "zai/glm-4.7-flashx": {
            id: "zai/glm-4.7-flashx",
            name: "GLM 4.7 FlashX",
            api: "anthropic-messages",
            provider: "vercel-ai-gateway",
            baseUrl: "https://ai-gateway.vercel.sh",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.06,
                output: 0.39999999999999997,
                cacheRead: 0.01,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 128000,
        },
    },
    "xai": {
        "grok-2": {
            id: "grok-2",
            name: "Grok 2",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 10,
                cacheRead: 2,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-2-1212": {
            id: "grok-2-1212",
            name: "Grok 2 (1212)",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 10,
                cacheRead: 2,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-2-latest": {
            id: "grok-2-latest",
            name: "Grok 2 Latest",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 2,
                output: 10,
                cacheRead: 2,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-2-vision": {
            id: "grok-2-vision",
            name: "Grok 2 Vision",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 10,
                cacheRead: 2,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 4096,
        },
        "grok-2-vision-1212": {
            id: "grok-2-vision-1212",
            name: "Grok 2 Vision (1212)",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 10,
                cacheRead: 2,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 4096,
        },
        "grok-2-vision-latest": {
            id: "grok-2-vision-latest",
            name: "Grok 2 Vision Latest",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 2,
                output: 10,
                cacheRead: 2,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 4096,
        },
        "grok-3": {
            id: "grok-3",
            name: "Grok 3",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.75,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-3-fast": {
            id: "grok-3-fast",
            name: "Grok 3 Fast",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-3-fast-latest": {
            id: "grok-3-fast-latest",
            name: "Grok 3 Fast Latest",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 5,
                output: 25,
                cacheRead: 1.25,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-3-latest": {
            id: "grok-3-latest",
            name: "Grok 3 Latest",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.75,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-3-mini": {
            id: "grok-3-mini",
            name: "Grok 3 Mini",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 0.5,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-3-mini-fast": {
            id: "grok-3-mini-fast",
            name: "Grok 3 Mini Fast",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 4,
                cacheRead: 0.15,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-3-mini-fast-latest": {
            id: "grok-3-mini-fast-latest",
            name: "Grok 3 Mini Fast Latest",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 4,
                cacheRead: 0.15,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-3-mini-latest": {
            id: "grok-3-mini-latest",
            name: "Grok 3 Mini Latest",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.3,
                output: 0.5,
                cacheRead: 0.075,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 8192,
        },
        "grok-4": {
            id: "grok-4",
            name: "Grok 4",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 3,
                output: 15,
                cacheRead: 0.75,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 64000,
        },
        "grok-4-1-fast": {
            id: "grok-4-1-fast",
            name: "Grok 4.1 Fast",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.2,
                output: 0.5,
                cacheRead: 0.05,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 30000,
        },
        "grok-4-1-fast-non-reasoning": {
            id: "grok-4-1-fast-non-reasoning",
            name: "Grok 4.1 Fast (Non-Reasoning)",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.2,
                output: 0.5,
                cacheRead: 0.05,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 30000,
        },
        "grok-4-fast": {
            id: "grok-4-fast",
            name: "Grok 4 Fast",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.2,
                output: 0.5,
                cacheRead: 0.05,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 30000,
        },
        "grok-4-fast-non-reasoning": {
            id: "grok-4-fast-non-reasoning",
            name: "Grok 4 Fast (Non-Reasoning)",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 0.2,
                output: 0.5,
                cacheRead: 0.05,
                cacheWrite: 0,
            },
            contextWindow: 2000000,
            maxTokens: 30000,
        },
        "grok-beta": {
            id: "grok-beta",
            name: "Grok Beta",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text"],
            cost: {
                input: 5,
                output: 15,
                cacheRead: 5,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 4096,
        },
        "grok-code-fast-1": {
            id: "grok-code-fast-1",
            name: "Grok Code Fast 1",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.2,
                output: 1.5,
                cacheRead: 0.02,
                cacheWrite: 0,
            },
            contextWindow: 256000,
            maxTokens: 10000,
        },
        "grok-vision-beta": {
            id: "grok-vision-beta",
            name: "Grok Vision Beta",
            api: "openai-completions",
            provider: "xai",
            baseUrl: "https://api.x.ai/v1",
            reasoning: false,
            input: ["text", "image"],
            cost: {
                input: 5,
                output: 15,
                cacheRead: 5,
                cacheWrite: 0,
            },
            contextWindow: 8192,
            maxTokens: 4096,
        },
    },
    "zai": {
        "glm-4.5": {
            id: "glm-4.5",
            name: "GLM-4.5",
            api: "openai-completions",
            provider: "zai",
            baseUrl: "https://api.z.ai/api/coding/paas/v4",
            compat: { "supportsDeveloperRole": false, "thinkingFormat": "zai" },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 2.2,
                cacheRead: 0.11,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 98304,
        },
        "glm-4.5-air": {
            id: "glm-4.5-air",
            name: "GLM-4.5-Air",
            api: "openai-completions",
            provider: "zai",
            baseUrl: "https://api.z.ai/api/coding/paas/v4",
            compat: { "supportsDeveloperRole": false, "thinkingFormat": "zai" },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.2,
                output: 1.1,
                cacheRead: 0.03,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 98304,
        },
        "glm-4.5-flash": {
            id: "glm-4.5-flash",
            name: "GLM-4.5-Flash",
            api: "openai-completions",
            provider: "zai",
            baseUrl: "https://api.z.ai/api/coding/paas/v4",
            compat: { "supportsDeveloperRole": false, "thinkingFormat": "zai" },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 131072,
            maxTokens: 98304,
        },
        "glm-4.5v": {
            id: "glm-4.5v",
            name: "GLM-4.5V",
            api: "openai-completions",
            provider: "zai",
            baseUrl: "https://api.z.ai/api/coding/paas/v4",
            compat: { "supportsDeveloperRole": false, "thinkingFormat": "zai" },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.6,
                output: 1.8,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 64000,
            maxTokens: 16384,
        },
        "glm-4.6": {
            id: "glm-4.6",
            name: "GLM-4.6",
            api: "openai-completions",
            provider: "zai",
            baseUrl: "https://api.z.ai/api/coding/paas/v4",
            compat: { "supportsDeveloperRole": false, "thinkingFormat": "zai" },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 2.2,
                cacheRead: 0.11,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "glm-4.6v": {
            id: "glm-4.6v",
            name: "GLM-4.6V",
            api: "openai-completions",
            provider: "zai",
            baseUrl: "https://api.z.ai/api/coding/paas/v4",
            compat: { "supportsDeveloperRole": false, "thinkingFormat": "zai" },
            reasoning: true,
            input: ["text", "image"],
            cost: {
                input: 0.3,
                output: 0.9,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 128000,
            maxTokens: 32768,
        },
        "glm-4.7": {
            id: "glm-4.7",
            name: "GLM-4.7",
            api: "openai-completions",
            provider: "zai",
            baseUrl: "https://api.z.ai/api/coding/paas/v4",
            compat: { "supportsDeveloperRole": false, "thinkingFormat": "zai" },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0.6,
                output: 2.2,
                cacheRead: 0.11,
                cacheWrite: 0,
            },
            contextWindow: 204800,
            maxTokens: 131072,
        },
        "glm-4.7-flash": {
            id: "glm-4.7-flash",
            name: "GLM-4.7-Flash",
            api: "openai-completions",
            provider: "zai",
            baseUrl: "https://api.z.ai/api/coding/paas/v4",
            compat: { "supportsDeveloperRole": false, "thinkingFormat": "zai" },
            reasoning: true,
            input: ["text"],
            cost: {
                input: 0,
                output: 0,
                cacheRead: 0,
                cacheWrite: 0,
            },
            contextWindow: 200000,
            maxTokens: 131072,
        },
    },
};
//# sourceMappingURL=models.generated.js.map