---
summary: "CLI reference for `openclaw-cn plugins` (list, install, enable/disable, doctor)"
read_when:
  - You want to install or manage in-process Gateway plugins
  - You want to debug plugin load failures
---

# `openclaw-cn plugins`

Manage Gateway plugins/extensions (loaded in-process).

Related:
- Plugin system: [Plugins](/plugin)
- Plugin manifest + schema: [Plugin manifest](/plugins/manifest)
- Security hardening: [Security](/gateway/security)

## Commands

```bash
openclaw-cn plugins list
openclaw-cn plugins info <id>
openclaw-cn plugins enable <id>
openclaw-cn plugins disable <id>
openclaw-cn plugins doctor
openclaw-cn plugins update <id>
openclaw-cn plugins update --all
```

Bundled plugins ship with Clawdbot but start disabled. Use `plugins enable` to
activate them.

All plugins must ship a `openclaw.plugin.json` file with an inline JSON Schema
(`configSchema`, even if empty). Missing/invalid manifests or schemas prevent
the plugin from loading and fail config validation.

### Install

```bash
openclaw-cn plugins install <path-or-spec>
```

Security note: treat plugin installs like running code. Prefer pinned versions.

Supported archives: `.zip`, `.tgz`, `.tar.gz`, `.tar`.

Use `--link` to avoid copying a local directory (adds to `plugins.load.paths`):

```bash
openclaw-cn plugins install -l ./my-plugin
```

### Update

```bash
openclaw-cn plugins update <id>
openclaw-cn plugins update --all
openclaw-cn plugins update <id> --dry-run
```

Updates only apply to plugins installed from npm (tracked in `plugins.installs`).
