/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.bootstrap.command.BootstrapCommand;
import org.apache.nifi.bootstrap.command.CommandStatus;
import org.apache.nifi.bootstrap.command.process.ProcessHandleProvider;
import org.apache.nifi.bootstrap.configuration.ApplicationClassName;
import org.apache.nifi.bootstrap.configuration.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StopBootstrapCommand
implements BootstrapCommand {
    private static final Duration FORCE_TERMINATION_TIMEOUT = Duration.ofSeconds(5L);
    private static final Logger logger = LoggerFactory.getLogger((String)ApplicationClassName.BOOTSTRAP_COMMAND.getName());
    private final ProcessHandleProvider processHandleProvider;
    private final ConfigurationProvider configurationProvider;
    private CommandStatus commandStatus = CommandStatus.ERROR;

    StopBootstrapCommand(ProcessHandleProvider processHandleProvider, ConfigurationProvider configurationProvider) {
        this.processHandleProvider = Objects.requireNonNull(processHandleProvider);
        this.configurationProvider = Objects.requireNonNull(configurationProvider);
    }

    @Override
    public CommandStatus getCommandStatus() {
        return this.commandStatus;
    }

    @Override
    public void run() {
        Optional<ProcessHandle> processHandle = this.processHandleProvider.findApplicationProcessHandle();
        if (processHandle.isEmpty()) {
            this.commandStatus = CommandStatus.SUCCESS;
            logger.info("Application Process not running");
        } else {
            this.stopBootstrapProcess();
            this.destroy(processHandle.get());
        }
    }

    private void stopBootstrapProcess() {
        Optional<ProcessHandle> bootstrapProcessHandleFound = this.processHandleProvider.findBootstrapProcessHandle();
        if (bootstrapProcessHandleFound.isPresent()) {
            ProcessHandle bootstrapProcessHandle = bootstrapProcessHandleFound.get();
            boolean destroyRequested = bootstrapProcessHandle.destroy();
            long pid = bootstrapProcessHandle.pid();
            if (destroyRequested) {
                logger.info("Bootstrap Process [{}] termination requested", (Object)pid);
                this.onBootstrapDestroyCompleted(bootstrapProcessHandle);
            } else {
                logger.warn("Bootstrap Process [{}] termination request failed", (Object)pid);
            }
        }
    }

    private void onBootstrapDestroyCompleted(ProcessHandle bootstrapProcessHandle) {
        long pid = bootstrapProcessHandle.pid();
        CompletableFuture<ProcessHandle> onExitHandle = bootstrapProcessHandle.onExit();
        try {
            ProcessHandle completedProcessHandle = onExitHandle.get(FORCE_TERMINATION_TIMEOUT.toSeconds(), TimeUnit.SECONDS);
            logger.info("Bootstrap Process [{}] termination completed", (Object)completedProcessHandle.pid());
        }
        catch (Exception e) {
            logger.warn("Bootstrap Process [{}] termination failed", (Object)pid);
        }
    }

    private void destroy(ProcessHandle applicationProcessHandle) {
        boolean destroyRequested = applicationProcessHandle.destroy();
        logger.info("Application Process [{}] termination requested", (Object)applicationProcessHandle.pid());
        if (destroyRequested) {
            this.onDestroyCompleted(applicationProcessHandle);
        } else {
            logger.warn("Application Process [{}] termination request failed", (Object)applicationProcessHandle.pid());
            this.destroyForcibly(applicationProcessHandle);
        }
    }

    private void destroyForcibly(ProcessHandle applicationProcessHandle) {
        boolean destroyForciblyRequested = applicationProcessHandle.destroyForcibly();
        if (destroyForciblyRequested) {
            logger.warn("Application Process [{}] force termination failed", (Object)applicationProcessHandle.pid());
        } else {
            this.onDestroyForciblyCompleted(applicationProcessHandle);
        }
    }

    private void onDestroyCompleted(ProcessHandle applicationProcessHandle) {
        long pid = applicationProcessHandle.pid();
        CompletableFuture<ProcessHandle> onExitHandle = applicationProcessHandle.onExit();
        Duration gracefulShutdownTimeout = this.configurationProvider.getGracefulShutdownTimeout();
        try {
            ProcessHandle completedProcessHandle = onExitHandle.get(gracefulShutdownTimeout.toSeconds(), TimeUnit.SECONDS);
            logger.info("Application Process [{}] termination completed", (Object)completedProcessHandle.pid());
            this.commandStatus = CommandStatus.SUCCESS;
        }
        catch (Exception e) {
            logger.warn("Application Process [{}] termination failed", (Object)pid);
            this.destroyForcibly(applicationProcessHandle);
        }
    }

    private void onDestroyForciblyCompleted(ProcessHandle applicationProcessHandle) {
        long pid = applicationProcessHandle.pid();
        CompletableFuture<ProcessHandle> onExitHandle = applicationProcessHandle.onExit();
        try {
            ProcessHandle completedProcessHandle = onExitHandle.get(FORCE_TERMINATION_TIMEOUT.toSeconds(), TimeUnit.SECONDS);
            logger.warn("Application Process [{}] force termination completed", (Object)completedProcessHandle.pid());
            this.commandStatus = CommandStatus.SUCCESS;
        }
        catch (Exception e) {
            logger.warn("Application Process [{}] force termination request failed", (Object)pid);
            this.commandStatus = CommandStatus.ERROR;
        }
    }
}

