/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.client.async.nio;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.queue.LoadBalanceCompression;
import org.apache.nifi.controller.queue.clustered.client.async.AsyncLoadBalanceClient;
import org.apache.nifi.controller.queue.clustered.client.async.AsyncLoadBalanceClientRegistry;
import org.apache.nifi.controller.queue.clustered.client.async.TransactionCompleteCallback;
import org.apache.nifi.controller.queue.clustered.client.async.TransactionFailureCallback;
import org.apache.nifi.controller.queue.clustered.client.async.nio.NioAsyncLoadBalanceClient;
import org.apache.nifi.controller.queue.clustered.client.async.nio.NioAsyncLoadBalanceClientFactory;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioAsyncLoadBalanceClientRegistry
implements AsyncLoadBalanceClientRegistry {
    private static final Logger logger = LoggerFactory.getLogger(NioAsyncLoadBalanceClientRegistry.class);
    private final NioAsyncLoadBalanceClientFactory clientFactory;
    private final int clientsPerNode;
    private Map<NodeIdentifier, Set<AsyncLoadBalanceClient>> clientMap = new HashMap<NodeIdentifier, Set<AsyncLoadBalanceClient>>();
    private Set<AsyncLoadBalanceClient> allClients = new CopyOnWriteArraySet<AsyncLoadBalanceClient>();
    private boolean running = false;

    public NioAsyncLoadBalanceClientRegistry(NioAsyncLoadBalanceClientFactory clientFactory, int clientsPerNode) {
        this.clientFactory = clientFactory;
        this.clientsPerNode = clientsPerNode;
    }

    @Override
    public synchronized void register(String connectionId, NodeIdentifier nodeId, BooleanSupplier emptySupplier, Supplier<FlowFileRecord> flowFileSupplier, TransactionFailureCallback failureCallback, TransactionCompleteCallback successCallback, Supplier<LoadBalanceCompression> compressionSupplier, BooleanSupplier honorBackpressureSupplier) {
        Set<AsyncLoadBalanceClient> clients = this.clientMap.get(nodeId);
        if (clients == null) {
            clients = this.registerClients(nodeId);
        }
        clients.forEach(client -> client.register(connectionId, emptySupplier, flowFileSupplier, failureCallback, successCallback, compressionSupplier, honorBackpressureSupplier));
        logger.debug("Registered Connection with ID {} to send to Node {}", (Object)connectionId, (Object)nodeId);
    }

    @Override
    public synchronized void unregister(String connectionId, NodeIdentifier nodeId) {
        Set<AsyncLoadBalanceClient> clients = this.clientMap.get(nodeId);
        if (clients == null) {
            return;
        }
        HashSet<AsyncLoadBalanceClient> toRemove = new HashSet<AsyncLoadBalanceClient>();
        for (AsyncLoadBalanceClient client : clients) {
            client.unregister(connectionId);
            if (client.getRegisteredConnectionCount() != 0) continue;
            toRemove.add(client);
        }
        clients.removeAll(toRemove);
        this.allClients.removeAll(toRemove);
        if (clients.isEmpty()) {
            this.clientMap.remove(nodeId);
        }
        logger.debug("Un-registered Connection with ID {} so that it will no longer send data to Node {}; {} clients were removed", new Object[]{connectionId, nodeId, toRemove.size()});
    }

    private Set<AsyncLoadBalanceClient> registerClients(NodeIdentifier nodeId) {
        HashSet<AsyncLoadBalanceClient> clients = new HashSet<AsyncLoadBalanceClient>();
        for (int i = 0; i < this.clientsPerNode; ++i) {
            NioAsyncLoadBalanceClient client = this.clientFactory.createClient(nodeId);
            clients.add(client);
            logger.debug("Added client {} for communicating with Node {}", (Object)client, (Object)nodeId);
        }
        this.clientMap.put(nodeId, clients);
        this.allClients.addAll(clients);
        if (this.running) {
            clients.forEach(AsyncLoadBalanceClient::start);
        }
        return clients;
    }

    public synchronized Set<AsyncLoadBalanceClient> getAllClients() {
        return this.allClients;
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.allClients.forEach(AsyncLoadBalanceClient::start);
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.allClients.forEach(AsyncLoadBalanceClient::stop);
    }
}

