/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.zkmigrator;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.toolkit.zkmigrator.ZooKeeperMigrator;
import org.apache.zookeeper.KeeperException;

public class ZooKeeperMigratorMain {
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String NIFI_TOOLKIT_HOME = "NIFI_TOOLKIT_HOME";
    private static final String HEADER = System.lineSeparator() + "A tool for importing and exporting data from ZooKeeper." + System.lineSeparator() + System.lineSeparator();
    private static final String FOOTER = System.lineSeparator() + "Java home: " + System.getenv("JAVA_HOME") + System.lineSeparator() + "NiFi Toolkit home: " + System.getenv("NIFI_TOOLKIT_HOME");
    private static final Option OPTION_ZK_MIGRATOR_HELP = Option.builder((String)"h").longOpt("help").desc("display help/usage info").build();
    private static final Option OPTION_ZK_ENDPOINT = Option.builder((String)"z").longOpt("zookeeper").desc("ZooKeeper endpoint string (ex. host:port/path)").hasArg().argName("zookeeper-endpoint").required().build();
    private static final Option OPTION_RECEIVE = Option.builder((String)"r").longOpt("receive").desc("receives data from zookeeper and writes to the given filename or standard output").build();
    private static final Option OPTION_SEND = Option.builder((String)"s").longOpt("send").desc("sends data to zookeeper read from the given filename or standard input").build();
    private static final Option OPTION_ZK_AUTH_INFO = Option.builder((String)"a").longOpt("auth").desc("username and password for the given ZooKeeper path").hasArg().argName("username:password").build();
    private static final Option OPTION_ZK_KRB_CONF_FILE = Option.builder((String)"k").longOpt("krb-conf").desc("JAAS file containing Kerberos config").hasArg().argName("jaas-filename").numberOfArgs(1).build();
    private static final Option OPTION_FILE = Option.builder((String)"f").longOpt("file").desc("file to be used for ZooKeeper data").hasArg().argName("filename").build();
    private static final Option OPTION_IGNORE_SOURCE = Option.builder().longOpt("ignore-source").desc("ignores the source ZooKeeper endpoint specified in the exported data").build();
    private static final Option OPTION_USE_EXISTING_ACL = Option.builder().longOpt("use-existing-acl").desc("allow write of existing acl data to destination").build();

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(OPTION_ZK_MIGRATOR_HELP);
        options.addOption(OPTION_ZK_ENDPOINT);
        options.addOption(OPTION_ZK_AUTH_INFO);
        options.addOption(OPTION_FILE);
        options.addOption(OPTION_IGNORE_SOURCE);
        options.addOption(OPTION_USE_EXISTING_ACL);
        OptionGroup optionGroupAuth = new OptionGroup().addOption(OPTION_ZK_AUTH_INFO).addOption(OPTION_ZK_KRB_CONF_FILE);
        optionGroupAuth.setRequired(false);
        options.addOptionGroup(optionGroupAuth);
        OptionGroup optionGroupReadWrite = new OptionGroup().addOption(OPTION_RECEIVE).addOption(OPTION_SEND);
        optionGroupReadWrite.setRequired(true);
        options.addOptionGroup(optionGroupReadWrite);
        return options;
    }

    private static void printUsage(String errorMessage, Options options) {
        Preconditions.checkNotNull((Object)options, (Object)"command line options were not specified");
        if (errorMessage != null) {
            System.out.println(errorMessage + System.lineSeparator());
        }
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(160);
        helpFormatter.setDescPadding(0);
        helpFormatter.printHelp(ZooKeeperMigratorMain.class.getCanonicalName(), HEADER, options, FOOTER, true);
    }

    public static void main(String[] args) throws IOException {
        block33: {
            PrintStream output = System.out;
            System.setOut(System.err);
            Options options = ZooKeeperMigratorMain.createOptions();
            try {
                byte[] authData;
                ZooKeeperMigrator.AuthMode authMode;
                CommandLine commandLine = new DefaultParser().parse(options, args);
                if (commandLine.hasOption(OPTION_ZK_MIGRATOR_HELP.getLongOpt())) {
                    ZooKeeperMigratorMain.printUsage(null, options);
                    break block33;
                }
                String zookeeperUri = commandLine.getOptionValue(OPTION_ZK_ENDPOINT.getOpt());
                Mode mode = commandLine.hasOption(OPTION_RECEIVE.getOpt()) ? Mode.READ : Mode.WRITE;
                String filename = commandLine.getOptionValue(OPTION_FILE.getOpt());
                String auth = commandLine.getOptionValue(OPTION_ZK_AUTH_INFO.getOpt());
                String jaasFilename = commandLine.getOptionValue(OPTION_ZK_KRB_CONF_FILE.getOpt());
                boolean ignoreSource = commandLine.hasOption(OPTION_IGNORE_SOURCE.getLongOpt());
                boolean useExistingACL = commandLine.hasOption(OPTION_USE_EXISTING_ACL.getLongOpt());
                if (auth != null) {
                    authMode = ZooKeeperMigrator.AuthMode.DIGEST;
                    authData = auth.getBytes(StandardCharsets.UTF_8);
                } else {
                    authData = null;
                    if (!Strings.isNullOrEmpty((String)jaasFilename)) {
                        authMode = ZooKeeperMigrator.AuthMode.SASL;
                        System.setProperty("java.security.auth.login.config", jaasFilename);
                    } else {
                        authMode = ZooKeeperMigrator.AuthMode.OPEN;
                    }
                }
                ZooKeeperMigrator zookeeperMigrator = new ZooKeeperMigrator(zookeeperUri);
                if (mode.equals((Object)Mode.READ)) {
                    try (OutputStream zkData = filename != null ? new FileOutputStream(Paths.get(filename, new String[0]).toFile()) : output;){
                        zookeeperMigrator.readZooKeeper(zkData, authMode, authData);
                        break block33;
                    }
                }
                try (InputStream zkData = filename != null ? new FileInputStream(Paths.get(filename, new String[0]).toFile()) : System.in;){
                    zookeeperMigrator.writeZooKeeper(zkData, authMode, authData, ignoreSource, useExistingACL);
                }
            }
            catch (ParseException e) {
                ZooKeeperMigratorMain.printUsage(e.getLocalizedMessage(), options);
            }
            catch (IOException | InterruptedException | ExecutionException | KeeperException e) {
                throw new IOException(String.format("unable to perform operation: %s", e.getLocalizedMessage()), e);
            }
        }
    }

    static enum Mode {
        READ,
        WRITE;

    }
}

