/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.StandardRepositoryStatusReport;
import org.apache.nifi.controller.repository.metrics.EventContainer;
import org.apache.nifi.controller.repository.metrics.EventSumValue;
import org.apache.nifi.controller.repository.metrics.SecondPrecisionEventContainer;

public class RingBufferEventRepository
implements FlowFileEventRepository {
    private final int numMinutes;
    private final EventSumValue aggregateValues = new EventSumValue(0L);
    private final ConcurrentMap<String, EventContainer> componentEventMap = new ConcurrentHashMap<String, EventContainer>();

    public RingBufferEventRepository(int numMinutes) {
        this.numMinutes = numMinutes;
    }

    public void close() throws IOException {
    }

    public void updateRepository(FlowFileEvent event, String componentId) {
        EventContainer eventContainer = this.componentEventMap.computeIfAbsent(componentId, id -> new SecondPrecisionEventContainer(this.numMinutes));
        eventContainer.addEvent(event);
        this.aggregateValues.add(event);
    }

    public StandardRepositoryStatusReport reportTransferEvents(long sinceEpochMillis) {
        StandardRepositoryStatusReport report = new StandardRepositoryStatusReport();
        this.componentEventMap.forEach((componentId, container) -> report.addReportEntry(container.generateReport(sinceEpochMillis), (String)componentId));
        return report;
    }

    public FlowFileEvent reportTransferEvents(String componentId, long now) {
        EventContainer container = (EventContainer)this.componentEventMap.get(componentId);
        return container == null ? null : container.generateReport(now);
    }

    public void purgeTransferEvents(String componentIdentifier) {
        this.componentEventMap.remove(componentIdentifier);
    }

    public FlowFileEvent reportAggregateEvent() {
        return this.aggregateValues.toFlowFileEvent();
    }
}

