/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Os;
import io.questdb.std.Sinkable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;

public class CairoException
extends RuntimeException
implements Sinkable,
FlyweightMessageContainer {
    public static final int ERRNO_FILE_DOES_NOT_EXIST = 2;
    public static final int ERRNO_FILE_DOES_NOT_EXIST_WIN = 3;
    public static final int ILLEGAL_OPERATION = -101;
    public static final int METADATA_VALIDATION = -100;
    public static final int NON_CRITICAL = -1;
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final int ERRNO_ACCESS_DENIED_WIN = 5;
    private static final ThreadLocal<CairoException> tlException = new ThreadLocal<CairoException>(CairoException::new);
    protected final StringSink message = new StringSink();
    protected int errno;
    private boolean cacheable;
    private boolean interruption;
    private int messagePosition;

    public static CairoException critical(int errno) {
        CairoException ex = tlException.get();
        assert ((ex = new CairoException()) != null);
        ex.message.clear();
        ex.errno = errno;
        ex.cacheable = false;
        ex.interruption = false;
        return ex;
    }

    public static CairoException detachedColumnMetadataMismatch(int columnIndex, CharSequence columnName, CharSequence attribute) {
        return CairoException.critical(-100).put("Detached column [index=").put(columnIndex).put(", name=").put(columnName).put(", attribute=").put(attribute).put("] does not match current table metadata");
    }

    public static CairoException detachedMetadataMismatch(CharSequence attribute) {
        return CairoException.critical(-100).put("Detached partition metadata [").put(attribute).put("] is not compatible with current table metadata");
    }

    public static CairoException duplicateColumn(CharSequence columnName, CharSequence columnAlias) {
        CairoException exception = CairoException.invalidMetadata("Duplicate column", columnName);
        if (columnAlias != null) {
            exception.put(", [alias=").put(columnAlias).put(']');
        }
        return exception;
    }

    public static CairoException duplicateColumn(CharSequence columnName) {
        return CairoException.duplicateColumn(columnName, null);
    }

    public static boolean errnoReadPathDoesNotExist(int errno) {
        return CairoException.errnoRemovePathDoesNotExist(errno) || Os.type == 3 && errno == 5;
    }

    public static boolean errnoRemovePathDoesNotExist(int errno) {
        return errno == 2 || Os.type == 3 && errno == 3;
    }

    public static CairoException invalidMetadata(@NotNull CharSequence msg, @NotNull CharSequence columnName) {
        return CairoException.critical(-100).put(msg).put(" [name=").put(columnName).put(']');
    }

    public static CairoException nonCritical() {
        return CairoException.critical(-1);
    }

    public static CairoException tableDoesNotExist(CharSequence tableName) {
        return CairoException.nonCritical().put("table does not exist [table=").put(tableName).put(']');
    }

    public boolean errnoReadPathDoesNotExist() {
        return CairoException.errnoReadPathDoesNotExist(this.errno);
    }

    public int getErrno() {
        return this.errno;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return "[" + this.errno + "] " + this.message;
    }

    @Override
    public int getPosition() {
        return this.messagePosition;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] result = EMPTY_STACK_TRACE;
        assert ((result = super.getStackTrace()) != null);
        return result;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public boolean isCritical() {
        return this.errno != -1;
    }

    public boolean isInterruption() {
        return this.interruption;
    }

    public boolean isWALTolerable() {
        return !this.isCritical() || this.errno == -100;
    }

    public CairoException position(int position) {
        this.messagePosition = position;
        return this;
    }

    public CairoException put(long value) {
        this.message.put(value);
        return this;
    }

    public CairoException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public CairoException put(Sinkable sinkable) {
        sinkable.toSink(this.message);
        return this;
    }

    public CairoException put(char c) {
        this.message.put(c);
        return this;
    }

    public CairoException putAsPrintable(CharSequence nonPrintable) {
        this.message.putAsPrintable(nonPrintable);
        return this;
    }

    public CairoException setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public CairoException setInterruption(boolean interruption) {
        this.interruption = interruption;
        return this;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[').put(this.errno).put("]: ").put(this.message);
    }

    public CairoException ts(long timestamp) {
        TimestampFormatUtils.appendDateTime(this.message, timestamp);
        return this;
    }
}

