/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.LogAlertSocket;
import io.questdb.log.LogRecordSink;
import io.questdb.std.Chars;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;

public class HttpLogRecordSink
extends LogRecordSink {
    static final String CRLF = "\r\n";
    private static final String CL_MARKER = "#########";
    private static final int CL_MARKER_LEN = "#########".length();
    private static final int MARK_NOT_SET = -1;
    private long bodyStart;
    private long contentLengthEnd = this._wptr;
    private boolean hasContentLengthMarker;
    private long mark = -1L;

    public HttpLogRecordSink(LogAlertSocket alertSkt) {
        this(alertSkt.getOutBufferPtr(), alertSkt.getOutBufferSize());
    }

    public HttpLogRecordSink(long address, long addressSize) {
        super(address, addressSize);
        this.bodyStart = this._wptr;
    }

    public int $() {
        if (this.hasContentLengthMarker) {
            int bodyLen = (int)(this._wptr - this.bodyStart);
            long p = this.contentLengthEnd;
            if (bodyLen == 0) {
                Unsafe.getUnsafe().putByte(p--, (byte)48);
            } else {
                int rem = bodyLen % 10;
                while (bodyLen > 0) {
                    Unsafe.getUnsafe().putByte(p--, (byte)(48 + rem));
                    rem = (bodyLen /= 10) % 10;
                }
            }
            int lpadLen = (int)((long)CL_MARKER_LEN - this.contentLengthEnd + p);
            for (int lpad = 0; lpad < lpadLen; ++lpad) {
                Unsafe.getUnsafe().putByte(p--, (byte)32);
            }
        }
        return this.length();
    }

    @Override
    public void clear() {
        super.clear();
        this.mark = -1L;
        this.contentLengthEnd = this._wptr;
        this.bodyStart = this._wptr;
        this.hasContentLengthMarker = false;
    }

    @Override
    public HttpLogRecordSink encodeUtf8(CharSequence cs) {
        super.encodeUtf8(cs);
        return this;
    }

    public long getMark() {
        return this.mark;
    }

    public HttpLogRecordSink put(LogRecordSink logRecord) {
        long address;
        int len = logRecord.length();
        long limit = address + (long)len;
        block6: for (long p = address = logRecord.getAddress(); p < limit; ++p) {
            byte c = Unsafe.getUnsafe().getByte(p);
            switch (c) {
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    continue block6;
                }
                case 9: {
                    this.put(' ');
                    continue block6;
                }
                case 36: {
                    this.put("\\$");
                    continue block6;
                }
                case 34: {
                    this.put("\\\"");
                    continue block6;
                }
                default: {
                    this.put((char)c);
                }
            }
        }
        return this;
    }

    @Override
    public HttpLogRecordSink put(CharSequence cs) {
        super.put(cs);
        return this;
    }

    @Override
    public HttpLogRecordSink put(CharSequence cs, int lo, int hi) {
        super.put(cs, lo, hi);
        return this;
    }

    @Override
    public HttpLogRecordSink put(Sinkable sinkable) {
        super.put(sinkable);
        return this;
    }

    @Override
    public HttpLogRecordSink put(char c) {
        super.put(c);
        return this;
    }

    public HttpLogRecordSink putHeader(CharSequence localHostIp) {
        this.clear();
        this.put("POST /api/v1/alerts HTTP/1.1").put(CRLF).put("Host: ").put(localHostIp).put(CRLF).put("User-Agent: QuestDB/LogAlert").put(CRLF).put("Accept: */*").put(CRLF).put("Content-Type: application/json").put(CRLF).putContentLengthMarker();
        this.put(CRLF);
        this.bodyStart = this._wptr;
        return this;
    }

    public HttpLogRecordSink rewindToMark() {
        this._wptr = this.mark == -1L ? this.address : this.mark;
        return this;
    }

    public HttpLogRecordSink setMark() {
        this.mark = this._wptr;
        return this;
    }

    public String toString() {
        return Chars.stringFromUtf8Bytes(this.address, this._wptr);
    }

    void putContentLengthMarker() {
        this.put("Content-Length:").put(CL_MARKER);
        this.contentLengthEnd = this._wptr - 1L;
        this.put(CRLF);
        this.hasContentLengthMarker = true;
    }
}

