/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.wali;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public interface SnapshotRecovery<T> {
    public long getMaxTransactionId();

    public Map<Object, T> getRecords();

    public Set<String> getRecoveredSwapLocations();

    public File getRecoveryFile();

    public static <T> SnapshotRecovery<T> emptyRecovery() {
        return new SnapshotRecovery<T>(){

            @Override
            public long getMaxTransactionId() {
                return -1L;
            }

            @Override
            public Map<Object, T> getRecords() {
                return Collections.emptyMap();
            }

            @Override
            public Set<String> getRecoveredSwapLocations() {
                return Collections.emptySet();
            }

            @Override
            public File getRecoveryFile() {
                return null;
            }
        };
    }
}

