# Contributing to `nvim-web-devicons`

Thank you for your contribution!

## Prerequisites

Code is formatted using *stylua* and linted using *luacheck*.

You can install these with:

```sh
cargo install stylua
luarocks install luacheck
```

or via your OS package manager e.g. *Arch Linux*:

```sh
pacman -S stylua luacheck
```

## Adding icons

Add or update icons in `lua/nvim-web-devicons/default/` directory

There are five files where icons can be added:

1. `icons_by_filename.lua`
2. `icons_by_file_extension.lua`
3. `icons_by_operating_system.lua`
4. `icons_by_desktop_environment.lua`
5. `icons_by_window_manager.lua`

Add the icon to table in file **1.** if the icon is for a file that is always named that way, for example `.gitconfig`.
Add the icon to table in file **2.** if the icon is for all files with an extension, for example `vim`.
Add the icon to table in files **3.**, **4.** and **5.** if the icon is from an OS, DE or WM.

Each icon must have the following structure (this is an example):

```lua
[".gitconfig"] = { icon = "", color = "#41535b", cterm_color = "0", name = "GitConfig" },
```

> [!IMPORTANT]
> Make sure each icon association occupies exactly one line.

***All of the following keys are required:***

- `icon` glyph
- `color` must contain a color in the html notation
- `cterm_color` must contain a number (any number)
  - the correct value for `cterm_color` will be generated by the script in next step
- `name` must only contain alphanumeric characters (don't use `/`, `-`, `_`)

## Building

Note: Ensure your current working directory is the repo root.

### Generate

Following your changes, please run:

```sh
make
```

This will:

1. Install required plugins: [vim-colortemplate](https://github.com/lifepillar/vim-colortemplate.git) and [mini.align](https://github.com/echasnovski/mini.align) if necessary
2. Generate cterm colors
3. Generate light color variants
4. Check style
5. Lint
6. Find missing filetypes

You can automatically fix any style issues via:

```sh
make style-fix
```

Please commit all files from `lua/nvim-web-devicons/default/`, `lua/nvim-web-devicons/light/` end `lua/nvim-web-devicons/filetypes.lua`

### Validate

After committing, please run:

```sh
make colors-check
```

This is run in CI and ensures that generation was correct by re-running it and validating that no changes were made.

## Test

Run `:NvimWebDeviconsHiTest` to view the icons and their highlighting.

Start *Neovim* with `TERM=xterm-256color nvim ...` to test cterm.

Check with `&background` `dark` and `light`

## Documentation

When modifying or adding API, please update [Usage](README.md#Usage)

## Pull Request

Please reference any issues in the description e.g. "resolves #1234", which will be closed upon merge.

Please check "allow edits by maintainers" to allow *nvim-web-devicons* maintainers to make small changes such as documentation tweaks.

## Subject

The merge commit message will be the subject of the PR.

A [Conventional Commits] subject will be validated by the Semantic Pull Request Subject CI job.
Reference the issue to be used in the release notes e.g.

```txt
feat: add gradle icons
fix: update rust icon
feat(#192): :NvimWebDeviconsHiTest
```

Available types:

- feat: A new feature
- fix: A bug fix
- docs: Documentation only changes
- style: Changes that do not affect the meaning of the code (white-space, formatting, missing semi-colons, etc)
- refactor: A code change that neither fixes a bug nor adds a feature
- perf: A code change that improves performance
- test: Adding missing tests or correcting existing tests
- build: Changes that affect the build system or external dependencies (example scopes: gulp, broccoli, npm)
- ci: Changes to our CI configuration files and scripts (example scopes: Travis, Circle, BrowserStack, SauceLabs)
- chore: Other changes that don't modify src or test files
- revert: Reverts a previous commit

If in doubt, look at previous commits.

See also [The Conventional Commits ultimate cheatsheet](https://gist.github.com/gabrielecanepa/fa6cca1a8ae96f77896fe70ddee65527)

## Browser Font

It is useful to see the actual glyphs in the pull request. That can be done by setting the browser font to your nerd font.

Using firefox:

- Settings -> General
- Fonts -> Advanced
- Change Monospace to "Hack Nerd Font Mono" or similar
- Uncheck "Allow pages to choose their own fonts, instead of your selections above"

[Conventional Commits]: <https://www.conventionalcommits.org/en/v1.0.0>
